(defproject dignati/om-charts "0.0.1"
  :description "Charts for Om"
  :url "http://github.com/dignati/om-charts"
  :license {:name "MIT License"
            :url "http://www.opensource.org/licenses/mit-license.php"
            :distribution :repo}
  :scm {:name "git"
        :url "https://github.com/dignati/om-charts"}
  :dependencies [[org.clojure/clojure "1.7.0-alpha2"]
                 [org.clojure/clojurescript "0.0-2913"]
                 [org.omcljs/om "0.8.8" :scope "provided"]
                 [prismatic/om-tools "0.3.10" :exclusions [om]]]
  :plugins [[lein-cljsbuild "1.0.4"]
            [lein-figwheel "0.2.5-SNAPSHOT"]]
  :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
  :profiles {:dev {:dependencies [[com.cemerick/piggieback "0.1.5"]
                                  [org.clojure/core.async "0.1.346.0-17112a-alpha"]
                                  [weasel "0.6.0"]
                                  [figwheel "0.2.5-SNAPSHOT"]
                                  [precursor/om-i "0.1.3"]]}}
  :cljsbuild {:builds [{:id "dev"
                        :source-paths ["src/" "dev/"]
                        :compiler {:main om-charts.dev.init
                                   :output-to "dev-resources/public/js/om-charts.js"
                                   :output-dir "dev-resources/public/js/out/"
                                   :optimizations :none
                                   :cache-analysis true
                                   :source-map true
                                   :asset-path "js/out"}}]}
  :figwheel {:http-server-root "public"
             :css-dirs ["dev-resources/public/css"]}
  :signing {:gpg-key "85D17920"}
  :lein-release {:deploy-via :clojars})
