/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import clojure.lang.IFn;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.internals.QuietStreamsConfig;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class CapturingStreamTask
extends StreamTask {
    private final StreamTask delegate;
    private final IFn capture;

    private static StreamsConfig dumbConfig() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("application.id", "");
        hashMap.put("bootstrap.servers", "");
        return new QuietStreamsConfig(hashMap);
    }

    public CapturingStreamTask(StreamTask streamTask, IFn iFn) {
        super(streamTask.id(), (Collection)streamTask.partitions(), streamTask.topology(), null, null, CapturingStreamTask.dumbConfig(), new StreamsMetricsImpl(new Metrics(Time.SYSTEM), ""), new StateDirectory(CapturingStreamTask.dumbConfig(), Time.SYSTEM, false), null, null, new StreamTask.ProducerSupplier(){

            public Producer<byte[], byte[]> get() {
                return null;
            }
        }, null);
        this.delegate = streamTask;
        this.capture = iFn;
    }

    public boolean initializeStateStores() {
        return this.delegate.initializeStateStores();
    }

    public void initializeTopology() {
        this.delegate.initializeTopology();
    }

    public void resume() {
        this.delegate.resume();
    }

    public boolean process() {
        return this.delegate.process();
    }

    public void punctuate(ProcessorNode processorNode, long l, PunctuationType punctuationType, Punctuator punctuator) {
        this.delegate.punctuate(processorNode, l, punctuationType, punctuator);
    }

    public void commit() {
        this.delegate.commit();
    }

    public void suspend() {
        this.delegate.suspend();
    }

    public void close(boolean bl, boolean bl2) {
        this.delegate.close(bl, bl2);
    }

    public void addRecords(TopicPartition topicPartition, Iterable<ConsumerRecord<byte[], byte[]>> iterable) {
        for (ConsumerRecord<byte[], byte[]> consumerRecord : iterable) {
            this.capture.invoke((Object)this.delegate, (Object)topicPartition, consumerRecord);
        }
    }

    public Cancellable schedule(long l, PunctuationType punctuationType, Punctuator punctuator) {
        return this.delegate.schedule(l, punctuationType, punctuator);
    }

    public boolean maybePunctuateStreamTime() {
        return this.delegate.maybePunctuateStreamTime();
    }

    public boolean maybePunctuateSystemTime() {
        return this.delegate.maybePunctuateSystemTime();
    }

    public TaskId id() {
        return this.delegate.id();
    }

    public String applicationId() {
        return this.delegate.applicationId();
    }

    public Set<TopicPartition> partitions() {
        return this.delegate.partitions();
    }

    public ProcessorTopology topology() {
        return this.delegate.topology();
    }

    public ProcessorContext context() {
        return this.delegate.context();
    }

    public StateStore getStore(String string) {
        return this.delegate.getStore(string);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean isEosEnabled() {
        return this.delegate.isEosEnabled();
    }

    public String toString(String string) {
        return this.delegate.toString(string);
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    protected Map<TopicPartition, Long> activeTaskCheckpointableOffsets() {
        return this.delegate.activeTaskCheckpointableOffsets();
    }

    public void flushState() {
        this.delegate.flushState();
    }

    public void closeSuspended(boolean bl, boolean bl2, RuntimeException runtimeException) {
        this.delegate.closeSuspended(bl, bl2, runtimeException);
    }

    public void updateOffsetLimits() {
        this.delegate.updateOffsetLimits();
    }

    public boolean commitNeeded() {
        return this.delegate.commitNeeded();
    }

    public boolean hasStateStores() {
        return this.delegate.hasStateStores();
    }

    public Collection<TopicPartition> changelogPartitions() {
        return this.delegate.changelogPartitions();
    }
}

