/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import clojure.lang.IFn;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class CapturingStreamTask
extends StreamTask {
    private final StreamTask delegate;
    private final IFn capture;

    private static StreamsConfig dumbConfig() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("application.id", "");
        hashMap.put("bootstrap.servers", "");
        return new ClientUtils.QuietStreamsConfig(hashMap);
    }

    private static StreamsMetricsImpl dumbMetrics(Time time) {
        return new StreamsMetricsImpl(new Metrics(time), "", "", time);
    }

    public CapturingStreamTask(StreamTask streamTask, IFn iFn, IFn iFn2) {
        super(streamTask.id(), streamTask.inputPartitions(), streamTask.topology, (Consumer)iFn.invoke((Object)streamTask, (Object)"mainConsumer"), CapturingStreamTask.dumbConfig(), CapturingStreamTask.dumbMetrics((Time)iFn.invoke((Object)streamTask, (Object)"time")), streamTask.stateDirectory, null, (Time)iFn.invoke((Object)streamTask, (Object)"time"), streamTask.stateMgr, (RecordCollector)iFn.invoke((Object)streamTask, (Object)"recordCollector"), (InternalProcessorContext)new ProcessorContextImpl(streamTask.id(), CapturingStreamTask.dumbConfig(), streamTask.stateMgr, CapturingStreamTask.dumbMetrics((Time)iFn.invoke((Object)streamTask, (Object)"time")), null){

            public void transitionToActive(StreamTask streamTask, RecordCollector recordCollector, ThreadCache threadCache) {
            }
        });
        this.delegate = streamTask;
        this.capture = iFn2;
    }

    public void addRecords(TopicPartition topicPartition, Iterable<ConsumerRecord<byte[], byte[]>> iterable) {
        for (ConsumerRecord<byte[], byte[]> consumerRecord : iterable) {
            this.capture.invoke((Object)this.delegate, (Object)topicPartition, consumerRecord);
        }
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public void initializeIfNeeded() {
        this.delegate.initializeIfNeeded();
    }

    public void addPartitionsForOffsetReset(Set<TopicPartition> set) {
        this.delegate.addPartitionsForOffsetReset(set);
    }

    public void completeRestoration(java.util.function.Consumer<Set<TopicPartition>> consumer) {
        this.delegate.completeRestoration(consumer);
    }

    public void suspend() {
        this.delegate.suspend();
    }

    public void resume() {
        this.delegate.resume();
    }

    public Map<TopicPartition, OffsetAndMetadata> prepareCommit() {
        return this.delegate.prepareCommit();
    }

    public void postCommit(boolean bl) {
        this.delegate.postCommit(bl);
    }

    public void closeClean() {
        this.delegate.closeClean();
    }

    public void closeDirty() {
        this.delegate.closeDirty();
    }

    public void updateInputPartitions(Set<TopicPartition> set, Map<String, List<String>> map) {
        this.delegate.updateInputPartitions(set, map);
    }

    public void closeCleanAndRecycleState() {
        this.delegate.closeCleanAndRecycleState();
    }

    public void maybeWriteCheckpoint(boolean bl) {
        this.delegate.maybeWriteCheckpoint(bl);
    }

    public boolean isProcessable(long l) {
        return this.delegate.isProcessable(l);
    }

    public boolean process(long l) {
        return this.delegate.process(l);
    }

    public void recordProcessBatchTime(long l) {
        this.delegate.recordProcessBatchTime(l);
    }

    public void recordProcessTimeRatioAndBufferSize(long l, long l2) {
        this.delegate.recordProcessTimeRatioAndBufferSize(l, l2);
    }

    public void punctuate(ProcessorNode<?, ?, ?, ?> processorNode, long l, PunctuationType punctuationType, Punctuator punctuator) {
        this.delegate.punctuate(processorNode, l, punctuationType, punctuator);
    }

    public Map<TopicPartition, Long> purgeableOffsets() {
        return this.delegate.purgeableOffsets();
    }

    public Cancellable schedule(long l, PunctuationType punctuationType, Punctuator punctuator) {
        return this.delegate.schedule(l, punctuationType, punctuator);
    }

    public boolean maybePunctuateStreamTime() {
        return this.delegate.maybePunctuateStreamTime();
    }

    public boolean maybePunctuateSystemTime() {
        return this.delegate.maybePunctuateSystemTime();
    }

    public boolean commitRequested() {
        return this.delegate.commitRequested();
    }

    public InternalProcessorContext processorContext() {
        return this.delegate.processorContext();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String toString(String string) {
        return this.delegate.toString(string);
    }

    public boolean commitNeeded() {
        return this.delegate.commitNeeded();
    }

    public Map<TopicPartition, Long> changelogOffsets() {
        return this.delegate.changelogOffsets();
    }

    public boolean hasRecordsQueued() {
        return this.delegate.hasRecordsQueued();
    }

    public TaskId id() {
        return this.delegate.id();
    }

    public Collection<TopicPartition> changelogPartitions() {
        return this.delegate.changelogPartitions();
    }

    public void markChangelogAsCorrupted(Collection<TopicPartition> collection) {
        this.delegate.markChangelogAsCorrupted(collection);
    }

    public StateStore getStore(String string) {
        return this.delegate.getStore(string);
    }

    public void revive() {
        this.delegate.revive();
    }

    public void maybeInitTaskTimeoutOrThrow(long l, Exception exception) {
        this.delegate.maybeInitTaskTimeoutOrThrow(l, exception);
    }

    public void clearTaskTimeout() {
        this.delegate.clearTaskTimeout();
    }

    public boolean needsInitializationOrRestoration() {
        return this.delegate.needsInitializationOrRestoration();
    }
}

