# InfluxDB client for Clojure

This client library communicates with the [InfluxDB HTTP API][1] (ver 1.7) and
is very small. Still lacking a few debugging features but has the important
things for managing, reading from and writing to databases.

[1]: https://docs.influxdata.com/influxdb/v1.7/tools/api/


## Installation

Add the following dependency to your `project.clj` file:

    [dk.emcken.influxdb-client "0.1.0"]


[![Clojars Project](https://img.shields.io/clojars/v/proven.svg)](https://clojars.org/proven)


## Usage

### Connecting

Specify how the client reaches the InfluxDB API using a hash-map:

    {:url \"http://localhost:8086\"}


Or if you have authentication also provide the username and password:

    {:url \"http://localhost:8086\"
     :username \"root\"
     :password \"secret\"}


The following code examples assumes you are in the `user` namespace and have
required the library and a connection representation (`conn`):

    user > (require '[dk.emcken.influxdb-client :as client :refer [unwrap query write]])
    nil

    user > (def conn {:url "http://localhost:8086"})
    #'user/conn


### Read and manage

Now check if you can read from the database:

    user > (unwrap (query conn ::client/read "SHOW DATABASES"))
    [{"series" [{"values" [["_internal"]], "columns" ["name"], "name" "databases"}], "statement_id" 0}]```

Managing the database requires a slightly different "method"
(`::client/manage`). The following creates 2 new databases:

    user > (unwrap (query conn ::client/manage ["CREATE DATABASE mydb1" "CREATE DATABASE mydb2"]))
    [{"statement_id" 0} {"statement_id" 1}]


### Write

