# Service Detection for Clojure

A Clojure library that provides utility functions for detecting services when
running in a cloud environment.  The most well-known environment is a Kubernetes
cluster.  Services are exposed to pods using environment variables.  These
variables follow a certain naming convention.  This library allows to detect
those services and use them in your applications.

Another situation where this may be useful is in CI/CD environments, where you
need to test against dynamically started services (e.g. a database server).
Usually the CI/CD environment will expose those services using environment
variables.  In your tests, you can then read those variables to access the
service.

## Usage

First add the library to your project:

```clojure
[dn/clj-service-detect [0.1.0-SNAPSHOT]]
```

Detect any services using the environment, assuming it is passed in via
a map (e.g. using the [Yogthos Config library](https://github.com/yogthos/config)).

```clojure
(require '[dn.service-detect.core :as sd])

;; Assuming `env` contains a map of environment variables and values
(def detected (sd/env->services env))
;; => will return a map containing the service name and its properties
```

## License

Copyright © 2020 FIXME

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
