(ns dn.service-detect.utils
  "Generic utility functions")

(defn key-like
  "Finds a key in the map that matches given regex"
  [re m]
  (->> m
       (filter (comp (partial re-matches re) name first))
       (first)))

(defn find-env-vars
  "Finds all env vars that match the given regex pattern"
  [env pattern]
  (->> env
       (keys)
       (filter (comp (partial re-matches pattern) name))))
       
(defn find-env-var
  "Finds first env var that matches given pattern"
  [env pattern]
  (first (find-env-var env pattern)))


