(defproject dn/clj-service-detect "0.1.0-SNAPSHOT"
  :description "Service detection library using env vars"
  :url "https://gitlab.com/dn13/dn-tools/clj-service-detect"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojure "1.10.1"]]
  :repl-options {:init-ns dn.service-detect.core}

  :profiles {:dev {:dependencies [[midje "1.9.9"]
                                  [dn/midje-junit-formatter "0.1.1"]]
                   :plugins [[lein-midje "3.2.1"]]}}

  :aliases {"autotest" ["midje" ":autotest"]}
  
  :deploy-repositories
  [["dn-clojars" {:url "https://clojars.org/repo"
                  :username [:gpg :env/clojars_user]
                  :password [:gpg :env/clojars_pass]}]])
