(ns dn.service-detect.core
  (:require [dn.service-detect
             [gitlab :as gitlab]
             [kubernetes :as k8s]]))

(defn env->services
  "Takes the given input environment map (assuming each env var is converted into
   a kebab-cased keyword) and tries to extract exposed service information from
   them."
  [env]
  (concat (k8s/detect-k8s-services env)
          (gitlab/detect-gitlab-services env)))
