(ns env.core)

(defn strict-get-var
  "Returns the value of env var or throws if it's undefined."
  [name]
  (if-some [ret (System/getenv name)]
    ret
    (throw (ex-info (str "env var must be defined: " (pr-str name)) {}))))

(defn get-var
  "Returns the value of env var or not-found if it's undefined."
  [name not-found]
  (if-some [ret (System/getenv name)]
    ret
    not-found))

(defmacro strict-get-compile-time-var
  "Returns the value of env var or throws in runtime if it's undefined during compilation."
  [name]
  (if-some [ret (System/getenv name)]
    ret
    `(throw (ex-info (str "env var must be defined during compilation: " ~(pr-str name)) {}))))