(ns hello.check
  (:require [io.pedestal.interceptor.chain :as c]
            [io.pedestal.interceptor.error :as err]
            [io.pedestal.interceptor.helpers :as h]
            [hello.interceptor :as i]
            [clojure.core.async :refer [<! >! <!! chan alt! go go-loop onto-chan sliding-buffer timeout]]
            ))

(def service-error-handler
  (err/error-dispatch [ctx ex]
                      [{:exception-type :java.lang.ArithmeticException :interceptor ::another-bad-one}]
                      (assoc ctx :response {:status 400 :body "Another bad one"})
                      [{:exception-type :java.lang.ArithmeticException}]
                      (assoc ctx :response {:status 400 :body "A bad one"})
                      [{:exception-type :clojure.lang.ExceptionInfo}]
                      (do
                        (assoc ctx :response {:status 400 :body "A bad one"}))
                      :else
                      (assoc ctx :io.pedestal.interceptor.chain/error ex)))



(defn app-handler [req]
  (println "Handler ")
  {:c 2})


(defn process-response-sleep [response]
  (println "process-response-sleep ")
  (Thread/sleep (* 1000 (rand-int 5)) )
  (merge response {:a 4}))


(defn process-response2 [response]
  (println "process-response2 ")
  (merge response {:a 4}))


(defn error-response [response]
  (println "error-response ")
  (if (odd? (rand-int 5))
    (throw (ex-info "Failed" {:a 3}))
    response
    )
  )







(comment


  (-> {:request [{:params {:a 4}} {:params {:a 5}}]}
      (c/execute [i/sequence-interceptor
                  (h/handler app-handler)
                  ;    (h/on-response error-response)
                  (h/on-response process-response)])
      )

  (-> {:request [{:params {:a 4}} {:params {:a 5}}]}
      (c/execute [i/sequence-until-error-interceptor
                  service-error-handler
                  (h/handler app-handler)
                  (h/on-response error-response)
                  (h/on-response process-response)])
      )


  (-> {:request [{:params {:a 4}} {:params {:a 5}}]}
      (c/execute [i/parallel-thread-interceptor
                  ;service-error-handler
                  (h/handler app-handler)
                ;  (h/on-response error-response)
                  (h/on-response process-response-sleep)
                  (h/on-response process-response2)])
      )


  (-> {:request [{:params {:a 4}} {:params {:a 5}}]}
      (c/execute [i/parallel-thread-interceptor
                  ;service-error-handler
                  (h/handler app-handler)
                  (h/on-response error-response)

             ;     (h/on-response error-response)
                  ])
      )


  )

