(ns dosql.compiler.core
  (:require [dosql.compiler.spec :as cs]
            [dosql.clj.common :as cc]
            [dosql.compiler.validation :as u]
            [dosql.impl.param-spec-genarator :as su]
            [dosql.compiler.core-sql :as sql]
            [dosql.compiler.core-inheritance :as ci]
            [clojure.spec :as s]))

(defn do-debug [m]
  (println m)
  m)

(defn default-config
  []
  {:dosql.core/file-reload true
   :dosql.core/timeout     1000
   :dosql.core/name        :_global_
   :dosql.core/tx-prop     [:isolation :serializable :read-only? true]})

(defn reserve-regex []
  #":_.*")

(defn group-by-reserve-key
  [r-name-coll coll]
  (->> coll
       (group-by (fn [m]
                   (let [name (get-in m [:dosql.core/name])]
                     (if (or (re-matches (reserve-regex) (str name))
                             (contains? r-name-coll name)
                             (= :_global_ name))
                       :reserve
                       :modules))))))

(defn group-by-config-key
  [coll]
  (->> coll
       (group-by #(if (= :_global_ (:dosql.core/name %))
                    :global
                    :modules))))

(defn do-grouping [coll]
  (let [{:keys [global modules]} (group-by-config-key coll)
        f-global (or (first global) {})
        {:keys [reserve modules]} (-> (get-in f-global [:dosql.core/reserve-name])
                                      (group-by-reserve-key modules))]
    (hash-map :global [f-global] :reserve reserve :modules modules)))

(defn map-reverse-join
  [join-coll]
  (let [f (fn [[s-tab s-id join-key d-tab d-id [r-tab r-id r-id2] :as j]]
            (condp = join-key
              :spec-model.core/rel-1-1 [d-tab d-id :spec-model.core/rel-1-1 s-tab s-id]
              :spec-model.core/rel-1-n [d-tab d-id :spec-model.core/rel-n-1 s-tab s-id]
              :spec-model.core/rel-n-1 [d-tab d-id :spec-model.core/rel-1-n s-tab s-id]
              :spec-model.core/rel-n-n [d-tab d-id :spec-model.core/rel-n-n s-tab s-id [r-tab r-id2 r-id]]
              j))]
    (->> (map f join-coll)
         (concat join-coll)
         (distinct)
         (sort-by first)
         (into []))))

(defn group-by-join-src
  [join-coll]
  (->> join-coll
       (group-by first)
       (map (fn [[k coll]]
              {k {:spec-model.core/join coll}}))
       (into {})))

(defn do-skip
  [m]
  (->> (into [] (:dosql.core/skip m))
       (apply dissoc m)))

(def skip-key-for-call [:spec-model.core/join :dosql.core/param-spec :dosql.core/default-param])
(def skip-key-for-others [:dosql.core/result :clojure.core/column])

(defn do-skip-for-dml-type
  [m]
  (condp = (:dosql.core/dml m)
    :dosql.core/dml-select m
    :dosql.core/dml-call (apply dissoc m skip-key-for-call)
    (apply dissoc m skip-key-for-others)))

(defn assoc-default-key
  [m]
  (if (:dosql.core/model m)
    m
    (assoc m :dosql.core/model (:dosql.core/name m))))

#_(defn remove-duplicate [m]
    (->> (keys m)
         (reduce (fn [acc k]
                   (condp = k
                     :dosql.core/default-param (update-in acc [k] (fn [w] (cc/distinct-with-range 2 w)))
                     acc)) m)))

(defmulti compile-m (fn [type _ _] type))
(def compile-module (partial compile-m :modules))
(def compile-global (partial compile-m :global))
(def compile-reserve (partial compile-m :reserve))

(defmethod compile-m
  :modules
  [_ tm global-m]
  (let [model-m (sql/map-sql-with-name-model tm)]
    (reduce (fn [acc v]
              (->> (ci/do-inheritance v tm global-m)
                   ;                (remove-duplicate)
                   (assoc-default-key)
                   (do-skip)
                   (do-skip-for-dml-type)
                   (conj acc))) [] model-m)))

(defmethod compile-m
  :global
  [_ tm _]
  (if (empty? tm )
    (default-config)
    (let [v (->> (get-in tm [:spec-model.core/join])
                 (map-reverse-join)
                 (group-by-join-src))
          w (merge-with merge v (get-in tm [:dosql.core/extend]))]
      (-> tm
          ;  (dissoc :spec-model.core/join)
          (assoc :dosql.core/extend w)))
    )

  )

(defmethod compile-m
  :reserve
  [_ tm _]
  (update-in tm [:dosql.core/sql] (fn [v] (clojure.string/join ";" v))))

(defn into-name-map
  [v]
  (hash-map (:dosql.core/name v) v))

(defn do-validation [coll]
  (do
    (cs/validate-input-spec! coll)
    (u/validate-distinct-name! coll)
    (u/validate-name-sql! coll)
    (u/validate-name-model! coll)
    (u/validate-extend-key! coll)
    (u/validate-join-key! coll)))

(defn evel-spec [tms]
  (do
    (doall (map eval (su/gen-spec tms)))
    tms))

(defn do-compile [coll file-name]
  (do-validation coll)
  (let [{:keys [modules global reserve]} (do-grouping coll)
        global (first (mapv #(compile-global % nil) global))
        modules (apply concat (mapv #(compile-module % global) modules))
        reserve (mapv #(compile-reserve % nil) reserve)
        global (-> (dissoc global :dosql.core/extend)
                   (assoc :dosql.core/file-name file-name)) r (su/filename-as-keyword file-name)]

    (->> (concat [global] modules reserve)
         (mapv (fn [w] (su/assosc-spec-to-m r w)))
         (into {} (map into-name-map))
         (evel-spec))))

(comment
  ;(require )

  ;(symbol 'he-hcsdf)
  ;(symbol "asdf")
  ;(clojure.set/rename-keys {:a 3} {:b :v})
  ;(as-parent-ns "tie.edn.sql")

  (clojure.string/split "tie.edn.sql" #"\.")

  ((->
    (read-file "tie.edn.sql")
      ;(second)
      ;(second)
      ;(get-in [:dosql.core/default-param 0 2])

    (clojure.pprint/pprint))
   2)

  (-> (read-file "tie3.edn.sql")
      ;(:get-dept-by-id)
      (get-in [:get-dept-by-id :dosql.core/param-spec-defined :id])
      (eval)
      (s/form)
      ;(first )
      ;(eval)
      ;(name)
      ;(clojure.pprint/pprint)
      )(-> (read-file "tie3.edn.sql")
      ;(:get-dept-by-id)
           (get-in [:get-dept-employee :dosql.core/param-spec-defined :id])
           (eval)
      ;(s/form)
      ;(first )

      ;(name)
           )(->>
             ((fr/read-file "tie3.edn.sql") alais-map)
             (s/conform :dosql.core/compiler-spec)
    ;(do-compile)
    ;  (s/explain-data :dosql.core/compiler-spec )
             (clojure.pprint/pprint))

  (clojure.pprint/pprint
   (s/exercise :dosql.core/compiler-spec 1))

  (->> (read-file "tie3.edn.sql")
       #_(s/conform :dosql.compiler.spec/compiler-input-spec))

  (do (read-file "tie.edn.sql")
      nil) (:hello.get-dept-by-id/spec
            (sp/registry))
  ;(clojure.set/rename-keys {:a 3 :b 4} {:a :tr/c})
  (let [v {:name [:many [:insert-dept :update-dept :delete-dept]]}]
    (m/match v
      {:name [:many _]} :many
      {:name [:many _]} :many
      :else nil)))

(comment

  ;(filter odd? [ 1 2 3])
  (sp/registry)

  ;(add-quote Hello)

  ;'tie-edn
  ;`

  (let [w1 (mapv namespace (list :tie-edn1/hello))]
    (doseq [w w1]
      (require (symbol w) :reload))) (println (quote [a])) (let [v (mapv namespace (list :a/b))
                                                                 w (list 'quote v)]
                                                             (println (eval w)));(println ''a)
;(s/registry)
  )
