(ns dosql.compiler.core-inheritance)


(defn compiler-merge
  [old new]
  (cond (map? new) (merge old new)
        (vector? new) (into (empty old) (concat new old))
        :else (or new old)))


(defn do-inheritance
  [w module-m f-config]
  (let [name-v (get w :dosql.core/name)
        w1 (merge-with compiler-merge
                       (get-in f-config [:dosql.core/extend name-v])
                       (get-in module-m [:dosql.core/extend name-v])
                       w)

        model-v (get w1 :dosql.core/model)
        w2 (merge-with compiler-merge
                       (get-in f-config [:dosql.core/extend model-v])
                       (get-in module-m [:dosql.core/extend model-v])
                       w1)

        module-m (dissoc module-m :dosql.core/name :dosql.core/model :dosql.core/sql :dosql.core/extend :dosql.core/doc)
        f-config (select-keys f-config [:dosql.core/default-param :dosql.core/param-spec :dosql.core/timeout])]
    (merge-with compiler-merge f-config module-m w2)))
