(ns dosql.compiler.core-sql
  (:require [dosql.clj.common :as dc]))



(defn dml-type
  [v]
  (let [w (-> v
              (clojure.string/trim)
              (clojure.string/lower-case)
              (clojure.string/split #"\s+")
              (first)
              (keyword))]
    (condp = w
      :select :dosql.core/dml-select
      :update :dosql.core/dml-update
      :insert :dosql.core/dml-insert
      :delete :dosql.core/dml-delete
      :call :dosql.core/dml-call
      (throw (ex-info "Undefined dml op" {:for v})))))



(def as-lower-case-keyword (comp keyword clojure.string/lower-case name))

(def sql-param-regex #"\w*:[\w|\-|#]+")

(defn sql-str-emit
  [sql-str]
  (->> (re-seq sql-param-regex sql-str)
       (transduce (comp (map read-string)) conj)
       (reduce (fn [acc v]
                 (let [w (as-lower-case-keyword v)
                       sql-str-w (-> (first acc)
                                     (clojure.string/replace-first (re-pattern (dc/as-string v)) (dc/as-string w)))]
                   (-> (assoc-in acc [0] sql-str-w)
                       (conj w)))
                 ) [sql-str])))



(defn do-format [m]
  (cond
    (and (keyword? (:dosql.core/name m))
         (keyword? (:dosql.core/model m)))
    (mapv vector
          (range)
          (:dosql.core/sql m)
          (repeat (:dosql.core/name m))
          (repeat (:dosql.core/model m)))

    (and (sequential? (:dosql.core/name m))
         (sequential? (:dosql.core/model m)))
    (mapv vector
          (range)
          (:dosql.core/sql m)
          (:dosql.core/name m)
          (:dosql.core/model m))

    (and (sequential? (:dosql.core/name m))
         (keyword? (:dosql.core/model m)))
    (mapv vector
          (range)
          (get-in m [:dosql.core/sql])
          (get-in m [:dosql.core/name])
          (repeat (:dosql.core/model m)))

    (sequential? (:dosql.core/name m))
    (mapv vector
          (range)
          (:dosql.core/sql m)
          (:dosql.core/name m)
          (repeat (:dosql.core/model m)))

    (keyword? (:dosql.core/name m))
    (mapv vector
          (range)
          (:dosql.core/sql m)
          (repeat (:dosql.core/name m))
          (repeat (:dosql.core/model m)))))


(defn- map-sql [[i s n m]]
  {:dosql.core/name  n
   :dosql.core/dml   (dml-type s)
   :dosql.core/index i
   :dosql.core/sql   (sql-str-emit s)
   :dosql.core/model m})


(defn map-sql-with-name-model
  [m]
  (->> m
       (do-format)
       (mapv map-sql)))




