(ns dosql.core-impl
  (:require
    [clojure.core.match :refer [match]]
    [io.pedestal.interceptor.helpers :as h]
    [io.pedestal.interceptor.chain :as c]
    [dosql.jdbc-io :as jdbc]
    [spec-model.core :as joi]
    [dosql.impl.sql-bind-impl :as bi]
    [dosql.selector :as sel]
    [dosql.impl.param-impl :as pi]
    [dosql.impl.param-spec-genarator :as psi]
    [dosql.impl.common-impl :as ci]))


(defn repl-log
  ([msg request]
   (println "--------------------" msg)
   (clojure.pprint/pprint request)

   request)
  ([requ] (repl-log "message" requ))
  )



(defn do-execute [interceptors context]
  (-> context
      (c/execute interceptors)
      (:response)))


(defn prepare-request [context]
  ;(println "---preparte request " (get-in context [:dosql.core/user-request ]))

  (let [[t n] (get-in context [:dosql.core/user-request :dosql.core/name])
        ds (:dosql.core/ds context)
        param (get-in context [:dosql.core/user-request :dosql.core/param])
        tm (-> (get-in context [:dosql.core/tms n])
               (assoc :dosql.core/param param)
               (assoc :dosql.core/ds ds))]
    (assoc context :request tm)))


(def pull-interceptor [(h/before prepare-request)
                       ;    (h/on-request (partial repl-log "debug pull"))
                       (h/on-request (partial pi/assoc-generator identity))
                       (h/on-request pi/merge-default-param)
                       (h/on-request psi/validate-spec)
                       (h/on-request bi/validate-input-not-empty!)
                       (h/on-request bi/validate-input-type!)
                       (h/on-request bi/validate-required-params!)
                       (h/on-request bi/sql-bind)
                       (h/handler jdbc/jdbc-handler2)
                       (h/on-response ci/do-result)
                       (h/on-response ci/do-column)])


(def sequence-interceptor [(h/before prepare-request)
                           (h/handler jdbc/jdbc-handler2)
                           (h/on-response #(update-in % [:dosql.core/output] first))])


(defn do-batch [exec-fn context]
  (let [[t nm] (get-in context [:dosql.core/user-request :dosql.core/name])]
    (->> nm
         (mapv (fn [n]
                 (assoc-in context [:dosql.core/user-request :dosql.core/name] [t n])))
         (mapv exec-fn))
    )
  )




(defn dbseq-as-gen [parent-context context]
  (->> (merge (select-keys parent-context [:dosql.core/tms :dosql.core/ds]) context)
       (do-execute sequence-interceptor)
       (:dosql.core/output)))


(def push-interceptor [(h/on-request bi/validate-input-not-empty!)

                       (h/on-request bi/validate-input-type!)
                       (h/on-request bi/validate-required-params!)
                       (h/on-request bi/sql-bind)
                       (h/handler jdbc/jdbc-handler2)])


(defn pull-one [context]
  (do-execute pull-interceptor context))


(defn pull-sequence-one [context]
  (do-execute sequence-interceptor context))




;; New ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(comment
  (-> {:dosql.core/user-request {:dosql.core/name :hello}
       :dosql.core/op           :dosql.core/pull})
  )

(defn dispatch-type [context]
  (let [t (:dosql.core/op context)
        [n _] (if-let [v (get-in context [:dosql.core/user-request :dosql.core/name])]
                v
                []
                )
        group (contains? (get-in context [:dosql.core/user-request])
                         :dosql.core/group)
        type (match [t n group]
                    [:dosql.core/pull :one _] :dosql.core/pull-entity-one

                    [:dosql.core/pull :many _] :dosql.core/pull-entity-many-parallel
                    [:dosql.core/pull _ true] :dosql.core/pull-entity-relational

                    [:dosql.core/push :one _] :dosql.core/push-entity-one
                    [:dosql.core/push :many _] :dosql.core/push-entity-many-sequential
                    [:dosql.core/push _ true] :dosql.core/push-entity-relational
                    )
        ]


    (println "type .........." type)
    type
    ))

(defmulti execute dispatch-type)


(defmethod execute
  :dosql.core/pull-sequence-one
  [context]
  (-> (pull-sequence-one context)
      :dosql.core/output))


(defmethod execute
  :dosql.core/seq-pull
  [context]
  (->> (do-batch pull-sequence-one context)
       (mapv (juxt :dosql.core/model :dosql.core/output))
       (into {})))


#_(defn get-output [tm]
    (get tm :dosql.core/output))



(defmethod execute
  :dosql.core/pull-entity-one
  [context]
  (-> (do-execute pull-interceptor context)
      ;((do-execute pull-interceptor context) exec/pull-one context)
      :dosql.core/output))


#_(defn log-interceptor [context]
    (clojure.pprint/pprint context)
    context
    )

(defmethod execute
  :dosql.core/pull-entity-many-parallel
  [context]
  (->> (do-batch (partial do-execute pull-interceptor) context)
       (mapv (juxt :dosql.core/model :dosql.core/output))
       (into {})))



(defmethod execute
  :dosql.core/pull-entity-relational
  [context]
  (let [[_ name] (get-in context [:dosql.core/user-request :dosql.core/name])
        group (get-in context [:dosql.core/user-request :dosql.core/group])
        tms (get-in context [:dosql.core/tms])
        [root-name & more-name] (if group
                                  (sel/select-name-for-groups tms group name)
                                  name)
        root-response2 (-> (assoc-in context [:dosql.core/user-request :dosql.core/name] [:one root-name])
                           (pull-one))
        [model output join] ((juxt :dosql.core/model :dosql.core/output :spec-model.core/join) root-response2)]
    (if (empty? output)
      {model output}
      (let [[_ params] (get-in context [:dosql.core/user-request :dosql.core/param])
            params (merge output params)
            context (-> context
                        (assoc-in [:dosql.core/user-request :dosql.core/name] [:one more-name])
                        (assoc-in [:dosql.core/user-request :dosql.core/param] [:one params]))
            batch-response (->> (do-batch pull-one context)
                                (mapv (juxt :dosql.core/model :dosql.core/output))
                                (into {}))
            response (merge batch-response {model output})
            out (joi/do-join response join)]
        out))))

;;;;;;;;;;;;;;;;;;;Push entity

;//@todo need to set for multi params
(defmethod execute
  :dosql.core/push-entity-one
  [context]
  (let [[_ n] (get-in context [:dosql.core/user-request :dosql.core/name])
        ds (:dosql.core/ds context)
        param (get-in context [:dosql.core/user-request :dosql.core/param])
        tm (-> (get-in context [:dosql.core/tms n])
               (assoc :dosql.core/param param)
               (assoc :dosql.core/ds ds))
        tm (-> (pi/assoc-generator (partial dbseq-as-gen context) tm)
               (pi/merge-default-param)

               (psi/validate-spec2))
        response (-> (assoc context :request tm)
                     (c/execute push-interceptor)
                     (:response)
                     (:dosql.core/output))]
    response))



(defmethod execute
  :dosql.core/push-entity-many-sequential
  [context]
  (let [tm-coll (sel/select-name context)
        [t param] (get-in context [:dosql.core/user-request :dosql.core/param])
        ds (:dosql.core/ds context)
        process (comp (map #(pi/assoc-generator (partial dbseq-as-gen context) %))
                      (map (fn [w]
                             (assoc w :dosql.core/param [t ((:dosql.core/model w) param)])))
                      (map pi/merge-default-param)
                      (map psi/validate-spec2)
                      (map #(assoc % :dosql.core/ds ds))
                      (map #(assoc context :request %))
                      (map (fn [c] (c/execute c push-interceptor)))
                      (map :response)
                      (map (juxt :dosql.core/model :dosql.core/output)))
        response-coll (into {} process tm-coll)]
    response-coll))



(defn relation-data [context]
  (let [tm-coll (sel/select-name context)
        [t param] (get-in context [:dosql.core/user-request :dosql.core/param])
        join-list (get-in tm-coll [0 :spec-model.core/join])
        tm-coll (mapv #(pi/assoc-generator (partial dbseq-as-gen context) %) tm-coll)
        model-default-param-m (into {} (mapv (juxt :dosql.core/model :dosql.core/default-param) tm-coll))
        id-genrator (fn [model model-map]
                      (pi/merge-default-param-rf model-map (get model-default-param-m model)))
        model-param-m (joi/do-disjoin id-genrator param join-list)]
    (joi/do-join model-param-m join-list)))


(defmethod execute
  :dosql.core/push-entity-relational
  [context]
  (let [tm-coll (sel/select-name context)
        [t param] (get-in context [:dosql.core/user-request :dosql.core/param])
        join-list (get-in tm-coll [0 :spec-model.core/join])
        tm-coll (mapv #(pi/assoc-generator (partial dbseq-as-gen context) %) tm-coll)
        model-default-param-m (into {} (mapv (juxt :dosql.core/model :dosql.core/default-param) tm-coll))
        id-genrator (fn [model model-map]
                      (pi/merge-default-param-rf model-map (get model-default-param-m model)))
        model-param-m (joi/do-disjoin id-genrator param join-list)
        ds (:dosql.core/ds context)
        process (comp (map (fn [w]
                             (assoc w :dosql.core/param [t ((:dosql.core/model w) model-param-m)])
                             ))
                      (map #(assoc % :dosql.core/ds ds))
                      (map #(assoc context :request %))
                      (map psi/validate-spec)
                      (map (fn [c] (c/execute c push-interceptor)))
                      (map :response)
                      (map (juxt :dosql.core/model :dosql.core/output)))
        response-coll (into {} process tm-coll)]
    response-coll))






