(ns dosql.core-spec
  (:require [clojure.spec :as s]))

(def dml #{:dosql.core/dml-select
           :dosql.core/dml-insert
           :dosql.core/dml-update
           :dosql.core/dml-delete
           :dosql.core/dml-call})


(def commit #{:dosql.core/commit-all
              :dosql.core/commit-none
              :dosql.core/commit-any})


(s/def :dosql.core/dml dml)
(s/def :dosql.core/commit commit)

(s/def :dosql.core/tx-prop (s/cat :ck #{:isolation}
                                  :cv (s/spec #{:none :read-committed :read-uncommitted :repeatable-read :serializable})
                                  :rk #{:read-only?}
                                  :rv (s/spec boolean?)))


(s/def :dosql.core/file-reload boolean?)
(s/def :dosql.core/reserve-name (s/every keyword? :kind set?))

(s/def :dosql.core/doc string?)
(s/def :dosql.core/timeout pos-int?)

(s/def :dosql.core/name
  (s/or :one keyword?
        :many (s/coll-of keyword? :kind vector? :distinct true)))

(s/def :dosql.core/index int?)


(s/def :dosql.core/sql (s/every string? :kind vector?))

(s/def :dosql.core/model
  (s/or :one keyword?
        :many (s/coll-of keyword? :kind vector?)))

(s/def :dosql.core/skip (s/every keyword? :kind set?))

(s/def :dosql.core/group keyword?)
(s/def :dosql.core/column (s/every-kv keyword? keyword?))
(s/def :dosql.core/result (s/every #{:dosql.core/result-array :dosql.core/result-single} :kind set?))
(s/def :dosql.core/read-only? boolean?)


(s/def :spec-model.core/join
  (clojure.spec/*
    (clojure.spec/alt
      :one (s/tuple keyword? keyword? #{:spec-model.core/rel-1-1 :spec-model.core/rel-1-n :spec-model.core/rel-n-1} keyword? keyword?)
      :many (s/tuple keyword? keyword? #{:spec-model.core/rel-n-n} keyword? keyword? (s/tuple keyword? keyword? keyword?)))))


(s/def :dosql.core/default-param (s/* (s/cat :k keyword? :fn fn?)))



(defn ns-keyword? [v]
  (if (namespace v) true false))


(defn clj-spec? [v]
  (let [v (eval v)]
    (if (and (not (keyword? v))
             (or (ifn? v)
                 (clojure.spec/spec? v)
                 (clojure.spec/regex? v)))
      true
      false)))


(s/def ::req (s/map-of keyword? clj-spec?))
(s/def ::opt (s/map-of keyword? clj-spec?))
(s/def :dosql.core/param-spec (s/merge (s/or :req (s/keys :req [::req])
                                             :opt (s/keys :opt [::opt]))
                                       (s/map-of #{:req :opt} any?)))



#_(s/conform
    (s/or
      :map
      map?
      :coll
      (s/every map? :kind vector? :min-count 1)
      )
    ;[{:a 3}]
    {:a 3}
    )

;;;;;;;;;;;;;;;;;;;; FOr input


(s/def :dosql.core/exec-total-time int?)
(s/def :dosql.core/exec-start-time int?)
(s/def :dosql.core/query-exception string?)


(s/def :dosql.core/output any?)

;(s/def :dosql.core/param map?)

(s/def :dosql.core/param
  (s/or
    :one
    map?
    :coll
    (s/every map? :kind vector? :min-count 1)
    ))

(s/def :dosql.core/format-nested any?)
(s/def :dosql.core/format-nested-array any?)
(s/def :dosql.core/format-nested-join any?)

(s/def :dosql.core/format-map any?)
(s/def :dosql.core/format-array any?)
(s/def :dosql.core/format-value any?)

(s/def :dosql.core/output-format #{:dosql.core/format-nested :dosql.core/format-nested-array :dosql.core/format-nested-join
                                   :dosql.core/format-map :dosql.core/format-array :dosql.core/format-value})
(s/def :dosql.core/param-format #{:dosql.core/format-nested :dosql.core/format-map})


(s/def :dosql.core/op #{:dosql.core/pull-sequence-one :dosql.core/pull-entity-many-sequential :dosql.core/push-entity-relational})
;(def input-key )

;;merge does not work with conform
(s/def :dosql.core/user-input
  (s/keys :req [(or :dosql.core/name :dosql.core/group)]
          :opt [:dosql.core/param :dosql.core/param-format :dosql.core/output-format])
  #_(s/merge
    (s/keys :req [(or :dosql.core/name :dosql.core/group)]
            :opt [:dosql.core/param :dosql.core/param-format :dosql.core/output-format])
    (s/map-of #{:dosql.core/name :dosql.core/group :dosql.core/op
                :dosql.core/param :dosql.core/param-format :dosql.core/output-format}
              any?)))


(comment



  ;(s/conform :dosql.core/param [{:a 3}])
  (s/conform :dosql.core/param {:a 3})
  (s/conform :dosql.core/name :a)
  (s/conform :dosql.core/name [:hello :a] )

  (->> {:dosql.core/name  [:get-employee-by-id :get-employee-dept :get-employee-detail]
        :dosql.core/param {:id 1}}
       (s/conform :dosql.core/user-input)
       (clojure.pprint/pprint)
       )

  (->> {:dosql.core/name  :get-employee-by-id
        :dosql.core/param [{:id 1}] }
       (s/conform :dosql.core/user-input)
       (clojure.pprint/pprint)
       )




  )