(ns leiningen.new.dotcloud
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]]))

(def render (renderer "dotcloud"))

(defn dotcloud
  "Generate a new dotCloud application"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (println "Generating a project called" name
             "based on the 'dotcloud' template.")
    (->files data
             [".gitignore" (render "gitignore" data)]
             ["scripts/deploy.sh" (render "deploy.sh" data)]
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)]
             ["deployments/dotcloud.yml" (render "dotcloud.yml" data)]
             ["resources/public/index.html" (render "index.html" data)]
             ["src/clj/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["test/{{sanitized}}/core_test.clj" (render "test.clj" data)])))
