// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.component');
goog.require('cljs.core');
goog.require('threeagent.threejs');
threeagent.component.component_registry = cljs.core.PersistentArrayMap.EMPTY;
threeagent.component.register_component_renderer_BANG_ = (function threeagent$component$register_component_renderer_BANG_(key,render_fn){
return threeagent.component.component_registry = cljs.core.assoc.call(null,threeagent.component.component_registry,key,render_fn);
});
threeagent.component.render_component = (function threeagent$component$render_component(key,config){
var renderer = cljs.core.get.call(null,threeagent.component.component_registry,key);
if(cljs.core.truth_(renderer)){
return renderer.call(null,config);
} else {
return cljs.core.println.call(null,"Missing renderer for object type",key);
}
});
threeagent.component.__GT_material = (function threeagent$component$__GT_material(config){
if((config instanceof THREE.Material)){
return config;
} else {
return threeagent.threejs.mesh_phong_material.call(null,config);
}
});
threeagent.component.to_mesh = (function threeagent$component$to_mesh(geo,material_config){
var mat = threeagent.component.__GT_material.call(null,material_config);
return threeagent.threejs.mesh.call(null,geo,mat);
});
threeagent.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"object","object",1474613949),(function (c){
return threeagent.threejs.object.call(null);
}));
threeagent.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"group","group",582596132),(function (c){
return threeagent.threejs.group.call(null);
}));
threeagent.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"camera","camera",-1190348585),(function (p__35711){
var map__35712 = p__35711;
var map__35712__$1 = (((((!((map__35712 == null))))?(((((map__35712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35712.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35712):map__35712);
var fov = cljs.core.get.call(null,map__35712__$1,new cljs.core.Keyword(null,"fov","fov",-12463282));
var aspectRatio = cljs.core.get.call(null,map__35712__$1,new cljs.core.Keyword(null,"aspectRatio","aspectRatio",-218867702));
var near = cljs.core.get.call(null,map__35712__$1,new cljs.core.Keyword(null,"near","near",-1077668328));
var far = cljs.core.get.call(null,map__35712__$1,new cljs.core.Keyword(null,"far","far",85807546));
return threeagent.threejs.perspective_camera.call(null,fov,aspectRatio,near,far);
}));
threeagent.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"instance","instance",-2121349050),(function (p__35714){
var map__35715 = p__35714;
var map__35715__$1 = (((((!((map__35715 == null))))?(((((map__35715.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35715.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35715):map__35715);
var object = cljs.core.get.call(null,map__35715__$1,new cljs.core.Keyword(null,"object","object",1474613949));
return object;
}));
threeagent.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"plane","plane",-223595224),(function (p__35717){
var map__35718 = p__35717;
var map__35718__$1 = (((((!((map__35718 == null))))?(((((map__35718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35718.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35718):map__35718);
var dims = cljs.core.get.call(null,map__35718__$1,new cljs.core.Keyword(null,"dims","dims",-466522889));
var segment_dims = cljs.core.get.call(null,map__35718__$1,new cljs.core.Keyword(null,"segment-dims","segment-dims",1394305588));
var material = cljs.core.get.call(null,map__35718__$1,new cljs.core.Keyword(null,"material","material",460118677));
var vec__35720 = dims;
var w = cljs.core.nth.call(null,vec__35720,(0),null);
var h = cljs.core.nth.call(null,vec__35720,(1),null);
var vec__35723 = segment_dims;
var sw = cljs.core.nth.call(null,vec__35723,(0),null);
var sh = cljs.core.nth.call(null,vec__35723,(1),null);
var geo = threeagent.threejs.plane_geometry.call(null,w,h,sw,sh);
return threeagent.component.to_mesh.call(null,geo,material);
}));
threeagent.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"box","box",1530920394),(function (p__35726){
var map__35727 = p__35726;
var map__35727__$1 = (((((!((map__35727 == null))))?(((((map__35727.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35727.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35727):map__35727);
var dims = cljs.core.get.call(null,map__35727__$1,new cljs.core.Keyword(null,"dims","dims",-466522889));
var material = cljs.core.get.call(null,map__35727__$1,new cljs.core.Keyword(null,"material","material",460118677));
var vec__35729 = dims;
var x = cljs.core.nth.call(null,vec__35729,(0),null);
var y = cljs.core.nth.call(null,vec__35729,(1),null);
var z = cljs.core.nth.call(null,vec__35729,(2),null);
var geo = threeagent.threejs.box_geometry.call(null,x,y,z);
return threeagent.component.to_mesh.call(null,geo,material);
}));
threeagent.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"sphere","sphere",384337120),(function (p__35732){
var map__35733 = p__35732;
var map__35733__$1 = (((((!((map__35733 == null))))?(((((map__35733.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35733.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35733):map__35733);
var radius = cljs.core.get.call(null,map__35733__$1,new cljs.core.Keyword(null,"radius","radius",-2073122258));
var width_segments = cljs.core.get.call(null,map__35733__$1,new cljs.core.Keyword(null,"width-segments","width-segments",25187827));
var height_segments = cljs.core.get.call(null,map__35733__$1,new cljs.core.Keyword(null,"height-segments","height-segments",1831894149));
var material = cljs.core.get.call(null,map__35733__$1,new cljs.core.Keyword(null,"material","material",460118677));
var geo = threeagent.threejs.sphere_geometry.call(null,radius,(function (){var or__4047__auto__ = width_segments;
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return (12);
}
})(),(function (){var or__4047__auto__ = height_segments;
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return (12);
}
})());
return threeagent.component.to_mesh.call(null,geo,material);
}));
threeagent.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"point-light","point-light",669926690),(function (p__35735){
var map__35736 = p__35735;
var map__35736__$1 = (((((!((map__35736 == null))))?(((((map__35736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35736.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35736):map__35736);
var color = cljs.core.get.call(null,map__35736__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var intensity = cljs.core.get.call(null,map__35736__$1,new cljs.core.Keyword(null,"intensity","intensity",1142770863));
var distance = cljs.core.get.call(null,map__35736__$1,new cljs.core.Keyword(null,"distance","distance",-1671893894));
return threeagent.threejs.point_light.call(null,color,intensity,distance);
}));
threeagent.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"hemisphere-light","hemisphere-light",-1569111131),(function (p__35738){
var map__35739 = p__35738;
var map__35739__$1 = (((((!((map__35739 == null))))?(((((map__35739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35739.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35739):map__35739);
var sky_color = cljs.core.get.call(null,map__35739__$1,new cljs.core.Keyword(null,"sky-color","sky-color",1803548607));
var ground_color = cljs.core.get.call(null,map__35739__$1,new cljs.core.Keyword(null,"ground-color","ground-color",-1832095873));
var intensity = cljs.core.get.call(null,map__35739__$1,new cljs.core.Keyword(null,"intensity","intensity",1142770863));
return threeagent.threejs.hemisphere_light.call(null,sky_color,ground_color,intensity);
}));
threeagent.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),(function (p__35741){
var map__35742 = p__35741;
var map__35742__$1 = (((((!((map__35742 == null))))?(((((map__35742.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35742.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35742):map__35742);
var cfg = map__35742__$1;
var text = cljs.core.get.call(null,map__35742__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var material = cljs.core.get.call(null,map__35742__$1,new cljs.core.Keyword(null,"material","material",460118677));
var geo = threeagent.threejs.text_geometry.call(null,text,cfg);
return threeagent.component.to_mesh.call(null,geo,material);
}));

//# sourceMappingURL=component.js.map?rel=1547411152344
