// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.impl.virtual_scene');
goog.require('cljs.core');
goog.require('threeagent.impl.util');
goog.require('medley.core');
goog.require('reagent.ratom');
goog.require('goog.structs.PriorityQueue');
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.non_component_keys !== 'undefined')){
} else {
threeagent.impl.virtual_scene.non_component_keys = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"rotation","rotation",-1728051644),null,new cljs.core.Keyword(null,"scale","scale",-230427353),null,new cljs.core.Keyword(null,"position","position",-2011731912),null], null), null);
}
threeagent.impl.virtual_scene.print_tree = (function threeagent$impl$virtual_scene$print_tree(var_args){
var G__22078 = arguments.length;
switch (G__22078) {
case 1:
return threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.impl.virtual_scene.print_tree.call(null,node,"");
});

threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2 = (function (node,p){
var is_reactive = (!((threeagent.impl.util.$.call(null,node,"reaction") == null)));
cljs.core.println.call(null,p,"|-",threeagent.impl.util.$.call(null,node,"key"),["dirty:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(threeagent.impl.util.$.call(null,node,"dirty"))].join(''),["reactive:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(is_reactive)].join(''),threeagent.impl.util.$.call(null,node,"render"));

var seq__22079 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,threeagent.impl.util.$.call(null,node,"children").values()));
var chunk__22080 = null;
var count__22081 = (0);
var i__22082 = (0);
while(true){
if((i__22082 < count__22081)){
var child = cljs.core._nth.call(null,chunk__22080,i__22082);
threeagent.impl.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__22084 = seq__22079;
var G__22085 = chunk__22080;
var G__22086 = count__22081;
var G__22087 = (i__22082 + (1));
seq__22079 = G__22084;
chunk__22080 = G__22085;
count__22081 = G__22086;
i__22082 = G__22087;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22079);
if(temp__5457__auto__){
var seq__22079__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22079__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__22079__$1);
var G__22088 = cljs.core.chunk_rest.call(null,seq__22079__$1);
var G__22089 = c__4461__auto__;
var G__22090 = cljs.core.count.call(null,c__4461__auto__);
var G__22091 = (0);
seq__22079 = G__22088;
chunk__22080 = G__22089;
count__22081 = G__22090;
i__22082 = G__22091;
continue;
} else {
var child = cljs.core.first.call(null,seq__22079__$1);
threeagent.impl.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__22092 = cljs.core.next.call(null,seq__22079__$1);
var G__22093 = null;
var G__22094 = (0);
var G__22095 = (0);
seq__22079 = G__22092;
chunk__22080 = G__22093;
count__22081 = G__22094;
i__22082 = G__22095;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.impl.virtual_scene.print_tree.cljs$lang$maxFixedArity = 2;

threeagent.impl.virtual_scene.node__GT_path = (function threeagent$impl$virtual_scene$node__GT_path(var_args){
var G__22097 = arguments.length;
switch (G__22097) {
case 1:
return threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.impl.virtual_scene.node__GT_path.call(null,cljs.core.PersistentVector.EMPTY,node);
});

threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2 = (function (path,node){
while(true){
if(cljs.core.truth_(node)){
var G__22099 = cljs.core.conj.call(null,path,threeagent.impl.util.$.call(null,node,"key"));
var G__22100 = threeagent.impl.util.$.call(null,node,"parent");
path = G__22099;
node = G__22100;
continue;
} else {
return cljs.core.reverse.call(null,path);
}
break;
}
});

threeagent.impl.virtual_scene.node__GT_path.cljs$lang$maxFixedArity = 2;

threeagent.impl.virtual_scene.get_in_node = (function threeagent$impl$virtual_scene$get_in_node(node,path){
while(true){
if(cljs.core.empty_QMARK_.call(null,path)){
return node;
} else {
var G__22101 = threeagent.impl.util.$.call(null,node,"children").get(cljs.core.first.call(null,path));
var G__22102 = cljs.core.rest.call(null,path);
node = G__22101;
path = G__22102;
continue;
}
break;
}
});
threeagent.impl.virtual_scene.get_key = (function threeagent$impl$virtual_scene$get_key(key,meta){
new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(meta);

return key;
});

/**
* @constructor
 * @implements {threeagent.impl.virtual_scene.Object}
*/
threeagent.impl.virtual_scene.Node = (function (parent,depth,key,meta,data,dirty,render,reaction,children){
this.parent = parent;
this.depth = depth;
this.key = key;
this.meta = meta;
this.data = data;
this.dirty = dirty;
this.render = render;
this.reaction = reaction;
this.children = children;
});
threeagent.impl.virtual_scene.Node.prototype.for_each_child = (function (f){
var self__ = this;
var this$ = this;
var seq__22103 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,self__.children.values()));
var chunk__22104 = null;
var count__22105 = (0);
var i__22106 = (0);
while(true){
if((i__22106 < count__22105)){
var child = cljs.core._nth.call(null,chunk__22104,i__22106);
f.call(null,child);


var G__22107 = seq__22103;
var G__22108 = chunk__22104;
var G__22109 = count__22105;
var G__22110 = (i__22106 + (1));
seq__22103 = G__22107;
chunk__22104 = G__22108;
count__22105 = G__22109;
i__22106 = G__22110;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22103);
if(temp__5457__auto__){
var seq__22103__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22103__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__22103__$1);
var G__22111 = cljs.core.chunk_rest.call(null,seq__22103__$1);
var G__22112 = c__4461__auto__;
var G__22113 = cljs.core.count.call(null,c__4461__auto__);
var G__22114 = (0);
seq__22103 = G__22111;
chunk__22104 = G__22112;
count__22105 = G__22113;
i__22106 = G__22114;
continue;
} else {
var child = cljs.core.first.call(null,seq__22103__$1);
f.call(null,child);


var G__22115 = cljs.core.next.call(null,seq__22103__$1);
var G__22116 = null;
var G__22117 = (0);
var G__22118 = (0);
seq__22103 = G__22115;
chunk__22104 = G__22116;
count__22105 = G__22117;
i__22106 = G__22118;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.impl.virtual_scene.Node.getBasis = (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.Symbol(null,"depth","depth",-885772129,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"dirty","dirty",-1924882488,null),new cljs.core.Symbol(null,"render","render",232498073,null),new cljs.core.Symbol(null,"reaction","reaction",2131401315,null),new cljs.core.Symbol(null,"children","children",699969545,null)], null);
});

threeagent.impl.virtual_scene.Node.cljs$lang$type = true;

threeagent.impl.virtual_scene.Node.cljs$lang$ctorStr = "threeagent.impl.virtual-scene/Node";

threeagent.impl.virtual_scene.Node.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"threeagent.impl.virtual-scene/Node");
});

/**
 * Positional factory function for threeagent.impl.virtual-scene/Node.
 */
threeagent.impl.virtual_scene.__GT_Node = (function threeagent$impl$virtual_scene$__GT_Node(parent,depth,key,meta,data,dirty,render,reaction,children){
return (new threeagent.impl.virtual_scene.Node(parent,depth,key,meta,data,dirty,render,reaction,children));
});


/**
* @constructor
 * @implements {threeagent.impl.virtual_scene.Object}
*/
threeagent.impl.virtual_scene.Scene = (function (root,render_queue){
this.root = root;
this.render_queue = render_queue;
});
threeagent.impl.virtual_scene.Scene.prototype.enqueue_for_render = (function (node){
var self__ = this;
var this$ = this;
threeagent.impl.util.$_BANG_.call(null,node,"dirty",true);

return self__.render_queue.enqueue(threeagent.impl.util.$.call(null,node,"depth"),node);
});

threeagent.impl.virtual_scene.Scene.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"render-queue","render-queue",-1084920245,null)], null);
});

threeagent.impl.virtual_scene.Scene.cljs$lang$type = true;

threeagent.impl.virtual_scene.Scene.cljs$lang$ctorStr = "threeagent.impl.virtual-scene/Scene";

threeagent.impl.virtual_scene.Scene.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"threeagent.impl.virtual-scene/Scene");
});

/**
 * Positional factory function for threeagent.impl.virtual-scene/Scene.
 */
threeagent.impl.virtual_scene.__GT_Scene = (function threeagent$impl$virtual_scene$__GT_Scene(root,render_queue){
return (new threeagent.impl.virtual_scene.Scene(root,render_queue));
});

threeagent.impl.virtual_scene.eval_fn = (function threeagent$impl$virtual_scene$eval_fn(f,args){
while(true){
var result = cljs.core.apply.call(null,f,args);
if(cljs.core.fn_QMARK_.call(null,result)){
var G__22119 = result;
var G__22120 = args;
f = G__22119;
args = G__22120;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,result], null);
}
break;
}
});
threeagent.impl.virtual_scene.on_react_BANG_ = (function threeagent$impl$virtual_scene$on_react_BANG_(ctx){
var node = threeagent.impl.util.$.call(null,ctx,"node");
var scene = threeagent.impl.util.$.call(null,ctx,"scene");
return scene.enqueue_for_render(node);
});
threeagent.impl.virtual_scene.extract_comp_config = (function threeagent$impl$virtual_scene$extract_comp_config(config){
var c = cljs.core.transient$.call(null,config);
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,((function (c){
return (function (p1__22121_SHARP_,p2__22122_SHARP_){
return cljs.core.dissoc_BANG_.call(null,p1__22121_SHARP_,p2__22122_SHARP_);
});})(c))
,c,threeagent.impl.virtual_scene.non_component_keys));
});
threeagent.impl.virtual_scene.node_data = (function threeagent$impl$virtual_scene$node_data(comp_key,comp_config){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"rotation","rotation",-1728051644),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"scale","scale",-230427353),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [1.0,1.0,1.0], null)),new cljs.core.Keyword(null,"component-key","component-key",1189239034),comp_key,new cljs.core.Keyword(null,"component-config","component-config",2000790546),threeagent.impl.virtual_scene.extract_comp_config.call(null,comp_config)], null);
});
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.__GT_node !== 'undefined')){
} else {
threeagent.impl.virtual_scene.__GT_node = (function (){var method_table__4524__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4525__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4526__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4527__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4528__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.impl.virtual-scene","->node"),((function (method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__){
return (function (scene,parent,key,p__22123){
var vec__22124 = p__22123;
var seq__22125 = cljs.core.seq.call(null,vec__22124);
var first__22126 = cljs.core.first.call(null,seq__22125);
var seq__22125__$1 = cljs.core.next.call(null,seq__22125);
var l = first__22126;
var r = seq__22125__$1;
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});})(method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4528__auto__,method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"default","default",-1987822328),(function (scene,parent,key,form){
return cljs.core.println.call(null,"Invalid object form:",form);
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (scene,parent,key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (scene,parent,key,form){
return threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent,key,cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),cljs.core.meta.call(null,form)));
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (scene,parent,key,form){
var vec__22127 = form;
var seq__22128 = cljs.core.seq.call(null,vec__22127);
var first__22129 = cljs.core.first.call(null,seq__22128);
var seq__22128__$1 = cljs.core.next.call(null,seq__22128);
var comp_key = first__22129;
var rs = seq__22128__$1;
var first_child = cljs.core.first.call(null,rs);
var metadata = cljs.core.meta.call(null,form);
var key__$1 = (function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return key;
}
})();
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,cljs.core.some_QMARK_,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
var children_map = (new Map());
var data = threeagent.impl.virtual_scene.node_data.call(null,comp_key,comp_config);
var depth = (cljs.core.truth_(parent)?(threeagent.impl.util.$.call(null,parent,"depth") + (1)):(0));
var node = (new threeagent.impl.virtual_scene.Node(parent,depth,key__$1,metadata,data,false,null,null,children_map));
var seq__22130_22140 = cljs.core.seq.call(null,medley.core.indexed.call(null,children));
var chunk__22131_22141 = null;
var count__22132_22142 = (0);
var i__22133_22143 = (0);
while(true){
if((i__22133_22143 < count__22132_22142)){
var vec__22134_22144 = cljs.core._nth.call(null,chunk__22131_22141,i__22133_22143);
var idx_22145 = cljs.core.nth.call(null,vec__22134_22144,(0),null);
var child_22146 = cljs.core.nth.call(null,vec__22134_22144,(1),null);
var temp__5457__auto___22147 = threeagent.impl.virtual_scene.__GT_node.call(null,scene,node,idx_22145,child_22146);
if(cljs.core.truth_(temp__5457__auto___22147)){
var child_node_22148 = temp__5457__auto___22147;
children_map.set(threeagent.impl.util.$.call(null,child_node_22148,"key"),child_node_22148);
} else {
}


var G__22149 = seq__22130_22140;
var G__22150 = chunk__22131_22141;
var G__22151 = count__22132_22142;
var G__22152 = (i__22133_22143 + (1));
seq__22130_22140 = G__22149;
chunk__22131_22141 = G__22150;
count__22132_22142 = G__22151;
i__22133_22143 = G__22152;
continue;
} else {
var temp__5457__auto___22153 = cljs.core.seq.call(null,seq__22130_22140);
if(temp__5457__auto___22153){
var seq__22130_22154__$1 = temp__5457__auto___22153;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22130_22154__$1)){
var c__4461__auto___22155 = cljs.core.chunk_first.call(null,seq__22130_22154__$1);
var G__22156 = cljs.core.chunk_rest.call(null,seq__22130_22154__$1);
var G__22157 = c__4461__auto___22155;
var G__22158 = cljs.core.count.call(null,c__4461__auto___22155);
var G__22159 = (0);
seq__22130_22140 = G__22156;
chunk__22131_22141 = G__22157;
count__22132_22142 = G__22158;
i__22133_22143 = G__22159;
continue;
} else {
var vec__22137_22160 = cljs.core.first.call(null,seq__22130_22154__$1);
var idx_22161 = cljs.core.nth.call(null,vec__22137_22160,(0),null);
var child_22162 = cljs.core.nth.call(null,vec__22137_22160,(1),null);
var temp__5457__auto___22163__$1 = threeagent.impl.virtual_scene.__GT_node.call(null,scene,node,idx_22161,child_22162);
if(cljs.core.truth_(temp__5457__auto___22163__$1)){
var child_node_22164 = temp__5457__auto___22163__$1;
children_map.set(threeagent.impl.util.$.call(null,child_node_22164,"key"),child_node_22164);
} else {
}


var G__22165 = cljs.core.next.call(null,seq__22130_22154__$1);
var G__22166 = null;
var G__22167 = (0);
var G__22168 = (0);
seq__22130_22140 = G__22165;
chunk__22131_22141 = G__22166;
count__22132_22142 = G__22167;
i__22133_22143 = G__22168;
continue;
}
} else {
}
}
break;
}

return node;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (scene,parent,key,form){
var key__$1 = (function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,form));
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return key;
}
})();
var vec__22169 = form;
var seq__22170 = cljs.core.seq.call(null,vec__22169);
var first__22171 = cljs.core.first.call(null,seq__22170);
var seq__22170__$1 = cljs.core.next.call(null,seq__22170);
var f = first__22171;
var args = seq__22170__$1;
var reaction_ctx = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),null,new cljs.core.Keyword(null,"reaction","reaction",490869788),null], null));
var vec__22172 = reagent.ratom.run_in_reaction.call(null,((function (key__$1,vec__22169,seq__22170,first__22171,seq__22170__$1,f,args,reaction_ctx){
return (function (){
return threeagent.impl.virtual_scene.eval_fn.call(null,f,args);
});})(key__$1,vec__22169,seq__22170,first__22171,seq__22170__$1,f,args,reaction_ctx))
,reaction_ctx,"reaction",threeagent.impl.virtual_scene.on_react_BANG_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"no-cache","no-cache",1588056370),true], null));
var final_fn = cljs.core.nth.call(null,vec__22172,(0),null);
var result = cljs.core.nth.call(null,vec__22172,(1),null);
var node = threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent,key__$1,result);
threeagent.impl.util.$_BANG_.call(null,node,"render",final_fn);

threeagent.impl.util.$_BANG_.call(null,node,"form",form);

threeagent.impl.util.$_BANG_.call(null,node,"rendered-form",result);

var temp__5457__auto___22175 = threeagent.impl.util.$.call(null,reaction_ctx,"reaction");
if(cljs.core.truth_(temp__5457__auto___22175)){
var reaction_22176 = temp__5457__auto___22175;
threeagent.impl.util.$_BANG_.call(null,reaction_ctx,"scene",scene);

threeagent.impl.util.$_BANG_.call(null,reaction_ctx,"node",node);

threeagent.impl.util.$_BANG_.call(null,node,"reaction",reaction_22176);
} else {
}

return node;
}));
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.__GT_node_shallow !== 'undefined')){
} else {
threeagent.impl.virtual_scene.__GT_node_shallow = (function (){var method_table__4524__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4525__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4526__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4527__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4528__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.impl.virtual-scene","->node-shallow"),((function (method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__){
return (function (key,p__22177){
var vec__22178 = p__22177;
var seq__22179 = cljs.core.seq.call(null,vec__22178);
var first__22180 = cljs.core.first.call(null,seq__22179);
var seq__22179__$1 = cljs.core.next.call(null,seq__22179);
var l = first__22180;
var r = seq__22179__$1;
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});})(method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4528__auto__,method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (key,form){
if(cljs.core.empty_QMARK_.call(null,form)){
return null;
} else {
var m = cljs.core.meta.call(null,form);
return threeagent.impl.virtual_scene.__GT_node_shallow.call(null,threeagent.impl.virtual_scene.get_key.call(null,key,m),cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),m));
}
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (key,form){
var vec__22184 = form;
var seq__22185 = cljs.core.seq.call(null,vec__22184);
var first__22186 = cljs.core.first.call(null,seq__22185);
var seq__22185__$1 = cljs.core.next.call(null,seq__22185);
var comp_key = first__22186;
var rs = seq__22185__$1;
var first_child = cljs.core.first.call(null,rs);
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,((function (vec__22184,seq__22185,first__22186,seq__22185__$1,comp_key,rs,first_child,comp_config){
return (function (p1__22181_SHARP_){
return (((!((p1__22181_SHARP_ == null)))) && ((!(cljs.core.empty_QMARK_.call(null,p1__22181_SHARP_)))));
});})(vec__22184,seq__22185,first__22186,seq__22185__$1,comp_key,rs,first_child,comp_config))
,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"data","data",-232669377),threeagent.impl.virtual_scene.node_data.call(null,comp_key,comp_config),new cljs.core.Keyword(null,"form","form",-1624062471),form,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807),cljs.core.map_indexed.call(null,((function (vec__22184,seq__22185,first__22186,seq__22185__$1,comp_key,rs,first_child,comp_config,children){
return (function (p1__22183_SHARP_,p2__22182_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p2__22182_SHARP_));
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return p1__22183_SHARP_;
}
})(),p2__22182_SHARP_],null));
});})(vec__22184,seq__22185,first__22186,seq__22185__$1,comp_key,rs,first_child,comp_config,children))
,children)], null);
}));
threeagent.impl.virtual_scene.dispose_node_BANG_ = (function threeagent$impl$virtual_scene$dispose_node_BANG_(node){
threeagent.impl.util.$_BANG_.call(null,node,"disposed",true);

var temp__5457__auto___22187 = threeagent.impl.util.$.call(null,node,"reaction");
if(cljs.core.truth_(temp__5457__auto___22187)){
var reaction_22188 = temp__5457__auto___22187;
reagent.ratom.dispose_BANG_.call(null,reaction_22188);
} else {
}

return node.for_each_child(threeagent.impl.virtual_scene.dispose_node_BANG_);
});
threeagent.impl.virtual_scene.add_node_BANG_ = (function threeagent$impl$virtual_scene$add_node_BANG_(scene,parent_node,key,form,changelog){
var temp__5457__auto__ = threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent_node,key,form);
if(cljs.core.truth_(temp__5457__auto__)){
var node = temp__5457__auto__;
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"add","add",235287739),null,threeagent.impl.util.$.call(null,node,"data")], null));

return node;
} else {
return null;
}
});
threeagent.impl.virtual_scene.remove_node_BANG_ = (function threeagent$impl$virtual_scene$remove_node_BANG_(node,changelog){
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"remove","remove",-131428414),threeagent.impl.util.$.call(null,node,"data"),null], null));

threeagent.impl.util.$_BANG_.call(null,node,"data",null);

threeagent.impl.util.$_BANG_.call(null,node,"dirty",false);

return threeagent.impl.virtual_scene.dispose_node_BANG_.call(null,node);
});
threeagent.impl.virtual_scene.update_node_BANG_ = (function threeagent$impl$virtual_scene$update_node_BANG_(scene,node,new_form,changelog){
threeagent.impl.util.$_BANG_.call(null,node,"dirty",false);

var render_fn = threeagent.impl.util.$.call(null,node,"render");
var rendered_form = (cljs.core.truth_(render_fn)?cljs.core.apply.call(null,render_fn,cljs.core.rest.call(null,new_form)):new_form);
var old_form = threeagent.impl.util.$.call(null,node,"rendered-form");
if(cljs.core.not_EQ_.call(null,rendered_form,old_form)){
var key = threeagent.impl.util.$.call(null,node,"key");
var children = threeagent.impl.util.$.call(null,node,"children");
var old_data = threeagent.impl.util.$.call(null,node,"data");
var shallow_node = threeagent.impl.virtual_scene.__GT_node_shallow.call(null,key,rendered_form);
var new_data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(shallow_node);
var current_keys = cljs.core.set.call(null,cljs.core.es6_iterator_seq.call(null,children.keys()));
var new_keys = cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.first,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node)));
var dropped_keys = clojure.set.difference.call(null,current_keys,new_keys);
threeagent.impl.util.$_BANG_.call(null,node,"data",new_data);

if(cljs.core.truth_(render_fn)){
threeagent.impl.util.$_BANG_.call(null,node,"form",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [render_fn], null),cljs.core.rest.call(null,new_form)));
} else {
}

threeagent.impl.util.$_BANG_.call(null,node,"rendered-form",new_form);

changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"update","update",1045576396),old_data,new_data], null));

var seq__22189_22203 = cljs.core.seq.call(null,dropped_keys);
var chunk__22190_22204 = null;
var count__22191_22205 = (0);
var i__22192_22206 = (0);
while(true){
if((i__22192_22206 < count__22191_22205)){
var child_key_22207 = cljs.core._nth.call(null,chunk__22190_22204,i__22192_22206);
var child_node_22208 = children.get(child_key_22207);
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,child_node_22208,changelog);

children.delete(child_key_22207);


var G__22209 = seq__22189_22203;
var G__22210 = chunk__22190_22204;
var G__22211 = count__22191_22205;
var G__22212 = (i__22192_22206 + (1));
seq__22189_22203 = G__22209;
chunk__22190_22204 = G__22210;
count__22191_22205 = G__22211;
i__22192_22206 = G__22212;
continue;
} else {
var temp__5457__auto___22213 = cljs.core.seq.call(null,seq__22189_22203);
if(temp__5457__auto___22213){
var seq__22189_22214__$1 = temp__5457__auto___22213;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22189_22214__$1)){
var c__4461__auto___22215 = cljs.core.chunk_first.call(null,seq__22189_22214__$1);
var G__22216 = cljs.core.chunk_rest.call(null,seq__22189_22214__$1);
var G__22217 = c__4461__auto___22215;
var G__22218 = cljs.core.count.call(null,c__4461__auto___22215);
var G__22219 = (0);
seq__22189_22203 = G__22216;
chunk__22190_22204 = G__22217;
count__22191_22205 = G__22218;
i__22192_22206 = G__22219;
continue;
} else {
var child_key_22220 = cljs.core.first.call(null,seq__22189_22214__$1);
var child_node_22221 = children.get(child_key_22220);
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,child_node_22221,changelog);

children.delete(child_key_22220);


var G__22222 = cljs.core.next.call(null,seq__22189_22214__$1);
var G__22223 = null;
var G__22224 = (0);
var G__22225 = (0);
seq__22189_22203 = G__22222;
chunk__22190_22204 = G__22223;
count__22191_22205 = G__22224;
i__22192_22206 = G__22225;
continue;
}
} else {
}
}
break;
}

var seq__22193 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node));
var chunk__22194 = null;
var count__22195 = (0);
var i__22196 = (0);
while(true){
if((i__22196 < count__22195)){
var vec__22197 = cljs.core._nth.call(null,chunk__22194,i__22196);
var child_key = cljs.core.nth.call(null,vec__22197,(0),null);
var child_form = cljs.core.nth.call(null,vec__22197,(1),null);
var temp__5455__auto___22226 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___22226)){
var child_22227 = temp__5455__auto___22226;
threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,child_22227,child_form,changelog);
} else {
var temp__5457__auto___22228 = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___22228)){
var child_node_22229 = temp__5457__auto___22228;
children.set(child_key,child_node_22229);
} else {
}
}


var G__22230 = seq__22193;
var G__22231 = chunk__22194;
var G__22232 = count__22195;
var G__22233 = (i__22196 + (1));
seq__22193 = G__22230;
chunk__22194 = G__22231;
count__22195 = G__22232;
i__22196 = G__22233;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22193);
if(temp__5457__auto__){
var seq__22193__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22193__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__22193__$1);
var G__22234 = cljs.core.chunk_rest.call(null,seq__22193__$1);
var G__22235 = c__4461__auto__;
var G__22236 = cljs.core.count.call(null,c__4461__auto__);
var G__22237 = (0);
seq__22193 = G__22234;
chunk__22194 = G__22235;
count__22195 = G__22236;
i__22196 = G__22237;
continue;
} else {
var vec__22200 = cljs.core.first.call(null,seq__22193__$1);
var child_key = cljs.core.nth.call(null,vec__22200,(0),null);
var child_form = cljs.core.nth.call(null,vec__22200,(1),null);
var temp__5455__auto___22238 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___22238)){
var child_22239 = temp__5455__auto___22238;
threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,child_22239,child_form,changelog);
} else {
var temp__5457__auto___22240__$1 = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___22240__$1)){
var child_node_22241 = temp__5457__auto___22240__$1;
children.set(child_key,child_node_22241);
} else {
}
}


var G__22242 = cljs.core.next.call(null,seq__22193__$1);
var G__22243 = null;
var G__22244 = (0);
var G__22245 = (0);
seq__22193 = G__22242;
chunk__22194 = G__22243;
count__22195 = G__22244;
i__22196 = G__22245;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
threeagent.impl.virtual_scene.render_node_BANG_ = (function threeagent$impl$virtual_scene$render_node_BANG_(scene,node,changelog){
var form = threeagent.impl.util.$.call(null,node,"form");
return threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,node,form,changelog);
});
threeagent.impl.virtual_scene.render_BANG_ = (function threeagent$impl$virtual_scene$render_BANG_(scene,changelog){
reagent.ratom.flush_BANG_.call(null);

var queue = threeagent.impl.util.$.call(null,scene,"render_queue");
var node = queue.dequeue();
while(true){
if(cljs.core.truth_(node)){
if(cljs.core.truth_(threeagent.impl.util.$.call(null,node,"dirty"))){
threeagent.impl.virtual_scene.render_node_BANG_.call(null,scene,node,changelog);
} else {
}

var G__22246 = queue.dequeue();
node = G__22246;
continue;
} else {
return null;
}
break;
}
});
threeagent.impl.virtual_scene.destroy_BANG_ = (function threeagent$impl$virtual_scene$destroy_BANG_(scene){
return threeagent.impl.virtual_scene.dispose_node_BANG_.call(null,threeagent.impl.util.$.call(null,scene,"root"));
});
threeagent.impl.virtual_scene.create = (function threeagent$impl$virtual_scene$create(root_fn){
var scene = (new threeagent.impl.virtual_scene.Scene(null,(new goog.structs.PriorityQueue())));
var root_node = threeagent.impl.virtual_scene.__GT_node.call(null,scene,null,(0),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root_fn], null));
threeagent.impl.util.$_BANG_.call(null,scene,"root",root_node);

return scene;
});

//# sourceMappingURL=virtual_scene.js.map?rel=1547522444086
