// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.impl.scene');
goog.require('cljs.core');
goog.require('threeagent.impl.virtual_scene');
goog.require('threeagent.impl.util');
goog.require('threeagent.impl.threejs');
goog.require('threeagent.impl.component');
goog.require('cljs.core');
threeagent.impl.scene.create_object = (function threeagent$impl$scene$create_object(node_data){
var comp_config = new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(node_data);
var obj = threeagent.impl.component.render_component.call(null,new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node_data),comp_config);
threeagent.impl.threejs.set_position_BANG_.call(null,obj,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(node_data));

threeagent.impl.threejs.set_rotation_BANG_.call(null,obj,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(node_data));

threeagent.impl.threejs.set_scale_BANG_.call(null,obj,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(node_data));

return obj;
});
threeagent.impl.scene.set_node_object = (function threeagent$impl$scene$set_node_object(context,node,node_data,obj){
threeagent.impl.util.$_BANG_.call(null,node,"threejs",obj);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"camera","camera",-1190348585),new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node_data))){
return threeagent.impl.util.$_BANG_.call(null,context,"camera",obj);
} else {
return null;
}
});
threeagent.impl.scene.add_node = (function threeagent$impl$scene$add_node(context,parent_object,node){
var node_data = threeagent.impl.util.$.call(null,node,"data");
var comp_config = new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(node_data);
var obj = threeagent.impl.scene.create_object.call(null,node_data);
threeagent.impl.scene.set_node_object.call(null,context,node,node_data,obj);

parent_object.add(obj);

node.for_each_child(cljs.core.partial.call(null,threeagent.impl.scene.add_node,context,obj));

var temp__5457__auto___22518 = new cljs.core.Keyword(null,"on-added","on-added",-54041858).cljs$core$IFn$_invoke$arity$1(threeagent.impl.util.$.call(null,node,"meta"));
if(cljs.core.truth_(temp__5457__auto___22518)){
var callback_22519 = temp__5457__auto___22518;
callback_22519.call(null,obj);
} else {
}

return obj;
});
threeagent.impl.scene.remove_node_BANG_ = (function threeagent$impl$scene$remove_node_BANG_(node){
var obj = threeagent.impl.util.$.call(null,node,"threejs");
var parent_obj = threeagent.impl.util.$.call(null,threeagent.impl.util.$.call(null,node,"parent"),"threejs");
var temp__5457__auto___22520 = new cljs.core.Keyword(null,"on-removed","on-removed",-1308728142).cljs$core$IFn$_invoke$arity$1(threeagent.impl.util.$.call(null,node,"meta"));
if(cljs.core.truth_(temp__5457__auto___22520)){
var callback_22521 = temp__5457__auto___22520;
callback_22521.call(null,obj);
} else {
}

parent_obj.remove(obj);

return node.for_each_child(threeagent.impl.scene.remove_node_BANG_);
});
threeagent.impl.scene.init_scene = (function threeagent$impl$scene$init_scene(context,virtual_scene,scene_root){
return threeagent.impl.scene.add_node.call(null,context,scene_root,threeagent.impl.util.$.call(null,virtual_scene,"root"));
});
threeagent.impl.scene.diff_data = (function threeagent$impl$scene$diff_data(o,n){
var this$ = ((((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(n))) || (cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(n)))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o,n], null):null);
var position = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(n):null);
var rotation = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(n):null);
var scale = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(n):null);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"this","this",-611633625),this$,new cljs.core.Keyword(null,"scale","scale",-230427353),scale,new cljs.core.Keyword(null,"position","position",-2011731912),position,new cljs.core.Keyword(null,"rotation","rotation",-1728051644),rotation], null);
});
threeagent.impl.scene.update_node_BANG_ = (function threeagent$impl$scene$update_node_BANG_(context,node,old_data,new_data){
var diff = threeagent.impl.scene.diff_data.call(null,old_data,new_data);
var old_obj = threeagent.impl.util.$.call(null,node,"threejs");
var metadata = threeagent.impl.util.$.call(null,node,"meta");
var this$ = new cljs.core.Keyword(null,"this","this",-611633625).cljs$core$IFn$_invoke$arity$1(diff);
if(cljs.core.truth_(this$)){
var vec__22522 = this$;
var o = cljs.core.nth.call(null,vec__22522,(0),null);
var n = cljs.core.nth.call(null,vec__22522,(1),null);
var parent_obj = threeagent.impl.util.$.call(null,old_obj,"parent");
var children = threeagent.impl.util.$.call(null,old_obj,"children");
var new_obj = threeagent.impl.scene.create_object.call(null,new_data);
var temp__5457__auto___22529 = new cljs.core.Keyword(null,"on-removed","on-removed",-1308728142).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(temp__5457__auto___22529)){
var callback_22530 = temp__5457__auto___22529;
callback_22530.call(null,old_obj);
} else {
}

threeagent.impl.scene.set_node_object.call(null,context,node,new_data,new_obj);

parent_obj.remove(old_obj);

parent_obj.add(new_obj);

var seq__22525_22531 = cljs.core.seq.call(null,children);
var chunk__22526_22532 = null;
var count__22527_22533 = (0);
var i__22528_22534 = (0);
while(true){
if((i__22528_22534 < count__22527_22533)){
var child_22535 = cljs.core._nth.call(null,chunk__22526_22532,i__22528_22534);
new_obj.add(child_22535);


var G__22536 = seq__22525_22531;
var G__22537 = chunk__22526_22532;
var G__22538 = count__22527_22533;
var G__22539 = (i__22528_22534 + (1));
seq__22525_22531 = G__22536;
chunk__22526_22532 = G__22537;
count__22527_22533 = G__22538;
i__22528_22534 = G__22539;
continue;
} else {
var temp__5457__auto___22540 = cljs.core.seq.call(null,seq__22525_22531);
if(temp__5457__auto___22540){
var seq__22525_22541__$1 = temp__5457__auto___22540;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22525_22541__$1)){
var c__4461__auto___22542 = cljs.core.chunk_first.call(null,seq__22525_22541__$1);
var G__22543 = cljs.core.chunk_rest.call(null,seq__22525_22541__$1);
var G__22544 = c__4461__auto___22542;
var G__22545 = cljs.core.count.call(null,c__4461__auto___22542);
var G__22546 = (0);
seq__22525_22531 = G__22543;
chunk__22526_22532 = G__22544;
count__22527_22533 = G__22545;
i__22528_22534 = G__22546;
continue;
} else {
var child_22547 = cljs.core.first.call(null,seq__22525_22541__$1);
new_obj.add(child_22547);


var G__22548 = cljs.core.next.call(null,seq__22525_22541__$1);
var G__22549 = null;
var G__22550 = (0);
var G__22551 = (0);
seq__22525_22531 = G__22548;
chunk__22526_22532 = G__22549;
count__22527_22533 = G__22550;
i__22528_22534 = G__22551;
continue;
}
} else {
}
}
break;
}

var temp__5457__auto__ = new cljs.core.Keyword(null,"on-added","on-added",-54041858).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(temp__5457__auto__)){
var callback = temp__5457__auto__;
return callback.call(null,new_obj);
} else {
return null;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(diff))){
threeagent.impl.threejs.set_position_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(diff));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(diff))){
threeagent.impl.threejs.set_rotation_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(diff));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(diff))){
return threeagent.impl.threejs.set_scale_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(diff));
} else {
return null;
}
}
});
threeagent.impl.scene.apply_change_BANG_ = (function threeagent$impl$scene$apply_change_BANG_(context,p__22552){
var vec__22553 = p__22552;
var node = cljs.core.nth.call(null,vec__22553,(0),null);
var action = cljs.core.nth.call(null,vec__22553,(1),null);
var old = cljs.core.nth.call(null,vec__22553,(2),null);
var new$ = cljs.core.nth.call(null,vec__22553,(3),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"add","add",235287739),action)){
return threeagent.impl.scene.add_node.call(null,context,threeagent.impl.util.$.call(null,threeagent.impl.util.$.call(null,node,"parent"),"threejs"),node);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"remove","remove",-131428414),action)){
return threeagent.impl.scene.remove_node_BANG_.call(null,node);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"update","update",1045576396),action)){
return threeagent.impl.scene.update_node_BANG_.call(null,context,node,old,new$);
} else {
return null;
}
}
}
});
threeagent.impl.scene.apply_virtual_scene_changes_BANG_ = (function threeagent$impl$scene$apply_virtual_scene_changes_BANG_(context,changelog){
var seq__22556 = cljs.core.seq.call(null,changelog);
var chunk__22557 = null;
var count__22558 = (0);
var i__22559 = (0);
while(true){
if((i__22559 < count__22558)){
var change = cljs.core._nth.call(null,chunk__22557,i__22559);
threeagent.impl.scene.apply_change_BANG_.call(null,context,change);


var G__22560 = seq__22556;
var G__22561 = chunk__22557;
var G__22562 = count__22558;
var G__22563 = (i__22559 + (1));
seq__22556 = G__22560;
chunk__22557 = G__22561;
count__22558 = G__22562;
i__22559 = G__22563;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22556);
if(temp__5457__auto__){
var seq__22556__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22556__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__22556__$1);
var G__22564 = cljs.core.chunk_rest.call(null,seq__22556__$1);
var G__22565 = c__4461__auto__;
var G__22566 = cljs.core.count.call(null,c__4461__auto__);
var G__22567 = (0);
seq__22556 = G__22564;
chunk__22557 = G__22565;
count__22558 = G__22566;
i__22559 = G__22567;
continue;
} else {
var change = cljs.core.first.call(null,seq__22556__$1);
threeagent.impl.scene.apply_change_BANG_.call(null,context,change);


var G__22568 = cljs.core.next.call(null,seq__22556__$1);
var G__22569 = null;
var G__22570 = (0);
var G__22571 = (0);
seq__22556 = G__22568;
chunk__22557 = G__22569;
count__22558 = G__22570;
i__22559 = G__22571;
continue;
}
} else {
return null;
}
}
break;
}
});
threeagent.impl.scene.animate = (function threeagent$impl$scene$animate(context){
var stats = threeagent.impl.util.$.call(null,context,"stats");
var clock = threeagent.impl.util.$.call(null,context,"clock");
var virtual_scene = threeagent.impl.util.$.call(null,context,"virtual-scene");
var renderer = threeagent.impl.util.$.call(null,context,"renderer");
var composer = threeagent.impl.util.$.call(null,context,"composer");
var camera = threeagent.impl.util.$.call(null,context,"camera");
var scene_root = threeagent.impl.util.$.call(null,context,"scene-root");
var before_render_cb = threeagent.impl.util.$.call(null,context,"before-render-cb");
if(cljs.core.truth_(stats)){
stats.begin();
} else {
}

var delta_time_22572 = clock.getDelta();
var changelog_22573 = [];
if(cljs.core.truth_(before_render_cb)){
before_render_cb.call(null,delta_time_22572);
} else {
}

threeagent.impl.virtual_scene.render_BANG_.call(null,virtual_scene,changelog_22573);

threeagent.impl.scene.apply_virtual_scene_changes_BANG_.call(null,context,changelog_22573);

if(cljs.core.truth_(composer)){
composer.render(delta_time_22572);
} else {
renderer.render(scene_root,camera);
}

if(cljs.core.truth_(stats)){
return stats.end();
} else {
return null;
}
});
threeagent.impl.scene.get_canvas = (function threeagent$impl$scene$get_canvas(dom_root){
if(cljs.core._EQ_.call(null,"canvas",clojure.string.lower_case.call(null,dom_root.tagName))){
return dom_root;
} else {
var c = document.createElement("canvas");
return dom_root.appendChild(c);
}
});
threeagent.impl.scene.create_camera = (function threeagent$impl$scene$create_camera(width,height,ortho_QMARK_){
if(cljs.core.truth_(ortho_QMARK_)){
return (new THREE.OrthographicCamera((width / -2.0),(width / 2.0),(height / 2.0),(height / -2.0),0.1,(1000)));
} else {
return (new THREE.PerspectiveCamera((75),(width / height),0.1,(1000)));
}
});
threeagent.impl.scene.create_context = (function threeagent$impl$scene$create_context(root_fn,dom_root,on_before_render_cb,ortho_camera_QMARK_,renderer_opts){
var canvas = threeagent.impl.scene.get_canvas.call(null,dom_root);
var width = canvas.offsetWidth;
var height = canvas.offsetHeight;
var virtual_scene = threeagent.impl.virtual_scene.create.call(null,root_fn);
var renderer = (new THREE.WebGLRenderer(cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,renderer_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"canvas","canvas",-1798817489),canvas], null)))));
var camera = threeagent.impl.scene.create_camera.call(null,width,height,ortho_camera_QMARK_);
var scene_root = (new THREE.Scene());
var composer = (((typeof POSTPROCESSING !== 'undefined'))?(new POSTPROCESSING.EffectComposer(renderer)):null);
var render_pass = (((typeof POSTPROCESSING !== 'undefined'))?(new POSTPROCESSING.RenderPass(scene_root,camera)):null);
renderer.setSize(width,height);

if(cljs.core.truth_(composer)){
threeagent.impl.util.$_BANG_.call(null,render_pass,"renderToScreen",true);

composer.addPass(render_pass);
} else {
}

var context = cljs.core.clj__GT_js.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"virtual-scene","virtual-scene",43369577),new cljs.core.Keyword(null,"scene-root","scene-root",-2114916885),new cljs.core.Keyword(null,"canvas","canvas",-1798817489),new cljs.core.Keyword(null,"renderer","renderer",336841071),new cljs.core.Keyword(null,"composer","composer",-1616081356),new cljs.core.Keyword(null,"camera","camera",-1190348585),new cljs.core.Keyword(null,"clock","clock",-894301127),new cljs.core.Keyword(null,"before-render-cb","before-render-cb",229389916),new cljs.core.Keyword(null,"stats","stats",-85643011)],[virtual_scene,scene_root,canvas,renderer,composer,camera,(new THREE.Clock()),on_before_render_cb,(((typeof Stats !== 'undefined'))?(new Stats()):null)]));
threeagent.impl.scene.init_scene.call(null,context,virtual_scene,scene_root);

if(cljs.core.truth_(context.stats)){
context.stats.showPanel((1));

document.body.appendChild(context.stats.dom);
} else {
}

threeagent.impl.util.$_BANG_.call(null,context,"animate-fn",((function (context,canvas,width,height,virtual_scene,renderer,camera,scene_root,composer,render_pass){
return (function (){
return threeagent.impl.scene.animate.call(null,context);
});})(context,canvas,width,height,virtual_scene,renderer,camera,scene_root,composer,render_pass))
);

return context;
});
threeagent.impl.scene.remove_all_children_BANG_ = (function threeagent$impl$scene$remove_all_children_BANG_(obj){
var seq__22574 = cljs.core.seq.call(null,threeagent.impl.util.$.call(null,obj,"children"));
var chunk__22575 = null;
var count__22576 = (0);
var i__22577 = (0);
while(true){
if((i__22577 < count__22576)){
var child = cljs.core._nth.call(null,chunk__22575,i__22577);
obj.remove(child);


var G__22578 = seq__22574;
var G__22579 = chunk__22575;
var G__22580 = count__22576;
var G__22581 = (i__22577 + (1));
seq__22574 = G__22578;
chunk__22575 = G__22579;
count__22576 = G__22580;
i__22577 = G__22581;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22574);
if(temp__5457__auto__){
var seq__22574__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22574__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__22574__$1);
var G__22582 = cljs.core.chunk_rest.call(null,seq__22574__$1);
var G__22583 = c__4461__auto__;
var G__22584 = cljs.core.count.call(null,c__4461__auto__);
var G__22585 = (0);
seq__22574 = G__22582;
chunk__22575 = G__22583;
count__22576 = G__22584;
i__22577 = G__22585;
continue;
} else {
var child = cljs.core.first.call(null,seq__22574__$1);
obj.remove(child);


var G__22586 = cljs.core.next.call(null,seq__22574__$1);
var G__22587 = null;
var G__22588 = (0);
var G__22589 = (0);
seq__22574 = G__22586;
chunk__22575 = G__22587;
count__22576 = G__22588;
i__22577 = G__22589;
continue;
}
} else {
return null;
}
}
break;
}
});
threeagent.impl.scene.reset_scene_BANG_ = (function threeagent$impl$scene$reset_scene_BANG_(scene,root_fn,p__22590){
var map__22591 = p__22590;
var map__22591__$1 = (((((!((map__22591 == null))))?(((((map__22591.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22591.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22591):map__22591);
var on_before_render = cljs.core.get.call(null,map__22591__$1,new cljs.core.Keyword(null,"on-before-render","on-before-render",601463713));
var root = threeagent.impl.util.$.call(null,scene,"scene-root");
var virtual_scene = threeagent.impl.util.$.call(null,scene,"virtual-scene");
var new_virtual_scene = threeagent.impl.virtual_scene.create.call(null,root_fn);
threeagent.impl.scene.remove_all_children_BANG_.call(null,root);

threeagent.impl.virtual_scene.destroy_BANG_.call(null,virtual_scene);

threeagent.impl.scene.init_scene.call(null,scene,new_virtual_scene,root);

threeagent.impl.util.$_BANG_.call(null,scene,"virtual-scene",new_virtual_scene);

threeagent.impl.util.$_BANG_.call(null,scene,"before-render-cb",on_before_render);

return scene;
});
threeagent.impl.scene.render = (function threeagent$impl$scene$render(root_fn,dom_root,p__22593){
var map__22594 = p__22593;
var map__22594__$1 = (((((!((map__22594 == null))))?(((((map__22594.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22594.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22594):map__22594);
var on_before_render = cljs.core.get.call(null,map__22594__$1,new cljs.core.Keyword(null,"on-before-render","on-before-render",601463713));
var ortho_camera_QMARK_ = cljs.core.get.call(null,map__22594__$1,new cljs.core.Keyword(null,"ortho-camera?","ortho-camera?",-1828964318));
var renderer_opts = cljs.core.get.call(null,map__22594__$1,new cljs.core.Keyword(null,"renderer-opts","renderer-opts",650523720));
var context = threeagent.impl.scene.create_context.call(null,root_fn,dom_root,on_before_render,ortho_camera_QMARK_,renderer_opts);
var renderer = threeagent.impl.util.$.call(null,context,"renderer");
renderer.setAnimationLoop(threeagent.impl.util.$.call(null,context,"animate-fn"));

return context;
});

//# sourceMappingURL=scene.js.map?rel=1550945896962
