// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.impl.component');
goog.require('cljs.core');
goog.require('threeagent.impl.threejs');
threeagent.impl.component.component_registry = cljs.core.PersistentArrayMap.EMPTY;
threeagent.impl.component.register_component_renderer_BANG_ = (function threeagent$impl$component$register_component_renderer_BANG_(key,render_fn){
return threeagent.impl.component.component_registry = cljs.core.assoc.call(null,threeagent.impl.component.component_registry,key,render_fn);
});
threeagent.impl.component.render_component = (function threeagent$impl$component$render_component(key,config){
var renderer = cljs.core.get.call(null,threeagent.impl.component.component_registry,key);
if(cljs.core.truth_(renderer)){
return renderer.call(null,config);
} else {
return cljs.core.println.call(null,"Missing renderer for object type",key);
}
});
threeagent.impl.component.__GT_material = (function threeagent$impl$component$__GT_material(config){
if((config instanceof THREE.Material)){
return config;
} else {
return threeagent.impl.threejs.mesh_phong_material.call(null,config);
}
});
threeagent.impl.component.to_mesh = (function threeagent$impl$component$to_mesh(geo,material_config){
var mat = threeagent.impl.component.__GT_material.call(null,material_config);
return threeagent.impl.threejs.mesh.call(null,geo,mat);
});
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"object","object",1474613949),(function (c){
return threeagent.impl.threejs.object.call(null);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"group","group",582596132),(function (c){
return threeagent.impl.threejs.group.call(null);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"camera","camera",-1190348585),(function (p__24950){
var map__24951 = p__24950;
var map__24951__$1 = (((((!((map__24951 == null))))?(((((map__24951.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24951.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24951):map__24951);
var fov = cljs.core.get.call(null,map__24951__$1,new cljs.core.Keyword(null,"fov","fov",-12463282));
var aspectRatio = cljs.core.get.call(null,map__24951__$1,new cljs.core.Keyword(null,"aspectRatio","aspectRatio",-218867702));
var near = cljs.core.get.call(null,map__24951__$1,new cljs.core.Keyword(null,"near","near",-1077668328));
var far = cljs.core.get.call(null,map__24951__$1,new cljs.core.Keyword(null,"far","far",85807546));
return threeagent.impl.threejs.perspective_camera.call(null,fov,aspectRatio,near,far);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"instance","instance",-2121349050),(function (p__24953){
var map__24954 = p__24953;
var map__24954__$1 = (((((!((map__24954 == null))))?(((((map__24954.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24954.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24954):map__24954);
var object = cljs.core.get.call(null,map__24954__$1,new cljs.core.Keyword(null,"object","object",1474613949));
return object;
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"plane","plane",-223595224),(function (p__24956){
var map__24957 = p__24956;
var map__24957__$1 = (((((!((map__24957 == null))))?(((((map__24957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24957.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24957):map__24957);
var dims = cljs.core.get.call(null,map__24957__$1,new cljs.core.Keyword(null,"dims","dims",-466522889));
var segment_dims = cljs.core.get.call(null,map__24957__$1,new cljs.core.Keyword(null,"segment-dims","segment-dims",1394305588));
var material = cljs.core.get.call(null,map__24957__$1,new cljs.core.Keyword(null,"material","material",460118677));
var vec__24959 = dims;
var w = cljs.core.nth.call(null,vec__24959,(0),null);
var h = cljs.core.nth.call(null,vec__24959,(1),null);
var vec__24962 = segment_dims;
var sw = cljs.core.nth.call(null,vec__24962,(0),null);
var sh = cljs.core.nth.call(null,vec__24962,(1),null);
var geo = threeagent.impl.threejs.plane_geometry.call(null,w,h,sw,sh);
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"box","box",1530920394),(function (p__24965){
var map__24966 = p__24965;
var map__24966__$1 = (((((!((map__24966 == null))))?(((((map__24966.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24966.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24966):map__24966);
var dims = cljs.core.get.call(null,map__24966__$1,new cljs.core.Keyword(null,"dims","dims",-466522889));
var material = cljs.core.get.call(null,map__24966__$1,new cljs.core.Keyword(null,"material","material",460118677));
var vec__24968 = dims;
var x = cljs.core.nth.call(null,vec__24968,(0),null);
var y = cljs.core.nth.call(null,vec__24968,(1),null);
var z = cljs.core.nth.call(null,vec__24968,(2),null);
var geo = threeagent.impl.threejs.box_geometry.call(null,x,y,z);
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"sphere","sphere",384337120),(function (p__24971){
var map__24972 = p__24971;
var map__24972__$1 = (((((!((map__24972 == null))))?(((((map__24972.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24972.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24972):map__24972);
var radius = cljs.core.get.call(null,map__24972__$1,new cljs.core.Keyword(null,"radius","radius",-2073122258));
var width_segments = cljs.core.get.call(null,map__24972__$1,new cljs.core.Keyword(null,"width-segments","width-segments",25187827));
var height_segments = cljs.core.get.call(null,map__24972__$1,new cljs.core.Keyword(null,"height-segments","height-segments",1831894149));
var material = cljs.core.get.call(null,map__24972__$1,new cljs.core.Keyword(null,"material","material",460118677));
var geo = threeagent.impl.threejs.sphere_geometry.call(null,radius,(function (){var or__4047__auto__ = width_segments;
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return (12);
}
})(),(function (){var or__4047__auto__ = height_segments;
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return (12);
}
})());
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"point-light","point-light",669926690),(function (p__24974){
var map__24975 = p__24974;
var map__24975__$1 = (((((!((map__24975 == null))))?(((((map__24975.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24975.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24975):map__24975);
var color = cljs.core.get.call(null,map__24975__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var intensity = cljs.core.get.call(null,map__24975__$1,new cljs.core.Keyword(null,"intensity","intensity",1142770863));
var distance = cljs.core.get.call(null,map__24975__$1,new cljs.core.Keyword(null,"distance","distance",-1671893894));
return threeagent.impl.threejs.point_light.call(null,color,intensity,distance);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"hemisphere-light","hemisphere-light",-1569111131),(function (p__24977){
var map__24978 = p__24977;
var map__24978__$1 = (((((!((map__24978 == null))))?(((((map__24978.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24978.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24978):map__24978);
var sky_color = cljs.core.get.call(null,map__24978__$1,new cljs.core.Keyword(null,"sky-color","sky-color",1803548607));
var ground_color = cljs.core.get.call(null,map__24978__$1,new cljs.core.Keyword(null,"ground-color","ground-color",-1832095873));
var intensity = cljs.core.get.call(null,map__24978__$1,new cljs.core.Keyword(null,"intensity","intensity",1142770863));
return threeagent.impl.threejs.hemisphere_light.call(null,sky_color,ground_color,intensity);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"directional-light","directional-light",1424371138),(function (p__24980){
var map__24981 = p__24980;
var map__24981__$1 = (((((!((map__24981 == null))))?(((((map__24981.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24981.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24981):map__24981);
var color = cljs.core.get.call(null,map__24981__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var intensity = cljs.core.get.call(null,map__24981__$1,new cljs.core.Keyword(null,"intensity","intensity",1142770863));
return threeagent.impl.threejs.directional_light.call(null,color,intensity);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),(function (p__24983){
var map__24984 = p__24983;
var map__24984__$1 = (((((!((map__24984 == null))))?(((((map__24984.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24984.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24984):map__24984);
var cfg = map__24984__$1;
var text = cljs.core.get.call(null,map__24984__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var material = cljs.core.get.call(null,map__24984__$1,new cljs.core.Keyword(null,"material","material",460118677));
var geo = threeagent.impl.threejs.text_geometry.call(null,text,cfg);
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));

//# sourceMappingURL=component.js.map
