// Compiled by ClojureScript 1.10.439 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined')){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__4047__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372))));
if(or__4047__auto__){
return or__4047__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__4047__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
var or__4047__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__4047__auto____$1)){
return or__4047__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__28224_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__28224_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependency_data !== 'undefined')){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__28225 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__28226 = null;
var count__28227 = (0);
var i__28228 = (0);
while(true){
if((i__28228 < count__28227)){
var n = cljs.core._nth.call(null,chunk__28226,i__28228);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__28229 = seq__28225;
var G__28230 = chunk__28226;
var G__28231 = count__28227;
var G__28232 = (i__28228 + (1));
seq__28225 = G__28229;
chunk__28226 = G__28230;
count__28227 = G__28231;
i__28228 = G__28232;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__28225);
if(temp__5457__auto__){
var seq__28225__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28225__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__28225__$1);
var G__28233 = cljs.core.chunk_rest.call(null,seq__28225__$1);
var G__28234 = c__4461__auto__;
var G__28235 = cljs.core.count.call(null,c__4461__auto__);
var G__28236 = (0);
seq__28225 = G__28233;
chunk__28226 = G__28234;
count__28227 = G__28235;
i__28228 = G__28236;
continue;
} else {
var n = cljs.core.first.call(null,seq__28225__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__28237 = cljs.core.next.call(null,seq__28225__$1);
var G__28238 = null;
var G__28239 = (0);
var G__28240 = (0);
seq__28225 = G__28237;
chunk__28226 = G__28238;
count__28227 = G__28239;
i__28228 = G__28240;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__28241){
var vec__28242 = p__28241;
var _ = cljs.core.nth.call(null,vec__28242,(0),null);
var v = cljs.core.nth.call(null,vec__28242,(1),null);
var and__4036__auto__ = v;
if(cljs.core.truth_(and__4036__auto__)){
return v.call(null,dep);
} else {
return and__4036__auto__;
}
}),cljs.core.filter.call(null,(function (p__28245){
var vec__28246 = p__28245;
var k = cljs.core.nth.call(null,vec__28246,(0),null);
var v = cljs.core.nth.call(null,vec__28246,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__28258_28266 = cljs.core.seq.call(null,deps);
var chunk__28259_28267 = null;
var count__28260_28268 = (0);
var i__28261_28269 = (0);
while(true){
if((i__28261_28269 < count__28260_28268)){
var dep_28270 = cljs.core._nth.call(null,chunk__28259_28267,i__28261_28269);
if(cljs.core.truth_((function (){var and__4036__auto__ = dep_28270;
if(cljs.core.truth_(and__4036__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_28270));
} else {
return and__4036__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_28270,(depth + (1)),state);
} else {
}


var G__28271 = seq__28258_28266;
var G__28272 = chunk__28259_28267;
var G__28273 = count__28260_28268;
var G__28274 = (i__28261_28269 + (1));
seq__28258_28266 = G__28271;
chunk__28259_28267 = G__28272;
count__28260_28268 = G__28273;
i__28261_28269 = G__28274;
continue;
} else {
var temp__5457__auto___28275 = cljs.core.seq.call(null,seq__28258_28266);
if(temp__5457__auto___28275){
var seq__28258_28276__$1 = temp__5457__auto___28275;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28258_28276__$1)){
var c__4461__auto___28277 = cljs.core.chunk_first.call(null,seq__28258_28276__$1);
var G__28278 = cljs.core.chunk_rest.call(null,seq__28258_28276__$1);
var G__28279 = c__4461__auto___28277;
var G__28280 = cljs.core.count.call(null,c__4461__auto___28277);
var G__28281 = (0);
seq__28258_28266 = G__28278;
chunk__28259_28267 = G__28279;
count__28260_28268 = G__28280;
i__28261_28269 = G__28281;
continue;
} else {
var dep_28282 = cljs.core.first.call(null,seq__28258_28276__$1);
if(cljs.core.truth_((function (){var and__4036__auto__ = dep_28282;
if(cljs.core.truth_(and__4036__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_28282));
} else {
return and__4036__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_28282,(depth + (1)),state);
} else {
}


var G__28283 = cljs.core.next.call(null,seq__28258_28276__$1);
var G__28284 = null;
var G__28285 = (0);
var G__28286 = (0);
seq__28258_28266 = G__28283;
chunk__28259_28267 = G__28284;
count__28260_28268 = G__28285;
i__28261_28269 = G__28286;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__28262){
var vec__28263 = p__28262;
var seq__28264 = cljs.core.seq.call(null,vec__28263);
var first__28265 = cljs.core.first.call(null,seq__28264);
var seq__28264__$1 = cljs.core.next.call(null,seq__28264);
var x = first__28265;
var xs = seq__28264__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__28263,seq__28264,first__28265,seq__28264__$1,x,xs,get_deps__$1){
return (function (p1__28249_SHARP_){
return clojure.set.difference.call(null,p1__28249_SHARP_,x);
});})(vec__28263,seq__28264,first__28265,seq__28264__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__28287 = cljs.core.seq.call(null,provides);
var chunk__28288 = null;
var count__28289 = (0);
var i__28290 = (0);
while(true){
if((i__28290 < count__28289)){
var prov = cljs.core._nth.call(null,chunk__28288,i__28290);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__28291_28299 = cljs.core.seq.call(null,requires);
var chunk__28292_28300 = null;
var count__28293_28301 = (0);
var i__28294_28302 = (0);
while(true){
if((i__28294_28302 < count__28293_28301)){
var req_28303 = cljs.core._nth.call(null,chunk__28292_28300,i__28294_28302);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_28303,prov);


var G__28304 = seq__28291_28299;
var G__28305 = chunk__28292_28300;
var G__28306 = count__28293_28301;
var G__28307 = (i__28294_28302 + (1));
seq__28291_28299 = G__28304;
chunk__28292_28300 = G__28305;
count__28293_28301 = G__28306;
i__28294_28302 = G__28307;
continue;
} else {
var temp__5457__auto___28308 = cljs.core.seq.call(null,seq__28291_28299);
if(temp__5457__auto___28308){
var seq__28291_28309__$1 = temp__5457__auto___28308;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28291_28309__$1)){
var c__4461__auto___28310 = cljs.core.chunk_first.call(null,seq__28291_28309__$1);
var G__28311 = cljs.core.chunk_rest.call(null,seq__28291_28309__$1);
var G__28312 = c__4461__auto___28310;
var G__28313 = cljs.core.count.call(null,c__4461__auto___28310);
var G__28314 = (0);
seq__28291_28299 = G__28311;
chunk__28292_28300 = G__28312;
count__28293_28301 = G__28313;
i__28294_28302 = G__28314;
continue;
} else {
var req_28315 = cljs.core.first.call(null,seq__28291_28309__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_28315,prov);


var G__28316 = cljs.core.next.call(null,seq__28291_28309__$1);
var G__28317 = null;
var G__28318 = (0);
var G__28319 = (0);
seq__28291_28299 = G__28316;
chunk__28292_28300 = G__28317;
count__28293_28301 = G__28318;
i__28294_28302 = G__28319;
continue;
}
} else {
}
}
break;
}


var G__28320 = seq__28287;
var G__28321 = chunk__28288;
var G__28322 = count__28289;
var G__28323 = (i__28290 + (1));
seq__28287 = G__28320;
chunk__28288 = G__28321;
count__28289 = G__28322;
i__28290 = G__28323;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__28287);
if(temp__5457__auto__){
var seq__28287__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28287__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__28287__$1);
var G__28324 = cljs.core.chunk_rest.call(null,seq__28287__$1);
var G__28325 = c__4461__auto__;
var G__28326 = cljs.core.count.call(null,c__4461__auto__);
var G__28327 = (0);
seq__28287 = G__28324;
chunk__28288 = G__28325;
count__28289 = G__28326;
i__28290 = G__28327;
continue;
} else {
var prov = cljs.core.first.call(null,seq__28287__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__28295_28328 = cljs.core.seq.call(null,requires);
var chunk__28296_28329 = null;
var count__28297_28330 = (0);
var i__28298_28331 = (0);
while(true){
if((i__28298_28331 < count__28297_28330)){
var req_28332 = cljs.core._nth.call(null,chunk__28296_28329,i__28298_28331);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_28332,prov);


var G__28333 = seq__28295_28328;
var G__28334 = chunk__28296_28329;
var G__28335 = count__28297_28330;
var G__28336 = (i__28298_28331 + (1));
seq__28295_28328 = G__28333;
chunk__28296_28329 = G__28334;
count__28297_28330 = G__28335;
i__28298_28331 = G__28336;
continue;
} else {
var temp__5457__auto___28337__$1 = cljs.core.seq.call(null,seq__28295_28328);
if(temp__5457__auto___28337__$1){
var seq__28295_28338__$1 = temp__5457__auto___28337__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28295_28338__$1)){
var c__4461__auto___28339 = cljs.core.chunk_first.call(null,seq__28295_28338__$1);
var G__28340 = cljs.core.chunk_rest.call(null,seq__28295_28338__$1);
var G__28341 = c__4461__auto___28339;
var G__28342 = cljs.core.count.call(null,c__4461__auto___28339);
var G__28343 = (0);
seq__28295_28328 = G__28340;
chunk__28296_28329 = G__28341;
count__28297_28330 = G__28342;
i__28298_28331 = G__28343;
continue;
} else {
var req_28344 = cljs.core.first.call(null,seq__28295_28338__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_28344,prov);


var G__28345 = cljs.core.next.call(null,seq__28295_28338__$1);
var G__28346 = null;
var G__28347 = (0);
var G__28348 = (0);
seq__28295_28328 = G__28345;
chunk__28296_28329 = G__28346;
count__28297_28330 = G__28347;
i__28298_28331 = G__28348;
continue;
}
} else {
}
}
break;
}


var G__28349 = cljs.core.next.call(null,seq__28287__$1);
var G__28350 = null;
var G__28351 = (0);
var G__28352 = (0);
seq__28287 = G__28349;
chunk__28288 = G__28350;
count__28289 = G__28351;
i__28290 = G__28352;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__28353_28357 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__28354_28358 = null;
var count__28355_28359 = (0);
var i__28356_28360 = (0);
while(true){
if((i__28356_28360 < count__28355_28359)){
var ns_28361 = cljs.core._nth.call(null,chunk__28354_28358,i__28356_28360);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_28361);


var G__28362 = seq__28353_28357;
var G__28363 = chunk__28354_28358;
var G__28364 = count__28355_28359;
var G__28365 = (i__28356_28360 + (1));
seq__28353_28357 = G__28362;
chunk__28354_28358 = G__28363;
count__28355_28359 = G__28364;
i__28356_28360 = G__28365;
continue;
} else {
var temp__5457__auto___28366 = cljs.core.seq.call(null,seq__28353_28357);
if(temp__5457__auto___28366){
var seq__28353_28367__$1 = temp__5457__auto___28366;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28353_28367__$1)){
var c__4461__auto___28368 = cljs.core.chunk_first.call(null,seq__28353_28367__$1);
var G__28369 = cljs.core.chunk_rest.call(null,seq__28353_28367__$1);
var G__28370 = c__4461__auto___28368;
var G__28371 = cljs.core.count.call(null,c__4461__auto___28368);
var G__28372 = (0);
seq__28353_28357 = G__28369;
chunk__28354_28358 = G__28370;
count__28355_28359 = G__28371;
i__28356_28360 = G__28372;
continue;
} else {
var ns_28373 = cljs.core.first.call(null,seq__28353_28367__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_28373);


var G__28374 = cljs.core.next.call(null,seq__28353_28367__$1);
var G__28375 = null;
var G__28376 = (0);
var G__28377 = (0);
seq__28353_28357 = G__28374;
chunk__28354_28358 = G__28375;
count__28355_28359 = G__28376;
i__28356_28360 = G__28377;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__4047__auto__ = goog.require__;
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__28378__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__28378 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__28379__i = 0, G__28379__a = new Array(arguments.length -  0);
while (G__28379__i < G__28379__a.length) {G__28379__a[G__28379__i] = arguments[G__28379__i + 0]; ++G__28379__i;}
  args = new cljs.core.IndexedSeq(G__28379__a,0,null);
} 
return G__28378__delegate.call(this,args);};
G__28378.cljs$lang$maxFixedArity = 0;
G__28378.cljs$lang$applyTo = (function (arglist__28380){
var args = cljs.core.seq(arglist__28380);
return G__28378__delegate(args);
});
G__28378.cljs$core$IFn$_invoke$arity$variadic = G__28378__delegate;
return G__28378;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined')){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = (((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.safeLoad !== 'undefined'))?(function (p1__28381_SHARP_,p2__28382_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__28381_SHARP_)),p2__28382_SHARP_);
}):(((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.load !== 'undefined'))?(function (p1__28383_SHARP_,p2__28384_SHARP_){
return goog.net.jsloader.load(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__28383_SHARP_),p2__28384_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__28385 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__28385.addCallback(((function (G__28385){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__28385))
);

G__28385.addErrback(((function (G__28385){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__28385))
);

return G__28385;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e28386){if((e28386 instanceof Error)){
var e = e28386;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e28386;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e28387){if((e28387 instanceof Error)){
var e = e28387;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e28387;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__28388 = cljs.core._EQ_;
var expr__28389 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__28388.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__28389))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__28388.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__28389))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__28388.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__28389))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__28388,expr__28389){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__28388,expr__28389))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__28391,callback){
var map__28392 = p__28391;
var map__28392__$1 = (((((!((map__28392 == null))))?(((((map__28392.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28392.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28392):map__28392);
var file_msg = map__28392__$1;
var request_url = cljs.core.get.call(null,map__28392__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__4047__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__28392,map__28392__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__28392,map__28392__$1,file_msg,request_url))
);
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_chan !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined')){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined')){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reloader_loop !== 'undefined')){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__26280__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto__){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto__){
return (function (state_28430){
var state_val_28431 = (state_28430[(1)]);
if((state_val_28431 === (7))){
var inst_28426 = (state_28430[(2)]);
var state_28430__$1 = state_28430;
var statearr_28432_28458 = state_28430__$1;
(statearr_28432_28458[(2)] = inst_28426);

(statearr_28432_28458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (1))){
var state_28430__$1 = state_28430;
var statearr_28433_28459 = state_28430__$1;
(statearr_28433_28459[(2)] = null);

(statearr_28433_28459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (4))){
var inst_28396 = (state_28430[(7)]);
var inst_28396__$1 = (state_28430[(2)]);
var state_28430__$1 = (function (){var statearr_28434 = state_28430;
(statearr_28434[(7)] = inst_28396__$1);

return statearr_28434;
})();
if(cljs.core.truth_(inst_28396__$1)){
var statearr_28435_28460 = state_28430__$1;
(statearr_28435_28460[(1)] = (5));

} else {
var statearr_28436_28461 = state_28430__$1;
(statearr_28436_28461[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (15))){
var inst_28409 = (state_28430[(8)]);
var inst_28411 = (state_28430[(9)]);
var inst_28413 = inst_28411.call(null,inst_28409);
var state_28430__$1 = state_28430;
var statearr_28437_28462 = state_28430__$1;
(statearr_28437_28462[(2)] = inst_28413);

(statearr_28437_28462[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (13))){
var inst_28420 = (state_28430[(2)]);
var state_28430__$1 = state_28430;
var statearr_28438_28463 = state_28430__$1;
(statearr_28438_28463[(2)] = inst_28420);

(statearr_28438_28463[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (6))){
var state_28430__$1 = state_28430;
var statearr_28439_28464 = state_28430__$1;
(statearr_28439_28464[(2)] = null);

(statearr_28439_28464[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (17))){
var inst_28417 = (state_28430[(2)]);
var state_28430__$1 = state_28430;
var statearr_28440_28465 = state_28430__$1;
(statearr_28440_28465[(2)] = inst_28417);

(statearr_28440_28465[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (3))){
var inst_28428 = (state_28430[(2)]);
var state_28430__$1 = state_28430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28430__$1,inst_28428);
} else {
if((state_val_28431 === (12))){
var state_28430__$1 = state_28430;
var statearr_28441_28466 = state_28430__$1;
(statearr_28441_28466[(2)] = null);

(statearr_28441_28466[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (2))){
var state_28430__$1 = state_28430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28430__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_28431 === (11))){
var inst_28401 = (state_28430[(10)]);
var inst_28407 = figwheel.client.file_reloading.blocking_load.call(null,inst_28401);
var state_28430__$1 = state_28430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28430__$1,(14),inst_28407);
} else {
if((state_val_28431 === (9))){
var inst_28401 = (state_28430[(10)]);
var state_28430__$1 = state_28430;
if(cljs.core.truth_(inst_28401)){
var statearr_28442_28467 = state_28430__$1;
(statearr_28442_28467[(1)] = (11));

} else {
var statearr_28443_28468 = state_28430__$1;
(statearr_28443_28468[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (5))){
var inst_28402 = (state_28430[(11)]);
var inst_28396 = (state_28430[(7)]);
var inst_28401 = cljs.core.nth.call(null,inst_28396,(0),null);
var inst_28402__$1 = cljs.core.nth.call(null,inst_28396,(1),null);
var state_28430__$1 = (function (){var statearr_28444 = state_28430;
(statearr_28444[(11)] = inst_28402__$1);

(statearr_28444[(10)] = inst_28401);

return statearr_28444;
})();
if(cljs.core.truth_(inst_28402__$1)){
var statearr_28445_28469 = state_28430__$1;
(statearr_28445_28469[(1)] = (8));

} else {
var statearr_28446_28470 = state_28430__$1;
(statearr_28446_28470[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (14))){
var inst_28411 = (state_28430[(9)]);
var inst_28401 = (state_28430[(10)]);
var inst_28409 = (state_28430[(2)]);
var inst_28410 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_28411__$1 = cljs.core.get.call(null,inst_28410,inst_28401);
var state_28430__$1 = (function (){var statearr_28447 = state_28430;
(statearr_28447[(8)] = inst_28409);

(statearr_28447[(9)] = inst_28411__$1);

return statearr_28447;
})();
if(cljs.core.truth_(inst_28411__$1)){
var statearr_28448_28471 = state_28430__$1;
(statearr_28448_28471[(1)] = (15));

} else {
var statearr_28449_28472 = state_28430__$1;
(statearr_28449_28472[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (16))){
var inst_28409 = (state_28430[(8)]);
var inst_28415 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_28409);
var state_28430__$1 = state_28430;
var statearr_28450_28473 = state_28430__$1;
(statearr_28450_28473[(2)] = inst_28415);

(statearr_28450_28473[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (10))){
var inst_28422 = (state_28430[(2)]);
var state_28430__$1 = (function (){var statearr_28451 = state_28430;
(statearr_28451[(12)] = inst_28422);

return statearr_28451;
})();
var statearr_28452_28474 = state_28430__$1;
(statearr_28452_28474[(2)] = null);

(statearr_28452_28474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28431 === (8))){
var inst_28402 = (state_28430[(11)]);
var inst_28404 = eval(inst_28402);
var state_28430__$1 = state_28430;
var statearr_28453_28475 = state_28430__$1;
(statearr_28453_28475[(2)] = inst_28404);

(statearr_28453_28475[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto__))
;
return ((function (switch__26185__auto__,c__26280__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__26186__auto__ = null;
var figwheel$client$file_reloading$state_machine__26186__auto____0 = (function (){
var statearr_28454 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28454[(0)] = figwheel$client$file_reloading$state_machine__26186__auto__);

(statearr_28454[(1)] = (1));

return statearr_28454;
});
var figwheel$client$file_reloading$state_machine__26186__auto____1 = (function (state_28430){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_28430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e28455){if((e28455 instanceof Object)){
var ex__26189__auto__ = e28455;
var statearr_28456_28476 = state_28430;
(statearr_28456_28476[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28430);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28455;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28477 = state_28430;
state_28430 = G__28477;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__26186__auto__ = function(state_28430){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__26186__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__26186__auto____1.call(this,state_28430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__26186__auto____0;
figwheel$client$file_reloading$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__26186__auto____1;
return figwheel$client$file_reloading$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto__))
})();
var state__26282__auto__ = (function (){var statearr_28457 = f__26281__auto__.call(null);
(statearr_28457[(6)] = c__26280__auto__);

return statearr_28457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto__))
);

return c__26280__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__28479 = arguments.length;
switch (G__28479) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__28481,callback){
var map__28482 = p__28481;
var map__28482__$1 = (((((!((map__28482 == null))))?(((((map__28482.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28482.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28482):map__28482);
var file_msg = map__28482__$1;
var namespace = cljs.core.get.call(null,map__28482__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__28482,map__28482__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__28482,map__28482__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__28484){
var map__28485 = p__28484;
var map__28485__$1 = (((((!((map__28485 == null))))?(((((map__28485.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28485.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28485):map__28485);
var file_msg = map__28485__$1;
var namespace = cljs.core.get.call(null,map__28485__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return (!((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null)));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__28487){
var map__28488 = p__28487;
var map__28488__$1 = (((((!((map__28488 == null))))?(((((map__28488.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28488.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28488):map__28488);
var file_msg = map__28488__$1;
var namespace = cljs.core.get.call(null,map__28488__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__4036__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__4036__auto__){
var or__4047__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
var or__4047__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__4047__auto____$1)){
return or__4047__auto____$1;
} else {
var or__4047__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__4047__auto____$2)){
return or__4047__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return and__4036__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__28490,callback){
var map__28491 = p__28490;
var map__28491__$1 = (((((!((map__28491 == null))))?(((((map__28491.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28491.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28491):map__28491);
var file_msg = map__28491__$1;
var request_url = cljs.core.get.call(null,map__28491__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__28491__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__26280__auto___28541 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___28541,out){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___28541,out){
return (function (state_28526){
var state_val_28527 = (state_28526[(1)]);
if((state_val_28527 === (1))){
var inst_28500 = cljs.core.seq.call(null,files);
var inst_28501 = cljs.core.first.call(null,inst_28500);
var inst_28502 = cljs.core.next.call(null,inst_28500);
var inst_28503 = files;
var state_28526__$1 = (function (){var statearr_28528 = state_28526;
(statearr_28528[(7)] = inst_28501);

(statearr_28528[(8)] = inst_28502);

(statearr_28528[(9)] = inst_28503);

return statearr_28528;
})();
var statearr_28529_28542 = state_28526__$1;
(statearr_28529_28542[(2)] = null);

(statearr_28529_28542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28527 === (2))){
var inst_28509 = (state_28526[(10)]);
var inst_28503 = (state_28526[(9)]);
var inst_28508 = cljs.core.seq.call(null,inst_28503);
var inst_28509__$1 = cljs.core.first.call(null,inst_28508);
var inst_28510 = cljs.core.next.call(null,inst_28508);
var inst_28511 = (inst_28509__$1 == null);
var inst_28512 = cljs.core.not.call(null,inst_28511);
var state_28526__$1 = (function (){var statearr_28530 = state_28526;
(statearr_28530[(10)] = inst_28509__$1);

(statearr_28530[(11)] = inst_28510);

return statearr_28530;
})();
if(inst_28512){
var statearr_28531_28543 = state_28526__$1;
(statearr_28531_28543[(1)] = (4));

} else {
var statearr_28532_28544 = state_28526__$1;
(statearr_28532_28544[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28527 === (3))){
var inst_28524 = (state_28526[(2)]);
var state_28526__$1 = state_28526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28526__$1,inst_28524);
} else {
if((state_val_28527 === (4))){
var inst_28509 = (state_28526[(10)]);
var inst_28514 = figwheel.client.file_reloading.reload_js_file.call(null,inst_28509);
var state_28526__$1 = state_28526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28526__$1,(7),inst_28514);
} else {
if((state_val_28527 === (5))){
var inst_28520 = cljs.core.async.close_BANG_.call(null,out);
var state_28526__$1 = state_28526;
var statearr_28533_28545 = state_28526__$1;
(statearr_28533_28545[(2)] = inst_28520);

(statearr_28533_28545[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28527 === (6))){
var inst_28522 = (state_28526[(2)]);
var state_28526__$1 = state_28526;
var statearr_28534_28546 = state_28526__$1;
(statearr_28534_28546[(2)] = inst_28522);

(statearr_28534_28546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28527 === (7))){
var inst_28510 = (state_28526[(11)]);
var inst_28516 = (state_28526[(2)]);
var inst_28517 = cljs.core.async.put_BANG_.call(null,out,inst_28516);
var inst_28503 = inst_28510;
var state_28526__$1 = (function (){var statearr_28535 = state_28526;
(statearr_28535[(9)] = inst_28503);

(statearr_28535[(12)] = inst_28517);

return statearr_28535;
})();
var statearr_28536_28547 = state_28526__$1;
(statearr_28536_28547[(2)] = null);

(statearr_28536_28547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__26280__auto___28541,out))
;
return ((function (switch__26185__auto__,c__26280__auto___28541,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto____0 = (function (){
var statearr_28537 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28537[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto__);

(statearr_28537[(1)] = (1));

return statearr_28537;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto____1 = (function (state_28526){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_28526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e28538){if((e28538 instanceof Object)){
var ex__26189__auto__ = e28538;
var statearr_28539_28548 = state_28526;
(statearr_28539_28548[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28526);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28538;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28549 = state_28526;
state_28526 = G__28549;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto__ = function(state_28526){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto____1.call(this,state_28526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___28541,out))
})();
var state__26282__auto__ = (function (){var statearr_28540 = f__26281__auto__.call(null);
(statearr_28540[(6)] = c__26280__auto___28541);

return statearr_28540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___28541,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__28550,opts){
var map__28551 = p__28550;
var map__28551__$1 = (((((!((map__28551 == null))))?(((((map__28551.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28551.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28551):map__28551);
var eval_body = cljs.core.get.call(null,map__28551__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__28551__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__4036__auto__ = eval_body;
if(cljs.core.truth_(and__4036__auto__)){
return typeof eval_body === 'string';
} else {
return and__4036__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e28553){var e = e28553;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5455__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__28554_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__28554_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5455__auto__)){
var file_msg = temp__5455__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__28555){
var vec__28556 = p__28555;
var k = cljs.core.nth.call(null,vec__28556,(0),null);
var v = cljs.core.nth.call(null,vec__28556,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__28559){
var vec__28560 = p__28559;
var k = cljs.core.nth.call(null,vec__28560,(0),null);
var v = cljs.core.nth.call(null,vec__28560,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__28566,p__28567){
var map__28568 = p__28566;
var map__28568__$1 = (((((!((map__28568 == null))))?(((((map__28568.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28568.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28568):map__28568);
var opts = map__28568__$1;
var before_jsload = cljs.core.get.call(null,map__28568__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__28568__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__28568__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__28569 = p__28567;
var map__28569__$1 = (((((!((map__28569 == null))))?(((((map__28569.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28569.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28569):map__28569);
var msg = map__28569__$1;
var files = cljs.core.get.call(null,map__28569__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__28569__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__28569__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__26280__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_28723){
var state_val_28724 = (state_28723[(1)]);
if((state_val_28724 === (7))){
var inst_28586 = (state_28723[(7)]);
var inst_28585 = (state_28723[(8)]);
var inst_28584 = (state_28723[(9)]);
var inst_28583 = (state_28723[(10)]);
var inst_28591 = cljs.core._nth.call(null,inst_28584,inst_28586);
var inst_28592 = figwheel.client.file_reloading.eval_body.call(null,inst_28591,opts);
var inst_28593 = (inst_28586 + (1));
var tmp28725 = inst_28585;
var tmp28726 = inst_28584;
var tmp28727 = inst_28583;
var inst_28583__$1 = tmp28727;
var inst_28584__$1 = tmp28726;
var inst_28585__$1 = tmp28725;
var inst_28586__$1 = inst_28593;
var state_28723__$1 = (function (){var statearr_28728 = state_28723;
(statearr_28728[(7)] = inst_28586__$1);

(statearr_28728[(11)] = inst_28592);

(statearr_28728[(8)] = inst_28585__$1);

(statearr_28728[(9)] = inst_28584__$1);

(statearr_28728[(10)] = inst_28583__$1);

return statearr_28728;
})();
var statearr_28729_28812 = state_28723__$1;
(statearr_28729_28812[(2)] = null);

(statearr_28729_28812[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (20))){
var inst_28626 = (state_28723[(12)]);
var inst_28634 = figwheel.client.file_reloading.sort_files.call(null,inst_28626);
var state_28723__$1 = state_28723;
var statearr_28730_28813 = state_28723__$1;
(statearr_28730_28813[(2)] = inst_28634);

(statearr_28730_28813[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (27))){
var state_28723__$1 = state_28723;
var statearr_28731_28814 = state_28723__$1;
(statearr_28731_28814[(2)] = null);

(statearr_28731_28814[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (1))){
var inst_28575 = (state_28723[(13)]);
var inst_28572 = before_jsload.call(null,files);
var inst_28573 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_28574 = (function (){return ((function (inst_28575,inst_28572,inst_28573,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__28563_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__28563_SHARP_);
});
;})(inst_28575,inst_28572,inst_28573,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28575__$1 = cljs.core.filter.call(null,inst_28574,files);
var inst_28576 = cljs.core.not_empty.call(null,inst_28575__$1);
var state_28723__$1 = (function (){var statearr_28732 = state_28723;
(statearr_28732[(14)] = inst_28573);

(statearr_28732[(13)] = inst_28575__$1);

(statearr_28732[(15)] = inst_28572);

return statearr_28732;
})();
if(cljs.core.truth_(inst_28576)){
var statearr_28733_28815 = state_28723__$1;
(statearr_28733_28815[(1)] = (2));

} else {
var statearr_28734_28816 = state_28723__$1;
(statearr_28734_28816[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (24))){
var state_28723__$1 = state_28723;
var statearr_28735_28817 = state_28723__$1;
(statearr_28735_28817[(2)] = null);

(statearr_28735_28817[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (39))){
var inst_28676 = (state_28723[(16)]);
var state_28723__$1 = state_28723;
var statearr_28736_28818 = state_28723__$1;
(statearr_28736_28818[(2)] = inst_28676);

(statearr_28736_28818[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (46))){
var inst_28718 = (state_28723[(2)]);
var state_28723__$1 = state_28723;
var statearr_28737_28819 = state_28723__$1;
(statearr_28737_28819[(2)] = inst_28718);

(statearr_28737_28819[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (4))){
var inst_28620 = (state_28723[(2)]);
var inst_28621 = cljs.core.List.EMPTY;
var inst_28622 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_28621);
var inst_28623 = (function (){return ((function (inst_28620,inst_28621,inst_28622,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__28564_SHARP_){
var and__4036__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__28564_SHARP_);
if(cljs.core.truth_(and__4036__auto__)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__28564_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__28564_SHARP_))));
} else {
return and__4036__auto__;
}
});
;})(inst_28620,inst_28621,inst_28622,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28624 = cljs.core.filter.call(null,inst_28623,files);
var inst_28625 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_28626 = cljs.core.concat.call(null,inst_28624,inst_28625);
var state_28723__$1 = (function (){var statearr_28738 = state_28723;
(statearr_28738[(17)] = inst_28620);

(statearr_28738[(12)] = inst_28626);

(statearr_28738[(18)] = inst_28622);

return statearr_28738;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_28739_28820 = state_28723__$1;
(statearr_28739_28820[(1)] = (16));

} else {
var statearr_28740_28821 = state_28723__$1;
(statearr_28740_28821[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (15))){
var inst_28610 = (state_28723[(2)]);
var state_28723__$1 = state_28723;
var statearr_28741_28822 = state_28723__$1;
(statearr_28741_28822[(2)] = inst_28610);

(statearr_28741_28822[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (21))){
var inst_28636 = (state_28723[(19)]);
var inst_28636__$1 = (state_28723[(2)]);
var inst_28637 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_28636__$1);
var state_28723__$1 = (function (){var statearr_28742 = state_28723;
(statearr_28742[(19)] = inst_28636__$1);

return statearr_28742;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28723__$1,(22),inst_28637);
} else {
if((state_val_28724 === (31))){
var inst_28721 = (state_28723[(2)]);
var state_28723__$1 = state_28723;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28723__$1,inst_28721);
} else {
if((state_val_28724 === (32))){
var inst_28676 = (state_28723[(16)]);
var inst_28681 = inst_28676.cljs$lang$protocol_mask$partition0$;
var inst_28682 = (inst_28681 & (64));
var inst_28683 = inst_28676.cljs$core$ISeq$;
var inst_28684 = (cljs.core.PROTOCOL_SENTINEL === inst_28683);
var inst_28685 = ((inst_28682) || (inst_28684));
var state_28723__$1 = state_28723;
if(cljs.core.truth_(inst_28685)){
var statearr_28743_28823 = state_28723__$1;
(statearr_28743_28823[(1)] = (35));

} else {
var statearr_28744_28824 = state_28723__$1;
(statearr_28744_28824[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (40))){
var inst_28698 = (state_28723[(20)]);
var inst_28697 = (state_28723[(2)]);
var inst_28698__$1 = cljs.core.get.call(null,inst_28697,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_28699 = cljs.core.get.call(null,inst_28697,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_28700 = cljs.core.not_empty.call(null,inst_28698__$1);
var state_28723__$1 = (function (){var statearr_28745 = state_28723;
(statearr_28745[(21)] = inst_28699);

(statearr_28745[(20)] = inst_28698__$1);

return statearr_28745;
})();
if(cljs.core.truth_(inst_28700)){
var statearr_28746_28825 = state_28723__$1;
(statearr_28746_28825[(1)] = (41));

} else {
var statearr_28747_28826 = state_28723__$1;
(statearr_28747_28826[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (33))){
var state_28723__$1 = state_28723;
var statearr_28748_28827 = state_28723__$1;
(statearr_28748_28827[(2)] = false);

(statearr_28748_28827[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (13))){
var inst_28596 = (state_28723[(22)]);
var inst_28600 = cljs.core.chunk_first.call(null,inst_28596);
var inst_28601 = cljs.core.chunk_rest.call(null,inst_28596);
var inst_28602 = cljs.core.count.call(null,inst_28600);
var inst_28583 = inst_28601;
var inst_28584 = inst_28600;
var inst_28585 = inst_28602;
var inst_28586 = (0);
var state_28723__$1 = (function (){var statearr_28749 = state_28723;
(statearr_28749[(7)] = inst_28586);

(statearr_28749[(8)] = inst_28585);

(statearr_28749[(9)] = inst_28584);

(statearr_28749[(10)] = inst_28583);

return statearr_28749;
})();
var statearr_28750_28828 = state_28723__$1;
(statearr_28750_28828[(2)] = null);

(statearr_28750_28828[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (22))){
var inst_28640 = (state_28723[(23)]);
var inst_28636 = (state_28723[(19)]);
var inst_28639 = (state_28723[(24)]);
var inst_28644 = (state_28723[(25)]);
var inst_28639__$1 = (state_28723[(2)]);
var inst_28640__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_28639__$1);
var inst_28641 = (function (){var all_files = inst_28636;
var res_SINGLEQUOTE_ = inst_28639__$1;
var res = inst_28640__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_28640,inst_28636,inst_28639,inst_28644,inst_28639__$1,inst_28640__$1,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__28565_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__28565_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_28640,inst_28636,inst_28639,inst_28644,inst_28639__$1,inst_28640__$1,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28642 = cljs.core.filter.call(null,inst_28641,inst_28639__$1);
var inst_28643 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_28644__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_28643);
var inst_28645 = cljs.core.not_empty.call(null,inst_28644__$1);
var state_28723__$1 = (function (){var statearr_28751 = state_28723;
(statearr_28751[(23)] = inst_28640__$1);

(statearr_28751[(26)] = inst_28642);

(statearr_28751[(24)] = inst_28639__$1);

(statearr_28751[(25)] = inst_28644__$1);

return statearr_28751;
})();
if(cljs.core.truth_(inst_28645)){
var statearr_28752_28829 = state_28723__$1;
(statearr_28752_28829[(1)] = (23));

} else {
var statearr_28753_28830 = state_28723__$1;
(statearr_28753_28830[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (36))){
var state_28723__$1 = state_28723;
var statearr_28754_28831 = state_28723__$1;
(statearr_28754_28831[(2)] = false);

(statearr_28754_28831[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (41))){
var inst_28698 = (state_28723[(20)]);
var inst_28702 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_28703 = cljs.core.map.call(null,inst_28702,inst_28698);
var inst_28704 = cljs.core.pr_str.call(null,inst_28703);
var inst_28705 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28704)].join('');
var inst_28706 = figwheel.client.utils.log.call(null,inst_28705);
var state_28723__$1 = state_28723;
var statearr_28755_28832 = state_28723__$1;
(statearr_28755_28832[(2)] = inst_28706);

(statearr_28755_28832[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (43))){
var inst_28699 = (state_28723[(21)]);
var inst_28709 = (state_28723[(2)]);
var inst_28710 = cljs.core.not_empty.call(null,inst_28699);
var state_28723__$1 = (function (){var statearr_28756 = state_28723;
(statearr_28756[(27)] = inst_28709);

return statearr_28756;
})();
if(cljs.core.truth_(inst_28710)){
var statearr_28757_28833 = state_28723__$1;
(statearr_28757_28833[(1)] = (44));

} else {
var statearr_28758_28834 = state_28723__$1;
(statearr_28758_28834[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (29))){
var inst_28640 = (state_28723[(23)]);
var inst_28642 = (state_28723[(26)]);
var inst_28636 = (state_28723[(19)]);
var inst_28639 = (state_28723[(24)]);
var inst_28676 = (state_28723[(16)]);
var inst_28644 = (state_28723[(25)]);
var inst_28672 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_28675 = (function (){var all_files = inst_28636;
var res_SINGLEQUOTE_ = inst_28639;
var res = inst_28640;
var files_not_loaded = inst_28642;
var dependencies_that_loaded = inst_28644;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28640,inst_28642,inst_28636,inst_28639,inst_28676,inst_28644,inst_28672,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__28674){
var map__28759 = p__28674;
var map__28759__$1 = (((((!((map__28759 == null))))?(((((map__28759.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28759.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28759):map__28759);
var namespace = cljs.core.get.call(null,map__28759__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28640,inst_28642,inst_28636,inst_28639,inst_28676,inst_28644,inst_28672,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28676__$1 = cljs.core.group_by.call(null,inst_28675,inst_28642);
var inst_28678 = (inst_28676__$1 == null);
var inst_28679 = cljs.core.not.call(null,inst_28678);
var state_28723__$1 = (function (){var statearr_28761 = state_28723;
(statearr_28761[(16)] = inst_28676__$1);

(statearr_28761[(28)] = inst_28672);

return statearr_28761;
})();
if(inst_28679){
var statearr_28762_28835 = state_28723__$1;
(statearr_28762_28835[(1)] = (32));

} else {
var statearr_28763_28836 = state_28723__$1;
(statearr_28763_28836[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (44))){
var inst_28699 = (state_28723[(21)]);
var inst_28712 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_28699);
var inst_28713 = cljs.core.pr_str.call(null,inst_28712);
var inst_28714 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28713)].join('');
var inst_28715 = figwheel.client.utils.log.call(null,inst_28714);
var state_28723__$1 = state_28723;
var statearr_28764_28837 = state_28723__$1;
(statearr_28764_28837[(2)] = inst_28715);

(statearr_28764_28837[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (6))){
var inst_28617 = (state_28723[(2)]);
var state_28723__$1 = state_28723;
var statearr_28765_28838 = state_28723__$1;
(statearr_28765_28838[(2)] = inst_28617);

(statearr_28765_28838[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (28))){
var inst_28642 = (state_28723[(26)]);
var inst_28669 = (state_28723[(2)]);
var inst_28670 = cljs.core.not_empty.call(null,inst_28642);
var state_28723__$1 = (function (){var statearr_28766 = state_28723;
(statearr_28766[(29)] = inst_28669);

return statearr_28766;
})();
if(cljs.core.truth_(inst_28670)){
var statearr_28767_28839 = state_28723__$1;
(statearr_28767_28839[(1)] = (29));

} else {
var statearr_28768_28840 = state_28723__$1;
(statearr_28768_28840[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (25))){
var inst_28640 = (state_28723[(23)]);
var inst_28656 = (state_28723[(2)]);
var inst_28657 = cljs.core.not_empty.call(null,inst_28640);
var state_28723__$1 = (function (){var statearr_28769 = state_28723;
(statearr_28769[(30)] = inst_28656);

return statearr_28769;
})();
if(cljs.core.truth_(inst_28657)){
var statearr_28770_28841 = state_28723__$1;
(statearr_28770_28841[(1)] = (26));

} else {
var statearr_28771_28842 = state_28723__$1;
(statearr_28771_28842[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (34))){
var inst_28692 = (state_28723[(2)]);
var state_28723__$1 = state_28723;
if(cljs.core.truth_(inst_28692)){
var statearr_28772_28843 = state_28723__$1;
(statearr_28772_28843[(1)] = (38));

} else {
var statearr_28773_28844 = state_28723__$1;
(statearr_28773_28844[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (17))){
var state_28723__$1 = state_28723;
var statearr_28774_28845 = state_28723__$1;
(statearr_28774_28845[(2)] = recompile_dependents);

(statearr_28774_28845[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (3))){
var state_28723__$1 = state_28723;
var statearr_28775_28846 = state_28723__$1;
(statearr_28775_28846[(2)] = null);

(statearr_28775_28846[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (12))){
var inst_28613 = (state_28723[(2)]);
var state_28723__$1 = state_28723;
var statearr_28776_28847 = state_28723__$1;
(statearr_28776_28847[(2)] = inst_28613);

(statearr_28776_28847[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (2))){
var inst_28575 = (state_28723[(13)]);
var inst_28582 = cljs.core.seq.call(null,inst_28575);
var inst_28583 = inst_28582;
var inst_28584 = null;
var inst_28585 = (0);
var inst_28586 = (0);
var state_28723__$1 = (function (){var statearr_28777 = state_28723;
(statearr_28777[(7)] = inst_28586);

(statearr_28777[(8)] = inst_28585);

(statearr_28777[(9)] = inst_28584);

(statearr_28777[(10)] = inst_28583);

return statearr_28777;
})();
var statearr_28778_28848 = state_28723__$1;
(statearr_28778_28848[(2)] = null);

(statearr_28778_28848[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (23))){
var inst_28640 = (state_28723[(23)]);
var inst_28642 = (state_28723[(26)]);
var inst_28636 = (state_28723[(19)]);
var inst_28639 = (state_28723[(24)]);
var inst_28644 = (state_28723[(25)]);
var inst_28647 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_28649 = (function (){var all_files = inst_28636;
var res_SINGLEQUOTE_ = inst_28639;
var res = inst_28640;
var files_not_loaded = inst_28642;
var dependencies_that_loaded = inst_28644;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28640,inst_28642,inst_28636,inst_28639,inst_28644,inst_28647,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__28648){
var map__28779 = p__28648;
var map__28779__$1 = (((((!((map__28779 == null))))?(((((map__28779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28779.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28779):map__28779);
var request_url = cljs.core.get.call(null,map__28779__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28640,inst_28642,inst_28636,inst_28639,inst_28644,inst_28647,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28650 = cljs.core.reverse.call(null,inst_28644);
var inst_28651 = cljs.core.map.call(null,inst_28649,inst_28650);
var inst_28652 = cljs.core.pr_str.call(null,inst_28651);
var inst_28653 = figwheel.client.utils.log.call(null,inst_28652);
var state_28723__$1 = (function (){var statearr_28781 = state_28723;
(statearr_28781[(31)] = inst_28647);

return statearr_28781;
})();
var statearr_28782_28849 = state_28723__$1;
(statearr_28782_28849[(2)] = inst_28653);

(statearr_28782_28849[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (35))){
var state_28723__$1 = state_28723;
var statearr_28783_28850 = state_28723__$1;
(statearr_28783_28850[(2)] = true);

(statearr_28783_28850[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (19))){
var inst_28626 = (state_28723[(12)]);
var inst_28632 = figwheel.client.file_reloading.expand_files.call(null,inst_28626);
var state_28723__$1 = state_28723;
var statearr_28784_28851 = state_28723__$1;
(statearr_28784_28851[(2)] = inst_28632);

(statearr_28784_28851[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (11))){
var state_28723__$1 = state_28723;
var statearr_28785_28852 = state_28723__$1;
(statearr_28785_28852[(2)] = null);

(statearr_28785_28852[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (9))){
var inst_28615 = (state_28723[(2)]);
var state_28723__$1 = state_28723;
var statearr_28786_28853 = state_28723__$1;
(statearr_28786_28853[(2)] = inst_28615);

(statearr_28786_28853[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (5))){
var inst_28586 = (state_28723[(7)]);
var inst_28585 = (state_28723[(8)]);
var inst_28588 = (inst_28586 < inst_28585);
var inst_28589 = inst_28588;
var state_28723__$1 = state_28723;
if(cljs.core.truth_(inst_28589)){
var statearr_28787_28854 = state_28723__$1;
(statearr_28787_28854[(1)] = (7));

} else {
var statearr_28788_28855 = state_28723__$1;
(statearr_28788_28855[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (14))){
var inst_28596 = (state_28723[(22)]);
var inst_28605 = cljs.core.first.call(null,inst_28596);
var inst_28606 = figwheel.client.file_reloading.eval_body.call(null,inst_28605,opts);
var inst_28607 = cljs.core.next.call(null,inst_28596);
var inst_28583 = inst_28607;
var inst_28584 = null;
var inst_28585 = (0);
var inst_28586 = (0);
var state_28723__$1 = (function (){var statearr_28789 = state_28723;
(statearr_28789[(7)] = inst_28586);

(statearr_28789[(32)] = inst_28606);

(statearr_28789[(8)] = inst_28585);

(statearr_28789[(9)] = inst_28584);

(statearr_28789[(10)] = inst_28583);

return statearr_28789;
})();
var statearr_28790_28856 = state_28723__$1;
(statearr_28790_28856[(2)] = null);

(statearr_28790_28856[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (45))){
var state_28723__$1 = state_28723;
var statearr_28791_28857 = state_28723__$1;
(statearr_28791_28857[(2)] = null);

(statearr_28791_28857[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (26))){
var inst_28640 = (state_28723[(23)]);
var inst_28642 = (state_28723[(26)]);
var inst_28636 = (state_28723[(19)]);
var inst_28639 = (state_28723[(24)]);
var inst_28644 = (state_28723[(25)]);
var inst_28659 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_28661 = (function (){var all_files = inst_28636;
var res_SINGLEQUOTE_ = inst_28639;
var res = inst_28640;
var files_not_loaded = inst_28642;
var dependencies_that_loaded = inst_28644;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28640,inst_28642,inst_28636,inst_28639,inst_28644,inst_28659,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__28660){
var map__28792 = p__28660;
var map__28792__$1 = (((((!((map__28792 == null))))?(((((map__28792.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28792.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28792):map__28792);
var namespace = cljs.core.get.call(null,map__28792__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__28792__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28640,inst_28642,inst_28636,inst_28639,inst_28644,inst_28659,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28662 = cljs.core.map.call(null,inst_28661,inst_28640);
var inst_28663 = cljs.core.pr_str.call(null,inst_28662);
var inst_28664 = figwheel.client.utils.log.call(null,inst_28663);
var inst_28665 = (function (){var all_files = inst_28636;
var res_SINGLEQUOTE_ = inst_28639;
var res = inst_28640;
var files_not_loaded = inst_28642;
var dependencies_that_loaded = inst_28644;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28640,inst_28642,inst_28636,inst_28639,inst_28644,inst_28659,inst_28661,inst_28662,inst_28663,inst_28664,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28640,inst_28642,inst_28636,inst_28639,inst_28644,inst_28659,inst_28661,inst_28662,inst_28663,inst_28664,state_val_28724,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28666 = setTimeout(inst_28665,(10));
var state_28723__$1 = (function (){var statearr_28794 = state_28723;
(statearr_28794[(33)] = inst_28659);

(statearr_28794[(34)] = inst_28664);

return statearr_28794;
})();
var statearr_28795_28858 = state_28723__$1;
(statearr_28795_28858[(2)] = inst_28666);

(statearr_28795_28858[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (16))){
var state_28723__$1 = state_28723;
var statearr_28796_28859 = state_28723__$1;
(statearr_28796_28859[(2)] = reload_dependents);

(statearr_28796_28859[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (38))){
var inst_28676 = (state_28723[(16)]);
var inst_28694 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28676);
var state_28723__$1 = state_28723;
var statearr_28797_28860 = state_28723__$1;
(statearr_28797_28860[(2)] = inst_28694);

(statearr_28797_28860[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (30))){
var state_28723__$1 = state_28723;
var statearr_28798_28861 = state_28723__$1;
(statearr_28798_28861[(2)] = null);

(statearr_28798_28861[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (10))){
var inst_28596 = (state_28723[(22)]);
var inst_28598 = cljs.core.chunked_seq_QMARK_.call(null,inst_28596);
var state_28723__$1 = state_28723;
if(inst_28598){
var statearr_28799_28862 = state_28723__$1;
(statearr_28799_28862[(1)] = (13));

} else {
var statearr_28800_28863 = state_28723__$1;
(statearr_28800_28863[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (18))){
var inst_28630 = (state_28723[(2)]);
var state_28723__$1 = state_28723;
if(cljs.core.truth_(inst_28630)){
var statearr_28801_28864 = state_28723__$1;
(statearr_28801_28864[(1)] = (19));

} else {
var statearr_28802_28865 = state_28723__$1;
(statearr_28802_28865[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (42))){
var state_28723__$1 = state_28723;
var statearr_28803_28866 = state_28723__$1;
(statearr_28803_28866[(2)] = null);

(statearr_28803_28866[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (37))){
var inst_28689 = (state_28723[(2)]);
var state_28723__$1 = state_28723;
var statearr_28804_28867 = state_28723__$1;
(statearr_28804_28867[(2)] = inst_28689);

(statearr_28804_28867[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28724 === (8))){
var inst_28596 = (state_28723[(22)]);
var inst_28583 = (state_28723[(10)]);
var inst_28596__$1 = cljs.core.seq.call(null,inst_28583);
var state_28723__$1 = (function (){var statearr_28805 = state_28723;
(statearr_28805[(22)] = inst_28596__$1);

return statearr_28805;
})();
if(inst_28596__$1){
var statearr_28806_28868 = state_28723__$1;
(statearr_28806_28868[(1)] = (10));

} else {
var statearr_28807_28869 = state_28723__$1;
(statearr_28807_28869[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__26185__auto__,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto____0 = (function (){
var statearr_28808 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28808[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto__);

(statearr_28808[(1)] = (1));

return statearr_28808;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto____1 = (function (state_28723){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_28723);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e28809){if((e28809 instanceof Object)){
var ex__26189__auto__ = e28809;
var statearr_28810_28870 = state_28723;
(statearr_28810_28870[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28723);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28809;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28871 = state_28723;
state_28723 = G__28871;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto__ = function(state_28723){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto____1.call(this,state_28723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__26282__auto__ = (function (){var statearr_28811 = f__26281__auto__.call(null);
(statearr_28811[(6)] = c__26280__auto__);

return statearr_28811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto__,map__28568,map__28568__$1,opts,before_jsload,on_jsload,reload_dependents,map__28569,map__28569__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__26280__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__28874,link){
var map__28875 = p__28874;
var map__28875__$1 = (((((!((map__28875 == null))))?(((((map__28875.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28875.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28875):map__28875);
var file = cljs.core.get.call(null,map__28875__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5457__auto__ = link.href;
if(cljs.core.truth_(temp__5457__auto__)){
var link_href = temp__5457__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5457__auto__,map__28875,map__28875__$1,file){
return (function (p1__28872_SHARP_,p2__28873_SHARP_){
if(cljs.core._EQ_.call(null,p1__28872_SHARP_,p2__28873_SHARP_)){
return p1__28872_SHARP_;
} else {
return false;
}
});})(link_href,temp__5457__auto__,map__28875,map__28875__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5457__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__28878){
var map__28879 = p__28878;
var map__28879__$1 = (((((!((map__28879 == null))))?(((((map__28879.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28879.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28879):map__28879);
var match_length = cljs.core.get.call(null,map__28879__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__28879__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__28877_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__28877_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5457__auto__)){
var res = temp__5457__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__28881_SHARP_,p2__28882_SHARP_){
return cljs.core.assoc.call(null,p1__28881_SHARP_,cljs.core.get.call(null,p2__28882_SHARP_,key),p2__28882_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5455__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5455__auto__)){
var link = temp__5455__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5455__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__5455__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_28883 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_28883);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_28883);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__28884,p__28885){
var map__28886 = p__28884;
var map__28886__$1 = (((((!((map__28886 == null))))?(((((map__28886.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28886.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28886):map__28886);
var on_cssload = cljs.core.get.call(null,map__28886__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__28887 = p__28885;
var map__28887__$1 = (((((!((map__28887 == null))))?(((((map__28887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28887.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28887):map__28887);
var files_msg = map__28887__$1;
var files = cljs.core.get.call(null,map__28887__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(figwheel.client.utils.html_env_QMARK_.call(null)){
var temp__5457__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5457__auto__)){
var f_datas = temp__5457__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1547336864678
