// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.impl.virtual_scene');
goog.require('cljs.core');
goog.require('threeagent.impl.util');
goog.require('medley.core');
goog.require('reagent.ratom');
goog.require('reagent.core');
goog.require('goog.structs.PriorityQueue');
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.non_component_keys !== 'undefined')){
} else {
threeagent.impl.virtual_scene.non_component_keys = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"rotation","rotation",-1728051644),null,new cljs.core.Keyword(null,"scale","scale",-230427353),null,new cljs.core.Keyword(null,"position","position",-2011731912),null], null), null);
}
threeagent.impl.virtual_scene.print_tree = (function threeagent$impl$virtual_scene$print_tree(var_args){
var G__22294 = arguments.length;
switch (G__22294) {
case 1:
return threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.impl.virtual_scene.print_tree.call(null,node,"");
});

threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2 = (function (node,p){
var is_reactive = (!((threeagent.impl.util.$.call(null,node,"reaction") == null)));
cljs.core.println.call(null,p,"|-",threeagent.impl.util.$.call(null,node,"key"),["dirty:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(threeagent.impl.util.$.call(null,node,"dirty"))].join(''),["reactive:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(is_reactive)].join(''),threeagent.impl.util.$.call(null,node,"render"));

var seq__22295 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,threeagent.impl.util.$.call(null,node,"children").values()));
var chunk__22296 = null;
var count__22297 = (0);
var i__22298 = (0);
while(true){
if((i__22298 < count__22297)){
var child = cljs.core._nth.call(null,chunk__22296,i__22298);
threeagent.impl.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__22300 = seq__22295;
var G__22301 = chunk__22296;
var G__22302 = count__22297;
var G__22303 = (i__22298 + (1));
seq__22295 = G__22300;
chunk__22296 = G__22301;
count__22297 = G__22302;
i__22298 = G__22303;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22295);
if(temp__5457__auto__){
var seq__22295__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22295__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__22295__$1);
var G__22304 = cljs.core.chunk_rest.call(null,seq__22295__$1);
var G__22305 = c__4461__auto__;
var G__22306 = cljs.core.count.call(null,c__4461__auto__);
var G__22307 = (0);
seq__22295 = G__22304;
chunk__22296 = G__22305;
count__22297 = G__22306;
i__22298 = G__22307;
continue;
} else {
var child = cljs.core.first.call(null,seq__22295__$1);
threeagent.impl.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__22308 = cljs.core.next.call(null,seq__22295__$1);
var G__22309 = null;
var G__22310 = (0);
var G__22311 = (0);
seq__22295 = G__22308;
chunk__22296 = G__22309;
count__22297 = G__22310;
i__22298 = G__22311;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.impl.virtual_scene.print_tree.cljs$lang$maxFixedArity = 2;

threeagent.impl.virtual_scene.node__GT_path = (function threeagent$impl$virtual_scene$node__GT_path(var_args){
var G__22313 = arguments.length;
switch (G__22313) {
case 1:
return threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.impl.virtual_scene.node__GT_path.call(null,cljs.core.PersistentVector.EMPTY,node);
});

threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2 = (function (path,node){
while(true){
if(cljs.core.truth_(node)){
var G__22315 = cljs.core.conj.call(null,path,threeagent.impl.util.$.call(null,node,"key"));
var G__22316 = threeagent.impl.util.$.call(null,node,"parent");
path = G__22315;
node = G__22316;
continue;
} else {
return cljs.core.reverse.call(null,path);
}
break;
}
});

threeagent.impl.virtual_scene.node__GT_path.cljs$lang$maxFixedArity = 2;

threeagent.impl.virtual_scene.get_in_node = (function threeagent$impl$virtual_scene$get_in_node(node,path){
while(true){
if(cljs.core.empty_QMARK_.call(null,path)){
return node;
} else {
var G__22317 = threeagent.impl.util.$.call(null,node,"children").get(cljs.core.first.call(null,path));
var G__22318 = cljs.core.rest.call(null,path);
node = G__22317;
path = G__22318;
continue;
}
break;
}
});
threeagent.impl.virtual_scene.get_key = (function threeagent$impl$virtual_scene$get_key(key,meta){
return new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$2(meta,key);
});

/**
* @constructor
 * @implements {threeagent.impl.virtual_scene.Object}
*/
threeagent.impl.virtual_scene.Node = (function (parent,depth,key,meta,data,dirty,render,reaction,children){
this.parent = parent;
this.depth = depth;
this.key = key;
this.meta = meta;
this.data = data;
this.dirty = dirty;
this.render = render;
this.reaction = reaction;
this.children = children;
});
threeagent.impl.virtual_scene.Node.prototype.for_each_child = (function (f){
var self__ = this;
var this$ = this;
var seq__22319 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,self__.children.values()));
var chunk__22320 = null;
var count__22321 = (0);
var i__22322 = (0);
while(true){
if((i__22322 < count__22321)){
var child = cljs.core._nth.call(null,chunk__22320,i__22322);
f.call(null,child);


var G__22323 = seq__22319;
var G__22324 = chunk__22320;
var G__22325 = count__22321;
var G__22326 = (i__22322 + (1));
seq__22319 = G__22323;
chunk__22320 = G__22324;
count__22321 = G__22325;
i__22322 = G__22326;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22319);
if(temp__5457__auto__){
var seq__22319__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22319__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__22319__$1);
var G__22327 = cljs.core.chunk_rest.call(null,seq__22319__$1);
var G__22328 = c__4461__auto__;
var G__22329 = cljs.core.count.call(null,c__4461__auto__);
var G__22330 = (0);
seq__22319 = G__22327;
chunk__22320 = G__22328;
count__22321 = G__22329;
i__22322 = G__22330;
continue;
} else {
var child = cljs.core.first.call(null,seq__22319__$1);
f.call(null,child);


var G__22331 = cljs.core.next.call(null,seq__22319__$1);
var G__22332 = null;
var G__22333 = (0);
var G__22334 = (0);
seq__22319 = G__22331;
chunk__22320 = G__22332;
count__22321 = G__22333;
i__22322 = G__22334;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.impl.virtual_scene.Node.getBasis = (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.Symbol(null,"depth","depth",-885772129,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"dirty","dirty",-1924882488,null),new cljs.core.Symbol(null,"render","render",232498073,null),new cljs.core.Symbol(null,"reaction","reaction",2131401315,null),new cljs.core.Symbol(null,"children","children",699969545,null)], null);
});

threeagent.impl.virtual_scene.Node.cljs$lang$type = true;

threeagent.impl.virtual_scene.Node.cljs$lang$ctorStr = "threeagent.impl.virtual-scene/Node";

threeagent.impl.virtual_scene.Node.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"threeagent.impl.virtual-scene/Node");
});

/**
 * Positional factory function for threeagent.impl.virtual-scene/Node.
 */
threeagent.impl.virtual_scene.__GT_Node = (function threeagent$impl$virtual_scene$__GT_Node(parent,depth,key,meta,data,dirty,render,reaction,children){
return (new threeagent.impl.virtual_scene.Node(parent,depth,key,meta,data,dirty,render,reaction,children));
});


/**
* @constructor
 * @implements {threeagent.impl.virtual_scene.Object}
*/
threeagent.impl.virtual_scene.Scene = (function (root,render_queue){
this.root = root;
this.render_queue = render_queue;
});
threeagent.impl.virtual_scene.Scene.prototype.enqueue_for_render = (function (node){
var self__ = this;
var this$ = this;
threeagent.impl.util.$_BANG_.call(null,node,"dirty",true);

return self__.render_queue.enqueue(threeagent.impl.util.$.call(null,node,"depth"),node);
});

threeagent.impl.virtual_scene.Scene.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"render-queue","render-queue",-1084920245,null)], null);
});

threeagent.impl.virtual_scene.Scene.cljs$lang$type = true;

threeagent.impl.virtual_scene.Scene.cljs$lang$ctorStr = "threeagent.impl.virtual-scene/Scene";

threeagent.impl.virtual_scene.Scene.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"threeagent.impl.virtual-scene/Scene");
});

/**
 * Positional factory function for threeagent.impl.virtual-scene/Scene.
 */
threeagent.impl.virtual_scene.__GT_Scene = (function threeagent$impl$virtual_scene$__GT_Scene(root,render_queue){
return (new threeagent.impl.virtual_scene.Scene(root,render_queue));
});

threeagent.impl.virtual_scene.eval_fn = (function threeagent$impl$virtual_scene$eval_fn(f,args){
while(true){
var result = cljs.core.apply.call(null,f,args);
if(cljs.core.fn_QMARK_.call(null,result)){
var G__22335 = result;
var G__22336 = args;
f = G__22335;
args = G__22336;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,result], null);
}
break;
}
});
threeagent.impl.virtual_scene.on_react_BANG_ = (function threeagent$impl$virtual_scene$on_react_BANG_(ctx){
var node = threeagent.impl.util.$.call(null,ctx,"node");
var scene = threeagent.impl.util.$.call(null,ctx,"scene");
return scene.enqueue_for_render(node);
});
threeagent.impl.virtual_scene.extract_comp_config = (function threeagent$impl$virtual_scene$extract_comp_config(config){
var c = cljs.core.transient$.call(null,config);
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,((function (c){
return (function (p1__22337_SHARP_,p2__22338_SHARP_){
return cljs.core.dissoc_BANG_.call(null,p1__22337_SHARP_,p2__22338_SHARP_);
});})(c))
,c,threeagent.impl.virtual_scene.non_component_keys));
});
threeagent.impl.virtual_scene.node_data = (function threeagent$impl$virtual_scene$node_data(comp_key,comp_config){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"rotation","rotation",-1728051644),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"scale","scale",-230427353),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [1.0,1.0,1.0], null)),new cljs.core.Keyword(null,"component-key","component-key",1189239034),comp_key,new cljs.core.Keyword(null,"component-config","component-config",2000790546),threeagent.impl.virtual_scene.extract_comp_config.call(null,comp_config)], null);
});
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.__GT_node !== 'undefined')){
} else {
threeagent.impl.virtual_scene.__GT_node = (function (){var method_table__4524__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4525__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4526__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4527__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4528__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.impl.virtual-scene","->node"),((function (method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__){
return (function (scene,parent,key,p__22339){
var vec__22340 = p__22339;
var seq__22341 = cljs.core.seq.call(null,vec__22340);
var first__22342 = cljs.core.first.call(null,seq__22341);
var seq__22341__$1 = cljs.core.next.call(null,seq__22341);
var l = first__22342;
var r = seq__22341__$1;
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});})(method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4528__auto__,method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"default","default",-1987822328),(function (scene,parent,key,form){
return cljs.core.println.call(null,"Invalid object form:",form);
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (scene,parent,key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (scene,parent,key,form){
return threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent,key,cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),cljs.core.meta.call(null,form)));
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (scene,parent,key,form){
var vec__22343 = form;
var seq__22344 = cljs.core.seq.call(null,vec__22343);
var first__22345 = cljs.core.first.call(null,seq__22344);
var seq__22344__$1 = cljs.core.next.call(null,seq__22344);
var comp_key = first__22345;
var rs = seq__22344__$1;
var first_child = cljs.core.first.call(null,rs);
var metadata = cljs.core.meta.call(null,form);
var key__$1 = (function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return key;
}
})();
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,cljs.core.some_QMARK_,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
var children_map = (new Map());
var data = threeagent.impl.virtual_scene.node_data.call(null,comp_key,comp_config);
var depth = (cljs.core.truth_(parent)?(threeagent.impl.util.$.call(null,parent,"depth") + (1)):(0));
var node = (new threeagent.impl.virtual_scene.Node(parent,depth,key__$1,metadata,data,false,null,null,children_map));
var seq__22346_22356 = cljs.core.seq.call(null,medley.core.indexed.call(null,children));
var chunk__22347_22357 = null;
var count__22348_22358 = (0);
var i__22349_22359 = (0);
while(true){
if((i__22349_22359 < count__22348_22358)){
var vec__22350_22360 = cljs.core._nth.call(null,chunk__22347_22357,i__22349_22359);
var idx_22361 = cljs.core.nth.call(null,vec__22350_22360,(0),null);
var child_22362 = cljs.core.nth.call(null,vec__22350_22360,(1),null);
var temp__5457__auto___22363 = threeagent.impl.virtual_scene.__GT_node.call(null,scene,node,idx_22361,child_22362);
if(cljs.core.truth_(temp__5457__auto___22363)){
var child_node_22364 = temp__5457__auto___22363;
children_map.set(threeagent.impl.util.$.call(null,child_node_22364,"key"),child_node_22364);
} else {
}


var G__22365 = seq__22346_22356;
var G__22366 = chunk__22347_22357;
var G__22367 = count__22348_22358;
var G__22368 = (i__22349_22359 + (1));
seq__22346_22356 = G__22365;
chunk__22347_22357 = G__22366;
count__22348_22358 = G__22367;
i__22349_22359 = G__22368;
continue;
} else {
var temp__5457__auto___22369 = cljs.core.seq.call(null,seq__22346_22356);
if(temp__5457__auto___22369){
var seq__22346_22370__$1 = temp__5457__auto___22369;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22346_22370__$1)){
var c__4461__auto___22371 = cljs.core.chunk_first.call(null,seq__22346_22370__$1);
var G__22372 = cljs.core.chunk_rest.call(null,seq__22346_22370__$1);
var G__22373 = c__4461__auto___22371;
var G__22374 = cljs.core.count.call(null,c__4461__auto___22371);
var G__22375 = (0);
seq__22346_22356 = G__22372;
chunk__22347_22357 = G__22373;
count__22348_22358 = G__22374;
i__22349_22359 = G__22375;
continue;
} else {
var vec__22353_22376 = cljs.core.first.call(null,seq__22346_22370__$1);
var idx_22377 = cljs.core.nth.call(null,vec__22353_22376,(0),null);
var child_22378 = cljs.core.nth.call(null,vec__22353_22376,(1),null);
var temp__5457__auto___22379__$1 = threeagent.impl.virtual_scene.__GT_node.call(null,scene,node,idx_22377,child_22378);
if(cljs.core.truth_(temp__5457__auto___22379__$1)){
var child_node_22380 = temp__5457__auto___22379__$1;
children_map.set(threeagent.impl.util.$.call(null,child_node_22380,"key"),child_node_22380);
} else {
}


var G__22381 = cljs.core.next.call(null,seq__22346_22370__$1);
var G__22382 = null;
var G__22383 = (0);
var G__22384 = (0);
seq__22346_22356 = G__22381;
chunk__22347_22357 = G__22382;
count__22348_22358 = G__22383;
i__22349_22359 = G__22384;
continue;
}
} else {
}
}
break;
}

return node;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (scene,parent,key,form){
var key__$1 = (function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,form));
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return key;
}
})();
var vec__22385 = form;
var seq__22386 = cljs.core.seq.call(null,vec__22385);
var first__22387 = cljs.core.first.call(null,seq__22386);
var seq__22386__$1 = cljs.core.next.call(null,seq__22386);
var f = first__22387;
var args = seq__22386__$1;
var reaction_ctx = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),null,new cljs.core.Keyword(null,"reaction","reaction",490869788),null], null));
var vec__22388 = reagent.ratom.run_in_reaction.call(null,((function (key__$1,vec__22385,seq__22386,first__22387,seq__22386__$1,f,args,reaction_ctx){
return (function (){
return threeagent.impl.virtual_scene.eval_fn.call(null,f,args);
});})(key__$1,vec__22385,seq__22386,first__22387,seq__22386__$1,f,args,reaction_ctx))
,reaction_ctx,"reaction",threeagent.impl.virtual_scene.on_react_BANG_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"no-cache","no-cache",1588056370),true], null));
var final_fn = cljs.core.nth.call(null,vec__22388,(0),null);
var result = cljs.core.nth.call(null,vec__22388,(1),null);
var node = threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent,key__$1,result);
threeagent.impl.util.$_BANG_.call(null,node,"render",final_fn);

threeagent.impl.util.$_BANG_.call(null,node,"form",form);

threeagent.impl.util.$_BANG_.call(null,node,"rendered-form",result);

var temp__5457__auto___22391 = threeagent.impl.util.$.call(null,reaction_ctx,"reaction");
if(cljs.core.truth_(temp__5457__auto___22391)){
var reaction_22392 = temp__5457__auto___22391;
threeagent.impl.util.$_BANG_.call(null,reaction_ctx,"scene",scene);

threeagent.impl.util.$_BANG_.call(null,reaction_ctx,"node",node);

threeagent.impl.util.$_BANG_.call(null,node,"reaction",reaction_22392);
} else {
}

return node;
}));
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.__GT_node_shallow !== 'undefined')){
} else {
threeagent.impl.virtual_scene.__GT_node_shallow = (function (){var method_table__4524__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4525__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4526__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4527__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4528__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.impl.virtual-scene","->node-shallow"),((function (method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__){
return (function (key,p__22393){
var vec__22394 = p__22393;
var seq__22395 = cljs.core.seq.call(null,vec__22394);
var first__22396 = cljs.core.first.call(null,seq__22395);
var seq__22395__$1 = cljs.core.next.call(null,seq__22395);
var l = first__22396;
var r = seq__22395__$1;
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});})(method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4528__auto__,method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (key,form){
if(cljs.core.empty_QMARK_.call(null,form)){
return null;
} else {
var m = cljs.core.meta.call(null,form);
return threeagent.impl.virtual_scene.__GT_node_shallow.call(null,threeagent.impl.virtual_scene.get_key.call(null,key,m),cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),m));
}
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (key,form){
var vec__22400 = form;
var seq__22401 = cljs.core.seq.call(null,vec__22400);
var first__22402 = cljs.core.first.call(null,seq__22401);
var seq__22401__$1 = cljs.core.next.call(null,seq__22401);
var comp_key = first__22402;
var rs = seq__22401__$1;
var first_child = cljs.core.first.call(null,rs);
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,((function (vec__22400,seq__22401,first__22402,seq__22401__$1,comp_key,rs,first_child,comp_config){
return (function (p1__22397_SHARP_){
return (((!((p1__22397_SHARP_ == null)))) && ((!(cljs.core.empty_QMARK_.call(null,p1__22397_SHARP_)))));
});})(vec__22400,seq__22401,first__22402,seq__22401__$1,comp_key,rs,first_child,comp_config))
,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"data","data",-232669377),threeagent.impl.virtual_scene.node_data.call(null,comp_key,comp_config),new cljs.core.Keyword(null,"form","form",-1624062471),form,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807),cljs.core.map_indexed.call(null,((function (vec__22400,seq__22401,first__22402,seq__22401__$1,comp_key,rs,first_child,comp_config,children){
return (function (p1__22399_SHARP_,p2__22398_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p2__22398_SHARP_));
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return p1__22399_SHARP_;
}
})(),p2__22398_SHARP_],null));
});})(vec__22400,seq__22401,first__22402,seq__22401__$1,comp_key,rs,first_child,comp_config,children))
,children)], null);
}));
threeagent.impl.virtual_scene.dispose_node_BANG_ = (function threeagent$impl$virtual_scene$dispose_node_BANG_(node){
threeagent.impl.util.$_BANG_.call(null,node,"disposed",true);

var temp__5457__auto___22403 = threeagent.impl.util.$.call(null,node,"reaction");
if(cljs.core.truth_(temp__5457__auto___22403)){
var reaction_22404 = temp__5457__auto___22403;
reagent.ratom.dispose_BANG_.call(null,reaction_22404);
} else {
}

return node.for_each_child(threeagent.impl.virtual_scene.dispose_node_BANG_);
});
threeagent.impl.virtual_scene.add_node_BANG_ = (function threeagent$impl$virtual_scene$add_node_BANG_(scene,parent_node,key,form,changelog){
var temp__5457__auto__ = threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent_node,key,form);
if(cljs.core.truth_(temp__5457__auto__)){
var node = temp__5457__auto__;
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"add","add",235287739),null,threeagent.impl.util.$.call(null,node,"data")], null));

return node;
} else {
return null;
}
});
threeagent.impl.virtual_scene.remove_node_BANG_ = (function threeagent$impl$virtual_scene$remove_node_BANG_(node,changelog){
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"remove","remove",-131428414),threeagent.impl.util.$.call(null,node,"data"),null], null));

threeagent.impl.util.$_BANG_.call(null,node,"data",null);

threeagent.impl.util.$_BANG_.call(null,node,"dirty",false);

return threeagent.impl.virtual_scene.dispose_node_BANG_.call(null,node);
});
threeagent.impl.virtual_scene.update_node_BANG_ = (function threeagent$impl$virtual_scene$update_node_BANG_(scene,node,new_form,changelog){
threeagent.impl.util.$_BANG_.call(null,node,"dirty",false);

var render_fn = threeagent.impl.util.$.call(null,node,"render");
var rendered_form = (cljs.core.truth_(render_fn)?cljs.core.apply.call(null,render_fn,cljs.core.rest.call(null,new_form)):new_form);
var old_form = threeagent.impl.util.$.call(null,node,"rendered-form");
if(cljs.core.not_EQ_.call(null,rendered_form,old_form)){
var key = threeagent.impl.util.$.call(null,node,"key");
var children = threeagent.impl.util.$.call(null,node,"children");
var old_data = threeagent.impl.util.$.call(null,node,"data");
var shallow_node = threeagent.impl.virtual_scene.__GT_node_shallow.call(null,key,rendered_form);
var new_data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(shallow_node);
var current_keys = cljs.core.set.call(null,cljs.core.es6_iterator_seq.call(null,children.keys()));
var new_keys = cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.first,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node)));
var dropped_keys = clojure.set.difference.call(null,current_keys,new_keys);
threeagent.impl.util.$_BANG_.call(null,node,"data",new_data);

if(cljs.core.truth_(render_fn)){
threeagent.impl.util.$_BANG_.call(null,node,"form",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [render_fn], null),cljs.core.rest.call(null,new_form)));
} else {
}

threeagent.impl.util.$_BANG_.call(null,node,"rendered-form",new_form);

changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"update","update",1045576396),old_data,new_data], null));

var seq__22405_22419 = cljs.core.seq.call(null,dropped_keys);
var chunk__22406_22420 = null;
var count__22407_22421 = (0);
var i__22408_22422 = (0);
while(true){
if((i__22408_22422 < count__22407_22421)){
var child_key_22423 = cljs.core._nth.call(null,chunk__22406_22420,i__22408_22422);
var child_node_22424 = children.get(child_key_22423);
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,child_node_22424,changelog);

children.delete(child_key_22423);


var G__22425 = seq__22405_22419;
var G__22426 = chunk__22406_22420;
var G__22427 = count__22407_22421;
var G__22428 = (i__22408_22422 + (1));
seq__22405_22419 = G__22425;
chunk__22406_22420 = G__22426;
count__22407_22421 = G__22427;
i__22408_22422 = G__22428;
continue;
} else {
var temp__5457__auto___22429 = cljs.core.seq.call(null,seq__22405_22419);
if(temp__5457__auto___22429){
var seq__22405_22430__$1 = temp__5457__auto___22429;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22405_22430__$1)){
var c__4461__auto___22431 = cljs.core.chunk_first.call(null,seq__22405_22430__$1);
var G__22432 = cljs.core.chunk_rest.call(null,seq__22405_22430__$1);
var G__22433 = c__4461__auto___22431;
var G__22434 = cljs.core.count.call(null,c__4461__auto___22431);
var G__22435 = (0);
seq__22405_22419 = G__22432;
chunk__22406_22420 = G__22433;
count__22407_22421 = G__22434;
i__22408_22422 = G__22435;
continue;
} else {
var child_key_22436 = cljs.core.first.call(null,seq__22405_22430__$1);
var child_node_22437 = children.get(child_key_22436);
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,child_node_22437,changelog);

children.delete(child_key_22436);


var G__22438 = cljs.core.next.call(null,seq__22405_22430__$1);
var G__22439 = null;
var G__22440 = (0);
var G__22441 = (0);
seq__22405_22419 = G__22438;
chunk__22406_22420 = G__22439;
count__22407_22421 = G__22440;
i__22408_22422 = G__22441;
continue;
}
} else {
}
}
break;
}

var seq__22409 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node));
var chunk__22410 = null;
var count__22411 = (0);
var i__22412 = (0);
while(true){
if((i__22412 < count__22411)){
var vec__22413 = cljs.core._nth.call(null,chunk__22410,i__22412);
var child_key = cljs.core.nth.call(null,vec__22413,(0),null);
var child_form = cljs.core.nth.call(null,vec__22413,(1),null);
var temp__5455__auto___22442 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___22442)){
var child_22443 = temp__5455__auto___22442;
threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,child_22443,child_form,changelog);
} else {
var temp__5457__auto___22444 = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___22444)){
var child_node_22445 = temp__5457__auto___22444;
children.set(child_key,child_node_22445);
} else {
}
}


var G__22446 = seq__22409;
var G__22447 = chunk__22410;
var G__22448 = count__22411;
var G__22449 = (i__22412 + (1));
seq__22409 = G__22446;
chunk__22410 = G__22447;
count__22411 = G__22448;
i__22412 = G__22449;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22409);
if(temp__5457__auto__){
var seq__22409__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22409__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__22409__$1);
var G__22450 = cljs.core.chunk_rest.call(null,seq__22409__$1);
var G__22451 = c__4461__auto__;
var G__22452 = cljs.core.count.call(null,c__4461__auto__);
var G__22453 = (0);
seq__22409 = G__22450;
chunk__22410 = G__22451;
count__22411 = G__22452;
i__22412 = G__22453;
continue;
} else {
var vec__22416 = cljs.core.first.call(null,seq__22409__$1);
var child_key = cljs.core.nth.call(null,vec__22416,(0),null);
var child_form = cljs.core.nth.call(null,vec__22416,(1),null);
var temp__5455__auto___22454 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___22454)){
var child_22455 = temp__5455__auto___22454;
threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,child_22455,child_form,changelog);
} else {
var temp__5457__auto___22456__$1 = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___22456__$1)){
var child_node_22457 = temp__5457__auto___22456__$1;
children.set(child_key,child_node_22457);
} else {
}
}


var G__22458 = cljs.core.next.call(null,seq__22409__$1);
var G__22459 = null;
var G__22460 = (0);
var G__22461 = (0);
seq__22409 = G__22458;
chunk__22410 = G__22459;
count__22411 = G__22460;
i__22412 = G__22461;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
threeagent.impl.virtual_scene.render_node_BANG_ = (function threeagent$impl$virtual_scene$render_node_BANG_(scene,node,changelog){
var form = threeagent.impl.util.$.call(null,node,"form");
return threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,node,form,changelog);
});
threeagent.impl.virtual_scene.render_BANG_ = (function threeagent$impl$virtual_scene$render_BANG_(scene,changelog){
reagent.core.flush.call(null);

var queue = threeagent.impl.util.$.call(null,scene,"render_queue");
var node = queue.dequeue();
while(true){
if(cljs.core.truth_(node)){
if(cljs.core.truth_(threeagent.impl.util.$.call(null,node,"dirty"))){
threeagent.impl.virtual_scene.render_node_BANG_.call(null,scene,node,changelog);
} else {
}

var G__22462 = queue.dequeue();
node = G__22462;
continue;
} else {
return null;
}
break;
}
});
threeagent.impl.virtual_scene.destroy_BANG_ = (function threeagent$impl$virtual_scene$destroy_BANG_(scene){
return threeagent.impl.virtual_scene.dispose_node_BANG_.call(null,threeagent.impl.util.$.call(null,scene,"root"));
});
threeagent.impl.virtual_scene.create = (function threeagent$impl$virtual_scene$create(root_fn){
var scene = (new threeagent.impl.virtual_scene.Scene(null,(new goog.structs.PriorityQueue())));
var root_node = threeagent.impl.virtual_scene.__GT_node.call(null,scene,null,(0),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root_fn], null));
threeagent.impl.util.$_BANG_.call(null,scene,"root",root_node);

return scene;
});

//# sourceMappingURL=virtual_scene.js.map?rel=1550945896869
