// Compiled by ClojureScript 1.10.520 {}
goog.provide('threeagent.impl.virtual_scene');
goog.require('cljs.core');
goog.require('threeagent.impl.util');
goog.require('medley.core');
goog.require('reagent.ratom');
goog.require('reagent.core');
goog.require('goog.structs.PriorityQueue');
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.non_component_keys !== 'undefined')){
} else {
threeagent.impl.virtual_scene.non_component_keys = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"rotation","rotation",-1728051644),null,new cljs.core.Keyword(null,"scale","scale",-230427353),null,new cljs.core.Keyword(null,"position","position",-2011731912),null], null), null);
}
threeagent.impl.virtual_scene.print_tree = (function threeagent$impl$virtual_scene$print_tree(var_args){
var G__2400 = arguments.length;
switch (G__2400) {
case 1:
return threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.impl.virtual_scene.print_tree.call(null,node,"");
});

threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2 = (function (node,p){
var is_reactive = (!((node.reaction == null)));
cljs.core.println.call(null,p,"|-",node.key,["comp:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node.data))].join(''),["dirty:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node.dirty)].join(''),["reactive:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(is_reactive)].join(''));

var seq__2401 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,node.children.values()));
var chunk__2402 = null;
var count__2403 = (0);
var i__2404 = (0);
while(true){
if((i__2404 < count__2403)){
var child = cljs.core._nth.call(null,chunk__2402,i__2404);
threeagent.impl.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__2406 = seq__2401;
var G__2407 = chunk__2402;
var G__2408 = count__2403;
var G__2409 = (i__2404 + (1));
seq__2401 = G__2406;
chunk__2402 = G__2407;
count__2403 = G__2408;
i__2404 = G__2409;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__2401);
if(temp__5457__auto__){
var seq__2401__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2401__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__2401__$1);
var G__2410 = cljs.core.chunk_rest.call(null,seq__2401__$1);
var G__2411 = c__4550__auto__;
var G__2412 = cljs.core.count.call(null,c__4550__auto__);
var G__2413 = (0);
seq__2401 = G__2410;
chunk__2402 = G__2411;
count__2403 = G__2412;
i__2404 = G__2413;
continue;
} else {
var child = cljs.core.first.call(null,seq__2401__$1);
threeagent.impl.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__2414 = cljs.core.next.call(null,seq__2401__$1);
var G__2415 = null;
var G__2416 = (0);
var G__2417 = (0);
seq__2401 = G__2414;
chunk__2402 = G__2415;
count__2403 = G__2416;
i__2404 = G__2417;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.impl.virtual_scene.print_tree.cljs$lang$maxFixedArity = 2;

threeagent.impl.virtual_scene.node__GT_path = (function threeagent$impl$virtual_scene$node__GT_path(var_args){
var G__2419 = arguments.length;
switch (G__2419) {
case 1:
return threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.impl.virtual_scene.node__GT_path.call(null,cljs.core.PersistentVector.EMPTY,node);
});

threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2 = (function (path,node){
while(true){
if(cljs.core.truth_(node)){
var G__2421 = cljs.core.conj.call(null,path,node.key);
var G__2422 = node.parent;
path = G__2421;
node = G__2422;
continue;
} else {
return cljs.core.reverse.call(null,path);
}
break;
}
});

threeagent.impl.virtual_scene.node__GT_path.cljs$lang$maxFixedArity = 2;

threeagent.impl.virtual_scene.get_key = (function threeagent$impl$virtual_scene$get_key(key,meta){
return new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$2(meta,key);
});

/**
* @constructor
 * @implements {threeagent.impl.virtual_scene.Object}
*/
threeagent.impl.virtual_scene.Node = (function (parent,depth,key,meta,data,dirty,render,reaction,children){
this.parent = parent;
this.depth = depth;
this.key = key;
this.meta = meta;
this.data = data;
this.dirty = dirty;
this.render = render;
this.reaction = reaction;
this.children = children;
});
threeagent.impl.virtual_scene.Node.prototype.for_each_child = (function (f){
var self__ = this;
var this$ = this;
var seq__2423 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,self__.children.values()));
var chunk__2424 = null;
var count__2425 = (0);
var i__2426 = (0);
while(true){
if((i__2426 < count__2425)){
var child = cljs.core._nth.call(null,chunk__2424,i__2426);
f.call(null,child);


var G__2427 = seq__2423;
var G__2428 = chunk__2424;
var G__2429 = count__2425;
var G__2430 = (i__2426 + (1));
seq__2423 = G__2427;
chunk__2424 = G__2428;
count__2425 = G__2429;
i__2426 = G__2430;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__2423);
if(temp__5457__auto__){
var seq__2423__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2423__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__2423__$1);
var G__2431 = cljs.core.chunk_rest.call(null,seq__2423__$1);
var G__2432 = c__4550__auto__;
var G__2433 = cljs.core.count.call(null,c__4550__auto__);
var G__2434 = (0);
seq__2423 = G__2431;
chunk__2424 = G__2432;
count__2425 = G__2433;
i__2426 = G__2434;
continue;
} else {
var child = cljs.core.first.call(null,seq__2423__$1);
f.call(null,child);


var G__2435 = cljs.core.next.call(null,seq__2423__$1);
var G__2436 = null;
var G__2437 = (0);
var G__2438 = (0);
seq__2423 = G__2435;
chunk__2424 = G__2436;
count__2425 = G__2437;
i__2426 = G__2438;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.impl.virtual_scene.Node.getBasis = (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Node","Node",446032991,null)], null)),new cljs.core.Symbol(null,"depth","depth",-885772129,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"dirty","dirty",-1924882488,null),new cljs.core.Symbol(null,"render","render",232498073,null),new cljs.core.Symbol(null,"reaction","reaction",2131401315,null),new cljs.core.Symbol(null,"children","children",699969545,null)], null);
});

threeagent.impl.virtual_scene.Node.cljs$lang$type = true;

threeagent.impl.virtual_scene.Node.cljs$lang$ctorStr = "threeagent.impl.virtual-scene/Node";

threeagent.impl.virtual_scene.Node.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"threeagent.impl.virtual-scene/Node");
});

/**
 * Positional factory function for threeagent.impl.virtual-scene/Node.
 */
threeagent.impl.virtual_scene.__GT_Node = (function threeagent$impl$virtual_scene$__GT_Node(parent,depth,key,meta,data,dirty,render,reaction,children){
return (new threeagent.impl.virtual_scene.Node(parent,depth,key,meta,data,dirty,render,reaction,children));
});


/**
* @constructor
 * @implements {threeagent.impl.virtual_scene.Object}
*/
threeagent.impl.virtual_scene.Scene = (function (root,renderQueue){
this.root = root;
this.renderQueue = renderQueue;
});
threeagent.impl.virtual_scene.Scene.prototype.enqueueForRender = (function (node){
var self__ = this;
var this$ = this;
node.dirty = true;

return self__.renderQueue.enqueue(node.depth,node);
});

threeagent.impl.virtual_scene.Scene.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"renderQueue","renderQueue",-1811767425,null)], null);
});

threeagent.impl.virtual_scene.Scene.cljs$lang$type = true;

threeagent.impl.virtual_scene.Scene.cljs$lang$ctorStr = "threeagent.impl.virtual-scene/Scene";

threeagent.impl.virtual_scene.Scene.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"threeagent.impl.virtual-scene/Scene");
});

/**
 * Positional factory function for threeagent.impl.virtual-scene/Scene.
 */
threeagent.impl.virtual_scene.__GT_Scene = (function threeagent$impl$virtual_scene$__GT_Scene(root,renderQueue){
return (new threeagent.impl.virtual_scene.Scene(root,renderQueue));
});

threeagent.impl.virtual_scene.get_in_node = (function threeagent$impl$virtual_scene$get_in_node(node,path){
while(true){
if(cljs.core.empty_QMARK_.call(null,path)){
return node;
} else {
var G__2439 = node.children.get(cljs.core.first.call(null,path));
var G__2440 = cljs.core.rest.call(null,path);
node = G__2439;
path = G__2440;
continue;
}
break;
}
});
threeagent.impl.virtual_scene.get_in_scene = (function threeagent$impl$virtual_scene$get_in_scene(scene,path){
return threeagent.impl.virtual_scene.get_in_node.call(null,scene.root,cljs.core.rest.call(null,path));
});
threeagent.impl.virtual_scene.eval_fn = (function threeagent$impl$virtual_scene$eval_fn(f,args){
while(true){
var result = cljs.core.apply.call(null,f,args);
if(cljs.core.fn_QMARK_.call(null,result)){
var G__2441 = result;
var G__2442 = args;
f = G__2441;
args = G__2442;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,result], null);
}
break;
}
});
threeagent.impl.virtual_scene.on_react_BANG_ = (function threeagent$impl$virtual_scene$on_react_BANG_(ctx){
var node = ctx.node;
var scene = ctx.scene;
return scene.enqueueForRender(node);
});
threeagent.impl.virtual_scene.extract_comp_config = (function threeagent$impl$virtual_scene$extract_comp_config(config){
var c = cljs.core.transient$.call(null,config);
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,((function (c){
return (function (p1__2443_SHARP_,p2__2444_SHARP_){
return cljs.core.dissoc_BANG_.call(null,p1__2443_SHARP_,p2__2444_SHARP_);
});})(c))
,c,threeagent.impl.virtual_scene.non_component_keys));
});
threeagent.impl.virtual_scene.node_data = (function threeagent$impl$virtual_scene$node_data(comp_key,comp_config){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"rotation","rotation",-1728051644),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"scale","scale",-230427353),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [1.0,1.0,1.0], null)),new cljs.core.Keyword(null,"component-key","component-key",1189239034),comp_key,new cljs.core.Keyword(null,"component-config","component-config",2000790546),threeagent.impl.virtual_scene.extract_comp_config.call(null,comp_config)], null);
});
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.__GT_node !== 'undefined')){
} else {
threeagent.impl.virtual_scene.__GT_node = (function (){var method_table__4613__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.impl.virtual-scene","->node"),((function (method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__){
return (function (scene,parent,key,p__2445){
var vec__2446 = p__2445;
var seq__2447 = cljs.core.seq.call(null,vec__2446);
var first__2448 = cljs.core.first.call(null,seq__2447);
var seq__2447__$1 = cljs.core.next.call(null,seq__2447);
var l = first__2448;
var r = seq__2447__$1;
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});})(method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"default","default",-1987822328),(function (scene,parent,key,form){
return cljs.core.println.call(null,"Invalid object form:",form);
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (scene,parent,key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (scene,parent,key,form){
return threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent,key,cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),cljs.core.meta.call(null,form)));
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (scene,parent,key,form){
var vec__2449 = form;
var seq__2450 = cljs.core.seq.call(null,vec__2449);
var first__2451 = cljs.core.first.call(null,seq__2450);
var seq__2450__$1 = cljs.core.next.call(null,seq__2450);
var comp_key = first__2451;
var rs = seq__2450__$1;
var first_child = cljs.core.first.call(null,rs);
var metadata = cljs.core.meta.call(null,form);
var key__$1 = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return key;
}
})();
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,cljs.core.some_QMARK_,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
var children_map = (new Map());
var data = threeagent.impl.virtual_scene.node_data.call(null,comp_key,comp_config);
var depth = (cljs.core.truth_(parent)?(parent.depth + (1)):(0));
var node = (new threeagent.impl.virtual_scene.Node(parent,depth,key__$1,metadata,data,false,null,null,children_map));
var seq__2452_2468 = cljs.core.seq.call(null,medley.core.indexed.call(null,children));
var chunk__2453_2469 = null;
var count__2454_2470 = (0);
var i__2455_2471 = (0);
while(true){
if((i__2455_2471 < count__2454_2470)){
var vec__2462_2472 = cljs.core._nth.call(null,chunk__2453_2469,i__2455_2471);
var idx_2473 = cljs.core.nth.call(null,vec__2462_2472,(0),null);
var child_2474 = cljs.core.nth.call(null,vec__2462_2472,(1),null);
var temp__5457__auto___2475 = threeagent.impl.virtual_scene.__GT_node.call(null,scene,node,idx_2473,child_2474);
if(cljs.core.truth_(temp__5457__auto___2475)){
var child_node_2476 = temp__5457__auto___2475;
children_map.set(child_node_2476.key,child_node_2476);
} else {
}


var G__2477 = seq__2452_2468;
var G__2478 = chunk__2453_2469;
var G__2479 = count__2454_2470;
var G__2480 = (i__2455_2471 + (1));
seq__2452_2468 = G__2477;
chunk__2453_2469 = G__2478;
count__2454_2470 = G__2479;
i__2455_2471 = G__2480;
continue;
} else {
var temp__5457__auto___2481 = cljs.core.seq.call(null,seq__2452_2468);
if(temp__5457__auto___2481){
var seq__2452_2482__$1 = temp__5457__auto___2481;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2452_2482__$1)){
var c__4550__auto___2483 = cljs.core.chunk_first.call(null,seq__2452_2482__$1);
var G__2484 = cljs.core.chunk_rest.call(null,seq__2452_2482__$1);
var G__2485 = c__4550__auto___2483;
var G__2486 = cljs.core.count.call(null,c__4550__auto___2483);
var G__2487 = (0);
seq__2452_2468 = G__2484;
chunk__2453_2469 = G__2485;
count__2454_2470 = G__2486;
i__2455_2471 = G__2487;
continue;
} else {
var vec__2465_2488 = cljs.core.first.call(null,seq__2452_2482__$1);
var idx_2489 = cljs.core.nth.call(null,vec__2465_2488,(0),null);
var child_2490 = cljs.core.nth.call(null,vec__2465_2488,(1),null);
var temp__5457__auto___2491__$1 = threeagent.impl.virtual_scene.__GT_node.call(null,scene,node,idx_2489,child_2490);
if(cljs.core.truth_(temp__5457__auto___2491__$1)){
var child_node_2492 = temp__5457__auto___2491__$1;
children_map.set(child_node_2492.key,child_node_2492);
} else {
}


var G__2493 = cljs.core.next.call(null,seq__2452_2482__$1);
var G__2494 = null;
var G__2495 = (0);
var G__2496 = (0);
seq__2452_2468 = G__2493;
chunk__2453_2469 = G__2494;
count__2454_2470 = G__2495;
i__2455_2471 = G__2496;
continue;
}
} else {
}
}
break;
}

return node;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (scene,parent,key,form){
var key__$1 = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,form));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return key;
}
})();
var vec__2497 = form;
var seq__2498 = cljs.core.seq.call(null,vec__2497);
var first__2499 = cljs.core.first.call(null,seq__2498);
var seq__2498__$1 = cljs.core.next.call(null,seq__2498);
var f = first__2499;
var args = seq__2498__$1;
var reaction_ctx = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),null,new cljs.core.Keyword(null,"reaction","reaction",490869788),null], null));
var vec__2500 = reagent.ratom.run_in_reaction.call(null,((function (key__$1,vec__2497,seq__2498,first__2499,seq__2498__$1,f,args,reaction_ctx){
return (function (){
return threeagent.impl.virtual_scene.eval_fn.call(null,f,args);
});})(key__$1,vec__2497,seq__2498,first__2499,seq__2498__$1,f,args,reaction_ctx))
,reaction_ctx,"reaction",threeagent.impl.virtual_scene.on_react_BANG_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"no-cache","no-cache",1588056370),true], null));
var final_fn = cljs.core.nth.call(null,vec__2500,(0),null);
var result = cljs.core.nth.call(null,vec__2500,(1),null);
var node = threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent,key__$1,result);
node.originalFn = f;

node.render = final_fn;

node.form = form;

node.renderedForm = result;

var temp__5457__auto___2503 = reaction_ctx.reaction;
if(cljs.core.truth_(temp__5457__auto___2503)){
var reaction_2504 = temp__5457__auto___2503;
reaction_ctx.scene = scene;

reaction_ctx.node = node;

node.reaction = reaction_2504;
} else {
}

return node;
}));
threeagent.impl.virtual_scene.form__GT_form_type = (function threeagent$impl$virtual_scene$form__GT_form_type(p__2505){
var vec__2506 = p__2505;
var seq__2507 = cljs.core.seq.call(null,vec__2506);
var first__2508 = cljs.core.first.call(null,seq__2507);
var seq__2507__$1 = cljs.core.next.call(null,seq__2507);
var l = first__2508;
var r = seq__2507__$1;
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.__GT_node_shallow !== 'undefined')){
} else {
threeagent.impl.virtual_scene.__GT_node_shallow = (function (){var method_table__4613__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.impl.virtual-scene","->node-shallow"),((function (method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__){
return (function (key,f){
return threeagent.impl.virtual_scene.form__GT_form_type.call(null,f);
});})(method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (key,form){
if(cljs.core.empty_QMARK_.call(null,form)){
return null;
} else {
var m = cljs.core.meta.call(null,form);
return threeagent.impl.virtual_scene.__GT_node_shallow.call(null,threeagent.impl.virtual_scene.get_key.call(null,key,m),cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),m));
}
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (key,form){
var vec__2512 = form;
var seq__2513 = cljs.core.seq.call(null,vec__2512);
var first__2514 = cljs.core.first.call(null,seq__2513);
var seq__2513__$1 = cljs.core.next.call(null,seq__2513);
var comp_key = first__2514;
var rs = seq__2513__$1;
var first_child = cljs.core.first.call(null,rs);
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,((function (vec__2512,seq__2513,first__2514,seq__2513__$1,comp_key,rs,first_child,comp_config){
return (function (p1__2509_SHARP_){
return (((!((p1__2509_SHARP_ == null)))) && ((!(cljs.core.empty_QMARK_.call(null,p1__2509_SHARP_)))));
});})(vec__2512,seq__2513,first__2514,seq__2513__$1,comp_key,rs,first_child,comp_config))
,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"data","data",-232669377),threeagent.impl.virtual_scene.node_data.call(null,comp_key,comp_config),new cljs.core.Keyword(null,"form","form",-1624062471),form,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807),cljs.core.map_indexed.call(null,((function (vec__2512,seq__2513,first__2514,seq__2513__$1,comp_key,rs,first_child,comp_config,children){
return (function (p1__2511_SHARP_,p2__2510_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p2__2510_SHARP_));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return p1__2511_SHARP_;
}
})(),p2__2510_SHARP_],null));
});})(vec__2512,seq__2513,first__2514,seq__2513__$1,comp_key,rs,first_child,comp_config,children))
,children)], null);
}));
threeagent.impl.virtual_scene.dispose_node_BANG_ = (function threeagent$impl$virtual_scene$dispose_node_BANG_(node){
node.disposed = true;

var temp__5457__auto___2515 = node.reaction;
if(cljs.core.truth_(temp__5457__auto___2515)){
var reaction_2516 = temp__5457__auto___2515;
reagent.ratom.dispose_BANG_.call(null,reaction_2516);
} else {
}

return node.for_each_child(threeagent.impl.virtual_scene.dispose_node_BANG_);
});
threeagent.impl.virtual_scene.add_node_BANG_ = (function threeagent$impl$virtual_scene$add_node_BANG_(scene,parent_node,key,form,changelog){
var temp__5457__auto__ = threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent_node,key,form);
if(cljs.core.truth_(temp__5457__auto__)){
var node = temp__5457__auto__;
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"add","add",235287739),null,node.data], null));

return node;
} else {
return null;
}
});
threeagent.impl.virtual_scene.remove_node_BANG_ = (function threeagent$impl$virtual_scene$remove_node_BANG_(node,changelog){
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"remove","remove",-131428414),node.data,null], null));

node.data = null;

node.dirty = false;

return threeagent.impl.virtual_scene.dispose_node_BANG_.call(null,node);
});
threeagent.impl.virtual_scene.replace_node_BANG_ = (function threeagent$impl$virtual_scene$replace_node_BANG_(scene,node,new_form,changelog){
var parent = node.parent;
var key = node.key;
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,node,changelog);

var new_node = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,parent,key,new_form,changelog);
return parent.children.set(key,new_node);
});
threeagent.impl.virtual_scene.diff_fn_QMARK_ = (function threeagent$impl$virtual_scene$diff_fn_QMARK_(node,new_form){
var original_fn = node.originalFn;
return (((!((original_fn == null)))) && (cljs.core.not_EQ_.call(null,original_fn,cljs.core.first.call(null,new_form))));
});
threeagent.impl.virtual_scene.update_node_BANG_ = (function threeagent$impl$virtual_scene$update_node_BANG_(scene,node,new_form,changelog){
node.dirty = false;

if(threeagent.impl.virtual_scene.diff_fn_QMARK_.call(null,node,new_form)){
return threeagent.impl.virtual_scene.replace_node_BANG_.call(null,scene,node,new_form,changelog);
} else {
var render_fn = node.render;
var original_fn = node.originalFn;
var new_type = threeagent.impl.virtual_scene.form__GT_form_type.call(null,new_form);
var rendered_form = (cljs.core.truth_((function (){var and__4120__auto__ = render_fn;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),new_type);
} else {
return and__4120__auto__;
}
})())?cljs.core.apply.call(null,render_fn,cljs.core.rest.call(null,new_form)):new_form);
var old_form = node.renderedForm;
if(cljs.core.not_EQ_.call(null,rendered_form,old_form)){
var key = node.key;
var children = node.children;
var old_data = node.data;
var shallow_node = threeagent.impl.virtual_scene.__GT_node_shallow.call(null,key,rendered_form);
var new_data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(shallow_node);
var current_keys = cljs.core.set.call(null,cljs.core.es6_iterator_seq.call(null,children.keys()));
var new_keys = cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.first,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node)));
var dropped_keys = clojure.set.difference.call(null,current_keys,new_keys);
node.data = new_data;

if(cljs.core.truth_(render_fn)){
node.form = cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [render_fn], null),cljs.core.rest.call(null,new_form));
} else {
}

node.renderedForm = new_form;

changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"update","update",1045576396),old_data,new_data], null));

var seq__2517_2537 = cljs.core.seq.call(null,dropped_keys);
var chunk__2518_2538 = null;
var count__2519_2539 = (0);
var i__2520_2540 = (0);
while(true){
if((i__2520_2540 < count__2519_2539)){
var child_key_2541 = cljs.core._nth.call(null,chunk__2518_2538,i__2520_2540);
var child_node_2542 = children.get(child_key_2541);
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,child_node_2542,changelog);

children.delete(child_key_2541);


var G__2543 = seq__2517_2537;
var G__2544 = chunk__2518_2538;
var G__2545 = count__2519_2539;
var G__2546 = (i__2520_2540 + (1));
seq__2517_2537 = G__2543;
chunk__2518_2538 = G__2544;
count__2519_2539 = G__2545;
i__2520_2540 = G__2546;
continue;
} else {
var temp__5457__auto___2547 = cljs.core.seq.call(null,seq__2517_2537);
if(temp__5457__auto___2547){
var seq__2517_2548__$1 = temp__5457__auto___2547;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2517_2548__$1)){
var c__4550__auto___2549 = cljs.core.chunk_first.call(null,seq__2517_2548__$1);
var G__2550 = cljs.core.chunk_rest.call(null,seq__2517_2548__$1);
var G__2551 = c__4550__auto___2549;
var G__2552 = cljs.core.count.call(null,c__4550__auto___2549);
var G__2553 = (0);
seq__2517_2537 = G__2550;
chunk__2518_2538 = G__2551;
count__2519_2539 = G__2552;
i__2520_2540 = G__2553;
continue;
} else {
var child_key_2554 = cljs.core.first.call(null,seq__2517_2548__$1);
var child_node_2555 = children.get(child_key_2554);
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,child_node_2555,changelog);

children.delete(child_key_2554);


var G__2556 = cljs.core.next.call(null,seq__2517_2548__$1);
var G__2557 = null;
var G__2558 = (0);
var G__2559 = (0);
seq__2517_2537 = G__2556;
chunk__2518_2538 = G__2557;
count__2519_2539 = G__2558;
i__2520_2540 = G__2559;
continue;
}
} else {
}
}
break;
}

var seq__2521 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node));
var chunk__2522 = null;
var count__2523 = (0);
var i__2524 = (0);
while(true){
if((i__2524 < count__2523)){
var vec__2531 = cljs.core._nth.call(null,chunk__2522,i__2524);
var child_key = cljs.core.nth.call(null,vec__2531,(0),null);
var child_form = cljs.core.nth.call(null,vec__2531,(1),null);
var temp__5455__auto___2560 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___2560)){
var child_2561 = temp__5455__auto___2560;
threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,child_2561,child_form,changelog);
} else {
var temp__5457__auto___2562 = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___2562)){
var child_node_2563 = temp__5457__auto___2562;
children.set(child_key,child_node_2563);
} else {
}
}


var G__2564 = seq__2521;
var G__2565 = chunk__2522;
var G__2566 = count__2523;
var G__2567 = (i__2524 + (1));
seq__2521 = G__2564;
chunk__2522 = G__2565;
count__2523 = G__2566;
i__2524 = G__2567;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__2521);
if(temp__5457__auto__){
var seq__2521__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2521__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__2521__$1);
var G__2568 = cljs.core.chunk_rest.call(null,seq__2521__$1);
var G__2569 = c__4550__auto__;
var G__2570 = cljs.core.count.call(null,c__4550__auto__);
var G__2571 = (0);
seq__2521 = G__2568;
chunk__2522 = G__2569;
count__2523 = G__2570;
i__2524 = G__2571;
continue;
} else {
var vec__2534 = cljs.core.first.call(null,seq__2521__$1);
var child_key = cljs.core.nth.call(null,vec__2534,(0),null);
var child_form = cljs.core.nth.call(null,vec__2534,(1),null);
var temp__5455__auto___2572 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___2572)){
var child_2573 = temp__5455__auto___2572;
threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,child_2573,child_form,changelog);
} else {
var temp__5457__auto___2574__$1 = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___2574__$1)){
var child_node_2575 = temp__5457__auto___2574__$1;
children.set(child_key,child_node_2575);
} else {
}
}


var G__2576 = cljs.core.next.call(null,seq__2521__$1);
var G__2577 = null;
var G__2578 = (0);
var G__2579 = (0);
seq__2521 = G__2576;
chunk__2522 = G__2577;
count__2523 = G__2578;
i__2524 = G__2579;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
}
});
threeagent.impl.virtual_scene.render_node_BANG_ = (function threeagent$impl$virtual_scene$render_node_BANG_(scene,node,changelog){
var form = node.form;
return threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,node,form,changelog);
});
threeagent.impl.virtual_scene.render_BANG_ = (function threeagent$impl$virtual_scene$render_BANG_(scene,changelog){
reagent.core.flush.call(null);

var queue = scene.renderQueue;
var node = queue.dequeue();
while(true){
if(cljs.core.truth_(node)){
if(cljs.core.truth_(node.dirty)){
threeagent.impl.virtual_scene.render_node_BANG_.call(null,scene,node,changelog);
} else {
}

var G__2580 = queue.dequeue();
node = G__2580;
continue;
} else {
return null;
}
break;
}
});
threeagent.impl.virtual_scene.destroy_BANG_ = (function threeagent$impl$virtual_scene$destroy_BANG_(scene){
return threeagent.impl.virtual_scene.dispose_node_BANG_.call(null,scene.root);
});
threeagent.impl.virtual_scene.create = (function threeagent$impl$virtual_scene$create(root_fn){
var scene = (new threeagent.impl.virtual_scene.Scene(null,(new goog.structs.PriorityQueue())));
var root_node = threeagent.impl.virtual_scene.__GT_node.call(null,scene,null,(0),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root_fn], null));
scene.root = root_node;

return scene;
});

//# sourceMappingURL=virtual_scene.js.map
