// Compiled by ClojureScript 1.10.520 {}
goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__32419){
var map__32420 = p__32419;
var map__32420__$1 = (((((!((map__32420 == null))))?(((((map__32420.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32420.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32420):map__32420);
var m = map__32420__$1;
var n = cljs.core.get.call(null,map__32420__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__32420__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return [(function (){var temp__5457__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5457__auto__)){
var ns = temp__5457__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__32422_32454 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__32423_32455 = null;
var count__32424_32456 = (0);
var i__32425_32457 = (0);
while(true){
if((i__32425_32457 < count__32424_32456)){
var f_32458 = cljs.core._nth.call(null,chunk__32423_32455,i__32425_32457);
cljs.core.println.call(null,"  ",f_32458);


var G__32459 = seq__32422_32454;
var G__32460 = chunk__32423_32455;
var G__32461 = count__32424_32456;
var G__32462 = (i__32425_32457 + (1));
seq__32422_32454 = G__32459;
chunk__32423_32455 = G__32460;
count__32424_32456 = G__32461;
i__32425_32457 = G__32462;
continue;
} else {
var temp__5457__auto___32463 = cljs.core.seq.call(null,seq__32422_32454);
if(temp__5457__auto___32463){
var seq__32422_32464__$1 = temp__5457__auto___32463;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32422_32464__$1)){
var c__4550__auto___32465 = cljs.core.chunk_first.call(null,seq__32422_32464__$1);
var G__32466 = cljs.core.chunk_rest.call(null,seq__32422_32464__$1);
var G__32467 = c__4550__auto___32465;
var G__32468 = cljs.core.count.call(null,c__4550__auto___32465);
var G__32469 = (0);
seq__32422_32454 = G__32466;
chunk__32423_32455 = G__32467;
count__32424_32456 = G__32468;
i__32425_32457 = G__32469;
continue;
} else {
var f_32470 = cljs.core.first.call(null,seq__32422_32464__$1);
cljs.core.println.call(null,"  ",f_32470);


var G__32471 = cljs.core.next.call(null,seq__32422_32464__$1);
var G__32472 = null;
var G__32473 = (0);
var G__32474 = (0);
seq__32422_32454 = G__32471;
chunk__32423_32455 = G__32472;
count__32424_32456 = G__32473;
i__32425_32457 = G__32474;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_32475 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_32475);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_32475)))?cljs.core.second.call(null,arglists_32475):arglists_32475));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__32426_32476 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__32427_32477 = null;
var count__32428_32478 = (0);
var i__32429_32479 = (0);
while(true){
if((i__32429_32479 < count__32428_32478)){
var vec__32440_32480 = cljs.core._nth.call(null,chunk__32427_32477,i__32429_32479);
var name_32481 = cljs.core.nth.call(null,vec__32440_32480,(0),null);
var map__32443_32482 = cljs.core.nth.call(null,vec__32440_32480,(1),null);
var map__32443_32483__$1 = (((((!((map__32443_32482 == null))))?(((((map__32443_32482.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32443_32482.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32443_32482):map__32443_32482);
var doc_32484 = cljs.core.get.call(null,map__32443_32483__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_32485 = cljs.core.get.call(null,map__32443_32483__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_32481);

cljs.core.println.call(null," ",arglists_32485);

if(cljs.core.truth_(doc_32484)){
cljs.core.println.call(null," ",doc_32484);
} else {
}


var G__32486 = seq__32426_32476;
var G__32487 = chunk__32427_32477;
var G__32488 = count__32428_32478;
var G__32489 = (i__32429_32479 + (1));
seq__32426_32476 = G__32486;
chunk__32427_32477 = G__32487;
count__32428_32478 = G__32488;
i__32429_32479 = G__32489;
continue;
} else {
var temp__5457__auto___32490 = cljs.core.seq.call(null,seq__32426_32476);
if(temp__5457__auto___32490){
var seq__32426_32491__$1 = temp__5457__auto___32490;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32426_32491__$1)){
var c__4550__auto___32492 = cljs.core.chunk_first.call(null,seq__32426_32491__$1);
var G__32493 = cljs.core.chunk_rest.call(null,seq__32426_32491__$1);
var G__32494 = c__4550__auto___32492;
var G__32495 = cljs.core.count.call(null,c__4550__auto___32492);
var G__32496 = (0);
seq__32426_32476 = G__32493;
chunk__32427_32477 = G__32494;
count__32428_32478 = G__32495;
i__32429_32479 = G__32496;
continue;
} else {
var vec__32445_32497 = cljs.core.first.call(null,seq__32426_32491__$1);
var name_32498 = cljs.core.nth.call(null,vec__32445_32497,(0),null);
var map__32448_32499 = cljs.core.nth.call(null,vec__32445_32497,(1),null);
var map__32448_32500__$1 = (((((!((map__32448_32499 == null))))?(((((map__32448_32499.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32448_32499.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32448_32499):map__32448_32499);
var doc_32501 = cljs.core.get.call(null,map__32448_32500__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_32502 = cljs.core.get.call(null,map__32448_32500__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_32498);

cljs.core.println.call(null," ",arglists_32502);

if(cljs.core.truth_(doc_32501)){
cljs.core.println.call(null," ",doc_32501);
} else {
}


var G__32503 = cljs.core.next.call(null,seq__32426_32491__$1);
var G__32504 = null;
var G__32505 = (0);
var G__32506 = (0);
seq__32426_32476 = G__32503;
chunk__32427_32477 = G__32504;
count__32428_32478 = G__32505;
i__32429_32479 = G__32506;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5457__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5457__auto__)){
var fnspec = temp__5457__auto__;
cljs.core.print.call(null,"Spec");

var seq__32450 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__32451 = null;
var count__32452 = (0);
var i__32453 = (0);
while(true){
if((i__32453 < count__32452)){
var role = cljs.core._nth.call(null,chunk__32451,i__32453);
var temp__5457__auto___32507__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5457__auto___32507__$1)){
var spec_32508 = temp__5457__auto___32507__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_32508));
} else {
}


var G__32509 = seq__32450;
var G__32510 = chunk__32451;
var G__32511 = count__32452;
var G__32512 = (i__32453 + (1));
seq__32450 = G__32509;
chunk__32451 = G__32510;
count__32452 = G__32511;
i__32453 = G__32512;
continue;
} else {
var temp__5457__auto____$1 = cljs.core.seq.call(null,seq__32450);
if(temp__5457__auto____$1){
var seq__32450__$1 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32450__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__32450__$1);
var G__32513 = cljs.core.chunk_rest.call(null,seq__32450__$1);
var G__32514 = c__4550__auto__;
var G__32515 = cljs.core.count.call(null,c__4550__auto__);
var G__32516 = (0);
seq__32450 = G__32513;
chunk__32451 = G__32514;
count__32452 = G__32515;
i__32453 = G__32516;
continue;
} else {
var role = cljs.core.first.call(null,seq__32450__$1);
var temp__5457__auto___32517__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5457__auto___32517__$2)){
var spec_32518 = temp__5457__auto___32517__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_32518));
} else {
}


var G__32519 = cljs.core.next.call(null,seq__32450__$1);
var G__32520 = null;
var G__32521 = (0);
var G__32522 = (0);
seq__32450 = G__32519;
chunk__32451 = G__32520;
count__32452 = G__32521;
i__32453 = G__32522;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof EvalError))?new cljs.core.Symbol("js","EvalError","js/EvalError",1793498501,null):(((t instanceof RangeError))?new cljs.core.Symbol("js","RangeError","js/RangeError",1703848089,null):(((t instanceof ReferenceError))?new cljs.core.Symbol("js","ReferenceError","js/ReferenceError",-198403224,null):(((t instanceof SyntaxError))?new cljs.core.Symbol("js","SyntaxError","js/SyntaxError",-1527651665,null):(((t instanceof URIError))?new cljs.core.Symbol("js","URIError","js/URIError",505061350,null):(((t instanceof Error))?new cljs.core.Symbol("js","Error","js/Error",-1692659266,null):null
)))))))], null),(function (){var temp__5457__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5457__auto__)){
var msg = temp__5457__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5457__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5457__auto__)){
var ed = temp__5457__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__32523 = cljs.core.conj.call(null,via,t);
var G__32524 = cljs.core.ex_cause.call(null,t);
via = G__32523;
t = G__32524;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5457__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5457__auto__)){
var root_msg = temp__5457__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5457__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5457__auto__)){
var data = temp__5457__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5457__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5457__auto__)){
var phase = temp__5457__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__32527 = datafied_throwable;
var map__32527__$1 = (((((!((map__32527 == null))))?(((((map__32527.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32527.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32527):map__32527);
var via = cljs.core.get.call(null,map__32527__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__32527__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__32527__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__32528 = cljs.core.last.call(null,via);
var map__32528__$1 = (((((!((map__32528 == null))))?(((((map__32528.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32528.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32528):map__32528);
var type = cljs.core.get.call(null,map__32528__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__32528__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__32528__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__32529 = data;
var map__32529__$1 = (((((!((map__32529 == null))))?(((((map__32529.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32529.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32529):map__32529);
var problems = cljs.core.get.call(null,map__32529__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__32529__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__32529__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__32530 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__32530__$1 = (((((!((map__32530 == null))))?(((((map__32530.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32530.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32530):map__32530);
var top_data = map__32530__$1;
var source = cljs.core.get.call(null,map__32530__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__32535 = phase;
var G__32535__$1 = (((G__32535 instanceof cljs.core.Keyword))?G__32535.fqn:null);
switch (G__32535__$1) {
case "read-source":
var map__32536 = data;
var map__32536__$1 = (((((!((map__32536 == null))))?(((((map__32536.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32536.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32536):map__32536);
var line = cljs.core.get.call(null,map__32536__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__32536__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__32538 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__32538__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__32538,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__32538);
var G__32538__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__32538__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__32538__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__32538__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__32538__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__32539 = top_data;
var G__32539__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__32539,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__32539);
var G__32539__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__32539__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__32539__$1);
var G__32539__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__32539__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__32539__$2);
var G__32539__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__32539__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__32539__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__32539__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__32539__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__32540 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__32540,(0),null);
var method = cljs.core.nth.call(null,vec__32540,(1),null);
var file = cljs.core.nth.call(null,vec__32540,(2),null);
var line = cljs.core.nth.call(null,vec__32540,(3),null);
var G__32543 = top_data;
var G__32543__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__32543,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__32543);
var G__32543__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__32543__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__32543__$1);
var G__32543__$3 = (cljs.core.truth_((function (){var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.call(null,G__32543__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__32543__$2);
var G__32543__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__32543__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__32543__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__32543__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__32543__$4;
}

break;
case "execution":
var vec__32544 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__32544,(0),null);
var method = cljs.core.nth.call(null,vec__32544,(1),null);
var file = cljs.core.nth.call(null,vec__32544,(2),null);
var line = cljs.core.nth.call(null,vec__32544,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,((function (vec__32544,source__$1,method,file,line,G__32535,G__32535__$1,map__32527,map__32527__$1,via,trace,phase,map__32528,map__32528__$1,type,message,data,map__32529,map__32529__$1,problems,fn,caller,map__32530,map__32530__$1,top_data,source){
return (function (p1__32526_SHARP_){
var or__4131__auto__ = (p1__32526_SHARP_ == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__32526_SHARP_);
}
});})(vec__32544,source__$1,method,file,line,G__32535,G__32535__$1,map__32527,map__32527__$1,via,trace,phase,map__32528,map__32528__$1,type,message,data,map__32529,map__32529__$1,problems,fn,caller,map__32530,map__32530__$1,top_data,source))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return line;
}
})();
var G__32547 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__32547__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__32547,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__32547);
var G__32547__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__32547__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__32547__$1);
var G__32547__$3 = (cljs.core.truth_((function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
}
})())?cljs.core.assoc.call(null,G__32547__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__32547__$2);
var G__32547__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__32547__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__32547__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__32547__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__32547__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32535__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__32551){
var map__32552 = p__32551;
var map__32552__$1 = (((((!((map__32552 == null))))?(((((map__32552.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32552.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32552):map__32552);
var triage_data = map__32552__$1;
var phase = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4131__auto__ = class$;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__32554 = phase;
var G__32554__$1 = (((G__32554 instanceof cljs.core.Keyword))?G__32554.fqn:null);
switch (G__32554__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__32555_32564 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__32556_32565 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__32557_32566 = true;
var _STAR_print_fn_STAR__temp_val__32558_32567 = ((function (_STAR_print_newline_STAR__orig_val__32555_32564,_STAR_print_fn_STAR__orig_val__32556_32565,_STAR_print_newline_STAR__temp_val__32557_32566,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__32555_32564,_STAR_print_fn_STAR__orig_val__32556_32565,_STAR_print_newline_STAR__temp_val__32557_32566,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__32557_32566;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__32558_32567;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__32555_32564,_STAR_print_fn_STAR__orig_val__32556_32565,_STAR_print_newline_STAR__temp_val__32557_32566,_STAR_print_fn_STAR__temp_val__32558_32567,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__32555_32564,_STAR_print_fn_STAR__orig_val__32556_32565,_STAR_print_newline_STAR__temp_val__32557_32566,_STAR_print_fn_STAR__temp_val__32558_32567,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__32549_SHARP_){
return cljs.core.dissoc.call(null,p1__32549_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__32555_32564,_STAR_print_fn_STAR__orig_val__32556_32565,_STAR_print_newline_STAR__temp_val__32557_32566,_STAR_print_fn_STAR__temp_val__32558_32567,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__32555_32564,_STAR_print_fn_STAR__orig_val__32556_32565,_STAR_print_newline_STAR__temp_val__32557_32566,_STAR_print_fn_STAR__temp_val__32558_32567,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__32556_32565;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__32555_32564;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__32559_32568 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__32560_32569 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__32561_32570 = true;
var _STAR_print_fn_STAR__temp_val__32562_32571 = ((function (_STAR_print_newline_STAR__orig_val__32559_32568,_STAR_print_fn_STAR__orig_val__32560_32569,_STAR_print_newline_STAR__temp_val__32561_32570,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__32559_32568,_STAR_print_fn_STAR__orig_val__32560_32569,_STAR_print_newline_STAR__temp_val__32561_32570,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__32561_32570;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__32562_32571;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__32559_32568,_STAR_print_fn_STAR__orig_val__32560_32569,_STAR_print_newline_STAR__temp_val__32561_32570,_STAR_print_fn_STAR__temp_val__32562_32571,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__32559_32568,_STAR_print_fn_STAR__orig_val__32560_32569,_STAR_print_newline_STAR__temp_val__32561_32570,_STAR_print_fn_STAR__temp_val__32562_32571,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__32550_SHARP_){
return cljs.core.dissoc.call(null,p1__32550_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__32559_32568,_STAR_print_fn_STAR__orig_val__32560_32569,_STAR_print_newline_STAR__temp_val__32561_32570,_STAR_print_fn_STAR__temp_val__32562_32571,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__32559_32568,_STAR_print_fn_STAR__orig_val__32560_32569,_STAR_print_newline_STAR__temp_val__32561_32570,_STAR_print_fn_STAR__temp_val__32562_32571,sb__4661__auto__,G__32554,G__32554__$1,loc,class_name,simple_class,cause_type,format,map__32552,map__32552__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__32560_32569;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__32559_32568;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32554__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=repl.js.map?rel=1552158901887
