// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.impl.virtual_scene');
goog.require('cljs.core');
goog.require('threeagent.impl.util');
goog.require('medley.core');
goog.require('reagent.ratom');
goog.require('reagent.core');
goog.require('goog.structs.PriorityQueue');
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.non_component_keys !== 'undefined')){
} else {
threeagent.impl.virtual_scene.non_component_keys = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"rotation","rotation",-1728051644),null,new cljs.core.Keyword(null,"scale","scale",-230427353),null,new cljs.core.Keyword(null,"position","position",-2011731912),null], null), null);
}
threeagent.impl.virtual_scene.print_tree = (function threeagent$impl$virtual_scene$print_tree(var_args){
var G__24761 = arguments.length;
switch (G__24761) {
case 1:
return threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.impl.virtual_scene.print_tree.call(null,node,"");
});

threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2 = (function (node,p){
var is_reactive = (!((threeagent.impl.util.$.call(null,node,"reaction") == null)));
cljs.core.println.call(null,p,"|-",threeagent.impl.util.$.call(null,node,"key"),["dirty:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(threeagent.impl.util.$.call(null,node,"dirty"))].join(''),["reactive:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(is_reactive)].join(''),threeagent.impl.util.$.call(null,node,"render"));

var seq__24762 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,threeagent.impl.util.$.call(null,node,"children").values()));
var chunk__24763 = null;
var count__24764 = (0);
var i__24765 = (0);
while(true){
if((i__24765 < count__24764)){
var child = cljs.core._nth.call(null,chunk__24763,i__24765);
threeagent.impl.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__24767 = seq__24762;
var G__24768 = chunk__24763;
var G__24769 = count__24764;
var G__24770 = (i__24765 + (1));
seq__24762 = G__24767;
chunk__24763 = G__24768;
count__24764 = G__24769;
i__24765 = G__24770;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__24762);
if(temp__5457__auto__){
var seq__24762__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24762__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__24762__$1);
var G__24771 = cljs.core.chunk_rest.call(null,seq__24762__$1);
var G__24772 = c__4461__auto__;
var G__24773 = cljs.core.count.call(null,c__4461__auto__);
var G__24774 = (0);
seq__24762 = G__24771;
chunk__24763 = G__24772;
count__24764 = G__24773;
i__24765 = G__24774;
continue;
} else {
var child = cljs.core.first.call(null,seq__24762__$1);
threeagent.impl.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__24775 = cljs.core.next.call(null,seq__24762__$1);
var G__24776 = null;
var G__24777 = (0);
var G__24778 = (0);
seq__24762 = G__24775;
chunk__24763 = G__24776;
count__24764 = G__24777;
i__24765 = G__24778;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.impl.virtual_scene.print_tree.cljs$lang$maxFixedArity = 2;

threeagent.impl.virtual_scene.node__GT_path = (function threeagent$impl$virtual_scene$node__GT_path(var_args){
var G__24780 = arguments.length;
switch (G__24780) {
case 1:
return threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.impl.virtual_scene.node__GT_path.call(null,cljs.core.PersistentVector.EMPTY,node);
});

threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2 = (function (path,node){
while(true){
if(cljs.core.truth_(node)){
var G__24782 = cljs.core.conj.call(null,path,threeagent.impl.util.$.call(null,node,"key"));
var G__24783 = threeagent.impl.util.$.call(null,node,"parent");
path = G__24782;
node = G__24783;
continue;
} else {
return cljs.core.reverse.call(null,path);
}
break;
}
});

threeagent.impl.virtual_scene.node__GT_path.cljs$lang$maxFixedArity = 2;

threeagent.impl.virtual_scene.get_in_node = (function threeagent$impl$virtual_scene$get_in_node(node,path){
while(true){
if(cljs.core.empty_QMARK_.call(null,path)){
return node;
} else {
var G__24784 = threeagent.impl.util.$.call(null,node,"children").get(cljs.core.first.call(null,path));
var G__24785 = cljs.core.rest.call(null,path);
node = G__24784;
path = G__24785;
continue;
}
break;
}
});
threeagent.impl.virtual_scene.get_key = (function threeagent$impl$virtual_scene$get_key(key,meta){
return new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$2(meta,key);
});

/**
* @constructor
 * @implements {threeagent.impl.virtual_scene.Object}
*/
threeagent.impl.virtual_scene.Node = (function (parent,depth,key,meta,data,dirty,render,reaction,children){
this.parent = parent;
this.depth = depth;
this.key = key;
this.meta = meta;
this.data = data;
this.dirty = dirty;
this.render = render;
this.reaction = reaction;
this.children = children;
});
threeagent.impl.virtual_scene.Node.prototype.for_each_child = (function (f){
var self__ = this;
var this$ = this;
var seq__24786 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,self__.children.values()));
var chunk__24787 = null;
var count__24788 = (0);
var i__24789 = (0);
while(true){
if((i__24789 < count__24788)){
var child = cljs.core._nth.call(null,chunk__24787,i__24789);
f.call(null,child);


var G__24790 = seq__24786;
var G__24791 = chunk__24787;
var G__24792 = count__24788;
var G__24793 = (i__24789 + (1));
seq__24786 = G__24790;
chunk__24787 = G__24791;
count__24788 = G__24792;
i__24789 = G__24793;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__24786);
if(temp__5457__auto__){
var seq__24786__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24786__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__24786__$1);
var G__24794 = cljs.core.chunk_rest.call(null,seq__24786__$1);
var G__24795 = c__4461__auto__;
var G__24796 = cljs.core.count.call(null,c__4461__auto__);
var G__24797 = (0);
seq__24786 = G__24794;
chunk__24787 = G__24795;
count__24788 = G__24796;
i__24789 = G__24797;
continue;
} else {
var child = cljs.core.first.call(null,seq__24786__$1);
f.call(null,child);


var G__24798 = cljs.core.next.call(null,seq__24786__$1);
var G__24799 = null;
var G__24800 = (0);
var G__24801 = (0);
seq__24786 = G__24798;
chunk__24787 = G__24799;
count__24788 = G__24800;
i__24789 = G__24801;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.impl.virtual_scene.Node.getBasis = (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.Symbol(null,"depth","depth",-885772129,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"dirty","dirty",-1924882488,null),new cljs.core.Symbol(null,"render","render",232498073,null),new cljs.core.Symbol(null,"reaction","reaction",2131401315,null),new cljs.core.Symbol(null,"children","children",699969545,null)], null);
});

threeagent.impl.virtual_scene.Node.cljs$lang$type = true;

threeagent.impl.virtual_scene.Node.cljs$lang$ctorStr = "threeagent.impl.virtual-scene/Node";

threeagent.impl.virtual_scene.Node.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"threeagent.impl.virtual-scene/Node");
});

/**
 * Positional factory function for threeagent.impl.virtual-scene/Node.
 */
threeagent.impl.virtual_scene.__GT_Node = (function threeagent$impl$virtual_scene$__GT_Node(parent,depth,key,meta,data,dirty,render,reaction,children){
return (new threeagent.impl.virtual_scene.Node(parent,depth,key,meta,data,dirty,render,reaction,children));
});


/**
* @constructor
 * @implements {threeagent.impl.virtual_scene.Object}
*/
threeagent.impl.virtual_scene.Scene = (function (root,render_queue){
this.root = root;
this.render_queue = render_queue;
});
threeagent.impl.virtual_scene.Scene.prototype.enqueue_for_render = (function (node){
var self__ = this;
var this$ = this;
threeagent.impl.util.$_BANG_.call(null,node,"dirty",true);

return self__.render_queue.enqueue(threeagent.impl.util.$.call(null,node,"depth"),node);
});

threeagent.impl.virtual_scene.Scene.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"render-queue","render-queue",-1084920245,null)], null);
});

threeagent.impl.virtual_scene.Scene.cljs$lang$type = true;

threeagent.impl.virtual_scene.Scene.cljs$lang$ctorStr = "threeagent.impl.virtual-scene/Scene";

threeagent.impl.virtual_scene.Scene.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"threeagent.impl.virtual-scene/Scene");
});

/**
 * Positional factory function for threeagent.impl.virtual-scene/Scene.
 */
threeagent.impl.virtual_scene.__GT_Scene = (function threeagent$impl$virtual_scene$__GT_Scene(root,render_queue){
return (new threeagent.impl.virtual_scene.Scene(root,render_queue));
});

threeagent.impl.virtual_scene.eval_fn = (function threeagent$impl$virtual_scene$eval_fn(f,args){
while(true){
var result = cljs.core.apply.call(null,f,args);
if(cljs.core.fn_QMARK_.call(null,result)){
var G__24802 = result;
var G__24803 = args;
f = G__24802;
args = G__24803;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,result], null);
}
break;
}
});
threeagent.impl.virtual_scene.on_react_BANG_ = (function threeagent$impl$virtual_scene$on_react_BANG_(ctx){
var node = threeagent.impl.util.$.call(null,ctx,"node");
var scene = threeagent.impl.util.$.call(null,ctx,"scene");
return scene.enqueue_for_render(node);
});
threeagent.impl.virtual_scene.extract_comp_config = (function threeagent$impl$virtual_scene$extract_comp_config(config){
var c = cljs.core.transient$.call(null,config);
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,((function (c){
return (function (p1__24804_SHARP_,p2__24805_SHARP_){
return cljs.core.dissoc_BANG_.call(null,p1__24804_SHARP_,p2__24805_SHARP_);
});})(c))
,c,threeagent.impl.virtual_scene.non_component_keys));
});
threeagent.impl.virtual_scene.node_data = (function threeagent$impl$virtual_scene$node_data(comp_key,comp_config){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"rotation","rotation",-1728051644),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"scale","scale",-230427353),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [1.0,1.0,1.0], null)),new cljs.core.Keyword(null,"component-key","component-key",1189239034),comp_key,new cljs.core.Keyword(null,"component-config","component-config",2000790546),threeagent.impl.virtual_scene.extract_comp_config.call(null,comp_config)], null);
});
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.__GT_node !== 'undefined')){
} else {
threeagent.impl.virtual_scene.__GT_node = (function (){var method_table__4524__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4525__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4526__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4527__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4528__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.impl.virtual-scene","->node"),((function (method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__){
return (function (scene,parent,key,p__24806){
var vec__24807 = p__24806;
var seq__24808 = cljs.core.seq.call(null,vec__24807);
var first__24809 = cljs.core.first.call(null,seq__24808);
var seq__24808__$1 = cljs.core.next.call(null,seq__24808);
var l = first__24809;
var r = seq__24808__$1;
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});})(method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4528__auto__,method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"default","default",-1987822328),(function (scene,parent,key,form){
return cljs.core.println.call(null,"Invalid object form:",form);
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (scene,parent,key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (scene,parent,key,form){
return threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent,key,cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),cljs.core.meta.call(null,form)));
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (scene,parent,key,form){
var vec__24810 = form;
var seq__24811 = cljs.core.seq.call(null,vec__24810);
var first__24812 = cljs.core.first.call(null,seq__24811);
var seq__24811__$1 = cljs.core.next.call(null,seq__24811);
var comp_key = first__24812;
var rs = seq__24811__$1;
var first_child = cljs.core.first.call(null,rs);
var metadata = cljs.core.meta.call(null,form);
var key__$1 = (function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return key;
}
})();
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,cljs.core.some_QMARK_,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
var children_map = (new Map());
var data = threeagent.impl.virtual_scene.node_data.call(null,comp_key,comp_config);
var depth = (cljs.core.truth_(parent)?(threeagent.impl.util.$.call(null,parent,"depth") + (1)):(0));
var node = (new threeagent.impl.virtual_scene.Node(parent,depth,key__$1,metadata,data,false,null,null,children_map));
var seq__24813_24823 = cljs.core.seq.call(null,medley.core.indexed.call(null,children));
var chunk__24814_24824 = null;
var count__24815_24825 = (0);
var i__24816_24826 = (0);
while(true){
if((i__24816_24826 < count__24815_24825)){
var vec__24817_24827 = cljs.core._nth.call(null,chunk__24814_24824,i__24816_24826);
var idx_24828 = cljs.core.nth.call(null,vec__24817_24827,(0),null);
var child_24829 = cljs.core.nth.call(null,vec__24817_24827,(1),null);
var temp__5457__auto___24830 = threeagent.impl.virtual_scene.__GT_node.call(null,scene,node,idx_24828,child_24829);
if(cljs.core.truth_(temp__5457__auto___24830)){
var child_node_24831 = temp__5457__auto___24830;
children_map.set(threeagent.impl.util.$.call(null,child_node_24831,"key"),child_node_24831);
} else {
}


var G__24832 = seq__24813_24823;
var G__24833 = chunk__24814_24824;
var G__24834 = count__24815_24825;
var G__24835 = (i__24816_24826 + (1));
seq__24813_24823 = G__24832;
chunk__24814_24824 = G__24833;
count__24815_24825 = G__24834;
i__24816_24826 = G__24835;
continue;
} else {
var temp__5457__auto___24836 = cljs.core.seq.call(null,seq__24813_24823);
if(temp__5457__auto___24836){
var seq__24813_24837__$1 = temp__5457__auto___24836;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24813_24837__$1)){
var c__4461__auto___24838 = cljs.core.chunk_first.call(null,seq__24813_24837__$1);
var G__24839 = cljs.core.chunk_rest.call(null,seq__24813_24837__$1);
var G__24840 = c__4461__auto___24838;
var G__24841 = cljs.core.count.call(null,c__4461__auto___24838);
var G__24842 = (0);
seq__24813_24823 = G__24839;
chunk__24814_24824 = G__24840;
count__24815_24825 = G__24841;
i__24816_24826 = G__24842;
continue;
} else {
var vec__24820_24843 = cljs.core.first.call(null,seq__24813_24837__$1);
var idx_24844 = cljs.core.nth.call(null,vec__24820_24843,(0),null);
var child_24845 = cljs.core.nth.call(null,vec__24820_24843,(1),null);
var temp__5457__auto___24846__$1 = threeagent.impl.virtual_scene.__GT_node.call(null,scene,node,idx_24844,child_24845);
if(cljs.core.truth_(temp__5457__auto___24846__$1)){
var child_node_24847 = temp__5457__auto___24846__$1;
children_map.set(threeagent.impl.util.$.call(null,child_node_24847,"key"),child_node_24847);
} else {
}


var G__24848 = cljs.core.next.call(null,seq__24813_24837__$1);
var G__24849 = null;
var G__24850 = (0);
var G__24851 = (0);
seq__24813_24823 = G__24848;
chunk__24814_24824 = G__24849;
count__24815_24825 = G__24850;
i__24816_24826 = G__24851;
continue;
}
} else {
}
}
break;
}

return node;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (scene,parent,key,form){
var key__$1 = (function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,form));
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return key;
}
})();
var vec__24852 = form;
var seq__24853 = cljs.core.seq.call(null,vec__24852);
var first__24854 = cljs.core.first.call(null,seq__24853);
var seq__24853__$1 = cljs.core.next.call(null,seq__24853);
var f = first__24854;
var args = seq__24853__$1;
var reaction_ctx = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),null,new cljs.core.Keyword(null,"reaction","reaction",490869788),null], null));
var vec__24855 = reagent.ratom.run_in_reaction.call(null,((function (key__$1,vec__24852,seq__24853,first__24854,seq__24853__$1,f,args,reaction_ctx){
return (function (){
return threeagent.impl.virtual_scene.eval_fn.call(null,f,args);
});})(key__$1,vec__24852,seq__24853,first__24854,seq__24853__$1,f,args,reaction_ctx))
,reaction_ctx,"reaction",threeagent.impl.virtual_scene.on_react_BANG_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"no-cache","no-cache",1588056370),true], null));
var final_fn = cljs.core.nth.call(null,vec__24855,(0),null);
var result = cljs.core.nth.call(null,vec__24855,(1),null);
var node = threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent,key__$1,result);
threeagent.impl.util.$_BANG_.call(null,node,"render",final_fn);

threeagent.impl.util.$_BANG_.call(null,node,"form",form);

threeagent.impl.util.$_BANG_.call(null,node,"rendered-form",result);

var temp__5457__auto___24858 = threeagent.impl.util.$.call(null,reaction_ctx,"reaction");
if(cljs.core.truth_(temp__5457__auto___24858)){
var reaction_24859 = temp__5457__auto___24858;
threeagent.impl.util.$_BANG_.call(null,reaction_ctx,"scene",scene);

threeagent.impl.util.$_BANG_.call(null,reaction_ctx,"node",node);

threeagent.impl.util.$_BANG_.call(null,node,"reaction",reaction_24859);
} else {
}

return node;
}));
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.__GT_node_shallow !== 'undefined')){
} else {
threeagent.impl.virtual_scene.__GT_node_shallow = (function (){var method_table__4524__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4525__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4526__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4527__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4528__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.impl.virtual-scene","->node-shallow"),((function (method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__){
return (function (key,p__24860){
var vec__24861 = p__24860;
var seq__24862 = cljs.core.seq.call(null,vec__24861);
var first__24863 = cljs.core.first.call(null,seq__24862);
var seq__24862__$1 = cljs.core.next.call(null,seq__24862);
var l = first__24863;
var r = seq__24862__$1;
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});})(method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4528__auto__,method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (key,form){
if(cljs.core.empty_QMARK_.call(null,form)){
return null;
} else {
var m = cljs.core.meta.call(null,form);
return threeagent.impl.virtual_scene.__GT_node_shallow.call(null,threeagent.impl.virtual_scene.get_key.call(null,key,m),cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),m));
}
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (key,form){
var vec__24867 = form;
var seq__24868 = cljs.core.seq.call(null,vec__24867);
var first__24869 = cljs.core.first.call(null,seq__24868);
var seq__24868__$1 = cljs.core.next.call(null,seq__24868);
var comp_key = first__24869;
var rs = seq__24868__$1;
var first_child = cljs.core.first.call(null,rs);
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,((function (vec__24867,seq__24868,first__24869,seq__24868__$1,comp_key,rs,first_child,comp_config){
return (function (p1__24864_SHARP_){
return (((!((p1__24864_SHARP_ == null)))) && ((!(cljs.core.empty_QMARK_.call(null,p1__24864_SHARP_)))));
});})(vec__24867,seq__24868,first__24869,seq__24868__$1,comp_key,rs,first_child,comp_config))
,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"data","data",-232669377),threeagent.impl.virtual_scene.node_data.call(null,comp_key,comp_config),new cljs.core.Keyword(null,"form","form",-1624062471),form,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807),cljs.core.map_indexed.call(null,((function (vec__24867,seq__24868,first__24869,seq__24868__$1,comp_key,rs,first_child,comp_config,children){
return (function (p1__24866_SHARP_,p2__24865_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p2__24865_SHARP_));
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return p1__24866_SHARP_;
}
})(),p2__24865_SHARP_],null));
});})(vec__24867,seq__24868,first__24869,seq__24868__$1,comp_key,rs,first_child,comp_config,children))
,children)], null);
}));
threeagent.impl.virtual_scene.dispose_node_BANG_ = (function threeagent$impl$virtual_scene$dispose_node_BANG_(node){
threeagent.impl.util.$_BANG_.call(null,node,"disposed",true);

var temp__5457__auto___24870 = threeagent.impl.util.$.call(null,node,"reaction");
if(cljs.core.truth_(temp__5457__auto___24870)){
var reaction_24871 = temp__5457__auto___24870;
reagent.ratom.dispose_BANG_.call(null,reaction_24871);
} else {
}

return node.for_each_child(threeagent.impl.virtual_scene.dispose_node_BANG_);
});
threeagent.impl.virtual_scene.add_node_BANG_ = (function threeagent$impl$virtual_scene$add_node_BANG_(scene,parent_node,key,form,changelog){
var temp__5457__auto__ = threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent_node,key,form);
if(cljs.core.truth_(temp__5457__auto__)){
var node = temp__5457__auto__;
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"add","add",235287739),null,threeagent.impl.util.$.call(null,node,"data")], null));

return node;
} else {
return null;
}
});
threeagent.impl.virtual_scene.remove_node_BANG_ = (function threeagent$impl$virtual_scene$remove_node_BANG_(node,changelog){
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"remove","remove",-131428414),threeagent.impl.util.$.call(null,node,"data"),null], null));

threeagent.impl.util.$_BANG_.call(null,node,"data",null);

threeagent.impl.util.$_BANG_.call(null,node,"dirty",false);

return threeagent.impl.virtual_scene.dispose_node_BANG_.call(null,node);
});
threeagent.impl.virtual_scene.update_node_BANG_ = (function threeagent$impl$virtual_scene$update_node_BANG_(scene,node,new_form,changelog){
threeagent.impl.util.$_BANG_.call(null,node,"dirty",false);

var render_fn = threeagent.impl.util.$.call(null,node,"render");
var rendered_form = (cljs.core.truth_(render_fn)?cljs.core.apply.call(null,render_fn,cljs.core.rest.call(null,new_form)):new_form);
var old_form = threeagent.impl.util.$.call(null,node,"rendered-form");
if(cljs.core.not_EQ_.call(null,rendered_form,old_form)){
var key = threeagent.impl.util.$.call(null,node,"key");
var children = threeagent.impl.util.$.call(null,node,"children");
var old_data = threeagent.impl.util.$.call(null,node,"data");
var shallow_node = threeagent.impl.virtual_scene.__GT_node_shallow.call(null,key,rendered_form);
var new_data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(shallow_node);
var current_keys = cljs.core.set.call(null,cljs.core.es6_iterator_seq.call(null,children.keys()));
var new_keys = cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.first,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node)));
var dropped_keys = clojure.set.difference.call(null,current_keys,new_keys);
threeagent.impl.util.$_BANG_.call(null,node,"data",new_data);

if(cljs.core.truth_(render_fn)){
threeagent.impl.util.$_BANG_.call(null,node,"form",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [render_fn], null),cljs.core.rest.call(null,new_form)));
} else {
}

threeagent.impl.util.$_BANG_.call(null,node,"rendered-form",new_form);

changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"update","update",1045576396),old_data,new_data], null));

var seq__24872_24886 = cljs.core.seq.call(null,dropped_keys);
var chunk__24873_24887 = null;
var count__24874_24888 = (0);
var i__24875_24889 = (0);
while(true){
if((i__24875_24889 < count__24874_24888)){
var child_key_24890 = cljs.core._nth.call(null,chunk__24873_24887,i__24875_24889);
var child_node_24891 = children.get(child_key_24890);
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,child_node_24891,changelog);

children.delete(child_key_24890);


var G__24892 = seq__24872_24886;
var G__24893 = chunk__24873_24887;
var G__24894 = count__24874_24888;
var G__24895 = (i__24875_24889 + (1));
seq__24872_24886 = G__24892;
chunk__24873_24887 = G__24893;
count__24874_24888 = G__24894;
i__24875_24889 = G__24895;
continue;
} else {
var temp__5457__auto___24896 = cljs.core.seq.call(null,seq__24872_24886);
if(temp__5457__auto___24896){
var seq__24872_24897__$1 = temp__5457__auto___24896;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24872_24897__$1)){
var c__4461__auto___24898 = cljs.core.chunk_first.call(null,seq__24872_24897__$1);
var G__24899 = cljs.core.chunk_rest.call(null,seq__24872_24897__$1);
var G__24900 = c__4461__auto___24898;
var G__24901 = cljs.core.count.call(null,c__4461__auto___24898);
var G__24902 = (0);
seq__24872_24886 = G__24899;
chunk__24873_24887 = G__24900;
count__24874_24888 = G__24901;
i__24875_24889 = G__24902;
continue;
} else {
var child_key_24903 = cljs.core.first.call(null,seq__24872_24897__$1);
var child_node_24904 = children.get(child_key_24903);
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,child_node_24904,changelog);

children.delete(child_key_24903);


var G__24905 = cljs.core.next.call(null,seq__24872_24897__$1);
var G__24906 = null;
var G__24907 = (0);
var G__24908 = (0);
seq__24872_24886 = G__24905;
chunk__24873_24887 = G__24906;
count__24874_24888 = G__24907;
i__24875_24889 = G__24908;
continue;
}
} else {
}
}
break;
}

var seq__24876 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node));
var chunk__24877 = null;
var count__24878 = (0);
var i__24879 = (0);
while(true){
if((i__24879 < count__24878)){
var vec__24880 = cljs.core._nth.call(null,chunk__24877,i__24879);
var child_key = cljs.core.nth.call(null,vec__24880,(0),null);
var child_form = cljs.core.nth.call(null,vec__24880,(1),null);
var temp__5455__auto___24909 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___24909)){
var child_24910 = temp__5455__auto___24909;
threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,child_24910,child_form,changelog);
} else {
var temp__5457__auto___24911 = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___24911)){
var child_node_24912 = temp__5457__auto___24911;
children.set(child_key,child_node_24912);
} else {
}
}


var G__24913 = seq__24876;
var G__24914 = chunk__24877;
var G__24915 = count__24878;
var G__24916 = (i__24879 + (1));
seq__24876 = G__24913;
chunk__24877 = G__24914;
count__24878 = G__24915;
i__24879 = G__24916;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__24876);
if(temp__5457__auto__){
var seq__24876__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24876__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__24876__$1);
var G__24917 = cljs.core.chunk_rest.call(null,seq__24876__$1);
var G__24918 = c__4461__auto__;
var G__24919 = cljs.core.count.call(null,c__4461__auto__);
var G__24920 = (0);
seq__24876 = G__24917;
chunk__24877 = G__24918;
count__24878 = G__24919;
i__24879 = G__24920;
continue;
} else {
var vec__24883 = cljs.core.first.call(null,seq__24876__$1);
var child_key = cljs.core.nth.call(null,vec__24883,(0),null);
var child_form = cljs.core.nth.call(null,vec__24883,(1),null);
var temp__5455__auto___24921 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___24921)){
var child_24922 = temp__5455__auto___24921;
threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,child_24922,child_form,changelog);
} else {
var temp__5457__auto___24923__$1 = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___24923__$1)){
var child_node_24924 = temp__5457__auto___24923__$1;
children.set(child_key,child_node_24924);
} else {
}
}


var G__24925 = cljs.core.next.call(null,seq__24876__$1);
var G__24926 = null;
var G__24927 = (0);
var G__24928 = (0);
seq__24876 = G__24925;
chunk__24877 = G__24926;
count__24878 = G__24927;
i__24879 = G__24928;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
threeagent.impl.virtual_scene.render_node_BANG_ = (function threeagent$impl$virtual_scene$render_node_BANG_(scene,node,changelog){
var form = threeagent.impl.util.$.call(null,node,"form");
return threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,node,form,changelog);
});
threeagent.impl.virtual_scene.render_BANG_ = (function threeagent$impl$virtual_scene$render_BANG_(scene,changelog){
reagent.core.flush.call(null);

var queue = threeagent.impl.util.$.call(null,scene,"render_queue");
var node = queue.dequeue();
while(true){
if(cljs.core.truth_(node)){
if(cljs.core.truth_(threeagent.impl.util.$.call(null,node,"dirty"))){
threeagent.impl.virtual_scene.render_node_BANG_.call(null,scene,node,changelog);
} else {
}

var G__24929 = queue.dequeue();
node = G__24929;
continue;
} else {
return null;
}
break;
}
});
threeagent.impl.virtual_scene.destroy_BANG_ = (function threeagent$impl$virtual_scene$destroy_BANG_(scene){
return threeagent.impl.virtual_scene.dispose_node_BANG_.call(null,threeagent.impl.util.$.call(null,scene,"root"));
});
threeagent.impl.virtual_scene.create = (function threeagent$impl$virtual_scene$create(root_fn){
var scene = (new threeagent.impl.virtual_scene.Scene(null,(new goog.structs.PriorityQueue())));
var root_node = threeagent.impl.virtual_scene.__GT_node.call(null,scene,null,(0),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root_fn], null));
threeagent.impl.util.$_BANG_.call(null,scene,"root",root_node);

return scene;
});

//# sourceMappingURL=virtual_scene.js.map
