// Compiled by ClojureScript 1.10.520 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__27496 = arguments.length;
switch (G__27496) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27497 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27497 = (function (f,blockable,meta27498){
this.f = f;
this.blockable = blockable;
this.meta27498 = meta27498;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27497.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27499,meta27498__$1){
var self__ = this;
var _27499__$1 = this;
return (new cljs.core.async.t_cljs$core$async27497(self__.f,self__.blockable,meta27498__$1));
});

cljs.core.async.t_cljs$core$async27497.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27499){
var self__ = this;
var _27499__$1 = this;
return self__.meta27498;
});

cljs.core.async.t_cljs$core$async27497.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27497.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async27497.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async27497.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async27497.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta27498","meta27498",483976062,null)], null);
});

cljs.core.async.t_cljs$core$async27497.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27497.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27497";

cljs.core.async.t_cljs$core$async27497.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async27497");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27497.
 */
cljs.core.async.__GT_t_cljs$core$async27497 = (function cljs$core$async$__GT_t_cljs$core$async27497(f__$1,blockable__$1,meta27498){
return (new cljs.core.async.t_cljs$core$async27497(f__$1,blockable__$1,meta27498));
});

}

return (new cljs.core.async.t_cljs$core$async27497(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__27503 = arguments.length;
switch (G__27503) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__27506 = arguments.length;
switch (G__27506) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__27509 = arguments.length;
switch (G__27509) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_27511 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_27511);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_27511,ret){
return (function (){
return fn1.call(null,val_27511);
});})(val_27511,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__27513 = arguments.length;
switch (G__27513) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___27515 = n;
var x_27516 = (0);
while(true){
if((x_27516 < n__4607__auto___27515)){
(a[x_27516] = (0));

var G__27517 = (x_27516 + (1));
x_27516 = G__27517;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__27518 = (i + (1));
i = G__27518;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27519 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27519 = (function (flag,meta27520){
this.flag = flag;
this.meta27520 = meta27520;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27519.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_27521,meta27520__$1){
var self__ = this;
var _27521__$1 = this;
return (new cljs.core.async.t_cljs$core$async27519(self__.flag,meta27520__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async27519.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_27521){
var self__ = this;
var _27521__$1 = this;
return self__.meta27520;
});})(flag))
;

cljs.core.async.t_cljs$core$async27519.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27519.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async27519.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async27519.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async27519.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta27520","meta27520",1808884,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async27519.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27519.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27519";

cljs.core.async.t_cljs$core$async27519.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async27519");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27519.
 */
cljs.core.async.__GT_t_cljs$core$async27519 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async27519(flag__$1,meta27520){
return (new cljs.core.async.t_cljs$core$async27519(flag__$1,meta27520));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async27519(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27522 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27522 = (function (flag,cb,meta27523){
this.flag = flag;
this.cb = cb;
this.meta27523 = meta27523;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27522.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27524,meta27523__$1){
var self__ = this;
var _27524__$1 = this;
return (new cljs.core.async.t_cljs$core$async27522(self__.flag,self__.cb,meta27523__$1));
});

cljs.core.async.t_cljs$core$async27522.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27524){
var self__ = this;
var _27524__$1 = this;
return self__.meta27523;
});

cljs.core.async.t_cljs$core$async27522.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27522.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async27522.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async27522.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async27522.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta27523","meta27523",1468980960,null)], null);
});

cljs.core.async.t_cljs$core$async27522.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27522.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27522";

cljs.core.async.t_cljs$core$async27522.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async27522");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27522.
 */
cljs.core.async.__GT_t_cljs$core$async27522 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async27522(flag__$1,cb__$1,meta27523){
return (new cljs.core.async.t_cljs$core$async27522(flag__$1,cb__$1,meta27523));
});

}

return (new cljs.core.async.t_cljs$core$async27522(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__27525_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__27525_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__27526_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__27526_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__27527 = (i + (1));
i = G__27527;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___27533 = arguments.length;
var i__4731__auto___27534 = (0);
while(true){
if((i__4731__auto___27534 < len__4730__auto___27533)){
args__4736__auto__.push((arguments[i__4731__auto___27534]));

var G__27535 = (i__4731__auto___27534 + (1));
i__4731__auto___27534 = G__27535;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__27530){
var map__27531 = p__27530;
var map__27531__$1 = (((((!((map__27531 == null))))?(((((map__27531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27531.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27531):map__27531);
var opts = map__27531__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq27528){
var G__27529 = cljs.core.first.call(null,seq27528);
var seq27528__$1 = cljs.core.next.call(null,seq27528);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27529,seq27528__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__27537 = arguments.length;
switch (G__27537) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__25572__auto___27583 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___27583){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___27583){
return (function (state_27561){
var state_val_27562 = (state_27561[(1)]);
if((state_val_27562 === (7))){
var inst_27557 = (state_27561[(2)]);
var state_27561__$1 = state_27561;
var statearr_27563_27584 = state_27561__$1;
(statearr_27563_27584[(2)] = inst_27557);

(statearr_27563_27584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27562 === (1))){
var state_27561__$1 = state_27561;
var statearr_27564_27585 = state_27561__$1;
(statearr_27564_27585[(2)] = null);

(statearr_27564_27585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27562 === (4))){
var inst_27540 = (state_27561[(7)]);
var inst_27540__$1 = (state_27561[(2)]);
var inst_27541 = (inst_27540__$1 == null);
var state_27561__$1 = (function (){var statearr_27565 = state_27561;
(statearr_27565[(7)] = inst_27540__$1);

return statearr_27565;
})();
if(cljs.core.truth_(inst_27541)){
var statearr_27566_27586 = state_27561__$1;
(statearr_27566_27586[(1)] = (5));

} else {
var statearr_27567_27587 = state_27561__$1;
(statearr_27567_27587[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27562 === (13))){
var state_27561__$1 = state_27561;
var statearr_27568_27588 = state_27561__$1;
(statearr_27568_27588[(2)] = null);

(statearr_27568_27588[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27562 === (6))){
var inst_27540 = (state_27561[(7)]);
var state_27561__$1 = state_27561;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27561__$1,(11),to,inst_27540);
} else {
if((state_val_27562 === (3))){
var inst_27559 = (state_27561[(2)]);
var state_27561__$1 = state_27561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27561__$1,inst_27559);
} else {
if((state_val_27562 === (12))){
var state_27561__$1 = state_27561;
var statearr_27569_27589 = state_27561__$1;
(statearr_27569_27589[(2)] = null);

(statearr_27569_27589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27562 === (2))){
var state_27561__$1 = state_27561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27561__$1,(4),from);
} else {
if((state_val_27562 === (11))){
var inst_27550 = (state_27561[(2)]);
var state_27561__$1 = state_27561;
if(cljs.core.truth_(inst_27550)){
var statearr_27570_27590 = state_27561__$1;
(statearr_27570_27590[(1)] = (12));

} else {
var statearr_27571_27591 = state_27561__$1;
(statearr_27571_27591[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27562 === (9))){
var state_27561__$1 = state_27561;
var statearr_27572_27592 = state_27561__$1;
(statearr_27572_27592[(2)] = null);

(statearr_27572_27592[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27562 === (5))){
var state_27561__$1 = state_27561;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27573_27593 = state_27561__$1;
(statearr_27573_27593[(1)] = (8));

} else {
var statearr_27574_27594 = state_27561__$1;
(statearr_27574_27594[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27562 === (14))){
var inst_27555 = (state_27561[(2)]);
var state_27561__$1 = state_27561;
var statearr_27575_27595 = state_27561__$1;
(statearr_27575_27595[(2)] = inst_27555);

(statearr_27575_27595[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27562 === (10))){
var inst_27547 = (state_27561[(2)]);
var state_27561__$1 = state_27561;
var statearr_27576_27596 = state_27561__$1;
(statearr_27576_27596[(2)] = inst_27547);

(statearr_27576_27596[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27562 === (8))){
var inst_27544 = cljs.core.async.close_BANG_.call(null,to);
var state_27561__$1 = state_27561;
var statearr_27577_27597 = state_27561__$1;
(statearr_27577_27597[(2)] = inst_27544);

(statearr_27577_27597[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___27583))
;
return ((function (switch__25405__auto__,c__25572__auto___27583){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_27578 = [null,null,null,null,null,null,null,null];
(statearr_27578[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_27578[(1)] = (1));

return statearr_27578;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_27561){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_27561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e27579){if((e27579 instanceof Object)){
var ex__25409__auto__ = e27579;
var statearr_27580_27598 = state_27561;
(statearr_27580_27598[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27561);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27579;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27599 = state_27561;
state_27561 = G__27599;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_27561){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_27561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___27583))
})();
var state__25574__auto__ = (function (){var statearr_27581 = f__25573__auto__.call(null);
(statearr_27581[(6)] = c__25572__auto___27583);

return statearr_27581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___27583))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__27600){
var vec__27601 = p__27600;
var v = cljs.core.nth.call(null,vec__27601,(0),null);
var p = cljs.core.nth.call(null,vec__27601,(1),null);
var job = vec__27601;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__25572__auto___27772 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___27772,res,vec__27601,v,p,job,jobs,results){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___27772,res,vec__27601,v,p,job,jobs,results){
return (function (state_27608){
var state_val_27609 = (state_27608[(1)]);
if((state_val_27609 === (1))){
var state_27608__$1 = state_27608;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27608__$1,(2),res,v);
} else {
if((state_val_27609 === (2))){
var inst_27605 = (state_27608[(2)]);
var inst_27606 = cljs.core.async.close_BANG_.call(null,res);
var state_27608__$1 = (function (){var statearr_27610 = state_27608;
(statearr_27610[(7)] = inst_27605);

return statearr_27610;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27608__$1,inst_27606);
} else {
return null;
}
}
});})(c__25572__auto___27772,res,vec__27601,v,p,job,jobs,results))
;
return ((function (switch__25405__auto__,c__25572__auto___27772,res,vec__27601,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0 = (function (){
var statearr_27611 = [null,null,null,null,null,null,null,null];
(statearr_27611[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__);

(statearr_27611[(1)] = (1));

return statearr_27611;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1 = (function (state_27608){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_27608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e27612){if((e27612 instanceof Object)){
var ex__25409__auto__ = e27612;
var statearr_27613_27773 = state_27608;
(statearr_27613_27773[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27608);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27612;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27774 = state_27608;
state_27608 = G__27774;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__ = function(state_27608){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1.call(this,state_27608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___27772,res,vec__27601,v,p,job,jobs,results))
})();
var state__25574__auto__ = (function (){var statearr_27614 = f__25573__auto__.call(null);
(statearr_27614[(6)] = c__25572__auto___27772);

return statearr_27614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___27772,res,vec__27601,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__27615){
var vec__27616 = p__27615;
var v = cljs.core.nth.call(null,vec__27616,(0),null);
var p = cljs.core.nth.call(null,vec__27616,(1),null);
var job = vec__27616;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___27775 = n;
var __27776 = (0);
while(true){
if((__27776 < n__4607__auto___27775)){
var G__27619_27777 = type;
var G__27619_27778__$1 = (((G__27619_27777 instanceof cljs.core.Keyword))?G__27619_27777.fqn:null);
switch (G__27619_27778__$1) {
case "compute":
var c__25572__auto___27780 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__27776,c__25572__auto___27780,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (__27776,c__25572__auto___27780,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async){
return (function (state_27632){
var state_val_27633 = (state_27632[(1)]);
if((state_val_27633 === (1))){
var state_27632__$1 = state_27632;
var statearr_27634_27781 = state_27632__$1;
(statearr_27634_27781[(2)] = null);

(statearr_27634_27781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (2))){
var state_27632__$1 = state_27632;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27632__$1,(4),jobs);
} else {
if((state_val_27633 === (3))){
var inst_27630 = (state_27632[(2)]);
var state_27632__$1 = state_27632;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27632__$1,inst_27630);
} else {
if((state_val_27633 === (4))){
var inst_27622 = (state_27632[(2)]);
var inst_27623 = process.call(null,inst_27622);
var state_27632__$1 = state_27632;
if(cljs.core.truth_(inst_27623)){
var statearr_27635_27782 = state_27632__$1;
(statearr_27635_27782[(1)] = (5));

} else {
var statearr_27636_27783 = state_27632__$1;
(statearr_27636_27783[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (5))){
var state_27632__$1 = state_27632;
var statearr_27637_27784 = state_27632__$1;
(statearr_27637_27784[(2)] = null);

(statearr_27637_27784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (6))){
var state_27632__$1 = state_27632;
var statearr_27638_27785 = state_27632__$1;
(statearr_27638_27785[(2)] = null);

(statearr_27638_27785[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (7))){
var inst_27628 = (state_27632[(2)]);
var state_27632__$1 = state_27632;
var statearr_27639_27786 = state_27632__$1;
(statearr_27639_27786[(2)] = inst_27628);

(statearr_27639_27786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__27776,c__25572__auto___27780,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async))
;
return ((function (__27776,switch__25405__auto__,c__25572__auto___27780,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0 = (function (){
var statearr_27640 = [null,null,null,null,null,null,null];
(statearr_27640[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__);

(statearr_27640[(1)] = (1));

return statearr_27640;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1 = (function (state_27632){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_27632);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e27641){if((e27641 instanceof Object)){
var ex__25409__auto__ = e27641;
var statearr_27642_27787 = state_27632;
(statearr_27642_27787[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27632);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27641;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27788 = state_27632;
state_27632 = G__27788;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__ = function(state_27632){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1.call(this,state_27632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__;
})()
;})(__27776,switch__25405__auto__,c__25572__auto___27780,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async))
})();
var state__25574__auto__ = (function (){var statearr_27643 = f__25573__auto__.call(null);
(statearr_27643[(6)] = c__25572__auto___27780);

return statearr_27643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(__27776,c__25572__auto___27780,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async))
);


break;
case "async":
var c__25572__auto___27789 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__27776,c__25572__auto___27789,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (__27776,c__25572__auto___27789,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async){
return (function (state_27656){
var state_val_27657 = (state_27656[(1)]);
if((state_val_27657 === (1))){
var state_27656__$1 = state_27656;
var statearr_27658_27790 = state_27656__$1;
(statearr_27658_27790[(2)] = null);

(statearr_27658_27790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27657 === (2))){
var state_27656__$1 = state_27656;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27656__$1,(4),jobs);
} else {
if((state_val_27657 === (3))){
var inst_27654 = (state_27656[(2)]);
var state_27656__$1 = state_27656;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27656__$1,inst_27654);
} else {
if((state_val_27657 === (4))){
var inst_27646 = (state_27656[(2)]);
var inst_27647 = async.call(null,inst_27646);
var state_27656__$1 = state_27656;
if(cljs.core.truth_(inst_27647)){
var statearr_27659_27791 = state_27656__$1;
(statearr_27659_27791[(1)] = (5));

} else {
var statearr_27660_27792 = state_27656__$1;
(statearr_27660_27792[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27657 === (5))){
var state_27656__$1 = state_27656;
var statearr_27661_27793 = state_27656__$1;
(statearr_27661_27793[(2)] = null);

(statearr_27661_27793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27657 === (6))){
var state_27656__$1 = state_27656;
var statearr_27662_27794 = state_27656__$1;
(statearr_27662_27794[(2)] = null);

(statearr_27662_27794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27657 === (7))){
var inst_27652 = (state_27656[(2)]);
var state_27656__$1 = state_27656;
var statearr_27663_27795 = state_27656__$1;
(statearr_27663_27795[(2)] = inst_27652);

(statearr_27663_27795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__27776,c__25572__auto___27789,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async))
;
return ((function (__27776,switch__25405__auto__,c__25572__auto___27789,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0 = (function (){
var statearr_27664 = [null,null,null,null,null,null,null];
(statearr_27664[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__);

(statearr_27664[(1)] = (1));

return statearr_27664;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1 = (function (state_27656){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_27656);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e27665){if((e27665 instanceof Object)){
var ex__25409__auto__ = e27665;
var statearr_27666_27796 = state_27656;
(statearr_27666_27796[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27656);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27665;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27797 = state_27656;
state_27656 = G__27797;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__ = function(state_27656){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1.call(this,state_27656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__;
})()
;})(__27776,switch__25405__auto__,c__25572__auto___27789,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async))
})();
var state__25574__auto__ = (function (){var statearr_27667 = f__25573__auto__.call(null);
(statearr_27667[(6)] = c__25572__auto___27789);

return statearr_27667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(__27776,c__25572__auto___27789,G__27619_27777,G__27619_27778__$1,n__4607__auto___27775,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27619_27778__$1)].join('')));

}

var G__27798 = (__27776 + (1));
__27776 = G__27798;
continue;
} else {
}
break;
}

var c__25572__auto___27799 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___27799,jobs,results,process,async){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___27799,jobs,results,process,async){
return (function (state_27689){
var state_val_27690 = (state_27689[(1)]);
if((state_val_27690 === (1))){
var state_27689__$1 = state_27689;
var statearr_27691_27800 = state_27689__$1;
(statearr_27691_27800[(2)] = null);

(statearr_27691_27800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27690 === (2))){
var state_27689__$1 = state_27689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27689__$1,(4),from);
} else {
if((state_val_27690 === (3))){
var inst_27687 = (state_27689[(2)]);
var state_27689__$1 = state_27689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27689__$1,inst_27687);
} else {
if((state_val_27690 === (4))){
var inst_27670 = (state_27689[(7)]);
var inst_27670__$1 = (state_27689[(2)]);
var inst_27671 = (inst_27670__$1 == null);
var state_27689__$1 = (function (){var statearr_27692 = state_27689;
(statearr_27692[(7)] = inst_27670__$1);

return statearr_27692;
})();
if(cljs.core.truth_(inst_27671)){
var statearr_27693_27801 = state_27689__$1;
(statearr_27693_27801[(1)] = (5));

} else {
var statearr_27694_27802 = state_27689__$1;
(statearr_27694_27802[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27690 === (5))){
var inst_27673 = cljs.core.async.close_BANG_.call(null,jobs);
var state_27689__$1 = state_27689;
var statearr_27695_27803 = state_27689__$1;
(statearr_27695_27803[(2)] = inst_27673);

(statearr_27695_27803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27690 === (6))){
var inst_27670 = (state_27689[(7)]);
var inst_27675 = (state_27689[(8)]);
var inst_27675__$1 = cljs.core.async.chan.call(null,(1));
var inst_27676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27677 = [inst_27670,inst_27675__$1];
var inst_27678 = (new cljs.core.PersistentVector(null,2,(5),inst_27676,inst_27677,null));
var state_27689__$1 = (function (){var statearr_27696 = state_27689;
(statearr_27696[(8)] = inst_27675__$1);

return statearr_27696;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27689__$1,(8),jobs,inst_27678);
} else {
if((state_val_27690 === (7))){
var inst_27685 = (state_27689[(2)]);
var state_27689__$1 = state_27689;
var statearr_27697_27804 = state_27689__$1;
(statearr_27697_27804[(2)] = inst_27685);

(statearr_27697_27804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27690 === (8))){
var inst_27675 = (state_27689[(8)]);
var inst_27680 = (state_27689[(2)]);
var state_27689__$1 = (function (){var statearr_27698 = state_27689;
(statearr_27698[(9)] = inst_27680);

return statearr_27698;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27689__$1,(9),results,inst_27675);
} else {
if((state_val_27690 === (9))){
var inst_27682 = (state_27689[(2)]);
var state_27689__$1 = (function (){var statearr_27699 = state_27689;
(statearr_27699[(10)] = inst_27682);

return statearr_27699;
})();
var statearr_27700_27805 = state_27689__$1;
(statearr_27700_27805[(2)] = null);

(statearr_27700_27805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___27799,jobs,results,process,async))
;
return ((function (switch__25405__auto__,c__25572__auto___27799,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0 = (function (){
var statearr_27701 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27701[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__);

(statearr_27701[(1)] = (1));

return statearr_27701;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1 = (function (state_27689){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_27689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e27702){if((e27702 instanceof Object)){
var ex__25409__auto__ = e27702;
var statearr_27703_27806 = state_27689;
(statearr_27703_27806[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27689);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27702;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27807 = state_27689;
state_27689 = G__27807;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__ = function(state_27689){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1.call(this,state_27689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___27799,jobs,results,process,async))
})();
var state__25574__auto__ = (function (){var statearr_27704 = f__25573__auto__.call(null);
(statearr_27704[(6)] = c__25572__auto___27799);

return statearr_27704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___27799,jobs,results,process,async))
);


var c__25572__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto__,jobs,results,process,async){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto__,jobs,results,process,async){
return (function (state_27742){
var state_val_27743 = (state_27742[(1)]);
if((state_val_27743 === (7))){
var inst_27738 = (state_27742[(2)]);
var state_27742__$1 = state_27742;
var statearr_27744_27808 = state_27742__$1;
(statearr_27744_27808[(2)] = inst_27738);

(statearr_27744_27808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (20))){
var state_27742__$1 = state_27742;
var statearr_27745_27809 = state_27742__$1;
(statearr_27745_27809[(2)] = null);

(statearr_27745_27809[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (1))){
var state_27742__$1 = state_27742;
var statearr_27746_27810 = state_27742__$1;
(statearr_27746_27810[(2)] = null);

(statearr_27746_27810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (4))){
var inst_27707 = (state_27742[(7)]);
var inst_27707__$1 = (state_27742[(2)]);
var inst_27708 = (inst_27707__$1 == null);
var state_27742__$1 = (function (){var statearr_27747 = state_27742;
(statearr_27747[(7)] = inst_27707__$1);

return statearr_27747;
})();
if(cljs.core.truth_(inst_27708)){
var statearr_27748_27811 = state_27742__$1;
(statearr_27748_27811[(1)] = (5));

} else {
var statearr_27749_27812 = state_27742__$1;
(statearr_27749_27812[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (15))){
var inst_27720 = (state_27742[(8)]);
var state_27742__$1 = state_27742;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27742__$1,(18),to,inst_27720);
} else {
if((state_val_27743 === (21))){
var inst_27733 = (state_27742[(2)]);
var state_27742__$1 = state_27742;
var statearr_27750_27813 = state_27742__$1;
(statearr_27750_27813[(2)] = inst_27733);

(statearr_27750_27813[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (13))){
var inst_27735 = (state_27742[(2)]);
var state_27742__$1 = (function (){var statearr_27751 = state_27742;
(statearr_27751[(9)] = inst_27735);

return statearr_27751;
})();
var statearr_27752_27814 = state_27742__$1;
(statearr_27752_27814[(2)] = null);

(statearr_27752_27814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (6))){
var inst_27707 = (state_27742[(7)]);
var state_27742__$1 = state_27742;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27742__$1,(11),inst_27707);
} else {
if((state_val_27743 === (17))){
var inst_27728 = (state_27742[(2)]);
var state_27742__$1 = state_27742;
if(cljs.core.truth_(inst_27728)){
var statearr_27753_27815 = state_27742__$1;
(statearr_27753_27815[(1)] = (19));

} else {
var statearr_27754_27816 = state_27742__$1;
(statearr_27754_27816[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (3))){
var inst_27740 = (state_27742[(2)]);
var state_27742__$1 = state_27742;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27742__$1,inst_27740);
} else {
if((state_val_27743 === (12))){
var inst_27717 = (state_27742[(10)]);
var state_27742__$1 = state_27742;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27742__$1,(14),inst_27717);
} else {
if((state_val_27743 === (2))){
var state_27742__$1 = state_27742;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27742__$1,(4),results);
} else {
if((state_val_27743 === (19))){
var state_27742__$1 = state_27742;
var statearr_27755_27817 = state_27742__$1;
(statearr_27755_27817[(2)] = null);

(statearr_27755_27817[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (11))){
var inst_27717 = (state_27742[(2)]);
var state_27742__$1 = (function (){var statearr_27756 = state_27742;
(statearr_27756[(10)] = inst_27717);

return statearr_27756;
})();
var statearr_27757_27818 = state_27742__$1;
(statearr_27757_27818[(2)] = null);

(statearr_27757_27818[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (9))){
var state_27742__$1 = state_27742;
var statearr_27758_27819 = state_27742__$1;
(statearr_27758_27819[(2)] = null);

(statearr_27758_27819[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (5))){
var state_27742__$1 = state_27742;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27759_27820 = state_27742__$1;
(statearr_27759_27820[(1)] = (8));

} else {
var statearr_27760_27821 = state_27742__$1;
(statearr_27760_27821[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (14))){
var inst_27720 = (state_27742[(8)]);
var inst_27722 = (state_27742[(11)]);
var inst_27720__$1 = (state_27742[(2)]);
var inst_27721 = (inst_27720__$1 == null);
var inst_27722__$1 = cljs.core.not.call(null,inst_27721);
var state_27742__$1 = (function (){var statearr_27761 = state_27742;
(statearr_27761[(8)] = inst_27720__$1);

(statearr_27761[(11)] = inst_27722__$1);

return statearr_27761;
})();
if(inst_27722__$1){
var statearr_27762_27822 = state_27742__$1;
(statearr_27762_27822[(1)] = (15));

} else {
var statearr_27763_27823 = state_27742__$1;
(statearr_27763_27823[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (16))){
var inst_27722 = (state_27742[(11)]);
var state_27742__$1 = state_27742;
var statearr_27764_27824 = state_27742__$1;
(statearr_27764_27824[(2)] = inst_27722);

(statearr_27764_27824[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (10))){
var inst_27714 = (state_27742[(2)]);
var state_27742__$1 = state_27742;
var statearr_27765_27825 = state_27742__$1;
(statearr_27765_27825[(2)] = inst_27714);

(statearr_27765_27825[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (18))){
var inst_27725 = (state_27742[(2)]);
var state_27742__$1 = state_27742;
var statearr_27766_27826 = state_27742__$1;
(statearr_27766_27826[(2)] = inst_27725);

(statearr_27766_27826[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27743 === (8))){
var inst_27711 = cljs.core.async.close_BANG_.call(null,to);
var state_27742__$1 = state_27742;
var statearr_27767_27827 = state_27742__$1;
(statearr_27767_27827[(2)] = inst_27711);

(statearr_27767_27827[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto__,jobs,results,process,async))
;
return ((function (switch__25405__auto__,c__25572__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0 = (function (){
var statearr_27768 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27768[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__);

(statearr_27768[(1)] = (1));

return statearr_27768;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1 = (function (state_27742){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_27742);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e27769){if((e27769 instanceof Object)){
var ex__25409__auto__ = e27769;
var statearr_27770_27828 = state_27742;
(statearr_27770_27828[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27742);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27769;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27829 = state_27742;
state_27742 = G__27829;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__ = function(state_27742){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1.call(this,state_27742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25406__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto__,jobs,results,process,async))
})();
var state__25574__auto__ = (function (){var statearr_27771 = f__25573__auto__.call(null);
(statearr_27771[(6)] = c__25572__auto__);

return statearr_27771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto__,jobs,results,process,async))
);

return c__25572__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__27831 = arguments.length;
switch (G__27831) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__27834 = arguments.length;
switch (G__27834) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__27837 = arguments.length;
switch (G__27837) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__25572__auto___27886 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___27886,tc,fc){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___27886,tc,fc){
return (function (state_27863){
var state_val_27864 = (state_27863[(1)]);
if((state_val_27864 === (7))){
var inst_27859 = (state_27863[(2)]);
var state_27863__$1 = state_27863;
var statearr_27865_27887 = state_27863__$1;
(statearr_27865_27887[(2)] = inst_27859);

(statearr_27865_27887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27864 === (1))){
var state_27863__$1 = state_27863;
var statearr_27866_27888 = state_27863__$1;
(statearr_27866_27888[(2)] = null);

(statearr_27866_27888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27864 === (4))){
var inst_27840 = (state_27863[(7)]);
var inst_27840__$1 = (state_27863[(2)]);
var inst_27841 = (inst_27840__$1 == null);
var state_27863__$1 = (function (){var statearr_27867 = state_27863;
(statearr_27867[(7)] = inst_27840__$1);

return statearr_27867;
})();
if(cljs.core.truth_(inst_27841)){
var statearr_27868_27889 = state_27863__$1;
(statearr_27868_27889[(1)] = (5));

} else {
var statearr_27869_27890 = state_27863__$1;
(statearr_27869_27890[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27864 === (13))){
var state_27863__$1 = state_27863;
var statearr_27870_27891 = state_27863__$1;
(statearr_27870_27891[(2)] = null);

(statearr_27870_27891[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27864 === (6))){
var inst_27840 = (state_27863[(7)]);
var inst_27846 = p.call(null,inst_27840);
var state_27863__$1 = state_27863;
if(cljs.core.truth_(inst_27846)){
var statearr_27871_27892 = state_27863__$1;
(statearr_27871_27892[(1)] = (9));

} else {
var statearr_27872_27893 = state_27863__$1;
(statearr_27872_27893[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27864 === (3))){
var inst_27861 = (state_27863[(2)]);
var state_27863__$1 = state_27863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27863__$1,inst_27861);
} else {
if((state_val_27864 === (12))){
var state_27863__$1 = state_27863;
var statearr_27873_27894 = state_27863__$1;
(statearr_27873_27894[(2)] = null);

(statearr_27873_27894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27864 === (2))){
var state_27863__$1 = state_27863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27863__$1,(4),ch);
} else {
if((state_val_27864 === (11))){
var inst_27840 = (state_27863[(7)]);
var inst_27850 = (state_27863[(2)]);
var state_27863__$1 = state_27863;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27863__$1,(8),inst_27850,inst_27840);
} else {
if((state_val_27864 === (9))){
var state_27863__$1 = state_27863;
var statearr_27874_27895 = state_27863__$1;
(statearr_27874_27895[(2)] = tc);

(statearr_27874_27895[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27864 === (5))){
var inst_27843 = cljs.core.async.close_BANG_.call(null,tc);
var inst_27844 = cljs.core.async.close_BANG_.call(null,fc);
var state_27863__$1 = (function (){var statearr_27875 = state_27863;
(statearr_27875[(8)] = inst_27843);

return statearr_27875;
})();
var statearr_27876_27896 = state_27863__$1;
(statearr_27876_27896[(2)] = inst_27844);

(statearr_27876_27896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27864 === (14))){
var inst_27857 = (state_27863[(2)]);
var state_27863__$1 = state_27863;
var statearr_27877_27897 = state_27863__$1;
(statearr_27877_27897[(2)] = inst_27857);

(statearr_27877_27897[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27864 === (10))){
var state_27863__$1 = state_27863;
var statearr_27878_27898 = state_27863__$1;
(statearr_27878_27898[(2)] = fc);

(statearr_27878_27898[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27864 === (8))){
var inst_27852 = (state_27863[(2)]);
var state_27863__$1 = state_27863;
if(cljs.core.truth_(inst_27852)){
var statearr_27879_27899 = state_27863__$1;
(statearr_27879_27899[(1)] = (12));

} else {
var statearr_27880_27900 = state_27863__$1;
(statearr_27880_27900[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___27886,tc,fc))
;
return ((function (switch__25405__auto__,c__25572__auto___27886,tc,fc){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_27881 = [null,null,null,null,null,null,null,null,null];
(statearr_27881[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_27881[(1)] = (1));

return statearr_27881;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_27863){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_27863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e27882){if((e27882 instanceof Object)){
var ex__25409__auto__ = e27882;
var statearr_27883_27901 = state_27863;
(statearr_27883_27901[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27863);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27882;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27902 = state_27863;
state_27863 = G__27902;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_27863){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_27863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___27886,tc,fc))
})();
var state__25574__auto__ = (function (){var statearr_27884 = f__25573__auto__.call(null);
(statearr_27884[(6)] = c__25572__auto___27886);

return statearr_27884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___27886,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__25572__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto__){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto__){
return (function (state_27923){
var state_val_27924 = (state_27923[(1)]);
if((state_val_27924 === (7))){
var inst_27919 = (state_27923[(2)]);
var state_27923__$1 = state_27923;
var statearr_27925_27943 = state_27923__$1;
(statearr_27925_27943[(2)] = inst_27919);

(statearr_27925_27943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27924 === (1))){
var inst_27903 = init;
var state_27923__$1 = (function (){var statearr_27926 = state_27923;
(statearr_27926[(7)] = inst_27903);

return statearr_27926;
})();
var statearr_27927_27944 = state_27923__$1;
(statearr_27927_27944[(2)] = null);

(statearr_27927_27944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27924 === (4))){
var inst_27906 = (state_27923[(8)]);
var inst_27906__$1 = (state_27923[(2)]);
var inst_27907 = (inst_27906__$1 == null);
var state_27923__$1 = (function (){var statearr_27928 = state_27923;
(statearr_27928[(8)] = inst_27906__$1);

return statearr_27928;
})();
if(cljs.core.truth_(inst_27907)){
var statearr_27929_27945 = state_27923__$1;
(statearr_27929_27945[(1)] = (5));

} else {
var statearr_27930_27946 = state_27923__$1;
(statearr_27930_27946[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27924 === (6))){
var inst_27910 = (state_27923[(9)]);
var inst_27903 = (state_27923[(7)]);
var inst_27906 = (state_27923[(8)]);
var inst_27910__$1 = f.call(null,inst_27903,inst_27906);
var inst_27911 = cljs.core.reduced_QMARK_.call(null,inst_27910__$1);
var state_27923__$1 = (function (){var statearr_27931 = state_27923;
(statearr_27931[(9)] = inst_27910__$1);

return statearr_27931;
})();
if(inst_27911){
var statearr_27932_27947 = state_27923__$1;
(statearr_27932_27947[(1)] = (8));

} else {
var statearr_27933_27948 = state_27923__$1;
(statearr_27933_27948[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27924 === (3))){
var inst_27921 = (state_27923[(2)]);
var state_27923__$1 = state_27923;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27923__$1,inst_27921);
} else {
if((state_val_27924 === (2))){
var state_27923__$1 = state_27923;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27923__$1,(4),ch);
} else {
if((state_val_27924 === (9))){
var inst_27910 = (state_27923[(9)]);
var inst_27903 = inst_27910;
var state_27923__$1 = (function (){var statearr_27934 = state_27923;
(statearr_27934[(7)] = inst_27903);

return statearr_27934;
})();
var statearr_27935_27949 = state_27923__$1;
(statearr_27935_27949[(2)] = null);

(statearr_27935_27949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27924 === (5))){
var inst_27903 = (state_27923[(7)]);
var state_27923__$1 = state_27923;
var statearr_27936_27950 = state_27923__$1;
(statearr_27936_27950[(2)] = inst_27903);

(statearr_27936_27950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27924 === (10))){
var inst_27917 = (state_27923[(2)]);
var state_27923__$1 = state_27923;
var statearr_27937_27951 = state_27923__$1;
(statearr_27937_27951[(2)] = inst_27917);

(statearr_27937_27951[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27924 === (8))){
var inst_27910 = (state_27923[(9)]);
var inst_27913 = cljs.core.deref.call(null,inst_27910);
var state_27923__$1 = state_27923;
var statearr_27938_27952 = state_27923__$1;
(statearr_27938_27952[(2)] = inst_27913);

(statearr_27938_27952[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto__))
;
return ((function (switch__25405__auto__,c__25572__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__25406__auto__ = null;
var cljs$core$async$reduce_$_state_machine__25406__auto____0 = (function (){
var statearr_27939 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27939[(0)] = cljs$core$async$reduce_$_state_machine__25406__auto__);

(statearr_27939[(1)] = (1));

return statearr_27939;
});
var cljs$core$async$reduce_$_state_machine__25406__auto____1 = (function (state_27923){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_27923);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e27940){if((e27940 instanceof Object)){
var ex__25409__auto__ = e27940;
var statearr_27941_27953 = state_27923;
(statearr_27941_27953[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27923);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27940;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27954 = state_27923;
state_27923 = G__27954;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__25406__auto__ = function(state_27923){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__25406__auto____1.call(this,state_27923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__25406__auto____0;
cljs$core$async$reduce_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__25406__auto____1;
return cljs$core$async$reduce_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto__))
})();
var state__25574__auto__ = (function (){var statearr_27942 = f__25573__auto__.call(null);
(statearr_27942[(6)] = c__25572__auto__);

return statearr_27942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto__))
);

return c__25572__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__25572__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto__,f__$1){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto__,f__$1){
return (function (state_27960){
var state_val_27961 = (state_27960[(1)]);
if((state_val_27961 === (1))){
var inst_27955 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_27960__$1 = state_27960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27960__$1,(2),inst_27955);
} else {
if((state_val_27961 === (2))){
var inst_27957 = (state_27960[(2)]);
var inst_27958 = f__$1.call(null,inst_27957);
var state_27960__$1 = state_27960;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27960__$1,inst_27958);
} else {
return null;
}
}
});})(c__25572__auto__,f__$1))
;
return ((function (switch__25405__auto__,c__25572__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__25406__auto__ = null;
var cljs$core$async$transduce_$_state_machine__25406__auto____0 = (function (){
var statearr_27962 = [null,null,null,null,null,null,null];
(statearr_27962[(0)] = cljs$core$async$transduce_$_state_machine__25406__auto__);

(statearr_27962[(1)] = (1));

return statearr_27962;
});
var cljs$core$async$transduce_$_state_machine__25406__auto____1 = (function (state_27960){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_27960);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e27963){if((e27963 instanceof Object)){
var ex__25409__auto__ = e27963;
var statearr_27964_27966 = state_27960;
(statearr_27964_27966[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27960);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27963;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27967 = state_27960;
state_27960 = G__27967;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__25406__auto__ = function(state_27960){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__25406__auto____1.call(this,state_27960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__25406__auto____0;
cljs$core$async$transduce_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__25406__auto____1;
return cljs$core$async$transduce_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto__,f__$1))
})();
var state__25574__auto__ = (function (){var statearr_27965 = f__25573__auto__.call(null);
(statearr_27965[(6)] = c__25572__auto__);

return statearr_27965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto__,f__$1))
);

return c__25572__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__27969 = arguments.length;
switch (G__27969) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__25572__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto__){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto__){
return (function (state_27994){
var state_val_27995 = (state_27994[(1)]);
if((state_val_27995 === (7))){
var inst_27976 = (state_27994[(2)]);
var state_27994__$1 = state_27994;
var statearr_27996_28017 = state_27994__$1;
(statearr_27996_28017[(2)] = inst_27976);

(statearr_27996_28017[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (1))){
var inst_27970 = cljs.core.seq.call(null,coll);
var inst_27971 = inst_27970;
var state_27994__$1 = (function (){var statearr_27997 = state_27994;
(statearr_27997[(7)] = inst_27971);

return statearr_27997;
})();
var statearr_27998_28018 = state_27994__$1;
(statearr_27998_28018[(2)] = null);

(statearr_27998_28018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (4))){
var inst_27971 = (state_27994[(7)]);
var inst_27974 = cljs.core.first.call(null,inst_27971);
var state_27994__$1 = state_27994;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27994__$1,(7),ch,inst_27974);
} else {
if((state_val_27995 === (13))){
var inst_27988 = (state_27994[(2)]);
var state_27994__$1 = state_27994;
var statearr_27999_28019 = state_27994__$1;
(statearr_27999_28019[(2)] = inst_27988);

(statearr_27999_28019[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (6))){
var inst_27979 = (state_27994[(2)]);
var state_27994__$1 = state_27994;
if(cljs.core.truth_(inst_27979)){
var statearr_28000_28020 = state_27994__$1;
(statearr_28000_28020[(1)] = (8));

} else {
var statearr_28001_28021 = state_27994__$1;
(statearr_28001_28021[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (3))){
var inst_27992 = (state_27994[(2)]);
var state_27994__$1 = state_27994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27994__$1,inst_27992);
} else {
if((state_val_27995 === (12))){
var state_27994__$1 = state_27994;
var statearr_28002_28022 = state_27994__$1;
(statearr_28002_28022[(2)] = null);

(statearr_28002_28022[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (2))){
var inst_27971 = (state_27994[(7)]);
var state_27994__$1 = state_27994;
if(cljs.core.truth_(inst_27971)){
var statearr_28003_28023 = state_27994__$1;
(statearr_28003_28023[(1)] = (4));

} else {
var statearr_28004_28024 = state_27994__$1;
(statearr_28004_28024[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (11))){
var inst_27985 = cljs.core.async.close_BANG_.call(null,ch);
var state_27994__$1 = state_27994;
var statearr_28005_28025 = state_27994__$1;
(statearr_28005_28025[(2)] = inst_27985);

(statearr_28005_28025[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (9))){
var state_27994__$1 = state_27994;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28006_28026 = state_27994__$1;
(statearr_28006_28026[(1)] = (11));

} else {
var statearr_28007_28027 = state_27994__$1;
(statearr_28007_28027[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (5))){
var inst_27971 = (state_27994[(7)]);
var state_27994__$1 = state_27994;
var statearr_28008_28028 = state_27994__$1;
(statearr_28008_28028[(2)] = inst_27971);

(statearr_28008_28028[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (10))){
var inst_27990 = (state_27994[(2)]);
var state_27994__$1 = state_27994;
var statearr_28009_28029 = state_27994__$1;
(statearr_28009_28029[(2)] = inst_27990);

(statearr_28009_28029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (8))){
var inst_27971 = (state_27994[(7)]);
var inst_27981 = cljs.core.next.call(null,inst_27971);
var inst_27971__$1 = inst_27981;
var state_27994__$1 = (function (){var statearr_28010 = state_27994;
(statearr_28010[(7)] = inst_27971__$1);

return statearr_28010;
})();
var statearr_28011_28030 = state_27994__$1;
(statearr_28011_28030[(2)] = null);

(statearr_28011_28030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto__))
;
return ((function (switch__25405__auto__,c__25572__auto__){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_28012 = [null,null,null,null,null,null,null,null];
(statearr_28012[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_28012[(1)] = (1));

return statearr_28012;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_27994){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_27994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e28013){if((e28013 instanceof Object)){
var ex__25409__auto__ = e28013;
var statearr_28014_28031 = state_27994;
(statearr_28014_28031[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27994);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28013;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28032 = state_27994;
state_27994 = G__28032;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_27994){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_27994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto__))
})();
var state__25574__auto__ = (function (){var statearr_28015 = f__25573__auto__.call(null);
(statearr_28015[(6)] = c__25572__auto__);

return statearr_28015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto__))
);

return c__25572__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28033 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28033 = (function (ch,cs,meta28034){
this.ch = ch;
this.cs = cs;
this.meta28034 = meta28034;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28033.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_28035,meta28034__$1){
var self__ = this;
var _28035__$1 = this;
return (new cljs.core.async.t_cljs$core$async28033(self__.ch,self__.cs,meta28034__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async28033.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_28035){
var self__ = this;
var _28035__$1 = this;
return self__.meta28034;
});})(cs))
;

cljs.core.async.t_cljs$core$async28033.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28033.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async28033.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28033.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async28033.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async28033.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async28033.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta28034","meta28034",2001545336,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async28033.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28033.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28033";

cljs.core.async.t_cljs$core$async28033.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28033");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28033.
 */
cljs.core.async.__GT_t_cljs$core$async28033 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async28033(ch__$1,cs__$1,meta28034){
return (new cljs.core.async.t_cljs$core$async28033(ch__$1,cs__$1,meta28034));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async28033(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__25572__auto___28255 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___28255,cs,m,dchan,dctr,done){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___28255,cs,m,dchan,dctr,done){
return (function (state_28170){
var state_val_28171 = (state_28170[(1)]);
if((state_val_28171 === (7))){
var inst_28166 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28172_28256 = state_28170__$1;
(statearr_28172_28256[(2)] = inst_28166);

(statearr_28172_28256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (20))){
var inst_28069 = (state_28170[(7)]);
var inst_28081 = cljs.core.first.call(null,inst_28069);
var inst_28082 = cljs.core.nth.call(null,inst_28081,(0),null);
var inst_28083 = cljs.core.nth.call(null,inst_28081,(1),null);
var state_28170__$1 = (function (){var statearr_28173 = state_28170;
(statearr_28173[(8)] = inst_28082);

return statearr_28173;
})();
if(cljs.core.truth_(inst_28083)){
var statearr_28174_28257 = state_28170__$1;
(statearr_28174_28257[(1)] = (22));

} else {
var statearr_28175_28258 = state_28170__$1;
(statearr_28175_28258[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (27))){
var inst_28111 = (state_28170[(9)]);
var inst_28118 = (state_28170[(10)]);
var inst_28038 = (state_28170[(11)]);
var inst_28113 = (state_28170[(12)]);
var inst_28118__$1 = cljs.core._nth.call(null,inst_28111,inst_28113);
var inst_28119 = cljs.core.async.put_BANG_.call(null,inst_28118__$1,inst_28038,done);
var state_28170__$1 = (function (){var statearr_28176 = state_28170;
(statearr_28176[(10)] = inst_28118__$1);

return statearr_28176;
})();
if(cljs.core.truth_(inst_28119)){
var statearr_28177_28259 = state_28170__$1;
(statearr_28177_28259[(1)] = (30));

} else {
var statearr_28178_28260 = state_28170__$1;
(statearr_28178_28260[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (1))){
var state_28170__$1 = state_28170;
var statearr_28179_28261 = state_28170__$1;
(statearr_28179_28261[(2)] = null);

(statearr_28179_28261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (24))){
var inst_28069 = (state_28170[(7)]);
var inst_28088 = (state_28170[(2)]);
var inst_28089 = cljs.core.next.call(null,inst_28069);
var inst_28047 = inst_28089;
var inst_28048 = null;
var inst_28049 = (0);
var inst_28050 = (0);
var state_28170__$1 = (function (){var statearr_28180 = state_28170;
(statearr_28180[(13)] = inst_28088);

(statearr_28180[(14)] = inst_28047);

(statearr_28180[(15)] = inst_28048);

(statearr_28180[(16)] = inst_28049);

(statearr_28180[(17)] = inst_28050);

return statearr_28180;
})();
var statearr_28181_28262 = state_28170__$1;
(statearr_28181_28262[(2)] = null);

(statearr_28181_28262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (39))){
var state_28170__$1 = state_28170;
var statearr_28185_28263 = state_28170__$1;
(statearr_28185_28263[(2)] = null);

(statearr_28185_28263[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (4))){
var inst_28038 = (state_28170[(11)]);
var inst_28038__$1 = (state_28170[(2)]);
var inst_28039 = (inst_28038__$1 == null);
var state_28170__$1 = (function (){var statearr_28186 = state_28170;
(statearr_28186[(11)] = inst_28038__$1);

return statearr_28186;
})();
if(cljs.core.truth_(inst_28039)){
var statearr_28187_28264 = state_28170__$1;
(statearr_28187_28264[(1)] = (5));

} else {
var statearr_28188_28265 = state_28170__$1;
(statearr_28188_28265[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (15))){
var inst_28047 = (state_28170[(14)]);
var inst_28048 = (state_28170[(15)]);
var inst_28049 = (state_28170[(16)]);
var inst_28050 = (state_28170[(17)]);
var inst_28065 = (state_28170[(2)]);
var inst_28066 = (inst_28050 + (1));
var tmp28182 = inst_28047;
var tmp28183 = inst_28048;
var tmp28184 = inst_28049;
var inst_28047__$1 = tmp28182;
var inst_28048__$1 = tmp28183;
var inst_28049__$1 = tmp28184;
var inst_28050__$1 = inst_28066;
var state_28170__$1 = (function (){var statearr_28189 = state_28170;
(statearr_28189[(18)] = inst_28065);

(statearr_28189[(14)] = inst_28047__$1);

(statearr_28189[(15)] = inst_28048__$1);

(statearr_28189[(16)] = inst_28049__$1);

(statearr_28189[(17)] = inst_28050__$1);

return statearr_28189;
})();
var statearr_28190_28266 = state_28170__$1;
(statearr_28190_28266[(2)] = null);

(statearr_28190_28266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (21))){
var inst_28092 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28194_28267 = state_28170__$1;
(statearr_28194_28267[(2)] = inst_28092);

(statearr_28194_28267[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (31))){
var inst_28118 = (state_28170[(10)]);
var inst_28122 = done.call(null,null);
var inst_28123 = cljs.core.async.untap_STAR_.call(null,m,inst_28118);
var state_28170__$1 = (function (){var statearr_28195 = state_28170;
(statearr_28195[(19)] = inst_28122);

return statearr_28195;
})();
var statearr_28196_28268 = state_28170__$1;
(statearr_28196_28268[(2)] = inst_28123);

(statearr_28196_28268[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (32))){
var inst_28111 = (state_28170[(9)]);
var inst_28112 = (state_28170[(20)]);
var inst_28110 = (state_28170[(21)]);
var inst_28113 = (state_28170[(12)]);
var inst_28125 = (state_28170[(2)]);
var inst_28126 = (inst_28113 + (1));
var tmp28191 = inst_28111;
var tmp28192 = inst_28112;
var tmp28193 = inst_28110;
var inst_28110__$1 = tmp28193;
var inst_28111__$1 = tmp28191;
var inst_28112__$1 = tmp28192;
var inst_28113__$1 = inst_28126;
var state_28170__$1 = (function (){var statearr_28197 = state_28170;
(statearr_28197[(9)] = inst_28111__$1);

(statearr_28197[(20)] = inst_28112__$1);

(statearr_28197[(21)] = inst_28110__$1);

(statearr_28197[(12)] = inst_28113__$1);

(statearr_28197[(22)] = inst_28125);

return statearr_28197;
})();
var statearr_28198_28269 = state_28170__$1;
(statearr_28198_28269[(2)] = null);

(statearr_28198_28269[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (40))){
var inst_28138 = (state_28170[(23)]);
var inst_28142 = done.call(null,null);
var inst_28143 = cljs.core.async.untap_STAR_.call(null,m,inst_28138);
var state_28170__$1 = (function (){var statearr_28199 = state_28170;
(statearr_28199[(24)] = inst_28142);

return statearr_28199;
})();
var statearr_28200_28270 = state_28170__$1;
(statearr_28200_28270[(2)] = inst_28143);

(statearr_28200_28270[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (33))){
var inst_28129 = (state_28170[(25)]);
var inst_28131 = cljs.core.chunked_seq_QMARK_.call(null,inst_28129);
var state_28170__$1 = state_28170;
if(inst_28131){
var statearr_28201_28271 = state_28170__$1;
(statearr_28201_28271[(1)] = (36));

} else {
var statearr_28202_28272 = state_28170__$1;
(statearr_28202_28272[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (13))){
var inst_28059 = (state_28170[(26)]);
var inst_28062 = cljs.core.async.close_BANG_.call(null,inst_28059);
var state_28170__$1 = state_28170;
var statearr_28203_28273 = state_28170__$1;
(statearr_28203_28273[(2)] = inst_28062);

(statearr_28203_28273[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (22))){
var inst_28082 = (state_28170[(8)]);
var inst_28085 = cljs.core.async.close_BANG_.call(null,inst_28082);
var state_28170__$1 = state_28170;
var statearr_28204_28274 = state_28170__$1;
(statearr_28204_28274[(2)] = inst_28085);

(statearr_28204_28274[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (36))){
var inst_28129 = (state_28170[(25)]);
var inst_28133 = cljs.core.chunk_first.call(null,inst_28129);
var inst_28134 = cljs.core.chunk_rest.call(null,inst_28129);
var inst_28135 = cljs.core.count.call(null,inst_28133);
var inst_28110 = inst_28134;
var inst_28111 = inst_28133;
var inst_28112 = inst_28135;
var inst_28113 = (0);
var state_28170__$1 = (function (){var statearr_28205 = state_28170;
(statearr_28205[(9)] = inst_28111);

(statearr_28205[(20)] = inst_28112);

(statearr_28205[(21)] = inst_28110);

(statearr_28205[(12)] = inst_28113);

return statearr_28205;
})();
var statearr_28206_28275 = state_28170__$1;
(statearr_28206_28275[(2)] = null);

(statearr_28206_28275[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (41))){
var inst_28129 = (state_28170[(25)]);
var inst_28145 = (state_28170[(2)]);
var inst_28146 = cljs.core.next.call(null,inst_28129);
var inst_28110 = inst_28146;
var inst_28111 = null;
var inst_28112 = (0);
var inst_28113 = (0);
var state_28170__$1 = (function (){var statearr_28207 = state_28170;
(statearr_28207[(9)] = inst_28111);

(statearr_28207[(20)] = inst_28112);

(statearr_28207[(21)] = inst_28110);

(statearr_28207[(12)] = inst_28113);

(statearr_28207[(27)] = inst_28145);

return statearr_28207;
})();
var statearr_28208_28276 = state_28170__$1;
(statearr_28208_28276[(2)] = null);

(statearr_28208_28276[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (43))){
var state_28170__$1 = state_28170;
var statearr_28209_28277 = state_28170__$1;
(statearr_28209_28277[(2)] = null);

(statearr_28209_28277[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (29))){
var inst_28154 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28210_28278 = state_28170__$1;
(statearr_28210_28278[(2)] = inst_28154);

(statearr_28210_28278[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (44))){
var inst_28163 = (state_28170[(2)]);
var state_28170__$1 = (function (){var statearr_28211 = state_28170;
(statearr_28211[(28)] = inst_28163);

return statearr_28211;
})();
var statearr_28212_28279 = state_28170__$1;
(statearr_28212_28279[(2)] = null);

(statearr_28212_28279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (6))){
var inst_28102 = (state_28170[(29)]);
var inst_28101 = cljs.core.deref.call(null,cs);
var inst_28102__$1 = cljs.core.keys.call(null,inst_28101);
var inst_28103 = cljs.core.count.call(null,inst_28102__$1);
var inst_28104 = cljs.core.reset_BANG_.call(null,dctr,inst_28103);
var inst_28109 = cljs.core.seq.call(null,inst_28102__$1);
var inst_28110 = inst_28109;
var inst_28111 = null;
var inst_28112 = (0);
var inst_28113 = (0);
var state_28170__$1 = (function (){var statearr_28213 = state_28170;
(statearr_28213[(9)] = inst_28111);

(statearr_28213[(29)] = inst_28102__$1);

(statearr_28213[(20)] = inst_28112);

(statearr_28213[(30)] = inst_28104);

(statearr_28213[(21)] = inst_28110);

(statearr_28213[(12)] = inst_28113);

return statearr_28213;
})();
var statearr_28214_28280 = state_28170__$1;
(statearr_28214_28280[(2)] = null);

(statearr_28214_28280[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (28))){
var inst_28110 = (state_28170[(21)]);
var inst_28129 = (state_28170[(25)]);
var inst_28129__$1 = cljs.core.seq.call(null,inst_28110);
var state_28170__$1 = (function (){var statearr_28215 = state_28170;
(statearr_28215[(25)] = inst_28129__$1);

return statearr_28215;
})();
if(inst_28129__$1){
var statearr_28216_28281 = state_28170__$1;
(statearr_28216_28281[(1)] = (33));

} else {
var statearr_28217_28282 = state_28170__$1;
(statearr_28217_28282[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (25))){
var inst_28112 = (state_28170[(20)]);
var inst_28113 = (state_28170[(12)]);
var inst_28115 = (inst_28113 < inst_28112);
var inst_28116 = inst_28115;
var state_28170__$1 = state_28170;
if(cljs.core.truth_(inst_28116)){
var statearr_28218_28283 = state_28170__$1;
(statearr_28218_28283[(1)] = (27));

} else {
var statearr_28219_28284 = state_28170__$1;
(statearr_28219_28284[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (34))){
var state_28170__$1 = state_28170;
var statearr_28220_28285 = state_28170__$1;
(statearr_28220_28285[(2)] = null);

(statearr_28220_28285[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (17))){
var state_28170__$1 = state_28170;
var statearr_28221_28286 = state_28170__$1;
(statearr_28221_28286[(2)] = null);

(statearr_28221_28286[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (3))){
var inst_28168 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28170__$1,inst_28168);
} else {
if((state_val_28171 === (12))){
var inst_28097 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28222_28287 = state_28170__$1;
(statearr_28222_28287[(2)] = inst_28097);

(statearr_28222_28287[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (2))){
var state_28170__$1 = state_28170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28170__$1,(4),ch);
} else {
if((state_val_28171 === (23))){
var state_28170__$1 = state_28170;
var statearr_28223_28288 = state_28170__$1;
(statearr_28223_28288[(2)] = null);

(statearr_28223_28288[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (35))){
var inst_28152 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28224_28289 = state_28170__$1;
(statearr_28224_28289[(2)] = inst_28152);

(statearr_28224_28289[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (19))){
var inst_28069 = (state_28170[(7)]);
var inst_28073 = cljs.core.chunk_first.call(null,inst_28069);
var inst_28074 = cljs.core.chunk_rest.call(null,inst_28069);
var inst_28075 = cljs.core.count.call(null,inst_28073);
var inst_28047 = inst_28074;
var inst_28048 = inst_28073;
var inst_28049 = inst_28075;
var inst_28050 = (0);
var state_28170__$1 = (function (){var statearr_28225 = state_28170;
(statearr_28225[(14)] = inst_28047);

(statearr_28225[(15)] = inst_28048);

(statearr_28225[(16)] = inst_28049);

(statearr_28225[(17)] = inst_28050);

return statearr_28225;
})();
var statearr_28226_28290 = state_28170__$1;
(statearr_28226_28290[(2)] = null);

(statearr_28226_28290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (11))){
var inst_28069 = (state_28170[(7)]);
var inst_28047 = (state_28170[(14)]);
var inst_28069__$1 = cljs.core.seq.call(null,inst_28047);
var state_28170__$1 = (function (){var statearr_28227 = state_28170;
(statearr_28227[(7)] = inst_28069__$1);

return statearr_28227;
})();
if(inst_28069__$1){
var statearr_28228_28291 = state_28170__$1;
(statearr_28228_28291[(1)] = (16));

} else {
var statearr_28229_28292 = state_28170__$1;
(statearr_28229_28292[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (9))){
var inst_28099 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28230_28293 = state_28170__$1;
(statearr_28230_28293[(2)] = inst_28099);

(statearr_28230_28293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (5))){
var inst_28045 = cljs.core.deref.call(null,cs);
var inst_28046 = cljs.core.seq.call(null,inst_28045);
var inst_28047 = inst_28046;
var inst_28048 = null;
var inst_28049 = (0);
var inst_28050 = (0);
var state_28170__$1 = (function (){var statearr_28231 = state_28170;
(statearr_28231[(14)] = inst_28047);

(statearr_28231[(15)] = inst_28048);

(statearr_28231[(16)] = inst_28049);

(statearr_28231[(17)] = inst_28050);

return statearr_28231;
})();
var statearr_28232_28294 = state_28170__$1;
(statearr_28232_28294[(2)] = null);

(statearr_28232_28294[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (14))){
var state_28170__$1 = state_28170;
var statearr_28233_28295 = state_28170__$1;
(statearr_28233_28295[(2)] = null);

(statearr_28233_28295[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (45))){
var inst_28160 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28234_28296 = state_28170__$1;
(statearr_28234_28296[(2)] = inst_28160);

(statearr_28234_28296[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (26))){
var inst_28102 = (state_28170[(29)]);
var inst_28156 = (state_28170[(2)]);
var inst_28157 = cljs.core.seq.call(null,inst_28102);
var state_28170__$1 = (function (){var statearr_28235 = state_28170;
(statearr_28235[(31)] = inst_28156);

return statearr_28235;
})();
if(inst_28157){
var statearr_28236_28297 = state_28170__$1;
(statearr_28236_28297[(1)] = (42));

} else {
var statearr_28237_28298 = state_28170__$1;
(statearr_28237_28298[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (16))){
var inst_28069 = (state_28170[(7)]);
var inst_28071 = cljs.core.chunked_seq_QMARK_.call(null,inst_28069);
var state_28170__$1 = state_28170;
if(inst_28071){
var statearr_28238_28299 = state_28170__$1;
(statearr_28238_28299[(1)] = (19));

} else {
var statearr_28239_28300 = state_28170__$1;
(statearr_28239_28300[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (38))){
var inst_28149 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28240_28301 = state_28170__$1;
(statearr_28240_28301[(2)] = inst_28149);

(statearr_28240_28301[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (30))){
var state_28170__$1 = state_28170;
var statearr_28241_28302 = state_28170__$1;
(statearr_28241_28302[(2)] = null);

(statearr_28241_28302[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (10))){
var inst_28048 = (state_28170[(15)]);
var inst_28050 = (state_28170[(17)]);
var inst_28058 = cljs.core._nth.call(null,inst_28048,inst_28050);
var inst_28059 = cljs.core.nth.call(null,inst_28058,(0),null);
var inst_28060 = cljs.core.nth.call(null,inst_28058,(1),null);
var state_28170__$1 = (function (){var statearr_28242 = state_28170;
(statearr_28242[(26)] = inst_28059);

return statearr_28242;
})();
if(cljs.core.truth_(inst_28060)){
var statearr_28243_28303 = state_28170__$1;
(statearr_28243_28303[(1)] = (13));

} else {
var statearr_28244_28304 = state_28170__$1;
(statearr_28244_28304[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (18))){
var inst_28095 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28245_28305 = state_28170__$1;
(statearr_28245_28305[(2)] = inst_28095);

(statearr_28245_28305[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (42))){
var state_28170__$1 = state_28170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28170__$1,(45),dchan);
} else {
if((state_val_28171 === (37))){
var inst_28038 = (state_28170[(11)]);
var inst_28129 = (state_28170[(25)]);
var inst_28138 = (state_28170[(23)]);
var inst_28138__$1 = cljs.core.first.call(null,inst_28129);
var inst_28139 = cljs.core.async.put_BANG_.call(null,inst_28138__$1,inst_28038,done);
var state_28170__$1 = (function (){var statearr_28246 = state_28170;
(statearr_28246[(23)] = inst_28138__$1);

return statearr_28246;
})();
if(cljs.core.truth_(inst_28139)){
var statearr_28247_28306 = state_28170__$1;
(statearr_28247_28306[(1)] = (39));

} else {
var statearr_28248_28307 = state_28170__$1;
(statearr_28248_28307[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28171 === (8))){
var inst_28049 = (state_28170[(16)]);
var inst_28050 = (state_28170[(17)]);
var inst_28052 = (inst_28050 < inst_28049);
var inst_28053 = inst_28052;
var state_28170__$1 = state_28170;
if(cljs.core.truth_(inst_28053)){
var statearr_28249_28308 = state_28170__$1;
(statearr_28249_28308[(1)] = (10));

} else {
var statearr_28250_28309 = state_28170__$1;
(statearr_28250_28309[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___28255,cs,m,dchan,dctr,done))
;
return ((function (switch__25405__auto__,c__25572__auto___28255,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__25406__auto__ = null;
var cljs$core$async$mult_$_state_machine__25406__auto____0 = (function (){
var statearr_28251 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28251[(0)] = cljs$core$async$mult_$_state_machine__25406__auto__);

(statearr_28251[(1)] = (1));

return statearr_28251;
});
var cljs$core$async$mult_$_state_machine__25406__auto____1 = (function (state_28170){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_28170);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e28252){if((e28252 instanceof Object)){
var ex__25409__auto__ = e28252;
var statearr_28253_28310 = state_28170;
(statearr_28253_28310[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28170);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28252;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28311 = state_28170;
state_28170 = G__28311;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__25406__auto__ = function(state_28170){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__25406__auto____1.call(this,state_28170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__25406__auto____0;
cljs$core$async$mult_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__25406__auto____1;
return cljs$core$async$mult_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___28255,cs,m,dchan,dctr,done))
})();
var state__25574__auto__ = (function (){var statearr_28254 = f__25573__auto__.call(null);
(statearr_28254[(6)] = c__25572__auto___28255);

return statearr_28254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___28255,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__28313 = arguments.length;
switch (G__28313) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___28325 = arguments.length;
var i__4731__auto___28326 = (0);
while(true){
if((i__4731__auto___28326 < len__4730__auto___28325)){
args__4736__auto__.push((arguments[i__4731__auto___28326]));

var G__28327 = (i__4731__auto___28326 + (1));
i__4731__auto___28326 = G__28327;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__28319){
var map__28320 = p__28319;
var map__28320__$1 = (((((!((map__28320 == null))))?(((((map__28320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28320.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28320):map__28320);
var opts = map__28320__$1;
var statearr_28322_28328 = state;
(statearr_28322_28328[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__28320,map__28320__$1,opts){
return (function (val){
var statearr_28323_28329 = state;
(statearr_28323_28329[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__28320,map__28320__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_28324_28330 = state;
(statearr_28324_28330[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq28315){
var G__28316 = cljs.core.first.call(null,seq28315);
var seq28315__$1 = cljs.core.next.call(null,seq28315);
var G__28317 = cljs.core.first.call(null,seq28315__$1);
var seq28315__$2 = cljs.core.next.call(null,seq28315__$1);
var G__28318 = cljs.core.first.call(null,seq28315__$2);
var seq28315__$3 = cljs.core.next.call(null,seq28315__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28316,G__28317,G__28318,seq28315__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28331 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28331 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta28332){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta28332 = meta28332;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28331.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_28333,meta28332__$1){
var self__ = this;
var _28333__$1 = this;
return (new cljs.core.async.t_cljs$core$async28331(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta28332__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28331.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_28333){
var self__ = this;
var _28333__$1 = this;
return self__.meta28332;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28331.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28331.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28331.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28331.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28331.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28331.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28331.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28331.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28331.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta28332","meta28332",-121913909,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28331.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28331.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28331";

cljs.core.async.t_cljs$core$async28331.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28331");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28331.
 */
cljs.core.async.__GT_t_cljs$core$async28331 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async28331(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta28332){
return (new cljs.core.async.t_cljs$core$async28331(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta28332));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async28331(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__25572__auto___28495 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___28495,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___28495,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_28435){
var state_val_28436 = (state_28435[(1)]);
if((state_val_28436 === (7))){
var inst_28350 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
var statearr_28437_28496 = state_28435__$1;
(statearr_28437_28496[(2)] = inst_28350);

(statearr_28437_28496[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (20))){
var inst_28362 = (state_28435[(7)]);
var state_28435__$1 = state_28435;
var statearr_28438_28497 = state_28435__$1;
(statearr_28438_28497[(2)] = inst_28362);

(statearr_28438_28497[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (27))){
var state_28435__$1 = state_28435;
var statearr_28439_28498 = state_28435__$1;
(statearr_28439_28498[(2)] = null);

(statearr_28439_28498[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (1))){
var inst_28337 = (state_28435[(8)]);
var inst_28337__$1 = calc_state.call(null);
var inst_28339 = (inst_28337__$1 == null);
var inst_28340 = cljs.core.not.call(null,inst_28339);
var state_28435__$1 = (function (){var statearr_28440 = state_28435;
(statearr_28440[(8)] = inst_28337__$1);

return statearr_28440;
})();
if(inst_28340){
var statearr_28441_28499 = state_28435__$1;
(statearr_28441_28499[(1)] = (2));

} else {
var statearr_28442_28500 = state_28435__$1;
(statearr_28442_28500[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (24))){
var inst_28409 = (state_28435[(9)]);
var inst_28386 = (state_28435[(10)]);
var inst_28395 = (state_28435[(11)]);
var inst_28409__$1 = inst_28386.call(null,inst_28395);
var state_28435__$1 = (function (){var statearr_28443 = state_28435;
(statearr_28443[(9)] = inst_28409__$1);

return statearr_28443;
})();
if(cljs.core.truth_(inst_28409__$1)){
var statearr_28444_28501 = state_28435__$1;
(statearr_28444_28501[(1)] = (29));

} else {
var statearr_28445_28502 = state_28435__$1;
(statearr_28445_28502[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (4))){
var inst_28353 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
if(cljs.core.truth_(inst_28353)){
var statearr_28446_28503 = state_28435__$1;
(statearr_28446_28503[(1)] = (8));

} else {
var statearr_28447_28504 = state_28435__$1;
(statearr_28447_28504[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (15))){
var inst_28380 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
if(cljs.core.truth_(inst_28380)){
var statearr_28448_28505 = state_28435__$1;
(statearr_28448_28505[(1)] = (19));

} else {
var statearr_28449_28506 = state_28435__$1;
(statearr_28449_28506[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (21))){
var inst_28385 = (state_28435[(12)]);
var inst_28385__$1 = (state_28435[(2)]);
var inst_28386 = cljs.core.get.call(null,inst_28385__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_28387 = cljs.core.get.call(null,inst_28385__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_28388 = cljs.core.get.call(null,inst_28385__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_28435__$1 = (function (){var statearr_28450 = state_28435;
(statearr_28450[(12)] = inst_28385__$1);

(statearr_28450[(10)] = inst_28386);

(statearr_28450[(13)] = inst_28387);

return statearr_28450;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28435__$1,(22),inst_28388);
} else {
if((state_val_28436 === (31))){
var inst_28417 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
if(cljs.core.truth_(inst_28417)){
var statearr_28451_28507 = state_28435__$1;
(statearr_28451_28507[(1)] = (32));

} else {
var statearr_28452_28508 = state_28435__$1;
(statearr_28452_28508[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (32))){
var inst_28394 = (state_28435[(14)]);
var state_28435__$1 = state_28435;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28435__$1,(35),out,inst_28394);
} else {
if((state_val_28436 === (33))){
var inst_28385 = (state_28435[(12)]);
var inst_28362 = inst_28385;
var state_28435__$1 = (function (){var statearr_28453 = state_28435;
(statearr_28453[(7)] = inst_28362);

return statearr_28453;
})();
var statearr_28454_28509 = state_28435__$1;
(statearr_28454_28509[(2)] = null);

(statearr_28454_28509[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (13))){
var inst_28362 = (state_28435[(7)]);
var inst_28369 = inst_28362.cljs$lang$protocol_mask$partition0$;
var inst_28370 = (inst_28369 & (64));
var inst_28371 = inst_28362.cljs$core$ISeq$;
var inst_28372 = (cljs.core.PROTOCOL_SENTINEL === inst_28371);
var inst_28373 = ((inst_28370) || (inst_28372));
var state_28435__$1 = state_28435;
if(cljs.core.truth_(inst_28373)){
var statearr_28455_28510 = state_28435__$1;
(statearr_28455_28510[(1)] = (16));

} else {
var statearr_28456_28511 = state_28435__$1;
(statearr_28456_28511[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (22))){
var inst_28394 = (state_28435[(14)]);
var inst_28395 = (state_28435[(11)]);
var inst_28393 = (state_28435[(2)]);
var inst_28394__$1 = cljs.core.nth.call(null,inst_28393,(0),null);
var inst_28395__$1 = cljs.core.nth.call(null,inst_28393,(1),null);
var inst_28396 = (inst_28394__$1 == null);
var inst_28397 = cljs.core._EQ_.call(null,inst_28395__$1,change);
var inst_28398 = ((inst_28396) || (inst_28397));
var state_28435__$1 = (function (){var statearr_28457 = state_28435;
(statearr_28457[(14)] = inst_28394__$1);

(statearr_28457[(11)] = inst_28395__$1);

return statearr_28457;
})();
if(cljs.core.truth_(inst_28398)){
var statearr_28458_28512 = state_28435__$1;
(statearr_28458_28512[(1)] = (23));

} else {
var statearr_28459_28513 = state_28435__$1;
(statearr_28459_28513[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (36))){
var inst_28385 = (state_28435[(12)]);
var inst_28362 = inst_28385;
var state_28435__$1 = (function (){var statearr_28460 = state_28435;
(statearr_28460[(7)] = inst_28362);

return statearr_28460;
})();
var statearr_28461_28514 = state_28435__$1;
(statearr_28461_28514[(2)] = null);

(statearr_28461_28514[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (29))){
var inst_28409 = (state_28435[(9)]);
var state_28435__$1 = state_28435;
var statearr_28462_28515 = state_28435__$1;
(statearr_28462_28515[(2)] = inst_28409);

(statearr_28462_28515[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (6))){
var state_28435__$1 = state_28435;
var statearr_28463_28516 = state_28435__$1;
(statearr_28463_28516[(2)] = false);

(statearr_28463_28516[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (28))){
var inst_28405 = (state_28435[(2)]);
var inst_28406 = calc_state.call(null);
var inst_28362 = inst_28406;
var state_28435__$1 = (function (){var statearr_28464 = state_28435;
(statearr_28464[(7)] = inst_28362);

(statearr_28464[(15)] = inst_28405);

return statearr_28464;
})();
var statearr_28465_28517 = state_28435__$1;
(statearr_28465_28517[(2)] = null);

(statearr_28465_28517[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (25))){
var inst_28431 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
var statearr_28466_28518 = state_28435__$1;
(statearr_28466_28518[(2)] = inst_28431);

(statearr_28466_28518[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (34))){
var inst_28429 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
var statearr_28467_28519 = state_28435__$1;
(statearr_28467_28519[(2)] = inst_28429);

(statearr_28467_28519[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (17))){
var state_28435__$1 = state_28435;
var statearr_28468_28520 = state_28435__$1;
(statearr_28468_28520[(2)] = false);

(statearr_28468_28520[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (3))){
var state_28435__$1 = state_28435;
var statearr_28469_28521 = state_28435__$1;
(statearr_28469_28521[(2)] = false);

(statearr_28469_28521[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (12))){
var inst_28433 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28435__$1,inst_28433);
} else {
if((state_val_28436 === (2))){
var inst_28337 = (state_28435[(8)]);
var inst_28342 = inst_28337.cljs$lang$protocol_mask$partition0$;
var inst_28343 = (inst_28342 & (64));
var inst_28344 = inst_28337.cljs$core$ISeq$;
var inst_28345 = (cljs.core.PROTOCOL_SENTINEL === inst_28344);
var inst_28346 = ((inst_28343) || (inst_28345));
var state_28435__$1 = state_28435;
if(cljs.core.truth_(inst_28346)){
var statearr_28470_28522 = state_28435__$1;
(statearr_28470_28522[(1)] = (5));

} else {
var statearr_28471_28523 = state_28435__$1;
(statearr_28471_28523[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (23))){
var inst_28394 = (state_28435[(14)]);
var inst_28400 = (inst_28394 == null);
var state_28435__$1 = state_28435;
if(cljs.core.truth_(inst_28400)){
var statearr_28472_28524 = state_28435__$1;
(statearr_28472_28524[(1)] = (26));

} else {
var statearr_28473_28525 = state_28435__$1;
(statearr_28473_28525[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (35))){
var inst_28420 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
if(cljs.core.truth_(inst_28420)){
var statearr_28474_28526 = state_28435__$1;
(statearr_28474_28526[(1)] = (36));

} else {
var statearr_28475_28527 = state_28435__$1;
(statearr_28475_28527[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (19))){
var inst_28362 = (state_28435[(7)]);
var inst_28382 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28362);
var state_28435__$1 = state_28435;
var statearr_28476_28528 = state_28435__$1;
(statearr_28476_28528[(2)] = inst_28382);

(statearr_28476_28528[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (11))){
var inst_28362 = (state_28435[(7)]);
var inst_28366 = (inst_28362 == null);
var inst_28367 = cljs.core.not.call(null,inst_28366);
var state_28435__$1 = state_28435;
if(inst_28367){
var statearr_28477_28529 = state_28435__$1;
(statearr_28477_28529[(1)] = (13));

} else {
var statearr_28478_28530 = state_28435__$1;
(statearr_28478_28530[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (9))){
var inst_28337 = (state_28435[(8)]);
var state_28435__$1 = state_28435;
var statearr_28479_28531 = state_28435__$1;
(statearr_28479_28531[(2)] = inst_28337);

(statearr_28479_28531[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (5))){
var state_28435__$1 = state_28435;
var statearr_28480_28532 = state_28435__$1;
(statearr_28480_28532[(2)] = true);

(statearr_28480_28532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (14))){
var state_28435__$1 = state_28435;
var statearr_28481_28533 = state_28435__$1;
(statearr_28481_28533[(2)] = false);

(statearr_28481_28533[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (26))){
var inst_28395 = (state_28435[(11)]);
var inst_28402 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_28395);
var state_28435__$1 = state_28435;
var statearr_28482_28534 = state_28435__$1;
(statearr_28482_28534[(2)] = inst_28402);

(statearr_28482_28534[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (16))){
var state_28435__$1 = state_28435;
var statearr_28483_28535 = state_28435__$1;
(statearr_28483_28535[(2)] = true);

(statearr_28483_28535[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (38))){
var inst_28425 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
var statearr_28484_28536 = state_28435__$1;
(statearr_28484_28536[(2)] = inst_28425);

(statearr_28484_28536[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (30))){
var inst_28386 = (state_28435[(10)]);
var inst_28387 = (state_28435[(13)]);
var inst_28395 = (state_28435[(11)]);
var inst_28412 = cljs.core.empty_QMARK_.call(null,inst_28386);
var inst_28413 = inst_28387.call(null,inst_28395);
var inst_28414 = cljs.core.not.call(null,inst_28413);
var inst_28415 = ((inst_28412) && (inst_28414));
var state_28435__$1 = state_28435;
var statearr_28485_28537 = state_28435__$1;
(statearr_28485_28537[(2)] = inst_28415);

(statearr_28485_28537[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (10))){
var inst_28337 = (state_28435[(8)]);
var inst_28358 = (state_28435[(2)]);
var inst_28359 = cljs.core.get.call(null,inst_28358,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_28360 = cljs.core.get.call(null,inst_28358,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_28361 = cljs.core.get.call(null,inst_28358,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_28362 = inst_28337;
var state_28435__$1 = (function (){var statearr_28486 = state_28435;
(statearr_28486[(16)] = inst_28361);

(statearr_28486[(17)] = inst_28360);

(statearr_28486[(7)] = inst_28362);

(statearr_28486[(18)] = inst_28359);

return statearr_28486;
})();
var statearr_28487_28538 = state_28435__$1;
(statearr_28487_28538[(2)] = null);

(statearr_28487_28538[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (18))){
var inst_28377 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
var statearr_28488_28539 = state_28435__$1;
(statearr_28488_28539[(2)] = inst_28377);

(statearr_28488_28539[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (37))){
var state_28435__$1 = state_28435;
var statearr_28489_28540 = state_28435__$1;
(statearr_28489_28540[(2)] = null);

(statearr_28489_28540[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (8))){
var inst_28337 = (state_28435[(8)]);
var inst_28355 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28337);
var state_28435__$1 = state_28435;
var statearr_28490_28541 = state_28435__$1;
(statearr_28490_28541[(2)] = inst_28355);

(statearr_28490_28541[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___28495,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__25405__auto__,c__25572__auto___28495,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__25406__auto__ = null;
var cljs$core$async$mix_$_state_machine__25406__auto____0 = (function (){
var statearr_28491 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28491[(0)] = cljs$core$async$mix_$_state_machine__25406__auto__);

(statearr_28491[(1)] = (1));

return statearr_28491;
});
var cljs$core$async$mix_$_state_machine__25406__auto____1 = (function (state_28435){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_28435);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e28492){if((e28492 instanceof Object)){
var ex__25409__auto__ = e28492;
var statearr_28493_28542 = state_28435;
(statearr_28493_28542[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28435);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28492;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28543 = state_28435;
state_28435 = G__28543;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__25406__auto__ = function(state_28435){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__25406__auto____1.call(this,state_28435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__25406__auto____0;
cljs$core$async$mix_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__25406__auto____1;
return cljs$core$async$mix_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___28495,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__25574__auto__ = (function (){var statearr_28494 = f__25573__auto__.call(null);
(statearr_28494[(6)] = c__25572__auto___28495);

return statearr_28494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___28495,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__28545 = arguments.length;
switch (G__28545) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__28549 = arguments.length;
switch (G__28549) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__28547_SHARP_){
if(cljs.core.truth_(p1__28547_SHARP_.call(null,topic))){
return p1__28547_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__28547_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28550 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28550 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta28551){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta28551 = meta28551;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28550.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_28552,meta28551__$1){
var self__ = this;
var _28552__$1 = this;
return (new cljs.core.async.t_cljs$core$async28550(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta28551__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28550.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_28552){
var self__ = this;
var _28552__$1 = this;
return self__.meta28551;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28550.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28550.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28550.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28550.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28550.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28550.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28550.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28550.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta28551","meta28551",-1963311272,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28550.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28550.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28550";

cljs.core.async.t_cljs$core$async28550.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28550");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28550.
 */
cljs.core.async.__GT_t_cljs$core$async28550 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async28550(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta28551){
return (new cljs.core.async.t_cljs$core$async28550(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta28551));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async28550(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__25572__auto___28670 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___28670,mults,ensure_mult,p){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___28670,mults,ensure_mult,p){
return (function (state_28624){
var state_val_28625 = (state_28624[(1)]);
if((state_val_28625 === (7))){
var inst_28620 = (state_28624[(2)]);
var state_28624__$1 = state_28624;
var statearr_28626_28671 = state_28624__$1;
(statearr_28626_28671[(2)] = inst_28620);

(statearr_28626_28671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (20))){
var state_28624__$1 = state_28624;
var statearr_28627_28672 = state_28624__$1;
(statearr_28627_28672[(2)] = null);

(statearr_28627_28672[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (1))){
var state_28624__$1 = state_28624;
var statearr_28628_28673 = state_28624__$1;
(statearr_28628_28673[(2)] = null);

(statearr_28628_28673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (24))){
var inst_28603 = (state_28624[(7)]);
var inst_28612 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_28603);
var state_28624__$1 = state_28624;
var statearr_28629_28674 = state_28624__$1;
(statearr_28629_28674[(2)] = inst_28612);

(statearr_28629_28674[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (4))){
var inst_28555 = (state_28624[(8)]);
var inst_28555__$1 = (state_28624[(2)]);
var inst_28556 = (inst_28555__$1 == null);
var state_28624__$1 = (function (){var statearr_28630 = state_28624;
(statearr_28630[(8)] = inst_28555__$1);

return statearr_28630;
})();
if(cljs.core.truth_(inst_28556)){
var statearr_28631_28675 = state_28624__$1;
(statearr_28631_28675[(1)] = (5));

} else {
var statearr_28632_28676 = state_28624__$1;
(statearr_28632_28676[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (15))){
var inst_28597 = (state_28624[(2)]);
var state_28624__$1 = state_28624;
var statearr_28633_28677 = state_28624__$1;
(statearr_28633_28677[(2)] = inst_28597);

(statearr_28633_28677[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (21))){
var inst_28617 = (state_28624[(2)]);
var state_28624__$1 = (function (){var statearr_28634 = state_28624;
(statearr_28634[(9)] = inst_28617);

return statearr_28634;
})();
var statearr_28635_28678 = state_28624__$1;
(statearr_28635_28678[(2)] = null);

(statearr_28635_28678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (13))){
var inst_28579 = (state_28624[(10)]);
var inst_28581 = cljs.core.chunked_seq_QMARK_.call(null,inst_28579);
var state_28624__$1 = state_28624;
if(inst_28581){
var statearr_28636_28679 = state_28624__$1;
(statearr_28636_28679[(1)] = (16));

} else {
var statearr_28637_28680 = state_28624__$1;
(statearr_28637_28680[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (22))){
var inst_28609 = (state_28624[(2)]);
var state_28624__$1 = state_28624;
if(cljs.core.truth_(inst_28609)){
var statearr_28638_28681 = state_28624__$1;
(statearr_28638_28681[(1)] = (23));

} else {
var statearr_28639_28682 = state_28624__$1;
(statearr_28639_28682[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (6))){
var inst_28603 = (state_28624[(7)]);
var inst_28605 = (state_28624[(11)]);
var inst_28555 = (state_28624[(8)]);
var inst_28603__$1 = topic_fn.call(null,inst_28555);
var inst_28604 = cljs.core.deref.call(null,mults);
var inst_28605__$1 = cljs.core.get.call(null,inst_28604,inst_28603__$1);
var state_28624__$1 = (function (){var statearr_28640 = state_28624;
(statearr_28640[(7)] = inst_28603__$1);

(statearr_28640[(11)] = inst_28605__$1);

return statearr_28640;
})();
if(cljs.core.truth_(inst_28605__$1)){
var statearr_28641_28683 = state_28624__$1;
(statearr_28641_28683[(1)] = (19));

} else {
var statearr_28642_28684 = state_28624__$1;
(statearr_28642_28684[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (25))){
var inst_28614 = (state_28624[(2)]);
var state_28624__$1 = state_28624;
var statearr_28643_28685 = state_28624__$1;
(statearr_28643_28685[(2)] = inst_28614);

(statearr_28643_28685[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (17))){
var inst_28579 = (state_28624[(10)]);
var inst_28588 = cljs.core.first.call(null,inst_28579);
var inst_28589 = cljs.core.async.muxch_STAR_.call(null,inst_28588);
var inst_28590 = cljs.core.async.close_BANG_.call(null,inst_28589);
var inst_28591 = cljs.core.next.call(null,inst_28579);
var inst_28565 = inst_28591;
var inst_28566 = null;
var inst_28567 = (0);
var inst_28568 = (0);
var state_28624__$1 = (function (){var statearr_28644 = state_28624;
(statearr_28644[(12)] = inst_28568);

(statearr_28644[(13)] = inst_28590);

(statearr_28644[(14)] = inst_28565);

(statearr_28644[(15)] = inst_28566);

(statearr_28644[(16)] = inst_28567);

return statearr_28644;
})();
var statearr_28645_28686 = state_28624__$1;
(statearr_28645_28686[(2)] = null);

(statearr_28645_28686[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (3))){
var inst_28622 = (state_28624[(2)]);
var state_28624__$1 = state_28624;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28624__$1,inst_28622);
} else {
if((state_val_28625 === (12))){
var inst_28599 = (state_28624[(2)]);
var state_28624__$1 = state_28624;
var statearr_28646_28687 = state_28624__$1;
(statearr_28646_28687[(2)] = inst_28599);

(statearr_28646_28687[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (2))){
var state_28624__$1 = state_28624;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28624__$1,(4),ch);
} else {
if((state_val_28625 === (23))){
var state_28624__$1 = state_28624;
var statearr_28647_28688 = state_28624__$1;
(statearr_28647_28688[(2)] = null);

(statearr_28647_28688[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (19))){
var inst_28605 = (state_28624[(11)]);
var inst_28555 = (state_28624[(8)]);
var inst_28607 = cljs.core.async.muxch_STAR_.call(null,inst_28605);
var state_28624__$1 = state_28624;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28624__$1,(22),inst_28607,inst_28555);
} else {
if((state_val_28625 === (11))){
var inst_28565 = (state_28624[(14)]);
var inst_28579 = (state_28624[(10)]);
var inst_28579__$1 = cljs.core.seq.call(null,inst_28565);
var state_28624__$1 = (function (){var statearr_28648 = state_28624;
(statearr_28648[(10)] = inst_28579__$1);

return statearr_28648;
})();
if(inst_28579__$1){
var statearr_28649_28689 = state_28624__$1;
(statearr_28649_28689[(1)] = (13));

} else {
var statearr_28650_28690 = state_28624__$1;
(statearr_28650_28690[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (9))){
var inst_28601 = (state_28624[(2)]);
var state_28624__$1 = state_28624;
var statearr_28651_28691 = state_28624__$1;
(statearr_28651_28691[(2)] = inst_28601);

(statearr_28651_28691[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (5))){
var inst_28562 = cljs.core.deref.call(null,mults);
var inst_28563 = cljs.core.vals.call(null,inst_28562);
var inst_28564 = cljs.core.seq.call(null,inst_28563);
var inst_28565 = inst_28564;
var inst_28566 = null;
var inst_28567 = (0);
var inst_28568 = (0);
var state_28624__$1 = (function (){var statearr_28652 = state_28624;
(statearr_28652[(12)] = inst_28568);

(statearr_28652[(14)] = inst_28565);

(statearr_28652[(15)] = inst_28566);

(statearr_28652[(16)] = inst_28567);

return statearr_28652;
})();
var statearr_28653_28692 = state_28624__$1;
(statearr_28653_28692[(2)] = null);

(statearr_28653_28692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (14))){
var state_28624__$1 = state_28624;
var statearr_28657_28693 = state_28624__$1;
(statearr_28657_28693[(2)] = null);

(statearr_28657_28693[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (16))){
var inst_28579 = (state_28624[(10)]);
var inst_28583 = cljs.core.chunk_first.call(null,inst_28579);
var inst_28584 = cljs.core.chunk_rest.call(null,inst_28579);
var inst_28585 = cljs.core.count.call(null,inst_28583);
var inst_28565 = inst_28584;
var inst_28566 = inst_28583;
var inst_28567 = inst_28585;
var inst_28568 = (0);
var state_28624__$1 = (function (){var statearr_28658 = state_28624;
(statearr_28658[(12)] = inst_28568);

(statearr_28658[(14)] = inst_28565);

(statearr_28658[(15)] = inst_28566);

(statearr_28658[(16)] = inst_28567);

return statearr_28658;
})();
var statearr_28659_28694 = state_28624__$1;
(statearr_28659_28694[(2)] = null);

(statearr_28659_28694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (10))){
var inst_28568 = (state_28624[(12)]);
var inst_28565 = (state_28624[(14)]);
var inst_28566 = (state_28624[(15)]);
var inst_28567 = (state_28624[(16)]);
var inst_28573 = cljs.core._nth.call(null,inst_28566,inst_28568);
var inst_28574 = cljs.core.async.muxch_STAR_.call(null,inst_28573);
var inst_28575 = cljs.core.async.close_BANG_.call(null,inst_28574);
var inst_28576 = (inst_28568 + (1));
var tmp28654 = inst_28565;
var tmp28655 = inst_28566;
var tmp28656 = inst_28567;
var inst_28565__$1 = tmp28654;
var inst_28566__$1 = tmp28655;
var inst_28567__$1 = tmp28656;
var inst_28568__$1 = inst_28576;
var state_28624__$1 = (function (){var statearr_28660 = state_28624;
(statearr_28660[(12)] = inst_28568__$1);

(statearr_28660[(14)] = inst_28565__$1);

(statearr_28660[(15)] = inst_28566__$1);

(statearr_28660[(17)] = inst_28575);

(statearr_28660[(16)] = inst_28567__$1);

return statearr_28660;
})();
var statearr_28661_28695 = state_28624__$1;
(statearr_28661_28695[(2)] = null);

(statearr_28661_28695[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (18))){
var inst_28594 = (state_28624[(2)]);
var state_28624__$1 = state_28624;
var statearr_28662_28696 = state_28624__$1;
(statearr_28662_28696[(2)] = inst_28594);

(statearr_28662_28696[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28625 === (8))){
var inst_28568 = (state_28624[(12)]);
var inst_28567 = (state_28624[(16)]);
var inst_28570 = (inst_28568 < inst_28567);
var inst_28571 = inst_28570;
var state_28624__$1 = state_28624;
if(cljs.core.truth_(inst_28571)){
var statearr_28663_28697 = state_28624__$1;
(statearr_28663_28697[(1)] = (10));

} else {
var statearr_28664_28698 = state_28624__$1;
(statearr_28664_28698[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___28670,mults,ensure_mult,p))
;
return ((function (switch__25405__auto__,c__25572__auto___28670,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_28665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28665[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_28665[(1)] = (1));

return statearr_28665;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_28624){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_28624);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e28666){if((e28666 instanceof Object)){
var ex__25409__auto__ = e28666;
var statearr_28667_28699 = state_28624;
(statearr_28667_28699[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28624);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28666;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28700 = state_28624;
state_28624 = G__28700;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_28624){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_28624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___28670,mults,ensure_mult,p))
})();
var state__25574__auto__ = (function (){var statearr_28668 = f__25573__auto__.call(null);
(statearr_28668[(6)] = c__25572__auto___28670);

return statearr_28668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___28670,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__28702 = arguments.length;
switch (G__28702) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__28705 = arguments.length;
switch (G__28705) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__28708 = arguments.length;
switch (G__28708) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__25572__auto___28775 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___28775,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___28775,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_28747){
var state_val_28748 = (state_28747[(1)]);
if((state_val_28748 === (7))){
var state_28747__$1 = state_28747;
var statearr_28749_28776 = state_28747__$1;
(statearr_28749_28776[(2)] = null);

(statearr_28749_28776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (1))){
var state_28747__$1 = state_28747;
var statearr_28750_28777 = state_28747__$1;
(statearr_28750_28777[(2)] = null);

(statearr_28750_28777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (4))){
var inst_28711 = (state_28747[(7)]);
var inst_28713 = (inst_28711 < cnt);
var state_28747__$1 = state_28747;
if(cljs.core.truth_(inst_28713)){
var statearr_28751_28778 = state_28747__$1;
(statearr_28751_28778[(1)] = (6));

} else {
var statearr_28752_28779 = state_28747__$1;
(statearr_28752_28779[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (15))){
var inst_28743 = (state_28747[(2)]);
var state_28747__$1 = state_28747;
var statearr_28753_28780 = state_28747__$1;
(statearr_28753_28780[(2)] = inst_28743);

(statearr_28753_28780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (13))){
var inst_28736 = cljs.core.async.close_BANG_.call(null,out);
var state_28747__$1 = state_28747;
var statearr_28754_28781 = state_28747__$1;
(statearr_28754_28781[(2)] = inst_28736);

(statearr_28754_28781[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (6))){
var state_28747__$1 = state_28747;
var statearr_28755_28782 = state_28747__$1;
(statearr_28755_28782[(2)] = null);

(statearr_28755_28782[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (3))){
var inst_28745 = (state_28747[(2)]);
var state_28747__$1 = state_28747;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28747__$1,inst_28745);
} else {
if((state_val_28748 === (12))){
var inst_28733 = (state_28747[(8)]);
var inst_28733__$1 = (state_28747[(2)]);
var inst_28734 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_28733__$1);
var state_28747__$1 = (function (){var statearr_28756 = state_28747;
(statearr_28756[(8)] = inst_28733__$1);

return statearr_28756;
})();
if(cljs.core.truth_(inst_28734)){
var statearr_28757_28783 = state_28747__$1;
(statearr_28757_28783[(1)] = (13));

} else {
var statearr_28758_28784 = state_28747__$1;
(statearr_28758_28784[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (2))){
var inst_28710 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_28711 = (0);
var state_28747__$1 = (function (){var statearr_28759 = state_28747;
(statearr_28759[(7)] = inst_28711);

(statearr_28759[(9)] = inst_28710);

return statearr_28759;
})();
var statearr_28760_28785 = state_28747__$1;
(statearr_28760_28785[(2)] = null);

(statearr_28760_28785[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (11))){
var inst_28711 = (state_28747[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_28747,(10),Object,null,(9));
var inst_28720 = chs__$1.call(null,inst_28711);
var inst_28721 = done.call(null,inst_28711);
var inst_28722 = cljs.core.async.take_BANG_.call(null,inst_28720,inst_28721);
var state_28747__$1 = state_28747;
var statearr_28761_28786 = state_28747__$1;
(statearr_28761_28786[(2)] = inst_28722);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28747__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (9))){
var inst_28711 = (state_28747[(7)]);
var inst_28724 = (state_28747[(2)]);
var inst_28725 = (inst_28711 + (1));
var inst_28711__$1 = inst_28725;
var state_28747__$1 = (function (){var statearr_28762 = state_28747;
(statearr_28762[(10)] = inst_28724);

(statearr_28762[(7)] = inst_28711__$1);

return statearr_28762;
})();
var statearr_28763_28787 = state_28747__$1;
(statearr_28763_28787[(2)] = null);

(statearr_28763_28787[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (5))){
var inst_28731 = (state_28747[(2)]);
var state_28747__$1 = (function (){var statearr_28764 = state_28747;
(statearr_28764[(11)] = inst_28731);

return statearr_28764;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28747__$1,(12),dchan);
} else {
if((state_val_28748 === (14))){
var inst_28733 = (state_28747[(8)]);
var inst_28738 = cljs.core.apply.call(null,f,inst_28733);
var state_28747__$1 = state_28747;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28747__$1,(16),out,inst_28738);
} else {
if((state_val_28748 === (16))){
var inst_28740 = (state_28747[(2)]);
var state_28747__$1 = (function (){var statearr_28765 = state_28747;
(statearr_28765[(12)] = inst_28740);

return statearr_28765;
})();
var statearr_28766_28788 = state_28747__$1;
(statearr_28766_28788[(2)] = null);

(statearr_28766_28788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (10))){
var inst_28715 = (state_28747[(2)]);
var inst_28716 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_28747__$1 = (function (){var statearr_28767 = state_28747;
(statearr_28767[(13)] = inst_28715);

return statearr_28767;
})();
var statearr_28768_28789 = state_28747__$1;
(statearr_28768_28789[(2)] = inst_28716);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28747__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (8))){
var inst_28729 = (state_28747[(2)]);
var state_28747__$1 = state_28747;
var statearr_28769_28790 = state_28747__$1;
(statearr_28769_28790[(2)] = inst_28729);

(statearr_28769_28790[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___28775,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__25405__auto__,c__25572__auto___28775,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_28770 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28770[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_28770[(1)] = (1));

return statearr_28770;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_28747){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_28747);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e28771){if((e28771 instanceof Object)){
var ex__25409__auto__ = e28771;
var statearr_28772_28791 = state_28747;
(statearr_28772_28791[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28747);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28771;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28792 = state_28747;
state_28747 = G__28792;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_28747){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_28747);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___28775,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__25574__auto__ = (function (){var statearr_28773 = f__25573__auto__.call(null);
(statearr_28773[(6)] = c__25572__auto___28775);

return statearr_28773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___28775,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__28795 = arguments.length;
switch (G__28795) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25572__auto___28849 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___28849,out){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___28849,out){
return (function (state_28827){
var state_val_28828 = (state_28827[(1)]);
if((state_val_28828 === (7))){
var inst_28807 = (state_28827[(7)]);
var inst_28806 = (state_28827[(8)]);
var inst_28806__$1 = (state_28827[(2)]);
var inst_28807__$1 = cljs.core.nth.call(null,inst_28806__$1,(0),null);
var inst_28808 = cljs.core.nth.call(null,inst_28806__$1,(1),null);
var inst_28809 = (inst_28807__$1 == null);
var state_28827__$1 = (function (){var statearr_28829 = state_28827;
(statearr_28829[(7)] = inst_28807__$1);

(statearr_28829[(9)] = inst_28808);

(statearr_28829[(8)] = inst_28806__$1);

return statearr_28829;
})();
if(cljs.core.truth_(inst_28809)){
var statearr_28830_28850 = state_28827__$1;
(statearr_28830_28850[(1)] = (8));

} else {
var statearr_28831_28851 = state_28827__$1;
(statearr_28831_28851[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28828 === (1))){
var inst_28796 = cljs.core.vec.call(null,chs);
var inst_28797 = inst_28796;
var state_28827__$1 = (function (){var statearr_28832 = state_28827;
(statearr_28832[(10)] = inst_28797);

return statearr_28832;
})();
var statearr_28833_28852 = state_28827__$1;
(statearr_28833_28852[(2)] = null);

(statearr_28833_28852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28828 === (4))){
var inst_28797 = (state_28827[(10)]);
var state_28827__$1 = state_28827;
return cljs.core.async.ioc_alts_BANG_.call(null,state_28827__$1,(7),inst_28797);
} else {
if((state_val_28828 === (6))){
var inst_28823 = (state_28827[(2)]);
var state_28827__$1 = state_28827;
var statearr_28834_28853 = state_28827__$1;
(statearr_28834_28853[(2)] = inst_28823);

(statearr_28834_28853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28828 === (3))){
var inst_28825 = (state_28827[(2)]);
var state_28827__$1 = state_28827;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28827__$1,inst_28825);
} else {
if((state_val_28828 === (2))){
var inst_28797 = (state_28827[(10)]);
var inst_28799 = cljs.core.count.call(null,inst_28797);
var inst_28800 = (inst_28799 > (0));
var state_28827__$1 = state_28827;
if(cljs.core.truth_(inst_28800)){
var statearr_28836_28854 = state_28827__$1;
(statearr_28836_28854[(1)] = (4));

} else {
var statearr_28837_28855 = state_28827__$1;
(statearr_28837_28855[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28828 === (11))){
var inst_28797 = (state_28827[(10)]);
var inst_28816 = (state_28827[(2)]);
var tmp28835 = inst_28797;
var inst_28797__$1 = tmp28835;
var state_28827__$1 = (function (){var statearr_28838 = state_28827;
(statearr_28838[(11)] = inst_28816);

(statearr_28838[(10)] = inst_28797__$1);

return statearr_28838;
})();
var statearr_28839_28856 = state_28827__$1;
(statearr_28839_28856[(2)] = null);

(statearr_28839_28856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28828 === (9))){
var inst_28807 = (state_28827[(7)]);
var state_28827__$1 = state_28827;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28827__$1,(11),out,inst_28807);
} else {
if((state_val_28828 === (5))){
var inst_28821 = cljs.core.async.close_BANG_.call(null,out);
var state_28827__$1 = state_28827;
var statearr_28840_28857 = state_28827__$1;
(statearr_28840_28857[(2)] = inst_28821);

(statearr_28840_28857[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28828 === (10))){
var inst_28819 = (state_28827[(2)]);
var state_28827__$1 = state_28827;
var statearr_28841_28858 = state_28827__$1;
(statearr_28841_28858[(2)] = inst_28819);

(statearr_28841_28858[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28828 === (8))){
var inst_28797 = (state_28827[(10)]);
var inst_28807 = (state_28827[(7)]);
var inst_28808 = (state_28827[(9)]);
var inst_28806 = (state_28827[(8)]);
var inst_28811 = (function (){var cs = inst_28797;
var vec__28802 = inst_28806;
var v = inst_28807;
var c = inst_28808;
return ((function (cs,vec__28802,v,c,inst_28797,inst_28807,inst_28808,inst_28806,state_val_28828,c__25572__auto___28849,out){
return (function (p1__28793_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__28793_SHARP_);
});
;})(cs,vec__28802,v,c,inst_28797,inst_28807,inst_28808,inst_28806,state_val_28828,c__25572__auto___28849,out))
})();
var inst_28812 = cljs.core.filterv.call(null,inst_28811,inst_28797);
var inst_28797__$1 = inst_28812;
var state_28827__$1 = (function (){var statearr_28842 = state_28827;
(statearr_28842[(10)] = inst_28797__$1);

return statearr_28842;
})();
var statearr_28843_28859 = state_28827__$1;
(statearr_28843_28859[(2)] = null);

(statearr_28843_28859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___28849,out))
;
return ((function (switch__25405__auto__,c__25572__auto___28849,out){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_28844 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28844[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_28844[(1)] = (1));

return statearr_28844;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_28827){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_28827);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e28845){if((e28845 instanceof Object)){
var ex__25409__auto__ = e28845;
var statearr_28846_28860 = state_28827;
(statearr_28846_28860[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28827);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28845;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28861 = state_28827;
state_28827 = G__28861;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_28827){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_28827);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___28849,out))
})();
var state__25574__auto__ = (function (){var statearr_28847 = f__25573__auto__.call(null);
(statearr_28847[(6)] = c__25572__auto___28849);

return statearr_28847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___28849,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__28863 = arguments.length;
switch (G__28863) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25572__auto___28908 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___28908,out){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___28908,out){
return (function (state_28887){
var state_val_28888 = (state_28887[(1)]);
if((state_val_28888 === (7))){
var inst_28869 = (state_28887[(7)]);
var inst_28869__$1 = (state_28887[(2)]);
var inst_28870 = (inst_28869__$1 == null);
var inst_28871 = cljs.core.not.call(null,inst_28870);
var state_28887__$1 = (function (){var statearr_28889 = state_28887;
(statearr_28889[(7)] = inst_28869__$1);

return statearr_28889;
})();
if(inst_28871){
var statearr_28890_28909 = state_28887__$1;
(statearr_28890_28909[(1)] = (8));

} else {
var statearr_28891_28910 = state_28887__$1;
(statearr_28891_28910[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28888 === (1))){
var inst_28864 = (0);
var state_28887__$1 = (function (){var statearr_28892 = state_28887;
(statearr_28892[(8)] = inst_28864);

return statearr_28892;
})();
var statearr_28893_28911 = state_28887__$1;
(statearr_28893_28911[(2)] = null);

(statearr_28893_28911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28888 === (4))){
var state_28887__$1 = state_28887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28887__$1,(7),ch);
} else {
if((state_val_28888 === (6))){
var inst_28882 = (state_28887[(2)]);
var state_28887__$1 = state_28887;
var statearr_28894_28912 = state_28887__$1;
(statearr_28894_28912[(2)] = inst_28882);

(statearr_28894_28912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28888 === (3))){
var inst_28884 = (state_28887[(2)]);
var inst_28885 = cljs.core.async.close_BANG_.call(null,out);
var state_28887__$1 = (function (){var statearr_28895 = state_28887;
(statearr_28895[(9)] = inst_28884);

return statearr_28895;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28887__$1,inst_28885);
} else {
if((state_val_28888 === (2))){
var inst_28864 = (state_28887[(8)]);
var inst_28866 = (inst_28864 < n);
var state_28887__$1 = state_28887;
if(cljs.core.truth_(inst_28866)){
var statearr_28896_28913 = state_28887__$1;
(statearr_28896_28913[(1)] = (4));

} else {
var statearr_28897_28914 = state_28887__$1;
(statearr_28897_28914[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28888 === (11))){
var inst_28864 = (state_28887[(8)]);
var inst_28874 = (state_28887[(2)]);
var inst_28875 = (inst_28864 + (1));
var inst_28864__$1 = inst_28875;
var state_28887__$1 = (function (){var statearr_28898 = state_28887;
(statearr_28898[(8)] = inst_28864__$1);

(statearr_28898[(10)] = inst_28874);

return statearr_28898;
})();
var statearr_28899_28915 = state_28887__$1;
(statearr_28899_28915[(2)] = null);

(statearr_28899_28915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28888 === (9))){
var state_28887__$1 = state_28887;
var statearr_28900_28916 = state_28887__$1;
(statearr_28900_28916[(2)] = null);

(statearr_28900_28916[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28888 === (5))){
var state_28887__$1 = state_28887;
var statearr_28901_28917 = state_28887__$1;
(statearr_28901_28917[(2)] = null);

(statearr_28901_28917[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28888 === (10))){
var inst_28879 = (state_28887[(2)]);
var state_28887__$1 = state_28887;
var statearr_28902_28918 = state_28887__$1;
(statearr_28902_28918[(2)] = inst_28879);

(statearr_28902_28918[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28888 === (8))){
var inst_28869 = (state_28887[(7)]);
var state_28887__$1 = state_28887;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28887__$1,(11),out,inst_28869);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___28908,out))
;
return ((function (switch__25405__auto__,c__25572__auto___28908,out){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_28903 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28903[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_28903[(1)] = (1));

return statearr_28903;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_28887){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_28887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e28904){if((e28904 instanceof Object)){
var ex__25409__auto__ = e28904;
var statearr_28905_28919 = state_28887;
(statearr_28905_28919[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28887);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28904;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28920 = state_28887;
state_28887 = G__28920;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_28887){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_28887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___28908,out))
})();
var state__25574__auto__ = (function (){var statearr_28906 = f__25573__auto__.call(null);
(statearr_28906[(6)] = c__25572__auto___28908);

return statearr_28906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___28908,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28922 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28922 = (function (f,ch,meta28923){
this.f = f;
this.ch = ch;
this.meta28923 = meta28923;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28922.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28924,meta28923__$1){
var self__ = this;
var _28924__$1 = this;
return (new cljs.core.async.t_cljs$core$async28922(self__.f,self__.ch,meta28923__$1));
});

cljs.core.async.t_cljs$core$async28922.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28924){
var self__ = this;
var _28924__$1 = this;
return self__.meta28923;
});

cljs.core.async.t_cljs$core$async28922.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28922.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28922.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28922.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28922.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28925 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28925 = (function (f,ch,meta28923,_,fn1,meta28926){
this.f = f;
this.ch = ch;
this.meta28923 = meta28923;
this._ = _;
this.fn1 = fn1;
this.meta28926 = meta28926;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28925.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_28927,meta28926__$1){
var self__ = this;
var _28927__$1 = this;
return (new cljs.core.async.t_cljs$core$async28925(self__.f,self__.ch,self__.meta28923,self__._,self__.fn1,meta28926__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async28925.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_28927){
var self__ = this;
var _28927__$1 = this;
return self__.meta28926;
});})(___$1))
;

cljs.core.async.t_cljs$core$async28925.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28925.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async28925.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async28925.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__28921_SHARP_){
return f1.call(null,(((p1__28921_SHARP_ == null))?null:self__.f.call(null,p1__28921_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async28925.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28923","meta28923",-519051101,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async28922","cljs.core.async/t_cljs$core$async28922",-1761662464,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta28926","meta28926",1116589491,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async28925.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28925.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28925";

cljs.core.async.t_cljs$core$async28925.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28925");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28925.
 */
cljs.core.async.__GT_t_cljs$core$async28925 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async28925(f__$1,ch__$1,meta28923__$1,___$2,fn1__$1,meta28926){
return (new cljs.core.async.t_cljs$core$async28925(f__$1,ch__$1,meta28923__$1,___$2,fn1__$1,meta28926));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async28925(self__.f,self__.ch,self__.meta28923,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async28922.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28922.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async28922.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28923","meta28923",-519051101,null)], null);
});

cljs.core.async.t_cljs$core$async28922.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28922.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28922";

cljs.core.async.t_cljs$core$async28922.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28922");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28922.
 */
cljs.core.async.__GT_t_cljs$core$async28922 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async28922(f__$1,ch__$1,meta28923){
return (new cljs.core.async.t_cljs$core$async28922(f__$1,ch__$1,meta28923));
});

}

return (new cljs.core.async.t_cljs$core$async28922(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28928 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28928 = (function (f,ch,meta28929){
this.f = f;
this.ch = ch;
this.meta28929 = meta28929;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28928.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28930,meta28929__$1){
var self__ = this;
var _28930__$1 = this;
return (new cljs.core.async.t_cljs$core$async28928(self__.f,self__.ch,meta28929__$1));
});

cljs.core.async.t_cljs$core$async28928.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28930){
var self__ = this;
var _28930__$1 = this;
return self__.meta28929;
});

cljs.core.async.t_cljs$core$async28928.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28928.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28928.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28928.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async28928.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28928.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async28928.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28929","meta28929",1784706012,null)], null);
});

cljs.core.async.t_cljs$core$async28928.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28928.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28928";

cljs.core.async.t_cljs$core$async28928.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28928");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28928.
 */
cljs.core.async.__GT_t_cljs$core$async28928 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async28928(f__$1,ch__$1,meta28929){
return (new cljs.core.async.t_cljs$core$async28928(f__$1,ch__$1,meta28929));
});

}

return (new cljs.core.async.t_cljs$core$async28928(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28931 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28931 = (function (p,ch,meta28932){
this.p = p;
this.ch = ch;
this.meta28932 = meta28932;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28931.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28933,meta28932__$1){
var self__ = this;
var _28933__$1 = this;
return (new cljs.core.async.t_cljs$core$async28931(self__.p,self__.ch,meta28932__$1));
});

cljs.core.async.t_cljs$core$async28931.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28933){
var self__ = this;
var _28933__$1 = this;
return self__.meta28932;
});

cljs.core.async.t_cljs$core$async28931.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28931.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28931.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28931.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28931.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async28931.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28931.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async28931.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28932","meta28932",1900229303,null)], null);
});

cljs.core.async.t_cljs$core$async28931.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28931.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28931";

cljs.core.async.t_cljs$core$async28931.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28931");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28931.
 */
cljs.core.async.__GT_t_cljs$core$async28931 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async28931(p__$1,ch__$1,meta28932){
return (new cljs.core.async.t_cljs$core$async28931(p__$1,ch__$1,meta28932));
});

}

return (new cljs.core.async.t_cljs$core$async28931(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__28935 = arguments.length;
switch (G__28935) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25572__auto___28975 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___28975,out){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___28975,out){
return (function (state_28956){
var state_val_28957 = (state_28956[(1)]);
if((state_val_28957 === (7))){
var inst_28952 = (state_28956[(2)]);
var state_28956__$1 = state_28956;
var statearr_28958_28976 = state_28956__$1;
(statearr_28958_28976[(2)] = inst_28952);

(statearr_28958_28976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (1))){
var state_28956__$1 = state_28956;
var statearr_28959_28977 = state_28956__$1;
(statearr_28959_28977[(2)] = null);

(statearr_28959_28977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (4))){
var inst_28938 = (state_28956[(7)]);
var inst_28938__$1 = (state_28956[(2)]);
var inst_28939 = (inst_28938__$1 == null);
var state_28956__$1 = (function (){var statearr_28960 = state_28956;
(statearr_28960[(7)] = inst_28938__$1);

return statearr_28960;
})();
if(cljs.core.truth_(inst_28939)){
var statearr_28961_28978 = state_28956__$1;
(statearr_28961_28978[(1)] = (5));

} else {
var statearr_28962_28979 = state_28956__$1;
(statearr_28962_28979[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (6))){
var inst_28938 = (state_28956[(7)]);
var inst_28943 = p.call(null,inst_28938);
var state_28956__$1 = state_28956;
if(cljs.core.truth_(inst_28943)){
var statearr_28963_28980 = state_28956__$1;
(statearr_28963_28980[(1)] = (8));

} else {
var statearr_28964_28981 = state_28956__$1;
(statearr_28964_28981[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (3))){
var inst_28954 = (state_28956[(2)]);
var state_28956__$1 = state_28956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28956__$1,inst_28954);
} else {
if((state_val_28957 === (2))){
var state_28956__$1 = state_28956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28956__$1,(4),ch);
} else {
if((state_val_28957 === (11))){
var inst_28946 = (state_28956[(2)]);
var state_28956__$1 = state_28956;
var statearr_28965_28982 = state_28956__$1;
(statearr_28965_28982[(2)] = inst_28946);

(statearr_28965_28982[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (9))){
var state_28956__$1 = state_28956;
var statearr_28966_28983 = state_28956__$1;
(statearr_28966_28983[(2)] = null);

(statearr_28966_28983[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (5))){
var inst_28941 = cljs.core.async.close_BANG_.call(null,out);
var state_28956__$1 = state_28956;
var statearr_28967_28984 = state_28956__$1;
(statearr_28967_28984[(2)] = inst_28941);

(statearr_28967_28984[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (10))){
var inst_28949 = (state_28956[(2)]);
var state_28956__$1 = (function (){var statearr_28968 = state_28956;
(statearr_28968[(8)] = inst_28949);

return statearr_28968;
})();
var statearr_28969_28985 = state_28956__$1;
(statearr_28969_28985[(2)] = null);

(statearr_28969_28985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (8))){
var inst_28938 = (state_28956[(7)]);
var state_28956__$1 = state_28956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28956__$1,(11),out,inst_28938);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___28975,out))
;
return ((function (switch__25405__auto__,c__25572__auto___28975,out){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_28970 = [null,null,null,null,null,null,null,null,null];
(statearr_28970[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_28970[(1)] = (1));

return statearr_28970;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_28956){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_28956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e28971){if((e28971 instanceof Object)){
var ex__25409__auto__ = e28971;
var statearr_28972_28986 = state_28956;
(statearr_28972_28986[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28971;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28987 = state_28956;
state_28956 = G__28987;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_28956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_28956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___28975,out))
})();
var state__25574__auto__ = (function (){var statearr_28973 = f__25573__auto__.call(null);
(statearr_28973[(6)] = c__25572__auto___28975);

return statearr_28973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___28975,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__28989 = arguments.length;
switch (G__28989) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__25572__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto__){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto__){
return (function (state_29052){
var state_val_29053 = (state_29052[(1)]);
if((state_val_29053 === (7))){
var inst_29048 = (state_29052[(2)]);
var state_29052__$1 = state_29052;
var statearr_29054_29092 = state_29052__$1;
(statearr_29054_29092[(2)] = inst_29048);

(statearr_29054_29092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (20))){
var inst_29018 = (state_29052[(7)]);
var inst_29029 = (state_29052[(2)]);
var inst_29030 = cljs.core.next.call(null,inst_29018);
var inst_29004 = inst_29030;
var inst_29005 = null;
var inst_29006 = (0);
var inst_29007 = (0);
var state_29052__$1 = (function (){var statearr_29055 = state_29052;
(statearr_29055[(8)] = inst_29029);

(statearr_29055[(9)] = inst_29007);

(statearr_29055[(10)] = inst_29005);

(statearr_29055[(11)] = inst_29004);

(statearr_29055[(12)] = inst_29006);

return statearr_29055;
})();
var statearr_29056_29093 = state_29052__$1;
(statearr_29056_29093[(2)] = null);

(statearr_29056_29093[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (1))){
var state_29052__$1 = state_29052;
var statearr_29057_29094 = state_29052__$1;
(statearr_29057_29094[(2)] = null);

(statearr_29057_29094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (4))){
var inst_28993 = (state_29052[(13)]);
var inst_28993__$1 = (state_29052[(2)]);
var inst_28994 = (inst_28993__$1 == null);
var state_29052__$1 = (function (){var statearr_29058 = state_29052;
(statearr_29058[(13)] = inst_28993__$1);

return statearr_29058;
})();
if(cljs.core.truth_(inst_28994)){
var statearr_29059_29095 = state_29052__$1;
(statearr_29059_29095[(1)] = (5));

} else {
var statearr_29060_29096 = state_29052__$1;
(statearr_29060_29096[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (15))){
var state_29052__$1 = state_29052;
var statearr_29064_29097 = state_29052__$1;
(statearr_29064_29097[(2)] = null);

(statearr_29064_29097[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (21))){
var state_29052__$1 = state_29052;
var statearr_29065_29098 = state_29052__$1;
(statearr_29065_29098[(2)] = null);

(statearr_29065_29098[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (13))){
var inst_29007 = (state_29052[(9)]);
var inst_29005 = (state_29052[(10)]);
var inst_29004 = (state_29052[(11)]);
var inst_29006 = (state_29052[(12)]);
var inst_29014 = (state_29052[(2)]);
var inst_29015 = (inst_29007 + (1));
var tmp29061 = inst_29005;
var tmp29062 = inst_29004;
var tmp29063 = inst_29006;
var inst_29004__$1 = tmp29062;
var inst_29005__$1 = tmp29061;
var inst_29006__$1 = tmp29063;
var inst_29007__$1 = inst_29015;
var state_29052__$1 = (function (){var statearr_29066 = state_29052;
(statearr_29066[(14)] = inst_29014);

(statearr_29066[(9)] = inst_29007__$1);

(statearr_29066[(10)] = inst_29005__$1);

(statearr_29066[(11)] = inst_29004__$1);

(statearr_29066[(12)] = inst_29006__$1);

return statearr_29066;
})();
var statearr_29067_29099 = state_29052__$1;
(statearr_29067_29099[(2)] = null);

(statearr_29067_29099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (22))){
var state_29052__$1 = state_29052;
var statearr_29068_29100 = state_29052__$1;
(statearr_29068_29100[(2)] = null);

(statearr_29068_29100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (6))){
var inst_28993 = (state_29052[(13)]);
var inst_29002 = f.call(null,inst_28993);
var inst_29003 = cljs.core.seq.call(null,inst_29002);
var inst_29004 = inst_29003;
var inst_29005 = null;
var inst_29006 = (0);
var inst_29007 = (0);
var state_29052__$1 = (function (){var statearr_29069 = state_29052;
(statearr_29069[(9)] = inst_29007);

(statearr_29069[(10)] = inst_29005);

(statearr_29069[(11)] = inst_29004);

(statearr_29069[(12)] = inst_29006);

return statearr_29069;
})();
var statearr_29070_29101 = state_29052__$1;
(statearr_29070_29101[(2)] = null);

(statearr_29070_29101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (17))){
var inst_29018 = (state_29052[(7)]);
var inst_29022 = cljs.core.chunk_first.call(null,inst_29018);
var inst_29023 = cljs.core.chunk_rest.call(null,inst_29018);
var inst_29024 = cljs.core.count.call(null,inst_29022);
var inst_29004 = inst_29023;
var inst_29005 = inst_29022;
var inst_29006 = inst_29024;
var inst_29007 = (0);
var state_29052__$1 = (function (){var statearr_29071 = state_29052;
(statearr_29071[(9)] = inst_29007);

(statearr_29071[(10)] = inst_29005);

(statearr_29071[(11)] = inst_29004);

(statearr_29071[(12)] = inst_29006);

return statearr_29071;
})();
var statearr_29072_29102 = state_29052__$1;
(statearr_29072_29102[(2)] = null);

(statearr_29072_29102[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (3))){
var inst_29050 = (state_29052[(2)]);
var state_29052__$1 = state_29052;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29052__$1,inst_29050);
} else {
if((state_val_29053 === (12))){
var inst_29038 = (state_29052[(2)]);
var state_29052__$1 = state_29052;
var statearr_29073_29103 = state_29052__$1;
(statearr_29073_29103[(2)] = inst_29038);

(statearr_29073_29103[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (2))){
var state_29052__$1 = state_29052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29052__$1,(4),in$);
} else {
if((state_val_29053 === (23))){
var inst_29046 = (state_29052[(2)]);
var state_29052__$1 = state_29052;
var statearr_29074_29104 = state_29052__$1;
(statearr_29074_29104[(2)] = inst_29046);

(statearr_29074_29104[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (19))){
var inst_29033 = (state_29052[(2)]);
var state_29052__$1 = state_29052;
var statearr_29075_29105 = state_29052__$1;
(statearr_29075_29105[(2)] = inst_29033);

(statearr_29075_29105[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (11))){
var inst_29018 = (state_29052[(7)]);
var inst_29004 = (state_29052[(11)]);
var inst_29018__$1 = cljs.core.seq.call(null,inst_29004);
var state_29052__$1 = (function (){var statearr_29076 = state_29052;
(statearr_29076[(7)] = inst_29018__$1);

return statearr_29076;
})();
if(inst_29018__$1){
var statearr_29077_29106 = state_29052__$1;
(statearr_29077_29106[(1)] = (14));

} else {
var statearr_29078_29107 = state_29052__$1;
(statearr_29078_29107[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (9))){
var inst_29040 = (state_29052[(2)]);
var inst_29041 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_29052__$1 = (function (){var statearr_29079 = state_29052;
(statearr_29079[(15)] = inst_29040);

return statearr_29079;
})();
if(cljs.core.truth_(inst_29041)){
var statearr_29080_29108 = state_29052__$1;
(statearr_29080_29108[(1)] = (21));

} else {
var statearr_29081_29109 = state_29052__$1;
(statearr_29081_29109[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (5))){
var inst_28996 = cljs.core.async.close_BANG_.call(null,out);
var state_29052__$1 = state_29052;
var statearr_29082_29110 = state_29052__$1;
(statearr_29082_29110[(2)] = inst_28996);

(statearr_29082_29110[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (14))){
var inst_29018 = (state_29052[(7)]);
var inst_29020 = cljs.core.chunked_seq_QMARK_.call(null,inst_29018);
var state_29052__$1 = state_29052;
if(inst_29020){
var statearr_29083_29111 = state_29052__$1;
(statearr_29083_29111[(1)] = (17));

} else {
var statearr_29084_29112 = state_29052__$1;
(statearr_29084_29112[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (16))){
var inst_29036 = (state_29052[(2)]);
var state_29052__$1 = state_29052;
var statearr_29085_29113 = state_29052__$1;
(statearr_29085_29113[(2)] = inst_29036);

(statearr_29085_29113[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29053 === (10))){
var inst_29007 = (state_29052[(9)]);
var inst_29005 = (state_29052[(10)]);
var inst_29012 = cljs.core._nth.call(null,inst_29005,inst_29007);
var state_29052__$1 = state_29052;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29052__$1,(13),out,inst_29012);
} else {
if((state_val_29053 === (18))){
var inst_29018 = (state_29052[(7)]);
var inst_29027 = cljs.core.first.call(null,inst_29018);
var state_29052__$1 = state_29052;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29052__$1,(20),out,inst_29027);
} else {
if((state_val_29053 === (8))){
var inst_29007 = (state_29052[(9)]);
var inst_29006 = (state_29052[(12)]);
var inst_29009 = (inst_29007 < inst_29006);
var inst_29010 = inst_29009;
var state_29052__$1 = state_29052;
if(cljs.core.truth_(inst_29010)){
var statearr_29086_29114 = state_29052__$1;
(statearr_29086_29114[(1)] = (10));

} else {
var statearr_29087_29115 = state_29052__$1;
(statearr_29087_29115[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto__))
;
return ((function (switch__25405__auto__,c__25572__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__25406__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__25406__auto____0 = (function (){
var statearr_29088 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29088[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__25406__auto__);

(statearr_29088[(1)] = (1));

return statearr_29088;
});
var cljs$core$async$mapcat_STAR__$_state_machine__25406__auto____1 = (function (state_29052){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_29052);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e29089){if((e29089 instanceof Object)){
var ex__25409__auto__ = e29089;
var statearr_29090_29116 = state_29052;
(statearr_29090_29116[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29052);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29089;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29117 = state_29052;
state_29052 = G__29117;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__25406__auto__ = function(state_29052){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__25406__auto____1.call(this,state_29052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__25406__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__25406__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto__))
})();
var state__25574__auto__ = (function (){var statearr_29091 = f__25573__auto__.call(null);
(statearr_29091[(6)] = c__25572__auto__);

return statearr_29091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto__))
);

return c__25572__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__29119 = arguments.length;
switch (G__29119) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__29122 = arguments.length;
switch (G__29122) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__29125 = arguments.length;
switch (G__29125) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25572__auto___29172 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___29172,out){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___29172,out){
return (function (state_29149){
var state_val_29150 = (state_29149[(1)]);
if((state_val_29150 === (7))){
var inst_29144 = (state_29149[(2)]);
var state_29149__$1 = state_29149;
var statearr_29151_29173 = state_29149__$1;
(statearr_29151_29173[(2)] = inst_29144);

(statearr_29151_29173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29150 === (1))){
var inst_29126 = null;
var state_29149__$1 = (function (){var statearr_29152 = state_29149;
(statearr_29152[(7)] = inst_29126);

return statearr_29152;
})();
var statearr_29153_29174 = state_29149__$1;
(statearr_29153_29174[(2)] = null);

(statearr_29153_29174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29150 === (4))){
var inst_29129 = (state_29149[(8)]);
var inst_29129__$1 = (state_29149[(2)]);
var inst_29130 = (inst_29129__$1 == null);
var inst_29131 = cljs.core.not.call(null,inst_29130);
var state_29149__$1 = (function (){var statearr_29154 = state_29149;
(statearr_29154[(8)] = inst_29129__$1);

return statearr_29154;
})();
if(inst_29131){
var statearr_29155_29175 = state_29149__$1;
(statearr_29155_29175[(1)] = (5));

} else {
var statearr_29156_29176 = state_29149__$1;
(statearr_29156_29176[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29150 === (6))){
var state_29149__$1 = state_29149;
var statearr_29157_29177 = state_29149__$1;
(statearr_29157_29177[(2)] = null);

(statearr_29157_29177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29150 === (3))){
var inst_29146 = (state_29149[(2)]);
var inst_29147 = cljs.core.async.close_BANG_.call(null,out);
var state_29149__$1 = (function (){var statearr_29158 = state_29149;
(statearr_29158[(9)] = inst_29146);

return statearr_29158;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29149__$1,inst_29147);
} else {
if((state_val_29150 === (2))){
var state_29149__$1 = state_29149;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29149__$1,(4),ch);
} else {
if((state_val_29150 === (11))){
var inst_29129 = (state_29149[(8)]);
var inst_29138 = (state_29149[(2)]);
var inst_29126 = inst_29129;
var state_29149__$1 = (function (){var statearr_29159 = state_29149;
(statearr_29159[(10)] = inst_29138);

(statearr_29159[(7)] = inst_29126);

return statearr_29159;
})();
var statearr_29160_29178 = state_29149__$1;
(statearr_29160_29178[(2)] = null);

(statearr_29160_29178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29150 === (9))){
var inst_29129 = (state_29149[(8)]);
var state_29149__$1 = state_29149;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29149__$1,(11),out,inst_29129);
} else {
if((state_val_29150 === (5))){
var inst_29126 = (state_29149[(7)]);
var inst_29129 = (state_29149[(8)]);
var inst_29133 = cljs.core._EQ_.call(null,inst_29129,inst_29126);
var state_29149__$1 = state_29149;
if(inst_29133){
var statearr_29162_29179 = state_29149__$1;
(statearr_29162_29179[(1)] = (8));

} else {
var statearr_29163_29180 = state_29149__$1;
(statearr_29163_29180[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29150 === (10))){
var inst_29141 = (state_29149[(2)]);
var state_29149__$1 = state_29149;
var statearr_29164_29181 = state_29149__$1;
(statearr_29164_29181[(2)] = inst_29141);

(statearr_29164_29181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29150 === (8))){
var inst_29126 = (state_29149[(7)]);
var tmp29161 = inst_29126;
var inst_29126__$1 = tmp29161;
var state_29149__$1 = (function (){var statearr_29165 = state_29149;
(statearr_29165[(7)] = inst_29126__$1);

return statearr_29165;
})();
var statearr_29166_29182 = state_29149__$1;
(statearr_29166_29182[(2)] = null);

(statearr_29166_29182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___29172,out))
;
return ((function (switch__25405__auto__,c__25572__auto___29172,out){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_29167 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29167[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_29167[(1)] = (1));

return statearr_29167;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_29149){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_29149);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e29168){if((e29168 instanceof Object)){
var ex__25409__auto__ = e29168;
var statearr_29169_29183 = state_29149;
(statearr_29169_29183[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29149);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29168;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29184 = state_29149;
state_29149 = G__29184;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_29149){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_29149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___29172,out))
})();
var state__25574__auto__ = (function (){var statearr_29170 = f__25573__auto__.call(null);
(statearr_29170[(6)] = c__25572__auto___29172);

return statearr_29170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___29172,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__29186 = arguments.length;
switch (G__29186) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25572__auto___29252 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___29252,out){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___29252,out){
return (function (state_29224){
var state_val_29225 = (state_29224[(1)]);
if((state_val_29225 === (7))){
var inst_29220 = (state_29224[(2)]);
var state_29224__$1 = state_29224;
var statearr_29226_29253 = state_29224__$1;
(statearr_29226_29253[(2)] = inst_29220);

(statearr_29226_29253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29225 === (1))){
var inst_29187 = (new Array(n));
var inst_29188 = inst_29187;
var inst_29189 = (0);
var state_29224__$1 = (function (){var statearr_29227 = state_29224;
(statearr_29227[(7)] = inst_29188);

(statearr_29227[(8)] = inst_29189);

return statearr_29227;
})();
var statearr_29228_29254 = state_29224__$1;
(statearr_29228_29254[(2)] = null);

(statearr_29228_29254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29225 === (4))){
var inst_29192 = (state_29224[(9)]);
var inst_29192__$1 = (state_29224[(2)]);
var inst_29193 = (inst_29192__$1 == null);
var inst_29194 = cljs.core.not.call(null,inst_29193);
var state_29224__$1 = (function (){var statearr_29229 = state_29224;
(statearr_29229[(9)] = inst_29192__$1);

return statearr_29229;
})();
if(inst_29194){
var statearr_29230_29255 = state_29224__$1;
(statearr_29230_29255[(1)] = (5));

} else {
var statearr_29231_29256 = state_29224__$1;
(statearr_29231_29256[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29225 === (15))){
var inst_29214 = (state_29224[(2)]);
var state_29224__$1 = state_29224;
var statearr_29232_29257 = state_29224__$1;
(statearr_29232_29257[(2)] = inst_29214);

(statearr_29232_29257[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29225 === (13))){
var state_29224__$1 = state_29224;
var statearr_29233_29258 = state_29224__$1;
(statearr_29233_29258[(2)] = null);

(statearr_29233_29258[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29225 === (6))){
var inst_29189 = (state_29224[(8)]);
var inst_29210 = (inst_29189 > (0));
var state_29224__$1 = state_29224;
if(cljs.core.truth_(inst_29210)){
var statearr_29234_29259 = state_29224__$1;
(statearr_29234_29259[(1)] = (12));

} else {
var statearr_29235_29260 = state_29224__$1;
(statearr_29235_29260[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29225 === (3))){
var inst_29222 = (state_29224[(2)]);
var state_29224__$1 = state_29224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29224__$1,inst_29222);
} else {
if((state_val_29225 === (12))){
var inst_29188 = (state_29224[(7)]);
var inst_29212 = cljs.core.vec.call(null,inst_29188);
var state_29224__$1 = state_29224;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29224__$1,(15),out,inst_29212);
} else {
if((state_val_29225 === (2))){
var state_29224__$1 = state_29224;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29224__$1,(4),ch);
} else {
if((state_val_29225 === (11))){
var inst_29204 = (state_29224[(2)]);
var inst_29205 = (new Array(n));
var inst_29188 = inst_29205;
var inst_29189 = (0);
var state_29224__$1 = (function (){var statearr_29236 = state_29224;
(statearr_29236[(7)] = inst_29188);

(statearr_29236[(8)] = inst_29189);

(statearr_29236[(10)] = inst_29204);

return statearr_29236;
})();
var statearr_29237_29261 = state_29224__$1;
(statearr_29237_29261[(2)] = null);

(statearr_29237_29261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29225 === (9))){
var inst_29188 = (state_29224[(7)]);
var inst_29202 = cljs.core.vec.call(null,inst_29188);
var state_29224__$1 = state_29224;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29224__$1,(11),out,inst_29202);
} else {
if((state_val_29225 === (5))){
var inst_29188 = (state_29224[(7)]);
var inst_29189 = (state_29224[(8)]);
var inst_29192 = (state_29224[(9)]);
var inst_29197 = (state_29224[(11)]);
var inst_29196 = (inst_29188[inst_29189] = inst_29192);
var inst_29197__$1 = (inst_29189 + (1));
var inst_29198 = (inst_29197__$1 < n);
var state_29224__$1 = (function (){var statearr_29238 = state_29224;
(statearr_29238[(11)] = inst_29197__$1);

(statearr_29238[(12)] = inst_29196);

return statearr_29238;
})();
if(cljs.core.truth_(inst_29198)){
var statearr_29239_29262 = state_29224__$1;
(statearr_29239_29262[(1)] = (8));

} else {
var statearr_29240_29263 = state_29224__$1;
(statearr_29240_29263[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29225 === (14))){
var inst_29217 = (state_29224[(2)]);
var inst_29218 = cljs.core.async.close_BANG_.call(null,out);
var state_29224__$1 = (function (){var statearr_29242 = state_29224;
(statearr_29242[(13)] = inst_29217);

return statearr_29242;
})();
var statearr_29243_29264 = state_29224__$1;
(statearr_29243_29264[(2)] = inst_29218);

(statearr_29243_29264[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29225 === (10))){
var inst_29208 = (state_29224[(2)]);
var state_29224__$1 = state_29224;
var statearr_29244_29265 = state_29224__$1;
(statearr_29244_29265[(2)] = inst_29208);

(statearr_29244_29265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29225 === (8))){
var inst_29188 = (state_29224[(7)]);
var inst_29197 = (state_29224[(11)]);
var tmp29241 = inst_29188;
var inst_29188__$1 = tmp29241;
var inst_29189 = inst_29197;
var state_29224__$1 = (function (){var statearr_29245 = state_29224;
(statearr_29245[(7)] = inst_29188__$1);

(statearr_29245[(8)] = inst_29189);

return statearr_29245;
})();
var statearr_29246_29266 = state_29224__$1;
(statearr_29246_29266[(2)] = null);

(statearr_29246_29266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___29252,out))
;
return ((function (switch__25405__auto__,c__25572__auto___29252,out){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_29247 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29247[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_29247[(1)] = (1));

return statearr_29247;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_29224){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_29224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e29248){if((e29248 instanceof Object)){
var ex__25409__auto__ = e29248;
var statearr_29249_29267 = state_29224;
(statearr_29249_29267[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29224);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29248;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29268 = state_29224;
state_29224 = G__29268;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_29224){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_29224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___29252,out))
})();
var state__25574__auto__ = (function (){var statearr_29250 = f__25573__auto__.call(null);
(statearr_29250[(6)] = c__25572__auto___29252);

return statearr_29250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___29252,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__29270 = arguments.length;
switch (G__29270) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25572__auto___29340 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___29340,out){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___29340,out){
return (function (state_29312){
var state_val_29313 = (state_29312[(1)]);
if((state_val_29313 === (7))){
var inst_29308 = (state_29312[(2)]);
var state_29312__$1 = state_29312;
var statearr_29314_29341 = state_29312__$1;
(statearr_29314_29341[(2)] = inst_29308);

(statearr_29314_29341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29313 === (1))){
var inst_29271 = [];
var inst_29272 = inst_29271;
var inst_29273 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_29312__$1 = (function (){var statearr_29315 = state_29312;
(statearr_29315[(7)] = inst_29272);

(statearr_29315[(8)] = inst_29273);

return statearr_29315;
})();
var statearr_29316_29342 = state_29312__$1;
(statearr_29316_29342[(2)] = null);

(statearr_29316_29342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29313 === (4))){
var inst_29276 = (state_29312[(9)]);
var inst_29276__$1 = (state_29312[(2)]);
var inst_29277 = (inst_29276__$1 == null);
var inst_29278 = cljs.core.not.call(null,inst_29277);
var state_29312__$1 = (function (){var statearr_29317 = state_29312;
(statearr_29317[(9)] = inst_29276__$1);

return statearr_29317;
})();
if(inst_29278){
var statearr_29318_29343 = state_29312__$1;
(statearr_29318_29343[(1)] = (5));

} else {
var statearr_29319_29344 = state_29312__$1;
(statearr_29319_29344[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29313 === (15))){
var inst_29302 = (state_29312[(2)]);
var state_29312__$1 = state_29312;
var statearr_29320_29345 = state_29312__$1;
(statearr_29320_29345[(2)] = inst_29302);

(statearr_29320_29345[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29313 === (13))){
var state_29312__$1 = state_29312;
var statearr_29321_29346 = state_29312__$1;
(statearr_29321_29346[(2)] = null);

(statearr_29321_29346[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29313 === (6))){
var inst_29272 = (state_29312[(7)]);
var inst_29297 = inst_29272.length;
var inst_29298 = (inst_29297 > (0));
var state_29312__$1 = state_29312;
if(cljs.core.truth_(inst_29298)){
var statearr_29322_29347 = state_29312__$1;
(statearr_29322_29347[(1)] = (12));

} else {
var statearr_29323_29348 = state_29312__$1;
(statearr_29323_29348[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29313 === (3))){
var inst_29310 = (state_29312[(2)]);
var state_29312__$1 = state_29312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29312__$1,inst_29310);
} else {
if((state_val_29313 === (12))){
var inst_29272 = (state_29312[(7)]);
var inst_29300 = cljs.core.vec.call(null,inst_29272);
var state_29312__$1 = state_29312;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29312__$1,(15),out,inst_29300);
} else {
if((state_val_29313 === (2))){
var state_29312__$1 = state_29312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29312__$1,(4),ch);
} else {
if((state_val_29313 === (11))){
var inst_29280 = (state_29312[(10)]);
var inst_29276 = (state_29312[(9)]);
var inst_29290 = (state_29312[(2)]);
var inst_29291 = [];
var inst_29292 = inst_29291.push(inst_29276);
var inst_29272 = inst_29291;
var inst_29273 = inst_29280;
var state_29312__$1 = (function (){var statearr_29324 = state_29312;
(statearr_29324[(11)] = inst_29290);

(statearr_29324[(7)] = inst_29272);

(statearr_29324[(12)] = inst_29292);

(statearr_29324[(8)] = inst_29273);

return statearr_29324;
})();
var statearr_29325_29349 = state_29312__$1;
(statearr_29325_29349[(2)] = null);

(statearr_29325_29349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29313 === (9))){
var inst_29272 = (state_29312[(7)]);
var inst_29288 = cljs.core.vec.call(null,inst_29272);
var state_29312__$1 = state_29312;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29312__$1,(11),out,inst_29288);
} else {
if((state_val_29313 === (5))){
var inst_29280 = (state_29312[(10)]);
var inst_29276 = (state_29312[(9)]);
var inst_29273 = (state_29312[(8)]);
var inst_29280__$1 = f.call(null,inst_29276);
var inst_29281 = cljs.core._EQ_.call(null,inst_29280__$1,inst_29273);
var inst_29282 = cljs.core.keyword_identical_QMARK_.call(null,inst_29273,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_29283 = ((inst_29281) || (inst_29282));
var state_29312__$1 = (function (){var statearr_29326 = state_29312;
(statearr_29326[(10)] = inst_29280__$1);

return statearr_29326;
})();
if(cljs.core.truth_(inst_29283)){
var statearr_29327_29350 = state_29312__$1;
(statearr_29327_29350[(1)] = (8));

} else {
var statearr_29328_29351 = state_29312__$1;
(statearr_29328_29351[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29313 === (14))){
var inst_29305 = (state_29312[(2)]);
var inst_29306 = cljs.core.async.close_BANG_.call(null,out);
var state_29312__$1 = (function (){var statearr_29330 = state_29312;
(statearr_29330[(13)] = inst_29305);

return statearr_29330;
})();
var statearr_29331_29352 = state_29312__$1;
(statearr_29331_29352[(2)] = inst_29306);

(statearr_29331_29352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29313 === (10))){
var inst_29295 = (state_29312[(2)]);
var state_29312__$1 = state_29312;
var statearr_29332_29353 = state_29312__$1;
(statearr_29332_29353[(2)] = inst_29295);

(statearr_29332_29353[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29313 === (8))){
var inst_29280 = (state_29312[(10)]);
var inst_29272 = (state_29312[(7)]);
var inst_29276 = (state_29312[(9)]);
var inst_29285 = inst_29272.push(inst_29276);
var tmp29329 = inst_29272;
var inst_29272__$1 = tmp29329;
var inst_29273 = inst_29280;
var state_29312__$1 = (function (){var statearr_29333 = state_29312;
(statearr_29333[(7)] = inst_29272__$1);

(statearr_29333[(14)] = inst_29285);

(statearr_29333[(8)] = inst_29273);

return statearr_29333;
})();
var statearr_29334_29354 = state_29312__$1;
(statearr_29334_29354[(2)] = null);

(statearr_29334_29354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___29340,out))
;
return ((function (switch__25405__auto__,c__25572__auto___29340,out){
return (function() {
var cljs$core$async$state_machine__25406__auto__ = null;
var cljs$core$async$state_machine__25406__auto____0 = (function (){
var statearr_29335 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29335[(0)] = cljs$core$async$state_machine__25406__auto__);

(statearr_29335[(1)] = (1));

return statearr_29335;
});
var cljs$core$async$state_machine__25406__auto____1 = (function (state_29312){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_29312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e29336){if((e29336 instanceof Object)){
var ex__25409__auto__ = e29336;
var statearr_29337_29355 = state_29312;
(statearr_29337_29355[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29336;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29356 = state_29312;
state_29312 = G__29356;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
cljs$core$async$state_machine__25406__auto__ = function(state_29312){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25406__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25406__auto____1.call(this,state_29312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25406__auto____0;
cljs$core$async$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25406__auto____1;
return cljs$core$async$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___29340,out))
})();
var state__25574__auto__ = (function (){var statearr_29338 = f__25573__auto__.call(null);
(statearr_29338[(6)] = c__25572__auto___29340);

return statearr_29338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___29340,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1552158900146
