// Compiled by ClojureScript 1.10.520 {}
goog.provide('threeagent.impl.scene');
goog.require('cljs.core');
goog.require('threeagent.impl.virtual_scene');
goog.require('threeagent.impl.util');
goog.require('threeagent.impl.threejs');
goog.require('threeagent.impl.component');
goog.require('module$tmp$workspace$node_modules$three$build$three_module');
goog.require('cljs.core');
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.scene !== 'undefined') && (typeof threeagent.impl.scene.contexts !== 'undefined')){
} else {
threeagent.impl.scene.contexts = [];
}

/**
* @constructor
 * @implements {threeagent.impl.scene.Object}
*/
threeagent.impl.scene.Context = (function (virtualScene,sceneRoot,domRoot,animateFn,canvas,camera,clock,renderer,beforeRenderCb,afterRenderCb){
this.virtualScene = virtualScene;
this.sceneRoot = sceneRoot;
this.domRoot = domRoot;
this.animateFn = animateFn;
this.canvas = canvas;
this.camera = camera;
this.clock = clock;
this.renderer = renderer;
this.beforeRenderCb = beforeRenderCb;
this.afterRenderCb = afterRenderCb;
});

threeagent.impl.scene.Context.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"virtualScene","virtualScene",992990126,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("vscene","Scene","vscene/Scene",658119375,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"sceneRoot","sceneRoot",1033417013,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("vscene","Node","vscene/Node",1790107141,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"domRoot","domRoot",-591277325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"js","js",-886355190,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"animateFn","animateFn",1982297624,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"js","js",-886355190,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"canvas","canvas",-158285962,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"js","js",-886355190,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"camera","camera",450182942,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"js","js",-886355190,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"clock","clock",746230400,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"js","js",-886355190,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"renderer","renderer",1977372598,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"js","js",-886355190,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"beforeRenderCb","beforeRenderCb",1113466702,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"js","js",-886355190,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"afterRenderCb","afterRenderCb",-28620285,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"js","js",-886355190,null)], null))], null);
});

threeagent.impl.scene.Context.cljs$lang$type = true;

threeagent.impl.scene.Context.cljs$lang$ctorStr = "threeagent.impl.scene/Context";

threeagent.impl.scene.Context.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"threeagent.impl.scene/Context");
});

/**
 * Positional factory function for threeagent.impl.scene/Context.
 */
threeagent.impl.scene.__GT_Context = (function threeagent$impl$scene$__GT_Context(virtualScene,sceneRoot,domRoot,animateFn,canvas,camera,clock,renderer,beforeRenderCb,afterRenderCb){
return (new threeagent.impl.scene.Context(virtualScene,sceneRoot,domRoot,animateFn,canvas,camera,clock,renderer,beforeRenderCb,afterRenderCb));
});

threeagent.impl.scene.create_object = (function threeagent$impl$scene$create_object(node_data){
var comp_config = new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(node_data);
var obj = threeagent.impl.component.render_component.call(null,new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node_data),comp_config);
threeagent.impl.threejs.set_position_BANG_.call(null,obj,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(node_data));

threeagent.impl.threejs.set_rotation_BANG_.call(null,obj,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(node_data));

threeagent.impl.threejs.set_scale_BANG_.call(null,obj,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(node_data));

return obj;
});
threeagent.impl.scene.set_node_object = (function threeagent$impl$scene$set_node_object(context,node,node_data,obj){
node.threejs = obj;

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"camera","camera",-1190348585),new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node_data))){
return context.camera = obj;
} else {
return null;
}
});
threeagent.impl.scene.add_node = (function threeagent$impl$scene$add_node(context,parent_object,node){
try{var node_data = node.data;
var comp_config = new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(node_data);
var obj = threeagent.impl.scene.create_object.call(null,node_data);
threeagent.impl.scene.set_node_object.call(null,context,node,node_data,obj);

parent_object.add(obj);

node.for_each_child(cljs.core.partial.call(null,threeagent.impl.scene.add_node,context,obj));

obj.dispatchEvent(({"type": "on-added"}));

var temp__5457__auto___5455 = new cljs.core.Keyword(null,"on-added","on-added",-54041858).cljs$core$IFn$_invoke$arity$1(node.meta);
if(cljs.core.truth_(temp__5457__auto___5455)){
var callback_5456 = temp__5457__auto___5455;
callback_5456.call(null,obj);
} else {
}

return obj;
}catch (e5454){var e = e5454;
threeagent.impl.util.log.call(null,"Failed to add node");

threeagent.impl.util.log.call(null,e);

return cljs.core.println.call(null,node);
}});
threeagent.impl.scene.remove_node_BANG_ = (function threeagent$impl$scene$remove_node_BANG_(node){
var obj = node.threejs;
var parent_obj = node.parent.threejs;
obj.dispatchEvent(({"type": "on-removed"}));

var temp__5457__auto___5457 = new cljs.core.Keyword(null,"on-removed","on-removed",-1308728142).cljs$core$IFn$_invoke$arity$1(node.meta);
if(cljs.core.truth_(temp__5457__auto___5457)){
var callback_5458 = temp__5457__auto___5457;
callback_5458.call(null,obj);
} else {
}

parent_obj.remove(obj);

return node.for_each_child(threeagent.impl.scene.remove_node_BANG_);
});
threeagent.impl.scene.init_scene = (function threeagent$impl$scene$init_scene(context,virtual_scene,scene_root){
return threeagent.impl.scene.add_node.call(null,context,scene_root,virtual_scene.root);
});
threeagent.impl.scene.diff_data = (function threeagent$impl$scene$diff_data(o,n){
var this$ = ((((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(n))) || (cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(n)))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o,n], null):null);
var position = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(n):null);
var rotation = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(n):null);
var scale = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(n):null);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"this","this",-611633625),this$,new cljs.core.Keyword(null,"scale","scale",-230427353),scale,new cljs.core.Keyword(null,"position","position",-2011731912),position,new cljs.core.Keyword(null,"rotation","rotation",-1728051644),rotation], null);
});
threeagent.impl.scene.update_node_BANG_ = (function threeagent$impl$scene$update_node_BANG_(context,node,old_data,new_data){
var diff = threeagent.impl.scene.diff_data.call(null,old_data,new_data);
var old_obj = node.threejs;
var metadata = node.meta;
var this$ = new cljs.core.Keyword(null,"this","this",-611633625).cljs$core$IFn$_invoke$arity$1(diff);
if(cljs.core.truth_(this$)){
try{var vec__5460 = this$;
var o = cljs.core.nth.call(null,vec__5460,(0),null);
var n = cljs.core.nth.call(null,vec__5460,(1),null);
var parent_obj = old_obj.parent;
var children = old_obj.children;
var new_obj = threeagent.impl.scene.create_object.call(null,new_data);
old_obj.dispatchEvent(({"type": "on-removed"}));

var temp__5457__auto___5467 = new cljs.core.Keyword(null,"on-removed","on-removed",-1308728142).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(temp__5457__auto___5467)){
var callback_5468 = temp__5457__auto___5467;
callback_5468.call(null,old_obj);
} else {
}

threeagent.impl.scene.set_node_object.call(null,context,node,new_data,new_obj);

parent_obj.remove(old_obj);

parent_obj.add(new_obj);

if(cljs.core.truth_(node.terminal_QMARK_())){
} else {
var seq__5463_5469 = cljs.core.seq.call(null,children);
var chunk__5464_5470 = null;
var count__5465_5471 = (0);
var i__5466_5472 = (0);
while(true){
if((i__5466_5472 < count__5465_5471)){
var child_5473 = cljs.core._nth.call(null,chunk__5464_5470,i__5466_5472);
new_obj.add(child_5473);


var G__5474 = seq__5463_5469;
var G__5475 = chunk__5464_5470;
var G__5476 = count__5465_5471;
var G__5477 = (i__5466_5472 + (1));
seq__5463_5469 = G__5474;
chunk__5464_5470 = G__5475;
count__5465_5471 = G__5476;
i__5466_5472 = G__5477;
continue;
} else {
var temp__5457__auto___5478 = cljs.core.seq.call(null,seq__5463_5469);
if(temp__5457__auto___5478){
var seq__5463_5479__$1 = temp__5457__auto___5478;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5463_5479__$1)){
var c__4550__auto___5480 = cljs.core.chunk_first.call(null,seq__5463_5479__$1);
var G__5481 = cljs.core.chunk_rest.call(null,seq__5463_5479__$1);
var G__5482 = c__4550__auto___5480;
var G__5483 = cljs.core.count.call(null,c__4550__auto___5480);
var G__5484 = (0);
seq__5463_5469 = G__5481;
chunk__5464_5470 = G__5482;
count__5465_5471 = G__5483;
i__5466_5472 = G__5484;
continue;
} else {
var child_5485 = cljs.core.first.call(null,seq__5463_5479__$1);
new_obj.add(child_5485);


var G__5486 = cljs.core.next.call(null,seq__5463_5479__$1);
var G__5487 = null;
var G__5488 = (0);
var G__5489 = (0);
seq__5463_5469 = G__5486;
chunk__5464_5470 = G__5487;
count__5465_5471 = G__5488;
i__5466_5472 = G__5489;
continue;
}
} else {
}
}
break;
}
}

new_obj.dispatchEvent(({"type": "on-added"}));

var temp__5457__auto__ = new cljs.core.Keyword(null,"on-added","on-added",-54041858).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(temp__5457__auto__)){
var callback = temp__5457__auto__;
return callback.call(null,new_obj);
} else {
return null;
}
}catch (e5459){var ex = e5459;
threeagent.impl.util.log.call(null,"Failed to update node due to error");

threeagent.impl.util.log.call(null,ex);

return threeagent.impl.util.log.call(null,node);
}} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(diff))){
threeagent.impl.threejs.set_position_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(diff));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(diff))){
threeagent.impl.threejs.set_rotation_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(diff));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(diff))){
return threeagent.impl.threejs.set_scale_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(diff));
} else {
return null;
}
}
});
threeagent.impl.scene.apply_change_BANG_ = (function threeagent$impl$scene$apply_change_BANG_(context,p__5490){
var vec__5491 = p__5490;
var node = cljs.core.nth.call(null,vec__5491,(0),null);
var action = cljs.core.nth.call(null,vec__5491,(1),null);
var old = cljs.core.nth.call(null,vec__5491,(2),null);
var new$ = cljs.core.nth.call(null,vec__5491,(3),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"add","add",235287739),action)){
return threeagent.impl.scene.add_node.call(null,context,node.parent.threejs,node);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"remove","remove",-131428414),action)){
return threeagent.impl.scene.remove_node_BANG_.call(null,node);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"update","update",1045576396),action)){
return threeagent.impl.scene.update_node_BANG_.call(null,context,node,old,new$);
} else {
return null;
}
}
}
});
threeagent.impl.scene.apply_virtual_scene_changes_BANG_ = (function threeagent$impl$scene$apply_virtual_scene_changes_BANG_(context,changelog){
var seq__5494 = cljs.core.seq.call(null,changelog);
var chunk__5495 = null;
var count__5496 = (0);
var i__5497 = (0);
while(true){
if((i__5497 < count__5496)){
var change = cljs.core._nth.call(null,chunk__5495,i__5497);
threeagent.impl.scene.apply_change_BANG_.call(null,context,change);


var G__5498 = seq__5494;
var G__5499 = chunk__5495;
var G__5500 = count__5496;
var G__5501 = (i__5497 + (1));
seq__5494 = G__5498;
chunk__5495 = G__5499;
count__5496 = G__5500;
i__5497 = G__5501;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__5494);
if(temp__5457__auto__){
var seq__5494__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5494__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__5494__$1);
var G__5502 = cljs.core.chunk_rest.call(null,seq__5494__$1);
var G__5503 = c__4550__auto__;
var G__5504 = cljs.core.count.call(null,c__4550__auto__);
var G__5505 = (0);
seq__5494 = G__5502;
chunk__5495 = G__5503;
count__5496 = G__5504;
i__5497 = G__5505;
continue;
} else {
var change = cljs.core.first.call(null,seq__5494__$1);
threeagent.impl.scene.apply_change_BANG_.call(null,context,change);


var G__5506 = cljs.core.next.call(null,seq__5494__$1);
var G__5507 = null;
var G__5508 = (0);
var G__5509 = (0);
seq__5494 = G__5506;
chunk__5495 = G__5507;
count__5496 = G__5508;
i__5497 = G__5509;
continue;
}
} else {
return null;
}
}
break;
}
});
threeagent.impl.scene.animate = (function threeagent$impl$scene$animate(context){
var stats = context.stats;
var clock = context.clock;
var virtual_scene = context.virtualScene;
var renderer = context.renderer;
var composer = context.composer;
var camera = context.camera;
var scene_root = context.sceneRoot;
var before_render_cb = context.beforeRenderCb;
var after_render_cb = context.afterRenderCb;
if(cljs.core.truth_(stats)){
stats.begin();
} else {
}

var delta_time_5510 = clock.getDelta();
var changelog_5511 = [];
if(cljs.core.truth_(before_render_cb)){
before_render_cb.call(null,delta_time_5510);
} else {
}

threeagent.impl.virtual_scene.render_BANG_.call(null,virtual_scene,changelog_5511);

threeagent.impl.scene.apply_virtual_scene_changes_BANG_.call(null,context,changelog_5511);

if(cljs.core.truth_(composer)){
composer.render(delta_time_5510);
} else {
renderer.render(scene_root,camera);
}

if(cljs.core.truth_(after_render_cb)){
after_render_cb.call(null,delta_time_5510);
} else {
}

if(cljs.core.truth_(stats)){
return stats.end();
} else {
return null;
}
});
threeagent.impl.scene.get_canvas = (function threeagent$impl$scene$get_canvas(dom_root){
if(cljs.core._EQ_.call(null,"canvas",clojure.string.lower_case.call(null,dom_root.tagName))){
return dom_root;
} else {
var c = document.createElement("canvas");
return dom_root.appendChild(c);
}
});
threeagent.impl.scene.create_context = (function threeagent$impl$scene$create_context(root_fn,dom_root,on_before_render_cb,on_after_render_cb){
var canvas = threeagent.impl.scene.get_canvas.call(null,dom_root);
var width = canvas.offsetWidth;
var height = canvas.offsetHeight;
var virtual_scene = threeagent.impl.virtual_scene.create.call(null,root_fn);
var renderer = (new module$tmp$workspace$node_modules$three$build$three_module.WebGLRenderer(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"canvas","canvas",-1798817489),canvas], null))));
var camera = (new module$tmp$workspace$node_modules$three$build$three_module.PerspectiveCamera((75),(width / height),0.1,(1000)));
var scene_root = (new module$tmp$workspace$node_modules$three$build$three_module.Scene());
var clock = (new module$tmp$workspace$node_modules$three$build$three_module.Clock());
renderer.setSize(width,height);

var context = (new threeagent.impl.scene.Context(virtual_scene,scene_root,dom_root,null,canvas,camera,clock,renderer,on_before_render_cb,on_after_render_cb));
context.animateFn = ((function (context,canvas,width,height,virtual_scene,renderer,camera,scene_root,clock){
return (function (){
return threeagent.impl.scene.animate.call(null,context);
});})(context,canvas,width,height,virtual_scene,renderer,camera,scene_root,clock))
;

threeagent.impl.scene.init_scene.call(null,context,virtual_scene,scene_root);

threeagent.impl.scene.contexts.push(context);

return context;
});
threeagent.impl.scene.remove_all_children_BANG_ = (function threeagent$impl$scene$remove_all_children_BANG_(vscene_root){
return vscene_root.for_each_child(threeagent.impl.scene.remove_node_BANG_);
});
threeagent.impl.scene.reset_context_BANG_ = (function threeagent$impl$scene$reset_context_BANG_(context,root_fn,p__5512){
var map__5513 = p__5512;
var map__5513__$1 = (((((!((map__5513 == null))))?(((((map__5513.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5513.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5513):map__5513);
var on_before_render = cljs.core.get.call(null,map__5513__$1,new cljs.core.Keyword(null,"on-before-render","on-before-render",601463713));
var on_after_render = cljs.core.get.call(null,map__5513__$1,new cljs.core.Keyword(null,"on-after-render","on-after-render",-1318143250));
var scene_root = context.sceneRoot;
var virtual_scene = context.virtualScene;
var new_virtual_scene = threeagent.impl.virtual_scene.create.call(null,root_fn);
threeagent.impl.scene.remove_all_children_BANG_.call(null,virtual_scene.root);

threeagent.impl.virtual_scene.destroy_BANG_.call(null,virtual_scene);

threeagent.impl.scene.init_scene.call(null,context,new_virtual_scene,scene_root);

context.virtualScene = new_virtual_scene;

context.beforeRenderCb = on_before_render;

context.afterRenderCb = on_after_render;

return context;
});
threeagent.impl.scene.find_context = (function threeagent$impl$scene$find_context(dom_root){
return cljs.core.first.call(null,cljs.core.filter.call(null,(function (p1__5515_SHARP_){
return cljs.core._EQ_.call(null,p1__5515_SHARP_.domRoot,dom_root);
}),threeagent.impl.scene.contexts));
});
threeagent.impl.scene.render = (function threeagent$impl$scene$render(root_fn,dom_root,p__5516){
var map__5517 = p__5516;
var map__5517__$1 = (((((!((map__5517 == null))))?(((((map__5517.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5517.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5517):map__5517);
var config = map__5517__$1;
var on_before_render = cljs.core.get.call(null,map__5517__$1,new cljs.core.Keyword(null,"on-before-render","on-before-render",601463713));
var on_after_render = cljs.core.get.call(null,map__5517__$1,new cljs.core.Keyword(null,"on-after-render","on-after-render",-1318143250));
var temp__5455__auto__ = threeagent.impl.scene.find_context.call(null,dom_root);
if(cljs.core.truth_(temp__5455__auto__)){
var existing_context = temp__5455__auto__;
return threeagent.impl.scene.reset_context_BANG_.call(null,existing_context,root_fn,config);
} else {
var context = threeagent.impl.scene.create_context.call(null,root_fn,dom_root,on_before_render,on_after_render);
var renderer = context.renderer;
renderer.setAnimationLoop(context.animateFn);

return context;
}
});

//# sourceMappingURL=scene.js.map
