// Compiled by ClojureScript 1.10.520 {}
goog.provide('threeagent.impl.virtual_scene');
goog.require('cljs.core');
goog.require('threeagent.impl.util');
goog.require('medley.core');
goog.require('reagent.ratom');
goog.require('reagent.core');
goog.require('goog.structs.PriorityQueue');
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.non_component_keys !== 'undefined')){
} else {
threeagent.impl.virtual_scene.non_component_keys = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"rotation","rotation",-1728051644),null,new cljs.core.Keyword(null,"scale","scale",-230427353),null,new cljs.core.Keyword(null,"position","position",-2011731912),null], null), null);
}
threeagent.impl.virtual_scene.print_tree = (function threeagent$impl$virtual_scene$print_tree(var_args){
var G__5233 = arguments.length;
switch (G__5233) {
case 1:
return threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.impl.virtual_scene.print_tree.call(null,node,"");
});

threeagent.impl.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2 = (function (node,p){
var is_reactive = (!((node.reaction == null)));
cljs.core.println.call(null,p,"|-",node.key,["comp:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node.data))].join(''),["dirty:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node.dirty)].join(''),["reactive:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(is_reactive)].join(''));

var seq__5234 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,node.children.values()));
var chunk__5235 = null;
var count__5236 = (0);
var i__5237 = (0);
while(true){
if((i__5237 < count__5236)){
var child = cljs.core._nth.call(null,chunk__5235,i__5237);
threeagent.impl.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__5239 = seq__5234;
var G__5240 = chunk__5235;
var G__5241 = count__5236;
var G__5242 = (i__5237 + (1));
seq__5234 = G__5239;
chunk__5235 = G__5240;
count__5236 = G__5241;
i__5237 = G__5242;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__5234);
if(temp__5457__auto__){
var seq__5234__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5234__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__5234__$1);
var G__5243 = cljs.core.chunk_rest.call(null,seq__5234__$1);
var G__5244 = c__4550__auto__;
var G__5245 = cljs.core.count.call(null,c__4550__auto__);
var G__5246 = (0);
seq__5234 = G__5243;
chunk__5235 = G__5244;
count__5236 = G__5245;
i__5237 = G__5246;
continue;
} else {
var child = cljs.core.first.call(null,seq__5234__$1);
threeagent.impl.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__5247 = cljs.core.next.call(null,seq__5234__$1);
var G__5248 = null;
var G__5249 = (0);
var G__5250 = (0);
seq__5234 = G__5247;
chunk__5235 = G__5248;
count__5236 = G__5249;
i__5237 = G__5250;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.impl.virtual_scene.print_tree.cljs$lang$maxFixedArity = 2;

threeagent.impl.virtual_scene.node__GT_path = (function threeagent$impl$virtual_scene$node__GT_path(var_args){
var G__5252 = arguments.length;
switch (G__5252) {
case 1:
return threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.impl.virtual_scene.node__GT_path.call(null,cljs.core.PersistentVector.EMPTY,node);
});

threeagent.impl.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2 = (function (path,node){
while(true){
if(cljs.core.truth_(node)){
var G__5254 = cljs.core.conj.call(null,path,node.key);
var G__5255 = node.parent;
path = G__5254;
node = G__5255;
continue;
} else {
return cljs.core.reverse.call(null,path);
}
break;
}
});

threeagent.impl.virtual_scene.node__GT_path.cljs$lang$maxFixedArity = 2;

threeagent.impl.virtual_scene.get_key = (function threeagent$impl$virtual_scene$get_key(key,meta){
return new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$2(meta,key);
});

/**
* @constructor
 * @implements {threeagent.impl.virtual_scene.Object}
*/
threeagent.impl.virtual_scene.Node = (function (parent,depth,key,meta,data,dirty,render,reaction,children){
this.parent = parent;
this.depth = depth;
this.key = key;
this.meta = meta;
this.data = data;
this.dirty = dirty;
this.render = render;
this.reaction = reaction;
this.children = children;
});
threeagent.impl.virtual_scene.Node.prototype.terminal_QMARK_ = (function (){
var self__ = this;
var this$ = this;
return cljs.core._EQ_.call(null,(0),self__.children.size);
});

threeagent.impl.virtual_scene.Node.prototype.for_each_child = (function (f){
var self__ = this;
var this$ = this;
var seq__5256 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,self__.children.values()));
var chunk__5257 = null;
var count__5258 = (0);
var i__5259 = (0);
while(true){
if((i__5259 < count__5258)){
var child = cljs.core._nth.call(null,chunk__5257,i__5259);
f.call(null,child);


var G__5260 = seq__5256;
var G__5261 = chunk__5257;
var G__5262 = count__5258;
var G__5263 = (i__5259 + (1));
seq__5256 = G__5260;
chunk__5257 = G__5261;
count__5258 = G__5262;
i__5259 = G__5263;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__5256);
if(temp__5457__auto__){
var seq__5256__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5256__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__5256__$1);
var G__5264 = cljs.core.chunk_rest.call(null,seq__5256__$1);
var G__5265 = c__4550__auto__;
var G__5266 = cljs.core.count.call(null,c__4550__auto__);
var G__5267 = (0);
seq__5256 = G__5264;
chunk__5257 = G__5265;
count__5258 = G__5266;
i__5259 = G__5267;
continue;
} else {
var child = cljs.core.first.call(null,seq__5256__$1);
f.call(null,child);


var G__5268 = cljs.core.next.call(null,seq__5256__$1);
var G__5269 = null;
var G__5270 = (0);
var G__5271 = (0);
seq__5256 = G__5268;
chunk__5257 = G__5269;
count__5258 = G__5270;
i__5259 = G__5271;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.impl.virtual_scene.Node.getBasis = (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Node","Node",446032991,null)], null)),new cljs.core.Symbol(null,"depth","depth",-885772129,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"dirty","dirty",-1924882488,null),new cljs.core.Symbol(null,"render","render",232498073,null),new cljs.core.Symbol(null,"reaction","reaction",2131401315,null),new cljs.core.Symbol(null,"children","children",699969545,null)], null);
});

threeagent.impl.virtual_scene.Node.cljs$lang$type = true;

threeagent.impl.virtual_scene.Node.cljs$lang$ctorStr = "threeagent.impl.virtual-scene/Node";

threeagent.impl.virtual_scene.Node.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"threeagent.impl.virtual-scene/Node");
});

/**
 * Positional factory function for threeagent.impl.virtual-scene/Node.
 */
threeagent.impl.virtual_scene.__GT_Node = (function threeagent$impl$virtual_scene$__GT_Node(parent,depth,key,meta,data,dirty,render,reaction,children){
return (new threeagent.impl.virtual_scene.Node(parent,depth,key,meta,data,dirty,render,reaction,children));
});


/**
* @constructor
 * @implements {threeagent.impl.virtual_scene.Object}
*/
threeagent.impl.virtual_scene.Scene = (function (root,renderQueue){
this.root = root;
this.renderQueue = renderQueue;
});
threeagent.impl.virtual_scene.Scene.prototype.enqueueForRender = (function (node){
var self__ = this;
var this$ = this;
node.dirty = true;

return self__.renderQueue.enqueue(node.depth,node);
});

threeagent.impl.virtual_scene.Scene.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"renderQueue","renderQueue",-1811767425,null)], null);
});

threeagent.impl.virtual_scene.Scene.cljs$lang$type = true;

threeagent.impl.virtual_scene.Scene.cljs$lang$ctorStr = "threeagent.impl.virtual-scene/Scene";

threeagent.impl.virtual_scene.Scene.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"threeagent.impl.virtual-scene/Scene");
});

/**
 * Positional factory function for threeagent.impl.virtual-scene/Scene.
 */
threeagent.impl.virtual_scene.__GT_Scene = (function threeagent$impl$virtual_scene$__GT_Scene(root,renderQueue){
return (new threeagent.impl.virtual_scene.Scene(root,renderQueue));
});

threeagent.impl.virtual_scene.get_in_node = (function threeagent$impl$virtual_scene$get_in_node(node,path){
while(true){
if(cljs.core.empty_QMARK_.call(null,path)){
return node;
} else {
var G__5272 = node.children.get(cljs.core.first.call(null,path));
var G__5273 = cljs.core.rest.call(null,path);
node = G__5272;
path = G__5273;
continue;
}
break;
}
});
threeagent.impl.virtual_scene.get_in_scene = (function threeagent$impl$virtual_scene$get_in_scene(scene,path){
return threeagent.impl.virtual_scene.get_in_node.call(null,scene.root,cljs.core.rest.call(null,path));
});
threeagent.impl.virtual_scene.eval_fn = (function threeagent$impl$virtual_scene$eval_fn(f,args){
while(true){
var result = cljs.core.apply.call(null,f,args);
if(cljs.core.fn_QMARK_.call(null,result)){
var G__5274 = result;
var G__5275 = args;
f = G__5274;
args = G__5275;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,result], null);
}
break;
}
});
threeagent.impl.virtual_scene.on_react_BANG_ = (function threeagent$impl$virtual_scene$on_react_BANG_(ctx){
var node = ctx.node;
var scene = ctx.scene;
return scene.enqueueForRender(node);
});
threeagent.impl.virtual_scene.extract_comp_config = (function threeagent$impl$virtual_scene$extract_comp_config(config){
var c = cljs.core.transient$.call(null,config);
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,((function (c){
return (function (p1__5276_SHARP_,p2__5277_SHARP_){
return cljs.core.dissoc_BANG_.call(null,p1__5276_SHARP_,p2__5277_SHARP_);
});})(c))
,c,threeagent.impl.virtual_scene.non_component_keys));
});
threeagent.impl.virtual_scene.node_data = (function threeagent$impl$virtual_scene$node_data(comp_key,comp_config){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"rotation","rotation",-1728051644),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"scale","scale",-230427353),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [1.0,1.0,1.0], null)),new cljs.core.Keyword(null,"component-key","component-key",1189239034),comp_key,new cljs.core.Keyword(null,"component-config","component-config",2000790546),threeagent.impl.virtual_scene.extract_comp_config.call(null,comp_config)], null);
});
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.__GT_node !== 'undefined')){
} else {
threeagent.impl.virtual_scene.__GT_node = (function (){var method_table__4613__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.impl.virtual-scene","->node"),((function (method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__){
return (function (scene,parent,key,p__5278){
var vec__5279 = p__5278;
var seq__5280 = cljs.core.seq.call(null,vec__5279);
var first__5281 = cljs.core.first.call(null,seq__5280);
var seq__5280__$1 = cljs.core.next.call(null,seq__5280);
var l = first__5281;
var r = seq__5280__$1;
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});})(method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"default","default",-1987822328),(function (scene,parent,key,form){
return cljs.core.println.call(null,"Invalid object form:",form);
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (scene,parent,key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (scene,parent,key,form){
return threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent,key,cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),cljs.core.meta.call(null,form)));
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (scene,parent,key,form){
var vec__5282 = form;
var seq__5283 = cljs.core.seq.call(null,vec__5282);
var first__5284 = cljs.core.first.call(null,seq__5283);
var seq__5283__$1 = cljs.core.next.call(null,seq__5283);
var comp_key = first__5284;
var rs = seq__5283__$1;
var first_child = cljs.core.first.call(null,rs);
var metadata = cljs.core.meta.call(null,form);
var key__$1 = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return key;
}
})();
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,cljs.core.some_QMARK_,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
var children_map = (new Map());
var data = threeagent.impl.virtual_scene.node_data.call(null,comp_key,comp_config);
var depth = (cljs.core.truth_(parent)?(parent.depth + (1)):(0));
var node = (new threeagent.impl.virtual_scene.Node(parent,depth,key__$1,metadata,data,false,null,null,children_map));
var seq__5285_5301 = cljs.core.seq.call(null,medley.core.indexed.call(null,children));
var chunk__5286_5302 = null;
var count__5287_5303 = (0);
var i__5288_5304 = (0);
while(true){
if((i__5288_5304 < count__5287_5303)){
var vec__5295_5305 = cljs.core._nth.call(null,chunk__5286_5302,i__5288_5304);
var idx_5306 = cljs.core.nth.call(null,vec__5295_5305,(0),null);
var child_5307 = cljs.core.nth.call(null,vec__5295_5305,(1),null);
var temp__5457__auto___5308 = threeagent.impl.virtual_scene.__GT_node.call(null,scene,node,idx_5306,child_5307);
if(cljs.core.truth_(temp__5457__auto___5308)){
var child_node_5309 = temp__5457__auto___5308;
children_map.set(child_node_5309.key,child_node_5309);
} else {
}


var G__5310 = seq__5285_5301;
var G__5311 = chunk__5286_5302;
var G__5312 = count__5287_5303;
var G__5313 = (i__5288_5304 + (1));
seq__5285_5301 = G__5310;
chunk__5286_5302 = G__5311;
count__5287_5303 = G__5312;
i__5288_5304 = G__5313;
continue;
} else {
var temp__5457__auto___5314 = cljs.core.seq.call(null,seq__5285_5301);
if(temp__5457__auto___5314){
var seq__5285_5315__$1 = temp__5457__auto___5314;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5285_5315__$1)){
var c__4550__auto___5316 = cljs.core.chunk_first.call(null,seq__5285_5315__$1);
var G__5317 = cljs.core.chunk_rest.call(null,seq__5285_5315__$1);
var G__5318 = c__4550__auto___5316;
var G__5319 = cljs.core.count.call(null,c__4550__auto___5316);
var G__5320 = (0);
seq__5285_5301 = G__5317;
chunk__5286_5302 = G__5318;
count__5287_5303 = G__5319;
i__5288_5304 = G__5320;
continue;
} else {
var vec__5298_5321 = cljs.core.first.call(null,seq__5285_5315__$1);
var idx_5322 = cljs.core.nth.call(null,vec__5298_5321,(0),null);
var child_5323 = cljs.core.nth.call(null,vec__5298_5321,(1),null);
var temp__5457__auto___5324__$1 = threeagent.impl.virtual_scene.__GT_node.call(null,scene,node,idx_5322,child_5323);
if(cljs.core.truth_(temp__5457__auto___5324__$1)){
var child_node_5325 = temp__5457__auto___5324__$1;
children_map.set(child_node_5325.key,child_node_5325);
} else {
}


var G__5326 = cljs.core.next.call(null,seq__5285_5315__$1);
var G__5327 = null;
var G__5328 = (0);
var G__5329 = (0);
seq__5285_5301 = G__5326;
chunk__5286_5302 = G__5327;
count__5287_5303 = G__5328;
i__5288_5304 = G__5329;
continue;
}
} else {
}
}
break;
}

return node;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (scene,parent,key,form){
var key__$1 = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,form));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return key;
}
})();
var vec__5330 = form;
var seq__5331 = cljs.core.seq.call(null,vec__5330);
var first__5332 = cljs.core.first.call(null,seq__5331);
var seq__5331__$1 = cljs.core.next.call(null,seq__5331);
var f = first__5332;
var args = seq__5331__$1;
var reaction_ctx = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),null,new cljs.core.Keyword(null,"reaction","reaction",490869788),null], null));
var vec__5333 = reagent.ratom.run_in_reaction.call(null,((function (key__$1,vec__5330,seq__5331,first__5332,seq__5331__$1,f,args,reaction_ctx){
return (function (){
return threeagent.impl.virtual_scene.eval_fn.call(null,f,args);
});})(key__$1,vec__5330,seq__5331,first__5332,seq__5331__$1,f,args,reaction_ctx))
,reaction_ctx,"reaction",threeagent.impl.virtual_scene.on_react_BANG_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"no-cache","no-cache",1588056370),true], null));
var final_fn = cljs.core.nth.call(null,vec__5333,(0),null);
var result = cljs.core.nth.call(null,vec__5333,(1),null);
var node = threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent,key__$1,result);
node.originalFn = f;

node.render = final_fn;

node.form = form;

node.renderedForm = result;

var temp__5457__auto___5336 = reaction_ctx.reaction;
if(cljs.core.truth_(temp__5457__auto___5336)){
var reaction_5337 = temp__5457__auto___5336;
reaction_ctx.scene = scene;

reaction_ctx.node = node;

node.reaction = reaction_5337;
} else {
}

return node;
}));
threeagent.impl.virtual_scene.form__GT_form_type = (function threeagent$impl$virtual_scene$form__GT_form_type(p__5338){
var vec__5339 = p__5338;
var seq__5340 = cljs.core.seq.call(null,vec__5339);
var first__5341 = cljs.core.first.call(null,seq__5340);
var seq__5340__$1 = cljs.core.next.call(null,seq__5340);
var l = first__5341;
var r = seq__5340__$1;
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});
if((typeof threeagent !== 'undefined') && (typeof threeagent.impl !== 'undefined') && (typeof threeagent.impl.virtual_scene !== 'undefined') && (typeof threeagent.impl.virtual_scene.__GT_node_shallow !== 'undefined')){
} else {
threeagent.impl.virtual_scene.__GT_node_shallow = (function (){var method_table__4613__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.impl.virtual-scene","->node-shallow"),((function (method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__){
return (function (key,f){
return threeagent.impl.virtual_scene.form__GT_form_type.call(null,f);
});})(method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (key,form){
if(cljs.core.empty_QMARK_.call(null,form)){
return null;
} else {
var m = cljs.core.meta.call(null,form);
return threeagent.impl.virtual_scene.__GT_node_shallow.call(null,threeagent.impl.virtual_scene.get_key.call(null,key,m),cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),m));
}
}));
cljs.core._add_method.call(null,threeagent.impl.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (key,form){
var vec__5345 = form;
var seq__5346 = cljs.core.seq.call(null,vec__5345);
var first__5347 = cljs.core.first.call(null,seq__5346);
var seq__5346__$1 = cljs.core.next.call(null,seq__5346);
var comp_key = first__5347;
var rs = seq__5346__$1;
var first_child = cljs.core.first.call(null,rs);
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,((function (vec__5345,seq__5346,first__5347,seq__5346__$1,comp_key,rs,first_child,comp_config){
return (function (p1__5342_SHARP_){
return (((!((p1__5342_SHARP_ == null)))) && ((!(cljs.core.empty_QMARK_.call(null,p1__5342_SHARP_)))));
});})(vec__5345,seq__5346,first__5347,seq__5346__$1,comp_key,rs,first_child,comp_config))
,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"data","data",-232669377),threeagent.impl.virtual_scene.node_data.call(null,comp_key,comp_config),new cljs.core.Keyword(null,"form","form",-1624062471),form,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807),cljs.core.map_indexed.call(null,((function (vec__5345,seq__5346,first__5347,seq__5346__$1,comp_key,rs,first_child,comp_config,children){
return (function (p1__5344_SHARP_,p2__5343_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p2__5343_SHARP_));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return p1__5344_SHARP_;
}
})(),p2__5343_SHARP_],null));
});})(vec__5345,seq__5346,first__5347,seq__5346__$1,comp_key,rs,first_child,comp_config,children))
,children)], null);
}));
threeagent.impl.virtual_scene.dispose_node_BANG_ = (function threeagent$impl$virtual_scene$dispose_node_BANG_(node){
node.disposed = true;

var temp__5457__auto___5348 = node.reaction;
if(cljs.core.truth_(temp__5457__auto___5348)){
var reaction_5349 = temp__5457__auto___5348;
reagent.ratom.dispose_BANG_.call(null,reaction_5349);
} else {
}

return node.for_each_child(threeagent.impl.virtual_scene.dispose_node_BANG_);
});
threeagent.impl.virtual_scene.add_node_BANG_ = (function threeagent$impl$virtual_scene$add_node_BANG_(scene,parent_node,key,form,changelog){
var temp__5457__auto__ = threeagent.impl.virtual_scene.__GT_node.call(null,scene,parent_node,key,form);
if(cljs.core.truth_(temp__5457__auto__)){
var node = temp__5457__auto__;
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"add","add",235287739),null,node.data], null));

return node;
} else {
return null;
}
});
threeagent.impl.virtual_scene.remove_node_BANG_ = (function threeagent$impl$virtual_scene$remove_node_BANG_(node,changelog){
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"remove","remove",-131428414),node.data,null], null));

node.data = null;

node.dirty = false;

return threeagent.impl.virtual_scene.dispose_node_BANG_.call(null,node);
});
threeagent.impl.virtual_scene.replace_node_BANG_ = (function threeagent$impl$virtual_scene$replace_node_BANG_(scene,node,new_form,changelog){
var parent = node.parent;
var key = node.key;
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,node,changelog);

var new_node = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,parent,key,new_form,changelog);
return parent.children.set(key,new_node);
});
threeagent.impl.virtual_scene.diff_fn_QMARK_ = (function threeagent$impl$virtual_scene$diff_fn_QMARK_(node,new_form){
var original_fn = node.originalFn;
return (((!((original_fn == null)))) && (cljs.core.not_EQ_.call(null,original_fn,cljs.core.first.call(null,new_form))));
});
threeagent.impl.virtual_scene.update_node_BANG_ = (function threeagent$impl$virtual_scene$update_node_BANG_(scene,node,new_form,changelog){
node.dirty = false;

if(threeagent.impl.virtual_scene.diff_fn_QMARK_.call(null,node,new_form)){
return threeagent.impl.virtual_scene.replace_node_BANG_.call(null,scene,node,new_form,changelog);
} else {
var render_fn = node.render;
var original_fn = node.originalFn;
var new_type = threeagent.impl.virtual_scene.form__GT_form_type.call(null,new_form);
var rendered_form = (cljs.core.truth_((function (){var and__4120__auto__ = render_fn;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),new_type);
} else {
return and__4120__auto__;
}
})())?cljs.core.apply.call(null,render_fn,cljs.core.rest.call(null,new_form)):new_form);
var old_form = node.renderedForm;
if(cljs.core.not_EQ_.call(null,rendered_form,old_form)){
var key = node.key;
var children = node.children;
var old_data = node.data;
var shallow_node = threeagent.impl.virtual_scene.__GT_node_shallow.call(null,key,rendered_form);
var new_data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(shallow_node);
var current_keys = cljs.core.set.call(null,cljs.core.es6_iterator_seq.call(null,children.keys()));
var new_keys = cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.first,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node)));
var dropped_keys = clojure.set.difference.call(null,current_keys,new_keys);
node.data = new_data;

if(cljs.core.truth_(render_fn)){
node.form = cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [render_fn], null),cljs.core.rest.call(null,new_form));
} else {
}

node.renderedForm = new_form;

changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"update","update",1045576396),old_data,new_data], null));

var seq__5350_5370 = cljs.core.seq.call(null,dropped_keys);
var chunk__5351_5371 = null;
var count__5352_5372 = (0);
var i__5353_5373 = (0);
while(true){
if((i__5353_5373 < count__5352_5372)){
var child_key_5374 = cljs.core._nth.call(null,chunk__5351_5371,i__5353_5373);
var child_node_5375 = children.get(child_key_5374);
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,child_node_5375,changelog);

children.delete(child_key_5374);


var G__5376 = seq__5350_5370;
var G__5377 = chunk__5351_5371;
var G__5378 = count__5352_5372;
var G__5379 = (i__5353_5373 + (1));
seq__5350_5370 = G__5376;
chunk__5351_5371 = G__5377;
count__5352_5372 = G__5378;
i__5353_5373 = G__5379;
continue;
} else {
var temp__5457__auto___5380 = cljs.core.seq.call(null,seq__5350_5370);
if(temp__5457__auto___5380){
var seq__5350_5381__$1 = temp__5457__auto___5380;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5350_5381__$1)){
var c__4550__auto___5382 = cljs.core.chunk_first.call(null,seq__5350_5381__$1);
var G__5383 = cljs.core.chunk_rest.call(null,seq__5350_5381__$1);
var G__5384 = c__4550__auto___5382;
var G__5385 = cljs.core.count.call(null,c__4550__auto___5382);
var G__5386 = (0);
seq__5350_5370 = G__5383;
chunk__5351_5371 = G__5384;
count__5352_5372 = G__5385;
i__5353_5373 = G__5386;
continue;
} else {
var child_key_5387 = cljs.core.first.call(null,seq__5350_5381__$1);
var child_node_5388 = children.get(child_key_5387);
threeagent.impl.virtual_scene.remove_node_BANG_.call(null,child_node_5388,changelog);

children.delete(child_key_5387);


var G__5389 = cljs.core.next.call(null,seq__5350_5381__$1);
var G__5390 = null;
var G__5391 = (0);
var G__5392 = (0);
seq__5350_5370 = G__5389;
chunk__5351_5371 = G__5390;
count__5352_5372 = G__5391;
i__5353_5373 = G__5392;
continue;
}
} else {
}
}
break;
}

var seq__5354 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node));
var chunk__5355 = null;
var count__5356 = (0);
var i__5357 = (0);
while(true){
if((i__5357 < count__5356)){
var vec__5364 = cljs.core._nth.call(null,chunk__5355,i__5357);
var child_key = cljs.core.nth.call(null,vec__5364,(0),null);
var child_form = cljs.core.nth.call(null,vec__5364,(1),null);
var temp__5455__auto___5393 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___5393)){
var child_5394 = temp__5455__auto___5393;
threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,child_5394,child_form,changelog);
} else {
var temp__5457__auto___5395 = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___5395)){
var child_node_5396 = temp__5457__auto___5395;
children.set(child_key,child_node_5396);
} else {
}
}


var G__5397 = seq__5354;
var G__5398 = chunk__5355;
var G__5399 = count__5356;
var G__5400 = (i__5357 + (1));
seq__5354 = G__5397;
chunk__5355 = G__5398;
count__5356 = G__5399;
i__5357 = G__5400;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__5354);
if(temp__5457__auto__){
var seq__5354__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5354__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__5354__$1);
var G__5401 = cljs.core.chunk_rest.call(null,seq__5354__$1);
var G__5402 = c__4550__auto__;
var G__5403 = cljs.core.count.call(null,c__4550__auto__);
var G__5404 = (0);
seq__5354 = G__5401;
chunk__5355 = G__5402;
count__5356 = G__5403;
i__5357 = G__5404;
continue;
} else {
var vec__5367 = cljs.core.first.call(null,seq__5354__$1);
var child_key = cljs.core.nth.call(null,vec__5367,(0),null);
var child_form = cljs.core.nth.call(null,vec__5367,(1),null);
var temp__5455__auto___5405 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___5405)){
var child_5406 = temp__5455__auto___5405;
threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,child_5406,child_form,changelog);
} else {
var temp__5457__auto___5407__$1 = threeagent.impl.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___5407__$1)){
var child_node_5408 = temp__5457__auto___5407__$1;
children.set(child_key,child_node_5408);
} else {
}
}


var G__5409 = cljs.core.next.call(null,seq__5354__$1);
var G__5410 = null;
var G__5411 = (0);
var G__5412 = (0);
seq__5354 = G__5409;
chunk__5355 = G__5410;
count__5356 = G__5411;
i__5357 = G__5412;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
}
});
threeagent.impl.virtual_scene.render_node_BANG_ = (function threeagent$impl$virtual_scene$render_node_BANG_(scene,node,changelog){
var form = node.form;
return threeagent.impl.virtual_scene.update_node_BANG_.call(null,scene,node,form,changelog);
});
threeagent.impl.virtual_scene.render_BANG_ = (function threeagent$impl$virtual_scene$render_BANG_(scene,changelog){
reagent.core.flush.call(null);

var queue = scene.renderQueue;
var node = queue.dequeue();
while(true){
if(cljs.core.truth_(node)){
if(cljs.core.truth_(node.dirty)){
threeagent.impl.virtual_scene.render_node_BANG_.call(null,scene,node,changelog);
} else {
}

var G__5413 = queue.dequeue();
node = G__5413;
continue;
} else {
return null;
}
break;
}
});
threeagent.impl.virtual_scene.destroy_BANG_ = (function threeagent$impl$virtual_scene$destroy_BANG_(scene){
return threeagent.impl.virtual_scene.dispose_node_BANG_.call(null,scene.root);
});
threeagent.impl.virtual_scene.create = (function threeagent$impl$virtual_scene$create(root_fn){
var scene = (new threeagent.impl.virtual_scene.Scene(null,(new goog.structs.PriorityQueue())));
var root_node = threeagent.impl.virtual_scene.__GT_node.call(null,scene,null,(0),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root_fn], null));
scene.root = root_node;

return scene;
});

//# sourceMappingURL=virtual_scene.js.map
