(ns draconic.ui
  (:require [draconic.ui.binding :as b]))


(defn deref [node]
  (b/-ui-get-state node))

(defn reset!
  "Takes a new val, that is set as the node's new state without consideration for the current state."
  [node newval]
  (b/-ui-set-state! node newval))

(defn compare-and-set!
  "Sets the new value if, and only if, the state of the node at call time is the same as the state of the node at set time. Returns true if set successful, else false."
  [node newval]
  (let [orig-state (deref node)]
    (if (= orig-state (deref node))
      (do
        (reset! node newval)
        true)
      false)))

(defn swap!
  "Takes a function of (old state) -> (new state). Works like with Clojure's swap!, so the fn should be without side effects. Returns the node."
  [node swap-fn]
  (loop []
    (if (compare-and-set! node (swap-fn (deref node)))
      node
      (recur)))
  )

(defn get-all-children [node]
  (b/-ui-get-all-children node))

(defn get-main-children [node]
  (:main (b/-ui-get-all-children node)))

(defn set-children! [node node-map]
  (b/-ui-set-children! node node-map))

(defn set-children-listener! [node content-section listener-fn]
  (b/-ui-set-children-listener! node content-section listener-fn))

(defn remove-children-listener! [node content-section]
  (b/-ui-remove-children-listener! node content-section))



(defn get-state-spec [node]
  (b/-ui-get-state-spec node))

(defn set-state-spec [node newspec]
  (b/-ui-set-state-spec node newspec))
