// Compiled by ClojureScript 1.7.48 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t31495 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31495 = (function (fn_handler,f,meta31496){
this.fn_handler = fn_handler;
this.f = f;
this.meta31496 = meta31496;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31495.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31497,meta31496__$1){
var self__ = this;
var _31497__$1 = this;
return (new cljs.core.async.t31495(self__.fn_handler,self__.f,meta31496__$1));
});

cljs.core.async.t31495.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31497){
var self__ = this;
var _31497__$1 = this;
return self__.meta31496;
});

cljs.core.async.t31495.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t31495.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t31495.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t31495.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta31496","meta31496",892431758,null)], null);
});

cljs.core.async.t31495.cljs$lang$type = true;

cljs.core.async.t31495.cljs$lang$ctorStr = "cljs.core.async/t31495";

cljs.core.async.t31495.cljs$lang$ctorPrWriter = (function (this__19107__auto__,writer__19108__auto__,opt__19109__auto__){
return cljs.core._write.call(null,writer__19108__auto__,"cljs.core.async/t31495");
});

cljs.core.async.__GT_t31495 = (function cljs$core$async$fn_handler_$___GT_t31495(fn_handler__$1,f__$1,meta31496){
return (new cljs.core.async.t31495(fn_handler__$1,f__$1,meta31496));
});

}

return (new cljs.core.async.t31495(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var args31500 = [];
var len__19567__auto___31503 = arguments.length;
var i__19568__auto___31504 = (0);
while(true){
if((i__19568__auto___31504 < len__19567__auto___31503)){
args31500.push((arguments[i__19568__auto___31504]));

var G__31505 = (i__19568__auto___31504 + (1));
i__19568__auto___31504 = G__31505;
continue;
} else {
}
break;
}

var G__31502 = args31500.length;
switch (G__31502) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31500.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var args31507 = [];
var len__19567__auto___31510 = arguments.length;
var i__19568__auto___31511 = (0);
while(true){
if((i__19568__auto___31511 < len__19567__auto___31510)){
args31507.push((arguments[i__19568__auto___31511]));

var G__31512 = (i__19568__auto___31511 + (1));
i__19568__auto___31511 = G__31512;
continue;
} else {
}
break;
}

var G__31509 = args31507.length;
switch (G__31509) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31507.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_31514 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_31514);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_31514,ret){
return (function (){
return fn1.call(null,val_31514);
});})(val_31514,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var args31515 = [];
var len__19567__auto___31518 = arguments.length;
var i__19568__auto___31519 = (0);
while(true){
if((i__19568__auto___31519 < len__19567__auto___31518)){
args31515.push((arguments[i__19568__auto___31519]));

var G__31520 = (i__19568__auto___31519 + (1));
i__19568__auto___31519 = G__31520;
continue;
} else {
}
break;
}

var G__31517 = args31515.length;
switch (G__31517) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31515.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__19412__auto___31522 = n;
var x_31523 = (0);
while(true){
if((x_31523 < n__19412__auto___31522)){
(a[x_31523] = (0));

var G__31524 = (x_31523 + (1));
x_31523 = G__31524;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__31525 = (i + (1));
i = G__31525;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t31529 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31529 = (function (alt_flag,flag,meta31530){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta31530 = meta31530;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31529.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31531,meta31530__$1){
var self__ = this;
var _31531__$1 = this;
return (new cljs.core.async.t31529(self__.alt_flag,self__.flag,meta31530__$1));
});})(flag))
;

cljs.core.async.t31529.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31531){
var self__ = this;
var _31531__$1 = this;
return self__.meta31530;
});})(flag))
;

cljs.core.async.t31529.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t31529.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t31529.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t31529.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31530","meta31530",586508120,null)], null);
});})(flag))
;

cljs.core.async.t31529.cljs$lang$type = true;

cljs.core.async.t31529.cljs$lang$ctorStr = "cljs.core.async/t31529";

cljs.core.async.t31529.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__19107__auto__,writer__19108__auto__,opt__19109__auto__){
return cljs.core._write.call(null,writer__19108__auto__,"cljs.core.async/t31529");
});})(flag))
;

cljs.core.async.__GT_t31529 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t31529(alt_flag__$1,flag__$1,meta31530){
return (new cljs.core.async.t31529(alt_flag__$1,flag__$1,meta31530));
});})(flag))
;

}

return (new cljs.core.async.t31529(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t31535 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31535 = (function (alt_handler,flag,cb,meta31536){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta31536 = meta31536;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31535.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31537,meta31536__$1){
var self__ = this;
var _31537__$1 = this;
return (new cljs.core.async.t31535(self__.alt_handler,self__.flag,self__.cb,meta31536__$1));
});

cljs.core.async.t31535.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31537){
var self__ = this;
var _31537__$1 = this;
return self__.meta31536;
});

cljs.core.async.t31535.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t31535.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t31535.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t31535.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31536","meta31536",-781438679,null)], null);
});

cljs.core.async.t31535.cljs$lang$type = true;

cljs.core.async.t31535.cljs$lang$ctorStr = "cljs.core.async/t31535";

cljs.core.async.t31535.cljs$lang$ctorPrWriter = (function (this__19107__auto__,writer__19108__auto__,opt__19109__auto__){
return cljs.core._write.call(null,writer__19108__auto__,"cljs.core.async/t31535");
});

cljs.core.async.__GT_t31535 = (function cljs$core$async$alt_handler_$___GT_t31535(alt_handler__$1,flag__$1,cb__$1,meta31536){
return (new cljs.core.async.t31535(alt_handler__$1,flag__$1,cb__$1,meta31536));
});

}

return (new cljs.core.async.t31535(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31538_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31538_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31539_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31539_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__18528__auto__ = wport;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31540 = (i + (1));
i = G__31540;
continue;
}
} else {
return null;
}
break;
}
})();
var or__18528__auto__ = ret;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__18516__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__18516__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__18516__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var args__19574__auto__ = [];
var len__19567__auto___31546 = arguments.length;
var i__19568__auto___31547 = (0);
while(true){
if((i__19568__auto___31547 < len__19567__auto___31546)){
args__19574__auto__.push((arguments[i__19568__auto___31547]));

var G__31548 = (i__19568__auto___31547 + (1));
i__19568__auto___31547 = G__31548;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31543){
var map__31544 = p__31543;
var map__31544__$1 = ((((!((map__31544 == null)))?((((map__31544.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31544.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31544):map__31544);
var opts = map__31544__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31541){
var G__31542 = cljs.core.first.call(null,seq31541);
var seq31541__$1 = cljs.core.next.call(null,seq31541);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31542,seq31541__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var args31549 = [];
var len__19567__auto___31599 = arguments.length;
var i__19568__auto___31600 = (0);
while(true){
if((i__19568__auto___31600 < len__19567__auto___31599)){
args31549.push((arguments[i__19568__auto___31600]));

var G__31601 = (i__19568__auto___31600 + (1));
i__19568__auto___31600 = G__31601;
continue;
} else {
}
break;
}

var G__31551 = args31549.length;
switch (G__31551) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31549.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__23999__auto___31603 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___31603){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___31603){
return (function (state_31575){
var state_val_31576 = (state_31575[(1)]);
if((state_val_31576 === (7))){
var inst_31571 = (state_31575[(2)]);
var state_31575__$1 = state_31575;
var statearr_31577_31604 = state_31575__$1;
(statearr_31577_31604[(2)] = inst_31571);

(statearr_31577_31604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31576 === (1))){
var state_31575__$1 = state_31575;
var statearr_31578_31605 = state_31575__$1;
(statearr_31578_31605[(2)] = null);

(statearr_31578_31605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31576 === (4))){
var inst_31554 = (state_31575[(7)]);
var inst_31554__$1 = (state_31575[(2)]);
var inst_31555 = (inst_31554__$1 == null);
var state_31575__$1 = (function (){var statearr_31579 = state_31575;
(statearr_31579[(7)] = inst_31554__$1);

return statearr_31579;
})();
if(cljs.core.truth_(inst_31555)){
var statearr_31580_31606 = state_31575__$1;
(statearr_31580_31606[(1)] = (5));

} else {
var statearr_31581_31607 = state_31575__$1;
(statearr_31581_31607[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31576 === (13))){
var state_31575__$1 = state_31575;
var statearr_31582_31608 = state_31575__$1;
(statearr_31582_31608[(2)] = null);

(statearr_31582_31608[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31576 === (6))){
var inst_31554 = (state_31575[(7)]);
var state_31575__$1 = state_31575;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31575__$1,(11),to,inst_31554);
} else {
if((state_val_31576 === (3))){
var inst_31573 = (state_31575[(2)]);
var state_31575__$1 = state_31575;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31575__$1,inst_31573);
} else {
if((state_val_31576 === (12))){
var state_31575__$1 = state_31575;
var statearr_31583_31609 = state_31575__$1;
(statearr_31583_31609[(2)] = null);

(statearr_31583_31609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31576 === (2))){
var state_31575__$1 = state_31575;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31575__$1,(4),from);
} else {
if((state_val_31576 === (11))){
var inst_31564 = (state_31575[(2)]);
var state_31575__$1 = state_31575;
if(cljs.core.truth_(inst_31564)){
var statearr_31584_31610 = state_31575__$1;
(statearr_31584_31610[(1)] = (12));

} else {
var statearr_31585_31611 = state_31575__$1;
(statearr_31585_31611[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31576 === (9))){
var state_31575__$1 = state_31575;
var statearr_31586_31612 = state_31575__$1;
(statearr_31586_31612[(2)] = null);

(statearr_31586_31612[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31576 === (5))){
var state_31575__$1 = state_31575;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31587_31613 = state_31575__$1;
(statearr_31587_31613[(1)] = (8));

} else {
var statearr_31588_31614 = state_31575__$1;
(statearr_31588_31614[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31576 === (14))){
var inst_31569 = (state_31575[(2)]);
var state_31575__$1 = state_31575;
var statearr_31589_31615 = state_31575__$1;
(statearr_31589_31615[(2)] = inst_31569);

(statearr_31589_31615[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31576 === (10))){
var inst_31561 = (state_31575[(2)]);
var state_31575__$1 = state_31575;
var statearr_31590_31616 = state_31575__$1;
(statearr_31590_31616[(2)] = inst_31561);

(statearr_31590_31616[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31576 === (8))){
var inst_31558 = cljs.core.async.close_BANG_.call(null,to);
var state_31575__$1 = state_31575;
var statearr_31591_31617 = state_31575__$1;
(statearr_31591_31617[(2)] = inst_31558);

(statearr_31591_31617[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___31603))
;
return ((function (switch__23984__auto__,c__23999__auto___31603){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_31595 = [null,null,null,null,null,null,null,null];
(statearr_31595[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_31595[(1)] = (1));

return statearr_31595;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_31575){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_31575);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e31596){if((e31596 instanceof Object)){
var ex__23988__auto__ = e31596;
var statearr_31597_31618 = state_31575;
(statearr_31597_31618[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31575);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31596;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31619 = state_31575;
state_31575 = G__31619;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_31575){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_31575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___31603))
})();
var state__24001__auto__ = (function (){var statearr_31598 = f__24000__auto__.call(null);
(statearr_31598[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___31603);

return statearr_31598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___31603))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__31803){
var vec__31804 = p__31803;
var v = cljs.core.nth.call(null,vec__31804,(0),null);
var p = cljs.core.nth.call(null,vec__31804,(1),null);
var job = vec__31804;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__23999__auto___31986 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___31986,res,vec__31804,v,p,job,jobs,results){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___31986,res,vec__31804,v,p,job,jobs,results){
return (function (state_31809){
var state_val_31810 = (state_31809[(1)]);
if((state_val_31810 === (1))){
var state_31809__$1 = state_31809;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31809__$1,(2),res,v);
} else {
if((state_val_31810 === (2))){
var inst_31806 = (state_31809[(2)]);
var inst_31807 = cljs.core.async.close_BANG_.call(null,res);
var state_31809__$1 = (function (){var statearr_31811 = state_31809;
(statearr_31811[(7)] = inst_31806);

return statearr_31811;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31809__$1,inst_31807);
} else {
return null;
}
}
});})(c__23999__auto___31986,res,vec__31804,v,p,job,jobs,results))
;
return ((function (switch__23984__auto__,c__23999__auto___31986,res,vec__31804,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0 = (function (){
var statearr_31815 = [null,null,null,null,null,null,null,null];
(statearr_31815[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__);

(statearr_31815[(1)] = (1));

return statearr_31815;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1 = (function (state_31809){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_31809);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e31816){if((e31816 instanceof Object)){
var ex__23988__auto__ = e31816;
var statearr_31817_31987 = state_31809;
(statearr_31817_31987[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31809);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31816;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31988 = state_31809;
state_31809 = G__31988;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__ = function(state_31809){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1.call(this,state_31809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___31986,res,vec__31804,v,p,job,jobs,results))
})();
var state__24001__auto__ = (function (){var statearr_31818 = f__24000__auto__.call(null);
(statearr_31818[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___31986);

return statearr_31818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___31986,res,vec__31804,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31819){
var vec__31820 = p__31819;
var v = cljs.core.nth.call(null,vec__31820,(0),null);
var p = cljs.core.nth.call(null,vec__31820,(1),null);
var job = vec__31820;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__19412__auto___31989 = n;
var __31990 = (0);
while(true){
if((__31990 < n__19412__auto___31989)){
var G__31821_31991 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__31821_31991) {
case "compute":
var c__23999__auto___31993 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31990,c__23999__auto___31993,G__31821_31991,n__19412__auto___31989,jobs,results,process,async){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (__31990,c__23999__auto___31993,G__31821_31991,n__19412__auto___31989,jobs,results,process,async){
return (function (state_31834){
var state_val_31835 = (state_31834[(1)]);
if((state_val_31835 === (1))){
var state_31834__$1 = state_31834;
var statearr_31836_31994 = state_31834__$1;
(statearr_31836_31994[(2)] = null);

(statearr_31836_31994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31835 === (2))){
var state_31834__$1 = state_31834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31834__$1,(4),jobs);
} else {
if((state_val_31835 === (3))){
var inst_31832 = (state_31834[(2)]);
var state_31834__$1 = state_31834;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31834__$1,inst_31832);
} else {
if((state_val_31835 === (4))){
var inst_31824 = (state_31834[(2)]);
var inst_31825 = process.call(null,inst_31824);
var state_31834__$1 = state_31834;
if(cljs.core.truth_(inst_31825)){
var statearr_31837_31995 = state_31834__$1;
(statearr_31837_31995[(1)] = (5));

} else {
var statearr_31838_31996 = state_31834__$1;
(statearr_31838_31996[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31835 === (5))){
var state_31834__$1 = state_31834;
var statearr_31839_31997 = state_31834__$1;
(statearr_31839_31997[(2)] = null);

(statearr_31839_31997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31835 === (6))){
var state_31834__$1 = state_31834;
var statearr_31840_31998 = state_31834__$1;
(statearr_31840_31998[(2)] = null);

(statearr_31840_31998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31835 === (7))){
var inst_31830 = (state_31834[(2)]);
var state_31834__$1 = state_31834;
var statearr_31841_31999 = state_31834__$1;
(statearr_31841_31999[(2)] = inst_31830);

(statearr_31841_31999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31990,c__23999__auto___31993,G__31821_31991,n__19412__auto___31989,jobs,results,process,async))
;
return ((function (__31990,switch__23984__auto__,c__23999__auto___31993,G__31821_31991,n__19412__auto___31989,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0 = (function (){
var statearr_31845 = [null,null,null,null,null,null,null];
(statearr_31845[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__);

(statearr_31845[(1)] = (1));

return statearr_31845;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1 = (function (state_31834){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_31834);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e31846){if((e31846 instanceof Object)){
var ex__23988__auto__ = e31846;
var statearr_31847_32000 = state_31834;
(statearr_31847_32000[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31834);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31846;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32001 = state_31834;
state_31834 = G__32001;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__ = function(state_31834){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1.call(this,state_31834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__;
})()
;})(__31990,switch__23984__auto__,c__23999__auto___31993,G__31821_31991,n__19412__auto___31989,jobs,results,process,async))
})();
var state__24001__auto__ = (function (){var statearr_31848 = f__24000__auto__.call(null);
(statearr_31848[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___31993);

return statearr_31848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(__31990,c__23999__auto___31993,G__31821_31991,n__19412__auto___31989,jobs,results,process,async))
);


break;
case "async":
var c__23999__auto___32002 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31990,c__23999__auto___32002,G__31821_31991,n__19412__auto___31989,jobs,results,process,async){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (__31990,c__23999__auto___32002,G__31821_31991,n__19412__auto___31989,jobs,results,process,async){
return (function (state_31861){
var state_val_31862 = (state_31861[(1)]);
if((state_val_31862 === (1))){
var state_31861__$1 = state_31861;
var statearr_31863_32003 = state_31861__$1;
(statearr_31863_32003[(2)] = null);

(statearr_31863_32003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31862 === (2))){
var state_31861__$1 = state_31861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31861__$1,(4),jobs);
} else {
if((state_val_31862 === (3))){
var inst_31859 = (state_31861[(2)]);
var state_31861__$1 = state_31861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31861__$1,inst_31859);
} else {
if((state_val_31862 === (4))){
var inst_31851 = (state_31861[(2)]);
var inst_31852 = async.call(null,inst_31851);
var state_31861__$1 = state_31861;
if(cljs.core.truth_(inst_31852)){
var statearr_31864_32004 = state_31861__$1;
(statearr_31864_32004[(1)] = (5));

} else {
var statearr_31865_32005 = state_31861__$1;
(statearr_31865_32005[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31862 === (5))){
var state_31861__$1 = state_31861;
var statearr_31866_32006 = state_31861__$1;
(statearr_31866_32006[(2)] = null);

(statearr_31866_32006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31862 === (6))){
var state_31861__$1 = state_31861;
var statearr_31867_32007 = state_31861__$1;
(statearr_31867_32007[(2)] = null);

(statearr_31867_32007[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31862 === (7))){
var inst_31857 = (state_31861[(2)]);
var state_31861__$1 = state_31861;
var statearr_31868_32008 = state_31861__$1;
(statearr_31868_32008[(2)] = inst_31857);

(statearr_31868_32008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31990,c__23999__auto___32002,G__31821_31991,n__19412__auto___31989,jobs,results,process,async))
;
return ((function (__31990,switch__23984__auto__,c__23999__auto___32002,G__31821_31991,n__19412__auto___31989,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0 = (function (){
var statearr_31872 = [null,null,null,null,null,null,null];
(statearr_31872[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__);

(statearr_31872[(1)] = (1));

return statearr_31872;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1 = (function (state_31861){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_31861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e31873){if((e31873 instanceof Object)){
var ex__23988__auto__ = e31873;
var statearr_31874_32009 = state_31861;
(statearr_31874_32009[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31861);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31873;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32010 = state_31861;
state_31861 = G__32010;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__ = function(state_31861){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1.call(this,state_31861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__;
})()
;})(__31990,switch__23984__auto__,c__23999__auto___32002,G__31821_31991,n__19412__auto___31989,jobs,results,process,async))
})();
var state__24001__auto__ = (function (){var statearr_31875 = f__24000__auto__.call(null);
(statearr_31875[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___32002);

return statearr_31875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(__31990,c__23999__auto___32002,G__31821_31991,n__19412__auto___31989,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__32011 = (__31990 + (1));
__31990 = G__32011;
continue;
} else {
}
break;
}

var c__23999__auto___32012 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___32012,jobs,results,process,async){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___32012,jobs,results,process,async){
return (function (state_31897){
var state_val_31898 = (state_31897[(1)]);
if((state_val_31898 === (1))){
var state_31897__$1 = state_31897;
var statearr_31899_32013 = state_31897__$1;
(statearr_31899_32013[(2)] = null);

(statearr_31899_32013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (2))){
var state_31897__$1 = state_31897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31897__$1,(4),from);
} else {
if((state_val_31898 === (3))){
var inst_31895 = (state_31897[(2)]);
var state_31897__$1 = state_31897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31897__$1,inst_31895);
} else {
if((state_val_31898 === (4))){
var inst_31878 = (state_31897[(7)]);
var inst_31878__$1 = (state_31897[(2)]);
var inst_31879 = (inst_31878__$1 == null);
var state_31897__$1 = (function (){var statearr_31900 = state_31897;
(statearr_31900[(7)] = inst_31878__$1);

return statearr_31900;
})();
if(cljs.core.truth_(inst_31879)){
var statearr_31901_32014 = state_31897__$1;
(statearr_31901_32014[(1)] = (5));

} else {
var statearr_31902_32015 = state_31897__$1;
(statearr_31902_32015[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (5))){
var inst_31881 = cljs.core.async.close_BANG_.call(null,jobs);
var state_31897__$1 = state_31897;
var statearr_31903_32016 = state_31897__$1;
(statearr_31903_32016[(2)] = inst_31881);

(statearr_31903_32016[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (6))){
var inst_31883 = (state_31897[(8)]);
var inst_31878 = (state_31897[(7)]);
var inst_31883__$1 = cljs.core.async.chan.call(null,(1));
var inst_31884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31885 = [inst_31878,inst_31883__$1];
var inst_31886 = (new cljs.core.PersistentVector(null,2,(5),inst_31884,inst_31885,null));
var state_31897__$1 = (function (){var statearr_31904 = state_31897;
(statearr_31904[(8)] = inst_31883__$1);

return statearr_31904;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31897__$1,(8),jobs,inst_31886);
} else {
if((state_val_31898 === (7))){
var inst_31893 = (state_31897[(2)]);
var state_31897__$1 = state_31897;
var statearr_31905_32017 = state_31897__$1;
(statearr_31905_32017[(2)] = inst_31893);

(statearr_31905_32017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (8))){
var inst_31883 = (state_31897[(8)]);
var inst_31888 = (state_31897[(2)]);
var state_31897__$1 = (function (){var statearr_31906 = state_31897;
(statearr_31906[(9)] = inst_31888);

return statearr_31906;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31897__$1,(9),results,inst_31883);
} else {
if((state_val_31898 === (9))){
var inst_31890 = (state_31897[(2)]);
var state_31897__$1 = (function (){var statearr_31907 = state_31897;
(statearr_31907[(10)] = inst_31890);

return statearr_31907;
})();
var statearr_31908_32018 = state_31897__$1;
(statearr_31908_32018[(2)] = null);

(statearr_31908_32018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___32012,jobs,results,process,async))
;
return ((function (switch__23984__auto__,c__23999__auto___32012,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0 = (function (){
var statearr_31912 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31912[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__);

(statearr_31912[(1)] = (1));

return statearr_31912;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1 = (function (state_31897){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_31897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e31913){if((e31913 instanceof Object)){
var ex__23988__auto__ = e31913;
var statearr_31914_32019 = state_31897;
(statearr_31914_32019[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31897);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31913;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32020 = state_31897;
state_31897 = G__32020;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__ = function(state_31897){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1.call(this,state_31897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___32012,jobs,results,process,async))
})();
var state__24001__auto__ = (function (){var statearr_31915 = f__24000__auto__.call(null);
(statearr_31915[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___32012);

return statearr_31915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___32012,jobs,results,process,async))
);


var c__23999__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto__,jobs,results,process,async){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto__,jobs,results,process,async){
return (function (state_31953){
var state_val_31954 = (state_31953[(1)]);
if((state_val_31954 === (7))){
var inst_31949 = (state_31953[(2)]);
var state_31953__$1 = state_31953;
var statearr_31955_32021 = state_31953__$1;
(statearr_31955_32021[(2)] = inst_31949);

(statearr_31955_32021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (20))){
var state_31953__$1 = state_31953;
var statearr_31956_32022 = state_31953__$1;
(statearr_31956_32022[(2)] = null);

(statearr_31956_32022[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (1))){
var state_31953__$1 = state_31953;
var statearr_31957_32023 = state_31953__$1;
(statearr_31957_32023[(2)] = null);

(statearr_31957_32023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (4))){
var inst_31918 = (state_31953[(7)]);
var inst_31918__$1 = (state_31953[(2)]);
var inst_31919 = (inst_31918__$1 == null);
var state_31953__$1 = (function (){var statearr_31958 = state_31953;
(statearr_31958[(7)] = inst_31918__$1);

return statearr_31958;
})();
if(cljs.core.truth_(inst_31919)){
var statearr_31959_32024 = state_31953__$1;
(statearr_31959_32024[(1)] = (5));

} else {
var statearr_31960_32025 = state_31953__$1;
(statearr_31960_32025[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (15))){
var inst_31931 = (state_31953[(8)]);
var state_31953__$1 = state_31953;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31953__$1,(18),to,inst_31931);
} else {
if((state_val_31954 === (21))){
var inst_31944 = (state_31953[(2)]);
var state_31953__$1 = state_31953;
var statearr_31961_32026 = state_31953__$1;
(statearr_31961_32026[(2)] = inst_31944);

(statearr_31961_32026[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (13))){
var inst_31946 = (state_31953[(2)]);
var state_31953__$1 = (function (){var statearr_31962 = state_31953;
(statearr_31962[(9)] = inst_31946);

return statearr_31962;
})();
var statearr_31963_32027 = state_31953__$1;
(statearr_31963_32027[(2)] = null);

(statearr_31963_32027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (6))){
var inst_31918 = (state_31953[(7)]);
var state_31953__$1 = state_31953;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31953__$1,(11),inst_31918);
} else {
if((state_val_31954 === (17))){
var inst_31939 = (state_31953[(2)]);
var state_31953__$1 = state_31953;
if(cljs.core.truth_(inst_31939)){
var statearr_31964_32028 = state_31953__$1;
(statearr_31964_32028[(1)] = (19));

} else {
var statearr_31965_32029 = state_31953__$1;
(statearr_31965_32029[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (3))){
var inst_31951 = (state_31953[(2)]);
var state_31953__$1 = state_31953;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31953__$1,inst_31951);
} else {
if((state_val_31954 === (12))){
var inst_31928 = (state_31953[(10)]);
var state_31953__$1 = state_31953;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31953__$1,(14),inst_31928);
} else {
if((state_val_31954 === (2))){
var state_31953__$1 = state_31953;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31953__$1,(4),results);
} else {
if((state_val_31954 === (19))){
var state_31953__$1 = state_31953;
var statearr_31966_32030 = state_31953__$1;
(statearr_31966_32030[(2)] = null);

(statearr_31966_32030[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (11))){
var inst_31928 = (state_31953[(2)]);
var state_31953__$1 = (function (){var statearr_31967 = state_31953;
(statearr_31967[(10)] = inst_31928);

return statearr_31967;
})();
var statearr_31968_32031 = state_31953__$1;
(statearr_31968_32031[(2)] = null);

(statearr_31968_32031[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (9))){
var state_31953__$1 = state_31953;
var statearr_31969_32032 = state_31953__$1;
(statearr_31969_32032[(2)] = null);

(statearr_31969_32032[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (5))){
var state_31953__$1 = state_31953;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31970_32033 = state_31953__$1;
(statearr_31970_32033[(1)] = (8));

} else {
var statearr_31971_32034 = state_31953__$1;
(statearr_31971_32034[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (14))){
var inst_31933 = (state_31953[(11)]);
var inst_31931 = (state_31953[(8)]);
var inst_31931__$1 = (state_31953[(2)]);
var inst_31932 = (inst_31931__$1 == null);
var inst_31933__$1 = cljs.core.not.call(null,inst_31932);
var state_31953__$1 = (function (){var statearr_31972 = state_31953;
(statearr_31972[(11)] = inst_31933__$1);

(statearr_31972[(8)] = inst_31931__$1);

return statearr_31972;
})();
if(inst_31933__$1){
var statearr_31973_32035 = state_31953__$1;
(statearr_31973_32035[(1)] = (15));

} else {
var statearr_31974_32036 = state_31953__$1;
(statearr_31974_32036[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (16))){
var inst_31933 = (state_31953[(11)]);
var state_31953__$1 = state_31953;
var statearr_31975_32037 = state_31953__$1;
(statearr_31975_32037[(2)] = inst_31933);

(statearr_31975_32037[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (10))){
var inst_31925 = (state_31953[(2)]);
var state_31953__$1 = state_31953;
var statearr_31976_32038 = state_31953__$1;
(statearr_31976_32038[(2)] = inst_31925);

(statearr_31976_32038[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (18))){
var inst_31936 = (state_31953[(2)]);
var state_31953__$1 = state_31953;
var statearr_31977_32039 = state_31953__$1;
(statearr_31977_32039[(2)] = inst_31936);

(statearr_31977_32039[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (8))){
var inst_31922 = cljs.core.async.close_BANG_.call(null,to);
var state_31953__$1 = state_31953;
var statearr_31978_32040 = state_31953__$1;
(statearr_31978_32040[(2)] = inst_31922);

(statearr_31978_32040[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto__,jobs,results,process,async))
;
return ((function (switch__23984__auto__,c__23999__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0 = (function (){
var statearr_31982 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31982[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__);

(statearr_31982[(1)] = (1));

return statearr_31982;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1 = (function (state_31953){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_31953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e31983){if((e31983 instanceof Object)){
var ex__23988__auto__ = e31983;
var statearr_31984_32041 = state_31953;
(statearr_31984_32041[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31953);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31983;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32042 = state_31953;
state_31953 = G__32042;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__ = function(state_31953){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1.call(this,state_31953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23985__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto__,jobs,results,process,async))
})();
var state__24001__auto__ = (function (){var statearr_31985 = f__24000__auto__.call(null);
(statearr_31985[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto__);

return statearr_31985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto__,jobs,results,process,async))
);

return c__23999__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var args32043 = [];
var len__19567__auto___32046 = arguments.length;
var i__19568__auto___32047 = (0);
while(true){
if((i__19568__auto___32047 < len__19567__auto___32046)){
args32043.push((arguments[i__19568__auto___32047]));

var G__32048 = (i__19568__auto___32047 + (1));
i__19568__auto___32047 = G__32048;
continue;
} else {
}
break;
}

var G__32045 = args32043.length;
switch (G__32045) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32043.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var args32050 = [];
var len__19567__auto___32053 = arguments.length;
var i__19568__auto___32054 = (0);
while(true){
if((i__19568__auto___32054 < len__19567__auto___32053)){
args32050.push((arguments[i__19568__auto___32054]));

var G__32055 = (i__19568__auto___32054 + (1));
i__19568__auto___32054 = G__32055;
continue;
} else {
}
break;
}

var G__32052 = args32050.length;
switch (G__32052) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32050.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var args32057 = [];
var len__19567__auto___32110 = arguments.length;
var i__19568__auto___32111 = (0);
while(true){
if((i__19568__auto___32111 < len__19567__auto___32110)){
args32057.push((arguments[i__19568__auto___32111]));

var G__32112 = (i__19568__auto___32111 + (1));
i__19568__auto___32111 = G__32112;
continue;
} else {
}
break;
}

var G__32059 = args32057.length;
switch (G__32059) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32057.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__23999__auto___32114 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___32114,tc,fc){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___32114,tc,fc){
return (function (state_32085){
var state_val_32086 = (state_32085[(1)]);
if((state_val_32086 === (7))){
var inst_32081 = (state_32085[(2)]);
var state_32085__$1 = state_32085;
var statearr_32087_32115 = state_32085__$1;
(statearr_32087_32115[(2)] = inst_32081);

(statearr_32087_32115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32086 === (1))){
var state_32085__$1 = state_32085;
var statearr_32088_32116 = state_32085__$1;
(statearr_32088_32116[(2)] = null);

(statearr_32088_32116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32086 === (4))){
var inst_32062 = (state_32085[(7)]);
var inst_32062__$1 = (state_32085[(2)]);
var inst_32063 = (inst_32062__$1 == null);
var state_32085__$1 = (function (){var statearr_32089 = state_32085;
(statearr_32089[(7)] = inst_32062__$1);

return statearr_32089;
})();
if(cljs.core.truth_(inst_32063)){
var statearr_32090_32117 = state_32085__$1;
(statearr_32090_32117[(1)] = (5));

} else {
var statearr_32091_32118 = state_32085__$1;
(statearr_32091_32118[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32086 === (13))){
var state_32085__$1 = state_32085;
var statearr_32092_32119 = state_32085__$1;
(statearr_32092_32119[(2)] = null);

(statearr_32092_32119[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32086 === (6))){
var inst_32062 = (state_32085[(7)]);
var inst_32068 = p.call(null,inst_32062);
var state_32085__$1 = state_32085;
if(cljs.core.truth_(inst_32068)){
var statearr_32093_32120 = state_32085__$1;
(statearr_32093_32120[(1)] = (9));

} else {
var statearr_32094_32121 = state_32085__$1;
(statearr_32094_32121[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32086 === (3))){
var inst_32083 = (state_32085[(2)]);
var state_32085__$1 = state_32085;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32085__$1,inst_32083);
} else {
if((state_val_32086 === (12))){
var state_32085__$1 = state_32085;
var statearr_32095_32122 = state_32085__$1;
(statearr_32095_32122[(2)] = null);

(statearr_32095_32122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32086 === (2))){
var state_32085__$1 = state_32085;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32085__$1,(4),ch);
} else {
if((state_val_32086 === (11))){
var inst_32062 = (state_32085[(7)]);
var inst_32072 = (state_32085[(2)]);
var state_32085__$1 = state_32085;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32085__$1,(8),inst_32072,inst_32062);
} else {
if((state_val_32086 === (9))){
var state_32085__$1 = state_32085;
var statearr_32096_32123 = state_32085__$1;
(statearr_32096_32123[(2)] = tc);

(statearr_32096_32123[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32086 === (5))){
var inst_32065 = cljs.core.async.close_BANG_.call(null,tc);
var inst_32066 = cljs.core.async.close_BANG_.call(null,fc);
var state_32085__$1 = (function (){var statearr_32097 = state_32085;
(statearr_32097[(8)] = inst_32065);

return statearr_32097;
})();
var statearr_32098_32124 = state_32085__$1;
(statearr_32098_32124[(2)] = inst_32066);

(statearr_32098_32124[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32086 === (14))){
var inst_32079 = (state_32085[(2)]);
var state_32085__$1 = state_32085;
var statearr_32099_32125 = state_32085__$1;
(statearr_32099_32125[(2)] = inst_32079);

(statearr_32099_32125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32086 === (10))){
var state_32085__$1 = state_32085;
var statearr_32100_32126 = state_32085__$1;
(statearr_32100_32126[(2)] = fc);

(statearr_32100_32126[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32086 === (8))){
var inst_32074 = (state_32085[(2)]);
var state_32085__$1 = state_32085;
if(cljs.core.truth_(inst_32074)){
var statearr_32101_32127 = state_32085__$1;
(statearr_32101_32127[(1)] = (12));

} else {
var statearr_32102_32128 = state_32085__$1;
(statearr_32102_32128[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___32114,tc,fc))
;
return ((function (switch__23984__auto__,c__23999__auto___32114,tc,fc){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_32106 = [null,null,null,null,null,null,null,null,null];
(statearr_32106[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_32106[(1)] = (1));

return statearr_32106;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_32085){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_32085);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e32107){if((e32107 instanceof Object)){
var ex__23988__auto__ = e32107;
var statearr_32108_32129 = state_32085;
(statearr_32108_32129[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32085);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32107;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32130 = state_32085;
state_32085 = G__32130;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_32085){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_32085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___32114,tc,fc))
})();
var state__24001__auto__ = (function (){var statearr_32109 = f__24000__auto__.call(null);
(statearr_32109[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___32114);

return statearr_32109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___32114,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__23999__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto__){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto__){
return (function (state_32177){
var state_val_32178 = (state_32177[(1)]);
if((state_val_32178 === (1))){
var inst_32163 = init;
var state_32177__$1 = (function (){var statearr_32179 = state_32177;
(statearr_32179[(7)] = inst_32163);

return statearr_32179;
})();
var statearr_32180_32195 = state_32177__$1;
(statearr_32180_32195[(2)] = null);

(statearr_32180_32195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32178 === (2))){
var state_32177__$1 = state_32177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32177__$1,(4),ch);
} else {
if((state_val_32178 === (3))){
var inst_32175 = (state_32177[(2)]);
var state_32177__$1 = state_32177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32177__$1,inst_32175);
} else {
if((state_val_32178 === (4))){
var inst_32166 = (state_32177[(8)]);
var inst_32166__$1 = (state_32177[(2)]);
var inst_32167 = (inst_32166__$1 == null);
var state_32177__$1 = (function (){var statearr_32181 = state_32177;
(statearr_32181[(8)] = inst_32166__$1);

return statearr_32181;
})();
if(cljs.core.truth_(inst_32167)){
var statearr_32182_32196 = state_32177__$1;
(statearr_32182_32196[(1)] = (5));

} else {
var statearr_32183_32197 = state_32177__$1;
(statearr_32183_32197[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32178 === (5))){
var inst_32163 = (state_32177[(7)]);
var state_32177__$1 = state_32177;
var statearr_32184_32198 = state_32177__$1;
(statearr_32184_32198[(2)] = inst_32163);

(statearr_32184_32198[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32178 === (6))){
var inst_32163 = (state_32177[(7)]);
var inst_32166 = (state_32177[(8)]);
var inst_32170 = f.call(null,inst_32163,inst_32166);
var inst_32163__$1 = inst_32170;
var state_32177__$1 = (function (){var statearr_32185 = state_32177;
(statearr_32185[(7)] = inst_32163__$1);

return statearr_32185;
})();
var statearr_32186_32199 = state_32177__$1;
(statearr_32186_32199[(2)] = null);

(statearr_32186_32199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32178 === (7))){
var inst_32173 = (state_32177[(2)]);
var state_32177__$1 = state_32177;
var statearr_32187_32200 = state_32177__$1;
(statearr_32187_32200[(2)] = inst_32173);

(statearr_32187_32200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23999__auto__))
;
return ((function (switch__23984__auto__,c__23999__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__23985__auto__ = null;
var cljs$core$async$reduce_$_state_machine__23985__auto____0 = (function (){
var statearr_32191 = [null,null,null,null,null,null,null,null,null];
(statearr_32191[(0)] = cljs$core$async$reduce_$_state_machine__23985__auto__);

(statearr_32191[(1)] = (1));

return statearr_32191;
});
var cljs$core$async$reduce_$_state_machine__23985__auto____1 = (function (state_32177){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_32177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e32192){if((e32192 instanceof Object)){
var ex__23988__auto__ = e32192;
var statearr_32193_32201 = state_32177;
(statearr_32193_32201[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32177);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32192;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32202 = state_32177;
state_32177 = G__32202;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__23985__auto__ = function(state_32177){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__23985__auto____1.call(this,state_32177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__23985__auto____0;
cljs$core$async$reduce_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__23985__auto____1;
return cljs$core$async$reduce_$_state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto__))
})();
var state__24001__auto__ = (function (){var statearr_32194 = f__24000__auto__.call(null);
(statearr_32194[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto__);

return statearr_32194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto__))
);

return c__23999__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var args32203 = [];
var len__19567__auto___32255 = arguments.length;
var i__19568__auto___32256 = (0);
while(true){
if((i__19568__auto___32256 < len__19567__auto___32255)){
args32203.push((arguments[i__19568__auto___32256]));

var G__32257 = (i__19568__auto___32256 + (1));
i__19568__auto___32256 = G__32257;
continue;
} else {
}
break;
}

var G__32205 = args32203.length;
switch (G__32205) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32203.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__23999__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto__){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto__){
return (function (state_32230){
var state_val_32231 = (state_32230[(1)]);
if((state_val_32231 === (7))){
var inst_32212 = (state_32230[(2)]);
var state_32230__$1 = state_32230;
var statearr_32232_32259 = state_32230__$1;
(statearr_32232_32259[(2)] = inst_32212);

(statearr_32232_32259[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32231 === (1))){
var inst_32206 = cljs.core.seq.call(null,coll);
var inst_32207 = inst_32206;
var state_32230__$1 = (function (){var statearr_32233 = state_32230;
(statearr_32233[(7)] = inst_32207);

return statearr_32233;
})();
var statearr_32234_32260 = state_32230__$1;
(statearr_32234_32260[(2)] = null);

(statearr_32234_32260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32231 === (4))){
var inst_32207 = (state_32230[(7)]);
var inst_32210 = cljs.core.first.call(null,inst_32207);
var state_32230__$1 = state_32230;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32230__$1,(7),ch,inst_32210);
} else {
if((state_val_32231 === (13))){
var inst_32224 = (state_32230[(2)]);
var state_32230__$1 = state_32230;
var statearr_32235_32261 = state_32230__$1;
(statearr_32235_32261[(2)] = inst_32224);

(statearr_32235_32261[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32231 === (6))){
var inst_32215 = (state_32230[(2)]);
var state_32230__$1 = state_32230;
if(cljs.core.truth_(inst_32215)){
var statearr_32236_32262 = state_32230__$1;
(statearr_32236_32262[(1)] = (8));

} else {
var statearr_32237_32263 = state_32230__$1;
(statearr_32237_32263[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32231 === (3))){
var inst_32228 = (state_32230[(2)]);
var state_32230__$1 = state_32230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32230__$1,inst_32228);
} else {
if((state_val_32231 === (12))){
var state_32230__$1 = state_32230;
var statearr_32238_32264 = state_32230__$1;
(statearr_32238_32264[(2)] = null);

(statearr_32238_32264[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32231 === (2))){
var inst_32207 = (state_32230[(7)]);
var state_32230__$1 = state_32230;
if(cljs.core.truth_(inst_32207)){
var statearr_32239_32265 = state_32230__$1;
(statearr_32239_32265[(1)] = (4));

} else {
var statearr_32240_32266 = state_32230__$1;
(statearr_32240_32266[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32231 === (11))){
var inst_32221 = cljs.core.async.close_BANG_.call(null,ch);
var state_32230__$1 = state_32230;
var statearr_32241_32267 = state_32230__$1;
(statearr_32241_32267[(2)] = inst_32221);

(statearr_32241_32267[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32231 === (9))){
var state_32230__$1 = state_32230;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32242_32268 = state_32230__$1;
(statearr_32242_32268[(1)] = (11));

} else {
var statearr_32243_32269 = state_32230__$1;
(statearr_32243_32269[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32231 === (5))){
var inst_32207 = (state_32230[(7)]);
var state_32230__$1 = state_32230;
var statearr_32244_32270 = state_32230__$1;
(statearr_32244_32270[(2)] = inst_32207);

(statearr_32244_32270[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32231 === (10))){
var inst_32226 = (state_32230[(2)]);
var state_32230__$1 = state_32230;
var statearr_32245_32271 = state_32230__$1;
(statearr_32245_32271[(2)] = inst_32226);

(statearr_32245_32271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32231 === (8))){
var inst_32207 = (state_32230[(7)]);
var inst_32217 = cljs.core.next.call(null,inst_32207);
var inst_32207__$1 = inst_32217;
var state_32230__$1 = (function (){var statearr_32246 = state_32230;
(statearr_32246[(7)] = inst_32207__$1);

return statearr_32246;
})();
var statearr_32247_32272 = state_32230__$1;
(statearr_32247_32272[(2)] = null);

(statearr_32247_32272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto__))
;
return ((function (switch__23984__auto__,c__23999__auto__){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_32251 = [null,null,null,null,null,null,null,null];
(statearr_32251[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_32251[(1)] = (1));

return statearr_32251;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_32230){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_32230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e32252){if((e32252 instanceof Object)){
var ex__23988__auto__ = e32252;
var statearr_32253_32273 = state_32230;
(statearr_32253_32273[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32230);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32252;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32274 = state_32230;
state_32230 = G__32274;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_32230){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_32230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto__))
})();
var state__24001__auto__ = (function (){var statearr_32254 = f__24000__auto__.call(null);
(statearr_32254[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto__);

return statearr_32254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto__))
);

return c__23999__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = {};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__19164__auto__ = (((_ == null))?null:_);
var m__19165__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,_);
} else {
var m__19165__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


cljs.core.async.Mult = {};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__19164__auto__ = (((m == null))?null:m);
var m__19165__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__19165__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__19164__auto__ = (((m == null))?null:m);
var m__19165__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,m,ch);
} else {
var m__19165__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__19164__auto__ = (((m == null))?null:m);
var m__19165__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,m);
} else {
var m__19165__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t32500 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32500 = (function (mult,ch,cs,meta32501){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta32501 = meta32501;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t32500.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32502,meta32501__$1){
var self__ = this;
var _32502__$1 = this;
return (new cljs.core.async.t32500(self__.mult,self__.ch,self__.cs,meta32501__$1));
});})(cs))
;

cljs.core.async.t32500.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32502){
var self__ = this;
var _32502__$1 = this;
return self__.meta32501;
});})(cs))
;

cljs.core.async.t32500.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t32500.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t32500.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t32500.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t32500.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t32500.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t32500.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta32501","meta32501",-69656207,null)], null);
});})(cs))
;

cljs.core.async.t32500.cljs$lang$type = true;

cljs.core.async.t32500.cljs$lang$ctorStr = "cljs.core.async/t32500";

cljs.core.async.t32500.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__19107__auto__,writer__19108__auto__,opt__19109__auto__){
return cljs.core._write.call(null,writer__19108__auto__,"cljs.core.async/t32500");
});})(cs))
;

cljs.core.async.__GT_t32500 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t32500(mult__$1,ch__$1,cs__$1,meta32501){
return (new cljs.core.async.t32500(mult__$1,ch__$1,cs__$1,meta32501));
});})(cs))
;

}

return (new cljs.core.async.t32500(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__23999__auto___32721 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___32721,cs,m,dchan,dctr,done){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___32721,cs,m,dchan,dctr,done){
return (function (state_32633){
var state_val_32634 = (state_32633[(1)]);
if((state_val_32634 === (7))){
var inst_32629 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32635_32722 = state_32633__$1;
(statearr_32635_32722[(2)] = inst_32629);

(statearr_32635_32722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (20))){
var inst_32534 = (state_32633[(7)]);
var inst_32544 = cljs.core.first.call(null,inst_32534);
var inst_32545 = cljs.core.nth.call(null,inst_32544,(0),null);
var inst_32546 = cljs.core.nth.call(null,inst_32544,(1),null);
var state_32633__$1 = (function (){var statearr_32636 = state_32633;
(statearr_32636[(8)] = inst_32545);

return statearr_32636;
})();
if(cljs.core.truth_(inst_32546)){
var statearr_32637_32723 = state_32633__$1;
(statearr_32637_32723[(1)] = (22));

} else {
var statearr_32638_32724 = state_32633__$1;
(statearr_32638_32724[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (27))){
var inst_32581 = (state_32633[(9)]);
var inst_32574 = (state_32633[(10)]);
var inst_32505 = (state_32633[(11)]);
var inst_32576 = (state_32633[(12)]);
var inst_32581__$1 = cljs.core._nth.call(null,inst_32574,inst_32576);
var inst_32582 = cljs.core.async.put_BANG_.call(null,inst_32581__$1,inst_32505,done);
var state_32633__$1 = (function (){var statearr_32639 = state_32633;
(statearr_32639[(9)] = inst_32581__$1);

return statearr_32639;
})();
if(cljs.core.truth_(inst_32582)){
var statearr_32640_32725 = state_32633__$1;
(statearr_32640_32725[(1)] = (30));

} else {
var statearr_32641_32726 = state_32633__$1;
(statearr_32641_32726[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (1))){
var state_32633__$1 = state_32633;
var statearr_32642_32727 = state_32633__$1;
(statearr_32642_32727[(2)] = null);

(statearr_32642_32727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (24))){
var inst_32534 = (state_32633[(7)]);
var inst_32551 = (state_32633[(2)]);
var inst_32552 = cljs.core.next.call(null,inst_32534);
var inst_32514 = inst_32552;
var inst_32515 = null;
var inst_32516 = (0);
var inst_32517 = (0);
var state_32633__$1 = (function (){var statearr_32643 = state_32633;
(statearr_32643[(13)] = inst_32517);

(statearr_32643[(14)] = inst_32515);

(statearr_32643[(15)] = inst_32514);

(statearr_32643[(16)] = inst_32551);

(statearr_32643[(17)] = inst_32516);

return statearr_32643;
})();
var statearr_32644_32728 = state_32633__$1;
(statearr_32644_32728[(2)] = null);

(statearr_32644_32728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (39))){
var state_32633__$1 = state_32633;
var statearr_32648_32729 = state_32633__$1;
(statearr_32648_32729[(2)] = null);

(statearr_32648_32729[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (4))){
var inst_32505 = (state_32633[(11)]);
var inst_32505__$1 = (state_32633[(2)]);
var inst_32506 = (inst_32505__$1 == null);
var state_32633__$1 = (function (){var statearr_32649 = state_32633;
(statearr_32649[(11)] = inst_32505__$1);

return statearr_32649;
})();
if(cljs.core.truth_(inst_32506)){
var statearr_32650_32730 = state_32633__$1;
(statearr_32650_32730[(1)] = (5));

} else {
var statearr_32651_32731 = state_32633__$1;
(statearr_32651_32731[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (15))){
var inst_32517 = (state_32633[(13)]);
var inst_32515 = (state_32633[(14)]);
var inst_32514 = (state_32633[(15)]);
var inst_32516 = (state_32633[(17)]);
var inst_32530 = (state_32633[(2)]);
var inst_32531 = (inst_32517 + (1));
var tmp32645 = inst_32515;
var tmp32646 = inst_32514;
var tmp32647 = inst_32516;
var inst_32514__$1 = tmp32646;
var inst_32515__$1 = tmp32645;
var inst_32516__$1 = tmp32647;
var inst_32517__$1 = inst_32531;
var state_32633__$1 = (function (){var statearr_32652 = state_32633;
(statearr_32652[(13)] = inst_32517__$1);

(statearr_32652[(14)] = inst_32515__$1);

(statearr_32652[(15)] = inst_32514__$1);

(statearr_32652[(18)] = inst_32530);

(statearr_32652[(17)] = inst_32516__$1);

return statearr_32652;
})();
var statearr_32653_32732 = state_32633__$1;
(statearr_32653_32732[(2)] = null);

(statearr_32653_32732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (21))){
var inst_32555 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32657_32733 = state_32633__$1;
(statearr_32657_32733[(2)] = inst_32555);

(statearr_32657_32733[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (31))){
var inst_32581 = (state_32633[(9)]);
var inst_32585 = done.call(null,null);
var inst_32586 = cljs.core.async.untap_STAR_.call(null,m,inst_32581);
var state_32633__$1 = (function (){var statearr_32658 = state_32633;
(statearr_32658[(19)] = inst_32585);

return statearr_32658;
})();
var statearr_32659_32734 = state_32633__$1;
(statearr_32659_32734[(2)] = inst_32586);

(statearr_32659_32734[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (32))){
var inst_32573 = (state_32633[(20)]);
var inst_32574 = (state_32633[(10)]);
var inst_32575 = (state_32633[(21)]);
var inst_32576 = (state_32633[(12)]);
var inst_32588 = (state_32633[(2)]);
var inst_32589 = (inst_32576 + (1));
var tmp32654 = inst_32573;
var tmp32655 = inst_32574;
var tmp32656 = inst_32575;
var inst_32573__$1 = tmp32654;
var inst_32574__$1 = tmp32655;
var inst_32575__$1 = tmp32656;
var inst_32576__$1 = inst_32589;
var state_32633__$1 = (function (){var statearr_32660 = state_32633;
(statearr_32660[(20)] = inst_32573__$1);

(statearr_32660[(10)] = inst_32574__$1);

(statearr_32660[(21)] = inst_32575__$1);

(statearr_32660[(22)] = inst_32588);

(statearr_32660[(12)] = inst_32576__$1);

return statearr_32660;
})();
var statearr_32661_32735 = state_32633__$1;
(statearr_32661_32735[(2)] = null);

(statearr_32661_32735[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (40))){
var inst_32601 = (state_32633[(23)]);
var inst_32605 = done.call(null,null);
var inst_32606 = cljs.core.async.untap_STAR_.call(null,m,inst_32601);
var state_32633__$1 = (function (){var statearr_32662 = state_32633;
(statearr_32662[(24)] = inst_32605);

return statearr_32662;
})();
var statearr_32663_32736 = state_32633__$1;
(statearr_32663_32736[(2)] = inst_32606);

(statearr_32663_32736[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (33))){
var inst_32592 = (state_32633[(25)]);
var inst_32594 = cljs.core.chunked_seq_QMARK_.call(null,inst_32592);
var state_32633__$1 = state_32633;
if(inst_32594){
var statearr_32664_32737 = state_32633__$1;
(statearr_32664_32737[(1)] = (36));

} else {
var statearr_32665_32738 = state_32633__$1;
(statearr_32665_32738[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (13))){
var inst_32524 = (state_32633[(26)]);
var inst_32527 = cljs.core.async.close_BANG_.call(null,inst_32524);
var state_32633__$1 = state_32633;
var statearr_32666_32739 = state_32633__$1;
(statearr_32666_32739[(2)] = inst_32527);

(statearr_32666_32739[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (22))){
var inst_32545 = (state_32633[(8)]);
var inst_32548 = cljs.core.async.close_BANG_.call(null,inst_32545);
var state_32633__$1 = state_32633;
var statearr_32667_32740 = state_32633__$1;
(statearr_32667_32740[(2)] = inst_32548);

(statearr_32667_32740[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (36))){
var inst_32592 = (state_32633[(25)]);
var inst_32596 = cljs.core.chunk_first.call(null,inst_32592);
var inst_32597 = cljs.core.chunk_rest.call(null,inst_32592);
var inst_32598 = cljs.core.count.call(null,inst_32596);
var inst_32573 = inst_32597;
var inst_32574 = inst_32596;
var inst_32575 = inst_32598;
var inst_32576 = (0);
var state_32633__$1 = (function (){var statearr_32668 = state_32633;
(statearr_32668[(20)] = inst_32573);

(statearr_32668[(10)] = inst_32574);

(statearr_32668[(21)] = inst_32575);

(statearr_32668[(12)] = inst_32576);

return statearr_32668;
})();
var statearr_32669_32741 = state_32633__$1;
(statearr_32669_32741[(2)] = null);

(statearr_32669_32741[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (41))){
var inst_32592 = (state_32633[(25)]);
var inst_32608 = (state_32633[(2)]);
var inst_32609 = cljs.core.next.call(null,inst_32592);
var inst_32573 = inst_32609;
var inst_32574 = null;
var inst_32575 = (0);
var inst_32576 = (0);
var state_32633__$1 = (function (){var statearr_32670 = state_32633;
(statearr_32670[(27)] = inst_32608);

(statearr_32670[(20)] = inst_32573);

(statearr_32670[(10)] = inst_32574);

(statearr_32670[(21)] = inst_32575);

(statearr_32670[(12)] = inst_32576);

return statearr_32670;
})();
var statearr_32671_32742 = state_32633__$1;
(statearr_32671_32742[(2)] = null);

(statearr_32671_32742[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (43))){
var state_32633__$1 = state_32633;
var statearr_32672_32743 = state_32633__$1;
(statearr_32672_32743[(2)] = null);

(statearr_32672_32743[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (29))){
var inst_32617 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32673_32744 = state_32633__$1;
(statearr_32673_32744[(2)] = inst_32617);

(statearr_32673_32744[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (44))){
var inst_32626 = (state_32633[(2)]);
var state_32633__$1 = (function (){var statearr_32674 = state_32633;
(statearr_32674[(28)] = inst_32626);

return statearr_32674;
})();
var statearr_32675_32745 = state_32633__$1;
(statearr_32675_32745[(2)] = null);

(statearr_32675_32745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (6))){
var inst_32565 = (state_32633[(29)]);
var inst_32564 = cljs.core.deref.call(null,cs);
var inst_32565__$1 = cljs.core.keys.call(null,inst_32564);
var inst_32566 = cljs.core.count.call(null,inst_32565__$1);
var inst_32567 = cljs.core.reset_BANG_.call(null,dctr,inst_32566);
var inst_32572 = cljs.core.seq.call(null,inst_32565__$1);
var inst_32573 = inst_32572;
var inst_32574 = null;
var inst_32575 = (0);
var inst_32576 = (0);
var state_32633__$1 = (function (){var statearr_32676 = state_32633;
(statearr_32676[(20)] = inst_32573);

(statearr_32676[(10)] = inst_32574);

(statearr_32676[(21)] = inst_32575);

(statearr_32676[(29)] = inst_32565__$1);

(statearr_32676[(12)] = inst_32576);

(statearr_32676[(30)] = inst_32567);

return statearr_32676;
})();
var statearr_32677_32746 = state_32633__$1;
(statearr_32677_32746[(2)] = null);

(statearr_32677_32746[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (28))){
var inst_32573 = (state_32633[(20)]);
var inst_32592 = (state_32633[(25)]);
var inst_32592__$1 = cljs.core.seq.call(null,inst_32573);
var state_32633__$1 = (function (){var statearr_32678 = state_32633;
(statearr_32678[(25)] = inst_32592__$1);

return statearr_32678;
})();
if(inst_32592__$1){
var statearr_32679_32747 = state_32633__$1;
(statearr_32679_32747[(1)] = (33));

} else {
var statearr_32680_32748 = state_32633__$1;
(statearr_32680_32748[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (25))){
var inst_32575 = (state_32633[(21)]);
var inst_32576 = (state_32633[(12)]);
var inst_32578 = (inst_32576 < inst_32575);
var inst_32579 = inst_32578;
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32579)){
var statearr_32681_32749 = state_32633__$1;
(statearr_32681_32749[(1)] = (27));

} else {
var statearr_32682_32750 = state_32633__$1;
(statearr_32682_32750[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (34))){
var state_32633__$1 = state_32633;
var statearr_32683_32751 = state_32633__$1;
(statearr_32683_32751[(2)] = null);

(statearr_32683_32751[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (17))){
var state_32633__$1 = state_32633;
var statearr_32684_32752 = state_32633__$1;
(statearr_32684_32752[(2)] = null);

(statearr_32684_32752[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (3))){
var inst_32631 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32633__$1,inst_32631);
} else {
if((state_val_32634 === (12))){
var inst_32560 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32685_32753 = state_32633__$1;
(statearr_32685_32753[(2)] = inst_32560);

(statearr_32685_32753[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (2))){
var state_32633__$1 = state_32633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32633__$1,(4),ch);
} else {
if((state_val_32634 === (23))){
var state_32633__$1 = state_32633;
var statearr_32686_32754 = state_32633__$1;
(statearr_32686_32754[(2)] = null);

(statearr_32686_32754[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (35))){
var inst_32615 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32687_32755 = state_32633__$1;
(statearr_32687_32755[(2)] = inst_32615);

(statearr_32687_32755[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (19))){
var inst_32534 = (state_32633[(7)]);
var inst_32538 = cljs.core.chunk_first.call(null,inst_32534);
var inst_32539 = cljs.core.chunk_rest.call(null,inst_32534);
var inst_32540 = cljs.core.count.call(null,inst_32538);
var inst_32514 = inst_32539;
var inst_32515 = inst_32538;
var inst_32516 = inst_32540;
var inst_32517 = (0);
var state_32633__$1 = (function (){var statearr_32688 = state_32633;
(statearr_32688[(13)] = inst_32517);

(statearr_32688[(14)] = inst_32515);

(statearr_32688[(15)] = inst_32514);

(statearr_32688[(17)] = inst_32516);

return statearr_32688;
})();
var statearr_32689_32756 = state_32633__$1;
(statearr_32689_32756[(2)] = null);

(statearr_32689_32756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (11))){
var inst_32534 = (state_32633[(7)]);
var inst_32514 = (state_32633[(15)]);
var inst_32534__$1 = cljs.core.seq.call(null,inst_32514);
var state_32633__$1 = (function (){var statearr_32690 = state_32633;
(statearr_32690[(7)] = inst_32534__$1);

return statearr_32690;
})();
if(inst_32534__$1){
var statearr_32691_32757 = state_32633__$1;
(statearr_32691_32757[(1)] = (16));

} else {
var statearr_32692_32758 = state_32633__$1;
(statearr_32692_32758[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (9))){
var inst_32562 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32693_32759 = state_32633__$1;
(statearr_32693_32759[(2)] = inst_32562);

(statearr_32693_32759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (5))){
var inst_32512 = cljs.core.deref.call(null,cs);
var inst_32513 = cljs.core.seq.call(null,inst_32512);
var inst_32514 = inst_32513;
var inst_32515 = null;
var inst_32516 = (0);
var inst_32517 = (0);
var state_32633__$1 = (function (){var statearr_32694 = state_32633;
(statearr_32694[(13)] = inst_32517);

(statearr_32694[(14)] = inst_32515);

(statearr_32694[(15)] = inst_32514);

(statearr_32694[(17)] = inst_32516);

return statearr_32694;
})();
var statearr_32695_32760 = state_32633__$1;
(statearr_32695_32760[(2)] = null);

(statearr_32695_32760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (14))){
var state_32633__$1 = state_32633;
var statearr_32696_32761 = state_32633__$1;
(statearr_32696_32761[(2)] = null);

(statearr_32696_32761[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (45))){
var inst_32623 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32697_32762 = state_32633__$1;
(statearr_32697_32762[(2)] = inst_32623);

(statearr_32697_32762[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (26))){
var inst_32565 = (state_32633[(29)]);
var inst_32619 = (state_32633[(2)]);
var inst_32620 = cljs.core.seq.call(null,inst_32565);
var state_32633__$1 = (function (){var statearr_32698 = state_32633;
(statearr_32698[(31)] = inst_32619);

return statearr_32698;
})();
if(inst_32620){
var statearr_32699_32763 = state_32633__$1;
(statearr_32699_32763[(1)] = (42));

} else {
var statearr_32700_32764 = state_32633__$1;
(statearr_32700_32764[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (16))){
var inst_32534 = (state_32633[(7)]);
var inst_32536 = cljs.core.chunked_seq_QMARK_.call(null,inst_32534);
var state_32633__$1 = state_32633;
if(inst_32536){
var statearr_32701_32765 = state_32633__$1;
(statearr_32701_32765[(1)] = (19));

} else {
var statearr_32702_32766 = state_32633__$1;
(statearr_32702_32766[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (38))){
var inst_32612 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32703_32767 = state_32633__$1;
(statearr_32703_32767[(2)] = inst_32612);

(statearr_32703_32767[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (30))){
var state_32633__$1 = state_32633;
var statearr_32704_32768 = state_32633__$1;
(statearr_32704_32768[(2)] = null);

(statearr_32704_32768[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (10))){
var inst_32517 = (state_32633[(13)]);
var inst_32515 = (state_32633[(14)]);
var inst_32523 = cljs.core._nth.call(null,inst_32515,inst_32517);
var inst_32524 = cljs.core.nth.call(null,inst_32523,(0),null);
var inst_32525 = cljs.core.nth.call(null,inst_32523,(1),null);
var state_32633__$1 = (function (){var statearr_32705 = state_32633;
(statearr_32705[(26)] = inst_32524);

return statearr_32705;
})();
if(cljs.core.truth_(inst_32525)){
var statearr_32706_32769 = state_32633__$1;
(statearr_32706_32769[(1)] = (13));

} else {
var statearr_32707_32770 = state_32633__$1;
(statearr_32707_32770[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (18))){
var inst_32558 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32708_32771 = state_32633__$1;
(statearr_32708_32771[(2)] = inst_32558);

(statearr_32708_32771[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (42))){
var state_32633__$1 = state_32633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32633__$1,(45),dchan);
} else {
if((state_val_32634 === (37))){
var inst_32601 = (state_32633[(23)]);
var inst_32592 = (state_32633[(25)]);
var inst_32505 = (state_32633[(11)]);
var inst_32601__$1 = cljs.core.first.call(null,inst_32592);
var inst_32602 = cljs.core.async.put_BANG_.call(null,inst_32601__$1,inst_32505,done);
var state_32633__$1 = (function (){var statearr_32709 = state_32633;
(statearr_32709[(23)] = inst_32601__$1);

return statearr_32709;
})();
if(cljs.core.truth_(inst_32602)){
var statearr_32710_32772 = state_32633__$1;
(statearr_32710_32772[(1)] = (39));

} else {
var statearr_32711_32773 = state_32633__$1;
(statearr_32711_32773[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (8))){
var inst_32517 = (state_32633[(13)]);
var inst_32516 = (state_32633[(17)]);
var inst_32519 = (inst_32517 < inst_32516);
var inst_32520 = inst_32519;
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32520)){
var statearr_32712_32774 = state_32633__$1;
(statearr_32712_32774[(1)] = (10));

} else {
var statearr_32713_32775 = state_32633__$1;
(statearr_32713_32775[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___32721,cs,m,dchan,dctr,done))
;
return ((function (switch__23984__auto__,c__23999__auto___32721,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__23985__auto__ = null;
var cljs$core$async$mult_$_state_machine__23985__auto____0 = (function (){
var statearr_32717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32717[(0)] = cljs$core$async$mult_$_state_machine__23985__auto__);

(statearr_32717[(1)] = (1));

return statearr_32717;
});
var cljs$core$async$mult_$_state_machine__23985__auto____1 = (function (state_32633){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_32633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e32718){if((e32718 instanceof Object)){
var ex__23988__auto__ = e32718;
var statearr_32719_32776 = state_32633;
(statearr_32719_32776[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32633);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32718;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32777 = state_32633;
state_32633 = G__32777;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__23985__auto__ = function(state_32633){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__23985__auto____1.call(this,state_32633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__23985__auto____0;
cljs$core$async$mult_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__23985__auto____1;
return cljs$core$async$mult_$_state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___32721,cs,m,dchan,dctr,done))
})();
var state__24001__auto__ = (function (){var statearr_32720 = f__24000__auto__.call(null);
(statearr_32720[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___32721);

return statearr_32720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___32721,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var args32778 = [];
var len__19567__auto___32781 = arguments.length;
var i__19568__auto___32782 = (0);
while(true){
if((i__19568__auto___32782 < len__19567__auto___32781)){
args32778.push((arguments[i__19568__auto___32782]));

var G__32783 = (i__19568__auto___32782 + (1));
i__19568__auto___32782 = G__32783;
continue;
} else {
}
break;
}

var G__32780 = args32778.length;
switch (G__32780) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32778.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = {};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__19164__auto__ = (((m == null))?null:m);
var m__19165__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,m,ch);
} else {
var m__19165__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__19164__auto__ = (((m == null))?null:m);
var m__19165__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,m,ch);
} else {
var m__19165__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__19164__auto__ = (((m == null))?null:m);
var m__19165__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,m);
} else {
var m__19165__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__19164__auto__ = (((m == null))?null:m);
var m__19165__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,m,state_map);
} else {
var m__19165__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__19164__auto__ = (((m == null))?null:m);
var m__19165__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,m,mode);
} else {
var m__19165__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var args__19574__auto__ = [];
var len__19567__auto___32797 = arguments.length;
var i__19568__auto___32798 = (0);
while(true){
if((i__19568__auto___32798 < len__19567__auto___32797)){
args__19574__auto__.push((arguments[i__19568__auto___32798]));

var G__32799 = (i__19568__auto___32798 + (1));
i__19568__auto___32798 = G__32799;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((3) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19575__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32791){
var map__32792 = p__32791;
var map__32792__$1 = ((((!((map__32792 == null)))?((((map__32792.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32792.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32792):map__32792);
var opts = map__32792__$1;
var statearr_32794_32800 = state;
(statearr_32794_32800[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__32792,map__32792__$1,opts){
return (function (val){
var statearr_32795_32801 = state;
(statearr_32795_32801[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__32792,map__32792__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_32796_32802 = state;
(statearr_32796_32802[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32787){
var G__32788 = cljs.core.first.call(null,seq32787);
var seq32787__$1 = cljs.core.next.call(null,seq32787);
var G__32789 = cljs.core.first.call(null,seq32787__$1);
var seq32787__$2 = cljs.core.next.call(null,seq32787__$1);
var G__32790 = cljs.core.first.call(null,seq32787__$2);
var seq32787__$3 = cljs.core.next.call(null,seq32787__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32788,G__32789,G__32790,seq32787__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t32966 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32966 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32967){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32967 = meta32967;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t32966.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32968,meta32967__$1){
var self__ = this;
var _32968__$1 = this;
return (new cljs.core.async.t32966(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32967__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32966.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32968){
var self__ = this;
var _32968__$1 = this;
return self__.meta32967;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32966.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t32966.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32966.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t32966.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32966.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32966.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32966.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32966.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32966.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta32967","meta32967",1444993773,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32966.cljs$lang$type = true;

cljs.core.async.t32966.cljs$lang$ctorStr = "cljs.core.async/t32966";

cljs.core.async.t32966.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__19107__auto__,writer__19108__auto__,opt__19109__auto__){
return cljs.core._write.call(null,writer__19108__auto__,"cljs.core.async/t32966");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t32966 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t32966(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32967){
return (new cljs.core.async.t32966(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32967));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t32966(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23999__auto___33129 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___33129,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___33129,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33066){
var state_val_33067 = (state_33066[(1)]);
if((state_val_33067 === (7))){
var inst_32984 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
var statearr_33068_33130 = state_33066__$1;
(statearr_33068_33130[(2)] = inst_32984);

(statearr_33068_33130[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (20))){
var inst_32996 = (state_33066[(7)]);
var state_33066__$1 = state_33066;
var statearr_33069_33131 = state_33066__$1;
(statearr_33069_33131[(2)] = inst_32996);

(statearr_33069_33131[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (27))){
var state_33066__$1 = state_33066;
var statearr_33070_33132 = state_33066__$1;
(statearr_33070_33132[(2)] = null);

(statearr_33070_33132[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (1))){
var inst_32972 = (state_33066[(8)]);
var inst_32972__$1 = calc_state.call(null);
var inst_32974 = (inst_32972__$1 == null);
var inst_32975 = cljs.core.not.call(null,inst_32974);
var state_33066__$1 = (function (){var statearr_33071 = state_33066;
(statearr_33071[(8)] = inst_32972__$1);

return statearr_33071;
})();
if(inst_32975){
var statearr_33072_33133 = state_33066__$1;
(statearr_33072_33133[(1)] = (2));

} else {
var statearr_33073_33134 = state_33066__$1;
(statearr_33073_33134[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (24))){
var inst_33026 = (state_33066[(9)]);
var inst_33040 = (state_33066[(10)]);
var inst_33019 = (state_33066[(11)]);
var inst_33040__$1 = inst_33019.call(null,inst_33026);
var state_33066__$1 = (function (){var statearr_33074 = state_33066;
(statearr_33074[(10)] = inst_33040__$1);

return statearr_33074;
})();
if(cljs.core.truth_(inst_33040__$1)){
var statearr_33075_33135 = state_33066__$1;
(statearr_33075_33135[(1)] = (29));

} else {
var statearr_33076_33136 = state_33066__$1;
(statearr_33076_33136[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (4))){
var inst_32987 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
if(cljs.core.truth_(inst_32987)){
var statearr_33077_33137 = state_33066__$1;
(statearr_33077_33137[(1)] = (8));

} else {
var statearr_33078_33138 = state_33066__$1;
(statearr_33078_33138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (15))){
var inst_33013 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
if(cljs.core.truth_(inst_33013)){
var statearr_33079_33139 = state_33066__$1;
(statearr_33079_33139[(1)] = (19));

} else {
var statearr_33080_33140 = state_33066__$1;
(statearr_33080_33140[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (21))){
var inst_33018 = (state_33066[(12)]);
var inst_33018__$1 = (state_33066[(2)]);
var inst_33019 = cljs.core.get.call(null,inst_33018__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_33020 = cljs.core.get.call(null,inst_33018__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_33021 = cljs.core.get.call(null,inst_33018__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_33066__$1 = (function (){var statearr_33081 = state_33066;
(statearr_33081[(13)] = inst_33020);

(statearr_33081[(11)] = inst_33019);

(statearr_33081[(12)] = inst_33018__$1);

return statearr_33081;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_33066__$1,(22),inst_33021);
} else {
if((state_val_33067 === (31))){
var inst_33048 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
if(cljs.core.truth_(inst_33048)){
var statearr_33082_33141 = state_33066__$1;
(statearr_33082_33141[(1)] = (32));

} else {
var statearr_33083_33142 = state_33066__$1;
(statearr_33083_33142[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (32))){
var inst_33025 = (state_33066[(14)]);
var state_33066__$1 = state_33066;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33066__$1,(35),out,inst_33025);
} else {
if((state_val_33067 === (33))){
var inst_33018 = (state_33066[(12)]);
var inst_32996 = inst_33018;
var state_33066__$1 = (function (){var statearr_33084 = state_33066;
(statearr_33084[(7)] = inst_32996);

return statearr_33084;
})();
var statearr_33085_33143 = state_33066__$1;
(statearr_33085_33143[(2)] = null);

(statearr_33085_33143[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (13))){
var inst_32996 = (state_33066[(7)]);
var inst_33003 = inst_32996.cljs$lang$protocol_mask$partition0$;
var inst_33004 = (inst_33003 & (64));
var inst_33005 = inst_32996.cljs$core$ISeq$;
var inst_33006 = (inst_33004) || (inst_33005);
var state_33066__$1 = state_33066;
if(cljs.core.truth_(inst_33006)){
var statearr_33086_33144 = state_33066__$1;
(statearr_33086_33144[(1)] = (16));

} else {
var statearr_33087_33145 = state_33066__$1;
(statearr_33087_33145[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (22))){
var inst_33025 = (state_33066[(14)]);
var inst_33026 = (state_33066[(9)]);
var inst_33024 = (state_33066[(2)]);
var inst_33025__$1 = cljs.core.nth.call(null,inst_33024,(0),null);
var inst_33026__$1 = cljs.core.nth.call(null,inst_33024,(1),null);
var inst_33027 = (inst_33025__$1 == null);
var inst_33028 = cljs.core._EQ_.call(null,inst_33026__$1,change);
var inst_33029 = (inst_33027) || (inst_33028);
var state_33066__$1 = (function (){var statearr_33088 = state_33066;
(statearr_33088[(14)] = inst_33025__$1);

(statearr_33088[(9)] = inst_33026__$1);

return statearr_33088;
})();
if(cljs.core.truth_(inst_33029)){
var statearr_33089_33146 = state_33066__$1;
(statearr_33089_33146[(1)] = (23));

} else {
var statearr_33090_33147 = state_33066__$1;
(statearr_33090_33147[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (36))){
var inst_33018 = (state_33066[(12)]);
var inst_32996 = inst_33018;
var state_33066__$1 = (function (){var statearr_33091 = state_33066;
(statearr_33091[(7)] = inst_32996);

return statearr_33091;
})();
var statearr_33092_33148 = state_33066__$1;
(statearr_33092_33148[(2)] = null);

(statearr_33092_33148[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (29))){
var inst_33040 = (state_33066[(10)]);
var state_33066__$1 = state_33066;
var statearr_33093_33149 = state_33066__$1;
(statearr_33093_33149[(2)] = inst_33040);

(statearr_33093_33149[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (6))){
var state_33066__$1 = state_33066;
var statearr_33094_33150 = state_33066__$1;
(statearr_33094_33150[(2)] = false);

(statearr_33094_33150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (28))){
var inst_33036 = (state_33066[(2)]);
var inst_33037 = calc_state.call(null);
var inst_32996 = inst_33037;
var state_33066__$1 = (function (){var statearr_33095 = state_33066;
(statearr_33095[(15)] = inst_33036);

(statearr_33095[(7)] = inst_32996);

return statearr_33095;
})();
var statearr_33096_33151 = state_33066__$1;
(statearr_33096_33151[(2)] = null);

(statearr_33096_33151[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (25))){
var inst_33062 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
var statearr_33097_33152 = state_33066__$1;
(statearr_33097_33152[(2)] = inst_33062);

(statearr_33097_33152[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (34))){
var inst_33060 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
var statearr_33098_33153 = state_33066__$1;
(statearr_33098_33153[(2)] = inst_33060);

(statearr_33098_33153[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (17))){
var state_33066__$1 = state_33066;
var statearr_33099_33154 = state_33066__$1;
(statearr_33099_33154[(2)] = false);

(statearr_33099_33154[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (3))){
var state_33066__$1 = state_33066;
var statearr_33100_33155 = state_33066__$1;
(statearr_33100_33155[(2)] = false);

(statearr_33100_33155[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (12))){
var inst_33064 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33066__$1,inst_33064);
} else {
if((state_val_33067 === (2))){
var inst_32972 = (state_33066[(8)]);
var inst_32977 = inst_32972.cljs$lang$protocol_mask$partition0$;
var inst_32978 = (inst_32977 & (64));
var inst_32979 = inst_32972.cljs$core$ISeq$;
var inst_32980 = (inst_32978) || (inst_32979);
var state_33066__$1 = state_33066;
if(cljs.core.truth_(inst_32980)){
var statearr_33101_33156 = state_33066__$1;
(statearr_33101_33156[(1)] = (5));

} else {
var statearr_33102_33157 = state_33066__$1;
(statearr_33102_33157[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (23))){
var inst_33025 = (state_33066[(14)]);
var inst_33031 = (inst_33025 == null);
var state_33066__$1 = state_33066;
if(cljs.core.truth_(inst_33031)){
var statearr_33103_33158 = state_33066__$1;
(statearr_33103_33158[(1)] = (26));

} else {
var statearr_33104_33159 = state_33066__$1;
(statearr_33104_33159[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (35))){
var inst_33051 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
if(cljs.core.truth_(inst_33051)){
var statearr_33105_33160 = state_33066__$1;
(statearr_33105_33160[(1)] = (36));

} else {
var statearr_33106_33161 = state_33066__$1;
(statearr_33106_33161[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (19))){
var inst_32996 = (state_33066[(7)]);
var inst_33015 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32996);
var state_33066__$1 = state_33066;
var statearr_33107_33162 = state_33066__$1;
(statearr_33107_33162[(2)] = inst_33015);

(statearr_33107_33162[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (11))){
var inst_32996 = (state_33066[(7)]);
var inst_33000 = (inst_32996 == null);
var inst_33001 = cljs.core.not.call(null,inst_33000);
var state_33066__$1 = state_33066;
if(inst_33001){
var statearr_33108_33163 = state_33066__$1;
(statearr_33108_33163[(1)] = (13));

} else {
var statearr_33109_33164 = state_33066__$1;
(statearr_33109_33164[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (9))){
var inst_32972 = (state_33066[(8)]);
var state_33066__$1 = state_33066;
var statearr_33110_33165 = state_33066__$1;
(statearr_33110_33165[(2)] = inst_32972);

(statearr_33110_33165[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (5))){
var state_33066__$1 = state_33066;
var statearr_33111_33166 = state_33066__$1;
(statearr_33111_33166[(2)] = true);

(statearr_33111_33166[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (14))){
var state_33066__$1 = state_33066;
var statearr_33112_33167 = state_33066__$1;
(statearr_33112_33167[(2)] = false);

(statearr_33112_33167[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (26))){
var inst_33026 = (state_33066[(9)]);
var inst_33033 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_33026);
var state_33066__$1 = state_33066;
var statearr_33113_33168 = state_33066__$1;
(statearr_33113_33168[(2)] = inst_33033);

(statearr_33113_33168[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (16))){
var state_33066__$1 = state_33066;
var statearr_33114_33169 = state_33066__$1;
(statearr_33114_33169[(2)] = true);

(statearr_33114_33169[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (38))){
var inst_33056 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
var statearr_33115_33170 = state_33066__$1;
(statearr_33115_33170[(2)] = inst_33056);

(statearr_33115_33170[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (30))){
var inst_33026 = (state_33066[(9)]);
var inst_33020 = (state_33066[(13)]);
var inst_33019 = (state_33066[(11)]);
var inst_33043 = cljs.core.empty_QMARK_.call(null,inst_33019);
var inst_33044 = inst_33020.call(null,inst_33026);
var inst_33045 = cljs.core.not.call(null,inst_33044);
var inst_33046 = (inst_33043) && (inst_33045);
var state_33066__$1 = state_33066;
var statearr_33116_33171 = state_33066__$1;
(statearr_33116_33171[(2)] = inst_33046);

(statearr_33116_33171[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (10))){
var inst_32972 = (state_33066[(8)]);
var inst_32992 = (state_33066[(2)]);
var inst_32993 = cljs.core.get.call(null,inst_32992,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32994 = cljs.core.get.call(null,inst_32992,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32995 = cljs.core.get.call(null,inst_32992,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32996 = inst_32972;
var state_33066__$1 = (function (){var statearr_33117 = state_33066;
(statearr_33117[(16)] = inst_32995);

(statearr_33117[(17)] = inst_32993);

(statearr_33117[(18)] = inst_32994);

(statearr_33117[(7)] = inst_32996);

return statearr_33117;
})();
var statearr_33118_33172 = state_33066__$1;
(statearr_33118_33172[(2)] = null);

(statearr_33118_33172[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (18))){
var inst_33010 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
var statearr_33119_33173 = state_33066__$1;
(statearr_33119_33173[(2)] = inst_33010);

(statearr_33119_33173[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (37))){
var state_33066__$1 = state_33066;
var statearr_33120_33174 = state_33066__$1;
(statearr_33120_33174[(2)] = null);

(statearr_33120_33174[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (8))){
var inst_32972 = (state_33066[(8)]);
var inst_32989 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32972);
var state_33066__$1 = state_33066;
var statearr_33121_33175 = state_33066__$1;
(statearr_33121_33175[(2)] = inst_32989);

(statearr_33121_33175[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___33129,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__23984__auto__,c__23999__auto___33129,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__23985__auto__ = null;
var cljs$core$async$mix_$_state_machine__23985__auto____0 = (function (){
var statearr_33125 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33125[(0)] = cljs$core$async$mix_$_state_machine__23985__auto__);

(statearr_33125[(1)] = (1));

return statearr_33125;
});
var cljs$core$async$mix_$_state_machine__23985__auto____1 = (function (state_33066){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_33066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e33126){if((e33126 instanceof Object)){
var ex__23988__auto__ = e33126;
var statearr_33127_33176 = state_33066;
(statearr_33127_33176[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33066);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33126;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33177 = state_33066;
state_33066 = G__33177;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__23985__auto__ = function(state_33066){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__23985__auto____1.call(this,state_33066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__23985__auto____0;
cljs$core$async$mix_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__23985__auto____1;
return cljs$core$async$mix_$_state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___33129,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__24001__auto__ = (function (){var statearr_33128 = f__24000__auto__.call(null);
(statearr_33128[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___33129);

return statearr_33128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___33129,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = {};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__19164__auto__ = (((p == null))?null:p);
var m__19165__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__19165__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__19164__auto__ = (((p == null))?null:p);
var m__19165__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,p,v,ch);
} else {
var m__19165__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var args33180 = [];
var len__19567__auto___33183 = arguments.length;
var i__19568__auto___33184 = (0);
while(true){
if((i__19568__auto___33184 < len__19567__auto___33183)){
args33180.push((arguments[i__19568__auto___33184]));

var G__33185 = (i__19568__auto___33184 + (1));
i__19568__auto___33184 = G__33185;
continue;
} else {
}
break;
}

var G__33182 = args33180.length;
switch (G__33182) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33180.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__19164__auto__ = (((p == null))?null:p);
var m__19165__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,p);
} else {
var m__19165__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__19164__auto__ = (((p == null))?null:p);
var m__19165__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,p,v);
} else {
var m__19165__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var args33188 = [];
var len__19567__auto___33313 = arguments.length;
var i__19568__auto___33314 = (0);
while(true){
if((i__19568__auto___33314 < len__19567__auto___33313)){
args33188.push((arguments[i__19568__auto___33314]));

var G__33315 = (i__19568__auto___33314 + (1));
i__19568__auto___33314 = G__33315;
continue;
} else {
}
break;
}

var G__33190 = args33188.length;
switch (G__33190) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33188.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__18528__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__18528__auto__,mults){
return (function (p1__33187_SHARP_){
if(cljs.core.truth_(p1__33187_SHARP_.call(null,topic))){
return p1__33187_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__33187_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__18528__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t33191 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t33191 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta33192){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta33192 = meta33192;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t33191.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33193,meta33192__$1){
var self__ = this;
var _33193__$1 = this;
return (new cljs.core.async.t33191(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta33192__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t33191.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33193){
var self__ = this;
var _33193__$1 = this;
return self__.meta33192;
});})(mults,ensure_mult))
;

cljs.core.async.t33191.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t33191.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t33191.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t33191.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t33191.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t33191.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t33191.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t33191.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta33192","meta33192",1025412495,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t33191.cljs$lang$type = true;

cljs.core.async.t33191.cljs$lang$ctorStr = "cljs.core.async/t33191";

cljs.core.async.t33191.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__19107__auto__,writer__19108__auto__,opt__19109__auto__){
return cljs.core._write.call(null,writer__19108__auto__,"cljs.core.async/t33191");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t33191 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t33191(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33192){
return (new cljs.core.async.t33191(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33192));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t33191(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23999__auto___33317 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___33317,mults,ensure_mult,p){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___33317,mults,ensure_mult,p){
return (function (state_33265){
var state_val_33266 = (state_33265[(1)]);
if((state_val_33266 === (7))){
var inst_33261 = (state_33265[(2)]);
var state_33265__$1 = state_33265;
var statearr_33267_33318 = state_33265__$1;
(statearr_33267_33318[(2)] = inst_33261);

(statearr_33267_33318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (20))){
var state_33265__$1 = state_33265;
var statearr_33268_33319 = state_33265__$1;
(statearr_33268_33319[(2)] = null);

(statearr_33268_33319[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (1))){
var state_33265__$1 = state_33265;
var statearr_33269_33320 = state_33265__$1;
(statearr_33269_33320[(2)] = null);

(statearr_33269_33320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (24))){
var inst_33244 = (state_33265[(7)]);
var inst_33253 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_33244);
var state_33265__$1 = state_33265;
var statearr_33270_33321 = state_33265__$1;
(statearr_33270_33321[(2)] = inst_33253);

(statearr_33270_33321[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (4))){
var inst_33196 = (state_33265[(8)]);
var inst_33196__$1 = (state_33265[(2)]);
var inst_33197 = (inst_33196__$1 == null);
var state_33265__$1 = (function (){var statearr_33271 = state_33265;
(statearr_33271[(8)] = inst_33196__$1);

return statearr_33271;
})();
if(cljs.core.truth_(inst_33197)){
var statearr_33272_33322 = state_33265__$1;
(statearr_33272_33322[(1)] = (5));

} else {
var statearr_33273_33323 = state_33265__$1;
(statearr_33273_33323[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (15))){
var inst_33238 = (state_33265[(2)]);
var state_33265__$1 = state_33265;
var statearr_33274_33324 = state_33265__$1;
(statearr_33274_33324[(2)] = inst_33238);

(statearr_33274_33324[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (21))){
var inst_33258 = (state_33265[(2)]);
var state_33265__$1 = (function (){var statearr_33275 = state_33265;
(statearr_33275[(9)] = inst_33258);

return statearr_33275;
})();
var statearr_33276_33325 = state_33265__$1;
(statearr_33276_33325[(2)] = null);

(statearr_33276_33325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (13))){
var inst_33220 = (state_33265[(10)]);
var inst_33222 = cljs.core.chunked_seq_QMARK_.call(null,inst_33220);
var state_33265__$1 = state_33265;
if(inst_33222){
var statearr_33277_33326 = state_33265__$1;
(statearr_33277_33326[(1)] = (16));

} else {
var statearr_33278_33327 = state_33265__$1;
(statearr_33278_33327[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (22))){
var inst_33250 = (state_33265[(2)]);
var state_33265__$1 = state_33265;
if(cljs.core.truth_(inst_33250)){
var statearr_33279_33328 = state_33265__$1;
(statearr_33279_33328[(1)] = (23));

} else {
var statearr_33280_33329 = state_33265__$1;
(statearr_33280_33329[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (6))){
var inst_33196 = (state_33265[(8)]);
var inst_33246 = (state_33265[(11)]);
var inst_33244 = (state_33265[(7)]);
var inst_33244__$1 = topic_fn.call(null,inst_33196);
var inst_33245 = cljs.core.deref.call(null,mults);
var inst_33246__$1 = cljs.core.get.call(null,inst_33245,inst_33244__$1);
var state_33265__$1 = (function (){var statearr_33281 = state_33265;
(statearr_33281[(11)] = inst_33246__$1);

(statearr_33281[(7)] = inst_33244__$1);

return statearr_33281;
})();
if(cljs.core.truth_(inst_33246__$1)){
var statearr_33282_33330 = state_33265__$1;
(statearr_33282_33330[(1)] = (19));

} else {
var statearr_33283_33331 = state_33265__$1;
(statearr_33283_33331[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (25))){
var inst_33255 = (state_33265[(2)]);
var state_33265__$1 = state_33265;
var statearr_33284_33332 = state_33265__$1;
(statearr_33284_33332[(2)] = inst_33255);

(statearr_33284_33332[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (17))){
var inst_33220 = (state_33265[(10)]);
var inst_33229 = cljs.core.first.call(null,inst_33220);
var inst_33230 = cljs.core.async.muxch_STAR_.call(null,inst_33229);
var inst_33231 = cljs.core.async.close_BANG_.call(null,inst_33230);
var inst_33232 = cljs.core.next.call(null,inst_33220);
var inst_33206 = inst_33232;
var inst_33207 = null;
var inst_33208 = (0);
var inst_33209 = (0);
var state_33265__$1 = (function (){var statearr_33285 = state_33265;
(statearr_33285[(12)] = inst_33231);

(statearr_33285[(13)] = inst_33208);

(statearr_33285[(14)] = inst_33206);

(statearr_33285[(15)] = inst_33207);

(statearr_33285[(16)] = inst_33209);

return statearr_33285;
})();
var statearr_33286_33333 = state_33265__$1;
(statearr_33286_33333[(2)] = null);

(statearr_33286_33333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (3))){
var inst_33263 = (state_33265[(2)]);
var state_33265__$1 = state_33265;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33265__$1,inst_33263);
} else {
if((state_val_33266 === (12))){
var inst_33240 = (state_33265[(2)]);
var state_33265__$1 = state_33265;
var statearr_33287_33334 = state_33265__$1;
(statearr_33287_33334[(2)] = inst_33240);

(statearr_33287_33334[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (2))){
var state_33265__$1 = state_33265;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33265__$1,(4),ch);
} else {
if((state_val_33266 === (23))){
var state_33265__$1 = state_33265;
var statearr_33288_33335 = state_33265__$1;
(statearr_33288_33335[(2)] = null);

(statearr_33288_33335[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (19))){
var inst_33196 = (state_33265[(8)]);
var inst_33246 = (state_33265[(11)]);
var inst_33248 = cljs.core.async.muxch_STAR_.call(null,inst_33246);
var state_33265__$1 = state_33265;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33265__$1,(22),inst_33248,inst_33196);
} else {
if((state_val_33266 === (11))){
var inst_33220 = (state_33265[(10)]);
var inst_33206 = (state_33265[(14)]);
var inst_33220__$1 = cljs.core.seq.call(null,inst_33206);
var state_33265__$1 = (function (){var statearr_33289 = state_33265;
(statearr_33289[(10)] = inst_33220__$1);

return statearr_33289;
})();
if(inst_33220__$1){
var statearr_33290_33336 = state_33265__$1;
(statearr_33290_33336[(1)] = (13));

} else {
var statearr_33291_33337 = state_33265__$1;
(statearr_33291_33337[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (9))){
var inst_33242 = (state_33265[(2)]);
var state_33265__$1 = state_33265;
var statearr_33292_33338 = state_33265__$1;
(statearr_33292_33338[(2)] = inst_33242);

(statearr_33292_33338[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (5))){
var inst_33203 = cljs.core.deref.call(null,mults);
var inst_33204 = cljs.core.vals.call(null,inst_33203);
var inst_33205 = cljs.core.seq.call(null,inst_33204);
var inst_33206 = inst_33205;
var inst_33207 = null;
var inst_33208 = (0);
var inst_33209 = (0);
var state_33265__$1 = (function (){var statearr_33293 = state_33265;
(statearr_33293[(13)] = inst_33208);

(statearr_33293[(14)] = inst_33206);

(statearr_33293[(15)] = inst_33207);

(statearr_33293[(16)] = inst_33209);

return statearr_33293;
})();
var statearr_33294_33339 = state_33265__$1;
(statearr_33294_33339[(2)] = null);

(statearr_33294_33339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (14))){
var state_33265__$1 = state_33265;
var statearr_33298_33340 = state_33265__$1;
(statearr_33298_33340[(2)] = null);

(statearr_33298_33340[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (16))){
var inst_33220 = (state_33265[(10)]);
var inst_33224 = cljs.core.chunk_first.call(null,inst_33220);
var inst_33225 = cljs.core.chunk_rest.call(null,inst_33220);
var inst_33226 = cljs.core.count.call(null,inst_33224);
var inst_33206 = inst_33225;
var inst_33207 = inst_33224;
var inst_33208 = inst_33226;
var inst_33209 = (0);
var state_33265__$1 = (function (){var statearr_33299 = state_33265;
(statearr_33299[(13)] = inst_33208);

(statearr_33299[(14)] = inst_33206);

(statearr_33299[(15)] = inst_33207);

(statearr_33299[(16)] = inst_33209);

return statearr_33299;
})();
var statearr_33300_33341 = state_33265__$1;
(statearr_33300_33341[(2)] = null);

(statearr_33300_33341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (10))){
var inst_33208 = (state_33265[(13)]);
var inst_33206 = (state_33265[(14)]);
var inst_33207 = (state_33265[(15)]);
var inst_33209 = (state_33265[(16)]);
var inst_33214 = cljs.core._nth.call(null,inst_33207,inst_33209);
var inst_33215 = cljs.core.async.muxch_STAR_.call(null,inst_33214);
var inst_33216 = cljs.core.async.close_BANG_.call(null,inst_33215);
var inst_33217 = (inst_33209 + (1));
var tmp33295 = inst_33208;
var tmp33296 = inst_33206;
var tmp33297 = inst_33207;
var inst_33206__$1 = tmp33296;
var inst_33207__$1 = tmp33297;
var inst_33208__$1 = tmp33295;
var inst_33209__$1 = inst_33217;
var state_33265__$1 = (function (){var statearr_33301 = state_33265;
(statearr_33301[(17)] = inst_33216);

(statearr_33301[(13)] = inst_33208__$1);

(statearr_33301[(14)] = inst_33206__$1);

(statearr_33301[(15)] = inst_33207__$1);

(statearr_33301[(16)] = inst_33209__$1);

return statearr_33301;
})();
var statearr_33302_33342 = state_33265__$1;
(statearr_33302_33342[(2)] = null);

(statearr_33302_33342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (18))){
var inst_33235 = (state_33265[(2)]);
var state_33265__$1 = state_33265;
var statearr_33303_33343 = state_33265__$1;
(statearr_33303_33343[(2)] = inst_33235);

(statearr_33303_33343[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33266 === (8))){
var inst_33208 = (state_33265[(13)]);
var inst_33209 = (state_33265[(16)]);
var inst_33211 = (inst_33209 < inst_33208);
var inst_33212 = inst_33211;
var state_33265__$1 = state_33265;
if(cljs.core.truth_(inst_33212)){
var statearr_33304_33344 = state_33265__$1;
(statearr_33304_33344[(1)] = (10));

} else {
var statearr_33305_33345 = state_33265__$1;
(statearr_33305_33345[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___33317,mults,ensure_mult,p))
;
return ((function (switch__23984__auto__,c__23999__auto___33317,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_33309 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33309[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_33309[(1)] = (1));

return statearr_33309;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_33265){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_33265);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e33310){if((e33310 instanceof Object)){
var ex__23988__auto__ = e33310;
var statearr_33311_33346 = state_33265;
(statearr_33311_33346[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33265);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33310;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33347 = state_33265;
state_33265 = G__33347;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_33265){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_33265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___33317,mults,ensure_mult,p))
})();
var state__24001__auto__ = (function (){var statearr_33312 = f__24000__auto__.call(null);
(statearr_33312[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___33317);

return statearr_33312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___33317,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var args33348 = [];
var len__19567__auto___33351 = arguments.length;
var i__19568__auto___33352 = (0);
while(true){
if((i__19568__auto___33352 < len__19567__auto___33351)){
args33348.push((arguments[i__19568__auto___33352]));

var G__33353 = (i__19568__auto___33352 + (1));
i__19568__auto___33352 = G__33353;
continue;
} else {
}
break;
}

var G__33350 = args33348.length;
switch (G__33350) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33348.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var args33355 = [];
var len__19567__auto___33358 = arguments.length;
var i__19568__auto___33359 = (0);
while(true){
if((i__19568__auto___33359 < len__19567__auto___33358)){
args33355.push((arguments[i__19568__auto___33359]));

var G__33360 = (i__19568__auto___33359 + (1));
i__19568__auto___33359 = G__33360;
continue;
} else {
}
break;
}

var G__33357 = args33355.length;
switch (G__33357) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33355.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var args33362 = [];
var len__19567__auto___33433 = arguments.length;
var i__19568__auto___33434 = (0);
while(true){
if((i__19568__auto___33434 < len__19567__auto___33433)){
args33362.push((arguments[i__19568__auto___33434]));

var G__33435 = (i__19568__auto___33434 + (1));
i__19568__auto___33434 = G__33435;
continue;
} else {
}
break;
}

var G__33364 = args33362.length;
switch (G__33364) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33362.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__23999__auto___33437 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___33437,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___33437,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33403){
var state_val_33404 = (state_33403[(1)]);
if((state_val_33404 === (7))){
var state_33403__$1 = state_33403;
var statearr_33405_33438 = state_33403__$1;
(statearr_33405_33438[(2)] = null);

(statearr_33405_33438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (1))){
var state_33403__$1 = state_33403;
var statearr_33406_33439 = state_33403__$1;
(statearr_33406_33439[(2)] = null);

(statearr_33406_33439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (4))){
var inst_33367 = (state_33403[(7)]);
var inst_33369 = (inst_33367 < cnt);
var state_33403__$1 = state_33403;
if(cljs.core.truth_(inst_33369)){
var statearr_33407_33440 = state_33403__$1;
(statearr_33407_33440[(1)] = (6));

} else {
var statearr_33408_33441 = state_33403__$1;
(statearr_33408_33441[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (15))){
var inst_33399 = (state_33403[(2)]);
var state_33403__$1 = state_33403;
var statearr_33409_33442 = state_33403__$1;
(statearr_33409_33442[(2)] = inst_33399);

(statearr_33409_33442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (13))){
var inst_33392 = cljs.core.async.close_BANG_.call(null,out);
var state_33403__$1 = state_33403;
var statearr_33410_33443 = state_33403__$1;
(statearr_33410_33443[(2)] = inst_33392);

(statearr_33410_33443[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (6))){
var state_33403__$1 = state_33403;
var statearr_33411_33444 = state_33403__$1;
(statearr_33411_33444[(2)] = null);

(statearr_33411_33444[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (3))){
var inst_33401 = (state_33403[(2)]);
var state_33403__$1 = state_33403;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33403__$1,inst_33401);
} else {
if((state_val_33404 === (12))){
var inst_33389 = (state_33403[(8)]);
var inst_33389__$1 = (state_33403[(2)]);
var inst_33390 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_33389__$1);
var state_33403__$1 = (function (){var statearr_33412 = state_33403;
(statearr_33412[(8)] = inst_33389__$1);

return statearr_33412;
})();
if(cljs.core.truth_(inst_33390)){
var statearr_33413_33445 = state_33403__$1;
(statearr_33413_33445[(1)] = (13));

} else {
var statearr_33414_33446 = state_33403__$1;
(statearr_33414_33446[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (2))){
var inst_33366 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_33367 = (0);
var state_33403__$1 = (function (){var statearr_33415 = state_33403;
(statearr_33415[(7)] = inst_33367);

(statearr_33415[(9)] = inst_33366);

return statearr_33415;
})();
var statearr_33416_33447 = state_33403__$1;
(statearr_33416_33447[(2)] = null);

(statearr_33416_33447[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (11))){
var inst_33367 = (state_33403[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_33403,(10),Object,null,(9));
var inst_33376 = chs__$1.call(null,inst_33367);
var inst_33377 = done.call(null,inst_33367);
var inst_33378 = cljs.core.async.take_BANG_.call(null,inst_33376,inst_33377);
var state_33403__$1 = state_33403;
var statearr_33417_33448 = state_33403__$1;
(statearr_33417_33448[(2)] = inst_33378);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33403__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (9))){
var inst_33367 = (state_33403[(7)]);
var inst_33380 = (state_33403[(2)]);
var inst_33381 = (inst_33367 + (1));
var inst_33367__$1 = inst_33381;
var state_33403__$1 = (function (){var statearr_33418 = state_33403;
(statearr_33418[(7)] = inst_33367__$1);

(statearr_33418[(10)] = inst_33380);

return statearr_33418;
})();
var statearr_33419_33449 = state_33403__$1;
(statearr_33419_33449[(2)] = null);

(statearr_33419_33449[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (5))){
var inst_33387 = (state_33403[(2)]);
var state_33403__$1 = (function (){var statearr_33420 = state_33403;
(statearr_33420[(11)] = inst_33387);

return statearr_33420;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33403__$1,(12),dchan);
} else {
if((state_val_33404 === (14))){
var inst_33389 = (state_33403[(8)]);
var inst_33394 = cljs.core.apply.call(null,f,inst_33389);
var state_33403__$1 = state_33403;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33403__$1,(16),out,inst_33394);
} else {
if((state_val_33404 === (16))){
var inst_33396 = (state_33403[(2)]);
var state_33403__$1 = (function (){var statearr_33421 = state_33403;
(statearr_33421[(12)] = inst_33396);

return statearr_33421;
})();
var statearr_33422_33450 = state_33403__$1;
(statearr_33422_33450[(2)] = null);

(statearr_33422_33450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (10))){
var inst_33371 = (state_33403[(2)]);
var inst_33372 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_33403__$1 = (function (){var statearr_33423 = state_33403;
(statearr_33423[(13)] = inst_33371);

return statearr_33423;
})();
var statearr_33424_33451 = state_33403__$1;
(statearr_33424_33451[(2)] = inst_33372);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33403__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33404 === (8))){
var inst_33385 = (state_33403[(2)]);
var state_33403__$1 = state_33403;
var statearr_33425_33452 = state_33403__$1;
(statearr_33425_33452[(2)] = inst_33385);

(statearr_33425_33452[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___33437,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__23984__auto__,c__23999__auto___33437,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_33429 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33429[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_33429[(1)] = (1));

return statearr_33429;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_33403){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_33403);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e33430){if((e33430 instanceof Object)){
var ex__23988__auto__ = e33430;
var statearr_33431_33453 = state_33403;
(statearr_33431_33453[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33403);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33430;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33454 = state_33403;
state_33403 = G__33454;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_33403){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_33403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___33437,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__24001__auto__ = (function (){var statearr_33432 = f__24000__auto__.call(null);
(statearr_33432[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___33437);

return statearr_33432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___33437,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var args33456 = [];
var len__19567__auto___33512 = arguments.length;
var i__19568__auto___33513 = (0);
while(true){
if((i__19568__auto___33513 < len__19567__auto___33512)){
args33456.push((arguments[i__19568__auto___33513]));

var G__33514 = (i__19568__auto___33513 + (1));
i__19568__auto___33513 = G__33514;
continue;
} else {
}
break;
}

var G__33458 = args33456.length;
switch (G__33458) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33456.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23999__auto___33516 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___33516,out){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___33516,out){
return (function (state_33488){
var state_val_33489 = (state_33488[(1)]);
if((state_val_33489 === (7))){
var inst_33468 = (state_33488[(7)]);
var inst_33467 = (state_33488[(8)]);
var inst_33467__$1 = (state_33488[(2)]);
var inst_33468__$1 = cljs.core.nth.call(null,inst_33467__$1,(0),null);
var inst_33469 = cljs.core.nth.call(null,inst_33467__$1,(1),null);
var inst_33470 = (inst_33468__$1 == null);
var state_33488__$1 = (function (){var statearr_33490 = state_33488;
(statearr_33490[(7)] = inst_33468__$1);

(statearr_33490[(9)] = inst_33469);

(statearr_33490[(8)] = inst_33467__$1);

return statearr_33490;
})();
if(cljs.core.truth_(inst_33470)){
var statearr_33491_33517 = state_33488__$1;
(statearr_33491_33517[(1)] = (8));

} else {
var statearr_33492_33518 = state_33488__$1;
(statearr_33492_33518[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33489 === (1))){
var inst_33459 = cljs.core.vec.call(null,chs);
var inst_33460 = inst_33459;
var state_33488__$1 = (function (){var statearr_33493 = state_33488;
(statearr_33493[(10)] = inst_33460);

return statearr_33493;
})();
var statearr_33494_33519 = state_33488__$1;
(statearr_33494_33519[(2)] = null);

(statearr_33494_33519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33489 === (4))){
var inst_33460 = (state_33488[(10)]);
var state_33488__$1 = state_33488;
return cljs.core.async.ioc_alts_BANG_.call(null,state_33488__$1,(7),inst_33460);
} else {
if((state_val_33489 === (6))){
var inst_33484 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
var statearr_33495_33520 = state_33488__$1;
(statearr_33495_33520[(2)] = inst_33484);

(statearr_33495_33520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33489 === (3))){
var inst_33486 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33488__$1,inst_33486);
} else {
if((state_val_33489 === (2))){
var inst_33460 = (state_33488[(10)]);
var inst_33462 = cljs.core.count.call(null,inst_33460);
var inst_33463 = (inst_33462 > (0));
var state_33488__$1 = state_33488;
if(cljs.core.truth_(inst_33463)){
var statearr_33497_33521 = state_33488__$1;
(statearr_33497_33521[(1)] = (4));

} else {
var statearr_33498_33522 = state_33488__$1;
(statearr_33498_33522[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33489 === (11))){
var inst_33460 = (state_33488[(10)]);
var inst_33477 = (state_33488[(2)]);
var tmp33496 = inst_33460;
var inst_33460__$1 = tmp33496;
var state_33488__$1 = (function (){var statearr_33499 = state_33488;
(statearr_33499[(10)] = inst_33460__$1);

(statearr_33499[(11)] = inst_33477);

return statearr_33499;
})();
var statearr_33500_33523 = state_33488__$1;
(statearr_33500_33523[(2)] = null);

(statearr_33500_33523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33489 === (9))){
var inst_33468 = (state_33488[(7)]);
var state_33488__$1 = state_33488;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33488__$1,(11),out,inst_33468);
} else {
if((state_val_33489 === (5))){
var inst_33482 = cljs.core.async.close_BANG_.call(null,out);
var state_33488__$1 = state_33488;
var statearr_33501_33524 = state_33488__$1;
(statearr_33501_33524[(2)] = inst_33482);

(statearr_33501_33524[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33489 === (10))){
var inst_33480 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
var statearr_33502_33525 = state_33488__$1;
(statearr_33502_33525[(2)] = inst_33480);

(statearr_33502_33525[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33489 === (8))){
var inst_33468 = (state_33488[(7)]);
var inst_33469 = (state_33488[(9)]);
var inst_33460 = (state_33488[(10)]);
var inst_33467 = (state_33488[(8)]);
var inst_33472 = (function (){var cs = inst_33460;
var vec__33465 = inst_33467;
var v = inst_33468;
var c = inst_33469;
return ((function (cs,vec__33465,v,c,inst_33468,inst_33469,inst_33460,inst_33467,state_val_33489,c__23999__auto___33516,out){
return (function (p1__33455_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__33455_SHARP_);
});
;})(cs,vec__33465,v,c,inst_33468,inst_33469,inst_33460,inst_33467,state_val_33489,c__23999__auto___33516,out))
})();
var inst_33473 = cljs.core.filterv.call(null,inst_33472,inst_33460);
var inst_33460__$1 = inst_33473;
var state_33488__$1 = (function (){var statearr_33503 = state_33488;
(statearr_33503[(10)] = inst_33460__$1);

return statearr_33503;
})();
var statearr_33504_33526 = state_33488__$1;
(statearr_33504_33526[(2)] = null);

(statearr_33504_33526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___33516,out))
;
return ((function (switch__23984__auto__,c__23999__auto___33516,out){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_33508 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33508[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_33508[(1)] = (1));

return statearr_33508;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_33488){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_33488);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e33509){if((e33509 instanceof Object)){
var ex__23988__auto__ = e33509;
var statearr_33510_33527 = state_33488;
(statearr_33510_33527[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33488);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33509;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33528 = state_33488;
state_33488 = G__33528;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_33488){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_33488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___33516,out))
})();
var state__24001__auto__ = (function (){var statearr_33511 = f__24000__auto__.call(null);
(statearr_33511[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___33516);

return statearr_33511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___33516,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var args33529 = [];
var len__19567__auto___33578 = arguments.length;
var i__19568__auto___33579 = (0);
while(true){
if((i__19568__auto___33579 < len__19567__auto___33578)){
args33529.push((arguments[i__19568__auto___33579]));

var G__33580 = (i__19568__auto___33579 + (1));
i__19568__auto___33579 = G__33580;
continue;
} else {
}
break;
}

var G__33531 = args33529.length;
switch (G__33531) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33529.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23999__auto___33582 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___33582,out){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___33582,out){
return (function (state_33555){
var state_val_33556 = (state_33555[(1)]);
if((state_val_33556 === (7))){
var inst_33537 = (state_33555[(7)]);
var inst_33537__$1 = (state_33555[(2)]);
var inst_33538 = (inst_33537__$1 == null);
var inst_33539 = cljs.core.not.call(null,inst_33538);
var state_33555__$1 = (function (){var statearr_33557 = state_33555;
(statearr_33557[(7)] = inst_33537__$1);

return statearr_33557;
})();
if(inst_33539){
var statearr_33558_33583 = state_33555__$1;
(statearr_33558_33583[(1)] = (8));

} else {
var statearr_33559_33584 = state_33555__$1;
(statearr_33559_33584[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33556 === (1))){
var inst_33532 = (0);
var state_33555__$1 = (function (){var statearr_33560 = state_33555;
(statearr_33560[(8)] = inst_33532);

return statearr_33560;
})();
var statearr_33561_33585 = state_33555__$1;
(statearr_33561_33585[(2)] = null);

(statearr_33561_33585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33556 === (4))){
var state_33555__$1 = state_33555;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33555__$1,(7),ch);
} else {
if((state_val_33556 === (6))){
var inst_33550 = (state_33555[(2)]);
var state_33555__$1 = state_33555;
var statearr_33562_33586 = state_33555__$1;
(statearr_33562_33586[(2)] = inst_33550);

(statearr_33562_33586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33556 === (3))){
var inst_33552 = (state_33555[(2)]);
var inst_33553 = cljs.core.async.close_BANG_.call(null,out);
var state_33555__$1 = (function (){var statearr_33563 = state_33555;
(statearr_33563[(9)] = inst_33552);

return statearr_33563;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33555__$1,inst_33553);
} else {
if((state_val_33556 === (2))){
var inst_33532 = (state_33555[(8)]);
var inst_33534 = (inst_33532 < n);
var state_33555__$1 = state_33555;
if(cljs.core.truth_(inst_33534)){
var statearr_33564_33587 = state_33555__$1;
(statearr_33564_33587[(1)] = (4));

} else {
var statearr_33565_33588 = state_33555__$1;
(statearr_33565_33588[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33556 === (11))){
var inst_33532 = (state_33555[(8)]);
var inst_33542 = (state_33555[(2)]);
var inst_33543 = (inst_33532 + (1));
var inst_33532__$1 = inst_33543;
var state_33555__$1 = (function (){var statearr_33566 = state_33555;
(statearr_33566[(8)] = inst_33532__$1);

(statearr_33566[(10)] = inst_33542);

return statearr_33566;
})();
var statearr_33567_33589 = state_33555__$1;
(statearr_33567_33589[(2)] = null);

(statearr_33567_33589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33556 === (9))){
var state_33555__$1 = state_33555;
var statearr_33568_33590 = state_33555__$1;
(statearr_33568_33590[(2)] = null);

(statearr_33568_33590[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33556 === (5))){
var state_33555__$1 = state_33555;
var statearr_33569_33591 = state_33555__$1;
(statearr_33569_33591[(2)] = null);

(statearr_33569_33591[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33556 === (10))){
var inst_33547 = (state_33555[(2)]);
var state_33555__$1 = state_33555;
var statearr_33570_33592 = state_33555__$1;
(statearr_33570_33592[(2)] = inst_33547);

(statearr_33570_33592[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33556 === (8))){
var inst_33537 = (state_33555[(7)]);
var state_33555__$1 = state_33555;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33555__$1,(11),out,inst_33537);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___33582,out))
;
return ((function (switch__23984__auto__,c__23999__auto___33582,out){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_33574 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33574[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_33574[(1)] = (1));

return statearr_33574;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_33555){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_33555);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e33575){if((e33575 instanceof Object)){
var ex__23988__auto__ = e33575;
var statearr_33576_33593 = state_33555;
(statearr_33576_33593[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33555);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33575;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33594 = state_33555;
state_33555 = G__33594;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_33555){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_33555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___33582,out))
})();
var state__24001__auto__ = (function (){var statearr_33577 = f__24000__auto__.call(null);
(statearr_33577[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___33582);

return statearr_33577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___33582,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t33602 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t33602 = (function (map_LT_,f,ch,meta33603){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta33603 = meta33603;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t33602.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33604,meta33603__$1){
var self__ = this;
var _33604__$1 = this;
return (new cljs.core.async.t33602(self__.map_LT_,self__.f,self__.ch,meta33603__$1));
});

cljs.core.async.t33602.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33604){
var self__ = this;
var _33604__$1 = this;
return self__.meta33603;
});

cljs.core.async.t33602.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t33602.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t33602.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t33602.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t33602.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t33605 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t33605 = (function (map_LT_,f,ch,meta33603,_,fn1,meta33606){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta33603 = meta33603;
this._ = _;
this.fn1 = fn1;
this.meta33606 = meta33606;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t33605.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33607,meta33606__$1){
var self__ = this;
var _33607__$1 = this;
return (new cljs.core.async.t33605(self__.map_LT_,self__.f,self__.ch,self__.meta33603,self__._,self__.fn1,meta33606__$1));
});})(___$1))
;

cljs.core.async.t33605.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33607){
var self__ = this;
var _33607__$1 = this;
return self__.meta33606;
});})(___$1))
;

cljs.core.async.t33605.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t33605.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t33605.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33595_SHARP_){
return f1.call(null,(((p1__33595_SHARP_ == null))?null:self__.f.call(null,p1__33595_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t33605.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33603","meta33603",-2033330971,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t33602","cljs.core.async/t33602",1670236241,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33606","meta33606",789845241,null)], null);
});})(___$1))
;

cljs.core.async.t33605.cljs$lang$type = true;

cljs.core.async.t33605.cljs$lang$ctorStr = "cljs.core.async/t33605";

cljs.core.async.t33605.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__19107__auto__,writer__19108__auto__,opt__19109__auto__){
return cljs.core._write.call(null,writer__19108__auto__,"cljs.core.async/t33605");
});})(___$1))
;

cljs.core.async.__GT_t33605 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t33605(map_LT___$1,f__$1,ch__$1,meta33603__$1,___$2,fn1__$1,meta33606){
return (new cljs.core.async.t33605(map_LT___$1,f__$1,ch__$1,meta33603__$1,___$2,fn1__$1,meta33606));
});})(___$1))
;

}

return (new cljs.core.async.t33605(self__.map_LT_,self__.f,self__.ch,self__.meta33603,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__18516__auto__ = ret;
if(cljs.core.truth_(and__18516__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__18516__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t33602.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t33602.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t33602.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33603","meta33603",-2033330971,null)], null);
});

cljs.core.async.t33602.cljs$lang$type = true;

cljs.core.async.t33602.cljs$lang$ctorStr = "cljs.core.async/t33602";

cljs.core.async.t33602.cljs$lang$ctorPrWriter = (function (this__19107__auto__,writer__19108__auto__,opt__19109__auto__){
return cljs.core._write.call(null,writer__19108__auto__,"cljs.core.async/t33602");
});

cljs.core.async.__GT_t33602 = (function cljs$core$async$map_LT__$___GT_t33602(map_LT___$1,f__$1,ch__$1,meta33603){
return (new cljs.core.async.t33602(map_LT___$1,f__$1,ch__$1,meta33603));
});

}

return (new cljs.core.async.t33602(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t33611 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t33611 = (function (map_GT_,f,ch,meta33612){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta33612 = meta33612;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t33611.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33613,meta33612__$1){
var self__ = this;
var _33613__$1 = this;
return (new cljs.core.async.t33611(self__.map_GT_,self__.f,self__.ch,meta33612__$1));
});

cljs.core.async.t33611.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33613){
var self__ = this;
var _33613__$1 = this;
return self__.meta33612;
});

cljs.core.async.t33611.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t33611.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t33611.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t33611.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t33611.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t33611.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t33611.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33612","meta33612",819460152,null)], null);
});

cljs.core.async.t33611.cljs$lang$type = true;

cljs.core.async.t33611.cljs$lang$ctorStr = "cljs.core.async/t33611";

cljs.core.async.t33611.cljs$lang$ctorPrWriter = (function (this__19107__auto__,writer__19108__auto__,opt__19109__auto__){
return cljs.core._write.call(null,writer__19108__auto__,"cljs.core.async/t33611");
});

cljs.core.async.__GT_t33611 = (function cljs$core$async$map_GT__$___GT_t33611(map_GT___$1,f__$1,ch__$1,meta33612){
return (new cljs.core.async.t33611(map_GT___$1,f__$1,ch__$1,meta33612));
});

}

return (new cljs.core.async.t33611(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t33617 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t33617 = (function (filter_GT_,p,ch,meta33618){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta33618 = meta33618;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t33617.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33619,meta33618__$1){
var self__ = this;
var _33619__$1 = this;
return (new cljs.core.async.t33617(self__.filter_GT_,self__.p,self__.ch,meta33618__$1));
});

cljs.core.async.t33617.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33619){
var self__ = this;
var _33619__$1 = this;
return self__.meta33618;
});

cljs.core.async.t33617.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t33617.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t33617.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t33617.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t33617.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t33617.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t33617.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t33617.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33618","meta33618",1385745087,null)], null);
});

cljs.core.async.t33617.cljs$lang$type = true;

cljs.core.async.t33617.cljs$lang$ctorStr = "cljs.core.async/t33617";

cljs.core.async.t33617.cljs$lang$ctorPrWriter = (function (this__19107__auto__,writer__19108__auto__,opt__19109__auto__){
return cljs.core._write.call(null,writer__19108__auto__,"cljs.core.async/t33617");
});

cljs.core.async.__GT_t33617 = (function cljs$core$async$filter_GT__$___GT_t33617(filter_GT___$1,p__$1,ch__$1,meta33618){
return (new cljs.core.async.t33617(filter_GT___$1,p__$1,ch__$1,meta33618));
});

}

return (new cljs.core.async.t33617(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var args33620 = [];
var len__19567__auto___33664 = arguments.length;
var i__19568__auto___33665 = (0);
while(true){
if((i__19568__auto___33665 < len__19567__auto___33664)){
args33620.push((arguments[i__19568__auto___33665]));

var G__33666 = (i__19568__auto___33665 + (1));
i__19568__auto___33665 = G__33666;
continue;
} else {
}
break;
}

var G__33622 = args33620.length;
switch (G__33622) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33620.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23999__auto___33668 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___33668,out){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___33668,out){
return (function (state_33643){
var state_val_33644 = (state_33643[(1)]);
if((state_val_33644 === (7))){
var inst_33639 = (state_33643[(2)]);
var state_33643__$1 = state_33643;
var statearr_33645_33669 = state_33643__$1;
(statearr_33645_33669[(2)] = inst_33639);

(statearr_33645_33669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33644 === (1))){
var state_33643__$1 = state_33643;
var statearr_33646_33670 = state_33643__$1;
(statearr_33646_33670[(2)] = null);

(statearr_33646_33670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33644 === (4))){
var inst_33625 = (state_33643[(7)]);
var inst_33625__$1 = (state_33643[(2)]);
var inst_33626 = (inst_33625__$1 == null);
var state_33643__$1 = (function (){var statearr_33647 = state_33643;
(statearr_33647[(7)] = inst_33625__$1);

return statearr_33647;
})();
if(cljs.core.truth_(inst_33626)){
var statearr_33648_33671 = state_33643__$1;
(statearr_33648_33671[(1)] = (5));

} else {
var statearr_33649_33672 = state_33643__$1;
(statearr_33649_33672[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33644 === (6))){
var inst_33625 = (state_33643[(7)]);
var inst_33630 = p.call(null,inst_33625);
var state_33643__$1 = state_33643;
if(cljs.core.truth_(inst_33630)){
var statearr_33650_33673 = state_33643__$1;
(statearr_33650_33673[(1)] = (8));

} else {
var statearr_33651_33674 = state_33643__$1;
(statearr_33651_33674[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33644 === (3))){
var inst_33641 = (state_33643[(2)]);
var state_33643__$1 = state_33643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33643__$1,inst_33641);
} else {
if((state_val_33644 === (2))){
var state_33643__$1 = state_33643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33643__$1,(4),ch);
} else {
if((state_val_33644 === (11))){
var inst_33633 = (state_33643[(2)]);
var state_33643__$1 = state_33643;
var statearr_33652_33675 = state_33643__$1;
(statearr_33652_33675[(2)] = inst_33633);

(statearr_33652_33675[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33644 === (9))){
var state_33643__$1 = state_33643;
var statearr_33653_33676 = state_33643__$1;
(statearr_33653_33676[(2)] = null);

(statearr_33653_33676[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33644 === (5))){
var inst_33628 = cljs.core.async.close_BANG_.call(null,out);
var state_33643__$1 = state_33643;
var statearr_33654_33677 = state_33643__$1;
(statearr_33654_33677[(2)] = inst_33628);

(statearr_33654_33677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33644 === (10))){
var inst_33636 = (state_33643[(2)]);
var state_33643__$1 = (function (){var statearr_33655 = state_33643;
(statearr_33655[(8)] = inst_33636);

return statearr_33655;
})();
var statearr_33656_33678 = state_33643__$1;
(statearr_33656_33678[(2)] = null);

(statearr_33656_33678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33644 === (8))){
var inst_33625 = (state_33643[(7)]);
var state_33643__$1 = state_33643;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33643__$1,(11),out,inst_33625);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___33668,out))
;
return ((function (switch__23984__auto__,c__23999__auto___33668,out){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_33660 = [null,null,null,null,null,null,null,null,null];
(statearr_33660[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_33660[(1)] = (1));

return statearr_33660;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_33643){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_33643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e33661){if((e33661 instanceof Object)){
var ex__23988__auto__ = e33661;
var statearr_33662_33679 = state_33643;
(statearr_33662_33679[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33643);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33661;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33680 = state_33643;
state_33643 = G__33680;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_33643){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_33643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___33668,out))
})();
var state__24001__auto__ = (function (){var statearr_33663 = f__24000__auto__.call(null);
(statearr_33663[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___33668);

return statearr_33663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___33668,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var args33681 = [];
var len__19567__auto___33684 = arguments.length;
var i__19568__auto___33685 = (0);
while(true){
if((i__19568__auto___33685 < len__19567__auto___33684)){
args33681.push((arguments[i__19568__auto___33685]));

var G__33686 = (i__19568__auto___33685 + (1));
i__19568__auto___33685 = G__33686;
continue;
} else {
}
break;
}

var G__33683 = args33681.length;
switch (G__33683) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33681.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__23999__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto__){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto__){
return (function (state_33853){
var state_val_33854 = (state_33853[(1)]);
if((state_val_33854 === (7))){
var inst_33849 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
var statearr_33855_33896 = state_33853__$1;
(statearr_33855_33896[(2)] = inst_33849);

(statearr_33855_33896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (20))){
var inst_33819 = (state_33853[(7)]);
var inst_33830 = (state_33853[(2)]);
var inst_33831 = cljs.core.next.call(null,inst_33819);
var inst_33805 = inst_33831;
var inst_33806 = null;
var inst_33807 = (0);
var inst_33808 = (0);
var state_33853__$1 = (function (){var statearr_33856 = state_33853;
(statearr_33856[(8)] = inst_33806);

(statearr_33856[(9)] = inst_33805);

(statearr_33856[(10)] = inst_33830);

(statearr_33856[(11)] = inst_33807);

(statearr_33856[(12)] = inst_33808);

return statearr_33856;
})();
var statearr_33857_33897 = state_33853__$1;
(statearr_33857_33897[(2)] = null);

(statearr_33857_33897[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (1))){
var state_33853__$1 = state_33853;
var statearr_33858_33898 = state_33853__$1;
(statearr_33858_33898[(2)] = null);

(statearr_33858_33898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (4))){
var inst_33794 = (state_33853[(13)]);
var inst_33794__$1 = (state_33853[(2)]);
var inst_33795 = (inst_33794__$1 == null);
var state_33853__$1 = (function (){var statearr_33859 = state_33853;
(statearr_33859[(13)] = inst_33794__$1);

return statearr_33859;
})();
if(cljs.core.truth_(inst_33795)){
var statearr_33860_33899 = state_33853__$1;
(statearr_33860_33899[(1)] = (5));

} else {
var statearr_33861_33900 = state_33853__$1;
(statearr_33861_33900[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (15))){
var state_33853__$1 = state_33853;
var statearr_33865_33901 = state_33853__$1;
(statearr_33865_33901[(2)] = null);

(statearr_33865_33901[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (21))){
var state_33853__$1 = state_33853;
var statearr_33866_33902 = state_33853__$1;
(statearr_33866_33902[(2)] = null);

(statearr_33866_33902[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (13))){
var inst_33806 = (state_33853[(8)]);
var inst_33805 = (state_33853[(9)]);
var inst_33807 = (state_33853[(11)]);
var inst_33808 = (state_33853[(12)]);
var inst_33815 = (state_33853[(2)]);
var inst_33816 = (inst_33808 + (1));
var tmp33862 = inst_33806;
var tmp33863 = inst_33805;
var tmp33864 = inst_33807;
var inst_33805__$1 = tmp33863;
var inst_33806__$1 = tmp33862;
var inst_33807__$1 = tmp33864;
var inst_33808__$1 = inst_33816;
var state_33853__$1 = (function (){var statearr_33867 = state_33853;
(statearr_33867[(8)] = inst_33806__$1);

(statearr_33867[(9)] = inst_33805__$1);

(statearr_33867[(11)] = inst_33807__$1);

(statearr_33867[(12)] = inst_33808__$1);

(statearr_33867[(14)] = inst_33815);

return statearr_33867;
})();
var statearr_33868_33903 = state_33853__$1;
(statearr_33868_33903[(2)] = null);

(statearr_33868_33903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (22))){
var state_33853__$1 = state_33853;
var statearr_33869_33904 = state_33853__$1;
(statearr_33869_33904[(2)] = null);

(statearr_33869_33904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (6))){
var inst_33794 = (state_33853[(13)]);
var inst_33803 = f.call(null,inst_33794);
var inst_33804 = cljs.core.seq.call(null,inst_33803);
var inst_33805 = inst_33804;
var inst_33806 = null;
var inst_33807 = (0);
var inst_33808 = (0);
var state_33853__$1 = (function (){var statearr_33870 = state_33853;
(statearr_33870[(8)] = inst_33806);

(statearr_33870[(9)] = inst_33805);

(statearr_33870[(11)] = inst_33807);

(statearr_33870[(12)] = inst_33808);

return statearr_33870;
})();
var statearr_33871_33905 = state_33853__$1;
(statearr_33871_33905[(2)] = null);

(statearr_33871_33905[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (17))){
var inst_33819 = (state_33853[(7)]);
var inst_33823 = cljs.core.chunk_first.call(null,inst_33819);
var inst_33824 = cljs.core.chunk_rest.call(null,inst_33819);
var inst_33825 = cljs.core.count.call(null,inst_33823);
var inst_33805 = inst_33824;
var inst_33806 = inst_33823;
var inst_33807 = inst_33825;
var inst_33808 = (0);
var state_33853__$1 = (function (){var statearr_33872 = state_33853;
(statearr_33872[(8)] = inst_33806);

(statearr_33872[(9)] = inst_33805);

(statearr_33872[(11)] = inst_33807);

(statearr_33872[(12)] = inst_33808);

return statearr_33872;
})();
var statearr_33873_33906 = state_33853__$1;
(statearr_33873_33906[(2)] = null);

(statearr_33873_33906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (3))){
var inst_33851 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33853__$1,inst_33851);
} else {
if((state_val_33854 === (12))){
var inst_33839 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
var statearr_33874_33907 = state_33853__$1;
(statearr_33874_33907[(2)] = inst_33839);

(statearr_33874_33907[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (2))){
var state_33853__$1 = state_33853;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33853__$1,(4),in$);
} else {
if((state_val_33854 === (23))){
var inst_33847 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
var statearr_33875_33908 = state_33853__$1;
(statearr_33875_33908[(2)] = inst_33847);

(statearr_33875_33908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (19))){
var inst_33834 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
var statearr_33876_33909 = state_33853__$1;
(statearr_33876_33909[(2)] = inst_33834);

(statearr_33876_33909[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (11))){
var inst_33805 = (state_33853[(9)]);
var inst_33819 = (state_33853[(7)]);
var inst_33819__$1 = cljs.core.seq.call(null,inst_33805);
var state_33853__$1 = (function (){var statearr_33877 = state_33853;
(statearr_33877[(7)] = inst_33819__$1);

return statearr_33877;
})();
if(inst_33819__$1){
var statearr_33878_33910 = state_33853__$1;
(statearr_33878_33910[(1)] = (14));

} else {
var statearr_33879_33911 = state_33853__$1;
(statearr_33879_33911[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (9))){
var inst_33841 = (state_33853[(2)]);
var inst_33842 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_33853__$1 = (function (){var statearr_33880 = state_33853;
(statearr_33880[(15)] = inst_33841);

return statearr_33880;
})();
if(cljs.core.truth_(inst_33842)){
var statearr_33881_33912 = state_33853__$1;
(statearr_33881_33912[(1)] = (21));

} else {
var statearr_33882_33913 = state_33853__$1;
(statearr_33882_33913[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (5))){
var inst_33797 = cljs.core.async.close_BANG_.call(null,out);
var state_33853__$1 = state_33853;
var statearr_33883_33914 = state_33853__$1;
(statearr_33883_33914[(2)] = inst_33797);

(statearr_33883_33914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (14))){
var inst_33819 = (state_33853[(7)]);
var inst_33821 = cljs.core.chunked_seq_QMARK_.call(null,inst_33819);
var state_33853__$1 = state_33853;
if(inst_33821){
var statearr_33884_33915 = state_33853__$1;
(statearr_33884_33915[(1)] = (17));

} else {
var statearr_33885_33916 = state_33853__$1;
(statearr_33885_33916[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (16))){
var inst_33837 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
var statearr_33886_33917 = state_33853__$1;
(statearr_33886_33917[(2)] = inst_33837);

(statearr_33886_33917[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (10))){
var inst_33806 = (state_33853[(8)]);
var inst_33808 = (state_33853[(12)]);
var inst_33813 = cljs.core._nth.call(null,inst_33806,inst_33808);
var state_33853__$1 = state_33853;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33853__$1,(13),out,inst_33813);
} else {
if((state_val_33854 === (18))){
var inst_33819 = (state_33853[(7)]);
var inst_33828 = cljs.core.first.call(null,inst_33819);
var state_33853__$1 = state_33853;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33853__$1,(20),out,inst_33828);
} else {
if((state_val_33854 === (8))){
var inst_33807 = (state_33853[(11)]);
var inst_33808 = (state_33853[(12)]);
var inst_33810 = (inst_33808 < inst_33807);
var inst_33811 = inst_33810;
var state_33853__$1 = state_33853;
if(cljs.core.truth_(inst_33811)){
var statearr_33887_33918 = state_33853__$1;
(statearr_33887_33918[(1)] = (10));

} else {
var statearr_33888_33919 = state_33853__$1;
(statearr_33888_33919[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto__))
;
return ((function (switch__23984__auto__,c__23999__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__23985__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__23985__auto____0 = (function (){
var statearr_33892 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33892[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__23985__auto__);

(statearr_33892[(1)] = (1));

return statearr_33892;
});
var cljs$core$async$mapcat_STAR__$_state_machine__23985__auto____1 = (function (state_33853){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_33853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e33893){if((e33893 instanceof Object)){
var ex__23988__auto__ = e33893;
var statearr_33894_33920 = state_33853;
(statearr_33894_33920[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33853);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33893;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33921 = state_33853;
state_33853 = G__33921;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__23985__auto__ = function(state_33853){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__23985__auto____1.call(this,state_33853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__23985__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__23985__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto__))
})();
var state__24001__auto__ = (function (){var statearr_33895 = f__24000__auto__.call(null);
(statearr_33895[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto__);

return statearr_33895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto__))
);

return c__23999__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var args33922 = [];
var len__19567__auto___33925 = arguments.length;
var i__19568__auto___33926 = (0);
while(true){
if((i__19568__auto___33926 < len__19567__auto___33925)){
args33922.push((arguments[i__19568__auto___33926]));

var G__33927 = (i__19568__auto___33926 + (1));
i__19568__auto___33926 = G__33927;
continue;
} else {
}
break;
}

var G__33924 = args33922.length;
switch (G__33924) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33922.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var args33929 = [];
var len__19567__auto___33932 = arguments.length;
var i__19568__auto___33933 = (0);
while(true){
if((i__19568__auto___33933 < len__19567__auto___33932)){
args33929.push((arguments[i__19568__auto___33933]));

var G__33934 = (i__19568__auto___33933 + (1));
i__19568__auto___33933 = G__33934;
continue;
} else {
}
break;
}

var G__33931 = args33929.length;
switch (G__33931) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33929.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var args33936 = [];
var len__19567__auto___33987 = arguments.length;
var i__19568__auto___33988 = (0);
while(true){
if((i__19568__auto___33988 < len__19567__auto___33987)){
args33936.push((arguments[i__19568__auto___33988]));

var G__33989 = (i__19568__auto___33988 + (1));
i__19568__auto___33988 = G__33989;
continue;
} else {
}
break;
}

var G__33938 = args33936.length;
switch (G__33938) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33936.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23999__auto___33991 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___33991,out){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___33991,out){
return (function (state_33962){
var state_val_33963 = (state_33962[(1)]);
if((state_val_33963 === (7))){
var inst_33957 = (state_33962[(2)]);
var state_33962__$1 = state_33962;
var statearr_33964_33992 = state_33962__$1;
(statearr_33964_33992[(2)] = inst_33957);

(statearr_33964_33992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33963 === (1))){
var inst_33939 = null;
var state_33962__$1 = (function (){var statearr_33965 = state_33962;
(statearr_33965[(7)] = inst_33939);

return statearr_33965;
})();
var statearr_33966_33993 = state_33962__$1;
(statearr_33966_33993[(2)] = null);

(statearr_33966_33993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33963 === (4))){
var inst_33942 = (state_33962[(8)]);
var inst_33942__$1 = (state_33962[(2)]);
var inst_33943 = (inst_33942__$1 == null);
var inst_33944 = cljs.core.not.call(null,inst_33943);
var state_33962__$1 = (function (){var statearr_33967 = state_33962;
(statearr_33967[(8)] = inst_33942__$1);

return statearr_33967;
})();
if(inst_33944){
var statearr_33968_33994 = state_33962__$1;
(statearr_33968_33994[(1)] = (5));

} else {
var statearr_33969_33995 = state_33962__$1;
(statearr_33969_33995[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33963 === (6))){
var state_33962__$1 = state_33962;
var statearr_33970_33996 = state_33962__$1;
(statearr_33970_33996[(2)] = null);

(statearr_33970_33996[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33963 === (3))){
var inst_33959 = (state_33962[(2)]);
var inst_33960 = cljs.core.async.close_BANG_.call(null,out);
var state_33962__$1 = (function (){var statearr_33971 = state_33962;
(statearr_33971[(9)] = inst_33959);

return statearr_33971;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33962__$1,inst_33960);
} else {
if((state_val_33963 === (2))){
var state_33962__$1 = state_33962;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33962__$1,(4),ch);
} else {
if((state_val_33963 === (11))){
var inst_33942 = (state_33962[(8)]);
var inst_33951 = (state_33962[(2)]);
var inst_33939 = inst_33942;
var state_33962__$1 = (function (){var statearr_33972 = state_33962;
(statearr_33972[(10)] = inst_33951);

(statearr_33972[(7)] = inst_33939);

return statearr_33972;
})();
var statearr_33973_33997 = state_33962__$1;
(statearr_33973_33997[(2)] = null);

(statearr_33973_33997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33963 === (9))){
var inst_33942 = (state_33962[(8)]);
var state_33962__$1 = state_33962;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33962__$1,(11),out,inst_33942);
} else {
if((state_val_33963 === (5))){
var inst_33942 = (state_33962[(8)]);
var inst_33939 = (state_33962[(7)]);
var inst_33946 = cljs.core._EQ_.call(null,inst_33942,inst_33939);
var state_33962__$1 = state_33962;
if(inst_33946){
var statearr_33975_33998 = state_33962__$1;
(statearr_33975_33998[(1)] = (8));

} else {
var statearr_33976_33999 = state_33962__$1;
(statearr_33976_33999[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33963 === (10))){
var inst_33954 = (state_33962[(2)]);
var state_33962__$1 = state_33962;
var statearr_33977_34000 = state_33962__$1;
(statearr_33977_34000[(2)] = inst_33954);

(statearr_33977_34000[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33963 === (8))){
var inst_33939 = (state_33962[(7)]);
var tmp33974 = inst_33939;
var inst_33939__$1 = tmp33974;
var state_33962__$1 = (function (){var statearr_33978 = state_33962;
(statearr_33978[(7)] = inst_33939__$1);

return statearr_33978;
})();
var statearr_33979_34001 = state_33962__$1;
(statearr_33979_34001[(2)] = null);

(statearr_33979_34001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___33991,out))
;
return ((function (switch__23984__auto__,c__23999__auto___33991,out){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_33983 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33983[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_33983[(1)] = (1));

return statearr_33983;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_33962){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_33962);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e33984){if((e33984 instanceof Object)){
var ex__23988__auto__ = e33984;
var statearr_33985_34002 = state_33962;
(statearr_33985_34002[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33962);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33984;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34003 = state_33962;
state_33962 = G__34003;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_33962){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_33962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___33991,out))
})();
var state__24001__auto__ = (function (){var statearr_33986 = f__24000__auto__.call(null);
(statearr_33986[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___33991);

return statearr_33986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___33991,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var args34004 = [];
var len__19567__auto___34074 = arguments.length;
var i__19568__auto___34075 = (0);
while(true){
if((i__19568__auto___34075 < len__19567__auto___34074)){
args34004.push((arguments[i__19568__auto___34075]));

var G__34076 = (i__19568__auto___34075 + (1));
i__19568__auto___34075 = G__34076;
continue;
} else {
}
break;
}

var G__34006 = args34004.length;
switch (G__34006) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34004.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23999__auto___34078 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___34078,out){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___34078,out){
return (function (state_34044){
var state_val_34045 = (state_34044[(1)]);
if((state_val_34045 === (7))){
var inst_34040 = (state_34044[(2)]);
var state_34044__$1 = state_34044;
var statearr_34046_34079 = state_34044__$1;
(statearr_34046_34079[(2)] = inst_34040);

(statearr_34046_34079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34045 === (1))){
var inst_34007 = (new Array(n));
var inst_34008 = inst_34007;
var inst_34009 = (0);
var state_34044__$1 = (function (){var statearr_34047 = state_34044;
(statearr_34047[(7)] = inst_34008);

(statearr_34047[(8)] = inst_34009);

return statearr_34047;
})();
var statearr_34048_34080 = state_34044__$1;
(statearr_34048_34080[(2)] = null);

(statearr_34048_34080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34045 === (4))){
var inst_34012 = (state_34044[(9)]);
var inst_34012__$1 = (state_34044[(2)]);
var inst_34013 = (inst_34012__$1 == null);
var inst_34014 = cljs.core.not.call(null,inst_34013);
var state_34044__$1 = (function (){var statearr_34049 = state_34044;
(statearr_34049[(9)] = inst_34012__$1);

return statearr_34049;
})();
if(inst_34014){
var statearr_34050_34081 = state_34044__$1;
(statearr_34050_34081[(1)] = (5));

} else {
var statearr_34051_34082 = state_34044__$1;
(statearr_34051_34082[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34045 === (15))){
var inst_34034 = (state_34044[(2)]);
var state_34044__$1 = state_34044;
var statearr_34052_34083 = state_34044__$1;
(statearr_34052_34083[(2)] = inst_34034);

(statearr_34052_34083[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34045 === (13))){
var state_34044__$1 = state_34044;
var statearr_34053_34084 = state_34044__$1;
(statearr_34053_34084[(2)] = null);

(statearr_34053_34084[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34045 === (6))){
var inst_34009 = (state_34044[(8)]);
var inst_34030 = (inst_34009 > (0));
var state_34044__$1 = state_34044;
if(cljs.core.truth_(inst_34030)){
var statearr_34054_34085 = state_34044__$1;
(statearr_34054_34085[(1)] = (12));

} else {
var statearr_34055_34086 = state_34044__$1;
(statearr_34055_34086[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34045 === (3))){
var inst_34042 = (state_34044[(2)]);
var state_34044__$1 = state_34044;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34044__$1,inst_34042);
} else {
if((state_val_34045 === (12))){
var inst_34008 = (state_34044[(7)]);
var inst_34032 = cljs.core.vec.call(null,inst_34008);
var state_34044__$1 = state_34044;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34044__$1,(15),out,inst_34032);
} else {
if((state_val_34045 === (2))){
var state_34044__$1 = state_34044;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34044__$1,(4),ch);
} else {
if((state_val_34045 === (11))){
var inst_34024 = (state_34044[(2)]);
var inst_34025 = (new Array(n));
var inst_34008 = inst_34025;
var inst_34009 = (0);
var state_34044__$1 = (function (){var statearr_34056 = state_34044;
(statearr_34056[(10)] = inst_34024);

(statearr_34056[(7)] = inst_34008);

(statearr_34056[(8)] = inst_34009);

return statearr_34056;
})();
var statearr_34057_34087 = state_34044__$1;
(statearr_34057_34087[(2)] = null);

(statearr_34057_34087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34045 === (9))){
var inst_34008 = (state_34044[(7)]);
var inst_34022 = cljs.core.vec.call(null,inst_34008);
var state_34044__$1 = state_34044;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34044__$1,(11),out,inst_34022);
} else {
if((state_val_34045 === (5))){
var inst_34012 = (state_34044[(9)]);
var inst_34017 = (state_34044[(11)]);
var inst_34008 = (state_34044[(7)]);
var inst_34009 = (state_34044[(8)]);
var inst_34016 = (inst_34008[inst_34009] = inst_34012);
var inst_34017__$1 = (inst_34009 + (1));
var inst_34018 = (inst_34017__$1 < n);
var state_34044__$1 = (function (){var statearr_34058 = state_34044;
(statearr_34058[(12)] = inst_34016);

(statearr_34058[(11)] = inst_34017__$1);

return statearr_34058;
})();
if(cljs.core.truth_(inst_34018)){
var statearr_34059_34088 = state_34044__$1;
(statearr_34059_34088[(1)] = (8));

} else {
var statearr_34060_34089 = state_34044__$1;
(statearr_34060_34089[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34045 === (14))){
var inst_34037 = (state_34044[(2)]);
var inst_34038 = cljs.core.async.close_BANG_.call(null,out);
var state_34044__$1 = (function (){var statearr_34062 = state_34044;
(statearr_34062[(13)] = inst_34037);

return statearr_34062;
})();
var statearr_34063_34090 = state_34044__$1;
(statearr_34063_34090[(2)] = inst_34038);

(statearr_34063_34090[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34045 === (10))){
var inst_34028 = (state_34044[(2)]);
var state_34044__$1 = state_34044;
var statearr_34064_34091 = state_34044__$1;
(statearr_34064_34091[(2)] = inst_34028);

(statearr_34064_34091[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34045 === (8))){
var inst_34017 = (state_34044[(11)]);
var inst_34008 = (state_34044[(7)]);
var tmp34061 = inst_34008;
var inst_34008__$1 = tmp34061;
var inst_34009 = inst_34017;
var state_34044__$1 = (function (){var statearr_34065 = state_34044;
(statearr_34065[(7)] = inst_34008__$1);

(statearr_34065[(8)] = inst_34009);

return statearr_34065;
})();
var statearr_34066_34092 = state_34044__$1;
(statearr_34066_34092[(2)] = null);

(statearr_34066_34092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___34078,out))
;
return ((function (switch__23984__auto__,c__23999__auto___34078,out){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_34070 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34070[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_34070[(1)] = (1));

return statearr_34070;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_34044){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_34044);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e34071){if((e34071 instanceof Object)){
var ex__23988__auto__ = e34071;
var statearr_34072_34093 = state_34044;
(statearr_34072_34093[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34044);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34071;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34094 = state_34044;
state_34044 = G__34094;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_34044){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_34044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___34078,out))
})();
var state__24001__auto__ = (function (){var statearr_34073 = f__24000__auto__.call(null);
(statearr_34073[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___34078);

return statearr_34073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___34078,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var args34095 = [];
var len__19567__auto___34169 = arguments.length;
var i__19568__auto___34170 = (0);
while(true){
if((i__19568__auto___34170 < len__19567__auto___34169)){
args34095.push((arguments[i__19568__auto___34170]));

var G__34171 = (i__19568__auto___34170 + (1));
i__19568__auto___34170 = G__34171;
continue;
} else {
}
break;
}

var G__34097 = args34095.length;
switch (G__34097) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34095.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23999__auto___34173 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___34173,out){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___34173,out){
return (function (state_34139){
var state_val_34140 = (state_34139[(1)]);
if((state_val_34140 === (7))){
var inst_34135 = (state_34139[(2)]);
var state_34139__$1 = state_34139;
var statearr_34141_34174 = state_34139__$1;
(statearr_34141_34174[(2)] = inst_34135);

(statearr_34141_34174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34140 === (1))){
var inst_34098 = [];
var inst_34099 = inst_34098;
var inst_34100 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_34139__$1 = (function (){var statearr_34142 = state_34139;
(statearr_34142[(7)] = inst_34100);

(statearr_34142[(8)] = inst_34099);

return statearr_34142;
})();
var statearr_34143_34175 = state_34139__$1;
(statearr_34143_34175[(2)] = null);

(statearr_34143_34175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34140 === (4))){
var inst_34103 = (state_34139[(9)]);
var inst_34103__$1 = (state_34139[(2)]);
var inst_34104 = (inst_34103__$1 == null);
var inst_34105 = cljs.core.not.call(null,inst_34104);
var state_34139__$1 = (function (){var statearr_34144 = state_34139;
(statearr_34144[(9)] = inst_34103__$1);

return statearr_34144;
})();
if(inst_34105){
var statearr_34145_34176 = state_34139__$1;
(statearr_34145_34176[(1)] = (5));

} else {
var statearr_34146_34177 = state_34139__$1;
(statearr_34146_34177[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34140 === (15))){
var inst_34129 = (state_34139[(2)]);
var state_34139__$1 = state_34139;
var statearr_34147_34178 = state_34139__$1;
(statearr_34147_34178[(2)] = inst_34129);

(statearr_34147_34178[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34140 === (13))){
var state_34139__$1 = state_34139;
var statearr_34148_34179 = state_34139__$1;
(statearr_34148_34179[(2)] = null);

(statearr_34148_34179[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34140 === (6))){
var inst_34099 = (state_34139[(8)]);
var inst_34124 = inst_34099.length;
var inst_34125 = (inst_34124 > (0));
var state_34139__$1 = state_34139;
if(cljs.core.truth_(inst_34125)){
var statearr_34149_34180 = state_34139__$1;
(statearr_34149_34180[(1)] = (12));

} else {
var statearr_34150_34181 = state_34139__$1;
(statearr_34150_34181[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34140 === (3))){
var inst_34137 = (state_34139[(2)]);
var state_34139__$1 = state_34139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34139__$1,inst_34137);
} else {
if((state_val_34140 === (12))){
var inst_34099 = (state_34139[(8)]);
var inst_34127 = cljs.core.vec.call(null,inst_34099);
var state_34139__$1 = state_34139;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34139__$1,(15),out,inst_34127);
} else {
if((state_val_34140 === (2))){
var state_34139__$1 = state_34139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34139__$1,(4),ch);
} else {
if((state_val_34140 === (11))){
var inst_34107 = (state_34139[(10)]);
var inst_34103 = (state_34139[(9)]);
var inst_34117 = (state_34139[(2)]);
var inst_34118 = [];
var inst_34119 = inst_34118.push(inst_34103);
var inst_34099 = inst_34118;
var inst_34100 = inst_34107;
var state_34139__$1 = (function (){var statearr_34151 = state_34139;
(statearr_34151[(7)] = inst_34100);

(statearr_34151[(11)] = inst_34117);

(statearr_34151[(12)] = inst_34119);

(statearr_34151[(8)] = inst_34099);

return statearr_34151;
})();
var statearr_34152_34182 = state_34139__$1;
(statearr_34152_34182[(2)] = null);

(statearr_34152_34182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34140 === (9))){
var inst_34099 = (state_34139[(8)]);
var inst_34115 = cljs.core.vec.call(null,inst_34099);
var state_34139__$1 = state_34139;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34139__$1,(11),out,inst_34115);
} else {
if((state_val_34140 === (5))){
var inst_34107 = (state_34139[(10)]);
var inst_34103 = (state_34139[(9)]);
var inst_34100 = (state_34139[(7)]);
var inst_34107__$1 = f.call(null,inst_34103);
var inst_34108 = cljs.core._EQ_.call(null,inst_34107__$1,inst_34100);
var inst_34109 = cljs.core.keyword_identical_QMARK_.call(null,inst_34100,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_34110 = (inst_34108) || (inst_34109);
var state_34139__$1 = (function (){var statearr_34153 = state_34139;
(statearr_34153[(10)] = inst_34107__$1);

return statearr_34153;
})();
if(cljs.core.truth_(inst_34110)){
var statearr_34154_34183 = state_34139__$1;
(statearr_34154_34183[(1)] = (8));

} else {
var statearr_34155_34184 = state_34139__$1;
(statearr_34155_34184[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34140 === (14))){
var inst_34132 = (state_34139[(2)]);
var inst_34133 = cljs.core.async.close_BANG_.call(null,out);
var state_34139__$1 = (function (){var statearr_34157 = state_34139;
(statearr_34157[(13)] = inst_34132);

return statearr_34157;
})();
var statearr_34158_34185 = state_34139__$1;
(statearr_34158_34185[(2)] = inst_34133);

(statearr_34158_34185[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34140 === (10))){
var inst_34122 = (state_34139[(2)]);
var state_34139__$1 = state_34139;
var statearr_34159_34186 = state_34139__$1;
(statearr_34159_34186[(2)] = inst_34122);

(statearr_34159_34186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34140 === (8))){
var inst_34107 = (state_34139[(10)]);
var inst_34103 = (state_34139[(9)]);
var inst_34099 = (state_34139[(8)]);
var inst_34112 = inst_34099.push(inst_34103);
var tmp34156 = inst_34099;
var inst_34099__$1 = tmp34156;
var inst_34100 = inst_34107;
var state_34139__$1 = (function (){var statearr_34160 = state_34139;
(statearr_34160[(14)] = inst_34112);

(statearr_34160[(7)] = inst_34100);

(statearr_34160[(8)] = inst_34099__$1);

return statearr_34160;
})();
var statearr_34161_34187 = state_34139__$1;
(statearr_34161_34187[(2)] = null);

(statearr_34161_34187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto___34173,out))
;
return ((function (switch__23984__auto__,c__23999__auto___34173,out){
return (function() {
var cljs$core$async$state_machine__23985__auto__ = null;
var cljs$core$async$state_machine__23985__auto____0 = (function (){
var statearr_34165 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34165[(0)] = cljs$core$async$state_machine__23985__auto__);

(statearr_34165[(1)] = (1));

return statearr_34165;
});
var cljs$core$async$state_machine__23985__auto____1 = (function (state_34139){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_34139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e34166){if((e34166 instanceof Object)){
var ex__23988__auto__ = e34166;
var statearr_34167_34188 = state_34139;
(statearr_34167_34188[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34139);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34166;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34189 = state_34139;
state_34139 = G__34189;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
cljs$core$async$state_machine__23985__auto__ = function(state_34139){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23985__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23985__auto____1.call(this,state_34139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23985__auto____0;
cljs$core$async$state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23985__auto____1;
return cljs$core$async$state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___34173,out))
})();
var state__24001__auto__ = (function (){var statearr_34168 = f__24000__auto__.call(null);
(statearr_34168[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___34173);

return statearr_34168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___34173,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map