// Compiled by ClojureScript 1.7.48 {}
goog.provide('dragonmark.inputs.validation');
goog.require('cljs.core');
goog.require('dragonmark.inputs.schemas');
goog.require('schema.core');
goog.require('dragonmark.inputs.date_utils');
goog.require('jkkramer.verily');
goog.require('schema.coerce');
goog.require('clojure.set');
goog.require('dragonmark.inputs.extern');
goog.require('clojure.string');
/**
 * The validation error message keys for a field.
 * The key is not the rule key but the message key.
 */
dragonmark.inputs.validation.sch_errors_list = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.named.call(null,schema.core.Keyword,"message")], null);
/**
 * Describes the input's error data structure.
 * A field can have multiples errors.
 */
dragonmark.inputs.validation.sch_errors = new cljs.core.PersistentArrayMap.fromArray([dragonmark.inputs.schemas.sch_field,dragonmark.inputs.validation.sch_errors_list], true, false);
/**
 * Describes the Verily errors data structure.
 */
dragonmark.inputs.validation.sch_verily_errs = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dragonmark.inputs.schemas.sch_field], null),new cljs.core.Keyword(null,"msg","msg",-1386103444),schema.core.Keyword], null)], null);
/**
 * Describes the Schema errors data structure
 */
dragonmark.inputs.validation.sch_schema_errs = new cljs.core.PersistentArrayMap.fromArray([dragonmark.inputs.schemas.sch_field,schema.core.Any], true, false);
/**
 * Do not validate an empty string as a valid s/Str
 */
dragonmark.inputs.validation.empty_string_coercer = (function dragonmark$inputs$validation$empty_string_coercer(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return s;
}
});
/**
 * Coerce an input string to a date.
 * The default format is used.
 * A blank string is coerced to nil.
 */
dragonmark.inputs.validation.inst_coercer = (function dragonmark$inputs$validation$inst_coercer(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return dragonmark.inputs.date_utils.parse.call(null,dragonmark.inputs.date_utils.fmt.call(null,dragonmark.inputs.date_utils.default_fmt,s));
}
});
/**
 * Schema coercers used for inputs that are sent as string.
 */
dragonmark.inputs.validation.validation_coercer = new cljs.core.PersistentArrayMap.fromArray([schema.core.Num,schema.coerce.safe.call(null,schema.coerce.edn_read_string),schema.core.Regex,dragonmark.inputs.validation.empty_string_coercer,schema.core.Str,dragonmark.inputs.validation.empty_string_coercer,schema.core.maybe.call(null,schema.core.Str),dragonmark.inputs.validation.empty_string_coercer,schema.core.Inst,dragonmark.inputs.validation.inst_coercer], true, false);
/**
 * Generic sequence of validation.
 * The first args can be partially applied to generate a custom validator.
 */
dragonmark.inputs.validation.validate = (function dragonmark$inputs$validation$validate(validation_fn,post,m){
return post.call(null,validation_fn.call(null,m));
});
var ufv___27512 = schema.utils.use_fn_validation;
var output_schema27491_27513 = dragonmark.inputs.validation.sch_errors;
var input_schema27492_27514 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.validation.sch_schema_errs,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-schema-errs","sch-schema-errs",1633294259,null)], null)))], null);
var input_checker27493_27515 = schema.core.checker.call(null,input_schema27492_27514);
var output_checker27494_27516 = schema.core.checker.call(null,output_schema27491_27513);
/**
 * Inputs: [errs :- sch-schema-errs]
 * Returns: sch-errors
 * 
 * Transforms the Schema's error data structure into the common error data structure.
 * For the moment Schema error are treated as missing field.
 */
dragonmark.inputs.validation.transform_schema_errors = ((function (ufv___27512,output_schema27491_27513,input_schema27492_27514,input_checker27493_27515,output_checker27494_27516){
return (function dragonmark$inputs$validation$transform_schema_errors(G__27495){
var validate__20921__auto__ = ufv___27512.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27517 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27495], null);
var temp__4425__auto___27518 = input_checker27493_27515.call(null,args__20922__auto___27517);
if(cljs.core.truth_(temp__4425__auto___27518)){
var error__20923__auto___27519 = temp__4425__auto___27518;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-schema-errors","transform-schema-errors",1319365661,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Schema's error data structure into the common error data structure.\n  For the moment Schema error are treated as missing field."], null)),cljs.core.pr_str.call(null,error__20923__auto___27519)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27492_27514,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27517,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27519], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var errs = G__27495;
while(true){
var temp__4425__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(errs);
if(cljs.core.truth_(temp__4425__auto__)){
var errors = temp__4425__auto__;
return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.concat,(function (){var iter__19281__auto__ = ((function (errors,temp__4425__auto__,validate__20921__auto__,ufv___27512,output_schema27491_27513,input_schema27492_27514,input_checker27493_27515,output_checker27494_27516){
return (function dragonmark$inputs$validation$transform_schema_errors_$_iter__27504(s__27505){
return (new cljs.core.LazySeq(null,((function (errors,temp__4425__auto__,validate__20921__auto__,ufv___27512,output_schema27491_27513,input_schema27492_27514,input_checker27493_27515,output_checker27494_27516){
return (function (){
var s__27505__$1 = s__27505;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__27505__$1);
if(temp__4425__auto____$1){
var s__27505__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27505__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__27505__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__27507 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__27506 = (0);
while(true){
if((i__27506 < size__19280__auto__)){
var vec__27510 = cljs.core._nth.call(null,c__19279__auto__,i__27506);
var k = cljs.core.nth.call(null,vec__27510,(0),null);
var _ = cljs.core.nth.call(null,vec__27510,(1),null);
cljs.core.chunk_append.call(null,b__27507,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mandatory","mandatory",542802336)], null)], true, false));

var G__27520 = (i__27506 + (1));
i__27506 = G__27520;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27507),dragonmark$inputs$validation$transform_schema_errors_$_iter__27504.call(null,cljs.core.chunk_rest.call(null,s__27505__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27507),null);
}
} else {
var vec__27511 = cljs.core.first.call(null,s__27505__$2);
var k = cljs.core.nth.call(null,vec__27511,(0),null);
var _ = cljs.core.nth.call(null,vec__27511,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mandatory","mandatory",542802336)], null)], true, false),dragonmark$inputs$validation$transform_schema_errors_$_iter__27504.call(null,cljs.core.rest.call(null,s__27505__$2)));
}
} else {
return null;
}
break;
}
});})(errors,temp__4425__auto__,validate__20921__auto__,ufv___27512,output_schema27491_27513,input_schema27492_27514,input_checker27493_27515,output_checker27494_27516))
,null,null));
});})(errors,temp__4425__auto__,validate__20921__auto__,ufv___27512,output_schema27491_27513,input_schema27492_27514,input_checker27493_27515,output_checker27494_27516))
;
return iter__19281__auto__.call(null,errors);
})());
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27521 = output_checker27494_27516.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27521)){
var error__20923__auto___27522 = temp__4425__auto___27521;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-schema-errors","transform-schema-errors",1319365661,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Schema's error data structure into the common error data structure.\n  For the moment Schema error are treated as missing field."], null)),cljs.core.pr_str.call(null,error__20923__auto___27522)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27491_27513,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27522], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27512,output_schema27491_27513,input_schema27492_27514,input_checker27493_27515,output_checker27494_27516))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.transform_schema_errors),schema.core.make_fn_schema.call(null,output_schema27491_27513,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27492_27514], null)));
var ufv___27548 = schema.utils.use_fn_validation;
var output_schema27523_27549 = dragonmark.inputs.validation.sch_errors;
var input_schema27524_27550 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.validation.sch_verily_errs,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-verily-errs","sch-verily-errs",-1962614795,null)], null)))], null);
var input_checker27525_27551 = schema.core.checker.call(null,input_schema27524_27550);
var output_checker27526_27552 = schema.core.checker.call(null,output_schema27523_27549);
/**
 * Inputs: [errs :- sch-verily-errs]
 * Returns: sch-errors
 * 
 * Transforms the Verily's error data structure into the common error data structure.
 */
dragonmark.inputs.validation.transform_verily_errors = ((function (ufv___27548,output_schema27523_27549,input_schema27524_27550,input_checker27525_27551,output_checker27526_27552){
return (function dragonmark$inputs$validation$transform_verily_errors(G__27527){
var validate__20921__auto__ = ufv___27548.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27553 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27527], null);
var temp__4425__auto___27554 = input_checker27525_27551.call(null,args__20922__auto___27553);
if(cljs.core.truth_(temp__4425__auto___27554)){
var error__20923__auto___27555 = temp__4425__auto___27554;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-verily-errors","transform-verily-errors",-197737448,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Verily's error data structure into the common error data structure."], null)),cljs.core.pr_str.call(null,error__20923__auto___27555)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27524_27550,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27553,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27555], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var errs = G__27527;
while(true){
if(cljs.core.seq.call(null,errs)){
return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.concat,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19281__auto__ = ((function (validate__20921__auto__,ufv___27548,output_schema27523_27549,input_schema27524_27550,input_checker27525_27551,output_checker27526_27552){
return (function dragonmark$inputs$validation$transform_verily_errors_$_iter__27538(s__27539){
return (new cljs.core.LazySeq(null,((function (validate__20921__auto__,ufv___27548,output_schema27523_27549,input_schema27524_27550,input_checker27525_27551,output_checker27526_27552){
return (function (){
var s__27539__$1 = s__27539;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__27539__$1);
if(temp__4425__auto__){
var xs__4977__auto__ = temp__4425__auto__;
var map__27546 = cljs.core.first.call(null,xs__4977__auto__);
var map__27546__$1 = ((((!((map__27546 == null)))?((((map__27546.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27546.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27546):map__27546);
var keys = cljs.core.get.call(null,map__27546__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var msg = cljs.core.get.call(null,map__27546__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var iterys__19277__auto__ = ((function (s__27539__$1,map__27546,map__27546__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__20921__auto__,ufv___27548,output_schema27523_27549,input_schema27524_27550,input_checker27525_27551,output_checker27526_27552){
return (function dragonmark$inputs$validation$transform_verily_errors_$_iter__27538_$_iter__27540(s__27541){
return (new cljs.core.LazySeq(null,((function (s__27539__$1,map__27546,map__27546__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__20921__auto__,ufv___27548,output_schema27523_27549,input_schema27524_27550,input_checker27525_27551,output_checker27526_27552){
return (function (){
var s__27541__$1 = s__27541;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__27541__$1);
if(temp__4425__auto____$1){
var s__27541__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27541__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__27541__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__27543 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__27542 = (0);
while(true){
if((i__27542 < size__19280__auto__)){
var k = cljs.core._nth.call(null,c__19279__auto__,i__27542);
cljs.core.chunk_append.call(null,b__27543,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null)], true, false));

var G__27556 = (i__27542 + (1));
i__27542 = G__27556;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27543),dragonmark$inputs$validation$transform_verily_errors_$_iter__27538_$_iter__27540.call(null,cljs.core.chunk_rest.call(null,s__27541__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27543),null);
}
} else {
var k = cljs.core.first.call(null,s__27541__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null)], true, false),dragonmark$inputs$validation$transform_verily_errors_$_iter__27538_$_iter__27540.call(null,cljs.core.rest.call(null,s__27541__$2)));
}
} else {
return null;
}
break;
}
});})(s__27539__$1,map__27546,map__27546__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__20921__auto__,ufv___27548,output_schema27523_27549,input_schema27524_27550,input_checker27525_27551,output_checker27526_27552))
,null,null));
});})(s__27539__$1,map__27546,map__27546__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__20921__auto__,ufv___27548,output_schema27523_27549,input_schema27524_27550,input_checker27525_27551,output_checker27526_27552))
;
var fs__19278__auto__ = cljs.core.seq.call(null,iterys__19277__auto__.call(null,keys));
if(fs__19278__auto__){
return cljs.core.concat.call(null,fs__19278__auto__,dragonmark$inputs$validation$transform_verily_errors_$_iter__27538.call(null,cljs.core.rest.call(null,s__27539__$1)));
} else {
var G__27557 = cljs.core.rest.call(null,s__27539__$1);
s__27539__$1 = G__27557;
continue;
}
} else {
return null;
}
break;
}
});})(validate__20921__auto__,ufv___27548,output_schema27523_27549,input_schema27524_27550,input_checker27525_27551,output_checker27526_27552))
,null,null));
});})(validate__20921__auto__,ufv___27548,output_schema27523_27549,input_schema27524_27550,input_checker27525_27551,output_checker27526_27552))
;
return iter__19281__auto__.call(null,errs);
})());
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27558 = output_checker27526_27552.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27558)){
var error__20923__auto___27559 = temp__4425__auto___27558;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-verily-errors","transform-verily-errors",-197737448,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Verily's error data structure into the common error data structure."], null)),cljs.core.pr_str.call(null,error__20923__auto___27559)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27523_27549,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27559], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27548,output_schema27523_27549,input_schema27524_27550,input_checker27525_27551,output_checker27526_27552))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.transform_verily_errors),schema.core.make_fn_schema.call(null,output_schema27523_27549,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27524_27550], null)));
dragonmark.inputs.validation.build_verily_validator = (function dragonmark$inputs$validation$build_verily_validator(rules){
return cljs.core.partial.call(null,dragonmark.inputs.validation.validate,jkkramer.verily.validations__GT_fn.call(null,rules),dragonmark.inputs.validation.transform_verily_errors);
});
dragonmark.inputs.validation.inter_fields_rules = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"lower-or-equal","lower-or-equal",-1150663190),null,new cljs.core.Keyword(null,"greater-or-equal","greater-or-equal",302221395),null,new cljs.core.Keyword(null,"lower","lower",1120320821),null,new cljs.core.Keyword(null,"greater","greater",1370260601),null,new cljs.core.Keyword(null,"equal","equal",-1921681350),null], null), null);
/**
 * Build the map error->rule
 */
dragonmark.inputs.validation.error__GT_rule = (function dragonmark$inputs$validation$error__GT_rule(rules){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19281__auto__ = (function dragonmark$inputs$validation$error__GT_rule_$_iter__27564(s__27565){
return (new cljs.core.LazySeq(null,(function (){
var s__27565__$1 = s__27565;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__27565__$1);
if(temp__4425__auto__){
var s__27565__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27565__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__27565__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__27567 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__27566 = (0);
while(true){
if((i__27566 < size__19280__auto__)){
var r = cljs.core._nth.call(null,c__19279__auto__,i__27566);
cljs.core.chunk_append.call(null,b__27567,cljs.core.juxt.call(null,cljs.core.last,cljs.core.first).call(null,r));

var G__27568 = (i__27566 + (1));
i__27566 = G__27568;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27567),dragonmark$inputs$validation$error__GT_rule_$_iter__27564.call(null,cljs.core.chunk_rest.call(null,s__27565__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27567),null);
}
} else {
var r = cljs.core.first.call(null,s__27565__$2);
return cljs.core.cons.call(null,cljs.core.juxt.call(null,cljs.core.last,cljs.core.first).call(null,r),dragonmark$inputs$validation$error__GT_rule_$_iter__27564.call(null,cljs.core.rest.call(null,s__27565__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19281__auto__.call(null,rules);
})());
});
/**
 * Determines validation dependencies between fields
 */
dragonmark.inputs.validation.fields_dependencies = (function dragonmark$inputs$validation$fields_dependencies(){
var args27569 = [];
var len__19567__auto___27584 = arguments.length;
var i__19568__auto___27585 = (0);
while(true){
if((i__19568__auto___27585 < len__19567__auto___27584)){
args27569.push((arguments[i__19568__auto___27585]));

var G__27586 = (i__19568__auto___27585 + (1));
i__19568__auto___27585 = G__27586;
continue;
} else {
}
break;
}

var G__27571 = args27569.length;
switch (G__27571) {
case 1:
return dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27569.length)].join('')));

}
});

dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$1 = (function (rules){
return dragonmark.inputs.validation.fields_dependencies.call(null,dragonmark.inputs.validation.inter_fields_rules,rules);
});

dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$2 = (function (rule_keys,rules){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19281__auto__ = (function dragonmark$inputs$validation$iter__27572(s__27573){
return (new cljs.core.LazySeq(null,(function (){
var s__27573__$1 = s__27573;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__27573__$1);
if(temp__4425__auto__){
var s__27573__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27573__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__27573__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__27575 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__27574 = (0);
while(true){
if((i__27574 < size__19280__auto__)){
var vec__27580 = cljs.core._nth.call(null,c__19279__auto__,i__27574);
var r = cljs.core.nth.call(null,vec__27580,(0),null);
var fs = cljs.core.nth.call(null,vec__27580,(1),null);
var m = cljs.core.nth.call(null,vec__27580,(2),null);
if(cljs.core.truth_(rule_keys.call(null,r))){
var vec__27581 = fs;
var f = cljs.core.nth.call(null,vec__27581,(0),null);
var deps = cljs.core.nthnext.call(null,vec__27581,(1));
cljs.core.chunk_append.call(null,b__27575,new cljs.core.PersistentArrayMap.fromArray([f,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"deps","deps",1883360319),deps,new cljs.core.Keyword(null,"mess","mess",530922968),m,new cljs.core.Keyword(null,"rule","rule",729973257),r], null)], true, false));

var G__27588 = (i__27574 + (1));
i__27574 = G__27588;
continue;
} else {
var G__27589 = (i__27574 + (1));
i__27574 = G__27589;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27575),dragonmark$inputs$validation$iter__27572.call(null,cljs.core.chunk_rest.call(null,s__27573__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27575),null);
}
} else {
var vec__27582 = cljs.core.first.call(null,s__27573__$2);
var r = cljs.core.nth.call(null,vec__27582,(0),null);
var fs = cljs.core.nth.call(null,vec__27582,(1),null);
var m = cljs.core.nth.call(null,vec__27582,(2),null);
if(cljs.core.truth_(rule_keys.call(null,r))){
var vec__27583 = fs;
var f = cljs.core.nth.call(null,vec__27583,(0),null);
var deps = cljs.core.nthnext.call(null,vec__27583,(1));
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([f,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"deps","deps",1883360319),deps,new cljs.core.Keyword(null,"mess","mess",530922968),m,new cljs.core.Keyword(null,"rule","rule",729973257),r], null)], true, false),dragonmark$inputs$validation$iter__27572.call(null,cljs.core.rest.call(null,s__27573__$2)));
} else {
var G__27590 = cljs.core.rest.call(null,s__27573__$2);
s__27573__$1 = G__27590;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19281__auto__.call(null,rules);
})());
});

dragonmark.inputs.validation.fields_dependencies.cljs$lang$maxFixedArity = 2;
var ufv___27597 = schema.utils.use_fn_validation;
var output_schema27591_27598 = dragonmark.inputs.schemas.sch_business_state;
var input_schema27592_27599 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,dragonmark.inputs.validation.sch_errors,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null)], null)))], null);
var input_checker27593_27600 = schema.core.checker.call(null,input_schema27592_27599);
var output_checker27594_27601 = schema.core.checker.call(null,output_schema27591_27598);
/**
 * Inputs: [state :- sch-business-state errs :- sch-errors]
 * Returns: sch-business-state
 * 
 * Set valid to false for each key in errors, true if absent
 */
dragonmark.inputs.validation.handle_errors = ((function (ufv___27597,output_schema27591_27598,input_schema27592_27599,input_checker27593_27600,output_checker27594_27601){
return (function dragonmark$inputs$validation$handle_errors(G__27595,G__27596){
var validate__20921__auto__ = ufv___27597.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27602 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27595,G__27596], null);
var temp__4425__auto___27603 = input_checker27593_27600.call(null,args__20922__auto___27602);
if(cljs.core.truth_(temp__4425__auto___27603)){
var error__20923__auto___27604 = temp__4425__auto___27603;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"handle-errors","handle-errors",1833858829,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set valid to false for each key in errors, true if absent"], null)),cljs.core.pr_str.call(null,error__20923__auto___27604)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27592_27599,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27602,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27604], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var state = G__27595;
var errs = G__27596;
while(true){
var err_ks = cljs.core.set.call(null,cljs.core.keys.call(null,errs));
var all_ks = cljs.core.set.call(null,cljs.core.keys.call(null,state));
var valid_ks = clojure.set.difference.call(null,all_ks,err_ks);
var state__$1 = cljs.core.reduce.call(null,((function (err_ks,all_ks,valid_ks,validate__20921__auto__,ufv___27597,output_schema27591_27598,input_schema27592_27599,input_checker27593_27600,output_checker27594_27601){
return (function (s,e){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),false),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"error","error",-978969032)], null),e.call(null,errs));
});})(err_ks,all_ks,valid_ks,validate__20921__auto__,ufv___27597,output_schema27591_27598,input_schema27592_27599,input_checker27593_27600,output_checker27594_27601))
,state,err_ks);
return cljs.core.reduce.call(null,((function (err_ks,all_ks,valid_ks,state__$1,validate__20921__auto__,ufv___27597,output_schema27591_27598,input_schema27592_27599,input_checker27593_27600,output_checker27594_27601){
return (function (s,e){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [e], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
});})(err_ks,all_ks,valid_ks,state__$1,validate__20921__auto__,ufv___27597,output_schema27591_27598,input_schema27592_27599,input_checker27593_27600,output_checker27594_27601))
,state__$1,valid_ks);
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27605 = output_checker27594_27601.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27605)){
var error__20923__auto___27606 = temp__4425__auto___27605;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"handle-errors","handle-errors",1833858829,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set valid to false for each key in errors, true if absent"], null)),cljs.core.pr_str.call(null,error__20923__auto___27606)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27591_27598,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27606], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27597,output_schema27591_27598,input_schema27592_27599,input_checker27593_27600,output_checker27594_27601))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.handle_errors),schema.core.make_fn_schema.call(null,output_schema27591_27598,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27592_27599], null)));
var ufv___27628 = schema.utils.use_fn_validation;
var output_schema27607_27629 = dragonmark.inputs.schemas.sch_business_state;
var input_schema27608_27630 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker27609_27631 = schema.core.checker.call(null,input_schema27608_27630);
var output_checker27610_27632 = schema.core.checker.call(null,output_schema27607_27629);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.keep_fields_to_validate = ((function (ufv___27628,output_schema27607_27629,input_schema27608_27630,input_checker27609_27631,output_checker27610_27632){
return (function dragonmark$inputs$validation$keep_fields_to_validate(G__27611){
var validate__20921__auto__ = ufv___27628.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27633 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27611], null);
var temp__4425__auto___27634 = input_checker27609_27631.call(null,args__20922__auto___27633);
if(cljs.core.truth_(temp__4425__auto___27634)){
var error__20923__auto___27635 = temp__4425__auto___27634;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"keep-fields-to-validate","keep-fields-to-validate",943659297,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___27635)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27608_27630,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27633,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27635], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var bs = G__27611;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19281__auto__ = ((function (validate__20921__auto__,ufv___27628,output_schema27607_27629,input_schema27608_27630,input_checker27609_27631,output_checker27610_27632){
return (function dragonmark$inputs$validation$keep_fields_to_validate_$_iter__27620(s__27621){
return (new cljs.core.LazySeq(null,((function (validate__20921__auto__,ufv___27628,output_schema27607_27629,input_schema27608_27630,input_checker27609_27631,output_checker27610_27632){
return (function (){
var s__27621__$1 = s__27621;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__27621__$1);
if(temp__4425__auto__){
var s__27621__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27621__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__27621__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__27623 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__27622 = (0);
while(true){
if((i__27622 < size__19280__auto__)){
var vec__27626 = cljs.core._nth.call(null,c__19279__auto__,i__27622);
var k = cljs.core.nth.call(null,vec__27626,(0),null);
var m = cljs.core.nth.call(null,vec__27626,(1),null);
var in$ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m);
var req = new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__18528__auto__ = req;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,in$));
}
})())){
cljs.core.chunk_append.call(null,b__27623,new cljs.core.PersistentArrayMap.fromArray([k,m], true, false));

var G__27636 = (i__27622 + (1));
i__27622 = G__27636;
continue;
} else {
var G__27637 = (i__27622 + (1));
i__27622 = G__27637;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27623),dragonmark$inputs$validation$keep_fields_to_validate_$_iter__27620.call(null,cljs.core.chunk_rest.call(null,s__27621__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27623),null);
}
} else {
var vec__27627 = cljs.core.first.call(null,s__27621__$2);
var k = cljs.core.nth.call(null,vec__27627,(0),null);
var m = cljs.core.nth.call(null,vec__27627,(1),null);
var in$ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m);
var req = new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__18528__auto__ = req;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,in$));
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,m], true, false),dragonmark$inputs$validation$keep_fields_to_validate_$_iter__27620.call(null,cljs.core.rest.call(null,s__27621__$2)));
} else {
var G__27638 = cljs.core.rest.call(null,s__27621__$2);
s__27621__$1 = G__27638;
continue;
}
}
} else {
return null;
}
break;
}
});})(validate__20921__auto__,ufv___27628,output_schema27607_27629,input_schema27608_27630,input_checker27609_27631,output_checker27610_27632))
,null,null));
});})(validate__20921__auto__,ufv___27628,output_schema27607_27629,input_schema27608_27630,input_checker27609_27631,output_checker27610_27632))
;
return iter__19281__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27639 = output_checker27610_27632.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27639)){
var error__20923__auto___27640 = temp__4425__auto___27639;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"keep-fields-to-validate","keep-fields-to-validate",943659297,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___27640)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27607_27629,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27640], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27628,output_schema27607_27629,input_schema27608_27630,input_checker27609_27631,output_checker27610_27632))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.keep_fields_to_validate),schema.core.make_fn_schema.call(null,output_schema27607_27629,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27608_27630], null)));
var ufv___27647 = schema.utils.use_fn_validation;
var output_schema27641_27648 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema27642_27649 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"fk","fk",2038974178,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker27643_27650 = schema.core.checker.call(null,input_schema27642_27649);
var output_checker27644_27651 = schema.core.checker.call(null,output_schema27641_27648);
/**
 * Inputs: [bs :- sch-business-state fk :- s/Keyword]
 * Returns: {s/Keyword s/Any}
 * 
 * Extract map fk->value for a single field.
 */
dragonmark.inputs.validation.bs__GT_unit_map = ((function (ufv___27647,output_schema27641_27648,input_schema27642_27649,input_checker27643_27650,output_checker27644_27651){
return (function dragonmark$inputs$validation$bs__GT_unit_map(G__27645,G__27646){
var validate__20921__auto__ = ufv___27647.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27652 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27645,G__27646], null);
var temp__4425__auto___27653 = input_checker27643_27650.call(null,args__20922__auto___27652);
if(cljs.core.truth_(temp__4425__auto___27653)){
var error__20923__auto___27654 = temp__4425__auto___27653;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"bs->unit-map","bs->unit-map",827144882,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extract map fk->value for a single field."], null)),cljs.core.pr_str.call(null,error__20923__auto___27654)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27642_27649,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27652,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27654], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var bs = G__27645;
var fk = G__27646;
while(true){
var m = fk.call(null,bs);
return new cljs.core.PersistentArrayMap.fromArray([fk,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m)], true, false);
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27655 = output_checker27644_27651.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27655)){
var error__20923__auto___27656 = temp__4425__auto___27655;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"bs->unit-map","bs->unit-map",827144882,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extract map fk->value for a single field."], null)),cljs.core.pr_str.call(null,error__20923__auto___27656)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27641_27648,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27656], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27647,output_schema27641_27648,input_schema27642_27649,input_checker27643_27650,output_checker27644_27651))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.bs__GT_unit_map),schema.core.make_fn_schema.call(null,output_schema27641_27648,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27642_27649], null)));
var ufv___27678 = schema.utils.use_fn_validation;
var output_schema27657_27679 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema27658_27680 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker27659_27681 = schema.core.checker.call(null,input_schema27658_27680);
var output_checker27660_27682 = schema.core.checker.call(null,output_schema27657_27679);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: {s/Keyword s/Any}
 * 
 * Transform the business local state into final map
 */
dragonmark.inputs.validation.business_state__GT_map = ((function (ufv___27678,output_schema27657_27679,input_schema27658_27680,input_checker27659_27681,output_checker27660_27682){
return (function dragonmark$inputs$validation$business_state__GT_map(G__27661){
var validate__20921__auto__ = ufv___27678.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27683 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27661], null);
var temp__4425__auto___27684 = input_checker27659_27681.call(null,args__20922__auto___27683);
if(cljs.core.truth_(temp__4425__auto___27684)){
var error__20923__auto___27685 = temp__4425__auto___27684;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"business-state->map","business-state->map",1652123635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform the business local state into final map"], null)),cljs.core.pr_str.call(null,error__20923__auto___27685)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27658_27680,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27683,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27685], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var bs = G__27661;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19281__auto__ = ((function (validate__20921__auto__,ufv___27678,output_schema27657_27679,input_schema27658_27680,input_checker27659_27681,output_checker27660_27682){
return (function dragonmark$inputs$validation$business_state__GT_map_$_iter__27670(s__27671){
return (new cljs.core.LazySeq(null,((function (validate__20921__auto__,ufv___27678,output_schema27657_27679,input_schema27658_27680,input_checker27659_27681,output_checker27660_27682){
return (function (){
var s__27671__$1 = s__27671;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__27671__$1);
if(temp__4425__auto__){
var s__27671__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27671__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__27671__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__27673 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__27672 = (0);
while(true){
if((i__27672 < size__19280__auto__)){
var vec__27676 = cljs.core._nth.call(null,c__19279__auto__,i__27672);
var k = cljs.core.nth.call(null,vec__27676,(0),null);
var _ = cljs.core.nth.call(null,vec__27676,(1),null);
cljs.core.chunk_append.call(null,b__27673,dragonmark.inputs.validation.bs__GT_unit_map.call(null,bs,k));

var G__27686 = (i__27672 + (1));
i__27672 = G__27686;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27673),dragonmark$inputs$validation$business_state__GT_map_$_iter__27670.call(null,cljs.core.chunk_rest.call(null,s__27671__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27673),null);
}
} else {
var vec__27677 = cljs.core.first.call(null,s__27671__$2);
var k = cljs.core.nth.call(null,vec__27677,(0),null);
var _ = cljs.core.nth.call(null,vec__27677,(1),null);
return cljs.core.cons.call(null,dragonmark.inputs.validation.bs__GT_unit_map.call(null,bs,k),dragonmark$inputs$validation$business_state__GT_map_$_iter__27670.call(null,cljs.core.rest.call(null,s__27671__$2)));
}
} else {
return null;
}
break;
}
});})(validate__20921__auto__,ufv___27678,output_schema27657_27679,input_schema27658_27680,input_checker27659_27681,output_checker27660_27682))
,null,null));
});})(validate__20921__auto__,ufv___27678,output_schema27657_27679,input_schema27658_27680,input_checker27659_27681,output_checker27660_27682))
;
return iter__19281__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27687 = output_checker27660_27682.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27687)){
var error__20923__auto___27688 = temp__4425__auto___27687;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"business-state->map","business-state->map",1652123635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform the business local state into final map"], null)),cljs.core.pr_str.call(null,error__20923__auto___27688)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27657_27679,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27688], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27678,output_schema27657_27679,input_schema27658_27680,input_checker27659_27681,output_checker27660_27682))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.business_state__GT_map),schema.core.make_fn_schema.call(null,output_schema27657_27679,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27658_27680], null)));
var ufv___27694 = schema.utils.use_fn_validation;
var output_schema27689_27695 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema27690_27696 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker27691_27697 = schema.core.checker.call(null,input_schema27690_27696);
var output_checker27692_27698 = schema.core.checker.call(null,output_schema27689_27695);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: {s/Keyword s/Any}
 * 
 * Create the map that will be validated by the Schema :
 * Only keeps :
 * - required keys
 * - optional keys with non blank values
 */
dragonmark.inputs.validation.pre_validation = ((function (ufv___27694,output_schema27689_27695,input_schema27690_27696,input_checker27691_27697,output_checker27692_27698){
return (function dragonmark$inputs$validation$pre_validation(G__27693){
var validate__20921__auto__ = ufv___27694.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27699 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27693], null);
var temp__4425__auto___27700 = input_checker27691_27697.call(null,args__20922__auto___27699);
if(cljs.core.truth_(temp__4425__auto___27700)){
var error__20923__auto___27701 = temp__4425__auto___27700;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"pre-validation","pre-validation",731230710,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Create the map that will be validated by the Schema :\n  Only keeps :\n  - required keys\n  - optional keys with non blank values"], null)),cljs.core.pr_str.call(null,error__20923__auto___27701)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27690_27696,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27699,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27701], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var bs = G__27693;
while(true){
return dragonmark.inputs.validation.business_state__GT_map.call(null,dragonmark.inputs.validation.keep_fields_to_validate.call(null,bs));
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27702 = output_checker27692_27698.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27702)){
var error__20923__auto___27703 = temp__4425__auto___27702;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"pre-validation","pre-validation",731230710,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Create the map that will be validated by the Schema :\n  Only keeps :\n  - required keys\n  - optional keys with non blank values"], null)),cljs.core.pr_str.call(null,error__20923__auto___27703)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27689_27695,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27703], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27694,output_schema27689_27695,input_schema27690_27696,input_checker27691_27697,output_checker27692_27698))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.pre_validation),schema.core.make_fn_schema.call(null,output_schema27689_27695,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27690_27696], null)));
var ufv___27725 = schema.utils.use_fn_validation;
var output_schema27704_27726 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema27705_27727 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"sch","sch",763282093,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker27706_27728 = schema.core.checker.call(null,input_schema27705_27727);
var output_checker27707_27729 = schema.core.checker.call(null,output_schema27704_27726);
/**
 * Inputs: [sch]
 * Returns: {s/Keyword s/Any}
 * 
 * Transform a Schema into a map of key -> individual Schema
 */
dragonmark.inputs.validation.sch_glo__GT_unit = ((function (ufv___27725,output_schema27704_27726,input_schema27705_27727,input_checker27706_27728,output_checker27707_27729){
return (function dragonmark$inputs$validation$sch_glo__GT_unit(G__27708){
var validate__20921__auto__ = ufv___27725.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27730 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27708], null);
var temp__4425__auto___27731 = input_checker27706_27728.call(null,args__20922__auto___27730);
if(cljs.core.truth_(temp__4425__auto___27731)){
var error__20923__auto___27732 = temp__4425__auto___27731;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sch-glo->unit","sch-glo->unit",1717844533,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform a Schema into a map of key -> individual Schema"], null)),cljs.core.pr_str.call(null,error__20923__auto___27732)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27705_27727,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27730,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27732], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var sch = G__27708;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19281__auto__ = ((function (validate__20921__auto__,ufv___27725,output_schema27704_27726,input_schema27705_27727,input_checker27706_27728,output_checker27707_27729){
return (function dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__27717(s__27718){
return (new cljs.core.LazySeq(null,((function (validate__20921__auto__,ufv___27725,output_schema27704_27726,input_schema27705_27727,input_checker27706_27728,output_checker27707_27729){
return (function (){
var s__27718__$1 = s__27718;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__27718__$1);
if(temp__4425__auto__){
var s__27718__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27718__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__27718__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__27720 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__27719 = (0);
while(true){
if((i__27719 < size__19280__auto__)){
var vec__27723 = cljs.core._nth.call(null,c__19279__auto__,i__27719);
var k = cljs.core.nth.call(null,vec__27723,(0),null);
var t = cljs.core.nth.call(null,vec__27723,(1),null);
cljs.core.chunk_append.call(null,b__27720,new cljs.core.PersistentArrayMap.fromArray([cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),new cljs.core.PersistentArrayMap.fromArray([k,t], true, false)], true, false));

var G__27733 = (i__27719 + (1));
i__27719 = G__27733;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27720),dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__27717.call(null,cljs.core.chunk_rest.call(null,s__27718__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27720),null);
}
} else {
var vec__27724 = cljs.core.first.call(null,s__27718__$2);
var k = cljs.core.nth.call(null,vec__27724,(0),null);
var t = cljs.core.nth.call(null,vec__27724,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),new cljs.core.PersistentArrayMap.fromArray([k,t], true, false)], true, false),dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__27717.call(null,cljs.core.rest.call(null,s__27718__$2)));
}
} else {
return null;
}
break;
}
});})(validate__20921__auto__,ufv___27725,output_schema27704_27726,input_schema27705_27727,input_checker27706_27728,output_checker27707_27729))
,null,null));
});})(validate__20921__auto__,ufv___27725,output_schema27704_27726,input_schema27705_27727,input_checker27706_27728,output_checker27707_27729))
;
return iter__19281__auto__.call(null,sch);
})());
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27734 = output_checker27707_27729.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27734)){
var error__20923__auto___27735 = temp__4425__auto___27734;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sch-glo->unit","sch-glo->unit",1717844533,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform a Schema into a map of key -> individual Schema"], null)),cljs.core.pr_str.call(null,error__20923__auto___27735)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27704_27726,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27735], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27725,output_schema27704_27726,input_schema27705_27727,input_checker27706_27728,output_checker27707_27729))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.sch_glo__GT_unit),schema.core.make_fn_schema.call(null,output_schema27704_27726,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27705_27727], null)));
/**
 * Build the map of field -> coercer
 */
dragonmark.inputs.validation.build_unit_coercers = (function dragonmark$inputs$validation$build_unit_coercers(sch){
return cljs.core.apply.call(null,cljs.core.merge,(function (){var iter__19281__auto__ = (function dragonmark$inputs$validation$build_unit_coercers_$_iter__27744(s__27745){
return (new cljs.core.LazySeq(null,(function (){
var s__27745__$1 = s__27745;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__27745__$1);
if(temp__4425__auto__){
var s__27745__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27745__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__27745__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__27747 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__27746 = (0);
while(true){
if((i__27746 < size__19280__auto__)){
var vec__27750 = cljs.core._nth.call(null,c__19279__auto__,i__27746);
var k = cljs.core.nth.call(null,vec__27750,(0),null);
var s = cljs.core.nth.call(null,vec__27750,(1),null);
cljs.core.chunk_append.call(null,b__27747,new cljs.core.PersistentArrayMap.fromArray([k,schema.coerce.coercer.call(null,s,dragonmark.inputs.validation.validation_coercer)], true, false));

var G__27752 = (i__27746 + (1));
i__27746 = G__27752;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27747),dragonmark$inputs$validation$build_unit_coercers_$_iter__27744.call(null,cljs.core.chunk_rest.call(null,s__27745__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27747),null);
}
} else {
var vec__27751 = cljs.core.first.call(null,s__27745__$2);
var k = cljs.core.nth.call(null,vec__27751,(0),null);
var s = cljs.core.nth.call(null,vec__27751,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,schema.coerce.coercer.call(null,s,dragonmark.inputs.validation.validation_coercer)], true, false),dragonmark$inputs$validation$build_unit_coercers_$_iter__27744.call(null,cljs.core.rest.call(null,s__27745__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19281__auto__.call(null,dragonmark.inputs.validation.sch_glo__GT_unit.call(null,sch));
})());
});
var ufv___27774 = schema.utils.use_fn_validation;
var output_schema27753_27775 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema27754_27776 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"unit-coercers","unit-coercers",-228543947,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_checker27755_27777 = schema.core.checker.call(null,input_schema27754_27776);
var output_checker27756_27778 = schema.core.checker.call(null,output_schema27753_27775);
/**
 * Inputs: [unit-coercers :- {s/Keyword s/Any}]
 * Returns: {s/Keyword s/Any}
 */
dragonmark.inputs.validation.unit_schema_validators = ((function (ufv___27774,output_schema27753_27775,input_schema27754_27776,input_checker27755_27777,output_checker27756_27778){
return (function dragonmark$inputs$validation$unit_schema_validators(G__27757){
var validate__20921__auto__ = true;
if(validate__20921__auto__){
var args__20922__auto___27779 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27757], null);
var temp__4425__auto___27780 = input_checker27755_27777.call(null,args__20922__auto___27779);
if(cljs.core.truth_(temp__4425__auto___27780)){
var error__20923__auto___27781 = temp__4425__auto___27780;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unit-schema-validators","unit-schema-validators",-690979832,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)),cljs.core.pr_str.call(null,error__20923__auto___27781)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27754_27776,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27779,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27781], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var unit_coercers = G__27757;
while(true){
return cljs.core.apply.call(null,cljs.core.merge,(function (){var iter__19281__auto__ = ((function (validate__20921__auto__,ufv___27774,output_schema27753_27775,input_schema27754_27776,input_checker27755_27777,output_checker27756_27778){
return (function dragonmark$inputs$validation$unit_schema_validators_$_iter__27766(s__27767){
return (new cljs.core.LazySeq(null,((function (validate__20921__auto__,ufv___27774,output_schema27753_27775,input_schema27754_27776,input_checker27755_27777,output_checker27756_27778){
return (function (){
var s__27767__$1 = s__27767;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__27767__$1);
if(temp__4425__auto__){
var s__27767__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27767__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__27767__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__27769 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__27768 = (0);
while(true){
if((i__27768 < size__19280__auto__)){
var vec__27772 = cljs.core._nth.call(null,c__19279__auto__,i__27768);
var k = cljs.core.nth.call(null,vec__27772,(0),null);
var c = cljs.core.nth.call(null,vec__27772,(1),null);
cljs.core.chunk_append.call(null,b__27769,new cljs.core.PersistentArrayMap.fromArray([k,cljs.core.partial.call(null,dragonmark.inputs.validation.validate,c,dragonmark.inputs.validation.transform_schema_errors)], true, false));

var G__27782 = (i__27768 + (1));
i__27768 = G__27782;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27769),dragonmark$inputs$validation$unit_schema_validators_$_iter__27766.call(null,cljs.core.chunk_rest.call(null,s__27767__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27769),null);
}
} else {
var vec__27773 = cljs.core.first.call(null,s__27767__$2);
var k = cljs.core.nth.call(null,vec__27773,(0),null);
var c = cljs.core.nth.call(null,vec__27773,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,cljs.core.partial.call(null,dragonmark.inputs.validation.validate,c,dragonmark.inputs.validation.transform_schema_errors)], true, false),dragonmark$inputs$validation$unit_schema_validators_$_iter__27766.call(null,cljs.core.rest.call(null,s__27767__$2)));
}
} else {
return null;
}
break;
}
});})(validate__20921__auto__,ufv___27774,output_schema27753_27775,input_schema27754_27776,input_checker27755_27777,output_checker27756_27778))
,null,null));
});})(validate__20921__auto__,ufv___27774,output_schema27753_27775,input_schema27754_27776,input_checker27755_27777,output_checker27756_27778))
;
return iter__19281__auto__.call(null,unit_coercers);
})());
break;
}
})();
if(validate__20921__auto__){
var temp__4425__auto___27783 = output_checker27756_27778.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27783)){
var error__20923__auto___27784 = temp__4425__auto___27783;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unit-schema-validators","unit-schema-validators",-690979832,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)),cljs.core.pr_str.call(null,error__20923__auto___27784)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27753_27775,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27784], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27774,output_schema27753_27775,input_schema27754_27776,input_checker27755_27777,output_checker27756_27778))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.unit_schema_validators),schema.core.make_fn_schema.call(null,output_schema27753_27775,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27754_27776], null)));
var ufv___27794 = schema.utils.use_fn_validation;
var output_schema27785_27795 = schema.core.Bool;
var input_schema27786_27796 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_field_state,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-field-state","sch-field-state",-361453047,null)], null)))], null);
var input_checker27787_27797 = schema.core.checker.call(null,input_schema27786_27796);
var output_checker27788_27798 = schema.core.checker.call(null,output_schema27785_27795);
/**
 * Inputs: [s :- sch-field-state]
 * Returns: s/Bool
 * 
 * Indicates if a field must be validated :
 * - required field
 * - optional field with non blank values
 */
dragonmark.inputs.validation.validate_QMARK_ = ((function (ufv___27794,output_schema27785_27795,input_schema27786_27796,input_checker27787_27797,output_checker27788_27798){
return (function dragonmark$inputs$validation$validate_QMARK_(G__27789){
var validate__20921__auto__ = ufv___27794.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27799 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27789], null);
var temp__4425__auto___27800 = input_checker27787_27797.call(null,args__20922__auto___27799);
if(cljs.core.truth_(temp__4425__auto___27800)){
var error__20923__auto___27801 = temp__4425__auto___27800;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"validate?","validate?",1996759489,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Indicates if a field must be validated :\n  - required field\n  - optional field with non blank values"], null)),cljs.core.pr_str.call(null,error__20923__auto___27801)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27786_27796,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27799,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27801], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var s = G__27789;
while(true){
var map__27792 = s;
var map__27792__$1 = ((((!((map__27792 == null)))?((((map__27792.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27792.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27792):map__27792);
var required = cljs.core.get.call(null,map__27792__$1,new cljs.core.Keyword(null,"required","required",1807647006));
var value = cljs.core.get.call(null,map__27792__$1,new cljs.core.Keyword(null,"value","value",305978217));
var or__18528__auto__ = required;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,value));
}
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27802 = output_checker27788_27798.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27802)){
var error__20923__auto___27803 = temp__4425__auto___27802;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"validate?","validate?",1996759489,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Indicates if a field must be validated :\n  - required field\n  - optional field with non blank values"], null)),cljs.core.pr_str.call(null,error__20923__auto___27803)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27785_27795,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27803], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27794,output_schema27785_27795,input_schema27786_27796,input_checker27787_27797,output_checker27788_27798))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.validate_QMARK_),schema.core.make_fn_schema.call(null,output_schema27785_27795,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27786_27796], null)));
var ufv___27810 = schema.utils.use_fn_validation;
var output_schema27804_27811 = dragonmark.inputs.schemas.sch_business_state;
var input_schema27805_27812 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,dragonmark.inputs.validation.sch_errors,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null)], null)))], null);
var input_checker27806_27813 = schema.core.checker.call(null,input_schema27805_27812);
var output_checker27807_27814 = schema.core.checker.call(null,output_schema27804_27811);
/**
 * Inputs: [state :- sch-business-state errs :- sch-errors]
 * Returns: sch-business-state
 * 
 * Handle errors for a single field
 */
dragonmark.inputs.validation.add_field_error = ((function (ufv___27810,output_schema27804_27811,input_schema27805_27812,input_checker27806_27813,output_checker27807_27814){
return (function dragonmark$inputs$validation$add_field_error(G__27808,G__27809){
var validate__20921__auto__ = ufv___27810.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27815 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27808,G__27809], null);
var temp__4425__auto___27816 = input_checker27806_27813.call(null,args__20922__auto___27815);
if(cljs.core.truth_(temp__4425__auto___27816)){
var error__20923__auto___27817 = temp__4425__auto___27816;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"add-field-error","add-field-error",-1753092209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Handle errors for a single field"], null)),cljs.core.pr_str.call(null,error__20923__auto___27817)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27805_27812,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27815,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27817], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var state = G__27808;
var errs = G__27809;
while(true){
return cljs.core.reduce.call(null,((function (validate__20921__auto__,ufv___27810,output_schema27804_27811,input_schema27805_27812,input_checker27806_27813,output_checker27807_27814){
return (function (s,e){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),false),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"error","error",-978969032)], null),e.call(null,errs));
});})(validate__20921__auto__,ufv___27810,output_schema27804_27811,input_schema27805_27812,input_checker27806_27813,output_checker27807_27814))
,state,cljs.core.keys.call(null,errs));
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27818 = output_checker27807_27814.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27818)){
var error__20923__auto___27819 = temp__4425__auto___27818;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"add-field-error","add-field-error",-1753092209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Handle errors for a single field"], null)),cljs.core.pr_str.call(null,error__20923__auto___27819)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27804_27811,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27819], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27810,output_schema27804_27811,input_schema27805_27812,input_checker27806_27813,output_checker27807_27814))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.add_field_error),schema.core.make_fn_schema.call(null,output_schema27804_27811,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27805_27812], null)));
var ufv___27826 = schema.utils.use_fn_validation;
var output_schema27820_27827 = dragonmark.inputs.schemas.sch_business_state;
var input_schema27821_27828 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker27822_27829 = schema.core.checker.call(null,input_schema27821_27828);
var output_checker27823_27830 = schema.core.checker.call(null,output_schema27820_27827);
/**
 * Inputs: [state :- sch-business-state k :- s/Keyword]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.remove_field_error = ((function (ufv___27826,output_schema27820_27827,input_schema27821_27828,input_checker27822_27829,output_checker27823_27830){
return (function dragonmark$inputs$validation$remove_field_error(G__27824,G__27825){
var validate__20921__auto__ = ufv___27826.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27831 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27824,G__27825], null);
var temp__4425__auto___27832 = input_checker27822_27829.call(null,args__20922__auto___27831);
if(cljs.core.truth_(temp__4425__auto___27832)){
var error__20923__auto___27833 = temp__4425__auto___27832;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error","remove-field-error",-837789813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___27833)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27821_27828,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27831,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27833], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var state = G__27824;
var k = G__27825;
while(true){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"valid","valid",155614240)], null),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27834 = output_checker27823_27830.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27834)){
var error__20923__auto___27835 = temp__4425__auto___27834;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error","remove-field-error",-837789813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___27835)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27820_27827,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27835], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27826,output_schema27820_27827,input_schema27821_27828,input_checker27822_27829,output_checker27823_27830))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_field_error),schema.core.make_fn_schema.call(null,output_schema27820_27827,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27821_27828], null)));
var ufv___27843 = schema.utils.use_fn_validation;
var output_schema27836_27844 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);
var input_schema27837_27845 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,cljs.core.PersistentHashSet.fromArray([schema.core.Keyword], true),cljs.core.with_meta(new cljs.core.Symbol(null,"cross-errs","cross-errs",-563013712,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),null], null), null)], null))),schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Keyword], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"error-rule","error-rule",327326958,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null))),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker27838_27846 = schema.core.checker.call(null,input_schema27837_27845);
var output_checker27839_27847 = schema.core.checker.call(null,output_schema27836_27844);
/**
 * Inputs: [cross-errs :- #{s/Keyword} error-rule :- {s/Keyword s/Keyword} errs :- [s/Keyword]]
 * Returns: [s/Keyword]
 * 
 * Remove the cross field errors keys from the validation errors.
 * This prevent errors from showing when inline validation occurs.
 */
dragonmark.inputs.validation.remove_dependant_errors = ((function (ufv___27843,output_schema27836_27844,input_schema27837_27845,input_checker27838_27846,output_checker27839_27847){
return (function dragonmark$inputs$validation$remove_dependant_errors(G__27840,G__27841,G__27842){
var validate__20921__auto__ = ufv___27843.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27848 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27840,G__27841,G__27842], null);
var temp__4425__auto___27849 = input_checker27838_27846.call(null,args__20922__auto___27848);
if(cljs.core.truth_(temp__4425__auto___27849)){
var error__20923__auto___27850 = temp__4425__auto___27849;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-dependant-errors","remove-dependant-errors",-830444485,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remove the cross field errors keys from the validation errors.\n  This prevent errors from showing when inline validation occurs."], null)),cljs.core.pr_str.call(null,error__20923__auto___27850)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27837_27845,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27848,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27850], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var cross_errs = G__27840;
var error_rule = G__27841;
var errs = G__27842;
while(true){
return cljs.core.seq.call(null,cljs.core.remove.call(null,((function (validate__20921__auto__,ufv___27843,output_schema27836_27844,input_schema27837_27845,input_checker27838_27846,output_checker27839_27847){
return (function (err){
return cross_errs.call(null,cljs.core.get.call(null,error_rule,err));
});})(validate__20921__auto__,ufv___27843,output_schema27836_27844,input_schema27837_27845,input_checker27838_27846,output_checker27839_27847))
,errs));
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27851 = output_checker27839_27847.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27851)){
var error__20923__auto___27852 = temp__4425__auto___27851;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-dependant-errors","remove-dependant-errors",-830444485,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remove the cross field errors keys from the validation errors.\n  This prevent errors from showing when inline validation occurs."], null)),cljs.core.pr_str.call(null,error__20923__auto___27852)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27836_27844,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27852], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27843,output_schema27836_27844,input_schema27837_27845,input_checker27838_27846,output_checker27839_27847))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_dependant_errors),schema.core.make_fn_schema.call(null,output_schema27836_27844,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27837_27845], null)));
dragonmark.inputs.validation.build_error_remover = (function dragonmark$inputs$validation$build_error_remover(rules,cross_fields_rules){
return cljs.core.partial.call(null,dragonmark.inputs.validation.remove_dependant_errors,cross_fields_rules,dragonmark.inputs.validation.error__GT_rule.call(null,rules));
});
/**
 * validate a single field against verily rules.
 * If an other field depends on this one, then the errors linked to this validation won't show up.
 */
dragonmark.inputs.validation.unit_verily_validation = (function dragonmark$inputs$validation$unit_verily_validation(fk,unit,p__27853){
var map__27856 = p__27853;
var map__27856__$1 = ((((!((map__27856 == null)))?((((map__27856.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27856.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27856):map__27856);
var state = map__27856__$1;
var unit_coercers = cljs.core.get.call(null,map__27856__$1,new cljs.core.Keyword(null,"unit-coercers","unit-coercers",-1869075474));
var remove_errs_fn = cljs.core.get.call(null,map__27856__$1,new cljs.core.Keyword(null,"remove-errs-fn","remove-errs-fn",-1642608850));
var verily_validator = cljs.core.get.call(null,map__27856__$1,new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403));
var coerced = fk.call(null,unit_coercers).call(null,unit);
var errs = verily_validator.call(null,coerced);
if(cljs.core.contains_QMARK_.call(null,errs,fk)){
var errs_unit = cljs.core.update_in.call(null,errs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null),remove_errs_fn);
var res = cljs.core.select_keys.call(null,errs_unit,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null));
if(cljs.core.truth_(fk.call(null,res))){
return res;
} else {
return null;
}
} else {
return null;
}
});
/**
 * Verily validation of a field that depend on other.
 * The confirm password is a typical example.
 */
dragonmark.inputs.validation.unit_dependant_verily_validation = (function dragonmark$inputs$validation$unit_dependant_verily_validation(fk,inputs,state){
var map__27860 = state;
var map__27860__$1 = ((((!((map__27860 == null)))?((((map__27860.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27860.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27860):map__27860);
var validation_deps = cljs.core.get.call(null,map__27860__$1,new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716));
var verily_validator = cljs.core.get.call(null,map__27860__$1,new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403));
var deps = fk.call(null,validation_deps);
var coerced = dragonmark.inputs.validation.business_state__GT_map.call(null,inputs);
var errs = verily_validator.call(null,coerced);
if(cljs.core.contains_QMARK_.call(null,errs,fk)){
return cljs.core.select_keys.call(null,errs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null));
} else {
return null;
}
});
/**
 * Verily validation of a single field
 */
dragonmark.inputs.validation.verily_validation = (function dragonmark$inputs$validation$verily_validation(fk,unit,bs,state){
var map__27864 = state;
var map__27864__$1 = ((((!((map__27864 == null)))?((((map__27864.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27864.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27864):map__27864);
var validation_deps = cljs.core.get.call(null,map__27864__$1,new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716));
if(cljs.core.truth_(fk.call(null,validation_deps))){
return dragonmark.inputs.validation.unit_dependant_verily_validation.call(null,fk,bs,state);
} else {
return dragonmark.inputs.validation.unit_verily_validation.call(null,fk,unit,state);
}
});
/**
 * Validation of a single field
 * TODO Refactoring
 */
dragonmark.inputs.validation.field_validation = (function dragonmark$inputs$validation$field_validation(fk,inputs,state){
var map__27868 = state;
var map__27868__$1 = ((((!((map__27868 == null)))?((((map__27868.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27868.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27868):map__27868);
var unit_validators = cljs.core.get.call(null,map__27868__$1,new cljs.core.Keyword(null,"unit-validators","unit-validators",-1302618433));
var unit = dragonmark.inputs.validation.bs__GT_unit_map.call(null,inputs,fk);
if(cljs.core.truth_(dragonmark.inputs.validation.validate_QMARK_.call(null,fk.call(null,inputs)))){
var temp__4423__auto__ = (function (){var or__18528__auto__ = (function (){var and__18516__auto__ = fk;
if(cljs.core.truth_(and__18516__auto__)){
var temp__4423__auto__ = fk.call(null,unit_validators);
if(cljs.core.truth_(temp__4423__auto__)){
var the_fn = temp__4423__auto__;
return the_fn.call(null,unit);
} else {
return null;
}
} else {
return and__18516__auto__;
}
})();
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return dragonmark.inputs.validation.verily_validation.call(null,fk,unit,inputs,state);
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var errs = temp__4423__auto__;
return dragonmark.inputs.validation.add_field_error.call(null,inputs,errs);
} else {
return dragonmark.inputs.validation.remove_field_error.call(null,inputs,fk);
}
} else {
return dragonmark.inputs.validation.remove_field_error.call(null,inputs,fk);
}
});
/**
 * Validate a single field of the local business state and update the local state.
 */
dragonmark.inputs.validation.field_validation_BANG_ = (function dragonmark$inputs$validation$field_validation_BANG_(owner,f){
var map__27872 = dragonmark.inputs.extern.get_state.call(null,owner);
var map__27872__$1 = ((((!((map__27872 == null)))?((((map__27872.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27872.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27872):map__27872);
var state = map__27872__$1;
var inputs = cljs.core.get.call(null,map__27872__$1,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var new_business_state = dragonmark.inputs.validation.field_validation.call(null,f,inputs,state);
if(cljs.core.not_EQ_.call(null,inputs,new_business_state)){
return dragonmark.inputs.extern.set_state_BANG_.call(null,owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"inputs","inputs",865803858)], null),new_business_state);
} else {
return null;
}
});
dragonmark.inputs.validation.full_validation = (function dragonmark$inputs$validation$full_validation(inputs,state){
return cljs.core.reduce.call(null,(function (bs,f){
return dragonmark.inputs.validation.field_validation.call(null,f,bs,state);
}),inputs,cljs.core.keys.call(null,inputs));
});
var ufv___27883 = schema.utils.use_fn_validation;
var output_schema27874_27884 = schema.core.Bool;
var input_schema27875_27885 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker27876_27886 = schema.core.checker.call(null,input_schema27875_27885);
var output_checker27877_27887 = schema.core.checker.call(null,output_schema27874_27884);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: s/Bool
 * 
 * Tells if there is at least one field in error.
 */
dragonmark.inputs.validation.no_error_QMARK_ = ((function (ufv___27883,output_schema27874_27884,input_schema27875_27885,input_checker27876_27886,output_checker27877_27887){
return (function dragonmark$inputs$validation$no_error_QMARK_(G__27878){
var validate__20921__auto__ = ufv___27883.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27888 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27878], null);
var temp__4425__auto___27889 = input_checker27876_27886.call(null,args__20922__auto___27888);
if(cljs.core.truth_(temp__4425__auto___27889)){
var error__20923__auto___27890 = temp__4425__auto___27889;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"no-error?","no-error?",323642458,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tells if there is at least one field in error."], null)),cljs.core.pr_str.call(null,error__20923__auto___27890)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27875_27885,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27888,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27890], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var bs = G__27878;
while(true){
return cljs.core.not_any_QMARK_.call(null,((function (validate__20921__auto__,ufv___27883,output_schema27874_27884,input_schema27875_27885,input_checker27876_27886,output_checker27877_27887){
return (function (p__27881){
var vec__27882 = p__27881;
var k = cljs.core.nth.call(null,vec__27882,(0),null);
var v = cljs.core.nth.call(null,vec__27882,(1),null);
return new cljs.core.Keyword(null,"valid","valid",155614240).cljs$core$IFn$_invoke$arity$1(v) === false;
});})(validate__20921__auto__,ufv___27883,output_schema27874_27884,input_schema27875_27885,input_checker27876_27886,output_checker27877_27887))
,bs);
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27891 = output_checker27877_27887.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27891)){
var error__20923__auto___27892 = temp__4425__auto___27891;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"no-error?","no-error?",323642458,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tells if there is at least one field in error."], null)),cljs.core.pr_str.call(null,error__20923__auto___27892)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27874_27884,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27892], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27883,output_schema27874_27884,input_schema27875_27885,input_checker27876_27886,output_checker27877_27887))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.no_error_QMARK_),schema.core.make_fn_schema.call(null,output_schema27874_27884,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27875_27885], null)));

//# sourceMappingURL=validation.js.map