// Compiled by ClojureScript 1.7.48 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');

figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.all_QMARK_ = (function figwheel$client$file_reloading$all_QMARK_(pred,coll){
return cljs.core.reduce.call(null,(function (p1__35642_SHARP_,p2__35643_SHARP_){
var and__18516__auto__ = p1__35642_SHARP_;
if(cljs.core.truth_(and__18516__auto__)){
return p2__35643_SHARP_;
} else {
return and__18516__auto__;
}
}),true,cljs.core.map.call(null,pred,coll));
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__18528__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__18528__auto__){
return or__18528__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.ns_to_js_file = (function figwheel$client$file_reloading$ns_to_js_file(ns){

return [cljs.core.str(clojure.string.replace.call(null,ns,".","/")),cljs.core.str(".js")].join('');
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){

return [cljs.core.str(figwheel.client.utils.base_url_path.call(null)),cljs.core.str(figwheel.client.file_reloading.ns_to_js_file.call(null,ns))].join('');
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
goog.isProvided = (function (x){
return false;
});

if(((cljs.core._STAR_loaded_libs_STAR_ == null)) || (cljs.core.empty_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_))){
cljs.core._STAR_loaded_libs_STAR_ = (function (){var gntp = goog.dependencies_.nameToPath;
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,((function (gntp){
return (function (name){
return (goog.dependencies_.visited[(gntp[name])]);
});})(gntp))
,cljs.core.js_keys.call(null,gntp)));
})();
} else {
}

goog.require = (function (name,reload){
if(cljs.core.truth_((function (){var or__18528__auto__ = !(cljs.core.contains_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_,name));
if(or__18528__auto__){
return or__18528__auto__;
} else {
return reload;
}
})())){
cljs.core._STAR_loaded_libs_STAR_ = cljs.core.conj.call(null,(function (){var or__18528__auto__ = cljs.core._STAR_loaded_libs_STAR_;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})(),name);

return figwheel.client.file_reloading.reload_file_STAR_.call(null,figwheel.client.file_reloading.resolve_ns.call(null,name));
} else {
return null;
}
});

goog.provide = goog.exportPath_;

return goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.reload_file_STAR_;
});
if(typeof figwheel.client.file_reloading.resolve_url !== 'undefined'){
} else {
figwheel.client.file_reloading.resolve_url = (function (){var method_table__19422__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19423__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19424__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19425__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19426__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"figwheel.client.file-reloading","resolve-url"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19426__auto__,method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__));
})();
}
cljs.core._add_method.call(null,figwheel.client.file_reloading.resolve_url,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__35644){
var map__35645 = p__35644;
var map__35645__$1 = ((((!((map__35645 == null)))?((((map__35645.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35645.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35645):map__35645);
var file = cljs.core.get.call(null,map__35645__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
return file;
}));
cljs.core._add_method.call(null,figwheel.client.file_reloading.resolve_url,new cljs.core.Keyword(null,"namespace","namespace",-377510372),(function (p__35647){
var map__35648 = p__35647;
var map__35648__$1 = ((((!((map__35648 == null)))?((((map__35648.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35648.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35648):map__35648);
var namespace = cljs.core.get.call(null,map__35648__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

return figwheel.client.file_reloading.resolve_ns.call(null,namespace);
}));
if(typeof figwheel.client.file_reloading.reload_base !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_base = (function (){var method_table__19422__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19423__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19424__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19425__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19426__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"figwheel.client.file-reloading","reload-base"),figwheel.client.utils.host_env_QMARK_,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19426__auto__,method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__));
})();
}
cljs.core._add_method.call(null,figwheel.client.file_reloading.reload_base,new cljs.core.Keyword(null,"node","node",581201198),(function (request_url,callback){

var root = clojure.string.join.call(null,"/",cljs.core.reverse.call(null,cljs.core.drop.call(null,(2),cljs.core.reverse.call(null,clojure.string.split.call(null,__dirname,"/")))));
var path = [cljs.core.str(root),cljs.core.str("/"),cljs.core.str(request_url)].join('');
(require.cache[path] = null);

return callback.call(null,(function (){try{return require(path);
}catch (e35650){if((e35650 instanceof Error)){
var e = e35650;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e35650;

}
}})());
}));
cljs.core._add_method.call(null,figwheel.client.file_reloading.reload_base,new cljs.core.Keyword(null,"html","html",-998796897),(function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred))
);

return deferred.addErrback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred))
);
}));
figwheel.client.file_reloading.reload_file_STAR_ = (function figwheel$client$file_reloading$reload_file_STAR_(){
var args35651 = [];
var len__19567__auto___35654 = arguments.length;
var i__19568__auto___35655 = (0);
while(true){
if((i__19568__auto___35655 < len__19567__auto___35654)){
args35651.push((arguments[i__19568__auto___35655]));

var G__35656 = (i__19568__auto___35655 + (1));
i__19568__auto___35655 = G__35656;
continue;
} else {
}
break;
}

var G__35653 = args35651.length;
switch (G__35653) {
case 2:
return figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35651.length)].join('')));

}
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (request_url,callback){
return figwheel.client.file_reloading.reload_base.call(null,request_url,callback);
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (request_url){
return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,cljs.core.identity);
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__35658,callback){
var map__35661 = p__35658;
var map__35661__$1 = ((((!((map__35661 == null)))?((((map__35661.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35661.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35661):map__35661);
var file_msg = map__35661__$1;
var request_url = cljs.core.get.call(null,map__35661__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__35661,map__35661__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfullly loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__35661,map__35661__$1,file_msg,request_url))
);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__35663){
var map__35666 = p__35663;
var map__35666__$1 = ((((!((map__35666 == null)))?((((map__35666.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35666.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35666):map__35666);
var file_msg = map__35666__$1;
var namespace = cljs.core.get.call(null,map__35666__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,map__35666__$1,new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157));

var meta_data__$1 = (function (){var or__18528__auto__ = meta_data;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var and__18516__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_data__$1));
if(and__18516__auto__){
var or__18528__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
var or__18528__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
if(cljs.core.truth_(or__18528__auto____$1)){
return or__18528__auto____$1;
} else {
var and__18516__auto____$1 = cljs.core.contains_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_,namespace);
if(and__18516__auto____$1){
var or__18528__auto____$2 = !(cljs.core.contains_QMARK_.call(null,meta_data__$1,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932)));
if(or__18528__auto____$2){
return or__18528__auto____$2;
} else {
return new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
}
} else {
return and__18516__auto____$1;
}
}
}
} else {
return and__18516__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__35668,callback){
var map__35671 = p__35668;
var map__35671__$1 = ((((!((map__35671 == null)))?((((map__35671.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35671.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35671):map__35671);
var file_msg = map__35671__$1;
var request_url = cljs.core.get.call(null,map__35671__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__35671__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.reload_file.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
setTimeout(((function (out){
return (function (){
return figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
figwheel.client.file_reloading.patch_goog_base.call(null);

cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);
});})(out))
,(0));

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__23999__auto___35759 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto___35759,out){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto___35759,out){
return (function (state_35741){
var state_val_35742 = (state_35741[(1)]);
if((state_val_35742 === (1))){
var inst_35719 = cljs.core.nth.call(null,files,(0),null);
var inst_35720 = cljs.core.nthnext.call(null,files,(1));
var inst_35721 = files;
var state_35741__$1 = (function (){var statearr_35743 = state_35741;
(statearr_35743[(7)] = inst_35719);

(statearr_35743[(8)] = inst_35720);

(statearr_35743[(9)] = inst_35721);

return statearr_35743;
})();
var statearr_35744_35760 = state_35741__$1;
(statearr_35744_35760[(2)] = null);

(statearr_35744_35760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35742 === (2))){
var inst_35724 = (state_35741[(10)]);
var inst_35721 = (state_35741[(9)]);
var inst_35724__$1 = cljs.core.nth.call(null,inst_35721,(0),null);
var inst_35725 = cljs.core.nthnext.call(null,inst_35721,(1));
var inst_35726 = (inst_35724__$1 == null);
var inst_35727 = cljs.core.not.call(null,inst_35726);
var state_35741__$1 = (function (){var statearr_35745 = state_35741;
(statearr_35745[(10)] = inst_35724__$1);

(statearr_35745[(11)] = inst_35725);

return statearr_35745;
})();
if(inst_35727){
var statearr_35746_35761 = state_35741__$1;
(statearr_35746_35761[(1)] = (4));

} else {
var statearr_35747_35762 = state_35741__$1;
(statearr_35747_35762[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35742 === (3))){
var inst_35739 = (state_35741[(2)]);
var state_35741__$1 = state_35741;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35741__$1,inst_35739);
} else {
if((state_val_35742 === (4))){
var inst_35724 = (state_35741[(10)]);
var inst_35729 = figwheel.client.file_reloading.reload_js_file.call(null,inst_35724);
var state_35741__$1 = state_35741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35741__$1,(7),inst_35729);
} else {
if((state_val_35742 === (5))){
var inst_35735 = cljs.core.async.close_BANG_.call(null,out);
var state_35741__$1 = state_35741;
var statearr_35748_35763 = state_35741__$1;
(statearr_35748_35763[(2)] = inst_35735);

(statearr_35748_35763[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35742 === (6))){
var inst_35737 = (state_35741[(2)]);
var state_35741__$1 = state_35741;
var statearr_35749_35764 = state_35741__$1;
(statearr_35749_35764[(2)] = inst_35737);

(statearr_35749_35764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35742 === (7))){
var inst_35725 = (state_35741[(11)]);
var inst_35731 = (state_35741[(2)]);
var inst_35732 = cljs.core.async.put_BANG_.call(null,out,inst_35731);
var inst_35721 = inst_35725;
var state_35741__$1 = (function (){var statearr_35750 = state_35741;
(statearr_35750[(12)] = inst_35732);

(statearr_35750[(9)] = inst_35721);

return statearr_35750;
})();
var statearr_35751_35765 = state_35741__$1;
(statearr_35751_35765[(2)] = null);

(statearr_35751_35765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23999__auto___35759,out))
;
return ((function (switch__23984__auto__,c__23999__auto___35759,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto____0 = (function (){
var statearr_35755 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35755[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto__);

(statearr_35755[(1)] = (1));

return statearr_35755;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto____1 = (function (state_35741){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_35741);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e35756){if((e35756 instanceof Object)){
var ex__23988__auto__ = e35756;
var statearr_35757_35766 = state_35741;
(statearr_35757_35766[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35741);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35756;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35767 = state_35741;
state_35741 = G__35767;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto__ = function(state_35741){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto____1.call(this,state_35741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto___35759,out))
})();
var state__24001__auto__ = (function (){var statearr_35758 = f__24000__auto__.call(null);
(statearr_35758[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto___35759);

return statearr_35758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto___35759,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.add_request_url = (function figwheel$client$file_reloading$add_request_url(p__35768,p__35769){
var map__35774 = p__35768;
var map__35774__$1 = ((((!((map__35774 == null)))?((((map__35774.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35774.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35774):map__35774);
var opts = map__35774__$1;
var url_rewriter = cljs.core.get.call(null,map__35774__$1,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",200543838));
var map__35775 = p__35769;
var map__35775__$1 = ((((!((map__35775 == null)))?((((map__35775.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35775.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35775):map__35775);
var file_msg = map__35775__$1;
var file = cljs.core.get.call(null,map__35775__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var resolved_path = figwheel.client.file_reloading.resolve_url.call(null,file_msg);
return cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"request-url","request-url",2100346596),(cljs.core.truth_(url_rewriter)?url_rewriter.call(null,resolved_path):resolved_path));
});
figwheel.client.file_reloading.add_request_urls = (function figwheel$client$file_reloading$add_request_urls(opts,files){
return cljs.core.map.call(null,cljs.core.partial.call(null,figwheel.client.file_reloading.add_request_url,opts),files);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__35778){
var map__35782 = p__35778;
var map__35782__$1 = ((((!((map__35782 == null)))?((((map__35782.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35782.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35782):map__35782);
var eval_body__$1 = cljs.core.get.call(null,map__35782__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__35782__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__18516__auto__ = eval_body__$1;
if(cljs.core.truth_(and__18516__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__18516__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return eval(code);
}catch (e35784){var e = e35784;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__35789,p__35790){
var map__36018 = p__35789;
var map__36018__$1 = ((((!((map__36018 == null)))?((((map__36018.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36018.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36018):map__36018);
var opts = map__36018__$1;
var before_jsload = cljs.core.get.call(null,map__36018__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__36018__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var load_unchanged_files = cljs.core.get.call(null,map__36018__$1,new cljs.core.Keyword(null,"load-unchanged-files","load-unchanged-files",-1561468704));
var map__36019 = p__35790;
var map__36019__$1 = ((((!((map__36019 == null)))?((((map__36019.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36019.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36019):map__36019);
var msg = map__36019__$1;
var files = cljs.core.get.call(null,map__36019__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var c__23999__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files){
return (function (state_36160){
var state_val_36161 = (state_36160[(1)]);
if((state_val_36161 === (7))){
var inst_36036 = (state_36160[(7)]);
var inst_36034 = (state_36160[(8)]);
var inst_36035 = (state_36160[(9)]);
var inst_36033 = (state_36160[(10)]);
var inst_36041 = cljs.core._nth.call(null,inst_36034,inst_36036);
var inst_36042 = figwheel.client.file_reloading.eval_body.call(null,inst_36041);
var inst_36043 = (inst_36036 + (1));
var tmp36162 = inst_36034;
var tmp36163 = inst_36035;
var tmp36164 = inst_36033;
var inst_36033__$1 = tmp36164;
var inst_36034__$1 = tmp36162;
var inst_36035__$1 = tmp36163;
var inst_36036__$1 = inst_36043;
var state_36160__$1 = (function (){var statearr_36165 = state_36160;
(statearr_36165[(7)] = inst_36036__$1);

(statearr_36165[(11)] = inst_36042);

(statearr_36165[(8)] = inst_36034__$1);

(statearr_36165[(9)] = inst_36035__$1);

(statearr_36165[(10)] = inst_36033__$1);

return statearr_36165;
})();
var statearr_36166_36245 = state_36160__$1;
(statearr_36166_36245[(2)] = null);

(statearr_36166_36245[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (20))){
var inst_36083 = (state_36160[(12)]);
var inst_36078 = (state_36160[(13)]);
var inst_36082 = (state_36160[(14)]);
var inst_36079 = (state_36160[(15)]);
var inst_36085 = (state_36160[(16)]);
var inst_36088 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_36090 = (function (){var all_files = inst_36078;
var files_SINGLEQUOTE_ = inst_36079;
var res_SINGLEQUOTE_ = inst_36082;
var res = inst_36083;
var files_not_loaded = inst_36085;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_36083,inst_36078,inst_36082,inst_36079,inst_36085,inst_36088,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files){
return (function (p__36089){
var map__36167 = p__36089;
var map__36167__$1 = ((((!((map__36167 == null)))?((((map__36167.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36167.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36167):map__36167);
var namespace = cljs.core.get.call(null,map__36167__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__36167__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.ns_to_js_file.call(null,namespace);
} else {
return file;
}
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_36083,inst_36078,inst_36082,inst_36079,inst_36085,inst_36088,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files))
})();
var inst_36091 = cljs.core.map.call(null,inst_36090,inst_36083);
var inst_36092 = cljs.core.pr_str.call(null,inst_36091);
var inst_36093 = figwheel.client.utils.log.call(null,inst_36092);
var inst_36094 = (function (){var all_files = inst_36078;
var files_SINGLEQUOTE_ = inst_36079;
var res_SINGLEQUOTE_ = inst_36082;
var res = inst_36083;
var files_not_loaded = inst_36085;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_36083,inst_36078,inst_36082,inst_36079,inst_36085,inst_36088,inst_36090,inst_36091,inst_36092,inst_36093,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_36083,inst_36078,inst_36082,inst_36079,inst_36085,inst_36088,inst_36090,inst_36091,inst_36092,inst_36093,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files))
})();
var inst_36095 = setTimeout(inst_36094,(10));
var state_36160__$1 = (function (){var statearr_36169 = state_36160;
(statearr_36169[(17)] = inst_36093);

(statearr_36169[(18)] = inst_36088);

return statearr_36169;
})();
var statearr_36170_36246 = state_36160__$1;
(statearr_36170_36246[(2)] = inst_36095);

(statearr_36170_36246[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (27))){
var state_36160__$1 = state_36160;
var statearr_36171_36247 = state_36160__$1;
(statearr_36171_36247[(2)] = false);

(statearr_36171_36247[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (1))){
var inst_36025 = (state_36160[(19)]);
var inst_36022 = before_jsload.call(null,files);
var inst_36023 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_36024 = (function (){return ((function (inst_36025,inst_36022,inst_36023,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files){
return (function (p1__35785_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__35785_SHARP_);
});
;})(inst_36025,inst_36022,inst_36023,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files))
})();
var inst_36025__$1 = cljs.core.filter.call(null,inst_36024,files);
var inst_36026 = cljs.core.not_empty.call(null,inst_36025__$1);
var state_36160__$1 = (function (){var statearr_36172 = state_36160;
(statearr_36172[(19)] = inst_36025__$1);

(statearr_36172[(20)] = inst_36022);

(statearr_36172[(21)] = inst_36023);

return statearr_36172;
})();
if(cljs.core.truth_(inst_36026)){
var statearr_36173_36248 = state_36160__$1;
(statearr_36173_36248[(1)] = (2));

} else {
var statearr_36174_36249 = state_36160__$1;
(statearr_36174_36249[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (24))){
var state_36160__$1 = state_36160;
var statearr_36175_36250 = state_36160__$1;
(statearr_36175_36250[(2)] = null);

(statearr_36175_36250[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (39))){
var state_36160__$1 = state_36160;
var statearr_36176_36251 = state_36160__$1;
(statearr_36176_36251[(2)] = null);

(statearr_36176_36251[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (4))){
var inst_36070 = (state_36160[(2)]);
var inst_36071 = (function (){return ((function (inst_36070,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files){
return (function (p1__35786_SHARP_){
var and__18516__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__35786_SHARP_);
if(cljs.core.truth_(and__18516__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__35786_SHARP_));
} else {
return and__18516__auto__;
}
});
;})(inst_36070,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files))
})();
var inst_36072 = cljs.core.filter.call(null,inst_36071,files);
var state_36160__$1 = (function (){var statearr_36177 = state_36160;
(statearr_36177[(22)] = inst_36070);

(statearr_36177[(23)] = inst_36072);

return statearr_36177;
})();
if(cljs.core.truth_(load_unchanged_files)){
var statearr_36178_36252 = state_36160__$1;
(statearr_36178_36252[(1)] = (16));

} else {
var statearr_36179_36253 = state_36160__$1;
(statearr_36179_36253[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (15))){
var inst_36060 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36180_36254 = state_36160__$1;
(statearr_36180_36254[(2)] = inst_36060);

(statearr_36180_36254[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (21))){
var state_36160__$1 = state_36160;
var statearr_36181_36255 = state_36160__$1;
(statearr_36181_36255[(2)] = null);

(statearr_36181_36255[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (31))){
var inst_36117 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36182_36256 = state_36160__$1;
(statearr_36182_36256[(2)] = inst_36117);

(statearr_36182_36256[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (32))){
var inst_36105 = (state_36160[(24)]);
var inst_36122 = cljs.core.apply.call(null,cljs.core.hash_map,inst_36105);
var state_36160__$1 = state_36160;
var statearr_36183_36257 = state_36160__$1;
(statearr_36183_36257[(2)] = inst_36122);

(statearr_36183_36257[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (40))){
var inst_36128 = (state_36160[(25)]);
var inst_36146 = (state_36160[(2)]);
var inst_36147 = cljs.core.not_empty.call(null,inst_36128);
var state_36160__$1 = (function (){var statearr_36184 = state_36160;
(statearr_36184[(26)] = inst_36146);

return statearr_36184;
})();
if(cljs.core.truth_(inst_36147)){
var statearr_36185_36258 = state_36160__$1;
(statearr_36185_36258[(1)] = (41));

} else {
var statearr_36186_36259 = state_36160__$1;
(statearr_36186_36259[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (33))){
var inst_36105 = (state_36160[(24)]);
var state_36160__$1 = state_36160;
var statearr_36187_36260 = state_36160__$1;
(statearr_36187_36260[(2)] = inst_36105);

(statearr_36187_36260[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (13))){
var inst_36046 = (state_36160[(27)]);
var inst_36050 = cljs.core.chunk_first.call(null,inst_36046);
var inst_36051 = cljs.core.chunk_rest.call(null,inst_36046);
var inst_36052 = cljs.core.count.call(null,inst_36050);
var inst_36033 = inst_36051;
var inst_36034 = inst_36050;
var inst_36035 = inst_36052;
var inst_36036 = (0);
var state_36160__$1 = (function (){var statearr_36188 = state_36160;
(statearr_36188[(7)] = inst_36036);

(statearr_36188[(8)] = inst_36034);

(statearr_36188[(9)] = inst_36035);

(statearr_36188[(10)] = inst_36033);

return statearr_36188;
})();
var statearr_36189_36261 = state_36160__$1;
(statearr_36189_36261[(2)] = null);

(statearr_36189_36261[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (22))){
var inst_36085 = (state_36160[(16)]);
var inst_36098 = (state_36160[(2)]);
var inst_36099 = cljs.core.not_empty.call(null,inst_36085);
var state_36160__$1 = (function (){var statearr_36190 = state_36160;
(statearr_36190[(28)] = inst_36098);

return statearr_36190;
})();
if(cljs.core.truth_(inst_36099)){
var statearr_36191_36262 = state_36160__$1;
(statearr_36191_36262[(1)] = (23));

} else {
var statearr_36192_36263 = state_36160__$1;
(statearr_36192_36263[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (36))){
var state_36160__$1 = state_36160;
var statearr_36193_36264 = state_36160__$1;
(statearr_36193_36264[(2)] = null);

(statearr_36193_36264[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (41))){
var inst_36128 = (state_36160[(25)]);
var inst_36149 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_36128);
var inst_36150 = cljs.core.pr_str.call(null,inst_36149);
var inst_36151 = [cljs.core.str("not required: "),cljs.core.str(inst_36150)].join('');
var inst_36152 = figwheel.client.utils.log.call(null,inst_36151);
var state_36160__$1 = state_36160;
var statearr_36194_36265 = state_36160__$1;
(statearr_36194_36265[(2)] = inst_36152);

(statearr_36194_36265[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (43))){
var inst_36155 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36195_36266 = state_36160__$1;
(statearr_36195_36266[(2)] = inst_36155);

(statearr_36195_36266[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (29))){
var state_36160__$1 = state_36160;
var statearr_36196_36267 = state_36160__$1;
(statearr_36196_36267[(2)] = true);

(statearr_36196_36267[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (6))){
var inst_36067 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36197_36268 = state_36160__$1;
(statearr_36197_36268[(2)] = inst_36067);

(statearr_36197_36268[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (28))){
var inst_36120 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
if(cljs.core.truth_(inst_36120)){
var statearr_36198_36269 = state_36160__$1;
(statearr_36198_36269[(1)] = (32));

} else {
var statearr_36199_36270 = state_36160__$1;
(statearr_36199_36270[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (25))){
var inst_36158 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36160__$1,inst_36158);
} else {
if((state_val_36161 === (34))){
var inst_36126 = (state_36160[(29)]);
var inst_36125 = (state_36160[(2)]);
var inst_36126__$1 = cljs.core.get.call(null,inst_36125,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_36127 = cljs.core.get.call(null,inst_36125,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932));
var inst_36128 = cljs.core.get.call(null,inst_36125,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_36129 = cljs.core.not_empty.call(null,inst_36126__$1);
var state_36160__$1 = (function (){var statearr_36200 = state_36160;
(statearr_36200[(29)] = inst_36126__$1);

(statearr_36200[(25)] = inst_36128);

(statearr_36200[(30)] = inst_36127);

return statearr_36200;
})();
if(cljs.core.truth_(inst_36129)){
var statearr_36201_36271 = state_36160__$1;
(statearr_36201_36271[(1)] = (35));

} else {
var statearr_36202_36272 = state_36160__$1;
(statearr_36202_36272[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (17))){
var inst_36072 = (state_36160[(23)]);
var state_36160__$1 = state_36160;
var statearr_36203_36273 = state_36160__$1;
(statearr_36203_36273[(2)] = inst_36072);

(statearr_36203_36273[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (3))){
var state_36160__$1 = state_36160;
var statearr_36204_36274 = state_36160__$1;
(statearr_36204_36274[(2)] = null);

(statearr_36204_36274[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (12))){
var inst_36063 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36205_36275 = state_36160__$1;
(statearr_36205_36275[(2)] = inst_36063);

(statearr_36205_36275[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (2))){
var inst_36025 = (state_36160[(19)]);
var inst_36032 = cljs.core.seq.call(null,inst_36025);
var inst_36033 = inst_36032;
var inst_36034 = null;
var inst_36035 = (0);
var inst_36036 = (0);
var state_36160__$1 = (function (){var statearr_36206 = state_36160;
(statearr_36206[(7)] = inst_36036);

(statearr_36206[(8)] = inst_36034);

(statearr_36206[(9)] = inst_36035);

(statearr_36206[(10)] = inst_36033);

return statearr_36206;
})();
var statearr_36207_36276 = state_36160__$1;
(statearr_36207_36276[(2)] = null);

(statearr_36207_36276[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (23))){
var inst_36083 = (state_36160[(12)]);
var inst_36078 = (state_36160[(13)]);
var inst_36082 = (state_36160[(14)]);
var inst_36079 = (state_36160[(15)]);
var inst_36105 = (state_36160[(24)]);
var inst_36085 = (state_36160[(16)]);
var inst_36101 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_36104 = (function (){var all_files = inst_36078;
var files_SINGLEQUOTE_ = inst_36079;
var res_SINGLEQUOTE_ = inst_36082;
var res = inst_36083;
var files_not_loaded = inst_36085;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_36083,inst_36078,inst_36082,inst_36079,inst_36105,inst_36085,inst_36101,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files){
return (function (p__36103){
var map__36208 = p__36103;
var map__36208__$1 = ((((!((map__36208 == null)))?((((map__36208.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36208.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36208):map__36208);
var meta_data = cljs.core.get.call(null,map__36208__$1,new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.contains_QMARK_.call(null,meta_data,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
if((cljs.core.contains_QMARK_.call(null,meta_data,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932))) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932).cljs$core$IFn$_invoke$arity$1(meta_data)))){
return new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
}
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_36083,inst_36078,inst_36082,inst_36079,inst_36105,inst_36085,inst_36101,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files))
})();
var inst_36105__$1 = cljs.core.group_by.call(null,inst_36104,inst_36085);
var inst_36107 = (inst_36105__$1 == null);
var inst_36108 = cljs.core.not.call(null,inst_36107);
var state_36160__$1 = (function (){var statearr_36210 = state_36160;
(statearr_36210[(31)] = inst_36101);

(statearr_36210[(24)] = inst_36105__$1);

return statearr_36210;
})();
if(inst_36108){
var statearr_36211_36277 = state_36160__$1;
(statearr_36211_36277[(1)] = (26));

} else {
var statearr_36212_36278 = state_36160__$1;
(statearr_36212_36278[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (35))){
var inst_36126 = (state_36160[(29)]);
var inst_36131 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_36126);
var inst_36132 = cljs.core.pr_str.call(null,inst_36131);
var inst_36133 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_36132)].join('');
var inst_36134 = figwheel.client.utils.log.call(null,inst_36133);
var state_36160__$1 = state_36160;
var statearr_36213_36279 = state_36160__$1;
(statearr_36213_36279[(2)] = inst_36134);

(statearr_36213_36279[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (19))){
var inst_36083 = (state_36160[(12)]);
var inst_36078 = (state_36160[(13)]);
var inst_36082 = (state_36160[(14)]);
var inst_36079 = (state_36160[(15)]);
var inst_36082__$1 = (state_36160[(2)]);
var inst_36083__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_36082__$1);
var inst_36084 = (function (){var all_files = inst_36078;
var files_SINGLEQUOTE_ = inst_36079;
var res_SINGLEQUOTE_ = inst_36082__$1;
var res = inst_36083__$1;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,inst_36083,inst_36078,inst_36082,inst_36079,inst_36082__$1,inst_36083__$1,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files){
return (function (p1__35788_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__35788_SHARP_));
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,inst_36083,inst_36078,inst_36082,inst_36079,inst_36082__$1,inst_36083__$1,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files))
})();
var inst_36085 = cljs.core.filter.call(null,inst_36084,inst_36082__$1);
var inst_36086 = cljs.core.not_empty.call(null,inst_36083__$1);
var state_36160__$1 = (function (){var statearr_36214 = state_36160;
(statearr_36214[(12)] = inst_36083__$1);

(statearr_36214[(14)] = inst_36082__$1);

(statearr_36214[(16)] = inst_36085);

return statearr_36214;
})();
if(cljs.core.truth_(inst_36086)){
var statearr_36215_36280 = state_36160__$1;
(statearr_36215_36280[(1)] = (20));

} else {
var statearr_36216_36281 = state_36160__$1;
(statearr_36216_36281[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (11))){
var state_36160__$1 = state_36160;
var statearr_36217_36282 = state_36160__$1;
(statearr_36217_36282[(2)] = null);

(statearr_36217_36282[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (9))){
var inst_36065 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36218_36283 = state_36160__$1;
(statearr_36218_36283[(2)] = inst_36065);

(statearr_36218_36283[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (5))){
var inst_36036 = (state_36160[(7)]);
var inst_36035 = (state_36160[(9)]);
var inst_36038 = (inst_36036 < inst_36035);
var inst_36039 = inst_36038;
var state_36160__$1 = state_36160;
if(cljs.core.truth_(inst_36039)){
var statearr_36219_36284 = state_36160__$1;
(statearr_36219_36284[(1)] = (7));

} else {
var statearr_36220_36285 = state_36160__$1;
(statearr_36220_36285[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (14))){
var inst_36046 = (state_36160[(27)]);
var inst_36055 = cljs.core.first.call(null,inst_36046);
var inst_36056 = figwheel.client.file_reloading.eval_body.call(null,inst_36055);
var inst_36057 = cljs.core.next.call(null,inst_36046);
var inst_36033 = inst_36057;
var inst_36034 = null;
var inst_36035 = (0);
var inst_36036 = (0);
var state_36160__$1 = (function (){var statearr_36221 = state_36160;
(statearr_36221[(7)] = inst_36036);

(statearr_36221[(8)] = inst_36034);

(statearr_36221[(9)] = inst_36035);

(statearr_36221[(10)] = inst_36033);

(statearr_36221[(32)] = inst_36056);

return statearr_36221;
})();
var statearr_36222_36286 = state_36160__$1;
(statearr_36222_36286[(2)] = null);

(statearr_36222_36286[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (26))){
var inst_36105 = (state_36160[(24)]);
var inst_36110 = inst_36105.cljs$lang$protocol_mask$partition0$;
var inst_36111 = (inst_36110 & (64));
var inst_36112 = inst_36105.cljs$core$ISeq$;
var inst_36113 = (inst_36111) || (inst_36112);
var state_36160__$1 = state_36160;
if(cljs.core.truth_(inst_36113)){
var statearr_36223_36287 = state_36160__$1;
(statearr_36223_36287[(1)] = (29));

} else {
var statearr_36224_36288 = state_36160__$1;
(statearr_36224_36288[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (16))){
var inst_36072 = (state_36160[(23)]);
var inst_36074 = (function (){var all_files = inst_36072;
return ((function (all_files,inst_36072,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files){
return (function (p1__35787_SHARP_){
return cljs.core.update_in.call(null,p1__35787_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157)], null),cljs.core.dissoc,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932));
});
;})(all_files,inst_36072,state_val_36161,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files))
})();
var inst_36075 = cljs.core.map.call(null,inst_36074,inst_36072);
var state_36160__$1 = state_36160;
var statearr_36225_36289 = state_36160__$1;
(statearr_36225_36289[(2)] = inst_36075);

(statearr_36225_36289[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (38))){
var inst_36127 = (state_36160[(30)]);
var inst_36140 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_36127);
var inst_36141 = cljs.core.pr_str.call(null,inst_36140);
var inst_36142 = [cljs.core.str("file didn't change: "),cljs.core.str(inst_36141)].join('');
var inst_36143 = figwheel.client.utils.log.call(null,inst_36142);
var state_36160__$1 = state_36160;
var statearr_36226_36290 = state_36160__$1;
(statearr_36226_36290[(2)] = inst_36143);

(statearr_36226_36290[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (30))){
var state_36160__$1 = state_36160;
var statearr_36227_36291 = state_36160__$1;
(statearr_36227_36291[(2)] = false);

(statearr_36227_36291[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (10))){
var inst_36046 = (state_36160[(27)]);
var inst_36048 = cljs.core.chunked_seq_QMARK_.call(null,inst_36046);
var state_36160__$1 = state_36160;
if(inst_36048){
var statearr_36228_36292 = state_36160__$1;
(statearr_36228_36292[(1)] = (13));

} else {
var statearr_36229_36293 = state_36160__$1;
(statearr_36229_36293[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (18))){
var inst_36078 = (state_36160[(13)]);
var inst_36079 = (state_36160[(15)]);
var inst_36078__$1 = (state_36160[(2)]);
var inst_36079__$1 = figwheel.client.file_reloading.add_request_urls.call(null,opts,inst_36078__$1);
var inst_36080 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_36079__$1);
var state_36160__$1 = (function (){var statearr_36230 = state_36160;
(statearr_36230[(13)] = inst_36078__$1);

(statearr_36230[(15)] = inst_36079__$1);

return statearr_36230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36160__$1,(19),inst_36080);
} else {
if((state_val_36161 === (42))){
var state_36160__$1 = state_36160;
var statearr_36231_36294 = state_36160__$1;
(statearr_36231_36294[(2)] = null);

(statearr_36231_36294[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (37))){
var inst_36127 = (state_36160[(30)]);
var inst_36137 = (state_36160[(2)]);
var inst_36138 = cljs.core.not_empty.call(null,inst_36127);
var state_36160__$1 = (function (){var statearr_36232 = state_36160;
(statearr_36232[(33)] = inst_36137);

return statearr_36232;
})();
if(cljs.core.truth_(inst_36138)){
var statearr_36233_36295 = state_36160__$1;
(statearr_36233_36295[(1)] = (38));

} else {
var statearr_36234_36296 = state_36160__$1;
(statearr_36234_36296[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (8))){
var inst_36046 = (state_36160[(27)]);
var inst_36033 = (state_36160[(10)]);
var inst_36046__$1 = cljs.core.seq.call(null,inst_36033);
var state_36160__$1 = (function (){var statearr_36235 = state_36160;
(statearr_36235[(27)] = inst_36046__$1);

return statearr_36235;
})();
if(inst_36046__$1){
var statearr_36236_36297 = state_36160__$1;
(statearr_36236_36297[(1)] = (10));

} else {
var statearr_36237_36298 = state_36160__$1;
(statearr_36237_36298[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files))
;
return ((function (switch__23984__auto__,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto____0 = (function (){
var statearr_36241 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36241[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto__);

(statearr_36241[(1)] = (1));

return statearr_36241;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto____1 = (function (state_36160){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_36160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e36242){if((e36242 instanceof Object)){
var ex__23988__auto__ = e36242;
var statearr_36243_36299 = state_36160;
(statearr_36243_36299[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36160);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36242;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36300 = state_36160;
state_36160 = G__36300;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto__ = function(state_36160){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto____1.call(this,state_36160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files))
})();
var state__24001__auto__ = (function (){var statearr_36244 = f__24000__auto__.call(null);
(statearr_36244[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto__);

return statearr_36244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto__,map__36018,map__36018__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__36019,map__36019__$1,msg,files))
);

return c__23999__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__36303,link){
var map__36306 = p__36303;
var map__36306__$1 = ((((!((map__36306 == null)))?((((map__36306.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36306.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36306):map__36306);
var file = cljs.core.get.call(null,map__36306__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__36306,map__36306__$1,file){
return (function (p1__36301_SHARP_,p2__36302_SHARP_){
if(cljs.core._EQ_.call(null,p1__36301_SHARP_,p2__36302_SHARP_)){
return p1__36301_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__36306,map__36306__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__36312){
var map__36313 = p__36312;
var map__36313__$1 = ((((!((map__36313 == null)))?((((map__36313.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36313.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36313):map__36313);
var match_length = cljs.core.get.call(null,map__36313__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__36313__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__36308_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__36308_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(){
var args36315 = [];
var len__19567__auto___36318 = arguments.length;
var i__19568__auto___36319 = (0);
while(true){
if((i__19568__auto___36319 < len__19567__auto___36318)){
args36315.push((arguments[i__19568__auto___36319]));

var G__36320 = (i__19568__auto___36319 + (1));
i__19568__auto___36319 = G__36320;
continue;
} else {
}
break;
}

var G__36317 = args36315.length;
switch (G__36317) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36315.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__36322){
var map__36325 = p__36322;
var map__36325__$1 = ((((!((map__36325 == null)))?((((map__36325.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36325.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36325):map__36325);
var f_data = map__36325__$1;
var file = cljs.core.get.call(null,map__36325__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var request_url = cljs.core.get.call(null,map__36325__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var temp__4423__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4423__auto__)){
var link = temp__4423__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return figwheel.client.file_reloading.add_link_to_doc.call(null,figwheel.client.file_reloading.create_link.call(null,(function (){var or__18528__auto__ = request_url;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return file;
}
})()));
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__36327,files_msg){
var map__36350 = p__36327;
var map__36350__$1 = ((((!((map__36350 == null)))?((((map__36350.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36350.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36350):map__36350);
var opts = map__36350__$1;
var on_cssload = cljs.core.get.call(null,map__36350__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__36352_36372 = cljs.core.seq.call(null,figwheel.client.file_reloading.add_request_urls.call(null,opts,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__36353_36373 = null;
var count__36354_36374 = (0);
var i__36355_36375 = (0);
while(true){
if((i__36355_36375 < count__36354_36374)){
var f_36376 = cljs.core._nth.call(null,chunk__36353_36373,i__36355_36375);
figwheel.client.file_reloading.reload_css_file.call(null,f_36376);

var G__36377 = seq__36352_36372;
var G__36378 = chunk__36353_36373;
var G__36379 = count__36354_36374;
var G__36380 = (i__36355_36375 + (1));
seq__36352_36372 = G__36377;
chunk__36353_36373 = G__36378;
count__36354_36374 = G__36379;
i__36355_36375 = G__36380;
continue;
} else {
var temp__4425__auto___36381 = cljs.core.seq.call(null,seq__36352_36372);
if(temp__4425__auto___36381){
var seq__36352_36382__$1 = temp__4425__auto___36381;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36352_36382__$1)){
var c__19312__auto___36383 = cljs.core.chunk_first.call(null,seq__36352_36382__$1);
var G__36384 = cljs.core.chunk_rest.call(null,seq__36352_36382__$1);
var G__36385 = c__19312__auto___36383;
var G__36386 = cljs.core.count.call(null,c__19312__auto___36383);
var G__36387 = (0);
seq__36352_36372 = G__36384;
chunk__36353_36373 = G__36385;
count__36354_36374 = G__36386;
i__36355_36375 = G__36387;
continue;
} else {
var f_36388 = cljs.core.first.call(null,seq__36352_36382__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_36388);

var G__36389 = cljs.core.next.call(null,seq__36352_36382__$1);
var G__36390 = null;
var G__36391 = (0);
var G__36392 = (0);
seq__36352_36372 = G__36389;
chunk__36353_36373 = G__36390;
count__36354_36374 = G__36391;
i__36355_36375 = G__36392;
continue;
}
} else {
}
}
break;
}

var c__23999__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23999__auto__,map__36350,map__36350__$1,opts,on_cssload){
return (function (){
var f__24000__auto__ = (function (){var switch__23984__auto__ = ((function (c__23999__auto__,map__36350,map__36350__$1,opts,on_cssload){
return (function (state_36362){
var state_val_36363 = (state_36362[(1)]);
if((state_val_36363 === (1))){
var inst_36356 = cljs.core.async.timeout.call(null,(100));
var state_36362__$1 = state_36362;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36362__$1,(2),inst_36356);
} else {
if((state_val_36363 === (2))){
var inst_36358 = (state_36362[(2)]);
var inst_36359 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg);
var inst_36360 = on_cssload.call(null,inst_36359);
var state_36362__$1 = (function (){var statearr_36364 = state_36362;
(statearr_36364[(7)] = inst_36358);

return statearr_36364;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36362__$1,inst_36360);
} else {
return null;
}
}
});})(c__23999__auto__,map__36350,map__36350__$1,opts,on_cssload))
;
return ((function (switch__23984__auto__,c__23999__auto__,map__36350,map__36350__$1,opts,on_cssload){
return (function() {
var figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto__ = null;
var figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto____0 = (function (){
var statearr_36368 = [null,null,null,null,null,null,null,null];
(statearr_36368[(0)] = figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto__);

(statearr_36368[(1)] = (1));

return statearr_36368;
});
var figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto____1 = (function (state_36362){
while(true){
var ret_value__23986__auto__ = (function (){try{while(true){
var result__23987__auto__ = switch__23984__auto__.call(null,state_36362);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23987__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23987__auto__;
}
break;
}
}catch (e36369){if((e36369 instanceof Object)){
var ex__23988__auto__ = e36369;
var statearr_36370_36393 = state_36362;
(statearr_36370_36393[(5)] = ex__23988__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36362);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36369;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23986__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36394 = state_36362;
state_36362 = G__36394;
continue;
} else {
return ret_value__23986__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto__ = function(state_36362){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto____1.call(this,state_36362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto____0;
figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto____1;
return figwheel$client$file_reloading$reload_css_files_$_state_machine__23985__auto__;
})()
;})(switch__23984__auto__,c__23999__auto__,map__36350,map__36350__$1,opts,on_cssload))
})();
var state__24001__auto__ = (function (){var statearr_36371 = f__24000__auto__.call(null);
(statearr_36371[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23999__auto__);

return statearr_36371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24001__auto__);
});})(c__23999__auto__,map__36350,map__36350__$1,opts,on_cssload))
);

return c__23999__auto__;
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map