// Compiled by ClojureScript 1.7.48 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__34325__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__34324 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__34324,(0),null);
var body = cljs.core.nthnext.call(null,vec__34324,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__34325 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34326__i = 0, G__34326__a = new Array(arguments.length -  0);
while (G__34326__i < G__34326__a.length) {G__34326__a[G__34326__i] = arguments[G__34326__i + 0]; ++G__34326__i;}
  args = new cljs.core.IndexedSeq(G__34326__a,0);
} 
return G__34325__delegate.call(this,args);};
G__34325.cljs$lang$maxFixedArity = 0;
G__34325.cljs$lang$applyTo = (function (arglist__34327){
var args = cljs.core.seq(arglist__34327);
return G__34325__delegate(args);
});
G__34325.cljs$core$IFn$_invoke$arity$variadic = G__34325__delegate;
return G__34325;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__19281__auto__ = (function sablono$core$update_arglists_$_iter__34332(s__34333){
return (new cljs.core.LazySeq(null,(function (){
var s__34333__$1 = s__34333;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__34333__$1);
if(temp__4425__auto__){
var s__34333__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__34333__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__34333__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__34335 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__34334 = (0);
while(true){
if((i__34334 < size__19280__auto__)){
var args = cljs.core._nth.call(null,c__19279__auto__,i__34334);
cljs.core.chunk_append.call(null,b__34335,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__34336 = (i__34334 + (1));
i__34334 = G__34336;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34335),sablono$core$update_arglists_$_iter__34332.call(null,cljs.core.chunk_rest.call(null,s__34333__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34335),null);
}
} else {
var args = cljs.core.first.call(null,s__34333__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__34332.call(null,cljs.core.rest.call(null,s__34333__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19281__auto__.call(null,arglists);
});
/**
 * Render the React `component` as an HTML string.
 */
sablono.core.render = (function sablono$core$render(component){
return React.renderComponentToString(component);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(){
var args__19574__auto__ = [];
var len__19567__auto___34342 = arguments.length;
var i__19568__auto___34343 = (0);
while(true){
if((i__19568__auto___34343 < len__19567__auto___34342)){
args__19574__auto__.push((arguments[i__19568__auto___34343]));

var G__34344 = (i__19568__auto___34343 + (1));
i__19568__auto___34343 = G__34344;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((0) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__19575__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__19281__auto__ = (function sablono$core$iter__34338(s__34339){
return (new cljs.core.LazySeq(null,(function (){
var s__34339__$1 = s__34339;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__34339__$1);
if(temp__4425__auto__){
var s__34339__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__34339__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__34339__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__34341 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__34340 = (0);
while(true){
if((i__34340 < size__19280__auto__)){
var style = cljs.core._nth.call(null,c__19279__auto__,i__34340);
cljs.core.chunk_append.call(null,b__34341,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__34345 = (i__34340 + (1));
i__34340 = G__34345;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34341),sablono$core$iter__34338.call(null,cljs.core.chunk_rest.call(null,s__34339__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34341),null);
}
} else {
var style = cljs.core.first.call(null,s__34339__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__34338.call(null,cljs.core.rest.call(null,s__34339__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19281__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq34337){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34337));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.9.0.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to34346 = (function sablono$core$link_to34346(){
var args__19574__auto__ = [];
var len__19567__auto___34349 = arguments.length;
var i__19568__auto___34350 = (0);
while(true){
if((i__19568__auto___34350 < len__19567__auto___34349)){
args__19574__auto__.push((arguments[i__19568__auto___34350]));

var G__34351 = (i__19568__auto___34350 + (1));
i__19568__auto___34350 = G__34351;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return sablono.core.link_to34346.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

sablono.core.link_to34346.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to34346.cljs$lang$maxFixedArity = (1);

sablono.core.link_to34346.cljs$lang$applyTo = (function (seq34347){
var G__34348 = cljs.core.first.call(null,seq34347);
var seq34347__$1 = cljs.core.next.call(null,seq34347);
return sablono.core.link_to34346.cljs$core$IFn$_invoke$arity$variadic(G__34348,seq34347__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to34346);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 * address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to34352 = (function sablono$core$mail_to34352(){
var args__19574__auto__ = [];
var len__19567__auto___34357 = arguments.length;
var i__19568__auto___34358 = (0);
while(true){
if((i__19568__auto___34358 < len__19567__auto___34357)){
args__19574__auto__.push((arguments[i__19568__auto___34358]));

var G__34359 = (i__19568__auto___34358 + (1));
i__19568__auto___34358 = G__34359;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return sablono.core.mail_to34352.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

sablono.core.mail_to34352.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__34355){
var vec__34356 = p__34355;
var content = cljs.core.nth.call(null,vec__34356,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__18528__auto__ = content;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to34352.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to34352.cljs$lang$applyTo = (function (seq34353){
var G__34354 = cljs.core.first.call(null,seq34353);
var seq34353__$1 = cljs.core.next.call(null,seq34353);
return sablono.core.mail_to34352.cljs$core$IFn$_invoke$arity$variadic(G__34354,seq34353__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to34352);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list34360 = (function sablono$core$unordered_list34360(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__19281__auto__ = (function sablono$core$unordered_list34360_$_iter__34365(s__34366){
return (new cljs.core.LazySeq(null,(function (){
var s__34366__$1 = s__34366;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__34366__$1);
if(temp__4425__auto__){
var s__34366__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__34366__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__34366__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__34368 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__34367 = (0);
while(true){
if((i__34367 < size__19280__auto__)){
var x = cljs.core._nth.call(null,c__19279__auto__,i__34367);
cljs.core.chunk_append.call(null,b__34368,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__34369 = (i__34367 + (1));
i__34367 = G__34369;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34368),sablono$core$unordered_list34360_$_iter__34365.call(null,cljs.core.chunk_rest.call(null,s__34366__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34368),null);
}
} else {
var x = cljs.core.first.call(null,s__34366__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list34360_$_iter__34365.call(null,cljs.core.rest.call(null,s__34366__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19281__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list34360);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list34370 = (function sablono$core$ordered_list34370(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__19281__auto__ = (function sablono$core$ordered_list34370_$_iter__34375(s__34376){
return (new cljs.core.LazySeq(null,(function (){
var s__34376__$1 = s__34376;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__34376__$1);
if(temp__4425__auto__){
var s__34376__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__34376__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__34376__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__34378 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__34377 = (0);
while(true){
if((i__34377 < size__19280__auto__)){
var x = cljs.core._nth.call(null,c__19279__auto__,i__34377);
cljs.core.chunk_append.call(null,b__34378,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__34379 = (i__34377 + (1));
i__34377 = G__34379;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34378),sablono$core$ordered_list34370_$_iter__34375.call(null,cljs.core.chunk_rest.call(null,s__34376__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34378),null);
}
} else {
var x = cljs.core.first.call(null,s__34376__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list34370_$_iter__34375.call(null,cljs.core.rest.call(null,s__34376__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19281__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list34370);
/**
 * Create an image element.
 */
sablono.core.image34380 = (function sablono$core$image34380(){
var args34381 = [];
var len__19567__auto___34384 = arguments.length;
var i__19568__auto___34385 = (0);
while(true){
if((i__19568__auto___34385 < len__19567__auto___34384)){
args34381.push((arguments[i__19568__auto___34385]));

var G__34386 = (i__19568__auto___34385 + (1));
i__19568__auto___34385 = G__34386;
continue;
} else {
}
break;
}

var G__34383 = args34381.length;
switch (G__34383) {
case 1:
return sablono.core.image34380.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image34380.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34381.length)].join('')));

}
});

sablono.core.image34380.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image34380.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image34380.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image34380);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__34388_SHARP_,p2__34389_SHARP_){
return [cljs.core.str(p1__34388_SHARP_),cljs.core.str("["),cljs.core.str(p2__34389_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__34390_SHARP_,p2__34391_SHARP_){
return [cljs.core.str(p1__34390_SHARP_),cljs.core.str("-"),cljs.core.str(p2__34391_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field34392 = (function sablono$core$color_field34392(){
var args34393 = [];
var len__19567__auto___34460 = arguments.length;
var i__19568__auto___34461 = (0);
while(true){
if((i__19568__auto___34461 < len__19567__auto___34460)){
args34393.push((arguments[i__19568__auto___34461]));

var G__34462 = (i__19568__auto___34461 + (1));
i__19568__auto___34461 = G__34462;
continue;
} else {
}
break;
}

var G__34395 = args34393.length;
switch (G__34395) {
case 1:
return sablono.core.color_field34392.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field34392.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34393.length)].join('')));

}
});

sablono.core.color_field34392.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.color_field34392.call(null,name__27337__auto__,null);
});

sablono.core.color_field34392.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.color_field34392.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field34392);

/**
 * Creates a date input field.
 */
sablono.core.date_field34396 = (function sablono$core$date_field34396(){
var args34397 = [];
var len__19567__auto___34464 = arguments.length;
var i__19568__auto___34465 = (0);
while(true){
if((i__19568__auto___34465 < len__19567__auto___34464)){
args34397.push((arguments[i__19568__auto___34465]));

var G__34466 = (i__19568__auto___34465 + (1));
i__19568__auto___34465 = G__34466;
continue;
} else {
}
break;
}

var G__34399 = args34397.length;
switch (G__34399) {
case 1:
return sablono.core.date_field34396.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field34396.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34397.length)].join('')));

}
});

sablono.core.date_field34396.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.date_field34396.call(null,name__27337__auto__,null);
});

sablono.core.date_field34396.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.date_field34396.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field34396);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field34400 = (function sablono$core$datetime_field34400(){
var args34401 = [];
var len__19567__auto___34468 = arguments.length;
var i__19568__auto___34469 = (0);
while(true){
if((i__19568__auto___34469 < len__19567__auto___34468)){
args34401.push((arguments[i__19568__auto___34469]));

var G__34470 = (i__19568__auto___34469 + (1));
i__19568__auto___34469 = G__34470;
continue;
} else {
}
break;
}

var G__34403 = args34401.length;
switch (G__34403) {
case 1:
return sablono.core.datetime_field34400.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field34400.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34401.length)].join('')));

}
});

sablono.core.datetime_field34400.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.datetime_field34400.call(null,name__27337__auto__,null);
});

sablono.core.datetime_field34400.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.datetime_field34400.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field34400);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field34404 = (function sablono$core$datetime_local_field34404(){
var args34405 = [];
var len__19567__auto___34472 = arguments.length;
var i__19568__auto___34473 = (0);
while(true){
if((i__19568__auto___34473 < len__19567__auto___34472)){
args34405.push((arguments[i__19568__auto___34473]));

var G__34474 = (i__19568__auto___34473 + (1));
i__19568__auto___34473 = G__34474;
continue;
} else {
}
break;
}

var G__34407 = args34405.length;
switch (G__34407) {
case 1:
return sablono.core.datetime_local_field34404.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field34404.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34405.length)].join('')));

}
});

sablono.core.datetime_local_field34404.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.datetime_local_field34404.call(null,name__27337__auto__,null);
});

sablono.core.datetime_local_field34404.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.datetime_local_field34404.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field34404);

/**
 * Creates a email input field.
 */
sablono.core.email_field34408 = (function sablono$core$email_field34408(){
var args34409 = [];
var len__19567__auto___34476 = arguments.length;
var i__19568__auto___34477 = (0);
while(true){
if((i__19568__auto___34477 < len__19567__auto___34476)){
args34409.push((arguments[i__19568__auto___34477]));

var G__34478 = (i__19568__auto___34477 + (1));
i__19568__auto___34477 = G__34478;
continue;
} else {
}
break;
}

var G__34411 = args34409.length;
switch (G__34411) {
case 1:
return sablono.core.email_field34408.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field34408.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34409.length)].join('')));

}
});

sablono.core.email_field34408.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.email_field34408.call(null,name__27337__auto__,null);
});

sablono.core.email_field34408.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.email_field34408.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field34408);

/**
 * Creates a file input field.
 */
sablono.core.file_field34412 = (function sablono$core$file_field34412(){
var args34413 = [];
var len__19567__auto___34480 = arguments.length;
var i__19568__auto___34481 = (0);
while(true){
if((i__19568__auto___34481 < len__19567__auto___34480)){
args34413.push((arguments[i__19568__auto___34481]));

var G__34482 = (i__19568__auto___34481 + (1));
i__19568__auto___34481 = G__34482;
continue;
} else {
}
break;
}

var G__34415 = args34413.length;
switch (G__34415) {
case 1:
return sablono.core.file_field34412.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field34412.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34413.length)].join('')));

}
});

sablono.core.file_field34412.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.file_field34412.call(null,name__27337__auto__,null);
});

sablono.core.file_field34412.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.file_field34412.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field34412);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field34416 = (function sablono$core$hidden_field34416(){
var args34417 = [];
var len__19567__auto___34484 = arguments.length;
var i__19568__auto___34485 = (0);
while(true){
if((i__19568__auto___34485 < len__19567__auto___34484)){
args34417.push((arguments[i__19568__auto___34485]));

var G__34486 = (i__19568__auto___34485 + (1));
i__19568__auto___34485 = G__34486;
continue;
} else {
}
break;
}

var G__34419 = args34417.length;
switch (G__34419) {
case 1:
return sablono.core.hidden_field34416.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field34416.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34417.length)].join('')));

}
});

sablono.core.hidden_field34416.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.hidden_field34416.call(null,name__27337__auto__,null);
});

sablono.core.hidden_field34416.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.hidden_field34416.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field34416);

/**
 * Creates a month input field.
 */
sablono.core.month_field34420 = (function sablono$core$month_field34420(){
var args34421 = [];
var len__19567__auto___34488 = arguments.length;
var i__19568__auto___34489 = (0);
while(true){
if((i__19568__auto___34489 < len__19567__auto___34488)){
args34421.push((arguments[i__19568__auto___34489]));

var G__34490 = (i__19568__auto___34489 + (1));
i__19568__auto___34489 = G__34490;
continue;
} else {
}
break;
}

var G__34423 = args34421.length;
switch (G__34423) {
case 1:
return sablono.core.month_field34420.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field34420.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34421.length)].join('')));

}
});

sablono.core.month_field34420.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.month_field34420.call(null,name__27337__auto__,null);
});

sablono.core.month_field34420.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.month_field34420.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field34420);

/**
 * Creates a number input field.
 */
sablono.core.number_field34424 = (function sablono$core$number_field34424(){
var args34425 = [];
var len__19567__auto___34492 = arguments.length;
var i__19568__auto___34493 = (0);
while(true){
if((i__19568__auto___34493 < len__19567__auto___34492)){
args34425.push((arguments[i__19568__auto___34493]));

var G__34494 = (i__19568__auto___34493 + (1));
i__19568__auto___34493 = G__34494;
continue;
} else {
}
break;
}

var G__34427 = args34425.length;
switch (G__34427) {
case 1:
return sablono.core.number_field34424.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field34424.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34425.length)].join('')));

}
});

sablono.core.number_field34424.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.number_field34424.call(null,name__27337__auto__,null);
});

sablono.core.number_field34424.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.number_field34424.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field34424);

/**
 * Creates a password input field.
 */
sablono.core.password_field34428 = (function sablono$core$password_field34428(){
var args34429 = [];
var len__19567__auto___34496 = arguments.length;
var i__19568__auto___34497 = (0);
while(true){
if((i__19568__auto___34497 < len__19567__auto___34496)){
args34429.push((arguments[i__19568__auto___34497]));

var G__34498 = (i__19568__auto___34497 + (1));
i__19568__auto___34497 = G__34498;
continue;
} else {
}
break;
}

var G__34431 = args34429.length;
switch (G__34431) {
case 1:
return sablono.core.password_field34428.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field34428.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34429.length)].join('')));

}
});

sablono.core.password_field34428.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.password_field34428.call(null,name__27337__auto__,null);
});

sablono.core.password_field34428.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.password_field34428.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field34428);

/**
 * Creates a range input field.
 */
sablono.core.range_field34432 = (function sablono$core$range_field34432(){
var args34433 = [];
var len__19567__auto___34500 = arguments.length;
var i__19568__auto___34501 = (0);
while(true){
if((i__19568__auto___34501 < len__19567__auto___34500)){
args34433.push((arguments[i__19568__auto___34501]));

var G__34502 = (i__19568__auto___34501 + (1));
i__19568__auto___34501 = G__34502;
continue;
} else {
}
break;
}

var G__34435 = args34433.length;
switch (G__34435) {
case 1:
return sablono.core.range_field34432.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field34432.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34433.length)].join('')));

}
});

sablono.core.range_field34432.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.range_field34432.call(null,name__27337__auto__,null);
});

sablono.core.range_field34432.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.range_field34432.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field34432);

/**
 * Creates a search input field.
 */
sablono.core.search_field34436 = (function sablono$core$search_field34436(){
var args34437 = [];
var len__19567__auto___34504 = arguments.length;
var i__19568__auto___34505 = (0);
while(true){
if((i__19568__auto___34505 < len__19567__auto___34504)){
args34437.push((arguments[i__19568__auto___34505]));

var G__34506 = (i__19568__auto___34505 + (1));
i__19568__auto___34505 = G__34506;
continue;
} else {
}
break;
}

var G__34439 = args34437.length;
switch (G__34439) {
case 1:
return sablono.core.search_field34436.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field34436.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34437.length)].join('')));

}
});

sablono.core.search_field34436.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.search_field34436.call(null,name__27337__auto__,null);
});

sablono.core.search_field34436.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.search_field34436.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field34436);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field34440 = (function sablono$core$tel_field34440(){
var args34441 = [];
var len__19567__auto___34508 = arguments.length;
var i__19568__auto___34509 = (0);
while(true){
if((i__19568__auto___34509 < len__19567__auto___34508)){
args34441.push((arguments[i__19568__auto___34509]));

var G__34510 = (i__19568__auto___34509 + (1));
i__19568__auto___34509 = G__34510;
continue;
} else {
}
break;
}

var G__34443 = args34441.length;
switch (G__34443) {
case 1:
return sablono.core.tel_field34440.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field34440.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34441.length)].join('')));

}
});

sablono.core.tel_field34440.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.tel_field34440.call(null,name__27337__auto__,null);
});

sablono.core.tel_field34440.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.tel_field34440.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field34440);

/**
 * Creates a text input field.
 */
sablono.core.text_field34444 = (function sablono$core$text_field34444(){
var args34445 = [];
var len__19567__auto___34512 = arguments.length;
var i__19568__auto___34513 = (0);
while(true){
if((i__19568__auto___34513 < len__19567__auto___34512)){
args34445.push((arguments[i__19568__auto___34513]));

var G__34514 = (i__19568__auto___34513 + (1));
i__19568__auto___34513 = G__34514;
continue;
} else {
}
break;
}

var G__34447 = args34445.length;
switch (G__34447) {
case 1:
return sablono.core.text_field34444.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field34444.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34445.length)].join('')));

}
});

sablono.core.text_field34444.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.text_field34444.call(null,name__27337__auto__,null);
});

sablono.core.text_field34444.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.text_field34444.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field34444);

/**
 * Creates a time input field.
 */
sablono.core.time_field34448 = (function sablono$core$time_field34448(){
var args34449 = [];
var len__19567__auto___34516 = arguments.length;
var i__19568__auto___34517 = (0);
while(true){
if((i__19568__auto___34517 < len__19567__auto___34516)){
args34449.push((arguments[i__19568__auto___34517]));

var G__34518 = (i__19568__auto___34517 + (1));
i__19568__auto___34517 = G__34518;
continue;
} else {
}
break;
}

var G__34451 = args34449.length;
switch (G__34451) {
case 1:
return sablono.core.time_field34448.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field34448.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34449.length)].join('')));

}
});

sablono.core.time_field34448.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.time_field34448.call(null,name__27337__auto__,null);
});

sablono.core.time_field34448.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.time_field34448.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field34448);

/**
 * Creates a url input field.
 */
sablono.core.url_field34452 = (function sablono$core$url_field34452(){
var args34453 = [];
var len__19567__auto___34520 = arguments.length;
var i__19568__auto___34521 = (0);
while(true){
if((i__19568__auto___34521 < len__19567__auto___34520)){
args34453.push((arguments[i__19568__auto___34521]));

var G__34522 = (i__19568__auto___34521 + (1));
i__19568__auto___34521 = G__34522;
continue;
} else {
}
break;
}

var G__34455 = args34453.length;
switch (G__34455) {
case 1:
return sablono.core.url_field34452.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field34452.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34453.length)].join('')));

}
});

sablono.core.url_field34452.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.url_field34452.call(null,name__27337__auto__,null);
});

sablono.core.url_field34452.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.url_field34452.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field34452);

/**
 * Creates a week input field.
 */
sablono.core.week_field34456 = (function sablono$core$week_field34456(){
var args34457 = [];
var len__19567__auto___34524 = arguments.length;
var i__19568__auto___34525 = (0);
while(true){
if((i__19568__auto___34525 < len__19567__auto___34524)){
args34457.push((arguments[i__19568__auto___34525]));

var G__34526 = (i__19568__auto___34525 + (1));
i__19568__auto___34525 = G__34526;
continue;
} else {
}
break;
}

var G__34459 = args34457.length;
switch (G__34459) {
case 1:
return sablono.core.week_field34456.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field34456.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34457.length)].join('')));

}
});

sablono.core.week_field34456.cljs$core$IFn$_invoke$arity$1 = (function (name__27337__auto__){
return sablono.core.week_field34456.call(null,name__27337__auto__,null);
});

sablono.core.week_field34456.cljs$core$IFn$_invoke$arity$2 = (function (name__27337__auto__,value__27338__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__27337__auto__,value__27338__auto__);
});

sablono.core.week_field34456.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field34456);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box34528 = (function sablono$core$check_box34528(){
var args34529 = [];
var len__19567__auto___34532 = arguments.length;
var i__19568__auto___34533 = (0);
while(true){
if((i__19568__auto___34533 < len__19567__auto___34532)){
args34529.push((arguments[i__19568__auto___34533]));

var G__34534 = (i__19568__auto___34533 + (1));
i__19568__auto___34533 = G__34534;
continue;
} else {
}
break;
}

var G__34531 = args34529.length;
switch (G__34531) {
case 1:
return sablono.core.check_box34528.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box34528.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box34528.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34529.length)].join('')));

}
});

sablono.core.check_box34528.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box34528.call(null,name,null);
});

sablono.core.check_box34528.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box34528.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box34528.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box34528.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box34528);
/**
 * Creates a radio button.
 */
sablono.core.radio_button34536 = (function sablono$core$radio_button34536(){
var args34537 = [];
var len__19567__auto___34540 = arguments.length;
var i__19568__auto___34541 = (0);
while(true){
if((i__19568__auto___34541 < len__19567__auto___34540)){
args34537.push((arguments[i__19568__auto___34541]));

var G__34542 = (i__19568__auto___34541 + (1));
i__19568__auto___34541 = G__34542;
continue;
} else {
}
break;
}

var G__34539 = args34537.length;
switch (G__34539) {
case 1:
return sablono.core.radio_button34536.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button34536.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button34536.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34537.length)].join('')));

}
});

sablono.core.radio_button34536.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button34536.call(null,group,null);
});

sablono.core.radio_button34536.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button34536.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button34536.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button34536.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button34536);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options34544 = (function sablono$core$select_options34544(){
var args34545 = [];
var len__19567__auto___34556 = arguments.length;
var i__19568__auto___34557 = (0);
while(true){
if((i__19568__auto___34557 < len__19567__auto___34556)){
args34545.push((arguments[i__19568__auto___34557]));

var G__34558 = (i__19568__auto___34557 + (1));
i__19568__auto___34557 = G__34558;
continue;
} else {
}
break;
}

var G__34547 = args34545.length;
switch (G__34547) {
case 1:
return sablono.core.select_options34544.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options34544.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34545.length)].join('')));

}
});

sablono.core.select_options34544.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options34544.call(null,coll,null);
});

sablono.core.select_options34544.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__19281__auto__ = (function sablono$core$iter__34548(s__34549){
return (new cljs.core.LazySeq(null,(function (){
var s__34549__$1 = s__34549;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__34549__$1);
if(temp__4425__auto__){
var s__34549__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__34549__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__34549__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__34551 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__34550 = (0);
while(true){
if((i__34550 < size__19280__auto__)){
var x = cljs.core._nth.call(null,c__19279__auto__,i__34550);
cljs.core.chunk_append.call(null,b__34551,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__34554 = x;
var text = cljs.core.nth.call(null,vec__34554,(0),null);
var val = cljs.core.nth.call(null,vec__34554,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__34554,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options34544.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__34560 = (i__34550 + (1));
i__34550 = G__34560;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34551),sablono$core$iter__34548.call(null,cljs.core.chunk_rest.call(null,s__34549__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34551),null);
}
} else {
var x = cljs.core.first.call(null,s__34549__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__34555 = x;
var text = cljs.core.nth.call(null,vec__34555,(0),null);
var val = cljs.core.nth.call(null,vec__34555,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__34555,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options34544.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__34548.call(null,cljs.core.rest.call(null,s__34549__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19281__auto__.call(null,coll);
});

sablono.core.select_options34544.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options34544);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down34561 = (function sablono$core$drop_down34561(){
var args34562 = [];
var len__19567__auto___34565 = arguments.length;
var i__19568__auto___34566 = (0);
while(true){
if((i__19568__auto___34566 < len__19567__auto___34565)){
args34562.push((arguments[i__19568__auto___34566]));

var G__34567 = (i__19568__auto___34566 + (1));
i__19568__auto___34566 = G__34567;
continue;
} else {
}
break;
}

var G__34564 = args34562.length;
switch (G__34564) {
case 2:
return sablono.core.drop_down34561.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down34561.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34562.length)].join('')));

}
});

sablono.core.drop_down34561.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down34561.call(null,name,options,null);
});

sablono.core.drop_down34561.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down34561.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down34561);
/**
 * Creates a text area element.
 */
sablono.core.text_area34569 = (function sablono$core$text_area34569(){
var args34570 = [];
var len__19567__auto___34573 = arguments.length;
var i__19568__auto___34574 = (0);
while(true){
if((i__19568__auto___34574 < len__19567__auto___34573)){
args34570.push((arguments[i__19568__auto___34574]));

var G__34575 = (i__19568__auto___34574 + (1));
i__19568__auto___34574 = G__34575;
continue;
} else {
}
break;
}

var G__34572 = args34570.length;
switch (G__34572) {
case 1:
return sablono.core.text_area34569.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area34569.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34570.length)].join('')));

}
});

sablono.core.text_area34569.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area34569.call(null,name,null);
});

sablono.core.text_area34569.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area34569.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area34569);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label34577 = (function sablono$core$label34577(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label34577);
/**
 * Creates a submit button.
 */
sablono.core.submit_button34578 = (function sablono$core$submit_button34578(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button34578);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button34579 = (function sablono$core$reset_button34579(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button34579);
/**
 * Create a form that points to a particular method and route.
 * e.g. (form-to [:put "/post"]
 * ...)
 */
sablono.core.form_to34580 = (function sablono$core$form_to34580(){
var args__19574__auto__ = [];
var len__19567__auto___34585 = arguments.length;
var i__19568__auto___34586 = (0);
while(true){
if((i__19568__auto___34586 < len__19567__auto___34585)){
args__19574__auto__.push((arguments[i__19568__auto___34586]));

var G__34587 = (i__19568__auto___34586 + (1));
i__19568__auto___34586 = G__34587;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return sablono.core.form_to34580.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

sablono.core.form_to34580.cljs$core$IFn$_invoke$arity$variadic = (function (p__34583,body){
var vec__34584 = p__34583;
var method = cljs.core.nth.call(null,vec__34584,(0),null);
var action = cljs.core.nth.call(null,vec__34584,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to34580.cljs$lang$maxFixedArity = (1);

sablono.core.form_to34580.cljs$lang$applyTo = (function (seq34581){
var G__34582 = cljs.core.first.call(null,seq34581);
var seq34581__$1 = cljs.core.next.call(null,seq34581);
return sablono.core.form_to34580.cljs$core$IFn$_invoke$arity$variadic(G__34582,seq34581__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to34580);

//# sourceMappingURL=core.js.map