// Compiled by ClojureScript 1.7.48 {}
goog.provide('dragonmark.inputs.date_utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.i18n.DateTimeFormat');
goog.require('goog.i18n.DateTimeParse');
goog.require('goog.ui.InputDatePicker');
goog.require('goog.date.Date');
goog.require('goog.date.Interval');
dragonmark.inputs.date_utils.default_fmt = "yyyy/MM/dd";
dragonmark.inputs.date_utils.format_map = (function (){var f = goog.i18n.DateTimeFormat.Format;
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"SHORT_DATETIME","SHORT_DATETIME",1598374504),new cljs.core.Keyword(null,"SHORT_TIME","SHORT_TIME",310908809),new cljs.core.Keyword(null,"FULL_DATETIME","FULL_DATETIME",-994229334),new cljs.core.Keyword(null,"FULL_TIME","FULL_TIME",2079466571),new cljs.core.Keyword(null,"MEDIUM_TIME","MEDIUM_TIME",886226349),new cljs.core.Keyword(null,"MEDIUM_DATETIME","MEDIUM_DATETIME",1699528622),new cljs.core.Keyword(null,"FULL_DATE","FULL_DATE",-155294353),new cljs.core.Keyword(null,"LONG_DATETIME","LONG_DATETIME",-1477050189),new cljs.core.Keyword(null,"LONG_TIME","LONG_TIME",1656541459),new cljs.core.Keyword(null,"MEDIUM_DATE","MEDIUM_DATE",-2761993),new cljs.core.Keyword(null,"LONG_DATE","LONG_DATE",-30104067),new cljs.core.Keyword(null,"SHORT_DATE","SHORT_DATE",1620789053)],[f.SHORT_DATETIME,f.SHORT_TIME,f.FULL_DATETIME,f.FULL_TIME,f.MEDIUM_TIME,f.MEDIUM_DATETIME,f.FULL_DATE,f.LONG_DATETIME,f.LONG_TIME,f.MEDIUM_DATE,f.LONG_DATE,f.SHORT_DATE]);
})();
/**
 * Format a date using either the built-in goog.i18n.DateTimeFormat.Format enum
 * or a formatting string like "dd MMMM yyyy"
 */
dragonmark.inputs.date_utils.fmt = (function dragonmark$inputs$date_utils$fmt(){
var args22298 = [];
var len__19528__auto___22301 = arguments.length;
var i__19529__auto___22302 = (0);
while(true){
if((i__19529__auto___22302 < len__19528__auto___22301)){
args22298.push((arguments[i__19529__auto___22302]));

var G__22303 = (i__19529__auto___22302 + (1));
i__19529__auto___22302 = G__22303;
continue;
} else {
}
break;
}

var G__22300 = args22298.length;
switch (G__22300) {
case 1:
return dragonmark.inputs.date_utils.fmt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dragonmark.inputs.date_utils.fmt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22298.length)].join('')));

}
});

dragonmark.inputs.date_utils.fmt.cljs$core$IFn$_invoke$arity$1 = (function (date){
return dragonmark.inputs.date_utils.fmt.call(null,dragonmark.inputs.date_utils.default_fmt,date);
});

dragonmark.inputs.date_utils.fmt.cljs$core$IFn$_invoke$arity$2 = (function (date_format,date){
return (new goog.i18n.DateTimeFormat((function (){var or__18489__auto__ = dragonmark.inputs.date_utils.format_map.call(null,date_format);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return date_format;
}
})())).format((new Date(date)));
});

dragonmark.inputs.date_utils.fmt.cljs$lang$maxFixedArity = 2;
/**
 * Parse a Date according to the format specified
 * Default format is dd/MM/yyyy
 */
dragonmark.inputs.date_utils.parse = (function dragonmark$inputs$date_utils$parse(){
var args22305 = [];
var len__19528__auto___22308 = arguments.length;
var i__19529__auto___22309 = (0);
while(true){
if((i__19529__auto___22309 < len__19528__auto___22308)){
args22305.push((arguments[i__19529__auto___22309]));

var G__22310 = (i__19529__auto___22309 + (1));
i__19529__auto___22309 = G__22310;
continue;
} else {
}
break;
}

var G__22307 = args22305.length;
switch (G__22307) {
case 2:
return dragonmark.inputs.date_utils.parse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dragonmark.inputs.date_utils.parse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22305.length)].join('')));

}
});

dragonmark.inputs.date_utils.parse.cljs$core$IFn$_invoke$arity$2 = (function (f,s){
var p = (new goog.i18n.DateTimeParse(f));
var d = (new Date());
p.strictParse(s,d);

return d;
});

dragonmark.inputs.date_utils.parse.cljs$core$IFn$_invoke$arity$1 = (function (s){
return dragonmark.inputs.date_utils.parse.call(null,dragonmark.inputs.date_utils.default_fmt,s);
});

dragonmark.inputs.date_utils.parse.cljs$lang$maxFixedArity = 2;
/**
 * Takes care of date rendering in the input.
 */
dragonmark.inputs.date_utils.display_date = (function dragonmark$inputs$date_utils$display_date(){
var args22312 = [];
var len__19528__auto___22315 = arguments.length;
var i__19529__auto___22316 = (0);
while(true){
if((i__19529__auto___22316 < len__19528__auto___22315)){
args22312.push((arguments[i__19529__auto___22316]));

var G__22317 = (i__19529__auto___22316 + (1));
i__19529__auto___22316 = G__22317;
continue;
} else {
}
break;
}

var G__22314 = args22312.length;
switch (G__22314) {
case 2:
return dragonmark.inputs.date_utils.display_date.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dragonmark.inputs.date_utils.display_date.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22312.length)].join('')));

}
});

dragonmark.inputs.date_utils.display_date.cljs$core$IFn$_invoke$arity$2 = (function (f,v){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,v))){
return null;
} else {
return dragonmark.inputs.date_utils.fmt.call(null,f,v);
}
});

dragonmark.inputs.date_utils.display_date.cljs$core$IFn$_invoke$arity$1 = (function (v){
return dragonmark.inputs.date_utils.display_date.call(null,dragonmark.inputs.date_utils.default_fmt,v);
});

dragonmark.inputs.date_utils.display_date.cljs$lang$maxFixedArity = 2;
dragonmark.inputs.date_utils.goog_date__GT_js_date = (function dragonmark$inputs$date_utils$goog_date__GT_js_date(d){
if(cljs.core.truth_(d)){
return dragonmark.inputs.date_utils.parse.call(null,dragonmark.inputs.date_utils.fmt.call(null,dragonmark.inputs.date_utils.default_fmt,d));
} else {
return null;
}
});

dragonmark.inputs.date_utils.SetDate = {};

dragonmark.inputs.date_utils.setInputValue = (function dragonmark$inputs$date_utils$setInputValue(this$,v){
if((!((this$ == null))) && (!((this$.dragonmark$inputs$date_utils$SetDate$setInputValue$arity$2 == null)))){
return this$.dragonmark$inputs$date_utils$SetDate$setInputValue$arity$2(this$,v);
} else {
var x__19125__auto__ = (((this$ == null))?null:this$);
var m__19126__auto__ = (dragonmark.inputs.date_utils.setInputValue[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,this$,v);
} else {
var m__19126__auto____$1 = (dragonmark.inputs.date_utils.setInputValue["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,this$,v);
} else {
throw cljs.core.missing_protocol.call(null,"SetDate.setInputValue",this$);
}
}
}
});

/**
 * Build a google.ui.InputDatePicker with a specific format
 */
dragonmark.inputs.date_utils.date_picker = (function dragonmark$inputs$date_utils$date_picker(f){
var ret = (new goog.ui.InputDatePicker((new goog.i18n.DateTimeFormat(f)),(new goog.i18n.DateTimeParse(f)),null,null));
return ret;
});
/**
 * Create a js/Date at plus/minus days
 */
dragonmark.inputs.date_utils.at = (function dragonmark$inputs$date_utils$at(d){
return dragonmark.inputs.date_utils.goog_date__GT_js_date.call(null,(function (){var G__22322 = (new goog.date.Date());
G__22322.add((new goog.date.Interval(goog.date.Interval.DAYS,d)));

return G__22322;
})());
});
dragonmark.inputs.date_utils.tomorrow = (function dragonmark$inputs$date_utils$tomorrow(){
return dragonmark.inputs.date_utils.at.call(null,(1));
});

//# sourceMappingURL=date_utils.js.map