// Compiled by ClojureScript 1.7.48 {}
goog.provide('dragonmark.inputs.validation');
goog.require('cljs.core');
goog.require('dragonmark.inputs.schemas');
goog.require('schema.core');
goog.require('dragonmark.inputs.date_utils');
goog.require('jkkramer.verily');
goog.require('schema.coerce');
goog.require('clojure.set');
goog.require('dragonmark.inputs.extern');
goog.require('clojure.string');
/**
 * The validation error message keys for a field.
 * The key is not the rule key but the message key.
 */
dragonmark.inputs.validation.sch_errors_list = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.named.call(null,schema.core.Keyword,"message")], null);
/**
 * Describes the input's error data structure.
 * A field can have multiples errors.
 */
dragonmark.inputs.validation.sch_errors = new cljs.core.PersistentArrayMap.fromArray([dragonmark.inputs.schemas.sch_field,dragonmark.inputs.validation.sch_errors_list], true, false);
/**
 * Describes the Verily errors data structure.
 */
dragonmark.inputs.validation.sch_verily_errs = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dragonmark.inputs.schemas.sch_field], null),new cljs.core.Keyword(null,"msg","msg",-1386103444),schema.core.Keyword], null)], null);
/**
 * Describes the Schema errors data structure
 */
dragonmark.inputs.validation.sch_schema_errs = new cljs.core.PersistentArrayMap.fromArray([dragonmark.inputs.schemas.sch_field,schema.core.Any], true, false);
/**
 * Do not validate an empty string as a valid s/Str
 */
dragonmark.inputs.validation.empty_string_coercer = (function dragonmark$inputs$validation$empty_string_coercer(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return s;
}
});
/**
 * Coerce an input string to a date.
 * The default format is used.
 * A blank string is coerced to nil.
 */
dragonmark.inputs.validation.inst_coercer = (function dragonmark$inputs$validation$inst_coercer(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return dragonmark.inputs.date_utils.parse.call(null,dragonmark.inputs.date_utils.fmt.call(null,dragonmark.inputs.date_utils.default_fmt,s));
}
});
/**
 * Schema coercers used for inputs that are sent as string.
 */
dragonmark.inputs.validation.validation_coercer = new cljs.core.PersistentArrayMap.fromArray([schema.core.Num,schema.coerce.safe.call(null,schema.coerce.edn_read_string),schema.core.Regex,dragonmark.inputs.validation.empty_string_coercer,schema.core.Str,dragonmark.inputs.validation.empty_string_coercer,schema.core.maybe.call(null,schema.core.Str),dragonmark.inputs.validation.empty_string_coercer,schema.core.Inst,dragonmark.inputs.validation.inst_coercer], true, false);
/**
 * Generic sequence of validation.
 * The first args can be partially applied to generate a custom validator.
 */
dragonmark.inputs.validation.validate = (function dragonmark$inputs$validation$validate(validation_fn,post,m){
return post.call(null,validation_fn.call(null,m));
});
var ufv___55678 = schema.utils.use_fn_validation;
var output_schema55657_55679 = dragonmark.inputs.validation.sch_errors;
var input_schema55658_55680 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.validation.sch_schema_errs,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-schema-errs","sch-schema-errs",1633294259,null)], null)))], null);
var input_checker55659_55681 = schema.core.checker.call(null,input_schema55658_55680);
var output_checker55660_55682 = schema.core.checker.call(null,output_schema55657_55679);
/**
 * Inputs: [errs :- sch-schema-errs]
 * Returns: sch-errors
 * 
 * Transforms the Schema's error data structure into the common error data structure.
 * For the moment Schema error are treated as missing field.
 */
dragonmark.inputs.validation.transform_schema_errors = ((function (ufv___55678,output_schema55657_55679,input_schema55658_55680,input_checker55659_55681,output_checker55660_55682){
return (function dragonmark$inputs$validation$transform_schema_errors(G__55661){
var validate__21099__auto__ = ufv___55678.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55683 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55661], null);
var temp__4425__auto___55684 = input_checker55659_55681.call(null,args__21100__auto___55683);
if(cljs.core.truth_(temp__4425__auto___55684)){
var error__21101__auto___55685 = temp__4425__auto___55684;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-schema-errors","transform-schema-errors",1319365661,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Schema's error data structure into the common error data structure.\n  For the moment Schema error are treated as missing field."], null)),cljs.core.pr_str.call(null,error__21101__auto___55685)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55658_55680,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55683,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55685], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var errs = G__55661;
while(true){
var temp__4425__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(errs);
if(cljs.core.truth_(temp__4425__auto__)){
var errors = temp__4425__auto__;
return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.concat,(function (){var iter__19242__auto__ = ((function (errors,temp__4425__auto__,validate__21099__auto__,ufv___55678,output_schema55657_55679,input_schema55658_55680,input_checker55659_55681,output_checker55660_55682){
return (function dragonmark$inputs$validation$transform_schema_errors_$_iter__55670(s__55671){
return (new cljs.core.LazySeq(null,((function (errors,temp__4425__auto__,validate__21099__auto__,ufv___55678,output_schema55657_55679,input_schema55658_55680,input_checker55659_55681,output_checker55660_55682){
return (function (){
var s__55671__$1 = s__55671;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__55671__$1);
if(temp__4425__auto____$1){
var s__55671__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55671__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55671__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55673 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55672 = (0);
while(true){
if((i__55672 < size__19241__auto__)){
var vec__55676 = cljs.core._nth.call(null,c__19240__auto__,i__55672);
var k = cljs.core.nth.call(null,vec__55676,(0),null);
var _ = cljs.core.nth.call(null,vec__55676,(1),null);
cljs.core.chunk_append.call(null,b__55673,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mandatory","mandatory",542802336)], null)], true, false));

var G__55686 = (i__55672 + (1));
i__55672 = G__55686;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55673),dragonmark$inputs$validation$transform_schema_errors_$_iter__55670.call(null,cljs.core.chunk_rest.call(null,s__55671__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55673),null);
}
} else {
var vec__55677 = cljs.core.first.call(null,s__55671__$2);
var k = cljs.core.nth.call(null,vec__55677,(0),null);
var _ = cljs.core.nth.call(null,vec__55677,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mandatory","mandatory",542802336)], null)], true, false),dragonmark$inputs$validation$transform_schema_errors_$_iter__55670.call(null,cljs.core.rest.call(null,s__55671__$2)));
}
} else {
return null;
}
break;
}
});})(errors,temp__4425__auto__,validate__21099__auto__,ufv___55678,output_schema55657_55679,input_schema55658_55680,input_checker55659_55681,output_checker55660_55682))
,null,null));
});})(errors,temp__4425__auto__,validate__21099__auto__,ufv___55678,output_schema55657_55679,input_schema55658_55680,input_checker55659_55681,output_checker55660_55682))
;
return iter__19242__auto__.call(null,errors);
})());
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___55687 = output_checker55660_55682.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55687)){
var error__21101__auto___55688 = temp__4425__auto___55687;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-schema-errors","transform-schema-errors",1319365661,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Schema's error data structure into the common error data structure.\n  For the moment Schema error are treated as missing field."], null)),cljs.core.pr_str.call(null,error__21101__auto___55688)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55657_55679,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55688], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55678,output_schema55657_55679,input_schema55658_55680,input_checker55659_55681,output_checker55660_55682))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.transform_schema_errors),schema.core.make_fn_schema.call(null,output_schema55657_55679,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55658_55680], null)));
var ufv___55714 = schema.utils.use_fn_validation;
var output_schema55689_55715 = dragonmark.inputs.validation.sch_errors;
var input_schema55690_55716 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.validation.sch_verily_errs,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-verily-errs","sch-verily-errs",-1962614795,null)], null)))], null);
var input_checker55691_55717 = schema.core.checker.call(null,input_schema55690_55716);
var output_checker55692_55718 = schema.core.checker.call(null,output_schema55689_55715);
/**
 * Inputs: [errs :- sch-verily-errs]
 * Returns: sch-errors
 * 
 * Transforms the Verily's error data structure into the common error data structure.
 */
dragonmark.inputs.validation.transform_verily_errors = ((function (ufv___55714,output_schema55689_55715,input_schema55690_55716,input_checker55691_55717,output_checker55692_55718){
return (function dragonmark$inputs$validation$transform_verily_errors(G__55693){
var validate__21099__auto__ = ufv___55714.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55719 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55693], null);
var temp__4425__auto___55720 = input_checker55691_55717.call(null,args__21100__auto___55719);
if(cljs.core.truth_(temp__4425__auto___55720)){
var error__21101__auto___55721 = temp__4425__auto___55720;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-verily-errors","transform-verily-errors",-197737448,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Verily's error data structure into the common error data structure."], null)),cljs.core.pr_str.call(null,error__21101__auto___55721)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55690_55716,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55719,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55721], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var errs = G__55693;
while(true){
if(cljs.core.seq.call(null,errs)){
return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.concat,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21099__auto__,ufv___55714,output_schema55689_55715,input_schema55690_55716,input_checker55691_55717,output_checker55692_55718){
return (function dragonmark$inputs$validation$transform_verily_errors_$_iter__55704(s__55705){
return (new cljs.core.LazySeq(null,((function (validate__21099__auto__,ufv___55714,output_schema55689_55715,input_schema55690_55716,input_checker55691_55717,output_checker55692_55718){
return (function (){
var s__55705__$1 = s__55705;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55705__$1);
if(temp__4425__auto__){
var xs__4977__auto__ = temp__4425__auto__;
var map__55712 = cljs.core.first.call(null,xs__4977__auto__);
var map__55712__$1 = ((((!((map__55712 == null)))?((((map__55712.cljs$lang$protocol_mask$partition0$ & (64))) || (map__55712.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55712):map__55712);
var keys = cljs.core.get.call(null,map__55712__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var msg = cljs.core.get.call(null,map__55712__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var iterys__19238__auto__ = ((function (s__55705__$1,map__55712,map__55712__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21099__auto__,ufv___55714,output_schema55689_55715,input_schema55690_55716,input_checker55691_55717,output_checker55692_55718){
return (function dragonmark$inputs$validation$transform_verily_errors_$_iter__55704_$_iter__55706(s__55707){
return (new cljs.core.LazySeq(null,((function (s__55705__$1,map__55712,map__55712__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21099__auto__,ufv___55714,output_schema55689_55715,input_schema55690_55716,input_checker55691_55717,output_checker55692_55718){
return (function (){
var s__55707__$1 = s__55707;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__55707__$1);
if(temp__4425__auto____$1){
var s__55707__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55707__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55707__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55709 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55708 = (0);
while(true){
if((i__55708 < size__19241__auto__)){
var k = cljs.core._nth.call(null,c__19240__auto__,i__55708);
cljs.core.chunk_append.call(null,b__55709,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null)], true, false));

var G__55722 = (i__55708 + (1));
i__55708 = G__55722;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55709),dragonmark$inputs$validation$transform_verily_errors_$_iter__55704_$_iter__55706.call(null,cljs.core.chunk_rest.call(null,s__55707__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55709),null);
}
} else {
var k = cljs.core.first.call(null,s__55707__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null)], true, false),dragonmark$inputs$validation$transform_verily_errors_$_iter__55704_$_iter__55706.call(null,cljs.core.rest.call(null,s__55707__$2)));
}
} else {
return null;
}
break;
}
});})(s__55705__$1,map__55712,map__55712__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21099__auto__,ufv___55714,output_schema55689_55715,input_schema55690_55716,input_checker55691_55717,output_checker55692_55718))
,null,null));
});})(s__55705__$1,map__55712,map__55712__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21099__auto__,ufv___55714,output_schema55689_55715,input_schema55690_55716,input_checker55691_55717,output_checker55692_55718))
;
var fs__19239__auto__ = cljs.core.seq.call(null,iterys__19238__auto__.call(null,keys));
if(fs__19239__auto__){
return cljs.core.concat.call(null,fs__19239__auto__,dragonmark$inputs$validation$transform_verily_errors_$_iter__55704.call(null,cljs.core.rest.call(null,s__55705__$1)));
} else {
var G__55723 = cljs.core.rest.call(null,s__55705__$1);
s__55705__$1 = G__55723;
continue;
}
} else {
return null;
}
break;
}
});})(validate__21099__auto__,ufv___55714,output_schema55689_55715,input_schema55690_55716,input_checker55691_55717,output_checker55692_55718))
,null,null));
});})(validate__21099__auto__,ufv___55714,output_schema55689_55715,input_schema55690_55716,input_checker55691_55717,output_checker55692_55718))
;
return iter__19242__auto__.call(null,errs);
})());
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___55724 = output_checker55692_55718.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55724)){
var error__21101__auto___55725 = temp__4425__auto___55724;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-verily-errors","transform-verily-errors",-197737448,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Verily's error data structure into the common error data structure."], null)),cljs.core.pr_str.call(null,error__21101__auto___55725)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55689_55715,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55725], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55714,output_schema55689_55715,input_schema55690_55716,input_checker55691_55717,output_checker55692_55718))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.transform_verily_errors),schema.core.make_fn_schema.call(null,output_schema55689_55715,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55690_55716], null)));
dragonmark.inputs.validation.build_verily_validator = (function dragonmark$inputs$validation$build_verily_validator(rules){
return cljs.core.partial.call(null,dragonmark.inputs.validation.validate,jkkramer.verily.validations__GT_fn.call(null,rules),dragonmark.inputs.validation.transform_verily_errors);
});
dragonmark.inputs.validation.inter_fields_rules = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"lower-or-equal","lower-or-equal",-1150663190),null,new cljs.core.Keyword(null,"greater-or-equal","greater-or-equal",302221395),null,new cljs.core.Keyword(null,"lower","lower",1120320821),null,new cljs.core.Keyword(null,"greater","greater",1370260601),null,new cljs.core.Keyword(null,"equal","equal",-1921681350),null], null), null);
/**
 * Build the map error->rule
 */
dragonmark.inputs.validation.error__GT_rule = (function dragonmark$inputs$validation$error__GT_rule(rules){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = (function dragonmark$inputs$validation$error__GT_rule_$_iter__55730(s__55731){
return (new cljs.core.LazySeq(null,(function (){
var s__55731__$1 = s__55731;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55731__$1);
if(temp__4425__auto__){
var s__55731__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55731__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55731__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55733 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55732 = (0);
while(true){
if((i__55732 < size__19241__auto__)){
var r = cljs.core._nth.call(null,c__19240__auto__,i__55732);
cljs.core.chunk_append.call(null,b__55733,cljs.core.juxt.call(null,cljs.core.last,cljs.core.first).call(null,r));

var G__55734 = (i__55732 + (1));
i__55732 = G__55734;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55733),dragonmark$inputs$validation$error__GT_rule_$_iter__55730.call(null,cljs.core.chunk_rest.call(null,s__55731__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55733),null);
}
} else {
var r = cljs.core.first.call(null,s__55731__$2);
return cljs.core.cons.call(null,cljs.core.juxt.call(null,cljs.core.last,cljs.core.first).call(null,r),dragonmark$inputs$validation$error__GT_rule_$_iter__55730.call(null,cljs.core.rest.call(null,s__55731__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,rules);
})());
});
/**
 * Determines validation dependencies between fields
 */
dragonmark.inputs.validation.fields_dependencies = (function dragonmark$inputs$validation$fields_dependencies(){
var args55735 = [];
var len__19528__auto___55750 = arguments.length;
var i__19529__auto___55751 = (0);
while(true){
if((i__19529__auto___55751 < len__19528__auto___55750)){
args55735.push((arguments[i__19529__auto___55751]));

var G__55752 = (i__19529__auto___55751 + (1));
i__19529__auto___55751 = G__55752;
continue;
} else {
}
break;
}

var G__55737 = args55735.length;
switch (G__55737) {
case 1:
return dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55735.length)].join('')));

}
});

dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$1 = (function (rules){
return dragonmark.inputs.validation.fields_dependencies.call(null,dragonmark.inputs.validation.inter_fields_rules,rules);
});

dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$2 = (function (rule_keys,rules){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = (function dragonmark$inputs$validation$iter__55738(s__55739){
return (new cljs.core.LazySeq(null,(function (){
var s__55739__$1 = s__55739;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55739__$1);
if(temp__4425__auto__){
var s__55739__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55739__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55739__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55741 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55740 = (0);
while(true){
if((i__55740 < size__19241__auto__)){
var vec__55746 = cljs.core._nth.call(null,c__19240__auto__,i__55740);
var r = cljs.core.nth.call(null,vec__55746,(0),null);
var fs = cljs.core.nth.call(null,vec__55746,(1),null);
var m = cljs.core.nth.call(null,vec__55746,(2),null);
if(cljs.core.truth_(rule_keys.call(null,r))){
var vec__55747 = fs;
var f = cljs.core.nth.call(null,vec__55747,(0),null);
var deps = cljs.core.nthnext.call(null,vec__55747,(1));
cljs.core.chunk_append.call(null,b__55741,new cljs.core.PersistentArrayMap.fromArray([f,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"deps","deps",1883360319),deps,new cljs.core.Keyword(null,"mess","mess",530922968),m,new cljs.core.Keyword(null,"rule","rule",729973257),r], null)], true, false));

var G__55754 = (i__55740 + (1));
i__55740 = G__55754;
continue;
} else {
var G__55755 = (i__55740 + (1));
i__55740 = G__55755;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55741),dragonmark$inputs$validation$iter__55738.call(null,cljs.core.chunk_rest.call(null,s__55739__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55741),null);
}
} else {
var vec__55748 = cljs.core.first.call(null,s__55739__$2);
var r = cljs.core.nth.call(null,vec__55748,(0),null);
var fs = cljs.core.nth.call(null,vec__55748,(1),null);
var m = cljs.core.nth.call(null,vec__55748,(2),null);
if(cljs.core.truth_(rule_keys.call(null,r))){
var vec__55749 = fs;
var f = cljs.core.nth.call(null,vec__55749,(0),null);
var deps = cljs.core.nthnext.call(null,vec__55749,(1));
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([f,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"deps","deps",1883360319),deps,new cljs.core.Keyword(null,"mess","mess",530922968),m,new cljs.core.Keyword(null,"rule","rule",729973257),r], null)], true, false),dragonmark$inputs$validation$iter__55738.call(null,cljs.core.rest.call(null,s__55739__$2)));
} else {
var G__55756 = cljs.core.rest.call(null,s__55739__$2);
s__55739__$1 = G__55756;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,rules);
})());
});

dragonmark.inputs.validation.fields_dependencies.cljs$lang$maxFixedArity = 2;
var ufv___55763 = schema.utils.use_fn_validation;
var output_schema55757_55764 = dragonmark.inputs.schemas.sch_business_state;
var input_schema55758_55765 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,dragonmark.inputs.validation.sch_errors,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null)], null)))], null);
var input_checker55759_55766 = schema.core.checker.call(null,input_schema55758_55765);
var output_checker55760_55767 = schema.core.checker.call(null,output_schema55757_55764);
/**
 * Inputs: [state :- sch-business-state errs :- sch-errors]
 * Returns: sch-business-state
 * 
 * Set valid to false for each key in errors, true if absent
 */
dragonmark.inputs.validation.handle_errors = ((function (ufv___55763,output_schema55757_55764,input_schema55758_55765,input_checker55759_55766,output_checker55760_55767){
return (function dragonmark$inputs$validation$handle_errors(G__55761,G__55762){
var validate__21099__auto__ = ufv___55763.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55768 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55761,G__55762], null);
var temp__4425__auto___55769 = input_checker55759_55766.call(null,args__21100__auto___55768);
if(cljs.core.truth_(temp__4425__auto___55769)){
var error__21101__auto___55770 = temp__4425__auto___55769;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"handle-errors","handle-errors",1833858829,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set valid to false for each key in errors, true if absent"], null)),cljs.core.pr_str.call(null,error__21101__auto___55770)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55758_55765,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55768,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55770], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var state = G__55761;
var errs = G__55762;
while(true){
var err_ks = cljs.core.set.call(null,cljs.core.keys.call(null,errs));
var all_ks = cljs.core.set.call(null,cljs.core.keys.call(null,state));
var valid_ks = clojure.set.difference.call(null,all_ks,err_ks);
var state__$1 = cljs.core.reduce.call(null,((function (err_ks,all_ks,valid_ks,validate__21099__auto__,ufv___55763,output_schema55757_55764,input_schema55758_55765,input_checker55759_55766,output_checker55760_55767){
return (function (s,e){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),false),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"error","error",-978969032)], null),e.call(null,errs));
});})(err_ks,all_ks,valid_ks,validate__21099__auto__,ufv___55763,output_schema55757_55764,input_schema55758_55765,input_checker55759_55766,output_checker55760_55767))
,state,err_ks);
return cljs.core.reduce.call(null,((function (err_ks,all_ks,valid_ks,state__$1,validate__21099__auto__,ufv___55763,output_schema55757_55764,input_schema55758_55765,input_checker55759_55766,output_checker55760_55767){
return (function (s,e){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [e], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
});})(err_ks,all_ks,valid_ks,state__$1,validate__21099__auto__,ufv___55763,output_schema55757_55764,input_schema55758_55765,input_checker55759_55766,output_checker55760_55767))
,state__$1,valid_ks);
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___55771 = output_checker55760_55767.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55771)){
var error__21101__auto___55772 = temp__4425__auto___55771;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"handle-errors","handle-errors",1833858829,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set valid to false for each key in errors, true if absent"], null)),cljs.core.pr_str.call(null,error__21101__auto___55772)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55757_55764,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55772], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55763,output_schema55757_55764,input_schema55758_55765,input_checker55759_55766,output_checker55760_55767))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.handle_errors),schema.core.make_fn_schema.call(null,output_schema55757_55764,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55758_55765], null)));
var ufv___55794 = schema.utils.use_fn_validation;
var output_schema55773_55795 = dragonmark.inputs.schemas.sch_business_state;
var input_schema55774_55796 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker55775_55797 = schema.core.checker.call(null,input_schema55774_55796);
var output_checker55776_55798 = schema.core.checker.call(null,output_schema55773_55795);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.keep_fields_to_validate = ((function (ufv___55794,output_schema55773_55795,input_schema55774_55796,input_checker55775_55797,output_checker55776_55798){
return (function dragonmark$inputs$validation$keep_fields_to_validate(G__55777){
var validate__21099__auto__ = ufv___55794.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55799 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55777], null);
var temp__4425__auto___55800 = input_checker55775_55797.call(null,args__21100__auto___55799);
if(cljs.core.truth_(temp__4425__auto___55800)){
var error__21101__auto___55801 = temp__4425__auto___55800;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"keep-fields-to-validate","keep-fields-to-validate",943659297,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21101__auto___55801)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55774_55796,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55799,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55801], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var bs = G__55777;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21099__auto__,ufv___55794,output_schema55773_55795,input_schema55774_55796,input_checker55775_55797,output_checker55776_55798){
return (function dragonmark$inputs$validation$keep_fields_to_validate_$_iter__55786(s__55787){
return (new cljs.core.LazySeq(null,((function (validate__21099__auto__,ufv___55794,output_schema55773_55795,input_schema55774_55796,input_checker55775_55797,output_checker55776_55798){
return (function (){
var s__55787__$1 = s__55787;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55787__$1);
if(temp__4425__auto__){
var s__55787__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55787__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55787__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55789 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55788 = (0);
while(true){
if((i__55788 < size__19241__auto__)){
var vec__55792 = cljs.core._nth.call(null,c__19240__auto__,i__55788);
var k = cljs.core.nth.call(null,vec__55792,(0),null);
var m = cljs.core.nth.call(null,vec__55792,(1),null);
var in$ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m);
var req = new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__18489__auto__ = req;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,in$));
}
})())){
cljs.core.chunk_append.call(null,b__55789,new cljs.core.PersistentArrayMap.fromArray([k,m], true, false));

var G__55802 = (i__55788 + (1));
i__55788 = G__55802;
continue;
} else {
var G__55803 = (i__55788 + (1));
i__55788 = G__55803;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55789),dragonmark$inputs$validation$keep_fields_to_validate_$_iter__55786.call(null,cljs.core.chunk_rest.call(null,s__55787__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55789),null);
}
} else {
var vec__55793 = cljs.core.first.call(null,s__55787__$2);
var k = cljs.core.nth.call(null,vec__55793,(0),null);
var m = cljs.core.nth.call(null,vec__55793,(1),null);
var in$ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m);
var req = new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__18489__auto__ = req;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,in$));
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,m], true, false),dragonmark$inputs$validation$keep_fields_to_validate_$_iter__55786.call(null,cljs.core.rest.call(null,s__55787__$2)));
} else {
var G__55804 = cljs.core.rest.call(null,s__55787__$2);
s__55787__$1 = G__55804;
continue;
}
}
} else {
return null;
}
break;
}
});})(validate__21099__auto__,ufv___55794,output_schema55773_55795,input_schema55774_55796,input_checker55775_55797,output_checker55776_55798))
,null,null));
});})(validate__21099__auto__,ufv___55794,output_schema55773_55795,input_schema55774_55796,input_checker55775_55797,output_checker55776_55798))
;
return iter__19242__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___55805 = output_checker55776_55798.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55805)){
var error__21101__auto___55806 = temp__4425__auto___55805;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"keep-fields-to-validate","keep-fields-to-validate",943659297,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21101__auto___55806)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55773_55795,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55806], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55794,output_schema55773_55795,input_schema55774_55796,input_checker55775_55797,output_checker55776_55798))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.keep_fields_to_validate),schema.core.make_fn_schema.call(null,output_schema55773_55795,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55774_55796], null)));
var ufv___55813 = schema.utils.use_fn_validation;
var output_schema55807_55814 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema55808_55815 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"fk","fk",2038974178,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker55809_55816 = schema.core.checker.call(null,input_schema55808_55815);
var output_checker55810_55817 = schema.core.checker.call(null,output_schema55807_55814);
/**
 * Inputs: [bs :- sch-business-state fk :- s/Keyword]
 * Returns: {s/Keyword s/Any}
 * 
 * Extract map fk->value for a single field.
 */
dragonmark.inputs.validation.bs__GT_unit_map = ((function (ufv___55813,output_schema55807_55814,input_schema55808_55815,input_checker55809_55816,output_checker55810_55817){
return (function dragonmark$inputs$validation$bs__GT_unit_map(G__55811,G__55812){
var validate__21099__auto__ = ufv___55813.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55818 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55811,G__55812], null);
var temp__4425__auto___55819 = input_checker55809_55816.call(null,args__21100__auto___55818);
if(cljs.core.truth_(temp__4425__auto___55819)){
var error__21101__auto___55820 = temp__4425__auto___55819;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"bs->unit-map","bs->unit-map",827144882,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extract map fk->value for a single field."], null)),cljs.core.pr_str.call(null,error__21101__auto___55820)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55808_55815,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55818,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55820], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var bs = G__55811;
var fk = G__55812;
while(true){
var m = fk.call(null,bs);
return new cljs.core.PersistentArrayMap.fromArray([fk,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m)], true, false);
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___55821 = output_checker55810_55817.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55821)){
var error__21101__auto___55822 = temp__4425__auto___55821;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"bs->unit-map","bs->unit-map",827144882,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extract map fk->value for a single field."], null)),cljs.core.pr_str.call(null,error__21101__auto___55822)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55807_55814,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55822], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55813,output_schema55807_55814,input_schema55808_55815,input_checker55809_55816,output_checker55810_55817))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.bs__GT_unit_map),schema.core.make_fn_schema.call(null,output_schema55807_55814,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55808_55815], null)));
var ufv___55844 = schema.utils.use_fn_validation;
var output_schema55823_55845 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema55824_55846 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker55825_55847 = schema.core.checker.call(null,input_schema55824_55846);
var output_checker55826_55848 = schema.core.checker.call(null,output_schema55823_55845);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: {s/Keyword s/Any}
 * 
 * Transform the business local state into final map
 */
dragonmark.inputs.validation.business_state__GT_map = ((function (ufv___55844,output_schema55823_55845,input_schema55824_55846,input_checker55825_55847,output_checker55826_55848){
return (function dragonmark$inputs$validation$business_state__GT_map(G__55827){
var validate__21099__auto__ = ufv___55844.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55849 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55827], null);
var temp__4425__auto___55850 = input_checker55825_55847.call(null,args__21100__auto___55849);
if(cljs.core.truth_(temp__4425__auto___55850)){
var error__21101__auto___55851 = temp__4425__auto___55850;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"business-state->map","business-state->map",1652123635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform the business local state into final map"], null)),cljs.core.pr_str.call(null,error__21101__auto___55851)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55824_55846,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55849,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55851], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var bs = G__55827;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21099__auto__,ufv___55844,output_schema55823_55845,input_schema55824_55846,input_checker55825_55847,output_checker55826_55848){
return (function dragonmark$inputs$validation$business_state__GT_map_$_iter__55836(s__55837){
return (new cljs.core.LazySeq(null,((function (validate__21099__auto__,ufv___55844,output_schema55823_55845,input_schema55824_55846,input_checker55825_55847,output_checker55826_55848){
return (function (){
var s__55837__$1 = s__55837;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55837__$1);
if(temp__4425__auto__){
var s__55837__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55837__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55837__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55839 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55838 = (0);
while(true){
if((i__55838 < size__19241__auto__)){
var vec__55842 = cljs.core._nth.call(null,c__19240__auto__,i__55838);
var k = cljs.core.nth.call(null,vec__55842,(0),null);
var _ = cljs.core.nth.call(null,vec__55842,(1),null);
cljs.core.chunk_append.call(null,b__55839,dragonmark.inputs.validation.bs__GT_unit_map.call(null,bs,k));

var G__55852 = (i__55838 + (1));
i__55838 = G__55852;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55839),dragonmark$inputs$validation$business_state__GT_map_$_iter__55836.call(null,cljs.core.chunk_rest.call(null,s__55837__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55839),null);
}
} else {
var vec__55843 = cljs.core.first.call(null,s__55837__$2);
var k = cljs.core.nth.call(null,vec__55843,(0),null);
var _ = cljs.core.nth.call(null,vec__55843,(1),null);
return cljs.core.cons.call(null,dragonmark.inputs.validation.bs__GT_unit_map.call(null,bs,k),dragonmark$inputs$validation$business_state__GT_map_$_iter__55836.call(null,cljs.core.rest.call(null,s__55837__$2)));
}
} else {
return null;
}
break;
}
});})(validate__21099__auto__,ufv___55844,output_schema55823_55845,input_schema55824_55846,input_checker55825_55847,output_checker55826_55848))
,null,null));
});})(validate__21099__auto__,ufv___55844,output_schema55823_55845,input_schema55824_55846,input_checker55825_55847,output_checker55826_55848))
;
return iter__19242__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___55853 = output_checker55826_55848.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55853)){
var error__21101__auto___55854 = temp__4425__auto___55853;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"business-state->map","business-state->map",1652123635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform the business local state into final map"], null)),cljs.core.pr_str.call(null,error__21101__auto___55854)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55823_55845,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55854], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55844,output_schema55823_55845,input_schema55824_55846,input_checker55825_55847,output_checker55826_55848))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.business_state__GT_map),schema.core.make_fn_schema.call(null,output_schema55823_55845,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55824_55846], null)));
var ufv___55860 = schema.utils.use_fn_validation;
var output_schema55855_55861 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema55856_55862 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker55857_55863 = schema.core.checker.call(null,input_schema55856_55862);
var output_checker55858_55864 = schema.core.checker.call(null,output_schema55855_55861);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: {s/Keyword s/Any}
 * 
 * Create the map that will be validated by the Schema :
 * Only keeps :
 * - required keys
 * - optional keys with non blank values
 */
dragonmark.inputs.validation.pre_validation = ((function (ufv___55860,output_schema55855_55861,input_schema55856_55862,input_checker55857_55863,output_checker55858_55864){
return (function dragonmark$inputs$validation$pre_validation(G__55859){
var validate__21099__auto__ = ufv___55860.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55865 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55859], null);
var temp__4425__auto___55866 = input_checker55857_55863.call(null,args__21100__auto___55865);
if(cljs.core.truth_(temp__4425__auto___55866)){
var error__21101__auto___55867 = temp__4425__auto___55866;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"pre-validation","pre-validation",731230710,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Create the map that will be validated by the Schema :\n  Only keeps :\n  - required keys\n  - optional keys with non blank values"], null)),cljs.core.pr_str.call(null,error__21101__auto___55867)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55856_55862,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55865,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55867], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var bs = G__55859;
while(true){
return dragonmark.inputs.validation.business_state__GT_map.call(null,dragonmark.inputs.validation.keep_fields_to_validate.call(null,bs));
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___55868 = output_checker55858_55864.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55868)){
var error__21101__auto___55869 = temp__4425__auto___55868;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"pre-validation","pre-validation",731230710,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Create the map that will be validated by the Schema :\n  Only keeps :\n  - required keys\n  - optional keys with non blank values"], null)),cljs.core.pr_str.call(null,error__21101__auto___55869)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55855_55861,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55869], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55860,output_schema55855_55861,input_schema55856_55862,input_checker55857_55863,output_checker55858_55864))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.pre_validation),schema.core.make_fn_schema.call(null,output_schema55855_55861,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55856_55862], null)));
var ufv___55891 = schema.utils.use_fn_validation;
var output_schema55870_55892 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema55871_55893 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"sch","sch",763282093,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker55872_55894 = schema.core.checker.call(null,input_schema55871_55893);
var output_checker55873_55895 = schema.core.checker.call(null,output_schema55870_55892);
/**
 * Inputs: [sch]
 * Returns: {s/Keyword s/Any}
 * 
 * Transform a Schema into a map of key -> individual Schema
 */
dragonmark.inputs.validation.sch_glo__GT_unit = ((function (ufv___55891,output_schema55870_55892,input_schema55871_55893,input_checker55872_55894,output_checker55873_55895){
return (function dragonmark$inputs$validation$sch_glo__GT_unit(G__55874){
var validate__21099__auto__ = ufv___55891.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55896 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55874], null);
var temp__4425__auto___55897 = input_checker55872_55894.call(null,args__21100__auto___55896);
if(cljs.core.truth_(temp__4425__auto___55897)){
var error__21101__auto___55898 = temp__4425__auto___55897;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sch-glo->unit","sch-glo->unit",1717844533,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform a Schema into a map of key -> individual Schema"], null)),cljs.core.pr_str.call(null,error__21101__auto___55898)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55871_55893,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55896,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55898], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var sch = G__55874;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21099__auto__,ufv___55891,output_schema55870_55892,input_schema55871_55893,input_checker55872_55894,output_checker55873_55895){
return (function dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__55883(s__55884){
return (new cljs.core.LazySeq(null,((function (validate__21099__auto__,ufv___55891,output_schema55870_55892,input_schema55871_55893,input_checker55872_55894,output_checker55873_55895){
return (function (){
var s__55884__$1 = s__55884;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55884__$1);
if(temp__4425__auto__){
var s__55884__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55884__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55884__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55886 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55885 = (0);
while(true){
if((i__55885 < size__19241__auto__)){
var vec__55889 = cljs.core._nth.call(null,c__19240__auto__,i__55885);
var k = cljs.core.nth.call(null,vec__55889,(0),null);
var t = cljs.core.nth.call(null,vec__55889,(1),null);
cljs.core.chunk_append.call(null,b__55886,new cljs.core.PersistentArrayMap.fromArray([cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),new cljs.core.PersistentArrayMap.fromArray([k,t], true, false)], true, false));

var G__55899 = (i__55885 + (1));
i__55885 = G__55899;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55886),dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__55883.call(null,cljs.core.chunk_rest.call(null,s__55884__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55886),null);
}
} else {
var vec__55890 = cljs.core.first.call(null,s__55884__$2);
var k = cljs.core.nth.call(null,vec__55890,(0),null);
var t = cljs.core.nth.call(null,vec__55890,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),new cljs.core.PersistentArrayMap.fromArray([k,t], true, false)], true, false),dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__55883.call(null,cljs.core.rest.call(null,s__55884__$2)));
}
} else {
return null;
}
break;
}
});})(validate__21099__auto__,ufv___55891,output_schema55870_55892,input_schema55871_55893,input_checker55872_55894,output_checker55873_55895))
,null,null));
});})(validate__21099__auto__,ufv___55891,output_schema55870_55892,input_schema55871_55893,input_checker55872_55894,output_checker55873_55895))
;
return iter__19242__auto__.call(null,sch);
})());
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___55900 = output_checker55873_55895.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55900)){
var error__21101__auto___55901 = temp__4425__auto___55900;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sch-glo->unit","sch-glo->unit",1717844533,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform a Schema into a map of key -> individual Schema"], null)),cljs.core.pr_str.call(null,error__21101__auto___55901)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55870_55892,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55901], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55891,output_schema55870_55892,input_schema55871_55893,input_checker55872_55894,output_checker55873_55895))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.sch_glo__GT_unit),schema.core.make_fn_schema.call(null,output_schema55870_55892,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55871_55893], null)));
/**
 * Build the map of field -> coercer
 */
dragonmark.inputs.validation.build_unit_coercers = (function dragonmark$inputs$validation$build_unit_coercers(sch){
return cljs.core.apply.call(null,cljs.core.merge,(function (){var iter__19242__auto__ = (function dragonmark$inputs$validation$build_unit_coercers_$_iter__55910(s__55911){
return (new cljs.core.LazySeq(null,(function (){
var s__55911__$1 = s__55911;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55911__$1);
if(temp__4425__auto__){
var s__55911__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55911__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55911__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55913 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55912 = (0);
while(true){
if((i__55912 < size__19241__auto__)){
var vec__55916 = cljs.core._nth.call(null,c__19240__auto__,i__55912);
var k = cljs.core.nth.call(null,vec__55916,(0),null);
var s = cljs.core.nth.call(null,vec__55916,(1),null);
cljs.core.chunk_append.call(null,b__55913,new cljs.core.PersistentArrayMap.fromArray([k,schema.coerce.coercer.call(null,s,dragonmark.inputs.validation.validation_coercer)], true, false));

var G__55918 = (i__55912 + (1));
i__55912 = G__55918;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55913),dragonmark$inputs$validation$build_unit_coercers_$_iter__55910.call(null,cljs.core.chunk_rest.call(null,s__55911__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55913),null);
}
} else {
var vec__55917 = cljs.core.first.call(null,s__55911__$2);
var k = cljs.core.nth.call(null,vec__55917,(0),null);
var s = cljs.core.nth.call(null,vec__55917,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,schema.coerce.coercer.call(null,s,dragonmark.inputs.validation.validation_coercer)], true, false),dragonmark$inputs$validation$build_unit_coercers_$_iter__55910.call(null,cljs.core.rest.call(null,s__55911__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,dragonmark.inputs.validation.sch_glo__GT_unit.call(null,sch));
})());
});
var ufv___55940 = schema.utils.use_fn_validation;
var output_schema55919_55941 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema55920_55942 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"unit-coercers","unit-coercers",-228543947,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_checker55921_55943 = schema.core.checker.call(null,input_schema55920_55942);
var output_checker55922_55944 = schema.core.checker.call(null,output_schema55919_55941);
/**
 * Inputs: [unit-coercers :- {s/Keyword s/Any}]
 * Returns: {s/Keyword s/Any}
 */
dragonmark.inputs.validation.unit_schema_validators = ((function (ufv___55940,output_schema55919_55941,input_schema55920_55942,input_checker55921_55943,output_checker55922_55944){
return (function dragonmark$inputs$validation$unit_schema_validators(G__55923){
var validate__21099__auto__ = true;
if(validate__21099__auto__){
var args__21100__auto___55945 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55923], null);
var temp__4425__auto___55946 = input_checker55921_55943.call(null,args__21100__auto___55945);
if(cljs.core.truth_(temp__4425__auto___55946)){
var error__21101__auto___55947 = temp__4425__auto___55946;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unit-schema-validators","unit-schema-validators",-690979832,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)),cljs.core.pr_str.call(null,error__21101__auto___55947)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55920_55942,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55945,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55947], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var unit_coercers = G__55923;
while(true){
return cljs.core.apply.call(null,cljs.core.merge,(function (){var iter__19242__auto__ = ((function (validate__21099__auto__,ufv___55940,output_schema55919_55941,input_schema55920_55942,input_checker55921_55943,output_checker55922_55944){
return (function dragonmark$inputs$validation$unit_schema_validators_$_iter__55932(s__55933){
return (new cljs.core.LazySeq(null,((function (validate__21099__auto__,ufv___55940,output_schema55919_55941,input_schema55920_55942,input_checker55921_55943,output_checker55922_55944){
return (function (){
var s__55933__$1 = s__55933;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55933__$1);
if(temp__4425__auto__){
var s__55933__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55933__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55933__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55935 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55934 = (0);
while(true){
if((i__55934 < size__19241__auto__)){
var vec__55938 = cljs.core._nth.call(null,c__19240__auto__,i__55934);
var k = cljs.core.nth.call(null,vec__55938,(0),null);
var c = cljs.core.nth.call(null,vec__55938,(1),null);
cljs.core.chunk_append.call(null,b__55935,new cljs.core.PersistentArrayMap.fromArray([k,cljs.core.partial.call(null,dragonmark.inputs.validation.validate,c,dragonmark.inputs.validation.transform_schema_errors)], true, false));

var G__55948 = (i__55934 + (1));
i__55934 = G__55948;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55935),dragonmark$inputs$validation$unit_schema_validators_$_iter__55932.call(null,cljs.core.chunk_rest.call(null,s__55933__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55935),null);
}
} else {
var vec__55939 = cljs.core.first.call(null,s__55933__$2);
var k = cljs.core.nth.call(null,vec__55939,(0),null);
var c = cljs.core.nth.call(null,vec__55939,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,cljs.core.partial.call(null,dragonmark.inputs.validation.validate,c,dragonmark.inputs.validation.transform_schema_errors)], true, false),dragonmark$inputs$validation$unit_schema_validators_$_iter__55932.call(null,cljs.core.rest.call(null,s__55933__$2)));
}
} else {
return null;
}
break;
}
});})(validate__21099__auto__,ufv___55940,output_schema55919_55941,input_schema55920_55942,input_checker55921_55943,output_checker55922_55944))
,null,null));
});})(validate__21099__auto__,ufv___55940,output_schema55919_55941,input_schema55920_55942,input_checker55921_55943,output_checker55922_55944))
;
return iter__19242__auto__.call(null,unit_coercers);
})());
break;
}
})();
if(validate__21099__auto__){
var temp__4425__auto___55949 = output_checker55922_55944.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55949)){
var error__21101__auto___55950 = temp__4425__auto___55949;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unit-schema-validators","unit-schema-validators",-690979832,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)),cljs.core.pr_str.call(null,error__21101__auto___55950)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55919_55941,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55950], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55940,output_schema55919_55941,input_schema55920_55942,input_checker55921_55943,output_checker55922_55944))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.unit_schema_validators),schema.core.make_fn_schema.call(null,output_schema55919_55941,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55920_55942], null)));
var ufv___55960 = schema.utils.use_fn_validation;
var output_schema55951_55961 = schema.core.Bool;
var input_schema55952_55962 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_field_state,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-field-state","sch-field-state",-361453047,null)], null)))], null);
var input_checker55953_55963 = schema.core.checker.call(null,input_schema55952_55962);
var output_checker55954_55964 = schema.core.checker.call(null,output_schema55951_55961);
/**
 * Inputs: [s :- sch-field-state]
 * Returns: s/Bool
 * 
 * Indicates if a field must be validated :
 * - required field
 * - optional field with non blank values
 */
dragonmark.inputs.validation.validate_QMARK_ = ((function (ufv___55960,output_schema55951_55961,input_schema55952_55962,input_checker55953_55963,output_checker55954_55964){
return (function dragonmark$inputs$validation$validate_QMARK_(G__55955){
var validate__21099__auto__ = ufv___55960.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55965 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55955], null);
var temp__4425__auto___55966 = input_checker55953_55963.call(null,args__21100__auto___55965);
if(cljs.core.truth_(temp__4425__auto___55966)){
var error__21101__auto___55967 = temp__4425__auto___55966;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"validate?","validate?",1996759489,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Indicates if a field must be validated :\n  - required field\n  - optional field with non blank values"], null)),cljs.core.pr_str.call(null,error__21101__auto___55967)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55952_55962,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55965,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55967], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var s = G__55955;
while(true){
var map__55958 = s;
var map__55958__$1 = ((((!((map__55958 == null)))?((((map__55958.cljs$lang$protocol_mask$partition0$ & (64))) || (map__55958.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55958):map__55958);
var required = cljs.core.get.call(null,map__55958__$1,new cljs.core.Keyword(null,"required","required",1807647006));
var value = cljs.core.get.call(null,map__55958__$1,new cljs.core.Keyword(null,"value","value",305978217));
var or__18489__auto__ = required;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,value));
}
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___55968 = output_checker55954_55964.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55968)){
var error__21101__auto___55969 = temp__4425__auto___55968;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"validate?","validate?",1996759489,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Indicates if a field must be validated :\n  - required field\n  - optional field with non blank values"], null)),cljs.core.pr_str.call(null,error__21101__auto___55969)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55951_55961,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55969], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55960,output_schema55951_55961,input_schema55952_55962,input_checker55953_55963,output_checker55954_55964))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.validate_QMARK_),schema.core.make_fn_schema.call(null,output_schema55951_55961,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55952_55962], null)));
var ufv___55976 = schema.utils.use_fn_validation;
var output_schema55970_55977 = dragonmark.inputs.schemas.sch_business_state;
var input_schema55971_55978 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,dragonmark.inputs.validation.sch_errors,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null)], null)))], null);
var input_checker55972_55979 = schema.core.checker.call(null,input_schema55971_55978);
var output_checker55973_55980 = schema.core.checker.call(null,output_schema55970_55977);
/**
 * Inputs: [state :- sch-business-state errs :- sch-errors]
 * Returns: sch-business-state
 * 
 * Handle errors for a single field
 */
dragonmark.inputs.validation.add_field_error = ((function (ufv___55976,output_schema55970_55977,input_schema55971_55978,input_checker55972_55979,output_checker55973_55980){
return (function dragonmark$inputs$validation$add_field_error(G__55974,G__55975){
var validate__21099__auto__ = ufv___55976.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55981 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55974,G__55975], null);
var temp__4425__auto___55982 = input_checker55972_55979.call(null,args__21100__auto___55981);
if(cljs.core.truth_(temp__4425__auto___55982)){
var error__21101__auto___55983 = temp__4425__auto___55982;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"add-field-error","add-field-error",-1753092209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Handle errors for a single field"], null)),cljs.core.pr_str.call(null,error__21101__auto___55983)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55971_55978,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55981,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55983], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var state = G__55974;
var errs = G__55975;
while(true){
return cljs.core.reduce.call(null,((function (validate__21099__auto__,ufv___55976,output_schema55970_55977,input_schema55971_55978,input_checker55972_55979,output_checker55973_55980){
return (function (s,e){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),false),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"error","error",-978969032)], null),e.call(null,errs));
});})(validate__21099__auto__,ufv___55976,output_schema55970_55977,input_schema55971_55978,input_checker55972_55979,output_checker55973_55980))
,state,cljs.core.keys.call(null,errs));
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___55984 = output_checker55973_55980.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___55984)){
var error__21101__auto___55985 = temp__4425__auto___55984;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"add-field-error","add-field-error",-1753092209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Handle errors for a single field"], null)),cljs.core.pr_str.call(null,error__21101__auto___55985)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55970_55977,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55985], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55976,output_schema55970_55977,input_schema55971_55978,input_checker55972_55979,output_checker55973_55980))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.add_field_error),schema.core.make_fn_schema.call(null,output_schema55970_55977,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55971_55978], null)));
dragonmark.inputs.validation.no_async_error_QMARK_ = (function dragonmark$inputs$validation$no_async_error_QMARK_(state,k){
var se = new cljs.core.Keyword(null,"async-error","async-error",528708636).cljs$core$IFn$_invoke$arity$1(k.call(null,state));
return cljs.core.boolean$.call(null,((se == null)) || (cljs.core.empty_QMARK_.call(null,se)));
});
var ufv___55992 = schema.utils.use_fn_validation;
var output_schema55986_55993 = dragonmark.inputs.schemas.sch_business_state;
var input_schema55987_55994 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker55988_55995 = schema.core.checker.call(null,input_schema55987_55994);
var output_checker55989_55996 = schema.core.checker.call(null,output_schema55986_55993);
/**
 * Inputs: [state :- sch-business-state k :- s/Keyword]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.remove_field_error = ((function (ufv___55992,output_schema55986_55993,input_schema55987_55994,input_checker55988_55995,output_checker55989_55996){
return (function dragonmark$inputs$validation$remove_field_error(G__55990,G__55991){
var validate__21099__auto__ = ufv___55992.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___55997 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55990,G__55991], null);
var temp__4425__auto___55998 = input_checker55988_55995.call(null,args__21100__auto___55997);
if(cljs.core.truth_(temp__4425__auto___55998)){
var error__21101__auto___55999 = temp__4425__auto___55998;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error","remove-field-error",-837789813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21101__auto___55999)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55987_55994,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___55997,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___55999], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var state = G__55990;
var k = G__55991;
while(true){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"valid","valid",155614240)], null),dragonmark.inputs.validation.no_async_error_QMARK_.call(null,state,k)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___56000 = output_checker55989_55996.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___56000)){
var error__21101__auto___56001 = temp__4425__auto___56000;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error","remove-field-error",-837789813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21101__auto___56001)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55986_55993,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___56001], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___55992,output_schema55986_55993,input_schema55987_55994,input_checker55988_55995,output_checker55989_55996))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_field_error),schema.core.make_fn_schema.call(null,output_schema55986_55993,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55987_55994], null)));
var ufv___56008 = schema.utils.use_fn_validation;
var output_schema56002_56009 = dragonmark.inputs.schemas.sch_business_state;
var input_schema56003_56010 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker56004_56011 = schema.core.checker.call(null,input_schema56003_56010);
var output_checker56005_56012 = schema.core.checker.call(null,output_schema56002_56009);
/**
 * Inputs: [state :- sch-business-state k :- s/Keyword]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.remove_field_error_and_server = ((function (ufv___56008,output_schema56002_56009,input_schema56003_56010,input_checker56004_56011,output_checker56005_56012){
return (function dragonmark$inputs$validation$remove_field_error_and_server(G__56006,G__56007){
var validate__21099__auto__ = ufv___56008.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___56013 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__56006,G__56007], null);
var temp__4425__auto___56014 = input_checker56004_56011.call(null,args__21100__auto___56013);
if(cljs.core.truth_(temp__4425__auto___56014)){
var error__21101__auto___56015 = temp__4425__auto___56014;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error-and-server","remove-field-error-and-server",-1796162559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21101__auto___56015)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema56003_56010,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___56013,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___56015], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var state = G__56006;
var k = G__56007;
while(true){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"valid","valid",155614240)], null),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"async-error","async-error",528708636)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___56016 = output_checker56005_56012.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___56016)){
var error__21101__auto___56017 = temp__4425__auto___56016;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error-and-server","remove-field-error-and-server",-1796162559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21101__auto___56017)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema56002_56009,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___56017], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___56008,output_schema56002_56009,input_schema56003_56010,input_checker56004_56011,output_checker56005_56012))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_field_error_and_server),schema.core.make_fn_schema.call(null,output_schema56002_56009,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema56003_56010], null)));
var ufv___56025 = schema.utils.use_fn_validation;
var output_schema56018_56026 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);
var input_schema56019_56027 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,cljs.core.PersistentHashSet.fromArray([schema.core.Keyword], true),cljs.core.with_meta(new cljs.core.Symbol(null,"cross-errs","cross-errs",-563013712,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),null], null), null)], null))),schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Keyword], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"error-rule","error-rule",327326958,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null))),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker56020_56028 = schema.core.checker.call(null,input_schema56019_56027);
var output_checker56021_56029 = schema.core.checker.call(null,output_schema56018_56026);
/**
 * Inputs: [cross-errs :- #{s/Keyword} error-rule :- {s/Keyword s/Keyword} errs :- [s/Keyword]]
 * Returns: [s/Keyword]
 * 
 * Remove the cross field errors keys from the validation errors.
 * This prevent errors from showing when inline validation occurs.
 */
dragonmark.inputs.validation.remove_dependant_errors = ((function (ufv___56025,output_schema56018_56026,input_schema56019_56027,input_checker56020_56028,output_checker56021_56029){
return (function dragonmark$inputs$validation$remove_dependant_errors(G__56022,G__56023,G__56024){
var validate__21099__auto__ = ufv___56025.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___56030 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__56022,G__56023,G__56024], null);
var temp__4425__auto___56031 = input_checker56020_56028.call(null,args__21100__auto___56030);
if(cljs.core.truth_(temp__4425__auto___56031)){
var error__21101__auto___56032 = temp__4425__auto___56031;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-dependant-errors","remove-dependant-errors",-830444485,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remove the cross field errors keys from the validation errors.\n  This prevent errors from showing when inline validation occurs."], null)),cljs.core.pr_str.call(null,error__21101__auto___56032)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema56019_56027,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___56030,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___56032], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var cross_errs = G__56022;
var error_rule = G__56023;
var errs = G__56024;
while(true){
return cljs.core.seq.call(null,cljs.core.remove.call(null,((function (validate__21099__auto__,ufv___56025,output_schema56018_56026,input_schema56019_56027,input_checker56020_56028,output_checker56021_56029){
return (function (err){
return cross_errs.call(null,cljs.core.get.call(null,error_rule,err));
});})(validate__21099__auto__,ufv___56025,output_schema56018_56026,input_schema56019_56027,input_checker56020_56028,output_checker56021_56029))
,errs));
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___56033 = output_checker56021_56029.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___56033)){
var error__21101__auto___56034 = temp__4425__auto___56033;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-dependant-errors","remove-dependant-errors",-830444485,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remove the cross field errors keys from the validation errors.\n  This prevent errors from showing when inline validation occurs."], null)),cljs.core.pr_str.call(null,error__21101__auto___56034)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema56018_56026,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___56034], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___56025,output_schema56018_56026,input_schema56019_56027,input_checker56020_56028,output_checker56021_56029))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_dependant_errors),schema.core.make_fn_schema.call(null,output_schema56018_56026,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema56019_56027], null)));
dragonmark.inputs.validation.build_error_remover = (function dragonmark$inputs$validation$build_error_remover(rules,cross_fields_rules){
return cljs.core.partial.call(null,dragonmark.inputs.validation.remove_dependant_errors,cross_fields_rules,dragonmark.inputs.validation.error__GT_rule.call(null,rules));
});
/**
 * validate a single field against verily rules.
 * If an other field depends on this one, then the errors linked to this validation won't show up.
 */
dragonmark.inputs.validation.unit_verily_validation = (function dragonmark$inputs$validation$unit_verily_validation(fk,unit,p__56035){
var map__56038 = p__56035;
var map__56038__$1 = ((((!((map__56038 == null)))?((((map__56038.cljs$lang$protocol_mask$partition0$ & (64))) || (map__56038.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56038):map__56038);
var state = map__56038__$1;
var unit_coercers = cljs.core.get.call(null,map__56038__$1,new cljs.core.Keyword(null,"unit-coercers","unit-coercers",-1869075474));
var remove_errs_fn = cljs.core.get.call(null,map__56038__$1,new cljs.core.Keyword(null,"remove-errs-fn","remove-errs-fn",-1642608850));
var verily_validator = cljs.core.get.call(null,map__56038__$1,new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403));
var coerced = fk.call(null,unit_coercers).call(null,unit);
var errs = verily_validator.call(null,coerced);
if(cljs.core.contains_QMARK_.call(null,errs,fk)){
var errs_unit = cljs.core.update_in.call(null,errs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null),remove_errs_fn);
var res = cljs.core.select_keys.call(null,errs_unit,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null));
if(cljs.core.truth_(fk.call(null,res))){
return res;
} else {
return null;
}
} else {
return null;
}
});
/**
 * Verily validation of a field that depend on other.
 * The confirm password is a typical example.
 */
dragonmark.inputs.validation.unit_dependant_verily_validation = (function dragonmark$inputs$validation$unit_dependant_verily_validation(fk,inputs,state){
var map__56042 = state;
var map__56042__$1 = ((((!((map__56042 == null)))?((((map__56042.cljs$lang$protocol_mask$partition0$ & (64))) || (map__56042.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56042):map__56042);
var validation_deps = cljs.core.get.call(null,map__56042__$1,new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716));
var verily_validator = cljs.core.get.call(null,map__56042__$1,new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403));
var deps = fk.call(null,validation_deps);
var coerced = dragonmark.inputs.validation.business_state__GT_map.call(null,inputs);
var errs = verily_validator.call(null,coerced);
if(cljs.core.contains_QMARK_.call(null,errs,fk)){
return cljs.core.select_keys.call(null,errs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null));
} else {
return null;
}
});
/**
 * Verily validation of a single field
 */
dragonmark.inputs.validation.verily_validation = (function dragonmark$inputs$validation$verily_validation(fk,unit,bs,state){
var map__56046 = state;
var map__56046__$1 = ((((!((map__56046 == null)))?((((map__56046.cljs$lang$protocol_mask$partition0$ & (64))) || (map__56046.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56046):map__56046);
var validation_deps = cljs.core.get.call(null,map__56046__$1,new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716));
if(cljs.core.truth_(fk.call(null,validation_deps))){
return dragonmark.inputs.validation.unit_dependant_verily_validation.call(null,fk,bs,state);
} else {
return dragonmark.inputs.validation.unit_verily_validation.call(null,fk,unit,state);
}
});
/**
 * Validation of a single field
 * TODO Refactoring
 */
dragonmark.inputs.validation.field_validation = (function dragonmark$inputs$validation$field_validation(fk,inputs,state){
var map__56050 = state;
var map__56050__$1 = ((((!((map__56050 == null)))?((((map__56050.cljs$lang$protocol_mask$partition0$ & (64))) || (map__56050.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56050):map__56050);
var unit_validators = cljs.core.get.call(null,map__56050__$1,new cljs.core.Keyword(null,"unit-validators","unit-validators",-1302618433));
var unit = dragonmark.inputs.validation.bs__GT_unit_map.call(null,inputs,fk);
if(cljs.core.truth_(dragonmark.inputs.validation.validate_QMARK_.call(null,fk.call(null,inputs)))){
var temp__4423__auto__ = (function (){var or__18489__auto__ = (function (){var and__18477__auto__ = fk;
if(cljs.core.truth_(and__18477__auto__)){
var temp__4423__auto__ = fk.call(null,unit_validators);
if(cljs.core.truth_(temp__4423__auto__)){
var the_fn = temp__4423__auto__;
return the_fn.call(null,unit);
} else {
return null;
}
} else {
return and__18477__auto__;
}
})();
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return dragonmark.inputs.validation.verily_validation.call(null,fk,unit,inputs,state);
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var errs = temp__4423__auto__;
return dragonmark.inputs.validation.add_field_error.call(null,inputs,errs);
} else {
return dragonmark.inputs.validation.remove_field_error.call(null,inputs,fk);
}
} else {
return dragonmark.inputs.validation.remove_field_error.call(null,inputs,fk);
}
});
/**
 * Validate a single field of the local business state and update the local state.
 */
dragonmark.inputs.validation.field_validation_BANG_ = (function dragonmark$inputs$validation$field_validation_BANG_(owner,f){
console.log("fv!",cljs.core.pr_str.call(null,f));

var map__56054 = dragonmark.inputs.extern.get_state.call(null,owner);
var map__56054__$1 = ((((!((map__56054 == null)))?((((map__56054.cljs$lang$protocol_mask$partition0$ & (64))) || (map__56054.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56054):map__56054);
var state = map__56054__$1;
var inputs = cljs.core.get.call(null,map__56054__$1,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var old_inputs = inputs;
var inputs__$1 = dragonmark.inputs.validation.remove_field_error_and_server.call(null,inputs,f);
console.log("After ",inputs__$1.call(null,f));

var new_business_state = dragonmark.inputs.validation.field_validation.call(null,f,inputs__$1,state);
if(cljs.core.not_EQ_.call(null,old_inputs,new_business_state)){
return dragonmark.inputs.extern.set_state_BANG_.call(null,owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"inputs","inputs",865803858)], null),new_business_state);
} else {
return null;
}
});
dragonmark.inputs.validation.full_validation = (function dragonmark$inputs$validation$full_validation(inputs,state){
return cljs.core.reduce.call(null,(function (bs,f){
return dragonmark.inputs.validation.field_validation.call(null,f,bs,state);
}),inputs,cljs.core.keys.call(null,inputs));
});
var ufv___56065 = schema.utils.use_fn_validation;
var output_schema56056_56066 = schema.core.Bool;
var input_schema56057_56067 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker56058_56068 = schema.core.checker.call(null,input_schema56057_56067);
var output_checker56059_56069 = schema.core.checker.call(null,output_schema56056_56066);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: s/Bool
 * 
 * Tells if there is at least one field in error.
 */
dragonmark.inputs.validation.no_error_QMARK_ = ((function (ufv___56065,output_schema56056_56066,input_schema56057_56067,input_checker56058_56068,output_checker56059_56069){
return (function dragonmark$inputs$validation$no_error_QMARK_(G__56060){
var validate__21099__auto__ = ufv___56065.get_cell();
if(cljs.core.truth_(validate__21099__auto__)){
var args__21100__auto___56070 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__56060], null);
var temp__4425__auto___56071 = input_checker56058_56068.call(null,args__21100__auto___56070);
if(cljs.core.truth_(temp__4425__auto___56071)){
var error__21101__auto___56072 = temp__4425__auto___56071;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"no-error?","no-error?",323642458,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tells if there is at least one field in error."], null)),cljs.core.pr_str.call(null,error__21101__auto___56072)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema56057_56067,new cljs.core.Keyword(null,"value","value",305978217),args__21100__auto___56070,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___56072], null));
} else {
}
} else {
}

var o__21102__auto__ = (function (){var bs = G__56060;
while(true){
return cljs.core.not_any_QMARK_.call(null,((function (validate__21099__auto__,ufv___56065,output_schema56056_56066,input_schema56057_56067,input_checker56058_56068,output_checker56059_56069){
return (function (p__56063){
var vec__56064 = p__56063;
var k = cljs.core.nth.call(null,vec__56064,(0),null);
var v = cljs.core.nth.call(null,vec__56064,(1),null);
return new cljs.core.Keyword(null,"valid","valid",155614240).cljs$core$IFn$_invoke$arity$1(v) === false;
});})(validate__21099__auto__,ufv___56065,output_schema56056_56066,input_schema56057_56067,input_checker56058_56068,output_checker56059_56069))
,bs);
break;
}
})();
if(cljs.core.truth_(validate__21099__auto__)){
var temp__4425__auto___56073 = output_checker56059_56069.call(null,o__21102__auto__);
if(cljs.core.truth_(temp__4425__auto___56073)){
var error__21101__auto___56074 = temp__4425__auto___56073;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"no-error?","no-error?",323642458,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tells if there is at least one field in error."], null)),cljs.core.pr_str.call(null,error__21101__auto___56074)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema56056_56066,new cljs.core.Keyword(null,"value","value",305978217),o__21102__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21101__auto___56074], null));
} else {
}
} else {
}

return o__21102__auto__;
});})(ufv___56065,output_schema56056_56066,input_schema56057_56067,input_checker56058_56068,output_checker56059_56069))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.no_error_QMARK_),schema.core.make_fn_schema.call(null,output_schema56056_56066,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema56057_56067], null)));

//# sourceMappingURL=validation.js.map