// Compiled by ClojureScript 1.7.48 {}
goog.provide('om_inputs.i18n');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('clojure.string');
goog.require('om_inputs.extern');
goog.require('om_inputs.utils');
om_inputs.i18n.sch_i18n_field_labels = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"label","label",1718410804)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"ph","ph",-1483583977)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"info","info",-317069002)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"info-title","info-title",-1811346921)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"html","html",-998796897)),schema.core.Any], true, false);
om_inputs.i18n.sch_i18n_enum_labels = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"data","data",-232669377)),new cljs.core.PersistentArrayMap.fromArray([schema.core.Any,om_inputs.i18n.sch_i18n_field_labels], true, false)], true, false);
om_inputs.i18n.sch_i18n_field = cljs.core.merge.call(null,om_inputs.i18n.sch_i18n_enum_labels,om_inputs.i18n.sch_i18n_field_labels);
om_inputs.i18n.sch_i18n_errors = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718)),new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Str], true, false)], true, false);
/**
 * Build a specific i18n Schema with all possible keys.
 */
om_inputs.i18n.build_i18n_schema = (function om_inputs$i18n$build_i18n_schema(sch){
return cljs.core.reduce.call(null,(function (acc,p__22298){
var vec__22299 = p__22298;
var k = cljs.core.nth.call(null,vec__22299,(0),null);
var v = cljs.core.nth.call(null,vec__22299,(1),null);
return cljs.core.assoc.call(null,acc,schema.core.optional_key.call(null,cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k)),om_inputs.i18n.sch_i18n_field);
}),new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"title","title",636505583)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"action","action",-811238024)),om_inputs.i18n.sch_i18n_field_labels,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"clean","clean",41534079)),om_inputs.i18n.sch_i18n_field_labels], true, false),sch);
});
/**
 * Try to determine the language of the browser
 */
om_inputs.i18n.browser_lang = (function om_inputs$i18n$browser_lang(){
var temp__4425__auto__ = (function (){var or__18489__auto__ = navigator.userLanguage;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = navigator.browserLanguage;
if(cljs.core.truth_(or__18489__auto____$1)){
return or__18489__auto____$1;
} else {
return navigator.language;
}
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var b_lang = temp__4425__auto__;
return b_lang.substr((0),(2));
} else {
return null;
}
});
om_inputs.i18n.I18NSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.Str,cljs.core.merge.call(null,om_inputs.i18n.sch_i18n_errors,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,om_inputs.i18n.sch_i18n_field], true, false),new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"title","title",636505583)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"action","action",-811238024)),om_inputs.i18n.sch_i18n_field_labels,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"clean","clean",41534079)),om_inputs.i18n.sch_i18n_field_labels], true, false))], true, false))], true, false);
/**
 * If i18n is provided then determine the language in this order from
 * the state
 * the browser
 * the first language available
 */
om_inputs.i18n.i18n_comp_lang = (function om_inputs$i18n$i18n_comp_lang(sch,comp_name,lang,full_i18n,opts){
var langs = cljs.core.keys.call(null,full_i18n);
var language = (function (){var or__18489__auto__ = cljs.core.some.call(null,cljs.core.PersistentHashSet.fromArray([lang], true),langs);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = cljs.core.some.call(null,cljs.core.PersistentHashSet.fromArray([om_inputs.i18n.browser_lang.call(null)], true),langs);
if(cljs.core.truth_(or__18489__auto____$1)){
return or__18489__auto____$1;
} else {
return cljs.core.first.call(null,langs);
}
}
})();
if(cljs.core.not_EQ_.call(null,lang,language)){
cljs.core.prn.call(null,[cljs.core.str("Warning - Check your i18n language configuration; you set : "),cljs.core.str(lang),cljs.core.str(" but found no labels. Switching to : "),cljs.core.str(language)].join(''));
} else {
}

var labels = cljs.core.get_in.call(null,full_i18n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [language,comp_name], null));
if(cljs.core.truth_(new cljs.core.Keyword(null,"validate-i18n-keys","validate-i18n-keys",-415632905).cljs$core$IFn$_invoke$arity$1(opts))){
return schema.core.validate.call(null,om_inputs.i18n.build_i18n_schema.call(null,sch),labels);
} else {
return labels;
}
});
/**
 * Optimisation and as a side effect the warning is printed only once
 */
om_inputs.i18n.i18n_comp_lang_memo = cljs.core.memoize.call(null,om_inputs.i18n.i18n_comp_lang);
/**
 * Get the specific i18n labels for the component and the language
 */
om_inputs.i18n.comp_i18n = (function om_inputs$i18n$comp_i18n(owner,comp_name,sch,opts){
var full_i18n = om_inputs.extern.get_i18n_info.call(null,owner,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
var lang = om_inputs.extern.get_state.call(null,owner,new cljs.core.Keyword(null,"lang","lang",-1819677104));
if(cljs.core.truth_(full_i18n)){
if(cljs.core.truth_(new cljs.core.Keyword(null,"validate-i18n-keys","validate-i18n-keys",-415632905).cljs$core$IFn$_invoke$arity$1(opts))){
schema.core.validate.call(null,om_inputs.i18n.I18NSchema,full_i18n);
} else {
}

return om_inputs.i18n.i18n_comp_lang_memo.call(null,sch,comp_name,lang,full_i18n,opts);
} else {
return null;
}
});
om_inputs.i18n.label = (function om_inputs$i18n$label(){
var args22300 = [];
var len__19528__auto___22303 = arguments.length;
var i__19529__auto___22304 = (0);
while(true){
if((i__19529__auto___22304 < len__19528__auto___22303)){
args22300.push((arguments[i__19529__auto___22304]));

var G__22305 = (i__19529__auto___22304 + (1));
i__19529__auto___22304 = G__22305;
continue;
} else {
}
break;
}

var G__22302 = args22300.length;
switch (G__22302) {
case 1:
return om_inputs.i18n.label.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return om_inputs.i18n.label.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22300.length)].join('')));

}
});

om_inputs.i18n.label.cljs$core$IFn$_invoke$arity$1 = (function (opts){
return om_inputs.i18n.label.call(null,new cljs.core.Keyword(null,"i18n","i18n",-563422499).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts));
});

om_inputs.i18n.label.cljs$core$IFn$_invoke$arity$2 = (function (i18n,k){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804)], null),clojure.string.capitalize.call(null,cljs.core.name.call(null,k)));
});

om_inputs.i18n.label.cljs$lang$maxFixedArity = 2;
om_inputs.i18n.desc = (function om_inputs$i18n$desc(){
var args22307 = [];
var len__19528__auto___22310 = arguments.length;
var i__19529__auto___22311 = (0);
while(true){
if((i__19529__auto___22311 < len__19528__auto___22310)){
args22307.push((arguments[i__19529__auto___22311]));

var G__22312 = (i__19529__auto___22311 + (1));
i__19529__auto___22311 = G__22312;
continue;
} else {
}
break;
}

var G__22309 = args22307.length;
switch (G__22309) {
case 1:
return om_inputs.i18n.desc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return om_inputs.i18n.desc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22307.length)].join('')));

}
});

om_inputs.i18n.desc.cljs$core$IFn$_invoke$arity$1 = (function (opts){
return cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),new cljs.core.Keyword(null,"desc","desc",2093485764)], null));
});

om_inputs.i18n.desc.cljs$core$IFn$_invoke$arity$2 = (function (i18n,k){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"desc","desc",2093485764)], null));
});

om_inputs.i18n.desc.cljs$lang$maxFixedArity = 2;
om_inputs.i18n.desc_QMARK_ = (function om_inputs$i18n$desc_QMARK_(i18n,k){
return !((om_inputs.i18n.desc.call(null,i18n,k) == null));
});
om_inputs.i18n.html_desc = (function om_inputs$i18n$html_desc(opts){
return cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),new cljs.core.Keyword(null,"html","html",-998796897)], null));
});
om_inputs.i18n.html_desc_QMARK_ = (function om_inputs$i18n$html_desc_QMARK_(opts){
return !((om_inputs.i18n.html_desc.call(null,opts) == null));
});
om_inputs.i18n.data = (function om_inputs$i18n$data(i18n){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
});
om_inputs.i18n.enum_label = (function om_inputs$i18n$enum_label(data,code){
return cljs.core.get_in.call(null,data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [code,new cljs.core.Keyword(null,"label","label",1718410804)], null),(((code instanceof cljs.core.Keyword))?om_inputs.utils.full_name.call(null,code):code));
});
var ufv___22320 = schema.utils.use_fn_validation;
var output_schema22314_22321 = schema.core.Any;
var input_schema22315_22322 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.i18n.I18NSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"full-i18n","full-i18n",757551349,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"I18NSchema","I18NSchema",-1537766132,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker22316_22323 = schema.core.checker.call(null,input_schema22315_22322);
var output_checker22317_22324 = schema.core.checker.call(null,output_schema22314_22321);
/**
 * Inputs: [full-i18n :- I18NSchema k :- s/Keyword]
 */
om_inputs.i18n.error = ((function (ufv___22320,output_schema22314_22321,input_schema22315_22322,input_checker22316_22323,output_checker22317_22324){
return (function om_inputs$i18n$error(G__22318,G__22319){
var validate__20882__auto__ = ufv___22320.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___22325 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__22318,G__22319], null);
var temp__4425__auto___22326 = input_checker22316_22323.call(null,args__20883__auto___22325);
if(cljs.core.truth_(temp__4425__auto___22326)){
var error__20884__auto___22327 = temp__4425__auto___22326;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___22327)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema22315_22322,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___22325,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___22327], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var full_i18n = G__22318;
var k = G__22319;
while(true){
return cljs.core.get_in.call(null,full_i18n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),k], null));
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___22328 = output_checker22317_22324.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___22328)){
var error__20884__auto___22329 = temp__4425__auto___22328;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___22329)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema22314_22321,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___22329], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___22320,output_schema22314_22321,input_schema22315_22322,input_checker22316_22323,output_checker22317_22324))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.i18n.error),schema.core.make_fn_schema.call(null,output_schema22314_22321,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema22315_22322], null)));
om_inputs.i18n.ph = (function om_inputs$i18n$ph(i18n){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ph","ph",-1483583977)], null));
});
om_inputs.i18n.info = (function om_inputs$i18n$info(opts){
return cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),new cljs.core.Keyword(null,"info","info",-317069002)], null));
});
om_inputs.i18n.info_title = (function om_inputs$i18n$info_title(opts){
return cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),new cljs.core.Keyword(null,"info-title","info-title",-1811346921)], null));
});

//# sourceMappingURL=i18n.js.map