// Compiled by ClojureScript 1.7.48 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t29257 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29257 = (function (fn_handler,f,meta29258){
this.fn_handler = fn_handler;
this.f = f;
this.meta29258 = meta29258;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29257.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29259,meta29258__$1){
var self__ = this;
var _29259__$1 = this;
return (new cljs.core.async.t29257(self__.fn_handler,self__.f,meta29258__$1));
});

cljs.core.async.t29257.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29259){
var self__ = this;
var _29259__$1 = this;
return self__.meta29258;
});

cljs.core.async.t29257.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29257.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t29257.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t29257.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta29258","meta29258",-1996900114,null)], null);
});

cljs.core.async.t29257.cljs$lang$type = true;

cljs.core.async.t29257.cljs$lang$ctorStr = "cljs.core.async/t29257";

cljs.core.async.t29257.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t29257");
});

cljs.core.async.__GT_t29257 = (function cljs$core$async$fn_handler_$___GT_t29257(fn_handler__$1,f__$1,meta29258){
return (new cljs.core.async.t29257(fn_handler__$1,f__$1,meta29258));
});

}

return (new cljs.core.async.t29257(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var args29262 = [];
var len__19528__auto___29265 = arguments.length;
var i__19529__auto___29266 = (0);
while(true){
if((i__19529__auto___29266 < len__19528__auto___29265)){
args29262.push((arguments[i__19529__auto___29266]));

var G__29267 = (i__19529__auto___29266 + (1));
i__19529__auto___29266 = G__29267;
continue;
} else {
}
break;
}

var G__29264 = args29262.length;
switch (G__29264) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29262.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var args29269 = [];
var len__19528__auto___29272 = arguments.length;
var i__19529__auto___29273 = (0);
while(true){
if((i__19529__auto___29273 < len__19528__auto___29272)){
args29269.push((arguments[i__19529__auto___29273]));

var G__29274 = (i__19529__auto___29273 + (1));
i__19529__auto___29273 = G__29274;
continue;
} else {
}
break;
}

var G__29271 = args29269.length;
switch (G__29271) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29269.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_29276 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_29276);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_29276,ret){
return (function (){
return fn1.call(null,val_29276);
});})(val_29276,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var args29277 = [];
var len__19528__auto___29280 = arguments.length;
var i__19529__auto___29281 = (0);
while(true){
if((i__19529__auto___29281 < len__19528__auto___29280)){
args29277.push((arguments[i__19529__auto___29281]));

var G__29282 = (i__19529__auto___29281 + (1));
i__19529__auto___29281 = G__29282;
continue;
} else {
}
break;
}

var G__29279 = args29277.length;
switch (G__29279) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29277.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__19373__auto___29284 = n;
var x_29285 = (0);
while(true){
if((x_29285 < n__19373__auto___29284)){
(a[x_29285] = (0));

var G__29286 = (x_29285 + (1));
x_29285 = G__29286;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__29287 = (i + (1));
i = G__29287;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t29291 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29291 = (function (alt_flag,flag,meta29292){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta29292 = meta29292;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29291.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29293,meta29292__$1){
var self__ = this;
var _29293__$1 = this;
return (new cljs.core.async.t29291(self__.alt_flag,self__.flag,meta29292__$1));
});})(flag))
;

cljs.core.async.t29291.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29293){
var self__ = this;
var _29293__$1 = this;
return self__.meta29292;
});})(flag))
;

cljs.core.async.t29291.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29291.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t29291.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t29291.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29292","meta29292",1154505499,null)], null);
});})(flag))
;

cljs.core.async.t29291.cljs$lang$type = true;

cljs.core.async.t29291.cljs$lang$ctorStr = "cljs.core.async/t29291";

cljs.core.async.t29291.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t29291");
});})(flag))
;

cljs.core.async.__GT_t29291 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t29291(alt_flag__$1,flag__$1,meta29292){
return (new cljs.core.async.t29291(alt_flag__$1,flag__$1,meta29292));
});})(flag))
;

}

return (new cljs.core.async.t29291(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t29297 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29297 = (function (alt_handler,flag,cb,meta29298){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta29298 = meta29298;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29297.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29299,meta29298__$1){
var self__ = this;
var _29299__$1 = this;
return (new cljs.core.async.t29297(self__.alt_handler,self__.flag,self__.cb,meta29298__$1));
});

cljs.core.async.t29297.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29299){
var self__ = this;
var _29299__$1 = this;
return self__.meta29298;
});

cljs.core.async.t29297.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29297.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t29297.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t29297.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29298","meta29298",1354074699,null)], null);
});

cljs.core.async.t29297.cljs$lang$type = true;

cljs.core.async.t29297.cljs$lang$ctorStr = "cljs.core.async/t29297";

cljs.core.async.t29297.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t29297");
});

cljs.core.async.__GT_t29297 = (function cljs$core$async$alt_handler_$___GT_t29297(alt_handler__$1,flag__$1,cb__$1,meta29298){
return (new cljs.core.async.t29297(alt_handler__$1,flag__$1,cb__$1,meta29298));
});

}

return (new cljs.core.async.t29297(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29300_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29300_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29301_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29301_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__18489__auto__ = wport;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29302 = (i + (1));
i = G__29302;
continue;
}
} else {
return null;
}
break;
}
})();
var or__18489__auto__ = ret;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__18477__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__18477__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__18477__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var args__19535__auto__ = [];
var len__19528__auto___29308 = arguments.length;
var i__19529__auto___29309 = (0);
while(true){
if((i__19529__auto___29309 < len__19528__auto___29308)){
args__19535__auto__.push((arguments[i__19529__auto___29309]));

var G__29310 = (i__19529__auto___29309 + (1));
i__19529__auto___29309 = G__29310;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29305){
var map__29306 = p__29305;
var map__29306__$1 = ((((!((map__29306 == null)))?((((map__29306.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29306.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29306):map__29306);
var opts = map__29306__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29303){
var G__29304 = cljs.core.first.call(null,seq29303);
var seq29303__$1 = cljs.core.next.call(null,seq29303);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29304,seq29303__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var args29311 = [];
var len__19528__auto___29361 = arguments.length;
var i__19529__auto___29362 = (0);
while(true){
if((i__19529__auto___29362 < len__19528__auto___29361)){
args29311.push((arguments[i__19529__auto___29362]));

var G__29363 = (i__19529__auto___29362 + (1));
i__19529__auto___29362 = G__29363;
continue;
} else {
}
break;
}

var G__29313 = args29311.length;
switch (G__29313) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29311.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__23928__auto___29365 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___29365){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___29365){
return (function (state_29337){
var state_val_29338 = (state_29337[(1)]);
if((state_val_29338 === (7))){
var inst_29333 = (state_29337[(2)]);
var state_29337__$1 = state_29337;
var statearr_29339_29366 = state_29337__$1;
(statearr_29339_29366[(2)] = inst_29333);

(statearr_29339_29366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29338 === (1))){
var state_29337__$1 = state_29337;
var statearr_29340_29367 = state_29337__$1;
(statearr_29340_29367[(2)] = null);

(statearr_29340_29367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29338 === (4))){
var inst_29316 = (state_29337[(7)]);
var inst_29316__$1 = (state_29337[(2)]);
var inst_29317 = (inst_29316__$1 == null);
var state_29337__$1 = (function (){var statearr_29341 = state_29337;
(statearr_29341[(7)] = inst_29316__$1);

return statearr_29341;
})();
if(cljs.core.truth_(inst_29317)){
var statearr_29342_29368 = state_29337__$1;
(statearr_29342_29368[(1)] = (5));

} else {
var statearr_29343_29369 = state_29337__$1;
(statearr_29343_29369[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29338 === (13))){
var state_29337__$1 = state_29337;
var statearr_29344_29370 = state_29337__$1;
(statearr_29344_29370[(2)] = null);

(statearr_29344_29370[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29338 === (6))){
var inst_29316 = (state_29337[(7)]);
var state_29337__$1 = state_29337;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29337__$1,(11),to,inst_29316);
} else {
if((state_val_29338 === (3))){
var inst_29335 = (state_29337[(2)]);
var state_29337__$1 = state_29337;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29337__$1,inst_29335);
} else {
if((state_val_29338 === (12))){
var state_29337__$1 = state_29337;
var statearr_29345_29371 = state_29337__$1;
(statearr_29345_29371[(2)] = null);

(statearr_29345_29371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29338 === (2))){
var state_29337__$1 = state_29337;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29337__$1,(4),from);
} else {
if((state_val_29338 === (11))){
var inst_29326 = (state_29337[(2)]);
var state_29337__$1 = state_29337;
if(cljs.core.truth_(inst_29326)){
var statearr_29346_29372 = state_29337__$1;
(statearr_29346_29372[(1)] = (12));

} else {
var statearr_29347_29373 = state_29337__$1;
(statearr_29347_29373[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29338 === (9))){
var state_29337__$1 = state_29337;
var statearr_29348_29374 = state_29337__$1;
(statearr_29348_29374[(2)] = null);

(statearr_29348_29374[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29338 === (5))){
var state_29337__$1 = state_29337;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29349_29375 = state_29337__$1;
(statearr_29349_29375[(1)] = (8));

} else {
var statearr_29350_29376 = state_29337__$1;
(statearr_29350_29376[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29338 === (14))){
var inst_29331 = (state_29337[(2)]);
var state_29337__$1 = state_29337;
var statearr_29351_29377 = state_29337__$1;
(statearr_29351_29377[(2)] = inst_29331);

(statearr_29351_29377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29338 === (10))){
var inst_29323 = (state_29337[(2)]);
var state_29337__$1 = state_29337;
var statearr_29352_29378 = state_29337__$1;
(statearr_29352_29378[(2)] = inst_29323);

(statearr_29352_29378[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29338 === (8))){
var inst_29320 = cljs.core.async.close_BANG_.call(null,to);
var state_29337__$1 = state_29337;
var statearr_29353_29379 = state_29337__$1;
(statearr_29353_29379[(2)] = inst_29320);

(statearr_29353_29379[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___29365))
;
return ((function (switch__23913__auto__,c__23928__auto___29365){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_29357 = [null,null,null,null,null,null,null,null];
(statearr_29357[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_29357[(1)] = (1));

return statearr_29357;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_29337){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_29337);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e29358){if((e29358 instanceof Object)){
var ex__23917__auto__ = e29358;
var statearr_29359_29380 = state_29337;
(statearr_29359_29380[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29337);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29358;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29381 = state_29337;
state_29337 = G__29381;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_29337){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_29337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___29365))
})();
var state__23930__auto__ = (function (){var statearr_29360 = f__23929__auto__.call(null);
(statearr_29360[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___29365);

return statearr_29360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___29365))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__29565){
var vec__29566 = p__29565;
var v = cljs.core.nth.call(null,vec__29566,(0),null);
var p = cljs.core.nth.call(null,vec__29566,(1),null);
var job = vec__29566;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__23928__auto___29748 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___29748,res,vec__29566,v,p,job,jobs,results){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___29748,res,vec__29566,v,p,job,jobs,results){
return (function (state_29571){
var state_val_29572 = (state_29571[(1)]);
if((state_val_29572 === (1))){
var state_29571__$1 = state_29571;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29571__$1,(2),res,v);
} else {
if((state_val_29572 === (2))){
var inst_29568 = (state_29571[(2)]);
var inst_29569 = cljs.core.async.close_BANG_.call(null,res);
var state_29571__$1 = (function (){var statearr_29573 = state_29571;
(statearr_29573[(7)] = inst_29568);

return statearr_29573;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29571__$1,inst_29569);
} else {
return null;
}
}
});})(c__23928__auto___29748,res,vec__29566,v,p,job,jobs,results))
;
return ((function (switch__23913__auto__,c__23928__auto___29748,res,vec__29566,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_29577 = [null,null,null,null,null,null,null,null];
(statearr_29577[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__);

(statearr_29577[(1)] = (1));

return statearr_29577;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1 = (function (state_29571){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_29571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e29578){if((e29578 instanceof Object)){
var ex__23917__auto__ = e29578;
var statearr_29579_29749 = state_29571;
(statearr_29579_29749[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29571);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29578;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29750 = state_29571;
state_29571 = G__29750;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = function(state_29571){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1.call(this,state_29571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___29748,res,vec__29566,v,p,job,jobs,results))
})();
var state__23930__auto__ = (function (){var statearr_29580 = f__23929__auto__.call(null);
(statearr_29580[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___29748);

return statearr_29580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___29748,res,vec__29566,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29581){
var vec__29582 = p__29581;
var v = cljs.core.nth.call(null,vec__29582,(0),null);
var p = cljs.core.nth.call(null,vec__29582,(1),null);
var job = vec__29582;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__19373__auto___29751 = n;
var __29752 = (0);
while(true){
if((__29752 < n__19373__auto___29751)){
var G__29583_29753 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29583_29753) {
case "compute":
var c__23928__auto___29755 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29752,c__23928__auto___29755,G__29583_29753,n__19373__auto___29751,jobs,results,process,async){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (__29752,c__23928__auto___29755,G__29583_29753,n__19373__auto___29751,jobs,results,process,async){
return (function (state_29596){
var state_val_29597 = (state_29596[(1)]);
if((state_val_29597 === (1))){
var state_29596__$1 = state_29596;
var statearr_29598_29756 = state_29596__$1;
(statearr_29598_29756[(2)] = null);

(statearr_29598_29756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29597 === (2))){
var state_29596__$1 = state_29596;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29596__$1,(4),jobs);
} else {
if((state_val_29597 === (3))){
var inst_29594 = (state_29596[(2)]);
var state_29596__$1 = state_29596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29596__$1,inst_29594);
} else {
if((state_val_29597 === (4))){
var inst_29586 = (state_29596[(2)]);
var inst_29587 = process.call(null,inst_29586);
var state_29596__$1 = state_29596;
if(cljs.core.truth_(inst_29587)){
var statearr_29599_29757 = state_29596__$1;
(statearr_29599_29757[(1)] = (5));

} else {
var statearr_29600_29758 = state_29596__$1;
(statearr_29600_29758[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29597 === (5))){
var state_29596__$1 = state_29596;
var statearr_29601_29759 = state_29596__$1;
(statearr_29601_29759[(2)] = null);

(statearr_29601_29759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29597 === (6))){
var state_29596__$1 = state_29596;
var statearr_29602_29760 = state_29596__$1;
(statearr_29602_29760[(2)] = null);

(statearr_29602_29760[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29597 === (7))){
var inst_29592 = (state_29596[(2)]);
var state_29596__$1 = state_29596;
var statearr_29603_29761 = state_29596__$1;
(statearr_29603_29761[(2)] = inst_29592);

(statearr_29603_29761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29752,c__23928__auto___29755,G__29583_29753,n__19373__auto___29751,jobs,results,process,async))
;
return ((function (__29752,switch__23913__auto__,c__23928__auto___29755,G__29583_29753,n__19373__auto___29751,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_29607 = [null,null,null,null,null,null,null];
(statearr_29607[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__);

(statearr_29607[(1)] = (1));

return statearr_29607;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1 = (function (state_29596){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_29596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e29608){if((e29608 instanceof Object)){
var ex__23917__auto__ = e29608;
var statearr_29609_29762 = state_29596;
(statearr_29609_29762[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29596);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29608;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29763 = state_29596;
state_29596 = G__29763;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = function(state_29596){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1.call(this,state_29596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__;
})()
;})(__29752,switch__23913__auto__,c__23928__auto___29755,G__29583_29753,n__19373__auto___29751,jobs,results,process,async))
})();
var state__23930__auto__ = (function (){var statearr_29610 = f__23929__auto__.call(null);
(statearr_29610[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___29755);

return statearr_29610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(__29752,c__23928__auto___29755,G__29583_29753,n__19373__auto___29751,jobs,results,process,async))
);


break;
case "async":
var c__23928__auto___29764 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29752,c__23928__auto___29764,G__29583_29753,n__19373__auto___29751,jobs,results,process,async){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (__29752,c__23928__auto___29764,G__29583_29753,n__19373__auto___29751,jobs,results,process,async){
return (function (state_29623){
var state_val_29624 = (state_29623[(1)]);
if((state_val_29624 === (1))){
var state_29623__$1 = state_29623;
var statearr_29625_29765 = state_29623__$1;
(statearr_29625_29765[(2)] = null);

(statearr_29625_29765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29624 === (2))){
var state_29623__$1 = state_29623;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29623__$1,(4),jobs);
} else {
if((state_val_29624 === (3))){
var inst_29621 = (state_29623[(2)]);
var state_29623__$1 = state_29623;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29623__$1,inst_29621);
} else {
if((state_val_29624 === (4))){
var inst_29613 = (state_29623[(2)]);
var inst_29614 = async.call(null,inst_29613);
var state_29623__$1 = state_29623;
if(cljs.core.truth_(inst_29614)){
var statearr_29626_29766 = state_29623__$1;
(statearr_29626_29766[(1)] = (5));

} else {
var statearr_29627_29767 = state_29623__$1;
(statearr_29627_29767[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29624 === (5))){
var state_29623__$1 = state_29623;
var statearr_29628_29768 = state_29623__$1;
(statearr_29628_29768[(2)] = null);

(statearr_29628_29768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29624 === (6))){
var state_29623__$1 = state_29623;
var statearr_29629_29769 = state_29623__$1;
(statearr_29629_29769[(2)] = null);

(statearr_29629_29769[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29624 === (7))){
var inst_29619 = (state_29623[(2)]);
var state_29623__$1 = state_29623;
var statearr_29630_29770 = state_29623__$1;
(statearr_29630_29770[(2)] = inst_29619);

(statearr_29630_29770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29752,c__23928__auto___29764,G__29583_29753,n__19373__auto___29751,jobs,results,process,async))
;
return ((function (__29752,switch__23913__auto__,c__23928__auto___29764,G__29583_29753,n__19373__auto___29751,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_29634 = [null,null,null,null,null,null,null];
(statearr_29634[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__);

(statearr_29634[(1)] = (1));

return statearr_29634;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1 = (function (state_29623){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_29623);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e29635){if((e29635 instanceof Object)){
var ex__23917__auto__ = e29635;
var statearr_29636_29771 = state_29623;
(statearr_29636_29771[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29623);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29635;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29772 = state_29623;
state_29623 = G__29772;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = function(state_29623){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1.call(this,state_29623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__;
})()
;})(__29752,switch__23913__auto__,c__23928__auto___29764,G__29583_29753,n__19373__auto___29751,jobs,results,process,async))
})();
var state__23930__auto__ = (function (){var statearr_29637 = f__23929__auto__.call(null);
(statearr_29637[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___29764);

return statearr_29637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(__29752,c__23928__auto___29764,G__29583_29753,n__19373__auto___29751,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__29773 = (__29752 + (1));
__29752 = G__29773;
continue;
} else {
}
break;
}

var c__23928__auto___29774 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___29774,jobs,results,process,async){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___29774,jobs,results,process,async){
return (function (state_29659){
var state_val_29660 = (state_29659[(1)]);
if((state_val_29660 === (1))){
var state_29659__$1 = state_29659;
var statearr_29661_29775 = state_29659__$1;
(statearr_29661_29775[(2)] = null);

(statearr_29661_29775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29660 === (2))){
var state_29659__$1 = state_29659;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29659__$1,(4),from);
} else {
if((state_val_29660 === (3))){
var inst_29657 = (state_29659[(2)]);
var state_29659__$1 = state_29659;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29659__$1,inst_29657);
} else {
if((state_val_29660 === (4))){
var inst_29640 = (state_29659[(7)]);
var inst_29640__$1 = (state_29659[(2)]);
var inst_29641 = (inst_29640__$1 == null);
var state_29659__$1 = (function (){var statearr_29662 = state_29659;
(statearr_29662[(7)] = inst_29640__$1);

return statearr_29662;
})();
if(cljs.core.truth_(inst_29641)){
var statearr_29663_29776 = state_29659__$1;
(statearr_29663_29776[(1)] = (5));

} else {
var statearr_29664_29777 = state_29659__$1;
(statearr_29664_29777[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29660 === (5))){
var inst_29643 = cljs.core.async.close_BANG_.call(null,jobs);
var state_29659__$1 = state_29659;
var statearr_29665_29778 = state_29659__$1;
(statearr_29665_29778[(2)] = inst_29643);

(statearr_29665_29778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29660 === (6))){
var inst_29645 = (state_29659[(8)]);
var inst_29640 = (state_29659[(7)]);
var inst_29645__$1 = cljs.core.async.chan.call(null,(1));
var inst_29646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29647 = [inst_29640,inst_29645__$1];
var inst_29648 = (new cljs.core.PersistentVector(null,2,(5),inst_29646,inst_29647,null));
var state_29659__$1 = (function (){var statearr_29666 = state_29659;
(statearr_29666[(8)] = inst_29645__$1);

return statearr_29666;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29659__$1,(8),jobs,inst_29648);
} else {
if((state_val_29660 === (7))){
var inst_29655 = (state_29659[(2)]);
var state_29659__$1 = state_29659;
var statearr_29667_29779 = state_29659__$1;
(statearr_29667_29779[(2)] = inst_29655);

(statearr_29667_29779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29660 === (8))){
var inst_29645 = (state_29659[(8)]);
var inst_29650 = (state_29659[(2)]);
var state_29659__$1 = (function (){var statearr_29668 = state_29659;
(statearr_29668[(9)] = inst_29650);

return statearr_29668;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29659__$1,(9),results,inst_29645);
} else {
if((state_val_29660 === (9))){
var inst_29652 = (state_29659[(2)]);
var state_29659__$1 = (function (){var statearr_29669 = state_29659;
(statearr_29669[(10)] = inst_29652);

return statearr_29669;
})();
var statearr_29670_29780 = state_29659__$1;
(statearr_29670_29780[(2)] = null);

(statearr_29670_29780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___29774,jobs,results,process,async))
;
return ((function (switch__23913__auto__,c__23928__auto___29774,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_29674 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29674[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__);

(statearr_29674[(1)] = (1));

return statearr_29674;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1 = (function (state_29659){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_29659);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e29675){if((e29675 instanceof Object)){
var ex__23917__auto__ = e29675;
var statearr_29676_29781 = state_29659;
(statearr_29676_29781[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29659);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29675;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29782 = state_29659;
state_29659 = G__29782;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = function(state_29659){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1.call(this,state_29659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___29774,jobs,results,process,async))
})();
var state__23930__auto__ = (function (){var statearr_29677 = f__23929__auto__.call(null);
(statearr_29677[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___29774);

return statearr_29677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___29774,jobs,results,process,async))
);


var c__23928__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto__,jobs,results,process,async){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto__,jobs,results,process,async){
return (function (state_29715){
var state_val_29716 = (state_29715[(1)]);
if((state_val_29716 === (7))){
var inst_29711 = (state_29715[(2)]);
var state_29715__$1 = state_29715;
var statearr_29717_29783 = state_29715__$1;
(statearr_29717_29783[(2)] = inst_29711);

(statearr_29717_29783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (20))){
var state_29715__$1 = state_29715;
var statearr_29718_29784 = state_29715__$1;
(statearr_29718_29784[(2)] = null);

(statearr_29718_29784[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (1))){
var state_29715__$1 = state_29715;
var statearr_29719_29785 = state_29715__$1;
(statearr_29719_29785[(2)] = null);

(statearr_29719_29785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (4))){
var inst_29680 = (state_29715[(7)]);
var inst_29680__$1 = (state_29715[(2)]);
var inst_29681 = (inst_29680__$1 == null);
var state_29715__$1 = (function (){var statearr_29720 = state_29715;
(statearr_29720[(7)] = inst_29680__$1);

return statearr_29720;
})();
if(cljs.core.truth_(inst_29681)){
var statearr_29721_29786 = state_29715__$1;
(statearr_29721_29786[(1)] = (5));

} else {
var statearr_29722_29787 = state_29715__$1;
(statearr_29722_29787[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (15))){
var inst_29693 = (state_29715[(8)]);
var state_29715__$1 = state_29715;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29715__$1,(18),to,inst_29693);
} else {
if((state_val_29716 === (21))){
var inst_29706 = (state_29715[(2)]);
var state_29715__$1 = state_29715;
var statearr_29723_29788 = state_29715__$1;
(statearr_29723_29788[(2)] = inst_29706);

(statearr_29723_29788[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (13))){
var inst_29708 = (state_29715[(2)]);
var state_29715__$1 = (function (){var statearr_29724 = state_29715;
(statearr_29724[(9)] = inst_29708);

return statearr_29724;
})();
var statearr_29725_29789 = state_29715__$1;
(statearr_29725_29789[(2)] = null);

(statearr_29725_29789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (6))){
var inst_29680 = (state_29715[(7)]);
var state_29715__$1 = state_29715;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29715__$1,(11),inst_29680);
} else {
if((state_val_29716 === (17))){
var inst_29701 = (state_29715[(2)]);
var state_29715__$1 = state_29715;
if(cljs.core.truth_(inst_29701)){
var statearr_29726_29790 = state_29715__$1;
(statearr_29726_29790[(1)] = (19));

} else {
var statearr_29727_29791 = state_29715__$1;
(statearr_29727_29791[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (3))){
var inst_29713 = (state_29715[(2)]);
var state_29715__$1 = state_29715;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29715__$1,inst_29713);
} else {
if((state_val_29716 === (12))){
var inst_29690 = (state_29715[(10)]);
var state_29715__$1 = state_29715;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29715__$1,(14),inst_29690);
} else {
if((state_val_29716 === (2))){
var state_29715__$1 = state_29715;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29715__$1,(4),results);
} else {
if((state_val_29716 === (19))){
var state_29715__$1 = state_29715;
var statearr_29728_29792 = state_29715__$1;
(statearr_29728_29792[(2)] = null);

(statearr_29728_29792[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (11))){
var inst_29690 = (state_29715[(2)]);
var state_29715__$1 = (function (){var statearr_29729 = state_29715;
(statearr_29729[(10)] = inst_29690);

return statearr_29729;
})();
var statearr_29730_29793 = state_29715__$1;
(statearr_29730_29793[(2)] = null);

(statearr_29730_29793[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (9))){
var state_29715__$1 = state_29715;
var statearr_29731_29794 = state_29715__$1;
(statearr_29731_29794[(2)] = null);

(statearr_29731_29794[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (5))){
var state_29715__$1 = state_29715;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29732_29795 = state_29715__$1;
(statearr_29732_29795[(1)] = (8));

} else {
var statearr_29733_29796 = state_29715__$1;
(statearr_29733_29796[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (14))){
var inst_29693 = (state_29715[(8)]);
var inst_29695 = (state_29715[(11)]);
var inst_29693__$1 = (state_29715[(2)]);
var inst_29694 = (inst_29693__$1 == null);
var inst_29695__$1 = cljs.core.not.call(null,inst_29694);
var state_29715__$1 = (function (){var statearr_29734 = state_29715;
(statearr_29734[(8)] = inst_29693__$1);

(statearr_29734[(11)] = inst_29695__$1);

return statearr_29734;
})();
if(inst_29695__$1){
var statearr_29735_29797 = state_29715__$1;
(statearr_29735_29797[(1)] = (15));

} else {
var statearr_29736_29798 = state_29715__$1;
(statearr_29736_29798[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (16))){
var inst_29695 = (state_29715[(11)]);
var state_29715__$1 = state_29715;
var statearr_29737_29799 = state_29715__$1;
(statearr_29737_29799[(2)] = inst_29695);

(statearr_29737_29799[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (10))){
var inst_29687 = (state_29715[(2)]);
var state_29715__$1 = state_29715;
var statearr_29738_29800 = state_29715__$1;
(statearr_29738_29800[(2)] = inst_29687);

(statearr_29738_29800[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (18))){
var inst_29698 = (state_29715[(2)]);
var state_29715__$1 = state_29715;
var statearr_29739_29801 = state_29715__$1;
(statearr_29739_29801[(2)] = inst_29698);

(statearr_29739_29801[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29716 === (8))){
var inst_29684 = cljs.core.async.close_BANG_.call(null,to);
var state_29715__$1 = state_29715;
var statearr_29740_29802 = state_29715__$1;
(statearr_29740_29802[(2)] = inst_29684);

(statearr_29740_29802[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto__,jobs,results,process,async))
;
return ((function (switch__23913__auto__,c__23928__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_29744 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29744[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__);

(statearr_29744[(1)] = (1));

return statearr_29744;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1 = (function (state_29715){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_29715);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e29745){if((e29745 instanceof Object)){
var ex__23917__auto__ = e29745;
var statearr_29746_29803 = state_29715;
(statearr_29746_29803[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29715);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29745;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29804 = state_29715;
state_29715 = G__29804;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = function(state_29715){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1.call(this,state_29715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto__,jobs,results,process,async))
})();
var state__23930__auto__ = (function (){var statearr_29747 = f__23929__auto__.call(null);
(statearr_29747[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto__);

return statearr_29747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto__,jobs,results,process,async))
);

return c__23928__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var args29805 = [];
var len__19528__auto___29808 = arguments.length;
var i__19529__auto___29809 = (0);
while(true){
if((i__19529__auto___29809 < len__19528__auto___29808)){
args29805.push((arguments[i__19529__auto___29809]));

var G__29810 = (i__19529__auto___29809 + (1));
i__19529__auto___29809 = G__29810;
continue;
} else {
}
break;
}

var G__29807 = args29805.length;
switch (G__29807) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29805.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var args29812 = [];
var len__19528__auto___29815 = arguments.length;
var i__19529__auto___29816 = (0);
while(true){
if((i__19529__auto___29816 < len__19528__auto___29815)){
args29812.push((arguments[i__19529__auto___29816]));

var G__29817 = (i__19529__auto___29816 + (1));
i__19529__auto___29816 = G__29817;
continue;
} else {
}
break;
}

var G__29814 = args29812.length;
switch (G__29814) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29812.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var args29819 = [];
var len__19528__auto___29872 = arguments.length;
var i__19529__auto___29873 = (0);
while(true){
if((i__19529__auto___29873 < len__19528__auto___29872)){
args29819.push((arguments[i__19529__auto___29873]));

var G__29874 = (i__19529__auto___29873 + (1));
i__19529__auto___29873 = G__29874;
continue;
} else {
}
break;
}

var G__29821 = args29819.length;
switch (G__29821) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29819.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__23928__auto___29876 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___29876,tc,fc){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___29876,tc,fc){
return (function (state_29847){
var state_val_29848 = (state_29847[(1)]);
if((state_val_29848 === (7))){
var inst_29843 = (state_29847[(2)]);
var state_29847__$1 = state_29847;
var statearr_29849_29877 = state_29847__$1;
(statearr_29849_29877[(2)] = inst_29843);

(statearr_29849_29877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29848 === (1))){
var state_29847__$1 = state_29847;
var statearr_29850_29878 = state_29847__$1;
(statearr_29850_29878[(2)] = null);

(statearr_29850_29878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29848 === (4))){
var inst_29824 = (state_29847[(7)]);
var inst_29824__$1 = (state_29847[(2)]);
var inst_29825 = (inst_29824__$1 == null);
var state_29847__$1 = (function (){var statearr_29851 = state_29847;
(statearr_29851[(7)] = inst_29824__$1);

return statearr_29851;
})();
if(cljs.core.truth_(inst_29825)){
var statearr_29852_29879 = state_29847__$1;
(statearr_29852_29879[(1)] = (5));

} else {
var statearr_29853_29880 = state_29847__$1;
(statearr_29853_29880[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29848 === (13))){
var state_29847__$1 = state_29847;
var statearr_29854_29881 = state_29847__$1;
(statearr_29854_29881[(2)] = null);

(statearr_29854_29881[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29848 === (6))){
var inst_29824 = (state_29847[(7)]);
var inst_29830 = p.call(null,inst_29824);
var state_29847__$1 = state_29847;
if(cljs.core.truth_(inst_29830)){
var statearr_29855_29882 = state_29847__$1;
(statearr_29855_29882[(1)] = (9));

} else {
var statearr_29856_29883 = state_29847__$1;
(statearr_29856_29883[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29848 === (3))){
var inst_29845 = (state_29847[(2)]);
var state_29847__$1 = state_29847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29847__$1,inst_29845);
} else {
if((state_val_29848 === (12))){
var state_29847__$1 = state_29847;
var statearr_29857_29884 = state_29847__$1;
(statearr_29857_29884[(2)] = null);

(statearr_29857_29884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29848 === (2))){
var state_29847__$1 = state_29847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29847__$1,(4),ch);
} else {
if((state_val_29848 === (11))){
var inst_29824 = (state_29847[(7)]);
var inst_29834 = (state_29847[(2)]);
var state_29847__$1 = state_29847;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29847__$1,(8),inst_29834,inst_29824);
} else {
if((state_val_29848 === (9))){
var state_29847__$1 = state_29847;
var statearr_29858_29885 = state_29847__$1;
(statearr_29858_29885[(2)] = tc);

(statearr_29858_29885[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29848 === (5))){
var inst_29827 = cljs.core.async.close_BANG_.call(null,tc);
var inst_29828 = cljs.core.async.close_BANG_.call(null,fc);
var state_29847__$1 = (function (){var statearr_29859 = state_29847;
(statearr_29859[(8)] = inst_29827);

return statearr_29859;
})();
var statearr_29860_29886 = state_29847__$1;
(statearr_29860_29886[(2)] = inst_29828);

(statearr_29860_29886[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29848 === (14))){
var inst_29841 = (state_29847[(2)]);
var state_29847__$1 = state_29847;
var statearr_29861_29887 = state_29847__$1;
(statearr_29861_29887[(2)] = inst_29841);

(statearr_29861_29887[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29848 === (10))){
var state_29847__$1 = state_29847;
var statearr_29862_29888 = state_29847__$1;
(statearr_29862_29888[(2)] = fc);

(statearr_29862_29888[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29848 === (8))){
var inst_29836 = (state_29847[(2)]);
var state_29847__$1 = state_29847;
if(cljs.core.truth_(inst_29836)){
var statearr_29863_29889 = state_29847__$1;
(statearr_29863_29889[(1)] = (12));

} else {
var statearr_29864_29890 = state_29847__$1;
(statearr_29864_29890[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___29876,tc,fc))
;
return ((function (switch__23913__auto__,c__23928__auto___29876,tc,fc){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_29868 = [null,null,null,null,null,null,null,null,null];
(statearr_29868[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_29868[(1)] = (1));

return statearr_29868;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_29847){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_29847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e29869){if((e29869 instanceof Object)){
var ex__23917__auto__ = e29869;
var statearr_29870_29891 = state_29847;
(statearr_29870_29891[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29869;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29892 = state_29847;
state_29847 = G__29892;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_29847){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_29847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___29876,tc,fc))
})();
var state__23930__auto__ = (function (){var statearr_29871 = f__23929__auto__.call(null);
(statearr_29871[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___29876);

return statearr_29871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___29876,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__23928__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto__){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto__){
return (function (state_29939){
var state_val_29940 = (state_29939[(1)]);
if((state_val_29940 === (1))){
var inst_29925 = init;
var state_29939__$1 = (function (){var statearr_29941 = state_29939;
(statearr_29941[(7)] = inst_29925);

return statearr_29941;
})();
var statearr_29942_29957 = state_29939__$1;
(statearr_29942_29957[(2)] = null);

(statearr_29942_29957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29940 === (2))){
var state_29939__$1 = state_29939;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29939__$1,(4),ch);
} else {
if((state_val_29940 === (3))){
var inst_29937 = (state_29939[(2)]);
var state_29939__$1 = state_29939;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29939__$1,inst_29937);
} else {
if((state_val_29940 === (4))){
var inst_29928 = (state_29939[(8)]);
var inst_29928__$1 = (state_29939[(2)]);
var inst_29929 = (inst_29928__$1 == null);
var state_29939__$1 = (function (){var statearr_29943 = state_29939;
(statearr_29943[(8)] = inst_29928__$1);

return statearr_29943;
})();
if(cljs.core.truth_(inst_29929)){
var statearr_29944_29958 = state_29939__$1;
(statearr_29944_29958[(1)] = (5));

} else {
var statearr_29945_29959 = state_29939__$1;
(statearr_29945_29959[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29940 === (5))){
var inst_29925 = (state_29939[(7)]);
var state_29939__$1 = state_29939;
var statearr_29946_29960 = state_29939__$1;
(statearr_29946_29960[(2)] = inst_29925);

(statearr_29946_29960[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29940 === (6))){
var inst_29928 = (state_29939[(8)]);
var inst_29925 = (state_29939[(7)]);
var inst_29932 = f.call(null,inst_29925,inst_29928);
var inst_29925__$1 = inst_29932;
var state_29939__$1 = (function (){var statearr_29947 = state_29939;
(statearr_29947[(7)] = inst_29925__$1);

return statearr_29947;
})();
var statearr_29948_29961 = state_29939__$1;
(statearr_29948_29961[(2)] = null);

(statearr_29948_29961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29940 === (7))){
var inst_29935 = (state_29939[(2)]);
var state_29939__$1 = state_29939;
var statearr_29949_29962 = state_29939__$1;
(statearr_29949_29962[(2)] = inst_29935);

(statearr_29949_29962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23928__auto__))
;
return ((function (switch__23913__auto__,c__23928__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__23914__auto__ = null;
var cljs$core$async$reduce_$_state_machine__23914__auto____0 = (function (){
var statearr_29953 = [null,null,null,null,null,null,null,null,null];
(statearr_29953[(0)] = cljs$core$async$reduce_$_state_machine__23914__auto__);

(statearr_29953[(1)] = (1));

return statearr_29953;
});
var cljs$core$async$reduce_$_state_machine__23914__auto____1 = (function (state_29939){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_29939);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e29954){if((e29954 instanceof Object)){
var ex__23917__auto__ = e29954;
var statearr_29955_29963 = state_29939;
(statearr_29955_29963[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29939);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29954;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29964 = state_29939;
state_29939 = G__29964;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__23914__auto__ = function(state_29939){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__23914__auto____1.call(this,state_29939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__23914__auto____0;
cljs$core$async$reduce_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__23914__auto____1;
return cljs$core$async$reduce_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto__))
})();
var state__23930__auto__ = (function (){var statearr_29956 = f__23929__auto__.call(null);
(statearr_29956[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto__);

return statearr_29956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto__))
);

return c__23928__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var args29965 = [];
var len__19528__auto___30017 = arguments.length;
var i__19529__auto___30018 = (0);
while(true){
if((i__19529__auto___30018 < len__19528__auto___30017)){
args29965.push((arguments[i__19529__auto___30018]));

var G__30019 = (i__19529__auto___30018 + (1));
i__19529__auto___30018 = G__30019;
continue;
} else {
}
break;
}

var G__29967 = args29965.length;
switch (G__29967) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29965.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__23928__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto__){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto__){
return (function (state_29992){
var state_val_29993 = (state_29992[(1)]);
if((state_val_29993 === (7))){
var inst_29974 = (state_29992[(2)]);
var state_29992__$1 = state_29992;
var statearr_29994_30021 = state_29992__$1;
(statearr_29994_30021[(2)] = inst_29974);

(statearr_29994_30021[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29993 === (1))){
var inst_29968 = cljs.core.seq.call(null,coll);
var inst_29969 = inst_29968;
var state_29992__$1 = (function (){var statearr_29995 = state_29992;
(statearr_29995[(7)] = inst_29969);

return statearr_29995;
})();
var statearr_29996_30022 = state_29992__$1;
(statearr_29996_30022[(2)] = null);

(statearr_29996_30022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29993 === (4))){
var inst_29969 = (state_29992[(7)]);
var inst_29972 = cljs.core.first.call(null,inst_29969);
var state_29992__$1 = state_29992;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29992__$1,(7),ch,inst_29972);
} else {
if((state_val_29993 === (13))){
var inst_29986 = (state_29992[(2)]);
var state_29992__$1 = state_29992;
var statearr_29997_30023 = state_29992__$1;
(statearr_29997_30023[(2)] = inst_29986);

(statearr_29997_30023[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29993 === (6))){
var inst_29977 = (state_29992[(2)]);
var state_29992__$1 = state_29992;
if(cljs.core.truth_(inst_29977)){
var statearr_29998_30024 = state_29992__$1;
(statearr_29998_30024[(1)] = (8));

} else {
var statearr_29999_30025 = state_29992__$1;
(statearr_29999_30025[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29993 === (3))){
var inst_29990 = (state_29992[(2)]);
var state_29992__$1 = state_29992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29992__$1,inst_29990);
} else {
if((state_val_29993 === (12))){
var state_29992__$1 = state_29992;
var statearr_30000_30026 = state_29992__$1;
(statearr_30000_30026[(2)] = null);

(statearr_30000_30026[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29993 === (2))){
var inst_29969 = (state_29992[(7)]);
var state_29992__$1 = state_29992;
if(cljs.core.truth_(inst_29969)){
var statearr_30001_30027 = state_29992__$1;
(statearr_30001_30027[(1)] = (4));

} else {
var statearr_30002_30028 = state_29992__$1;
(statearr_30002_30028[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29993 === (11))){
var inst_29983 = cljs.core.async.close_BANG_.call(null,ch);
var state_29992__$1 = state_29992;
var statearr_30003_30029 = state_29992__$1;
(statearr_30003_30029[(2)] = inst_29983);

(statearr_30003_30029[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29993 === (9))){
var state_29992__$1 = state_29992;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30004_30030 = state_29992__$1;
(statearr_30004_30030[(1)] = (11));

} else {
var statearr_30005_30031 = state_29992__$1;
(statearr_30005_30031[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29993 === (5))){
var inst_29969 = (state_29992[(7)]);
var state_29992__$1 = state_29992;
var statearr_30006_30032 = state_29992__$1;
(statearr_30006_30032[(2)] = inst_29969);

(statearr_30006_30032[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29993 === (10))){
var inst_29988 = (state_29992[(2)]);
var state_29992__$1 = state_29992;
var statearr_30007_30033 = state_29992__$1;
(statearr_30007_30033[(2)] = inst_29988);

(statearr_30007_30033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29993 === (8))){
var inst_29969 = (state_29992[(7)]);
var inst_29979 = cljs.core.next.call(null,inst_29969);
var inst_29969__$1 = inst_29979;
var state_29992__$1 = (function (){var statearr_30008 = state_29992;
(statearr_30008[(7)] = inst_29969__$1);

return statearr_30008;
})();
var statearr_30009_30034 = state_29992__$1;
(statearr_30009_30034[(2)] = null);

(statearr_30009_30034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto__))
;
return ((function (switch__23913__auto__,c__23928__auto__){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_30013 = [null,null,null,null,null,null,null,null];
(statearr_30013[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_30013[(1)] = (1));

return statearr_30013;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_29992){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_29992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e30014){if((e30014 instanceof Object)){
var ex__23917__auto__ = e30014;
var statearr_30015_30035 = state_29992;
(statearr_30015_30035[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29992);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30014;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30036 = state_29992;
state_29992 = G__30036;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_29992){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_29992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto__))
})();
var state__23930__auto__ = (function (){var statearr_30016 = f__23929__auto__.call(null);
(statearr_30016[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto__);

return statearr_30016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto__))
);

return c__23928__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = {};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__19125__auto__ = (((_ == null))?null:_);
var m__19126__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,_);
} else {
var m__19126__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


cljs.core.async.Mult = {};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__19126__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,ch);
} else {
var m__19126__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m);
} else {
var m__19126__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t30262 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30262 = (function (mult,ch,cs,meta30263){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta30263 = meta30263;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30262.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30264,meta30263__$1){
var self__ = this;
var _30264__$1 = this;
return (new cljs.core.async.t30262(self__.mult,self__.ch,self__.cs,meta30263__$1));
});})(cs))
;

cljs.core.async.t30262.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30264){
var self__ = this;
var _30264__$1 = this;
return self__.meta30263;
});})(cs))
;

cljs.core.async.t30262.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30262.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t30262.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t30262.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t30262.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t30262.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t30262.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30263","meta30263",-1055754719,null)], null);
});})(cs))
;

cljs.core.async.t30262.cljs$lang$type = true;

cljs.core.async.t30262.cljs$lang$ctorStr = "cljs.core.async/t30262";

cljs.core.async.t30262.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t30262");
});})(cs))
;

cljs.core.async.__GT_t30262 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t30262(mult__$1,ch__$1,cs__$1,meta30263){
return (new cljs.core.async.t30262(mult__$1,ch__$1,cs__$1,meta30263));
});})(cs))
;

}

return (new cljs.core.async.t30262(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__23928__auto___30483 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___30483,cs,m,dchan,dctr,done){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___30483,cs,m,dchan,dctr,done){
return (function (state_30395){
var state_val_30396 = (state_30395[(1)]);
if((state_val_30396 === (7))){
var inst_30391 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30397_30484 = state_30395__$1;
(statearr_30397_30484[(2)] = inst_30391);

(statearr_30397_30484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (20))){
var inst_30296 = (state_30395[(7)]);
var inst_30306 = cljs.core.first.call(null,inst_30296);
var inst_30307 = cljs.core.nth.call(null,inst_30306,(0),null);
var inst_30308 = cljs.core.nth.call(null,inst_30306,(1),null);
var state_30395__$1 = (function (){var statearr_30398 = state_30395;
(statearr_30398[(8)] = inst_30307);

return statearr_30398;
})();
if(cljs.core.truth_(inst_30308)){
var statearr_30399_30485 = state_30395__$1;
(statearr_30399_30485[(1)] = (22));

} else {
var statearr_30400_30486 = state_30395__$1;
(statearr_30400_30486[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (27))){
var inst_30343 = (state_30395[(9)]);
var inst_30338 = (state_30395[(10)]);
var inst_30336 = (state_30395[(11)]);
var inst_30267 = (state_30395[(12)]);
var inst_30343__$1 = cljs.core._nth.call(null,inst_30336,inst_30338);
var inst_30344 = cljs.core.async.put_BANG_.call(null,inst_30343__$1,inst_30267,done);
var state_30395__$1 = (function (){var statearr_30401 = state_30395;
(statearr_30401[(9)] = inst_30343__$1);

return statearr_30401;
})();
if(cljs.core.truth_(inst_30344)){
var statearr_30402_30487 = state_30395__$1;
(statearr_30402_30487[(1)] = (30));

} else {
var statearr_30403_30488 = state_30395__$1;
(statearr_30403_30488[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (1))){
var state_30395__$1 = state_30395;
var statearr_30404_30489 = state_30395__$1;
(statearr_30404_30489[(2)] = null);

(statearr_30404_30489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (24))){
var inst_30296 = (state_30395[(7)]);
var inst_30313 = (state_30395[(2)]);
var inst_30314 = cljs.core.next.call(null,inst_30296);
var inst_30276 = inst_30314;
var inst_30277 = null;
var inst_30278 = (0);
var inst_30279 = (0);
var state_30395__$1 = (function (){var statearr_30405 = state_30395;
(statearr_30405[(13)] = inst_30278);

(statearr_30405[(14)] = inst_30277);

(statearr_30405[(15)] = inst_30279);

(statearr_30405[(16)] = inst_30276);

(statearr_30405[(17)] = inst_30313);

return statearr_30405;
})();
var statearr_30406_30490 = state_30395__$1;
(statearr_30406_30490[(2)] = null);

(statearr_30406_30490[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (39))){
var state_30395__$1 = state_30395;
var statearr_30410_30491 = state_30395__$1;
(statearr_30410_30491[(2)] = null);

(statearr_30410_30491[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (4))){
var inst_30267 = (state_30395[(12)]);
var inst_30267__$1 = (state_30395[(2)]);
var inst_30268 = (inst_30267__$1 == null);
var state_30395__$1 = (function (){var statearr_30411 = state_30395;
(statearr_30411[(12)] = inst_30267__$1);

return statearr_30411;
})();
if(cljs.core.truth_(inst_30268)){
var statearr_30412_30492 = state_30395__$1;
(statearr_30412_30492[(1)] = (5));

} else {
var statearr_30413_30493 = state_30395__$1;
(statearr_30413_30493[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (15))){
var inst_30278 = (state_30395[(13)]);
var inst_30277 = (state_30395[(14)]);
var inst_30279 = (state_30395[(15)]);
var inst_30276 = (state_30395[(16)]);
var inst_30292 = (state_30395[(2)]);
var inst_30293 = (inst_30279 + (1));
var tmp30407 = inst_30278;
var tmp30408 = inst_30277;
var tmp30409 = inst_30276;
var inst_30276__$1 = tmp30409;
var inst_30277__$1 = tmp30408;
var inst_30278__$1 = tmp30407;
var inst_30279__$1 = inst_30293;
var state_30395__$1 = (function (){var statearr_30414 = state_30395;
(statearr_30414[(13)] = inst_30278__$1);

(statearr_30414[(14)] = inst_30277__$1);

(statearr_30414[(15)] = inst_30279__$1);

(statearr_30414[(16)] = inst_30276__$1);

(statearr_30414[(18)] = inst_30292);

return statearr_30414;
})();
var statearr_30415_30494 = state_30395__$1;
(statearr_30415_30494[(2)] = null);

(statearr_30415_30494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (21))){
var inst_30317 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30419_30495 = state_30395__$1;
(statearr_30419_30495[(2)] = inst_30317);

(statearr_30419_30495[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (31))){
var inst_30343 = (state_30395[(9)]);
var inst_30347 = done.call(null,null);
var inst_30348 = cljs.core.async.untap_STAR_.call(null,m,inst_30343);
var state_30395__$1 = (function (){var statearr_30420 = state_30395;
(statearr_30420[(19)] = inst_30347);

return statearr_30420;
})();
var statearr_30421_30496 = state_30395__$1;
(statearr_30421_30496[(2)] = inst_30348);

(statearr_30421_30496[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (32))){
var inst_30335 = (state_30395[(20)]);
var inst_30337 = (state_30395[(21)]);
var inst_30338 = (state_30395[(10)]);
var inst_30336 = (state_30395[(11)]);
var inst_30350 = (state_30395[(2)]);
var inst_30351 = (inst_30338 + (1));
var tmp30416 = inst_30335;
var tmp30417 = inst_30337;
var tmp30418 = inst_30336;
var inst_30335__$1 = tmp30416;
var inst_30336__$1 = tmp30418;
var inst_30337__$1 = tmp30417;
var inst_30338__$1 = inst_30351;
var state_30395__$1 = (function (){var statearr_30422 = state_30395;
(statearr_30422[(20)] = inst_30335__$1);

(statearr_30422[(21)] = inst_30337__$1);

(statearr_30422[(22)] = inst_30350);

(statearr_30422[(10)] = inst_30338__$1);

(statearr_30422[(11)] = inst_30336__$1);

return statearr_30422;
})();
var statearr_30423_30497 = state_30395__$1;
(statearr_30423_30497[(2)] = null);

(statearr_30423_30497[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (40))){
var inst_30363 = (state_30395[(23)]);
var inst_30367 = done.call(null,null);
var inst_30368 = cljs.core.async.untap_STAR_.call(null,m,inst_30363);
var state_30395__$1 = (function (){var statearr_30424 = state_30395;
(statearr_30424[(24)] = inst_30367);

return statearr_30424;
})();
var statearr_30425_30498 = state_30395__$1;
(statearr_30425_30498[(2)] = inst_30368);

(statearr_30425_30498[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (33))){
var inst_30354 = (state_30395[(25)]);
var inst_30356 = cljs.core.chunked_seq_QMARK_.call(null,inst_30354);
var state_30395__$1 = state_30395;
if(inst_30356){
var statearr_30426_30499 = state_30395__$1;
(statearr_30426_30499[(1)] = (36));

} else {
var statearr_30427_30500 = state_30395__$1;
(statearr_30427_30500[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (13))){
var inst_30286 = (state_30395[(26)]);
var inst_30289 = cljs.core.async.close_BANG_.call(null,inst_30286);
var state_30395__$1 = state_30395;
var statearr_30428_30501 = state_30395__$1;
(statearr_30428_30501[(2)] = inst_30289);

(statearr_30428_30501[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (22))){
var inst_30307 = (state_30395[(8)]);
var inst_30310 = cljs.core.async.close_BANG_.call(null,inst_30307);
var state_30395__$1 = state_30395;
var statearr_30429_30502 = state_30395__$1;
(statearr_30429_30502[(2)] = inst_30310);

(statearr_30429_30502[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (36))){
var inst_30354 = (state_30395[(25)]);
var inst_30358 = cljs.core.chunk_first.call(null,inst_30354);
var inst_30359 = cljs.core.chunk_rest.call(null,inst_30354);
var inst_30360 = cljs.core.count.call(null,inst_30358);
var inst_30335 = inst_30359;
var inst_30336 = inst_30358;
var inst_30337 = inst_30360;
var inst_30338 = (0);
var state_30395__$1 = (function (){var statearr_30430 = state_30395;
(statearr_30430[(20)] = inst_30335);

(statearr_30430[(21)] = inst_30337);

(statearr_30430[(10)] = inst_30338);

(statearr_30430[(11)] = inst_30336);

return statearr_30430;
})();
var statearr_30431_30503 = state_30395__$1;
(statearr_30431_30503[(2)] = null);

(statearr_30431_30503[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (41))){
var inst_30354 = (state_30395[(25)]);
var inst_30370 = (state_30395[(2)]);
var inst_30371 = cljs.core.next.call(null,inst_30354);
var inst_30335 = inst_30371;
var inst_30336 = null;
var inst_30337 = (0);
var inst_30338 = (0);
var state_30395__$1 = (function (){var statearr_30432 = state_30395;
(statearr_30432[(20)] = inst_30335);

(statearr_30432[(21)] = inst_30337);

(statearr_30432[(27)] = inst_30370);

(statearr_30432[(10)] = inst_30338);

(statearr_30432[(11)] = inst_30336);

return statearr_30432;
})();
var statearr_30433_30504 = state_30395__$1;
(statearr_30433_30504[(2)] = null);

(statearr_30433_30504[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (43))){
var state_30395__$1 = state_30395;
var statearr_30434_30505 = state_30395__$1;
(statearr_30434_30505[(2)] = null);

(statearr_30434_30505[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (29))){
var inst_30379 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30435_30506 = state_30395__$1;
(statearr_30435_30506[(2)] = inst_30379);

(statearr_30435_30506[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (44))){
var inst_30388 = (state_30395[(2)]);
var state_30395__$1 = (function (){var statearr_30436 = state_30395;
(statearr_30436[(28)] = inst_30388);

return statearr_30436;
})();
var statearr_30437_30507 = state_30395__$1;
(statearr_30437_30507[(2)] = null);

(statearr_30437_30507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (6))){
var inst_30327 = (state_30395[(29)]);
var inst_30326 = cljs.core.deref.call(null,cs);
var inst_30327__$1 = cljs.core.keys.call(null,inst_30326);
var inst_30328 = cljs.core.count.call(null,inst_30327__$1);
var inst_30329 = cljs.core.reset_BANG_.call(null,dctr,inst_30328);
var inst_30334 = cljs.core.seq.call(null,inst_30327__$1);
var inst_30335 = inst_30334;
var inst_30336 = null;
var inst_30337 = (0);
var inst_30338 = (0);
var state_30395__$1 = (function (){var statearr_30438 = state_30395;
(statearr_30438[(20)] = inst_30335);

(statearr_30438[(29)] = inst_30327__$1);

(statearr_30438[(21)] = inst_30337);

(statearr_30438[(10)] = inst_30338);

(statearr_30438[(11)] = inst_30336);

(statearr_30438[(30)] = inst_30329);

return statearr_30438;
})();
var statearr_30439_30508 = state_30395__$1;
(statearr_30439_30508[(2)] = null);

(statearr_30439_30508[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (28))){
var inst_30335 = (state_30395[(20)]);
var inst_30354 = (state_30395[(25)]);
var inst_30354__$1 = cljs.core.seq.call(null,inst_30335);
var state_30395__$1 = (function (){var statearr_30440 = state_30395;
(statearr_30440[(25)] = inst_30354__$1);

return statearr_30440;
})();
if(inst_30354__$1){
var statearr_30441_30509 = state_30395__$1;
(statearr_30441_30509[(1)] = (33));

} else {
var statearr_30442_30510 = state_30395__$1;
(statearr_30442_30510[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (25))){
var inst_30337 = (state_30395[(21)]);
var inst_30338 = (state_30395[(10)]);
var inst_30340 = (inst_30338 < inst_30337);
var inst_30341 = inst_30340;
var state_30395__$1 = state_30395;
if(cljs.core.truth_(inst_30341)){
var statearr_30443_30511 = state_30395__$1;
(statearr_30443_30511[(1)] = (27));

} else {
var statearr_30444_30512 = state_30395__$1;
(statearr_30444_30512[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (34))){
var state_30395__$1 = state_30395;
var statearr_30445_30513 = state_30395__$1;
(statearr_30445_30513[(2)] = null);

(statearr_30445_30513[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (17))){
var state_30395__$1 = state_30395;
var statearr_30446_30514 = state_30395__$1;
(statearr_30446_30514[(2)] = null);

(statearr_30446_30514[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (3))){
var inst_30393 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30395__$1,inst_30393);
} else {
if((state_val_30396 === (12))){
var inst_30322 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30447_30515 = state_30395__$1;
(statearr_30447_30515[(2)] = inst_30322);

(statearr_30447_30515[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (2))){
var state_30395__$1 = state_30395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30395__$1,(4),ch);
} else {
if((state_val_30396 === (23))){
var state_30395__$1 = state_30395;
var statearr_30448_30516 = state_30395__$1;
(statearr_30448_30516[(2)] = null);

(statearr_30448_30516[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (35))){
var inst_30377 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30449_30517 = state_30395__$1;
(statearr_30449_30517[(2)] = inst_30377);

(statearr_30449_30517[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (19))){
var inst_30296 = (state_30395[(7)]);
var inst_30300 = cljs.core.chunk_first.call(null,inst_30296);
var inst_30301 = cljs.core.chunk_rest.call(null,inst_30296);
var inst_30302 = cljs.core.count.call(null,inst_30300);
var inst_30276 = inst_30301;
var inst_30277 = inst_30300;
var inst_30278 = inst_30302;
var inst_30279 = (0);
var state_30395__$1 = (function (){var statearr_30450 = state_30395;
(statearr_30450[(13)] = inst_30278);

(statearr_30450[(14)] = inst_30277);

(statearr_30450[(15)] = inst_30279);

(statearr_30450[(16)] = inst_30276);

return statearr_30450;
})();
var statearr_30451_30518 = state_30395__$1;
(statearr_30451_30518[(2)] = null);

(statearr_30451_30518[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (11))){
var inst_30276 = (state_30395[(16)]);
var inst_30296 = (state_30395[(7)]);
var inst_30296__$1 = cljs.core.seq.call(null,inst_30276);
var state_30395__$1 = (function (){var statearr_30452 = state_30395;
(statearr_30452[(7)] = inst_30296__$1);

return statearr_30452;
})();
if(inst_30296__$1){
var statearr_30453_30519 = state_30395__$1;
(statearr_30453_30519[(1)] = (16));

} else {
var statearr_30454_30520 = state_30395__$1;
(statearr_30454_30520[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (9))){
var inst_30324 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30455_30521 = state_30395__$1;
(statearr_30455_30521[(2)] = inst_30324);

(statearr_30455_30521[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (5))){
var inst_30274 = cljs.core.deref.call(null,cs);
var inst_30275 = cljs.core.seq.call(null,inst_30274);
var inst_30276 = inst_30275;
var inst_30277 = null;
var inst_30278 = (0);
var inst_30279 = (0);
var state_30395__$1 = (function (){var statearr_30456 = state_30395;
(statearr_30456[(13)] = inst_30278);

(statearr_30456[(14)] = inst_30277);

(statearr_30456[(15)] = inst_30279);

(statearr_30456[(16)] = inst_30276);

return statearr_30456;
})();
var statearr_30457_30522 = state_30395__$1;
(statearr_30457_30522[(2)] = null);

(statearr_30457_30522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (14))){
var state_30395__$1 = state_30395;
var statearr_30458_30523 = state_30395__$1;
(statearr_30458_30523[(2)] = null);

(statearr_30458_30523[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (45))){
var inst_30385 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30459_30524 = state_30395__$1;
(statearr_30459_30524[(2)] = inst_30385);

(statearr_30459_30524[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (26))){
var inst_30327 = (state_30395[(29)]);
var inst_30381 = (state_30395[(2)]);
var inst_30382 = cljs.core.seq.call(null,inst_30327);
var state_30395__$1 = (function (){var statearr_30460 = state_30395;
(statearr_30460[(31)] = inst_30381);

return statearr_30460;
})();
if(inst_30382){
var statearr_30461_30525 = state_30395__$1;
(statearr_30461_30525[(1)] = (42));

} else {
var statearr_30462_30526 = state_30395__$1;
(statearr_30462_30526[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (16))){
var inst_30296 = (state_30395[(7)]);
var inst_30298 = cljs.core.chunked_seq_QMARK_.call(null,inst_30296);
var state_30395__$1 = state_30395;
if(inst_30298){
var statearr_30463_30527 = state_30395__$1;
(statearr_30463_30527[(1)] = (19));

} else {
var statearr_30464_30528 = state_30395__$1;
(statearr_30464_30528[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (38))){
var inst_30374 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30465_30529 = state_30395__$1;
(statearr_30465_30529[(2)] = inst_30374);

(statearr_30465_30529[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (30))){
var state_30395__$1 = state_30395;
var statearr_30466_30530 = state_30395__$1;
(statearr_30466_30530[(2)] = null);

(statearr_30466_30530[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (10))){
var inst_30277 = (state_30395[(14)]);
var inst_30279 = (state_30395[(15)]);
var inst_30285 = cljs.core._nth.call(null,inst_30277,inst_30279);
var inst_30286 = cljs.core.nth.call(null,inst_30285,(0),null);
var inst_30287 = cljs.core.nth.call(null,inst_30285,(1),null);
var state_30395__$1 = (function (){var statearr_30467 = state_30395;
(statearr_30467[(26)] = inst_30286);

return statearr_30467;
})();
if(cljs.core.truth_(inst_30287)){
var statearr_30468_30531 = state_30395__$1;
(statearr_30468_30531[(1)] = (13));

} else {
var statearr_30469_30532 = state_30395__$1;
(statearr_30469_30532[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (18))){
var inst_30320 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30470_30533 = state_30395__$1;
(statearr_30470_30533[(2)] = inst_30320);

(statearr_30470_30533[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (42))){
var state_30395__$1 = state_30395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30395__$1,(45),dchan);
} else {
if((state_val_30396 === (37))){
var inst_30354 = (state_30395[(25)]);
var inst_30267 = (state_30395[(12)]);
var inst_30363 = (state_30395[(23)]);
var inst_30363__$1 = cljs.core.first.call(null,inst_30354);
var inst_30364 = cljs.core.async.put_BANG_.call(null,inst_30363__$1,inst_30267,done);
var state_30395__$1 = (function (){var statearr_30471 = state_30395;
(statearr_30471[(23)] = inst_30363__$1);

return statearr_30471;
})();
if(cljs.core.truth_(inst_30364)){
var statearr_30472_30534 = state_30395__$1;
(statearr_30472_30534[(1)] = (39));

} else {
var statearr_30473_30535 = state_30395__$1;
(statearr_30473_30535[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (8))){
var inst_30278 = (state_30395[(13)]);
var inst_30279 = (state_30395[(15)]);
var inst_30281 = (inst_30279 < inst_30278);
var inst_30282 = inst_30281;
var state_30395__$1 = state_30395;
if(cljs.core.truth_(inst_30282)){
var statearr_30474_30536 = state_30395__$1;
(statearr_30474_30536[(1)] = (10));

} else {
var statearr_30475_30537 = state_30395__$1;
(statearr_30475_30537[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___30483,cs,m,dchan,dctr,done))
;
return ((function (switch__23913__auto__,c__23928__auto___30483,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__23914__auto__ = null;
var cljs$core$async$mult_$_state_machine__23914__auto____0 = (function (){
var statearr_30479 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30479[(0)] = cljs$core$async$mult_$_state_machine__23914__auto__);

(statearr_30479[(1)] = (1));

return statearr_30479;
});
var cljs$core$async$mult_$_state_machine__23914__auto____1 = (function (state_30395){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_30395);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e30480){if((e30480 instanceof Object)){
var ex__23917__auto__ = e30480;
var statearr_30481_30538 = state_30395;
(statearr_30481_30538[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30395);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30480;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30539 = state_30395;
state_30395 = G__30539;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__23914__auto__ = function(state_30395){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__23914__auto____1.call(this,state_30395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__23914__auto____0;
cljs$core$async$mult_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__23914__auto____1;
return cljs$core$async$mult_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___30483,cs,m,dchan,dctr,done))
})();
var state__23930__auto__ = (function (){var statearr_30482 = f__23929__auto__.call(null);
(statearr_30482[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___30483);

return statearr_30482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___30483,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var args30540 = [];
var len__19528__auto___30543 = arguments.length;
var i__19529__auto___30544 = (0);
while(true){
if((i__19529__auto___30544 < len__19528__auto___30543)){
args30540.push((arguments[i__19529__auto___30544]));

var G__30545 = (i__19529__auto___30544 + (1));
i__19529__auto___30544 = G__30545;
continue;
} else {
}
break;
}

var G__30542 = args30540.length;
switch (G__30542) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30540.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = {};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,ch);
} else {
var m__19126__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,ch);
} else {
var m__19126__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m);
} else {
var m__19126__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,state_map);
} else {
var m__19126__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,mode);
} else {
var m__19126__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var args__19535__auto__ = [];
var len__19528__auto___30559 = arguments.length;
var i__19529__auto___30560 = (0);
while(true){
if((i__19529__auto___30560 < len__19528__auto___30559)){
args__19535__auto__.push((arguments[i__19529__auto___30560]));

var G__30561 = (i__19529__auto___30560 + (1));
i__19529__auto___30560 = G__30561;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((3) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19536__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30553){
var map__30554 = p__30553;
var map__30554__$1 = ((((!((map__30554 == null)))?((((map__30554.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30554.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30554):map__30554);
var opts = map__30554__$1;
var statearr_30556_30562 = state;
(statearr_30556_30562[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__30554,map__30554__$1,opts){
return (function (val){
var statearr_30557_30563 = state;
(statearr_30557_30563[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__30554,map__30554__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_30558_30564 = state;
(statearr_30558_30564[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30549){
var G__30550 = cljs.core.first.call(null,seq30549);
var seq30549__$1 = cljs.core.next.call(null,seq30549);
var G__30551 = cljs.core.first.call(null,seq30549__$1);
var seq30549__$2 = cljs.core.next.call(null,seq30549__$1);
var G__30552 = cljs.core.first.call(null,seq30549__$2);
var seq30549__$3 = cljs.core.next.call(null,seq30549__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30550,G__30551,G__30552,seq30549__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t30728 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30728 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta30729){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta30729 = meta30729;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30728.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30730,meta30729__$1){
var self__ = this;
var _30730__$1 = this;
return (new cljs.core.async.t30728(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta30729__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30728.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30730){
var self__ = this;
var _30730__$1 = this;
return self__.meta30729;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30728.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30728.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30728.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t30728.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30728.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30728.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30728.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30728.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30728.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta30729","meta30729",1353977215,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30728.cljs$lang$type = true;

cljs.core.async.t30728.cljs$lang$ctorStr = "cljs.core.async/t30728";

cljs.core.async.t30728.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t30728");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t30728 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t30728(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30729){
return (new cljs.core.async.t30728(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30729));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t30728(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23928__auto___30891 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___30891,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___30891,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_30828){
var state_val_30829 = (state_30828[(1)]);
if((state_val_30829 === (7))){
var inst_30746 = (state_30828[(2)]);
var state_30828__$1 = state_30828;
var statearr_30830_30892 = state_30828__$1;
(statearr_30830_30892[(2)] = inst_30746);

(statearr_30830_30892[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (20))){
var inst_30758 = (state_30828[(7)]);
var state_30828__$1 = state_30828;
var statearr_30831_30893 = state_30828__$1;
(statearr_30831_30893[(2)] = inst_30758);

(statearr_30831_30893[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (27))){
var state_30828__$1 = state_30828;
var statearr_30832_30894 = state_30828__$1;
(statearr_30832_30894[(2)] = null);

(statearr_30832_30894[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (1))){
var inst_30734 = (state_30828[(8)]);
var inst_30734__$1 = calc_state.call(null);
var inst_30736 = (inst_30734__$1 == null);
var inst_30737 = cljs.core.not.call(null,inst_30736);
var state_30828__$1 = (function (){var statearr_30833 = state_30828;
(statearr_30833[(8)] = inst_30734__$1);

return statearr_30833;
})();
if(inst_30737){
var statearr_30834_30895 = state_30828__$1;
(statearr_30834_30895[(1)] = (2));

} else {
var statearr_30835_30896 = state_30828__$1;
(statearr_30835_30896[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (24))){
var inst_30802 = (state_30828[(9)]);
var inst_30781 = (state_30828[(10)]);
var inst_30788 = (state_30828[(11)]);
var inst_30802__$1 = inst_30781.call(null,inst_30788);
var state_30828__$1 = (function (){var statearr_30836 = state_30828;
(statearr_30836[(9)] = inst_30802__$1);

return statearr_30836;
})();
if(cljs.core.truth_(inst_30802__$1)){
var statearr_30837_30897 = state_30828__$1;
(statearr_30837_30897[(1)] = (29));

} else {
var statearr_30838_30898 = state_30828__$1;
(statearr_30838_30898[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (4))){
var inst_30749 = (state_30828[(2)]);
var state_30828__$1 = state_30828;
if(cljs.core.truth_(inst_30749)){
var statearr_30839_30899 = state_30828__$1;
(statearr_30839_30899[(1)] = (8));

} else {
var statearr_30840_30900 = state_30828__$1;
(statearr_30840_30900[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (15))){
var inst_30775 = (state_30828[(2)]);
var state_30828__$1 = state_30828;
if(cljs.core.truth_(inst_30775)){
var statearr_30841_30901 = state_30828__$1;
(statearr_30841_30901[(1)] = (19));

} else {
var statearr_30842_30902 = state_30828__$1;
(statearr_30842_30902[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (21))){
var inst_30780 = (state_30828[(12)]);
var inst_30780__$1 = (state_30828[(2)]);
var inst_30781 = cljs.core.get.call(null,inst_30780__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_30782 = cljs.core.get.call(null,inst_30780__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_30783 = cljs.core.get.call(null,inst_30780__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_30828__$1 = (function (){var statearr_30843 = state_30828;
(statearr_30843[(10)] = inst_30781);

(statearr_30843[(13)] = inst_30782);

(statearr_30843[(12)] = inst_30780__$1);

return statearr_30843;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_30828__$1,(22),inst_30783);
} else {
if((state_val_30829 === (31))){
var inst_30810 = (state_30828[(2)]);
var state_30828__$1 = state_30828;
if(cljs.core.truth_(inst_30810)){
var statearr_30844_30903 = state_30828__$1;
(statearr_30844_30903[(1)] = (32));

} else {
var statearr_30845_30904 = state_30828__$1;
(statearr_30845_30904[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (32))){
var inst_30787 = (state_30828[(14)]);
var state_30828__$1 = state_30828;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30828__$1,(35),out,inst_30787);
} else {
if((state_val_30829 === (33))){
var inst_30780 = (state_30828[(12)]);
var inst_30758 = inst_30780;
var state_30828__$1 = (function (){var statearr_30846 = state_30828;
(statearr_30846[(7)] = inst_30758);

return statearr_30846;
})();
var statearr_30847_30905 = state_30828__$1;
(statearr_30847_30905[(2)] = null);

(statearr_30847_30905[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (13))){
var inst_30758 = (state_30828[(7)]);
var inst_30765 = inst_30758.cljs$lang$protocol_mask$partition0$;
var inst_30766 = (inst_30765 & (64));
var inst_30767 = inst_30758.cljs$core$ISeq$;
var inst_30768 = (inst_30766) || (inst_30767);
var state_30828__$1 = state_30828;
if(cljs.core.truth_(inst_30768)){
var statearr_30848_30906 = state_30828__$1;
(statearr_30848_30906[(1)] = (16));

} else {
var statearr_30849_30907 = state_30828__$1;
(statearr_30849_30907[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (22))){
var inst_30787 = (state_30828[(14)]);
var inst_30788 = (state_30828[(11)]);
var inst_30786 = (state_30828[(2)]);
var inst_30787__$1 = cljs.core.nth.call(null,inst_30786,(0),null);
var inst_30788__$1 = cljs.core.nth.call(null,inst_30786,(1),null);
var inst_30789 = (inst_30787__$1 == null);
var inst_30790 = cljs.core._EQ_.call(null,inst_30788__$1,change);
var inst_30791 = (inst_30789) || (inst_30790);
var state_30828__$1 = (function (){var statearr_30850 = state_30828;
(statearr_30850[(14)] = inst_30787__$1);

(statearr_30850[(11)] = inst_30788__$1);

return statearr_30850;
})();
if(cljs.core.truth_(inst_30791)){
var statearr_30851_30908 = state_30828__$1;
(statearr_30851_30908[(1)] = (23));

} else {
var statearr_30852_30909 = state_30828__$1;
(statearr_30852_30909[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (36))){
var inst_30780 = (state_30828[(12)]);
var inst_30758 = inst_30780;
var state_30828__$1 = (function (){var statearr_30853 = state_30828;
(statearr_30853[(7)] = inst_30758);

return statearr_30853;
})();
var statearr_30854_30910 = state_30828__$1;
(statearr_30854_30910[(2)] = null);

(statearr_30854_30910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (29))){
var inst_30802 = (state_30828[(9)]);
var state_30828__$1 = state_30828;
var statearr_30855_30911 = state_30828__$1;
(statearr_30855_30911[(2)] = inst_30802);

(statearr_30855_30911[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (6))){
var state_30828__$1 = state_30828;
var statearr_30856_30912 = state_30828__$1;
(statearr_30856_30912[(2)] = false);

(statearr_30856_30912[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (28))){
var inst_30798 = (state_30828[(2)]);
var inst_30799 = calc_state.call(null);
var inst_30758 = inst_30799;
var state_30828__$1 = (function (){var statearr_30857 = state_30828;
(statearr_30857[(7)] = inst_30758);

(statearr_30857[(15)] = inst_30798);

return statearr_30857;
})();
var statearr_30858_30913 = state_30828__$1;
(statearr_30858_30913[(2)] = null);

(statearr_30858_30913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (25))){
var inst_30824 = (state_30828[(2)]);
var state_30828__$1 = state_30828;
var statearr_30859_30914 = state_30828__$1;
(statearr_30859_30914[(2)] = inst_30824);

(statearr_30859_30914[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (34))){
var inst_30822 = (state_30828[(2)]);
var state_30828__$1 = state_30828;
var statearr_30860_30915 = state_30828__$1;
(statearr_30860_30915[(2)] = inst_30822);

(statearr_30860_30915[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (17))){
var state_30828__$1 = state_30828;
var statearr_30861_30916 = state_30828__$1;
(statearr_30861_30916[(2)] = false);

(statearr_30861_30916[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (3))){
var state_30828__$1 = state_30828;
var statearr_30862_30917 = state_30828__$1;
(statearr_30862_30917[(2)] = false);

(statearr_30862_30917[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (12))){
var inst_30826 = (state_30828[(2)]);
var state_30828__$1 = state_30828;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30828__$1,inst_30826);
} else {
if((state_val_30829 === (2))){
var inst_30734 = (state_30828[(8)]);
var inst_30739 = inst_30734.cljs$lang$protocol_mask$partition0$;
var inst_30740 = (inst_30739 & (64));
var inst_30741 = inst_30734.cljs$core$ISeq$;
var inst_30742 = (inst_30740) || (inst_30741);
var state_30828__$1 = state_30828;
if(cljs.core.truth_(inst_30742)){
var statearr_30863_30918 = state_30828__$1;
(statearr_30863_30918[(1)] = (5));

} else {
var statearr_30864_30919 = state_30828__$1;
(statearr_30864_30919[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (23))){
var inst_30787 = (state_30828[(14)]);
var inst_30793 = (inst_30787 == null);
var state_30828__$1 = state_30828;
if(cljs.core.truth_(inst_30793)){
var statearr_30865_30920 = state_30828__$1;
(statearr_30865_30920[(1)] = (26));

} else {
var statearr_30866_30921 = state_30828__$1;
(statearr_30866_30921[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (35))){
var inst_30813 = (state_30828[(2)]);
var state_30828__$1 = state_30828;
if(cljs.core.truth_(inst_30813)){
var statearr_30867_30922 = state_30828__$1;
(statearr_30867_30922[(1)] = (36));

} else {
var statearr_30868_30923 = state_30828__$1;
(statearr_30868_30923[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (19))){
var inst_30758 = (state_30828[(7)]);
var inst_30777 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30758);
var state_30828__$1 = state_30828;
var statearr_30869_30924 = state_30828__$1;
(statearr_30869_30924[(2)] = inst_30777);

(statearr_30869_30924[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (11))){
var inst_30758 = (state_30828[(7)]);
var inst_30762 = (inst_30758 == null);
var inst_30763 = cljs.core.not.call(null,inst_30762);
var state_30828__$1 = state_30828;
if(inst_30763){
var statearr_30870_30925 = state_30828__$1;
(statearr_30870_30925[(1)] = (13));

} else {
var statearr_30871_30926 = state_30828__$1;
(statearr_30871_30926[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (9))){
var inst_30734 = (state_30828[(8)]);
var state_30828__$1 = state_30828;
var statearr_30872_30927 = state_30828__$1;
(statearr_30872_30927[(2)] = inst_30734);

(statearr_30872_30927[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (5))){
var state_30828__$1 = state_30828;
var statearr_30873_30928 = state_30828__$1;
(statearr_30873_30928[(2)] = true);

(statearr_30873_30928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (14))){
var state_30828__$1 = state_30828;
var statearr_30874_30929 = state_30828__$1;
(statearr_30874_30929[(2)] = false);

(statearr_30874_30929[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (26))){
var inst_30788 = (state_30828[(11)]);
var inst_30795 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_30788);
var state_30828__$1 = state_30828;
var statearr_30875_30930 = state_30828__$1;
(statearr_30875_30930[(2)] = inst_30795);

(statearr_30875_30930[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (16))){
var state_30828__$1 = state_30828;
var statearr_30876_30931 = state_30828__$1;
(statearr_30876_30931[(2)] = true);

(statearr_30876_30931[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (38))){
var inst_30818 = (state_30828[(2)]);
var state_30828__$1 = state_30828;
var statearr_30877_30932 = state_30828__$1;
(statearr_30877_30932[(2)] = inst_30818);

(statearr_30877_30932[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (30))){
var inst_30781 = (state_30828[(10)]);
var inst_30782 = (state_30828[(13)]);
var inst_30788 = (state_30828[(11)]);
var inst_30805 = cljs.core.empty_QMARK_.call(null,inst_30781);
var inst_30806 = inst_30782.call(null,inst_30788);
var inst_30807 = cljs.core.not.call(null,inst_30806);
var inst_30808 = (inst_30805) && (inst_30807);
var state_30828__$1 = state_30828;
var statearr_30878_30933 = state_30828__$1;
(statearr_30878_30933[(2)] = inst_30808);

(statearr_30878_30933[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (10))){
var inst_30734 = (state_30828[(8)]);
var inst_30754 = (state_30828[(2)]);
var inst_30755 = cljs.core.get.call(null,inst_30754,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_30756 = cljs.core.get.call(null,inst_30754,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_30757 = cljs.core.get.call(null,inst_30754,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_30758 = inst_30734;
var state_30828__$1 = (function (){var statearr_30879 = state_30828;
(statearr_30879[(16)] = inst_30757);

(statearr_30879[(17)] = inst_30755);

(statearr_30879[(7)] = inst_30758);

(statearr_30879[(18)] = inst_30756);

return statearr_30879;
})();
var statearr_30880_30934 = state_30828__$1;
(statearr_30880_30934[(2)] = null);

(statearr_30880_30934[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (18))){
var inst_30772 = (state_30828[(2)]);
var state_30828__$1 = state_30828;
var statearr_30881_30935 = state_30828__$1;
(statearr_30881_30935[(2)] = inst_30772);

(statearr_30881_30935[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (37))){
var state_30828__$1 = state_30828;
var statearr_30882_30936 = state_30828__$1;
(statearr_30882_30936[(2)] = null);

(statearr_30882_30936[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30829 === (8))){
var inst_30734 = (state_30828[(8)]);
var inst_30751 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30734);
var state_30828__$1 = state_30828;
var statearr_30883_30937 = state_30828__$1;
(statearr_30883_30937[(2)] = inst_30751);

(statearr_30883_30937[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___30891,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__23913__auto__,c__23928__auto___30891,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__23914__auto__ = null;
var cljs$core$async$mix_$_state_machine__23914__auto____0 = (function (){
var statearr_30887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30887[(0)] = cljs$core$async$mix_$_state_machine__23914__auto__);

(statearr_30887[(1)] = (1));

return statearr_30887;
});
var cljs$core$async$mix_$_state_machine__23914__auto____1 = (function (state_30828){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_30828);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e30888){if((e30888 instanceof Object)){
var ex__23917__auto__ = e30888;
var statearr_30889_30938 = state_30828;
(statearr_30889_30938[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30828);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30888;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30939 = state_30828;
state_30828 = G__30939;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__23914__auto__ = function(state_30828){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__23914__auto____1.call(this,state_30828);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__23914__auto____0;
cljs$core$async$mix_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__23914__auto____1;
return cljs$core$async$mix_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___30891,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__23930__auto__ = (function (){var statearr_30890 = f__23929__auto__.call(null);
(statearr_30890[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___30891);

return statearr_30890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___30891,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = {};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__19125__auto__ = (((p == null))?null:p);
var m__19126__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__19126__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__19125__auto__ = (((p == null))?null:p);
var m__19126__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,p,v,ch);
} else {
var m__19126__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var args30942 = [];
var len__19528__auto___30945 = arguments.length;
var i__19529__auto___30946 = (0);
while(true){
if((i__19529__auto___30946 < len__19528__auto___30945)){
args30942.push((arguments[i__19529__auto___30946]));

var G__30947 = (i__19529__auto___30946 + (1));
i__19529__auto___30946 = G__30947;
continue;
} else {
}
break;
}

var G__30944 = args30942.length;
switch (G__30944) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30942.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__19125__auto__ = (((p == null))?null:p);
var m__19126__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,p);
} else {
var m__19126__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__19125__auto__ = (((p == null))?null:p);
var m__19126__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,p,v);
} else {
var m__19126__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var args30950 = [];
var len__19528__auto___31075 = arguments.length;
var i__19529__auto___31076 = (0);
while(true){
if((i__19529__auto___31076 < len__19528__auto___31075)){
args30950.push((arguments[i__19529__auto___31076]));

var G__31077 = (i__19529__auto___31076 + (1));
i__19529__auto___31076 = G__31077;
continue;
} else {
}
break;
}

var G__30952 = args30950.length;
switch (G__30952) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30950.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__18489__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__18489__auto__,mults){
return (function (p1__30949_SHARP_){
if(cljs.core.truth_(p1__30949_SHARP_.call(null,topic))){
return p1__30949_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__30949_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__18489__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t30953 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30953 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta30954){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta30954 = meta30954;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30953.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_30955,meta30954__$1){
var self__ = this;
var _30955__$1 = this;
return (new cljs.core.async.t30953(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta30954__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t30953.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_30955){
var self__ = this;
var _30955__$1 = this;
return self__.meta30954;
});})(mults,ensure_mult))
;

cljs.core.async.t30953.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30953.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t30953.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t30953.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t30953.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t30953.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t30953.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t30953.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta30954","meta30954",503916099,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t30953.cljs$lang$type = true;

cljs.core.async.t30953.cljs$lang$ctorStr = "cljs.core.async/t30953";

cljs.core.async.t30953.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t30953");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t30953 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t30953(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta30954){
return (new cljs.core.async.t30953(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta30954));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t30953(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23928__auto___31079 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___31079,mults,ensure_mult,p){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___31079,mults,ensure_mult,p){
return (function (state_31027){
var state_val_31028 = (state_31027[(1)]);
if((state_val_31028 === (7))){
var inst_31023 = (state_31027[(2)]);
var state_31027__$1 = state_31027;
var statearr_31029_31080 = state_31027__$1;
(statearr_31029_31080[(2)] = inst_31023);

(statearr_31029_31080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (20))){
var state_31027__$1 = state_31027;
var statearr_31030_31081 = state_31027__$1;
(statearr_31030_31081[(2)] = null);

(statearr_31030_31081[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (1))){
var state_31027__$1 = state_31027;
var statearr_31031_31082 = state_31027__$1;
(statearr_31031_31082[(2)] = null);

(statearr_31031_31082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (24))){
var inst_31006 = (state_31027[(7)]);
var inst_31015 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_31006);
var state_31027__$1 = state_31027;
var statearr_31032_31083 = state_31027__$1;
(statearr_31032_31083[(2)] = inst_31015);

(statearr_31032_31083[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (4))){
var inst_30958 = (state_31027[(8)]);
var inst_30958__$1 = (state_31027[(2)]);
var inst_30959 = (inst_30958__$1 == null);
var state_31027__$1 = (function (){var statearr_31033 = state_31027;
(statearr_31033[(8)] = inst_30958__$1);

return statearr_31033;
})();
if(cljs.core.truth_(inst_30959)){
var statearr_31034_31084 = state_31027__$1;
(statearr_31034_31084[(1)] = (5));

} else {
var statearr_31035_31085 = state_31027__$1;
(statearr_31035_31085[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (15))){
var inst_31000 = (state_31027[(2)]);
var state_31027__$1 = state_31027;
var statearr_31036_31086 = state_31027__$1;
(statearr_31036_31086[(2)] = inst_31000);

(statearr_31036_31086[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (21))){
var inst_31020 = (state_31027[(2)]);
var state_31027__$1 = (function (){var statearr_31037 = state_31027;
(statearr_31037[(9)] = inst_31020);

return statearr_31037;
})();
var statearr_31038_31087 = state_31027__$1;
(statearr_31038_31087[(2)] = null);

(statearr_31038_31087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (13))){
var inst_30982 = (state_31027[(10)]);
var inst_30984 = cljs.core.chunked_seq_QMARK_.call(null,inst_30982);
var state_31027__$1 = state_31027;
if(inst_30984){
var statearr_31039_31088 = state_31027__$1;
(statearr_31039_31088[(1)] = (16));

} else {
var statearr_31040_31089 = state_31027__$1;
(statearr_31040_31089[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (22))){
var inst_31012 = (state_31027[(2)]);
var state_31027__$1 = state_31027;
if(cljs.core.truth_(inst_31012)){
var statearr_31041_31090 = state_31027__$1;
(statearr_31041_31090[(1)] = (23));

} else {
var statearr_31042_31091 = state_31027__$1;
(statearr_31042_31091[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (6))){
var inst_31006 = (state_31027[(7)]);
var inst_31008 = (state_31027[(11)]);
var inst_30958 = (state_31027[(8)]);
var inst_31006__$1 = topic_fn.call(null,inst_30958);
var inst_31007 = cljs.core.deref.call(null,mults);
var inst_31008__$1 = cljs.core.get.call(null,inst_31007,inst_31006__$1);
var state_31027__$1 = (function (){var statearr_31043 = state_31027;
(statearr_31043[(7)] = inst_31006__$1);

(statearr_31043[(11)] = inst_31008__$1);

return statearr_31043;
})();
if(cljs.core.truth_(inst_31008__$1)){
var statearr_31044_31092 = state_31027__$1;
(statearr_31044_31092[(1)] = (19));

} else {
var statearr_31045_31093 = state_31027__$1;
(statearr_31045_31093[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (25))){
var inst_31017 = (state_31027[(2)]);
var state_31027__$1 = state_31027;
var statearr_31046_31094 = state_31027__$1;
(statearr_31046_31094[(2)] = inst_31017);

(statearr_31046_31094[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (17))){
var inst_30982 = (state_31027[(10)]);
var inst_30991 = cljs.core.first.call(null,inst_30982);
var inst_30992 = cljs.core.async.muxch_STAR_.call(null,inst_30991);
var inst_30993 = cljs.core.async.close_BANG_.call(null,inst_30992);
var inst_30994 = cljs.core.next.call(null,inst_30982);
var inst_30968 = inst_30994;
var inst_30969 = null;
var inst_30970 = (0);
var inst_30971 = (0);
var state_31027__$1 = (function (){var statearr_31047 = state_31027;
(statearr_31047[(12)] = inst_30968);

(statearr_31047[(13)] = inst_30969);

(statearr_31047[(14)] = inst_30970);

(statearr_31047[(15)] = inst_30993);

(statearr_31047[(16)] = inst_30971);

return statearr_31047;
})();
var statearr_31048_31095 = state_31027__$1;
(statearr_31048_31095[(2)] = null);

(statearr_31048_31095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (3))){
var inst_31025 = (state_31027[(2)]);
var state_31027__$1 = state_31027;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31027__$1,inst_31025);
} else {
if((state_val_31028 === (12))){
var inst_31002 = (state_31027[(2)]);
var state_31027__$1 = state_31027;
var statearr_31049_31096 = state_31027__$1;
(statearr_31049_31096[(2)] = inst_31002);

(statearr_31049_31096[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (2))){
var state_31027__$1 = state_31027;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31027__$1,(4),ch);
} else {
if((state_val_31028 === (23))){
var state_31027__$1 = state_31027;
var statearr_31050_31097 = state_31027__$1;
(statearr_31050_31097[(2)] = null);

(statearr_31050_31097[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (19))){
var inst_31008 = (state_31027[(11)]);
var inst_30958 = (state_31027[(8)]);
var inst_31010 = cljs.core.async.muxch_STAR_.call(null,inst_31008);
var state_31027__$1 = state_31027;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31027__$1,(22),inst_31010,inst_30958);
} else {
if((state_val_31028 === (11))){
var inst_30968 = (state_31027[(12)]);
var inst_30982 = (state_31027[(10)]);
var inst_30982__$1 = cljs.core.seq.call(null,inst_30968);
var state_31027__$1 = (function (){var statearr_31051 = state_31027;
(statearr_31051[(10)] = inst_30982__$1);

return statearr_31051;
})();
if(inst_30982__$1){
var statearr_31052_31098 = state_31027__$1;
(statearr_31052_31098[(1)] = (13));

} else {
var statearr_31053_31099 = state_31027__$1;
(statearr_31053_31099[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (9))){
var inst_31004 = (state_31027[(2)]);
var state_31027__$1 = state_31027;
var statearr_31054_31100 = state_31027__$1;
(statearr_31054_31100[(2)] = inst_31004);

(statearr_31054_31100[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (5))){
var inst_30965 = cljs.core.deref.call(null,mults);
var inst_30966 = cljs.core.vals.call(null,inst_30965);
var inst_30967 = cljs.core.seq.call(null,inst_30966);
var inst_30968 = inst_30967;
var inst_30969 = null;
var inst_30970 = (0);
var inst_30971 = (0);
var state_31027__$1 = (function (){var statearr_31055 = state_31027;
(statearr_31055[(12)] = inst_30968);

(statearr_31055[(13)] = inst_30969);

(statearr_31055[(14)] = inst_30970);

(statearr_31055[(16)] = inst_30971);

return statearr_31055;
})();
var statearr_31056_31101 = state_31027__$1;
(statearr_31056_31101[(2)] = null);

(statearr_31056_31101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (14))){
var state_31027__$1 = state_31027;
var statearr_31060_31102 = state_31027__$1;
(statearr_31060_31102[(2)] = null);

(statearr_31060_31102[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (16))){
var inst_30982 = (state_31027[(10)]);
var inst_30986 = cljs.core.chunk_first.call(null,inst_30982);
var inst_30987 = cljs.core.chunk_rest.call(null,inst_30982);
var inst_30988 = cljs.core.count.call(null,inst_30986);
var inst_30968 = inst_30987;
var inst_30969 = inst_30986;
var inst_30970 = inst_30988;
var inst_30971 = (0);
var state_31027__$1 = (function (){var statearr_31061 = state_31027;
(statearr_31061[(12)] = inst_30968);

(statearr_31061[(13)] = inst_30969);

(statearr_31061[(14)] = inst_30970);

(statearr_31061[(16)] = inst_30971);

return statearr_31061;
})();
var statearr_31062_31103 = state_31027__$1;
(statearr_31062_31103[(2)] = null);

(statearr_31062_31103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (10))){
var inst_30968 = (state_31027[(12)]);
var inst_30969 = (state_31027[(13)]);
var inst_30970 = (state_31027[(14)]);
var inst_30971 = (state_31027[(16)]);
var inst_30976 = cljs.core._nth.call(null,inst_30969,inst_30971);
var inst_30977 = cljs.core.async.muxch_STAR_.call(null,inst_30976);
var inst_30978 = cljs.core.async.close_BANG_.call(null,inst_30977);
var inst_30979 = (inst_30971 + (1));
var tmp31057 = inst_30968;
var tmp31058 = inst_30969;
var tmp31059 = inst_30970;
var inst_30968__$1 = tmp31057;
var inst_30969__$1 = tmp31058;
var inst_30970__$1 = tmp31059;
var inst_30971__$1 = inst_30979;
var state_31027__$1 = (function (){var statearr_31063 = state_31027;
(statearr_31063[(17)] = inst_30978);

(statearr_31063[(12)] = inst_30968__$1);

(statearr_31063[(13)] = inst_30969__$1);

(statearr_31063[(14)] = inst_30970__$1);

(statearr_31063[(16)] = inst_30971__$1);

return statearr_31063;
})();
var statearr_31064_31104 = state_31027__$1;
(statearr_31064_31104[(2)] = null);

(statearr_31064_31104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (18))){
var inst_30997 = (state_31027[(2)]);
var state_31027__$1 = state_31027;
var statearr_31065_31105 = state_31027__$1;
(statearr_31065_31105[(2)] = inst_30997);

(statearr_31065_31105[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31028 === (8))){
var inst_30970 = (state_31027[(14)]);
var inst_30971 = (state_31027[(16)]);
var inst_30973 = (inst_30971 < inst_30970);
var inst_30974 = inst_30973;
var state_31027__$1 = state_31027;
if(cljs.core.truth_(inst_30974)){
var statearr_31066_31106 = state_31027__$1;
(statearr_31066_31106[(1)] = (10));

} else {
var statearr_31067_31107 = state_31027__$1;
(statearr_31067_31107[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___31079,mults,ensure_mult,p))
;
return ((function (switch__23913__auto__,c__23928__auto___31079,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_31071 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31071[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_31071[(1)] = (1));

return statearr_31071;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_31027){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31027);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31072){if((e31072 instanceof Object)){
var ex__23917__auto__ = e31072;
var statearr_31073_31108 = state_31027;
(statearr_31073_31108[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31027);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31072;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31109 = state_31027;
state_31027 = G__31109;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_31027){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_31027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___31079,mults,ensure_mult,p))
})();
var state__23930__auto__ = (function (){var statearr_31074 = f__23929__auto__.call(null);
(statearr_31074[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___31079);

return statearr_31074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___31079,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var args31110 = [];
var len__19528__auto___31113 = arguments.length;
var i__19529__auto___31114 = (0);
while(true){
if((i__19529__auto___31114 < len__19528__auto___31113)){
args31110.push((arguments[i__19529__auto___31114]));

var G__31115 = (i__19529__auto___31114 + (1));
i__19529__auto___31114 = G__31115;
continue;
} else {
}
break;
}

var G__31112 = args31110.length;
switch (G__31112) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31110.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var args31117 = [];
var len__19528__auto___31120 = arguments.length;
var i__19529__auto___31121 = (0);
while(true){
if((i__19529__auto___31121 < len__19528__auto___31120)){
args31117.push((arguments[i__19529__auto___31121]));

var G__31122 = (i__19529__auto___31121 + (1));
i__19529__auto___31121 = G__31122;
continue;
} else {
}
break;
}

var G__31119 = args31117.length;
switch (G__31119) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31117.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var args31124 = [];
var len__19528__auto___31195 = arguments.length;
var i__19529__auto___31196 = (0);
while(true){
if((i__19529__auto___31196 < len__19528__auto___31195)){
args31124.push((arguments[i__19529__auto___31196]));

var G__31197 = (i__19529__auto___31196 + (1));
i__19529__auto___31196 = G__31197;
continue;
} else {
}
break;
}

var G__31126 = args31124.length;
switch (G__31126) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31124.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__23928__auto___31199 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___31199,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___31199,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31165){
var state_val_31166 = (state_31165[(1)]);
if((state_val_31166 === (7))){
var state_31165__$1 = state_31165;
var statearr_31167_31200 = state_31165__$1;
(statearr_31167_31200[(2)] = null);

(statearr_31167_31200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (1))){
var state_31165__$1 = state_31165;
var statearr_31168_31201 = state_31165__$1;
(statearr_31168_31201[(2)] = null);

(statearr_31168_31201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (4))){
var inst_31129 = (state_31165[(7)]);
var inst_31131 = (inst_31129 < cnt);
var state_31165__$1 = state_31165;
if(cljs.core.truth_(inst_31131)){
var statearr_31169_31202 = state_31165__$1;
(statearr_31169_31202[(1)] = (6));

} else {
var statearr_31170_31203 = state_31165__$1;
(statearr_31170_31203[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (15))){
var inst_31161 = (state_31165[(2)]);
var state_31165__$1 = state_31165;
var statearr_31171_31204 = state_31165__$1;
(statearr_31171_31204[(2)] = inst_31161);

(statearr_31171_31204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (13))){
var inst_31154 = cljs.core.async.close_BANG_.call(null,out);
var state_31165__$1 = state_31165;
var statearr_31172_31205 = state_31165__$1;
(statearr_31172_31205[(2)] = inst_31154);

(statearr_31172_31205[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (6))){
var state_31165__$1 = state_31165;
var statearr_31173_31206 = state_31165__$1;
(statearr_31173_31206[(2)] = null);

(statearr_31173_31206[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (3))){
var inst_31163 = (state_31165[(2)]);
var state_31165__$1 = state_31165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31165__$1,inst_31163);
} else {
if((state_val_31166 === (12))){
var inst_31151 = (state_31165[(8)]);
var inst_31151__$1 = (state_31165[(2)]);
var inst_31152 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_31151__$1);
var state_31165__$1 = (function (){var statearr_31174 = state_31165;
(statearr_31174[(8)] = inst_31151__$1);

return statearr_31174;
})();
if(cljs.core.truth_(inst_31152)){
var statearr_31175_31207 = state_31165__$1;
(statearr_31175_31207[(1)] = (13));

} else {
var statearr_31176_31208 = state_31165__$1;
(statearr_31176_31208[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (2))){
var inst_31128 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_31129 = (0);
var state_31165__$1 = (function (){var statearr_31177 = state_31165;
(statearr_31177[(7)] = inst_31129);

(statearr_31177[(9)] = inst_31128);

return statearr_31177;
})();
var statearr_31178_31209 = state_31165__$1;
(statearr_31178_31209[(2)] = null);

(statearr_31178_31209[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (11))){
var inst_31129 = (state_31165[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31165,(10),Object,null,(9));
var inst_31138 = chs__$1.call(null,inst_31129);
var inst_31139 = done.call(null,inst_31129);
var inst_31140 = cljs.core.async.take_BANG_.call(null,inst_31138,inst_31139);
var state_31165__$1 = state_31165;
var statearr_31179_31210 = state_31165__$1;
(statearr_31179_31210[(2)] = inst_31140);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31165__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (9))){
var inst_31129 = (state_31165[(7)]);
var inst_31142 = (state_31165[(2)]);
var inst_31143 = (inst_31129 + (1));
var inst_31129__$1 = inst_31143;
var state_31165__$1 = (function (){var statearr_31180 = state_31165;
(statearr_31180[(7)] = inst_31129__$1);

(statearr_31180[(10)] = inst_31142);

return statearr_31180;
})();
var statearr_31181_31211 = state_31165__$1;
(statearr_31181_31211[(2)] = null);

(statearr_31181_31211[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (5))){
var inst_31149 = (state_31165[(2)]);
var state_31165__$1 = (function (){var statearr_31182 = state_31165;
(statearr_31182[(11)] = inst_31149);

return statearr_31182;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31165__$1,(12),dchan);
} else {
if((state_val_31166 === (14))){
var inst_31151 = (state_31165[(8)]);
var inst_31156 = cljs.core.apply.call(null,f,inst_31151);
var state_31165__$1 = state_31165;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31165__$1,(16),out,inst_31156);
} else {
if((state_val_31166 === (16))){
var inst_31158 = (state_31165[(2)]);
var state_31165__$1 = (function (){var statearr_31183 = state_31165;
(statearr_31183[(12)] = inst_31158);

return statearr_31183;
})();
var statearr_31184_31212 = state_31165__$1;
(statearr_31184_31212[(2)] = null);

(statearr_31184_31212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (10))){
var inst_31133 = (state_31165[(2)]);
var inst_31134 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_31165__$1 = (function (){var statearr_31185 = state_31165;
(statearr_31185[(13)] = inst_31133);

return statearr_31185;
})();
var statearr_31186_31213 = state_31165__$1;
(statearr_31186_31213[(2)] = inst_31134);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31165__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31166 === (8))){
var inst_31147 = (state_31165[(2)]);
var state_31165__$1 = state_31165;
var statearr_31187_31214 = state_31165__$1;
(statearr_31187_31214[(2)] = inst_31147);

(statearr_31187_31214[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___31199,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__23913__auto__,c__23928__auto___31199,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_31191 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31191[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_31191[(1)] = (1));

return statearr_31191;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_31165){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31192){if((e31192 instanceof Object)){
var ex__23917__auto__ = e31192;
var statearr_31193_31215 = state_31165;
(statearr_31193_31215[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31165);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31192;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31216 = state_31165;
state_31165 = G__31216;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_31165){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_31165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___31199,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__23930__auto__ = (function (){var statearr_31194 = f__23929__auto__.call(null);
(statearr_31194[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___31199);

return statearr_31194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___31199,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var args31218 = [];
var len__19528__auto___31274 = arguments.length;
var i__19529__auto___31275 = (0);
while(true){
if((i__19529__auto___31275 < len__19528__auto___31274)){
args31218.push((arguments[i__19529__auto___31275]));

var G__31276 = (i__19529__auto___31275 + (1));
i__19529__auto___31275 = G__31276;
continue;
} else {
}
break;
}

var G__31220 = args31218.length;
switch (G__31220) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31218.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23928__auto___31278 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___31278,out){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___31278,out){
return (function (state_31250){
var state_val_31251 = (state_31250[(1)]);
if((state_val_31251 === (7))){
var inst_31230 = (state_31250[(7)]);
var inst_31229 = (state_31250[(8)]);
var inst_31229__$1 = (state_31250[(2)]);
var inst_31230__$1 = cljs.core.nth.call(null,inst_31229__$1,(0),null);
var inst_31231 = cljs.core.nth.call(null,inst_31229__$1,(1),null);
var inst_31232 = (inst_31230__$1 == null);
var state_31250__$1 = (function (){var statearr_31252 = state_31250;
(statearr_31252[(9)] = inst_31231);

(statearr_31252[(7)] = inst_31230__$1);

(statearr_31252[(8)] = inst_31229__$1);

return statearr_31252;
})();
if(cljs.core.truth_(inst_31232)){
var statearr_31253_31279 = state_31250__$1;
(statearr_31253_31279[(1)] = (8));

} else {
var statearr_31254_31280 = state_31250__$1;
(statearr_31254_31280[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31251 === (1))){
var inst_31221 = cljs.core.vec.call(null,chs);
var inst_31222 = inst_31221;
var state_31250__$1 = (function (){var statearr_31255 = state_31250;
(statearr_31255[(10)] = inst_31222);

return statearr_31255;
})();
var statearr_31256_31281 = state_31250__$1;
(statearr_31256_31281[(2)] = null);

(statearr_31256_31281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31251 === (4))){
var inst_31222 = (state_31250[(10)]);
var state_31250__$1 = state_31250;
return cljs.core.async.ioc_alts_BANG_.call(null,state_31250__$1,(7),inst_31222);
} else {
if((state_val_31251 === (6))){
var inst_31246 = (state_31250[(2)]);
var state_31250__$1 = state_31250;
var statearr_31257_31282 = state_31250__$1;
(statearr_31257_31282[(2)] = inst_31246);

(statearr_31257_31282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31251 === (3))){
var inst_31248 = (state_31250[(2)]);
var state_31250__$1 = state_31250;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31250__$1,inst_31248);
} else {
if((state_val_31251 === (2))){
var inst_31222 = (state_31250[(10)]);
var inst_31224 = cljs.core.count.call(null,inst_31222);
var inst_31225 = (inst_31224 > (0));
var state_31250__$1 = state_31250;
if(cljs.core.truth_(inst_31225)){
var statearr_31259_31283 = state_31250__$1;
(statearr_31259_31283[(1)] = (4));

} else {
var statearr_31260_31284 = state_31250__$1;
(statearr_31260_31284[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31251 === (11))){
var inst_31222 = (state_31250[(10)]);
var inst_31239 = (state_31250[(2)]);
var tmp31258 = inst_31222;
var inst_31222__$1 = tmp31258;
var state_31250__$1 = (function (){var statearr_31261 = state_31250;
(statearr_31261[(10)] = inst_31222__$1);

(statearr_31261[(11)] = inst_31239);

return statearr_31261;
})();
var statearr_31262_31285 = state_31250__$1;
(statearr_31262_31285[(2)] = null);

(statearr_31262_31285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31251 === (9))){
var inst_31230 = (state_31250[(7)]);
var state_31250__$1 = state_31250;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31250__$1,(11),out,inst_31230);
} else {
if((state_val_31251 === (5))){
var inst_31244 = cljs.core.async.close_BANG_.call(null,out);
var state_31250__$1 = state_31250;
var statearr_31263_31286 = state_31250__$1;
(statearr_31263_31286[(2)] = inst_31244);

(statearr_31263_31286[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31251 === (10))){
var inst_31242 = (state_31250[(2)]);
var state_31250__$1 = state_31250;
var statearr_31264_31287 = state_31250__$1;
(statearr_31264_31287[(2)] = inst_31242);

(statearr_31264_31287[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31251 === (8))){
var inst_31231 = (state_31250[(9)]);
var inst_31230 = (state_31250[(7)]);
var inst_31229 = (state_31250[(8)]);
var inst_31222 = (state_31250[(10)]);
var inst_31234 = (function (){var cs = inst_31222;
var vec__31227 = inst_31229;
var v = inst_31230;
var c = inst_31231;
return ((function (cs,vec__31227,v,c,inst_31231,inst_31230,inst_31229,inst_31222,state_val_31251,c__23928__auto___31278,out){
return (function (p1__31217_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__31217_SHARP_);
});
;})(cs,vec__31227,v,c,inst_31231,inst_31230,inst_31229,inst_31222,state_val_31251,c__23928__auto___31278,out))
})();
var inst_31235 = cljs.core.filterv.call(null,inst_31234,inst_31222);
var inst_31222__$1 = inst_31235;
var state_31250__$1 = (function (){var statearr_31265 = state_31250;
(statearr_31265[(10)] = inst_31222__$1);

return statearr_31265;
})();
var statearr_31266_31288 = state_31250__$1;
(statearr_31266_31288[(2)] = null);

(statearr_31266_31288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___31278,out))
;
return ((function (switch__23913__auto__,c__23928__auto___31278,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_31270 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31270[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_31270[(1)] = (1));

return statearr_31270;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_31250){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31250);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31271){if((e31271 instanceof Object)){
var ex__23917__auto__ = e31271;
var statearr_31272_31289 = state_31250;
(statearr_31272_31289[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31250);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31271;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31290 = state_31250;
state_31250 = G__31290;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_31250){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_31250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___31278,out))
})();
var state__23930__auto__ = (function (){var statearr_31273 = f__23929__auto__.call(null);
(statearr_31273[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___31278);

return statearr_31273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___31278,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var args31291 = [];
var len__19528__auto___31340 = arguments.length;
var i__19529__auto___31341 = (0);
while(true){
if((i__19529__auto___31341 < len__19528__auto___31340)){
args31291.push((arguments[i__19529__auto___31341]));

var G__31342 = (i__19529__auto___31341 + (1));
i__19529__auto___31341 = G__31342;
continue;
} else {
}
break;
}

var G__31293 = args31291.length;
switch (G__31293) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31291.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23928__auto___31344 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___31344,out){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___31344,out){
return (function (state_31317){
var state_val_31318 = (state_31317[(1)]);
if((state_val_31318 === (7))){
var inst_31299 = (state_31317[(7)]);
var inst_31299__$1 = (state_31317[(2)]);
var inst_31300 = (inst_31299__$1 == null);
var inst_31301 = cljs.core.not.call(null,inst_31300);
var state_31317__$1 = (function (){var statearr_31319 = state_31317;
(statearr_31319[(7)] = inst_31299__$1);

return statearr_31319;
})();
if(inst_31301){
var statearr_31320_31345 = state_31317__$1;
(statearr_31320_31345[(1)] = (8));

} else {
var statearr_31321_31346 = state_31317__$1;
(statearr_31321_31346[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31318 === (1))){
var inst_31294 = (0);
var state_31317__$1 = (function (){var statearr_31322 = state_31317;
(statearr_31322[(8)] = inst_31294);

return statearr_31322;
})();
var statearr_31323_31347 = state_31317__$1;
(statearr_31323_31347[(2)] = null);

(statearr_31323_31347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31318 === (4))){
var state_31317__$1 = state_31317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31317__$1,(7),ch);
} else {
if((state_val_31318 === (6))){
var inst_31312 = (state_31317[(2)]);
var state_31317__$1 = state_31317;
var statearr_31324_31348 = state_31317__$1;
(statearr_31324_31348[(2)] = inst_31312);

(statearr_31324_31348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31318 === (3))){
var inst_31314 = (state_31317[(2)]);
var inst_31315 = cljs.core.async.close_BANG_.call(null,out);
var state_31317__$1 = (function (){var statearr_31325 = state_31317;
(statearr_31325[(9)] = inst_31314);

return statearr_31325;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31317__$1,inst_31315);
} else {
if((state_val_31318 === (2))){
var inst_31294 = (state_31317[(8)]);
var inst_31296 = (inst_31294 < n);
var state_31317__$1 = state_31317;
if(cljs.core.truth_(inst_31296)){
var statearr_31326_31349 = state_31317__$1;
(statearr_31326_31349[(1)] = (4));

} else {
var statearr_31327_31350 = state_31317__$1;
(statearr_31327_31350[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31318 === (11))){
var inst_31294 = (state_31317[(8)]);
var inst_31304 = (state_31317[(2)]);
var inst_31305 = (inst_31294 + (1));
var inst_31294__$1 = inst_31305;
var state_31317__$1 = (function (){var statearr_31328 = state_31317;
(statearr_31328[(8)] = inst_31294__$1);

(statearr_31328[(10)] = inst_31304);

return statearr_31328;
})();
var statearr_31329_31351 = state_31317__$1;
(statearr_31329_31351[(2)] = null);

(statearr_31329_31351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31318 === (9))){
var state_31317__$1 = state_31317;
var statearr_31330_31352 = state_31317__$1;
(statearr_31330_31352[(2)] = null);

(statearr_31330_31352[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31318 === (5))){
var state_31317__$1 = state_31317;
var statearr_31331_31353 = state_31317__$1;
(statearr_31331_31353[(2)] = null);

(statearr_31331_31353[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31318 === (10))){
var inst_31309 = (state_31317[(2)]);
var state_31317__$1 = state_31317;
var statearr_31332_31354 = state_31317__$1;
(statearr_31332_31354[(2)] = inst_31309);

(statearr_31332_31354[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31318 === (8))){
var inst_31299 = (state_31317[(7)]);
var state_31317__$1 = state_31317;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31317__$1,(11),out,inst_31299);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___31344,out))
;
return ((function (switch__23913__auto__,c__23928__auto___31344,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_31336 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31336[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_31336[(1)] = (1));

return statearr_31336;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_31317){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31337){if((e31337 instanceof Object)){
var ex__23917__auto__ = e31337;
var statearr_31338_31355 = state_31317;
(statearr_31338_31355[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31317);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31337;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31356 = state_31317;
state_31317 = G__31356;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_31317){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_31317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___31344,out))
})();
var state__23930__auto__ = (function (){var statearr_31339 = f__23929__auto__.call(null);
(statearr_31339[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___31344);

return statearr_31339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___31344,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t31364 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31364 = (function (map_LT_,f,ch,meta31365){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31365 = meta31365;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31364.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31366,meta31365__$1){
var self__ = this;
var _31366__$1 = this;
return (new cljs.core.async.t31364(self__.map_LT_,self__.f,self__.ch,meta31365__$1));
});

cljs.core.async.t31364.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31366){
var self__ = this;
var _31366__$1 = this;
return self__.meta31365;
});

cljs.core.async.t31364.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31364.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t31364.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t31364.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31364.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t31367 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31367 = (function (map_LT_,f,ch,meta31365,_,fn1,meta31368){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31365 = meta31365;
this._ = _;
this.fn1 = fn1;
this.meta31368 = meta31368;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31367.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31369,meta31368__$1){
var self__ = this;
var _31369__$1 = this;
return (new cljs.core.async.t31367(self__.map_LT_,self__.f,self__.ch,self__.meta31365,self__._,self__.fn1,meta31368__$1));
});})(___$1))
;

cljs.core.async.t31367.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31369){
var self__ = this;
var _31369__$1 = this;
return self__.meta31368;
});})(___$1))
;

cljs.core.async.t31367.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t31367.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t31367.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31357_SHARP_){
return f1.call(null,(((p1__31357_SHARP_ == null))?null:self__.f.call(null,p1__31357_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t31367.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31365","meta31365",1834147686,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t31364","cljs.core.async/t31364",894441875,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31368","meta31368",-736583945,null)], null);
});})(___$1))
;

cljs.core.async.t31367.cljs$lang$type = true;

cljs.core.async.t31367.cljs$lang$ctorStr = "cljs.core.async/t31367";

cljs.core.async.t31367.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t31367");
});})(___$1))
;

cljs.core.async.__GT_t31367 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t31367(map_LT___$1,f__$1,ch__$1,meta31365__$1,___$2,fn1__$1,meta31368){
return (new cljs.core.async.t31367(map_LT___$1,f__$1,ch__$1,meta31365__$1,___$2,fn1__$1,meta31368));
});})(___$1))
;

}

return (new cljs.core.async.t31367(self__.map_LT_,self__.f,self__.ch,self__.meta31365,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__18477__auto__ = ret;
if(cljs.core.truth_(and__18477__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__18477__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t31364.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31364.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t31364.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31365","meta31365",1834147686,null)], null);
});

cljs.core.async.t31364.cljs$lang$type = true;

cljs.core.async.t31364.cljs$lang$ctorStr = "cljs.core.async/t31364";

cljs.core.async.t31364.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t31364");
});

cljs.core.async.__GT_t31364 = (function cljs$core$async$map_LT__$___GT_t31364(map_LT___$1,f__$1,ch__$1,meta31365){
return (new cljs.core.async.t31364(map_LT___$1,f__$1,ch__$1,meta31365));
});

}

return (new cljs.core.async.t31364(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t31373 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31373 = (function (map_GT_,f,ch,meta31374){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta31374 = meta31374;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31373.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31375,meta31374__$1){
var self__ = this;
var _31375__$1 = this;
return (new cljs.core.async.t31373(self__.map_GT_,self__.f,self__.ch,meta31374__$1));
});

cljs.core.async.t31373.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31375){
var self__ = this;
var _31375__$1 = this;
return self__.meta31374;
});

cljs.core.async.t31373.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31373.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t31373.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31373.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t31373.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31373.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t31373.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31374","meta31374",616257724,null)], null);
});

cljs.core.async.t31373.cljs$lang$type = true;

cljs.core.async.t31373.cljs$lang$ctorStr = "cljs.core.async/t31373";

cljs.core.async.t31373.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t31373");
});

cljs.core.async.__GT_t31373 = (function cljs$core$async$map_GT__$___GT_t31373(map_GT___$1,f__$1,ch__$1,meta31374){
return (new cljs.core.async.t31373(map_GT___$1,f__$1,ch__$1,meta31374));
});

}

return (new cljs.core.async.t31373(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t31379 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31379 = (function (filter_GT_,p,ch,meta31380){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta31380 = meta31380;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31379.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31381,meta31380__$1){
var self__ = this;
var _31381__$1 = this;
return (new cljs.core.async.t31379(self__.filter_GT_,self__.p,self__.ch,meta31380__$1));
});

cljs.core.async.t31379.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31381){
var self__ = this;
var _31381__$1 = this;
return self__.meta31380;
});

cljs.core.async.t31379.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31379.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t31379.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t31379.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31379.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t31379.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31379.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t31379.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31380","meta31380",-62968425,null)], null);
});

cljs.core.async.t31379.cljs$lang$type = true;

cljs.core.async.t31379.cljs$lang$ctorStr = "cljs.core.async/t31379";

cljs.core.async.t31379.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t31379");
});

cljs.core.async.__GT_t31379 = (function cljs$core$async$filter_GT__$___GT_t31379(filter_GT___$1,p__$1,ch__$1,meta31380){
return (new cljs.core.async.t31379(filter_GT___$1,p__$1,ch__$1,meta31380));
});

}

return (new cljs.core.async.t31379(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var args31382 = [];
var len__19528__auto___31426 = arguments.length;
var i__19529__auto___31427 = (0);
while(true){
if((i__19529__auto___31427 < len__19528__auto___31426)){
args31382.push((arguments[i__19529__auto___31427]));

var G__31428 = (i__19529__auto___31427 + (1));
i__19529__auto___31427 = G__31428;
continue;
} else {
}
break;
}

var G__31384 = args31382.length;
switch (G__31384) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31382.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23928__auto___31430 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___31430,out){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___31430,out){
return (function (state_31405){
var state_val_31406 = (state_31405[(1)]);
if((state_val_31406 === (7))){
var inst_31401 = (state_31405[(2)]);
var state_31405__$1 = state_31405;
var statearr_31407_31431 = state_31405__$1;
(statearr_31407_31431[(2)] = inst_31401);

(statearr_31407_31431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31406 === (1))){
var state_31405__$1 = state_31405;
var statearr_31408_31432 = state_31405__$1;
(statearr_31408_31432[(2)] = null);

(statearr_31408_31432[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31406 === (4))){
var inst_31387 = (state_31405[(7)]);
var inst_31387__$1 = (state_31405[(2)]);
var inst_31388 = (inst_31387__$1 == null);
var state_31405__$1 = (function (){var statearr_31409 = state_31405;
(statearr_31409[(7)] = inst_31387__$1);

return statearr_31409;
})();
if(cljs.core.truth_(inst_31388)){
var statearr_31410_31433 = state_31405__$1;
(statearr_31410_31433[(1)] = (5));

} else {
var statearr_31411_31434 = state_31405__$1;
(statearr_31411_31434[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31406 === (6))){
var inst_31387 = (state_31405[(7)]);
var inst_31392 = p.call(null,inst_31387);
var state_31405__$1 = state_31405;
if(cljs.core.truth_(inst_31392)){
var statearr_31412_31435 = state_31405__$1;
(statearr_31412_31435[(1)] = (8));

} else {
var statearr_31413_31436 = state_31405__$1;
(statearr_31413_31436[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31406 === (3))){
var inst_31403 = (state_31405[(2)]);
var state_31405__$1 = state_31405;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31405__$1,inst_31403);
} else {
if((state_val_31406 === (2))){
var state_31405__$1 = state_31405;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31405__$1,(4),ch);
} else {
if((state_val_31406 === (11))){
var inst_31395 = (state_31405[(2)]);
var state_31405__$1 = state_31405;
var statearr_31414_31437 = state_31405__$1;
(statearr_31414_31437[(2)] = inst_31395);

(statearr_31414_31437[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31406 === (9))){
var state_31405__$1 = state_31405;
var statearr_31415_31438 = state_31405__$1;
(statearr_31415_31438[(2)] = null);

(statearr_31415_31438[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31406 === (5))){
var inst_31390 = cljs.core.async.close_BANG_.call(null,out);
var state_31405__$1 = state_31405;
var statearr_31416_31439 = state_31405__$1;
(statearr_31416_31439[(2)] = inst_31390);

(statearr_31416_31439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31406 === (10))){
var inst_31398 = (state_31405[(2)]);
var state_31405__$1 = (function (){var statearr_31417 = state_31405;
(statearr_31417[(8)] = inst_31398);

return statearr_31417;
})();
var statearr_31418_31440 = state_31405__$1;
(statearr_31418_31440[(2)] = null);

(statearr_31418_31440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31406 === (8))){
var inst_31387 = (state_31405[(7)]);
var state_31405__$1 = state_31405;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31405__$1,(11),out,inst_31387);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___31430,out))
;
return ((function (switch__23913__auto__,c__23928__auto___31430,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_31422 = [null,null,null,null,null,null,null,null,null];
(statearr_31422[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_31422[(1)] = (1));

return statearr_31422;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_31405){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31423){if((e31423 instanceof Object)){
var ex__23917__auto__ = e31423;
var statearr_31424_31441 = state_31405;
(statearr_31424_31441[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31405);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31423;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31442 = state_31405;
state_31405 = G__31442;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_31405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_31405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___31430,out))
})();
var state__23930__auto__ = (function (){var statearr_31425 = f__23929__auto__.call(null);
(statearr_31425[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___31430);

return statearr_31425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___31430,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var args31443 = [];
var len__19528__auto___31446 = arguments.length;
var i__19529__auto___31447 = (0);
while(true){
if((i__19529__auto___31447 < len__19528__auto___31446)){
args31443.push((arguments[i__19529__auto___31447]));

var G__31448 = (i__19529__auto___31447 + (1));
i__19529__auto___31447 = G__31448;
continue;
} else {
}
break;
}

var G__31445 = args31443.length;
switch (G__31445) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31443.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__23928__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto__){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto__){
return (function (state_31615){
var state_val_31616 = (state_31615[(1)]);
if((state_val_31616 === (7))){
var inst_31611 = (state_31615[(2)]);
var state_31615__$1 = state_31615;
var statearr_31617_31658 = state_31615__$1;
(statearr_31617_31658[(2)] = inst_31611);

(statearr_31617_31658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (20))){
var inst_31581 = (state_31615[(7)]);
var inst_31592 = (state_31615[(2)]);
var inst_31593 = cljs.core.next.call(null,inst_31581);
var inst_31567 = inst_31593;
var inst_31568 = null;
var inst_31569 = (0);
var inst_31570 = (0);
var state_31615__$1 = (function (){var statearr_31618 = state_31615;
(statearr_31618[(8)] = inst_31567);

(statearr_31618[(9)] = inst_31570);

(statearr_31618[(10)] = inst_31569);

(statearr_31618[(11)] = inst_31568);

(statearr_31618[(12)] = inst_31592);

return statearr_31618;
})();
var statearr_31619_31659 = state_31615__$1;
(statearr_31619_31659[(2)] = null);

(statearr_31619_31659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (1))){
var state_31615__$1 = state_31615;
var statearr_31620_31660 = state_31615__$1;
(statearr_31620_31660[(2)] = null);

(statearr_31620_31660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (4))){
var inst_31556 = (state_31615[(13)]);
var inst_31556__$1 = (state_31615[(2)]);
var inst_31557 = (inst_31556__$1 == null);
var state_31615__$1 = (function (){var statearr_31621 = state_31615;
(statearr_31621[(13)] = inst_31556__$1);

return statearr_31621;
})();
if(cljs.core.truth_(inst_31557)){
var statearr_31622_31661 = state_31615__$1;
(statearr_31622_31661[(1)] = (5));

} else {
var statearr_31623_31662 = state_31615__$1;
(statearr_31623_31662[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (15))){
var state_31615__$1 = state_31615;
var statearr_31627_31663 = state_31615__$1;
(statearr_31627_31663[(2)] = null);

(statearr_31627_31663[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (21))){
var state_31615__$1 = state_31615;
var statearr_31628_31664 = state_31615__$1;
(statearr_31628_31664[(2)] = null);

(statearr_31628_31664[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (13))){
var inst_31567 = (state_31615[(8)]);
var inst_31570 = (state_31615[(9)]);
var inst_31569 = (state_31615[(10)]);
var inst_31568 = (state_31615[(11)]);
var inst_31577 = (state_31615[(2)]);
var inst_31578 = (inst_31570 + (1));
var tmp31624 = inst_31567;
var tmp31625 = inst_31569;
var tmp31626 = inst_31568;
var inst_31567__$1 = tmp31624;
var inst_31568__$1 = tmp31626;
var inst_31569__$1 = tmp31625;
var inst_31570__$1 = inst_31578;
var state_31615__$1 = (function (){var statearr_31629 = state_31615;
(statearr_31629[(8)] = inst_31567__$1);

(statearr_31629[(14)] = inst_31577);

(statearr_31629[(9)] = inst_31570__$1);

(statearr_31629[(10)] = inst_31569__$1);

(statearr_31629[(11)] = inst_31568__$1);

return statearr_31629;
})();
var statearr_31630_31665 = state_31615__$1;
(statearr_31630_31665[(2)] = null);

(statearr_31630_31665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (22))){
var state_31615__$1 = state_31615;
var statearr_31631_31666 = state_31615__$1;
(statearr_31631_31666[(2)] = null);

(statearr_31631_31666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (6))){
var inst_31556 = (state_31615[(13)]);
var inst_31565 = f.call(null,inst_31556);
var inst_31566 = cljs.core.seq.call(null,inst_31565);
var inst_31567 = inst_31566;
var inst_31568 = null;
var inst_31569 = (0);
var inst_31570 = (0);
var state_31615__$1 = (function (){var statearr_31632 = state_31615;
(statearr_31632[(8)] = inst_31567);

(statearr_31632[(9)] = inst_31570);

(statearr_31632[(10)] = inst_31569);

(statearr_31632[(11)] = inst_31568);

return statearr_31632;
})();
var statearr_31633_31667 = state_31615__$1;
(statearr_31633_31667[(2)] = null);

(statearr_31633_31667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (17))){
var inst_31581 = (state_31615[(7)]);
var inst_31585 = cljs.core.chunk_first.call(null,inst_31581);
var inst_31586 = cljs.core.chunk_rest.call(null,inst_31581);
var inst_31587 = cljs.core.count.call(null,inst_31585);
var inst_31567 = inst_31586;
var inst_31568 = inst_31585;
var inst_31569 = inst_31587;
var inst_31570 = (0);
var state_31615__$1 = (function (){var statearr_31634 = state_31615;
(statearr_31634[(8)] = inst_31567);

(statearr_31634[(9)] = inst_31570);

(statearr_31634[(10)] = inst_31569);

(statearr_31634[(11)] = inst_31568);

return statearr_31634;
})();
var statearr_31635_31668 = state_31615__$1;
(statearr_31635_31668[(2)] = null);

(statearr_31635_31668[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (3))){
var inst_31613 = (state_31615[(2)]);
var state_31615__$1 = state_31615;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31615__$1,inst_31613);
} else {
if((state_val_31616 === (12))){
var inst_31601 = (state_31615[(2)]);
var state_31615__$1 = state_31615;
var statearr_31636_31669 = state_31615__$1;
(statearr_31636_31669[(2)] = inst_31601);

(statearr_31636_31669[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (2))){
var state_31615__$1 = state_31615;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31615__$1,(4),in$);
} else {
if((state_val_31616 === (23))){
var inst_31609 = (state_31615[(2)]);
var state_31615__$1 = state_31615;
var statearr_31637_31670 = state_31615__$1;
(statearr_31637_31670[(2)] = inst_31609);

(statearr_31637_31670[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (19))){
var inst_31596 = (state_31615[(2)]);
var state_31615__$1 = state_31615;
var statearr_31638_31671 = state_31615__$1;
(statearr_31638_31671[(2)] = inst_31596);

(statearr_31638_31671[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (11))){
var inst_31567 = (state_31615[(8)]);
var inst_31581 = (state_31615[(7)]);
var inst_31581__$1 = cljs.core.seq.call(null,inst_31567);
var state_31615__$1 = (function (){var statearr_31639 = state_31615;
(statearr_31639[(7)] = inst_31581__$1);

return statearr_31639;
})();
if(inst_31581__$1){
var statearr_31640_31672 = state_31615__$1;
(statearr_31640_31672[(1)] = (14));

} else {
var statearr_31641_31673 = state_31615__$1;
(statearr_31641_31673[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (9))){
var inst_31603 = (state_31615[(2)]);
var inst_31604 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_31615__$1 = (function (){var statearr_31642 = state_31615;
(statearr_31642[(15)] = inst_31603);

return statearr_31642;
})();
if(cljs.core.truth_(inst_31604)){
var statearr_31643_31674 = state_31615__$1;
(statearr_31643_31674[(1)] = (21));

} else {
var statearr_31644_31675 = state_31615__$1;
(statearr_31644_31675[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (5))){
var inst_31559 = cljs.core.async.close_BANG_.call(null,out);
var state_31615__$1 = state_31615;
var statearr_31645_31676 = state_31615__$1;
(statearr_31645_31676[(2)] = inst_31559);

(statearr_31645_31676[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (14))){
var inst_31581 = (state_31615[(7)]);
var inst_31583 = cljs.core.chunked_seq_QMARK_.call(null,inst_31581);
var state_31615__$1 = state_31615;
if(inst_31583){
var statearr_31646_31677 = state_31615__$1;
(statearr_31646_31677[(1)] = (17));

} else {
var statearr_31647_31678 = state_31615__$1;
(statearr_31647_31678[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (16))){
var inst_31599 = (state_31615[(2)]);
var state_31615__$1 = state_31615;
var statearr_31648_31679 = state_31615__$1;
(statearr_31648_31679[(2)] = inst_31599);

(statearr_31648_31679[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31616 === (10))){
var inst_31570 = (state_31615[(9)]);
var inst_31568 = (state_31615[(11)]);
var inst_31575 = cljs.core._nth.call(null,inst_31568,inst_31570);
var state_31615__$1 = state_31615;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31615__$1,(13),out,inst_31575);
} else {
if((state_val_31616 === (18))){
var inst_31581 = (state_31615[(7)]);
var inst_31590 = cljs.core.first.call(null,inst_31581);
var state_31615__$1 = state_31615;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31615__$1,(20),out,inst_31590);
} else {
if((state_val_31616 === (8))){
var inst_31570 = (state_31615[(9)]);
var inst_31569 = (state_31615[(10)]);
var inst_31572 = (inst_31570 < inst_31569);
var inst_31573 = inst_31572;
var state_31615__$1 = state_31615;
if(cljs.core.truth_(inst_31573)){
var statearr_31649_31680 = state_31615__$1;
(statearr_31649_31680[(1)] = (10));

} else {
var statearr_31650_31681 = state_31615__$1;
(statearr_31650_31681[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto__))
;
return ((function (switch__23913__auto__,c__23928__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_31654 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31654[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__);

(statearr_31654[(1)] = (1));

return statearr_31654;
});
var cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____1 = (function (state_31615){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31615);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31655){if((e31655 instanceof Object)){
var ex__23917__auto__ = e31655;
var statearr_31656_31682 = state_31615;
(statearr_31656_31682[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31615);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31655;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31683 = state_31615;
state_31615 = G__31683;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__ = function(state_31615){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____1.call(this,state_31615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto__))
})();
var state__23930__auto__ = (function (){var statearr_31657 = f__23929__auto__.call(null);
(statearr_31657[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto__);

return statearr_31657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto__))
);

return c__23928__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var args31684 = [];
var len__19528__auto___31687 = arguments.length;
var i__19529__auto___31688 = (0);
while(true){
if((i__19529__auto___31688 < len__19528__auto___31687)){
args31684.push((arguments[i__19529__auto___31688]));

var G__31689 = (i__19529__auto___31688 + (1));
i__19529__auto___31688 = G__31689;
continue;
} else {
}
break;
}

var G__31686 = args31684.length;
switch (G__31686) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31684.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var args31691 = [];
var len__19528__auto___31694 = arguments.length;
var i__19529__auto___31695 = (0);
while(true){
if((i__19529__auto___31695 < len__19528__auto___31694)){
args31691.push((arguments[i__19529__auto___31695]));

var G__31696 = (i__19529__auto___31695 + (1));
i__19529__auto___31695 = G__31696;
continue;
} else {
}
break;
}

var G__31693 = args31691.length;
switch (G__31693) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31691.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var args31698 = [];
var len__19528__auto___31749 = arguments.length;
var i__19529__auto___31750 = (0);
while(true){
if((i__19529__auto___31750 < len__19528__auto___31749)){
args31698.push((arguments[i__19529__auto___31750]));

var G__31751 = (i__19529__auto___31750 + (1));
i__19529__auto___31750 = G__31751;
continue;
} else {
}
break;
}

var G__31700 = args31698.length;
switch (G__31700) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31698.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23928__auto___31753 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___31753,out){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___31753,out){
return (function (state_31724){
var state_val_31725 = (state_31724[(1)]);
if((state_val_31725 === (7))){
var inst_31719 = (state_31724[(2)]);
var state_31724__$1 = state_31724;
var statearr_31726_31754 = state_31724__$1;
(statearr_31726_31754[(2)] = inst_31719);

(statearr_31726_31754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31725 === (1))){
var inst_31701 = null;
var state_31724__$1 = (function (){var statearr_31727 = state_31724;
(statearr_31727[(7)] = inst_31701);

return statearr_31727;
})();
var statearr_31728_31755 = state_31724__$1;
(statearr_31728_31755[(2)] = null);

(statearr_31728_31755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31725 === (4))){
var inst_31704 = (state_31724[(8)]);
var inst_31704__$1 = (state_31724[(2)]);
var inst_31705 = (inst_31704__$1 == null);
var inst_31706 = cljs.core.not.call(null,inst_31705);
var state_31724__$1 = (function (){var statearr_31729 = state_31724;
(statearr_31729[(8)] = inst_31704__$1);

return statearr_31729;
})();
if(inst_31706){
var statearr_31730_31756 = state_31724__$1;
(statearr_31730_31756[(1)] = (5));

} else {
var statearr_31731_31757 = state_31724__$1;
(statearr_31731_31757[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31725 === (6))){
var state_31724__$1 = state_31724;
var statearr_31732_31758 = state_31724__$1;
(statearr_31732_31758[(2)] = null);

(statearr_31732_31758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31725 === (3))){
var inst_31721 = (state_31724[(2)]);
var inst_31722 = cljs.core.async.close_BANG_.call(null,out);
var state_31724__$1 = (function (){var statearr_31733 = state_31724;
(statearr_31733[(9)] = inst_31721);

return statearr_31733;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31724__$1,inst_31722);
} else {
if((state_val_31725 === (2))){
var state_31724__$1 = state_31724;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31724__$1,(4),ch);
} else {
if((state_val_31725 === (11))){
var inst_31704 = (state_31724[(8)]);
var inst_31713 = (state_31724[(2)]);
var inst_31701 = inst_31704;
var state_31724__$1 = (function (){var statearr_31734 = state_31724;
(statearr_31734[(10)] = inst_31713);

(statearr_31734[(7)] = inst_31701);

return statearr_31734;
})();
var statearr_31735_31759 = state_31724__$1;
(statearr_31735_31759[(2)] = null);

(statearr_31735_31759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31725 === (9))){
var inst_31704 = (state_31724[(8)]);
var state_31724__$1 = state_31724;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31724__$1,(11),out,inst_31704);
} else {
if((state_val_31725 === (5))){
var inst_31704 = (state_31724[(8)]);
var inst_31701 = (state_31724[(7)]);
var inst_31708 = cljs.core._EQ_.call(null,inst_31704,inst_31701);
var state_31724__$1 = state_31724;
if(inst_31708){
var statearr_31737_31760 = state_31724__$1;
(statearr_31737_31760[(1)] = (8));

} else {
var statearr_31738_31761 = state_31724__$1;
(statearr_31738_31761[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31725 === (10))){
var inst_31716 = (state_31724[(2)]);
var state_31724__$1 = state_31724;
var statearr_31739_31762 = state_31724__$1;
(statearr_31739_31762[(2)] = inst_31716);

(statearr_31739_31762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31725 === (8))){
var inst_31701 = (state_31724[(7)]);
var tmp31736 = inst_31701;
var inst_31701__$1 = tmp31736;
var state_31724__$1 = (function (){var statearr_31740 = state_31724;
(statearr_31740[(7)] = inst_31701__$1);

return statearr_31740;
})();
var statearr_31741_31763 = state_31724__$1;
(statearr_31741_31763[(2)] = null);

(statearr_31741_31763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___31753,out))
;
return ((function (switch__23913__auto__,c__23928__auto___31753,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_31745 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31745[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_31745[(1)] = (1));

return statearr_31745;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_31724){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31746){if((e31746 instanceof Object)){
var ex__23917__auto__ = e31746;
var statearr_31747_31764 = state_31724;
(statearr_31747_31764[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31724);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31746;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31765 = state_31724;
state_31724 = G__31765;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_31724){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_31724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___31753,out))
})();
var state__23930__auto__ = (function (){var statearr_31748 = f__23929__auto__.call(null);
(statearr_31748[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___31753);

return statearr_31748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___31753,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var args31766 = [];
var len__19528__auto___31836 = arguments.length;
var i__19529__auto___31837 = (0);
while(true){
if((i__19529__auto___31837 < len__19528__auto___31836)){
args31766.push((arguments[i__19529__auto___31837]));

var G__31838 = (i__19529__auto___31837 + (1));
i__19529__auto___31837 = G__31838;
continue;
} else {
}
break;
}

var G__31768 = args31766.length;
switch (G__31768) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31766.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23928__auto___31840 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___31840,out){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___31840,out){
return (function (state_31806){
var state_val_31807 = (state_31806[(1)]);
if((state_val_31807 === (7))){
var inst_31802 = (state_31806[(2)]);
var state_31806__$1 = state_31806;
var statearr_31808_31841 = state_31806__$1;
(statearr_31808_31841[(2)] = inst_31802);

(statearr_31808_31841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31807 === (1))){
var inst_31769 = (new Array(n));
var inst_31770 = inst_31769;
var inst_31771 = (0);
var state_31806__$1 = (function (){var statearr_31809 = state_31806;
(statearr_31809[(7)] = inst_31770);

(statearr_31809[(8)] = inst_31771);

return statearr_31809;
})();
var statearr_31810_31842 = state_31806__$1;
(statearr_31810_31842[(2)] = null);

(statearr_31810_31842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31807 === (4))){
var inst_31774 = (state_31806[(9)]);
var inst_31774__$1 = (state_31806[(2)]);
var inst_31775 = (inst_31774__$1 == null);
var inst_31776 = cljs.core.not.call(null,inst_31775);
var state_31806__$1 = (function (){var statearr_31811 = state_31806;
(statearr_31811[(9)] = inst_31774__$1);

return statearr_31811;
})();
if(inst_31776){
var statearr_31812_31843 = state_31806__$1;
(statearr_31812_31843[(1)] = (5));

} else {
var statearr_31813_31844 = state_31806__$1;
(statearr_31813_31844[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31807 === (15))){
var inst_31796 = (state_31806[(2)]);
var state_31806__$1 = state_31806;
var statearr_31814_31845 = state_31806__$1;
(statearr_31814_31845[(2)] = inst_31796);

(statearr_31814_31845[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31807 === (13))){
var state_31806__$1 = state_31806;
var statearr_31815_31846 = state_31806__$1;
(statearr_31815_31846[(2)] = null);

(statearr_31815_31846[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31807 === (6))){
var inst_31771 = (state_31806[(8)]);
var inst_31792 = (inst_31771 > (0));
var state_31806__$1 = state_31806;
if(cljs.core.truth_(inst_31792)){
var statearr_31816_31847 = state_31806__$1;
(statearr_31816_31847[(1)] = (12));

} else {
var statearr_31817_31848 = state_31806__$1;
(statearr_31817_31848[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31807 === (3))){
var inst_31804 = (state_31806[(2)]);
var state_31806__$1 = state_31806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31806__$1,inst_31804);
} else {
if((state_val_31807 === (12))){
var inst_31770 = (state_31806[(7)]);
var inst_31794 = cljs.core.vec.call(null,inst_31770);
var state_31806__$1 = state_31806;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31806__$1,(15),out,inst_31794);
} else {
if((state_val_31807 === (2))){
var state_31806__$1 = state_31806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31806__$1,(4),ch);
} else {
if((state_val_31807 === (11))){
var inst_31786 = (state_31806[(2)]);
var inst_31787 = (new Array(n));
var inst_31770 = inst_31787;
var inst_31771 = (0);
var state_31806__$1 = (function (){var statearr_31818 = state_31806;
(statearr_31818[(7)] = inst_31770);

(statearr_31818[(10)] = inst_31786);

(statearr_31818[(8)] = inst_31771);

return statearr_31818;
})();
var statearr_31819_31849 = state_31806__$1;
(statearr_31819_31849[(2)] = null);

(statearr_31819_31849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31807 === (9))){
var inst_31770 = (state_31806[(7)]);
var inst_31784 = cljs.core.vec.call(null,inst_31770);
var state_31806__$1 = state_31806;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31806__$1,(11),out,inst_31784);
} else {
if((state_val_31807 === (5))){
var inst_31770 = (state_31806[(7)]);
var inst_31779 = (state_31806[(11)]);
var inst_31774 = (state_31806[(9)]);
var inst_31771 = (state_31806[(8)]);
var inst_31778 = (inst_31770[inst_31771] = inst_31774);
var inst_31779__$1 = (inst_31771 + (1));
var inst_31780 = (inst_31779__$1 < n);
var state_31806__$1 = (function (){var statearr_31820 = state_31806;
(statearr_31820[(11)] = inst_31779__$1);

(statearr_31820[(12)] = inst_31778);

return statearr_31820;
})();
if(cljs.core.truth_(inst_31780)){
var statearr_31821_31850 = state_31806__$1;
(statearr_31821_31850[(1)] = (8));

} else {
var statearr_31822_31851 = state_31806__$1;
(statearr_31822_31851[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31807 === (14))){
var inst_31799 = (state_31806[(2)]);
var inst_31800 = cljs.core.async.close_BANG_.call(null,out);
var state_31806__$1 = (function (){var statearr_31824 = state_31806;
(statearr_31824[(13)] = inst_31799);

return statearr_31824;
})();
var statearr_31825_31852 = state_31806__$1;
(statearr_31825_31852[(2)] = inst_31800);

(statearr_31825_31852[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31807 === (10))){
var inst_31790 = (state_31806[(2)]);
var state_31806__$1 = state_31806;
var statearr_31826_31853 = state_31806__$1;
(statearr_31826_31853[(2)] = inst_31790);

(statearr_31826_31853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31807 === (8))){
var inst_31770 = (state_31806[(7)]);
var inst_31779 = (state_31806[(11)]);
var tmp31823 = inst_31770;
var inst_31770__$1 = tmp31823;
var inst_31771 = inst_31779;
var state_31806__$1 = (function (){var statearr_31827 = state_31806;
(statearr_31827[(7)] = inst_31770__$1);

(statearr_31827[(8)] = inst_31771);

return statearr_31827;
})();
var statearr_31828_31854 = state_31806__$1;
(statearr_31828_31854[(2)] = null);

(statearr_31828_31854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___31840,out))
;
return ((function (switch__23913__auto__,c__23928__auto___31840,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_31832 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31832[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_31832[(1)] = (1));

return statearr_31832;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_31806){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31833){if((e31833 instanceof Object)){
var ex__23917__auto__ = e31833;
var statearr_31834_31855 = state_31806;
(statearr_31834_31855[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31806);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31833;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31856 = state_31806;
state_31806 = G__31856;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_31806){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_31806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___31840,out))
})();
var state__23930__auto__ = (function (){var statearr_31835 = f__23929__auto__.call(null);
(statearr_31835[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___31840);

return statearr_31835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___31840,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var args31857 = [];
var len__19528__auto___31931 = arguments.length;
var i__19529__auto___31932 = (0);
while(true){
if((i__19529__auto___31932 < len__19528__auto___31931)){
args31857.push((arguments[i__19529__auto___31932]));

var G__31933 = (i__19529__auto___31932 + (1));
i__19529__auto___31932 = G__31933;
continue;
} else {
}
break;
}

var G__31859 = args31857.length;
switch (G__31859) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31857.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23928__auto___31935 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23928__auto___31935,out){
return (function (){
var f__23929__auto__ = (function (){var switch__23913__auto__ = ((function (c__23928__auto___31935,out){
return (function (state_31901){
var state_val_31902 = (state_31901[(1)]);
if((state_val_31902 === (7))){
var inst_31897 = (state_31901[(2)]);
var state_31901__$1 = state_31901;
var statearr_31903_31936 = state_31901__$1;
(statearr_31903_31936[(2)] = inst_31897);

(statearr_31903_31936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31902 === (1))){
var inst_31860 = [];
var inst_31861 = inst_31860;
var inst_31862 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_31901__$1 = (function (){var statearr_31904 = state_31901;
(statearr_31904[(7)] = inst_31862);

(statearr_31904[(8)] = inst_31861);

return statearr_31904;
})();
var statearr_31905_31937 = state_31901__$1;
(statearr_31905_31937[(2)] = null);

(statearr_31905_31937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31902 === (4))){
var inst_31865 = (state_31901[(9)]);
var inst_31865__$1 = (state_31901[(2)]);
var inst_31866 = (inst_31865__$1 == null);
var inst_31867 = cljs.core.not.call(null,inst_31866);
var state_31901__$1 = (function (){var statearr_31906 = state_31901;
(statearr_31906[(9)] = inst_31865__$1);

return statearr_31906;
})();
if(inst_31867){
var statearr_31907_31938 = state_31901__$1;
(statearr_31907_31938[(1)] = (5));

} else {
var statearr_31908_31939 = state_31901__$1;
(statearr_31908_31939[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31902 === (15))){
var inst_31891 = (state_31901[(2)]);
var state_31901__$1 = state_31901;
var statearr_31909_31940 = state_31901__$1;
(statearr_31909_31940[(2)] = inst_31891);

(statearr_31909_31940[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31902 === (13))){
var state_31901__$1 = state_31901;
var statearr_31910_31941 = state_31901__$1;
(statearr_31910_31941[(2)] = null);

(statearr_31910_31941[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31902 === (6))){
var inst_31861 = (state_31901[(8)]);
var inst_31886 = inst_31861.length;
var inst_31887 = (inst_31886 > (0));
var state_31901__$1 = state_31901;
if(cljs.core.truth_(inst_31887)){
var statearr_31911_31942 = state_31901__$1;
(statearr_31911_31942[(1)] = (12));

} else {
var statearr_31912_31943 = state_31901__$1;
(statearr_31912_31943[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31902 === (3))){
var inst_31899 = (state_31901[(2)]);
var state_31901__$1 = state_31901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31901__$1,inst_31899);
} else {
if((state_val_31902 === (12))){
var inst_31861 = (state_31901[(8)]);
var inst_31889 = cljs.core.vec.call(null,inst_31861);
var state_31901__$1 = state_31901;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31901__$1,(15),out,inst_31889);
} else {
if((state_val_31902 === (2))){
var state_31901__$1 = state_31901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31901__$1,(4),ch);
} else {
if((state_val_31902 === (11))){
var inst_31869 = (state_31901[(10)]);
var inst_31865 = (state_31901[(9)]);
var inst_31879 = (state_31901[(2)]);
var inst_31880 = [];
var inst_31881 = inst_31880.push(inst_31865);
var inst_31861 = inst_31880;
var inst_31862 = inst_31869;
var state_31901__$1 = (function (){var statearr_31913 = state_31901;
(statearr_31913[(7)] = inst_31862);

(statearr_31913[(11)] = inst_31879);

(statearr_31913[(12)] = inst_31881);

(statearr_31913[(8)] = inst_31861);

return statearr_31913;
})();
var statearr_31914_31944 = state_31901__$1;
(statearr_31914_31944[(2)] = null);

(statearr_31914_31944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31902 === (9))){
var inst_31861 = (state_31901[(8)]);
var inst_31877 = cljs.core.vec.call(null,inst_31861);
var state_31901__$1 = state_31901;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31901__$1,(11),out,inst_31877);
} else {
if((state_val_31902 === (5))){
var inst_31862 = (state_31901[(7)]);
var inst_31869 = (state_31901[(10)]);
var inst_31865 = (state_31901[(9)]);
var inst_31869__$1 = f.call(null,inst_31865);
var inst_31870 = cljs.core._EQ_.call(null,inst_31869__$1,inst_31862);
var inst_31871 = cljs.core.keyword_identical_QMARK_.call(null,inst_31862,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_31872 = (inst_31870) || (inst_31871);
var state_31901__$1 = (function (){var statearr_31915 = state_31901;
(statearr_31915[(10)] = inst_31869__$1);

return statearr_31915;
})();
if(cljs.core.truth_(inst_31872)){
var statearr_31916_31945 = state_31901__$1;
(statearr_31916_31945[(1)] = (8));

} else {
var statearr_31917_31946 = state_31901__$1;
(statearr_31917_31946[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31902 === (14))){
var inst_31894 = (state_31901[(2)]);
var inst_31895 = cljs.core.async.close_BANG_.call(null,out);
var state_31901__$1 = (function (){var statearr_31919 = state_31901;
(statearr_31919[(13)] = inst_31894);

return statearr_31919;
})();
var statearr_31920_31947 = state_31901__$1;
(statearr_31920_31947[(2)] = inst_31895);

(statearr_31920_31947[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31902 === (10))){
var inst_31884 = (state_31901[(2)]);
var state_31901__$1 = state_31901;
var statearr_31921_31948 = state_31901__$1;
(statearr_31921_31948[(2)] = inst_31884);

(statearr_31921_31948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31902 === (8))){
var inst_31869 = (state_31901[(10)]);
var inst_31861 = (state_31901[(8)]);
var inst_31865 = (state_31901[(9)]);
var inst_31874 = inst_31861.push(inst_31865);
var tmp31918 = inst_31861;
var inst_31861__$1 = tmp31918;
var inst_31862 = inst_31869;
var state_31901__$1 = (function (){var statearr_31922 = state_31901;
(statearr_31922[(7)] = inst_31862);

(statearr_31922[(8)] = inst_31861__$1);

(statearr_31922[(14)] = inst_31874);

return statearr_31922;
})();
var statearr_31923_31949 = state_31901__$1;
(statearr_31923_31949[(2)] = null);

(statearr_31923_31949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23928__auto___31935,out))
;
return ((function (switch__23913__auto__,c__23928__auto___31935,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_31927 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31927[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_31927[(1)] = (1));

return statearr_31927;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_31901){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31928){if((e31928 instanceof Object)){
var ex__23917__auto__ = e31928;
var statearr_31929_31950 = state_31901;
(statearr_31929_31950[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31901);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31928;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31951 = state_31901;
state_31901 = G__31951;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_31901){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_31901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23928__auto___31935,out))
})();
var state__23930__auto__ = (function (){var statearr_31930 = f__23929__auto__.call(null);
(statearr_31930[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23928__auto___31935);

return statearr_31930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23930__auto__);
});})(c__23928__auto___31935,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map