// Compiled by ClojureScript 1.7.48 {}
goog.provide('dragonmark.inputs.validation');
goog.require('cljs.core');
goog.require('dragonmark.inputs.schemas');
goog.require('schema.core');
goog.require('dragonmark.inputs.date_utils');
goog.require('jkkramer.verily');
goog.require('schema.coerce');
goog.require('clojure.set');
goog.require('dragonmark.inputs.extern');
goog.require('clojure.string');
/**
 * The validation error message keys for a field.
 * The key is not the rule key but the message key.
 */
dragonmark.inputs.validation.sch_errors_list = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.named.call(null,schema.core.Keyword,"message")], null);
/**
 * Describes the input's error data structure.
 * A field can have multiples errors.
 */
dragonmark.inputs.validation.sch_errors = new cljs.core.PersistentArrayMap.fromArray([dragonmark.inputs.schemas.sch_field,dragonmark.inputs.validation.sch_errors_list], true, false);
/**
 * Describes the Verily errors data structure.
 */
dragonmark.inputs.validation.sch_verily_errs = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dragonmark.inputs.schemas.sch_field], null),new cljs.core.Keyword(null,"msg","msg",-1386103444),schema.core.Keyword], null)], null);
/**
 * Describes the Schema errors data structure
 */
dragonmark.inputs.validation.sch_schema_errs = new cljs.core.PersistentArrayMap.fromArray([dragonmark.inputs.schemas.sch_field,schema.core.Any], true, false);
/**
 * Do not validate an empty string as a valid s/Str
 */
dragonmark.inputs.validation.empty_string_coercer = (function dragonmark$inputs$validation$empty_string_coercer(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return s;
}
});
/**
 * Coerce an input string to a date.
 * The default format is used.
 * A blank string is coerced to nil.
 */
dragonmark.inputs.validation.inst_coercer = (function dragonmark$inputs$validation$inst_coercer(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return dragonmark.inputs.date_utils.parse.call(null,dragonmark.inputs.date_utils.fmt.call(null,dragonmark.inputs.date_utils.default_fmt,s));
}
});
/**
 * Schema coercers used for inputs that are sent as string.
 */
dragonmark.inputs.validation.validation_coercer = new cljs.core.PersistentArrayMap.fromArray([schema.core.Num,schema.coerce.safe.call(null,schema.coerce.edn_read_string),schema.core.Regex,dragonmark.inputs.validation.empty_string_coercer,schema.core.Str,dragonmark.inputs.validation.empty_string_coercer,schema.core.maybe.call(null,schema.core.Str),dragonmark.inputs.validation.empty_string_coercer,schema.core.Inst,dragonmark.inputs.validation.inst_coercer], true, false);
/**
 * Generic sequence of validation.
 * The first args can be partially applied to generate a custom validator.
 */
dragonmark.inputs.validation.validate = (function dragonmark$inputs$validation$validate(validation_fn,post,m){
return post.call(null,validation_fn.call(null,m));
});
var ufv___33770 = schema.utils.use_fn_validation;
var output_schema33749_33771 = dragonmark.inputs.validation.sch_errors;
var input_schema33750_33772 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.validation.sch_schema_errs,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-schema-errs","sch-schema-errs",1633294259,null)], null)))], null);
var input_checker33751_33773 = schema.core.checker.call(null,input_schema33750_33772);
var output_checker33752_33774 = schema.core.checker.call(null,output_schema33749_33771);
/**
 * Inputs: [errs :- sch-schema-errs]
 * Returns: sch-errors
 * 
 * Transforms the Schema's error data structure into the common error data structure.
 * For the moment Schema error are treated as missing field.
 */
dragonmark.inputs.validation.transform_schema_errors = ((function (ufv___33770,output_schema33749_33771,input_schema33750_33772,input_checker33751_33773,output_checker33752_33774){
return (function dragonmark$inputs$validation$transform_schema_errors(G__33753){
var validate__21152__auto__ = ufv___33770.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___33775 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__33753], null);
var temp__4425__auto___33776 = input_checker33751_33773.call(null,args__21153__auto___33775);
if(cljs.core.truth_(temp__4425__auto___33776)){
var error__21154__auto___33777 = temp__4425__auto___33776;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-schema-errors","transform-schema-errors",1319365661,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Schema's error data structure into the common error data structure.\n  For the moment Schema error are treated as missing field."], null)),cljs.core.pr_str.call(null,error__21154__auto___33777)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema33750_33772,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___33775,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33777], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var errs = G__33753;
while(true){
var temp__4425__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(errs);
if(cljs.core.truth_(temp__4425__auto__)){
var errors = temp__4425__auto__;
return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.concat,(function (){var iter__19242__auto__ = ((function (errors,temp__4425__auto__,validate__21152__auto__,ufv___33770,output_schema33749_33771,input_schema33750_33772,input_checker33751_33773,output_checker33752_33774){
return (function dragonmark$inputs$validation$transform_schema_errors_$_iter__33762(s__33763){
return (new cljs.core.LazySeq(null,((function (errors,temp__4425__auto__,validate__21152__auto__,ufv___33770,output_schema33749_33771,input_schema33750_33772,input_checker33751_33773,output_checker33752_33774){
return (function (){
var s__33763__$1 = s__33763;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__33763__$1);
if(temp__4425__auto____$1){
var s__33763__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33763__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__33763__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__33765 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__33764 = (0);
while(true){
if((i__33764 < size__19241__auto__)){
var vec__33768 = cljs.core._nth.call(null,c__19240__auto__,i__33764);
var k = cljs.core.nth.call(null,vec__33768,(0),null);
var _ = cljs.core.nth.call(null,vec__33768,(1),null);
cljs.core.chunk_append.call(null,b__33765,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mandatory","mandatory",542802336)], null)], true, false));

var G__33778 = (i__33764 + (1));
i__33764 = G__33778;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33765),dragonmark$inputs$validation$transform_schema_errors_$_iter__33762.call(null,cljs.core.chunk_rest.call(null,s__33763__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33765),null);
}
} else {
var vec__33769 = cljs.core.first.call(null,s__33763__$2);
var k = cljs.core.nth.call(null,vec__33769,(0),null);
var _ = cljs.core.nth.call(null,vec__33769,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mandatory","mandatory",542802336)], null)], true, false),dragonmark$inputs$validation$transform_schema_errors_$_iter__33762.call(null,cljs.core.rest.call(null,s__33763__$2)));
}
} else {
return null;
}
break;
}
});})(errors,temp__4425__auto__,validate__21152__auto__,ufv___33770,output_schema33749_33771,input_schema33750_33772,input_checker33751_33773,output_checker33752_33774))
,null,null));
});})(errors,temp__4425__auto__,validate__21152__auto__,ufv___33770,output_schema33749_33771,input_schema33750_33772,input_checker33751_33773,output_checker33752_33774))
;
return iter__19242__auto__.call(null,errors);
})());
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___33779 = output_checker33752_33774.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___33779)){
var error__21154__auto___33780 = temp__4425__auto___33779;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-schema-errors","transform-schema-errors",1319365661,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Schema's error data structure into the common error data structure.\n  For the moment Schema error are treated as missing field."], null)),cljs.core.pr_str.call(null,error__21154__auto___33780)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema33749_33771,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33780], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___33770,output_schema33749_33771,input_schema33750_33772,input_checker33751_33773,output_checker33752_33774))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.transform_schema_errors),schema.core.make_fn_schema.call(null,output_schema33749_33771,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema33750_33772], null)));
var ufv___33806 = schema.utils.use_fn_validation;
var output_schema33781_33807 = dragonmark.inputs.validation.sch_errors;
var input_schema33782_33808 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.validation.sch_verily_errs,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-verily-errs","sch-verily-errs",-1962614795,null)], null)))], null);
var input_checker33783_33809 = schema.core.checker.call(null,input_schema33782_33808);
var output_checker33784_33810 = schema.core.checker.call(null,output_schema33781_33807);
/**
 * Inputs: [errs :- sch-verily-errs]
 * Returns: sch-errors
 * 
 * Transforms the Verily's error data structure into the common error data structure.
 */
dragonmark.inputs.validation.transform_verily_errors = ((function (ufv___33806,output_schema33781_33807,input_schema33782_33808,input_checker33783_33809,output_checker33784_33810){
return (function dragonmark$inputs$validation$transform_verily_errors(G__33785){
var validate__21152__auto__ = ufv___33806.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___33811 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__33785], null);
var temp__4425__auto___33812 = input_checker33783_33809.call(null,args__21153__auto___33811);
if(cljs.core.truth_(temp__4425__auto___33812)){
var error__21154__auto___33813 = temp__4425__auto___33812;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-verily-errors","transform-verily-errors",-197737448,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Verily's error data structure into the common error data structure."], null)),cljs.core.pr_str.call(null,error__21154__auto___33813)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema33782_33808,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___33811,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33813], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var errs = G__33785;
while(true){
if(cljs.core.seq.call(null,errs)){
return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.concat,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21152__auto__,ufv___33806,output_schema33781_33807,input_schema33782_33808,input_checker33783_33809,output_checker33784_33810){
return (function dragonmark$inputs$validation$transform_verily_errors_$_iter__33796(s__33797){
return (new cljs.core.LazySeq(null,((function (validate__21152__auto__,ufv___33806,output_schema33781_33807,input_schema33782_33808,input_checker33783_33809,output_checker33784_33810){
return (function (){
var s__33797__$1 = s__33797;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__33797__$1);
if(temp__4425__auto__){
var xs__4977__auto__ = temp__4425__auto__;
var map__33804 = cljs.core.first.call(null,xs__4977__auto__);
var map__33804__$1 = ((((!((map__33804 == null)))?((((map__33804.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33804.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33804):map__33804);
var keys = cljs.core.get.call(null,map__33804__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var msg = cljs.core.get.call(null,map__33804__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var iterys__19238__auto__ = ((function (s__33797__$1,map__33804,map__33804__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21152__auto__,ufv___33806,output_schema33781_33807,input_schema33782_33808,input_checker33783_33809,output_checker33784_33810){
return (function dragonmark$inputs$validation$transform_verily_errors_$_iter__33796_$_iter__33798(s__33799){
return (new cljs.core.LazySeq(null,((function (s__33797__$1,map__33804,map__33804__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21152__auto__,ufv___33806,output_schema33781_33807,input_schema33782_33808,input_checker33783_33809,output_checker33784_33810){
return (function (){
var s__33799__$1 = s__33799;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__33799__$1);
if(temp__4425__auto____$1){
var s__33799__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33799__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__33799__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__33801 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__33800 = (0);
while(true){
if((i__33800 < size__19241__auto__)){
var k = cljs.core._nth.call(null,c__19240__auto__,i__33800);
cljs.core.chunk_append.call(null,b__33801,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null)], true, false));

var G__33814 = (i__33800 + (1));
i__33800 = G__33814;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33801),dragonmark$inputs$validation$transform_verily_errors_$_iter__33796_$_iter__33798.call(null,cljs.core.chunk_rest.call(null,s__33799__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33801),null);
}
} else {
var k = cljs.core.first.call(null,s__33799__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null)], true, false),dragonmark$inputs$validation$transform_verily_errors_$_iter__33796_$_iter__33798.call(null,cljs.core.rest.call(null,s__33799__$2)));
}
} else {
return null;
}
break;
}
});})(s__33797__$1,map__33804,map__33804__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21152__auto__,ufv___33806,output_schema33781_33807,input_schema33782_33808,input_checker33783_33809,output_checker33784_33810))
,null,null));
});})(s__33797__$1,map__33804,map__33804__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21152__auto__,ufv___33806,output_schema33781_33807,input_schema33782_33808,input_checker33783_33809,output_checker33784_33810))
;
var fs__19239__auto__ = cljs.core.seq.call(null,iterys__19238__auto__.call(null,keys));
if(fs__19239__auto__){
return cljs.core.concat.call(null,fs__19239__auto__,dragonmark$inputs$validation$transform_verily_errors_$_iter__33796.call(null,cljs.core.rest.call(null,s__33797__$1)));
} else {
var G__33815 = cljs.core.rest.call(null,s__33797__$1);
s__33797__$1 = G__33815;
continue;
}
} else {
return null;
}
break;
}
});})(validate__21152__auto__,ufv___33806,output_schema33781_33807,input_schema33782_33808,input_checker33783_33809,output_checker33784_33810))
,null,null));
});})(validate__21152__auto__,ufv___33806,output_schema33781_33807,input_schema33782_33808,input_checker33783_33809,output_checker33784_33810))
;
return iter__19242__auto__.call(null,errs);
})());
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___33816 = output_checker33784_33810.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___33816)){
var error__21154__auto___33817 = temp__4425__auto___33816;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-verily-errors","transform-verily-errors",-197737448,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Verily's error data structure into the common error data structure."], null)),cljs.core.pr_str.call(null,error__21154__auto___33817)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema33781_33807,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33817], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___33806,output_schema33781_33807,input_schema33782_33808,input_checker33783_33809,output_checker33784_33810))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.transform_verily_errors),schema.core.make_fn_schema.call(null,output_schema33781_33807,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema33782_33808], null)));
dragonmark.inputs.validation.build_verily_validator = (function dragonmark$inputs$validation$build_verily_validator(rules){
return cljs.core.partial.call(null,dragonmark.inputs.validation.validate,jkkramer.verily.validations__GT_fn.call(null,rules),dragonmark.inputs.validation.transform_verily_errors);
});
dragonmark.inputs.validation.inter_fields_rules = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"lower-or-equal","lower-or-equal",-1150663190),null,new cljs.core.Keyword(null,"greater-or-equal","greater-or-equal",302221395),null,new cljs.core.Keyword(null,"lower","lower",1120320821),null,new cljs.core.Keyword(null,"greater","greater",1370260601),null,new cljs.core.Keyword(null,"equal","equal",-1921681350),null], null), null);
/**
 * Build the map error->rule
 */
dragonmark.inputs.validation.error__GT_rule = (function dragonmark$inputs$validation$error__GT_rule(rules){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = (function dragonmark$inputs$validation$error__GT_rule_$_iter__33822(s__33823){
return (new cljs.core.LazySeq(null,(function (){
var s__33823__$1 = s__33823;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__33823__$1);
if(temp__4425__auto__){
var s__33823__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33823__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__33823__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__33825 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__33824 = (0);
while(true){
if((i__33824 < size__19241__auto__)){
var r = cljs.core._nth.call(null,c__19240__auto__,i__33824);
cljs.core.chunk_append.call(null,b__33825,cljs.core.juxt.call(null,cljs.core.last,cljs.core.first).call(null,r));

var G__33826 = (i__33824 + (1));
i__33824 = G__33826;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33825),dragonmark$inputs$validation$error__GT_rule_$_iter__33822.call(null,cljs.core.chunk_rest.call(null,s__33823__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33825),null);
}
} else {
var r = cljs.core.first.call(null,s__33823__$2);
return cljs.core.cons.call(null,cljs.core.juxt.call(null,cljs.core.last,cljs.core.first).call(null,r),dragonmark$inputs$validation$error__GT_rule_$_iter__33822.call(null,cljs.core.rest.call(null,s__33823__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,rules);
})());
});
/**
 * Determines validation dependencies between fields
 */
dragonmark.inputs.validation.fields_dependencies = (function dragonmark$inputs$validation$fields_dependencies(){
var args33827 = [];
var len__19528__auto___33842 = arguments.length;
var i__19529__auto___33843 = (0);
while(true){
if((i__19529__auto___33843 < len__19528__auto___33842)){
args33827.push((arguments[i__19529__auto___33843]));

var G__33844 = (i__19529__auto___33843 + (1));
i__19529__auto___33843 = G__33844;
continue;
} else {
}
break;
}

var G__33829 = args33827.length;
switch (G__33829) {
case 1:
return dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33827.length)].join('')));

}
});

dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$1 = (function (rules){
return dragonmark.inputs.validation.fields_dependencies.call(null,dragonmark.inputs.validation.inter_fields_rules,rules);
});

dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$2 = (function (rule_keys,rules){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = (function dragonmark$inputs$validation$iter__33830(s__33831){
return (new cljs.core.LazySeq(null,(function (){
var s__33831__$1 = s__33831;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__33831__$1);
if(temp__4425__auto__){
var s__33831__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33831__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__33831__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__33833 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__33832 = (0);
while(true){
if((i__33832 < size__19241__auto__)){
var vec__33838 = cljs.core._nth.call(null,c__19240__auto__,i__33832);
var r = cljs.core.nth.call(null,vec__33838,(0),null);
var fs = cljs.core.nth.call(null,vec__33838,(1),null);
var m = cljs.core.nth.call(null,vec__33838,(2),null);
if(cljs.core.truth_(rule_keys.call(null,r))){
var vec__33839 = fs;
var f = cljs.core.nth.call(null,vec__33839,(0),null);
var deps = cljs.core.nthnext.call(null,vec__33839,(1));
cljs.core.chunk_append.call(null,b__33833,new cljs.core.PersistentArrayMap.fromArray([f,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"deps","deps",1883360319),deps,new cljs.core.Keyword(null,"mess","mess",530922968),m,new cljs.core.Keyword(null,"rule","rule",729973257),r], null)], true, false));

var G__33846 = (i__33832 + (1));
i__33832 = G__33846;
continue;
} else {
var G__33847 = (i__33832 + (1));
i__33832 = G__33847;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33833),dragonmark$inputs$validation$iter__33830.call(null,cljs.core.chunk_rest.call(null,s__33831__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33833),null);
}
} else {
var vec__33840 = cljs.core.first.call(null,s__33831__$2);
var r = cljs.core.nth.call(null,vec__33840,(0),null);
var fs = cljs.core.nth.call(null,vec__33840,(1),null);
var m = cljs.core.nth.call(null,vec__33840,(2),null);
if(cljs.core.truth_(rule_keys.call(null,r))){
var vec__33841 = fs;
var f = cljs.core.nth.call(null,vec__33841,(0),null);
var deps = cljs.core.nthnext.call(null,vec__33841,(1));
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([f,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"deps","deps",1883360319),deps,new cljs.core.Keyword(null,"mess","mess",530922968),m,new cljs.core.Keyword(null,"rule","rule",729973257),r], null)], true, false),dragonmark$inputs$validation$iter__33830.call(null,cljs.core.rest.call(null,s__33831__$2)));
} else {
var G__33848 = cljs.core.rest.call(null,s__33831__$2);
s__33831__$1 = G__33848;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,rules);
})());
});

dragonmark.inputs.validation.fields_dependencies.cljs$lang$maxFixedArity = 2;
var ufv___33855 = schema.utils.use_fn_validation;
var output_schema33849_33856 = dragonmark.inputs.schemas.sch_business_state;
var input_schema33850_33857 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,dragonmark.inputs.validation.sch_errors,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null)], null)))], null);
var input_checker33851_33858 = schema.core.checker.call(null,input_schema33850_33857);
var output_checker33852_33859 = schema.core.checker.call(null,output_schema33849_33856);
/**
 * Inputs: [state :- sch-business-state errs :- sch-errors]
 * Returns: sch-business-state
 * 
 * Set valid to false for each key in errors, true if absent
 */
dragonmark.inputs.validation.handle_errors = ((function (ufv___33855,output_schema33849_33856,input_schema33850_33857,input_checker33851_33858,output_checker33852_33859){
return (function dragonmark$inputs$validation$handle_errors(G__33853,G__33854){
var validate__21152__auto__ = ufv___33855.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___33860 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__33853,G__33854], null);
var temp__4425__auto___33861 = input_checker33851_33858.call(null,args__21153__auto___33860);
if(cljs.core.truth_(temp__4425__auto___33861)){
var error__21154__auto___33862 = temp__4425__auto___33861;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"handle-errors","handle-errors",1833858829,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set valid to false for each key in errors, true if absent"], null)),cljs.core.pr_str.call(null,error__21154__auto___33862)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema33850_33857,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___33860,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33862], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var state = G__33853;
var errs = G__33854;
while(true){
var err_ks = cljs.core.set.call(null,cljs.core.keys.call(null,errs));
var all_ks = cljs.core.set.call(null,cljs.core.keys.call(null,state));
var valid_ks = clojure.set.difference.call(null,all_ks,err_ks);
var state__$1 = cljs.core.reduce.call(null,((function (err_ks,all_ks,valid_ks,validate__21152__auto__,ufv___33855,output_schema33849_33856,input_schema33850_33857,input_checker33851_33858,output_checker33852_33859){
return (function (s,e){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),false),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"error","error",-978969032)], null),e.call(null,errs));
});})(err_ks,all_ks,valid_ks,validate__21152__auto__,ufv___33855,output_schema33849_33856,input_schema33850_33857,input_checker33851_33858,output_checker33852_33859))
,state,err_ks);
return cljs.core.reduce.call(null,((function (err_ks,all_ks,valid_ks,state__$1,validate__21152__auto__,ufv___33855,output_schema33849_33856,input_schema33850_33857,input_checker33851_33858,output_checker33852_33859){
return (function (s,e){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [e], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
});})(err_ks,all_ks,valid_ks,state__$1,validate__21152__auto__,ufv___33855,output_schema33849_33856,input_schema33850_33857,input_checker33851_33858,output_checker33852_33859))
,state__$1,valid_ks);
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___33863 = output_checker33852_33859.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___33863)){
var error__21154__auto___33864 = temp__4425__auto___33863;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"handle-errors","handle-errors",1833858829,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set valid to false for each key in errors, true if absent"], null)),cljs.core.pr_str.call(null,error__21154__auto___33864)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema33849_33856,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33864], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___33855,output_schema33849_33856,input_schema33850_33857,input_checker33851_33858,output_checker33852_33859))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.handle_errors),schema.core.make_fn_schema.call(null,output_schema33849_33856,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema33850_33857], null)));
var ufv___33886 = schema.utils.use_fn_validation;
var output_schema33865_33887 = dragonmark.inputs.schemas.sch_business_state;
var input_schema33866_33888 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker33867_33889 = schema.core.checker.call(null,input_schema33866_33888);
var output_checker33868_33890 = schema.core.checker.call(null,output_schema33865_33887);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.keep_fields_to_validate = ((function (ufv___33886,output_schema33865_33887,input_schema33866_33888,input_checker33867_33889,output_checker33868_33890){
return (function dragonmark$inputs$validation$keep_fields_to_validate(G__33869){
var validate__21152__auto__ = ufv___33886.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___33891 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__33869], null);
var temp__4425__auto___33892 = input_checker33867_33889.call(null,args__21153__auto___33891);
if(cljs.core.truth_(temp__4425__auto___33892)){
var error__21154__auto___33893 = temp__4425__auto___33892;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"keep-fields-to-validate","keep-fields-to-validate",943659297,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___33893)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema33866_33888,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___33891,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33893], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var bs = G__33869;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21152__auto__,ufv___33886,output_schema33865_33887,input_schema33866_33888,input_checker33867_33889,output_checker33868_33890){
return (function dragonmark$inputs$validation$keep_fields_to_validate_$_iter__33878(s__33879){
return (new cljs.core.LazySeq(null,((function (validate__21152__auto__,ufv___33886,output_schema33865_33887,input_schema33866_33888,input_checker33867_33889,output_checker33868_33890){
return (function (){
var s__33879__$1 = s__33879;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__33879__$1);
if(temp__4425__auto__){
var s__33879__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33879__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__33879__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__33881 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__33880 = (0);
while(true){
if((i__33880 < size__19241__auto__)){
var vec__33884 = cljs.core._nth.call(null,c__19240__auto__,i__33880);
var k = cljs.core.nth.call(null,vec__33884,(0),null);
var m = cljs.core.nth.call(null,vec__33884,(1),null);
var in$ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m);
var req = new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__18489__auto__ = req;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,in$));
}
})())){
cljs.core.chunk_append.call(null,b__33881,new cljs.core.PersistentArrayMap.fromArray([k,m], true, false));

var G__33894 = (i__33880 + (1));
i__33880 = G__33894;
continue;
} else {
var G__33895 = (i__33880 + (1));
i__33880 = G__33895;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33881),dragonmark$inputs$validation$keep_fields_to_validate_$_iter__33878.call(null,cljs.core.chunk_rest.call(null,s__33879__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33881),null);
}
} else {
var vec__33885 = cljs.core.first.call(null,s__33879__$2);
var k = cljs.core.nth.call(null,vec__33885,(0),null);
var m = cljs.core.nth.call(null,vec__33885,(1),null);
var in$ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m);
var req = new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__18489__auto__ = req;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,in$));
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,m], true, false),dragonmark$inputs$validation$keep_fields_to_validate_$_iter__33878.call(null,cljs.core.rest.call(null,s__33879__$2)));
} else {
var G__33896 = cljs.core.rest.call(null,s__33879__$2);
s__33879__$1 = G__33896;
continue;
}
}
} else {
return null;
}
break;
}
});})(validate__21152__auto__,ufv___33886,output_schema33865_33887,input_schema33866_33888,input_checker33867_33889,output_checker33868_33890))
,null,null));
});})(validate__21152__auto__,ufv___33886,output_schema33865_33887,input_schema33866_33888,input_checker33867_33889,output_checker33868_33890))
;
return iter__19242__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___33897 = output_checker33868_33890.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___33897)){
var error__21154__auto___33898 = temp__4425__auto___33897;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"keep-fields-to-validate","keep-fields-to-validate",943659297,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___33898)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema33865_33887,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33898], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___33886,output_schema33865_33887,input_schema33866_33888,input_checker33867_33889,output_checker33868_33890))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.keep_fields_to_validate),schema.core.make_fn_schema.call(null,output_schema33865_33887,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema33866_33888], null)));
var ufv___33905 = schema.utils.use_fn_validation;
var output_schema33899_33906 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema33900_33907 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"fk","fk",2038974178,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker33901_33908 = schema.core.checker.call(null,input_schema33900_33907);
var output_checker33902_33909 = schema.core.checker.call(null,output_schema33899_33906);
/**
 * Inputs: [bs :- sch-business-state fk :- s/Keyword]
 * Returns: {s/Keyword s/Any}
 * 
 * Extract map fk->value for a single field.
 */
dragonmark.inputs.validation.bs__GT_unit_map = ((function (ufv___33905,output_schema33899_33906,input_schema33900_33907,input_checker33901_33908,output_checker33902_33909){
return (function dragonmark$inputs$validation$bs__GT_unit_map(G__33903,G__33904){
var validate__21152__auto__ = ufv___33905.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___33910 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__33903,G__33904], null);
var temp__4425__auto___33911 = input_checker33901_33908.call(null,args__21153__auto___33910);
if(cljs.core.truth_(temp__4425__auto___33911)){
var error__21154__auto___33912 = temp__4425__auto___33911;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"bs->unit-map","bs->unit-map",827144882,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extract map fk->value for a single field."], null)),cljs.core.pr_str.call(null,error__21154__auto___33912)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema33900_33907,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___33910,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33912], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var bs = G__33903;
var fk = G__33904;
while(true){
var m = fk.call(null,bs);
return new cljs.core.PersistentArrayMap.fromArray([fk,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m)], true, false);
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___33913 = output_checker33902_33909.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___33913)){
var error__21154__auto___33914 = temp__4425__auto___33913;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"bs->unit-map","bs->unit-map",827144882,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extract map fk->value for a single field."], null)),cljs.core.pr_str.call(null,error__21154__auto___33914)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema33899_33906,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33914], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___33905,output_schema33899_33906,input_schema33900_33907,input_checker33901_33908,output_checker33902_33909))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.bs__GT_unit_map),schema.core.make_fn_schema.call(null,output_schema33899_33906,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema33900_33907], null)));
var ufv___33936 = schema.utils.use_fn_validation;
var output_schema33915_33937 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema33916_33938 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker33917_33939 = schema.core.checker.call(null,input_schema33916_33938);
var output_checker33918_33940 = schema.core.checker.call(null,output_schema33915_33937);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: {s/Keyword s/Any}
 * 
 * Transform the business local state into final map
 */
dragonmark.inputs.validation.business_state__GT_map = ((function (ufv___33936,output_schema33915_33937,input_schema33916_33938,input_checker33917_33939,output_checker33918_33940){
return (function dragonmark$inputs$validation$business_state__GT_map(G__33919){
var validate__21152__auto__ = ufv___33936.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___33941 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__33919], null);
var temp__4425__auto___33942 = input_checker33917_33939.call(null,args__21153__auto___33941);
if(cljs.core.truth_(temp__4425__auto___33942)){
var error__21154__auto___33943 = temp__4425__auto___33942;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"business-state->map","business-state->map",1652123635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform the business local state into final map"], null)),cljs.core.pr_str.call(null,error__21154__auto___33943)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema33916_33938,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___33941,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33943], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var bs = G__33919;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21152__auto__,ufv___33936,output_schema33915_33937,input_schema33916_33938,input_checker33917_33939,output_checker33918_33940){
return (function dragonmark$inputs$validation$business_state__GT_map_$_iter__33928(s__33929){
return (new cljs.core.LazySeq(null,((function (validate__21152__auto__,ufv___33936,output_schema33915_33937,input_schema33916_33938,input_checker33917_33939,output_checker33918_33940){
return (function (){
var s__33929__$1 = s__33929;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__33929__$1);
if(temp__4425__auto__){
var s__33929__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33929__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__33929__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__33931 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__33930 = (0);
while(true){
if((i__33930 < size__19241__auto__)){
var vec__33934 = cljs.core._nth.call(null,c__19240__auto__,i__33930);
var k = cljs.core.nth.call(null,vec__33934,(0),null);
var _ = cljs.core.nth.call(null,vec__33934,(1),null);
cljs.core.chunk_append.call(null,b__33931,dragonmark.inputs.validation.bs__GT_unit_map.call(null,bs,k));

var G__33944 = (i__33930 + (1));
i__33930 = G__33944;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33931),dragonmark$inputs$validation$business_state__GT_map_$_iter__33928.call(null,cljs.core.chunk_rest.call(null,s__33929__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33931),null);
}
} else {
var vec__33935 = cljs.core.first.call(null,s__33929__$2);
var k = cljs.core.nth.call(null,vec__33935,(0),null);
var _ = cljs.core.nth.call(null,vec__33935,(1),null);
return cljs.core.cons.call(null,dragonmark.inputs.validation.bs__GT_unit_map.call(null,bs,k),dragonmark$inputs$validation$business_state__GT_map_$_iter__33928.call(null,cljs.core.rest.call(null,s__33929__$2)));
}
} else {
return null;
}
break;
}
});})(validate__21152__auto__,ufv___33936,output_schema33915_33937,input_schema33916_33938,input_checker33917_33939,output_checker33918_33940))
,null,null));
});})(validate__21152__auto__,ufv___33936,output_schema33915_33937,input_schema33916_33938,input_checker33917_33939,output_checker33918_33940))
;
return iter__19242__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___33945 = output_checker33918_33940.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___33945)){
var error__21154__auto___33946 = temp__4425__auto___33945;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"business-state->map","business-state->map",1652123635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform the business local state into final map"], null)),cljs.core.pr_str.call(null,error__21154__auto___33946)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema33915_33937,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33946], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___33936,output_schema33915_33937,input_schema33916_33938,input_checker33917_33939,output_checker33918_33940))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.business_state__GT_map),schema.core.make_fn_schema.call(null,output_schema33915_33937,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema33916_33938], null)));
var ufv___33952 = schema.utils.use_fn_validation;
var output_schema33947_33953 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema33948_33954 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker33949_33955 = schema.core.checker.call(null,input_schema33948_33954);
var output_checker33950_33956 = schema.core.checker.call(null,output_schema33947_33953);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: {s/Keyword s/Any}
 * 
 * Create the map that will be validated by the Schema :
 * Only keeps :
 * - required keys
 * - optional keys with non blank values
 */
dragonmark.inputs.validation.pre_validation = ((function (ufv___33952,output_schema33947_33953,input_schema33948_33954,input_checker33949_33955,output_checker33950_33956){
return (function dragonmark$inputs$validation$pre_validation(G__33951){
var validate__21152__auto__ = ufv___33952.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___33957 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__33951], null);
var temp__4425__auto___33958 = input_checker33949_33955.call(null,args__21153__auto___33957);
if(cljs.core.truth_(temp__4425__auto___33958)){
var error__21154__auto___33959 = temp__4425__auto___33958;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"pre-validation","pre-validation",731230710,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Create the map that will be validated by the Schema :\n  Only keeps :\n  - required keys\n  - optional keys with non blank values"], null)),cljs.core.pr_str.call(null,error__21154__auto___33959)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema33948_33954,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___33957,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33959], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var bs = G__33951;
while(true){
return dragonmark.inputs.validation.business_state__GT_map.call(null,dragonmark.inputs.validation.keep_fields_to_validate.call(null,bs));
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___33960 = output_checker33950_33956.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___33960)){
var error__21154__auto___33961 = temp__4425__auto___33960;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"pre-validation","pre-validation",731230710,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Create the map that will be validated by the Schema :\n  Only keeps :\n  - required keys\n  - optional keys with non blank values"], null)),cljs.core.pr_str.call(null,error__21154__auto___33961)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema33947_33953,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33961], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___33952,output_schema33947_33953,input_schema33948_33954,input_checker33949_33955,output_checker33950_33956))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.pre_validation),schema.core.make_fn_schema.call(null,output_schema33947_33953,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema33948_33954], null)));
var ufv___33983 = schema.utils.use_fn_validation;
var output_schema33962_33984 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema33963_33985 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"sch","sch",763282093,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker33964_33986 = schema.core.checker.call(null,input_schema33963_33985);
var output_checker33965_33987 = schema.core.checker.call(null,output_schema33962_33984);
/**
 * Inputs: [sch]
 * Returns: {s/Keyword s/Any}
 * 
 * Transform a Schema into a map of key -> individual Schema
 */
dragonmark.inputs.validation.sch_glo__GT_unit = ((function (ufv___33983,output_schema33962_33984,input_schema33963_33985,input_checker33964_33986,output_checker33965_33987){
return (function dragonmark$inputs$validation$sch_glo__GT_unit(G__33966){
var validate__21152__auto__ = ufv___33983.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___33988 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__33966], null);
var temp__4425__auto___33989 = input_checker33964_33986.call(null,args__21153__auto___33988);
if(cljs.core.truth_(temp__4425__auto___33989)){
var error__21154__auto___33990 = temp__4425__auto___33989;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sch-glo->unit","sch-glo->unit",1717844533,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform a Schema into a map of key -> individual Schema"], null)),cljs.core.pr_str.call(null,error__21154__auto___33990)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema33963_33985,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___33988,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33990], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var sch = G__33966;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21152__auto__,ufv___33983,output_schema33962_33984,input_schema33963_33985,input_checker33964_33986,output_checker33965_33987){
return (function dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__33975(s__33976){
return (new cljs.core.LazySeq(null,((function (validate__21152__auto__,ufv___33983,output_schema33962_33984,input_schema33963_33985,input_checker33964_33986,output_checker33965_33987){
return (function (){
var s__33976__$1 = s__33976;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__33976__$1);
if(temp__4425__auto__){
var s__33976__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33976__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__33976__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__33978 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__33977 = (0);
while(true){
if((i__33977 < size__19241__auto__)){
var vec__33981 = cljs.core._nth.call(null,c__19240__auto__,i__33977);
var k = cljs.core.nth.call(null,vec__33981,(0),null);
var t = cljs.core.nth.call(null,vec__33981,(1),null);
cljs.core.chunk_append.call(null,b__33978,new cljs.core.PersistentArrayMap.fromArray([cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),new cljs.core.PersistentArrayMap.fromArray([k,t], true, false)], true, false));

var G__33991 = (i__33977 + (1));
i__33977 = G__33991;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33978),dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__33975.call(null,cljs.core.chunk_rest.call(null,s__33976__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33978),null);
}
} else {
var vec__33982 = cljs.core.first.call(null,s__33976__$2);
var k = cljs.core.nth.call(null,vec__33982,(0),null);
var t = cljs.core.nth.call(null,vec__33982,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),new cljs.core.PersistentArrayMap.fromArray([k,t], true, false)], true, false),dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__33975.call(null,cljs.core.rest.call(null,s__33976__$2)));
}
} else {
return null;
}
break;
}
});})(validate__21152__auto__,ufv___33983,output_schema33962_33984,input_schema33963_33985,input_checker33964_33986,output_checker33965_33987))
,null,null));
});})(validate__21152__auto__,ufv___33983,output_schema33962_33984,input_schema33963_33985,input_checker33964_33986,output_checker33965_33987))
;
return iter__19242__auto__.call(null,sch);
})());
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___33992 = output_checker33965_33987.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___33992)){
var error__21154__auto___33993 = temp__4425__auto___33992;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sch-glo->unit","sch-glo->unit",1717844533,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform a Schema into a map of key -> individual Schema"], null)),cljs.core.pr_str.call(null,error__21154__auto___33993)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema33962_33984,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___33993], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___33983,output_schema33962_33984,input_schema33963_33985,input_checker33964_33986,output_checker33965_33987))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.sch_glo__GT_unit),schema.core.make_fn_schema.call(null,output_schema33962_33984,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema33963_33985], null)));
/**
 * Build the map of field -> coercer
 */
dragonmark.inputs.validation.build_unit_coercers = (function dragonmark$inputs$validation$build_unit_coercers(sch){
return cljs.core.apply.call(null,cljs.core.merge,(function (){var iter__19242__auto__ = (function dragonmark$inputs$validation$build_unit_coercers_$_iter__34002(s__34003){
return (new cljs.core.LazySeq(null,(function (){
var s__34003__$1 = s__34003;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__34003__$1);
if(temp__4425__auto__){
var s__34003__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__34003__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__34003__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__34005 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__34004 = (0);
while(true){
if((i__34004 < size__19241__auto__)){
var vec__34008 = cljs.core._nth.call(null,c__19240__auto__,i__34004);
var k = cljs.core.nth.call(null,vec__34008,(0),null);
var s = cljs.core.nth.call(null,vec__34008,(1),null);
cljs.core.chunk_append.call(null,b__34005,new cljs.core.PersistentArrayMap.fromArray([k,schema.coerce.coercer.call(null,s,dragonmark.inputs.validation.validation_coercer)], true, false));

var G__34010 = (i__34004 + (1));
i__34004 = G__34010;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34005),dragonmark$inputs$validation$build_unit_coercers_$_iter__34002.call(null,cljs.core.chunk_rest.call(null,s__34003__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34005),null);
}
} else {
var vec__34009 = cljs.core.first.call(null,s__34003__$2);
var k = cljs.core.nth.call(null,vec__34009,(0),null);
var s = cljs.core.nth.call(null,vec__34009,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,schema.coerce.coercer.call(null,s,dragonmark.inputs.validation.validation_coercer)], true, false),dragonmark$inputs$validation$build_unit_coercers_$_iter__34002.call(null,cljs.core.rest.call(null,s__34003__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,dragonmark.inputs.validation.sch_glo__GT_unit.call(null,sch));
})());
});
var ufv___34032 = schema.utils.use_fn_validation;
var output_schema34011_34033 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema34012_34034 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"unit-coercers","unit-coercers",-228543947,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_checker34013_34035 = schema.core.checker.call(null,input_schema34012_34034);
var output_checker34014_34036 = schema.core.checker.call(null,output_schema34011_34033);
/**
 * Inputs: [unit-coercers :- {s/Keyword s/Any}]
 * Returns: {s/Keyword s/Any}
 */
dragonmark.inputs.validation.unit_schema_validators = ((function (ufv___34032,output_schema34011_34033,input_schema34012_34034,input_checker34013_34035,output_checker34014_34036){
return (function dragonmark$inputs$validation$unit_schema_validators(G__34015){
var validate__21152__auto__ = true;
if(validate__21152__auto__){
var args__21153__auto___34037 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__34015], null);
var temp__4425__auto___34038 = input_checker34013_34035.call(null,args__21153__auto___34037);
if(cljs.core.truth_(temp__4425__auto___34038)){
var error__21154__auto___34039 = temp__4425__auto___34038;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unit-schema-validators","unit-schema-validators",-690979832,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)),cljs.core.pr_str.call(null,error__21154__auto___34039)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema34012_34034,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___34037,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34039], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var unit_coercers = G__34015;
while(true){
return cljs.core.apply.call(null,cljs.core.merge,(function (){var iter__19242__auto__ = ((function (validate__21152__auto__,ufv___34032,output_schema34011_34033,input_schema34012_34034,input_checker34013_34035,output_checker34014_34036){
return (function dragonmark$inputs$validation$unit_schema_validators_$_iter__34024(s__34025){
return (new cljs.core.LazySeq(null,((function (validate__21152__auto__,ufv___34032,output_schema34011_34033,input_schema34012_34034,input_checker34013_34035,output_checker34014_34036){
return (function (){
var s__34025__$1 = s__34025;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__34025__$1);
if(temp__4425__auto__){
var s__34025__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__34025__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__34025__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__34027 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__34026 = (0);
while(true){
if((i__34026 < size__19241__auto__)){
var vec__34030 = cljs.core._nth.call(null,c__19240__auto__,i__34026);
var k = cljs.core.nth.call(null,vec__34030,(0),null);
var c = cljs.core.nth.call(null,vec__34030,(1),null);
cljs.core.chunk_append.call(null,b__34027,new cljs.core.PersistentArrayMap.fromArray([k,cljs.core.partial.call(null,dragonmark.inputs.validation.validate,c,dragonmark.inputs.validation.transform_schema_errors)], true, false));

var G__34040 = (i__34026 + (1));
i__34026 = G__34040;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34027),dragonmark$inputs$validation$unit_schema_validators_$_iter__34024.call(null,cljs.core.chunk_rest.call(null,s__34025__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34027),null);
}
} else {
var vec__34031 = cljs.core.first.call(null,s__34025__$2);
var k = cljs.core.nth.call(null,vec__34031,(0),null);
var c = cljs.core.nth.call(null,vec__34031,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,cljs.core.partial.call(null,dragonmark.inputs.validation.validate,c,dragonmark.inputs.validation.transform_schema_errors)], true, false),dragonmark$inputs$validation$unit_schema_validators_$_iter__34024.call(null,cljs.core.rest.call(null,s__34025__$2)));
}
} else {
return null;
}
break;
}
});})(validate__21152__auto__,ufv___34032,output_schema34011_34033,input_schema34012_34034,input_checker34013_34035,output_checker34014_34036))
,null,null));
});})(validate__21152__auto__,ufv___34032,output_schema34011_34033,input_schema34012_34034,input_checker34013_34035,output_checker34014_34036))
;
return iter__19242__auto__.call(null,unit_coercers);
})());
break;
}
})();
if(validate__21152__auto__){
var temp__4425__auto___34041 = output_checker34014_34036.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___34041)){
var error__21154__auto___34042 = temp__4425__auto___34041;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unit-schema-validators","unit-schema-validators",-690979832,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)),cljs.core.pr_str.call(null,error__21154__auto___34042)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema34011_34033,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34042], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___34032,output_schema34011_34033,input_schema34012_34034,input_checker34013_34035,output_checker34014_34036))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.unit_schema_validators),schema.core.make_fn_schema.call(null,output_schema34011_34033,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema34012_34034], null)));
var ufv___34052 = schema.utils.use_fn_validation;
var output_schema34043_34053 = schema.core.Bool;
var input_schema34044_34054 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_field_state,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-field-state","sch-field-state",-361453047,null)], null)))], null);
var input_checker34045_34055 = schema.core.checker.call(null,input_schema34044_34054);
var output_checker34046_34056 = schema.core.checker.call(null,output_schema34043_34053);
/**
 * Inputs: [s :- sch-field-state]
 * Returns: s/Bool
 * 
 * Indicates if a field must be validated :
 * - required field
 * - optional field with non blank values
 */
dragonmark.inputs.validation.validate_QMARK_ = ((function (ufv___34052,output_schema34043_34053,input_schema34044_34054,input_checker34045_34055,output_checker34046_34056){
return (function dragonmark$inputs$validation$validate_QMARK_(G__34047){
var validate__21152__auto__ = ufv___34052.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___34057 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__34047], null);
var temp__4425__auto___34058 = input_checker34045_34055.call(null,args__21153__auto___34057);
if(cljs.core.truth_(temp__4425__auto___34058)){
var error__21154__auto___34059 = temp__4425__auto___34058;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"validate?","validate?",1996759489,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Indicates if a field must be validated :\n  - required field\n  - optional field with non blank values"], null)),cljs.core.pr_str.call(null,error__21154__auto___34059)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema34044_34054,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___34057,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34059], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var s = G__34047;
while(true){
var map__34050 = s;
var map__34050__$1 = ((((!((map__34050 == null)))?((((map__34050.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34050.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34050):map__34050);
var required = cljs.core.get.call(null,map__34050__$1,new cljs.core.Keyword(null,"required","required",1807647006));
var value = cljs.core.get.call(null,map__34050__$1,new cljs.core.Keyword(null,"value","value",305978217));
var or__18489__auto__ = required;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,value));
}
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___34060 = output_checker34046_34056.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___34060)){
var error__21154__auto___34061 = temp__4425__auto___34060;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"validate?","validate?",1996759489,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Indicates if a field must be validated :\n  - required field\n  - optional field with non blank values"], null)),cljs.core.pr_str.call(null,error__21154__auto___34061)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema34043_34053,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34061], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___34052,output_schema34043_34053,input_schema34044_34054,input_checker34045_34055,output_checker34046_34056))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.validate_QMARK_),schema.core.make_fn_schema.call(null,output_schema34043_34053,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema34044_34054], null)));
var ufv___34068 = schema.utils.use_fn_validation;
var output_schema34062_34069 = dragonmark.inputs.schemas.sch_business_state;
var input_schema34063_34070 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,dragonmark.inputs.validation.sch_errors,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null)], null)))], null);
var input_checker34064_34071 = schema.core.checker.call(null,input_schema34063_34070);
var output_checker34065_34072 = schema.core.checker.call(null,output_schema34062_34069);
/**
 * Inputs: [state :- sch-business-state errs :- sch-errors]
 * Returns: sch-business-state
 * 
 * Handle errors for a single field
 */
dragonmark.inputs.validation.add_field_error = ((function (ufv___34068,output_schema34062_34069,input_schema34063_34070,input_checker34064_34071,output_checker34065_34072){
return (function dragonmark$inputs$validation$add_field_error(G__34066,G__34067){
var validate__21152__auto__ = ufv___34068.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___34073 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__34066,G__34067], null);
var temp__4425__auto___34074 = input_checker34064_34071.call(null,args__21153__auto___34073);
if(cljs.core.truth_(temp__4425__auto___34074)){
var error__21154__auto___34075 = temp__4425__auto___34074;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"add-field-error","add-field-error",-1753092209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Handle errors for a single field"], null)),cljs.core.pr_str.call(null,error__21154__auto___34075)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema34063_34070,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___34073,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34075], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var state = G__34066;
var errs = G__34067;
while(true){
return cljs.core.reduce.call(null,((function (validate__21152__auto__,ufv___34068,output_schema34062_34069,input_schema34063_34070,input_checker34064_34071,output_checker34065_34072){
return (function (s,e){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),false),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"error","error",-978969032)], null),e.call(null,errs));
});})(validate__21152__auto__,ufv___34068,output_schema34062_34069,input_schema34063_34070,input_checker34064_34071,output_checker34065_34072))
,state,cljs.core.keys.call(null,errs));
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___34076 = output_checker34065_34072.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___34076)){
var error__21154__auto___34077 = temp__4425__auto___34076;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"add-field-error","add-field-error",-1753092209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Handle errors for a single field"], null)),cljs.core.pr_str.call(null,error__21154__auto___34077)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema34062_34069,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34077], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___34068,output_schema34062_34069,input_schema34063_34070,input_checker34064_34071,output_checker34065_34072))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.add_field_error),schema.core.make_fn_schema.call(null,output_schema34062_34069,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema34063_34070], null)));
dragonmark.inputs.validation.no_async_error_QMARK_ = (function dragonmark$inputs$validation$no_async_error_QMARK_(state,k){
var se = new cljs.core.Keyword(null,"async-error","async-error",528708636).cljs$core$IFn$_invoke$arity$1(k.call(null,state));
return cljs.core.boolean$.call(null,((se == null)) || (cljs.core.empty_QMARK_.call(null,se)));
});
var ufv___34084 = schema.utils.use_fn_validation;
var output_schema34078_34085 = dragonmark.inputs.schemas.sch_business_state;
var input_schema34079_34086 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker34080_34087 = schema.core.checker.call(null,input_schema34079_34086);
var output_checker34081_34088 = schema.core.checker.call(null,output_schema34078_34085);
/**
 * Inputs: [state :- sch-business-state k :- s/Keyword]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.remove_field_error = ((function (ufv___34084,output_schema34078_34085,input_schema34079_34086,input_checker34080_34087,output_checker34081_34088){
return (function dragonmark$inputs$validation$remove_field_error(G__34082,G__34083){
var validate__21152__auto__ = ufv___34084.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___34089 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__34082,G__34083], null);
var temp__4425__auto___34090 = input_checker34080_34087.call(null,args__21153__auto___34089);
if(cljs.core.truth_(temp__4425__auto___34090)){
var error__21154__auto___34091 = temp__4425__auto___34090;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error","remove-field-error",-837789813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___34091)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema34079_34086,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___34089,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34091], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var state = G__34082;
var k = G__34083;
while(true){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"valid","valid",155614240)], null),dragonmark.inputs.validation.no_async_error_QMARK_.call(null,state,k)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___34092 = output_checker34081_34088.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___34092)){
var error__21154__auto___34093 = temp__4425__auto___34092;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error","remove-field-error",-837789813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___34093)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema34078_34085,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34093], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___34084,output_schema34078_34085,input_schema34079_34086,input_checker34080_34087,output_checker34081_34088))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_field_error),schema.core.make_fn_schema.call(null,output_schema34078_34085,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema34079_34086], null)));
var ufv___34100 = schema.utils.use_fn_validation;
var output_schema34094_34101 = dragonmark.inputs.schemas.sch_business_state;
var input_schema34095_34102 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker34096_34103 = schema.core.checker.call(null,input_schema34095_34102);
var output_checker34097_34104 = schema.core.checker.call(null,output_schema34094_34101);
/**
 * Inputs: [state :- sch-business-state k :- s/Keyword]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.remove_field_error_and_server = ((function (ufv___34100,output_schema34094_34101,input_schema34095_34102,input_checker34096_34103,output_checker34097_34104){
return (function dragonmark$inputs$validation$remove_field_error_and_server(G__34098,G__34099){
var validate__21152__auto__ = ufv___34100.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___34105 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__34098,G__34099], null);
var temp__4425__auto___34106 = input_checker34096_34103.call(null,args__21153__auto___34105);
if(cljs.core.truth_(temp__4425__auto___34106)){
var error__21154__auto___34107 = temp__4425__auto___34106;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error-and-server","remove-field-error-and-server",-1796162559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___34107)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema34095_34102,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___34105,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34107], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var state = G__34098;
var k = G__34099;
while(true){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"valid","valid",155614240)], null),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"async-error","async-error",528708636)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___34108 = output_checker34097_34104.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___34108)){
var error__21154__auto___34109 = temp__4425__auto___34108;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error-and-server","remove-field-error-and-server",-1796162559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___34109)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema34094_34101,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34109], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___34100,output_schema34094_34101,input_schema34095_34102,input_checker34096_34103,output_checker34097_34104))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_field_error_and_server),schema.core.make_fn_schema.call(null,output_schema34094_34101,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema34095_34102], null)));
var ufv___34117 = schema.utils.use_fn_validation;
var output_schema34110_34118 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);
var input_schema34111_34119 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,cljs.core.PersistentHashSet.fromArray([schema.core.Keyword], true),cljs.core.with_meta(new cljs.core.Symbol(null,"cross-errs","cross-errs",-563013712,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),null], null), null)], null))),schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Keyword], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"error-rule","error-rule",327326958,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null))),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker34112_34120 = schema.core.checker.call(null,input_schema34111_34119);
var output_checker34113_34121 = schema.core.checker.call(null,output_schema34110_34118);
/**
 * Inputs: [cross-errs :- #{s/Keyword} error-rule :- {s/Keyword s/Keyword} errs :- [s/Keyword]]
 * Returns: [s/Keyword]
 * 
 * Remove the cross field errors keys from the validation errors.
 * This prevent errors from showing when inline validation occurs.
 */
dragonmark.inputs.validation.remove_dependant_errors = ((function (ufv___34117,output_schema34110_34118,input_schema34111_34119,input_checker34112_34120,output_checker34113_34121){
return (function dragonmark$inputs$validation$remove_dependant_errors(G__34114,G__34115,G__34116){
var validate__21152__auto__ = ufv___34117.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___34122 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__34114,G__34115,G__34116], null);
var temp__4425__auto___34123 = input_checker34112_34120.call(null,args__21153__auto___34122);
if(cljs.core.truth_(temp__4425__auto___34123)){
var error__21154__auto___34124 = temp__4425__auto___34123;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-dependant-errors","remove-dependant-errors",-830444485,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remove the cross field errors keys from the validation errors.\n  This prevent errors from showing when inline validation occurs."], null)),cljs.core.pr_str.call(null,error__21154__auto___34124)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema34111_34119,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___34122,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34124], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var cross_errs = G__34114;
var error_rule = G__34115;
var errs = G__34116;
while(true){
return cljs.core.seq.call(null,cljs.core.remove.call(null,((function (validate__21152__auto__,ufv___34117,output_schema34110_34118,input_schema34111_34119,input_checker34112_34120,output_checker34113_34121){
return (function (err){
return cross_errs.call(null,cljs.core.get.call(null,error_rule,err));
});})(validate__21152__auto__,ufv___34117,output_schema34110_34118,input_schema34111_34119,input_checker34112_34120,output_checker34113_34121))
,errs));
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___34125 = output_checker34113_34121.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___34125)){
var error__21154__auto___34126 = temp__4425__auto___34125;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-dependant-errors","remove-dependant-errors",-830444485,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remove the cross field errors keys from the validation errors.\n  This prevent errors from showing when inline validation occurs."], null)),cljs.core.pr_str.call(null,error__21154__auto___34126)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema34110_34118,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34126], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___34117,output_schema34110_34118,input_schema34111_34119,input_checker34112_34120,output_checker34113_34121))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_dependant_errors),schema.core.make_fn_schema.call(null,output_schema34110_34118,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema34111_34119], null)));
dragonmark.inputs.validation.build_error_remover = (function dragonmark$inputs$validation$build_error_remover(rules,cross_fields_rules){
return cljs.core.partial.call(null,dragonmark.inputs.validation.remove_dependant_errors,cross_fields_rules,dragonmark.inputs.validation.error__GT_rule.call(null,rules));
});
/**
 * validate a single field against verily rules.
 * If an other field depends on this one, then the errors linked to this validation won't show up.
 */
dragonmark.inputs.validation.unit_verily_validation = (function dragonmark$inputs$validation$unit_verily_validation(fk,unit,p__34127){
var map__34130 = p__34127;
var map__34130__$1 = ((((!((map__34130 == null)))?((((map__34130.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34130.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34130):map__34130);
var state = map__34130__$1;
var unit_coercers = cljs.core.get.call(null,map__34130__$1,new cljs.core.Keyword(null,"unit-coercers","unit-coercers",-1869075474));
var remove_errs_fn = cljs.core.get.call(null,map__34130__$1,new cljs.core.Keyword(null,"remove-errs-fn","remove-errs-fn",-1642608850));
var verily_validator = cljs.core.get.call(null,map__34130__$1,new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403));
var coerced = fk.call(null,unit_coercers).call(null,unit);
var errs = verily_validator.call(null,coerced);
if(cljs.core.contains_QMARK_.call(null,errs,fk)){
var errs_unit = cljs.core.update_in.call(null,errs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null),remove_errs_fn);
var res = cljs.core.select_keys.call(null,errs_unit,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null));
if(cljs.core.truth_(fk.call(null,res))){
return res;
} else {
return null;
}
} else {
return null;
}
});
/**
 * Verily validation of a field that depend on other.
 * The confirm password is a typical example.
 */
dragonmark.inputs.validation.unit_dependant_verily_validation = (function dragonmark$inputs$validation$unit_dependant_verily_validation(fk,inputs,state){
var map__34134 = state;
var map__34134__$1 = ((((!((map__34134 == null)))?((((map__34134.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34134.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34134):map__34134);
var validation_deps = cljs.core.get.call(null,map__34134__$1,new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716));
var verily_validator = cljs.core.get.call(null,map__34134__$1,new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403));
var deps = fk.call(null,validation_deps);
var coerced = dragonmark.inputs.validation.business_state__GT_map.call(null,inputs);
var errs = verily_validator.call(null,coerced);
if(cljs.core.contains_QMARK_.call(null,errs,fk)){
return cljs.core.select_keys.call(null,errs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null));
} else {
return null;
}
});
/**
 * Verily validation of a single field
 */
dragonmark.inputs.validation.verily_validation = (function dragonmark$inputs$validation$verily_validation(fk,unit,bs,state){
var map__34138 = state;
var map__34138__$1 = ((((!((map__34138 == null)))?((((map__34138.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34138.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34138):map__34138);
var validation_deps = cljs.core.get.call(null,map__34138__$1,new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716));
if(cljs.core.truth_(fk.call(null,validation_deps))){
return dragonmark.inputs.validation.unit_dependant_verily_validation.call(null,fk,bs,state);
} else {
return dragonmark.inputs.validation.unit_verily_validation.call(null,fk,unit,state);
}
});
/**
 * Validation of a single field
 * TODO Refactoring
 */
dragonmark.inputs.validation.field_validation = (function dragonmark$inputs$validation$field_validation(fk,inputs,state){
var map__34142 = state;
var map__34142__$1 = ((((!((map__34142 == null)))?((((map__34142.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34142.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34142):map__34142);
var unit_validators = cljs.core.get.call(null,map__34142__$1,new cljs.core.Keyword(null,"unit-validators","unit-validators",-1302618433));
var unit = dragonmark.inputs.validation.bs__GT_unit_map.call(null,inputs,fk);
if(cljs.core.truth_(dragonmark.inputs.validation.validate_QMARK_.call(null,fk.call(null,inputs)))){
var temp__4423__auto__ = (function (){var or__18489__auto__ = (function (){var and__18477__auto__ = fk;
if(cljs.core.truth_(and__18477__auto__)){
var temp__4423__auto__ = fk.call(null,unit_validators);
if(cljs.core.truth_(temp__4423__auto__)){
var the_fn = temp__4423__auto__;
return the_fn.call(null,unit);
} else {
return null;
}
} else {
return and__18477__auto__;
}
})();
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return dragonmark.inputs.validation.verily_validation.call(null,fk,unit,inputs,state);
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var errs = temp__4423__auto__;
return dragonmark.inputs.validation.add_field_error.call(null,inputs,errs);
} else {
return dragonmark.inputs.validation.remove_field_error.call(null,inputs,fk);
}
} else {
return dragonmark.inputs.validation.remove_field_error.call(null,inputs,fk);
}
});
/**
 * Validate a single field of the local business state and update the local state.
 */
dragonmark.inputs.validation.field_validation_BANG_ = (function dragonmark$inputs$validation$field_validation_BANG_(owner,f){
var map__34146 = dragonmark.inputs.extern.get_state.call(null,owner);
var map__34146__$1 = ((((!((map__34146 == null)))?((((map__34146.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34146.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34146):map__34146);
var state = map__34146__$1;
var inputs = cljs.core.get.call(null,map__34146__$1,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var old_inputs = inputs;
var inputs__$1 = dragonmark.inputs.validation.remove_field_error_and_server.call(null,inputs,f);
var new_business_state = dragonmark.inputs.validation.field_validation.call(null,f,inputs__$1,state);
if(cljs.core.not_EQ_.call(null,old_inputs,new_business_state)){
return dragonmark.inputs.extern.set_state_BANG_.call(null,owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"inputs","inputs",865803858)], null),new_business_state);
} else {
return null;
}
});
dragonmark.inputs.validation.full_validation = (function dragonmark$inputs$validation$full_validation(inputs,state){
return cljs.core.reduce.call(null,(function (bs,f){
return dragonmark.inputs.validation.field_validation.call(null,f,bs,state);
}),inputs,cljs.core.keys.call(null,inputs));
});
var ufv___34157 = schema.utils.use_fn_validation;
var output_schema34148_34158 = schema.core.Bool;
var input_schema34149_34159 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker34150_34160 = schema.core.checker.call(null,input_schema34149_34159);
var output_checker34151_34161 = schema.core.checker.call(null,output_schema34148_34158);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: s/Bool
 * 
 * Tells if there is at least one field in error.
 */
dragonmark.inputs.validation.no_error_QMARK_ = ((function (ufv___34157,output_schema34148_34158,input_schema34149_34159,input_checker34150_34160,output_checker34151_34161){
return (function dragonmark$inputs$validation$no_error_QMARK_(G__34152){
var validate__21152__auto__ = ufv___34157.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___34162 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__34152], null);
var temp__4425__auto___34163 = input_checker34150_34160.call(null,args__21153__auto___34162);
if(cljs.core.truth_(temp__4425__auto___34163)){
var error__21154__auto___34164 = temp__4425__auto___34163;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"no-error?","no-error?",323642458,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tells if there is at least one field in error."], null)),cljs.core.pr_str.call(null,error__21154__auto___34164)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema34149_34159,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___34162,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34164], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var bs = G__34152;
while(true){
return cljs.core.not_any_QMARK_.call(null,((function (validate__21152__auto__,ufv___34157,output_schema34148_34158,input_schema34149_34159,input_checker34150_34160,output_checker34151_34161){
return (function (p__34155){
var vec__34156 = p__34155;
var k = cljs.core.nth.call(null,vec__34156,(0),null);
var v = cljs.core.nth.call(null,vec__34156,(1),null);
return new cljs.core.Keyword(null,"valid","valid",155614240).cljs$core$IFn$_invoke$arity$1(v) === false;
});})(validate__21152__auto__,ufv___34157,output_schema34148_34158,input_schema34149_34159,input_checker34150_34160,output_checker34151_34161))
,bs);
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___34165 = output_checker34151_34161.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___34165)){
var error__21154__auto___34166 = temp__4425__auto___34165;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"no-error?","no-error?",323642458,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tells if there is at least one field in error."], null)),cljs.core.pr_str.call(null,error__21154__auto___34166)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema34148_34158,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___34166], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___34157,output_schema34148_34158,input_schema34149_34159,input_checker34150_34160,output_checker34151_34161))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.no_error_QMARK_),schema.core.make_fn_schema.call(null,output_schema34148_34158,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema34149_34159], null)));

//# sourceMappingURL=validation.js.map