// Compiled by ClojureScript 1.7.48 {}
goog.provide('jkkramer.verily');
goog.require('cljs.core');
goog.require('clojure.string');
jkkramer.verily.seqify = (function jkkramer$verily$seqify(x){
if(!(cljs.core.sequential_QMARK_.call(null,x))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);
} else {
return x;
}
});
/**
 * Expands a name like "foo[bar][baz]" or :foo.bar.baz into [:foo :bar :baz]
 */
jkkramer.verily.expand_name = (function jkkramer$verily$expand_name(name){
if((typeof name === 'string') || ((name instanceof cljs.core.Keyword))){
var name_str = cljs.core.name.call(null,name);
var vec__28943 = cljs.core.re_matches.call(null,/^([^\[]+)((?:\[[^\]]+?\])*)$/,name_str);
var _ = cljs.core.nth.call(null,vec__28943,(0),null);
var name1 = cljs.core.nth.call(null,vec__28943,(1),null);
var more_names = cljs.core.nth.call(null,vec__28943,(2),null);
if(cljs.core.seq.call(null,more_names)){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,name1)], null),cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.keyword,cljs.core.second),cljs.core.re_seq.call(null,/\[([^\]]+)\]/,more_names)));
} else {
var parts = clojure.string.split.call(null,name_str,/\./);
return cljs.core.mapv.call(null,cljs.core.keyword,parts);
}
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name], null);
}
});
jkkramer.verily.make_validator = (function jkkramer$verily$make_validator(keys,bad_pred,msg){
var bad_pred_STAR_ = (function (p1__28944_SHARP_){
try{return bad_pred.call(null,p1__28944_SHARP_);
}catch (e28947){if((e28947 instanceof Error)){
var _ = e28947;
return true;
} else {
throw e28947;

}
}});
return ((function (bad_pred_STAR_){
return (function (m){
var bad_keys = cljs.core.filter.call(null,((function (bad_pred_STAR_){
return (function (p1__28945_SHARP_){
return bad_pred_STAR_.call(null,cljs.core.get.call(null,m,p1__28945_SHARP_,cljs.core.get_in.call(null,m,jkkramer.verily.expand_name.call(null,p1__28945_SHARP_),new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708))));
});})(bad_pred_STAR_))
,jkkramer.verily.seqify.call(null,keys));
if(cljs.core.seq.call(null,bad_keys)){
if(cljs.core.map_QMARK_.call(null,msg)){
return msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),bad_keys,new cljs.core.Keyword(null,"msg","msg",-1386103444),msg], null);
}
} else {
return null;
}
});
;})(bad_pred_STAR_))
});
/**
 * The keys must be present in the map but may be blank.
 */
jkkramer.verily.contains = (function jkkramer$verily$contains(){
var args__19535__auto__ = [];
var len__19528__auto___28952 = arguments.length;
var i__19529__auto___28953 = (0);
while(true){
if((i__19529__auto___28953 < len__19528__auto___28952)){
args__19535__auto__.push((arguments[i__19529__auto___28953]));

var G__28954 = (i__19529__auto___28953 + (1));
i__19529__auto___28953 = G__28954;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.contains.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.contains.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__28950){
var vec__28951 = p__28950;
var msg = cljs.core.nth.call(null,vec__28951,(0),null);
return jkkramer.verily.make_validator.call(null,keys,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),null], null), null),(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be present";
}
})());
});

jkkramer.verily.contains.cljs$lang$maxFixedArity = (1);

jkkramer.verily.contains.cljs$lang$applyTo = (function (seq28948){
var G__28949 = cljs.core.first.call(null,seq28948);
var seq28948__$1 = cljs.core.next.call(null,seq28948);
return jkkramer.verily.contains.cljs$core$IFn$_invoke$arity$variadic(G__28949,seq28948__$1);
});
/**
 * The keys must be present in the map AND not be blank.
 */
jkkramer.verily.required = (function jkkramer$verily$required(){
var args__19535__auto__ = [];
var len__19528__auto___28960 = arguments.length;
var i__19529__auto___28961 = (0);
while(true){
if((i__19529__auto___28961 < len__19528__auto___28960)){
args__19535__auto__.push((arguments[i__19529__auto___28961]));

var G__28962 = (i__19529__auto___28961 + (1));
i__19529__auto___28961 = G__28962;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.required.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.required.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__28958){
var vec__28959 = p__28958;
var msg = cljs.core.nth.call(null,vec__28959,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__28959,msg){
return (function (p1__28955_SHARP_){
var or__18489__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__28955_SHARP_);
if(or__18489__auto__){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = (p1__28955_SHARP_ == null);
if(or__18489__auto____$1){
return or__18489__auto____$1;
} else {
var and__18477__auto__ = typeof p1__28955_SHARP_ === 'string';
if(and__18477__auto__){
return clojure.string.blank_QMARK_.call(null,p1__28955_SHARP_);
} else {
return and__18477__auto__;
}
}
}
});})(vec__28959,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must not be blank";
}
})());
});

jkkramer.verily.required.cljs$lang$maxFixedArity = (1);

jkkramer.verily.required.cljs$lang$applyTo = (function (seq28956){
var G__28957 = cljs.core.first.call(null,seq28956);
var seq28956__$1 = cljs.core.next.call(null,seq28956);
return jkkramer.verily.required.cljs$core$IFn$_invoke$arity$variadic(G__28957,seq28956__$1);
});
jkkramer.verily.complete = (function jkkramer$verily$complete(){
var args__19535__auto__ = [];
var len__19528__auto___28969 = arguments.length;
var i__19529__auto___28970 = (0);
while(true){
if((i__19529__auto___28970 < len__19528__auto___28969)){
args__19535__auto__.push((arguments[i__19529__auto___28970]));

var G__28971 = (i__19529__auto___28970 + (1));
i__19529__auto___28970 = G__28971;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.complete.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.complete.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__28967){
var vec__28968 = p__28967;
var msg = cljs.core.nth.call(null,vec__28968,(0),null);

var bad_QMARK_ = ((function (vec__28968,msg){
return (function (p1__28963_SHARP_){
var or__18489__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__28963_SHARP_);
if(or__18489__auto__){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = (p1__28963_SHARP_ == null);
if(or__18489__auto____$1){
return or__18489__auto____$1;
} else {
var and__18477__auto__ = typeof p1__28963_SHARP_ === 'string';
if(and__18477__auto__){
return clojure.string.blank_QMARK_.call(null,p1__28963_SHARP_);
} else {
return and__18477__auto__;
}
}
}
});})(vec__28968,msg))
;
return jkkramer.verily.make_validator.call(null,keys,((function (bad_QMARK_,vec__28968,msg){
return (function (p1__28964_SHARP_){
var or__18489__auto__ = bad_QMARK_.call(null,p1__28964_SHARP_);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = !(cljs.core.coll_QMARK_.call(null,p1__28964_SHARP_));
if(or__18489__auto____$1){
return or__18489__auto____$1;
} else {
var or__18489__auto____$2 = (function (){var and__18477__auto__ = cljs.core.map_QMARK_.call(null,p1__28964_SHARP_);
if(and__18477__auto__){
return cljs.core.some.call(null,bad_QMARK_,cljs.core.vals.call(null,p1__28964_SHARP_));
} else {
return and__18477__auto__;
}
})();
if(cljs.core.truth_(or__18489__auto____$2)){
return or__18489__auto____$2;
} else {
var and__18477__auto__ = cljs.core.coll_QMARK_.call(null,p1__28964_SHARP_);
if(and__18477__auto__){
return cljs.core.some.call(null,bad_QMARK_,p1__28964_SHARP_);
} else {
return and__18477__auto__;
}
}
}
}
});})(bad_QMARK_,vec__28968,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("must not be incomplete")].join('');
}
})());
});

jkkramer.verily.complete.cljs$lang$maxFixedArity = (1);

jkkramer.verily.complete.cljs$lang$applyTo = (function (seq28965){
var G__28966 = cljs.core.first.call(null,seq28965);
var seq28965__$1 = cljs.core.next.call(null,seq28965);
return jkkramer.verily.complete.cljs$core$IFn$_invoke$arity$variadic(G__28966,seq28965__$1);
});
/**
 * If present, the keys must not be blank.
 */
jkkramer.verily.not_blank = (function jkkramer$verily$not_blank(){
var args__19535__auto__ = [];
var len__19528__auto___28977 = arguments.length;
var i__19529__auto___28978 = (0);
while(true){
if((i__19529__auto___28978 < len__19528__auto___28977)){
args__19535__auto__.push((arguments[i__19529__auto___28978]));

var G__28979 = (i__19529__auto___28978 + (1));
i__19529__auto___28978 = G__28979;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.not_blank.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.not_blank.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__28975){
var vec__28976 = p__28975;
var msg = cljs.core.nth.call(null,vec__28976,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__28976,msg){
return (function (p1__28972_SHARP_){
var or__18489__auto__ = (p1__28972_SHARP_ == null);
if(or__18489__auto__){
return or__18489__auto__;
} else {
var and__18477__auto__ = typeof p1__28972_SHARP_ === 'string';
if(and__18477__auto__){
return clojure.string.blank_QMARK_.call(null,p1__28972_SHARP_);
} else {
return and__18477__auto__;
}
}
});})(vec__28976,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must not be blank";
}
})());
});

jkkramer.verily.not_blank.cljs$lang$maxFixedArity = (1);

jkkramer.verily.not_blank.cljs$lang$applyTo = (function (seq28973){
var G__28974 = cljs.core.first.call(null,seq28973);
var seq28973__$1 = cljs.core.next.call(null,seq28973);
return jkkramer.verily.not_blank.cljs$core$IFn$_invoke$arity$variadic(G__28974,seq28973__$1);
});
jkkramer.verily.exact = (function jkkramer$verily$exact(){
var args__19535__auto__ = [];
var len__19528__auto___28986 = arguments.length;
var i__19529__auto___28987 = (0);
while(true){
if((i__19529__auto___28987 < len__19528__auto___28986)){
args__19535__auto__.push((arguments[i__19529__auto___28987]));

var G__28988 = (i__19529__auto___28987 + (1));
i__19529__auto___28987 = G__28988;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.exact.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.exact.cljs$core$IFn$_invoke$arity$variadic = (function (val,keys,p__28984){
var vec__28985 = p__28984;
var msg = cljs.core.nth.call(null,vec__28985,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__28985,msg){
return (function (p1__28980_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__28980_SHARP_)) && (cljs.core.not_EQ_.call(null,val,p1__28980_SHARP_));
});})(vec__28985,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "incorrect value";
}
})());
});

jkkramer.verily.exact.cljs$lang$maxFixedArity = (2);

jkkramer.verily.exact.cljs$lang$applyTo = (function (seq28981){
var G__28982 = cljs.core.first.call(null,seq28981);
var seq28981__$1 = cljs.core.next.call(null,seq28981);
var G__28983 = cljs.core.first.call(null,seq28981__$1);
var seq28981__$2 = cljs.core.next.call(null,seq28981__$1);
return jkkramer.verily.exact.cljs$core$IFn$_invoke$arity$variadic(G__28982,G__28983,seq28981__$2);
});
jkkramer.verily.equal = (function jkkramer$verily$equal(){
var args__19535__auto__ = [];
var len__19528__auto___28994 = arguments.length;
var i__19529__auto___28995 = (0);
while(true){
if((i__19529__auto___28995 < len__19528__auto___28994)){
args__19535__auto__.push((arguments[i__19529__auto___28995]));

var G__28996 = (i__19529__auto___28995 + (1));
i__19529__auto___28995 = G__28996;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.equal.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.equal.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__28992){
var vec__28993 = p__28992;
var msg = cljs.core.nth.call(null,vec__28993,(0),null);
var keys__$1 = jkkramer.verily.seqify.call(null,keys);
return ((function (keys__$1,vec__28993,msg){
return (function (m){
if(cljs.core.truth_(cljs.core.apply.call(null,cljs.core._EQ_,cljs.core.map.call(null,((function (keys__$1,vec__28993,msg){
return (function (p1__28989_SHARP_){
return cljs.core.get.call(null,m,p1__28989_SHARP_,cljs.core.get_in.call(null,m,jkkramer.verily.expand_name.call(null,p1__28989_SHARP_)));
});})(keys__$1,vec__28993,msg))
,keys__$1)))){
return null;
} else {
if(cljs.core.map_QMARK_.call(null,msg)){
return msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),keys__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444),(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be equal";
}
})()], null);
}
}
});
;})(keys__$1,vec__28993,msg))
});

jkkramer.verily.equal.cljs$lang$maxFixedArity = (1);

jkkramer.verily.equal.cljs$lang$applyTo = (function (seq28990){
var G__28991 = cljs.core.first.call(null,seq28990);
var seq28990__$1 = cljs.core.next.call(null,seq28990);
return jkkramer.verily.equal.cljs$core$IFn$_invoke$arity$variadic(G__28991,seq28990__$1);
});
jkkramer.verily.matches = (function jkkramer$verily$matches(){
var args__19535__auto__ = [];
var len__19528__auto___29003 = arguments.length;
var i__19529__auto___29004 = (0);
while(true){
if((i__19529__auto___29004 < len__19528__auto___29003)){
args__19535__auto__.push((arguments[i__19529__auto___29004]));

var G__29005 = (i__19529__auto___29004 + (1));
i__19529__auto___29004 = G__29005;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.matches.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.matches.cljs$core$IFn$_invoke$arity$variadic = (function (re,keys,p__29001){
var vec__29002 = p__29001;
var msg = cljs.core.nth.call(null,vec__29002,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29002,msg){
return (function (p1__28997_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__28997_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__28997_SHARP_))) && (cljs.core.not.call(null,cljs.core.re_matches.call(null,re,p1__28997_SHARP_)));
});})(vec__29002,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "incorrect format";
}
})());
});

jkkramer.verily.matches.cljs$lang$maxFixedArity = (2);

jkkramer.verily.matches.cljs$lang$applyTo = (function (seq28998){
var G__28999 = cljs.core.first.call(null,seq28998);
var seq28998__$1 = cljs.core.next.call(null,seq28998);
var G__29000 = cljs.core.first.call(null,seq28998__$1);
var seq28998__$2 = cljs.core.next.call(null,seq28998__$1);
return jkkramer.verily.matches.cljs$core$IFn$_invoke$arity$variadic(G__28999,G__29000,seq28998__$2);
});
jkkramer.verily.min_length = (function jkkramer$verily$min_length(){
var args__19535__auto__ = [];
var len__19528__auto___29012 = arguments.length;
var i__19529__auto___29013 = (0);
while(true){
if((i__19529__auto___29013 < len__19528__auto___29012)){
args__19535__auto__.push((arguments[i__19529__auto___29013]));

var G__29014 = (i__19529__auto___29013 + (1));
i__19529__auto___29013 = G__29014;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.min_length.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.min_length.cljs$core$IFn$_invoke$arity$variadic = (function (len,keys,p__29010){
var vec__29011 = p__29010;
var msg = cljs.core.nth.call(null,vec__29011,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29011,msg){
return (function (p1__29006_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29006_SHARP_)) && (!((p1__29006_SHARP_ == null))) && (!((len <= cljs.core.count.call(null,p1__29006_SHARP_))));
});})(vec__29011,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("must be at least "),cljs.core.str(len),cljs.core.str(" characters")].join('');
}
})());
});

jkkramer.verily.min_length.cljs$lang$maxFixedArity = (2);

jkkramer.verily.min_length.cljs$lang$applyTo = (function (seq29007){
var G__29008 = cljs.core.first.call(null,seq29007);
var seq29007__$1 = cljs.core.next.call(null,seq29007);
var G__29009 = cljs.core.first.call(null,seq29007__$1);
var seq29007__$2 = cljs.core.next.call(null,seq29007__$1);
return jkkramer.verily.min_length.cljs$core$IFn$_invoke$arity$variadic(G__29008,G__29009,seq29007__$2);
});
jkkramer.verily.max_length = (function jkkramer$verily$max_length(){
var args__19535__auto__ = [];
var len__19528__auto___29021 = arguments.length;
var i__19529__auto___29022 = (0);
while(true){
if((i__19529__auto___29022 < len__19528__auto___29021)){
args__19535__auto__.push((arguments[i__19529__auto___29022]));

var G__29023 = (i__19529__auto___29022 + (1));
i__19529__auto___29022 = G__29023;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.max_length.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.max_length.cljs$core$IFn$_invoke$arity$variadic = (function (len,keys,p__29019){
var vec__29020 = p__29019;
var msg = cljs.core.nth.call(null,vec__29020,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29020,msg){
return (function (p1__29015_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29015_SHARP_)) && (!((p1__29015_SHARP_ == null))) && (!((len >= cljs.core.count.call(null,p1__29015_SHARP_))));
});})(vec__29020,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("cannot exceed "),cljs.core.str(len),cljs.core.str(" characters")].join('');
}
})());
});

jkkramer.verily.max_length.cljs$lang$maxFixedArity = (2);

jkkramer.verily.max_length.cljs$lang$applyTo = (function (seq29016){
var G__29017 = cljs.core.first.call(null,seq29016);
var seq29016__$1 = cljs.core.next.call(null,seq29016);
var G__29018 = cljs.core.first.call(null,seq29016__$1);
var seq29016__$2 = cljs.core.next.call(null,seq29016__$1);
return jkkramer.verily.max_length.cljs$core$IFn$_invoke$arity$variadic(G__29017,G__29018,seq29016__$2);
});
jkkramer.verily.in$ = (function jkkramer$verily$in(){
var args__19535__auto__ = [];
var len__19528__auto___29030 = arguments.length;
var i__19529__auto___29031 = (0);
while(true){
if((i__19529__auto___29031 < len__19528__auto___29030)){
args__19535__auto__.push((arguments[i__19529__auto___29031]));

var G__29032 = (i__19529__auto___29031 + (1));
i__19529__auto___29031 = G__29032;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.in$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.in$.cljs$core$IFn$_invoke$arity$variadic = (function (coll,keys,p__29028){
var vec__29029 = p__29028;
var msg = cljs.core.nth.call(null,vec__29029,(0),null);
var coll_set = ((cljs.core.set_QMARK_.call(null,coll))?coll:cljs.core.set.call(null,coll));
return jkkramer.verily.make_validator.call(null,keys,((function (coll_set,vec__29029,msg){
return (function (p1__29024_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29024_SHARP_)) && (!((p1__29024_SHARP_ == null))) && (!(cljs.core.contains_QMARK_.call(null,coll_set,p1__29024_SHARP_)));
});})(coll_set,vec__29029,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("not an accepted value")].join('');
}
})());
});

jkkramer.verily.in$.cljs$lang$maxFixedArity = (2);

jkkramer.verily.in$.cljs$lang$applyTo = (function (seq29025){
var G__29026 = cljs.core.first.call(null,seq29025);
var seq29025__$1 = cljs.core.next.call(null,seq29025);
var G__29027 = cljs.core.first.call(null,seq29025__$1);
var seq29025__$2 = cljs.core.next.call(null,seq29025__$1);
return jkkramer.verily.in$.cljs$core$IFn$_invoke$arity$variadic(G__29026,G__29027,seq29025__$2);
});
jkkramer.verily.every_in = (function jkkramer$verily$every_in(){
var args__19535__auto__ = [];
var len__19528__auto___29039 = arguments.length;
var i__19529__auto___29040 = (0);
while(true){
if((i__19529__auto___29040 < len__19528__auto___29039)){
args__19535__auto__.push((arguments[i__19529__auto___29040]));

var G__29041 = (i__19529__auto___29040 + (1));
i__19529__auto___29040 = G__29041;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.every_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.every_in.cljs$core$IFn$_invoke$arity$variadic = (function (coll,keys,p__29037){
var vec__29038 = p__29037;
var msg = cljs.core.nth.call(null,vec__29038,(0),null);
var coll_set = ((cljs.core.set_QMARK_.call(null,coll))?coll:cljs.core.set.call(null,coll));
return jkkramer.verily.make_validator.call(null,keys,((function (coll_set,vec__29038,msg){
return (function (p1__29033_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29033_SHARP_)) && (!((p1__29033_SHARP_ == null))) && (!(cljs.core.every_QMARK_.call(null,((function (coll_set,vec__29038,msg){
return (function (x){
return cljs.core.contains_QMARK_.call(null,coll_set,x);
});})(coll_set,vec__29038,msg))
,p1__29033_SHARP_)));
});})(coll_set,vec__29038,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("not an accepted value")].join('');
}
})());
});

jkkramer.verily.every_in.cljs$lang$maxFixedArity = (2);

jkkramer.verily.every_in.cljs$lang$applyTo = (function (seq29034){
var G__29035 = cljs.core.first.call(null,seq29034);
var seq29034__$1 = cljs.core.next.call(null,seq29034);
var G__29036 = cljs.core.first.call(null,seq29034__$1);
var seq29034__$2 = cljs.core.next.call(null,seq29034__$1);
return jkkramer.verily.every_in.cljs$core$IFn$_invoke$arity$variadic(G__29035,G__29036,seq29034__$2);
});
jkkramer.verily.zip_regex = /^\d{5}(?:[-\s]\d{4})?$/;
jkkramer.verily.us_zip = (function jkkramer$verily$us_zip(){
var args__19535__auto__ = [];
var len__19528__auto___29047 = arguments.length;
var i__19529__auto___29048 = (0);
while(true){
if((i__19529__auto___29048 < len__19528__auto___29047)){
args__19535__auto__.push((arguments[i__19529__auto___29048]));

var G__29049 = (i__19529__auto___29048 + (1));
i__19529__auto___29048 = G__29049;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.us_zip.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.us_zip.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29045){
var vec__29046 = p__29045;
var msg = cljs.core.nth.call(null,vec__29046,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29046,msg){
return (function (p1__29042_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29042_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__29042_SHARP_))) && (cljs.core.not.call(null,cljs.core.re_matches.call(null,jkkramer.verily.zip_regex,p1__29042_SHARP_)));
});})(vec__29046,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a valid US zip code";
}
})());
});

jkkramer.verily.us_zip.cljs$lang$maxFixedArity = (1);

jkkramer.verily.us_zip.cljs$lang$applyTo = (function (seq29043){
var G__29044 = cljs.core.first.call(null,seq29043);
var seq29043__$1 = cljs.core.next.call(null,seq29043);
return jkkramer.verily.us_zip.cljs$core$IFn$_invoke$arity$variadic(G__29044,seq29043__$1);
});
jkkramer.verily.email = (function jkkramer$verily$email(){
var args__19535__auto__ = [];
var len__19528__auto___29055 = arguments.length;
var i__19529__auto___29056 = (0);
while(true){
if((i__19529__auto___29056 < len__19528__auto___29055)){
args__19535__auto__.push((arguments[i__19529__auto___29056]));

var G__29057 = (i__19529__auto___29056 + (1));
i__19529__auto___29056 = G__29057;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.email.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.email.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29053){
var vec__29054 = p__29053;
var msg = cljs.core.nth.call(null,vec__29054,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29054,msg){
return (function (p1__29050_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29050_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__29050_SHARP_))) && (cljs.core.not.call(null,cljs.core.re_matches.call(null,/[^^]+@[^$]+/,p1__29050_SHARP_)));
});})(vec__29054,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a valid email";
}
})());
});

jkkramer.verily.email.cljs$lang$maxFixedArity = (1);

jkkramer.verily.email.cljs$lang$applyTo = (function (seq29051){
var G__29052 = cljs.core.first.call(null,seq29051);
var seq29051__$1 = cljs.core.next.call(null,seq29051);
return jkkramer.verily.email.cljs$core$IFn$_invoke$arity$variadic(G__29052,seq29051__$1);
});
jkkramer.verily.web_url = (function jkkramer$verily$web_url(){
var args__19535__auto__ = [];
var len__19528__auto___29067 = arguments.length;
var i__19529__auto___29068 = (0);
while(true){
if((i__19529__auto___29068 < len__19528__auto___29067)){
args__19535__auto__.push((arguments[i__19529__auto___29068]));

var G__29069 = (i__19529__auto___29068 + (1));
i__19529__auto___29068 = G__29069;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.web_url.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.web_url.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29061){
var vec__29062 = p__29061;
var msg = cljs.core.nth.call(null,vec__29062,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29062,msg){
return (function (p1__29058_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29058_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__29058_SHARP_))) && ((cljs.core.not.call(null,(function (){try{return true;
}catch (e29066){if((e29066 instanceof Error)){
var _ = e29066;
return null;
} else {
throw e29066;

}
}})())) || (cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,p1__29058_SHARP_))));
});})(vec__29062,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a valid website URL";
}
})());
});

jkkramer.verily.web_url.cljs$lang$maxFixedArity = (1);

jkkramer.verily.web_url.cljs$lang$applyTo = (function (seq29059){
var G__29060 = cljs.core.first.call(null,seq29059);
var seq29059__$1 = cljs.core.next.call(null,seq29059);
return jkkramer.verily.web_url.cljs$core$IFn$_invoke$arity$variadic(G__29060,seq29059__$1);
});
jkkramer.verily.url = (function jkkramer$verily$url(){
var args__19535__auto__ = [];
var len__19528__auto___29077 = arguments.length;
var i__19529__auto___29078 = (0);
while(true){
if((i__19529__auto___29078 < len__19528__auto___29077)){
args__19535__auto__.push((arguments[i__19529__auto___29078]));

var G__29079 = (i__19529__auto___29078 + (1));
i__19529__auto___29078 = G__29079;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.url.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.url.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29073){
var vec__29074 = p__29073;
var msg = cljs.core.nth.call(null,vec__29074,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29074,msg){
return (function (p1__29070_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29070_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__29070_SHARP_))) && (cljs.core.not.call(null,(function (){try{return cljs.core.re_find.call(null,/^[a-zA-Z]+:\/\//,p1__29070_SHARP_);
}catch (e29076){if((e29076 instanceof Error)){
var _ = e29076;
return null;
} else {
throw e29076;

}
}})()));
});})(vec__29074,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a valid URL";
}
})());
});

jkkramer.verily.url.cljs$lang$maxFixedArity = (1);

jkkramer.verily.url.cljs$lang$applyTo = (function (seq29071){
var G__29072 = cljs.core.first.call(null,seq29071);
var seq29071__$1 = cljs.core.next.call(null,seq29071);
return jkkramer.verily.url.cljs$core$IFn$_invoke$arity$variadic(G__29072,seq29071__$1);
});
jkkramer.verily.string = (function jkkramer$verily$string(){
var args__19535__auto__ = [];
var len__19528__auto___29085 = arguments.length;
var i__19529__auto___29086 = (0);
while(true){
if((i__19529__auto___29086 < len__19528__auto___29085)){
args__19535__auto__.push((arguments[i__19529__auto___29086]));

var G__29087 = (i__19529__auto___29086 + (1));
i__19529__auto___29086 = G__29087;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.string.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.string.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29083){
var vec__29084 = p__29083;
var msg = cljs.core.nth.call(null,vec__29084,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29084,msg){
return (function (p1__29080_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29080_SHARP_)) && (!((p1__29080_SHARP_ == null))) && (!(typeof p1__29080_SHARP_ === 'string'));
});})(vec__29084,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a string";
}
})());
});

jkkramer.verily.string.cljs$lang$maxFixedArity = (1);

jkkramer.verily.string.cljs$lang$applyTo = (function (seq29081){
var G__29082 = cljs.core.first.call(null,seq29081);
var seq29081__$1 = cljs.core.next.call(null,seq29081);
return jkkramer.verily.string.cljs$core$IFn$_invoke$arity$variadic(G__29082,seq29081__$1);
});
jkkramer.verily.strings = (function jkkramer$verily$strings(){
var args__19535__auto__ = [];
var len__19528__auto___29093 = arguments.length;
var i__19529__auto___29094 = (0);
while(true){
if((i__19529__auto___29094 < len__19528__auto___29093)){
args__19535__auto__.push((arguments[i__19529__auto___29094]));

var G__29095 = (i__19529__auto___29094 + (1));
i__19529__auto___29094 = G__29095;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.strings.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.strings.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29091){
var vec__29092 = p__29091;
var msg = cljs.core.nth.call(null,vec__29092,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29092,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__29092,msg){
return (function (p1__29088_SHARP_){
return !(typeof p1__29088_SHARP_ === 'string');
});})(or__18489__auto__,and__18477__auto__,vec__29092,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__29092,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be strings";
}
})());
});

jkkramer.verily.strings.cljs$lang$maxFixedArity = (1);

jkkramer.verily.strings.cljs$lang$applyTo = (function (seq29089){
var G__29090 = cljs.core.first.call(null,seq29089);
var seq29089__$1 = cljs.core.next.call(null,seq29089);
return jkkramer.verily.strings.cljs$core$IFn$_invoke$arity$variadic(G__29090,seq29089__$1);
});
jkkramer.verily.bool = (function jkkramer$verily$bool(){
var args__19535__auto__ = [];
var len__19528__auto___29101 = arguments.length;
var i__19529__auto___29102 = (0);
while(true){
if((i__19529__auto___29102 < len__19528__auto___29101)){
args__19535__auto__.push((arguments[i__19529__auto___29102]));

var G__29103 = (i__19529__auto___29102 + (1));
i__19529__auto___29102 = G__29103;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.bool.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.bool.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29099){
var vec__29100 = p__29099;
var msg = cljs.core.nth.call(null,vec__29100,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29100,msg){
return (function (p1__29096_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29096_SHARP_)) && (!((p1__29096_SHARP_ == null))) && (!(p1__29096_SHARP_ === true)) && (!(p1__29096_SHARP_ === false));
});})(vec__29100,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be true or false";
}
})());
});

jkkramer.verily.bool.cljs$lang$maxFixedArity = (1);

jkkramer.verily.bool.cljs$lang$applyTo = (function (seq29097){
var G__29098 = cljs.core.first.call(null,seq29097);
var seq29097__$1 = cljs.core.next.call(null,seq29097);
return jkkramer.verily.bool.cljs$core$IFn$_invoke$arity$variadic(G__29098,seq29097__$1);
});
jkkramer.verily.bools = (function jkkramer$verily$bools(){
var args__19535__auto__ = [];
var len__19528__auto___29109 = arguments.length;
var i__19529__auto___29110 = (0);
while(true){
if((i__19529__auto___29110 < len__19528__auto___29109)){
args__19535__auto__.push((arguments[i__19529__auto___29110]));

var G__29111 = (i__19529__auto___29110 + (1));
i__19529__auto___29110 = G__29111;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.bools.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.bools.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29107){
var vec__29108 = p__29107;
var msg = cljs.core.nth.call(null,vec__29108,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29108,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__29108,msg){
return (function (p1__29104_SHARP_){
return (!(p1__29104_SHARP_ === true)) && (!(p1__29104_SHARP_ === false));
});})(or__18489__auto__,and__18477__auto__,vec__29108,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__29108,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be all true or false";
}
})());
});

jkkramer.verily.bools.cljs$lang$maxFixedArity = (1);

jkkramer.verily.bools.cljs$lang$applyTo = (function (seq29105){
var G__29106 = cljs.core.first.call(null,seq29105);
var seq29105__$1 = cljs.core.next.call(null,seq29105);
return jkkramer.verily.bools.cljs$core$IFn$_invoke$arity$variadic(G__29106,seq29105__$1);
});
jkkramer.verily.integer = (function jkkramer$verily$integer(){
var args__19535__auto__ = [];
var len__19528__auto___29117 = arguments.length;
var i__19529__auto___29118 = (0);
while(true){
if((i__19529__auto___29118 < len__19528__auto___29117)){
args__19535__auto__.push((arguments[i__19529__auto___29118]));

var G__29119 = (i__19529__auto___29118 + (1));
i__19529__auto___29118 = G__29119;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.integer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.integer.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29115){
var vec__29116 = p__29115;
var msg = cljs.core.nth.call(null,vec__29116,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29116,msg){
return (function (p1__29112_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29112_SHARP_)) && (!((p1__29112_SHARP_ == null))) && (!(cljs.core.integer_QMARK_.call(null,p1__29112_SHARP_)));
});})(vec__29116,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a number";
}
})());
});

jkkramer.verily.integer.cljs$lang$maxFixedArity = (1);

jkkramer.verily.integer.cljs$lang$applyTo = (function (seq29113){
var G__29114 = cljs.core.first.call(null,seq29113);
var seq29113__$1 = cljs.core.next.call(null,seq29113);
return jkkramer.verily.integer.cljs$core$IFn$_invoke$arity$variadic(G__29114,seq29113__$1);
});
jkkramer.verily.integers = (function jkkramer$verily$integers(){
var args__19535__auto__ = [];
var len__19528__auto___29125 = arguments.length;
var i__19529__auto___29126 = (0);
while(true){
if((i__19529__auto___29126 < len__19528__auto___29125)){
args__19535__auto__.push((arguments[i__19529__auto___29126]));

var G__29127 = (i__19529__auto___29126 + (1));
i__19529__auto___29126 = G__29127;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.integers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.integers.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29123){
var vec__29124 = p__29123;
var msg = cljs.core.nth.call(null,vec__29124,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29124,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__29124,msg){
return (function (p1__29120_SHARP_){
return !(cljs.core.integer_QMARK_.call(null,p1__29120_SHARP_));
});})(or__18489__auto__,and__18477__auto__,vec__29124,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__29124,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be numbers";
}
})());
});

jkkramer.verily.integers.cljs$lang$maxFixedArity = (1);

jkkramer.verily.integers.cljs$lang$applyTo = (function (seq29121){
var G__29122 = cljs.core.first.call(null,seq29121);
var seq29121__$1 = cljs.core.next.call(null,seq29121);
return jkkramer.verily.integers.cljs$core$IFn$_invoke$arity$variadic(G__29122,seq29121__$1);
});
jkkramer.verily.floating_point = (function jkkramer$verily$floating_point(){
var args__19535__auto__ = [];
var len__19528__auto___29133 = arguments.length;
var i__19529__auto___29134 = (0);
while(true){
if((i__19529__auto___29134 < len__19528__auto___29133)){
args__19535__auto__.push((arguments[i__19529__auto___29134]));

var G__29135 = (i__19529__auto___29134 + (1));
i__19529__auto___29134 = G__29135;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.floating_point.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.floating_point.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29131){
var vec__29132 = p__29131;
var msg = cljs.core.nth.call(null,vec__29132,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29132,msg){
return (function (p1__29128_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29128_SHARP_)) && (!((p1__29128_SHARP_ == null))) && (!(typeof p1__29128_SHARP_ === 'number'));
});})(vec__29132,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a decimal number";
}
})());
});

jkkramer.verily.floating_point.cljs$lang$maxFixedArity = (1);

jkkramer.verily.floating_point.cljs$lang$applyTo = (function (seq29129){
var G__29130 = cljs.core.first.call(null,seq29129);
var seq29129__$1 = cljs.core.next.call(null,seq29129);
return jkkramer.verily.floating_point.cljs$core$IFn$_invoke$arity$variadic(G__29130,seq29129__$1);
});
jkkramer.verily.floating_points = (function jkkramer$verily$floating_points(){
var args__19535__auto__ = [];
var len__19528__auto___29141 = arguments.length;
var i__19529__auto___29142 = (0);
while(true){
if((i__19529__auto___29142 < len__19528__auto___29141)){
args__19535__auto__.push((arguments[i__19529__auto___29142]));

var G__29143 = (i__19529__auto___29142 + (1));
i__19529__auto___29142 = G__29143;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.floating_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.floating_points.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29139){
var vec__29140 = p__29139;
var msg = cljs.core.nth.call(null,vec__29140,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29140,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__29140,msg){
return (function (p1__29136_SHARP_){
return !(typeof p1__29136_SHARP_ === 'number');
});})(or__18489__auto__,and__18477__auto__,vec__29140,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__29140,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be decimal numbers";
}
})());
});

jkkramer.verily.floating_points.cljs$lang$maxFixedArity = (1);

jkkramer.verily.floating_points.cljs$lang$applyTo = (function (seq29137){
var G__29138 = cljs.core.first.call(null,seq29137);
var seq29137__$1 = cljs.core.next.call(null,seq29137);
return jkkramer.verily.floating_points.cljs$core$IFn$_invoke$arity$variadic(G__29138,seq29137__$1);
});
jkkramer.verily.decimal_str_QMARK_ = (function jkkramer$verily$decimal_str_QMARK_(x){
var and__18477__auto__ = typeof x === 'string';
if(and__18477__auto__){
return cljs.core.re_matches.call(null,/[0-9\.]+/,x);
} else {
return and__18477__auto__;
}
});
jkkramer.verily.decimal = (function jkkramer$verily$decimal(){
var args__19535__auto__ = [];
var len__19528__auto___29149 = arguments.length;
var i__19529__auto___29150 = (0);
while(true){
if((i__19529__auto___29150 < len__19528__auto___29149)){
args__19535__auto__.push((arguments[i__19529__auto___29150]));

var G__29151 = (i__19529__auto___29150 + (1));
i__19529__auto___29150 = G__29151;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.decimal.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.decimal.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29147){
var vec__29148 = p__29147;
var msg = cljs.core.nth.call(null,vec__29148,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29148,msg){
return (function (p1__29144_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29144_SHARP_)) && (!((p1__29144_SHARP_ == null))) && (cljs.core.not.call(null,jkkramer.verily.decimal_str_QMARK_.call(null,p1__29144_SHARP_)));
});})(vec__29148,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a decimal number";
}
})());
});

jkkramer.verily.decimal.cljs$lang$maxFixedArity = (1);

jkkramer.verily.decimal.cljs$lang$applyTo = (function (seq29145){
var G__29146 = cljs.core.first.call(null,seq29145);
var seq29145__$1 = cljs.core.next.call(null,seq29145);
return jkkramer.verily.decimal.cljs$core$IFn$_invoke$arity$variadic(G__29146,seq29145__$1);
});
jkkramer.verily.decimals = (function jkkramer$verily$decimals(){
var args__19535__auto__ = [];
var len__19528__auto___29157 = arguments.length;
var i__19529__auto___29158 = (0);
while(true){
if((i__19529__auto___29158 < len__19528__auto___29157)){
args__19535__auto__.push((arguments[i__19529__auto___29158]));

var G__29159 = (i__19529__auto___29158 + (1));
i__19529__auto___29158 = G__29159;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.decimals.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.decimals.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29155){
var vec__29156 = p__29155;
var msg = cljs.core.nth.call(null,vec__29156,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29156,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__29156,msg){
return (function (p1__29152_SHARP_){
return cljs.core.not.call(null,jkkramer.verily.decimal_str_QMARK_.call(null,p1__29152_SHARP_));
});})(or__18489__auto__,and__18477__auto__,vec__29156,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__29156,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be decimal numbers";
}
})());
});

jkkramer.verily.decimals.cljs$lang$maxFixedArity = (1);

jkkramer.verily.decimals.cljs$lang$applyTo = (function (seq29153){
var G__29154 = cljs.core.first.call(null,seq29153);
var seq29153__$1 = cljs.core.next.call(null,seq29153);
return jkkramer.verily.decimals.cljs$core$IFn$_invoke$arity$variadic(G__29154,seq29153__$1);
});
jkkramer.verily.min_val = (function jkkramer$verily$min_val(){
var args__19535__auto__ = [];
var len__19528__auto___29166 = arguments.length;
var i__19529__auto___29167 = (0);
while(true){
if((i__19529__auto___29167 < len__19528__auto___29166)){
args__19535__auto__.push((arguments[i__19529__auto___29167]));

var G__29168 = (i__19529__auto___29167 + (1));
i__19529__auto___29167 = G__29168;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.min_val.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.min_val.cljs$core$IFn$_invoke$arity$variadic = (function (min,keys,p__29164){
var vec__29165 = p__29164;
var msg = cljs.core.nth.call(null,vec__29165,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29165,msg){
return (function (p1__29160_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29160_SHARP_)) && (!((p1__29160_SHARP_ == null))) && ((!(typeof p1__29160_SHARP_ === 'number')) || ((min > p1__29160_SHARP_)));
});})(vec__29165,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("cannot be less than "),cljs.core.str(min)].join('');
}
})());
});

jkkramer.verily.min_val.cljs$lang$maxFixedArity = (2);

jkkramer.verily.min_val.cljs$lang$applyTo = (function (seq29161){
var G__29162 = cljs.core.first.call(null,seq29161);
var seq29161__$1 = cljs.core.next.call(null,seq29161);
var G__29163 = cljs.core.first.call(null,seq29161__$1);
var seq29161__$2 = cljs.core.next.call(null,seq29161__$1);
return jkkramer.verily.min_val.cljs$core$IFn$_invoke$arity$variadic(G__29162,G__29163,seq29161__$2);
});
jkkramer.verily.at_least = jkkramer.verily.min_val;
jkkramer.verily.max_val = (function jkkramer$verily$max_val(){
var args__19535__auto__ = [];
var len__19528__auto___29175 = arguments.length;
var i__19529__auto___29176 = (0);
while(true){
if((i__19529__auto___29176 < len__19528__auto___29175)){
args__19535__auto__.push((arguments[i__19529__auto___29176]));

var G__29177 = (i__19529__auto___29176 + (1));
i__19529__auto___29176 = G__29177;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.max_val.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.max_val.cljs$core$IFn$_invoke$arity$variadic = (function (max,keys,p__29173){
var vec__29174 = p__29173;
var msg = cljs.core.nth.call(null,vec__29174,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29174,msg){
return (function (p1__29169_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29169_SHARP_)) && (!((p1__29169_SHARP_ == null))) && ((!(typeof p1__29169_SHARP_ === 'number')) || ((max < p1__29169_SHARP_)));
});})(vec__29174,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("cannot be more than "),cljs.core.str(max)].join('');
}
})());
});

jkkramer.verily.max_val.cljs$lang$maxFixedArity = (2);

jkkramer.verily.max_val.cljs$lang$applyTo = (function (seq29170){
var G__29171 = cljs.core.first.call(null,seq29170);
var seq29170__$1 = cljs.core.next.call(null,seq29170);
var G__29172 = cljs.core.first.call(null,seq29170__$1);
var seq29170__$2 = cljs.core.next.call(null,seq29170__$1);
return jkkramer.verily.max_val.cljs$core$IFn$_invoke$arity$variadic(G__29171,G__29172,seq29170__$2);
});
jkkramer.verily.at_most = jkkramer.verily.max_val;
jkkramer.verily.within = (function jkkramer$verily$within(){
var args__19535__auto__ = [];
var len__19528__auto___29185 = arguments.length;
var i__19529__auto___29186 = (0);
while(true){
if((i__19529__auto___29186 < len__19528__auto___29185)){
args__19535__auto__.push((arguments[i__19529__auto___29186]));

var G__29187 = (i__19529__auto___29186 + (1));
i__19529__auto___29186 = G__29187;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((3) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((3)),(0))):null);
return jkkramer.verily.within.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19536__auto__);
});

jkkramer.verily.within.cljs$core$IFn$_invoke$arity$variadic = (function (min,max,keys,p__29183){
var vec__29184 = p__29183;
var msg = cljs.core.nth.call(null,vec__29184,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29184,msg){
return (function (p1__29178_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29178_SHARP_)) && (!((p1__29178_SHARP_ == null))) && ((!(typeof p1__29178_SHARP_ === 'number')) || (((min > p1__29178_SHARP_)) || ((max < p1__29178_SHARP_))));
});})(vec__29184,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("must be within "),cljs.core.str(min),cljs.core.str(" and "),cljs.core.str(max)].join('');
}
})());
});

jkkramer.verily.within.cljs$lang$maxFixedArity = (3);

jkkramer.verily.within.cljs$lang$applyTo = (function (seq29179){
var G__29180 = cljs.core.first.call(null,seq29179);
var seq29179__$1 = cljs.core.next.call(null,seq29179);
var G__29181 = cljs.core.first.call(null,seq29179__$1);
var seq29179__$2 = cljs.core.next.call(null,seq29179__$1);
var G__29182 = cljs.core.first.call(null,seq29179__$2);
var seq29179__$3 = cljs.core.next.call(null,seq29179__$2);
return jkkramer.verily.within.cljs$core$IFn$_invoke$arity$variadic(G__29180,G__29181,G__29182,seq29179__$3);
});
jkkramer.verily.positive = (function jkkramer$verily$positive(){
var args__19535__auto__ = [];
var len__19528__auto___29193 = arguments.length;
var i__19529__auto___29194 = (0);
while(true){
if((i__19529__auto___29194 < len__19528__auto___29193)){
args__19535__auto__.push((arguments[i__19529__auto___29194]));

var G__29195 = (i__19529__auto___29194 + (1));
i__19529__auto___29194 = G__29195;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.positive.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.positive.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29191){
var vec__29192 = p__29191;
var msg = cljs.core.nth.call(null,vec__29192,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29192,msg){
return (function (p1__29188_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29188_SHARP_)) && (!((p1__29188_SHARP_ == null))) && ((!(typeof p1__29188_SHARP_ === 'number')) || (!((p1__29188_SHARP_ > (0)))));
});})(vec__29192,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a positive number";
}
})());
});

jkkramer.verily.positive.cljs$lang$maxFixedArity = (1);

jkkramer.verily.positive.cljs$lang$applyTo = (function (seq29189){
var G__29190 = cljs.core.first.call(null,seq29189);
var seq29189__$1 = cljs.core.next.call(null,seq29189);
return jkkramer.verily.positive.cljs$core$IFn$_invoke$arity$variadic(G__29190,seq29189__$1);
});
jkkramer.verily.negative = (function jkkramer$verily$negative(){
var args__19535__auto__ = [];
var len__19528__auto___29201 = arguments.length;
var i__19529__auto___29202 = (0);
while(true){
if((i__19529__auto___29202 < len__19528__auto___29201)){
args__19535__auto__.push((arguments[i__19529__auto___29202]));

var G__29203 = (i__19529__auto___29202 + (1));
i__19529__auto___29202 = G__29203;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.negative.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.negative.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29199){
var vec__29200 = p__29199;
var msg = cljs.core.nth.call(null,vec__29200,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29200,msg){
return (function (p1__29196_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29196_SHARP_)) && (!((p1__29196_SHARP_ == null))) && ((!(typeof p1__29196_SHARP_ === 'number')) || (!((p1__29196_SHARP_ < (0)))));
});})(vec__29200,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a negative number";
}
})());
});

jkkramer.verily.negative.cljs$lang$maxFixedArity = (1);

jkkramer.verily.negative.cljs$lang$applyTo = (function (seq29197){
var G__29198 = cljs.core.first.call(null,seq29197);
var seq29197__$1 = cljs.core.next.call(null,seq29197);
return jkkramer.verily.negative.cljs$core$IFn$_invoke$arity$variadic(G__29198,seq29197__$1);
});
jkkramer.verily.date = (function jkkramer$verily$date(){
var args__19535__auto__ = [];
var len__19528__auto___29209 = arguments.length;
var i__19529__auto___29210 = (0);
while(true){
if((i__19529__auto___29210 < len__19528__auto___29209)){
args__19535__auto__.push((arguments[i__19529__auto___29210]));

var G__29211 = (i__19529__auto___29210 + (1));
i__19529__auto___29210 = G__29211;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.date.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.date.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29207){
var vec__29208 = p__29207;
var msg = cljs.core.nth.call(null,vec__29208,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29208,msg){
return (function (p1__29204_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29204_SHARP_)) && (!((p1__29204_SHARP_ == null))) && (!((p1__29204_SHARP_ instanceof Date)));
});})(vec__29208,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a date";
}
})());
});

jkkramer.verily.date.cljs$lang$maxFixedArity = (1);

jkkramer.verily.date.cljs$lang$applyTo = (function (seq29205){
var G__29206 = cljs.core.first.call(null,seq29205);
var seq29205__$1 = cljs.core.next.call(null,seq29205);
return jkkramer.verily.date.cljs$core$IFn$_invoke$arity$variadic(G__29206,seq29205__$1);
});
jkkramer.verily.dates = (function jkkramer$verily$dates(){
var args__19535__auto__ = [];
var len__19528__auto___29217 = arguments.length;
var i__19529__auto___29218 = (0);
while(true){
if((i__19529__auto___29218 < len__19528__auto___29217)){
args__19535__auto__.push((arguments[i__19529__auto___29218]));

var G__29219 = (i__19529__auto___29218 + (1));
i__19529__auto___29218 = G__29219;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.dates.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.dates.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29215){
var vec__29216 = p__29215;
var msg = cljs.core.nth.call(null,vec__29216,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29216,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__29216,msg){
return (function (p1__29212_SHARP_){
return !((p1__29212_SHARP_ instanceof Date));
});})(or__18489__auto__,and__18477__auto__,vec__29216,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__29216,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be dates";
}
})());
});

jkkramer.verily.dates.cljs$lang$maxFixedArity = (1);

jkkramer.verily.dates.cljs$lang$applyTo = (function (seq29213){
var G__29214 = cljs.core.first.call(null,seq29213);
var seq29213__$1 = cljs.core.next.call(null,seq29213);
return jkkramer.verily.dates.cljs$core$IFn$_invoke$arity$variadic(G__29214,seq29213__$1);
});
jkkramer.verily.after_QMARK_ = (function jkkramer$verily$after_QMARK_(d1,d2){
return (d2 < d1);
});
jkkramer.verily.after = (function jkkramer$verily$after(){
var args__19535__auto__ = [];
var len__19528__auto___29226 = arguments.length;
var i__19529__auto___29227 = (0);
while(true){
if((i__19529__auto___29227 < len__19528__auto___29226)){
args__19535__auto__.push((arguments[i__19529__auto___29227]));

var G__29228 = (i__19529__auto___29227 + (1));
i__19529__auto___29227 = G__29228;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.after.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.after.cljs$core$IFn$_invoke$arity$variadic = (function (date,keys,p__29224){
var vec__29225 = p__29224;
var msg = cljs.core.nth.call(null,vec__29225,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29225,msg){
return (function (p1__29220_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29220_SHARP_)) && (!((p1__29220_SHARP_ == null))) && ((!((p1__29220_SHARP_ instanceof Date))) || (cljs.core.not.call(null,jkkramer.verily.after_QMARK_.call(null,p1__29220_SHARP_,date))));
});})(vec__29225,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("must be after "),cljs.core.str(date)].join('');
}
})());
});

jkkramer.verily.after.cljs$lang$maxFixedArity = (2);

jkkramer.verily.after.cljs$lang$applyTo = (function (seq29221){
var G__29222 = cljs.core.first.call(null,seq29221);
var seq29221__$1 = cljs.core.next.call(null,seq29221);
var G__29223 = cljs.core.first.call(null,seq29221__$1);
var seq29221__$2 = cljs.core.next.call(null,seq29221__$1);
return jkkramer.verily.after.cljs$core$IFn$_invoke$arity$variadic(G__29222,G__29223,seq29221__$2);
});
jkkramer.verily.before_QMARK_ = (function jkkramer$verily$before_QMARK_(d1,d2){
return (d1 < d2);
});
jkkramer.verily.before = (function jkkramer$verily$before(){
var args__19535__auto__ = [];
var len__19528__auto___29235 = arguments.length;
var i__19529__auto___29236 = (0);
while(true){
if((i__19529__auto___29236 < len__19528__auto___29235)){
args__19535__auto__.push((arguments[i__19529__auto___29236]));

var G__29237 = (i__19529__auto___29236 + (1));
i__19529__auto___29236 = G__29237;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.before.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.before.cljs$core$IFn$_invoke$arity$variadic = (function (date,keys,p__29233){
var vec__29234 = p__29233;
var msg = cljs.core.nth.call(null,vec__29234,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29234,msg){
return (function (p1__29229_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29229_SHARP_)) && (!((p1__29229_SHARP_ == null))) && ((!((p1__29229_SHARP_ instanceof Date))) || (cljs.core.not.call(null,jkkramer.verily.before_QMARK_.call(null,p1__29229_SHARP_,date))));
});})(vec__29234,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("must be before "),cljs.core.str(date)].join('');
}
})());
});

jkkramer.verily.before.cljs$lang$maxFixedArity = (2);

jkkramer.verily.before.cljs$lang$applyTo = (function (seq29230){
var G__29231 = cljs.core.first.call(null,seq29230);
var seq29230__$1 = cljs.core.next.call(null,seq29230);
var G__29232 = cljs.core.first.call(null,seq29230__$1);
var seq29230__$2 = cljs.core.next.call(null,seq29230__$1);
return jkkramer.verily.before.cljs$core$IFn$_invoke$arity$variadic(G__29231,G__29232,seq29230__$2);
});
jkkramer.verily.digits = (function jkkramer$verily$digits(n){
return cljs.core.map.call(null,(function (p1__29238_SHARP_){
return (p1__29238_SHARP_.charCodeAt((0)) - (48));
}),[cljs.core.str(n)].join(''));
});
jkkramer.verily.luhn_QMARK_ = (function jkkramer$verily$luhn_QMARK_(x){
var n = ((typeof x === 'string')?clojure.string.replace.call(null,x,/[^0-9]/,""):x);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,((function (n){
return (function (d,idx){
if(cljs.core.even_QMARK_.call(null,idx)){
return cljs.core.reduce.call(null,cljs.core._PLUS_,jkkramer.verily.digits.call(null,(d * (2))));
} else {
return d;
}
});})(n))
,cljs.core.reverse.call(null,jkkramer.verily.digits.call(null,n)),cljs.core.iterate.call(null,cljs.core.inc,(1))));
return (cljs.core.mod.call(null,sum,(10)) === (0));
});
jkkramer.verily.luhn = (function jkkramer$verily$luhn(){
var args__19535__auto__ = [];
var len__19528__auto___29244 = arguments.length;
var i__19529__auto___29245 = (0);
while(true){
if((i__19529__auto___29245 < len__19528__auto___29244)){
args__19535__auto__.push((arguments[i__19529__auto___29245]));

var G__29246 = (i__19529__auto___29245 + (1));
i__19529__auto___29245 = G__29246;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.luhn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.luhn.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__29242){
var vec__29243 = p__29242;
var msg = cljs.core.nth.call(null,vec__29243,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__29243,msg){
return (function (p1__29239_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__29239_SHARP_)) && (!((p1__29239_SHARP_ == null))) && (cljs.core.not.call(null,jkkramer.verily.luhn_QMARK_.call(null,p1__29239_SHARP_)));
});})(vec__29243,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "number is not valid";
}
})());
});

jkkramer.verily.luhn.cljs$lang$maxFixedArity = (1);

jkkramer.verily.luhn.cljs$lang$applyTo = (function (seq29240){
var G__29241 = cljs.core.first.call(null,seq29240);
var seq29240__$1 = cljs.core.next.call(null,seq29240);
return jkkramer.verily.luhn.cljs$core$IFn$_invoke$arity$variadic(G__29241,seq29240__$1);
});
jkkramer.verily.combine = (function jkkramer$verily$combine(){
var args__19535__auto__ = [];
var len__19528__auto___29249 = arguments.length;
var i__19529__auto___29250 = (0);
while(true){
if((i__19529__auto___29250 < len__19528__auto___29249)){
args__19535__auto__.push((arguments[i__19529__auto___29250]));

var G__29251 = (i__19529__auto___29250 + (1));
i__19529__auto___29250 = G__29251;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((0) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((0)),(0))):null);
return jkkramer.verily.combine.cljs$core$IFn$_invoke$arity$variadic(argseq__19536__auto__);
});

jkkramer.verily.combine.cljs$core$IFn$_invoke$arity$variadic = (function (validators){
return (function (m){
return cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,jkkramer.verily.seqify,cljs.core.keep.call(null,(function (p1__29247_SHARP_){
return p1__29247_SHARP_.call(null,m);
}),validators)));
});
});

jkkramer.verily.combine.cljs$lang$maxFixedArity = (0);

jkkramer.verily.combine.cljs$lang$applyTo = (function (seq29248){
return jkkramer.verily.combine.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29248));
});
jkkramer.verily.validations_map = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"booleans","booleans",-883685439),new cljs.core.Keyword(null,"email","email",1415816706),new cljs.core.Keyword(null,"date","date",-1463434462),new cljs.core.Keyword(null,"max-length","max-length",-254826109),new cljs.core.Keyword(null,"decimals","decimals",1715096484),new cljs.core.Keyword(null,"contains","contains",676899812),new cljs.core.Keyword(null,"min-length","min-length",-325792315),new cljs.core.Keyword(null,"dates","dates",-1600154075),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"integers","integers",1109066438),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"us-zip","us-zip",99525255),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"strings","strings",-2055406807),new cljs.core.Keyword(null,"luhn","luhn",2107621225),new cljs.core.Keyword(null,"positive","positive",1112941866),new cljs.core.Keyword(null,"negative","negative",-1562068438),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"at-least","at-least",267196846),new cljs.core.Keyword(null,"matches","matches",635497998),new cljs.core.Keyword(null,"floating-points","floating-points",1367959567),new cljs.core.Keyword(null,"bigints","bigints",508771281),new cljs.core.Keyword(null,"floating-point","floating-point",164663314),new cljs.core.Keyword(null,"integer","integer",-604721710),new cljs.core.Keyword(null,"after","after",594996914),new cljs.core.Keyword(null,"str","str",1089608819),new cljs.core.Keyword(null,"exact","exact",1438022323),new cljs.core.Keyword(null,"bools","bools",1248415956),new cljs.core.Keyword(null,"decimal","decimal",-170212044),new cljs.core.Keyword(null,"ints","ints",893195924),new cljs.core.Keyword(null,"max-val","max-val",-1492247884),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"within","within",-76827465),new cljs.core.Keyword(null,"every-in","every-in",929753720),new cljs.core.Keyword(null,"complete","complete",-500388775),new cljs.core.Keyword(null,"bool","bool",1444635321),new cljs.core.Keyword(null,"equal","equal",-1921681350),new cljs.core.Keyword(null,"before","before",-1633692388),new cljs.core.Keyword(null,"web-url","web-url",601349660),new cljs.core.Keyword(null,"not-blank","not-blank",-661874020),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"at-most","at-most",34804861),new cljs.core.Keyword(null,"strs","strs",1175537277),new cljs.core.Keyword(null,"required","required",1807647006),new cljs.core.Keyword(null,"min-val","min-val",-243137826),new cljs.core.Keyword(null,"floats","floats",-1126940417),new cljs.core.Keyword(null,"in","in",-1531184865)],[jkkramer.verily.bools,jkkramer.verily.email,jkkramer.verily.date,jkkramer.verily.max_length,jkkramer.verily.decimals,jkkramer.verily.contains,jkkramer.verily.min_length,jkkramer.verily.dates,jkkramer.verily.integer,jkkramer.verily.integers,jkkramer.verily.decimal,jkkramer.verily.us_zip,jkkramer.verily.floating_point,jkkramer.verily.strings,jkkramer.verily.luhn,jkkramer.verily.positive,jkkramer.verily.negative,jkkramer.verily.string,jkkramer.verily.at_least,jkkramer.verily.matches,jkkramer.verily.floating_points,jkkramer.verily.decimals,jkkramer.verily.floating_point,jkkramer.verily.integer,jkkramer.verily.after,jkkramer.verily.string,jkkramer.verily.exact,jkkramer.verily.bools,jkkramer.verily.decimal,jkkramer.verily.integers,jkkramer.verily.max_val,jkkramer.verily.url,jkkramer.verily.within,jkkramer.verily.every_in,jkkramer.verily.complete,jkkramer.verily.bool,jkkramer.verily.equal,jkkramer.verily.before,jkkramer.verily.web_url,jkkramer.verily.not_blank,jkkramer.verily.bool,jkkramer.verily.at_most,jkkramer.verily.strings,jkkramer.verily.required,jkkramer.verily.min_val,jkkramer.verily.floating_points,jkkramer.verily.in$]);
if(typeof jkkramer.verily.validation__GT_fn !== 'undefined'){
} else {
jkkramer.verily.validation__GT_fn = (function (){var method_table__19383__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19384__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19385__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19386__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19387__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"jkkramer.verily","validation->fn"),((function (method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__,hierarchy__19387__auto__){
return (function (vspec){
return cljs.core.first.call(null,vspec);
});})(method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__,hierarchy__19387__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19387__auto__,method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__));
})();
}
cljs.core._add_method.call(null,jkkramer.verily.validation__GT_fn,new cljs.core.Keyword(null,"default","default",-1987822328),(function (vspec){
var temp__4423__auto__ = cljs.core.get.call(null,jkkramer.verily.validations_map,cljs.core.first.call(null,vspec));
if(cljs.core.truth_(temp__4423__auto__)){
var vfn = temp__4423__auto__;
return cljs.core.apply.call(null,vfn,cljs.core.rest.call(null,vspec));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("Unknown validation "),cljs.core.str(cljs.core.first.call(null,vspec))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"vspec","vspec",-1158741640),cljs.core.first.call(null,vspec)], null));
}
}));
jkkramer.verily.validations__GT_fn = (function jkkramer$verily$validations__GT_fn(validations){
return cljs.core.apply.call(null,jkkramer.verily.combine,cljs.core.map.call(null,jkkramer.verily.validation__GT_fn,validations));
});
jkkramer.verily.validate = (function jkkramer$verily$validate(values,validations){
return jkkramer.verily.validations__GT_fn.call(null,validations).call(null,values);
});

//# sourceMappingURL=verily.js.map