// Compiled by ClojureScript 1.7.48 {}
goog.provide('om_inputs.core');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('schema.core');
goog.require('om_inputs.i18n');
goog.require('om_inputs.validation');
goog.require('om_inputs.schema_utils');
goog.require('sablono.core');
goog.require('om_inputs.typing_controls');
goog.require('om_inputs.date_utils');
goog.require('om_inputs.utils');
goog.require('jkkramer.verily');
goog.require('cljs.core.async');
goog.require('schema.coerce');
goog.require('om_inputs.extern');
goog.require('clojure.string');
goog.require('goog.events');
goog.require('om_inputs.schemas');
cljs.core.enable_console_print_BANG_.call(null);
/**
 * Get value from an event
 */
om_inputs.core.e_value = (function om_inputs$core$e_value(e){
return e.target.value;
});
/**
 * Get the checked status of a checkbox.
 */
om_inputs.core.e_checked = (function om_inputs$core$e_checked(e){
return e.target.checked;
});
om_inputs.core.styles = (function om_inputs$core$styles(){
var args__19535__auto__ = [];
var len__19528__auto___23863 = arguments.length;
var i__19529__auto___23864 = (0);
while(true){
if((i__19529__auto___23864 < len__19528__auto___23863)){
args__19535__auto__.push((arguments[i__19529__auto___23864]));

var G__23865 = (i__19529__auto___23864 + (1));
i__19529__auto___23864 = G__23865;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((0) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((0)),(0))):null);
return om_inputs.core.styles.cljs$core$IFn$_invoke$arity$variadic(argseq__19536__auto__);
});

om_inputs.core.styles.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return clojure.string.join.call(null," ",args);
});

om_inputs.core.styles.cljs$lang$maxFixedArity = (0);

om_inputs.core.styles.cljs$lang$applyTo = (function (seq23862){
return om_inputs.core.styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq23862));
});
if(typeof om_inputs.core.magic_input !== 'undefined'){
} else {
om_inputs.core.magic_input = (function (){var method_table__19383__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19384__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19385__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19386__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19387__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"om-inputs.core","magic-input"),((function (method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__,hierarchy__19387__auto__){
return (function (p__23866){
var map__23867 = p__23866;
var map__23867__$1 = ((((!((map__23867 == null)))?((((map__23867.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23867.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23867):map__23867);
var opts = cljs.core.get.call(null,map__23867__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"type","type",1174270348)], null),om_inputs.schema_utils.sch_type.call(null,new cljs.core.Keyword(null,"k-sch","k-sch",-193796815).cljs$core$IFn$_invoke$arity$1(opts)));
});})(method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__,hierarchy__19387__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19387__auto__,method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__));
})();
}
/**
 * Display the i18n label of a select or radio group entry, fall backs to the code.
 */
om_inputs.core.enum_label = (function om_inputs$core$enum_label(i18n,code){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),code,new cljs.core.Keyword(null,"label","label",1718410804)], null),(((code instanceof cljs.core.Keyword))?om_inputs.utils.full_name.call(null,code):code));
});
/**
 * Choose if we iterate on the values of the schema enum or on the keys of the i18n data.
 */
om_inputs.core.choose_iterator = (function om_inputs$core$choose_iterator(p__23869){
var map__23872 = p__23869;
var map__23872__$1 = ((((!((map__23872 == null)))?((((map__23872.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23872.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23872):map__23872);
var i18n = cljs.core.get.call(null,map__23872__$1,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
var k_sch = cljs.core.get.call(null,map__23872__$1,new cljs.core.Keyword(null,"k-sch","k-sch",-193796815));
var label_order = cljs.core.get.call(null,map__23872__$1,new cljs.core.Keyword(null,"label-order","label-order",113701622));
var temp__4423__auto__ = (function (){var and__18477__auto__ = label_order;
if(cljs.core.truth_(and__18477__auto__)){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
} else {
return and__18477__auto__;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var data = temp__4423__auto__;
return cljs.core.keys.call(null,data);
} else {
return new cljs.core.Keyword(null,"vs","vs",-2022097090).cljs$core$IFn$_invoke$arity$1(k_sch);
}
});
cljs.core._add_method.call(null,om_inputs.core.magic_input,"enum",(function (p__23874){
var map__23875 = p__23874;
var map__23875__$1 = ((((!((map__23875 == null)))?((((map__23875.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23875.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23875):map__23875);
var map__23876 = cljs.core.get.call(null,map__23875__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23876__$1 = ((((!((map__23876 == null)))?((((map__23876.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23876.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23876):map__23876);
var options = map__23876__$1;
var attrs = cljs.core.get.call(null,map__23876__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var i18n = cljs.core.get.call(null,map__23876__$1,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),attrs,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),""], null),""], null),cljs.core.map.call(null,((function (map__23875,map__23875__$1,map__23876,map__23876__$1,options,attrs,i18n){
return (function (code){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),code], null),om_inputs.core.enum_label.call(null,i18n,code)], null);
});})(map__23875,map__23875__$1,map__23876,map__23876__$1,options,attrs,i18n))
,om_inputs.core.choose_iterator.call(null,options)))], null);
}));
om_inputs.core.radio_group = (function om_inputs$core$radio_group(style,p__23879){
var map__23884 = p__23879;
var map__23884__$1 = ((((!((map__23884 == null)))?((((map__23884.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23884.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23884):map__23884);
var map__23885 = cljs.core.get.call(null,map__23884__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23885__$1 = ((((!((map__23885 == null)))?((((map__23885.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23885.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23885):map__23885);
var options = map__23885__$1;
var attrs = cljs.core.get.call(null,map__23885__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var k = cljs.core.get.call(null,map__23885__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var i18n = cljs.core.get.call(null,map__23885__$1,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
var chan = cljs.core.get.call(null,map__23884__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"input-group"], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,((function (map__23884,map__23884__$1,map__23885,map__23885__$1,options,attrs,k,i18n,chan){
return (function (code){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),style], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"checked","checked",-50955819),cljs.core._EQ_.call(null,code,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs)),new cljs.core.Keyword(null,"className","className",-1983287057),"",new cljs.core.Keyword(null,"value","value",305978217),code,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__23884,map__23884__$1,map__23885,map__23885__$1,options,attrs,k,i18n,chan){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,code], null));
});})(map__23884,map__23884__$1,map__23885,map__23885__$1,options,attrs,k,i18n,chan))
], null))], null),om_inputs.core.enum_label.call(null,i18n,code)], null)], null);
});})(map__23884,map__23884__$1,map__23885,map__23885__$1,options,attrs,k,i18n,chan))
,om_inputs.core.choose_iterator.call(null,options)))], null);
});
cljs.core._add_method.call(null,om_inputs.core.magic_input,"radio-group",(function (m){
return om_inputs.core.radio_group.call(null,"radio",m);
}));
cljs.core._add_method.call(null,om_inputs.core.magic_input,"radio-group-inline",(function (m){
return om_inputs.core.radio_group.call(null,"radio-inline",m);
}));
/**
 * HOF, generates a function,  that closes over the value, for segemented control
 */
om_inputs.core.make_segmented = (function om_inputs$core$make_segmented(type,k,value,i18n,chan){
return (function (code){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"active","active",1895962068),cljs.core._EQ_.call(null,code,value),new cljs.core.Keyword(null,"className","className",-1983287057),om_inputs.core.styles.call(null,"btn",((cljs.core._EQ_.call(null,code,value))?"btn-primary":"btn-default")),new cljs.core.Keyword(null,"key","key",-1516042587),[cljs.core.str(om_inputs.utils.full_name.call(null,k)),cljs.core.str("/"),cljs.core.str(code)].join(''),new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str(om_inputs.utils.full_name.call(null,k)),cljs.core.str("/"),cljs.core.str(code)].join(''),new cljs.core.Keyword(null,"value","value",305978217),code,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),(function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,code], null));
})], null),om_inputs.core.enum_label.call(null,i18n,code)], null);
});
});
cljs.core._add_method.call(null,om_inputs.core.magic_input,"btn-group",(function (p__23888){
var map__23889 = p__23888;
var map__23889__$1 = ((((!((map__23889 == null)))?((((map__23889.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23889.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23889):map__23889);
var map__23890 = cljs.core.get.call(null,map__23889__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23890__$1 = ((((!((map__23890 == null)))?((((map__23890.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23890.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23890):map__23890);
var options = map__23890__$1;
var attrs = cljs.core.get.call(null,map__23890__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var k = cljs.core.get.call(null,map__23890__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var i18n = cljs.core.get.call(null,map__23890__$1,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
var chan = cljs.core.get.call(null,map__23889__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"btn-group"], null)),cljs.core.map.call(null,om_inputs.core.make_segmented.call(null,"button",k,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs),i18n,chan),om_inputs.core.choose_iterator.call(null,options))], null);
}));
cljs.core._add_method.call(null,om_inputs.core.magic_input,"range-btn-group",(function (p__23893){
var map__23894 = p__23893;
var map__23894__$1 = ((((!((map__23894 == null)))?((((map__23894.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23894.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23894):map__23894);
var map__23895 = cljs.core.get.call(null,map__23894__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23895__$1 = ((((!((map__23895 == null)))?((((map__23895.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23895.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23895):map__23895);
var attrs = cljs.core.get.call(null,map__23895__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var i18n = cljs.core.get.call(null,map__23895__$1,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
var k = cljs.core.get.call(null,map__23895__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var chan = cljs.core.get.call(null,map__23894__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var map__23898 = attrs;
var map__23898__$1 = ((((!((map__23898 == null)))?((((map__23898.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23898.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23898):map__23898);
var min = cljs.core.get.call(null,map__23898__$1,new cljs.core.Keyword(null,"min","min",444991522));
var max = cljs.core.get.call(null,map__23898__$1,new cljs.core.Keyword(null,"max","max",61366548));
var step = cljs.core.get.call(null,map__23898__$1,new cljs.core.Keyword(null,"step","step",1288888124),(1));
var value = cljs.core.get.call(null,map__23898__$1,new cljs.core.Keyword(null,"value","value",305978217));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"btn-group"], null)),cljs.core.map.call(null,om_inputs.core.make_segmented.call(null,"button",k,value,i18n,chan),cljs.core.range.call(null,(min | (0)),((max | (0)) + (1)),step))], null);
}));
cljs.core._add_method.call(null,om_inputs.core.magic_input,"stepper",(function (p__23900){
var map__23901 = p__23900;
var map__23901__$1 = ((((!((map__23901 == null)))?((((map__23901.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23901.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23901):map__23901);
var map__23902 = cljs.core.get.call(null,map__23901__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23902__$1 = ((((!((map__23902 == null)))?((((map__23902.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23902.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23902):map__23902);
var attrs = cljs.core.get.call(null,map__23902__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var k = cljs.core.get.call(null,map__23902__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var chan = cljs.core.get.call(null,map__23901__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var map__23905 = attrs;
var map__23905__$1 = ((((!((map__23905 == null)))?((((map__23905.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23905.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23905):map__23905);
var min = cljs.core.get.call(null,map__23905__$1,new cljs.core.Keyword(null,"min","min",444991522));
var max = cljs.core.get.call(null,map__23905__$1,new cljs.core.Keyword(null,"max","max",61366548));
var step = cljs.core.get.call(null,map__23905__$1,new cljs.core.Keyword(null,"step","step",1288888124));
var value = cljs.core.get.call(null,map__23905__$1,new cljs.core.Keyword(null,"value","value",305978217));
var size = cljs.core.get.call(null,map__23905__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var value__$1 = om_inputs.utils.__GT_int.call(null,value);
var min__$1 = om_inputs.utils.__GT_int.call(null,min);
var max__$1 = om_inputs.utils.__GT_int.call(null,max);
var step__$1 = om_inputs.utils.__GT_int.call(null,step);
var plus = (cljs.core.truth_(step__$1)?cljs.core.partial.call(null,cljs.core._PLUS_,cljs.core.long$.call(null,step__$1)):cljs.core.inc);
var minus = (cljs.core.truth_(step__$1)?cljs.core.partial.call(null,cljs.core._PLUS_,(- cljs.core.long$.call(null,step__$1))):cljs.core.dec);
var style = om_inputs.core.styles.call(null,"btn btn-default",(cljs.core.truth_(size)?[cljs.core.str("btn-"),cljs.core.str(size)].join(''):null));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"btn-group stepper"], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"className","className",-1983287057),style,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__23905,map__23905__$1,min,max,step,value,size,value__$1,min__$1,max__$1,step__$1,plus,minus,style,map__23901,map__23901__$1,map__23902,map__23902__$1,attrs,k,chan){
return (function (){
if(cljs.core.truth_((function (){var or__18489__auto__ = (min__$1 == null);
if(or__18489__auto__){
return or__18489__auto__;
} else {
var and__18477__auto__ = min__$1;
if(cljs.core.truth_(and__18477__auto__)){
return ((min__$1 | (0)) <= minus.call(null,value__$1));
} else {
return and__18477__auto__;
}
}
})())){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,[cljs.core.str(minus.call(null,value__$1))].join('')], null));
} else {
return null;
}
});})(map__23905,map__23905__$1,min,max,step,value,size,value__$1,min__$1,max__$1,step__$1,plus,minus,style,map__23901,map__23901__$1,map__23902,map__23902__$1,attrs,k,chan))
], null),"-"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"className","className",-1983287057),"input-stepper",new cljs.core.Keyword(null,"size","size",1098693007),(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,value__$1))?(1):cljs.core.count.call(null,[cljs.core.str(value__$1)].join(''))),new cljs.core.Keyword(null,"value","value",305978217),value__$1], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"className","className",-1983287057),style,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__23905,map__23905__$1,min,max,step,value,size,value__$1,min__$1,max__$1,step__$1,plus,minus,style,map__23901,map__23901__$1,map__23902,map__23902__$1,attrs,k,chan){
return (function (){
if(cljs.core.truth_((function (){var or__18489__auto__ = (max__$1 == null);
if(or__18489__auto__){
return or__18489__auto__;
} else {
var and__18477__auto__ = max__$1;
if(cljs.core.truth_(and__18477__auto__)){
return (plus.call(null,value__$1) <= (max__$1 | (0)));
} else {
return and__18477__auto__;
}
}
})())){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,[cljs.core.str(plus.call(null,value__$1))].join('')], null));
} else {
return null;
}
});})(map__23905,map__23905__$1,min,max,step,value,size,value__$1,min__$1,max__$1,step__$1,plus,minus,style,map__23901,map__23901__$1,map__23902,map__23902__$1,attrs,k,chan))
], null),"+"], null)], null);
}));
cljs.core._add_method.call(null,om_inputs.core.magic_input,schema.core.Inst,(function (p__23908){
var map__23909 = p__23908;
var map__23909__$1 = ((((!((map__23909 == null)))?((((map__23909.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23909.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23909):map__23909);
var map__23910 = cljs.core.get.call(null,map__23909__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23910__$1 = ((((!((map__23910 == null)))?((((map__23910.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23910.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23910):map__23910);
var k = cljs.core.get.call(null,map__23910__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var attrs = cljs.core.get.call(null,map__23910__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var chan = cljs.core.get.call(null,map__23909__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var date = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),om_inputs.date_utils.default_fmt,new cljs.core.Keyword(null,"value","value",305978217),om_inputs.date_utils.display_date.call(null,date),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (date,map__23909,map__23909__$1,map__23910,map__23910__$1,k,attrs,chan){
return (function (){
return cljs.core.List.EMPTY;
});})(date,map__23909,map__23909__$1,map__23910,map__23910__$1,k,attrs,chan))
,new cljs.core.Keyword(null,"onBlur","onBlur",229342509),((function (date,map__23909,map__23909__$1,map__23910,map__23910__$1,k,attrs,chan){
return (function (p1__23907_SHARP_){
var v = om_inputs.core.e_value.call(null,p1__23907_SHARP_);
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,v))?null:om_inputs.date_utils.parse.call(null,v))], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"focus","focus",234677911),k], null));

return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));
});})(date,map__23909,map__23909__$1,map__23910,map__23910__$1,k,attrs,chan))
], null))], null);
}));
cljs.core._add_method.call(null,om_inputs.core.magic_input,"date",(function (p__23914){
var map__23915 = p__23914;
var map__23915__$1 = ((((!((map__23915 == null)))?((((map__23915.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23915.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23915):map__23915);
var map__23916 = cljs.core.get.call(null,map__23915__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23916__$1 = ((((!((map__23916 == null)))?((((map__23916.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23916.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23916):map__23916);
var k = cljs.core.get.call(null,map__23916__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var attrs = cljs.core.get.call(null,map__23916__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var chan = cljs.core.get.call(null,map__23915__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var date = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"date",new cljs.core.Keyword(null,"value","value",305978217),om_inputs.date_utils.display_date.call(null,"yyyy-MM-dd",date),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (date,map__23915,map__23915__$1,map__23916,map__23916__$1,k,attrs,chan){
return (function (){
return cljs.core.List.EMPTY;
});})(date,map__23915,map__23915__$1,map__23916,map__23916__$1,k,attrs,chan))
,new cljs.core.Keyword(null,"onBlur","onBlur",229342509),((function (date,map__23915,map__23915__$1,map__23916,map__23916__$1,k,attrs,chan){
return (function (p1__23913_SHARP_){
var v = om_inputs.core.e_value.call(null,p1__23913_SHARP_);
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,v))?null:om_inputs.date_utils.parse.call(null,"yyyy-MM-dd",v))], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"focus","focus",234677911),k], null));

return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));
});})(date,map__23915,map__23915__$1,map__23916,map__23916__$1,k,attrs,chan))
], null))], null);
}));
cljs.core._add_method.call(null,om_inputs.core.magic_input,schema.core.Bool,(function (p__23920){
var map__23921 = p__23920;
var map__23921__$1 = ((((!((map__23921 == null)))?((((map__23921.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23921.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23921):map__23921);
var map__23922 = cljs.core.get.call(null,map__23921__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23922__$1 = ((((!((map__23922 == null)))?((((map__23922.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23922.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23922):map__23922);
var k = cljs.core.get.call(null,map__23922__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var attrs = cljs.core.get.call(null,map__23922__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var chan = cljs.core.get.call(null,map__23921__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var value = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"checked","checked",-50955819),Boolean(value),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (value,map__23921,map__23921__$1,map__23922,map__23922__$1,k,attrs,chan){
return (function (p1__23919_SHARP_){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,p1__23919_SHARP_.target.checked], null));
});})(value,map__23921,map__23921__$1,map__23922,map__23922__$1,k,attrs,chan))
,new cljs.core.Keyword(null,"type","type",1174270348),"checkbox"], null))], null);
}));
cljs.core._add_method.call(null,om_inputs.core.magic_input,"range",(function (p__23925){
var map__23926 = p__23925;
var map__23926__$1 = ((((!((map__23926 == null)))?((((map__23926.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23926.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23926):map__23926);
var map__23927 = cljs.core.get.call(null,map__23926__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23927__$1 = ((((!((map__23927 == null)))?((((map__23927.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23927.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23927):map__23927);
var attrs = cljs.core.get.call(null,map__23927__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),"range"], null),attrs)], null);
}));
cljs.core._add_method.call(null,om_inputs.core.magic_input,"now",(function (p__23930){
var map__23931 = p__23930;
var map__23931__$1 = ((((!((map__23931 == null)))?((((map__23931.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23931.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23931):map__23931);
var map__23932 = cljs.core.get.call(null,map__23931__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23932__$1 = ((((!((map__23932 == null)))?((((map__23932.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23932.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23932):map__23932);
var attrs = cljs.core.get.call(null,map__23932__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var k = cljs.core.get.call(null,map__23932__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var chan = cljs.core.get.call(null,map__23931__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"className","className",-1983287057),"btn",new cljs.core.Keyword(null,"preventDefault","preventDefault",-1714933772),true,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__23931,map__23931__$1,map__23932,map__23932__$1,attrs,k,chan){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(new Date())], null));
});})(map__23931,map__23931__$1,map__23932,map__23932__$1,attrs,k,chan))
], null))], null);
}));
cljs.core._add_method.call(null,om_inputs.core.magic_input,"email",(function (p__23935){
var map__23936 = p__23935;
var map__23936__$1 = ((((!((map__23936 == null)))?((((map__23936.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23936.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23936):map__23936);
var map__23937 = cljs.core.get.call(null,map__23936__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23937__$1 = ((((!((map__23937 == null)))?((((map__23937.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23937.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23937):map__23937);
var attrs = cljs.core.get.call(null,map__23937__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"email",new cljs.core.Keyword(null,"autoCapitalize","autoCapitalize",438011742),"off",new cljs.core.Keyword(null,"autoCorrect","autoCorrect",448626584),"off"], null),attrs)], null);
}));
cljs.core._add_method.call(null,om_inputs.core.magic_input,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__23940){
var map__23941 = p__23940;
var map__23941__$1 = ((((!((map__23941 == null)))?((((map__23941.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23941.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23941):map__23941);
var map__23942 = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__23942__$1 = ((((!((map__23942 == null)))?((((map__23942.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23942.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23942):map__23942);
var attrs = cljs.core.get.call(null,map__23942__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),attrs], null);
}));

om_inputs.core.Required = {};

om_inputs.core.required_QMARK_ = (function om_inputs$core$required_QMARK_(this$){
if((!((this$ == null))) && (!((this$.om_inputs$core$Required$required_QMARK_$arity$1 == null)))){
return this$.om_inputs$core$Required$required_QMARK_$arity$1(this$);
} else {
var x__19125__auto__ = (((this$ == null))?null:this$);
var m__19126__auto__ = (om_inputs.core.required_QMARK_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,this$);
} else {
var m__19126__auto____$1 = (om_inputs.core.required_QMARK_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Required.required?",this$);
}
}
}
});

schema.core.OptionalKey.prototype.om_inputs$core$Required$ = true;

schema.core.OptionalKey.prototype.om_inputs$core$Required$required_QMARK_$arity$1 = (function (this$){
var this$__$1 = this;
return false;
});

schema.core.RequiredKey.prototype.om_inputs$core$Required$ = true;

schema.core.RequiredKey.prototype.om_inputs$core$Required$required_QMARK_$arity$1 = (function (this$){
var this$__$1 = this;
return true;
});

cljs.core.Keyword.prototype.om_inputs$core$Required$ = true;

cljs.core.Keyword.prototype.om_inputs$core$Required$required_QMARK_$arity$1 = (function (k){
var k__$1 = this;
return true;
});
/**
 * Choose the initial value.
 * s/Num fields must be represented as string because of the typing control.
 * If an initial value is provided for a s/Num it will be represented as a string in the
 * local state.
 */
om_inputs.core.init_state_value = (function om_inputs$core$init_state_value(v,t){
var pred__23950 = cljs.core._EQ_;
var expr__23951 = t;
if(cljs.core.truth_(pred__23950.call(null,schema.core.Num,expr__23951))){
return [cljs.core.str(v)].join('');
} else {
return v;
}
});
var ufv___23974 = schema.utils.use_fn_validation;
var output_schema23953_23975 = om_inputs.schemas.sch_business_state;
var input_schema23954_23976 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"sch","sch",763282093,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"init","init",-234949907,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema23959_23977 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"sch","sch",763282093,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker23955_23978 = schema.core.checker.call(null,input_schema23954_23976);
var output_checker23956_23979 = schema.core.checker.call(null,output_schema23953_23975);
var input_checker23960_23980 = schema.core.checker.call(null,input_schema23959_23977);
var output_checker23961_23981 = schema.core.checker.call(null,output_schema23953_23975);
/**
 * Inputs: ([sch init] [sch])
 * Returns: sch-business-state
 * 
 * Build the initial business local state backing the inputs in the form.
 * It accepts init values from the options
 * TODO validate that the value is correct
 */
om_inputs.core.build_init_state = ((function (ufv___23974,output_schema23953_23975,input_schema23954_23976,input_schema23959_23977,input_checker23955_23978,output_checker23956_23979,input_checker23960_23980,output_checker23961_23981){
return (function om_inputs$core$build_init_state(){
var args23963 = [];
var len__19528__auto___23982 = arguments.length;
var i__19529__auto___23983 = (0);
while(true){
if((i__19529__auto___23983 < len__19528__auto___23982)){
args23963.push((arguments[i__19529__auto___23983]));

var G__23984 = (i__19529__auto___23983 + (1));
i__19529__auto___23983 = G__23984;
continue;
} else {
}
break;
}

var G__23965 = args23963.length;
switch (G__23965) {
case 2:
return om_inputs.core.build_init_state.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return om_inputs.core.build_init_state.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23963.length)].join('')));

}
});})(ufv___23974,output_schema23953_23975,input_schema23954_23976,input_schema23959_23977,input_checker23955_23978,output_checker23956_23979,input_checker23960_23980,output_checker23961_23981))
;

om_inputs.core.build_init_state.cljs$core$IFn$_invoke$arity$2 = ((function (ufv___23974,output_schema23953_23975,input_schema23954_23976,input_schema23959_23977,input_checker23955_23978,output_checker23956_23979,input_checker23960_23980,output_checker23961_23981){
return (function (G__23957,G__23958){
var validate__20882__auto__ = ufv___23974.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___23986 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23957,G__23958], null);
var temp__4425__auto___23987 = input_checker23955_23978.call(null,args__20883__auto___23986);
if(cljs.core.truth_(temp__4425__auto___23987)){
var error__20884__auto___23988 = temp__4425__auto___23987;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"build-init-state","build-init-state",980879982,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build the initial business local state backing the inputs in the form.\n   It accepts init values from the options\n  TODO validate that the value is correct"], null)),cljs.core.pr_str.call(null,error__20884__auto___23988)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23954_23976,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___23986,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___23988], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var sch = G__23957;
var init = G__23958;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__20882__auto__,ufv___23974,output_schema23953_23975,input_schema23954_23976,input_schema23959_23977,input_checker23955_23978,output_checker23956_23979,input_checker23960_23980,output_checker23961_23981){
return (function om_inputs$core$iter__23966(s__23967){
return (new cljs.core.LazySeq(null,((function (validate__20882__auto__,ufv___23974,output_schema23953_23975,input_schema23954_23976,input_schema23959_23977,input_checker23955_23978,output_checker23956_23979,input_checker23960_23980,output_checker23961_23981){
return (function (){
var s__23967__$1 = s__23967;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23967__$1);
if(temp__4425__auto__){
var s__23967__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23967__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__23967__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__23969 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__23968 = (0);
while(true){
if((i__23968 < size__19241__auto__)){
var vec__23972 = cljs.core._nth.call(null,c__19240__auto__,i__23968);
var k = cljs.core.nth.call(null,vec__23972,(0),null);
var t = cljs.core.nth.call(null,vec__23972,(1),null);
var fk = cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k);
var t__$1 = om_inputs.schema_utils.sch_type.call(null,t);
var init_val = cljs.core.get.call(null,init,fk,"");
cljs.core.chunk_append.call(null,b__23969,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),om_inputs.core.init_state_value.call(null,init_val,t__$1),new cljs.core.Keyword(null,"required","required",1807647006),om_inputs.core.required_QMARK_.call(null,k),new cljs.core.Keyword(null,"type","type",1174270348),t__$1], null)], null));

var G__23989 = (i__23968 + (1));
i__23968 = G__23989;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23969),om_inputs$core$iter__23966.call(null,cljs.core.chunk_rest.call(null,s__23967__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23969),null);
}
} else {
var vec__23973 = cljs.core.first.call(null,s__23967__$2);
var k = cljs.core.nth.call(null,vec__23973,(0),null);
var t = cljs.core.nth.call(null,vec__23973,(1),null);
var fk = cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k);
var t__$1 = om_inputs.schema_utils.sch_type.call(null,t);
var init_val = cljs.core.get.call(null,init,fk,"");
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),om_inputs.core.init_state_value.call(null,init_val,t__$1),new cljs.core.Keyword(null,"required","required",1807647006),om_inputs.core.required_QMARK_.call(null,k),new cljs.core.Keyword(null,"type","type",1174270348),t__$1], null)], null),om_inputs$core$iter__23966.call(null,cljs.core.rest.call(null,s__23967__$2)));
}
} else {
return null;
}
break;
}
});})(validate__20882__auto__,ufv___23974,output_schema23953_23975,input_schema23954_23976,input_schema23959_23977,input_checker23955_23978,output_checker23956_23979,input_checker23960_23980,output_checker23961_23981))
,null,null));
});})(validate__20882__auto__,ufv___23974,output_schema23953_23975,input_schema23954_23976,input_schema23959_23977,input_checker23955_23978,output_checker23956_23979,input_checker23960_23980,output_checker23961_23981))
;
return iter__19242__auto__.call(null,sch);
})());
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___23990 = output_checker23956_23979.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___23990)){
var error__20884__auto___23991 = temp__4425__auto___23990;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"build-init-state","build-init-state",980879982,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build the initial business local state backing the inputs in the form.\n   It accepts init values from the options\n  TODO validate that the value is correct"], null)),cljs.core.pr_str.call(null,error__20884__auto___23991)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23953_23975,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___23991], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___23974,output_schema23953_23975,input_schema23954_23976,input_schema23959_23977,input_checker23955_23978,output_checker23956_23979,input_checker23960_23980,output_checker23961_23981))
;

om_inputs.core.build_init_state.cljs$core$IFn$_invoke$arity$1 = ((function (ufv___23974,output_schema23953_23975,input_schema23954_23976,input_schema23959_23977,input_checker23955_23978,output_checker23956_23979,input_checker23960_23980,output_checker23961_23981){
return (function (G__23962){
var validate__20882__auto__ = ufv___23974.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___23992 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23962], null);
var temp__4425__auto___23993 = input_checker23960_23980.call(null,args__20883__auto___23992);
if(cljs.core.truth_(temp__4425__auto___23993)){
var error__20884__auto___23994 = temp__4425__auto___23993;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"build-init-state","build-init-state",980879982,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build the initial business local state backing the inputs in the form.\n   It accepts init values from the options\n  TODO validate that the value is correct"], null)),cljs.core.pr_str.call(null,error__20884__auto___23994)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23959_23977,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___23992,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___23994], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var sch = G__23962;
while(true){
return om_inputs.core.build_init_state.call(null,sch,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___23995 = output_checker23961_23981.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___23995)){
var error__20884__auto___23996 = temp__4425__auto___23995;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"build-init-state","build-init-state",980879982,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build the initial business local state backing the inputs in the form.\n   It accepts init values from the options\n  TODO validate that the value is correct"], null)),cljs.core.pr_str.call(null,error__20884__auto___23996)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23953_23975,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___23996], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___23974,output_schema23953_23975,input_schema23954_23976,input_schema23959_23977,input_checker23955_23978,output_checker23956_23979,input_checker23960_23980,output_checker23961_23981))
;

om_inputs.core.build_init_state.cljs$lang$maxFixedArity = 2;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.core.build_init_state),schema.core.make_fn_schema.call(null,output_schema23953_23975,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23954_23976,input_schema23959_23977], null)));
/**
 * Decorate an HTML node with google.ui.inputdatepicker
 */
om_inputs.core.add_date_picker_BANG_ = (function om_inputs$core$add_date_picker_BANG_(k,node,chan,f){
var dp = om_inputs.date_utils.date_picker.call(null,f);
dp.decorate(node);

return goog.events.listen(dp,goog.ui.DatePicker.Events.CHANGE,((function (dp){
return (function (p1__23997_SHARP_){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,om_inputs.date_utils.goog_date__GT_js_date.call(null,p1__23997_SHARP_.date)], null));

return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));
});})(dp))
);
});
om_inputs.core.handle_date_fields_BANG_ = (function om_inputs$core$handle_date_fields_BANG_(owner,f,opts){
var chan = om_inputs.extern.get_state.call(null,owner,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var state = om_inputs.extern.get_state.call(null,owner,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var date_fieds = (function (){var iter__19242__auto__ = ((function (chan,state){
return (function om_inputs$core$handle_date_fields_BANG__$_iter__24018(s__24019){
return (new cljs.core.LazySeq(null,((function (chan,state){
return (function (){
var s__24019__$1 = s__24019;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__24019__$1);
if(temp__4425__auto__){
var s__24019__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__24019__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__24019__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__24021 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__24020 = (0);
while(true){
if((i__24020 < size__19241__auto__)){
var vec__24028 = cljs.core._nth.call(null,c__19240__auto__,i__24020);
var k = cljs.core.nth.call(null,vec__24028,(0),null);
var map__24029 = cljs.core.nth.call(null,vec__24028,(1),null);
var map__24029__$1 = ((((!((map__24029 == null)))?((((map__24029.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24029.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24029):map__24029);
var type = cljs.core.get.call(null,map__24029__$1,new cljs.core.Keyword(null,"type","type",1174270348));
if((cljs.core._EQ_.call(null,schema.core.Inst,type)) && (cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["date",null,"now",null], null), null).call(null,cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"type","type",1174270348)], null)))))){
cljs.core.chunk_append.call(null,b__24021,k);

var G__24038 = (i__24020 + (1));
i__24020 = G__24038;
continue;
} else {
var G__24039 = (i__24020 + (1));
i__24020 = G__24039;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__24021),om_inputs$core$handle_date_fields_BANG__$_iter__24018.call(null,cljs.core.chunk_rest.call(null,s__24019__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__24021),null);
}
} else {
var vec__24031 = cljs.core.first.call(null,s__24019__$2);
var k = cljs.core.nth.call(null,vec__24031,(0),null);
var map__24032 = cljs.core.nth.call(null,vec__24031,(1),null);
var map__24032__$1 = ((((!((map__24032 == null)))?((((map__24032.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24032.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24032):map__24032);
var type = cljs.core.get.call(null,map__24032__$1,new cljs.core.Keyword(null,"type","type",1174270348));
if((cljs.core._EQ_.call(null,schema.core.Inst,type)) && (cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["date",null,"now",null], null), null).call(null,cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"type","type",1174270348)], null)))))){
return cljs.core.cons.call(null,k,om_inputs$core$handle_date_fields_BANG__$_iter__24018.call(null,cljs.core.rest.call(null,s__24019__$2)));
} else {
var G__24040 = cljs.core.rest.call(null,s__24019__$2);
s__24019__$1 = G__24040;
continue;
}
}
} else {
return null;
}
break;
}
});})(chan,state))
,null,null));
});})(chan,state))
;
return iter__19242__auto__.call(null,state);
})();
var seq__24034 = cljs.core.seq.call(null,date_fieds);
var chunk__24035 = null;
var count__24036 = (0);
var i__24037 = (0);
while(true){
if((i__24037 < count__24036)){
var k = cljs.core._nth.call(null,chunk__24035,i__24037);
om_inputs.core.add_date_picker_BANG_.call(null,k,om_inputs.extern.get_node.call(null,owner,om_inputs.utils.full_name.call(null,k)),chan,f);

var G__24041 = seq__24034;
var G__24042 = chunk__24035;
var G__24043 = count__24036;
var G__24044 = (i__24037 + (1));
seq__24034 = G__24041;
chunk__24035 = G__24042;
count__24036 = G__24043;
i__24037 = G__24044;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__24034);
if(temp__4425__auto__){
var seq__24034__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24034__$1)){
var c__19273__auto__ = cljs.core.chunk_first.call(null,seq__24034__$1);
var G__24045 = cljs.core.chunk_rest.call(null,seq__24034__$1);
var G__24046 = c__19273__auto__;
var G__24047 = cljs.core.count.call(null,c__19273__auto__);
var G__24048 = (0);
seq__24034 = G__24045;
chunk__24035 = G__24046;
count__24036 = G__24047;
i__24037 = G__24048;
continue;
} else {
var k = cljs.core.first.call(null,seq__24034__$1);
om_inputs.core.add_date_picker_BANG_.call(null,k,om_inputs.extern.get_node.call(null,owner,om_inputs.utils.full_name.call(null,k)),chan,f);

var G__24049 = cljs.core.next.call(null,seq__24034__$1);
var G__24050 = null;
var G__24051 = (0);
var G__24052 = (0);
seq__24034 = G__24049;
chunk__24035 = G__24050;
count__24036 = G__24051;
i__24037 = G__24052;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Display a tooltip next to the field to inform the user.
 * options :
 * :k the target field
 * :type serves to build the css class tooltip-type
 * :action attach a function when closing the tooltip
 */
om_inputs.core.tooltip = (function om_inputs$core$tooltip(app,owner,opts){
return om_inputs.extern.create_component.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),cljs.core.with_meta((function (_){
var tool = om_inputs.extern.get_node.call(null,owner,[cljs.core.str(new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts)),cljs.core.str("-tooltip")].join(''));
var elem = document.getElementById(om_inputs.utils.full_name.call(null,new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts)));
var rect_tool = tool.getBoundingClientRect();
var rect = elem.getBoundingClientRect();
var delta = (0.5 * (rect.height - rect_tool.height));
tool.style.left = [cljs.core.str(rect.width),cljs.core.str("px")].join('');

return tool.style.top = [cljs.core.str(delta),cljs.core.str("px")].join('');
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),new cljs.core.Keyword(null,"did-mount","did-mount",918232960)], null)),new cljs.core.Keyword(null,"render","render",-1408033454),(function (_){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"className","className",-1983287057),om_inputs.core.styles.call(null,"popover right",[cljs.core.str("popover-"),cljs.core.str(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(opts))].join('')),new cljs.core.Keyword(null,"role","role",-736691072),"alert",new cljs.core.Keyword(null,"ref","ref",1289896967),[cljs.core.str(new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts)),cljs.core.str("-tooltip")].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"arrow"], null),""], null),(cljs.core.truth_(new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(app))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"popover-title"], null),new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(app)], null):null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"popover-content"], null),new cljs.core.Keyword(null,"mess","mess",530922968).cljs$core$IFn$_invoke$arity$1(app),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"className","className",-1983287057),"close",new cljs.core.Keyword(null,"onClick","onClick",-1991238530),new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts)], null),"x"], null)], null)], null);
})], null));
});
/**
 * Display a dismissable error message
 */
om_inputs.core.message = (function om_inputs$core$message(app,owner,m){
return om_inputs.extern.create_component.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"render","render",-1408033454),(function (this$){
var map__24055 = om_inputs.extern.get_state.call(null,this$);
var map__24055__$1 = ((((!((map__24055 == null)))?((((map__24055.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24055.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24055):map__24055);
var state = map__24055__$1;
var chan = cljs.core.get.call(null,map__24055__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var mess = cljs.core.get.call(null,map__24055__$1,new cljs.core.Keyword(null,"mess","mess",530922968));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"className","className",-1983287057),"alert alert-danger",new cljs.core.Keyword(null,"role","role",-736691072),"alert"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"className","className",-1983287057),"close",new cljs.core.Keyword(null,"data-dismiss","data-dismiss",-2004576016),"alert",new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__24055,map__24055__$1,state,chan,mess){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kill-mess","kill-mess",723475912),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(m)], null));
});})(map__24055,map__24055__$1,state,chan,mess))
], null),"x"], null),mess], null);
})], null));
});
/**
 * Display a small description under the label
 */
om_inputs.core.description = (function om_inputs$core$description(app,owner,m){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"description"], null),new cljs.core.Keyword(null,"desc","desc",2093485764).cljs$core$IFn$_invoke$arity$1(m)], null);
});
om_inputs.core.button_view = (function om_inputs$core$button_view(app,owner,p__24057){
var map__24060 = p__24057;
var map__24060__$1 = ((((!((map__24060 == null)))?((((map__24060.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24060.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24060):map__24060);
var k = cljs.core.get.call(null,map__24060__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var labels = cljs.core.get.call(null,map__24060__$1,new cljs.core.Keyword(null,"labels","labels",-626734591));
var comp_name = cljs.core.get.call(null,map__24060__$1,new cljs.core.Keyword(null,"comp-name","comp-name",-474371587));
var attrs = cljs.core.get.call(null,map__24060__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
return om_inputs.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"render","render",-1408033454),((function (map__24060,map__24060__$1,k,labels,comp_name,attrs){
return (function (this$){
var state = om_inputs.extern.get_state.call(null,this$);
var chan_name = cljs.core.keyword.call(null,[cljs.core.str(cljs.core.name.call(null,k)),cljs.core.str("-chan")].join(''));
var chan = om_inputs.extern.get_state.call(null,owner,chan_name);
var button_state = cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),k], null));
var btn_style = (cljs.core.truth_(button_state)?cljs.core.name.call(null,button_state):null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str(om_inputs.utils.full_name.call(null,comp_name)),cljs.core.str("-"),cljs.core.str(cljs.core.name.call(null,k))].join(''),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),cljs.core._EQ_.call(null,"disabled",btn_style),new cljs.core.Keyword(null,"className","className",-1983287057),om_inputs.core.styles.call(null,"btn btn-primary has-spinner has-error",btn_style),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (state,chan_name,chan,button_state,btn_style,map__24060,map__24060__$1,k,labels,comp_name,attrs){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,k);
});})(state,chan_name,chan,button_state,btn_style,map__24060,map__24060__$1,k,labels,comp_name,attrs))
], null)),om_inputs.i18n.label.call(null,labels,k),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"error"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"fa fa-ban text-danger"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"spinner"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"fa fa-spin fa-cog"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"description"], null),new cljs.core.Keyword(null,"desc","desc",2093485764).cljs$core$IFn$_invoke$arity$1(labels)], null)], null);
});})(map__24060,map__24060__$1,k,labels,comp_name,attrs))
], null));
});
var ufv___24069 = schema.utils.use_fn_validation;
var output_schema24062_24070 = schema.core.Any;
var input_schema24063_24071 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker24064_24072 = schema.core.checker.call(null,input_schema24063_24071);
var output_checker24065_24073 = schema.core.checker.call(null,output_schema24062_24070);
/**
 * Inputs: [m :- sch-business-state f :- s/Keyword k :- s/Keyword]
 */
om_inputs.core.get_in_bs = ((function (ufv___24069,output_schema24062_24070,input_schema24063_24071,input_checker24064_24072,output_checker24065_24073){
return (function om_inputs$core$get_in_bs(G__24066,G__24067,G__24068){
var validate__20882__auto__ = ufv___24069.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24074 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24066,G__24067,G__24068], null);
var temp__4425__auto___24075 = input_checker24064_24072.call(null,args__20883__auto___24074);
if(cljs.core.truth_(temp__4425__auto___24075)){
var error__20884__auto___24076 = temp__4425__auto___24075;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"get-in-bs","get-in-bs",-1499000109,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___24076)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24063_24071,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24074,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24076], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var m = G__24066;
var f = G__24067;
var k = G__24068;
while(true){
return cljs.core.get_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,k], null));
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24077 = output_checker24065_24073.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24077)){
var error__20884__auto___24078 = temp__4425__auto___24077;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"get-in-bs","get-in-bs",-1499000109,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___24078)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24062_24070,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24078], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24069,output_schema24062_24070,input_schema24063_24071,input_checker24064_24072,output_checker24065_24073))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.core.get_in_bs),schema.core.make_fn_schema.call(null,output_schema24062_24070,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema24063_24071], null)));
var ufv___24085 = schema.utils.use_fn_validation;
var output_schema24079_24086 = schema.core.Any;
var input_schema24080_24087 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker24081_24088 = schema.core.checker.call(null,input_schema24080_24087);
var output_checker24082_24089 = schema.core.checker.call(null,output_schema24079_24086);
/**
 * Inputs: [m k]
 * Returns: s/Any
 */
om_inputs.core.fvalue = ((function (ufv___24085,output_schema24079_24086,input_schema24080_24087,input_checker24081_24088,output_checker24082_24089){
return (function om_inputs$core$fvalue(G__24083,G__24084){
var validate__20882__auto__ = ufv___24085.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24090 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24083,G__24084], null);
var temp__4425__auto___24091 = input_checker24081_24088.call(null,args__20883__auto___24090);
if(cljs.core.truth_(temp__4425__auto___24091)){
var error__20884__auto___24092 = temp__4425__auto___24091;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fvalue","fvalue",-1480770053,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___24092)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24080_24087,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24090,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24092], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var m = G__24083;
var k = G__24084;
while(true){
return om_inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"value","value",305978217));
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24093 = output_checker24082_24089.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24093)){
var error__20884__auto___24094 = temp__4425__auto___24093;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fvalue","fvalue",-1480770053,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___24094)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24079_24086,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24094], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24085,output_schema24079_24086,input_schema24080_24087,input_checker24081_24088,output_checker24082_24089))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.core.fvalue),schema.core.make_fn_schema.call(null,output_schema24079_24086,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema24080_24087], null)));
var ufv___24101 = schema.utils.use_fn_validation;
var output_schema24095_24102 = schema.core.maybe.call(null,schema.core.Bool);
var input_schema24096_24103 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker24097_24104 = schema.core.checker.call(null,input_schema24096_24103);
var output_checker24098_24105 = schema.core.checker.call(null,output_schema24095_24102);
/**
 * Inputs: [m k]
 * Returns: (s/maybe s/Bool)
 */
om_inputs.core.fvalid = ((function (ufv___24101,output_schema24095_24102,input_schema24096_24103,input_checker24097_24104,output_checker24098_24105){
return (function om_inputs$core$fvalid(G__24099,G__24100){
var validate__20882__auto__ = ufv___24101.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24106 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24099,G__24100], null);
var temp__4425__auto___24107 = input_checker24097_24104.call(null,args__20883__auto___24106);
if(cljs.core.truth_(temp__4425__auto___24107)){
var error__20884__auto___24108 = temp__4425__auto___24107;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fvalid","fvalid",-323473304,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null))], null)),cljs.core.pr_str.call(null,error__20884__auto___24108)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24096_24103,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24106,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24108], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var m = G__24099;
var k = G__24100;
while(true){
return om_inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"valid","valid",155614240));
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24109 = output_checker24098_24105.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24109)){
var error__20884__auto___24110 = temp__4425__auto___24109;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fvalid","fvalid",-323473304,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null))], null)),cljs.core.pr_str.call(null,error__20884__auto___24110)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24095_24102,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24110], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24101,output_schema24095_24102,input_schema24096_24103,input_checker24097_24104,output_checker24098_24105))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.core.fvalid),schema.core.make_fn_schema.call(null,output_schema24095_24102,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema24096_24103], null)));
var ufv___24117 = schema.utils.use_fn_validation;
var output_schema24111_24118 = schema.core.Bool;
var input_schema24112_24119 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker24113_24120 = schema.core.checker.call(null,input_schema24112_24119);
var output_checker24114_24121 = schema.core.checker.call(null,output_schema24111_24118);
/**
 * Inputs: [m k]
 * Returns: s/Bool
 */
om_inputs.core.frequired = ((function (ufv___24117,output_schema24111_24118,input_schema24112_24119,input_checker24113_24120,output_checker24114_24121){
return (function om_inputs$core$frequired(G__24115,G__24116){
var validate__20882__auto__ = ufv___24117.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24122 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24115,G__24116], null);
var temp__4425__auto___24123 = input_checker24113_24120.call(null,args__20883__auto___24122);
if(cljs.core.truth_(temp__4425__auto___24123)){
var error__20884__auto___24124 = temp__4425__auto___24123;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"frequired","frequired",-1936208580,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___24124)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24112_24119,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24122,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24124], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var m = G__24115;
var k = G__24116;
while(true){
return om_inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"required","required",1807647006));
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24125 = output_checker24114_24121.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24125)){
var error__20884__auto___24126 = temp__4425__auto___24125;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"frequired","frequired",-1936208580,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___24126)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24111_24118,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24126], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24117,output_schema24111_24118,input_schema24112_24119,input_checker24113_24120,output_checker24114_24121))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.core.frequired),schema.core.make_fn_schema.call(null,output_schema24111_24118,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema24112_24119], null)));
var ufv___24133 = schema.utils.use_fn_validation;
var output_schema24127_24134 = om_inputs.validation.sch_errors_list;
var input_schema24128_24135 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker24129_24136 = schema.core.checker.call(null,input_schema24128_24135);
var output_checker24130_24137 = schema.core.checker.call(null,output_schema24127_24134);
/**
 * Inputs: [m k]
 * Returns: va/sch-errors-list
 */
om_inputs.core.ferrors = ((function (ufv___24133,output_schema24127_24134,input_schema24128_24135,input_checker24129_24136,output_checker24130_24137){
return (function om_inputs$core$ferrors(G__24131,G__24132){
var validate__20882__auto__ = ufv___24133.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24138 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24131,G__24132], null);
var temp__4425__auto___24139 = input_checker24129_24136.call(null,args__20883__auto___24138);
if(cljs.core.truth_(temp__4425__auto___24139)){
var error__20884__auto___24140 = temp__4425__auto___24139;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"ferrors","ferrors",257894416,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("va","sch-errors-list","va/sch-errors-list",-338989951,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___24140)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24128_24135,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24138,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24140], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var m = G__24131;
var k = G__24132;
while(true){
return om_inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"error","error",-978969032));
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24141 = output_checker24130_24137.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24141)){
var error__20884__auto___24142 = temp__4425__auto___24141;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"ferrors","ferrors",257894416,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("va","sch-errors-list","va/sch-errors-list",-338989951,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___24142)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24127_24134,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24142], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24133,output_schema24127_24134,input_schema24128_24135,input_checker24129_24136,output_checker24130_24137))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.core.ferrors),schema.core.make_fn_schema.call(null,output_schema24127_24134,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema24128_24135], null)));
var ufv___24149 = schema.utils.use_fn_validation;
var output_schema24143_24150 = schema.core.maybe.call(null,schema.core.Bool);
var input_schema24144_24151 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker24145_24152 = schema.core.checker.call(null,input_schema24144_24151);
var output_checker24146_24153 = schema.core.checker.call(null,output_schema24143_24150);
/**
 * Inputs: [m k]
 * Returns: (s/maybe s/Bool)
 */
om_inputs.core.fdisabled = ((function (ufv___24149,output_schema24143_24150,input_schema24144_24151,input_checker24145_24152,output_checker24146_24153){
return (function om_inputs$core$fdisabled(G__24147,G__24148){
var validate__20882__auto__ = ufv___24149.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24154 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24147,G__24148], null);
var temp__4425__auto___24155 = input_checker24145_24152.call(null,args__20883__auto___24154);
if(cljs.core.truth_(temp__4425__auto___24155)){
var error__20884__auto___24156 = temp__4425__auto___24155;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fdisabled","fdisabled",-1063898034,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null))], null)),cljs.core.pr_str.call(null,error__20884__auto___24156)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24144_24151,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24154,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24156], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var m = G__24147;
var k = G__24148;
while(true){
return om_inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24157 = output_checker24146_24153.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24157)){
var error__20884__auto___24158 = temp__4425__auto___24157;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fdisabled","fdisabled",-1063898034,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null))], null)),cljs.core.pr_str.call(null,error__20884__auto___24158)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24143_24150,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24158], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24149,output_schema24143_24150,input_schema24144_24151,input_checker24145_24152,output_checker24146_24153))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.core.fdisabled),schema.core.make_fn_schema.call(null,output_schema24143_24150,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema24144_24151], null)));
om_inputs.core.ffocus = (function om_inputs$core$ffocus(m,k){
return om_inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"focus","focus",234677911));
});
var ufv___24182 = schema.utils.use_fn_validation;
var output_schema24159_24183 = om_inputs.schemas.sch_business_state;
var input_schema24160_24184 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker24161_24185 = schema.core.checker.call(null,input_schema24160_24184);
var output_checker24162_24186 = schema.core.checker.call(null,output_schema24159_24183);
/**
 * Inputs: [bs :- sch-business-state k :- s/Keyword v :- s/Any]
 * Returns: sch-business-state
 */
om_inputs.core.assoc_in_all = ((function (ufv___24182,output_schema24159_24183,input_schema24160_24184,input_checker24161_24185,output_checker24162_24186){
return (function om_inputs$core$assoc_in_all(G__24163,G__24164,G__24165){
var validate__20882__auto__ = ufv___24182.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24187 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24163,G__24164,G__24165], null);
var temp__4425__auto___24188 = input_checker24161_24185.call(null,args__20883__auto___24187);
if(cljs.core.truth_(temp__4425__auto___24188)){
var error__20884__auto___24189 = temp__4425__auto___24188;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"assoc-in-all","assoc-in-all",-807712230,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___24189)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24160_24184,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24187,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24189], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var bs = G__24163;
var k = G__24164;
var v = G__24165;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__20882__auto__,ufv___24182,output_schema24159_24183,input_schema24160_24184,input_checker24161_24185,output_checker24162_24186){
return (function om_inputs$core$assoc_in_all_$_iter__24174(s__24175){
return (new cljs.core.LazySeq(null,((function (validate__20882__auto__,ufv___24182,output_schema24159_24183,input_schema24160_24184,input_checker24161_24185,output_checker24162_24186){
return (function (){
var s__24175__$1 = s__24175;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__24175__$1);
if(temp__4425__auto__){
var s__24175__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__24175__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__24175__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__24177 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__24176 = (0);
while(true){
if((i__24176 < size__19241__auto__)){
var vec__24180 = cljs.core._nth.call(null,c__19240__auto__,i__24176);
var fk = cljs.core.nth.call(null,vec__24180,(0),null);
var s = cljs.core.nth.call(null,vec__24180,(1),null);
cljs.core.chunk_append.call(null,b__24177,new cljs.core.PersistentArrayMap.fromArray([fk,cljs.core.assoc.call(null,s,k,v)], true, false));

var G__24190 = (i__24176 + (1));
i__24176 = G__24190;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__24177),om_inputs$core$assoc_in_all_$_iter__24174.call(null,cljs.core.chunk_rest.call(null,s__24175__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__24177),null);
}
} else {
var vec__24181 = cljs.core.first.call(null,s__24175__$2);
var fk = cljs.core.nth.call(null,vec__24181,(0),null);
var s = cljs.core.nth.call(null,vec__24181,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([fk,cljs.core.assoc.call(null,s,k,v)], true, false),om_inputs$core$assoc_in_all_$_iter__24174.call(null,cljs.core.rest.call(null,s__24175__$2)));
}
} else {
return null;
}
break;
}
});})(validate__20882__auto__,ufv___24182,output_schema24159_24183,input_schema24160_24184,input_checker24161_24185,output_checker24162_24186))
,null,null));
});})(validate__20882__auto__,ufv___24182,output_schema24159_24183,input_schema24160_24184,input_checker24161_24185,output_checker24162_24186))
;
return iter__19242__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24191 = output_checker24162_24186.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24191)){
var error__20884__auto___24192 = temp__4425__auto___24191;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"assoc-in-all","assoc-in-all",-807712230,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___24192)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24159_24183,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24192], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24182,output_schema24159_24183,input_schema24160_24184,input_checker24161_24185,output_checker24162_24186))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.core.assoc_in_all),schema.core.make_fn_schema.call(null,output_schema24159_24183,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema24160_24184], null)));
/**
 * Disable all inputs after successful validation.
 */
om_inputs.core.disable_all = (function om_inputs$core$disable_all(bs){
return om_inputs.core.assoc_in_all.call(null,bs,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),true);
});
/**
 * Disable all inputs after successful validation.
 */
om_inputs.core.enable_all = (function om_inputs$core$enable_all(bs){
return om_inputs.core.assoc_in_all.call(null,bs,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),false);
});
/**
 * Finds the i18n message for the first error on a field.
 */
om_inputs.core.error_mess = (function om_inputs$core$error_mess(owner,kbs,lang){
var full_i18n = om_inputs.extern.get_i18n_info.call(null,owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),lang], null));
var temp__4425__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(kbs);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__24194 = temp__4425__auto__;
var err_k = cljs.core.nth.call(null,vec__24194,(0),null);
var errs = cljs.core.nthnext.call(null,vec__24194,(1));
return om_inputs.i18n.error.call(null,full_i18n,err_k);
} else {
return null;
}
});
om_inputs.core.validation_style = (function om_inputs$core$validation_style(p__24195){
var map__24198 = p__24195;
var map__24198__$1 = ((((!((map__24198 == null)))?((((map__24198.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24198.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24198):map__24198);
var valid = cljs.core.get.call(null,map__24198__$1,new cljs.core.Keyword(null,"valid","valid",155614240));
var invalid = cljs.core.get.call(null,map__24198__$1,new cljs.core.Keyword(null,"invalid","invalid",412869516));
if(cljs.core.truth_(valid)){
return "has-success";
} else {
if(cljs.core.truth_(invalid)){
return "has-error has-feedback";
} else {
return "";

}
}
});
om_inputs.core.required_style = (function om_inputs$core$required_style(kbs){
if(cljs.core.truth_(new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(kbs))){
return "required";
} else {
return "optional";
}
});
if(typeof om_inputs.core.layout_input !== 'undefined'){
} else {
om_inputs.core.layout_input = (function (){var method_table__19383__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19384__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19385__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19386__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19387__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"om-inputs.core","layout-input"),((function (method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__,hierarchy__19387__auto__){
return (function (_,p__24200,___$1,___$2){
var map__24201 = p__24200;
var map__24201__$1 = ((((!((map__24201 == null)))?((((map__24201.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24201.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24201):map__24201);
var layout = cljs.core.get.call(null,map__24201__$1,new cljs.core.Keyword(null,"layout","layout",-2120940921));
return layout;
});})(method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__,hierarchy__19387__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19387__auto__,method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__));
})();
}
cljs.core._add_method.call(null,om_inputs.core.layout_input,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner,opts,kbs,p__24203){
var map__24204 = p__24203;
var map__24204__$1 = ((((!((map__24204 == null)))?((((map__24204.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24204.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24204):map__24204);
var val_states = map__24204__$1;
var invalid = cljs.core.get.call(null,map__24204__$1,new cljs.core.Keyword(null,"invalid","invalid",412869516));
var map__24206 = om_inputs.extern.get_state.call(null,owner);
var map__24206__$1 = ((((!((map__24206 == null)))?((((map__24206.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24206.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24206):map__24206);
var chan = cljs.core.get.call(null,map__24206__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var lang = cljs.core.get.call(null,map__24206__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),om_inputs.core.styles.call(null,"form-group",om_inputs.core.validation_style.call(null,val_states))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),om_inputs.utils.full_name.call(null,new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts)),new cljs.core.Keyword(null,"className","className",-1983287057),om_inputs.core.styles.call(null,"control-label",om_inputs.core.required_style.call(null,kbs))], null),om_inputs.i18n.label.call(null,opts)], null),(cljs.core.truth_(new cljs.core.Keyword(null,"labeled","labeled",1871152938).cljs$core$IFn$_invoke$arity$1(opts))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"badge"], null),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(kbs)], null):null),(cljs.core.truth_(om_inputs.i18n.desc.call(null,opts))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"description"], null),om_inputs.i18n.desc.call(null,opts)], null):null),(cljs.core.truth_(om_inputs.i18n.html_desc.call(null,opts))?sablono.interpreter.interpret.call(null,om_inputs.i18n.html_desc.call(null,opts)):null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"input-container"], null),(function (){var opts__$1 = cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"className","className",-1983287057)], null),"form-control");
return om_inputs.core.magic_input.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),chan,new cljs.core.Keyword(null,"opts","opts",155075701),opts__$1], null));
})(),(cljs.core.truth_((function (){var and__18477__auto__ = om_inputs.i18n.info.call(null,opts);
if(cljs.core.truth_(and__18477__auto__)){
return new cljs.core.Keyword(null,"focus","focus",234677911).cljs$core$IFn$_invoke$arity$1(kbs);
} else {
return and__18477__auto__;
}
})())?om_inputs.extern.build_component.call(null,om_inputs.core.tooltip,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mess","mess",530922968),om_inputs.i18n.info.call(null,opts),new cljs.core.Keyword(null,"title","title",636505583),om_inputs.i18n.info_title.call(null,opts)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"type","type",1174270348),"info"], null)], null)):null),(function (){var mess = om_inputs.core.error_mess.call(null,owner,kbs,lang);
if(cljs.core.truth_((function (){var and__18477__auto__ = invalid;
if(cljs.core.truth_(and__18477__auto__)){
return mess;
} else {
return and__18477__auto__;
}
})())){
return om_inputs.extern.build_component.call(null,om_inputs.core.tooltip,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mess","mess",530922968),mess], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"type","type",1174270348),"error",new cljs.core.Keyword(null,"action","action",-811238024),((function (mess,map__24206,map__24206__$1,chan,lang,map__24204,map__24204__$1,val_states,invalid){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kill-mess","kill-mess",723475912),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts)], null));
});})(mess,map__24206,map__24206__$1,chan,lang,map__24204,map__24204__$1,val_states,invalid))
], null),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mess","mess",530922968),mess], null)], null));
} else {
return null;
}
})()], null)], null);
}));
cljs.core._add_method.call(null,om_inputs.core.layout_input,"in-line",(function (owner,opts,kbs,p__24208){
var map__24209 = p__24208;
var map__24209__$1 = ((((!((map__24209 == null)))?((((map__24209.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24209.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24209):map__24209);
var val_states = map__24209__$1;
var invalid = cljs.core.get.call(null,map__24209__$1,new cljs.core.Keyword(null,"invalid","invalid",412869516));
var map__24211 = om_inputs.extern.get_state.call(null,owner);
var map__24211__$1 = ((((!((map__24211 == null)))?((((map__24211.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24211.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24211):map__24211);
var chan = cljs.core.get.call(null,map__24211__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var lang = cljs.core.get.call(null,map__24211__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),om_inputs.core.validation_style.call(null,val_states)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),om_inputs.core.styles.call(null,"checkbox",om_inputs.core.required_style.call(null,kbs))], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),om_inputs.utils.full_name.call(null,new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts))], null),(cljs.core.truth_(new cljs.core.Keyword(null,"labeled","labeled",1871152938).cljs$core$IFn$_invoke$arity$1(opts))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"badge"], null),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(kbs)], null):null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"input-container"], null),om_inputs.core.magic_input.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),chan,new cljs.core.Keyword(null,"opts","opts",155075701),opts], null)),(cljs.core.truth_((function (){var and__18477__auto__ = om_inputs.i18n.info.call(null,opts);
if(cljs.core.truth_(and__18477__auto__)){
return new cljs.core.Keyword(null,"focus","focus",234677911).cljs$core$IFn$_invoke$arity$1(opts);
} else {
return and__18477__auto__;
}
})())?om_inputs.extern.build_component.call(null,om_inputs.core.tooltip,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mess","mess",530922968),om_inputs.i18n.info.call(null,opts),new cljs.core.Keyword(null,"title","title",636505583),om_inputs.i18n.info_title.call(null,opts)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"type","type",1174270348),"info"], null)], null)):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),om_inputs.i18n.label.call(null,opts)], null)], null),(function (){var mess = om_inputs.core.error_mess.call(null,owner,kbs,lang);
if(cljs.core.truth_((function (){var and__18477__auto__ = invalid;
if(cljs.core.truth_(and__18477__auto__)){
return mess;
} else {
return and__18477__auto__;
}
})())){
return om_inputs.extern.build_component.call(null,om_inputs.core.tooltip,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mess","mess",530922968),mess], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"type","type",1174270348),"error",new cljs.core.Keyword(null,"action","action",-811238024),((function (mess,map__24211,map__24211__$1,chan,lang,map__24209,map__24209__$1,val_states,invalid){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kill-mess","kill-mess",723475912),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts)], null));
});})(mess,map__24211,map__24211__$1,chan,lang,map__24209,map__24209__$1,val_states,invalid))
], null),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mess","mess",530922968),mess], null)], null));
} else {
return null;
}
})()], null),(cljs.core.truth_(om_inputs.i18n.desc.call(null,opts))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"description"], null),om_inputs.i18n.desc.call(null,opts)], null):null),(cljs.core.truth_(om_inputs.i18n.html_desc.call(null,opts))?sablono.interpreter.interpret.call(null,om_inputs.i18n.html_desc.call(null,opts)):null)], null);
}));
om_inputs.core.build_input = (function om_inputs$core$build_input(owner,p__24215){
var map__24220 = p__24215;
var map__24220__$1 = ((((!((map__24220 == null)))?((((map__24220.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24220.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24220):map__24220);
var opts = map__24220__$1;
var k = cljs.core.get.call(null,map__24220__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var map__24222 = om_inputs.extern.get_state.call(null,owner);
var map__24222__$1 = ((((!((map__24222 == null)))?((((map__24222.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24222.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24222):map__24222);
var chan = cljs.core.get.call(null,map__24222__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var inputs = cljs.core.get.call(null,map__24222__$1,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var kbs = k.call(null,inputs);
var valid = new cljs.core.Keyword(null,"valid","valid",155614240).cljs$core$IFn$_invoke$arity$1(kbs);
var controled = !((valid == null));
var invalid = (controled) && (cljs.core.not.call(null,valid));
var val_states = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"valid","valid",155614240),valid,new cljs.core.Keyword(null,"invalid","invalid",412869516),invalid,new cljs.core.Keyword(null,"controled","controled",1088856164),controled], null);
var k_attrs = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"onBlur","onBlur",229342509),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"onChange","onChange",-312891301),new cljs.core.Keyword(null,"onFocus","onFocus",1152444958)],[om_inputs.utils.full_name.call(null,k),cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),new cljs.core.Keyword(null,"ph","ph",-1483583977)], null)),new cljs.core.Keyword(null,"disabled","disabled",-1529784218).cljs$core$IFn$_invoke$arity$1(kbs),om_inputs.utils.full_name.call(null,k),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(kbs),((function (map__24222,map__24222__$1,chan,inputs,kbs,valid,controled,invalid,val_states,map__24220,map__24220__$1,opts,k){
return (function (){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"focus","focus",234677911),k], null));

return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));
});})(map__24222,map__24222__$1,chan,inputs,kbs,valid,controled,invalid,val_states,map__24220,map__24220__$1,opts,k))
,om_inputs.utils.full_name.call(null,k),((function (map__24222,map__24222__$1,chan,inputs,kbs,valid,controled,invalid,val_states,map__24220,map__24220__$1,opts,k){
return (function (p1__24213_SHARP_){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,om_inputs.core.e_value.call(null,p1__24213_SHARP_)], null));
});})(map__24222,map__24222__$1,chan,inputs,kbs,valid,controled,invalid,val_states,map__24220,map__24220__$1,opts,k))
,((function (map__24222,map__24222__$1,chan,inputs,kbs,valid,controled,invalid,val_states,map__24220,map__24220__$1,opts,k){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"focus","focus",234677911),k], null));
});})(map__24222,map__24222__$1,chan,inputs,kbs,valid,controled,invalid,val_states,map__24220,map__24220__$1,opts,k))
]);
var opts__$1 = cljs.core.update_in.call(null,opts,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713)], null),((function (map__24222,map__24222__$1,chan,inputs,kbs,valid,controled,invalid,val_states,k_attrs,map__24220,map__24220__$1,opts,k){
return (function (p1__24214_SHARP_){
return cljs.core.merge.call(null,k_attrs,p1__24214_SHARP_);
});})(map__24222,map__24222__$1,chan,inputs,kbs,valid,controled,invalid,val_states,k_attrs,map__24220,map__24220__$1,opts,k))
);
return om_inputs.core.layout_input.call(null,owner,opts__$1,kbs,val_states);
});
om_inputs.core.action_states = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"init","init",-1875481434),new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"in-error","in-error",-1865680681),new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),new cljs.core.Keyword(null,"init","init",-1875481434)], null);
om_inputs.core.error_flow = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"init","init",-1875481434),new cljs.core.Keyword(null,"in-error","in-error",-1865680681),new cljs.core.Keyword(null,"in-error","in-error",-1865680681),new cljs.core.Keyword(null,"in-error","in-error",-1865680681)], null);
var ufv___24541 = schema.utils.use_fn_validation;
var output_schema24227_24542 = schema.core.Any;
var input_schema24228_24543 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null);
var input_schema24232_24544 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"comp-name","comp-name",1166159940,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"action","action",829293503,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema24238_24545 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"comp-name","comp-name",1166159940,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"action","action",829293503,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema24245_24546 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"comp-name","comp-name",1166159940,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"action","action",829293503,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"clean","clean",1682065606,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,om_inputs.schemas.SchOptions,cljs.core.with_meta(new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"SchOptions","SchOptions",995391861,null)], null)))], null);
var input_checker24229_24547 = schema.core.checker.call(null,input_schema24228_24543);
var output_checker24230_24548 = schema.core.checker.call(null,output_schema24227_24542);
var input_checker24233_24549 = schema.core.checker.call(null,input_schema24232_24544);
var output_checker24234_24550 = schema.core.checker.call(null,output_schema24227_24542);
var input_checker24239_24551 = schema.core.checker.call(null,input_schema24238_24545);
var output_checker24240_24552 = schema.core.checker.call(null,output_schema24227_24542);
var input_checker24246_24553 = schema.core.checker.call(null,input_schema24245_24546);
var output_checker24247_24554 = schema.core.checker.call(null,output_schema24227_24542);
/**
 * Inputs: ([{:keys [name schema action clean opts], :or {opts {}}, :as spec}] [comp-name :- s/Keyword schema action] [comp-name :- s/Keyword schema action opts] [comp-name :- s/Keyword schema action clean opts :- SchOptions])
 * 
 * Build an input form Om component based on a prismatic/Schema
 */
om_inputs.core.make_input_comp = ((function (ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function om_inputs$core$make_input_comp(){
var args24253 = [];
var len__19528__auto___24555 = arguments.length;
var i__19529__auto___24556 = (0);
while(true){
if((i__19529__auto___24556 < len__19528__auto___24555)){
args24253.push((arguments[i__19529__auto___24556]));

var G__24557 = (i__19529__auto___24556 + (1));
i__19529__auto___24556 = G__24557;
continue;
} else {
}
break;
}

var G__24255 = args24253.length;
switch (G__24255) {
case 1:
return om_inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return om_inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return om_inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return om_inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24253.length)].join('')));

}
});})(ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
;

om_inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$1 = ((function (ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (G__24231){
var validate__20882__auto__ = ufv___24541.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24559 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24231], null);
var temp__4425__auto___24560 = input_checker24229_24547.call(null,args__20883__auto___24559);
if(cljs.core.truth_(temp__4425__auto___24560)){
var error__20884__auto___24561 = temp__4425__auto___24560;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20884__auto___24561)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24228_24543,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24559,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24561], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var G__24257 = G__24231;
var map__24258 = G__24257;
var map__24258__$1 = ((((!((map__24258 == null)))?((((map__24258.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24258.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24258):map__24258);
var spec = map__24258__$1;
var name = cljs.core.get.call(null,map__24258__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var schema__$1 = cljs.core.get.call(null,map__24258__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
var action = cljs.core.get.call(null,map__24258__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var clean = cljs.core.get.call(null,map__24258__$1,new cljs.core.Keyword(null,"clean","clean",41534079));
var opts = cljs.core.get.call(null,map__24258__$1,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY);
var G__24257__$1 = G__24257;
while(true){
var map__24260 = G__24257__$1;
var map__24260__$1 = ((((!((map__24260 == null)))?((((map__24260.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24260.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24260):map__24260);
var spec__$1 = map__24260__$1;
var name__$1 = cljs.core.get.call(null,map__24260__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var schema__$2 = cljs.core.get.call(null,map__24260__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
var action__$1 = cljs.core.get.call(null,map__24260__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var clean__$1 = cljs.core.get.call(null,map__24260__$1,new cljs.core.Keyword(null,"clean","clean",41534079));
var opts__$1 = cljs.core.get.call(null,map__24260__$1,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY);
return om_inputs.core.make_input_comp.call(null,name__$1,schema__$2,action__$1,clean__$1,opts__$1);
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24562 = output_checker24230_24548.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24562)){
var error__20884__auto___24563 = temp__4425__auto___24562;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20884__auto___24563)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24227_24542,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24563], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
;

om_inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$3 = ((function (ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (G__24235,G__24236,G__24237){
var validate__20882__auto__ = ufv___24541.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24564 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24235,G__24236,G__24237], null);
var temp__4425__auto___24565 = input_checker24233_24549.call(null,args__20883__auto___24564);
if(cljs.core.truth_(temp__4425__auto___24565)){
var error__20884__auto___24566 = temp__4425__auto___24565;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20884__auto___24566)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24232_24544,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24564,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24566], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var comp_name = G__24235;
var schema__$1 = G__24236;
var action = G__24237;
while(true){
return om_inputs.core.make_input_comp.call(null,comp_name,schema__$1,action,null,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24567 = output_checker24234_24550.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24567)){
var error__20884__auto___24568 = temp__4425__auto___24567;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20884__auto___24568)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24227_24542,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24568], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
;

om_inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$4 = ((function (ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (G__24241,G__24242,G__24243,G__24244){
var validate__20882__auto__ = ufv___24541.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24569 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24241,G__24242,G__24243,G__24244], null);
var temp__4425__auto___24570 = input_checker24239_24551.call(null,args__20883__auto___24569);
if(cljs.core.truth_(temp__4425__auto___24570)){
var error__20884__auto___24571 = temp__4425__auto___24570;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20884__auto___24571)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24238_24545,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24569,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24571], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var comp_name = G__24241;
var schema__$1 = G__24242;
var action = G__24243;
var opts = G__24244;
while(true){
return om_inputs.core.make_input_comp.call(null,comp_name,schema__$1,action,null,opts);
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24572 = output_checker24240_24552.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24572)){
var error__20884__auto___24573 = temp__4425__auto___24572;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20884__auto___24573)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24227_24542,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24573], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
;

om_inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$5 = ((function (ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (G__24248,G__24249,G__24250,G__24251,G__24252){
var validate__20882__auto__ = ufv___24541.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___24574 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__24248,G__24249,G__24250,G__24251,G__24252], null);
var temp__4425__auto___24575 = input_checker24246_24553.call(null,args__20883__auto___24574);
if(cljs.core.truth_(temp__4425__auto___24575)){
var error__20884__auto___24576 = temp__4425__auto___24575;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20884__auto___24576)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema24245_24546,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___24574,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24576], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var comp_name = G__24248;
var schema__$1 = G__24249;
var action = G__24250;
var clean = G__24251;
var opts = G__24252;
while(true){
var order = new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(opts);
var verily_rules = new cljs.core.Keyword(null,"validations","validations",1347149461).cljs$core$IFn$_invoke$arity$1(opts);
var schema_coercer = schema.coerce.coercer.call(null,schema__$1,om_inputs.validation.validation_coercer);
var validation = om_inputs.validation.build_verily_validator.call(null,verily_rules);
var checker = cljs.core.partial.call(null,om_inputs.validation.validate,schema_coercer,om_inputs.validation.transform_schema_errors);
var unit_coercers = om_inputs.validation.build_unit_coercers.call(null,schema__$1);
var unit_validators = om_inputs.validation.unit_schema_validators.call(null,unit_coercers);
var remove_errs_fn = om_inputs.validation.build_error_remover.call(null,verily_rules,om_inputs.validation.inter_fields_rules);
var typing_controls = om_inputs.typing_controls.build_typing_control.call(null,schema__$1);
var initial_bs = om_inputs.core.build_init_state.call(null,schema__$1,new cljs.core.Keyword(null,"init","init",-1875481434).cljs$core$IFn$_invoke$arity$1(opts));
var initial_action_state = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"init","init",-1875481434),new cljs.core.Keyword(null,"clean","clean",41534079),new cljs.core.Keyword(null,"disabled","disabled",-1529784218)], null);
var willReceivePropsFn = new cljs.core.Keyword(null,"IWillReceiveProps","IWillReceiveProps",-1997358067).cljs$core$IFn$_invoke$arity$1(opts);
return ((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (app,owner){
return om_inputs.extern.create_component.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"get-initial-state","get-initial-state",-4494070),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"chan","chan",-2103021695),new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716),new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403),new cljs.core.Keyword(null,"remove-errs-fn","remove-errs-fn",-1642608850),new cljs.core.Keyword(null,"created-chan","created-chan",645924718),new cljs.core.Keyword(null,"unit-coercers","unit-coercers",-1869075474),new cljs.core.Keyword(null,"validation-chan","validation-chan",-1434352752),new cljs.core.Keyword(null,"inputs","inputs",865803858),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"action-chan","action-chan",1941883997),new cljs.core.Keyword(null,"clean-chan","clean-chan",-1416649986),new cljs.core.Keyword(null,"unit-validators","unit-validators",-1302618433)],[cljs.core.async.chan.call(null),om_inputs.validation.fields_dependencies.call(null,verily_rules),initial_action_state,validation,remove_errs_fn,cljs.core.async.chan.call(null),unit_coercers,cljs.core.async.chan.call(null),initial_bs,opts,cljs.core.async.chan.call(null),cljs.core.async.chan.call(null),unit_validators]);
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
,new cljs.core.Keyword(null,"component-will-mount","component-will-mount",209708855),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (this$){
var map__24262 = om_inputs.extern.get_state.call(null,owner);
var map__24262__$1 = ((((!((map__24262 == null)))?((((map__24262.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24262.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24262):map__24262);
var chan = cljs.core.get.call(null,map__24262__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var action_chan = cljs.core.get.call(null,map__24262__$1,new cljs.core.Keyword(null,"action-chan","action-chan",1941883997));
var validation_chan = cljs.core.get.call(null,map__24262__$1,new cljs.core.Keyword(null,"validation-chan","validation-chan",-1434352752));
var created_chan = cljs.core.get.call(null,map__24262__$1,new cljs.core.Keyword(null,"created-chan","created-chan",645924718));
var clean_chan = cljs.core.get.call(null,map__24262__$1,new cljs.core.Keyword(null,"clean-chan","clean-chan",-1416649986));
var c__23211__auto___24577 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23211__auto___24577,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (){
var f__23212__auto__ = (function (){var switch__23196__auto__ = ((function (c__23211__auto___24577,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (state_24397){
var state_val_24398 = (state_24397[(1)]);
if((state_val_24398 === (7))){
var state_24397__$1 = state_24397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24397__$1,(9),action_chan);
} else {
if((state_val_24398 === (20))){
var inst_24310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24311 = [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_24312 = (new cljs.core.PersistentVector(null,2,(5),inst_24310,inst_24311,null));
var inst_24313 = om_inputs.extern.update_state_BANG_.call(null,owner,inst_24312,om_inputs.core.error_flow);
var state_24397__$1 = (function (){var statearr_24399 = state_24397;
(statearr_24399[(7)] = inst_24313);

return statearr_24399;
})();
var statearr_24400_24578 = state_24397__$1;
(statearr_24400_24578[(2)] = null);

(statearr_24400_24578[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (27))){
var inst_24335 = (state_24397[(2)]);
var inst_24336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24337 = [new cljs.core.Keyword(null,"ko","ko",-626263540),inst_24335];
var inst_24338 = (new cljs.core.PersistentVector(null,2,(5),inst_24336,inst_24337,null));
var inst_24339 = cljs.core.async.put_BANG_.call(null,created_chan,inst_24338);
var state_24397__$1 = state_24397;
var statearr_24401_24579 = state_24397__$1;
(statearr_24401_24579[(2)] = inst_24339);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24397__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (1))){
var state_24397__$1 = state_24397;
var statearr_24402_24580 = state_24397__$1;
(statearr_24402_24580[(2)] = null);

(statearr_24402_24580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (24))){
var state_24397__$1 = state_24397;
var statearr_24403_24581 = state_24397__$1;
(statearr_24403_24581[(2)] = null);

(statearr_24403_24581[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (4))){
var state_24397__$1 = state_24397;
var statearr_24404_24582 = state_24397__$1;
(statearr_24404_24582[(2)] = null);

(statearr_24404_24582[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (15))){
var inst_24291 = (state_24397[(2)]);
var state_24397__$1 = state_24397;
var statearr_24405_24583 = state_24397__$1;
(statearr_24405_24583[(2)] = inst_24291);

(statearr_24405_24583[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (21))){
var inst_24316 = (state_24397[(2)]);
var state_24397__$1 = state_24397;
var statearr_24406_24584 = state_24397__$1;
(statearr_24406_24584[(2)] = inst_24316);

(statearr_24406_24584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (31))){
var inst_24363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24364 = [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"one-shot","one-shot",-2139661191)];
var inst_24365 = (new cljs.core.PersistentVector(null,2,(5),inst_24363,inst_24364,null));
var inst_24366 = cljs.core.get_in.call(null,opts,inst_24365);
var state_24397__$1 = state_24397;
if(cljs.core.truth_(inst_24366)){
var statearr_24407_24585 = state_24397__$1;
(statearr_24407_24585[(1)] = (33));

} else {
var statearr_24408_24586 = state_24397__$1;
(statearr_24408_24586[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (32))){
var inst_24383 = (state_24397[(2)]);
var state_24397__$1 = (function (){var statearr_24409 = state_24397;
(statearr_24409[(8)] = inst_24383);

return statearr_24409;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24397__$1,(36),clean_chan);
} else {
if((state_val_24398 === (33))){
var inst_24356 = (state_24397[(9)]);
var inst_24355 = (state_24397[(10)]);
var inst_24354 = (state_24397[(11)]);
var inst_24368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24369 = [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_24370 = (new cljs.core.PersistentVector(null,2,(5),inst_24368,inst_24369,null));
var inst_24371 = om_inputs.extern.update_state_nr_BANG_.call(null,owner,inst_24370,om_inputs.core.action_states);
var inst_24372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24373 = [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"clean","clean",41534079)];
var inst_24374 = (new cljs.core.PersistentVector(null,2,(5),inst_24372,inst_24373,null));
var inst_24375 = om_inputs.extern.update_state_nr_BANG_.call(null,owner,inst_24374,om_inputs.core.action_states);
var inst_24376 = (function (){var vec__24352 = inst_24354;
var v = inst_24355;
var m = inst_24356;
return ((function (vec__24352,v,m,inst_24356,inst_24355,inst_24354,inst_24368,inst_24369,inst_24370,inst_24371,inst_24372,inst_24373,inst_24374,inst_24375,state_val_24398,c__23211__auto___24577,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (p1__24224_SHARP_){
return om_inputs.core.disable_all.call(null,p1__24224_SHARP_);
});
;})(vec__24352,v,m,inst_24356,inst_24355,inst_24354,inst_24368,inst_24369,inst_24370,inst_24371,inst_24372,inst_24373,inst_24374,inst_24375,state_val_24398,c__23211__auto___24577,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
})();
var inst_24377 = om_inputs.extern.update_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_24376);
var state_24397__$1 = (function (){var statearr_24410 = state_24397;
(statearr_24410[(12)] = inst_24375);

(statearr_24410[(13)] = inst_24371);

return statearr_24410;
})();
var statearr_24411_24587 = state_24397__$1;
(statearr_24411_24587[(2)] = inst_24377);

(statearr_24411_24587[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (13))){
var state_24397__$1 = state_24397;
var statearr_24412_24588 = state_24397__$1;
(statearr_24412_24588[(2)] = true);

(statearr_24412_24588[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (22))){
var inst_24320 = (state_24397[(2)]);
var inst_24321 = om_inputs.extern.get_state.call(null,owner,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var inst_24322 = om_inputs.validation.pre_validation.call(null,inst_24321);
var inst_24323 = schema_coercer.call(null,inst_24322);
var inst_24324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24325 = [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_24326 = (new cljs.core.PersistentVector(null,2,(5),inst_24324,inst_24325,null));
var inst_24327 = om_inputs.extern.update_state_BANG_.call(null,owner,inst_24326,om_inputs.core.action_states);
var inst_24328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24329 = [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"async","async",1050769601)];
var inst_24330 = (new cljs.core.PersistentVector(null,2,(5),inst_24328,inst_24329,null));
var inst_24331 = cljs.core.get_in.call(null,opts,inst_24330);
var state_24397__$1 = (function (){var statearr_24413 = state_24397;
(statearr_24413[(14)] = inst_24320);

(statearr_24413[(15)] = inst_24327);

(statearr_24413[(16)] = inst_24323);

return statearr_24413;
})();
if(cljs.core.truth_(inst_24331)){
var statearr_24414_24589 = state_24397__$1;
(statearr_24414_24589[(1)] = (23));

} else {
var statearr_24415_24590 = state_24397__$1;
(statearr_24415_24590[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (36))){
var inst_24385 = (state_24397[(2)]);
var inst_24386 = clean.call(null,app,owner);
var inst_24387 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24388 = [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_24389 = (new cljs.core.PersistentVector(null,2,(5),inst_24387,inst_24388,null));
var inst_24390 = om_inputs.extern.update_state_nr_BANG_.call(null,owner,inst_24389,om_inputs.core.action_states);
var inst_24391 = (function (){return ((function (inst_24385,inst_24386,inst_24387,inst_24388,inst_24389,inst_24390,state_val_24398,c__23211__auto___24577,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (p1__24225_SHARP_){
return om_inputs.core.enable_all.call(null,p1__24225_SHARP_);
});
;})(inst_24385,inst_24386,inst_24387,inst_24388,inst_24389,inst_24390,state_val_24398,c__23211__auto___24577,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
})();
var inst_24392 = om_inputs.extern.update_state_nr_BANG_.call(null,owner,new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_24391);
var state_24397__$1 = (function (){var statearr_24416 = state_24397;
(statearr_24416[(17)] = inst_24392);

(statearr_24416[(18)] = inst_24385);

(statearr_24416[(19)] = inst_24386);

(statearr_24416[(20)] = inst_24390);

return statearr_24416;
})();
var statearr_24417_24591 = state_24397__$1;
(statearr_24417_24591[(2)] = null);

(statearr_24417_24591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (29))){
var inst_24355 = (state_24397[(10)]);
var inst_24354 = (state_24397[(11)]);
var inst_24354__$1 = (state_24397[(2)]);
var inst_24355__$1 = cljs.core.nth.call(null,inst_24354__$1,(0),null);
var inst_24356 = cljs.core.nth.call(null,inst_24354__$1,(1),null);
var inst_24357 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ko","ko",-626263540),inst_24355__$1);
var state_24397__$1 = (function (){var statearr_24418 = state_24397;
(statearr_24418[(9)] = inst_24356);

(statearr_24418[(10)] = inst_24355__$1);

(statearr_24418[(11)] = inst_24354__$1);

return statearr_24418;
})();
if(inst_24357){
var statearr_24419_24592 = state_24397__$1;
(statearr_24419_24592[(1)] = (30));

} else {
var statearr_24420_24593 = state_24397__$1;
(statearr_24420_24593[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (6))){
var inst_24273 = (state_24397[(2)]);
var inst_24274 = om_inputs.extern.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"action-state","action-state",-1575944631),initial_action_state);
var state_24397__$1 = (function (){var statearr_24421 = state_24397;
(statearr_24421[(21)] = inst_24274);

(statearr_24421[(22)] = inst_24273);

return statearr_24421;
})();
var statearr_24422_24594 = state_24397__$1;
(statearr_24422_24594[(2)] = null);

(statearr_24422_24594[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (28))){
var inst_24323 = (state_24397[(16)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_24397,(27),Object,null,(26));
var inst_24343 = action.call(null,app,owner,inst_24323);
var inst_24344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24345 = [new cljs.core.Keyword(null,"ok","ok",967785236)];
var inst_24346 = (new cljs.core.PersistentVector(null,1,(5),inst_24344,inst_24345,null));
var inst_24347 = cljs.core.async.put_BANG_.call(null,created_chan,inst_24346);
var state_24397__$1 = (function (){var statearr_24423 = state_24397;
(statearr_24423[(23)] = inst_24343);

return statearr_24423;
})();
var statearr_24424_24595 = state_24397__$1;
(statearr_24424_24595[(2)] = inst_24347);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24397__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (25))){
var inst_24351 = (state_24397[(2)]);
var state_24397__$1 = (function (){var statearr_24425 = state_24397;
(statearr_24425[(24)] = inst_24351);

return statearr_24425;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24397__$1,(29),created_chan);
} else {
if((state_val_24398 === (34))){
var state_24397__$1 = state_24397;
var statearr_24426_24596 = state_24397__$1;
(statearr_24426_24596[(2)] = null);

(statearr_24426_24596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (17))){
var inst_24279 = (state_24397[(25)]);
var state_24397__$1 = state_24397;
var statearr_24427_24597 = state_24397__$1;
(statearr_24427_24597[(2)] = inst_24279);

(statearr_24427_24597[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (3))){
var inst_24395 = (state_24397[(2)]);
var state_24397__$1 = state_24397;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24397__$1,inst_24395);
} else {
if((state_val_24398 === (12))){
var inst_24294 = (state_24397[(2)]);
var state_24397__$1 = state_24397;
if(cljs.core.truth_(inst_24294)){
var statearr_24428_24598 = state_24397__$1;
(statearr_24428_24598[(1)] = (16));

} else {
var statearr_24429_24599 = state_24397__$1;
(statearr_24429_24599[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (2))){
var inst_24265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24266 = [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"no-reset","no-reset",-1147706932)];
var inst_24267 = (new cljs.core.PersistentVector(null,2,(5),inst_24265,inst_24266,null));
var inst_24268 = cljs.core.get_in.call(null,opts,inst_24267);
var state_24397__$1 = state_24397;
if(cljs.core.truth_(inst_24268)){
var statearr_24430_24600 = state_24397__$1;
(statearr_24430_24600[(1)] = (4));

} else {
var statearr_24431_24601 = state_24397__$1;
(statearr_24431_24601[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (23))){
var inst_24323 = (state_24397[(16)]);
var inst_24333 = action.call(null,app,owner,inst_24323,created_chan);
var state_24397__$1 = state_24397;
var statearr_24432_24602 = state_24397__$1;
(statearr_24432_24602[(2)] = inst_24333);

(statearr_24432_24602[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (35))){
var inst_24381 = (state_24397[(2)]);
var state_24397__$1 = state_24397;
var statearr_24433_24603 = state_24397__$1;
(statearr_24433_24603[(2)] = inst_24381);

(statearr_24433_24603[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (19))){
var inst_24308 = cljs.core.async.put_BANG_.call(null,validation_chan,new cljs.core.Keyword(null,"validee","validee",373082584));
var state_24397__$1 = state_24397;
var statearr_24434_24604 = state_24397__$1;
(statearr_24434_24604[(2)] = inst_24308);

(statearr_24434_24604[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (11))){
var state_24397__$1 = state_24397;
var statearr_24435_24605 = state_24397__$1;
(statearr_24435_24605[(2)] = false);

(statearr_24435_24605[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (9))){
var inst_24279 = (state_24397[(25)]);
var inst_24277 = (state_24397[(2)]);
var inst_24279__$1 = om_inputs.extern.get_state.call(null,owner);
var inst_24281 = (inst_24279__$1 == null);
var inst_24282 = cljs.core.not.call(null,inst_24281);
var state_24397__$1 = (function (){var statearr_24436 = state_24397;
(statearr_24436[(26)] = inst_24277);

(statearr_24436[(25)] = inst_24279__$1);

return statearr_24436;
})();
if(inst_24282){
var statearr_24437_24606 = state_24397__$1;
(statearr_24437_24606[(1)] = (10));

} else {
var statearr_24438_24607 = state_24397__$1;
(statearr_24438_24607[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (5))){
var inst_24271 = om_inputs.extern.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"inputs","inputs",865803858),initial_bs);
var state_24397__$1 = state_24397;
var statearr_24439_24608 = state_24397__$1;
(statearr_24439_24608[(2)] = inst_24271);

(statearr_24439_24608[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (14))){
var state_24397__$1 = state_24397;
var statearr_24440_24609 = state_24397__$1;
(statearr_24440_24609[(2)] = false);

(statearr_24440_24609[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (26))){
var inst_24349 = (state_24397[(2)]);
var state_24397__$1 = state_24397;
var statearr_24441_24610 = state_24397__$1;
(statearr_24441_24610[(2)] = inst_24349);

(statearr_24441_24610[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (16))){
var inst_24279 = (state_24397[(25)]);
var inst_24296 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24279);
var state_24397__$1 = state_24397;
var statearr_24442_24611 = state_24397__$1;
(statearr_24442_24611[(2)] = inst_24296);

(statearr_24442_24611[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (30))){
var inst_24356 = (state_24397[(9)]);
var inst_24359 = [cljs.core.str("An error has occured during action : "),cljs.core.str(inst_24356)].join('');
var inst_24360 = cljs.core.prn.call(null,inst_24359);
var state_24397__$1 = (function (){var statearr_24443 = state_24397;
(statearr_24443[(27)] = inst_24360);

return statearr_24443;
})();
var statearr_24444_24612 = state_24397__$1;
(statearr_24444_24612[(2)] = null);

(statearr_24444_24612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (10))){
var inst_24279 = (state_24397[(25)]);
var inst_24284 = inst_24279.cljs$lang$protocol_mask$partition0$;
var inst_24285 = (inst_24284 & (64));
var inst_24286 = inst_24279.cljs$core$ISeq$;
var inst_24287 = (inst_24285) || (inst_24286);
var state_24397__$1 = state_24397;
if(cljs.core.truth_(inst_24287)){
var statearr_24445_24613 = state_24397__$1;
(statearr_24445_24613[(1)] = (13));

} else {
var statearr_24446_24614 = state_24397__$1;
(statearr_24446_24614[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (18))){
var inst_24299 = (state_24397[(2)]);
var inst_24300 = cljs.core.get.call(null,inst_24299,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var inst_24301 = om_inputs.validation.full_validation.call(null,inst_24300,inst_24299);
var inst_24302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24303 = [new cljs.core.Keyword(null,"inputs","inputs",865803858)];
var inst_24304 = (new cljs.core.PersistentVector(null,1,(5),inst_24302,inst_24303,null));
var inst_24305 = om_inputs.extern.set_state_BANG_.call(null,owner,inst_24304,inst_24301);
var inst_24306 = om_inputs.validation.no_error_QMARK_.call(null,inst_24301);
var state_24397__$1 = (function (){var statearr_24447 = state_24397;
(statearr_24447[(28)] = inst_24305);

return statearr_24447;
})();
if(cljs.core.truth_(inst_24306)){
var statearr_24448_24615 = state_24397__$1;
(statearr_24448_24615[(1)] = (19));

} else {
var statearr_24449_24616 = state_24397__$1;
(statearr_24449_24616[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24398 === (8))){
var inst_24318 = (state_24397[(2)]);
var state_24397__$1 = (function (){var statearr_24450 = state_24397;
(statearr_24450[(29)] = inst_24318);

return statearr_24450;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24397__$1,(22),validation_chan);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23211__auto___24577,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
;
return ((function (switch__23196__auto__,c__23211__auto___24577,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function() {
var om_inputs$core$state_machine__23197__auto__ = null;
var om_inputs$core$state_machine__23197__auto____0 = (function (){
var statearr_24454 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24454[(0)] = om_inputs$core$state_machine__23197__auto__);

(statearr_24454[(1)] = (1));

return statearr_24454;
});
var om_inputs$core$state_machine__23197__auto____1 = (function (state_24397){
while(true){
var ret_value__23198__auto__ = (function (){try{while(true){
var result__23199__auto__ = switch__23196__auto__.call(null,state_24397);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23199__auto__;
}
break;
}
}catch (e24455){if((e24455 instanceof Object)){
var ex__23200__auto__ = e24455;
var statearr_24456_24617 = state_24397;
(statearr_24456_24617[(5)] = ex__23200__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24397);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24455;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24618 = state_24397;
state_24397 = G__24618;
continue;
} else {
return ret_value__23198__auto__;
}
break;
}
});
om_inputs$core$state_machine__23197__auto__ = function(state_24397){
switch(arguments.length){
case 0:
return om_inputs$core$state_machine__23197__auto____0.call(this);
case 1:
return om_inputs$core$state_machine__23197__auto____1.call(this,state_24397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
om_inputs$core$state_machine__23197__auto__.cljs$core$IFn$_invoke$arity$0 = om_inputs$core$state_machine__23197__auto____0;
om_inputs$core$state_machine__23197__auto__.cljs$core$IFn$_invoke$arity$1 = om_inputs$core$state_machine__23197__auto____1;
return om_inputs$core$state_machine__23197__auto__;
})()
;})(switch__23196__auto__,c__23211__auto___24577,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
})();
var state__23213__auto__ = (function (){var statearr_24457 = f__23212__auto__.call(null);
(statearr_24457[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23211__auto___24577);

return statearr_24457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23213__auto__);
});})(c__23211__auto___24577,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
);


var c__23211__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23211__auto__,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (){
var f__23212__auto__ = (function (){var switch__23196__auto__ = ((function (c__23211__auto__,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (state_24512){
var state_val_24513 = (state_24512[(1)]);
if((state_val_24513 === (7))){
var inst_24507 = (state_24512[(2)]);
var state_24512__$1 = (function (){var statearr_24514 = state_24512;
(statearr_24514[(7)] = inst_24507);

return statearr_24514;
})();
var statearr_24515_24619 = state_24512__$1;
(statearr_24515_24619[(2)] = null);

(statearr_24515_24619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24513 === (1))){
var state_24512__$1 = state_24512;
var statearr_24516_24620 = state_24512__$1;
(statearr_24516_24620[(2)] = null);

(statearr_24516_24620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24513 === (4))){
var inst_24462 = (state_24512[(8)]);
var inst_24461 = (state_24512[(9)]);
var inst_24461__$1 = (state_24512[(2)]);
var inst_24462__$1 = cljs.core.nth.call(null,inst_24461__$1,(0),null);
var inst_24463 = cljs.core.nth.call(null,inst_24461__$1,(1),null);
var inst_24467 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"focus","focus",234677911),inst_24462__$1);
var state_24512__$1 = (function (){var statearr_24517 = state_24512;
(statearr_24517[(8)] = inst_24462__$1);

(statearr_24517[(10)] = inst_24463);

(statearr_24517[(9)] = inst_24461__$1);

return statearr_24517;
})();
if(inst_24467){
var statearr_24518_24621 = state_24512__$1;
(statearr_24518_24621[(1)] = (5));

} else {
var statearr_24519_24622 = state_24512__$1;
(statearr_24519_24622[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24513 === (13))){
var inst_24503 = (state_24512[(2)]);
var state_24512__$1 = state_24512;
var statearr_24520_24623 = state_24512__$1;
(statearr_24520_24623[(2)] = inst_24503);

(statearr_24520_24623[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24513 === (6))){
var inst_24462 = (state_24512[(8)]);
var inst_24474 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"kill-mess","kill-mess",723475912),inst_24462);
var state_24512__$1 = state_24512;
if(inst_24474){
var statearr_24521_24624 = state_24512__$1;
(statearr_24521_24624[(1)] = (8));

} else {
var statearr_24522_24625 = state_24512__$1;
(statearr_24522_24625[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24513 === (3))){
var inst_24510 = (state_24512[(2)]);
var state_24512__$1 = state_24512;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24512__$1,inst_24510);
} else {
if((state_val_24513 === (12))){
var inst_24462 = (state_24512[(8)]);
var inst_24463 = (state_24512[(10)]);
var inst_24461 = (state_24512[(9)]);
var inst_24486 = (function (){var vec__24459 = inst_24461;
var k = inst_24462;
var v = inst_24463;
var pred__24464 = cljs.core._EQ_;
var expr__24465 = inst_24462;
return ((function (vec__24459,k,v,pred__24464,expr__24465,inst_24462,inst_24463,inst_24461,state_val_24513,c__23211__auto__,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (n,_){
return n;
});
;})(vec__24459,k,v,pred__24464,expr__24465,inst_24462,inst_24463,inst_24461,state_val_24513,c__23211__auto__,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
})();
var inst_24487 = cljs.core.get.call(null,typing_controls,inst_24462,inst_24486);
var inst_24488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24489 = [inst_24462,new cljs.core.Keyword(null,"post-typing","post-typing",129196416)];
var inst_24490 = (new cljs.core.PersistentVector(null,2,(5),inst_24488,inst_24489,null));
var inst_24491 = cljs.core.get_in.call(null,opts,inst_24490,cljs.core.identity);
var inst_24492 = inst_24491.call(null,inst_24463);
var inst_24493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24494 = [new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_24462,new cljs.core.Keyword(null,"value","value",305978217)];
var inst_24495 = (new cljs.core.PersistentVector(null,3,(5),inst_24493,inst_24494,null));
var inst_24496 = om_inputs.extern.get_state.call(null,owner,inst_24495);
var inst_24497 = inst_24487.call(null,inst_24492,inst_24496);
var inst_24498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24499 = [new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_24462,new cljs.core.Keyword(null,"value","value",305978217)];
var inst_24500 = (new cljs.core.PersistentVector(null,3,(5),inst_24498,inst_24499,null));
var inst_24501 = om_inputs.extern.set_state_BANG_.call(null,owner,inst_24500,inst_24497);
var state_24512__$1 = state_24512;
var statearr_24523_24626 = state_24512__$1;
(statearr_24523_24626[(2)] = inst_24501);

(statearr_24523_24626[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24513 === (2))){
var state_24512__$1 = state_24512;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24512__$1,(4),chan);
} else {
if((state_val_24513 === (11))){
var inst_24463 = (state_24512[(10)]);
var inst_24484 = om_inputs.validation.field_validation_BANG_.call(null,owner,inst_24463);
var state_24512__$1 = state_24512;
var statearr_24524_24627 = state_24512__$1;
(statearr_24524_24627[(2)] = inst_24484);

(statearr_24524_24627[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24513 === (9))){
var inst_24462 = (state_24512[(8)]);
var inst_24482 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"validate","validate",-201300827),inst_24462);
var state_24512__$1 = state_24512;
if(inst_24482){
var statearr_24525_24628 = state_24512__$1;
(statearr_24525_24628[(1)] = (11));

} else {
var statearr_24526_24629 = state_24512__$1;
(statearr_24526_24629[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24513 === (5))){
var inst_24463 = (state_24512[(10)]);
var inst_24469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24470 = [new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_24463,new cljs.core.Keyword(null,"focus","focus",234677911)];
var inst_24471 = (new cljs.core.PersistentVector(null,3,(5),inst_24469,inst_24470,null));
var inst_24472 = om_inputs.extern.update_state_BANG_.call(null,owner,inst_24471,cljs.core.not);
var state_24512__$1 = state_24512;
var statearr_24527_24630 = state_24512__$1;
(statearr_24527_24630[(2)] = inst_24472);

(statearr_24527_24630[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24513 === (10))){
var inst_24505 = (state_24512[(2)]);
var state_24512__$1 = state_24512;
var statearr_24528_24631 = state_24512__$1;
(statearr_24528_24631[(2)] = inst_24505);

(statearr_24528_24631[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24513 === (8))){
var inst_24462 = (state_24512[(8)]);
var inst_24463 = (state_24512[(10)]);
var inst_24461 = (state_24512[(9)]);
var inst_24476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24477 = [new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_24463];
var inst_24478 = (new cljs.core.PersistentVector(null,2,(5),inst_24476,inst_24477,null));
var inst_24479 = (function (){var vec__24459 = inst_24461;
var k = inst_24462;
var v = inst_24463;
var pred__24464 = cljs.core._EQ_;
var expr__24465 = inst_24462;
return ((function (vec__24459,k,v,pred__24464,expr__24465,inst_24462,inst_24463,inst_24461,inst_24476,inst_24477,inst_24478,state_val_24513,c__23211__auto__,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (p1__24226_SHARP_){
return cljs.core.dissoc.call(null,p1__24226_SHARP_,new cljs.core.Keyword(null,"error","error",-978969032));
});
;})(vec__24459,k,v,pred__24464,expr__24465,inst_24462,inst_24463,inst_24461,inst_24476,inst_24477,inst_24478,state_val_24513,c__23211__auto__,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
})();
var inst_24480 = om_inputs.extern.update_state_BANG_.call(null,owner,inst_24478,inst_24479);
var state_24512__$1 = state_24512;
var statearr_24529_24632 = state_24512__$1;
(statearr_24529_24632[(2)] = inst_24480);

(statearr_24529_24632[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23211__auto__,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
;
return ((function (switch__23196__auto__,c__23211__auto__,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function() {
var om_inputs$core$state_machine__23197__auto__ = null;
var om_inputs$core$state_machine__23197__auto____0 = (function (){
var statearr_24533 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24533[(0)] = om_inputs$core$state_machine__23197__auto__);

(statearr_24533[(1)] = (1));

return statearr_24533;
});
var om_inputs$core$state_machine__23197__auto____1 = (function (state_24512){
while(true){
var ret_value__23198__auto__ = (function (){try{while(true){
var result__23199__auto__ = switch__23196__auto__.call(null,state_24512);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23199__auto__;
}
break;
}
}catch (e24534){if((e24534 instanceof Object)){
var ex__23200__auto__ = e24534;
var statearr_24535_24633 = state_24512;
(statearr_24535_24633[(5)] = ex__23200__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24512);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24534;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24634 = state_24512;
state_24512 = G__24634;
continue;
} else {
return ret_value__23198__auto__;
}
break;
}
});
om_inputs$core$state_machine__23197__auto__ = function(state_24512){
switch(arguments.length){
case 0:
return om_inputs$core$state_machine__23197__auto____0.call(this);
case 1:
return om_inputs$core$state_machine__23197__auto____1.call(this,state_24512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
om_inputs$core$state_machine__23197__auto__.cljs$core$IFn$_invoke$arity$0 = om_inputs$core$state_machine__23197__auto____0;
om_inputs$core$state_machine__23197__auto__.cljs$core$IFn$_invoke$arity$1 = om_inputs$core$state_machine__23197__auto____1;
return om_inputs$core$state_machine__23197__auto__;
})()
;})(switch__23196__auto__,c__23211__auto__,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
})();
var state__23213__auto__ = (function (){var statearr_24536 = f__23212__auto__.call(null);
(statearr_24536[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23211__auto__);

return statearr_24536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23213__auto__);
});})(c__23211__auto__,map__24262,map__24262__$1,chan,action_chan,validation_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
);

return c__23211__auto__;
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
,new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (_){
return om_inputs.core.handle_date_fields_BANG_.call(null,owner,om_inputs.date_utils.default_fmt,opts);
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
,new cljs.core.Keyword(null,"component-will-unmount","component-will-unmount",-2058314698),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (_){
return cljs.core.prn.call(null,[cljs.core.str("WARNING : "),cljs.core.str(om_inputs.utils.full_name.call(null,comp_name)),cljs.core.str(" will unmount !")].join(''));
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
,new cljs.core.Keyword(null,"component-will-receive-props","component-will-receive-props",551608157),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (this$,next_props){
if(cljs.core.truth_(willReceivePropsFn)){
return willReceivePropsFn.call(null,owner,next_props);
} else {
return null;
}
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
,new cljs.core.Keyword(null,"component-will-update","component-will-update",335247566),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (this$,next_props,next_state){
return null;
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
,new cljs.core.Keyword(null,"render","render",-1408033454),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (this$){
var map__24537 = om_inputs.extern.get_state.call(null,this$);
var map__24537__$1 = ((((!((map__24537 == null)))?((((map__24537.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24537.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24537):map__24537);
var state = map__24537__$1;
var chan = cljs.core.get.call(null,map__24537__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var inputs = cljs.core.get.call(null,map__24537__$1,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var action_state = cljs.core.get.call(null,map__24537__$1,new cljs.core.Keyword(null,"action-state","action-state",-1575944631));
var dyn_opts = cljs.core.get.call(null,map__24537__$1,new cljs.core.Keyword(null,"dyn-opts","dyn-opts",-1763725899));
var labels = om_inputs.i18n.comp_i18n.call(null,owner,comp_name,schema__$1,opts);
var title = cljs.core.get_in.call(null,labels,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"title","title",636505583)], null));
var opts__$1 = cljs.core.merge_with.call(null,cljs.core.merge,opts,dyn_opts);
var comp_class = cljs.core.get_in.call(null,opts__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp_name,new cljs.core.Keyword(null,"className","className",-1983287057)], null));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"className","className",-1983287057),om_inputs.core.styles.call(null,"panel panel-default",comp_class),new cljs.core.Keyword(null,"key","key",-1516042587),om_inputs.utils.full_name.call(null,comp_name),new cljs.core.Keyword(null,"ref","ref",1289896967),om_inputs.utils.full_name.call(null,comp_name),new cljs.core.Keyword(null,"id","id",-1388402092),om_inputs.utils.full_name.call(null,comp_name)], null),(cljs.core.truth_(title)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"panel-heading"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"panel-title"], null),title], null)], null):null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"className","className",-1983287057),"panel-body",new cljs.core.Keyword(null,"role","role",-736691072),"form"], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"inputs-group"], null)], null),(cljs.core.truth_(order)?cljs.core.map.call(null,((function (labels,title,opts__$1,comp_class,map__24537,map__24537__$1,state,chan,inputs,action_state,dyn_opts,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (k){
return om_inputs.core.build_input.call(null,owner,cljs.core.assoc.call(null,k.call(null,opts__$1),new cljs.core.Keyword(null,"k","k",-2146297393),k,new cljs.core.Keyword(null,"k-sch","k-sch",-193796815),om_inputs.schema_utils.get_sch.call(null,schema__$1,k),new cljs.core.Keyword(null,"i18n","i18n",-563422499),k.call(null,labels)));
});})(labels,title,opts__$1,comp_class,map__24537,map__24537__$1,state,chan,inputs,action_state,dyn_opts,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
,order):cljs.core.map.call(null,((function (labels,title,opts__$1,comp_class,map__24537,map__24537__$1,state,chan,inputs,action_state,dyn_opts,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554){
return (function (p__24539){
var vec__24540 = p__24539;
var k = cljs.core.nth.call(null,vec__24540,(0),null);
var t = cljs.core.nth.call(null,vec__24540,(1),null);
var k__$1 = (((k instanceof cljs.core.Keyword))?k:new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(k));
return om_inputs.core.build_input.call(null,owner,cljs.core.assoc.call(null,k__$1.call(null,opts__$1),new cljs.core.Keyword(null,"k","k",-2146297393),k__$1,new cljs.core.Keyword(null,"k-sch","k-sch",-193796815),t,new cljs.core.Keyword(null,"i18n","i18n",-563422499),k__$1.call(null,labels)));
});})(labels,title,opts__$1,comp_class,map__24537,map__24537__$1,state,chan,inputs,action_state,dyn_opts,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
,schema__$1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"panel-button"], null),om_inputs.extern.build_component.call(null,om_inputs.core.button_view,app,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),state,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"labels","labels",-626734591),new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(labels),new cljs.core.Keyword(null,"comp-name","comp-name",-474371587),comp_name,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.get_in.call(null,opts__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"attrs","attrs",-2090668713)], null))], null)], null)),om_inputs.extern.build_component.call(null,om_inputs.core.button_view,app,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),state,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"clean","clean",41534079),new cljs.core.Keyword(null,"labels","labels",-626734591),new cljs.core.Keyword(null,"clean","clean",41534079).cljs$core$IFn$_invoke$arity$1(labels),new cljs.core.Keyword(null,"comp-name","comp-name",-474371587),comp_name,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.get_in.call(null,opts__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"clean","clean",41534079),new cljs.core.Keyword(null,"attrs","attrs",-2090668713)], null))], null)], null))], null)], null)], null);
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
], null));
});
;})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,willReceivePropsFn,validate__20882__auto__,ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___24635 = output_checker24247_24554.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___24635)){
var error__20884__auto___24636 = temp__4425__auto___24635;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20884__auto___24636)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema24227_24542,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___24636], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___24541,output_schema24227_24542,input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546,input_checker24229_24547,output_checker24230_24548,input_checker24233_24549,output_checker24234_24550,input_checker24239_24551,output_checker24240_24552,input_checker24246_24553,output_checker24247_24554))
;

om_inputs.core.make_input_comp.cljs$lang$maxFixedArity = 5;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.core.make_input_comp),schema.core.make_fn_schema.call(null,output_schema24227_24542,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema24228_24543,input_schema24232_24544,input_schema24238_24545,input_schema24245_24546], null)));

//# sourceMappingURL=core.js.map