// Compiled by ClojureScript 1.7.48 {}
goog.provide('om_inputs.date_utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.i18n.DateTimeFormat');
goog.require('goog.i18n.DateTimeParse');
goog.require('goog.ui.InputDatePicker');
goog.require('goog.date.Date');
goog.require('goog.date.Interval');
om_inputs.date_utils.default_fmt = "dd/MM/yyyy";
om_inputs.date_utils.format_map = (function (){var f = goog.i18n.DateTimeFormat.Format;
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"SHORT_DATETIME","SHORT_DATETIME",1598374504),new cljs.core.Keyword(null,"SHORT_TIME","SHORT_TIME",310908809),new cljs.core.Keyword(null,"FULL_DATETIME","FULL_DATETIME",-994229334),new cljs.core.Keyword(null,"FULL_TIME","FULL_TIME",2079466571),new cljs.core.Keyword(null,"MEDIUM_TIME","MEDIUM_TIME",886226349),new cljs.core.Keyword(null,"MEDIUM_DATETIME","MEDIUM_DATETIME",1699528622),new cljs.core.Keyword(null,"FULL_DATE","FULL_DATE",-155294353),new cljs.core.Keyword(null,"LONG_DATETIME","LONG_DATETIME",-1477050189),new cljs.core.Keyword(null,"LONG_TIME","LONG_TIME",1656541459),new cljs.core.Keyword(null,"MEDIUM_DATE","MEDIUM_DATE",-2761993),new cljs.core.Keyword(null,"LONG_DATE","LONG_DATE",-30104067),new cljs.core.Keyword(null,"SHORT_DATE","SHORT_DATE",1620789053)],[f.SHORT_DATETIME,f.SHORT_TIME,f.FULL_DATETIME,f.FULL_TIME,f.MEDIUM_TIME,f.MEDIUM_DATETIME,f.FULL_DATE,f.LONG_DATETIME,f.LONG_TIME,f.MEDIUM_DATE,f.LONG_DATE,f.SHORT_DATE]);
})();
/**
 * Format a date using either the built-in goog.i18n.DateTimeFormat.Format enum
 * or a formatting string like "dd MMMM yyyy"
 */
om_inputs.date_utils.fmt = (function om_inputs$date_utils$fmt(){
var args20697 = [];
var len__19528__auto___20700 = arguments.length;
var i__19529__auto___20701 = (0);
while(true){
if((i__19529__auto___20701 < len__19528__auto___20700)){
args20697.push((arguments[i__19529__auto___20701]));

var G__20702 = (i__19529__auto___20701 + (1));
i__19529__auto___20701 = G__20702;
continue;
} else {
}
break;
}

var G__20699 = args20697.length;
switch (G__20699) {
case 1:
return om_inputs.date_utils.fmt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return om_inputs.date_utils.fmt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20697.length)].join('')));

}
});

om_inputs.date_utils.fmt.cljs$core$IFn$_invoke$arity$1 = (function (date){
return om_inputs.date_utils.fmt.call(null,om_inputs.date_utils.default_fmt,date);
});

om_inputs.date_utils.fmt.cljs$core$IFn$_invoke$arity$2 = (function (date_format,date){
return (new goog.i18n.DateTimeFormat((function (){var or__18489__auto__ = om_inputs.date_utils.format_map.call(null,date_format);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return date_format;
}
})())).format((new Date(date)));
});

om_inputs.date_utils.fmt.cljs$lang$maxFixedArity = 2;
/**
 * Parse a Date according to the format specified
 * Default format is dd/MM/yyyy
 */
om_inputs.date_utils.parse = (function om_inputs$date_utils$parse(){
var args20704 = [];
var len__19528__auto___20707 = arguments.length;
var i__19529__auto___20708 = (0);
while(true){
if((i__19529__auto___20708 < len__19528__auto___20707)){
args20704.push((arguments[i__19529__auto___20708]));

var G__20709 = (i__19529__auto___20708 + (1));
i__19529__auto___20708 = G__20709;
continue;
} else {
}
break;
}

var G__20706 = args20704.length;
switch (G__20706) {
case 2:
return om_inputs.date_utils.parse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return om_inputs.date_utils.parse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20704.length)].join('')));

}
});

om_inputs.date_utils.parse.cljs$core$IFn$_invoke$arity$2 = (function (f,s){
var p = (new goog.i18n.DateTimeParse(f));
var d = (new Date());
p.strictParse(s,d);

return d;
});

om_inputs.date_utils.parse.cljs$core$IFn$_invoke$arity$1 = (function (s){
return om_inputs.date_utils.parse.call(null,om_inputs.date_utils.default_fmt,s);
});

om_inputs.date_utils.parse.cljs$lang$maxFixedArity = 2;
/**
 * Takes care of date rendering in the input.
 */
om_inputs.date_utils.display_date = (function om_inputs$date_utils$display_date(){
var args20711 = [];
var len__19528__auto___20714 = arguments.length;
var i__19529__auto___20715 = (0);
while(true){
if((i__19529__auto___20715 < len__19528__auto___20714)){
args20711.push((arguments[i__19529__auto___20715]));

var G__20716 = (i__19529__auto___20715 + (1));
i__19529__auto___20715 = G__20716;
continue;
} else {
}
break;
}

var G__20713 = args20711.length;
switch (G__20713) {
case 2:
return om_inputs.date_utils.display_date.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return om_inputs.date_utils.display_date.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20711.length)].join('')));

}
});

om_inputs.date_utils.display_date.cljs$core$IFn$_invoke$arity$2 = (function (f,v){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,v))){
return null;
} else {
return om_inputs.date_utils.fmt.call(null,f,v);
}
});

om_inputs.date_utils.display_date.cljs$core$IFn$_invoke$arity$1 = (function (v){
return om_inputs.date_utils.display_date.call(null,om_inputs.date_utils.default_fmt,v);
});

om_inputs.date_utils.display_date.cljs$lang$maxFixedArity = 2;
om_inputs.date_utils.goog_date__GT_js_date = (function om_inputs$date_utils$goog_date__GT_js_date(d){
if(cljs.core.truth_(d)){
return om_inputs.date_utils.parse.call(null,om_inputs.date_utils.fmt.call(null,om_inputs.date_utils.default_fmt,d));
} else {
return null;
}
});

om_inputs.date_utils.SetDate = {};

om_inputs.date_utils.setInputValue = (function om_inputs$date_utils$setInputValue(this$,v){
if((!((this$ == null))) && (!((this$.om_inputs$date_utils$SetDate$setInputValue$arity$2 == null)))){
return this$.om_inputs$date_utils$SetDate$setInputValue$arity$2(this$,v);
} else {
var x__19125__auto__ = (((this$ == null))?null:this$);
var m__19126__auto__ = (om_inputs.date_utils.setInputValue[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,this$,v);
} else {
var m__19126__auto____$1 = (om_inputs.date_utils.setInputValue["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,this$,v);
} else {
throw cljs.core.missing_protocol.call(null,"SetDate.setInputValue",this$);
}
}
}
});

/**
 * Build a google.ui.InputDatePicker with a specific format
 */
om_inputs.date_utils.date_picker = (function om_inputs$date_utils$date_picker(f){
return (new goog.ui.InputDatePicker((new goog.i18n.DateTimeFormat(f)),(new goog.i18n.DateTimeParse(f)),null,null));
});
/**
 * Create a js/Date at plus/minus days
 */
om_inputs.date_utils.at = (function om_inputs$date_utils$at(d){
return om_inputs.date_utils.goog_date__GT_js_date.call(null,(function (){var G__20721 = (new goog.date.Date());
G__20721.add((new goog.date.Interval(goog.date.Interval.DAYS,d)));

return G__20721;
})());
});
om_inputs.date_utils.tomorrow = (function om_inputs$date_utils$tomorrow(){
return om_inputs.date_utils.at.call(null,(1));
});

//# sourceMappingURL=date_utils.js.map