// Compiled by ClojureScript 1.7.48 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t56262 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t56262 = (function (fn_handler,f,meta56263){
this.fn_handler = fn_handler;
this.f = f;
this.meta56263 = meta56263;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t56262.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_56264,meta56263__$1){
var self__ = this;
var _56264__$1 = this;
return (new cljs.core.async.t56262(self__.fn_handler,self__.f,meta56263__$1));
});

cljs.core.async.t56262.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_56264){
var self__ = this;
var _56264__$1 = this;
return self__.meta56263;
});

cljs.core.async.t56262.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t56262.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t56262.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t56262.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta56263","meta56263",-1452487046,null)], null);
});

cljs.core.async.t56262.cljs$lang$type = true;

cljs.core.async.t56262.cljs$lang$ctorStr = "cljs.core.async/t56262";

cljs.core.async.t56262.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t56262");
});

cljs.core.async.__GT_t56262 = (function cljs$core$async$fn_handler_$___GT_t56262(fn_handler__$1,f__$1,meta56263){
return (new cljs.core.async.t56262(fn_handler__$1,f__$1,meta56263));
});

}

return (new cljs.core.async.t56262(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var args56267 = [];
var len__19528__auto___56270 = arguments.length;
var i__19529__auto___56271 = (0);
while(true){
if((i__19529__auto___56271 < len__19528__auto___56270)){
args56267.push((arguments[i__19529__auto___56271]));

var G__56272 = (i__19529__auto___56271 + (1));
i__19529__auto___56271 = G__56272;
continue;
} else {
}
break;
}

var G__56269 = args56267.length;
switch (G__56269) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args56267.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var args56274 = [];
var len__19528__auto___56277 = arguments.length;
var i__19529__auto___56278 = (0);
while(true){
if((i__19529__auto___56278 < len__19528__auto___56277)){
args56274.push((arguments[i__19529__auto___56278]));

var G__56279 = (i__19529__auto___56278 + (1));
i__19529__auto___56278 = G__56279;
continue;
} else {
}
break;
}

var G__56276 = args56274.length;
switch (G__56276) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args56274.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_56281 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_56281);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_56281,ret){
return (function (){
return fn1.call(null,val_56281);
});})(val_56281,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var args56282 = [];
var len__19528__auto___56285 = arguments.length;
var i__19529__auto___56286 = (0);
while(true){
if((i__19529__auto___56286 < len__19528__auto___56285)){
args56282.push((arguments[i__19529__auto___56286]));

var G__56287 = (i__19529__auto___56286 + (1));
i__19529__auto___56286 = G__56287;
continue;
} else {
}
break;
}

var G__56284 = args56282.length;
switch (G__56284) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args56282.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__19373__auto___56289 = n;
var x_56290 = (0);
while(true){
if((x_56290 < n__19373__auto___56289)){
(a[x_56290] = (0));

var G__56291 = (x_56290 + (1));
x_56290 = G__56291;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__56292 = (i + (1));
i = G__56292;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t56296 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t56296 = (function (alt_flag,flag,meta56297){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta56297 = meta56297;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t56296.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_56298,meta56297__$1){
var self__ = this;
var _56298__$1 = this;
return (new cljs.core.async.t56296(self__.alt_flag,self__.flag,meta56297__$1));
});})(flag))
;

cljs.core.async.t56296.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_56298){
var self__ = this;
var _56298__$1 = this;
return self__.meta56297;
});})(flag))
;

cljs.core.async.t56296.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t56296.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t56296.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t56296.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta56297","meta56297",-1711151182,null)], null);
});})(flag))
;

cljs.core.async.t56296.cljs$lang$type = true;

cljs.core.async.t56296.cljs$lang$ctorStr = "cljs.core.async/t56296";

cljs.core.async.t56296.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t56296");
});})(flag))
;

cljs.core.async.__GT_t56296 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t56296(alt_flag__$1,flag__$1,meta56297){
return (new cljs.core.async.t56296(alt_flag__$1,flag__$1,meta56297));
});})(flag))
;

}

return (new cljs.core.async.t56296(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t56302 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t56302 = (function (alt_handler,flag,cb,meta56303){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta56303 = meta56303;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t56302.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_56304,meta56303__$1){
var self__ = this;
var _56304__$1 = this;
return (new cljs.core.async.t56302(self__.alt_handler,self__.flag,self__.cb,meta56303__$1));
});

cljs.core.async.t56302.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_56304){
var self__ = this;
var _56304__$1 = this;
return self__.meta56303;
});

cljs.core.async.t56302.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t56302.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t56302.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t56302.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta56303","meta56303",-1516116753,null)], null);
});

cljs.core.async.t56302.cljs$lang$type = true;

cljs.core.async.t56302.cljs$lang$ctorStr = "cljs.core.async/t56302";

cljs.core.async.t56302.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t56302");
});

cljs.core.async.__GT_t56302 = (function cljs$core$async$alt_handler_$___GT_t56302(alt_handler__$1,flag__$1,cb__$1,meta56303){
return (new cljs.core.async.t56302(alt_handler__$1,flag__$1,cb__$1,meta56303));
});

}

return (new cljs.core.async.t56302(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__56305_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__56305_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__56306_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__56306_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__18489__auto__ = wport;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return port;
}
})()], null));
} else {
var G__56307 = (i + (1));
i = G__56307;
continue;
}
} else {
return null;
}
break;
}
})();
var or__18489__auto__ = ret;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__18477__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__18477__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__18477__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var args__19535__auto__ = [];
var len__19528__auto___56313 = arguments.length;
var i__19529__auto___56314 = (0);
while(true){
if((i__19529__auto___56314 < len__19528__auto___56313)){
args__19535__auto__.push((arguments[i__19529__auto___56314]));

var G__56315 = (i__19529__auto___56314 + (1));
i__19529__auto___56314 = G__56315;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__56310){
var map__56311 = p__56310;
var map__56311__$1 = ((((!((map__56311 == null)))?((((map__56311.cljs$lang$protocol_mask$partition0$ & (64))) || (map__56311.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56311):map__56311);
var opts = map__56311__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq56308){
var G__56309 = cljs.core.first.call(null,seq56308);
var seq56308__$1 = cljs.core.next.call(null,seq56308);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__56309,seq56308__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var args56316 = [];
var len__19528__auto___56366 = arguments.length;
var i__19529__auto___56367 = (0);
while(true){
if((i__19529__auto___56367 < len__19528__auto___56366)){
args56316.push((arguments[i__19529__auto___56367]));

var G__56368 = (i__19529__auto___56367 + (1));
i__19529__auto___56367 = G__56368;
continue;
} else {
}
break;
}

var G__56318 = args56316.length;
switch (G__56318) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args56316.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__24142__auto___56370 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___56370){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___56370){
return (function (state_56342){
var state_val_56343 = (state_56342[(1)]);
if((state_val_56343 === (7))){
var inst_56338 = (state_56342[(2)]);
var state_56342__$1 = state_56342;
var statearr_56344_56371 = state_56342__$1;
(statearr_56344_56371[(2)] = inst_56338);

(statearr_56344_56371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56343 === (1))){
var state_56342__$1 = state_56342;
var statearr_56345_56372 = state_56342__$1;
(statearr_56345_56372[(2)] = null);

(statearr_56345_56372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56343 === (4))){
var inst_56321 = (state_56342[(7)]);
var inst_56321__$1 = (state_56342[(2)]);
var inst_56322 = (inst_56321__$1 == null);
var state_56342__$1 = (function (){var statearr_56346 = state_56342;
(statearr_56346[(7)] = inst_56321__$1);

return statearr_56346;
})();
if(cljs.core.truth_(inst_56322)){
var statearr_56347_56373 = state_56342__$1;
(statearr_56347_56373[(1)] = (5));

} else {
var statearr_56348_56374 = state_56342__$1;
(statearr_56348_56374[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56343 === (13))){
var state_56342__$1 = state_56342;
var statearr_56349_56375 = state_56342__$1;
(statearr_56349_56375[(2)] = null);

(statearr_56349_56375[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56343 === (6))){
var inst_56321 = (state_56342[(7)]);
var state_56342__$1 = state_56342;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56342__$1,(11),to,inst_56321);
} else {
if((state_val_56343 === (3))){
var inst_56340 = (state_56342[(2)]);
var state_56342__$1 = state_56342;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56342__$1,inst_56340);
} else {
if((state_val_56343 === (12))){
var state_56342__$1 = state_56342;
var statearr_56350_56376 = state_56342__$1;
(statearr_56350_56376[(2)] = null);

(statearr_56350_56376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56343 === (2))){
var state_56342__$1 = state_56342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56342__$1,(4),from);
} else {
if((state_val_56343 === (11))){
var inst_56331 = (state_56342[(2)]);
var state_56342__$1 = state_56342;
if(cljs.core.truth_(inst_56331)){
var statearr_56351_56377 = state_56342__$1;
(statearr_56351_56377[(1)] = (12));

} else {
var statearr_56352_56378 = state_56342__$1;
(statearr_56352_56378[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56343 === (9))){
var state_56342__$1 = state_56342;
var statearr_56353_56379 = state_56342__$1;
(statearr_56353_56379[(2)] = null);

(statearr_56353_56379[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56343 === (5))){
var state_56342__$1 = state_56342;
if(cljs.core.truth_(close_QMARK_)){
var statearr_56354_56380 = state_56342__$1;
(statearr_56354_56380[(1)] = (8));

} else {
var statearr_56355_56381 = state_56342__$1;
(statearr_56355_56381[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56343 === (14))){
var inst_56336 = (state_56342[(2)]);
var state_56342__$1 = state_56342;
var statearr_56356_56382 = state_56342__$1;
(statearr_56356_56382[(2)] = inst_56336);

(statearr_56356_56382[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56343 === (10))){
var inst_56328 = (state_56342[(2)]);
var state_56342__$1 = state_56342;
var statearr_56357_56383 = state_56342__$1;
(statearr_56357_56383[(2)] = inst_56328);

(statearr_56357_56383[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56343 === (8))){
var inst_56325 = cljs.core.async.close_BANG_.call(null,to);
var state_56342__$1 = state_56342;
var statearr_56358_56384 = state_56342__$1;
(statearr_56358_56384[(2)] = inst_56325);

(statearr_56358_56384[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___56370))
;
return ((function (switch__24077__auto__,c__24142__auto___56370){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_56362 = [null,null,null,null,null,null,null,null];
(statearr_56362[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_56362[(1)] = (1));

return statearr_56362;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_56342){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_56342);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e56363){if((e56363 instanceof Object)){
var ex__24081__auto__ = e56363;
var statearr_56364_56385 = state_56342;
(statearr_56364_56385[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56342);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56363;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56386 = state_56342;
state_56342 = G__56386;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_56342){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_56342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___56370))
})();
var state__24144__auto__ = (function (){var statearr_56365 = f__24143__auto__.call(null);
(statearr_56365[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___56370);

return statearr_56365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___56370))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__56570){
var vec__56571 = p__56570;
var v = cljs.core.nth.call(null,vec__56571,(0),null);
var p = cljs.core.nth.call(null,vec__56571,(1),null);
var job = vec__56571;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__24142__auto___56753 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___56753,res,vec__56571,v,p,job,jobs,results){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___56753,res,vec__56571,v,p,job,jobs,results){
return (function (state_56576){
var state_val_56577 = (state_56576[(1)]);
if((state_val_56577 === (1))){
var state_56576__$1 = state_56576;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56576__$1,(2),res,v);
} else {
if((state_val_56577 === (2))){
var inst_56573 = (state_56576[(2)]);
var inst_56574 = cljs.core.async.close_BANG_.call(null,res);
var state_56576__$1 = (function (){var statearr_56578 = state_56576;
(statearr_56578[(7)] = inst_56573);

return statearr_56578;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56576__$1,inst_56574);
} else {
return null;
}
}
});})(c__24142__auto___56753,res,vec__56571,v,p,job,jobs,results))
;
return ((function (switch__24077__auto__,c__24142__auto___56753,res,vec__56571,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0 = (function (){
var statearr_56582 = [null,null,null,null,null,null,null,null];
(statearr_56582[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__);

(statearr_56582[(1)] = (1));

return statearr_56582;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1 = (function (state_56576){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_56576);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e56583){if((e56583 instanceof Object)){
var ex__24081__auto__ = e56583;
var statearr_56584_56754 = state_56576;
(statearr_56584_56754[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56576);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56583;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56755 = state_56576;
state_56576 = G__56755;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__ = function(state_56576){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1.call(this,state_56576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___56753,res,vec__56571,v,p,job,jobs,results))
})();
var state__24144__auto__ = (function (){var statearr_56585 = f__24143__auto__.call(null);
(statearr_56585[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___56753);

return statearr_56585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___56753,res,vec__56571,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__56586){
var vec__56587 = p__56586;
var v = cljs.core.nth.call(null,vec__56587,(0),null);
var p = cljs.core.nth.call(null,vec__56587,(1),null);
var job = vec__56587;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__19373__auto___56756 = n;
var __56757 = (0);
while(true){
if((__56757 < n__19373__auto___56756)){
var G__56588_56758 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__56588_56758) {
case "compute":
var c__24142__auto___56760 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__56757,c__24142__auto___56760,G__56588_56758,n__19373__auto___56756,jobs,results,process,async){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (__56757,c__24142__auto___56760,G__56588_56758,n__19373__auto___56756,jobs,results,process,async){
return (function (state_56601){
var state_val_56602 = (state_56601[(1)]);
if((state_val_56602 === (1))){
var state_56601__$1 = state_56601;
var statearr_56603_56761 = state_56601__$1;
(statearr_56603_56761[(2)] = null);

(statearr_56603_56761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56602 === (2))){
var state_56601__$1 = state_56601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56601__$1,(4),jobs);
} else {
if((state_val_56602 === (3))){
var inst_56599 = (state_56601[(2)]);
var state_56601__$1 = state_56601;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56601__$1,inst_56599);
} else {
if((state_val_56602 === (4))){
var inst_56591 = (state_56601[(2)]);
var inst_56592 = process.call(null,inst_56591);
var state_56601__$1 = state_56601;
if(cljs.core.truth_(inst_56592)){
var statearr_56604_56762 = state_56601__$1;
(statearr_56604_56762[(1)] = (5));

} else {
var statearr_56605_56763 = state_56601__$1;
(statearr_56605_56763[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56602 === (5))){
var state_56601__$1 = state_56601;
var statearr_56606_56764 = state_56601__$1;
(statearr_56606_56764[(2)] = null);

(statearr_56606_56764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56602 === (6))){
var state_56601__$1 = state_56601;
var statearr_56607_56765 = state_56601__$1;
(statearr_56607_56765[(2)] = null);

(statearr_56607_56765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56602 === (7))){
var inst_56597 = (state_56601[(2)]);
var state_56601__$1 = state_56601;
var statearr_56608_56766 = state_56601__$1;
(statearr_56608_56766[(2)] = inst_56597);

(statearr_56608_56766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__56757,c__24142__auto___56760,G__56588_56758,n__19373__auto___56756,jobs,results,process,async))
;
return ((function (__56757,switch__24077__auto__,c__24142__auto___56760,G__56588_56758,n__19373__auto___56756,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0 = (function (){
var statearr_56612 = [null,null,null,null,null,null,null];
(statearr_56612[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__);

(statearr_56612[(1)] = (1));

return statearr_56612;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1 = (function (state_56601){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_56601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e56613){if((e56613 instanceof Object)){
var ex__24081__auto__ = e56613;
var statearr_56614_56767 = state_56601;
(statearr_56614_56767[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56601);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56613;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56768 = state_56601;
state_56601 = G__56768;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__ = function(state_56601){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1.call(this,state_56601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__;
})()
;})(__56757,switch__24077__auto__,c__24142__auto___56760,G__56588_56758,n__19373__auto___56756,jobs,results,process,async))
})();
var state__24144__auto__ = (function (){var statearr_56615 = f__24143__auto__.call(null);
(statearr_56615[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___56760);

return statearr_56615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(__56757,c__24142__auto___56760,G__56588_56758,n__19373__auto___56756,jobs,results,process,async))
);


break;
case "async":
var c__24142__auto___56769 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__56757,c__24142__auto___56769,G__56588_56758,n__19373__auto___56756,jobs,results,process,async){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (__56757,c__24142__auto___56769,G__56588_56758,n__19373__auto___56756,jobs,results,process,async){
return (function (state_56628){
var state_val_56629 = (state_56628[(1)]);
if((state_val_56629 === (1))){
var state_56628__$1 = state_56628;
var statearr_56630_56770 = state_56628__$1;
(statearr_56630_56770[(2)] = null);

(statearr_56630_56770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56629 === (2))){
var state_56628__$1 = state_56628;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56628__$1,(4),jobs);
} else {
if((state_val_56629 === (3))){
var inst_56626 = (state_56628[(2)]);
var state_56628__$1 = state_56628;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56628__$1,inst_56626);
} else {
if((state_val_56629 === (4))){
var inst_56618 = (state_56628[(2)]);
var inst_56619 = async.call(null,inst_56618);
var state_56628__$1 = state_56628;
if(cljs.core.truth_(inst_56619)){
var statearr_56631_56771 = state_56628__$1;
(statearr_56631_56771[(1)] = (5));

} else {
var statearr_56632_56772 = state_56628__$1;
(statearr_56632_56772[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56629 === (5))){
var state_56628__$1 = state_56628;
var statearr_56633_56773 = state_56628__$1;
(statearr_56633_56773[(2)] = null);

(statearr_56633_56773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56629 === (6))){
var state_56628__$1 = state_56628;
var statearr_56634_56774 = state_56628__$1;
(statearr_56634_56774[(2)] = null);

(statearr_56634_56774[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56629 === (7))){
var inst_56624 = (state_56628[(2)]);
var state_56628__$1 = state_56628;
var statearr_56635_56775 = state_56628__$1;
(statearr_56635_56775[(2)] = inst_56624);

(statearr_56635_56775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__56757,c__24142__auto___56769,G__56588_56758,n__19373__auto___56756,jobs,results,process,async))
;
return ((function (__56757,switch__24077__auto__,c__24142__auto___56769,G__56588_56758,n__19373__auto___56756,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0 = (function (){
var statearr_56639 = [null,null,null,null,null,null,null];
(statearr_56639[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__);

(statearr_56639[(1)] = (1));

return statearr_56639;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1 = (function (state_56628){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_56628);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e56640){if((e56640 instanceof Object)){
var ex__24081__auto__ = e56640;
var statearr_56641_56776 = state_56628;
(statearr_56641_56776[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56628);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56640;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56777 = state_56628;
state_56628 = G__56777;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__ = function(state_56628){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1.call(this,state_56628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__;
})()
;})(__56757,switch__24077__auto__,c__24142__auto___56769,G__56588_56758,n__19373__auto___56756,jobs,results,process,async))
})();
var state__24144__auto__ = (function (){var statearr_56642 = f__24143__auto__.call(null);
(statearr_56642[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___56769);

return statearr_56642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(__56757,c__24142__auto___56769,G__56588_56758,n__19373__auto___56756,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__56778 = (__56757 + (1));
__56757 = G__56778;
continue;
} else {
}
break;
}

var c__24142__auto___56779 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___56779,jobs,results,process,async){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___56779,jobs,results,process,async){
return (function (state_56664){
var state_val_56665 = (state_56664[(1)]);
if((state_val_56665 === (1))){
var state_56664__$1 = state_56664;
var statearr_56666_56780 = state_56664__$1;
(statearr_56666_56780[(2)] = null);

(statearr_56666_56780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56665 === (2))){
var state_56664__$1 = state_56664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56664__$1,(4),from);
} else {
if((state_val_56665 === (3))){
var inst_56662 = (state_56664[(2)]);
var state_56664__$1 = state_56664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56664__$1,inst_56662);
} else {
if((state_val_56665 === (4))){
var inst_56645 = (state_56664[(7)]);
var inst_56645__$1 = (state_56664[(2)]);
var inst_56646 = (inst_56645__$1 == null);
var state_56664__$1 = (function (){var statearr_56667 = state_56664;
(statearr_56667[(7)] = inst_56645__$1);

return statearr_56667;
})();
if(cljs.core.truth_(inst_56646)){
var statearr_56668_56781 = state_56664__$1;
(statearr_56668_56781[(1)] = (5));

} else {
var statearr_56669_56782 = state_56664__$1;
(statearr_56669_56782[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56665 === (5))){
var inst_56648 = cljs.core.async.close_BANG_.call(null,jobs);
var state_56664__$1 = state_56664;
var statearr_56670_56783 = state_56664__$1;
(statearr_56670_56783[(2)] = inst_56648);

(statearr_56670_56783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56665 === (6))){
var inst_56645 = (state_56664[(7)]);
var inst_56650 = (state_56664[(8)]);
var inst_56650__$1 = cljs.core.async.chan.call(null,(1));
var inst_56651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56652 = [inst_56645,inst_56650__$1];
var inst_56653 = (new cljs.core.PersistentVector(null,2,(5),inst_56651,inst_56652,null));
var state_56664__$1 = (function (){var statearr_56671 = state_56664;
(statearr_56671[(8)] = inst_56650__$1);

return statearr_56671;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56664__$1,(8),jobs,inst_56653);
} else {
if((state_val_56665 === (7))){
var inst_56660 = (state_56664[(2)]);
var state_56664__$1 = state_56664;
var statearr_56672_56784 = state_56664__$1;
(statearr_56672_56784[(2)] = inst_56660);

(statearr_56672_56784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56665 === (8))){
var inst_56650 = (state_56664[(8)]);
var inst_56655 = (state_56664[(2)]);
var state_56664__$1 = (function (){var statearr_56673 = state_56664;
(statearr_56673[(9)] = inst_56655);

return statearr_56673;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56664__$1,(9),results,inst_56650);
} else {
if((state_val_56665 === (9))){
var inst_56657 = (state_56664[(2)]);
var state_56664__$1 = (function (){var statearr_56674 = state_56664;
(statearr_56674[(10)] = inst_56657);

return statearr_56674;
})();
var statearr_56675_56785 = state_56664__$1;
(statearr_56675_56785[(2)] = null);

(statearr_56675_56785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___56779,jobs,results,process,async))
;
return ((function (switch__24077__auto__,c__24142__auto___56779,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0 = (function (){
var statearr_56679 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_56679[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__);

(statearr_56679[(1)] = (1));

return statearr_56679;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1 = (function (state_56664){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_56664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e56680){if((e56680 instanceof Object)){
var ex__24081__auto__ = e56680;
var statearr_56681_56786 = state_56664;
(statearr_56681_56786[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56664);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56680;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56787 = state_56664;
state_56664 = G__56787;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__ = function(state_56664){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1.call(this,state_56664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___56779,jobs,results,process,async))
})();
var state__24144__auto__ = (function (){var statearr_56682 = f__24143__auto__.call(null);
(statearr_56682[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___56779);

return statearr_56682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___56779,jobs,results,process,async))
);


var c__24142__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto__,jobs,results,process,async){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto__,jobs,results,process,async){
return (function (state_56720){
var state_val_56721 = (state_56720[(1)]);
if((state_val_56721 === (7))){
var inst_56716 = (state_56720[(2)]);
var state_56720__$1 = state_56720;
var statearr_56722_56788 = state_56720__$1;
(statearr_56722_56788[(2)] = inst_56716);

(statearr_56722_56788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (20))){
var state_56720__$1 = state_56720;
var statearr_56723_56789 = state_56720__$1;
(statearr_56723_56789[(2)] = null);

(statearr_56723_56789[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (1))){
var state_56720__$1 = state_56720;
var statearr_56724_56790 = state_56720__$1;
(statearr_56724_56790[(2)] = null);

(statearr_56724_56790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (4))){
var inst_56685 = (state_56720[(7)]);
var inst_56685__$1 = (state_56720[(2)]);
var inst_56686 = (inst_56685__$1 == null);
var state_56720__$1 = (function (){var statearr_56725 = state_56720;
(statearr_56725[(7)] = inst_56685__$1);

return statearr_56725;
})();
if(cljs.core.truth_(inst_56686)){
var statearr_56726_56791 = state_56720__$1;
(statearr_56726_56791[(1)] = (5));

} else {
var statearr_56727_56792 = state_56720__$1;
(statearr_56727_56792[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (15))){
var inst_56698 = (state_56720[(8)]);
var state_56720__$1 = state_56720;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56720__$1,(18),to,inst_56698);
} else {
if((state_val_56721 === (21))){
var inst_56711 = (state_56720[(2)]);
var state_56720__$1 = state_56720;
var statearr_56728_56793 = state_56720__$1;
(statearr_56728_56793[(2)] = inst_56711);

(statearr_56728_56793[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (13))){
var inst_56713 = (state_56720[(2)]);
var state_56720__$1 = (function (){var statearr_56729 = state_56720;
(statearr_56729[(9)] = inst_56713);

return statearr_56729;
})();
var statearr_56730_56794 = state_56720__$1;
(statearr_56730_56794[(2)] = null);

(statearr_56730_56794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (6))){
var inst_56685 = (state_56720[(7)]);
var state_56720__$1 = state_56720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56720__$1,(11),inst_56685);
} else {
if((state_val_56721 === (17))){
var inst_56706 = (state_56720[(2)]);
var state_56720__$1 = state_56720;
if(cljs.core.truth_(inst_56706)){
var statearr_56731_56795 = state_56720__$1;
(statearr_56731_56795[(1)] = (19));

} else {
var statearr_56732_56796 = state_56720__$1;
(statearr_56732_56796[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (3))){
var inst_56718 = (state_56720[(2)]);
var state_56720__$1 = state_56720;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56720__$1,inst_56718);
} else {
if((state_val_56721 === (12))){
var inst_56695 = (state_56720[(10)]);
var state_56720__$1 = state_56720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56720__$1,(14),inst_56695);
} else {
if((state_val_56721 === (2))){
var state_56720__$1 = state_56720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56720__$1,(4),results);
} else {
if((state_val_56721 === (19))){
var state_56720__$1 = state_56720;
var statearr_56733_56797 = state_56720__$1;
(statearr_56733_56797[(2)] = null);

(statearr_56733_56797[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (11))){
var inst_56695 = (state_56720[(2)]);
var state_56720__$1 = (function (){var statearr_56734 = state_56720;
(statearr_56734[(10)] = inst_56695);

return statearr_56734;
})();
var statearr_56735_56798 = state_56720__$1;
(statearr_56735_56798[(2)] = null);

(statearr_56735_56798[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (9))){
var state_56720__$1 = state_56720;
var statearr_56736_56799 = state_56720__$1;
(statearr_56736_56799[(2)] = null);

(statearr_56736_56799[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (5))){
var state_56720__$1 = state_56720;
if(cljs.core.truth_(close_QMARK_)){
var statearr_56737_56800 = state_56720__$1;
(statearr_56737_56800[(1)] = (8));

} else {
var statearr_56738_56801 = state_56720__$1;
(statearr_56738_56801[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (14))){
var inst_56698 = (state_56720[(8)]);
var inst_56700 = (state_56720[(11)]);
var inst_56698__$1 = (state_56720[(2)]);
var inst_56699 = (inst_56698__$1 == null);
var inst_56700__$1 = cljs.core.not.call(null,inst_56699);
var state_56720__$1 = (function (){var statearr_56739 = state_56720;
(statearr_56739[(8)] = inst_56698__$1);

(statearr_56739[(11)] = inst_56700__$1);

return statearr_56739;
})();
if(inst_56700__$1){
var statearr_56740_56802 = state_56720__$1;
(statearr_56740_56802[(1)] = (15));

} else {
var statearr_56741_56803 = state_56720__$1;
(statearr_56741_56803[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (16))){
var inst_56700 = (state_56720[(11)]);
var state_56720__$1 = state_56720;
var statearr_56742_56804 = state_56720__$1;
(statearr_56742_56804[(2)] = inst_56700);

(statearr_56742_56804[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (10))){
var inst_56692 = (state_56720[(2)]);
var state_56720__$1 = state_56720;
var statearr_56743_56805 = state_56720__$1;
(statearr_56743_56805[(2)] = inst_56692);

(statearr_56743_56805[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (18))){
var inst_56703 = (state_56720[(2)]);
var state_56720__$1 = state_56720;
var statearr_56744_56806 = state_56720__$1;
(statearr_56744_56806[(2)] = inst_56703);

(statearr_56744_56806[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56721 === (8))){
var inst_56689 = cljs.core.async.close_BANG_.call(null,to);
var state_56720__$1 = state_56720;
var statearr_56745_56807 = state_56720__$1;
(statearr_56745_56807[(2)] = inst_56689);

(statearr_56745_56807[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto__,jobs,results,process,async))
;
return ((function (switch__24077__auto__,c__24142__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0 = (function (){
var statearr_56749 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56749[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__);

(statearr_56749[(1)] = (1));

return statearr_56749;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1 = (function (state_56720){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_56720);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e56750){if((e56750 instanceof Object)){
var ex__24081__auto__ = e56750;
var statearr_56751_56808 = state_56720;
(statearr_56751_56808[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56720);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56750;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56809 = state_56720;
state_56720 = G__56809;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__ = function(state_56720){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1.call(this,state_56720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24078__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto__,jobs,results,process,async))
})();
var state__24144__auto__ = (function (){var statearr_56752 = f__24143__auto__.call(null);
(statearr_56752[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto__);

return statearr_56752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto__,jobs,results,process,async))
);

return c__24142__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var args56810 = [];
var len__19528__auto___56813 = arguments.length;
var i__19529__auto___56814 = (0);
while(true){
if((i__19529__auto___56814 < len__19528__auto___56813)){
args56810.push((arguments[i__19529__auto___56814]));

var G__56815 = (i__19529__auto___56814 + (1));
i__19529__auto___56814 = G__56815;
continue;
} else {
}
break;
}

var G__56812 = args56810.length;
switch (G__56812) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args56810.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var args56817 = [];
var len__19528__auto___56820 = arguments.length;
var i__19529__auto___56821 = (0);
while(true){
if((i__19529__auto___56821 < len__19528__auto___56820)){
args56817.push((arguments[i__19529__auto___56821]));

var G__56822 = (i__19529__auto___56821 + (1));
i__19529__auto___56821 = G__56822;
continue;
} else {
}
break;
}

var G__56819 = args56817.length;
switch (G__56819) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args56817.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var args56824 = [];
var len__19528__auto___56877 = arguments.length;
var i__19529__auto___56878 = (0);
while(true){
if((i__19529__auto___56878 < len__19528__auto___56877)){
args56824.push((arguments[i__19529__auto___56878]));

var G__56879 = (i__19529__auto___56878 + (1));
i__19529__auto___56878 = G__56879;
continue;
} else {
}
break;
}

var G__56826 = args56824.length;
switch (G__56826) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args56824.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__24142__auto___56881 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___56881,tc,fc){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___56881,tc,fc){
return (function (state_56852){
var state_val_56853 = (state_56852[(1)]);
if((state_val_56853 === (7))){
var inst_56848 = (state_56852[(2)]);
var state_56852__$1 = state_56852;
var statearr_56854_56882 = state_56852__$1;
(statearr_56854_56882[(2)] = inst_56848);

(statearr_56854_56882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56853 === (1))){
var state_56852__$1 = state_56852;
var statearr_56855_56883 = state_56852__$1;
(statearr_56855_56883[(2)] = null);

(statearr_56855_56883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56853 === (4))){
var inst_56829 = (state_56852[(7)]);
var inst_56829__$1 = (state_56852[(2)]);
var inst_56830 = (inst_56829__$1 == null);
var state_56852__$1 = (function (){var statearr_56856 = state_56852;
(statearr_56856[(7)] = inst_56829__$1);

return statearr_56856;
})();
if(cljs.core.truth_(inst_56830)){
var statearr_56857_56884 = state_56852__$1;
(statearr_56857_56884[(1)] = (5));

} else {
var statearr_56858_56885 = state_56852__$1;
(statearr_56858_56885[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56853 === (13))){
var state_56852__$1 = state_56852;
var statearr_56859_56886 = state_56852__$1;
(statearr_56859_56886[(2)] = null);

(statearr_56859_56886[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56853 === (6))){
var inst_56829 = (state_56852[(7)]);
var inst_56835 = p.call(null,inst_56829);
var state_56852__$1 = state_56852;
if(cljs.core.truth_(inst_56835)){
var statearr_56860_56887 = state_56852__$1;
(statearr_56860_56887[(1)] = (9));

} else {
var statearr_56861_56888 = state_56852__$1;
(statearr_56861_56888[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56853 === (3))){
var inst_56850 = (state_56852[(2)]);
var state_56852__$1 = state_56852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56852__$1,inst_56850);
} else {
if((state_val_56853 === (12))){
var state_56852__$1 = state_56852;
var statearr_56862_56889 = state_56852__$1;
(statearr_56862_56889[(2)] = null);

(statearr_56862_56889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56853 === (2))){
var state_56852__$1 = state_56852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56852__$1,(4),ch);
} else {
if((state_val_56853 === (11))){
var inst_56829 = (state_56852[(7)]);
var inst_56839 = (state_56852[(2)]);
var state_56852__$1 = state_56852;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56852__$1,(8),inst_56839,inst_56829);
} else {
if((state_val_56853 === (9))){
var state_56852__$1 = state_56852;
var statearr_56863_56890 = state_56852__$1;
(statearr_56863_56890[(2)] = tc);

(statearr_56863_56890[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56853 === (5))){
var inst_56832 = cljs.core.async.close_BANG_.call(null,tc);
var inst_56833 = cljs.core.async.close_BANG_.call(null,fc);
var state_56852__$1 = (function (){var statearr_56864 = state_56852;
(statearr_56864[(8)] = inst_56832);

return statearr_56864;
})();
var statearr_56865_56891 = state_56852__$1;
(statearr_56865_56891[(2)] = inst_56833);

(statearr_56865_56891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56853 === (14))){
var inst_56846 = (state_56852[(2)]);
var state_56852__$1 = state_56852;
var statearr_56866_56892 = state_56852__$1;
(statearr_56866_56892[(2)] = inst_56846);

(statearr_56866_56892[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56853 === (10))){
var state_56852__$1 = state_56852;
var statearr_56867_56893 = state_56852__$1;
(statearr_56867_56893[(2)] = fc);

(statearr_56867_56893[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56853 === (8))){
var inst_56841 = (state_56852[(2)]);
var state_56852__$1 = state_56852;
if(cljs.core.truth_(inst_56841)){
var statearr_56868_56894 = state_56852__$1;
(statearr_56868_56894[(1)] = (12));

} else {
var statearr_56869_56895 = state_56852__$1;
(statearr_56869_56895[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___56881,tc,fc))
;
return ((function (switch__24077__auto__,c__24142__auto___56881,tc,fc){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_56873 = [null,null,null,null,null,null,null,null,null];
(statearr_56873[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_56873[(1)] = (1));

return statearr_56873;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_56852){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_56852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e56874){if((e56874 instanceof Object)){
var ex__24081__auto__ = e56874;
var statearr_56875_56896 = state_56852;
(statearr_56875_56896[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56852);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56874;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56897 = state_56852;
state_56852 = G__56897;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_56852){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_56852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___56881,tc,fc))
})();
var state__24144__auto__ = (function (){var statearr_56876 = f__24143__auto__.call(null);
(statearr_56876[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___56881);

return statearr_56876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___56881,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__24142__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto__){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto__){
return (function (state_56944){
var state_val_56945 = (state_56944[(1)]);
if((state_val_56945 === (1))){
var inst_56930 = init;
var state_56944__$1 = (function (){var statearr_56946 = state_56944;
(statearr_56946[(7)] = inst_56930);

return statearr_56946;
})();
var statearr_56947_56962 = state_56944__$1;
(statearr_56947_56962[(2)] = null);

(statearr_56947_56962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56945 === (2))){
var state_56944__$1 = state_56944;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56944__$1,(4),ch);
} else {
if((state_val_56945 === (3))){
var inst_56942 = (state_56944[(2)]);
var state_56944__$1 = state_56944;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56944__$1,inst_56942);
} else {
if((state_val_56945 === (4))){
var inst_56933 = (state_56944[(8)]);
var inst_56933__$1 = (state_56944[(2)]);
var inst_56934 = (inst_56933__$1 == null);
var state_56944__$1 = (function (){var statearr_56948 = state_56944;
(statearr_56948[(8)] = inst_56933__$1);

return statearr_56948;
})();
if(cljs.core.truth_(inst_56934)){
var statearr_56949_56963 = state_56944__$1;
(statearr_56949_56963[(1)] = (5));

} else {
var statearr_56950_56964 = state_56944__$1;
(statearr_56950_56964[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56945 === (5))){
var inst_56930 = (state_56944[(7)]);
var state_56944__$1 = state_56944;
var statearr_56951_56965 = state_56944__$1;
(statearr_56951_56965[(2)] = inst_56930);

(statearr_56951_56965[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56945 === (6))){
var inst_56933 = (state_56944[(8)]);
var inst_56930 = (state_56944[(7)]);
var inst_56937 = f.call(null,inst_56930,inst_56933);
var inst_56930__$1 = inst_56937;
var state_56944__$1 = (function (){var statearr_56952 = state_56944;
(statearr_56952[(7)] = inst_56930__$1);

return statearr_56952;
})();
var statearr_56953_56966 = state_56944__$1;
(statearr_56953_56966[(2)] = null);

(statearr_56953_56966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56945 === (7))){
var inst_56940 = (state_56944[(2)]);
var state_56944__$1 = state_56944;
var statearr_56954_56967 = state_56944__$1;
(statearr_56954_56967[(2)] = inst_56940);

(statearr_56954_56967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__24142__auto__))
;
return ((function (switch__24077__auto__,c__24142__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__24078__auto__ = null;
var cljs$core$async$reduce_$_state_machine__24078__auto____0 = (function (){
var statearr_56958 = [null,null,null,null,null,null,null,null,null];
(statearr_56958[(0)] = cljs$core$async$reduce_$_state_machine__24078__auto__);

(statearr_56958[(1)] = (1));

return statearr_56958;
});
var cljs$core$async$reduce_$_state_machine__24078__auto____1 = (function (state_56944){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_56944);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e56959){if((e56959 instanceof Object)){
var ex__24081__auto__ = e56959;
var statearr_56960_56968 = state_56944;
(statearr_56960_56968[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56944);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56959;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56969 = state_56944;
state_56944 = G__56969;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__24078__auto__ = function(state_56944){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__24078__auto____1.call(this,state_56944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__24078__auto____0;
cljs$core$async$reduce_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__24078__auto____1;
return cljs$core$async$reduce_$_state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto__))
})();
var state__24144__auto__ = (function (){var statearr_56961 = f__24143__auto__.call(null);
(statearr_56961[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto__);

return statearr_56961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto__))
);

return c__24142__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var args56970 = [];
var len__19528__auto___57022 = arguments.length;
var i__19529__auto___57023 = (0);
while(true){
if((i__19529__auto___57023 < len__19528__auto___57022)){
args56970.push((arguments[i__19529__auto___57023]));

var G__57024 = (i__19529__auto___57023 + (1));
i__19529__auto___57023 = G__57024;
continue;
} else {
}
break;
}

var G__56972 = args56970.length;
switch (G__56972) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args56970.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__24142__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto__){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto__){
return (function (state_56997){
var state_val_56998 = (state_56997[(1)]);
if((state_val_56998 === (7))){
var inst_56979 = (state_56997[(2)]);
var state_56997__$1 = state_56997;
var statearr_56999_57026 = state_56997__$1;
(statearr_56999_57026[(2)] = inst_56979);

(statearr_56999_57026[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (1))){
var inst_56973 = cljs.core.seq.call(null,coll);
var inst_56974 = inst_56973;
var state_56997__$1 = (function (){var statearr_57000 = state_56997;
(statearr_57000[(7)] = inst_56974);

return statearr_57000;
})();
var statearr_57001_57027 = state_56997__$1;
(statearr_57001_57027[(2)] = null);

(statearr_57001_57027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (4))){
var inst_56974 = (state_56997[(7)]);
var inst_56977 = cljs.core.first.call(null,inst_56974);
var state_56997__$1 = state_56997;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56997__$1,(7),ch,inst_56977);
} else {
if((state_val_56998 === (13))){
var inst_56991 = (state_56997[(2)]);
var state_56997__$1 = state_56997;
var statearr_57002_57028 = state_56997__$1;
(statearr_57002_57028[(2)] = inst_56991);

(statearr_57002_57028[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (6))){
var inst_56982 = (state_56997[(2)]);
var state_56997__$1 = state_56997;
if(cljs.core.truth_(inst_56982)){
var statearr_57003_57029 = state_56997__$1;
(statearr_57003_57029[(1)] = (8));

} else {
var statearr_57004_57030 = state_56997__$1;
(statearr_57004_57030[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (3))){
var inst_56995 = (state_56997[(2)]);
var state_56997__$1 = state_56997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56997__$1,inst_56995);
} else {
if((state_val_56998 === (12))){
var state_56997__$1 = state_56997;
var statearr_57005_57031 = state_56997__$1;
(statearr_57005_57031[(2)] = null);

(statearr_57005_57031[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (2))){
var inst_56974 = (state_56997[(7)]);
var state_56997__$1 = state_56997;
if(cljs.core.truth_(inst_56974)){
var statearr_57006_57032 = state_56997__$1;
(statearr_57006_57032[(1)] = (4));

} else {
var statearr_57007_57033 = state_56997__$1;
(statearr_57007_57033[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (11))){
var inst_56988 = cljs.core.async.close_BANG_.call(null,ch);
var state_56997__$1 = state_56997;
var statearr_57008_57034 = state_56997__$1;
(statearr_57008_57034[(2)] = inst_56988);

(statearr_57008_57034[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (9))){
var state_56997__$1 = state_56997;
if(cljs.core.truth_(close_QMARK_)){
var statearr_57009_57035 = state_56997__$1;
(statearr_57009_57035[(1)] = (11));

} else {
var statearr_57010_57036 = state_56997__$1;
(statearr_57010_57036[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (5))){
var inst_56974 = (state_56997[(7)]);
var state_56997__$1 = state_56997;
var statearr_57011_57037 = state_56997__$1;
(statearr_57011_57037[(2)] = inst_56974);

(statearr_57011_57037[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (10))){
var inst_56993 = (state_56997[(2)]);
var state_56997__$1 = state_56997;
var statearr_57012_57038 = state_56997__$1;
(statearr_57012_57038[(2)] = inst_56993);

(statearr_57012_57038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56998 === (8))){
var inst_56974 = (state_56997[(7)]);
var inst_56984 = cljs.core.next.call(null,inst_56974);
var inst_56974__$1 = inst_56984;
var state_56997__$1 = (function (){var statearr_57013 = state_56997;
(statearr_57013[(7)] = inst_56974__$1);

return statearr_57013;
})();
var statearr_57014_57039 = state_56997__$1;
(statearr_57014_57039[(2)] = null);

(statearr_57014_57039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto__))
;
return ((function (switch__24077__auto__,c__24142__auto__){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_57018 = [null,null,null,null,null,null,null,null];
(statearr_57018[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_57018[(1)] = (1));

return statearr_57018;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_56997){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_56997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e57019){if((e57019 instanceof Object)){
var ex__24081__auto__ = e57019;
var statearr_57020_57040 = state_56997;
(statearr_57020_57040[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56997);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57019;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57041 = state_56997;
state_56997 = G__57041;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_56997){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_56997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto__))
})();
var state__24144__auto__ = (function (){var statearr_57021 = f__24143__auto__.call(null);
(statearr_57021[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto__);

return statearr_57021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto__))
);

return c__24142__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = {};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__19125__auto__ = (((_ == null))?null:_);
var m__19126__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,_);
} else {
var m__19126__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


cljs.core.async.Mult = {};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__19126__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,ch);
} else {
var m__19126__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m);
} else {
var m__19126__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t57267 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t57267 = (function (mult,ch,cs,meta57268){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta57268 = meta57268;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t57267.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_57269,meta57268__$1){
var self__ = this;
var _57269__$1 = this;
return (new cljs.core.async.t57267(self__.mult,self__.ch,self__.cs,meta57268__$1));
});})(cs))
;

cljs.core.async.t57267.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_57269){
var self__ = this;
var _57269__$1 = this;
return self__.meta57268;
});})(cs))
;

cljs.core.async.t57267.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t57267.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t57267.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t57267.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t57267.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t57267.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t57267.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta57268","meta57268",-1851474808,null)], null);
});})(cs))
;

cljs.core.async.t57267.cljs$lang$type = true;

cljs.core.async.t57267.cljs$lang$ctorStr = "cljs.core.async/t57267";

cljs.core.async.t57267.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t57267");
});})(cs))
;

cljs.core.async.__GT_t57267 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t57267(mult__$1,ch__$1,cs__$1,meta57268){
return (new cljs.core.async.t57267(mult__$1,ch__$1,cs__$1,meta57268));
});})(cs))
;

}

return (new cljs.core.async.t57267(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__24142__auto___57488 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___57488,cs,m,dchan,dctr,done){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___57488,cs,m,dchan,dctr,done){
return (function (state_57400){
var state_val_57401 = (state_57400[(1)]);
if((state_val_57401 === (7))){
var inst_57396 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
var statearr_57402_57489 = state_57400__$1;
(statearr_57402_57489[(2)] = inst_57396);

(statearr_57402_57489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (20))){
var inst_57301 = (state_57400[(7)]);
var inst_57311 = cljs.core.first.call(null,inst_57301);
var inst_57312 = cljs.core.nth.call(null,inst_57311,(0),null);
var inst_57313 = cljs.core.nth.call(null,inst_57311,(1),null);
var state_57400__$1 = (function (){var statearr_57403 = state_57400;
(statearr_57403[(8)] = inst_57312);

return statearr_57403;
})();
if(cljs.core.truth_(inst_57313)){
var statearr_57404_57490 = state_57400__$1;
(statearr_57404_57490[(1)] = (22));

} else {
var statearr_57405_57491 = state_57400__$1;
(statearr_57405_57491[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (27))){
var inst_57348 = (state_57400[(9)]);
var inst_57272 = (state_57400[(10)]);
var inst_57341 = (state_57400[(11)]);
var inst_57343 = (state_57400[(12)]);
var inst_57348__$1 = cljs.core._nth.call(null,inst_57341,inst_57343);
var inst_57349 = cljs.core.async.put_BANG_.call(null,inst_57348__$1,inst_57272,done);
var state_57400__$1 = (function (){var statearr_57406 = state_57400;
(statearr_57406[(9)] = inst_57348__$1);

return statearr_57406;
})();
if(cljs.core.truth_(inst_57349)){
var statearr_57407_57492 = state_57400__$1;
(statearr_57407_57492[(1)] = (30));

} else {
var statearr_57408_57493 = state_57400__$1;
(statearr_57408_57493[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (1))){
var state_57400__$1 = state_57400;
var statearr_57409_57494 = state_57400__$1;
(statearr_57409_57494[(2)] = null);

(statearr_57409_57494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (24))){
var inst_57301 = (state_57400[(7)]);
var inst_57318 = (state_57400[(2)]);
var inst_57319 = cljs.core.next.call(null,inst_57301);
var inst_57281 = inst_57319;
var inst_57282 = null;
var inst_57283 = (0);
var inst_57284 = (0);
var state_57400__$1 = (function (){var statearr_57410 = state_57400;
(statearr_57410[(13)] = inst_57284);

(statearr_57410[(14)] = inst_57282);

(statearr_57410[(15)] = inst_57318);

(statearr_57410[(16)] = inst_57283);

(statearr_57410[(17)] = inst_57281);

return statearr_57410;
})();
var statearr_57411_57495 = state_57400__$1;
(statearr_57411_57495[(2)] = null);

(statearr_57411_57495[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (39))){
var state_57400__$1 = state_57400;
var statearr_57415_57496 = state_57400__$1;
(statearr_57415_57496[(2)] = null);

(statearr_57415_57496[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (4))){
var inst_57272 = (state_57400[(10)]);
var inst_57272__$1 = (state_57400[(2)]);
var inst_57273 = (inst_57272__$1 == null);
var state_57400__$1 = (function (){var statearr_57416 = state_57400;
(statearr_57416[(10)] = inst_57272__$1);

return statearr_57416;
})();
if(cljs.core.truth_(inst_57273)){
var statearr_57417_57497 = state_57400__$1;
(statearr_57417_57497[(1)] = (5));

} else {
var statearr_57418_57498 = state_57400__$1;
(statearr_57418_57498[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (15))){
var inst_57284 = (state_57400[(13)]);
var inst_57282 = (state_57400[(14)]);
var inst_57283 = (state_57400[(16)]);
var inst_57281 = (state_57400[(17)]);
var inst_57297 = (state_57400[(2)]);
var inst_57298 = (inst_57284 + (1));
var tmp57412 = inst_57282;
var tmp57413 = inst_57283;
var tmp57414 = inst_57281;
var inst_57281__$1 = tmp57414;
var inst_57282__$1 = tmp57412;
var inst_57283__$1 = tmp57413;
var inst_57284__$1 = inst_57298;
var state_57400__$1 = (function (){var statearr_57419 = state_57400;
(statearr_57419[(13)] = inst_57284__$1);

(statearr_57419[(14)] = inst_57282__$1);

(statearr_57419[(16)] = inst_57283__$1);

(statearr_57419[(18)] = inst_57297);

(statearr_57419[(17)] = inst_57281__$1);

return statearr_57419;
})();
var statearr_57420_57499 = state_57400__$1;
(statearr_57420_57499[(2)] = null);

(statearr_57420_57499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (21))){
var inst_57322 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
var statearr_57424_57500 = state_57400__$1;
(statearr_57424_57500[(2)] = inst_57322);

(statearr_57424_57500[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (31))){
var inst_57348 = (state_57400[(9)]);
var inst_57352 = done.call(null,null);
var inst_57353 = cljs.core.async.untap_STAR_.call(null,m,inst_57348);
var state_57400__$1 = (function (){var statearr_57425 = state_57400;
(statearr_57425[(19)] = inst_57352);

return statearr_57425;
})();
var statearr_57426_57501 = state_57400__$1;
(statearr_57426_57501[(2)] = inst_57353);

(statearr_57426_57501[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (32))){
var inst_57341 = (state_57400[(11)]);
var inst_57343 = (state_57400[(12)]);
var inst_57340 = (state_57400[(20)]);
var inst_57342 = (state_57400[(21)]);
var inst_57355 = (state_57400[(2)]);
var inst_57356 = (inst_57343 + (1));
var tmp57421 = inst_57341;
var tmp57422 = inst_57340;
var tmp57423 = inst_57342;
var inst_57340__$1 = tmp57422;
var inst_57341__$1 = tmp57421;
var inst_57342__$1 = tmp57423;
var inst_57343__$1 = inst_57356;
var state_57400__$1 = (function (){var statearr_57427 = state_57400;
(statearr_57427[(11)] = inst_57341__$1);

(statearr_57427[(12)] = inst_57343__$1);

(statearr_57427[(22)] = inst_57355);

(statearr_57427[(20)] = inst_57340__$1);

(statearr_57427[(21)] = inst_57342__$1);

return statearr_57427;
})();
var statearr_57428_57502 = state_57400__$1;
(statearr_57428_57502[(2)] = null);

(statearr_57428_57502[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (40))){
var inst_57368 = (state_57400[(23)]);
var inst_57372 = done.call(null,null);
var inst_57373 = cljs.core.async.untap_STAR_.call(null,m,inst_57368);
var state_57400__$1 = (function (){var statearr_57429 = state_57400;
(statearr_57429[(24)] = inst_57372);

return statearr_57429;
})();
var statearr_57430_57503 = state_57400__$1;
(statearr_57430_57503[(2)] = inst_57373);

(statearr_57430_57503[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (33))){
var inst_57359 = (state_57400[(25)]);
var inst_57361 = cljs.core.chunked_seq_QMARK_.call(null,inst_57359);
var state_57400__$1 = state_57400;
if(inst_57361){
var statearr_57431_57504 = state_57400__$1;
(statearr_57431_57504[(1)] = (36));

} else {
var statearr_57432_57505 = state_57400__$1;
(statearr_57432_57505[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (13))){
var inst_57291 = (state_57400[(26)]);
var inst_57294 = cljs.core.async.close_BANG_.call(null,inst_57291);
var state_57400__$1 = state_57400;
var statearr_57433_57506 = state_57400__$1;
(statearr_57433_57506[(2)] = inst_57294);

(statearr_57433_57506[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (22))){
var inst_57312 = (state_57400[(8)]);
var inst_57315 = cljs.core.async.close_BANG_.call(null,inst_57312);
var state_57400__$1 = state_57400;
var statearr_57434_57507 = state_57400__$1;
(statearr_57434_57507[(2)] = inst_57315);

(statearr_57434_57507[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (36))){
var inst_57359 = (state_57400[(25)]);
var inst_57363 = cljs.core.chunk_first.call(null,inst_57359);
var inst_57364 = cljs.core.chunk_rest.call(null,inst_57359);
var inst_57365 = cljs.core.count.call(null,inst_57363);
var inst_57340 = inst_57364;
var inst_57341 = inst_57363;
var inst_57342 = inst_57365;
var inst_57343 = (0);
var state_57400__$1 = (function (){var statearr_57435 = state_57400;
(statearr_57435[(11)] = inst_57341);

(statearr_57435[(12)] = inst_57343);

(statearr_57435[(20)] = inst_57340);

(statearr_57435[(21)] = inst_57342);

return statearr_57435;
})();
var statearr_57436_57508 = state_57400__$1;
(statearr_57436_57508[(2)] = null);

(statearr_57436_57508[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (41))){
var inst_57359 = (state_57400[(25)]);
var inst_57375 = (state_57400[(2)]);
var inst_57376 = cljs.core.next.call(null,inst_57359);
var inst_57340 = inst_57376;
var inst_57341 = null;
var inst_57342 = (0);
var inst_57343 = (0);
var state_57400__$1 = (function (){var statearr_57437 = state_57400;
(statearr_57437[(27)] = inst_57375);

(statearr_57437[(11)] = inst_57341);

(statearr_57437[(12)] = inst_57343);

(statearr_57437[(20)] = inst_57340);

(statearr_57437[(21)] = inst_57342);

return statearr_57437;
})();
var statearr_57438_57509 = state_57400__$1;
(statearr_57438_57509[(2)] = null);

(statearr_57438_57509[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (43))){
var state_57400__$1 = state_57400;
var statearr_57439_57510 = state_57400__$1;
(statearr_57439_57510[(2)] = null);

(statearr_57439_57510[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (29))){
var inst_57384 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
var statearr_57440_57511 = state_57400__$1;
(statearr_57440_57511[(2)] = inst_57384);

(statearr_57440_57511[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (44))){
var inst_57393 = (state_57400[(2)]);
var state_57400__$1 = (function (){var statearr_57441 = state_57400;
(statearr_57441[(28)] = inst_57393);

return statearr_57441;
})();
var statearr_57442_57512 = state_57400__$1;
(statearr_57442_57512[(2)] = null);

(statearr_57442_57512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (6))){
var inst_57332 = (state_57400[(29)]);
var inst_57331 = cljs.core.deref.call(null,cs);
var inst_57332__$1 = cljs.core.keys.call(null,inst_57331);
var inst_57333 = cljs.core.count.call(null,inst_57332__$1);
var inst_57334 = cljs.core.reset_BANG_.call(null,dctr,inst_57333);
var inst_57339 = cljs.core.seq.call(null,inst_57332__$1);
var inst_57340 = inst_57339;
var inst_57341 = null;
var inst_57342 = (0);
var inst_57343 = (0);
var state_57400__$1 = (function (){var statearr_57443 = state_57400;
(statearr_57443[(30)] = inst_57334);

(statearr_57443[(11)] = inst_57341);

(statearr_57443[(12)] = inst_57343);

(statearr_57443[(20)] = inst_57340);

(statearr_57443[(29)] = inst_57332__$1);

(statearr_57443[(21)] = inst_57342);

return statearr_57443;
})();
var statearr_57444_57513 = state_57400__$1;
(statearr_57444_57513[(2)] = null);

(statearr_57444_57513[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (28))){
var inst_57359 = (state_57400[(25)]);
var inst_57340 = (state_57400[(20)]);
var inst_57359__$1 = cljs.core.seq.call(null,inst_57340);
var state_57400__$1 = (function (){var statearr_57445 = state_57400;
(statearr_57445[(25)] = inst_57359__$1);

return statearr_57445;
})();
if(inst_57359__$1){
var statearr_57446_57514 = state_57400__$1;
(statearr_57446_57514[(1)] = (33));

} else {
var statearr_57447_57515 = state_57400__$1;
(statearr_57447_57515[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (25))){
var inst_57343 = (state_57400[(12)]);
var inst_57342 = (state_57400[(21)]);
var inst_57345 = (inst_57343 < inst_57342);
var inst_57346 = inst_57345;
var state_57400__$1 = state_57400;
if(cljs.core.truth_(inst_57346)){
var statearr_57448_57516 = state_57400__$1;
(statearr_57448_57516[(1)] = (27));

} else {
var statearr_57449_57517 = state_57400__$1;
(statearr_57449_57517[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (34))){
var state_57400__$1 = state_57400;
var statearr_57450_57518 = state_57400__$1;
(statearr_57450_57518[(2)] = null);

(statearr_57450_57518[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (17))){
var state_57400__$1 = state_57400;
var statearr_57451_57519 = state_57400__$1;
(statearr_57451_57519[(2)] = null);

(statearr_57451_57519[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (3))){
var inst_57398 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57400__$1,inst_57398);
} else {
if((state_val_57401 === (12))){
var inst_57327 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
var statearr_57452_57520 = state_57400__$1;
(statearr_57452_57520[(2)] = inst_57327);

(statearr_57452_57520[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (2))){
var state_57400__$1 = state_57400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57400__$1,(4),ch);
} else {
if((state_val_57401 === (23))){
var state_57400__$1 = state_57400;
var statearr_57453_57521 = state_57400__$1;
(statearr_57453_57521[(2)] = null);

(statearr_57453_57521[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (35))){
var inst_57382 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
var statearr_57454_57522 = state_57400__$1;
(statearr_57454_57522[(2)] = inst_57382);

(statearr_57454_57522[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (19))){
var inst_57301 = (state_57400[(7)]);
var inst_57305 = cljs.core.chunk_first.call(null,inst_57301);
var inst_57306 = cljs.core.chunk_rest.call(null,inst_57301);
var inst_57307 = cljs.core.count.call(null,inst_57305);
var inst_57281 = inst_57306;
var inst_57282 = inst_57305;
var inst_57283 = inst_57307;
var inst_57284 = (0);
var state_57400__$1 = (function (){var statearr_57455 = state_57400;
(statearr_57455[(13)] = inst_57284);

(statearr_57455[(14)] = inst_57282);

(statearr_57455[(16)] = inst_57283);

(statearr_57455[(17)] = inst_57281);

return statearr_57455;
})();
var statearr_57456_57523 = state_57400__$1;
(statearr_57456_57523[(2)] = null);

(statearr_57456_57523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (11))){
var inst_57301 = (state_57400[(7)]);
var inst_57281 = (state_57400[(17)]);
var inst_57301__$1 = cljs.core.seq.call(null,inst_57281);
var state_57400__$1 = (function (){var statearr_57457 = state_57400;
(statearr_57457[(7)] = inst_57301__$1);

return statearr_57457;
})();
if(inst_57301__$1){
var statearr_57458_57524 = state_57400__$1;
(statearr_57458_57524[(1)] = (16));

} else {
var statearr_57459_57525 = state_57400__$1;
(statearr_57459_57525[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (9))){
var inst_57329 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
var statearr_57460_57526 = state_57400__$1;
(statearr_57460_57526[(2)] = inst_57329);

(statearr_57460_57526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (5))){
var inst_57279 = cljs.core.deref.call(null,cs);
var inst_57280 = cljs.core.seq.call(null,inst_57279);
var inst_57281 = inst_57280;
var inst_57282 = null;
var inst_57283 = (0);
var inst_57284 = (0);
var state_57400__$1 = (function (){var statearr_57461 = state_57400;
(statearr_57461[(13)] = inst_57284);

(statearr_57461[(14)] = inst_57282);

(statearr_57461[(16)] = inst_57283);

(statearr_57461[(17)] = inst_57281);

return statearr_57461;
})();
var statearr_57462_57527 = state_57400__$1;
(statearr_57462_57527[(2)] = null);

(statearr_57462_57527[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (14))){
var state_57400__$1 = state_57400;
var statearr_57463_57528 = state_57400__$1;
(statearr_57463_57528[(2)] = null);

(statearr_57463_57528[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (45))){
var inst_57390 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
var statearr_57464_57529 = state_57400__$1;
(statearr_57464_57529[(2)] = inst_57390);

(statearr_57464_57529[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (26))){
var inst_57332 = (state_57400[(29)]);
var inst_57386 = (state_57400[(2)]);
var inst_57387 = cljs.core.seq.call(null,inst_57332);
var state_57400__$1 = (function (){var statearr_57465 = state_57400;
(statearr_57465[(31)] = inst_57386);

return statearr_57465;
})();
if(inst_57387){
var statearr_57466_57530 = state_57400__$1;
(statearr_57466_57530[(1)] = (42));

} else {
var statearr_57467_57531 = state_57400__$1;
(statearr_57467_57531[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (16))){
var inst_57301 = (state_57400[(7)]);
var inst_57303 = cljs.core.chunked_seq_QMARK_.call(null,inst_57301);
var state_57400__$1 = state_57400;
if(inst_57303){
var statearr_57468_57532 = state_57400__$1;
(statearr_57468_57532[(1)] = (19));

} else {
var statearr_57469_57533 = state_57400__$1;
(statearr_57469_57533[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (38))){
var inst_57379 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
var statearr_57470_57534 = state_57400__$1;
(statearr_57470_57534[(2)] = inst_57379);

(statearr_57470_57534[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (30))){
var state_57400__$1 = state_57400;
var statearr_57471_57535 = state_57400__$1;
(statearr_57471_57535[(2)] = null);

(statearr_57471_57535[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (10))){
var inst_57284 = (state_57400[(13)]);
var inst_57282 = (state_57400[(14)]);
var inst_57290 = cljs.core._nth.call(null,inst_57282,inst_57284);
var inst_57291 = cljs.core.nth.call(null,inst_57290,(0),null);
var inst_57292 = cljs.core.nth.call(null,inst_57290,(1),null);
var state_57400__$1 = (function (){var statearr_57472 = state_57400;
(statearr_57472[(26)] = inst_57291);

return statearr_57472;
})();
if(cljs.core.truth_(inst_57292)){
var statearr_57473_57536 = state_57400__$1;
(statearr_57473_57536[(1)] = (13));

} else {
var statearr_57474_57537 = state_57400__$1;
(statearr_57474_57537[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (18))){
var inst_57325 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
var statearr_57475_57538 = state_57400__$1;
(statearr_57475_57538[(2)] = inst_57325);

(statearr_57475_57538[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (42))){
var state_57400__$1 = state_57400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57400__$1,(45),dchan);
} else {
if((state_val_57401 === (37))){
var inst_57272 = (state_57400[(10)]);
var inst_57359 = (state_57400[(25)]);
var inst_57368 = (state_57400[(23)]);
var inst_57368__$1 = cljs.core.first.call(null,inst_57359);
var inst_57369 = cljs.core.async.put_BANG_.call(null,inst_57368__$1,inst_57272,done);
var state_57400__$1 = (function (){var statearr_57476 = state_57400;
(statearr_57476[(23)] = inst_57368__$1);

return statearr_57476;
})();
if(cljs.core.truth_(inst_57369)){
var statearr_57477_57539 = state_57400__$1;
(statearr_57477_57539[(1)] = (39));

} else {
var statearr_57478_57540 = state_57400__$1;
(statearr_57478_57540[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (8))){
var inst_57284 = (state_57400[(13)]);
var inst_57283 = (state_57400[(16)]);
var inst_57286 = (inst_57284 < inst_57283);
var inst_57287 = inst_57286;
var state_57400__$1 = state_57400;
if(cljs.core.truth_(inst_57287)){
var statearr_57479_57541 = state_57400__$1;
(statearr_57479_57541[(1)] = (10));

} else {
var statearr_57480_57542 = state_57400__$1;
(statearr_57480_57542[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___57488,cs,m,dchan,dctr,done))
;
return ((function (switch__24077__auto__,c__24142__auto___57488,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__24078__auto__ = null;
var cljs$core$async$mult_$_state_machine__24078__auto____0 = (function (){
var statearr_57484 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57484[(0)] = cljs$core$async$mult_$_state_machine__24078__auto__);

(statearr_57484[(1)] = (1));

return statearr_57484;
});
var cljs$core$async$mult_$_state_machine__24078__auto____1 = (function (state_57400){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_57400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e57485){if((e57485 instanceof Object)){
var ex__24081__auto__ = e57485;
var statearr_57486_57543 = state_57400;
(statearr_57486_57543[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57400);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57485;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57544 = state_57400;
state_57400 = G__57544;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__24078__auto__ = function(state_57400){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__24078__auto____1.call(this,state_57400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__24078__auto____0;
cljs$core$async$mult_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__24078__auto____1;
return cljs$core$async$mult_$_state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___57488,cs,m,dchan,dctr,done))
})();
var state__24144__auto__ = (function (){var statearr_57487 = f__24143__auto__.call(null);
(statearr_57487[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___57488);

return statearr_57487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___57488,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var args57545 = [];
var len__19528__auto___57548 = arguments.length;
var i__19529__auto___57549 = (0);
while(true){
if((i__19529__auto___57549 < len__19528__auto___57548)){
args57545.push((arguments[i__19529__auto___57549]));

var G__57550 = (i__19529__auto___57549 + (1));
i__19529__auto___57549 = G__57550;
continue;
} else {
}
break;
}

var G__57547 = args57545.length;
switch (G__57547) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args57545.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = {};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,ch);
} else {
var m__19126__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,ch);
} else {
var m__19126__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m);
} else {
var m__19126__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,state_map);
} else {
var m__19126__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__19125__auto__ = (((m == null))?null:m);
var m__19126__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,m,mode);
} else {
var m__19126__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var args__19535__auto__ = [];
var len__19528__auto___57564 = arguments.length;
var i__19529__auto___57565 = (0);
while(true){
if((i__19529__auto___57565 < len__19528__auto___57564)){
args__19535__auto__.push((arguments[i__19529__auto___57565]));

var G__57566 = (i__19529__auto___57565 + (1));
i__19529__auto___57565 = G__57566;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((3) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19536__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__57558){
var map__57559 = p__57558;
var map__57559__$1 = ((((!((map__57559 == null)))?((((map__57559.cljs$lang$protocol_mask$partition0$ & (64))) || (map__57559.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57559):map__57559);
var opts = map__57559__$1;
var statearr_57561_57567 = state;
(statearr_57561_57567[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__57559,map__57559__$1,opts){
return (function (val){
var statearr_57562_57568 = state;
(statearr_57562_57568[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__57559,map__57559__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_57563_57569 = state;
(statearr_57563_57569[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq57554){
var G__57555 = cljs.core.first.call(null,seq57554);
var seq57554__$1 = cljs.core.next.call(null,seq57554);
var G__57556 = cljs.core.first.call(null,seq57554__$1);
var seq57554__$2 = cljs.core.next.call(null,seq57554__$1);
var G__57557 = cljs.core.first.call(null,seq57554__$2);
var seq57554__$3 = cljs.core.next.call(null,seq57554__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__57555,G__57556,G__57557,seq57554__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t57733 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t57733 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta57734){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta57734 = meta57734;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t57733.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_57735,meta57734__$1){
var self__ = this;
var _57735__$1 = this;
return (new cljs.core.async.t57733(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta57734__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t57733.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_57735){
var self__ = this;
var _57735__$1 = this;
return self__.meta57734;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t57733.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t57733.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t57733.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t57733.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t57733.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t57733.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t57733.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t57733.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t57733.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta57734","meta57734",-1064264023,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t57733.cljs$lang$type = true;

cljs.core.async.t57733.cljs$lang$ctorStr = "cljs.core.async/t57733";

cljs.core.async.t57733.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t57733");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t57733 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t57733(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta57734){
return (new cljs.core.async.t57733(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta57734));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t57733(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__24142__auto___57896 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___57896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___57896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_57833){
var state_val_57834 = (state_57833[(1)]);
if((state_val_57834 === (7))){
var inst_57751 = (state_57833[(2)]);
var state_57833__$1 = state_57833;
var statearr_57835_57897 = state_57833__$1;
(statearr_57835_57897[(2)] = inst_57751);

(statearr_57835_57897[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (20))){
var inst_57763 = (state_57833[(7)]);
var state_57833__$1 = state_57833;
var statearr_57836_57898 = state_57833__$1;
(statearr_57836_57898[(2)] = inst_57763);

(statearr_57836_57898[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (27))){
var state_57833__$1 = state_57833;
var statearr_57837_57899 = state_57833__$1;
(statearr_57837_57899[(2)] = null);

(statearr_57837_57899[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (1))){
var inst_57739 = (state_57833[(8)]);
var inst_57739__$1 = calc_state.call(null);
var inst_57741 = (inst_57739__$1 == null);
var inst_57742 = cljs.core.not.call(null,inst_57741);
var state_57833__$1 = (function (){var statearr_57838 = state_57833;
(statearr_57838[(8)] = inst_57739__$1);

return statearr_57838;
})();
if(inst_57742){
var statearr_57839_57900 = state_57833__$1;
(statearr_57839_57900[(1)] = (2));

} else {
var statearr_57840_57901 = state_57833__$1;
(statearr_57840_57901[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (24))){
var inst_57807 = (state_57833[(9)]);
var inst_57786 = (state_57833[(10)]);
var inst_57793 = (state_57833[(11)]);
var inst_57807__$1 = inst_57786.call(null,inst_57793);
var state_57833__$1 = (function (){var statearr_57841 = state_57833;
(statearr_57841[(9)] = inst_57807__$1);

return statearr_57841;
})();
if(cljs.core.truth_(inst_57807__$1)){
var statearr_57842_57902 = state_57833__$1;
(statearr_57842_57902[(1)] = (29));

} else {
var statearr_57843_57903 = state_57833__$1;
(statearr_57843_57903[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (4))){
var inst_57754 = (state_57833[(2)]);
var state_57833__$1 = state_57833;
if(cljs.core.truth_(inst_57754)){
var statearr_57844_57904 = state_57833__$1;
(statearr_57844_57904[(1)] = (8));

} else {
var statearr_57845_57905 = state_57833__$1;
(statearr_57845_57905[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (15))){
var inst_57780 = (state_57833[(2)]);
var state_57833__$1 = state_57833;
if(cljs.core.truth_(inst_57780)){
var statearr_57846_57906 = state_57833__$1;
(statearr_57846_57906[(1)] = (19));

} else {
var statearr_57847_57907 = state_57833__$1;
(statearr_57847_57907[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (21))){
var inst_57785 = (state_57833[(12)]);
var inst_57785__$1 = (state_57833[(2)]);
var inst_57786 = cljs.core.get.call(null,inst_57785__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_57787 = cljs.core.get.call(null,inst_57785__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_57788 = cljs.core.get.call(null,inst_57785__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_57833__$1 = (function (){var statearr_57848 = state_57833;
(statearr_57848[(13)] = inst_57787);

(statearr_57848[(12)] = inst_57785__$1);

(statearr_57848[(10)] = inst_57786);

return statearr_57848;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_57833__$1,(22),inst_57788);
} else {
if((state_val_57834 === (31))){
var inst_57815 = (state_57833[(2)]);
var state_57833__$1 = state_57833;
if(cljs.core.truth_(inst_57815)){
var statearr_57849_57908 = state_57833__$1;
(statearr_57849_57908[(1)] = (32));

} else {
var statearr_57850_57909 = state_57833__$1;
(statearr_57850_57909[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (32))){
var inst_57792 = (state_57833[(14)]);
var state_57833__$1 = state_57833;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57833__$1,(35),out,inst_57792);
} else {
if((state_val_57834 === (33))){
var inst_57785 = (state_57833[(12)]);
var inst_57763 = inst_57785;
var state_57833__$1 = (function (){var statearr_57851 = state_57833;
(statearr_57851[(7)] = inst_57763);

return statearr_57851;
})();
var statearr_57852_57910 = state_57833__$1;
(statearr_57852_57910[(2)] = null);

(statearr_57852_57910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (13))){
var inst_57763 = (state_57833[(7)]);
var inst_57770 = inst_57763.cljs$lang$protocol_mask$partition0$;
var inst_57771 = (inst_57770 & (64));
var inst_57772 = inst_57763.cljs$core$ISeq$;
var inst_57773 = (inst_57771) || (inst_57772);
var state_57833__$1 = state_57833;
if(cljs.core.truth_(inst_57773)){
var statearr_57853_57911 = state_57833__$1;
(statearr_57853_57911[(1)] = (16));

} else {
var statearr_57854_57912 = state_57833__$1;
(statearr_57854_57912[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (22))){
var inst_57793 = (state_57833[(11)]);
var inst_57792 = (state_57833[(14)]);
var inst_57791 = (state_57833[(2)]);
var inst_57792__$1 = cljs.core.nth.call(null,inst_57791,(0),null);
var inst_57793__$1 = cljs.core.nth.call(null,inst_57791,(1),null);
var inst_57794 = (inst_57792__$1 == null);
var inst_57795 = cljs.core._EQ_.call(null,inst_57793__$1,change);
var inst_57796 = (inst_57794) || (inst_57795);
var state_57833__$1 = (function (){var statearr_57855 = state_57833;
(statearr_57855[(11)] = inst_57793__$1);

(statearr_57855[(14)] = inst_57792__$1);

return statearr_57855;
})();
if(cljs.core.truth_(inst_57796)){
var statearr_57856_57913 = state_57833__$1;
(statearr_57856_57913[(1)] = (23));

} else {
var statearr_57857_57914 = state_57833__$1;
(statearr_57857_57914[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (36))){
var inst_57785 = (state_57833[(12)]);
var inst_57763 = inst_57785;
var state_57833__$1 = (function (){var statearr_57858 = state_57833;
(statearr_57858[(7)] = inst_57763);

return statearr_57858;
})();
var statearr_57859_57915 = state_57833__$1;
(statearr_57859_57915[(2)] = null);

(statearr_57859_57915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (29))){
var inst_57807 = (state_57833[(9)]);
var state_57833__$1 = state_57833;
var statearr_57860_57916 = state_57833__$1;
(statearr_57860_57916[(2)] = inst_57807);

(statearr_57860_57916[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (6))){
var state_57833__$1 = state_57833;
var statearr_57861_57917 = state_57833__$1;
(statearr_57861_57917[(2)] = false);

(statearr_57861_57917[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (28))){
var inst_57803 = (state_57833[(2)]);
var inst_57804 = calc_state.call(null);
var inst_57763 = inst_57804;
var state_57833__$1 = (function (){var statearr_57862 = state_57833;
(statearr_57862[(7)] = inst_57763);

(statearr_57862[(15)] = inst_57803);

return statearr_57862;
})();
var statearr_57863_57918 = state_57833__$1;
(statearr_57863_57918[(2)] = null);

(statearr_57863_57918[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (25))){
var inst_57829 = (state_57833[(2)]);
var state_57833__$1 = state_57833;
var statearr_57864_57919 = state_57833__$1;
(statearr_57864_57919[(2)] = inst_57829);

(statearr_57864_57919[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (34))){
var inst_57827 = (state_57833[(2)]);
var state_57833__$1 = state_57833;
var statearr_57865_57920 = state_57833__$1;
(statearr_57865_57920[(2)] = inst_57827);

(statearr_57865_57920[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (17))){
var state_57833__$1 = state_57833;
var statearr_57866_57921 = state_57833__$1;
(statearr_57866_57921[(2)] = false);

(statearr_57866_57921[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (3))){
var state_57833__$1 = state_57833;
var statearr_57867_57922 = state_57833__$1;
(statearr_57867_57922[(2)] = false);

(statearr_57867_57922[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (12))){
var inst_57831 = (state_57833[(2)]);
var state_57833__$1 = state_57833;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57833__$1,inst_57831);
} else {
if((state_val_57834 === (2))){
var inst_57739 = (state_57833[(8)]);
var inst_57744 = inst_57739.cljs$lang$protocol_mask$partition0$;
var inst_57745 = (inst_57744 & (64));
var inst_57746 = inst_57739.cljs$core$ISeq$;
var inst_57747 = (inst_57745) || (inst_57746);
var state_57833__$1 = state_57833;
if(cljs.core.truth_(inst_57747)){
var statearr_57868_57923 = state_57833__$1;
(statearr_57868_57923[(1)] = (5));

} else {
var statearr_57869_57924 = state_57833__$1;
(statearr_57869_57924[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (23))){
var inst_57792 = (state_57833[(14)]);
var inst_57798 = (inst_57792 == null);
var state_57833__$1 = state_57833;
if(cljs.core.truth_(inst_57798)){
var statearr_57870_57925 = state_57833__$1;
(statearr_57870_57925[(1)] = (26));

} else {
var statearr_57871_57926 = state_57833__$1;
(statearr_57871_57926[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (35))){
var inst_57818 = (state_57833[(2)]);
var state_57833__$1 = state_57833;
if(cljs.core.truth_(inst_57818)){
var statearr_57872_57927 = state_57833__$1;
(statearr_57872_57927[(1)] = (36));

} else {
var statearr_57873_57928 = state_57833__$1;
(statearr_57873_57928[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (19))){
var inst_57763 = (state_57833[(7)]);
var inst_57782 = cljs.core.apply.call(null,cljs.core.hash_map,inst_57763);
var state_57833__$1 = state_57833;
var statearr_57874_57929 = state_57833__$1;
(statearr_57874_57929[(2)] = inst_57782);

(statearr_57874_57929[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (11))){
var inst_57763 = (state_57833[(7)]);
var inst_57767 = (inst_57763 == null);
var inst_57768 = cljs.core.not.call(null,inst_57767);
var state_57833__$1 = state_57833;
if(inst_57768){
var statearr_57875_57930 = state_57833__$1;
(statearr_57875_57930[(1)] = (13));

} else {
var statearr_57876_57931 = state_57833__$1;
(statearr_57876_57931[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (9))){
var inst_57739 = (state_57833[(8)]);
var state_57833__$1 = state_57833;
var statearr_57877_57932 = state_57833__$1;
(statearr_57877_57932[(2)] = inst_57739);

(statearr_57877_57932[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (5))){
var state_57833__$1 = state_57833;
var statearr_57878_57933 = state_57833__$1;
(statearr_57878_57933[(2)] = true);

(statearr_57878_57933[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (14))){
var state_57833__$1 = state_57833;
var statearr_57879_57934 = state_57833__$1;
(statearr_57879_57934[(2)] = false);

(statearr_57879_57934[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (26))){
var inst_57793 = (state_57833[(11)]);
var inst_57800 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_57793);
var state_57833__$1 = state_57833;
var statearr_57880_57935 = state_57833__$1;
(statearr_57880_57935[(2)] = inst_57800);

(statearr_57880_57935[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (16))){
var state_57833__$1 = state_57833;
var statearr_57881_57936 = state_57833__$1;
(statearr_57881_57936[(2)] = true);

(statearr_57881_57936[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (38))){
var inst_57823 = (state_57833[(2)]);
var state_57833__$1 = state_57833;
var statearr_57882_57937 = state_57833__$1;
(statearr_57882_57937[(2)] = inst_57823);

(statearr_57882_57937[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (30))){
var inst_57787 = (state_57833[(13)]);
var inst_57786 = (state_57833[(10)]);
var inst_57793 = (state_57833[(11)]);
var inst_57810 = cljs.core.empty_QMARK_.call(null,inst_57786);
var inst_57811 = inst_57787.call(null,inst_57793);
var inst_57812 = cljs.core.not.call(null,inst_57811);
var inst_57813 = (inst_57810) && (inst_57812);
var state_57833__$1 = state_57833;
var statearr_57883_57938 = state_57833__$1;
(statearr_57883_57938[(2)] = inst_57813);

(statearr_57883_57938[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (10))){
var inst_57739 = (state_57833[(8)]);
var inst_57759 = (state_57833[(2)]);
var inst_57760 = cljs.core.get.call(null,inst_57759,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_57761 = cljs.core.get.call(null,inst_57759,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_57762 = cljs.core.get.call(null,inst_57759,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_57763 = inst_57739;
var state_57833__$1 = (function (){var statearr_57884 = state_57833;
(statearr_57884[(7)] = inst_57763);

(statearr_57884[(16)] = inst_57761);

(statearr_57884[(17)] = inst_57760);

(statearr_57884[(18)] = inst_57762);

return statearr_57884;
})();
var statearr_57885_57939 = state_57833__$1;
(statearr_57885_57939[(2)] = null);

(statearr_57885_57939[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (18))){
var inst_57777 = (state_57833[(2)]);
var state_57833__$1 = state_57833;
var statearr_57886_57940 = state_57833__$1;
(statearr_57886_57940[(2)] = inst_57777);

(statearr_57886_57940[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (37))){
var state_57833__$1 = state_57833;
var statearr_57887_57941 = state_57833__$1;
(statearr_57887_57941[(2)] = null);

(statearr_57887_57941[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57834 === (8))){
var inst_57739 = (state_57833[(8)]);
var inst_57756 = cljs.core.apply.call(null,cljs.core.hash_map,inst_57739);
var state_57833__$1 = state_57833;
var statearr_57888_57942 = state_57833__$1;
(statearr_57888_57942[(2)] = inst_57756);

(statearr_57888_57942[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___57896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__24077__auto__,c__24142__auto___57896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__24078__auto__ = null;
var cljs$core$async$mix_$_state_machine__24078__auto____0 = (function (){
var statearr_57892 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57892[(0)] = cljs$core$async$mix_$_state_machine__24078__auto__);

(statearr_57892[(1)] = (1));

return statearr_57892;
});
var cljs$core$async$mix_$_state_machine__24078__auto____1 = (function (state_57833){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_57833);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e57893){if((e57893 instanceof Object)){
var ex__24081__auto__ = e57893;
var statearr_57894_57943 = state_57833;
(statearr_57894_57943[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57833);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57893;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57944 = state_57833;
state_57833 = G__57944;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__24078__auto__ = function(state_57833){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__24078__auto____1.call(this,state_57833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__24078__auto____0;
cljs$core$async$mix_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__24078__auto____1;
return cljs$core$async$mix_$_state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___57896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__24144__auto__ = (function (){var statearr_57895 = f__24143__auto__.call(null);
(statearr_57895[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___57896);

return statearr_57895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___57896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = {};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__19125__auto__ = (((p == null))?null:p);
var m__19126__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__19126__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__19125__auto__ = (((p == null))?null:p);
var m__19126__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,p,v,ch);
} else {
var m__19126__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var args57947 = [];
var len__19528__auto___57950 = arguments.length;
var i__19529__auto___57951 = (0);
while(true){
if((i__19529__auto___57951 < len__19528__auto___57950)){
args57947.push((arguments[i__19529__auto___57951]));

var G__57952 = (i__19529__auto___57951 + (1));
i__19529__auto___57951 = G__57952;
continue;
} else {
}
break;
}

var G__57949 = args57947.length;
switch (G__57949) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args57947.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__19125__auto__ = (((p == null))?null:p);
var m__19126__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,p);
} else {
var m__19126__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__19125__auto__ = (((p == null))?null:p);
var m__19126__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,p,v);
} else {
var m__19126__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var args57955 = [];
var len__19528__auto___58080 = arguments.length;
var i__19529__auto___58081 = (0);
while(true){
if((i__19529__auto___58081 < len__19528__auto___58080)){
args57955.push((arguments[i__19529__auto___58081]));

var G__58082 = (i__19529__auto___58081 + (1));
i__19529__auto___58081 = G__58082;
continue;
} else {
}
break;
}

var G__57957 = args57955.length;
switch (G__57957) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args57955.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__18489__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__18489__auto__,mults){
return (function (p1__57954_SHARP_){
if(cljs.core.truth_(p1__57954_SHARP_.call(null,topic))){
return p1__57954_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__57954_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__18489__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t57958 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t57958 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta57959){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta57959 = meta57959;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t57958.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_57960,meta57959__$1){
var self__ = this;
var _57960__$1 = this;
return (new cljs.core.async.t57958(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta57959__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t57958.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_57960){
var self__ = this;
var _57960__$1 = this;
return self__.meta57959;
});})(mults,ensure_mult))
;

cljs.core.async.t57958.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t57958.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t57958.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t57958.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t57958.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t57958.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t57958.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t57958.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta57959","meta57959",-1223356212,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t57958.cljs$lang$type = true;

cljs.core.async.t57958.cljs$lang$ctorStr = "cljs.core.async/t57958";

cljs.core.async.t57958.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t57958");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t57958 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t57958(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta57959){
return (new cljs.core.async.t57958(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta57959));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t57958(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__24142__auto___58084 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___58084,mults,ensure_mult,p){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___58084,mults,ensure_mult,p){
return (function (state_58032){
var state_val_58033 = (state_58032[(1)]);
if((state_val_58033 === (7))){
var inst_58028 = (state_58032[(2)]);
var state_58032__$1 = state_58032;
var statearr_58034_58085 = state_58032__$1;
(statearr_58034_58085[(2)] = inst_58028);

(statearr_58034_58085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (20))){
var state_58032__$1 = state_58032;
var statearr_58035_58086 = state_58032__$1;
(statearr_58035_58086[(2)] = null);

(statearr_58035_58086[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (1))){
var state_58032__$1 = state_58032;
var statearr_58036_58087 = state_58032__$1;
(statearr_58036_58087[(2)] = null);

(statearr_58036_58087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (24))){
var inst_58011 = (state_58032[(7)]);
var inst_58020 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_58011);
var state_58032__$1 = state_58032;
var statearr_58037_58088 = state_58032__$1;
(statearr_58037_58088[(2)] = inst_58020);

(statearr_58037_58088[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (4))){
var inst_57963 = (state_58032[(8)]);
var inst_57963__$1 = (state_58032[(2)]);
var inst_57964 = (inst_57963__$1 == null);
var state_58032__$1 = (function (){var statearr_58038 = state_58032;
(statearr_58038[(8)] = inst_57963__$1);

return statearr_58038;
})();
if(cljs.core.truth_(inst_57964)){
var statearr_58039_58089 = state_58032__$1;
(statearr_58039_58089[(1)] = (5));

} else {
var statearr_58040_58090 = state_58032__$1;
(statearr_58040_58090[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (15))){
var inst_58005 = (state_58032[(2)]);
var state_58032__$1 = state_58032;
var statearr_58041_58091 = state_58032__$1;
(statearr_58041_58091[(2)] = inst_58005);

(statearr_58041_58091[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (21))){
var inst_58025 = (state_58032[(2)]);
var state_58032__$1 = (function (){var statearr_58042 = state_58032;
(statearr_58042[(9)] = inst_58025);

return statearr_58042;
})();
var statearr_58043_58092 = state_58032__$1;
(statearr_58043_58092[(2)] = null);

(statearr_58043_58092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (13))){
var inst_57987 = (state_58032[(10)]);
var inst_57989 = cljs.core.chunked_seq_QMARK_.call(null,inst_57987);
var state_58032__$1 = state_58032;
if(inst_57989){
var statearr_58044_58093 = state_58032__$1;
(statearr_58044_58093[(1)] = (16));

} else {
var statearr_58045_58094 = state_58032__$1;
(statearr_58045_58094[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (22))){
var inst_58017 = (state_58032[(2)]);
var state_58032__$1 = state_58032;
if(cljs.core.truth_(inst_58017)){
var statearr_58046_58095 = state_58032__$1;
(statearr_58046_58095[(1)] = (23));

} else {
var statearr_58047_58096 = state_58032__$1;
(statearr_58047_58096[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (6))){
var inst_58013 = (state_58032[(11)]);
var inst_58011 = (state_58032[(7)]);
var inst_57963 = (state_58032[(8)]);
var inst_58011__$1 = topic_fn.call(null,inst_57963);
var inst_58012 = cljs.core.deref.call(null,mults);
var inst_58013__$1 = cljs.core.get.call(null,inst_58012,inst_58011__$1);
var state_58032__$1 = (function (){var statearr_58048 = state_58032;
(statearr_58048[(11)] = inst_58013__$1);

(statearr_58048[(7)] = inst_58011__$1);

return statearr_58048;
})();
if(cljs.core.truth_(inst_58013__$1)){
var statearr_58049_58097 = state_58032__$1;
(statearr_58049_58097[(1)] = (19));

} else {
var statearr_58050_58098 = state_58032__$1;
(statearr_58050_58098[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (25))){
var inst_58022 = (state_58032[(2)]);
var state_58032__$1 = state_58032;
var statearr_58051_58099 = state_58032__$1;
(statearr_58051_58099[(2)] = inst_58022);

(statearr_58051_58099[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (17))){
var inst_57987 = (state_58032[(10)]);
var inst_57996 = cljs.core.first.call(null,inst_57987);
var inst_57997 = cljs.core.async.muxch_STAR_.call(null,inst_57996);
var inst_57998 = cljs.core.async.close_BANG_.call(null,inst_57997);
var inst_57999 = cljs.core.next.call(null,inst_57987);
var inst_57973 = inst_57999;
var inst_57974 = null;
var inst_57975 = (0);
var inst_57976 = (0);
var state_58032__$1 = (function (){var statearr_58052 = state_58032;
(statearr_58052[(12)] = inst_57974);

(statearr_58052[(13)] = inst_57975);

(statearr_58052[(14)] = inst_57998);

(statearr_58052[(15)] = inst_57976);

(statearr_58052[(16)] = inst_57973);

return statearr_58052;
})();
var statearr_58053_58100 = state_58032__$1;
(statearr_58053_58100[(2)] = null);

(statearr_58053_58100[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (3))){
var inst_58030 = (state_58032[(2)]);
var state_58032__$1 = state_58032;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58032__$1,inst_58030);
} else {
if((state_val_58033 === (12))){
var inst_58007 = (state_58032[(2)]);
var state_58032__$1 = state_58032;
var statearr_58054_58101 = state_58032__$1;
(statearr_58054_58101[(2)] = inst_58007);

(statearr_58054_58101[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (2))){
var state_58032__$1 = state_58032;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58032__$1,(4),ch);
} else {
if((state_val_58033 === (23))){
var state_58032__$1 = state_58032;
var statearr_58055_58102 = state_58032__$1;
(statearr_58055_58102[(2)] = null);

(statearr_58055_58102[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (19))){
var inst_58013 = (state_58032[(11)]);
var inst_57963 = (state_58032[(8)]);
var inst_58015 = cljs.core.async.muxch_STAR_.call(null,inst_58013);
var state_58032__$1 = state_58032;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58032__$1,(22),inst_58015,inst_57963);
} else {
if((state_val_58033 === (11))){
var inst_57973 = (state_58032[(16)]);
var inst_57987 = (state_58032[(10)]);
var inst_57987__$1 = cljs.core.seq.call(null,inst_57973);
var state_58032__$1 = (function (){var statearr_58056 = state_58032;
(statearr_58056[(10)] = inst_57987__$1);

return statearr_58056;
})();
if(inst_57987__$1){
var statearr_58057_58103 = state_58032__$1;
(statearr_58057_58103[(1)] = (13));

} else {
var statearr_58058_58104 = state_58032__$1;
(statearr_58058_58104[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (9))){
var inst_58009 = (state_58032[(2)]);
var state_58032__$1 = state_58032;
var statearr_58059_58105 = state_58032__$1;
(statearr_58059_58105[(2)] = inst_58009);

(statearr_58059_58105[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (5))){
var inst_57970 = cljs.core.deref.call(null,mults);
var inst_57971 = cljs.core.vals.call(null,inst_57970);
var inst_57972 = cljs.core.seq.call(null,inst_57971);
var inst_57973 = inst_57972;
var inst_57974 = null;
var inst_57975 = (0);
var inst_57976 = (0);
var state_58032__$1 = (function (){var statearr_58060 = state_58032;
(statearr_58060[(12)] = inst_57974);

(statearr_58060[(13)] = inst_57975);

(statearr_58060[(15)] = inst_57976);

(statearr_58060[(16)] = inst_57973);

return statearr_58060;
})();
var statearr_58061_58106 = state_58032__$1;
(statearr_58061_58106[(2)] = null);

(statearr_58061_58106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (14))){
var state_58032__$1 = state_58032;
var statearr_58065_58107 = state_58032__$1;
(statearr_58065_58107[(2)] = null);

(statearr_58065_58107[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (16))){
var inst_57987 = (state_58032[(10)]);
var inst_57991 = cljs.core.chunk_first.call(null,inst_57987);
var inst_57992 = cljs.core.chunk_rest.call(null,inst_57987);
var inst_57993 = cljs.core.count.call(null,inst_57991);
var inst_57973 = inst_57992;
var inst_57974 = inst_57991;
var inst_57975 = inst_57993;
var inst_57976 = (0);
var state_58032__$1 = (function (){var statearr_58066 = state_58032;
(statearr_58066[(12)] = inst_57974);

(statearr_58066[(13)] = inst_57975);

(statearr_58066[(15)] = inst_57976);

(statearr_58066[(16)] = inst_57973);

return statearr_58066;
})();
var statearr_58067_58108 = state_58032__$1;
(statearr_58067_58108[(2)] = null);

(statearr_58067_58108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (10))){
var inst_57974 = (state_58032[(12)]);
var inst_57975 = (state_58032[(13)]);
var inst_57976 = (state_58032[(15)]);
var inst_57973 = (state_58032[(16)]);
var inst_57981 = cljs.core._nth.call(null,inst_57974,inst_57976);
var inst_57982 = cljs.core.async.muxch_STAR_.call(null,inst_57981);
var inst_57983 = cljs.core.async.close_BANG_.call(null,inst_57982);
var inst_57984 = (inst_57976 + (1));
var tmp58062 = inst_57974;
var tmp58063 = inst_57975;
var tmp58064 = inst_57973;
var inst_57973__$1 = tmp58064;
var inst_57974__$1 = tmp58062;
var inst_57975__$1 = tmp58063;
var inst_57976__$1 = inst_57984;
var state_58032__$1 = (function (){var statearr_58068 = state_58032;
(statearr_58068[(12)] = inst_57974__$1);

(statearr_58068[(13)] = inst_57975__$1);

(statearr_58068[(15)] = inst_57976__$1);

(statearr_58068[(16)] = inst_57973__$1);

(statearr_58068[(17)] = inst_57983);

return statearr_58068;
})();
var statearr_58069_58109 = state_58032__$1;
(statearr_58069_58109[(2)] = null);

(statearr_58069_58109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (18))){
var inst_58002 = (state_58032[(2)]);
var state_58032__$1 = state_58032;
var statearr_58070_58110 = state_58032__$1;
(statearr_58070_58110[(2)] = inst_58002);

(statearr_58070_58110[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58033 === (8))){
var inst_57975 = (state_58032[(13)]);
var inst_57976 = (state_58032[(15)]);
var inst_57978 = (inst_57976 < inst_57975);
var inst_57979 = inst_57978;
var state_58032__$1 = state_58032;
if(cljs.core.truth_(inst_57979)){
var statearr_58071_58111 = state_58032__$1;
(statearr_58071_58111[(1)] = (10));

} else {
var statearr_58072_58112 = state_58032__$1;
(statearr_58072_58112[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___58084,mults,ensure_mult,p))
;
return ((function (switch__24077__auto__,c__24142__auto___58084,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_58076 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58076[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_58076[(1)] = (1));

return statearr_58076;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_58032){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_58032);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e58077){if((e58077 instanceof Object)){
var ex__24081__auto__ = e58077;
var statearr_58078_58113 = state_58032;
(statearr_58078_58113[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58032);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58077;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58114 = state_58032;
state_58032 = G__58114;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_58032){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_58032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___58084,mults,ensure_mult,p))
})();
var state__24144__auto__ = (function (){var statearr_58079 = f__24143__auto__.call(null);
(statearr_58079[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___58084);

return statearr_58079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___58084,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var args58115 = [];
var len__19528__auto___58118 = arguments.length;
var i__19529__auto___58119 = (0);
while(true){
if((i__19529__auto___58119 < len__19528__auto___58118)){
args58115.push((arguments[i__19529__auto___58119]));

var G__58120 = (i__19529__auto___58119 + (1));
i__19529__auto___58119 = G__58120;
continue;
} else {
}
break;
}

var G__58117 = args58115.length;
switch (G__58117) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58115.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var args58122 = [];
var len__19528__auto___58125 = arguments.length;
var i__19529__auto___58126 = (0);
while(true){
if((i__19529__auto___58126 < len__19528__auto___58125)){
args58122.push((arguments[i__19529__auto___58126]));

var G__58127 = (i__19529__auto___58126 + (1));
i__19529__auto___58126 = G__58127;
continue;
} else {
}
break;
}

var G__58124 = args58122.length;
switch (G__58124) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58122.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var args58129 = [];
var len__19528__auto___58200 = arguments.length;
var i__19529__auto___58201 = (0);
while(true){
if((i__19529__auto___58201 < len__19528__auto___58200)){
args58129.push((arguments[i__19529__auto___58201]));

var G__58202 = (i__19529__auto___58201 + (1));
i__19529__auto___58201 = G__58202;
continue;
} else {
}
break;
}

var G__58131 = args58129.length;
switch (G__58131) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58129.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__24142__auto___58204 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___58204,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___58204,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_58170){
var state_val_58171 = (state_58170[(1)]);
if((state_val_58171 === (7))){
var state_58170__$1 = state_58170;
var statearr_58172_58205 = state_58170__$1;
(statearr_58172_58205[(2)] = null);

(statearr_58172_58205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (1))){
var state_58170__$1 = state_58170;
var statearr_58173_58206 = state_58170__$1;
(statearr_58173_58206[(2)] = null);

(statearr_58173_58206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (4))){
var inst_58134 = (state_58170[(7)]);
var inst_58136 = (inst_58134 < cnt);
var state_58170__$1 = state_58170;
if(cljs.core.truth_(inst_58136)){
var statearr_58174_58207 = state_58170__$1;
(statearr_58174_58207[(1)] = (6));

} else {
var statearr_58175_58208 = state_58170__$1;
(statearr_58175_58208[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (15))){
var inst_58166 = (state_58170[(2)]);
var state_58170__$1 = state_58170;
var statearr_58176_58209 = state_58170__$1;
(statearr_58176_58209[(2)] = inst_58166);

(statearr_58176_58209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (13))){
var inst_58159 = cljs.core.async.close_BANG_.call(null,out);
var state_58170__$1 = state_58170;
var statearr_58177_58210 = state_58170__$1;
(statearr_58177_58210[(2)] = inst_58159);

(statearr_58177_58210[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (6))){
var state_58170__$1 = state_58170;
var statearr_58178_58211 = state_58170__$1;
(statearr_58178_58211[(2)] = null);

(statearr_58178_58211[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (3))){
var inst_58168 = (state_58170[(2)]);
var state_58170__$1 = state_58170;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58170__$1,inst_58168);
} else {
if((state_val_58171 === (12))){
var inst_58156 = (state_58170[(8)]);
var inst_58156__$1 = (state_58170[(2)]);
var inst_58157 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_58156__$1);
var state_58170__$1 = (function (){var statearr_58179 = state_58170;
(statearr_58179[(8)] = inst_58156__$1);

return statearr_58179;
})();
if(cljs.core.truth_(inst_58157)){
var statearr_58180_58212 = state_58170__$1;
(statearr_58180_58212[(1)] = (13));

} else {
var statearr_58181_58213 = state_58170__$1;
(statearr_58181_58213[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (2))){
var inst_58133 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_58134 = (0);
var state_58170__$1 = (function (){var statearr_58182 = state_58170;
(statearr_58182[(7)] = inst_58134);

(statearr_58182[(9)] = inst_58133);

return statearr_58182;
})();
var statearr_58183_58214 = state_58170__$1;
(statearr_58183_58214[(2)] = null);

(statearr_58183_58214[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (11))){
var inst_58134 = (state_58170[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_58170,(10),Object,null,(9));
var inst_58143 = chs__$1.call(null,inst_58134);
var inst_58144 = done.call(null,inst_58134);
var inst_58145 = cljs.core.async.take_BANG_.call(null,inst_58143,inst_58144);
var state_58170__$1 = state_58170;
var statearr_58184_58215 = state_58170__$1;
(statearr_58184_58215[(2)] = inst_58145);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58170__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (9))){
var inst_58134 = (state_58170[(7)]);
var inst_58147 = (state_58170[(2)]);
var inst_58148 = (inst_58134 + (1));
var inst_58134__$1 = inst_58148;
var state_58170__$1 = (function (){var statearr_58185 = state_58170;
(statearr_58185[(7)] = inst_58134__$1);

(statearr_58185[(10)] = inst_58147);

return statearr_58185;
})();
var statearr_58186_58216 = state_58170__$1;
(statearr_58186_58216[(2)] = null);

(statearr_58186_58216[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (5))){
var inst_58154 = (state_58170[(2)]);
var state_58170__$1 = (function (){var statearr_58187 = state_58170;
(statearr_58187[(11)] = inst_58154);

return statearr_58187;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58170__$1,(12),dchan);
} else {
if((state_val_58171 === (14))){
var inst_58156 = (state_58170[(8)]);
var inst_58161 = cljs.core.apply.call(null,f,inst_58156);
var state_58170__$1 = state_58170;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58170__$1,(16),out,inst_58161);
} else {
if((state_val_58171 === (16))){
var inst_58163 = (state_58170[(2)]);
var state_58170__$1 = (function (){var statearr_58188 = state_58170;
(statearr_58188[(12)] = inst_58163);

return statearr_58188;
})();
var statearr_58189_58217 = state_58170__$1;
(statearr_58189_58217[(2)] = null);

(statearr_58189_58217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (10))){
var inst_58138 = (state_58170[(2)]);
var inst_58139 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_58170__$1 = (function (){var statearr_58190 = state_58170;
(statearr_58190[(13)] = inst_58138);

return statearr_58190;
})();
var statearr_58191_58218 = state_58170__$1;
(statearr_58191_58218[(2)] = inst_58139);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58170__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58171 === (8))){
var inst_58152 = (state_58170[(2)]);
var state_58170__$1 = state_58170;
var statearr_58192_58219 = state_58170__$1;
(statearr_58192_58219[(2)] = inst_58152);

(statearr_58192_58219[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___58204,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__24077__auto__,c__24142__auto___58204,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_58196 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58196[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_58196[(1)] = (1));

return statearr_58196;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_58170){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_58170);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e58197){if((e58197 instanceof Object)){
var ex__24081__auto__ = e58197;
var statearr_58198_58220 = state_58170;
(statearr_58198_58220[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58170);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58197;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58221 = state_58170;
state_58170 = G__58221;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_58170){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_58170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___58204,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__24144__auto__ = (function (){var statearr_58199 = f__24143__auto__.call(null);
(statearr_58199[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___58204);

return statearr_58199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___58204,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var args58223 = [];
var len__19528__auto___58279 = arguments.length;
var i__19529__auto___58280 = (0);
while(true){
if((i__19529__auto___58280 < len__19528__auto___58279)){
args58223.push((arguments[i__19529__auto___58280]));

var G__58281 = (i__19529__auto___58280 + (1));
i__19529__auto___58280 = G__58281;
continue;
} else {
}
break;
}

var G__58225 = args58223.length;
switch (G__58225) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58223.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24142__auto___58283 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___58283,out){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___58283,out){
return (function (state_58255){
var state_val_58256 = (state_58255[(1)]);
if((state_val_58256 === (7))){
var inst_58235 = (state_58255[(7)]);
var inst_58234 = (state_58255[(8)]);
var inst_58234__$1 = (state_58255[(2)]);
var inst_58235__$1 = cljs.core.nth.call(null,inst_58234__$1,(0),null);
var inst_58236 = cljs.core.nth.call(null,inst_58234__$1,(1),null);
var inst_58237 = (inst_58235__$1 == null);
var state_58255__$1 = (function (){var statearr_58257 = state_58255;
(statearr_58257[(7)] = inst_58235__$1);

(statearr_58257[(9)] = inst_58236);

(statearr_58257[(8)] = inst_58234__$1);

return statearr_58257;
})();
if(cljs.core.truth_(inst_58237)){
var statearr_58258_58284 = state_58255__$1;
(statearr_58258_58284[(1)] = (8));

} else {
var statearr_58259_58285 = state_58255__$1;
(statearr_58259_58285[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58256 === (1))){
var inst_58226 = cljs.core.vec.call(null,chs);
var inst_58227 = inst_58226;
var state_58255__$1 = (function (){var statearr_58260 = state_58255;
(statearr_58260[(10)] = inst_58227);

return statearr_58260;
})();
var statearr_58261_58286 = state_58255__$1;
(statearr_58261_58286[(2)] = null);

(statearr_58261_58286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58256 === (4))){
var inst_58227 = (state_58255[(10)]);
var state_58255__$1 = state_58255;
return cljs.core.async.ioc_alts_BANG_.call(null,state_58255__$1,(7),inst_58227);
} else {
if((state_val_58256 === (6))){
var inst_58251 = (state_58255[(2)]);
var state_58255__$1 = state_58255;
var statearr_58262_58287 = state_58255__$1;
(statearr_58262_58287[(2)] = inst_58251);

(statearr_58262_58287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58256 === (3))){
var inst_58253 = (state_58255[(2)]);
var state_58255__$1 = state_58255;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58255__$1,inst_58253);
} else {
if((state_val_58256 === (2))){
var inst_58227 = (state_58255[(10)]);
var inst_58229 = cljs.core.count.call(null,inst_58227);
var inst_58230 = (inst_58229 > (0));
var state_58255__$1 = state_58255;
if(cljs.core.truth_(inst_58230)){
var statearr_58264_58288 = state_58255__$1;
(statearr_58264_58288[(1)] = (4));

} else {
var statearr_58265_58289 = state_58255__$1;
(statearr_58265_58289[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58256 === (11))){
var inst_58227 = (state_58255[(10)]);
var inst_58244 = (state_58255[(2)]);
var tmp58263 = inst_58227;
var inst_58227__$1 = tmp58263;
var state_58255__$1 = (function (){var statearr_58266 = state_58255;
(statearr_58266[(10)] = inst_58227__$1);

(statearr_58266[(11)] = inst_58244);

return statearr_58266;
})();
var statearr_58267_58290 = state_58255__$1;
(statearr_58267_58290[(2)] = null);

(statearr_58267_58290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58256 === (9))){
var inst_58235 = (state_58255[(7)]);
var state_58255__$1 = state_58255;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58255__$1,(11),out,inst_58235);
} else {
if((state_val_58256 === (5))){
var inst_58249 = cljs.core.async.close_BANG_.call(null,out);
var state_58255__$1 = state_58255;
var statearr_58268_58291 = state_58255__$1;
(statearr_58268_58291[(2)] = inst_58249);

(statearr_58268_58291[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58256 === (10))){
var inst_58247 = (state_58255[(2)]);
var state_58255__$1 = state_58255;
var statearr_58269_58292 = state_58255__$1;
(statearr_58269_58292[(2)] = inst_58247);

(statearr_58269_58292[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58256 === (8))){
var inst_58227 = (state_58255[(10)]);
var inst_58235 = (state_58255[(7)]);
var inst_58236 = (state_58255[(9)]);
var inst_58234 = (state_58255[(8)]);
var inst_58239 = (function (){var cs = inst_58227;
var vec__58232 = inst_58234;
var v = inst_58235;
var c = inst_58236;
return ((function (cs,vec__58232,v,c,inst_58227,inst_58235,inst_58236,inst_58234,state_val_58256,c__24142__auto___58283,out){
return (function (p1__58222_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__58222_SHARP_);
});
;})(cs,vec__58232,v,c,inst_58227,inst_58235,inst_58236,inst_58234,state_val_58256,c__24142__auto___58283,out))
})();
var inst_58240 = cljs.core.filterv.call(null,inst_58239,inst_58227);
var inst_58227__$1 = inst_58240;
var state_58255__$1 = (function (){var statearr_58270 = state_58255;
(statearr_58270[(10)] = inst_58227__$1);

return statearr_58270;
})();
var statearr_58271_58293 = state_58255__$1;
(statearr_58271_58293[(2)] = null);

(statearr_58271_58293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___58283,out))
;
return ((function (switch__24077__auto__,c__24142__auto___58283,out){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_58275 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58275[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_58275[(1)] = (1));

return statearr_58275;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_58255){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_58255);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e58276){if((e58276 instanceof Object)){
var ex__24081__auto__ = e58276;
var statearr_58277_58294 = state_58255;
(statearr_58277_58294[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58255);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58276;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58295 = state_58255;
state_58255 = G__58295;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_58255){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_58255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___58283,out))
})();
var state__24144__auto__ = (function (){var statearr_58278 = f__24143__auto__.call(null);
(statearr_58278[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___58283);

return statearr_58278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___58283,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var args58296 = [];
var len__19528__auto___58345 = arguments.length;
var i__19529__auto___58346 = (0);
while(true){
if((i__19529__auto___58346 < len__19528__auto___58345)){
args58296.push((arguments[i__19529__auto___58346]));

var G__58347 = (i__19529__auto___58346 + (1));
i__19529__auto___58346 = G__58347;
continue;
} else {
}
break;
}

var G__58298 = args58296.length;
switch (G__58298) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58296.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24142__auto___58349 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___58349,out){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___58349,out){
return (function (state_58322){
var state_val_58323 = (state_58322[(1)]);
if((state_val_58323 === (7))){
var inst_58304 = (state_58322[(7)]);
var inst_58304__$1 = (state_58322[(2)]);
var inst_58305 = (inst_58304__$1 == null);
var inst_58306 = cljs.core.not.call(null,inst_58305);
var state_58322__$1 = (function (){var statearr_58324 = state_58322;
(statearr_58324[(7)] = inst_58304__$1);

return statearr_58324;
})();
if(inst_58306){
var statearr_58325_58350 = state_58322__$1;
(statearr_58325_58350[(1)] = (8));

} else {
var statearr_58326_58351 = state_58322__$1;
(statearr_58326_58351[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58323 === (1))){
var inst_58299 = (0);
var state_58322__$1 = (function (){var statearr_58327 = state_58322;
(statearr_58327[(8)] = inst_58299);

return statearr_58327;
})();
var statearr_58328_58352 = state_58322__$1;
(statearr_58328_58352[(2)] = null);

(statearr_58328_58352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58323 === (4))){
var state_58322__$1 = state_58322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58322__$1,(7),ch);
} else {
if((state_val_58323 === (6))){
var inst_58317 = (state_58322[(2)]);
var state_58322__$1 = state_58322;
var statearr_58329_58353 = state_58322__$1;
(statearr_58329_58353[(2)] = inst_58317);

(statearr_58329_58353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58323 === (3))){
var inst_58319 = (state_58322[(2)]);
var inst_58320 = cljs.core.async.close_BANG_.call(null,out);
var state_58322__$1 = (function (){var statearr_58330 = state_58322;
(statearr_58330[(9)] = inst_58319);

return statearr_58330;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58322__$1,inst_58320);
} else {
if((state_val_58323 === (2))){
var inst_58299 = (state_58322[(8)]);
var inst_58301 = (inst_58299 < n);
var state_58322__$1 = state_58322;
if(cljs.core.truth_(inst_58301)){
var statearr_58331_58354 = state_58322__$1;
(statearr_58331_58354[(1)] = (4));

} else {
var statearr_58332_58355 = state_58322__$1;
(statearr_58332_58355[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58323 === (11))){
var inst_58299 = (state_58322[(8)]);
var inst_58309 = (state_58322[(2)]);
var inst_58310 = (inst_58299 + (1));
var inst_58299__$1 = inst_58310;
var state_58322__$1 = (function (){var statearr_58333 = state_58322;
(statearr_58333[(10)] = inst_58309);

(statearr_58333[(8)] = inst_58299__$1);

return statearr_58333;
})();
var statearr_58334_58356 = state_58322__$1;
(statearr_58334_58356[(2)] = null);

(statearr_58334_58356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58323 === (9))){
var state_58322__$1 = state_58322;
var statearr_58335_58357 = state_58322__$1;
(statearr_58335_58357[(2)] = null);

(statearr_58335_58357[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58323 === (5))){
var state_58322__$1 = state_58322;
var statearr_58336_58358 = state_58322__$1;
(statearr_58336_58358[(2)] = null);

(statearr_58336_58358[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58323 === (10))){
var inst_58314 = (state_58322[(2)]);
var state_58322__$1 = state_58322;
var statearr_58337_58359 = state_58322__$1;
(statearr_58337_58359[(2)] = inst_58314);

(statearr_58337_58359[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58323 === (8))){
var inst_58304 = (state_58322[(7)]);
var state_58322__$1 = state_58322;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58322__$1,(11),out,inst_58304);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___58349,out))
;
return ((function (switch__24077__auto__,c__24142__auto___58349,out){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_58341 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_58341[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_58341[(1)] = (1));

return statearr_58341;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_58322){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_58322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e58342){if((e58342 instanceof Object)){
var ex__24081__auto__ = e58342;
var statearr_58343_58360 = state_58322;
(statearr_58343_58360[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58322);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58342;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58361 = state_58322;
state_58322 = G__58361;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_58322){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_58322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___58349,out))
})();
var state__24144__auto__ = (function (){var statearr_58344 = f__24143__auto__.call(null);
(statearr_58344[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___58349);

return statearr_58344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___58349,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t58369 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t58369 = (function (map_LT_,f,ch,meta58370){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta58370 = meta58370;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t58369.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_58371,meta58370__$1){
var self__ = this;
var _58371__$1 = this;
return (new cljs.core.async.t58369(self__.map_LT_,self__.f,self__.ch,meta58370__$1));
});

cljs.core.async.t58369.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_58371){
var self__ = this;
var _58371__$1 = this;
return self__.meta58370;
});

cljs.core.async.t58369.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t58369.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t58369.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t58369.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t58369.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t58372 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t58372 = (function (map_LT_,f,ch,meta58370,_,fn1,meta58373){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta58370 = meta58370;
this._ = _;
this.fn1 = fn1;
this.meta58373 = meta58373;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t58372.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_58374,meta58373__$1){
var self__ = this;
var _58374__$1 = this;
return (new cljs.core.async.t58372(self__.map_LT_,self__.f,self__.ch,self__.meta58370,self__._,self__.fn1,meta58373__$1));
});})(___$1))
;

cljs.core.async.t58372.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_58374){
var self__ = this;
var _58374__$1 = this;
return self__.meta58373;
});})(___$1))
;

cljs.core.async.t58372.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t58372.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t58372.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__58362_SHARP_){
return f1.call(null,(((p1__58362_SHARP_ == null))?null:self__.f.call(null,p1__58362_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t58372.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta58370","meta58370",-1813645528,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t58369","cljs.core.async/t58369",-1856072222,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta58373","meta58373",-1278699856,null)], null);
});})(___$1))
;

cljs.core.async.t58372.cljs$lang$type = true;

cljs.core.async.t58372.cljs$lang$ctorStr = "cljs.core.async/t58372";

cljs.core.async.t58372.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t58372");
});})(___$1))
;

cljs.core.async.__GT_t58372 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t58372(map_LT___$1,f__$1,ch__$1,meta58370__$1,___$2,fn1__$1,meta58373){
return (new cljs.core.async.t58372(map_LT___$1,f__$1,ch__$1,meta58370__$1,___$2,fn1__$1,meta58373));
});})(___$1))
;

}

return (new cljs.core.async.t58372(self__.map_LT_,self__.f,self__.ch,self__.meta58370,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__18477__auto__ = ret;
if(cljs.core.truth_(and__18477__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__18477__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t58369.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t58369.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t58369.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta58370","meta58370",-1813645528,null)], null);
});

cljs.core.async.t58369.cljs$lang$type = true;

cljs.core.async.t58369.cljs$lang$ctorStr = "cljs.core.async/t58369";

cljs.core.async.t58369.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t58369");
});

cljs.core.async.__GT_t58369 = (function cljs$core$async$map_LT__$___GT_t58369(map_LT___$1,f__$1,ch__$1,meta58370){
return (new cljs.core.async.t58369(map_LT___$1,f__$1,ch__$1,meta58370));
});

}

return (new cljs.core.async.t58369(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t58378 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t58378 = (function (map_GT_,f,ch,meta58379){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta58379 = meta58379;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t58378.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_58380,meta58379__$1){
var self__ = this;
var _58380__$1 = this;
return (new cljs.core.async.t58378(self__.map_GT_,self__.f,self__.ch,meta58379__$1));
});

cljs.core.async.t58378.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_58380){
var self__ = this;
var _58380__$1 = this;
return self__.meta58379;
});

cljs.core.async.t58378.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t58378.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t58378.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t58378.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t58378.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t58378.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t58378.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta58379","meta58379",2100889298,null)], null);
});

cljs.core.async.t58378.cljs$lang$type = true;

cljs.core.async.t58378.cljs$lang$ctorStr = "cljs.core.async/t58378";

cljs.core.async.t58378.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t58378");
});

cljs.core.async.__GT_t58378 = (function cljs$core$async$map_GT__$___GT_t58378(map_GT___$1,f__$1,ch__$1,meta58379){
return (new cljs.core.async.t58378(map_GT___$1,f__$1,ch__$1,meta58379));
});

}

return (new cljs.core.async.t58378(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t58384 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t58384 = (function (filter_GT_,p,ch,meta58385){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta58385 = meta58385;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t58384.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_58386,meta58385__$1){
var self__ = this;
var _58386__$1 = this;
return (new cljs.core.async.t58384(self__.filter_GT_,self__.p,self__.ch,meta58385__$1));
});

cljs.core.async.t58384.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_58386){
var self__ = this;
var _58386__$1 = this;
return self__.meta58385;
});

cljs.core.async.t58384.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t58384.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t58384.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t58384.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t58384.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t58384.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t58384.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t58384.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta58385","meta58385",272823330,null)], null);
});

cljs.core.async.t58384.cljs$lang$type = true;

cljs.core.async.t58384.cljs$lang$ctorStr = "cljs.core.async/t58384";

cljs.core.async.t58384.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"cljs.core.async/t58384");
});

cljs.core.async.__GT_t58384 = (function cljs$core$async$filter_GT__$___GT_t58384(filter_GT___$1,p__$1,ch__$1,meta58385){
return (new cljs.core.async.t58384(filter_GT___$1,p__$1,ch__$1,meta58385));
});

}

return (new cljs.core.async.t58384(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var args58387 = [];
var len__19528__auto___58431 = arguments.length;
var i__19529__auto___58432 = (0);
while(true){
if((i__19529__auto___58432 < len__19528__auto___58431)){
args58387.push((arguments[i__19529__auto___58432]));

var G__58433 = (i__19529__auto___58432 + (1));
i__19529__auto___58432 = G__58433;
continue;
} else {
}
break;
}

var G__58389 = args58387.length;
switch (G__58389) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58387.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24142__auto___58435 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___58435,out){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___58435,out){
return (function (state_58410){
var state_val_58411 = (state_58410[(1)]);
if((state_val_58411 === (7))){
var inst_58406 = (state_58410[(2)]);
var state_58410__$1 = state_58410;
var statearr_58412_58436 = state_58410__$1;
(statearr_58412_58436[(2)] = inst_58406);

(statearr_58412_58436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58411 === (1))){
var state_58410__$1 = state_58410;
var statearr_58413_58437 = state_58410__$1;
(statearr_58413_58437[(2)] = null);

(statearr_58413_58437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58411 === (4))){
var inst_58392 = (state_58410[(7)]);
var inst_58392__$1 = (state_58410[(2)]);
var inst_58393 = (inst_58392__$1 == null);
var state_58410__$1 = (function (){var statearr_58414 = state_58410;
(statearr_58414[(7)] = inst_58392__$1);

return statearr_58414;
})();
if(cljs.core.truth_(inst_58393)){
var statearr_58415_58438 = state_58410__$1;
(statearr_58415_58438[(1)] = (5));

} else {
var statearr_58416_58439 = state_58410__$1;
(statearr_58416_58439[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58411 === (6))){
var inst_58392 = (state_58410[(7)]);
var inst_58397 = p.call(null,inst_58392);
var state_58410__$1 = state_58410;
if(cljs.core.truth_(inst_58397)){
var statearr_58417_58440 = state_58410__$1;
(statearr_58417_58440[(1)] = (8));

} else {
var statearr_58418_58441 = state_58410__$1;
(statearr_58418_58441[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58411 === (3))){
var inst_58408 = (state_58410[(2)]);
var state_58410__$1 = state_58410;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58410__$1,inst_58408);
} else {
if((state_val_58411 === (2))){
var state_58410__$1 = state_58410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58410__$1,(4),ch);
} else {
if((state_val_58411 === (11))){
var inst_58400 = (state_58410[(2)]);
var state_58410__$1 = state_58410;
var statearr_58419_58442 = state_58410__$1;
(statearr_58419_58442[(2)] = inst_58400);

(statearr_58419_58442[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58411 === (9))){
var state_58410__$1 = state_58410;
var statearr_58420_58443 = state_58410__$1;
(statearr_58420_58443[(2)] = null);

(statearr_58420_58443[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58411 === (5))){
var inst_58395 = cljs.core.async.close_BANG_.call(null,out);
var state_58410__$1 = state_58410;
var statearr_58421_58444 = state_58410__$1;
(statearr_58421_58444[(2)] = inst_58395);

(statearr_58421_58444[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58411 === (10))){
var inst_58403 = (state_58410[(2)]);
var state_58410__$1 = (function (){var statearr_58422 = state_58410;
(statearr_58422[(8)] = inst_58403);

return statearr_58422;
})();
var statearr_58423_58445 = state_58410__$1;
(statearr_58423_58445[(2)] = null);

(statearr_58423_58445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58411 === (8))){
var inst_58392 = (state_58410[(7)]);
var state_58410__$1 = state_58410;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58410__$1,(11),out,inst_58392);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___58435,out))
;
return ((function (switch__24077__auto__,c__24142__auto___58435,out){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_58427 = [null,null,null,null,null,null,null,null,null];
(statearr_58427[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_58427[(1)] = (1));

return statearr_58427;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_58410){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_58410);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e58428){if((e58428 instanceof Object)){
var ex__24081__auto__ = e58428;
var statearr_58429_58446 = state_58410;
(statearr_58429_58446[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58410);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58428;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58447 = state_58410;
state_58410 = G__58447;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_58410){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_58410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___58435,out))
})();
var state__24144__auto__ = (function (){var statearr_58430 = f__24143__auto__.call(null);
(statearr_58430[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___58435);

return statearr_58430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___58435,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var args58448 = [];
var len__19528__auto___58451 = arguments.length;
var i__19529__auto___58452 = (0);
while(true){
if((i__19529__auto___58452 < len__19528__auto___58451)){
args58448.push((arguments[i__19529__auto___58452]));

var G__58453 = (i__19529__auto___58452 + (1));
i__19529__auto___58452 = G__58453;
continue;
} else {
}
break;
}

var G__58450 = args58448.length;
switch (G__58450) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58448.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__24142__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto__){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto__){
return (function (state_58620){
var state_val_58621 = (state_58620[(1)]);
if((state_val_58621 === (7))){
var inst_58616 = (state_58620[(2)]);
var state_58620__$1 = state_58620;
var statearr_58622_58663 = state_58620__$1;
(statearr_58622_58663[(2)] = inst_58616);

(statearr_58622_58663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (20))){
var inst_58586 = (state_58620[(7)]);
var inst_58597 = (state_58620[(2)]);
var inst_58598 = cljs.core.next.call(null,inst_58586);
var inst_58572 = inst_58598;
var inst_58573 = null;
var inst_58574 = (0);
var inst_58575 = (0);
var state_58620__$1 = (function (){var statearr_58623 = state_58620;
(statearr_58623[(8)] = inst_58575);

(statearr_58623[(9)] = inst_58597);

(statearr_58623[(10)] = inst_58573);

(statearr_58623[(11)] = inst_58572);

(statearr_58623[(12)] = inst_58574);

return statearr_58623;
})();
var statearr_58624_58664 = state_58620__$1;
(statearr_58624_58664[(2)] = null);

(statearr_58624_58664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (1))){
var state_58620__$1 = state_58620;
var statearr_58625_58665 = state_58620__$1;
(statearr_58625_58665[(2)] = null);

(statearr_58625_58665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (4))){
var inst_58561 = (state_58620[(13)]);
var inst_58561__$1 = (state_58620[(2)]);
var inst_58562 = (inst_58561__$1 == null);
var state_58620__$1 = (function (){var statearr_58626 = state_58620;
(statearr_58626[(13)] = inst_58561__$1);

return statearr_58626;
})();
if(cljs.core.truth_(inst_58562)){
var statearr_58627_58666 = state_58620__$1;
(statearr_58627_58666[(1)] = (5));

} else {
var statearr_58628_58667 = state_58620__$1;
(statearr_58628_58667[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (15))){
var state_58620__$1 = state_58620;
var statearr_58632_58668 = state_58620__$1;
(statearr_58632_58668[(2)] = null);

(statearr_58632_58668[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (21))){
var state_58620__$1 = state_58620;
var statearr_58633_58669 = state_58620__$1;
(statearr_58633_58669[(2)] = null);

(statearr_58633_58669[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (13))){
var inst_58575 = (state_58620[(8)]);
var inst_58573 = (state_58620[(10)]);
var inst_58572 = (state_58620[(11)]);
var inst_58574 = (state_58620[(12)]);
var inst_58582 = (state_58620[(2)]);
var inst_58583 = (inst_58575 + (1));
var tmp58629 = inst_58573;
var tmp58630 = inst_58572;
var tmp58631 = inst_58574;
var inst_58572__$1 = tmp58630;
var inst_58573__$1 = tmp58629;
var inst_58574__$1 = tmp58631;
var inst_58575__$1 = inst_58583;
var state_58620__$1 = (function (){var statearr_58634 = state_58620;
(statearr_58634[(14)] = inst_58582);

(statearr_58634[(8)] = inst_58575__$1);

(statearr_58634[(10)] = inst_58573__$1);

(statearr_58634[(11)] = inst_58572__$1);

(statearr_58634[(12)] = inst_58574__$1);

return statearr_58634;
})();
var statearr_58635_58670 = state_58620__$1;
(statearr_58635_58670[(2)] = null);

(statearr_58635_58670[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (22))){
var state_58620__$1 = state_58620;
var statearr_58636_58671 = state_58620__$1;
(statearr_58636_58671[(2)] = null);

(statearr_58636_58671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (6))){
var inst_58561 = (state_58620[(13)]);
var inst_58570 = f.call(null,inst_58561);
var inst_58571 = cljs.core.seq.call(null,inst_58570);
var inst_58572 = inst_58571;
var inst_58573 = null;
var inst_58574 = (0);
var inst_58575 = (0);
var state_58620__$1 = (function (){var statearr_58637 = state_58620;
(statearr_58637[(8)] = inst_58575);

(statearr_58637[(10)] = inst_58573);

(statearr_58637[(11)] = inst_58572);

(statearr_58637[(12)] = inst_58574);

return statearr_58637;
})();
var statearr_58638_58672 = state_58620__$1;
(statearr_58638_58672[(2)] = null);

(statearr_58638_58672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (17))){
var inst_58586 = (state_58620[(7)]);
var inst_58590 = cljs.core.chunk_first.call(null,inst_58586);
var inst_58591 = cljs.core.chunk_rest.call(null,inst_58586);
var inst_58592 = cljs.core.count.call(null,inst_58590);
var inst_58572 = inst_58591;
var inst_58573 = inst_58590;
var inst_58574 = inst_58592;
var inst_58575 = (0);
var state_58620__$1 = (function (){var statearr_58639 = state_58620;
(statearr_58639[(8)] = inst_58575);

(statearr_58639[(10)] = inst_58573);

(statearr_58639[(11)] = inst_58572);

(statearr_58639[(12)] = inst_58574);

return statearr_58639;
})();
var statearr_58640_58673 = state_58620__$1;
(statearr_58640_58673[(2)] = null);

(statearr_58640_58673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (3))){
var inst_58618 = (state_58620[(2)]);
var state_58620__$1 = state_58620;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58620__$1,inst_58618);
} else {
if((state_val_58621 === (12))){
var inst_58606 = (state_58620[(2)]);
var state_58620__$1 = state_58620;
var statearr_58641_58674 = state_58620__$1;
(statearr_58641_58674[(2)] = inst_58606);

(statearr_58641_58674[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (2))){
var state_58620__$1 = state_58620;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58620__$1,(4),in$);
} else {
if((state_val_58621 === (23))){
var inst_58614 = (state_58620[(2)]);
var state_58620__$1 = state_58620;
var statearr_58642_58675 = state_58620__$1;
(statearr_58642_58675[(2)] = inst_58614);

(statearr_58642_58675[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (19))){
var inst_58601 = (state_58620[(2)]);
var state_58620__$1 = state_58620;
var statearr_58643_58676 = state_58620__$1;
(statearr_58643_58676[(2)] = inst_58601);

(statearr_58643_58676[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (11))){
var inst_58586 = (state_58620[(7)]);
var inst_58572 = (state_58620[(11)]);
var inst_58586__$1 = cljs.core.seq.call(null,inst_58572);
var state_58620__$1 = (function (){var statearr_58644 = state_58620;
(statearr_58644[(7)] = inst_58586__$1);

return statearr_58644;
})();
if(inst_58586__$1){
var statearr_58645_58677 = state_58620__$1;
(statearr_58645_58677[(1)] = (14));

} else {
var statearr_58646_58678 = state_58620__$1;
(statearr_58646_58678[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (9))){
var inst_58608 = (state_58620[(2)]);
var inst_58609 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_58620__$1 = (function (){var statearr_58647 = state_58620;
(statearr_58647[(15)] = inst_58608);

return statearr_58647;
})();
if(cljs.core.truth_(inst_58609)){
var statearr_58648_58679 = state_58620__$1;
(statearr_58648_58679[(1)] = (21));

} else {
var statearr_58649_58680 = state_58620__$1;
(statearr_58649_58680[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (5))){
var inst_58564 = cljs.core.async.close_BANG_.call(null,out);
var state_58620__$1 = state_58620;
var statearr_58650_58681 = state_58620__$1;
(statearr_58650_58681[(2)] = inst_58564);

(statearr_58650_58681[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (14))){
var inst_58586 = (state_58620[(7)]);
var inst_58588 = cljs.core.chunked_seq_QMARK_.call(null,inst_58586);
var state_58620__$1 = state_58620;
if(inst_58588){
var statearr_58651_58682 = state_58620__$1;
(statearr_58651_58682[(1)] = (17));

} else {
var statearr_58652_58683 = state_58620__$1;
(statearr_58652_58683[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (16))){
var inst_58604 = (state_58620[(2)]);
var state_58620__$1 = state_58620;
var statearr_58653_58684 = state_58620__$1;
(statearr_58653_58684[(2)] = inst_58604);

(statearr_58653_58684[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58621 === (10))){
var inst_58575 = (state_58620[(8)]);
var inst_58573 = (state_58620[(10)]);
var inst_58580 = cljs.core._nth.call(null,inst_58573,inst_58575);
var state_58620__$1 = state_58620;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58620__$1,(13),out,inst_58580);
} else {
if((state_val_58621 === (18))){
var inst_58586 = (state_58620[(7)]);
var inst_58595 = cljs.core.first.call(null,inst_58586);
var state_58620__$1 = state_58620;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58620__$1,(20),out,inst_58595);
} else {
if((state_val_58621 === (8))){
var inst_58575 = (state_58620[(8)]);
var inst_58574 = (state_58620[(12)]);
var inst_58577 = (inst_58575 < inst_58574);
var inst_58578 = inst_58577;
var state_58620__$1 = state_58620;
if(cljs.core.truth_(inst_58578)){
var statearr_58654_58685 = state_58620__$1;
(statearr_58654_58685[(1)] = (10));

} else {
var statearr_58655_58686 = state_58620__$1;
(statearr_58655_58686[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto__))
;
return ((function (switch__24077__auto__,c__24142__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__24078__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__24078__auto____0 = (function (){
var statearr_58659 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58659[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__24078__auto__);

(statearr_58659[(1)] = (1));

return statearr_58659;
});
var cljs$core$async$mapcat_STAR__$_state_machine__24078__auto____1 = (function (state_58620){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_58620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e58660){if((e58660 instanceof Object)){
var ex__24081__auto__ = e58660;
var statearr_58661_58687 = state_58620;
(statearr_58661_58687[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58620);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58660;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58688 = state_58620;
state_58620 = G__58688;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__24078__auto__ = function(state_58620){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__24078__auto____1.call(this,state_58620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__24078__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__24078__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto__))
})();
var state__24144__auto__ = (function (){var statearr_58662 = f__24143__auto__.call(null);
(statearr_58662[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto__);

return statearr_58662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto__))
);

return c__24142__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var args58689 = [];
var len__19528__auto___58692 = arguments.length;
var i__19529__auto___58693 = (0);
while(true){
if((i__19529__auto___58693 < len__19528__auto___58692)){
args58689.push((arguments[i__19529__auto___58693]));

var G__58694 = (i__19529__auto___58693 + (1));
i__19529__auto___58693 = G__58694;
continue;
} else {
}
break;
}

var G__58691 = args58689.length;
switch (G__58691) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58689.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var args58696 = [];
var len__19528__auto___58699 = arguments.length;
var i__19529__auto___58700 = (0);
while(true){
if((i__19529__auto___58700 < len__19528__auto___58699)){
args58696.push((arguments[i__19529__auto___58700]));

var G__58701 = (i__19529__auto___58700 + (1));
i__19529__auto___58700 = G__58701;
continue;
} else {
}
break;
}

var G__58698 = args58696.length;
switch (G__58698) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58696.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var args58703 = [];
var len__19528__auto___58754 = arguments.length;
var i__19529__auto___58755 = (0);
while(true){
if((i__19529__auto___58755 < len__19528__auto___58754)){
args58703.push((arguments[i__19529__auto___58755]));

var G__58756 = (i__19529__auto___58755 + (1));
i__19529__auto___58755 = G__58756;
continue;
} else {
}
break;
}

var G__58705 = args58703.length;
switch (G__58705) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58703.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24142__auto___58758 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___58758,out){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___58758,out){
return (function (state_58729){
var state_val_58730 = (state_58729[(1)]);
if((state_val_58730 === (7))){
var inst_58724 = (state_58729[(2)]);
var state_58729__$1 = state_58729;
var statearr_58731_58759 = state_58729__$1;
(statearr_58731_58759[(2)] = inst_58724);

(statearr_58731_58759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58730 === (1))){
var inst_58706 = null;
var state_58729__$1 = (function (){var statearr_58732 = state_58729;
(statearr_58732[(7)] = inst_58706);

return statearr_58732;
})();
var statearr_58733_58760 = state_58729__$1;
(statearr_58733_58760[(2)] = null);

(statearr_58733_58760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58730 === (4))){
var inst_58709 = (state_58729[(8)]);
var inst_58709__$1 = (state_58729[(2)]);
var inst_58710 = (inst_58709__$1 == null);
var inst_58711 = cljs.core.not.call(null,inst_58710);
var state_58729__$1 = (function (){var statearr_58734 = state_58729;
(statearr_58734[(8)] = inst_58709__$1);

return statearr_58734;
})();
if(inst_58711){
var statearr_58735_58761 = state_58729__$1;
(statearr_58735_58761[(1)] = (5));

} else {
var statearr_58736_58762 = state_58729__$1;
(statearr_58736_58762[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58730 === (6))){
var state_58729__$1 = state_58729;
var statearr_58737_58763 = state_58729__$1;
(statearr_58737_58763[(2)] = null);

(statearr_58737_58763[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58730 === (3))){
var inst_58726 = (state_58729[(2)]);
var inst_58727 = cljs.core.async.close_BANG_.call(null,out);
var state_58729__$1 = (function (){var statearr_58738 = state_58729;
(statearr_58738[(9)] = inst_58726);

return statearr_58738;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58729__$1,inst_58727);
} else {
if((state_val_58730 === (2))){
var state_58729__$1 = state_58729;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58729__$1,(4),ch);
} else {
if((state_val_58730 === (11))){
var inst_58709 = (state_58729[(8)]);
var inst_58718 = (state_58729[(2)]);
var inst_58706 = inst_58709;
var state_58729__$1 = (function (){var statearr_58739 = state_58729;
(statearr_58739[(7)] = inst_58706);

(statearr_58739[(10)] = inst_58718);

return statearr_58739;
})();
var statearr_58740_58764 = state_58729__$1;
(statearr_58740_58764[(2)] = null);

(statearr_58740_58764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58730 === (9))){
var inst_58709 = (state_58729[(8)]);
var state_58729__$1 = state_58729;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58729__$1,(11),out,inst_58709);
} else {
if((state_val_58730 === (5))){
var inst_58706 = (state_58729[(7)]);
var inst_58709 = (state_58729[(8)]);
var inst_58713 = cljs.core._EQ_.call(null,inst_58709,inst_58706);
var state_58729__$1 = state_58729;
if(inst_58713){
var statearr_58742_58765 = state_58729__$1;
(statearr_58742_58765[(1)] = (8));

} else {
var statearr_58743_58766 = state_58729__$1;
(statearr_58743_58766[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58730 === (10))){
var inst_58721 = (state_58729[(2)]);
var state_58729__$1 = state_58729;
var statearr_58744_58767 = state_58729__$1;
(statearr_58744_58767[(2)] = inst_58721);

(statearr_58744_58767[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58730 === (8))){
var inst_58706 = (state_58729[(7)]);
var tmp58741 = inst_58706;
var inst_58706__$1 = tmp58741;
var state_58729__$1 = (function (){var statearr_58745 = state_58729;
(statearr_58745[(7)] = inst_58706__$1);

return statearr_58745;
})();
var statearr_58746_58768 = state_58729__$1;
(statearr_58746_58768[(2)] = null);

(statearr_58746_58768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___58758,out))
;
return ((function (switch__24077__auto__,c__24142__auto___58758,out){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_58750 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_58750[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_58750[(1)] = (1));

return statearr_58750;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_58729){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_58729);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e58751){if((e58751 instanceof Object)){
var ex__24081__auto__ = e58751;
var statearr_58752_58769 = state_58729;
(statearr_58752_58769[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58729);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58751;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58770 = state_58729;
state_58729 = G__58770;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_58729){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_58729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___58758,out))
})();
var state__24144__auto__ = (function (){var statearr_58753 = f__24143__auto__.call(null);
(statearr_58753[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___58758);

return statearr_58753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___58758,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var args58771 = [];
var len__19528__auto___58841 = arguments.length;
var i__19529__auto___58842 = (0);
while(true){
if((i__19529__auto___58842 < len__19528__auto___58841)){
args58771.push((arguments[i__19529__auto___58842]));

var G__58843 = (i__19529__auto___58842 + (1));
i__19529__auto___58842 = G__58843;
continue;
} else {
}
break;
}

var G__58773 = args58771.length;
switch (G__58773) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58771.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24142__auto___58845 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___58845,out){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___58845,out){
return (function (state_58811){
var state_val_58812 = (state_58811[(1)]);
if((state_val_58812 === (7))){
var inst_58807 = (state_58811[(2)]);
var state_58811__$1 = state_58811;
var statearr_58813_58846 = state_58811__$1;
(statearr_58813_58846[(2)] = inst_58807);

(statearr_58813_58846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58812 === (1))){
var inst_58774 = (new Array(n));
var inst_58775 = inst_58774;
var inst_58776 = (0);
var state_58811__$1 = (function (){var statearr_58814 = state_58811;
(statearr_58814[(7)] = inst_58776);

(statearr_58814[(8)] = inst_58775);

return statearr_58814;
})();
var statearr_58815_58847 = state_58811__$1;
(statearr_58815_58847[(2)] = null);

(statearr_58815_58847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58812 === (4))){
var inst_58779 = (state_58811[(9)]);
var inst_58779__$1 = (state_58811[(2)]);
var inst_58780 = (inst_58779__$1 == null);
var inst_58781 = cljs.core.not.call(null,inst_58780);
var state_58811__$1 = (function (){var statearr_58816 = state_58811;
(statearr_58816[(9)] = inst_58779__$1);

return statearr_58816;
})();
if(inst_58781){
var statearr_58817_58848 = state_58811__$1;
(statearr_58817_58848[(1)] = (5));

} else {
var statearr_58818_58849 = state_58811__$1;
(statearr_58818_58849[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58812 === (15))){
var inst_58801 = (state_58811[(2)]);
var state_58811__$1 = state_58811;
var statearr_58819_58850 = state_58811__$1;
(statearr_58819_58850[(2)] = inst_58801);

(statearr_58819_58850[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58812 === (13))){
var state_58811__$1 = state_58811;
var statearr_58820_58851 = state_58811__$1;
(statearr_58820_58851[(2)] = null);

(statearr_58820_58851[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58812 === (6))){
var inst_58776 = (state_58811[(7)]);
var inst_58797 = (inst_58776 > (0));
var state_58811__$1 = state_58811;
if(cljs.core.truth_(inst_58797)){
var statearr_58821_58852 = state_58811__$1;
(statearr_58821_58852[(1)] = (12));

} else {
var statearr_58822_58853 = state_58811__$1;
(statearr_58822_58853[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58812 === (3))){
var inst_58809 = (state_58811[(2)]);
var state_58811__$1 = state_58811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58811__$1,inst_58809);
} else {
if((state_val_58812 === (12))){
var inst_58775 = (state_58811[(8)]);
var inst_58799 = cljs.core.vec.call(null,inst_58775);
var state_58811__$1 = state_58811;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58811__$1,(15),out,inst_58799);
} else {
if((state_val_58812 === (2))){
var state_58811__$1 = state_58811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58811__$1,(4),ch);
} else {
if((state_val_58812 === (11))){
var inst_58791 = (state_58811[(2)]);
var inst_58792 = (new Array(n));
var inst_58775 = inst_58792;
var inst_58776 = (0);
var state_58811__$1 = (function (){var statearr_58823 = state_58811;
(statearr_58823[(7)] = inst_58776);

(statearr_58823[(10)] = inst_58791);

(statearr_58823[(8)] = inst_58775);

return statearr_58823;
})();
var statearr_58824_58854 = state_58811__$1;
(statearr_58824_58854[(2)] = null);

(statearr_58824_58854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58812 === (9))){
var inst_58775 = (state_58811[(8)]);
var inst_58789 = cljs.core.vec.call(null,inst_58775);
var state_58811__$1 = state_58811;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58811__$1,(11),out,inst_58789);
} else {
if((state_val_58812 === (5))){
var inst_58776 = (state_58811[(7)]);
var inst_58775 = (state_58811[(8)]);
var inst_58779 = (state_58811[(9)]);
var inst_58784 = (state_58811[(11)]);
var inst_58783 = (inst_58775[inst_58776] = inst_58779);
var inst_58784__$1 = (inst_58776 + (1));
var inst_58785 = (inst_58784__$1 < n);
var state_58811__$1 = (function (){var statearr_58825 = state_58811;
(statearr_58825[(12)] = inst_58783);

(statearr_58825[(11)] = inst_58784__$1);

return statearr_58825;
})();
if(cljs.core.truth_(inst_58785)){
var statearr_58826_58855 = state_58811__$1;
(statearr_58826_58855[(1)] = (8));

} else {
var statearr_58827_58856 = state_58811__$1;
(statearr_58827_58856[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58812 === (14))){
var inst_58804 = (state_58811[(2)]);
var inst_58805 = cljs.core.async.close_BANG_.call(null,out);
var state_58811__$1 = (function (){var statearr_58829 = state_58811;
(statearr_58829[(13)] = inst_58804);

return statearr_58829;
})();
var statearr_58830_58857 = state_58811__$1;
(statearr_58830_58857[(2)] = inst_58805);

(statearr_58830_58857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58812 === (10))){
var inst_58795 = (state_58811[(2)]);
var state_58811__$1 = state_58811;
var statearr_58831_58858 = state_58811__$1;
(statearr_58831_58858[(2)] = inst_58795);

(statearr_58831_58858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58812 === (8))){
var inst_58775 = (state_58811[(8)]);
var inst_58784 = (state_58811[(11)]);
var tmp58828 = inst_58775;
var inst_58775__$1 = tmp58828;
var inst_58776 = inst_58784;
var state_58811__$1 = (function (){var statearr_58832 = state_58811;
(statearr_58832[(7)] = inst_58776);

(statearr_58832[(8)] = inst_58775__$1);

return statearr_58832;
})();
var statearr_58833_58859 = state_58811__$1;
(statearr_58833_58859[(2)] = null);

(statearr_58833_58859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___58845,out))
;
return ((function (switch__24077__auto__,c__24142__auto___58845,out){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_58837 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58837[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_58837[(1)] = (1));

return statearr_58837;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_58811){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_58811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e58838){if((e58838 instanceof Object)){
var ex__24081__auto__ = e58838;
var statearr_58839_58860 = state_58811;
(statearr_58839_58860[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58811);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58838;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58861 = state_58811;
state_58811 = G__58861;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_58811){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_58811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___58845,out))
})();
var state__24144__auto__ = (function (){var statearr_58840 = f__24143__auto__.call(null);
(statearr_58840[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___58845);

return statearr_58840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___58845,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var args58862 = [];
var len__19528__auto___58936 = arguments.length;
var i__19529__auto___58937 = (0);
while(true){
if((i__19529__auto___58937 < len__19528__auto___58936)){
args58862.push((arguments[i__19529__auto___58937]));

var G__58938 = (i__19529__auto___58937 + (1));
i__19529__auto___58937 = G__58938;
continue;
} else {
}
break;
}

var G__58864 = args58862.length;
switch (G__58864) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args58862.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24142__auto___58940 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___58940,out){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___58940,out){
return (function (state_58906){
var state_val_58907 = (state_58906[(1)]);
if((state_val_58907 === (7))){
var inst_58902 = (state_58906[(2)]);
var state_58906__$1 = state_58906;
var statearr_58908_58941 = state_58906__$1;
(statearr_58908_58941[(2)] = inst_58902);

(statearr_58908_58941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58907 === (1))){
var inst_58865 = [];
var inst_58866 = inst_58865;
var inst_58867 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_58906__$1 = (function (){var statearr_58909 = state_58906;
(statearr_58909[(7)] = inst_58867);

(statearr_58909[(8)] = inst_58866);

return statearr_58909;
})();
var statearr_58910_58942 = state_58906__$1;
(statearr_58910_58942[(2)] = null);

(statearr_58910_58942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58907 === (4))){
var inst_58870 = (state_58906[(9)]);
var inst_58870__$1 = (state_58906[(2)]);
var inst_58871 = (inst_58870__$1 == null);
var inst_58872 = cljs.core.not.call(null,inst_58871);
var state_58906__$1 = (function (){var statearr_58911 = state_58906;
(statearr_58911[(9)] = inst_58870__$1);

return statearr_58911;
})();
if(inst_58872){
var statearr_58912_58943 = state_58906__$1;
(statearr_58912_58943[(1)] = (5));

} else {
var statearr_58913_58944 = state_58906__$1;
(statearr_58913_58944[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58907 === (15))){
var inst_58896 = (state_58906[(2)]);
var state_58906__$1 = state_58906;
var statearr_58914_58945 = state_58906__$1;
(statearr_58914_58945[(2)] = inst_58896);

(statearr_58914_58945[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58907 === (13))){
var state_58906__$1 = state_58906;
var statearr_58915_58946 = state_58906__$1;
(statearr_58915_58946[(2)] = null);

(statearr_58915_58946[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58907 === (6))){
var inst_58866 = (state_58906[(8)]);
var inst_58891 = inst_58866.length;
var inst_58892 = (inst_58891 > (0));
var state_58906__$1 = state_58906;
if(cljs.core.truth_(inst_58892)){
var statearr_58916_58947 = state_58906__$1;
(statearr_58916_58947[(1)] = (12));

} else {
var statearr_58917_58948 = state_58906__$1;
(statearr_58917_58948[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58907 === (3))){
var inst_58904 = (state_58906[(2)]);
var state_58906__$1 = state_58906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58906__$1,inst_58904);
} else {
if((state_val_58907 === (12))){
var inst_58866 = (state_58906[(8)]);
var inst_58894 = cljs.core.vec.call(null,inst_58866);
var state_58906__$1 = state_58906;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58906__$1,(15),out,inst_58894);
} else {
if((state_val_58907 === (2))){
var state_58906__$1 = state_58906;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58906__$1,(4),ch);
} else {
if((state_val_58907 === (11))){
var inst_58874 = (state_58906[(10)]);
var inst_58870 = (state_58906[(9)]);
var inst_58884 = (state_58906[(2)]);
var inst_58885 = [];
var inst_58886 = inst_58885.push(inst_58870);
var inst_58866 = inst_58885;
var inst_58867 = inst_58874;
var state_58906__$1 = (function (){var statearr_58918 = state_58906;
(statearr_58918[(7)] = inst_58867);

(statearr_58918[(11)] = inst_58886);

(statearr_58918[(8)] = inst_58866);

(statearr_58918[(12)] = inst_58884);

return statearr_58918;
})();
var statearr_58919_58949 = state_58906__$1;
(statearr_58919_58949[(2)] = null);

(statearr_58919_58949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58907 === (9))){
var inst_58866 = (state_58906[(8)]);
var inst_58882 = cljs.core.vec.call(null,inst_58866);
var state_58906__$1 = state_58906;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58906__$1,(11),out,inst_58882);
} else {
if((state_val_58907 === (5))){
var inst_58874 = (state_58906[(10)]);
var inst_58867 = (state_58906[(7)]);
var inst_58870 = (state_58906[(9)]);
var inst_58874__$1 = f.call(null,inst_58870);
var inst_58875 = cljs.core._EQ_.call(null,inst_58874__$1,inst_58867);
var inst_58876 = cljs.core.keyword_identical_QMARK_.call(null,inst_58867,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_58877 = (inst_58875) || (inst_58876);
var state_58906__$1 = (function (){var statearr_58920 = state_58906;
(statearr_58920[(10)] = inst_58874__$1);

return statearr_58920;
})();
if(cljs.core.truth_(inst_58877)){
var statearr_58921_58950 = state_58906__$1;
(statearr_58921_58950[(1)] = (8));

} else {
var statearr_58922_58951 = state_58906__$1;
(statearr_58922_58951[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58907 === (14))){
var inst_58899 = (state_58906[(2)]);
var inst_58900 = cljs.core.async.close_BANG_.call(null,out);
var state_58906__$1 = (function (){var statearr_58924 = state_58906;
(statearr_58924[(13)] = inst_58899);

return statearr_58924;
})();
var statearr_58925_58952 = state_58906__$1;
(statearr_58925_58952[(2)] = inst_58900);

(statearr_58925_58952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58907 === (10))){
var inst_58889 = (state_58906[(2)]);
var state_58906__$1 = state_58906;
var statearr_58926_58953 = state_58906__$1;
(statearr_58926_58953[(2)] = inst_58889);

(statearr_58926_58953[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58907 === (8))){
var inst_58874 = (state_58906[(10)]);
var inst_58870 = (state_58906[(9)]);
var inst_58866 = (state_58906[(8)]);
var inst_58879 = inst_58866.push(inst_58870);
var tmp58923 = inst_58866;
var inst_58866__$1 = tmp58923;
var inst_58867 = inst_58874;
var state_58906__$1 = (function (){var statearr_58927 = state_58906;
(statearr_58927[(14)] = inst_58879);

(statearr_58927[(7)] = inst_58867);

(statearr_58927[(8)] = inst_58866__$1);

return statearr_58927;
})();
var statearr_58928_58954 = state_58906__$1;
(statearr_58928_58954[(2)] = null);

(statearr_58928_58954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto___58940,out))
;
return ((function (switch__24077__auto__,c__24142__auto___58940,out){
return (function() {
var cljs$core$async$state_machine__24078__auto__ = null;
var cljs$core$async$state_machine__24078__auto____0 = (function (){
var statearr_58932 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58932[(0)] = cljs$core$async$state_machine__24078__auto__);

(statearr_58932[(1)] = (1));

return statearr_58932;
});
var cljs$core$async$state_machine__24078__auto____1 = (function (state_58906){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_58906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e58933){if((e58933 instanceof Object)){
var ex__24081__auto__ = e58933;
var statearr_58934_58955 = state_58906;
(statearr_58934_58955[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58906);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58933;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58956 = state_58906;
state_58906 = G__58956;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
cljs$core$async$state_machine__24078__auto__ = function(state_58906){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24078__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24078__auto____1.call(this,state_58906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24078__auto____0;
cljs$core$async$state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24078__auto____1;
return cljs$core$async$state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___58940,out))
})();
var state__24144__auto__ = (function (){var statearr_58935 = f__24143__auto__.call(null);
(statearr_58935[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___58940);

return statearr_58935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___58940,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map