// Compiled by ClojureScript 1.7.48 {}
goog.provide('dragonmark.inputs.validation');
goog.require('cljs.core');
goog.require('dragonmark.inputs.schemas');
goog.require('schema.core');
goog.require('dragonmark.inputs.date_utils');
goog.require('jkkramer.verily');
goog.require('schema.coerce');
goog.require('clojure.set');
goog.require('dragonmark.inputs.extern');
goog.require('clojure.string');
/**
 * The validation error message keys for a field.
 * The key is not the rule key but the message key.
 */
dragonmark.inputs.validation.sch_errors_list = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.named.call(null,schema.core.Keyword,"message")], null);
/**
 * Describes the input's error data structure.
 * A field can have multiples errors.
 */
dragonmark.inputs.validation.sch_errors = new cljs.core.PersistentArrayMap.fromArray([dragonmark.inputs.schemas.sch_field,dragonmark.inputs.validation.sch_errors_list], true, false);
/**
 * Describes the Verily errors data structure.
 */
dragonmark.inputs.validation.sch_verily_errs = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dragonmark.inputs.schemas.sch_field], null),new cljs.core.Keyword(null,"msg","msg",-1386103444),schema.core.Keyword], null)], null);
/**
 * Describes the Schema errors data structure
 */
dragonmark.inputs.validation.sch_schema_errs = new cljs.core.PersistentArrayMap.fromArray([dragonmark.inputs.schemas.sch_field,schema.core.Any], true, false);
/**
 * Do not validate an empty string as a valid s/Str
 */
dragonmark.inputs.validation.empty_string_coercer = (function dragonmark$inputs$validation$empty_string_coercer(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return s;
}
});
/**
 * Coerce an input string to a date.
 * The default format is used.
 * A blank string is coerced to nil.
 */
dragonmark.inputs.validation.inst_coercer = (function dragonmark$inputs$validation$inst_coercer(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return dragonmark.inputs.date_utils.parse.call(null,dragonmark.inputs.date_utils.fmt.call(null,dragonmark.inputs.date_utils.default_fmt,s));
}
});
/**
 * Schema coercers used for inputs that are sent as string.
 */
dragonmark.inputs.validation.validation_coercer = new cljs.core.PersistentArrayMap.fromArray([schema.core.Num,schema.coerce.safe.call(null,schema.coerce.edn_read_string),schema.core.Regex,dragonmark.inputs.validation.empty_string_coercer,schema.core.Str,dragonmark.inputs.validation.empty_string_coercer,schema.core.maybe.call(null,schema.core.Str),dragonmark.inputs.validation.empty_string_coercer,schema.core.Inst,dragonmark.inputs.validation.inst_coercer], true, false);
/**
 * Generic sequence of validation.
 * The first args can be partially applied to generate a custom validator.
 */
dragonmark.inputs.validation.validate = (function dragonmark$inputs$validation$validate(validation_fn,post,m){
return post.call(null,validation_fn.call(null,m));
});
var ufv___53632 = schema.utils.use_fn_validation;
var output_schema53611_53633 = dragonmark.inputs.validation.sch_errors;
var input_schema53612_53634 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.validation.sch_schema_errs,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-schema-errs","sch-schema-errs",1633294259,null)], null)))], null);
var input_checker53613_53635 = schema.core.checker.call(null,input_schema53612_53634);
var output_checker53614_53636 = schema.core.checker.call(null,output_schema53611_53633);
/**
 * Inputs: [errs :- sch-schema-errs]
 * Returns: sch-errors
 * 
 * Transforms the Schema's error data structure into the common error data structure.
 * For the moment Schema error are treated as missing field.
 */
dragonmark.inputs.validation.transform_schema_errors = ((function (ufv___53632,output_schema53611_53633,input_schema53612_53634,input_checker53613_53635,output_checker53614_53636){
return (function dragonmark$inputs$validation$transform_schema_errors(G__53615){
var validate__21152__auto__ = ufv___53632.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53637 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53615], null);
var temp__4425__auto___53638 = input_checker53613_53635.call(null,args__21153__auto___53637);
if(cljs.core.truth_(temp__4425__auto___53638)){
var error__21154__auto___53639 = temp__4425__auto___53638;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-schema-errors","transform-schema-errors",1319365661,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Schema's error data structure into the common error data structure.\n  For the moment Schema error are treated as missing field."], null)),cljs.core.pr_str.call(null,error__21154__auto___53639)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53612_53634,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53637,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53639], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var errs = G__53615;
while(true){
var temp__4425__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(errs);
if(cljs.core.truth_(temp__4425__auto__)){
var errors = temp__4425__auto__;
return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.concat,(function (){var iter__19242__auto__ = ((function (errors,temp__4425__auto__,validate__21152__auto__,ufv___53632,output_schema53611_53633,input_schema53612_53634,input_checker53613_53635,output_checker53614_53636){
return (function dragonmark$inputs$validation$transform_schema_errors_$_iter__53624(s__53625){
return (new cljs.core.LazySeq(null,((function (errors,temp__4425__auto__,validate__21152__auto__,ufv___53632,output_schema53611_53633,input_schema53612_53634,input_checker53613_53635,output_checker53614_53636){
return (function (){
var s__53625__$1 = s__53625;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__53625__$1);
if(temp__4425__auto____$1){
var s__53625__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__53625__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__53625__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__53627 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__53626 = (0);
while(true){
if((i__53626 < size__19241__auto__)){
var vec__53630 = cljs.core._nth.call(null,c__19240__auto__,i__53626);
var k = cljs.core.nth.call(null,vec__53630,(0),null);
var _ = cljs.core.nth.call(null,vec__53630,(1),null);
cljs.core.chunk_append.call(null,b__53627,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mandatory","mandatory",542802336)], null)], true, false));

var G__53640 = (i__53626 + (1));
i__53626 = G__53640;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53627),dragonmark$inputs$validation$transform_schema_errors_$_iter__53624.call(null,cljs.core.chunk_rest.call(null,s__53625__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53627),null);
}
} else {
var vec__53631 = cljs.core.first.call(null,s__53625__$2);
var k = cljs.core.nth.call(null,vec__53631,(0),null);
var _ = cljs.core.nth.call(null,vec__53631,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mandatory","mandatory",542802336)], null)], true, false),dragonmark$inputs$validation$transform_schema_errors_$_iter__53624.call(null,cljs.core.rest.call(null,s__53625__$2)));
}
} else {
return null;
}
break;
}
});})(errors,temp__4425__auto__,validate__21152__auto__,ufv___53632,output_schema53611_53633,input_schema53612_53634,input_checker53613_53635,output_checker53614_53636))
,null,null));
});})(errors,temp__4425__auto__,validate__21152__auto__,ufv___53632,output_schema53611_53633,input_schema53612_53634,input_checker53613_53635,output_checker53614_53636))
;
return iter__19242__auto__.call(null,errors);
})());
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53641 = output_checker53614_53636.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53641)){
var error__21154__auto___53642 = temp__4425__auto___53641;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-schema-errors","transform-schema-errors",1319365661,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Schema's error data structure into the common error data structure.\n  For the moment Schema error are treated as missing field."], null)),cljs.core.pr_str.call(null,error__21154__auto___53642)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53611_53633,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53642], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53632,output_schema53611_53633,input_schema53612_53634,input_checker53613_53635,output_checker53614_53636))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.transform_schema_errors),schema.core.make_fn_schema.call(null,output_schema53611_53633,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53612_53634], null)));
var ufv___53668 = schema.utils.use_fn_validation;
var output_schema53643_53669 = dragonmark.inputs.validation.sch_errors;
var input_schema53644_53670 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.validation.sch_verily_errs,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-verily-errs","sch-verily-errs",-1962614795,null)], null)))], null);
var input_checker53645_53671 = schema.core.checker.call(null,input_schema53644_53670);
var output_checker53646_53672 = schema.core.checker.call(null,output_schema53643_53669);
/**
 * Inputs: [errs :- sch-verily-errs]
 * Returns: sch-errors
 * 
 * Transforms the Verily's error data structure into the common error data structure.
 */
dragonmark.inputs.validation.transform_verily_errors = ((function (ufv___53668,output_schema53643_53669,input_schema53644_53670,input_checker53645_53671,output_checker53646_53672){
return (function dragonmark$inputs$validation$transform_verily_errors(G__53647){
var validate__21152__auto__ = ufv___53668.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53673 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53647], null);
var temp__4425__auto___53674 = input_checker53645_53671.call(null,args__21153__auto___53673);
if(cljs.core.truth_(temp__4425__auto___53674)){
var error__21154__auto___53675 = temp__4425__auto___53674;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-verily-errors","transform-verily-errors",-197737448,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Verily's error data structure into the common error data structure."], null)),cljs.core.pr_str.call(null,error__21154__auto___53675)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53644_53670,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53673,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53675], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var errs = G__53647;
while(true){
if(cljs.core.seq.call(null,errs)){
return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.concat,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21152__auto__,ufv___53668,output_schema53643_53669,input_schema53644_53670,input_checker53645_53671,output_checker53646_53672){
return (function dragonmark$inputs$validation$transform_verily_errors_$_iter__53658(s__53659){
return (new cljs.core.LazySeq(null,((function (validate__21152__auto__,ufv___53668,output_schema53643_53669,input_schema53644_53670,input_checker53645_53671,output_checker53646_53672){
return (function (){
var s__53659__$1 = s__53659;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__53659__$1);
if(temp__4425__auto__){
var xs__4977__auto__ = temp__4425__auto__;
var map__53666 = cljs.core.first.call(null,xs__4977__auto__);
var map__53666__$1 = ((((!((map__53666 == null)))?((((map__53666.cljs$lang$protocol_mask$partition0$ & (64))) || (map__53666.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53666):map__53666);
var keys = cljs.core.get.call(null,map__53666__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var msg = cljs.core.get.call(null,map__53666__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var iterys__19238__auto__ = ((function (s__53659__$1,map__53666,map__53666__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21152__auto__,ufv___53668,output_schema53643_53669,input_schema53644_53670,input_checker53645_53671,output_checker53646_53672){
return (function dragonmark$inputs$validation$transform_verily_errors_$_iter__53658_$_iter__53660(s__53661){
return (new cljs.core.LazySeq(null,((function (s__53659__$1,map__53666,map__53666__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21152__auto__,ufv___53668,output_schema53643_53669,input_schema53644_53670,input_checker53645_53671,output_checker53646_53672){
return (function (){
var s__53661__$1 = s__53661;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__53661__$1);
if(temp__4425__auto____$1){
var s__53661__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__53661__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__53661__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__53663 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__53662 = (0);
while(true){
if((i__53662 < size__19241__auto__)){
var k = cljs.core._nth.call(null,c__19240__auto__,i__53662);
cljs.core.chunk_append.call(null,b__53663,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null)], true, false));

var G__53676 = (i__53662 + (1));
i__53662 = G__53676;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53663),dragonmark$inputs$validation$transform_verily_errors_$_iter__53658_$_iter__53660.call(null,cljs.core.chunk_rest.call(null,s__53661__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53663),null);
}
} else {
var k = cljs.core.first.call(null,s__53661__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null)], true, false),dragonmark$inputs$validation$transform_verily_errors_$_iter__53658_$_iter__53660.call(null,cljs.core.rest.call(null,s__53661__$2)));
}
} else {
return null;
}
break;
}
});})(s__53659__$1,map__53666,map__53666__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21152__auto__,ufv___53668,output_schema53643_53669,input_schema53644_53670,input_checker53645_53671,output_checker53646_53672))
,null,null));
});})(s__53659__$1,map__53666,map__53666__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__21152__auto__,ufv___53668,output_schema53643_53669,input_schema53644_53670,input_checker53645_53671,output_checker53646_53672))
;
var fs__19239__auto__ = cljs.core.seq.call(null,iterys__19238__auto__.call(null,keys));
if(fs__19239__auto__){
return cljs.core.concat.call(null,fs__19239__auto__,dragonmark$inputs$validation$transform_verily_errors_$_iter__53658.call(null,cljs.core.rest.call(null,s__53659__$1)));
} else {
var G__53677 = cljs.core.rest.call(null,s__53659__$1);
s__53659__$1 = G__53677;
continue;
}
} else {
return null;
}
break;
}
});})(validate__21152__auto__,ufv___53668,output_schema53643_53669,input_schema53644_53670,input_checker53645_53671,output_checker53646_53672))
,null,null));
});})(validate__21152__auto__,ufv___53668,output_schema53643_53669,input_schema53644_53670,input_checker53645_53671,output_checker53646_53672))
;
return iter__19242__auto__.call(null,errs);
})());
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53678 = output_checker53646_53672.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53678)){
var error__21154__auto___53679 = temp__4425__auto___53678;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-verily-errors","transform-verily-errors",-197737448,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Verily's error data structure into the common error data structure."], null)),cljs.core.pr_str.call(null,error__21154__auto___53679)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53643_53669,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53679], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53668,output_schema53643_53669,input_schema53644_53670,input_checker53645_53671,output_checker53646_53672))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.transform_verily_errors),schema.core.make_fn_schema.call(null,output_schema53643_53669,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53644_53670], null)));
dragonmark.inputs.validation.build_verily_validator = (function dragonmark$inputs$validation$build_verily_validator(rules){
return cljs.core.partial.call(null,dragonmark.inputs.validation.validate,jkkramer.verily.validations__GT_fn.call(null,rules),dragonmark.inputs.validation.transform_verily_errors);
});
dragonmark.inputs.validation.inter_fields_rules = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"lower-or-equal","lower-or-equal",-1150663190),null,new cljs.core.Keyword(null,"greater-or-equal","greater-or-equal",302221395),null,new cljs.core.Keyword(null,"lower","lower",1120320821),null,new cljs.core.Keyword(null,"greater","greater",1370260601),null,new cljs.core.Keyword(null,"equal","equal",-1921681350),null], null), null);
/**
 * Build the map error->rule
 */
dragonmark.inputs.validation.error__GT_rule = (function dragonmark$inputs$validation$error__GT_rule(rules){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = (function dragonmark$inputs$validation$error__GT_rule_$_iter__53684(s__53685){
return (new cljs.core.LazySeq(null,(function (){
var s__53685__$1 = s__53685;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__53685__$1);
if(temp__4425__auto__){
var s__53685__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__53685__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__53685__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__53687 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__53686 = (0);
while(true){
if((i__53686 < size__19241__auto__)){
var r = cljs.core._nth.call(null,c__19240__auto__,i__53686);
cljs.core.chunk_append.call(null,b__53687,cljs.core.juxt.call(null,cljs.core.last,cljs.core.first).call(null,r));

var G__53688 = (i__53686 + (1));
i__53686 = G__53688;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53687),dragonmark$inputs$validation$error__GT_rule_$_iter__53684.call(null,cljs.core.chunk_rest.call(null,s__53685__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53687),null);
}
} else {
var r = cljs.core.first.call(null,s__53685__$2);
return cljs.core.cons.call(null,cljs.core.juxt.call(null,cljs.core.last,cljs.core.first).call(null,r),dragonmark$inputs$validation$error__GT_rule_$_iter__53684.call(null,cljs.core.rest.call(null,s__53685__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,rules);
})());
});
/**
 * Determines validation dependencies between fields
 */
dragonmark.inputs.validation.fields_dependencies = (function dragonmark$inputs$validation$fields_dependencies(){
var args53689 = [];
var len__19528__auto___53704 = arguments.length;
var i__19529__auto___53705 = (0);
while(true){
if((i__19529__auto___53705 < len__19528__auto___53704)){
args53689.push((arguments[i__19529__auto___53705]));

var G__53706 = (i__19529__auto___53705 + (1));
i__19529__auto___53705 = G__53706;
continue;
} else {
}
break;
}

var G__53691 = args53689.length;
switch (G__53691) {
case 1:
return dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args53689.length)].join('')));

}
});

dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$1 = (function (rules){
return dragonmark.inputs.validation.fields_dependencies.call(null,dragonmark.inputs.validation.inter_fields_rules,rules);
});

dragonmark.inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$2 = (function (rule_keys,rules){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = (function dragonmark$inputs$validation$iter__53692(s__53693){
return (new cljs.core.LazySeq(null,(function (){
var s__53693__$1 = s__53693;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__53693__$1);
if(temp__4425__auto__){
var s__53693__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__53693__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__53693__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__53695 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__53694 = (0);
while(true){
if((i__53694 < size__19241__auto__)){
var vec__53700 = cljs.core._nth.call(null,c__19240__auto__,i__53694);
var r = cljs.core.nth.call(null,vec__53700,(0),null);
var fs = cljs.core.nth.call(null,vec__53700,(1),null);
var m = cljs.core.nth.call(null,vec__53700,(2),null);
if(cljs.core.truth_(rule_keys.call(null,r))){
var vec__53701 = fs;
var f = cljs.core.nth.call(null,vec__53701,(0),null);
var deps = cljs.core.nthnext.call(null,vec__53701,(1));
cljs.core.chunk_append.call(null,b__53695,new cljs.core.PersistentArrayMap.fromArray([f,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"deps","deps",1883360319),deps,new cljs.core.Keyword(null,"mess","mess",530922968),m,new cljs.core.Keyword(null,"rule","rule",729973257),r], null)], true, false));

var G__53708 = (i__53694 + (1));
i__53694 = G__53708;
continue;
} else {
var G__53709 = (i__53694 + (1));
i__53694 = G__53709;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53695),dragonmark$inputs$validation$iter__53692.call(null,cljs.core.chunk_rest.call(null,s__53693__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53695),null);
}
} else {
var vec__53702 = cljs.core.first.call(null,s__53693__$2);
var r = cljs.core.nth.call(null,vec__53702,(0),null);
var fs = cljs.core.nth.call(null,vec__53702,(1),null);
var m = cljs.core.nth.call(null,vec__53702,(2),null);
if(cljs.core.truth_(rule_keys.call(null,r))){
var vec__53703 = fs;
var f = cljs.core.nth.call(null,vec__53703,(0),null);
var deps = cljs.core.nthnext.call(null,vec__53703,(1));
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([f,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"deps","deps",1883360319),deps,new cljs.core.Keyword(null,"mess","mess",530922968),m,new cljs.core.Keyword(null,"rule","rule",729973257),r], null)], true, false),dragonmark$inputs$validation$iter__53692.call(null,cljs.core.rest.call(null,s__53693__$2)));
} else {
var G__53710 = cljs.core.rest.call(null,s__53693__$2);
s__53693__$1 = G__53710;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,rules);
})());
});

dragonmark.inputs.validation.fields_dependencies.cljs$lang$maxFixedArity = 2;
var ufv___53717 = schema.utils.use_fn_validation;
var output_schema53711_53718 = dragonmark.inputs.schemas.sch_business_state;
var input_schema53712_53719 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,dragonmark.inputs.validation.sch_errors,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null)], null)))], null);
var input_checker53713_53720 = schema.core.checker.call(null,input_schema53712_53719);
var output_checker53714_53721 = schema.core.checker.call(null,output_schema53711_53718);
/**
 * Inputs: [state :- sch-business-state errs :- sch-errors]
 * Returns: sch-business-state
 * 
 * Set valid to false for each key in errors, true if absent
 */
dragonmark.inputs.validation.handle_errors = ((function (ufv___53717,output_schema53711_53718,input_schema53712_53719,input_checker53713_53720,output_checker53714_53721){
return (function dragonmark$inputs$validation$handle_errors(G__53715,G__53716){
var validate__21152__auto__ = ufv___53717.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53722 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53715,G__53716], null);
var temp__4425__auto___53723 = input_checker53713_53720.call(null,args__21153__auto___53722);
if(cljs.core.truth_(temp__4425__auto___53723)){
var error__21154__auto___53724 = temp__4425__auto___53723;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"handle-errors","handle-errors",1833858829,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set valid to false for each key in errors, true if absent"], null)),cljs.core.pr_str.call(null,error__21154__auto___53724)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53712_53719,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53722,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53724], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var state = G__53715;
var errs = G__53716;
while(true){
var err_ks = cljs.core.set.call(null,cljs.core.keys.call(null,errs));
var all_ks = cljs.core.set.call(null,cljs.core.keys.call(null,state));
var valid_ks = clojure.set.difference.call(null,all_ks,err_ks);
var state__$1 = cljs.core.reduce.call(null,((function (err_ks,all_ks,valid_ks,validate__21152__auto__,ufv___53717,output_schema53711_53718,input_schema53712_53719,input_checker53713_53720,output_checker53714_53721){
return (function (s,e){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),false),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"error","error",-978969032)], null),e.call(null,errs));
});})(err_ks,all_ks,valid_ks,validate__21152__auto__,ufv___53717,output_schema53711_53718,input_schema53712_53719,input_checker53713_53720,output_checker53714_53721))
,state,err_ks);
return cljs.core.reduce.call(null,((function (err_ks,all_ks,valid_ks,state__$1,validate__21152__auto__,ufv___53717,output_schema53711_53718,input_schema53712_53719,input_checker53713_53720,output_checker53714_53721){
return (function (s,e){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [e], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
});})(err_ks,all_ks,valid_ks,state__$1,validate__21152__auto__,ufv___53717,output_schema53711_53718,input_schema53712_53719,input_checker53713_53720,output_checker53714_53721))
,state__$1,valid_ks);
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53725 = output_checker53714_53721.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53725)){
var error__21154__auto___53726 = temp__4425__auto___53725;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"handle-errors","handle-errors",1833858829,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set valid to false for each key in errors, true if absent"], null)),cljs.core.pr_str.call(null,error__21154__auto___53726)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53711_53718,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53726], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53717,output_schema53711_53718,input_schema53712_53719,input_checker53713_53720,output_checker53714_53721))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.handle_errors),schema.core.make_fn_schema.call(null,output_schema53711_53718,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53712_53719], null)));
var ufv___53748 = schema.utils.use_fn_validation;
var output_schema53727_53749 = dragonmark.inputs.schemas.sch_business_state;
var input_schema53728_53750 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker53729_53751 = schema.core.checker.call(null,input_schema53728_53750);
var output_checker53730_53752 = schema.core.checker.call(null,output_schema53727_53749);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.keep_fields_to_validate = ((function (ufv___53748,output_schema53727_53749,input_schema53728_53750,input_checker53729_53751,output_checker53730_53752){
return (function dragonmark$inputs$validation$keep_fields_to_validate(G__53731){
var validate__21152__auto__ = ufv___53748.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53753 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53731], null);
var temp__4425__auto___53754 = input_checker53729_53751.call(null,args__21153__auto___53753);
if(cljs.core.truth_(temp__4425__auto___53754)){
var error__21154__auto___53755 = temp__4425__auto___53754;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"keep-fields-to-validate","keep-fields-to-validate",943659297,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___53755)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53728_53750,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53753,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53755], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var bs = G__53731;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21152__auto__,ufv___53748,output_schema53727_53749,input_schema53728_53750,input_checker53729_53751,output_checker53730_53752){
return (function dragonmark$inputs$validation$keep_fields_to_validate_$_iter__53740(s__53741){
return (new cljs.core.LazySeq(null,((function (validate__21152__auto__,ufv___53748,output_schema53727_53749,input_schema53728_53750,input_checker53729_53751,output_checker53730_53752){
return (function (){
var s__53741__$1 = s__53741;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__53741__$1);
if(temp__4425__auto__){
var s__53741__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__53741__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__53741__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__53743 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__53742 = (0);
while(true){
if((i__53742 < size__19241__auto__)){
var vec__53746 = cljs.core._nth.call(null,c__19240__auto__,i__53742);
var k = cljs.core.nth.call(null,vec__53746,(0),null);
var m = cljs.core.nth.call(null,vec__53746,(1),null);
var in$ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m);
var req = new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__18489__auto__ = req;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,in$));
}
})())){
cljs.core.chunk_append.call(null,b__53743,new cljs.core.PersistentArrayMap.fromArray([k,m], true, false));

var G__53756 = (i__53742 + (1));
i__53742 = G__53756;
continue;
} else {
var G__53757 = (i__53742 + (1));
i__53742 = G__53757;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53743),dragonmark$inputs$validation$keep_fields_to_validate_$_iter__53740.call(null,cljs.core.chunk_rest.call(null,s__53741__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53743),null);
}
} else {
var vec__53747 = cljs.core.first.call(null,s__53741__$2);
var k = cljs.core.nth.call(null,vec__53747,(0),null);
var m = cljs.core.nth.call(null,vec__53747,(1),null);
var in$ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m);
var req = new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__18489__auto__ = req;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,in$));
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,m], true, false),dragonmark$inputs$validation$keep_fields_to_validate_$_iter__53740.call(null,cljs.core.rest.call(null,s__53741__$2)));
} else {
var G__53758 = cljs.core.rest.call(null,s__53741__$2);
s__53741__$1 = G__53758;
continue;
}
}
} else {
return null;
}
break;
}
});})(validate__21152__auto__,ufv___53748,output_schema53727_53749,input_schema53728_53750,input_checker53729_53751,output_checker53730_53752))
,null,null));
});})(validate__21152__auto__,ufv___53748,output_schema53727_53749,input_schema53728_53750,input_checker53729_53751,output_checker53730_53752))
;
return iter__19242__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53759 = output_checker53730_53752.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53759)){
var error__21154__auto___53760 = temp__4425__auto___53759;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"keep-fields-to-validate","keep-fields-to-validate",943659297,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___53760)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53727_53749,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53760], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53748,output_schema53727_53749,input_schema53728_53750,input_checker53729_53751,output_checker53730_53752))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.keep_fields_to_validate),schema.core.make_fn_schema.call(null,output_schema53727_53749,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53728_53750], null)));
var ufv___53767 = schema.utils.use_fn_validation;
var output_schema53761_53768 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema53762_53769 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"fk","fk",2038974178,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker53763_53770 = schema.core.checker.call(null,input_schema53762_53769);
var output_checker53764_53771 = schema.core.checker.call(null,output_schema53761_53768);
/**
 * Inputs: [bs :- sch-business-state fk :- s/Keyword]
 * Returns: {s/Keyword s/Any}
 * 
 * Extract map fk->value for a single field.
 */
dragonmark.inputs.validation.bs__GT_unit_map = ((function (ufv___53767,output_schema53761_53768,input_schema53762_53769,input_checker53763_53770,output_checker53764_53771){
return (function dragonmark$inputs$validation$bs__GT_unit_map(G__53765,G__53766){
var validate__21152__auto__ = ufv___53767.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53772 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53765,G__53766], null);
var temp__4425__auto___53773 = input_checker53763_53770.call(null,args__21153__auto___53772);
if(cljs.core.truth_(temp__4425__auto___53773)){
var error__21154__auto___53774 = temp__4425__auto___53773;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"bs->unit-map","bs->unit-map",827144882,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extract map fk->value for a single field."], null)),cljs.core.pr_str.call(null,error__21154__auto___53774)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53762_53769,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53772,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53774], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var bs = G__53765;
var fk = G__53766;
while(true){
var m = fk.call(null,bs);
return new cljs.core.PersistentArrayMap.fromArray([fk,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m)], true, false);
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53775 = output_checker53764_53771.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53775)){
var error__21154__auto___53776 = temp__4425__auto___53775;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"bs->unit-map","bs->unit-map",827144882,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extract map fk->value for a single field."], null)),cljs.core.pr_str.call(null,error__21154__auto___53776)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53761_53768,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53776], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53767,output_schema53761_53768,input_schema53762_53769,input_checker53763_53770,output_checker53764_53771))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.bs__GT_unit_map),schema.core.make_fn_schema.call(null,output_schema53761_53768,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53762_53769], null)));
var ufv___53798 = schema.utils.use_fn_validation;
var output_schema53777_53799 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema53778_53800 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker53779_53801 = schema.core.checker.call(null,input_schema53778_53800);
var output_checker53780_53802 = schema.core.checker.call(null,output_schema53777_53799);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: {s/Keyword s/Any}
 * 
 * Transform the business local state into final map
 */
dragonmark.inputs.validation.business_state__GT_map = ((function (ufv___53798,output_schema53777_53799,input_schema53778_53800,input_checker53779_53801,output_checker53780_53802){
return (function dragonmark$inputs$validation$business_state__GT_map(G__53781){
var validate__21152__auto__ = ufv___53798.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53803 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53781], null);
var temp__4425__auto___53804 = input_checker53779_53801.call(null,args__21153__auto___53803);
if(cljs.core.truth_(temp__4425__auto___53804)){
var error__21154__auto___53805 = temp__4425__auto___53804;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"business-state->map","business-state->map",1652123635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform the business local state into final map"], null)),cljs.core.pr_str.call(null,error__21154__auto___53805)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53778_53800,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53803,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53805], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var bs = G__53781;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21152__auto__,ufv___53798,output_schema53777_53799,input_schema53778_53800,input_checker53779_53801,output_checker53780_53802){
return (function dragonmark$inputs$validation$business_state__GT_map_$_iter__53790(s__53791){
return (new cljs.core.LazySeq(null,((function (validate__21152__auto__,ufv___53798,output_schema53777_53799,input_schema53778_53800,input_checker53779_53801,output_checker53780_53802){
return (function (){
var s__53791__$1 = s__53791;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__53791__$1);
if(temp__4425__auto__){
var s__53791__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__53791__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__53791__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__53793 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__53792 = (0);
while(true){
if((i__53792 < size__19241__auto__)){
var vec__53796 = cljs.core._nth.call(null,c__19240__auto__,i__53792);
var k = cljs.core.nth.call(null,vec__53796,(0),null);
var _ = cljs.core.nth.call(null,vec__53796,(1),null);
cljs.core.chunk_append.call(null,b__53793,dragonmark.inputs.validation.bs__GT_unit_map.call(null,bs,k));

var G__53806 = (i__53792 + (1));
i__53792 = G__53806;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53793),dragonmark$inputs$validation$business_state__GT_map_$_iter__53790.call(null,cljs.core.chunk_rest.call(null,s__53791__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53793),null);
}
} else {
var vec__53797 = cljs.core.first.call(null,s__53791__$2);
var k = cljs.core.nth.call(null,vec__53797,(0),null);
var _ = cljs.core.nth.call(null,vec__53797,(1),null);
return cljs.core.cons.call(null,dragonmark.inputs.validation.bs__GT_unit_map.call(null,bs,k),dragonmark$inputs$validation$business_state__GT_map_$_iter__53790.call(null,cljs.core.rest.call(null,s__53791__$2)));
}
} else {
return null;
}
break;
}
});})(validate__21152__auto__,ufv___53798,output_schema53777_53799,input_schema53778_53800,input_checker53779_53801,output_checker53780_53802))
,null,null));
});})(validate__21152__auto__,ufv___53798,output_schema53777_53799,input_schema53778_53800,input_checker53779_53801,output_checker53780_53802))
;
return iter__19242__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53807 = output_checker53780_53802.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53807)){
var error__21154__auto___53808 = temp__4425__auto___53807;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"business-state->map","business-state->map",1652123635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform the business local state into final map"], null)),cljs.core.pr_str.call(null,error__21154__auto___53808)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53777_53799,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53808], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53798,output_schema53777_53799,input_schema53778_53800,input_checker53779_53801,output_checker53780_53802))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.business_state__GT_map),schema.core.make_fn_schema.call(null,output_schema53777_53799,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53778_53800], null)));
var ufv___53814 = schema.utils.use_fn_validation;
var output_schema53809_53815 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema53810_53816 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker53811_53817 = schema.core.checker.call(null,input_schema53810_53816);
var output_checker53812_53818 = schema.core.checker.call(null,output_schema53809_53815);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: {s/Keyword s/Any}
 * 
 * Create the map that will be validated by the Schema :
 * Only keeps :
 * - required keys
 * - optional keys with non blank values
 */
dragonmark.inputs.validation.pre_validation = ((function (ufv___53814,output_schema53809_53815,input_schema53810_53816,input_checker53811_53817,output_checker53812_53818){
return (function dragonmark$inputs$validation$pre_validation(G__53813){
var validate__21152__auto__ = ufv___53814.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53819 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53813], null);
var temp__4425__auto___53820 = input_checker53811_53817.call(null,args__21153__auto___53819);
if(cljs.core.truth_(temp__4425__auto___53820)){
var error__21154__auto___53821 = temp__4425__auto___53820;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"pre-validation","pre-validation",731230710,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Create the map that will be validated by the Schema :\n  Only keeps :\n  - required keys\n  - optional keys with non blank values"], null)),cljs.core.pr_str.call(null,error__21154__auto___53821)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53810_53816,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53819,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53821], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var bs = G__53813;
while(true){
return dragonmark.inputs.validation.business_state__GT_map.call(null,dragonmark.inputs.validation.keep_fields_to_validate.call(null,bs));
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53822 = output_checker53812_53818.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53822)){
var error__21154__auto___53823 = temp__4425__auto___53822;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"pre-validation","pre-validation",731230710,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Create the map that will be validated by the Schema :\n  Only keeps :\n  - required keys\n  - optional keys with non blank values"], null)),cljs.core.pr_str.call(null,error__21154__auto___53823)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53809_53815,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53823], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53814,output_schema53809_53815,input_schema53810_53816,input_checker53811_53817,output_checker53812_53818))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.pre_validation),schema.core.make_fn_schema.call(null,output_schema53809_53815,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53810_53816], null)));
var ufv___53845 = schema.utils.use_fn_validation;
var output_schema53824_53846 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema53825_53847 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"sch","sch",763282093,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker53826_53848 = schema.core.checker.call(null,input_schema53825_53847);
var output_checker53827_53849 = schema.core.checker.call(null,output_schema53824_53846);
/**
 * Inputs: [sch]
 * Returns: {s/Keyword s/Any}
 * 
 * Transform a Schema into a map of key -> individual Schema
 */
dragonmark.inputs.validation.sch_glo__GT_unit = ((function (ufv___53845,output_schema53824_53846,input_schema53825_53847,input_checker53826_53848,output_checker53827_53849){
return (function dragonmark$inputs$validation$sch_glo__GT_unit(G__53828){
var validate__21152__auto__ = ufv___53845.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53850 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53828], null);
var temp__4425__auto___53851 = input_checker53826_53848.call(null,args__21153__auto___53850);
if(cljs.core.truth_(temp__4425__auto___53851)){
var error__21154__auto___53852 = temp__4425__auto___53851;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sch-glo->unit","sch-glo->unit",1717844533,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform a Schema into a map of key -> individual Schema"], null)),cljs.core.pr_str.call(null,error__21154__auto___53852)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53825_53847,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53850,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53852], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var sch = G__53828;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__21152__auto__,ufv___53845,output_schema53824_53846,input_schema53825_53847,input_checker53826_53848,output_checker53827_53849){
return (function dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__53837(s__53838){
return (new cljs.core.LazySeq(null,((function (validate__21152__auto__,ufv___53845,output_schema53824_53846,input_schema53825_53847,input_checker53826_53848,output_checker53827_53849){
return (function (){
var s__53838__$1 = s__53838;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__53838__$1);
if(temp__4425__auto__){
var s__53838__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__53838__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__53838__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__53840 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__53839 = (0);
while(true){
if((i__53839 < size__19241__auto__)){
var vec__53843 = cljs.core._nth.call(null,c__19240__auto__,i__53839);
var k = cljs.core.nth.call(null,vec__53843,(0),null);
var t = cljs.core.nth.call(null,vec__53843,(1),null);
cljs.core.chunk_append.call(null,b__53840,new cljs.core.PersistentArrayMap.fromArray([cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),new cljs.core.PersistentArrayMap.fromArray([k,t], true, false)], true, false));

var G__53853 = (i__53839 + (1));
i__53839 = G__53853;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53840),dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__53837.call(null,cljs.core.chunk_rest.call(null,s__53838__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53840),null);
}
} else {
var vec__53844 = cljs.core.first.call(null,s__53838__$2);
var k = cljs.core.nth.call(null,vec__53844,(0),null);
var t = cljs.core.nth.call(null,vec__53844,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),new cljs.core.PersistentArrayMap.fromArray([k,t], true, false)], true, false),dragonmark$inputs$validation$sch_glo__GT_unit_$_iter__53837.call(null,cljs.core.rest.call(null,s__53838__$2)));
}
} else {
return null;
}
break;
}
});})(validate__21152__auto__,ufv___53845,output_schema53824_53846,input_schema53825_53847,input_checker53826_53848,output_checker53827_53849))
,null,null));
});})(validate__21152__auto__,ufv___53845,output_schema53824_53846,input_schema53825_53847,input_checker53826_53848,output_checker53827_53849))
;
return iter__19242__auto__.call(null,sch);
})());
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53854 = output_checker53827_53849.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53854)){
var error__21154__auto___53855 = temp__4425__auto___53854;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sch-glo->unit","sch-glo->unit",1717844533,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform a Schema into a map of key -> individual Schema"], null)),cljs.core.pr_str.call(null,error__21154__auto___53855)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53824_53846,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53855], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53845,output_schema53824_53846,input_schema53825_53847,input_checker53826_53848,output_checker53827_53849))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.sch_glo__GT_unit),schema.core.make_fn_schema.call(null,output_schema53824_53846,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53825_53847], null)));
/**
 * Build the map of field -> coercer
 */
dragonmark.inputs.validation.build_unit_coercers = (function dragonmark$inputs$validation$build_unit_coercers(sch){
return cljs.core.apply.call(null,cljs.core.merge,(function (){var iter__19242__auto__ = (function dragonmark$inputs$validation$build_unit_coercers_$_iter__53864(s__53865){
return (new cljs.core.LazySeq(null,(function (){
var s__53865__$1 = s__53865;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__53865__$1);
if(temp__4425__auto__){
var s__53865__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__53865__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__53865__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__53867 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__53866 = (0);
while(true){
if((i__53866 < size__19241__auto__)){
var vec__53870 = cljs.core._nth.call(null,c__19240__auto__,i__53866);
var k = cljs.core.nth.call(null,vec__53870,(0),null);
var s = cljs.core.nth.call(null,vec__53870,(1),null);
cljs.core.chunk_append.call(null,b__53867,new cljs.core.PersistentArrayMap.fromArray([k,schema.coerce.coercer.call(null,s,dragonmark.inputs.validation.validation_coercer)], true, false));

var G__53872 = (i__53866 + (1));
i__53866 = G__53872;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53867),dragonmark$inputs$validation$build_unit_coercers_$_iter__53864.call(null,cljs.core.chunk_rest.call(null,s__53865__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53867),null);
}
} else {
var vec__53871 = cljs.core.first.call(null,s__53865__$2);
var k = cljs.core.nth.call(null,vec__53871,(0),null);
var s = cljs.core.nth.call(null,vec__53871,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,schema.coerce.coercer.call(null,s,dragonmark.inputs.validation.validation_coercer)], true, false),dragonmark$inputs$validation$build_unit_coercers_$_iter__53864.call(null,cljs.core.rest.call(null,s__53865__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,dragonmark.inputs.validation.sch_glo__GT_unit.call(null,sch));
})());
});
var ufv___53894 = schema.utils.use_fn_validation;
var output_schema53873_53895 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema53874_53896 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"unit-coercers","unit-coercers",-228543947,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_checker53875_53897 = schema.core.checker.call(null,input_schema53874_53896);
var output_checker53876_53898 = schema.core.checker.call(null,output_schema53873_53895);
/**
 * Inputs: [unit-coercers :- {s/Keyword s/Any}]
 * Returns: {s/Keyword s/Any}
 */
dragonmark.inputs.validation.unit_schema_validators = ((function (ufv___53894,output_schema53873_53895,input_schema53874_53896,input_checker53875_53897,output_checker53876_53898){
return (function dragonmark$inputs$validation$unit_schema_validators(G__53877){
var validate__21152__auto__ = true;
if(validate__21152__auto__){
var args__21153__auto___53899 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53877], null);
var temp__4425__auto___53900 = input_checker53875_53897.call(null,args__21153__auto___53899);
if(cljs.core.truth_(temp__4425__auto___53900)){
var error__21154__auto___53901 = temp__4425__auto___53900;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unit-schema-validators","unit-schema-validators",-690979832,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)),cljs.core.pr_str.call(null,error__21154__auto___53901)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53874_53896,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53899,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53901], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var unit_coercers = G__53877;
while(true){
return cljs.core.apply.call(null,cljs.core.merge,(function (){var iter__19242__auto__ = ((function (validate__21152__auto__,ufv___53894,output_schema53873_53895,input_schema53874_53896,input_checker53875_53897,output_checker53876_53898){
return (function dragonmark$inputs$validation$unit_schema_validators_$_iter__53886(s__53887){
return (new cljs.core.LazySeq(null,((function (validate__21152__auto__,ufv___53894,output_schema53873_53895,input_schema53874_53896,input_checker53875_53897,output_checker53876_53898){
return (function (){
var s__53887__$1 = s__53887;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__53887__$1);
if(temp__4425__auto__){
var s__53887__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__53887__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__53887__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__53889 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__53888 = (0);
while(true){
if((i__53888 < size__19241__auto__)){
var vec__53892 = cljs.core._nth.call(null,c__19240__auto__,i__53888);
var k = cljs.core.nth.call(null,vec__53892,(0),null);
var c = cljs.core.nth.call(null,vec__53892,(1),null);
cljs.core.chunk_append.call(null,b__53889,new cljs.core.PersistentArrayMap.fromArray([k,cljs.core.partial.call(null,dragonmark.inputs.validation.validate,c,dragonmark.inputs.validation.transform_schema_errors)], true, false));

var G__53902 = (i__53888 + (1));
i__53888 = G__53902;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53889),dragonmark$inputs$validation$unit_schema_validators_$_iter__53886.call(null,cljs.core.chunk_rest.call(null,s__53887__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53889),null);
}
} else {
var vec__53893 = cljs.core.first.call(null,s__53887__$2);
var k = cljs.core.nth.call(null,vec__53893,(0),null);
var c = cljs.core.nth.call(null,vec__53893,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,cljs.core.partial.call(null,dragonmark.inputs.validation.validate,c,dragonmark.inputs.validation.transform_schema_errors)], true, false),dragonmark$inputs$validation$unit_schema_validators_$_iter__53886.call(null,cljs.core.rest.call(null,s__53887__$2)));
}
} else {
return null;
}
break;
}
});})(validate__21152__auto__,ufv___53894,output_schema53873_53895,input_schema53874_53896,input_checker53875_53897,output_checker53876_53898))
,null,null));
});})(validate__21152__auto__,ufv___53894,output_schema53873_53895,input_schema53874_53896,input_checker53875_53897,output_checker53876_53898))
;
return iter__19242__auto__.call(null,unit_coercers);
})());
break;
}
})();
if(validate__21152__auto__){
var temp__4425__auto___53903 = output_checker53876_53898.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53903)){
var error__21154__auto___53904 = temp__4425__auto___53903;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unit-schema-validators","unit-schema-validators",-690979832,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)),cljs.core.pr_str.call(null,error__21154__auto___53904)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53873_53895,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53904], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53894,output_schema53873_53895,input_schema53874_53896,input_checker53875_53897,output_checker53876_53898))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.unit_schema_validators),schema.core.make_fn_schema.call(null,output_schema53873_53895,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53874_53896], null)));
var ufv___53914 = schema.utils.use_fn_validation;
var output_schema53905_53915 = schema.core.Bool;
var input_schema53906_53916 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_field_state,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-field-state","sch-field-state",-361453047,null)], null)))], null);
var input_checker53907_53917 = schema.core.checker.call(null,input_schema53906_53916);
var output_checker53908_53918 = schema.core.checker.call(null,output_schema53905_53915);
/**
 * Inputs: [s :- sch-field-state]
 * Returns: s/Bool
 * 
 * Indicates if a field must be validated :
 * - required field
 * - optional field with non blank values
 */
dragonmark.inputs.validation.validate_QMARK_ = ((function (ufv___53914,output_schema53905_53915,input_schema53906_53916,input_checker53907_53917,output_checker53908_53918){
return (function dragonmark$inputs$validation$validate_QMARK_(G__53909){
var validate__21152__auto__ = ufv___53914.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53919 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53909], null);
var temp__4425__auto___53920 = input_checker53907_53917.call(null,args__21153__auto___53919);
if(cljs.core.truth_(temp__4425__auto___53920)){
var error__21154__auto___53921 = temp__4425__auto___53920;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"validate?","validate?",1996759489,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Indicates if a field must be validated :\n  - required field\n  - optional field with non blank values"], null)),cljs.core.pr_str.call(null,error__21154__auto___53921)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53906_53916,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53919,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53921], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var s = G__53909;
while(true){
var map__53912 = s;
var map__53912__$1 = ((((!((map__53912 == null)))?((((map__53912.cljs$lang$protocol_mask$partition0$ & (64))) || (map__53912.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53912):map__53912);
var required = cljs.core.get.call(null,map__53912__$1,new cljs.core.Keyword(null,"required","required",1807647006));
var value = cljs.core.get.call(null,map__53912__$1,new cljs.core.Keyword(null,"value","value",305978217));
var or__18489__auto__ = required;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,value));
}
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53922 = output_checker53908_53918.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53922)){
var error__21154__auto___53923 = temp__4425__auto___53922;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"validate?","validate?",1996759489,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Indicates if a field must be validated :\n  - required field\n  - optional field with non blank values"], null)),cljs.core.pr_str.call(null,error__21154__auto___53923)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53905_53915,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53923], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53914,output_schema53905_53915,input_schema53906_53916,input_checker53907_53917,output_checker53908_53918))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.validate_QMARK_),schema.core.make_fn_schema.call(null,output_schema53905_53915,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53906_53916], null)));
var ufv___53930 = schema.utils.use_fn_validation;
var output_schema53924_53931 = dragonmark.inputs.schemas.sch_business_state;
var input_schema53925_53932 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,dragonmark.inputs.validation.sch_errors,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null)], null)))], null);
var input_checker53926_53933 = schema.core.checker.call(null,input_schema53925_53932);
var output_checker53927_53934 = schema.core.checker.call(null,output_schema53924_53931);
/**
 * Inputs: [state :- sch-business-state errs :- sch-errors]
 * Returns: sch-business-state
 * 
 * Handle errors for a single field
 */
dragonmark.inputs.validation.add_field_error = ((function (ufv___53930,output_schema53924_53931,input_schema53925_53932,input_checker53926_53933,output_checker53927_53934){
return (function dragonmark$inputs$validation$add_field_error(G__53928,G__53929){
var validate__21152__auto__ = ufv___53930.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53935 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53928,G__53929], null);
var temp__4425__auto___53936 = input_checker53926_53933.call(null,args__21153__auto___53935);
if(cljs.core.truth_(temp__4425__auto___53936)){
var error__21154__auto___53937 = temp__4425__auto___53936;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"add-field-error","add-field-error",-1753092209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Handle errors for a single field"], null)),cljs.core.pr_str.call(null,error__21154__auto___53937)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53925_53932,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53935,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53937], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var state = G__53928;
var errs = G__53929;
while(true){
return cljs.core.reduce.call(null,((function (validate__21152__auto__,ufv___53930,output_schema53924_53931,input_schema53925_53932,input_checker53926_53933,output_checker53927_53934){
return (function (s,e){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),false),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"error","error",-978969032)], null),e.call(null,errs));
});})(validate__21152__auto__,ufv___53930,output_schema53924_53931,input_schema53925_53932,input_checker53926_53933,output_checker53927_53934))
,state,cljs.core.keys.call(null,errs));
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53938 = output_checker53927_53934.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53938)){
var error__21154__auto___53939 = temp__4425__auto___53938;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"add-field-error","add-field-error",-1753092209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Handle errors for a single field"], null)),cljs.core.pr_str.call(null,error__21154__auto___53939)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53924_53931,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53939], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53930,output_schema53924_53931,input_schema53925_53932,input_checker53926_53933,output_checker53927_53934))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.add_field_error),schema.core.make_fn_schema.call(null,output_schema53924_53931,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53925_53932], null)));
dragonmark.inputs.validation.no_async_error_QMARK_ = (function dragonmark$inputs$validation$no_async_error_QMARK_(state,k){
var se = new cljs.core.Keyword(null,"async-error","async-error",528708636).cljs$core$IFn$_invoke$arity$1(k.call(null,state));
return cljs.core.boolean$.call(null,((se == null)) || (cljs.core.empty_QMARK_.call(null,se)));
});
var ufv___53946 = schema.utils.use_fn_validation;
var output_schema53940_53947 = dragonmark.inputs.schemas.sch_business_state;
var input_schema53941_53948 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker53942_53949 = schema.core.checker.call(null,input_schema53941_53948);
var output_checker53943_53950 = schema.core.checker.call(null,output_schema53940_53947);
/**
 * Inputs: [state :- sch-business-state k :- s/Keyword]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.remove_field_error = ((function (ufv___53946,output_schema53940_53947,input_schema53941_53948,input_checker53942_53949,output_checker53943_53950){
return (function dragonmark$inputs$validation$remove_field_error(G__53944,G__53945){
var validate__21152__auto__ = ufv___53946.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53951 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53944,G__53945], null);
var temp__4425__auto___53952 = input_checker53942_53949.call(null,args__21153__auto___53951);
if(cljs.core.truth_(temp__4425__auto___53952)){
var error__21154__auto___53953 = temp__4425__auto___53952;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error","remove-field-error",-837789813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___53953)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53941_53948,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53951,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53953], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var state = G__53944;
var k = G__53945;
while(true){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"valid","valid",155614240)], null),dragonmark.inputs.validation.no_async_error_QMARK_.call(null,state,k)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53954 = output_checker53943_53950.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53954)){
var error__21154__auto___53955 = temp__4425__auto___53954;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error","remove-field-error",-837789813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___53955)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53940_53947,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53955], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53946,output_schema53940_53947,input_schema53941_53948,input_checker53942_53949,output_checker53943_53950))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_field_error),schema.core.make_fn_schema.call(null,output_schema53940_53947,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53941_53948], null)));
var ufv___53962 = schema.utils.use_fn_validation;
var output_schema53956_53963 = dragonmark.inputs.schemas.sch_business_state;
var input_schema53957_53964 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker53958_53965 = schema.core.checker.call(null,input_schema53957_53964);
var output_checker53959_53966 = schema.core.checker.call(null,output_schema53956_53963);
/**
 * Inputs: [state :- sch-business-state k :- s/Keyword]
 * Returns: sch-business-state
 */
dragonmark.inputs.validation.remove_field_error_and_server = ((function (ufv___53962,output_schema53956_53963,input_schema53957_53964,input_checker53958_53965,output_checker53959_53966){
return (function dragonmark$inputs$validation$remove_field_error_and_server(G__53960,G__53961){
var validate__21152__auto__ = ufv___53962.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53967 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53960,G__53961], null);
var temp__4425__auto___53968 = input_checker53958_53965.call(null,args__21153__auto___53967);
if(cljs.core.truth_(temp__4425__auto___53968)){
var error__21154__auto___53969 = temp__4425__auto___53968;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error-and-server","remove-field-error-and-server",-1796162559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___53969)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53957_53964,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53967,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53969], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var state = G__53960;
var k = G__53961;
while(true){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"valid","valid",155614240)], null),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"async-error","async-error",528708636)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53970 = output_checker53959_53966.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53970)){
var error__21154__auto___53971 = temp__4425__auto___53970;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error-and-server","remove-field-error-and-server",-1796162559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__21154__auto___53971)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53956_53963,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53971], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53962,output_schema53956_53963,input_schema53957_53964,input_checker53958_53965,output_checker53959_53966))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_field_error_and_server),schema.core.make_fn_schema.call(null,output_schema53956_53963,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53957_53964], null)));
var ufv___53979 = schema.utils.use_fn_validation;
var output_schema53972_53980 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);
var input_schema53973_53981 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,cljs.core.PersistentHashSet.fromArray([schema.core.Keyword], true),cljs.core.with_meta(new cljs.core.Symbol(null,"cross-errs","cross-errs",-563013712,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),null], null), null)], null))),schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Keyword], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"error-rule","error-rule",327326958,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null))),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker53974_53982 = schema.core.checker.call(null,input_schema53973_53981);
var output_checker53975_53983 = schema.core.checker.call(null,output_schema53972_53980);
/**
 * Inputs: [cross-errs :- #{s/Keyword} error-rule :- {s/Keyword s/Keyword} errs :- [s/Keyword]]
 * Returns: [s/Keyword]
 * 
 * Remove the cross field errors keys from the validation errors.
 * This prevent errors from showing when inline validation occurs.
 */
dragonmark.inputs.validation.remove_dependant_errors = ((function (ufv___53979,output_schema53972_53980,input_schema53973_53981,input_checker53974_53982,output_checker53975_53983){
return (function dragonmark$inputs$validation$remove_dependant_errors(G__53976,G__53977,G__53978){
var validate__21152__auto__ = ufv___53979.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___53984 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53976,G__53977,G__53978], null);
var temp__4425__auto___53985 = input_checker53974_53982.call(null,args__21153__auto___53984);
if(cljs.core.truth_(temp__4425__auto___53985)){
var error__21154__auto___53986 = temp__4425__auto___53985;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-dependant-errors","remove-dependant-errors",-830444485,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remove the cross field errors keys from the validation errors.\n  This prevent errors from showing when inline validation occurs."], null)),cljs.core.pr_str.call(null,error__21154__auto___53986)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53973_53981,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___53984,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53986], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var cross_errs = G__53976;
var error_rule = G__53977;
var errs = G__53978;
while(true){
return cljs.core.seq.call(null,cljs.core.remove.call(null,((function (validate__21152__auto__,ufv___53979,output_schema53972_53980,input_schema53973_53981,input_checker53974_53982,output_checker53975_53983){
return (function (err){
return cross_errs.call(null,cljs.core.get.call(null,error_rule,err));
});})(validate__21152__auto__,ufv___53979,output_schema53972_53980,input_schema53973_53981,input_checker53974_53982,output_checker53975_53983))
,errs));
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___53987 = output_checker53975_53983.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___53987)){
var error__21154__auto___53988 = temp__4425__auto___53987;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-dependant-errors","remove-dependant-errors",-830444485,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remove the cross field errors keys from the validation errors.\n  This prevent errors from showing when inline validation occurs."], null)),cljs.core.pr_str.call(null,error__21154__auto___53988)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53972_53980,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___53988], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___53979,output_schema53972_53980,input_schema53973_53981,input_checker53974_53982,output_checker53975_53983))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.remove_dependant_errors),schema.core.make_fn_schema.call(null,output_schema53972_53980,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53973_53981], null)));
dragonmark.inputs.validation.build_error_remover = (function dragonmark$inputs$validation$build_error_remover(rules,cross_fields_rules){
return cljs.core.partial.call(null,dragonmark.inputs.validation.remove_dependant_errors,cross_fields_rules,dragonmark.inputs.validation.error__GT_rule.call(null,rules));
});
/**
 * validate a single field against verily rules.
 * If an other field depends on this one, then the errors linked to this validation won't show up.
 */
dragonmark.inputs.validation.unit_verily_validation = (function dragonmark$inputs$validation$unit_verily_validation(fk,unit,p__53989){
var map__53992 = p__53989;
var map__53992__$1 = ((((!((map__53992 == null)))?((((map__53992.cljs$lang$protocol_mask$partition0$ & (64))) || (map__53992.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53992):map__53992);
var state = map__53992__$1;
var unit_coercers = cljs.core.get.call(null,map__53992__$1,new cljs.core.Keyword(null,"unit-coercers","unit-coercers",-1869075474));
var remove_errs_fn = cljs.core.get.call(null,map__53992__$1,new cljs.core.Keyword(null,"remove-errs-fn","remove-errs-fn",-1642608850));
var verily_validator = cljs.core.get.call(null,map__53992__$1,new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403));
var coerced = fk.call(null,unit_coercers).call(null,unit);
var errs = verily_validator.call(null,coerced);
if(cljs.core.contains_QMARK_.call(null,errs,fk)){
var errs_unit = cljs.core.update_in.call(null,errs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null),remove_errs_fn);
var res = cljs.core.select_keys.call(null,errs_unit,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null));
if(cljs.core.truth_(fk.call(null,res))){
return res;
} else {
return null;
}
} else {
return null;
}
});
/**
 * Verily validation of a field that depend on other.
 * The confirm password is a typical example.
 */
dragonmark.inputs.validation.unit_dependant_verily_validation = (function dragonmark$inputs$validation$unit_dependant_verily_validation(fk,inputs,state){
var map__53996 = state;
var map__53996__$1 = ((((!((map__53996 == null)))?((((map__53996.cljs$lang$protocol_mask$partition0$ & (64))) || (map__53996.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53996):map__53996);
var validation_deps = cljs.core.get.call(null,map__53996__$1,new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716));
var verily_validator = cljs.core.get.call(null,map__53996__$1,new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403));
var deps = fk.call(null,validation_deps);
var coerced = dragonmark.inputs.validation.business_state__GT_map.call(null,inputs);
var errs = verily_validator.call(null,coerced);
if(cljs.core.contains_QMARK_.call(null,errs,fk)){
return cljs.core.select_keys.call(null,errs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null));
} else {
return null;
}
});
/**
 * Verily validation of a single field
 */
dragonmark.inputs.validation.verily_validation = (function dragonmark$inputs$validation$verily_validation(fk,unit,bs,state){
var map__54000 = state;
var map__54000__$1 = ((((!((map__54000 == null)))?((((map__54000.cljs$lang$protocol_mask$partition0$ & (64))) || (map__54000.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54000):map__54000);
var validation_deps = cljs.core.get.call(null,map__54000__$1,new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716));
if(cljs.core.truth_(fk.call(null,validation_deps))){
return dragonmark.inputs.validation.unit_dependant_verily_validation.call(null,fk,bs,state);
} else {
return dragonmark.inputs.validation.unit_verily_validation.call(null,fk,unit,state);
}
});
/**
 * Validation of a single field
 * TODO Refactoring
 */
dragonmark.inputs.validation.field_validation = (function dragonmark$inputs$validation$field_validation(fk,inputs,state){
var map__54004 = state;
var map__54004__$1 = ((((!((map__54004 == null)))?((((map__54004.cljs$lang$protocol_mask$partition0$ & (64))) || (map__54004.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54004):map__54004);
var unit_validators = cljs.core.get.call(null,map__54004__$1,new cljs.core.Keyword(null,"unit-validators","unit-validators",-1302618433));
var unit = dragonmark.inputs.validation.bs__GT_unit_map.call(null,inputs,fk);
if(cljs.core.truth_(dragonmark.inputs.validation.validate_QMARK_.call(null,fk.call(null,inputs)))){
var temp__4423__auto__ = (function (){var or__18489__auto__ = (function (){var and__18477__auto__ = fk;
if(cljs.core.truth_(and__18477__auto__)){
var temp__4423__auto__ = fk.call(null,unit_validators);
if(cljs.core.truth_(temp__4423__auto__)){
var the_fn = temp__4423__auto__;
return the_fn.call(null,unit);
} else {
return null;
}
} else {
return and__18477__auto__;
}
})();
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return dragonmark.inputs.validation.verily_validation.call(null,fk,unit,inputs,state);
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var errs = temp__4423__auto__;
return dragonmark.inputs.validation.add_field_error.call(null,inputs,errs);
} else {
return dragonmark.inputs.validation.remove_field_error.call(null,inputs,fk);
}
} else {
return dragonmark.inputs.validation.remove_field_error.call(null,inputs,fk);
}
});
/**
 * Validate a single field of the local business state and update the local state.
 */
dragonmark.inputs.validation.field_validation_BANG_ = (function dragonmark$inputs$validation$field_validation_BANG_(owner,f){
var map__54008 = dragonmark.inputs.extern.get_state.call(null,owner);
var map__54008__$1 = ((((!((map__54008 == null)))?((((map__54008.cljs$lang$protocol_mask$partition0$ & (64))) || (map__54008.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54008):map__54008);
var state = map__54008__$1;
var inputs = cljs.core.get.call(null,map__54008__$1,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var old_inputs = inputs;
var inputs__$1 = dragonmark.inputs.validation.remove_field_error_and_server.call(null,inputs,f);
var new_business_state = dragonmark.inputs.validation.field_validation.call(null,f,inputs__$1,state);
if(cljs.core.not_EQ_.call(null,old_inputs,new_business_state)){
return dragonmark.inputs.extern.set_state_BANG_.call(null,owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"inputs","inputs",865803858)], null),new_business_state);
} else {
return null;
}
});
dragonmark.inputs.validation.full_validation = (function dragonmark$inputs$validation$full_validation(inputs,state){
return cljs.core.reduce.call(null,(function (bs,f){
return dragonmark.inputs.validation.field_validation.call(null,f,bs,state);
}),inputs,cljs.core.keys.call(null,inputs));
});
var ufv___54019 = schema.utils.use_fn_validation;
var output_schema54010_54020 = schema.core.Bool;
var input_schema54011_54021 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker54012_54022 = schema.core.checker.call(null,input_schema54011_54021);
var output_checker54013_54023 = schema.core.checker.call(null,output_schema54010_54020);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: s/Bool
 * 
 * Tells if there is at least one field in error.
 */
dragonmark.inputs.validation.no_error_QMARK_ = ((function (ufv___54019,output_schema54010_54020,input_schema54011_54021,input_checker54012_54022,output_checker54013_54023){
return (function dragonmark$inputs$validation$no_error_QMARK_(G__54014){
var validate__21152__auto__ = ufv___54019.get_cell();
if(cljs.core.truth_(validate__21152__auto__)){
var args__21153__auto___54024 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54014], null);
var temp__4425__auto___54025 = input_checker54012_54022.call(null,args__21153__auto___54024);
if(cljs.core.truth_(temp__4425__auto___54025)){
var error__21154__auto___54026 = temp__4425__auto___54025;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"no-error?","no-error?",323642458,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tells if there is at least one field in error."], null)),cljs.core.pr_str.call(null,error__21154__auto___54026)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54011_54021,new cljs.core.Keyword(null,"value","value",305978217),args__21153__auto___54024,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___54026], null));
} else {
}
} else {
}

var o__21155__auto__ = (function (){var bs = G__54014;
while(true){
return cljs.core.not_any_QMARK_.call(null,((function (validate__21152__auto__,ufv___54019,output_schema54010_54020,input_schema54011_54021,input_checker54012_54022,output_checker54013_54023){
return (function (p__54017){
var vec__54018 = p__54017;
var k = cljs.core.nth.call(null,vec__54018,(0),null);
var v = cljs.core.nth.call(null,vec__54018,(1),null);
return new cljs.core.Keyword(null,"valid","valid",155614240).cljs$core$IFn$_invoke$arity$1(v) === false;
});})(validate__21152__auto__,ufv___54019,output_schema54010_54020,input_schema54011_54021,input_checker54012_54022,output_checker54013_54023))
,bs);
break;
}
})();
if(cljs.core.truth_(validate__21152__auto__)){
var temp__4425__auto___54027 = output_checker54013_54023.call(null,o__21155__auto__);
if(cljs.core.truth_(temp__4425__auto___54027)){
var error__21154__auto___54028 = temp__4425__auto___54027;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"no-error?","no-error?",323642458,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tells if there is at least one field in error."], null)),cljs.core.pr_str.call(null,error__21154__auto___54028)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54010_54020,new cljs.core.Keyword(null,"value","value",305978217),o__21155__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__21154__auto___54028], null));
} else {
}
} else {
}

return o__21155__auto__;
});})(ufv___54019,output_schema54010_54020,input_schema54011_54021,input_checker54012_54022,output_checker54013_54023))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.validation.no_error_QMARK_),schema.core.make_fn_schema.call(null,output_schema54010_54020,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54011_54021], null)));

//# sourceMappingURL=validation.js.map