// Compiled by ClojureScript 1.7.48 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');

figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.all_QMARK_ = (function figwheel$client$file_reloading$all_QMARK_(pred,coll){
return cljs.core.reduce.call(null,(function (p1__60409_SHARP_,p2__60410_SHARP_){
var and__18477__auto__ = p1__60409_SHARP_;
if(cljs.core.truth_(and__18477__auto__)){
return p2__60410_SHARP_;
} else {
return and__18477__auto__;
}
}),true,cljs.core.map.call(null,pred,coll));
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__18489__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.ns_to_js_file = (function figwheel$client$file_reloading$ns_to_js_file(ns){

return [cljs.core.str(clojure.string.replace.call(null,ns,".","/")),cljs.core.str(".js")].join('');
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){

return [cljs.core.str(figwheel.client.utils.base_url_path.call(null)),cljs.core.str(figwheel.client.file_reloading.ns_to_js_file.call(null,ns))].join('');
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
goog.isProvided = (function (x){
return false;
});

if(((cljs.core._STAR_loaded_libs_STAR_ == null)) || (cljs.core.empty_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_))){
cljs.core._STAR_loaded_libs_STAR_ = (function (){var gntp = goog.dependencies_.nameToPath;
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,((function (gntp){
return (function (name){
return (goog.dependencies_.visited[(gntp[name])]);
});})(gntp))
,cljs.core.js_keys.call(null,gntp)));
})();
} else {
}

goog.require = (function (name,reload){
if(cljs.core.truth_((function (){var or__18489__auto__ = !(cljs.core.contains_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_,name));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return reload;
}
})())){
cljs.core._STAR_loaded_libs_STAR_ = cljs.core.conj.call(null,(function (){var or__18489__auto__ = cljs.core._STAR_loaded_libs_STAR_;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})(),name);

return figwheel.client.file_reloading.reload_file_STAR_.call(null,figwheel.client.file_reloading.resolve_ns.call(null,name));
} else {
return null;
}
});

goog.provide = goog.exportPath_;

return goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.reload_file_STAR_;
});
if(typeof figwheel.client.file_reloading.resolve_url !== 'undefined'){
} else {
figwheel.client.file_reloading.resolve_url = (function (){var method_table__19383__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19384__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19385__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19386__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19387__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"figwheel.client.file-reloading","resolve-url"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19387__auto__,method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__));
})();
}
cljs.core._add_method.call(null,figwheel.client.file_reloading.resolve_url,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__60411){
var map__60412 = p__60411;
var map__60412__$1 = ((((!((map__60412 == null)))?((((map__60412.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60412.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60412):map__60412);
var file = cljs.core.get.call(null,map__60412__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
return file;
}));
cljs.core._add_method.call(null,figwheel.client.file_reloading.resolve_url,new cljs.core.Keyword(null,"namespace","namespace",-377510372),(function (p__60414){
var map__60415 = p__60414;
var map__60415__$1 = ((((!((map__60415 == null)))?((((map__60415.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60415.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60415):map__60415);
var namespace = cljs.core.get.call(null,map__60415__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

return figwheel.client.file_reloading.resolve_ns.call(null,namespace);
}));
if(typeof figwheel.client.file_reloading.reload_base !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_base = (function (){var method_table__19383__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19384__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19385__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19386__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19387__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"figwheel.client.file-reloading","reload-base"),figwheel.client.utils.host_env_QMARK_,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19387__auto__,method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__));
})();
}
cljs.core._add_method.call(null,figwheel.client.file_reloading.reload_base,new cljs.core.Keyword(null,"node","node",581201198),(function (request_url,callback){

var root = clojure.string.join.call(null,"/",cljs.core.reverse.call(null,cljs.core.drop.call(null,(2),cljs.core.reverse.call(null,clojure.string.split.call(null,__dirname,"/")))));
var path = [cljs.core.str(root),cljs.core.str("/"),cljs.core.str(request_url)].join('');
(require.cache[path] = null);

return callback.call(null,(function (){try{return require(path);
}catch (e60417){if((e60417 instanceof Error)){
var e = e60417;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e60417;

}
}})());
}));
cljs.core._add_method.call(null,figwheel.client.file_reloading.reload_base,new cljs.core.Keyword(null,"html","html",-998796897),(function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred))
);

return deferred.addErrback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred))
);
}));
figwheel.client.file_reloading.reload_file_STAR_ = (function figwheel$client$file_reloading$reload_file_STAR_(){
var args60418 = [];
var len__19528__auto___60421 = arguments.length;
var i__19529__auto___60422 = (0);
while(true){
if((i__19529__auto___60422 < len__19528__auto___60421)){
args60418.push((arguments[i__19529__auto___60422]));

var G__60423 = (i__19529__auto___60422 + (1));
i__19529__auto___60422 = G__60423;
continue;
} else {
}
break;
}

var G__60420 = args60418.length;
switch (G__60420) {
case 2:
return figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args60418.length)].join('')));

}
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (request_url,callback){
return figwheel.client.file_reloading.reload_base.call(null,request_url,callback);
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (request_url){
return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,cljs.core.identity);
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__60425,callback){
var map__60428 = p__60425;
var map__60428__$1 = ((((!((map__60428 == null)))?((((map__60428.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60428.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60428):map__60428);
var file_msg = map__60428__$1;
var request_url = cljs.core.get.call(null,map__60428__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__60428,map__60428__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfullly loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__60428,map__60428__$1,file_msg,request_url))
);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__60430){
var map__60433 = p__60430;
var map__60433__$1 = ((((!((map__60433 == null)))?((((map__60433.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60433.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60433):map__60433);
var file_msg = map__60433__$1;
var namespace = cljs.core.get.call(null,map__60433__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,map__60433__$1,new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157));

var meta_data__$1 = (function (){var or__18489__auto__ = meta_data;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var and__18477__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_data__$1));
if(and__18477__auto__){
var or__18489__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
if(cljs.core.truth_(or__18489__auto____$1)){
return or__18489__auto____$1;
} else {
var and__18477__auto____$1 = cljs.core.contains_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_,namespace);
if(and__18477__auto____$1){
var or__18489__auto____$2 = !(cljs.core.contains_QMARK_.call(null,meta_data__$1,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932)));
if(or__18489__auto____$2){
return or__18489__auto____$2;
} else {
return new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
}
} else {
return and__18477__auto____$1;
}
}
}
} else {
return and__18477__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__60435,callback){
var map__60438 = p__60435;
var map__60438__$1 = ((((!((map__60438 == null)))?((((map__60438.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60438.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60438):map__60438);
var file_msg = map__60438__$1;
var request_url = cljs.core.get.call(null,map__60438__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__60438__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.reload_file.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
setTimeout(((function (out){
return (function (){
return figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
figwheel.client.file_reloading.patch_goog_base.call(null);

cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);
});})(out))
,(0));

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__24142__auto___60526 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto___60526,out){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto___60526,out){
return (function (state_60508){
var state_val_60509 = (state_60508[(1)]);
if((state_val_60509 === (1))){
var inst_60486 = cljs.core.nth.call(null,files,(0),null);
var inst_60487 = cljs.core.nthnext.call(null,files,(1));
var inst_60488 = files;
var state_60508__$1 = (function (){var statearr_60510 = state_60508;
(statearr_60510[(7)] = inst_60488);

(statearr_60510[(8)] = inst_60486);

(statearr_60510[(9)] = inst_60487);

return statearr_60510;
})();
var statearr_60511_60527 = state_60508__$1;
(statearr_60511_60527[(2)] = null);

(statearr_60511_60527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60509 === (2))){
var inst_60488 = (state_60508[(7)]);
var inst_60491 = (state_60508[(10)]);
var inst_60491__$1 = cljs.core.nth.call(null,inst_60488,(0),null);
var inst_60492 = cljs.core.nthnext.call(null,inst_60488,(1));
var inst_60493 = (inst_60491__$1 == null);
var inst_60494 = cljs.core.not.call(null,inst_60493);
var state_60508__$1 = (function (){var statearr_60512 = state_60508;
(statearr_60512[(10)] = inst_60491__$1);

(statearr_60512[(11)] = inst_60492);

return statearr_60512;
})();
if(inst_60494){
var statearr_60513_60528 = state_60508__$1;
(statearr_60513_60528[(1)] = (4));

} else {
var statearr_60514_60529 = state_60508__$1;
(statearr_60514_60529[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60509 === (3))){
var inst_60506 = (state_60508[(2)]);
var state_60508__$1 = state_60508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60508__$1,inst_60506);
} else {
if((state_val_60509 === (4))){
var inst_60491 = (state_60508[(10)]);
var inst_60496 = figwheel.client.file_reloading.reload_js_file.call(null,inst_60491);
var state_60508__$1 = state_60508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60508__$1,(7),inst_60496);
} else {
if((state_val_60509 === (5))){
var inst_60502 = cljs.core.async.close_BANG_.call(null,out);
var state_60508__$1 = state_60508;
var statearr_60515_60530 = state_60508__$1;
(statearr_60515_60530[(2)] = inst_60502);

(statearr_60515_60530[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60509 === (6))){
var inst_60504 = (state_60508[(2)]);
var state_60508__$1 = state_60508;
var statearr_60516_60531 = state_60508__$1;
(statearr_60516_60531[(2)] = inst_60504);

(statearr_60516_60531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60509 === (7))){
var inst_60492 = (state_60508[(11)]);
var inst_60498 = (state_60508[(2)]);
var inst_60499 = cljs.core.async.put_BANG_.call(null,out,inst_60498);
var inst_60488 = inst_60492;
var state_60508__$1 = (function (){var statearr_60517 = state_60508;
(statearr_60517[(7)] = inst_60488);

(statearr_60517[(12)] = inst_60499);

return statearr_60517;
})();
var statearr_60518_60532 = state_60508__$1;
(statearr_60518_60532[(2)] = null);

(statearr_60518_60532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__24142__auto___60526,out))
;
return ((function (switch__24077__auto__,c__24142__auto___60526,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto____0 = (function (){
var statearr_60522 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60522[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto__);

(statearr_60522[(1)] = (1));

return statearr_60522;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto____1 = (function (state_60508){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_60508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e60523){if((e60523 instanceof Object)){
var ex__24081__auto__ = e60523;
var statearr_60524_60533 = state_60508;
(statearr_60524_60533[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60508);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60523;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60534 = state_60508;
state_60508 = G__60534;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto__ = function(state_60508){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto____1.call(this,state_60508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto___60526,out))
})();
var state__24144__auto__ = (function (){var statearr_60525 = f__24143__auto__.call(null);
(statearr_60525[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto___60526);

return statearr_60525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto___60526,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.add_request_url = (function figwheel$client$file_reloading$add_request_url(p__60535,p__60536){
var map__60541 = p__60535;
var map__60541__$1 = ((((!((map__60541 == null)))?((((map__60541.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60541.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60541):map__60541);
var opts = map__60541__$1;
var url_rewriter = cljs.core.get.call(null,map__60541__$1,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",200543838));
var map__60542 = p__60536;
var map__60542__$1 = ((((!((map__60542 == null)))?((((map__60542.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60542.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60542):map__60542);
var file_msg = map__60542__$1;
var file = cljs.core.get.call(null,map__60542__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var resolved_path = figwheel.client.file_reloading.resolve_url.call(null,file_msg);
return cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"request-url","request-url",2100346596),(cljs.core.truth_(url_rewriter)?url_rewriter.call(null,resolved_path):resolved_path));
});
figwheel.client.file_reloading.add_request_urls = (function figwheel$client$file_reloading$add_request_urls(opts,files){
return cljs.core.map.call(null,cljs.core.partial.call(null,figwheel.client.file_reloading.add_request_url,opts),files);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__60545){
var map__60549 = p__60545;
var map__60549__$1 = ((((!((map__60549 == null)))?((((map__60549.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60549.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60549):map__60549);
var eval_body__$1 = cljs.core.get.call(null,map__60549__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__60549__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__18477__auto__ = eval_body__$1;
if(cljs.core.truth_(and__18477__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__18477__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return eval(code);
}catch (e60551){var e = e60551;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__60556,p__60557){
var map__60785 = p__60556;
var map__60785__$1 = ((((!((map__60785 == null)))?((((map__60785.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60785.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60785):map__60785);
var opts = map__60785__$1;
var before_jsload = cljs.core.get.call(null,map__60785__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__60785__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var load_unchanged_files = cljs.core.get.call(null,map__60785__$1,new cljs.core.Keyword(null,"load-unchanged-files","load-unchanged-files",-1561468704));
var map__60786 = p__60557;
var map__60786__$1 = ((((!((map__60786 == null)))?((((map__60786.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60786.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60786):map__60786);
var msg = map__60786__$1;
var files = cljs.core.get.call(null,map__60786__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var c__24142__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files){
return (function (state_60927){
var state_val_60928 = (state_60927[(1)]);
if((state_val_60928 === (7))){
var inst_60803 = (state_60927[(7)]);
var inst_60801 = (state_60927[(8)]);
var inst_60802 = (state_60927[(9)]);
var inst_60800 = (state_60927[(10)]);
var inst_60808 = cljs.core._nth.call(null,inst_60801,inst_60803);
var inst_60809 = figwheel.client.file_reloading.eval_body.call(null,inst_60808);
var inst_60810 = (inst_60803 + (1));
var tmp60929 = inst_60801;
var tmp60930 = inst_60802;
var tmp60931 = inst_60800;
var inst_60800__$1 = tmp60931;
var inst_60801__$1 = tmp60929;
var inst_60802__$1 = tmp60930;
var inst_60803__$1 = inst_60810;
var state_60927__$1 = (function (){var statearr_60932 = state_60927;
(statearr_60932[(7)] = inst_60803__$1);

(statearr_60932[(8)] = inst_60801__$1);

(statearr_60932[(11)] = inst_60809);

(statearr_60932[(9)] = inst_60802__$1);

(statearr_60932[(10)] = inst_60800__$1);

return statearr_60932;
})();
var statearr_60933_61012 = state_60927__$1;
(statearr_60933_61012[(2)] = null);

(statearr_60933_61012[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (20))){
var inst_60846 = (state_60927[(12)]);
var inst_60850 = (state_60927[(13)]);
var inst_60845 = (state_60927[(14)]);
var inst_60852 = (state_60927[(15)]);
var inst_60849 = (state_60927[(16)]);
var inst_60855 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_60857 = (function (){var all_files = inst_60845;
var files_SINGLEQUOTE_ = inst_60846;
var res_SINGLEQUOTE_ = inst_60849;
var res = inst_60850;
var files_not_loaded = inst_60852;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_60846,inst_60850,inst_60845,inst_60852,inst_60849,inst_60855,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files){
return (function (p__60856){
var map__60934 = p__60856;
var map__60934__$1 = ((((!((map__60934 == null)))?((((map__60934.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60934.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60934):map__60934);
var namespace = cljs.core.get.call(null,map__60934__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__60934__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.ns_to_js_file.call(null,namespace);
} else {
return file;
}
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_60846,inst_60850,inst_60845,inst_60852,inst_60849,inst_60855,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files))
})();
var inst_60858 = cljs.core.map.call(null,inst_60857,inst_60850);
var inst_60859 = cljs.core.pr_str.call(null,inst_60858);
var inst_60860 = figwheel.client.utils.log.call(null,inst_60859);
var inst_60861 = (function (){var all_files = inst_60845;
var files_SINGLEQUOTE_ = inst_60846;
var res_SINGLEQUOTE_ = inst_60849;
var res = inst_60850;
var files_not_loaded = inst_60852;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_60846,inst_60850,inst_60845,inst_60852,inst_60849,inst_60855,inst_60857,inst_60858,inst_60859,inst_60860,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_60846,inst_60850,inst_60845,inst_60852,inst_60849,inst_60855,inst_60857,inst_60858,inst_60859,inst_60860,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files))
})();
var inst_60862 = setTimeout(inst_60861,(10));
var state_60927__$1 = (function (){var statearr_60936 = state_60927;
(statearr_60936[(17)] = inst_60855);

(statearr_60936[(18)] = inst_60860);

return statearr_60936;
})();
var statearr_60937_61013 = state_60927__$1;
(statearr_60937_61013[(2)] = inst_60862);

(statearr_60937_61013[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (27))){
var state_60927__$1 = state_60927;
var statearr_60938_61014 = state_60927__$1;
(statearr_60938_61014[(2)] = false);

(statearr_60938_61014[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (1))){
var inst_60792 = (state_60927[(19)]);
var inst_60789 = before_jsload.call(null,files);
var inst_60790 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_60791 = (function (){return ((function (inst_60792,inst_60789,inst_60790,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files){
return (function (p1__60552_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__60552_SHARP_);
});
;})(inst_60792,inst_60789,inst_60790,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files))
})();
var inst_60792__$1 = cljs.core.filter.call(null,inst_60791,files);
var inst_60793 = cljs.core.not_empty.call(null,inst_60792__$1);
var state_60927__$1 = (function (){var statearr_60939 = state_60927;
(statearr_60939[(20)] = inst_60789);

(statearr_60939[(19)] = inst_60792__$1);

(statearr_60939[(21)] = inst_60790);

return statearr_60939;
})();
if(cljs.core.truth_(inst_60793)){
var statearr_60940_61015 = state_60927__$1;
(statearr_60940_61015[(1)] = (2));

} else {
var statearr_60941_61016 = state_60927__$1;
(statearr_60941_61016[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (24))){
var state_60927__$1 = state_60927;
var statearr_60942_61017 = state_60927__$1;
(statearr_60942_61017[(2)] = null);

(statearr_60942_61017[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (39))){
var state_60927__$1 = state_60927;
var statearr_60943_61018 = state_60927__$1;
(statearr_60943_61018[(2)] = null);

(statearr_60943_61018[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (4))){
var inst_60837 = (state_60927[(2)]);
var inst_60838 = (function (){return ((function (inst_60837,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files){
return (function (p1__60553_SHARP_){
var and__18477__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__60553_SHARP_);
if(cljs.core.truth_(and__18477__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__60553_SHARP_));
} else {
return and__18477__auto__;
}
});
;})(inst_60837,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files))
})();
var inst_60839 = cljs.core.filter.call(null,inst_60838,files);
var state_60927__$1 = (function (){var statearr_60944 = state_60927;
(statearr_60944[(22)] = inst_60839);

(statearr_60944[(23)] = inst_60837);

return statearr_60944;
})();
if(cljs.core.truth_(load_unchanged_files)){
var statearr_60945_61019 = state_60927__$1;
(statearr_60945_61019[(1)] = (16));

} else {
var statearr_60946_61020 = state_60927__$1;
(statearr_60946_61020[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (15))){
var inst_60827 = (state_60927[(2)]);
var state_60927__$1 = state_60927;
var statearr_60947_61021 = state_60927__$1;
(statearr_60947_61021[(2)] = inst_60827);

(statearr_60947_61021[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (21))){
var state_60927__$1 = state_60927;
var statearr_60948_61022 = state_60927__$1;
(statearr_60948_61022[(2)] = null);

(statearr_60948_61022[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (31))){
var inst_60884 = (state_60927[(2)]);
var state_60927__$1 = state_60927;
var statearr_60949_61023 = state_60927__$1;
(statearr_60949_61023[(2)] = inst_60884);

(statearr_60949_61023[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (32))){
var inst_60872 = (state_60927[(24)]);
var inst_60889 = cljs.core.apply.call(null,cljs.core.hash_map,inst_60872);
var state_60927__$1 = state_60927;
var statearr_60950_61024 = state_60927__$1;
(statearr_60950_61024[(2)] = inst_60889);

(statearr_60950_61024[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (40))){
var inst_60895 = (state_60927[(25)]);
var inst_60913 = (state_60927[(2)]);
var inst_60914 = cljs.core.not_empty.call(null,inst_60895);
var state_60927__$1 = (function (){var statearr_60951 = state_60927;
(statearr_60951[(26)] = inst_60913);

return statearr_60951;
})();
if(cljs.core.truth_(inst_60914)){
var statearr_60952_61025 = state_60927__$1;
(statearr_60952_61025[(1)] = (41));

} else {
var statearr_60953_61026 = state_60927__$1;
(statearr_60953_61026[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (33))){
var inst_60872 = (state_60927[(24)]);
var state_60927__$1 = state_60927;
var statearr_60954_61027 = state_60927__$1;
(statearr_60954_61027[(2)] = inst_60872);

(statearr_60954_61027[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (13))){
var inst_60813 = (state_60927[(27)]);
var inst_60817 = cljs.core.chunk_first.call(null,inst_60813);
var inst_60818 = cljs.core.chunk_rest.call(null,inst_60813);
var inst_60819 = cljs.core.count.call(null,inst_60817);
var inst_60800 = inst_60818;
var inst_60801 = inst_60817;
var inst_60802 = inst_60819;
var inst_60803 = (0);
var state_60927__$1 = (function (){var statearr_60955 = state_60927;
(statearr_60955[(7)] = inst_60803);

(statearr_60955[(8)] = inst_60801);

(statearr_60955[(9)] = inst_60802);

(statearr_60955[(10)] = inst_60800);

return statearr_60955;
})();
var statearr_60956_61028 = state_60927__$1;
(statearr_60956_61028[(2)] = null);

(statearr_60956_61028[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (22))){
var inst_60852 = (state_60927[(15)]);
var inst_60865 = (state_60927[(2)]);
var inst_60866 = cljs.core.not_empty.call(null,inst_60852);
var state_60927__$1 = (function (){var statearr_60957 = state_60927;
(statearr_60957[(28)] = inst_60865);

return statearr_60957;
})();
if(cljs.core.truth_(inst_60866)){
var statearr_60958_61029 = state_60927__$1;
(statearr_60958_61029[(1)] = (23));

} else {
var statearr_60959_61030 = state_60927__$1;
(statearr_60959_61030[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (36))){
var state_60927__$1 = state_60927;
var statearr_60960_61031 = state_60927__$1;
(statearr_60960_61031[(2)] = null);

(statearr_60960_61031[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (41))){
var inst_60895 = (state_60927[(25)]);
var inst_60916 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_60895);
var inst_60917 = cljs.core.pr_str.call(null,inst_60916);
var inst_60918 = [cljs.core.str("not required: "),cljs.core.str(inst_60917)].join('');
var inst_60919 = figwheel.client.utils.log.call(null,inst_60918);
var state_60927__$1 = state_60927;
var statearr_60961_61032 = state_60927__$1;
(statearr_60961_61032[(2)] = inst_60919);

(statearr_60961_61032[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (43))){
var inst_60922 = (state_60927[(2)]);
var state_60927__$1 = state_60927;
var statearr_60962_61033 = state_60927__$1;
(statearr_60962_61033[(2)] = inst_60922);

(statearr_60962_61033[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (29))){
var state_60927__$1 = state_60927;
var statearr_60963_61034 = state_60927__$1;
(statearr_60963_61034[(2)] = true);

(statearr_60963_61034[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (6))){
var inst_60834 = (state_60927[(2)]);
var state_60927__$1 = state_60927;
var statearr_60964_61035 = state_60927__$1;
(statearr_60964_61035[(2)] = inst_60834);

(statearr_60964_61035[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (28))){
var inst_60887 = (state_60927[(2)]);
var state_60927__$1 = state_60927;
if(cljs.core.truth_(inst_60887)){
var statearr_60965_61036 = state_60927__$1;
(statearr_60965_61036[(1)] = (32));

} else {
var statearr_60966_61037 = state_60927__$1;
(statearr_60966_61037[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (25))){
var inst_60925 = (state_60927[(2)]);
var state_60927__$1 = state_60927;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60927__$1,inst_60925);
} else {
if((state_val_60928 === (34))){
var inst_60893 = (state_60927[(29)]);
var inst_60892 = (state_60927[(2)]);
var inst_60893__$1 = cljs.core.get.call(null,inst_60892,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_60894 = cljs.core.get.call(null,inst_60892,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932));
var inst_60895 = cljs.core.get.call(null,inst_60892,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_60896 = cljs.core.not_empty.call(null,inst_60893__$1);
var state_60927__$1 = (function (){var statearr_60967 = state_60927;
(statearr_60967[(29)] = inst_60893__$1);

(statearr_60967[(25)] = inst_60895);

(statearr_60967[(30)] = inst_60894);

return statearr_60967;
})();
if(cljs.core.truth_(inst_60896)){
var statearr_60968_61038 = state_60927__$1;
(statearr_60968_61038[(1)] = (35));

} else {
var statearr_60969_61039 = state_60927__$1;
(statearr_60969_61039[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (17))){
var inst_60839 = (state_60927[(22)]);
var state_60927__$1 = state_60927;
var statearr_60970_61040 = state_60927__$1;
(statearr_60970_61040[(2)] = inst_60839);

(statearr_60970_61040[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (3))){
var state_60927__$1 = state_60927;
var statearr_60971_61041 = state_60927__$1;
(statearr_60971_61041[(2)] = null);

(statearr_60971_61041[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (12))){
var inst_60830 = (state_60927[(2)]);
var state_60927__$1 = state_60927;
var statearr_60972_61042 = state_60927__$1;
(statearr_60972_61042[(2)] = inst_60830);

(statearr_60972_61042[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (2))){
var inst_60792 = (state_60927[(19)]);
var inst_60799 = cljs.core.seq.call(null,inst_60792);
var inst_60800 = inst_60799;
var inst_60801 = null;
var inst_60802 = (0);
var inst_60803 = (0);
var state_60927__$1 = (function (){var statearr_60973 = state_60927;
(statearr_60973[(7)] = inst_60803);

(statearr_60973[(8)] = inst_60801);

(statearr_60973[(9)] = inst_60802);

(statearr_60973[(10)] = inst_60800);

return statearr_60973;
})();
var statearr_60974_61043 = state_60927__$1;
(statearr_60974_61043[(2)] = null);

(statearr_60974_61043[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (23))){
var inst_60872 = (state_60927[(24)]);
var inst_60846 = (state_60927[(12)]);
var inst_60850 = (state_60927[(13)]);
var inst_60845 = (state_60927[(14)]);
var inst_60852 = (state_60927[(15)]);
var inst_60849 = (state_60927[(16)]);
var inst_60868 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_60871 = (function (){var all_files = inst_60845;
var files_SINGLEQUOTE_ = inst_60846;
var res_SINGLEQUOTE_ = inst_60849;
var res = inst_60850;
var files_not_loaded = inst_60852;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_60872,inst_60846,inst_60850,inst_60845,inst_60852,inst_60849,inst_60868,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files){
return (function (p__60870){
var map__60975 = p__60870;
var map__60975__$1 = ((((!((map__60975 == null)))?((((map__60975.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60975.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60975):map__60975);
var meta_data = cljs.core.get.call(null,map__60975__$1,new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.contains_QMARK_.call(null,meta_data,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
if((cljs.core.contains_QMARK_.call(null,meta_data,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932))) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932).cljs$core$IFn$_invoke$arity$1(meta_data)))){
return new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
}
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_60872,inst_60846,inst_60850,inst_60845,inst_60852,inst_60849,inst_60868,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files))
})();
var inst_60872__$1 = cljs.core.group_by.call(null,inst_60871,inst_60852);
var inst_60874 = (inst_60872__$1 == null);
var inst_60875 = cljs.core.not.call(null,inst_60874);
var state_60927__$1 = (function (){var statearr_60977 = state_60927;
(statearr_60977[(24)] = inst_60872__$1);

(statearr_60977[(31)] = inst_60868);

return statearr_60977;
})();
if(inst_60875){
var statearr_60978_61044 = state_60927__$1;
(statearr_60978_61044[(1)] = (26));

} else {
var statearr_60979_61045 = state_60927__$1;
(statearr_60979_61045[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (35))){
var inst_60893 = (state_60927[(29)]);
var inst_60898 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_60893);
var inst_60899 = cljs.core.pr_str.call(null,inst_60898);
var inst_60900 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_60899)].join('');
var inst_60901 = figwheel.client.utils.log.call(null,inst_60900);
var state_60927__$1 = state_60927;
var statearr_60980_61046 = state_60927__$1;
(statearr_60980_61046[(2)] = inst_60901);

(statearr_60980_61046[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (19))){
var inst_60846 = (state_60927[(12)]);
var inst_60850 = (state_60927[(13)]);
var inst_60845 = (state_60927[(14)]);
var inst_60849 = (state_60927[(16)]);
var inst_60849__$1 = (state_60927[(2)]);
var inst_60850__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_60849__$1);
var inst_60851 = (function (){var all_files = inst_60845;
var files_SINGLEQUOTE_ = inst_60846;
var res_SINGLEQUOTE_ = inst_60849__$1;
var res = inst_60850__$1;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,inst_60846,inst_60850,inst_60845,inst_60849,inst_60849__$1,inst_60850__$1,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files){
return (function (p1__60555_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__60555_SHARP_));
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,inst_60846,inst_60850,inst_60845,inst_60849,inst_60849__$1,inst_60850__$1,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files))
})();
var inst_60852 = cljs.core.filter.call(null,inst_60851,inst_60849__$1);
var inst_60853 = cljs.core.not_empty.call(null,inst_60850__$1);
var state_60927__$1 = (function (){var statearr_60981 = state_60927;
(statearr_60981[(13)] = inst_60850__$1);

(statearr_60981[(15)] = inst_60852);

(statearr_60981[(16)] = inst_60849__$1);

return statearr_60981;
})();
if(cljs.core.truth_(inst_60853)){
var statearr_60982_61047 = state_60927__$1;
(statearr_60982_61047[(1)] = (20));

} else {
var statearr_60983_61048 = state_60927__$1;
(statearr_60983_61048[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (11))){
var state_60927__$1 = state_60927;
var statearr_60984_61049 = state_60927__$1;
(statearr_60984_61049[(2)] = null);

(statearr_60984_61049[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (9))){
var inst_60832 = (state_60927[(2)]);
var state_60927__$1 = state_60927;
var statearr_60985_61050 = state_60927__$1;
(statearr_60985_61050[(2)] = inst_60832);

(statearr_60985_61050[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (5))){
var inst_60803 = (state_60927[(7)]);
var inst_60802 = (state_60927[(9)]);
var inst_60805 = (inst_60803 < inst_60802);
var inst_60806 = inst_60805;
var state_60927__$1 = state_60927;
if(cljs.core.truth_(inst_60806)){
var statearr_60986_61051 = state_60927__$1;
(statearr_60986_61051[(1)] = (7));

} else {
var statearr_60987_61052 = state_60927__$1;
(statearr_60987_61052[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (14))){
var inst_60813 = (state_60927[(27)]);
var inst_60822 = cljs.core.first.call(null,inst_60813);
var inst_60823 = figwheel.client.file_reloading.eval_body.call(null,inst_60822);
var inst_60824 = cljs.core.next.call(null,inst_60813);
var inst_60800 = inst_60824;
var inst_60801 = null;
var inst_60802 = (0);
var inst_60803 = (0);
var state_60927__$1 = (function (){var statearr_60988 = state_60927;
(statearr_60988[(32)] = inst_60823);

(statearr_60988[(7)] = inst_60803);

(statearr_60988[(8)] = inst_60801);

(statearr_60988[(9)] = inst_60802);

(statearr_60988[(10)] = inst_60800);

return statearr_60988;
})();
var statearr_60989_61053 = state_60927__$1;
(statearr_60989_61053[(2)] = null);

(statearr_60989_61053[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (26))){
var inst_60872 = (state_60927[(24)]);
var inst_60877 = inst_60872.cljs$lang$protocol_mask$partition0$;
var inst_60878 = (inst_60877 & (64));
var inst_60879 = inst_60872.cljs$core$ISeq$;
var inst_60880 = (inst_60878) || (inst_60879);
var state_60927__$1 = state_60927;
if(cljs.core.truth_(inst_60880)){
var statearr_60990_61054 = state_60927__$1;
(statearr_60990_61054[(1)] = (29));

} else {
var statearr_60991_61055 = state_60927__$1;
(statearr_60991_61055[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (16))){
var inst_60839 = (state_60927[(22)]);
var inst_60841 = (function (){var all_files = inst_60839;
return ((function (all_files,inst_60839,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files){
return (function (p1__60554_SHARP_){
return cljs.core.update_in.call(null,p1__60554_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157)], null),cljs.core.dissoc,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932));
});
;})(all_files,inst_60839,state_val_60928,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files))
})();
var inst_60842 = cljs.core.map.call(null,inst_60841,inst_60839);
var state_60927__$1 = state_60927;
var statearr_60992_61056 = state_60927__$1;
(statearr_60992_61056[(2)] = inst_60842);

(statearr_60992_61056[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (38))){
var inst_60894 = (state_60927[(30)]);
var inst_60907 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_60894);
var inst_60908 = cljs.core.pr_str.call(null,inst_60907);
var inst_60909 = [cljs.core.str("file didn't change: "),cljs.core.str(inst_60908)].join('');
var inst_60910 = figwheel.client.utils.log.call(null,inst_60909);
var state_60927__$1 = state_60927;
var statearr_60993_61057 = state_60927__$1;
(statearr_60993_61057[(2)] = inst_60910);

(statearr_60993_61057[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (30))){
var state_60927__$1 = state_60927;
var statearr_60994_61058 = state_60927__$1;
(statearr_60994_61058[(2)] = false);

(statearr_60994_61058[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (10))){
var inst_60813 = (state_60927[(27)]);
var inst_60815 = cljs.core.chunked_seq_QMARK_.call(null,inst_60813);
var state_60927__$1 = state_60927;
if(inst_60815){
var statearr_60995_61059 = state_60927__$1;
(statearr_60995_61059[(1)] = (13));

} else {
var statearr_60996_61060 = state_60927__$1;
(statearr_60996_61060[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (18))){
var inst_60846 = (state_60927[(12)]);
var inst_60845 = (state_60927[(14)]);
var inst_60845__$1 = (state_60927[(2)]);
var inst_60846__$1 = figwheel.client.file_reloading.add_request_urls.call(null,opts,inst_60845__$1);
var inst_60847 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_60846__$1);
var state_60927__$1 = (function (){var statearr_60997 = state_60927;
(statearr_60997[(12)] = inst_60846__$1);

(statearr_60997[(14)] = inst_60845__$1);

return statearr_60997;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60927__$1,(19),inst_60847);
} else {
if((state_val_60928 === (42))){
var state_60927__$1 = state_60927;
var statearr_60998_61061 = state_60927__$1;
(statearr_60998_61061[(2)] = null);

(statearr_60998_61061[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (37))){
var inst_60894 = (state_60927[(30)]);
var inst_60904 = (state_60927[(2)]);
var inst_60905 = cljs.core.not_empty.call(null,inst_60894);
var state_60927__$1 = (function (){var statearr_60999 = state_60927;
(statearr_60999[(33)] = inst_60904);

return statearr_60999;
})();
if(cljs.core.truth_(inst_60905)){
var statearr_61000_61062 = state_60927__$1;
(statearr_61000_61062[(1)] = (38));

} else {
var statearr_61001_61063 = state_60927__$1;
(statearr_61001_61063[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60928 === (8))){
var inst_60813 = (state_60927[(27)]);
var inst_60800 = (state_60927[(10)]);
var inst_60813__$1 = cljs.core.seq.call(null,inst_60800);
var state_60927__$1 = (function (){var statearr_61002 = state_60927;
(statearr_61002[(27)] = inst_60813__$1);

return statearr_61002;
})();
if(inst_60813__$1){
var statearr_61003_61064 = state_60927__$1;
(statearr_61003_61064[(1)] = (10));

} else {
var statearr_61004_61065 = state_60927__$1;
(statearr_61004_61065[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files))
;
return ((function (switch__24077__auto__,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto____0 = (function (){
var statearr_61008 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61008[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto__);

(statearr_61008[(1)] = (1));

return statearr_61008;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto____1 = (function (state_60927){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_60927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e61009){if((e61009 instanceof Object)){
var ex__24081__auto__ = e61009;
var statearr_61010_61066 = state_60927;
(statearr_61010_61066[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60927);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61009;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61067 = state_60927;
state_60927 = G__61067;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto__ = function(state_60927){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto____1.call(this,state_60927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files))
})();
var state__24144__auto__ = (function (){var statearr_61011 = f__24143__auto__.call(null);
(statearr_61011[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto__);

return statearr_61011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto__,map__60785,map__60785__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__60786,map__60786__$1,msg,files))
);

return c__24142__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__61070,link){
var map__61073 = p__61070;
var map__61073__$1 = ((((!((map__61073 == null)))?((((map__61073.cljs$lang$protocol_mask$partition0$ & (64))) || (map__61073.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61073):map__61073);
var file = cljs.core.get.call(null,map__61073__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__61073,map__61073__$1,file){
return (function (p1__61068_SHARP_,p2__61069_SHARP_){
if(cljs.core._EQ_.call(null,p1__61068_SHARP_,p2__61069_SHARP_)){
return p1__61068_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__61073,map__61073__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__61079){
var map__61080 = p__61079;
var map__61080__$1 = ((((!((map__61080 == null)))?((((map__61080.cljs$lang$protocol_mask$partition0$ & (64))) || (map__61080.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61080):map__61080);
var match_length = cljs.core.get.call(null,map__61080__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__61080__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__61075_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__61075_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(){
var args61082 = [];
var len__19528__auto___61085 = arguments.length;
var i__19529__auto___61086 = (0);
while(true){
if((i__19529__auto___61086 < len__19528__auto___61085)){
args61082.push((arguments[i__19529__auto___61086]));

var G__61087 = (i__19529__auto___61086 + (1));
i__19529__auto___61086 = G__61087;
continue;
} else {
}
break;
}

var G__61084 = args61082.length;
switch (G__61084) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61082.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__61089){
var map__61092 = p__61089;
var map__61092__$1 = ((((!((map__61092 == null)))?((((map__61092.cljs$lang$protocol_mask$partition0$ & (64))) || (map__61092.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61092):map__61092);
var f_data = map__61092__$1;
var file = cljs.core.get.call(null,map__61092__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var request_url = cljs.core.get.call(null,map__61092__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var temp__4423__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4423__auto__)){
var link = temp__4423__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return figwheel.client.file_reloading.add_link_to_doc.call(null,figwheel.client.file_reloading.create_link.call(null,(function (){var or__18489__auto__ = request_url;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return file;
}
})()));
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__61094,files_msg){
var map__61117 = p__61094;
var map__61117__$1 = ((((!((map__61117 == null)))?((((map__61117.cljs$lang$protocol_mask$partition0$ & (64))) || (map__61117.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61117):map__61117);
var opts = map__61117__$1;
var on_cssload = cljs.core.get.call(null,map__61117__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__61119_61139 = cljs.core.seq.call(null,figwheel.client.file_reloading.add_request_urls.call(null,opts,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__61120_61140 = null;
var count__61121_61141 = (0);
var i__61122_61142 = (0);
while(true){
if((i__61122_61142 < count__61121_61141)){
var f_61143 = cljs.core._nth.call(null,chunk__61120_61140,i__61122_61142);
figwheel.client.file_reloading.reload_css_file.call(null,f_61143);

var G__61144 = seq__61119_61139;
var G__61145 = chunk__61120_61140;
var G__61146 = count__61121_61141;
var G__61147 = (i__61122_61142 + (1));
seq__61119_61139 = G__61144;
chunk__61120_61140 = G__61145;
count__61121_61141 = G__61146;
i__61122_61142 = G__61147;
continue;
} else {
var temp__4425__auto___61148 = cljs.core.seq.call(null,seq__61119_61139);
if(temp__4425__auto___61148){
var seq__61119_61149__$1 = temp__4425__auto___61148;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61119_61149__$1)){
var c__19273__auto___61150 = cljs.core.chunk_first.call(null,seq__61119_61149__$1);
var G__61151 = cljs.core.chunk_rest.call(null,seq__61119_61149__$1);
var G__61152 = c__19273__auto___61150;
var G__61153 = cljs.core.count.call(null,c__19273__auto___61150);
var G__61154 = (0);
seq__61119_61139 = G__61151;
chunk__61120_61140 = G__61152;
count__61121_61141 = G__61153;
i__61122_61142 = G__61154;
continue;
} else {
var f_61155 = cljs.core.first.call(null,seq__61119_61149__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_61155);

var G__61156 = cljs.core.next.call(null,seq__61119_61149__$1);
var G__61157 = null;
var G__61158 = (0);
var G__61159 = (0);
seq__61119_61139 = G__61156;
chunk__61120_61140 = G__61157;
count__61121_61141 = G__61158;
i__61122_61142 = G__61159;
continue;
}
} else {
}
}
break;
}

var c__24142__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24142__auto__,map__61117,map__61117__$1,opts,on_cssload){
return (function (){
var f__24143__auto__ = (function (){var switch__24077__auto__ = ((function (c__24142__auto__,map__61117,map__61117__$1,opts,on_cssload){
return (function (state_61129){
var state_val_61130 = (state_61129[(1)]);
if((state_val_61130 === (1))){
var inst_61123 = cljs.core.async.timeout.call(null,(100));
var state_61129__$1 = state_61129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61129__$1,(2),inst_61123);
} else {
if((state_val_61130 === (2))){
var inst_61125 = (state_61129[(2)]);
var inst_61126 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg);
var inst_61127 = on_cssload.call(null,inst_61126);
var state_61129__$1 = (function (){var statearr_61131 = state_61129;
(statearr_61131[(7)] = inst_61125);

return statearr_61131;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61129__$1,inst_61127);
} else {
return null;
}
}
});})(c__24142__auto__,map__61117,map__61117__$1,opts,on_cssload))
;
return ((function (switch__24077__auto__,c__24142__auto__,map__61117,map__61117__$1,opts,on_cssload){
return (function() {
var figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto__ = null;
var figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto____0 = (function (){
var statearr_61135 = [null,null,null,null,null,null,null,null];
(statearr_61135[(0)] = figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto__);

(statearr_61135[(1)] = (1));

return statearr_61135;
});
var figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto____1 = (function (state_61129){
while(true){
var ret_value__24079__auto__ = (function (){try{while(true){
var result__24080__auto__ = switch__24077__auto__.call(null,state_61129);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24080__auto__;
}
break;
}
}catch (e61136){if((e61136 instanceof Object)){
var ex__24081__auto__ = e61136;
var statearr_61137_61160 = state_61129;
(statearr_61137_61160[(5)] = ex__24081__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61129);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61136;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61161 = state_61129;
state_61129 = G__61161;
continue;
} else {
return ret_value__24079__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto__ = function(state_61129){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto____1.call(this,state_61129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto____0;
figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto____1;
return figwheel$client$file_reloading$reload_css_files_$_state_machine__24078__auto__;
})()
;})(switch__24077__auto__,c__24142__auto__,map__61117,map__61117__$1,opts,on_cssload))
})();
var state__24144__auto__ = (function (){var statearr_61138 = f__24143__auto__.call(null);
(statearr_61138[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24142__auto__);

return statearr_61138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24144__auto__);
});})(c__24142__auto__,map__61117,map__61117__$1,opts,on_cssload))
);

return c__24142__auto__;
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map