// Compiled by ClojureScript 1.7.48 {}
goog.provide('jkkramer.verily');
goog.require('cljs.core');
goog.require('clojure.string');
jkkramer.verily.seqify = (function jkkramer$verily$seqify(x){
if(!(cljs.core.sequential_QMARK_.call(null,x))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);
} else {
return x;
}
});
/**
 * Expands a name like "foo[bar][baz]" or :foo.bar.baz into [:foo :bar :baz]
 */
jkkramer.verily.expand_name = (function jkkramer$verily$expand_name(name){
if((typeof name === 'string') || ((name instanceof cljs.core.Keyword))){
var name_str = cljs.core.name.call(null,name);
var vec__55948 = cljs.core.re_matches.call(null,/^([^\[]+)((?:\[[^\]]+?\])*)$/,name_str);
var _ = cljs.core.nth.call(null,vec__55948,(0),null);
var name1 = cljs.core.nth.call(null,vec__55948,(1),null);
var more_names = cljs.core.nth.call(null,vec__55948,(2),null);
if(cljs.core.seq.call(null,more_names)){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,name1)], null),cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.keyword,cljs.core.second),cljs.core.re_seq.call(null,/\[([^\]]+)\]/,more_names)));
} else {
var parts = clojure.string.split.call(null,name_str,/\./);
return cljs.core.mapv.call(null,cljs.core.keyword,parts);
}
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name], null);
}
});
jkkramer.verily.make_validator = (function jkkramer$verily$make_validator(keys,bad_pred,msg){
var bad_pred_STAR_ = (function (p1__55949_SHARP_){
try{return bad_pred.call(null,p1__55949_SHARP_);
}catch (e55952){if((e55952 instanceof Error)){
var _ = e55952;
return true;
} else {
throw e55952;

}
}});
return ((function (bad_pred_STAR_){
return (function (m){
var bad_keys = cljs.core.filter.call(null,((function (bad_pred_STAR_){
return (function (p1__55950_SHARP_){
return bad_pred_STAR_.call(null,cljs.core.get.call(null,m,p1__55950_SHARP_,cljs.core.get_in.call(null,m,jkkramer.verily.expand_name.call(null,p1__55950_SHARP_),new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708))));
});})(bad_pred_STAR_))
,jkkramer.verily.seqify.call(null,keys));
if(cljs.core.seq.call(null,bad_keys)){
if(cljs.core.map_QMARK_.call(null,msg)){
return msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),bad_keys,new cljs.core.Keyword(null,"msg","msg",-1386103444),msg], null);
}
} else {
return null;
}
});
;})(bad_pred_STAR_))
});
/**
 * The keys must be present in the map but may be blank.
 */
jkkramer.verily.contains = (function jkkramer$verily$contains(){
var args__19535__auto__ = [];
var len__19528__auto___55957 = arguments.length;
var i__19529__auto___55958 = (0);
while(true){
if((i__19529__auto___55958 < len__19528__auto___55957)){
args__19535__auto__.push((arguments[i__19529__auto___55958]));

var G__55959 = (i__19529__auto___55958 + (1));
i__19529__auto___55958 = G__55959;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.contains.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.contains.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__55955){
var vec__55956 = p__55955;
var msg = cljs.core.nth.call(null,vec__55956,(0),null);
return jkkramer.verily.make_validator.call(null,keys,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),null], null), null),(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be present";
}
})());
});

jkkramer.verily.contains.cljs$lang$maxFixedArity = (1);

jkkramer.verily.contains.cljs$lang$applyTo = (function (seq55953){
var G__55954 = cljs.core.first.call(null,seq55953);
var seq55953__$1 = cljs.core.next.call(null,seq55953);
return jkkramer.verily.contains.cljs$core$IFn$_invoke$arity$variadic(G__55954,seq55953__$1);
});
/**
 * The keys must be present in the map AND not be blank.
 */
jkkramer.verily.required = (function jkkramer$verily$required(){
var args__19535__auto__ = [];
var len__19528__auto___55965 = arguments.length;
var i__19529__auto___55966 = (0);
while(true){
if((i__19529__auto___55966 < len__19528__auto___55965)){
args__19535__auto__.push((arguments[i__19529__auto___55966]));

var G__55967 = (i__19529__auto___55966 + (1));
i__19529__auto___55966 = G__55967;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.required.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.required.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__55963){
var vec__55964 = p__55963;
var msg = cljs.core.nth.call(null,vec__55964,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__55964,msg){
return (function (p1__55960_SHARP_){
var or__18489__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__55960_SHARP_);
if(or__18489__auto__){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = (p1__55960_SHARP_ == null);
if(or__18489__auto____$1){
return or__18489__auto____$1;
} else {
var and__18477__auto__ = typeof p1__55960_SHARP_ === 'string';
if(and__18477__auto__){
return clojure.string.blank_QMARK_.call(null,p1__55960_SHARP_);
} else {
return and__18477__auto__;
}
}
}
});})(vec__55964,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must not be blank";
}
})());
});

jkkramer.verily.required.cljs$lang$maxFixedArity = (1);

jkkramer.verily.required.cljs$lang$applyTo = (function (seq55961){
var G__55962 = cljs.core.first.call(null,seq55961);
var seq55961__$1 = cljs.core.next.call(null,seq55961);
return jkkramer.verily.required.cljs$core$IFn$_invoke$arity$variadic(G__55962,seq55961__$1);
});
jkkramer.verily.complete = (function jkkramer$verily$complete(){
var args__19535__auto__ = [];
var len__19528__auto___55974 = arguments.length;
var i__19529__auto___55975 = (0);
while(true){
if((i__19529__auto___55975 < len__19528__auto___55974)){
args__19535__auto__.push((arguments[i__19529__auto___55975]));

var G__55976 = (i__19529__auto___55975 + (1));
i__19529__auto___55975 = G__55976;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.complete.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.complete.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__55972){
var vec__55973 = p__55972;
var msg = cljs.core.nth.call(null,vec__55973,(0),null);

var bad_QMARK_ = ((function (vec__55973,msg){
return (function (p1__55968_SHARP_){
var or__18489__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__55968_SHARP_);
if(or__18489__auto__){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = (p1__55968_SHARP_ == null);
if(or__18489__auto____$1){
return or__18489__auto____$1;
} else {
var and__18477__auto__ = typeof p1__55968_SHARP_ === 'string';
if(and__18477__auto__){
return clojure.string.blank_QMARK_.call(null,p1__55968_SHARP_);
} else {
return and__18477__auto__;
}
}
}
});})(vec__55973,msg))
;
return jkkramer.verily.make_validator.call(null,keys,((function (bad_QMARK_,vec__55973,msg){
return (function (p1__55969_SHARP_){
var or__18489__auto__ = bad_QMARK_.call(null,p1__55969_SHARP_);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = !(cljs.core.coll_QMARK_.call(null,p1__55969_SHARP_));
if(or__18489__auto____$1){
return or__18489__auto____$1;
} else {
var or__18489__auto____$2 = (function (){var and__18477__auto__ = cljs.core.map_QMARK_.call(null,p1__55969_SHARP_);
if(and__18477__auto__){
return cljs.core.some.call(null,bad_QMARK_,cljs.core.vals.call(null,p1__55969_SHARP_));
} else {
return and__18477__auto__;
}
})();
if(cljs.core.truth_(or__18489__auto____$2)){
return or__18489__auto____$2;
} else {
var and__18477__auto__ = cljs.core.coll_QMARK_.call(null,p1__55969_SHARP_);
if(and__18477__auto__){
return cljs.core.some.call(null,bad_QMARK_,p1__55969_SHARP_);
} else {
return and__18477__auto__;
}
}
}
}
});})(bad_QMARK_,vec__55973,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("must not be incomplete")].join('');
}
})());
});

jkkramer.verily.complete.cljs$lang$maxFixedArity = (1);

jkkramer.verily.complete.cljs$lang$applyTo = (function (seq55970){
var G__55971 = cljs.core.first.call(null,seq55970);
var seq55970__$1 = cljs.core.next.call(null,seq55970);
return jkkramer.verily.complete.cljs$core$IFn$_invoke$arity$variadic(G__55971,seq55970__$1);
});
/**
 * If present, the keys must not be blank.
 */
jkkramer.verily.not_blank = (function jkkramer$verily$not_blank(){
var args__19535__auto__ = [];
var len__19528__auto___55982 = arguments.length;
var i__19529__auto___55983 = (0);
while(true){
if((i__19529__auto___55983 < len__19528__auto___55982)){
args__19535__auto__.push((arguments[i__19529__auto___55983]));

var G__55984 = (i__19529__auto___55983 + (1));
i__19529__auto___55983 = G__55984;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.not_blank.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.not_blank.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__55980){
var vec__55981 = p__55980;
var msg = cljs.core.nth.call(null,vec__55981,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__55981,msg){
return (function (p1__55977_SHARP_){
var or__18489__auto__ = (p1__55977_SHARP_ == null);
if(or__18489__auto__){
return or__18489__auto__;
} else {
var and__18477__auto__ = typeof p1__55977_SHARP_ === 'string';
if(and__18477__auto__){
return clojure.string.blank_QMARK_.call(null,p1__55977_SHARP_);
} else {
return and__18477__auto__;
}
}
});})(vec__55981,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must not be blank";
}
})());
});

jkkramer.verily.not_blank.cljs$lang$maxFixedArity = (1);

jkkramer.verily.not_blank.cljs$lang$applyTo = (function (seq55978){
var G__55979 = cljs.core.first.call(null,seq55978);
var seq55978__$1 = cljs.core.next.call(null,seq55978);
return jkkramer.verily.not_blank.cljs$core$IFn$_invoke$arity$variadic(G__55979,seq55978__$1);
});
jkkramer.verily.exact = (function jkkramer$verily$exact(){
var args__19535__auto__ = [];
var len__19528__auto___55991 = arguments.length;
var i__19529__auto___55992 = (0);
while(true){
if((i__19529__auto___55992 < len__19528__auto___55991)){
args__19535__auto__.push((arguments[i__19529__auto___55992]));

var G__55993 = (i__19529__auto___55992 + (1));
i__19529__auto___55992 = G__55993;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.exact.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.exact.cljs$core$IFn$_invoke$arity$variadic = (function (val,keys,p__55989){
var vec__55990 = p__55989;
var msg = cljs.core.nth.call(null,vec__55990,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__55990,msg){
return (function (p1__55985_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__55985_SHARP_)) && (cljs.core.not_EQ_.call(null,val,p1__55985_SHARP_));
});})(vec__55990,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "incorrect value";
}
})());
});

jkkramer.verily.exact.cljs$lang$maxFixedArity = (2);

jkkramer.verily.exact.cljs$lang$applyTo = (function (seq55986){
var G__55987 = cljs.core.first.call(null,seq55986);
var seq55986__$1 = cljs.core.next.call(null,seq55986);
var G__55988 = cljs.core.first.call(null,seq55986__$1);
var seq55986__$2 = cljs.core.next.call(null,seq55986__$1);
return jkkramer.verily.exact.cljs$core$IFn$_invoke$arity$variadic(G__55987,G__55988,seq55986__$2);
});
jkkramer.verily.equal = (function jkkramer$verily$equal(){
var args__19535__auto__ = [];
var len__19528__auto___55999 = arguments.length;
var i__19529__auto___56000 = (0);
while(true){
if((i__19529__auto___56000 < len__19528__auto___55999)){
args__19535__auto__.push((arguments[i__19529__auto___56000]));

var G__56001 = (i__19529__auto___56000 + (1));
i__19529__auto___56000 = G__56001;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.equal.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.equal.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__55997){
var vec__55998 = p__55997;
var msg = cljs.core.nth.call(null,vec__55998,(0),null);
var keys__$1 = jkkramer.verily.seqify.call(null,keys);
return ((function (keys__$1,vec__55998,msg){
return (function (m){
if(cljs.core.truth_(cljs.core.apply.call(null,cljs.core._EQ_,cljs.core.map.call(null,((function (keys__$1,vec__55998,msg){
return (function (p1__55994_SHARP_){
return cljs.core.get.call(null,m,p1__55994_SHARP_,cljs.core.get_in.call(null,m,jkkramer.verily.expand_name.call(null,p1__55994_SHARP_)));
});})(keys__$1,vec__55998,msg))
,keys__$1)))){
return null;
} else {
if(cljs.core.map_QMARK_.call(null,msg)){
return msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),keys__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444),(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be equal";
}
})()], null);
}
}
});
;})(keys__$1,vec__55998,msg))
});

jkkramer.verily.equal.cljs$lang$maxFixedArity = (1);

jkkramer.verily.equal.cljs$lang$applyTo = (function (seq55995){
var G__55996 = cljs.core.first.call(null,seq55995);
var seq55995__$1 = cljs.core.next.call(null,seq55995);
return jkkramer.verily.equal.cljs$core$IFn$_invoke$arity$variadic(G__55996,seq55995__$1);
});
jkkramer.verily.matches = (function jkkramer$verily$matches(){
var args__19535__auto__ = [];
var len__19528__auto___56008 = arguments.length;
var i__19529__auto___56009 = (0);
while(true){
if((i__19529__auto___56009 < len__19528__auto___56008)){
args__19535__auto__.push((arguments[i__19529__auto___56009]));

var G__56010 = (i__19529__auto___56009 + (1));
i__19529__auto___56009 = G__56010;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.matches.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.matches.cljs$core$IFn$_invoke$arity$variadic = (function (re,keys,p__56006){
var vec__56007 = p__56006;
var msg = cljs.core.nth.call(null,vec__56007,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56007,msg){
return (function (p1__56002_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56002_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__56002_SHARP_))) && (cljs.core.not.call(null,cljs.core.re_matches.call(null,re,p1__56002_SHARP_)));
});})(vec__56007,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "incorrect format";
}
})());
});

jkkramer.verily.matches.cljs$lang$maxFixedArity = (2);

jkkramer.verily.matches.cljs$lang$applyTo = (function (seq56003){
var G__56004 = cljs.core.first.call(null,seq56003);
var seq56003__$1 = cljs.core.next.call(null,seq56003);
var G__56005 = cljs.core.first.call(null,seq56003__$1);
var seq56003__$2 = cljs.core.next.call(null,seq56003__$1);
return jkkramer.verily.matches.cljs$core$IFn$_invoke$arity$variadic(G__56004,G__56005,seq56003__$2);
});
jkkramer.verily.min_length = (function jkkramer$verily$min_length(){
var args__19535__auto__ = [];
var len__19528__auto___56017 = arguments.length;
var i__19529__auto___56018 = (0);
while(true){
if((i__19529__auto___56018 < len__19528__auto___56017)){
args__19535__auto__.push((arguments[i__19529__auto___56018]));

var G__56019 = (i__19529__auto___56018 + (1));
i__19529__auto___56018 = G__56019;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.min_length.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.min_length.cljs$core$IFn$_invoke$arity$variadic = (function (len,keys,p__56015){
var vec__56016 = p__56015;
var msg = cljs.core.nth.call(null,vec__56016,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56016,msg){
return (function (p1__56011_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56011_SHARP_)) && (!((p1__56011_SHARP_ == null))) && (!((len <= cljs.core.count.call(null,p1__56011_SHARP_))));
});})(vec__56016,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("must be at least "),cljs.core.str(len),cljs.core.str(" characters")].join('');
}
})());
});

jkkramer.verily.min_length.cljs$lang$maxFixedArity = (2);

jkkramer.verily.min_length.cljs$lang$applyTo = (function (seq56012){
var G__56013 = cljs.core.first.call(null,seq56012);
var seq56012__$1 = cljs.core.next.call(null,seq56012);
var G__56014 = cljs.core.first.call(null,seq56012__$1);
var seq56012__$2 = cljs.core.next.call(null,seq56012__$1);
return jkkramer.verily.min_length.cljs$core$IFn$_invoke$arity$variadic(G__56013,G__56014,seq56012__$2);
});
jkkramer.verily.max_length = (function jkkramer$verily$max_length(){
var args__19535__auto__ = [];
var len__19528__auto___56026 = arguments.length;
var i__19529__auto___56027 = (0);
while(true){
if((i__19529__auto___56027 < len__19528__auto___56026)){
args__19535__auto__.push((arguments[i__19529__auto___56027]));

var G__56028 = (i__19529__auto___56027 + (1));
i__19529__auto___56027 = G__56028;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.max_length.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.max_length.cljs$core$IFn$_invoke$arity$variadic = (function (len,keys,p__56024){
var vec__56025 = p__56024;
var msg = cljs.core.nth.call(null,vec__56025,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56025,msg){
return (function (p1__56020_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56020_SHARP_)) && (!((p1__56020_SHARP_ == null))) && (!((len >= cljs.core.count.call(null,p1__56020_SHARP_))));
});})(vec__56025,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("cannot exceed "),cljs.core.str(len),cljs.core.str(" characters")].join('');
}
})());
});

jkkramer.verily.max_length.cljs$lang$maxFixedArity = (2);

jkkramer.verily.max_length.cljs$lang$applyTo = (function (seq56021){
var G__56022 = cljs.core.first.call(null,seq56021);
var seq56021__$1 = cljs.core.next.call(null,seq56021);
var G__56023 = cljs.core.first.call(null,seq56021__$1);
var seq56021__$2 = cljs.core.next.call(null,seq56021__$1);
return jkkramer.verily.max_length.cljs$core$IFn$_invoke$arity$variadic(G__56022,G__56023,seq56021__$2);
});
jkkramer.verily.in$ = (function jkkramer$verily$in(){
var args__19535__auto__ = [];
var len__19528__auto___56035 = arguments.length;
var i__19529__auto___56036 = (0);
while(true){
if((i__19529__auto___56036 < len__19528__auto___56035)){
args__19535__auto__.push((arguments[i__19529__auto___56036]));

var G__56037 = (i__19529__auto___56036 + (1));
i__19529__auto___56036 = G__56037;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.in$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.in$.cljs$core$IFn$_invoke$arity$variadic = (function (coll,keys,p__56033){
var vec__56034 = p__56033;
var msg = cljs.core.nth.call(null,vec__56034,(0),null);
var coll_set = ((cljs.core.set_QMARK_.call(null,coll))?coll:cljs.core.set.call(null,coll));
return jkkramer.verily.make_validator.call(null,keys,((function (coll_set,vec__56034,msg){
return (function (p1__56029_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56029_SHARP_)) && (!((p1__56029_SHARP_ == null))) && (!(cljs.core.contains_QMARK_.call(null,coll_set,p1__56029_SHARP_)));
});})(coll_set,vec__56034,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("not an accepted value")].join('');
}
})());
});

jkkramer.verily.in$.cljs$lang$maxFixedArity = (2);

jkkramer.verily.in$.cljs$lang$applyTo = (function (seq56030){
var G__56031 = cljs.core.first.call(null,seq56030);
var seq56030__$1 = cljs.core.next.call(null,seq56030);
var G__56032 = cljs.core.first.call(null,seq56030__$1);
var seq56030__$2 = cljs.core.next.call(null,seq56030__$1);
return jkkramer.verily.in$.cljs$core$IFn$_invoke$arity$variadic(G__56031,G__56032,seq56030__$2);
});
jkkramer.verily.every_in = (function jkkramer$verily$every_in(){
var args__19535__auto__ = [];
var len__19528__auto___56044 = arguments.length;
var i__19529__auto___56045 = (0);
while(true){
if((i__19529__auto___56045 < len__19528__auto___56044)){
args__19535__auto__.push((arguments[i__19529__auto___56045]));

var G__56046 = (i__19529__auto___56045 + (1));
i__19529__auto___56045 = G__56046;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.every_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.every_in.cljs$core$IFn$_invoke$arity$variadic = (function (coll,keys,p__56042){
var vec__56043 = p__56042;
var msg = cljs.core.nth.call(null,vec__56043,(0),null);
var coll_set = ((cljs.core.set_QMARK_.call(null,coll))?coll:cljs.core.set.call(null,coll));
return jkkramer.verily.make_validator.call(null,keys,((function (coll_set,vec__56043,msg){
return (function (p1__56038_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56038_SHARP_)) && (!((p1__56038_SHARP_ == null))) && (!(cljs.core.every_QMARK_.call(null,((function (coll_set,vec__56043,msg){
return (function (x){
return cljs.core.contains_QMARK_.call(null,coll_set,x);
});})(coll_set,vec__56043,msg))
,p1__56038_SHARP_)));
});})(coll_set,vec__56043,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("not an accepted value")].join('');
}
})());
});

jkkramer.verily.every_in.cljs$lang$maxFixedArity = (2);

jkkramer.verily.every_in.cljs$lang$applyTo = (function (seq56039){
var G__56040 = cljs.core.first.call(null,seq56039);
var seq56039__$1 = cljs.core.next.call(null,seq56039);
var G__56041 = cljs.core.first.call(null,seq56039__$1);
var seq56039__$2 = cljs.core.next.call(null,seq56039__$1);
return jkkramer.verily.every_in.cljs$core$IFn$_invoke$arity$variadic(G__56040,G__56041,seq56039__$2);
});
jkkramer.verily.zip_regex = /^\d{5}(?:[-\s]\d{4})?$/;
jkkramer.verily.us_zip = (function jkkramer$verily$us_zip(){
var args__19535__auto__ = [];
var len__19528__auto___56052 = arguments.length;
var i__19529__auto___56053 = (0);
while(true){
if((i__19529__auto___56053 < len__19528__auto___56052)){
args__19535__auto__.push((arguments[i__19529__auto___56053]));

var G__56054 = (i__19529__auto___56053 + (1));
i__19529__auto___56053 = G__56054;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.us_zip.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.us_zip.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56050){
var vec__56051 = p__56050;
var msg = cljs.core.nth.call(null,vec__56051,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56051,msg){
return (function (p1__56047_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56047_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__56047_SHARP_))) && (cljs.core.not.call(null,cljs.core.re_matches.call(null,jkkramer.verily.zip_regex,p1__56047_SHARP_)));
});})(vec__56051,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a valid US zip code";
}
})());
});

jkkramer.verily.us_zip.cljs$lang$maxFixedArity = (1);

jkkramer.verily.us_zip.cljs$lang$applyTo = (function (seq56048){
var G__56049 = cljs.core.first.call(null,seq56048);
var seq56048__$1 = cljs.core.next.call(null,seq56048);
return jkkramer.verily.us_zip.cljs$core$IFn$_invoke$arity$variadic(G__56049,seq56048__$1);
});
jkkramer.verily.email = (function jkkramer$verily$email(){
var args__19535__auto__ = [];
var len__19528__auto___56060 = arguments.length;
var i__19529__auto___56061 = (0);
while(true){
if((i__19529__auto___56061 < len__19528__auto___56060)){
args__19535__auto__.push((arguments[i__19529__auto___56061]));

var G__56062 = (i__19529__auto___56061 + (1));
i__19529__auto___56061 = G__56062;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.email.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.email.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56058){
var vec__56059 = p__56058;
var msg = cljs.core.nth.call(null,vec__56059,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56059,msg){
return (function (p1__56055_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56055_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__56055_SHARP_))) && (cljs.core.not.call(null,cljs.core.re_matches.call(null,/[^^]+@[^$]+/,p1__56055_SHARP_)));
});})(vec__56059,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a valid email";
}
})());
});

jkkramer.verily.email.cljs$lang$maxFixedArity = (1);

jkkramer.verily.email.cljs$lang$applyTo = (function (seq56056){
var G__56057 = cljs.core.first.call(null,seq56056);
var seq56056__$1 = cljs.core.next.call(null,seq56056);
return jkkramer.verily.email.cljs$core$IFn$_invoke$arity$variadic(G__56057,seq56056__$1);
});
jkkramer.verily.web_url = (function jkkramer$verily$web_url(){
var args__19535__auto__ = [];
var len__19528__auto___56072 = arguments.length;
var i__19529__auto___56073 = (0);
while(true){
if((i__19529__auto___56073 < len__19528__auto___56072)){
args__19535__auto__.push((arguments[i__19529__auto___56073]));

var G__56074 = (i__19529__auto___56073 + (1));
i__19529__auto___56073 = G__56074;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.web_url.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.web_url.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56066){
var vec__56067 = p__56066;
var msg = cljs.core.nth.call(null,vec__56067,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56067,msg){
return (function (p1__56063_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56063_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__56063_SHARP_))) && ((cljs.core.not.call(null,(function (){try{return true;
}catch (e56071){if((e56071 instanceof Error)){
var _ = e56071;
return null;
} else {
throw e56071;

}
}})())) || (cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,p1__56063_SHARP_))));
});})(vec__56067,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a valid website URL";
}
})());
});

jkkramer.verily.web_url.cljs$lang$maxFixedArity = (1);

jkkramer.verily.web_url.cljs$lang$applyTo = (function (seq56064){
var G__56065 = cljs.core.first.call(null,seq56064);
var seq56064__$1 = cljs.core.next.call(null,seq56064);
return jkkramer.verily.web_url.cljs$core$IFn$_invoke$arity$variadic(G__56065,seq56064__$1);
});
jkkramer.verily.url = (function jkkramer$verily$url(){
var args__19535__auto__ = [];
var len__19528__auto___56082 = arguments.length;
var i__19529__auto___56083 = (0);
while(true){
if((i__19529__auto___56083 < len__19528__auto___56082)){
args__19535__auto__.push((arguments[i__19529__auto___56083]));

var G__56084 = (i__19529__auto___56083 + (1));
i__19529__auto___56083 = G__56084;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.url.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.url.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56078){
var vec__56079 = p__56078;
var msg = cljs.core.nth.call(null,vec__56079,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56079,msg){
return (function (p1__56075_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56075_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__56075_SHARP_))) && (cljs.core.not.call(null,(function (){try{return cljs.core.re_find.call(null,/^[a-zA-Z]+:\/\//,p1__56075_SHARP_);
}catch (e56081){if((e56081 instanceof Error)){
var _ = e56081;
return null;
} else {
throw e56081;

}
}})()));
});})(vec__56079,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a valid URL";
}
})());
});

jkkramer.verily.url.cljs$lang$maxFixedArity = (1);

jkkramer.verily.url.cljs$lang$applyTo = (function (seq56076){
var G__56077 = cljs.core.first.call(null,seq56076);
var seq56076__$1 = cljs.core.next.call(null,seq56076);
return jkkramer.verily.url.cljs$core$IFn$_invoke$arity$variadic(G__56077,seq56076__$1);
});
jkkramer.verily.string = (function jkkramer$verily$string(){
var args__19535__auto__ = [];
var len__19528__auto___56090 = arguments.length;
var i__19529__auto___56091 = (0);
while(true){
if((i__19529__auto___56091 < len__19528__auto___56090)){
args__19535__auto__.push((arguments[i__19529__auto___56091]));

var G__56092 = (i__19529__auto___56091 + (1));
i__19529__auto___56091 = G__56092;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.string.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.string.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56088){
var vec__56089 = p__56088;
var msg = cljs.core.nth.call(null,vec__56089,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56089,msg){
return (function (p1__56085_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56085_SHARP_)) && (!((p1__56085_SHARP_ == null))) && (!(typeof p1__56085_SHARP_ === 'string'));
});})(vec__56089,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a string";
}
})());
});

jkkramer.verily.string.cljs$lang$maxFixedArity = (1);

jkkramer.verily.string.cljs$lang$applyTo = (function (seq56086){
var G__56087 = cljs.core.first.call(null,seq56086);
var seq56086__$1 = cljs.core.next.call(null,seq56086);
return jkkramer.verily.string.cljs$core$IFn$_invoke$arity$variadic(G__56087,seq56086__$1);
});
jkkramer.verily.strings = (function jkkramer$verily$strings(){
var args__19535__auto__ = [];
var len__19528__auto___56098 = arguments.length;
var i__19529__auto___56099 = (0);
while(true){
if((i__19529__auto___56099 < len__19528__auto___56098)){
args__19535__auto__.push((arguments[i__19529__auto___56099]));

var G__56100 = (i__19529__auto___56099 + (1));
i__19529__auto___56099 = G__56100;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.strings.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.strings.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56096){
var vec__56097 = p__56096;
var msg = cljs.core.nth.call(null,vec__56097,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56097,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__56097,msg){
return (function (p1__56093_SHARP_){
return !(typeof p1__56093_SHARP_ === 'string');
});})(or__18489__auto__,and__18477__auto__,vec__56097,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__56097,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be strings";
}
})());
});

jkkramer.verily.strings.cljs$lang$maxFixedArity = (1);

jkkramer.verily.strings.cljs$lang$applyTo = (function (seq56094){
var G__56095 = cljs.core.first.call(null,seq56094);
var seq56094__$1 = cljs.core.next.call(null,seq56094);
return jkkramer.verily.strings.cljs$core$IFn$_invoke$arity$variadic(G__56095,seq56094__$1);
});
jkkramer.verily.bool = (function jkkramer$verily$bool(){
var args__19535__auto__ = [];
var len__19528__auto___56106 = arguments.length;
var i__19529__auto___56107 = (0);
while(true){
if((i__19529__auto___56107 < len__19528__auto___56106)){
args__19535__auto__.push((arguments[i__19529__auto___56107]));

var G__56108 = (i__19529__auto___56107 + (1));
i__19529__auto___56107 = G__56108;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.bool.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.bool.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56104){
var vec__56105 = p__56104;
var msg = cljs.core.nth.call(null,vec__56105,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56105,msg){
return (function (p1__56101_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56101_SHARP_)) && (!((p1__56101_SHARP_ == null))) && (!(p1__56101_SHARP_ === true)) && (!(p1__56101_SHARP_ === false));
});})(vec__56105,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be true or false";
}
})());
});

jkkramer.verily.bool.cljs$lang$maxFixedArity = (1);

jkkramer.verily.bool.cljs$lang$applyTo = (function (seq56102){
var G__56103 = cljs.core.first.call(null,seq56102);
var seq56102__$1 = cljs.core.next.call(null,seq56102);
return jkkramer.verily.bool.cljs$core$IFn$_invoke$arity$variadic(G__56103,seq56102__$1);
});
jkkramer.verily.bools = (function jkkramer$verily$bools(){
var args__19535__auto__ = [];
var len__19528__auto___56114 = arguments.length;
var i__19529__auto___56115 = (0);
while(true){
if((i__19529__auto___56115 < len__19528__auto___56114)){
args__19535__auto__.push((arguments[i__19529__auto___56115]));

var G__56116 = (i__19529__auto___56115 + (1));
i__19529__auto___56115 = G__56116;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.bools.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.bools.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56112){
var vec__56113 = p__56112;
var msg = cljs.core.nth.call(null,vec__56113,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56113,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__56113,msg){
return (function (p1__56109_SHARP_){
return (!(p1__56109_SHARP_ === true)) && (!(p1__56109_SHARP_ === false));
});})(or__18489__auto__,and__18477__auto__,vec__56113,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__56113,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be all true or false";
}
})());
});

jkkramer.verily.bools.cljs$lang$maxFixedArity = (1);

jkkramer.verily.bools.cljs$lang$applyTo = (function (seq56110){
var G__56111 = cljs.core.first.call(null,seq56110);
var seq56110__$1 = cljs.core.next.call(null,seq56110);
return jkkramer.verily.bools.cljs$core$IFn$_invoke$arity$variadic(G__56111,seq56110__$1);
});
jkkramer.verily.integer = (function jkkramer$verily$integer(){
var args__19535__auto__ = [];
var len__19528__auto___56122 = arguments.length;
var i__19529__auto___56123 = (0);
while(true){
if((i__19529__auto___56123 < len__19528__auto___56122)){
args__19535__auto__.push((arguments[i__19529__auto___56123]));

var G__56124 = (i__19529__auto___56123 + (1));
i__19529__auto___56123 = G__56124;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.integer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.integer.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56120){
var vec__56121 = p__56120;
var msg = cljs.core.nth.call(null,vec__56121,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56121,msg){
return (function (p1__56117_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56117_SHARP_)) && (!((p1__56117_SHARP_ == null))) && (!(cljs.core.integer_QMARK_.call(null,p1__56117_SHARP_)));
});})(vec__56121,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a number";
}
})());
});

jkkramer.verily.integer.cljs$lang$maxFixedArity = (1);

jkkramer.verily.integer.cljs$lang$applyTo = (function (seq56118){
var G__56119 = cljs.core.first.call(null,seq56118);
var seq56118__$1 = cljs.core.next.call(null,seq56118);
return jkkramer.verily.integer.cljs$core$IFn$_invoke$arity$variadic(G__56119,seq56118__$1);
});
jkkramer.verily.integers = (function jkkramer$verily$integers(){
var args__19535__auto__ = [];
var len__19528__auto___56130 = arguments.length;
var i__19529__auto___56131 = (0);
while(true){
if((i__19529__auto___56131 < len__19528__auto___56130)){
args__19535__auto__.push((arguments[i__19529__auto___56131]));

var G__56132 = (i__19529__auto___56131 + (1));
i__19529__auto___56131 = G__56132;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.integers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.integers.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56128){
var vec__56129 = p__56128;
var msg = cljs.core.nth.call(null,vec__56129,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56129,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__56129,msg){
return (function (p1__56125_SHARP_){
return !(cljs.core.integer_QMARK_.call(null,p1__56125_SHARP_));
});})(or__18489__auto__,and__18477__auto__,vec__56129,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__56129,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be numbers";
}
})());
});

jkkramer.verily.integers.cljs$lang$maxFixedArity = (1);

jkkramer.verily.integers.cljs$lang$applyTo = (function (seq56126){
var G__56127 = cljs.core.first.call(null,seq56126);
var seq56126__$1 = cljs.core.next.call(null,seq56126);
return jkkramer.verily.integers.cljs$core$IFn$_invoke$arity$variadic(G__56127,seq56126__$1);
});
jkkramer.verily.floating_point = (function jkkramer$verily$floating_point(){
var args__19535__auto__ = [];
var len__19528__auto___56138 = arguments.length;
var i__19529__auto___56139 = (0);
while(true){
if((i__19529__auto___56139 < len__19528__auto___56138)){
args__19535__auto__.push((arguments[i__19529__auto___56139]));

var G__56140 = (i__19529__auto___56139 + (1));
i__19529__auto___56139 = G__56140;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.floating_point.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.floating_point.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56136){
var vec__56137 = p__56136;
var msg = cljs.core.nth.call(null,vec__56137,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56137,msg){
return (function (p1__56133_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56133_SHARP_)) && (!((p1__56133_SHARP_ == null))) && (!(typeof p1__56133_SHARP_ === 'number'));
});})(vec__56137,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a decimal number";
}
})());
});

jkkramer.verily.floating_point.cljs$lang$maxFixedArity = (1);

jkkramer.verily.floating_point.cljs$lang$applyTo = (function (seq56134){
var G__56135 = cljs.core.first.call(null,seq56134);
var seq56134__$1 = cljs.core.next.call(null,seq56134);
return jkkramer.verily.floating_point.cljs$core$IFn$_invoke$arity$variadic(G__56135,seq56134__$1);
});
jkkramer.verily.floating_points = (function jkkramer$verily$floating_points(){
var args__19535__auto__ = [];
var len__19528__auto___56146 = arguments.length;
var i__19529__auto___56147 = (0);
while(true){
if((i__19529__auto___56147 < len__19528__auto___56146)){
args__19535__auto__.push((arguments[i__19529__auto___56147]));

var G__56148 = (i__19529__auto___56147 + (1));
i__19529__auto___56147 = G__56148;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.floating_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.floating_points.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56144){
var vec__56145 = p__56144;
var msg = cljs.core.nth.call(null,vec__56145,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56145,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__56145,msg){
return (function (p1__56141_SHARP_){
return !(typeof p1__56141_SHARP_ === 'number');
});})(or__18489__auto__,and__18477__auto__,vec__56145,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__56145,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be decimal numbers";
}
})());
});

jkkramer.verily.floating_points.cljs$lang$maxFixedArity = (1);

jkkramer.verily.floating_points.cljs$lang$applyTo = (function (seq56142){
var G__56143 = cljs.core.first.call(null,seq56142);
var seq56142__$1 = cljs.core.next.call(null,seq56142);
return jkkramer.verily.floating_points.cljs$core$IFn$_invoke$arity$variadic(G__56143,seq56142__$1);
});
jkkramer.verily.decimal_str_QMARK_ = (function jkkramer$verily$decimal_str_QMARK_(x){
var and__18477__auto__ = typeof x === 'string';
if(and__18477__auto__){
return cljs.core.re_matches.call(null,/[0-9\.]+/,x);
} else {
return and__18477__auto__;
}
});
jkkramer.verily.decimal = (function jkkramer$verily$decimal(){
var args__19535__auto__ = [];
var len__19528__auto___56154 = arguments.length;
var i__19529__auto___56155 = (0);
while(true){
if((i__19529__auto___56155 < len__19528__auto___56154)){
args__19535__auto__.push((arguments[i__19529__auto___56155]));

var G__56156 = (i__19529__auto___56155 + (1));
i__19529__auto___56155 = G__56156;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.decimal.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.decimal.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56152){
var vec__56153 = p__56152;
var msg = cljs.core.nth.call(null,vec__56153,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56153,msg){
return (function (p1__56149_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56149_SHARP_)) && (!((p1__56149_SHARP_ == null))) && (cljs.core.not.call(null,jkkramer.verily.decimal_str_QMARK_.call(null,p1__56149_SHARP_)));
});})(vec__56153,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a decimal number";
}
})());
});

jkkramer.verily.decimal.cljs$lang$maxFixedArity = (1);

jkkramer.verily.decimal.cljs$lang$applyTo = (function (seq56150){
var G__56151 = cljs.core.first.call(null,seq56150);
var seq56150__$1 = cljs.core.next.call(null,seq56150);
return jkkramer.verily.decimal.cljs$core$IFn$_invoke$arity$variadic(G__56151,seq56150__$1);
});
jkkramer.verily.decimals = (function jkkramer$verily$decimals(){
var args__19535__auto__ = [];
var len__19528__auto___56162 = arguments.length;
var i__19529__auto___56163 = (0);
while(true){
if((i__19529__auto___56163 < len__19528__auto___56162)){
args__19535__auto__.push((arguments[i__19529__auto___56163]));

var G__56164 = (i__19529__auto___56163 + (1));
i__19529__auto___56163 = G__56164;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.decimals.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.decimals.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56160){
var vec__56161 = p__56160;
var msg = cljs.core.nth.call(null,vec__56161,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56161,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__56161,msg){
return (function (p1__56157_SHARP_){
return cljs.core.not.call(null,jkkramer.verily.decimal_str_QMARK_.call(null,p1__56157_SHARP_));
});})(or__18489__auto__,and__18477__auto__,vec__56161,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__56161,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be decimal numbers";
}
})());
});

jkkramer.verily.decimals.cljs$lang$maxFixedArity = (1);

jkkramer.verily.decimals.cljs$lang$applyTo = (function (seq56158){
var G__56159 = cljs.core.first.call(null,seq56158);
var seq56158__$1 = cljs.core.next.call(null,seq56158);
return jkkramer.verily.decimals.cljs$core$IFn$_invoke$arity$variadic(G__56159,seq56158__$1);
});
jkkramer.verily.min_val = (function jkkramer$verily$min_val(){
var args__19535__auto__ = [];
var len__19528__auto___56171 = arguments.length;
var i__19529__auto___56172 = (0);
while(true){
if((i__19529__auto___56172 < len__19528__auto___56171)){
args__19535__auto__.push((arguments[i__19529__auto___56172]));

var G__56173 = (i__19529__auto___56172 + (1));
i__19529__auto___56172 = G__56173;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.min_val.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.min_val.cljs$core$IFn$_invoke$arity$variadic = (function (min,keys,p__56169){
var vec__56170 = p__56169;
var msg = cljs.core.nth.call(null,vec__56170,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56170,msg){
return (function (p1__56165_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56165_SHARP_)) && (!((p1__56165_SHARP_ == null))) && ((!(typeof p1__56165_SHARP_ === 'number')) || ((min > p1__56165_SHARP_)));
});})(vec__56170,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("cannot be less than "),cljs.core.str(min)].join('');
}
})());
});

jkkramer.verily.min_val.cljs$lang$maxFixedArity = (2);

jkkramer.verily.min_val.cljs$lang$applyTo = (function (seq56166){
var G__56167 = cljs.core.first.call(null,seq56166);
var seq56166__$1 = cljs.core.next.call(null,seq56166);
var G__56168 = cljs.core.first.call(null,seq56166__$1);
var seq56166__$2 = cljs.core.next.call(null,seq56166__$1);
return jkkramer.verily.min_val.cljs$core$IFn$_invoke$arity$variadic(G__56167,G__56168,seq56166__$2);
});
jkkramer.verily.at_least = jkkramer.verily.min_val;
jkkramer.verily.max_val = (function jkkramer$verily$max_val(){
var args__19535__auto__ = [];
var len__19528__auto___56180 = arguments.length;
var i__19529__auto___56181 = (0);
while(true){
if((i__19529__auto___56181 < len__19528__auto___56180)){
args__19535__auto__.push((arguments[i__19529__auto___56181]));

var G__56182 = (i__19529__auto___56181 + (1));
i__19529__auto___56181 = G__56182;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.max_val.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.max_val.cljs$core$IFn$_invoke$arity$variadic = (function (max,keys,p__56178){
var vec__56179 = p__56178;
var msg = cljs.core.nth.call(null,vec__56179,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56179,msg){
return (function (p1__56174_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56174_SHARP_)) && (!((p1__56174_SHARP_ == null))) && ((!(typeof p1__56174_SHARP_ === 'number')) || ((max < p1__56174_SHARP_)));
});})(vec__56179,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("cannot be more than "),cljs.core.str(max)].join('');
}
})());
});

jkkramer.verily.max_val.cljs$lang$maxFixedArity = (2);

jkkramer.verily.max_val.cljs$lang$applyTo = (function (seq56175){
var G__56176 = cljs.core.first.call(null,seq56175);
var seq56175__$1 = cljs.core.next.call(null,seq56175);
var G__56177 = cljs.core.first.call(null,seq56175__$1);
var seq56175__$2 = cljs.core.next.call(null,seq56175__$1);
return jkkramer.verily.max_val.cljs$core$IFn$_invoke$arity$variadic(G__56176,G__56177,seq56175__$2);
});
jkkramer.verily.at_most = jkkramer.verily.max_val;
jkkramer.verily.within = (function jkkramer$verily$within(){
var args__19535__auto__ = [];
var len__19528__auto___56190 = arguments.length;
var i__19529__auto___56191 = (0);
while(true){
if((i__19529__auto___56191 < len__19528__auto___56190)){
args__19535__auto__.push((arguments[i__19529__auto___56191]));

var G__56192 = (i__19529__auto___56191 + (1));
i__19529__auto___56191 = G__56192;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((3) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((3)),(0))):null);
return jkkramer.verily.within.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19536__auto__);
});

jkkramer.verily.within.cljs$core$IFn$_invoke$arity$variadic = (function (min,max,keys,p__56188){
var vec__56189 = p__56188;
var msg = cljs.core.nth.call(null,vec__56189,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56189,msg){
return (function (p1__56183_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56183_SHARP_)) && (!((p1__56183_SHARP_ == null))) && ((!(typeof p1__56183_SHARP_ === 'number')) || (((min > p1__56183_SHARP_)) || ((max < p1__56183_SHARP_))));
});})(vec__56189,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("must be within "),cljs.core.str(min),cljs.core.str(" and "),cljs.core.str(max)].join('');
}
})());
});

jkkramer.verily.within.cljs$lang$maxFixedArity = (3);

jkkramer.verily.within.cljs$lang$applyTo = (function (seq56184){
var G__56185 = cljs.core.first.call(null,seq56184);
var seq56184__$1 = cljs.core.next.call(null,seq56184);
var G__56186 = cljs.core.first.call(null,seq56184__$1);
var seq56184__$2 = cljs.core.next.call(null,seq56184__$1);
var G__56187 = cljs.core.first.call(null,seq56184__$2);
var seq56184__$3 = cljs.core.next.call(null,seq56184__$2);
return jkkramer.verily.within.cljs$core$IFn$_invoke$arity$variadic(G__56185,G__56186,G__56187,seq56184__$3);
});
jkkramer.verily.positive = (function jkkramer$verily$positive(){
var args__19535__auto__ = [];
var len__19528__auto___56198 = arguments.length;
var i__19529__auto___56199 = (0);
while(true){
if((i__19529__auto___56199 < len__19528__auto___56198)){
args__19535__auto__.push((arguments[i__19529__auto___56199]));

var G__56200 = (i__19529__auto___56199 + (1));
i__19529__auto___56199 = G__56200;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.positive.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.positive.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56196){
var vec__56197 = p__56196;
var msg = cljs.core.nth.call(null,vec__56197,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56197,msg){
return (function (p1__56193_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56193_SHARP_)) && (!((p1__56193_SHARP_ == null))) && ((!(typeof p1__56193_SHARP_ === 'number')) || (!((p1__56193_SHARP_ > (0)))));
});})(vec__56197,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a positive number";
}
})());
});

jkkramer.verily.positive.cljs$lang$maxFixedArity = (1);

jkkramer.verily.positive.cljs$lang$applyTo = (function (seq56194){
var G__56195 = cljs.core.first.call(null,seq56194);
var seq56194__$1 = cljs.core.next.call(null,seq56194);
return jkkramer.verily.positive.cljs$core$IFn$_invoke$arity$variadic(G__56195,seq56194__$1);
});
jkkramer.verily.negative = (function jkkramer$verily$negative(){
var args__19535__auto__ = [];
var len__19528__auto___56206 = arguments.length;
var i__19529__auto___56207 = (0);
while(true){
if((i__19529__auto___56207 < len__19528__auto___56206)){
args__19535__auto__.push((arguments[i__19529__auto___56207]));

var G__56208 = (i__19529__auto___56207 + (1));
i__19529__auto___56207 = G__56208;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.negative.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.negative.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56204){
var vec__56205 = p__56204;
var msg = cljs.core.nth.call(null,vec__56205,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56205,msg){
return (function (p1__56201_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56201_SHARP_)) && (!((p1__56201_SHARP_ == null))) && ((!(typeof p1__56201_SHARP_ === 'number')) || (!((p1__56201_SHARP_ < (0)))));
});})(vec__56205,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a negative number";
}
})());
});

jkkramer.verily.negative.cljs$lang$maxFixedArity = (1);

jkkramer.verily.negative.cljs$lang$applyTo = (function (seq56202){
var G__56203 = cljs.core.first.call(null,seq56202);
var seq56202__$1 = cljs.core.next.call(null,seq56202);
return jkkramer.verily.negative.cljs$core$IFn$_invoke$arity$variadic(G__56203,seq56202__$1);
});
jkkramer.verily.date = (function jkkramer$verily$date(){
var args__19535__auto__ = [];
var len__19528__auto___56214 = arguments.length;
var i__19529__auto___56215 = (0);
while(true){
if((i__19529__auto___56215 < len__19528__auto___56214)){
args__19535__auto__.push((arguments[i__19529__auto___56215]));

var G__56216 = (i__19529__auto___56215 + (1));
i__19529__auto___56215 = G__56216;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.date.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.date.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56212){
var vec__56213 = p__56212;
var msg = cljs.core.nth.call(null,vec__56213,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56213,msg){
return (function (p1__56209_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56209_SHARP_)) && (!((p1__56209_SHARP_ == null))) && (!((p1__56209_SHARP_ instanceof Date)));
});})(vec__56213,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be a date";
}
})());
});

jkkramer.verily.date.cljs$lang$maxFixedArity = (1);

jkkramer.verily.date.cljs$lang$applyTo = (function (seq56210){
var G__56211 = cljs.core.first.call(null,seq56210);
var seq56210__$1 = cljs.core.next.call(null,seq56210);
return jkkramer.verily.date.cljs$core$IFn$_invoke$arity$variadic(G__56211,seq56210__$1);
});
jkkramer.verily.dates = (function jkkramer$verily$dates(){
var args__19535__auto__ = [];
var len__19528__auto___56222 = arguments.length;
var i__19529__auto___56223 = (0);
while(true){
if((i__19529__auto___56223 < len__19528__auto___56222)){
args__19535__auto__.push((arguments[i__19529__auto___56223]));

var G__56224 = (i__19529__auto___56223 + (1));
i__19529__auto___56223 = G__56224;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.dates.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.dates.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56220){
var vec__56221 = p__56220;
var msg = cljs.core.nth.call(null,vec__56221,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56221,msg){
return (function (v){
var and__18477__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18477__auto__){
var or__18489__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return cljs.core.some.call(null,((function (or__18489__auto__,and__18477__auto__,vec__56221,msg){
return (function (p1__56217_SHARP_){
return !((p1__56217_SHARP_ instanceof Date));
});})(or__18489__auto__,and__18477__auto__,vec__56221,msg))
,v);
}
} else {
return and__18477__auto__;
}
});})(vec__56221,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "must be dates";
}
})());
});

jkkramer.verily.dates.cljs$lang$maxFixedArity = (1);

jkkramer.verily.dates.cljs$lang$applyTo = (function (seq56218){
var G__56219 = cljs.core.first.call(null,seq56218);
var seq56218__$1 = cljs.core.next.call(null,seq56218);
return jkkramer.verily.dates.cljs$core$IFn$_invoke$arity$variadic(G__56219,seq56218__$1);
});
jkkramer.verily.after_QMARK_ = (function jkkramer$verily$after_QMARK_(d1,d2){
return (d2 < d1);
});
jkkramer.verily.after = (function jkkramer$verily$after(){
var args__19535__auto__ = [];
var len__19528__auto___56231 = arguments.length;
var i__19529__auto___56232 = (0);
while(true){
if((i__19529__auto___56232 < len__19528__auto___56231)){
args__19535__auto__.push((arguments[i__19529__auto___56232]));

var G__56233 = (i__19529__auto___56232 + (1));
i__19529__auto___56232 = G__56233;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.after.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.after.cljs$core$IFn$_invoke$arity$variadic = (function (date,keys,p__56229){
var vec__56230 = p__56229;
var msg = cljs.core.nth.call(null,vec__56230,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56230,msg){
return (function (p1__56225_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56225_SHARP_)) && (!((p1__56225_SHARP_ == null))) && ((!((p1__56225_SHARP_ instanceof Date))) || (cljs.core.not.call(null,jkkramer.verily.after_QMARK_.call(null,p1__56225_SHARP_,date))));
});})(vec__56230,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("must be after "),cljs.core.str(date)].join('');
}
})());
});

jkkramer.verily.after.cljs$lang$maxFixedArity = (2);

jkkramer.verily.after.cljs$lang$applyTo = (function (seq56226){
var G__56227 = cljs.core.first.call(null,seq56226);
var seq56226__$1 = cljs.core.next.call(null,seq56226);
var G__56228 = cljs.core.first.call(null,seq56226__$1);
var seq56226__$2 = cljs.core.next.call(null,seq56226__$1);
return jkkramer.verily.after.cljs$core$IFn$_invoke$arity$variadic(G__56227,G__56228,seq56226__$2);
});
jkkramer.verily.before_QMARK_ = (function jkkramer$verily$before_QMARK_(d1,d2){
return (d1 < d2);
});
jkkramer.verily.before = (function jkkramer$verily$before(){
var args__19535__auto__ = [];
var len__19528__auto___56240 = arguments.length;
var i__19529__auto___56241 = (0);
while(true){
if((i__19529__auto___56241 < len__19528__auto___56240)){
args__19535__auto__.push((arguments[i__19529__auto___56241]));

var G__56242 = (i__19529__auto___56241 + (1));
i__19529__auto___56241 = G__56242;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return jkkramer.verily.before.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});

jkkramer.verily.before.cljs$core$IFn$_invoke$arity$variadic = (function (date,keys,p__56238){
var vec__56239 = p__56238;
var msg = cljs.core.nth.call(null,vec__56239,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56239,msg){
return (function (p1__56234_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56234_SHARP_)) && (!((p1__56234_SHARP_ == null))) && ((!((p1__56234_SHARP_ instanceof Date))) || (cljs.core.not.call(null,jkkramer.verily.before_QMARK_.call(null,p1__56234_SHARP_,date))));
});})(vec__56239,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return [cljs.core.str("must be before "),cljs.core.str(date)].join('');
}
})());
});

jkkramer.verily.before.cljs$lang$maxFixedArity = (2);

jkkramer.verily.before.cljs$lang$applyTo = (function (seq56235){
var G__56236 = cljs.core.first.call(null,seq56235);
var seq56235__$1 = cljs.core.next.call(null,seq56235);
var G__56237 = cljs.core.first.call(null,seq56235__$1);
var seq56235__$2 = cljs.core.next.call(null,seq56235__$1);
return jkkramer.verily.before.cljs$core$IFn$_invoke$arity$variadic(G__56236,G__56237,seq56235__$2);
});
jkkramer.verily.digits = (function jkkramer$verily$digits(n){
return cljs.core.map.call(null,(function (p1__56243_SHARP_){
return (p1__56243_SHARP_.charCodeAt((0)) - (48));
}),[cljs.core.str(n)].join(''));
});
jkkramer.verily.luhn_QMARK_ = (function jkkramer$verily$luhn_QMARK_(x){
var n = ((typeof x === 'string')?clojure.string.replace.call(null,x,/[^0-9]/,""):x);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,((function (n){
return (function (d,idx){
if(cljs.core.even_QMARK_.call(null,idx)){
return cljs.core.reduce.call(null,cljs.core._PLUS_,jkkramer.verily.digits.call(null,(d * (2))));
} else {
return d;
}
});})(n))
,cljs.core.reverse.call(null,jkkramer.verily.digits.call(null,n)),cljs.core.iterate.call(null,cljs.core.inc,(1))));
return (cljs.core.mod.call(null,sum,(10)) === (0));
});
jkkramer.verily.luhn = (function jkkramer$verily$luhn(){
var args__19535__auto__ = [];
var len__19528__auto___56249 = arguments.length;
var i__19529__auto___56250 = (0);
while(true){
if((i__19529__auto___56250 < len__19528__auto___56249)){
args__19535__auto__.push((arguments[i__19529__auto___56250]));

var G__56251 = (i__19529__auto___56250 + (1));
i__19529__auto___56250 = G__56251;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return jkkramer.verily.luhn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

jkkramer.verily.luhn.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__56247){
var vec__56248 = p__56247;
var msg = cljs.core.nth.call(null,vec__56248,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__56248,msg){
return (function (p1__56244_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__56244_SHARP_)) && (!((p1__56244_SHARP_ == null))) && (cljs.core.not.call(null,jkkramer.verily.luhn_QMARK_.call(null,p1__56244_SHARP_)));
});})(vec__56248,msg))
,(function (){var or__18489__auto__ = msg;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return "number is not valid";
}
})());
});

jkkramer.verily.luhn.cljs$lang$maxFixedArity = (1);

jkkramer.verily.luhn.cljs$lang$applyTo = (function (seq56245){
var G__56246 = cljs.core.first.call(null,seq56245);
var seq56245__$1 = cljs.core.next.call(null,seq56245);
return jkkramer.verily.luhn.cljs$core$IFn$_invoke$arity$variadic(G__56246,seq56245__$1);
});
jkkramer.verily.combine = (function jkkramer$verily$combine(){
var args__19535__auto__ = [];
var len__19528__auto___56254 = arguments.length;
var i__19529__auto___56255 = (0);
while(true){
if((i__19529__auto___56255 < len__19528__auto___56254)){
args__19535__auto__.push((arguments[i__19529__auto___56255]));

var G__56256 = (i__19529__auto___56255 + (1));
i__19529__auto___56255 = G__56256;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((0) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((0)),(0))):null);
return jkkramer.verily.combine.cljs$core$IFn$_invoke$arity$variadic(argseq__19536__auto__);
});

jkkramer.verily.combine.cljs$core$IFn$_invoke$arity$variadic = (function (validators){
return (function (m){
return cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,jkkramer.verily.seqify,cljs.core.keep.call(null,(function (p1__56252_SHARP_){
return p1__56252_SHARP_.call(null,m);
}),validators)));
});
});

jkkramer.verily.combine.cljs$lang$maxFixedArity = (0);

jkkramer.verily.combine.cljs$lang$applyTo = (function (seq56253){
return jkkramer.verily.combine.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq56253));
});
jkkramer.verily.validations_map = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"booleans","booleans",-883685439),new cljs.core.Keyword(null,"email","email",1415816706),new cljs.core.Keyword(null,"date","date",-1463434462),new cljs.core.Keyword(null,"max-length","max-length",-254826109),new cljs.core.Keyword(null,"decimals","decimals",1715096484),new cljs.core.Keyword(null,"contains","contains",676899812),new cljs.core.Keyword(null,"min-length","min-length",-325792315),new cljs.core.Keyword(null,"dates","dates",-1600154075),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"integers","integers",1109066438),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"us-zip","us-zip",99525255),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"strings","strings",-2055406807),new cljs.core.Keyword(null,"luhn","luhn",2107621225),new cljs.core.Keyword(null,"positive","positive",1112941866),new cljs.core.Keyword(null,"negative","negative",-1562068438),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"at-least","at-least",267196846),new cljs.core.Keyword(null,"matches","matches",635497998),new cljs.core.Keyword(null,"floating-points","floating-points",1367959567),new cljs.core.Keyword(null,"bigints","bigints",508771281),new cljs.core.Keyword(null,"floating-point","floating-point",164663314),new cljs.core.Keyword(null,"integer","integer",-604721710),new cljs.core.Keyword(null,"after","after",594996914),new cljs.core.Keyword(null,"str","str",1089608819),new cljs.core.Keyword(null,"exact","exact",1438022323),new cljs.core.Keyword(null,"bools","bools",1248415956),new cljs.core.Keyword(null,"decimal","decimal",-170212044),new cljs.core.Keyword(null,"ints","ints",893195924),new cljs.core.Keyword(null,"max-val","max-val",-1492247884),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"within","within",-76827465),new cljs.core.Keyword(null,"every-in","every-in",929753720),new cljs.core.Keyword(null,"complete","complete",-500388775),new cljs.core.Keyword(null,"bool","bool",1444635321),new cljs.core.Keyword(null,"equal","equal",-1921681350),new cljs.core.Keyword(null,"before","before",-1633692388),new cljs.core.Keyword(null,"web-url","web-url",601349660),new cljs.core.Keyword(null,"not-blank","not-blank",-661874020),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"at-most","at-most",34804861),new cljs.core.Keyword(null,"strs","strs",1175537277),new cljs.core.Keyword(null,"required","required",1807647006),new cljs.core.Keyword(null,"min-val","min-val",-243137826),new cljs.core.Keyword(null,"floats","floats",-1126940417),new cljs.core.Keyword(null,"in","in",-1531184865)],[jkkramer.verily.bools,jkkramer.verily.email,jkkramer.verily.date,jkkramer.verily.max_length,jkkramer.verily.decimals,jkkramer.verily.contains,jkkramer.verily.min_length,jkkramer.verily.dates,jkkramer.verily.integer,jkkramer.verily.integers,jkkramer.verily.decimal,jkkramer.verily.us_zip,jkkramer.verily.floating_point,jkkramer.verily.strings,jkkramer.verily.luhn,jkkramer.verily.positive,jkkramer.verily.negative,jkkramer.verily.string,jkkramer.verily.at_least,jkkramer.verily.matches,jkkramer.verily.floating_points,jkkramer.verily.decimals,jkkramer.verily.floating_point,jkkramer.verily.integer,jkkramer.verily.after,jkkramer.verily.string,jkkramer.verily.exact,jkkramer.verily.bools,jkkramer.verily.decimal,jkkramer.verily.integers,jkkramer.verily.max_val,jkkramer.verily.url,jkkramer.verily.within,jkkramer.verily.every_in,jkkramer.verily.complete,jkkramer.verily.bool,jkkramer.verily.equal,jkkramer.verily.before,jkkramer.verily.web_url,jkkramer.verily.not_blank,jkkramer.verily.bool,jkkramer.verily.at_most,jkkramer.verily.strings,jkkramer.verily.required,jkkramer.verily.min_val,jkkramer.verily.floating_points,jkkramer.verily.in$]);
if(typeof jkkramer.verily.validation__GT_fn !== 'undefined'){
} else {
jkkramer.verily.validation__GT_fn = (function (){var method_table__19383__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19384__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19385__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19386__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19387__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"jkkramer.verily","validation->fn"),((function (method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__,hierarchy__19387__auto__){
return (function (vspec){
return cljs.core.first.call(null,vspec);
});})(method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__,hierarchy__19387__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19387__auto__,method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__));
})();
}
cljs.core._add_method.call(null,jkkramer.verily.validation__GT_fn,new cljs.core.Keyword(null,"default","default",-1987822328),(function (vspec){
var temp__4423__auto__ = cljs.core.get.call(null,jkkramer.verily.validations_map,cljs.core.first.call(null,vspec));
if(cljs.core.truth_(temp__4423__auto__)){
var vfn = temp__4423__auto__;
return cljs.core.apply.call(null,vfn,cljs.core.rest.call(null,vspec));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("Unknown validation "),cljs.core.str(cljs.core.first.call(null,vspec))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"vspec","vspec",-1158741640),cljs.core.first.call(null,vspec)], null));
}
}));
jkkramer.verily.validations__GT_fn = (function jkkramer$verily$validations__GT_fn(validations){
return cljs.core.apply.call(null,jkkramer.verily.combine,cljs.core.map.call(null,jkkramer.verily.validation__GT_fn,validations));
});
jkkramer.verily.validate = (function jkkramer$verily$validate(values,validations){
return jkkramer.verily.validations__GT_fn.call(null,validations).call(null,values);
});

//# sourceMappingURL=verily.js.map