// Compiled by ClojureScript 1.7.48 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__59092__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__59091 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__59091,(0),null);
var body = cljs.core.nthnext.call(null,vec__59091,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__59092 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__59093__i = 0, G__59093__a = new Array(arguments.length -  0);
while (G__59093__i < G__59093__a.length) {G__59093__a[G__59093__i] = arguments[G__59093__i + 0]; ++G__59093__i;}
  args = new cljs.core.IndexedSeq(G__59093__a,0);
} 
return G__59092__delegate.call(this,args);};
G__59092.cljs$lang$maxFixedArity = 0;
G__59092.cljs$lang$applyTo = (function (arglist__59094){
var args = cljs.core.seq(arglist__59094);
return G__59092__delegate(args);
});
G__59092.cljs$core$IFn$_invoke$arity$variadic = G__59092__delegate;
return G__59092;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__19242__auto__ = (function sablono$core$update_arglists_$_iter__59099(s__59100){
return (new cljs.core.LazySeq(null,(function (){
var s__59100__$1 = s__59100;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__59100__$1);
if(temp__4425__auto__){
var s__59100__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__59100__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__59100__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__59102 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__59101 = (0);
while(true){
if((i__59101 < size__19241__auto__)){
var args = cljs.core._nth.call(null,c__19240__auto__,i__59101);
cljs.core.chunk_append.call(null,b__59102,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__59103 = (i__59101 + (1));
i__59101 = G__59103;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__59102),sablono$core$update_arglists_$_iter__59099.call(null,cljs.core.chunk_rest.call(null,s__59100__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__59102),null);
}
} else {
var args = cljs.core.first.call(null,s__59100__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__59099.call(null,cljs.core.rest.call(null,s__59100__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,arglists);
});
/**
 * Render the React `component` as an HTML string.
 */
sablono.core.render = (function sablono$core$render(component){
return React.renderComponentToString(component);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(){
var args__19535__auto__ = [];
var len__19528__auto___59109 = arguments.length;
var i__19529__auto___59110 = (0);
while(true){
if((i__19529__auto___59110 < len__19528__auto___59109)){
args__19535__auto__.push((arguments[i__19529__auto___59110]));

var G__59111 = (i__19529__auto___59110 + (1));
i__19529__auto___59110 = G__59111;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((0) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__19536__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__19242__auto__ = (function sablono$core$iter__59105(s__59106){
return (new cljs.core.LazySeq(null,(function (){
var s__59106__$1 = s__59106;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__59106__$1);
if(temp__4425__auto__){
var s__59106__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__59106__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__59106__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__59108 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__59107 = (0);
while(true){
if((i__59107 < size__19241__auto__)){
var style = cljs.core._nth.call(null,c__19240__auto__,i__59107);
cljs.core.chunk_append.call(null,b__59108,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__59112 = (i__59107 + (1));
i__59107 = G__59112;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__59108),sablono$core$iter__59105.call(null,cljs.core.chunk_rest.call(null,s__59106__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__59108),null);
}
} else {
var style = cljs.core.first.call(null,s__59106__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__59105.call(null,cljs.core.rest.call(null,s__59106__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq59104){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq59104));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.9.0.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to59113 = (function sablono$core$link_to59113(){
var args__19535__auto__ = [];
var len__19528__auto___59116 = arguments.length;
var i__19529__auto___59117 = (0);
while(true){
if((i__19529__auto___59117 < len__19528__auto___59116)){
args__19535__auto__.push((arguments[i__19529__auto___59117]));

var G__59118 = (i__19529__auto___59117 + (1));
i__19529__auto___59117 = G__59118;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return sablono.core.link_to59113.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

sablono.core.link_to59113.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to59113.cljs$lang$maxFixedArity = (1);

sablono.core.link_to59113.cljs$lang$applyTo = (function (seq59114){
var G__59115 = cljs.core.first.call(null,seq59114);
var seq59114__$1 = cljs.core.next.call(null,seq59114);
return sablono.core.link_to59113.cljs$core$IFn$_invoke$arity$variadic(G__59115,seq59114__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to59113);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 * address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to59119 = (function sablono$core$mail_to59119(){
var args__19535__auto__ = [];
var len__19528__auto___59124 = arguments.length;
var i__19529__auto___59125 = (0);
while(true){
if((i__19529__auto___59125 < len__19528__auto___59124)){
args__19535__auto__.push((arguments[i__19529__auto___59125]));

var G__59126 = (i__19529__auto___59125 + (1));
i__19529__auto___59125 = G__59126;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return sablono.core.mail_to59119.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

sablono.core.mail_to59119.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__59122){
var vec__59123 = p__59122;
var content = cljs.core.nth.call(null,vec__59123,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__18489__auto__ = content;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to59119.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to59119.cljs$lang$applyTo = (function (seq59120){
var G__59121 = cljs.core.first.call(null,seq59120);
var seq59120__$1 = cljs.core.next.call(null,seq59120);
return sablono.core.mail_to59119.cljs$core$IFn$_invoke$arity$variadic(G__59121,seq59120__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to59119);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list59127 = (function sablono$core$unordered_list59127(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__19242__auto__ = (function sablono$core$unordered_list59127_$_iter__59132(s__59133){
return (new cljs.core.LazySeq(null,(function (){
var s__59133__$1 = s__59133;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__59133__$1);
if(temp__4425__auto__){
var s__59133__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__59133__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__59133__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__59135 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__59134 = (0);
while(true){
if((i__59134 < size__19241__auto__)){
var x = cljs.core._nth.call(null,c__19240__auto__,i__59134);
cljs.core.chunk_append.call(null,b__59135,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__59136 = (i__59134 + (1));
i__59134 = G__59136;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__59135),sablono$core$unordered_list59127_$_iter__59132.call(null,cljs.core.chunk_rest.call(null,s__59133__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__59135),null);
}
} else {
var x = cljs.core.first.call(null,s__59133__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list59127_$_iter__59132.call(null,cljs.core.rest.call(null,s__59133__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list59127);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list59137 = (function sablono$core$ordered_list59137(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__19242__auto__ = (function sablono$core$ordered_list59137_$_iter__59142(s__59143){
return (new cljs.core.LazySeq(null,(function (){
var s__59143__$1 = s__59143;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__59143__$1);
if(temp__4425__auto__){
var s__59143__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__59143__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__59143__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__59145 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__59144 = (0);
while(true){
if((i__59144 < size__19241__auto__)){
var x = cljs.core._nth.call(null,c__19240__auto__,i__59144);
cljs.core.chunk_append.call(null,b__59145,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__59146 = (i__59144 + (1));
i__59144 = G__59146;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__59145),sablono$core$ordered_list59137_$_iter__59142.call(null,cljs.core.chunk_rest.call(null,s__59143__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__59145),null);
}
} else {
var x = cljs.core.first.call(null,s__59143__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list59137_$_iter__59142.call(null,cljs.core.rest.call(null,s__59143__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list59137);
/**
 * Create an image element.
 */
sablono.core.image59147 = (function sablono$core$image59147(){
var args59148 = [];
var len__19528__auto___59151 = arguments.length;
var i__19529__auto___59152 = (0);
while(true){
if((i__19529__auto___59152 < len__19528__auto___59151)){
args59148.push((arguments[i__19529__auto___59152]));

var G__59153 = (i__19529__auto___59152 + (1));
i__19529__auto___59152 = G__59153;
continue;
} else {
}
break;
}

var G__59150 = args59148.length;
switch (G__59150) {
case 1:
return sablono.core.image59147.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image59147.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59148.length)].join('')));

}
});

sablono.core.image59147.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image59147.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image59147.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image59147);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__59155_SHARP_,p2__59156_SHARP_){
return [cljs.core.str(p1__59155_SHARP_),cljs.core.str("["),cljs.core.str(p2__59156_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__59157_SHARP_,p2__59158_SHARP_){
return [cljs.core.str(p1__59157_SHARP_),cljs.core.str("-"),cljs.core.str(p2__59158_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field59159 = (function sablono$core$color_field59159(){
var args59160 = [];
var len__19528__auto___59227 = arguments.length;
var i__19529__auto___59228 = (0);
while(true){
if((i__19529__auto___59228 < len__19528__auto___59227)){
args59160.push((arguments[i__19529__auto___59228]));

var G__59229 = (i__19529__auto___59228 + (1));
i__19529__auto___59228 = G__59229;
continue;
} else {
}
break;
}

var G__59162 = args59160.length;
switch (G__59162) {
case 1:
return sablono.core.color_field59159.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field59159.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59160.length)].join('')));

}
});

sablono.core.color_field59159.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.color_field59159.call(null,name__27305__auto__,null);
});

sablono.core.color_field59159.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.color_field59159.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field59159);

/**
 * Creates a date input field.
 */
sablono.core.date_field59163 = (function sablono$core$date_field59163(){
var args59164 = [];
var len__19528__auto___59231 = arguments.length;
var i__19529__auto___59232 = (0);
while(true){
if((i__19529__auto___59232 < len__19528__auto___59231)){
args59164.push((arguments[i__19529__auto___59232]));

var G__59233 = (i__19529__auto___59232 + (1));
i__19529__auto___59232 = G__59233;
continue;
} else {
}
break;
}

var G__59166 = args59164.length;
switch (G__59166) {
case 1:
return sablono.core.date_field59163.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field59163.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59164.length)].join('')));

}
});

sablono.core.date_field59163.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.date_field59163.call(null,name__27305__auto__,null);
});

sablono.core.date_field59163.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.date_field59163.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field59163);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field59167 = (function sablono$core$datetime_field59167(){
var args59168 = [];
var len__19528__auto___59235 = arguments.length;
var i__19529__auto___59236 = (0);
while(true){
if((i__19529__auto___59236 < len__19528__auto___59235)){
args59168.push((arguments[i__19529__auto___59236]));

var G__59237 = (i__19529__auto___59236 + (1));
i__19529__auto___59236 = G__59237;
continue;
} else {
}
break;
}

var G__59170 = args59168.length;
switch (G__59170) {
case 1:
return sablono.core.datetime_field59167.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field59167.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59168.length)].join('')));

}
});

sablono.core.datetime_field59167.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.datetime_field59167.call(null,name__27305__auto__,null);
});

sablono.core.datetime_field59167.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.datetime_field59167.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field59167);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field59171 = (function sablono$core$datetime_local_field59171(){
var args59172 = [];
var len__19528__auto___59239 = arguments.length;
var i__19529__auto___59240 = (0);
while(true){
if((i__19529__auto___59240 < len__19528__auto___59239)){
args59172.push((arguments[i__19529__auto___59240]));

var G__59241 = (i__19529__auto___59240 + (1));
i__19529__auto___59240 = G__59241;
continue;
} else {
}
break;
}

var G__59174 = args59172.length;
switch (G__59174) {
case 1:
return sablono.core.datetime_local_field59171.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field59171.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59172.length)].join('')));

}
});

sablono.core.datetime_local_field59171.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.datetime_local_field59171.call(null,name__27305__auto__,null);
});

sablono.core.datetime_local_field59171.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.datetime_local_field59171.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field59171);

/**
 * Creates a email input field.
 */
sablono.core.email_field59175 = (function sablono$core$email_field59175(){
var args59176 = [];
var len__19528__auto___59243 = arguments.length;
var i__19529__auto___59244 = (0);
while(true){
if((i__19529__auto___59244 < len__19528__auto___59243)){
args59176.push((arguments[i__19529__auto___59244]));

var G__59245 = (i__19529__auto___59244 + (1));
i__19529__auto___59244 = G__59245;
continue;
} else {
}
break;
}

var G__59178 = args59176.length;
switch (G__59178) {
case 1:
return sablono.core.email_field59175.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field59175.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59176.length)].join('')));

}
});

sablono.core.email_field59175.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.email_field59175.call(null,name__27305__auto__,null);
});

sablono.core.email_field59175.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.email_field59175.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field59175);

/**
 * Creates a file input field.
 */
sablono.core.file_field59179 = (function sablono$core$file_field59179(){
var args59180 = [];
var len__19528__auto___59247 = arguments.length;
var i__19529__auto___59248 = (0);
while(true){
if((i__19529__auto___59248 < len__19528__auto___59247)){
args59180.push((arguments[i__19529__auto___59248]));

var G__59249 = (i__19529__auto___59248 + (1));
i__19529__auto___59248 = G__59249;
continue;
} else {
}
break;
}

var G__59182 = args59180.length;
switch (G__59182) {
case 1:
return sablono.core.file_field59179.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field59179.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59180.length)].join('')));

}
});

sablono.core.file_field59179.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.file_field59179.call(null,name__27305__auto__,null);
});

sablono.core.file_field59179.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.file_field59179.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field59179);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field59183 = (function sablono$core$hidden_field59183(){
var args59184 = [];
var len__19528__auto___59251 = arguments.length;
var i__19529__auto___59252 = (0);
while(true){
if((i__19529__auto___59252 < len__19528__auto___59251)){
args59184.push((arguments[i__19529__auto___59252]));

var G__59253 = (i__19529__auto___59252 + (1));
i__19529__auto___59252 = G__59253;
continue;
} else {
}
break;
}

var G__59186 = args59184.length;
switch (G__59186) {
case 1:
return sablono.core.hidden_field59183.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field59183.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59184.length)].join('')));

}
});

sablono.core.hidden_field59183.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.hidden_field59183.call(null,name__27305__auto__,null);
});

sablono.core.hidden_field59183.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.hidden_field59183.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field59183);

/**
 * Creates a month input field.
 */
sablono.core.month_field59187 = (function sablono$core$month_field59187(){
var args59188 = [];
var len__19528__auto___59255 = arguments.length;
var i__19529__auto___59256 = (0);
while(true){
if((i__19529__auto___59256 < len__19528__auto___59255)){
args59188.push((arguments[i__19529__auto___59256]));

var G__59257 = (i__19529__auto___59256 + (1));
i__19529__auto___59256 = G__59257;
continue;
} else {
}
break;
}

var G__59190 = args59188.length;
switch (G__59190) {
case 1:
return sablono.core.month_field59187.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field59187.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59188.length)].join('')));

}
});

sablono.core.month_field59187.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.month_field59187.call(null,name__27305__auto__,null);
});

sablono.core.month_field59187.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.month_field59187.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field59187);

/**
 * Creates a number input field.
 */
sablono.core.number_field59191 = (function sablono$core$number_field59191(){
var args59192 = [];
var len__19528__auto___59259 = arguments.length;
var i__19529__auto___59260 = (0);
while(true){
if((i__19529__auto___59260 < len__19528__auto___59259)){
args59192.push((arguments[i__19529__auto___59260]));

var G__59261 = (i__19529__auto___59260 + (1));
i__19529__auto___59260 = G__59261;
continue;
} else {
}
break;
}

var G__59194 = args59192.length;
switch (G__59194) {
case 1:
return sablono.core.number_field59191.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field59191.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59192.length)].join('')));

}
});

sablono.core.number_field59191.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.number_field59191.call(null,name__27305__auto__,null);
});

sablono.core.number_field59191.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.number_field59191.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field59191);

/**
 * Creates a password input field.
 */
sablono.core.password_field59195 = (function sablono$core$password_field59195(){
var args59196 = [];
var len__19528__auto___59263 = arguments.length;
var i__19529__auto___59264 = (0);
while(true){
if((i__19529__auto___59264 < len__19528__auto___59263)){
args59196.push((arguments[i__19529__auto___59264]));

var G__59265 = (i__19529__auto___59264 + (1));
i__19529__auto___59264 = G__59265;
continue;
} else {
}
break;
}

var G__59198 = args59196.length;
switch (G__59198) {
case 1:
return sablono.core.password_field59195.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field59195.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59196.length)].join('')));

}
});

sablono.core.password_field59195.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.password_field59195.call(null,name__27305__auto__,null);
});

sablono.core.password_field59195.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.password_field59195.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field59195);

/**
 * Creates a range input field.
 */
sablono.core.range_field59199 = (function sablono$core$range_field59199(){
var args59200 = [];
var len__19528__auto___59267 = arguments.length;
var i__19529__auto___59268 = (0);
while(true){
if((i__19529__auto___59268 < len__19528__auto___59267)){
args59200.push((arguments[i__19529__auto___59268]));

var G__59269 = (i__19529__auto___59268 + (1));
i__19529__auto___59268 = G__59269;
continue;
} else {
}
break;
}

var G__59202 = args59200.length;
switch (G__59202) {
case 1:
return sablono.core.range_field59199.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field59199.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59200.length)].join('')));

}
});

sablono.core.range_field59199.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.range_field59199.call(null,name__27305__auto__,null);
});

sablono.core.range_field59199.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.range_field59199.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field59199);

/**
 * Creates a search input field.
 */
sablono.core.search_field59203 = (function sablono$core$search_field59203(){
var args59204 = [];
var len__19528__auto___59271 = arguments.length;
var i__19529__auto___59272 = (0);
while(true){
if((i__19529__auto___59272 < len__19528__auto___59271)){
args59204.push((arguments[i__19529__auto___59272]));

var G__59273 = (i__19529__auto___59272 + (1));
i__19529__auto___59272 = G__59273;
continue;
} else {
}
break;
}

var G__59206 = args59204.length;
switch (G__59206) {
case 1:
return sablono.core.search_field59203.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field59203.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59204.length)].join('')));

}
});

sablono.core.search_field59203.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.search_field59203.call(null,name__27305__auto__,null);
});

sablono.core.search_field59203.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.search_field59203.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field59203);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field59207 = (function sablono$core$tel_field59207(){
var args59208 = [];
var len__19528__auto___59275 = arguments.length;
var i__19529__auto___59276 = (0);
while(true){
if((i__19529__auto___59276 < len__19528__auto___59275)){
args59208.push((arguments[i__19529__auto___59276]));

var G__59277 = (i__19529__auto___59276 + (1));
i__19529__auto___59276 = G__59277;
continue;
} else {
}
break;
}

var G__59210 = args59208.length;
switch (G__59210) {
case 1:
return sablono.core.tel_field59207.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field59207.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59208.length)].join('')));

}
});

sablono.core.tel_field59207.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.tel_field59207.call(null,name__27305__auto__,null);
});

sablono.core.tel_field59207.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.tel_field59207.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field59207);

/**
 * Creates a text input field.
 */
sablono.core.text_field59211 = (function sablono$core$text_field59211(){
var args59212 = [];
var len__19528__auto___59279 = arguments.length;
var i__19529__auto___59280 = (0);
while(true){
if((i__19529__auto___59280 < len__19528__auto___59279)){
args59212.push((arguments[i__19529__auto___59280]));

var G__59281 = (i__19529__auto___59280 + (1));
i__19529__auto___59280 = G__59281;
continue;
} else {
}
break;
}

var G__59214 = args59212.length;
switch (G__59214) {
case 1:
return sablono.core.text_field59211.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field59211.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59212.length)].join('')));

}
});

sablono.core.text_field59211.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.text_field59211.call(null,name__27305__auto__,null);
});

sablono.core.text_field59211.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.text_field59211.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field59211);

/**
 * Creates a time input field.
 */
sablono.core.time_field59215 = (function sablono$core$time_field59215(){
var args59216 = [];
var len__19528__auto___59283 = arguments.length;
var i__19529__auto___59284 = (0);
while(true){
if((i__19529__auto___59284 < len__19528__auto___59283)){
args59216.push((arguments[i__19529__auto___59284]));

var G__59285 = (i__19529__auto___59284 + (1));
i__19529__auto___59284 = G__59285;
continue;
} else {
}
break;
}

var G__59218 = args59216.length;
switch (G__59218) {
case 1:
return sablono.core.time_field59215.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field59215.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59216.length)].join('')));

}
});

sablono.core.time_field59215.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.time_field59215.call(null,name__27305__auto__,null);
});

sablono.core.time_field59215.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.time_field59215.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field59215);

/**
 * Creates a url input field.
 */
sablono.core.url_field59219 = (function sablono$core$url_field59219(){
var args59220 = [];
var len__19528__auto___59287 = arguments.length;
var i__19529__auto___59288 = (0);
while(true){
if((i__19529__auto___59288 < len__19528__auto___59287)){
args59220.push((arguments[i__19529__auto___59288]));

var G__59289 = (i__19529__auto___59288 + (1));
i__19529__auto___59288 = G__59289;
continue;
} else {
}
break;
}

var G__59222 = args59220.length;
switch (G__59222) {
case 1:
return sablono.core.url_field59219.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field59219.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59220.length)].join('')));

}
});

sablono.core.url_field59219.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.url_field59219.call(null,name__27305__auto__,null);
});

sablono.core.url_field59219.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.url_field59219.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field59219);

/**
 * Creates a week input field.
 */
sablono.core.week_field59223 = (function sablono$core$week_field59223(){
var args59224 = [];
var len__19528__auto___59291 = arguments.length;
var i__19529__auto___59292 = (0);
while(true){
if((i__19529__auto___59292 < len__19528__auto___59291)){
args59224.push((arguments[i__19529__auto___59292]));

var G__59293 = (i__19529__auto___59292 + (1));
i__19529__auto___59292 = G__59293;
continue;
} else {
}
break;
}

var G__59226 = args59224.length;
switch (G__59226) {
case 1:
return sablono.core.week_field59223.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field59223.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59224.length)].join('')));

}
});

sablono.core.week_field59223.cljs$core$IFn$_invoke$arity$1 = (function (name__27305__auto__){
return sablono.core.week_field59223.call(null,name__27305__auto__,null);
});

sablono.core.week_field59223.cljs$core$IFn$_invoke$arity$2 = (function (name__27305__auto__,value__27306__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__27305__auto__,value__27306__auto__);
});

sablono.core.week_field59223.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field59223);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box59295 = (function sablono$core$check_box59295(){
var args59296 = [];
var len__19528__auto___59299 = arguments.length;
var i__19529__auto___59300 = (0);
while(true){
if((i__19529__auto___59300 < len__19528__auto___59299)){
args59296.push((arguments[i__19529__auto___59300]));

var G__59301 = (i__19529__auto___59300 + (1));
i__19529__auto___59300 = G__59301;
continue;
} else {
}
break;
}

var G__59298 = args59296.length;
switch (G__59298) {
case 1:
return sablono.core.check_box59295.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box59295.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box59295.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59296.length)].join('')));

}
});

sablono.core.check_box59295.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box59295.call(null,name,null);
});

sablono.core.check_box59295.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box59295.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box59295.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box59295.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box59295);
/**
 * Creates a radio button.
 */
sablono.core.radio_button59303 = (function sablono$core$radio_button59303(){
var args59304 = [];
var len__19528__auto___59307 = arguments.length;
var i__19529__auto___59308 = (0);
while(true){
if((i__19529__auto___59308 < len__19528__auto___59307)){
args59304.push((arguments[i__19529__auto___59308]));

var G__59309 = (i__19529__auto___59308 + (1));
i__19529__auto___59308 = G__59309;
continue;
} else {
}
break;
}

var G__59306 = args59304.length;
switch (G__59306) {
case 1:
return sablono.core.radio_button59303.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button59303.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button59303.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59304.length)].join('')));

}
});

sablono.core.radio_button59303.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button59303.call(null,group,null);
});

sablono.core.radio_button59303.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button59303.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button59303.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button59303.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button59303);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options59311 = (function sablono$core$select_options59311(){
var args59312 = [];
var len__19528__auto___59323 = arguments.length;
var i__19529__auto___59324 = (0);
while(true){
if((i__19529__auto___59324 < len__19528__auto___59323)){
args59312.push((arguments[i__19529__auto___59324]));

var G__59325 = (i__19529__auto___59324 + (1));
i__19529__auto___59324 = G__59325;
continue;
} else {
}
break;
}

var G__59314 = args59312.length;
switch (G__59314) {
case 1:
return sablono.core.select_options59311.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options59311.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59312.length)].join('')));

}
});

sablono.core.select_options59311.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options59311.call(null,coll,null);
});

sablono.core.select_options59311.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__19242__auto__ = (function sablono$core$iter__59315(s__59316){
return (new cljs.core.LazySeq(null,(function (){
var s__59316__$1 = s__59316;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__59316__$1);
if(temp__4425__auto__){
var s__59316__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__59316__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__59316__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__59318 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__59317 = (0);
while(true){
if((i__59317 < size__19241__auto__)){
var x = cljs.core._nth.call(null,c__19240__auto__,i__59317);
cljs.core.chunk_append.call(null,b__59318,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__59321 = x;
var text = cljs.core.nth.call(null,vec__59321,(0),null);
var val = cljs.core.nth.call(null,vec__59321,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__59321,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options59311.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__59327 = (i__59317 + (1));
i__59317 = G__59327;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__59318),sablono$core$iter__59315.call(null,cljs.core.chunk_rest.call(null,s__59316__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__59318),null);
}
} else {
var x = cljs.core.first.call(null,s__59316__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__59322 = x;
var text = cljs.core.nth.call(null,vec__59322,(0),null);
var val = cljs.core.nth.call(null,vec__59322,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__59322,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options59311.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__59315.call(null,cljs.core.rest.call(null,s__59316__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,coll);
});

sablono.core.select_options59311.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options59311);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down59328 = (function sablono$core$drop_down59328(){
var args59329 = [];
var len__19528__auto___59332 = arguments.length;
var i__19529__auto___59333 = (0);
while(true){
if((i__19529__auto___59333 < len__19528__auto___59332)){
args59329.push((arguments[i__19529__auto___59333]));

var G__59334 = (i__19529__auto___59333 + (1));
i__19529__auto___59333 = G__59334;
continue;
} else {
}
break;
}

var G__59331 = args59329.length;
switch (G__59331) {
case 2:
return sablono.core.drop_down59328.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down59328.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59329.length)].join('')));

}
});

sablono.core.drop_down59328.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down59328.call(null,name,options,null);
});

sablono.core.drop_down59328.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down59328.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down59328);
/**
 * Creates a text area element.
 */
sablono.core.text_area59336 = (function sablono$core$text_area59336(){
var args59337 = [];
var len__19528__auto___59340 = arguments.length;
var i__19529__auto___59341 = (0);
while(true){
if((i__19529__auto___59341 < len__19528__auto___59340)){
args59337.push((arguments[i__19529__auto___59341]));

var G__59342 = (i__19529__auto___59341 + (1));
i__19529__auto___59341 = G__59342;
continue;
} else {
}
break;
}

var G__59339 = args59337.length;
switch (G__59339) {
case 1:
return sablono.core.text_area59336.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area59336.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59337.length)].join('')));

}
});

sablono.core.text_area59336.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area59336.call(null,name,null);
});

sablono.core.text_area59336.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area59336.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area59336);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label59344 = (function sablono$core$label59344(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label59344);
/**
 * Creates a submit button.
 */
sablono.core.submit_button59345 = (function sablono$core$submit_button59345(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button59345);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button59346 = (function sablono$core$reset_button59346(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button59346);
/**
 * Create a form that points to a particular method and route.
 * e.g. (form-to [:put "/post"]
 * ...)
 */
sablono.core.form_to59347 = (function sablono$core$form_to59347(){
var args__19535__auto__ = [];
var len__19528__auto___59352 = arguments.length;
var i__19529__auto___59353 = (0);
while(true){
if((i__19529__auto___59353 < len__19528__auto___59352)){
args__19535__auto__.push((arguments[i__19529__auto___59353]));

var G__59354 = (i__19529__auto___59353 + (1));
i__19529__auto___59353 = G__59354;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((1) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((1)),(0))):null);
return sablono.core.form_to59347.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19536__auto__);
});

sablono.core.form_to59347.cljs$core$IFn$_invoke$arity$variadic = (function (p__59350,body){
var vec__59351 = p__59350;
var method = cljs.core.nth.call(null,vec__59351,(0),null);
var action = cljs.core.nth.call(null,vec__59351,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to59347.cljs$lang$maxFixedArity = (1);

sablono.core.form_to59347.cljs$lang$applyTo = (function (seq59348){
var G__59349 = cljs.core.first.call(null,seq59348);
var seq59348__$1 = cljs.core.next.call(null,seq59348);
return sablono.core.form_to59347.cljs$core$IFn$_invoke$arity$variadic(G__59349,seq59348__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to59347);

//# sourceMappingURL=core.js.map