// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('ccn.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
/**
 * Composes a CSS class for an element with modifiers by BEM methodology.
 */
ccn.core.bem = (function ccn$core$bem(var_args){
var G__14923 = arguments.length;
switch (G__14923) {
case 2:
return ccn.core.bem.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return ccn.core.bem.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

ccn.core.bem.cljs$core$IFn$_invoke$arity$2 = (function (block,modifiers){
return ccn.core.bem.cljs$core$IFn$_invoke$arity$3(block,null,modifiers);
});

ccn.core.bem.cljs$core$IFn$_invoke$arity$3 = (function (block,element,modifiers){
var full_name = ((!((element == null)))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(element)].join(''):block);
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.remove.cljs$core$IFn$_invoke$arity$2(clojure.string.blank_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [full_name], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (full_name){
return (function (p1__14921_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(full_name),"--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__14921_SHARP_)].join('');
});})(full_name))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(clojure.string.blank_QMARK_,modifiers)))));
});

ccn.core.bem.cljs$lang$maxFixedArity = 3;

/**
 * Composes a CSS class from given args, removes blanks.
 */
ccn.core.css_class = (function ccn$core$css_class(var_args){
var args__9237__auto__ = [];
var len__9230__auto___14942 = arguments.length;
var i__9231__auto___14943 = (0);
while(true){
if((i__9231__auto___14943 < len__9230__auto___14942)){
args__9237__auto__.push((arguments[i__9231__auto___14943]));

var G__14947 = (i__9231__auto___14943 + (1));
i__9231__auto___14943 = G__14947;
continue;
} else {
}
break;
}

var argseq__9238__auto__ = ((((0) < args__9237__auto__.length))?(new cljs.core.IndexedSeq(args__9237__auto__.slice((0)),(0),null)):null);
return ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(argseq__9238__auto__);
});

ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic = (function (classes){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.remove.cljs$core$IFn$_invoke$arity$2(clojure.string.blank_QMARK_,classes));
});

ccn.core.css_class.cljs$lang$maxFixedArity = (0);

ccn.core.css_class.cljs$lang$applyTo = (function (seq14932){
return ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq14932));
});

/**
 * Composes a CSS class in Twitter Bootstrap way. It handles special cases like `disabled`.
 */
ccn.core.twbs = (function ccn$core$twbs(base,modifiers){
var vec__14951 = cljs.core.split_with(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,"disabled"),cljs.core.set(modifiers));
var head = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14951,(0),null);
var tail = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14951,(1),null);
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.remove.cljs$core$IFn$_invoke$arity$2(clojure.string.blank_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(tail),base], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__14951,head,tail){
return (function (p1__14950_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(base),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__14950_SHARP_)].join('');
});})(vec__14951,head,tail))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(clojure.string.blank_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(head,cljs.core.rest(tail)))))));
});
