// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__14342){
var vec__14343 = p__14342;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14343,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14343,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__14370 = (clojure.data.diff.cljs$core$IFn$_invoke$arity$2 ? clojure.data.diff.cljs$core$IFn$_invoke$arity$2(va,vb) : clojure.data.diff.call(null,va,vb));
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14370,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14370,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14370,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = (in_a) && (in_b) && ((!((ab == null))) || (((va == null)) && ((vb == null))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(((in_a) && ((!((a_STAR_ == null))) || (!(same))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),(((in_b) && ((!((b_STAR_ == null))) || (!(same))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__14422 = arguments.length;
switch (G__14422) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__8409__auto__ = cljs.core.count(a);
var y__8410__auto__ = cljs.core.count(b);
return ((x__8409__auto__ > y__8410__auto__) ? x__8409__auto__ : y__8410__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if((!((x == null))) && (!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null)))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__8742__auto__ = (((x == null))?null:x);
var m__8743__auto__ = (clojure.data.equality_partition[goog.typeOf(x__8742__auto__)]);
if(!((m__8743__auto__ == null))){
return (m__8743__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8743__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__8743__auto__.call(null,x));
} else {
var m__8743__auto____$1 = (clojure.data.equality_partition["_"]);
if(!((m__8743__auto____$1 == null))){
return (m__8743__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8743__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__8743__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if((!((a == null))) && (!((a.clojure$data$Diff$diff_similar$arity$2 == null)))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__8742__auto__ = (((a == null))?null:a);
var m__8743__auto__ = (clojure.data.diff_similar[goog.typeOf(x__8742__auto__)]);
if(!((m__8743__auto__ == null))){
return (m__8743__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8743__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__8743__auto__.call(null,a,b));
} else {
var m__8743__auto____$1 = (clojure.data.diff_similar["_"]);
if(!((m__8743__auto____$1 == null))){
return (m__8743__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8743__auto____$1.cljs$core$IFn$_invoke$arity$2(a,b) : m__8743__auto____$1.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__14448_14489 = clojure.data.equality_partition;
var G__14449_14490 = "null";
var G__14450_14491 = ((function (G__14448_14489,G__14449_14490){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__14448_14489,G__14449_14490))
;
goog.object.set(G__14448_14489,G__14449_14490,G__14450_14491);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__14455_14492 = clojure.data.equality_partition;
var G__14457_14493 = "string";
var G__14458_14494 = ((function (G__14455_14492,G__14457_14493){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__14455_14492,G__14457_14493))
;
goog.object.set(G__14455_14492,G__14457_14493,G__14458_14494);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__14461_14495 = clojure.data.equality_partition;
var G__14462_14496 = "number";
var G__14463_14497 = ((function (G__14461_14495,G__14462_14496){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__14461_14495,G__14462_14496))
;
goog.object.set(G__14461_14495,G__14462_14496,G__14463_14497);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__14464_14501 = clojure.data.equality_partition;
var G__14465_14502 = "array";
var G__14466_14503 = ((function (G__14464_14501,G__14465_14502){
return (function (x){
return cljs.core.cst$kw$sequential;
});})(G__14464_14501,G__14465_14502))
;
goog.object.set(G__14464_14501,G__14465_14502,G__14466_14503);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__14468_14505 = clojure.data.equality_partition;
var G__14469_14506 = "function";
var G__14470_14507 = ((function (G__14468_14505,G__14469_14506){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__14468_14505,G__14469_14506))
;
goog.object.set(G__14468_14505,G__14469_14506,G__14470_14507);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__14471_14509 = clojure.data.equality_partition;
var G__14472_14510 = "boolean";
var G__14473_14511 = ((function (G__14471_14509,G__14472_14510){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__14471_14509,G__14472_14510))
;
goog.object.set(G__14471_14509,G__14472_14510,G__14473_14511);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__14474_14513 = clojure.data.equality_partition;
var G__14475_14514 = "_";
var G__14476_14515 = ((function (G__14474_14513,G__14475_14514){
return (function (x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return cljs.core.cst$kw$map;
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return cljs.core.cst$kw$set;
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return cljs.core.cst$kw$sequential;
} else {
return cljs.core.cst$kw$atom;

}
}
}
});})(G__14474_14513,G__14475_14514))
;
goog.object.set(G__14474_14513,G__14475_14514,G__14476_14515);
goog.object.set(clojure.data.Diff,"null",true);

var G__14526_14568 = clojure.data.diff_similar;
var G__14527_14569 = "null";
var G__14528_14570 = ((function (G__14526_14568,G__14527_14569){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__14526_14568,G__14527_14569))
;
goog.object.set(G__14526_14568,G__14527_14569,G__14528_14570);

goog.object.set(clojure.data.Diff,"string",true);

var G__14533_14573 = clojure.data.diff_similar;
var G__14534_14574 = "string";
var G__14535_14575 = ((function (G__14533_14573,G__14534_14574){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__14533_14573,G__14534_14574))
;
goog.object.set(G__14533_14573,G__14534_14574,G__14535_14575);

goog.object.set(clojure.data.Diff,"number",true);

var G__14536_14579 = clojure.data.diff_similar;
var G__14537_14580 = "number";
var G__14538_14581 = ((function (G__14536_14579,G__14537_14580){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__14536_14579,G__14537_14580))
;
goog.object.set(G__14536_14579,G__14537_14580,G__14538_14581);

goog.object.set(clojure.data.Diff,"array",true);

var G__14541_14583 = clojure.data.diff_similar;
var G__14542_14584 = "array";
var G__14543_14585 = ((function (G__14541_14583,G__14542_14584){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__14541_14583,G__14542_14584))
;
goog.object.set(G__14541_14583,G__14542_14584,G__14543_14585);

goog.object.set(clojure.data.Diff,"function",true);

var G__14544_14590 = clojure.data.diff_similar;
var G__14545_14591 = "function";
var G__14546_14592 = ((function (G__14544_14590,G__14545_14591){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__14544_14590,G__14545_14591))
;
goog.object.set(G__14544_14590,G__14545_14591,G__14546_14592);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__14551_14593 = clojure.data.diff_similar;
var G__14552_14594 = "boolean";
var G__14553_14595 = ((function (G__14551_14593,G__14552_14594){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__14551_14593,G__14552_14594))
;
goog.object.set(G__14551_14593,G__14552_14594,G__14553_14595);

goog.object.set(clojure.data.Diff,"_",true);

var G__14555_14596 = clojure.data.diff_similar;
var G__14556_14597 = "_";
var G__14557_14598 = ((function (G__14555_14596,G__14556_14597){
return (function (a,b){
var fexpr__14563 = (function (){var G__14566 = clojure.data.equality_partition(a);
var G__14566__$1 = (((G__14566 instanceof cljs.core.Keyword))?G__14566.fqn:null);
switch (G__14566__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14566__$1)].join('')));

}
})();
return (fexpr__14563.cljs$core$IFn$_invoke$arity$2 ? fexpr__14563.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14563.call(null,a,b));
});})(G__14555_14596,G__14556_14597))
;
goog.object.set(G__14555_14596,G__14556_14597,G__14557_14598);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});
