// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = cljs.core.cst$kw$event;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.events.kind) : re_frame.registrar.kinds.call(null,re_frame.events.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__14785_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(p1__14785_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain(interceptors);
} else {
if(cljs.core.coll_QMARK_(interceptors)){
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors], 0));
}

var chain = make_chain(interceptors);
if(cljs.core.empty_QMARK_(chain)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: when registering ",id,", given an empty interceptor chain"], 0));
} else {
}

var temp__4657__auto___14803 = cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__4657__auto___14803)){
var not_i_14808 = temp__4657__auto___14803;
if(cljs.core.fn_QMARK_(not_i_14808)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_14808], 0));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: when registering ",id,", expected interceptors, but got: ",not_i_14808], 0));
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler(re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils(id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector(event_v);
var temp__4655__auto__ = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__4655__auto__)){
var interceptors = temp__4655__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler."], 0));
} else {
var _STAR_handling_STAR_14823 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_14825 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$operation,event_id,cljs.core.cst$kw$op_DASH_type,re_frame.events.kind,cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$event,event_v], null)], null));

try{try{return re_frame.interceptor.execute(event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__14739__auto___14854 = re_frame.interop.now();
var duration__14740__auto___14855 = (end__14739__auto___14854 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__14826_14856 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__14827_14857 = null;
var count__14828_14858 = (0);
var i__14829_14859 = (0);
while(true){
if((i__14829_14859 < count__14828_14858)){
var vec__14830_14866 = chunk__14827_14857.cljs$core$IIndexed$_nth$arity$2(null,i__14829_14859);
var k__14741__auto___14867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14830_14866,(0),null);
var cb__14742__auto___14868 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14830_14866,(1),null);
try{var G__14842_14872 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__14740__auto___14855,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__14742__auto___14868.cljs$core$IFn$_invoke$arity$1 ? cb__14742__auto___14868.cljs$core$IFn$_invoke$arity$1(G__14842_14872) : cb__14742__auto___14868.call(null,G__14842_14872));
}catch (e14837){if((e14837 instanceof java.lang.Exception)){
var e__14743__auto___14873 = e14837;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__14741__auto___14867,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__14743__auto___14873], 0));
} else {
throw e14837;

}
}
var G__14875 = seq__14826_14856;
var G__14876 = chunk__14827_14857;
var G__14877 = count__14828_14858;
var G__14878 = (i__14829_14859 + (1));
seq__14826_14856 = G__14875;
chunk__14827_14857 = G__14876;
count__14828_14858 = G__14877;
i__14829_14859 = G__14878;
continue;
} else {
var temp__4657__auto___14879 = cljs.core.seq(seq__14826_14856);
if(temp__4657__auto___14879){
var seq__14826_14880__$1 = temp__4657__auto___14879;
if(cljs.core.chunked_seq_QMARK_(seq__14826_14880__$1)){
var c__8898__auto___14881 = cljs.core.chunk_first(seq__14826_14880__$1);
var G__14883 = cljs.core.chunk_rest(seq__14826_14880__$1);
var G__14884 = c__8898__auto___14881;
var G__14885 = cljs.core.count(c__8898__auto___14881);
var G__14886 = (0);
seq__14826_14856 = G__14883;
chunk__14827_14857 = G__14884;
count__14828_14858 = G__14885;
i__14829_14859 = G__14886;
continue;
} else {
var vec__14844_14891 = cljs.core.first(seq__14826_14880__$1);
var k__14741__auto___14892 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14844_14891,(0),null);
var cb__14742__auto___14893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14844_14891,(1),null);
try{var G__14852_14896 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__14740__auto___14855,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__14742__auto___14893.cljs$core$IFn$_invoke$arity$1 ? cb__14742__auto___14893.cljs$core$IFn$_invoke$arity$1(G__14852_14896) : cb__14742__auto___14893.call(null,G__14852_14896));
}catch (e14850){if((e14850 instanceof java.lang.Exception)){
var e__14743__auto___14902 = e14850;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__14741__auto___14892,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__14743__auto___14902], 0));
} else {
throw e14850;

}
}
var G__14906 = cljs.core.next(seq__14826_14880__$1);
var G__14907 = null;
var G__14908 = (0);
var G__14909 = (0);
seq__14826_14856 = G__14906;
chunk__14827_14857 = G__14907;
count__14828_14858 = G__14908;
i__14829_14859 = G__14909;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_14825;
}} else {
return re_frame.interceptor.execute(event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_14823;
}}
} else {
return null;
}
});
