// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30996 = arguments.length;
switch (G__30996) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async30997 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30997 = (function (f,blockable,meta30998){
this.f = f;
this.blockable = blockable;
this.meta30998 = meta30998;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async30997.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30999,meta30998__$1){
var self__ = this;
var _30999__$1 = this;
return (new cljs.core.async.t_cljs$core$async30997(self__.f,self__.blockable,meta30998__$1));
});

cljs.core.async.t_cljs$core$async30997.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30999){
var self__ = this;
var _30999__$1 = this;
return self__.meta30998;
});

cljs.core.async.t_cljs$core$async30997.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30997.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30997.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async30997.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async30997.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30998","meta30998",982302157,null)], null);
});

cljs.core.async.t_cljs$core$async30997.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30997.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30997";

cljs.core.async.t_cljs$core$async30997.cljs$lang$ctorPrWriter = (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async30997");
});

cljs.core.async.__GT_t_cljs$core$async30997 = (function cljs$core$async$__GT_t_cljs$core$async30997(f__$1,blockable__$1,meta30998){
return (new cljs.core.async.t_cljs$core$async30997(f__$1,blockable__$1,meta30998));
});

}

return (new cljs.core.async.t_cljs$core$async30997(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31003 = arguments.length;
switch (G__31003) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31006 = arguments.length;
switch (G__31006) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31009 = arguments.length;
switch (G__31009) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_31011 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_31011);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_31011,ret){
return (function (){
return fn1.call(null,val_31011);
});})(val_31011,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31013 = arguments.length;
switch (G__31013) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29295__auto___31015 = n;
var x_31016 = (0);
while(true){
if((x_31016 < n__29295__auto___31015)){
(a[x_31016] = (0));

var G__31017 = (x_31016 + (1));
x_31016 = G__31017;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__31018 = (i + (1));
i = G__31018;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async31019 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31019 = (function (flag,meta31020){
this.flag = flag;
this.meta31020 = meta31020;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31021,meta31020__$1){
var self__ = this;
var _31021__$1 = this;
return (new cljs.core.async.t_cljs$core$async31019(self__.flag,meta31020__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31021){
var self__ = this;
var _31021__$1 = this;
return self__.meta31020;
});})(flag))
;

cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31019.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31020","meta31020",-35562413,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31019.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31019.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31019";

cljs.core.async.t_cljs$core$async31019.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async31019");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31019 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31019(flag__$1,meta31020){
return (new cljs.core.async.t_cljs$core$async31019(flag__$1,meta31020));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31019(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31022 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31022 = (function (flag,cb,meta31023){
this.flag = flag;
this.cb = cb;
this.meta31023 = meta31023;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31022.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31024,meta31023__$1){
var self__ = this;
var _31024__$1 = this;
return (new cljs.core.async.t_cljs$core$async31022(self__.flag,self__.cb,meta31023__$1));
});

cljs.core.async.t_cljs$core$async31022.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31024){
var self__ = this;
var _31024__$1 = this;
return self__.meta31023;
});

cljs.core.async.t_cljs$core$async31022.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31022.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async31022.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31022.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31022.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31023","meta31023",-1707964722,null)], null);
});

cljs.core.async.t_cljs$core$async31022.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31022.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31022";

cljs.core.async.t_cljs$core$async31022.cljs$lang$ctorPrWriter = (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async31022");
});

cljs.core.async.__GT_t_cljs$core$async31022 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31022(flag__$1,cb__$1,meta31023){
return (new cljs.core.async.t_cljs$core$async31022(flag__$1,cb__$1,meta31023));
});

}

return (new cljs.core.async.t_cljs$core$async31022(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31025_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31025_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31026_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31026_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28348__auto__ = wport;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31027 = (i + (1));
i = G__31027;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28348__auto__ = ret;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__28336__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28336__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28336__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29526__auto__ = [];
var len__29519__auto___31033 = arguments.length;
var i__29520__auto___31034 = (0);
while(true){
if((i__29520__auto___31034 < len__29519__auto___31033)){
args__29526__auto__.push((arguments[i__29520__auto___31034]));

var G__31035 = (i__29520__auto___31034 + (1));
i__29520__auto___31034 = G__31035;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((1) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29527__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31030){
var map__31031 = p__31030;
var map__31031__$1 = ((((!((map__31031 == null)))?((((map__31031.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31031.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31031):map__31031);
var opts = map__31031__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31028){
var G__31029 = cljs.core.first.call(null,seq31028);
var seq31028__$1 = cljs.core.next.call(null,seq31028);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31029,seq31028__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31037 = arguments.length;
switch (G__31037) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30950__auto___31083 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___31083){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___31083){
return (function (state_31061){
var state_val_31062 = (state_31061[(1)]);
if((state_val_31062 === (7))){
var inst_31057 = (state_31061[(2)]);
var state_31061__$1 = state_31061;
var statearr_31063_31084 = state_31061__$1;
(statearr_31063_31084[(2)] = inst_31057);

(statearr_31063_31084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31062 === (1))){
var state_31061__$1 = state_31061;
var statearr_31064_31085 = state_31061__$1;
(statearr_31064_31085[(2)] = null);

(statearr_31064_31085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31062 === (4))){
var inst_31040 = (state_31061[(7)]);
var inst_31040__$1 = (state_31061[(2)]);
var inst_31041 = (inst_31040__$1 == null);
var state_31061__$1 = (function (){var statearr_31065 = state_31061;
(statearr_31065[(7)] = inst_31040__$1);

return statearr_31065;
})();
if(cljs.core.truth_(inst_31041)){
var statearr_31066_31086 = state_31061__$1;
(statearr_31066_31086[(1)] = (5));

} else {
var statearr_31067_31087 = state_31061__$1;
(statearr_31067_31087[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31062 === (13))){
var state_31061__$1 = state_31061;
var statearr_31068_31088 = state_31061__$1;
(statearr_31068_31088[(2)] = null);

(statearr_31068_31088[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31062 === (6))){
var inst_31040 = (state_31061[(7)]);
var state_31061__$1 = state_31061;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31061__$1,(11),to,inst_31040);
} else {
if((state_val_31062 === (3))){
var inst_31059 = (state_31061[(2)]);
var state_31061__$1 = state_31061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31061__$1,inst_31059);
} else {
if((state_val_31062 === (12))){
var state_31061__$1 = state_31061;
var statearr_31069_31089 = state_31061__$1;
(statearr_31069_31089[(2)] = null);

(statearr_31069_31089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31062 === (2))){
var state_31061__$1 = state_31061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31061__$1,(4),from);
} else {
if((state_val_31062 === (11))){
var inst_31050 = (state_31061[(2)]);
var state_31061__$1 = state_31061;
if(cljs.core.truth_(inst_31050)){
var statearr_31070_31090 = state_31061__$1;
(statearr_31070_31090[(1)] = (12));

} else {
var statearr_31071_31091 = state_31061__$1;
(statearr_31071_31091[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31062 === (9))){
var state_31061__$1 = state_31061;
var statearr_31072_31092 = state_31061__$1;
(statearr_31072_31092[(2)] = null);

(statearr_31072_31092[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31062 === (5))){
var state_31061__$1 = state_31061;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31073_31093 = state_31061__$1;
(statearr_31073_31093[(1)] = (8));

} else {
var statearr_31074_31094 = state_31061__$1;
(statearr_31074_31094[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31062 === (14))){
var inst_31055 = (state_31061[(2)]);
var state_31061__$1 = state_31061;
var statearr_31075_31095 = state_31061__$1;
(statearr_31075_31095[(2)] = inst_31055);

(statearr_31075_31095[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31062 === (10))){
var inst_31047 = (state_31061[(2)]);
var state_31061__$1 = state_31061;
var statearr_31076_31096 = state_31061__$1;
(statearr_31076_31096[(2)] = inst_31047);

(statearr_31076_31096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31062 === (8))){
var inst_31044 = cljs.core.async.close_BANG_.call(null,to);
var state_31061__$1 = state_31061;
var statearr_31077_31097 = state_31061__$1;
(statearr_31077_31097[(2)] = inst_31044);

(statearr_31077_31097[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___31083))
;
return ((function (switch__30862__auto__,c__30950__auto___31083){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_31078 = [null,null,null,null,null,null,null,null];
(statearr_31078[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_31078[(1)] = (1));

return statearr_31078;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_31061){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31079){if((e31079 instanceof Object)){
var ex__30866__auto__ = e31079;
var statearr_31080_31098 = state_31061;
(statearr_31080_31098[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31061);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31079;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31099 = state_31061;
state_31061 = G__31099;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_31061){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_31061);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___31083))
})();
var state__30952__auto__ = (function (){var statearr_31081 = f__30951__auto__.call(null);
(statearr_31081[(6)] = c__30950__auto___31083);

return statearr_31081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___31083))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__31100){
var vec__31101 = p__31100;
var v = cljs.core.nth.call(null,vec__31101,(0),null);
var p = cljs.core.nth.call(null,vec__31101,(1),null);
var job = vec__31101;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__30950__auto___31272 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___31272,res,vec__31101,v,p,job,jobs,results){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___31272,res,vec__31101,v,p,job,jobs,results){
return (function (state_31108){
var state_val_31109 = (state_31108[(1)]);
if((state_val_31109 === (1))){
var state_31108__$1 = state_31108;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31108__$1,(2),res,v);
} else {
if((state_val_31109 === (2))){
var inst_31105 = (state_31108[(2)]);
var inst_31106 = cljs.core.async.close_BANG_.call(null,res);
var state_31108__$1 = (function (){var statearr_31110 = state_31108;
(statearr_31110[(7)] = inst_31105);

return statearr_31110;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31108__$1,inst_31106);
} else {
return null;
}
}
});})(c__30950__auto___31272,res,vec__31101,v,p,job,jobs,results))
;
return ((function (switch__30862__auto__,c__30950__auto___31272,res,vec__31101,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0 = (function (){
var statearr_31111 = [null,null,null,null,null,null,null,null];
(statearr_31111[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__);

(statearr_31111[(1)] = (1));

return statearr_31111;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1 = (function (state_31108){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31108);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31112){if((e31112 instanceof Object)){
var ex__30866__auto__ = e31112;
var statearr_31113_31273 = state_31108;
(statearr_31113_31273[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31108);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31112;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31274 = state_31108;
state_31108 = G__31274;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__ = function(state_31108){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1.call(this,state_31108);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___31272,res,vec__31101,v,p,job,jobs,results))
})();
var state__30952__auto__ = (function (){var statearr_31114 = f__30951__auto__.call(null);
(statearr_31114[(6)] = c__30950__auto___31272);

return statearr_31114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___31272,res,vec__31101,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31115){
var vec__31116 = p__31115;
var v = cljs.core.nth.call(null,vec__31116,(0),null);
var p = cljs.core.nth.call(null,vec__31116,(1),null);
var job = vec__31116;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29295__auto___31275 = n;
var __31276 = (0);
while(true){
if((__31276 < n__29295__auto___31275)){
var G__31119_31277 = type;
var G__31119_31278__$1 = (((G__31119_31277 instanceof cljs.core.Keyword))?G__31119_31277.fqn:null);
switch (G__31119_31278__$1) {
case "compute":
var c__30950__auto___31280 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31276,c__30950__auto___31280,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (__31276,c__30950__auto___31280,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async){
return (function (state_31132){
var state_val_31133 = (state_31132[(1)]);
if((state_val_31133 === (1))){
var state_31132__$1 = state_31132;
var statearr_31134_31281 = state_31132__$1;
(statearr_31134_31281[(2)] = null);

(statearr_31134_31281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31133 === (2))){
var state_31132__$1 = state_31132;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31132__$1,(4),jobs);
} else {
if((state_val_31133 === (3))){
var inst_31130 = (state_31132[(2)]);
var state_31132__$1 = state_31132;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31132__$1,inst_31130);
} else {
if((state_val_31133 === (4))){
var inst_31122 = (state_31132[(2)]);
var inst_31123 = process.call(null,inst_31122);
var state_31132__$1 = state_31132;
if(cljs.core.truth_(inst_31123)){
var statearr_31135_31282 = state_31132__$1;
(statearr_31135_31282[(1)] = (5));

} else {
var statearr_31136_31283 = state_31132__$1;
(statearr_31136_31283[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31133 === (5))){
var state_31132__$1 = state_31132;
var statearr_31137_31284 = state_31132__$1;
(statearr_31137_31284[(2)] = null);

(statearr_31137_31284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31133 === (6))){
var state_31132__$1 = state_31132;
var statearr_31138_31285 = state_31132__$1;
(statearr_31138_31285[(2)] = null);

(statearr_31138_31285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31133 === (7))){
var inst_31128 = (state_31132[(2)]);
var state_31132__$1 = state_31132;
var statearr_31139_31286 = state_31132__$1;
(statearr_31139_31286[(2)] = inst_31128);

(statearr_31139_31286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31276,c__30950__auto___31280,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async))
;
return ((function (__31276,switch__30862__auto__,c__30950__auto___31280,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0 = (function (){
var statearr_31140 = [null,null,null,null,null,null,null];
(statearr_31140[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__);

(statearr_31140[(1)] = (1));

return statearr_31140;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1 = (function (state_31132){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31132);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31141){if((e31141 instanceof Object)){
var ex__30866__auto__ = e31141;
var statearr_31142_31287 = state_31132;
(statearr_31142_31287[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31132);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31141;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31288 = state_31132;
state_31132 = G__31288;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__ = function(state_31132){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1.call(this,state_31132);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__;
})()
;})(__31276,switch__30862__auto__,c__30950__auto___31280,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async))
})();
var state__30952__auto__ = (function (){var statearr_31143 = f__30951__auto__.call(null);
(statearr_31143[(6)] = c__30950__auto___31280);

return statearr_31143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(__31276,c__30950__auto___31280,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async))
);


break;
case "async":
var c__30950__auto___31289 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31276,c__30950__auto___31289,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (__31276,c__30950__auto___31289,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async){
return (function (state_31156){
var state_val_31157 = (state_31156[(1)]);
if((state_val_31157 === (1))){
var state_31156__$1 = state_31156;
var statearr_31158_31290 = state_31156__$1;
(statearr_31158_31290[(2)] = null);

(statearr_31158_31290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31157 === (2))){
var state_31156__$1 = state_31156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31156__$1,(4),jobs);
} else {
if((state_val_31157 === (3))){
var inst_31154 = (state_31156[(2)]);
var state_31156__$1 = state_31156;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31156__$1,inst_31154);
} else {
if((state_val_31157 === (4))){
var inst_31146 = (state_31156[(2)]);
var inst_31147 = async.call(null,inst_31146);
var state_31156__$1 = state_31156;
if(cljs.core.truth_(inst_31147)){
var statearr_31159_31291 = state_31156__$1;
(statearr_31159_31291[(1)] = (5));

} else {
var statearr_31160_31292 = state_31156__$1;
(statearr_31160_31292[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31157 === (5))){
var state_31156__$1 = state_31156;
var statearr_31161_31293 = state_31156__$1;
(statearr_31161_31293[(2)] = null);

(statearr_31161_31293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31157 === (6))){
var state_31156__$1 = state_31156;
var statearr_31162_31294 = state_31156__$1;
(statearr_31162_31294[(2)] = null);

(statearr_31162_31294[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31157 === (7))){
var inst_31152 = (state_31156[(2)]);
var state_31156__$1 = state_31156;
var statearr_31163_31295 = state_31156__$1;
(statearr_31163_31295[(2)] = inst_31152);

(statearr_31163_31295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31276,c__30950__auto___31289,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async))
;
return ((function (__31276,switch__30862__auto__,c__30950__auto___31289,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0 = (function (){
var statearr_31164 = [null,null,null,null,null,null,null];
(statearr_31164[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__);

(statearr_31164[(1)] = (1));

return statearr_31164;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1 = (function (state_31156){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31165){if((e31165 instanceof Object)){
var ex__30866__auto__ = e31165;
var statearr_31166_31296 = state_31156;
(statearr_31166_31296[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31156);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31165;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31297 = state_31156;
state_31156 = G__31297;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__ = function(state_31156){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1.call(this,state_31156);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__;
})()
;})(__31276,switch__30862__auto__,c__30950__auto___31289,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async))
})();
var state__30952__auto__ = (function (){var statearr_31167 = f__30951__auto__.call(null);
(statearr_31167[(6)] = c__30950__auto___31289);

return statearr_31167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(__31276,c__30950__auto___31289,G__31119_31277,G__31119_31278__$1,n__29295__auto___31275,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31119_31278__$1)].join('')));

}

var G__31298 = (__31276 + (1));
__31276 = G__31298;
continue;
} else {
}
break;
}

var c__30950__auto___31299 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___31299,jobs,results,process,async){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___31299,jobs,results,process,async){
return (function (state_31189){
var state_val_31190 = (state_31189[(1)]);
if((state_val_31190 === (1))){
var state_31189__$1 = state_31189;
var statearr_31191_31300 = state_31189__$1;
(statearr_31191_31300[(2)] = null);

(statearr_31191_31300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31190 === (2))){
var state_31189__$1 = state_31189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31189__$1,(4),from);
} else {
if((state_val_31190 === (3))){
var inst_31187 = (state_31189[(2)]);
var state_31189__$1 = state_31189;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31189__$1,inst_31187);
} else {
if((state_val_31190 === (4))){
var inst_31170 = (state_31189[(7)]);
var inst_31170__$1 = (state_31189[(2)]);
var inst_31171 = (inst_31170__$1 == null);
var state_31189__$1 = (function (){var statearr_31192 = state_31189;
(statearr_31192[(7)] = inst_31170__$1);

return statearr_31192;
})();
if(cljs.core.truth_(inst_31171)){
var statearr_31193_31301 = state_31189__$1;
(statearr_31193_31301[(1)] = (5));

} else {
var statearr_31194_31302 = state_31189__$1;
(statearr_31194_31302[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31190 === (5))){
var inst_31173 = cljs.core.async.close_BANG_.call(null,jobs);
var state_31189__$1 = state_31189;
var statearr_31195_31303 = state_31189__$1;
(statearr_31195_31303[(2)] = inst_31173);

(statearr_31195_31303[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31190 === (6))){
var inst_31170 = (state_31189[(7)]);
var inst_31175 = (state_31189[(8)]);
var inst_31175__$1 = cljs.core.async.chan.call(null,(1));
var inst_31176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31177 = [inst_31170,inst_31175__$1];
var inst_31178 = (new cljs.core.PersistentVector(null,2,(5),inst_31176,inst_31177,null));
var state_31189__$1 = (function (){var statearr_31196 = state_31189;
(statearr_31196[(8)] = inst_31175__$1);

return statearr_31196;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31189__$1,(8),jobs,inst_31178);
} else {
if((state_val_31190 === (7))){
var inst_31185 = (state_31189[(2)]);
var state_31189__$1 = state_31189;
var statearr_31197_31304 = state_31189__$1;
(statearr_31197_31304[(2)] = inst_31185);

(statearr_31197_31304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31190 === (8))){
var inst_31175 = (state_31189[(8)]);
var inst_31180 = (state_31189[(2)]);
var state_31189__$1 = (function (){var statearr_31198 = state_31189;
(statearr_31198[(9)] = inst_31180);

return statearr_31198;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31189__$1,(9),results,inst_31175);
} else {
if((state_val_31190 === (9))){
var inst_31182 = (state_31189[(2)]);
var state_31189__$1 = (function (){var statearr_31199 = state_31189;
(statearr_31199[(10)] = inst_31182);

return statearr_31199;
})();
var statearr_31200_31305 = state_31189__$1;
(statearr_31200_31305[(2)] = null);

(statearr_31200_31305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___31299,jobs,results,process,async))
;
return ((function (switch__30862__auto__,c__30950__auto___31299,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0 = (function (){
var statearr_31201 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31201[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__);

(statearr_31201[(1)] = (1));

return statearr_31201;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1 = (function (state_31189){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31202){if((e31202 instanceof Object)){
var ex__30866__auto__ = e31202;
var statearr_31203_31306 = state_31189;
(statearr_31203_31306[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31189);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31202;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31307 = state_31189;
state_31189 = G__31307;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__ = function(state_31189){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1.call(this,state_31189);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___31299,jobs,results,process,async))
})();
var state__30952__auto__ = (function (){var statearr_31204 = f__30951__auto__.call(null);
(statearr_31204[(6)] = c__30950__auto___31299);

return statearr_31204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___31299,jobs,results,process,async))
);


var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__,jobs,results,process,async){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__,jobs,results,process,async){
return (function (state_31242){
var state_val_31243 = (state_31242[(1)]);
if((state_val_31243 === (7))){
var inst_31238 = (state_31242[(2)]);
var state_31242__$1 = state_31242;
var statearr_31244_31308 = state_31242__$1;
(statearr_31244_31308[(2)] = inst_31238);

(statearr_31244_31308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (20))){
var state_31242__$1 = state_31242;
var statearr_31245_31309 = state_31242__$1;
(statearr_31245_31309[(2)] = null);

(statearr_31245_31309[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (1))){
var state_31242__$1 = state_31242;
var statearr_31246_31310 = state_31242__$1;
(statearr_31246_31310[(2)] = null);

(statearr_31246_31310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (4))){
var inst_31207 = (state_31242[(7)]);
var inst_31207__$1 = (state_31242[(2)]);
var inst_31208 = (inst_31207__$1 == null);
var state_31242__$1 = (function (){var statearr_31247 = state_31242;
(statearr_31247[(7)] = inst_31207__$1);

return statearr_31247;
})();
if(cljs.core.truth_(inst_31208)){
var statearr_31248_31311 = state_31242__$1;
(statearr_31248_31311[(1)] = (5));

} else {
var statearr_31249_31312 = state_31242__$1;
(statearr_31249_31312[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (15))){
var inst_31220 = (state_31242[(8)]);
var state_31242__$1 = state_31242;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31242__$1,(18),to,inst_31220);
} else {
if((state_val_31243 === (21))){
var inst_31233 = (state_31242[(2)]);
var state_31242__$1 = state_31242;
var statearr_31250_31313 = state_31242__$1;
(statearr_31250_31313[(2)] = inst_31233);

(statearr_31250_31313[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (13))){
var inst_31235 = (state_31242[(2)]);
var state_31242__$1 = (function (){var statearr_31251 = state_31242;
(statearr_31251[(9)] = inst_31235);

return statearr_31251;
})();
var statearr_31252_31314 = state_31242__$1;
(statearr_31252_31314[(2)] = null);

(statearr_31252_31314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (6))){
var inst_31207 = (state_31242[(7)]);
var state_31242__$1 = state_31242;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31242__$1,(11),inst_31207);
} else {
if((state_val_31243 === (17))){
var inst_31228 = (state_31242[(2)]);
var state_31242__$1 = state_31242;
if(cljs.core.truth_(inst_31228)){
var statearr_31253_31315 = state_31242__$1;
(statearr_31253_31315[(1)] = (19));

} else {
var statearr_31254_31316 = state_31242__$1;
(statearr_31254_31316[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (3))){
var inst_31240 = (state_31242[(2)]);
var state_31242__$1 = state_31242;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31242__$1,inst_31240);
} else {
if((state_val_31243 === (12))){
var inst_31217 = (state_31242[(10)]);
var state_31242__$1 = state_31242;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31242__$1,(14),inst_31217);
} else {
if((state_val_31243 === (2))){
var state_31242__$1 = state_31242;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31242__$1,(4),results);
} else {
if((state_val_31243 === (19))){
var state_31242__$1 = state_31242;
var statearr_31255_31317 = state_31242__$1;
(statearr_31255_31317[(2)] = null);

(statearr_31255_31317[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (11))){
var inst_31217 = (state_31242[(2)]);
var state_31242__$1 = (function (){var statearr_31256 = state_31242;
(statearr_31256[(10)] = inst_31217);

return statearr_31256;
})();
var statearr_31257_31318 = state_31242__$1;
(statearr_31257_31318[(2)] = null);

(statearr_31257_31318[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (9))){
var state_31242__$1 = state_31242;
var statearr_31258_31319 = state_31242__$1;
(statearr_31258_31319[(2)] = null);

(statearr_31258_31319[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (5))){
var state_31242__$1 = state_31242;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31259_31320 = state_31242__$1;
(statearr_31259_31320[(1)] = (8));

} else {
var statearr_31260_31321 = state_31242__$1;
(statearr_31260_31321[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (14))){
var inst_31220 = (state_31242[(8)]);
var inst_31222 = (state_31242[(11)]);
var inst_31220__$1 = (state_31242[(2)]);
var inst_31221 = (inst_31220__$1 == null);
var inst_31222__$1 = cljs.core.not.call(null,inst_31221);
var state_31242__$1 = (function (){var statearr_31261 = state_31242;
(statearr_31261[(8)] = inst_31220__$1);

(statearr_31261[(11)] = inst_31222__$1);

return statearr_31261;
})();
if(inst_31222__$1){
var statearr_31262_31322 = state_31242__$1;
(statearr_31262_31322[(1)] = (15));

} else {
var statearr_31263_31323 = state_31242__$1;
(statearr_31263_31323[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (16))){
var inst_31222 = (state_31242[(11)]);
var state_31242__$1 = state_31242;
var statearr_31264_31324 = state_31242__$1;
(statearr_31264_31324[(2)] = inst_31222);

(statearr_31264_31324[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (10))){
var inst_31214 = (state_31242[(2)]);
var state_31242__$1 = state_31242;
var statearr_31265_31325 = state_31242__$1;
(statearr_31265_31325[(2)] = inst_31214);

(statearr_31265_31325[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (18))){
var inst_31225 = (state_31242[(2)]);
var state_31242__$1 = state_31242;
var statearr_31266_31326 = state_31242__$1;
(statearr_31266_31326[(2)] = inst_31225);

(statearr_31266_31326[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31243 === (8))){
var inst_31211 = cljs.core.async.close_BANG_.call(null,to);
var state_31242__$1 = state_31242;
var statearr_31267_31327 = state_31242__$1;
(statearr_31267_31327[(2)] = inst_31211);

(statearr_31267_31327[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto__,jobs,results,process,async))
;
return ((function (switch__30862__auto__,c__30950__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0 = (function (){
var statearr_31268 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31268[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__);

(statearr_31268[(1)] = (1));

return statearr_31268;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1 = (function (state_31242){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31242);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31269){if((e31269 instanceof Object)){
var ex__30866__auto__ = e31269;
var statearr_31270_31328 = state_31242;
(statearr_31270_31328[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31242);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31269;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31329 = state_31242;
state_31242 = G__31329;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__ = function(state_31242){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1.call(this,state_31242);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30863__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__,jobs,results,process,async))
})();
var state__30952__auto__ = (function (){var statearr_31271 = f__30951__auto__.call(null);
(statearr_31271[(6)] = c__30950__auto__);

return statearr_31271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__,jobs,results,process,async))
);

return c__30950__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31331 = arguments.length;
switch (G__31331) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31334 = arguments.length;
switch (G__31334) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31337 = arguments.length;
switch (G__31337) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__30950__auto___31386 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___31386,tc,fc){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___31386,tc,fc){
return (function (state_31363){
var state_val_31364 = (state_31363[(1)]);
if((state_val_31364 === (7))){
var inst_31359 = (state_31363[(2)]);
var state_31363__$1 = state_31363;
var statearr_31365_31387 = state_31363__$1;
(statearr_31365_31387[(2)] = inst_31359);

(statearr_31365_31387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31364 === (1))){
var state_31363__$1 = state_31363;
var statearr_31366_31388 = state_31363__$1;
(statearr_31366_31388[(2)] = null);

(statearr_31366_31388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31364 === (4))){
var inst_31340 = (state_31363[(7)]);
var inst_31340__$1 = (state_31363[(2)]);
var inst_31341 = (inst_31340__$1 == null);
var state_31363__$1 = (function (){var statearr_31367 = state_31363;
(statearr_31367[(7)] = inst_31340__$1);

return statearr_31367;
})();
if(cljs.core.truth_(inst_31341)){
var statearr_31368_31389 = state_31363__$1;
(statearr_31368_31389[(1)] = (5));

} else {
var statearr_31369_31390 = state_31363__$1;
(statearr_31369_31390[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31364 === (13))){
var state_31363__$1 = state_31363;
var statearr_31370_31391 = state_31363__$1;
(statearr_31370_31391[(2)] = null);

(statearr_31370_31391[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31364 === (6))){
var inst_31340 = (state_31363[(7)]);
var inst_31346 = p.call(null,inst_31340);
var state_31363__$1 = state_31363;
if(cljs.core.truth_(inst_31346)){
var statearr_31371_31392 = state_31363__$1;
(statearr_31371_31392[(1)] = (9));

} else {
var statearr_31372_31393 = state_31363__$1;
(statearr_31372_31393[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31364 === (3))){
var inst_31361 = (state_31363[(2)]);
var state_31363__$1 = state_31363;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31363__$1,inst_31361);
} else {
if((state_val_31364 === (12))){
var state_31363__$1 = state_31363;
var statearr_31373_31394 = state_31363__$1;
(statearr_31373_31394[(2)] = null);

(statearr_31373_31394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31364 === (2))){
var state_31363__$1 = state_31363;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31363__$1,(4),ch);
} else {
if((state_val_31364 === (11))){
var inst_31340 = (state_31363[(7)]);
var inst_31350 = (state_31363[(2)]);
var state_31363__$1 = state_31363;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31363__$1,(8),inst_31350,inst_31340);
} else {
if((state_val_31364 === (9))){
var state_31363__$1 = state_31363;
var statearr_31374_31395 = state_31363__$1;
(statearr_31374_31395[(2)] = tc);

(statearr_31374_31395[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31364 === (5))){
var inst_31343 = cljs.core.async.close_BANG_.call(null,tc);
var inst_31344 = cljs.core.async.close_BANG_.call(null,fc);
var state_31363__$1 = (function (){var statearr_31375 = state_31363;
(statearr_31375[(8)] = inst_31343);

return statearr_31375;
})();
var statearr_31376_31396 = state_31363__$1;
(statearr_31376_31396[(2)] = inst_31344);

(statearr_31376_31396[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31364 === (14))){
var inst_31357 = (state_31363[(2)]);
var state_31363__$1 = state_31363;
var statearr_31377_31397 = state_31363__$1;
(statearr_31377_31397[(2)] = inst_31357);

(statearr_31377_31397[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31364 === (10))){
var state_31363__$1 = state_31363;
var statearr_31378_31398 = state_31363__$1;
(statearr_31378_31398[(2)] = fc);

(statearr_31378_31398[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31364 === (8))){
var inst_31352 = (state_31363[(2)]);
var state_31363__$1 = state_31363;
if(cljs.core.truth_(inst_31352)){
var statearr_31379_31399 = state_31363__$1;
(statearr_31379_31399[(1)] = (12));

} else {
var statearr_31380_31400 = state_31363__$1;
(statearr_31380_31400[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___31386,tc,fc))
;
return ((function (switch__30862__auto__,c__30950__auto___31386,tc,fc){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_31381 = [null,null,null,null,null,null,null,null,null];
(statearr_31381[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_31381[(1)] = (1));

return statearr_31381;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_31363){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31363);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31382){if((e31382 instanceof Object)){
var ex__30866__auto__ = e31382;
var statearr_31383_31401 = state_31363;
(statearr_31383_31401[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31363);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31382;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31402 = state_31363;
state_31363 = G__31402;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_31363){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_31363);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___31386,tc,fc))
})();
var state__30952__auto__ = (function (){var statearr_31384 = f__30951__auto__.call(null);
(statearr_31384[(6)] = c__30950__auto___31386);

return statearr_31384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___31386,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__){
return (function (state_31423){
var state_val_31424 = (state_31423[(1)]);
if((state_val_31424 === (7))){
var inst_31419 = (state_31423[(2)]);
var state_31423__$1 = state_31423;
var statearr_31425_31443 = state_31423__$1;
(statearr_31425_31443[(2)] = inst_31419);

(statearr_31425_31443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31424 === (1))){
var inst_31403 = init;
var state_31423__$1 = (function (){var statearr_31426 = state_31423;
(statearr_31426[(7)] = inst_31403);

return statearr_31426;
})();
var statearr_31427_31444 = state_31423__$1;
(statearr_31427_31444[(2)] = null);

(statearr_31427_31444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31424 === (4))){
var inst_31406 = (state_31423[(8)]);
var inst_31406__$1 = (state_31423[(2)]);
var inst_31407 = (inst_31406__$1 == null);
var state_31423__$1 = (function (){var statearr_31428 = state_31423;
(statearr_31428[(8)] = inst_31406__$1);

return statearr_31428;
})();
if(cljs.core.truth_(inst_31407)){
var statearr_31429_31445 = state_31423__$1;
(statearr_31429_31445[(1)] = (5));

} else {
var statearr_31430_31446 = state_31423__$1;
(statearr_31430_31446[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31424 === (6))){
var inst_31410 = (state_31423[(9)]);
var inst_31406 = (state_31423[(8)]);
var inst_31403 = (state_31423[(7)]);
var inst_31410__$1 = f.call(null,inst_31403,inst_31406);
var inst_31411 = cljs.core.reduced_QMARK_.call(null,inst_31410__$1);
var state_31423__$1 = (function (){var statearr_31431 = state_31423;
(statearr_31431[(9)] = inst_31410__$1);

return statearr_31431;
})();
if(inst_31411){
var statearr_31432_31447 = state_31423__$1;
(statearr_31432_31447[(1)] = (8));

} else {
var statearr_31433_31448 = state_31423__$1;
(statearr_31433_31448[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31424 === (3))){
var inst_31421 = (state_31423[(2)]);
var state_31423__$1 = state_31423;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31423__$1,inst_31421);
} else {
if((state_val_31424 === (2))){
var state_31423__$1 = state_31423;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31423__$1,(4),ch);
} else {
if((state_val_31424 === (9))){
var inst_31410 = (state_31423[(9)]);
var inst_31403 = inst_31410;
var state_31423__$1 = (function (){var statearr_31434 = state_31423;
(statearr_31434[(7)] = inst_31403);

return statearr_31434;
})();
var statearr_31435_31449 = state_31423__$1;
(statearr_31435_31449[(2)] = null);

(statearr_31435_31449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31424 === (5))){
var inst_31403 = (state_31423[(7)]);
var state_31423__$1 = state_31423;
var statearr_31436_31450 = state_31423__$1;
(statearr_31436_31450[(2)] = inst_31403);

(statearr_31436_31450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31424 === (10))){
var inst_31417 = (state_31423[(2)]);
var state_31423__$1 = state_31423;
var statearr_31437_31451 = state_31423__$1;
(statearr_31437_31451[(2)] = inst_31417);

(statearr_31437_31451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31424 === (8))){
var inst_31410 = (state_31423[(9)]);
var inst_31413 = cljs.core.deref.call(null,inst_31410);
var state_31423__$1 = state_31423;
var statearr_31438_31452 = state_31423__$1;
(statearr_31438_31452[(2)] = inst_31413);

(statearr_31438_31452[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto__))
;
return ((function (switch__30862__auto__,c__30950__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__30863__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30863__auto____0 = (function (){
var statearr_31439 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31439[(0)] = cljs$core$async$reduce_$_state_machine__30863__auto__);

(statearr_31439[(1)] = (1));

return statearr_31439;
});
var cljs$core$async$reduce_$_state_machine__30863__auto____1 = (function (state_31423){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31423);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31440){if((e31440 instanceof Object)){
var ex__30866__auto__ = e31440;
var statearr_31441_31453 = state_31423;
(statearr_31441_31453[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31423);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31440;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31454 = state_31423;
state_31423 = G__31454;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30863__auto__ = function(state_31423){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30863__auto____1.call(this,state_31423);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30863__auto____0;
cljs$core$async$reduce_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30863__auto____1;
return cljs$core$async$reduce_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__))
})();
var state__30952__auto__ = (function (){var statearr_31442 = f__30951__auto__.call(null);
(statearr_31442[(6)] = c__30950__auto__);

return statearr_31442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__))
);

return c__30950__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__,f__$1){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__,f__$1){
return (function (state_31460){
var state_val_31461 = (state_31460[(1)]);
if((state_val_31461 === (1))){
var inst_31455 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_31460__$1 = state_31460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31460__$1,(2),inst_31455);
} else {
if((state_val_31461 === (2))){
var inst_31457 = (state_31460[(2)]);
var inst_31458 = f__$1.call(null,inst_31457);
var state_31460__$1 = state_31460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31460__$1,inst_31458);
} else {
return null;
}
}
});})(c__30950__auto__,f__$1))
;
return ((function (switch__30862__auto__,c__30950__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__30863__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30863__auto____0 = (function (){
var statearr_31462 = [null,null,null,null,null,null,null];
(statearr_31462[(0)] = cljs$core$async$transduce_$_state_machine__30863__auto__);

(statearr_31462[(1)] = (1));

return statearr_31462;
});
var cljs$core$async$transduce_$_state_machine__30863__auto____1 = (function (state_31460){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31463){if((e31463 instanceof Object)){
var ex__30866__auto__ = e31463;
var statearr_31464_31466 = state_31460;
(statearr_31464_31466[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31460);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31463;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31467 = state_31460;
state_31460 = G__31467;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30863__auto__ = function(state_31460){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30863__auto____1.call(this,state_31460);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30863__auto____0;
cljs$core$async$transduce_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30863__auto____1;
return cljs$core$async$transduce_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__,f__$1))
})();
var state__30952__auto__ = (function (){var statearr_31465 = f__30951__auto__.call(null);
(statearr_31465[(6)] = c__30950__auto__);

return statearr_31465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__,f__$1))
);

return c__30950__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31469 = arguments.length;
switch (G__31469) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__){
return (function (state_31494){
var state_val_31495 = (state_31494[(1)]);
if((state_val_31495 === (7))){
var inst_31476 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
var statearr_31496_31517 = state_31494__$1;
(statearr_31496_31517[(2)] = inst_31476);

(statearr_31496_31517[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (1))){
var inst_31470 = cljs.core.seq.call(null,coll);
var inst_31471 = inst_31470;
var state_31494__$1 = (function (){var statearr_31497 = state_31494;
(statearr_31497[(7)] = inst_31471);

return statearr_31497;
})();
var statearr_31498_31518 = state_31494__$1;
(statearr_31498_31518[(2)] = null);

(statearr_31498_31518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (4))){
var inst_31471 = (state_31494[(7)]);
var inst_31474 = cljs.core.first.call(null,inst_31471);
var state_31494__$1 = state_31494;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31494__$1,(7),ch,inst_31474);
} else {
if((state_val_31495 === (13))){
var inst_31488 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
var statearr_31499_31519 = state_31494__$1;
(statearr_31499_31519[(2)] = inst_31488);

(statearr_31499_31519[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (6))){
var inst_31479 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
if(cljs.core.truth_(inst_31479)){
var statearr_31500_31520 = state_31494__$1;
(statearr_31500_31520[(1)] = (8));

} else {
var statearr_31501_31521 = state_31494__$1;
(statearr_31501_31521[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (3))){
var inst_31492 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31494__$1,inst_31492);
} else {
if((state_val_31495 === (12))){
var state_31494__$1 = state_31494;
var statearr_31502_31522 = state_31494__$1;
(statearr_31502_31522[(2)] = null);

(statearr_31502_31522[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (2))){
var inst_31471 = (state_31494[(7)]);
var state_31494__$1 = state_31494;
if(cljs.core.truth_(inst_31471)){
var statearr_31503_31523 = state_31494__$1;
(statearr_31503_31523[(1)] = (4));

} else {
var statearr_31504_31524 = state_31494__$1;
(statearr_31504_31524[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (11))){
var inst_31485 = cljs.core.async.close_BANG_.call(null,ch);
var state_31494__$1 = state_31494;
var statearr_31505_31525 = state_31494__$1;
(statearr_31505_31525[(2)] = inst_31485);

(statearr_31505_31525[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (9))){
var state_31494__$1 = state_31494;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31506_31526 = state_31494__$1;
(statearr_31506_31526[(1)] = (11));

} else {
var statearr_31507_31527 = state_31494__$1;
(statearr_31507_31527[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (5))){
var inst_31471 = (state_31494[(7)]);
var state_31494__$1 = state_31494;
var statearr_31508_31528 = state_31494__$1;
(statearr_31508_31528[(2)] = inst_31471);

(statearr_31508_31528[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (10))){
var inst_31490 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
var statearr_31509_31529 = state_31494__$1;
(statearr_31509_31529[(2)] = inst_31490);

(statearr_31509_31529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (8))){
var inst_31471 = (state_31494[(7)]);
var inst_31481 = cljs.core.next.call(null,inst_31471);
var inst_31471__$1 = inst_31481;
var state_31494__$1 = (function (){var statearr_31510 = state_31494;
(statearr_31510[(7)] = inst_31471__$1);

return statearr_31510;
})();
var statearr_31511_31530 = state_31494__$1;
(statearr_31511_31530[(2)] = null);

(statearr_31511_31530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto__))
;
return ((function (switch__30862__auto__,c__30950__auto__){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_31512 = [null,null,null,null,null,null,null,null];
(statearr_31512[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_31512[(1)] = (1));

return statearr_31512;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_31494){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31513){if((e31513 instanceof Object)){
var ex__30866__auto__ = e31513;
var statearr_31514_31531 = state_31494;
(statearr_31514_31531[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31494);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31513;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31532 = state_31494;
state_31494 = G__31532;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_31494){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_31494);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__))
})();
var state__30952__auto__ = (function (){var statearr_31515 = f__30951__auto__.call(null);
(statearr_31515[(6)] = c__30950__auto__);

return statearr_31515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__))
);

return c__30950__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__29031__auto__ = (((_ == null))?null:_);
var m__29032__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,_);
} else {
var m__29032__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__29032__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,ch);
} else {
var m__29032__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m);
} else {
var m__29032__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31533 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31533 = (function (ch,cs,meta31534){
this.ch = ch;
this.cs = cs;
this.meta31534 = meta31534;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31533.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31535,meta31534__$1){
var self__ = this;
var _31535__$1 = this;
return (new cljs.core.async.t_cljs$core$async31533(self__.ch,self__.cs,meta31534__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async31533.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31535){
var self__ = this;
var _31535__$1 = this;
return self__.meta31534;
});})(cs))
;

cljs.core.async.t_cljs$core$async31533.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31533.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async31533.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31533.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31533.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31533.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31533.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31534","meta31534",1144539777,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async31533.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31533.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31533";

cljs.core.async.t_cljs$core$async31533.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async31533");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async31533 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async31533(ch__$1,cs__$1,meta31534){
return (new cljs.core.async.t_cljs$core$async31533(ch__$1,cs__$1,meta31534));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async31533(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__30950__auto___31755 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___31755,cs,m,dchan,dctr,done){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___31755,cs,m,dchan,dctr,done){
return (function (state_31670){
var state_val_31671 = (state_31670[(1)]);
if((state_val_31671 === (7))){
var inst_31666 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31672_31756 = state_31670__$1;
(statearr_31672_31756[(2)] = inst_31666);

(statearr_31672_31756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (20))){
var inst_31569 = (state_31670[(7)]);
var inst_31581 = cljs.core.first.call(null,inst_31569);
var inst_31582 = cljs.core.nth.call(null,inst_31581,(0),null);
var inst_31583 = cljs.core.nth.call(null,inst_31581,(1),null);
var state_31670__$1 = (function (){var statearr_31673 = state_31670;
(statearr_31673[(8)] = inst_31582);

return statearr_31673;
})();
if(cljs.core.truth_(inst_31583)){
var statearr_31674_31757 = state_31670__$1;
(statearr_31674_31757[(1)] = (22));

} else {
var statearr_31675_31758 = state_31670__$1;
(statearr_31675_31758[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (27))){
var inst_31618 = (state_31670[(9)]);
var inst_31611 = (state_31670[(10)]);
var inst_31613 = (state_31670[(11)]);
var inst_31538 = (state_31670[(12)]);
var inst_31618__$1 = cljs.core._nth.call(null,inst_31611,inst_31613);
var inst_31619 = cljs.core.async.put_BANG_.call(null,inst_31618__$1,inst_31538,done);
var state_31670__$1 = (function (){var statearr_31676 = state_31670;
(statearr_31676[(9)] = inst_31618__$1);

return statearr_31676;
})();
if(cljs.core.truth_(inst_31619)){
var statearr_31677_31759 = state_31670__$1;
(statearr_31677_31759[(1)] = (30));

} else {
var statearr_31678_31760 = state_31670__$1;
(statearr_31678_31760[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (1))){
var state_31670__$1 = state_31670;
var statearr_31679_31761 = state_31670__$1;
(statearr_31679_31761[(2)] = null);

(statearr_31679_31761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (24))){
var inst_31569 = (state_31670[(7)]);
var inst_31588 = (state_31670[(2)]);
var inst_31589 = cljs.core.next.call(null,inst_31569);
var inst_31547 = inst_31589;
var inst_31548 = null;
var inst_31549 = (0);
var inst_31550 = (0);
var state_31670__$1 = (function (){var statearr_31680 = state_31670;
(statearr_31680[(13)] = inst_31549);

(statearr_31680[(14)] = inst_31547);

(statearr_31680[(15)] = inst_31548);

(statearr_31680[(16)] = inst_31550);

(statearr_31680[(17)] = inst_31588);

return statearr_31680;
})();
var statearr_31681_31762 = state_31670__$1;
(statearr_31681_31762[(2)] = null);

(statearr_31681_31762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (39))){
var state_31670__$1 = state_31670;
var statearr_31685_31763 = state_31670__$1;
(statearr_31685_31763[(2)] = null);

(statearr_31685_31763[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (4))){
var inst_31538 = (state_31670[(12)]);
var inst_31538__$1 = (state_31670[(2)]);
var inst_31539 = (inst_31538__$1 == null);
var state_31670__$1 = (function (){var statearr_31686 = state_31670;
(statearr_31686[(12)] = inst_31538__$1);

return statearr_31686;
})();
if(cljs.core.truth_(inst_31539)){
var statearr_31687_31764 = state_31670__$1;
(statearr_31687_31764[(1)] = (5));

} else {
var statearr_31688_31765 = state_31670__$1;
(statearr_31688_31765[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (15))){
var inst_31549 = (state_31670[(13)]);
var inst_31547 = (state_31670[(14)]);
var inst_31548 = (state_31670[(15)]);
var inst_31550 = (state_31670[(16)]);
var inst_31565 = (state_31670[(2)]);
var inst_31566 = (inst_31550 + (1));
var tmp31682 = inst_31549;
var tmp31683 = inst_31547;
var tmp31684 = inst_31548;
var inst_31547__$1 = tmp31683;
var inst_31548__$1 = tmp31684;
var inst_31549__$1 = tmp31682;
var inst_31550__$1 = inst_31566;
var state_31670__$1 = (function (){var statearr_31689 = state_31670;
(statearr_31689[(13)] = inst_31549__$1);

(statearr_31689[(18)] = inst_31565);

(statearr_31689[(14)] = inst_31547__$1);

(statearr_31689[(15)] = inst_31548__$1);

(statearr_31689[(16)] = inst_31550__$1);

return statearr_31689;
})();
var statearr_31690_31766 = state_31670__$1;
(statearr_31690_31766[(2)] = null);

(statearr_31690_31766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (21))){
var inst_31592 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31694_31767 = state_31670__$1;
(statearr_31694_31767[(2)] = inst_31592);

(statearr_31694_31767[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (31))){
var inst_31618 = (state_31670[(9)]);
var inst_31622 = done.call(null,null);
var inst_31623 = cljs.core.async.untap_STAR_.call(null,m,inst_31618);
var state_31670__$1 = (function (){var statearr_31695 = state_31670;
(statearr_31695[(19)] = inst_31622);

return statearr_31695;
})();
var statearr_31696_31768 = state_31670__$1;
(statearr_31696_31768[(2)] = inst_31623);

(statearr_31696_31768[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (32))){
var inst_31610 = (state_31670[(20)]);
var inst_31611 = (state_31670[(10)]);
var inst_31612 = (state_31670[(21)]);
var inst_31613 = (state_31670[(11)]);
var inst_31625 = (state_31670[(2)]);
var inst_31626 = (inst_31613 + (1));
var tmp31691 = inst_31610;
var tmp31692 = inst_31611;
var tmp31693 = inst_31612;
var inst_31610__$1 = tmp31691;
var inst_31611__$1 = tmp31692;
var inst_31612__$1 = tmp31693;
var inst_31613__$1 = inst_31626;
var state_31670__$1 = (function (){var statearr_31697 = state_31670;
(statearr_31697[(20)] = inst_31610__$1);

(statearr_31697[(22)] = inst_31625);

(statearr_31697[(10)] = inst_31611__$1);

(statearr_31697[(21)] = inst_31612__$1);

(statearr_31697[(11)] = inst_31613__$1);

return statearr_31697;
})();
var statearr_31698_31769 = state_31670__$1;
(statearr_31698_31769[(2)] = null);

(statearr_31698_31769[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (40))){
var inst_31638 = (state_31670[(23)]);
var inst_31642 = done.call(null,null);
var inst_31643 = cljs.core.async.untap_STAR_.call(null,m,inst_31638);
var state_31670__$1 = (function (){var statearr_31699 = state_31670;
(statearr_31699[(24)] = inst_31642);

return statearr_31699;
})();
var statearr_31700_31770 = state_31670__$1;
(statearr_31700_31770[(2)] = inst_31643);

(statearr_31700_31770[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (33))){
var inst_31629 = (state_31670[(25)]);
var inst_31631 = cljs.core.chunked_seq_QMARK_.call(null,inst_31629);
var state_31670__$1 = state_31670;
if(inst_31631){
var statearr_31701_31771 = state_31670__$1;
(statearr_31701_31771[(1)] = (36));

} else {
var statearr_31702_31772 = state_31670__$1;
(statearr_31702_31772[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (13))){
var inst_31559 = (state_31670[(26)]);
var inst_31562 = cljs.core.async.close_BANG_.call(null,inst_31559);
var state_31670__$1 = state_31670;
var statearr_31703_31773 = state_31670__$1;
(statearr_31703_31773[(2)] = inst_31562);

(statearr_31703_31773[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (22))){
var inst_31582 = (state_31670[(8)]);
var inst_31585 = cljs.core.async.close_BANG_.call(null,inst_31582);
var state_31670__$1 = state_31670;
var statearr_31704_31774 = state_31670__$1;
(statearr_31704_31774[(2)] = inst_31585);

(statearr_31704_31774[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (36))){
var inst_31629 = (state_31670[(25)]);
var inst_31633 = cljs.core.chunk_first.call(null,inst_31629);
var inst_31634 = cljs.core.chunk_rest.call(null,inst_31629);
var inst_31635 = cljs.core.count.call(null,inst_31633);
var inst_31610 = inst_31634;
var inst_31611 = inst_31633;
var inst_31612 = inst_31635;
var inst_31613 = (0);
var state_31670__$1 = (function (){var statearr_31705 = state_31670;
(statearr_31705[(20)] = inst_31610);

(statearr_31705[(10)] = inst_31611);

(statearr_31705[(21)] = inst_31612);

(statearr_31705[(11)] = inst_31613);

return statearr_31705;
})();
var statearr_31706_31775 = state_31670__$1;
(statearr_31706_31775[(2)] = null);

(statearr_31706_31775[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (41))){
var inst_31629 = (state_31670[(25)]);
var inst_31645 = (state_31670[(2)]);
var inst_31646 = cljs.core.next.call(null,inst_31629);
var inst_31610 = inst_31646;
var inst_31611 = null;
var inst_31612 = (0);
var inst_31613 = (0);
var state_31670__$1 = (function (){var statearr_31707 = state_31670;
(statearr_31707[(27)] = inst_31645);

(statearr_31707[(20)] = inst_31610);

(statearr_31707[(10)] = inst_31611);

(statearr_31707[(21)] = inst_31612);

(statearr_31707[(11)] = inst_31613);

return statearr_31707;
})();
var statearr_31708_31776 = state_31670__$1;
(statearr_31708_31776[(2)] = null);

(statearr_31708_31776[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (43))){
var state_31670__$1 = state_31670;
var statearr_31709_31777 = state_31670__$1;
(statearr_31709_31777[(2)] = null);

(statearr_31709_31777[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (29))){
var inst_31654 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31710_31778 = state_31670__$1;
(statearr_31710_31778[(2)] = inst_31654);

(statearr_31710_31778[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (44))){
var inst_31663 = (state_31670[(2)]);
var state_31670__$1 = (function (){var statearr_31711 = state_31670;
(statearr_31711[(28)] = inst_31663);

return statearr_31711;
})();
var statearr_31712_31779 = state_31670__$1;
(statearr_31712_31779[(2)] = null);

(statearr_31712_31779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (6))){
var inst_31602 = (state_31670[(29)]);
var inst_31601 = cljs.core.deref.call(null,cs);
var inst_31602__$1 = cljs.core.keys.call(null,inst_31601);
var inst_31603 = cljs.core.count.call(null,inst_31602__$1);
var inst_31604 = cljs.core.reset_BANG_.call(null,dctr,inst_31603);
var inst_31609 = cljs.core.seq.call(null,inst_31602__$1);
var inst_31610 = inst_31609;
var inst_31611 = null;
var inst_31612 = (0);
var inst_31613 = (0);
var state_31670__$1 = (function (){var statearr_31713 = state_31670;
(statearr_31713[(20)] = inst_31610);

(statearr_31713[(10)] = inst_31611);

(statearr_31713[(21)] = inst_31612);

(statearr_31713[(29)] = inst_31602__$1);

(statearr_31713[(11)] = inst_31613);

(statearr_31713[(30)] = inst_31604);

return statearr_31713;
})();
var statearr_31714_31780 = state_31670__$1;
(statearr_31714_31780[(2)] = null);

(statearr_31714_31780[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (28))){
var inst_31610 = (state_31670[(20)]);
var inst_31629 = (state_31670[(25)]);
var inst_31629__$1 = cljs.core.seq.call(null,inst_31610);
var state_31670__$1 = (function (){var statearr_31715 = state_31670;
(statearr_31715[(25)] = inst_31629__$1);

return statearr_31715;
})();
if(inst_31629__$1){
var statearr_31716_31781 = state_31670__$1;
(statearr_31716_31781[(1)] = (33));

} else {
var statearr_31717_31782 = state_31670__$1;
(statearr_31717_31782[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (25))){
var inst_31612 = (state_31670[(21)]);
var inst_31613 = (state_31670[(11)]);
var inst_31615 = (inst_31613 < inst_31612);
var inst_31616 = inst_31615;
var state_31670__$1 = state_31670;
if(cljs.core.truth_(inst_31616)){
var statearr_31718_31783 = state_31670__$1;
(statearr_31718_31783[(1)] = (27));

} else {
var statearr_31719_31784 = state_31670__$1;
(statearr_31719_31784[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (34))){
var state_31670__$1 = state_31670;
var statearr_31720_31785 = state_31670__$1;
(statearr_31720_31785[(2)] = null);

(statearr_31720_31785[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (17))){
var state_31670__$1 = state_31670;
var statearr_31721_31786 = state_31670__$1;
(statearr_31721_31786[(2)] = null);

(statearr_31721_31786[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (3))){
var inst_31668 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31670__$1,inst_31668);
} else {
if((state_val_31671 === (12))){
var inst_31597 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31722_31787 = state_31670__$1;
(statearr_31722_31787[(2)] = inst_31597);

(statearr_31722_31787[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (2))){
var state_31670__$1 = state_31670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31670__$1,(4),ch);
} else {
if((state_val_31671 === (23))){
var state_31670__$1 = state_31670;
var statearr_31723_31788 = state_31670__$1;
(statearr_31723_31788[(2)] = null);

(statearr_31723_31788[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (35))){
var inst_31652 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31724_31789 = state_31670__$1;
(statearr_31724_31789[(2)] = inst_31652);

(statearr_31724_31789[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (19))){
var inst_31569 = (state_31670[(7)]);
var inst_31573 = cljs.core.chunk_first.call(null,inst_31569);
var inst_31574 = cljs.core.chunk_rest.call(null,inst_31569);
var inst_31575 = cljs.core.count.call(null,inst_31573);
var inst_31547 = inst_31574;
var inst_31548 = inst_31573;
var inst_31549 = inst_31575;
var inst_31550 = (0);
var state_31670__$1 = (function (){var statearr_31725 = state_31670;
(statearr_31725[(13)] = inst_31549);

(statearr_31725[(14)] = inst_31547);

(statearr_31725[(15)] = inst_31548);

(statearr_31725[(16)] = inst_31550);

return statearr_31725;
})();
var statearr_31726_31790 = state_31670__$1;
(statearr_31726_31790[(2)] = null);

(statearr_31726_31790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (11))){
var inst_31569 = (state_31670[(7)]);
var inst_31547 = (state_31670[(14)]);
var inst_31569__$1 = cljs.core.seq.call(null,inst_31547);
var state_31670__$1 = (function (){var statearr_31727 = state_31670;
(statearr_31727[(7)] = inst_31569__$1);

return statearr_31727;
})();
if(inst_31569__$1){
var statearr_31728_31791 = state_31670__$1;
(statearr_31728_31791[(1)] = (16));

} else {
var statearr_31729_31792 = state_31670__$1;
(statearr_31729_31792[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (9))){
var inst_31599 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31730_31793 = state_31670__$1;
(statearr_31730_31793[(2)] = inst_31599);

(statearr_31730_31793[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (5))){
var inst_31545 = cljs.core.deref.call(null,cs);
var inst_31546 = cljs.core.seq.call(null,inst_31545);
var inst_31547 = inst_31546;
var inst_31548 = null;
var inst_31549 = (0);
var inst_31550 = (0);
var state_31670__$1 = (function (){var statearr_31731 = state_31670;
(statearr_31731[(13)] = inst_31549);

(statearr_31731[(14)] = inst_31547);

(statearr_31731[(15)] = inst_31548);

(statearr_31731[(16)] = inst_31550);

return statearr_31731;
})();
var statearr_31732_31794 = state_31670__$1;
(statearr_31732_31794[(2)] = null);

(statearr_31732_31794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (14))){
var state_31670__$1 = state_31670;
var statearr_31733_31795 = state_31670__$1;
(statearr_31733_31795[(2)] = null);

(statearr_31733_31795[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (45))){
var inst_31660 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31734_31796 = state_31670__$1;
(statearr_31734_31796[(2)] = inst_31660);

(statearr_31734_31796[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (26))){
var inst_31602 = (state_31670[(29)]);
var inst_31656 = (state_31670[(2)]);
var inst_31657 = cljs.core.seq.call(null,inst_31602);
var state_31670__$1 = (function (){var statearr_31735 = state_31670;
(statearr_31735[(31)] = inst_31656);

return statearr_31735;
})();
if(inst_31657){
var statearr_31736_31797 = state_31670__$1;
(statearr_31736_31797[(1)] = (42));

} else {
var statearr_31737_31798 = state_31670__$1;
(statearr_31737_31798[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (16))){
var inst_31569 = (state_31670[(7)]);
var inst_31571 = cljs.core.chunked_seq_QMARK_.call(null,inst_31569);
var state_31670__$1 = state_31670;
if(inst_31571){
var statearr_31738_31799 = state_31670__$1;
(statearr_31738_31799[(1)] = (19));

} else {
var statearr_31739_31800 = state_31670__$1;
(statearr_31739_31800[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (38))){
var inst_31649 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31740_31801 = state_31670__$1;
(statearr_31740_31801[(2)] = inst_31649);

(statearr_31740_31801[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (30))){
var state_31670__$1 = state_31670;
var statearr_31741_31802 = state_31670__$1;
(statearr_31741_31802[(2)] = null);

(statearr_31741_31802[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (10))){
var inst_31548 = (state_31670[(15)]);
var inst_31550 = (state_31670[(16)]);
var inst_31558 = cljs.core._nth.call(null,inst_31548,inst_31550);
var inst_31559 = cljs.core.nth.call(null,inst_31558,(0),null);
var inst_31560 = cljs.core.nth.call(null,inst_31558,(1),null);
var state_31670__$1 = (function (){var statearr_31742 = state_31670;
(statearr_31742[(26)] = inst_31559);

return statearr_31742;
})();
if(cljs.core.truth_(inst_31560)){
var statearr_31743_31803 = state_31670__$1;
(statearr_31743_31803[(1)] = (13));

} else {
var statearr_31744_31804 = state_31670__$1;
(statearr_31744_31804[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (18))){
var inst_31595 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31745_31805 = state_31670__$1;
(statearr_31745_31805[(2)] = inst_31595);

(statearr_31745_31805[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (42))){
var state_31670__$1 = state_31670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31670__$1,(45),dchan);
} else {
if((state_val_31671 === (37))){
var inst_31638 = (state_31670[(23)]);
var inst_31629 = (state_31670[(25)]);
var inst_31538 = (state_31670[(12)]);
var inst_31638__$1 = cljs.core.first.call(null,inst_31629);
var inst_31639 = cljs.core.async.put_BANG_.call(null,inst_31638__$1,inst_31538,done);
var state_31670__$1 = (function (){var statearr_31746 = state_31670;
(statearr_31746[(23)] = inst_31638__$1);

return statearr_31746;
})();
if(cljs.core.truth_(inst_31639)){
var statearr_31747_31806 = state_31670__$1;
(statearr_31747_31806[(1)] = (39));

} else {
var statearr_31748_31807 = state_31670__$1;
(statearr_31748_31807[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31671 === (8))){
var inst_31549 = (state_31670[(13)]);
var inst_31550 = (state_31670[(16)]);
var inst_31552 = (inst_31550 < inst_31549);
var inst_31553 = inst_31552;
var state_31670__$1 = state_31670;
if(cljs.core.truth_(inst_31553)){
var statearr_31749_31808 = state_31670__$1;
(statearr_31749_31808[(1)] = (10));

} else {
var statearr_31750_31809 = state_31670__$1;
(statearr_31750_31809[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___31755,cs,m,dchan,dctr,done))
;
return ((function (switch__30862__auto__,c__30950__auto___31755,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__30863__auto__ = null;
var cljs$core$async$mult_$_state_machine__30863__auto____0 = (function (){
var statearr_31751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31751[(0)] = cljs$core$async$mult_$_state_machine__30863__auto__);

(statearr_31751[(1)] = (1));

return statearr_31751;
});
var cljs$core$async$mult_$_state_machine__30863__auto____1 = (function (state_31670){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31670);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31752){if((e31752 instanceof Object)){
var ex__30866__auto__ = e31752;
var statearr_31753_31810 = state_31670;
(statearr_31753_31810[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31670);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31752;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31811 = state_31670;
state_31670 = G__31811;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30863__auto__ = function(state_31670){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30863__auto____1.call(this,state_31670);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30863__auto____0;
cljs$core$async$mult_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30863__auto____1;
return cljs$core$async$mult_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___31755,cs,m,dchan,dctr,done))
})();
var state__30952__auto__ = (function (){var statearr_31754 = f__30951__auto__.call(null);
(statearr_31754[(6)] = c__30950__auto___31755);

return statearr_31754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___31755,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__31813 = arguments.length;
switch (G__31813) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,ch);
} else {
var m__29032__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,ch);
} else {
var m__29032__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m);
} else {
var m__29032__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,state_map);
} else {
var m__29032__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,mode);
} else {
var m__29032__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29526__auto__ = [];
var len__29519__auto___31825 = arguments.length;
var i__29520__auto___31826 = (0);
while(true){
if((i__29520__auto___31826 < len__29519__auto___31825)){
args__29526__auto__.push((arguments[i__29520__auto___31826]));

var G__31827 = (i__29520__auto___31826 + (1));
i__29520__auto___31826 = G__31827;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((3) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29527__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31819){
var map__31820 = p__31819;
var map__31820__$1 = ((((!((map__31820 == null)))?((((map__31820.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31820.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31820):map__31820);
var opts = map__31820__$1;
var statearr_31822_31828 = state;
(statearr_31822_31828[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__31820,map__31820__$1,opts){
return (function (val){
var statearr_31823_31829 = state;
(statearr_31823_31829[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__31820,map__31820__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_31824_31830 = state;
(statearr_31824_31830[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31815){
var G__31816 = cljs.core.first.call(null,seq31815);
var seq31815__$1 = cljs.core.next.call(null,seq31815);
var G__31817 = cljs.core.first.call(null,seq31815__$1);
var seq31815__$2 = cljs.core.next.call(null,seq31815__$1);
var G__31818 = cljs.core.first.call(null,seq31815__$2);
var seq31815__$3 = cljs.core.next.call(null,seq31815__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31816,G__31817,G__31818,seq31815__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31831 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31831 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta31832){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta31832 = meta31832;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31831.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31833,meta31832__$1){
var self__ = this;
var _31833__$1 = this;
return (new cljs.core.async.t_cljs$core$async31831(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta31832__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31831.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31833){
var self__ = this;
var _31833__$1 = this;
return self__.meta31832;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31831.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31831.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31831.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31831.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31831.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31831.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31831.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31831.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31831.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta31832","meta31832",92911968,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31831.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31831.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31831";

cljs.core.async.t_cljs$core$async31831.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async31831");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31831 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31831(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31832){
return (new cljs.core.async.t_cljs$core$async31831(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31832));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31831(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30950__auto___31995 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___31995,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___31995,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31935){
var state_val_31936 = (state_31935[(1)]);
if((state_val_31936 === (7))){
var inst_31850 = (state_31935[(2)]);
var state_31935__$1 = state_31935;
var statearr_31937_31996 = state_31935__$1;
(statearr_31937_31996[(2)] = inst_31850);

(statearr_31937_31996[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (20))){
var inst_31862 = (state_31935[(7)]);
var state_31935__$1 = state_31935;
var statearr_31938_31997 = state_31935__$1;
(statearr_31938_31997[(2)] = inst_31862);

(statearr_31938_31997[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (27))){
var state_31935__$1 = state_31935;
var statearr_31939_31998 = state_31935__$1;
(statearr_31939_31998[(2)] = null);

(statearr_31939_31998[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (1))){
var inst_31837 = (state_31935[(8)]);
var inst_31837__$1 = calc_state.call(null);
var inst_31839 = (inst_31837__$1 == null);
var inst_31840 = cljs.core.not.call(null,inst_31839);
var state_31935__$1 = (function (){var statearr_31940 = state_31935;
(statearr_31940[(8)] = inst_31837__$1);

return statearr_31940;
})();
if(inst_31840){
var statearr_31941_31999 = state_31935__$1;
(statearr_31941_31999[(1)] = (2));

} else {
var statearr_31942_32000 = state_31935__$1;
(statearr_31942_32000[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (24))){
var inst_31886 = (state_31935[(9)]);
var inst_31909 = (state_31935[(10)]);
var inst_31895 = (state_31935[(11)]);
var inst_31909__$1 = inst_31886.call(null,inst_31895);
var state_31935__$1 = (function (){var statearr_31943 = state_31935;
(statearr_31943[(10)] = inst_31909__$1);

return statearr_31943;
})();
if(cljs.core.truth_(inst_31909__$1)){
var statearr_31944_32001 = state_31935__$1;
(statearr_31944_32001[(1)] = (29));

} else {
var statearr_31945_32002 = state_31935__$1;
(statearr_31945_32002[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (4))){
var inst_31853 = (state_31935[(2)]);
var state_31935__$1 = state_31935;
if(cljs.core.truth_(inst_31853)){
var statearr_31946_32003 = state_31935__$1;
(statearr_31946_32003[(1)] = (8));

} else {
var statearr_31947_32004 = state_31935__$1;
(statearr_31947_32004[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (15))){
var inst_31880 = (state_31935[(2)]);
var state_31935__$1 = state_31935;
if(cljs.core.truth_(inst_31880)){
var statearr_31948_32005 = state_31935__$1;
(statearr_31948_32005[(1)] = (19));

} else {
var statearr_31949_32006 = state_31935__$1;
(statearr_31949_32006[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (21))){
var inst_31885 = (state_31935[(12)]);
var inst_31885__$1 = (state_31935[(2)]);
var inst_31886 = cljs.core.get.call(null,inst_31885__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31887 = cljs.core.get.call(null,inst_31885__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31888 = cljs.core.get.call(null,inst_31885__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31935__$1 = (function (){var statearr_31950 = state_31935;
(statearr_31950[(9)] = inst_31886);

(statearr_31950[(12)] = inst_31885__$1);

(statearr_31950[(13)] = inst_31887);

return statearr_31950;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31935__$1,(22),inst_31888);
} else {
if((state_val_31936 === (31))){
var inst_31917 = (state_31935[(2)]);
var state_31935__$1 = state_31935;
if(cljs.core.truth_(inst_31917)){
var statearr_31951_32007 = state_31935__$1;
(statearr_31951_32007[(1)] = (32));

} else {
var statearr_31952_32008 = state_31935__$1;
(statearr_31952_32008[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (32))){
var inst_31894 = (state_31935[(14)]);
var state_31935__$1 = state_31935;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31935__$1,(35),out,inst_31894);
} else {
if((state_val_31936 === (33))){
var inst_31885 = (state_31935[(12)]);
var inst_31862 = inst_31885;
var state_31935__$1 = (function (){var statearr_31953 = state_31935;
(statearr_31953[(7)] = inst_31862);

return statearr_31953;
})();
var statearr_31954_32009 = state_31935__$1;
(statearr_31954_32009[(2)] = null);

(statearr_31954_32009[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (13))){
var inst_31862 = (state_31935[(7)]);
var inst_31869 = inst_31862.cljs$lang$protocol_mask$partition0$;
var inst_31870 = (inst_31869 & (64));
var inst_31871 = inst_31862.cljs$core$ISeq$;
var inst_31872 = (cljs.core.PROTOCOL_SENTINEL === inst_31871);
var inst_31873 = (inst_31870) || (inst_31872);
var state_31935__$1 = state_31935;
if(cljs.core.truth_(inst_31873)){
var statearr_31955_32010 = state_31935__$1;
(statearr_31955_32010[(1)] = (16));

} else {
var statearr_31956_32011 = state_31935__$1;
(statearr_31956_32011[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (22))){
var inst_31894 = (state_31935[(14)]);
var inst_31895 = (state_31935[(11)]);
var inst_31893 = (state_31935[(2)]);
var inst_31894__$1 = cljs.core.nth.call(null,inst_31893,(0),null);
var inst_31895__$1 = cljs.core.nth.call(null,inst_31893,(1),null);
var inst_31896 = (inst_31894__$1 == null);
var inst_31897 = cljs.core._EQ_.call(null,inst_31895__$1,change);
var inst_31898 = (inst_31896) || (inst_31897);
var state_31935__$1 = (function (){var statearr_31957 = state_31935;
(statearr_31957[(14)] = inst_31894__$1);

(statearr_31957[(11)] = inst_31895__$1);

return statearr_31957;
})();
if(cljs.core.truth_(inst_31898)){
var statearr_31958_32012 = state_31935__$1;
(statearr_31958_32012[(1)] = (23));

} else {
var statearr_31959_32013 = state_31935__$1;
(statearr_31959_32013[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (36))){
var inst_31885 = (state_31935[(12)]);
var inst_31862 = inst_31885;
var state_31935__$1 = (function (){var statearr_31960 = state_31935;
(statearr_31960[(7)] = inst_31862);

return statearr_31960;
})();
var statearr_31961_32014 = state_31935__$1;
(statearr_31961_32014[(2)] = null);

(statearr_31961_32014[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (29))){
var inst_31909 = (state_31935[(10)]);
var state_31935__$1 = state_31935;
var statearr_31962_32015 = state_31935__$1;
(statearr_31962_32015[(2)] = inst_31909);

(statearr_31962_32015[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (6))){
var state_31935__$1 = state_31935;
var statearr_31963_32016 = state_31935__$1;
(statearr_31963_32016[(2)] = false);

(statearr_31963_32016[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (28))){
var inst_31905 = (state_31935[(2)]);
var inst_31906 = calc_state.call(null);
var inst_31862 = inst_31906;
var state_31935__$1 = (function (){var statearr_31964 = state_31935;
(statearr_31964[(7)] = inst_31862);

(statearr_31964[(15)] = inst_31905);

return statearr_31964;
})();
var statearr_31965_32017 = state_31935__$1;
(statearr_31965_32017[(2)] = null);

(statearr_31965_32017[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (25))){
var inst_31931 = (state_31935[(2)]);
var state_31935__$1 = state_31935;
var statearr_31966_32018 = state_31935__$1;
(statearr_31966_32018[(2)] = inst_31931);

(statearr_31966_32018[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (34))){
var inst_31929 = (state_31935[(2)]);
var state_31935__$1 = state_31935;
var statearr_31967_32019 = state_31935__$1;
(statearr_31967_32019[(2)] = inst_31929);

(statearr_31967_32019[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (17))){
var state_31935__$1 = state_31935;
var statearr_31968_32020 = state_31935__$1;
(statearr_31968_32020[(2)] = false);

(statearr_31968_32020[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (3))){
var state_31935__$1 = state_31935;
var statearr_31969_32021 = state_31935__$1;
(statearr_31969_32021[(2)] = false);

(statearr_31969_32021[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (12))){
var inst_31933 = (state_31935[(2)]);
var state_31935__$1 = state_31935;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31935__$1,inst_31933);
} else {
if((state_val_31936 === (2))){
var inst_31837 = (state_31935[(8)]);
var inst_31842 = inst_31837.cljs$lang$protocol_mask$partition0$;
var inst_31843 = (inst_31842 & (64));
var inst_31844 = inst_31837.cljs$core$ISeq$;
var inst_31845 = (cljs.core.PROTOCOL_SENTINEL === inst_31844);
var inst_31846 = (inst_31843) || (inst_31845);
var state_31935__$1 = state_31935;
if(cljs.core.truth_(inst_31846)){
var statearr_31970_32022 = state_31935__$1;
(statearr_31970_32022[(1)] = (5));

} else {
var statearr_31971_32023 = state_31935__$1;
(statearr_31971_32023[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (23))){
var inst_31894 = (state_31935[(14)]);
var inst_31900 = (inst_31894 == null);
var state_31935__$1 = state_31935;
if(cljs.core.truth_(inst_31900)){
var statearr_31972_32024 = state_31935__$1;
(statearr_31972_32024[(1)] = (26));

} else {
var statearr_31973_32025 = state_31935__$1;
(statearr_31973_32025[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (35))){
var inst_31920 = (state_31935[(2)]);
var state_31935__$1 = state_31935;
if(cljs.core.truth_(inst_31920)){
var statearr_31974_32026 = state_31935__$1;
(statearr_31974_32026[(1)] = (36));

} else {
var statearr_31975_32027 = state_31935__$1;
(statearr_31975_32027[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (19))){
var inst_31862 = (state_31935[(7)]);
var inst_31882 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31862);
var state_31935__$1 = state_31935;
var statearr_31976_32028 = state_31935__$1;
(statearr_31976_32028[(2)] = inst_31882);

(statearr_31976_32028[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (11))){
var inst_31862 = (state_31935[(7)]);
var inst_31866 = (inst_31862 == null);
var inst_31867 = cljs.core.not.call(null,inst_31866);
var state_31935__$1 = state_31935;
if(inst_31867){
var statearr_31977_32029 = state_31935__$1;
(statearr_31977_32029[(1)] = (13));

} else {
var statearr_31978_32030 = state_31935__$1;
(statearr_31978_32030[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (9))){
var inst_31837 = (state_31935[(8)]);
var state_31935__$1 = state_31935;
var statearr_31979_32031 = state_31935__$1;
(statearr_31979_32031[(2)] = inst_31837);

(statearr_31979_32031[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (5))){
var state_31935__$1 = state_31935;
var statearr_31980_32032 = state_31935__$1;
(statearr_31980_32032[(2)] = true);

(statearr_31980_32032[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (14))){
var state_31935__$1 = state_31935;
var statearr_31981_32033 = state_31935__$1;
(statearr_31981_32033[(2)] = false);

(statearr_31981_32033[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (26))){
var inst_31895 = (state_31935[(11)]);
var inst_31902 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31895);
var state_31935__$1 = state_31935;
var statearr_31982_32034 = state_31935__$1;
(statearr_31982_32034[(2)] = inst_31902);

(statearr_31982_32034[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (16))){
var state_31935__$1 = state_31935;
var statearr_31983_32035 = state_31935__$1;
(statearr_31983_32035[(2)] = true);

(statearr_31983_32035[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (38))){
var inst_31925 = (state_31935[(2)]);
var state_31935__$1 = state_31935;
var statearr_31984_32036 = state_31935__$1;
(statearr_31984_32036[(2)] = inst_31925);

(statearr_31984_32036[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (30))){
var inst_31886 = (state_31935[(9)]);
var inst_31887 = (state_31935[(13)]);
var inst_31895 = (state_31935[(11)]);
var inst_31912 = cljs.core.empty_QMARK_.call(null,inst_31886);
var inst_31913 = inst_31887.call(null,inst_31895);
var inst_31914 = cljs.core.not.call(null,inst_31913);
var inst_31915 = (inst_31912) && (inst_31914);
var state_31935__$1 = state_31935;
var statearr_31985_32037 = state_31935__$1;
(statearr_31985_32037[(2)] = inst_31915);

(statearr_31985_32037[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (10))){
var inst_31837 = (state_31935[(8)]);
var inst_31858 = (state_31935[(2)]);
var inst_31859 = cljs.core.get.call(null,inst_31858,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31860 = cljs.core.get.call(null,inst_31858,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31861 = cljs.core.get.call(null,inst_31858,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31862 = inst_31837;
var state_31935__$1 = (function (){var statearr_31986 = state_31935;
(statearr_31986[(7)] = inst_31862);

(statearr_31986[(16)] = inst_31859);

(statearr_31986[(17)] = inst_31860);

(statearr_31986[(18)] = inst_31861);

return statearr_31986;
})();
var statearr_31987_32038 = state_31935__$1;
(statearr_31987_32038[(2)] = null);

(statearr_31987_32038[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (18))){
var inst_31877 = (state_31935[(2)]);
var state_31935__$1 = state_31935;
var statearr_31988_32039 = state_31935__$1;
(statearr_31988_32039[(2)] = inst_31877);

(statearr_31988_32039[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (37))){
var state_31935__$1 = state_31935;
var statearr_31989_32040 = state_31935__$1;
(statearr_31989_32040[(2)] = null);

(statearr_31989_32040[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31936 === (8))){
var inst_31837 = (state_31935[(8)]);
var inst_31855 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31837);
var state_31935__$1 = state_31935;
var statearr_31990_32041 = state_31935__$1;
(statearr_31990_32041[(2)] = inst_31855);

(statearr_31990_32041[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___31995,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__30862__auto__,c__30950__auto___31995,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__30863__auto__ = null;
var cljs$core$async$mix_$_state_machine__30863__auto____0 = (function (){
var statearr_31991 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31991[(0)] = cljs$core$async$mix_$_state_machine__30863__auto__);

(statearr_31991[(1)] = (1));

return statearr_31991;
});
var cljs$core$async$mix_$_state_machine__30863__auto____1 = (function (state_31935){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_31935);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e31992){if((e31992 instanceof Object)){
var ex__30866__auto__ = e31992;
var statearr_31993_32042 = state_31935;
(statearr_31993_32042[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31935);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31992;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32043 = state_31935;
state_31935 = G__32043;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30863__auto__ = function(state_31935){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30863__auto____1.call(this,state_31935);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30863__auto____0;
cljs$core$async$mix_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30863__auto____1;
return cljs$core$async$mix_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___31995,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__30952__auto__ = (function (){var statearr_31994 = f__30951__auto__.call(null);
(statearr_31994[(6)] = c__30950__auto___31995);

return statearr_31994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___31995,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__29031__auto__ = (((p == null))?null:p);
var m__29032__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__29032__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__29031__auto__ = (((p == null))?null:p);
var m__29032__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,p,v,ch);
} else {
var m__29032__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32045 = arguments.length;
switch (G__32045) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__29031__auto__ = (((p == null))?null:p);
var m__29032__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,p);
} else {
var m__29032__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__29031__auto__ = (((p == null))?null:p);
var m__29032__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,p,v);
} else {
var m__29032__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32049 = arguments.length;
switch (G__32049) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28348__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28348__auto__,mults){
return (function (p1__32047_SHARP_){
if(cljs.core.truth_(p1__32047_SHARP_.call(null,topic))){
return p1__32047_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__32047_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28348__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32050 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32050 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32051){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32051 = meta32051;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32050.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32052,meta32051__$1){
var self__ = this;
var _32052__$1 = this;
return (new cljs.core.async.t_cljs$core$async32050(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32051__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32050.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32052){
var self__ = this;
var _32052__$1 = this;
return self__.meta32051;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32050.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32050.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32050.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32050.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32050.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32050.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32050.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32050.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32051","meta32051",1938333876,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32050.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32050.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32050";

cljs.core.async.t_cljs$core$async32050.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async32050");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32050 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32050(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32051){
return (new cljs.core.async.t_cljs$core$async32050(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32051));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32050(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30950__auto___32170 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___32170,mults,ensure_mult,p){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___32170,mults,ensure_mult,p){
return (function (state_32124){
var state_val_32125 = (state_32124[(1)]);
if((state_val_32125 === (7))){
var inst_32120 = (state_32124[(2)]);
var state_32124__$1 = state_32124;
var statearr_32126_32171 = state_32124__$1;
(statearr_32126_32171[(2)] = inst_32120);

(statearr_32126_32171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (20))){
var state_32124__$1 = state_32124;
var statearr_32127_32172 = state_32124__$1;
(statearr_32127_32172[(2)] = null);

(statearr_32127_32172[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (1))){
var state_32124__$1 = state_32124;
var statearr_32128_32173 = state_32124__$1;
(statearr_32128_32173[(2)] = null);

(statearr_32128_32173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (24))){
var inst_32103 = (state_32124[(7)]);
var inst_32112 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_32103);
var state_32124__$1 = state_32124;
var statearr_32129_32174 = state_32124__$1;
(statearr_32129_32174[(2)] = inst_32112);

(statearr_32129_32174[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (4))){
var inst_32055 = (state_32124[(8)]);
var inst_32055__$1 = (state_32124[(2)]);
var inst_32056 = (inst_32055__$1 == null);
var state_32124__$1 = (function (){var statearr_32130 = state_32124;
(statearr_32130[(8)] = inst_32055__$1);

return statearr_32130;
})();
if(cljs.core.truth_(inst_32056)){
var statearr_32131_32175 = state_32124__$1;
(statearr_32131_32175[(1)] = (5));

} else {
var statearr_32132_32176 = state_32124__$1;
(statearr_32132_32176[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (15))){
var inst_32097 = (state_32124[(2)]);
var state_32124__$1 = state_32124;
var statearr_32133_32177 = state_32124__$1;
(statearr_32133_32177[(2)] = inst_32097);

(statearr_32133_32177[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (21))){
var inst_32117 = (state_32124[(2)]);
var state_32124__$1 = (function (){var statearr_32134 = state_32124;
(statearr_32134[(9)] = inst_32117);

return statearr_32134;
})();
var statearr_32135_32178 = state_32124__$1;
(statearr_32135_32178[(2)] = null);

(statearr_32135_32178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (13))){
var inst_32079 = (state_32124[(10)]);
var inst_32081 = cljs.core.chunked_seq_QMARK_.call(null,inst_32079);
var state_32124__$1 = state_32124;
if(inst_32081){
var statearr_32136_32179 = state_32124__$1;
(statearr_32136_32179[(1)] = (16));

} else {
var statearr_32137_32180 = state_32124__$1;
(statearr_32137_32180[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (22))){
var inst_32109 = (state_32124[(2)]);
var state_32124__$1 = state_32124;
if(cljs.core.truth_(inst_32109)){
var statearr_32138_32181 = state_32124__$1;
(statearr_32138_32181[(1)] = (23));

} else {
var statearr_32139_32182 = state_32124__$1;
(statearr_32139_32182[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (6))){
var inst_32105 = (state_32124[(11)]);
var inst_32055 = (state_32124[(8)]);
var inst_32103 = (state_32124[(7)]);
var inst_32103__$1 = topic_fn.call(null,inst_32055);
var inst_32104 = cljs.core.deref.call(null,mults);
var inst_32105__$1 = cljs.core.get.call(null,inst_32104,inst_32103__$1);
var state_32124__$1 = (function (){var statearr_32140 = state_32124;
(statearr_32140[(11)] = inst_32105__$1);

(statearr_32140[(7)] = inst_32103__$1);

return statearr_32140;
})();
if(cljs.core.truth_(inst_32105__$1)){
var statearr_32141_32183 = state_32124__$1;
(statearr_32141_32183[(1)] = (19));

} else {
var statearr_32142_32184 = state_32124__$1;
(statearr_32142_32184[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (25))){
var inst_32114 = (state_32124[(2)]);
var state_32124__$1 = state_32124;
var statearr_32143_32185 = state_32124__$1;
(statearr_32143_32185[(2)] = inst_32114);

(statearr_32143_32185[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (17))){
var inst_32079 = (state_32124[(10)]);
var inst_32088 = cljs.core.first.call(null,inst_32079);
var inst_32089 = cljs.core.async.muxch_STAR_.call(null,inst_32088);
var inst_32090 = cljs.core.async.close_BANG_.call(null,inst_32089);
var inst_32091 = cljs.core.next.call(null,inst_32079);
var inst_32065 = inst_32091;
var inst_32066 = null;
var inst_32067 = (0);
var inst_32068 = (0);
var state_32124__$1 = (function (){var statearr_32144 = state_32124;
(statearr_32144[(12)] = inst_32065);

(statearr_32144[(13)] = inst_32068);

(statearr_32144[(14)] = inst_32067);

(statearr_32144[(15)] = inst_32090);

(statearr_32144[(16)] = inst_32066);

return statearr_32144;
})();
var statearr_32145_32186 = state_32124__$1;
(statearr_32145_32186[(2)] = null);

(statearr_32145_32186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (3))){
var inst_32122 = (state_32124[(2)]);
var state_32124__$1 = state_32124;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32124__$1,inst_32122);
} else {
if((state_val_32125 === (12))){
var inst_32099 = (state_32124[(2)]);
var state_32124__$1 = state_32124;
var statearr_32146_32187 = state_32124__$1;
(statearr_32146_32187[(2)] = inst_32099);

(statearr_32146_32187[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (2))){
var state_32124__$1 = state_32124;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32124__$1,(4),ch);
} else {
if((state_val_32125 === (23))){
var state_32124__$1 = state_32124;
var statearr_32147_32188 = state_32124__$1;
(statearr_32147_32188[(2)] = null);

(statearr_32147_32188[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (19))){
var inst_32105 = (state_32124[(11)]);
var inst_32055 = (state_32124[(8)]);
var inst_32107 = cljs.core.async.muxch_STAR_.call(null,inst_32105);
var state_32124__$1 = state_32124;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32124__$1,(22),inst_32107,inst_32055);
} else {
if((state_val_32125 === (11))){
var inst_32065 = (state_32124[(12)]);
var inst_32079 = (state_32124[(10)]);
var inst_32079__$1 = cljs.core.seq.call(null,inst_32065);
var state_32124__$1 = (function (){var statearr_32148 = state_32124;
(statearr_32148[(10)] = inst_32079__$1);

return statearr_32148;
})();
if(inst_32079__$1){
var statearr_32149_32189 = state_32124__$1;
(statearr_32149_32189[(1)] = (13));

} else {
var statearr_32150_32190 = state_32124__$1;
(statearr_32150_32190[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (9))){
var inst_32101 = (state_32124[(2)]);
var state_32124__$1 = state_32124;
var statearr_32151_32191 = state_32124__$1;
(statearr_32151_32191[(2)] = inst_32101);

(statearr_32151_32191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (5))){
var inst_32062 = cljs.core.deref.call(null,mults);
var inst_32063 = cljs.core.vals.call(null,inst_32062);
var inst_32064 = cljs.core.seq.call(null,inst_32063);
var inst_32065 = inst_32064;
var inst_32066 = null;
var inst_32067 = (0);
var inst_32068 = (0);
var state_32124__$1 = (function (){var statearr_32152 = state_32124;
(statearr_32152[(12)] = inst_32065);

(statearr_32152[(13)] = inst_32068);

(statearr_32152[(14)] = inst_32067);

(statearr_32152[(16)] = inst_32066);

return statearr_32152;
})();
var statearr_32153_32192 = state_32124__$1;
(statearr_32153_32192[(2)] = null);

(statearr_32153_32192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (14))){
var state_32124__$1 = state_32124;
var statearr_32157_32193 = state_32124__$1;
(statearr_32157_32193[(2)] = null);

(statearr_32157_32193[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (16))){
var inst_32079 = (state_32124[(10)]);
var inst_32083 = cljs.core.chunk_first.call(null,inst_32079);
var inst_32084 = cljs.core.chunk_rest.call(null,inst_32079);
var inst_32085 = cljs.core.count.call(null,inst_32083);
var inst_32065 = inst_32084;
var inst_32066 = inst_32083;
var inst_32067 = inst_32085;
var inst_32068 = (0);
var state_32124__$1 = (function (){var statearr_32158 = state_32124;
(statearr_32158[(12)] = inst_32065);

(statearr_32158[(13)] = inst_32068);

(statearr_32158[(14)] = inst_32067);

(statearr_32158[(16)] = inst_32066);

return statearr_32158;
})();
var statearr_32159_32194 = state_32124__$1;
(statearr_32159_32194[(2)] = null);

(statearr_32159_32194[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (10))){
var inst_32065 = (state_32124[(12)]);
var inst_32068 = (state_32124[(13)]);
var inst_32067 = (state_32124[(14)]);
var inst_32066 = (state_32124[(16)]);
var inst_32073 = cljs.core._nth.call(null,inst_32066,inst_32068);
var inst_32074 = cljs.core.async.muxch_STAR_.call(null,inst_32073);
var inst_32075 = cljs.core.async.close_BANG_.call(null,inst_32074);
var inst_32076 = (inst_32068 + (1));
var tmp32154 = inst_32065;
var tmp32155 = inst_32067;
var tmp32156 = inst_32066;
var inst_32065__$1 = tmp32154;
var inst_32066__$1 = tmp32156;
var inst_32067__$1 = tmp32155;
var inst_32068__$1 = inst_32076;
var state_32124__$1 = (function (){var statearr_32160 = state_32124;
(statearr_32160[(12)] = inst_32065__$1);

(statearr_32160[(17)] = inst_32075);

(statearr_32160[(13)] = inst_32068__$1);

(statearr_32160[(14)] = inst_32067__$1);

(statearr_32160[(16)] = inst_32066__$1);

return statearr_32160;
})();
var statearr_32161_32195 = state_32124__$1;
(statearr_32161_32195[(2)] = null);

(statearr_32161_32195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (18))){
var inst_32094 = (state_32124[(2)]);
var state_32124__$1 = state_32124;
var statearr_32162_32196 = state_32124__$1;
(statearr_32162_32196[(2)] = inst_32094);

(statearr_32162_32196[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32125 === (8))){
var inst_32068 = (state_32124[(13)]);
var inst_32067 = (state_32124[(14)]);
var inst_32070 = (inst_32068 < inst_32067);
var inst_32071 = inst_32070;
var state_32124__$1 = state_32124;
if(cljs.core.truth_(inst_32071)){
var statearr_32163_32197 = state_32124__$1;
(statearr_32163_32197[(1)] = (10));

} else {
var statearr_32164_32198 = state_32124__$1;
(statearr_32164_32198[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___32170,mults,ensure_mult,p))
;
return ((function (switch__30862__auto__,c__30950__auto___32170,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_32165 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32165[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_32165[(1)] = (1));

return statearr_32165;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_32124){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_32124);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e32166){if((e32166 instanceof Object)){
var ex__30866__auto__ = e32166;
var statearr_32167_32199 = state_32124;
(statearr_32167_32199[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32124);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32166;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32200 = state_32124;
state_32124 = G__32200;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_32124){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_32124);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___32170,mults,ensure_mult,p))
})();
var state__30952__auto__ = (function (){var statearr_32168 = f__30951__auto__.call(null);
(statearr_32168[(6)] = c__30950__auto___32170);

return statearr_32168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___32170,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32202 = arguments.length;
switch (G__32202) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32205 = arguments.length;
switch (G__32205) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32208 = arguments.length;
switch (G__32208) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__30950__auto___32275 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___32275,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___32275,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32247){
var state_val_32248 = (state_32247[(1)]);
if((state_val_32248 === (7))){
var state_32247__$1 = state_32247;
var statearr_32249_32276 = state_32247__$1;
(statearr_32249_32276[(2)] = null);

(statearr_32249_32276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (1))){
var state_32247__$1 = state_32247;
var statearr_32250_32277 = state_32247__$1;
(statearr_32250_32277[(2)] = null);

(statearr_32250_32277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (4))){
var inst_32211 = (state_32247[(7)]);
var inst_32213 = (inst_32211 < cnt);
var state_32247__$1 = state_32247;
if(cljs.core.truth_(inst_32213)){
var statearr_32251_32278 = state_32247__$1;
(statearr_32251_32278[(1)] = (6));

} else {
var statearr_32252_32279 = state_32247__$1;
(statearr_32252_32279[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (15))){
var inst_32243 = (state_32247[(2)]);
var state_32247__$1 = state_32247;
var statearr_32253_32280 = state_32247__$1;
(statearr_32253_32280[(2)] = inst_32243);

(statearr_32253_32280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (13))){
var inst_32236 = cljs.core.async.close_BANG_.call(null,out);
var state_32247__$1 = state_32247;
var statearr_32254_32281 = state_32247__$1;
(statearr_32254_32281[(2)] = inst_32236);

(statearr_32254_32281[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (6))){
var state_32247__$1 = state_32247;
var statearr_32255_32282 = state_32247__$1;
(statearr_32255_32282[(2)] = null);

(statearr_32255_32282[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (3))){
var inst_32245 = (state_32247[(2)]);
var state_32247__$1 = state_32247;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32247__$1,inst_32245);
} else {
if((state_val_32248 === (12))){
var inst_32233 = (state_32247[(8)]);
var inst_32233__$1 = (state_32247[(2)]);
var inst_32234 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32233__$1);
var state_32247__$1 = (function (){var statearr_32256 = state_32247;
(statearr_32256[(8)] = inst_32233__$1);

return statearr_32256;
})();
if(cljs.core.truth_(inst_32234)){
var statearr_32257_32283 = state_32247__$1;
(statearr_32257_32283[(1)] = (13));

} else {
var statearr_32258_32284 = state_32247__$1;
(statearr_32258_32284[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (2))){
var inst_32210 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32211 = (0);
var state_32247__$1 = (function (){var statearr_32259 = state_32247;
(statearr_32259[(9)] = inst_32210);

(statearr_32259[(7)] = inst_32211);

return statearr_32259;
})();
var statearr_32260_32285 = state_32247__$1;
(statearr_32260_32285[(2)] = null);

(statearr_32260_32285[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (11))){
var inst_32211 = (state_32247[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32247,(10),Object,null,(9));
var inst_32220 = chs__$1.call(null,inst_32211);
var inst_32221 = done.call(null,inst_32211);
var inst_32222 = cljs.core.async.take_BANG_.call(null,inst_32220,inst_32221);
var state_32247__$1 = state_32247;
var statearr_32261_32286 = state_32247__$1;
(statearr_32261_32286[(2)] = inst_32222);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32247__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (9))){
var inst_32211 = (state_32247[(7)]);
var inst_32224 = (state_32247[(2)]);
var inst_32225 = (inst_32211 + (1));
var inst_32211__$1 = inst_32225;
var state_32247__$1 = (function (){var statearr_32262 = state_32247;
(statearr_32262[(10)] = inst_32224);

(statearr_32262[(7)] = inst_32211__$1);

return statearr_32262;
})();
var statearr_32263_32287 = state_32247__$1;
(statearr_32263_32287[(2)] = null);

(statearr_32263_32287[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (5))){
var inst_32231 = (state_32247[(2)]);
var state_32247__$1 = (function (){var statearr_32264 = state_32247;
(statearr_32264[(11)] = inst_32231);

return statearr_32264;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32247__$1,(12),dchan);
} else {
if((state_val_32248 === (14))){
var inst_32233 = (state_32247[(8)]);
var inst_32238 = cljs.core.apply.call(null,f,inst_32233);
var state_32247__$1 = state_32247;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32247__$1,(16),out,inst_32238);
} else {
if((state_val_32248 === (16))){
var inst_32240 = (state_32247[(2)]);
var state_32247__$1 = (function (){var statearr_32265 = state_32247;
(statearr_32265[(12)] = inst_32240);

return statearr_32265;
})();
var statearr_32266_32288 = state_32247__$1;
(statearr_32266_32288[(2)] = null);

(statearr_32266_32288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (10))){
var inst_32215 = (state_32247[(2)]);
var inst_32216 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32247__$1 = (function (){var statearr_32267 = state_32247;
(statearr_32267[(13)] = inst_32215);

return statearr_32267;
})();
var statearr_32268_32289 = state_32247__$1;
(statearr_32268_32289[(2)] = inst_32216);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32247__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32248 === (8))){
var inst_32229 = (state_32247[(2)]);
var state_32247__$1 = state_32247;
var statearr_32269_32290 = state_32247__$1;
(statearr_32269_32290[(2)] = inst_32229);

(statearr_32269_32290[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___32275,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__30862__auto__,c__30950__auto___32275,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_32270 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32270[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_32270[(1)] = (1));

return statearr_32270;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_32247){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_32247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e32271){if((e32271 instanceof Object)){
var ex__30866__auto__ = e32271;
var statearr_32272_32291 = state_32247;
(statearr_32272_32291[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32247);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32271;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32292 = state_32247;
state_32247 = G__32292;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_32247){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_32247);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___32275,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__30952__auto__ = (function (){var statearr_32273 = f__30951__auto__.call(null);
(statearr_32273[(6)] = c__30950__auto___32275);

return statearr_32273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___32275,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32295 = arguments.length;
switch (G__32295) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30950__auto___32349 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___32349,out){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___32349,out){
return (function (state_32327){
var state_val_32328 = (state_32327[(1)]);
if((state_val_32328 === (7))){
var inst_32306 = (state_32327[(7)]);
var inst_32307 = (state_32327[(8)]);
var inst_32306__$1 = (state_32327[(2)]);
var inst_32307__$1 = cljs.core.nth.call(null,inst_32306__$1,(0),null);
var inst_32308 = cljs.core.nth.call(null,inst_32306__$1,(1),null);
var inst_32309 = (inst_32307__$1 == null);
var state_32327__$1 = (function (){var statearr_32329 = state_32327;
(statearr_32329[(9)] = inst_32308);

(statearr_32329[(7)] = inst_32306__$1);

(statearr_32329[(8)] = inst_32307__$1);

return statearr_32329;
})();
if(cljs.core.truth_(inst_32309)){
var statearr_32330_32350 = state_32327__$1;
(statearr_32330_32350[(1)] = (8));

} else {
var statearr_32331_32351 = state_32327__$1;
(statearr_32331_32351[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32328 === (1))){
var inst_32296 = cljs.core.vec.call(null,chs);
var inst_32297 = inst_32296;
var state_32327__$1 = (function (){var statearr_32332 = state_32327;
(statearr_32332[(10)] = inst_32297);

return statearr_32332;
})();
var statearr_32333_32352 = state_32327__$1;
(statearr_32333_32352[(2)] = null);

(statearr_32333_32352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32328 === (4))){
var inst_32297 = (state_32327[(10)]);
var state_32327__$1 = state_32327;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32327__$1,(7),inst_32297);
} else {
if((state_val_32328 === (6))){
var inst_32323 = (state_32327[(2)]);
var state_32327__$1 = state_32327;
var statearr_32334_32353 = state_32327__$1;
(statearr_32334_32353[(2)] = inst_32323);

(statearr_32334_32353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32328 === (3))){
var inst_32325 = (state_32327[(2)]);
var state_32327__$1 = state_32327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32327__$1,inst_32325);
} else {
if((state_val_32328 === (2))){
var inst_32297 = (state_32327[(10)]);
var inst_32299 = cljs.core.count.call(null,inst_32297);
var inst_32300 = (inst_32299 > (0));
var state_32327__$1 = state_32327;
if(cljs.core.truth_(inst_32300)){
var statearr_32336_32354 = state_32327__$1;
(statearr_32336_32354[(1)] = (4));

} else {
var statearr_32337_32355 = state_32327__$1;
(statearr_32337_32355[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32328 === (11))){
var inst_32297 = (state_32327[(10)]);
var inst_32316 = (state_32327[(2)]);
var tmp32335 = inst_32297;
var inst_32297__$1 = tmp32335;
var state_32327__$1 = (function (){var statearr_32338 = state_32327;
(statearr_32338[(10)] = inst_32297__$1);

(statearr_32338[(11)] = inst_32316);

return statearr_32338;
})();
var statearr_32339_32356 = state_32327__$1;
(statearr_32339_32356[(2)] = null);

(statearr_32339_32356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32328 === (9))){
var inst_32307 = (state_32327[(8)]);
var state_32327__$1 = state_32327;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32327__$1,(11),out,inst_32307);
} else {
if((state_val_32328 === (5))){
var inst_32321 = cljs.core.async.close_BANG_.call(null,out);
var state_32327__$1 = state_32327;
var statearr_32340_32357 = state_32327__$1;
(statearr_32340_32357[(2)] = inst_32321);

(statearr_32340_32357[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32328 === (10))){
var inst_32319 = (state_32327[(2)]);
var state_32327__$1 = state_32327;
var statearr_32341_32358 = state_32327__$1;
(statearr_32341_32358[(2)] = inst_32319);

(statearr_32341_32358[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32328 === (8))){
var inst_32297 = (state_32327[(10)]);
var inst_32308 = (state_32327[(9)]);
var inst_32306 = (state_32327[(7)]);
var inst_32307 = (state_32327[(8)]);
var inst_32311 = (function (){var cs = inst_32297;
var vec__32302 = inst_32306;
var v = inst_32307;
var c = inst_32308;
return ((function (cs,vec__32302,v,c,inst_32297,inst_32308,inst_32306,inst_32307,state_val_32328,c__30950__auto___32349,out){
return (function (p1__32293_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__32293_SHARP_);
});
;})(cs,vec__32302,v,c,inst_32297,inst_32308,inst_32306,inst_32307,state_val_32328,c__30950__auto___32349,out))
})();
var inst_32312 = cljs.core.filterv.call(null,inst_32311,inst_32297);
var inst_32297__$1 = inst_32312;
var state_32327__$1 = (function (){var statearr_32342 = state_32327;
(statearr_32342[(10)] = inst_32297__$1);

return statearr_32342;
})();
var statearr_32343_32359 = state_32327__$1;
(statearr_32343_32359[(2)] = null);

(statearr_32343_32359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___32349,out))
;
return ((function (switch__30862__auto__,c__30950__auto___32349,out){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_32344 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32344[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_32344[(1)] = (1));

return statearr_32344;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_32327){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_32327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e32345){if((e32345 instanceof Object)){
var ex__30866__auto__ = e32345;
var statearr_32346_32360 = state_32327;
(statearr_32346_32360[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32327);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32345;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32361 = state_32327;
state_32327 = G__32361;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_32327){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_32327);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___32349,out))
})();
var state__30952__auto__ = (function (){var statearr_32347 = f__30951__auto__.call(null);
(statearr_32347[(6)] = c__30950__auto___32349);

return statearr_32347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___32349,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32363 = arguments.length;
switch (G__32363) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30950__auto___32408 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___32408,out){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___32408,out){
return (function (state_32387){
var state_val_32388 = (state_32387[(1)]);
if((state_val_32388 === (7))){
var inst_32369 = (state_32387[(7)]);
var inst_32369__$1 = (state_32387[(2)]);
var inst_32370 = (inst_32369__$1 == null);
var inst_32371 = cljs.core.not.call(null,inst_32370);
var state_32387__$1 = (function (){var statearr_32389 = state_32387;
(statearr_32389[(7)] = inst_32369__$1);

return statearr_32389;
})();
if(inst_32371){
var statearr_32390_32409 = state_32387__$1;
(statearr_32390_32409[(1)] = (8));

} else {
var statearr_32391_32410 = state_32387__$1;
(statearr_32391_32410[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32388 === (1))){
var inst_32364 = (0);
var state_32387__$1 = (function (){var statearr_32392 = state_32387;
(statearr_32392[(8)] = inst_32364);

return statearr_32392;
})();
var statearr_32393_32411 = state_32387__$1;
(statearr_32393_32411[(2)] = null);

(statearr_32393_32411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32388 === (4))){
var state_32387__$1 = state_32387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32387__$1,(7),ch);
} else {
if((state_val_32388 === (6))){
var inst_32382 = (state_32387[(2)]);
var state_32387__$1 = state_32387;
var statearr_32394_32412 = state_32387__$1;
(statearr_32394_32412[(2)] = inst_32382);

(statearr_32394_32412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32388 === (3))){
var inst_32384 = (state_32387[(2)]);
var inst_32385 = cljs.core.async.close_BANG_.call(null,out);
var state_32387__$1 = (function (){var statearr_32395 = state_32387;
(statearr_32395[(9)] = inst_32384);

return statearr_32395;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32387__$1,inst_32385);
} else {
if((state_val_32388 === (2))){
var inst_32364 = (state_32387[(8)]);
var inst_32366 = (inst_32364 < n);
var state_32387__$1 = state_32387;
if(cljs.core.truth_(inst_32366)){
var statearr_32396_32413 = state_32387__$1;
(statearr_32396_32413[(1)] = (4));

} else {
var statearr_32397_32414 = state_32387__$1;
(statearr_32397_32414[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32388 === (11))){
var inst_32364 = (state_32387[(8)]);
var inst_32374 = (state_32387[(2)]);
var inst_32375 = (inst_32364 + (1));
var inst_32364__$1 = inst_32375;
var state_32387__$1 = (function (){var statearr_32398 = state_32387;
(statearr_32398[(10)] = inst_32374);

(statearr_32398[(8)] = inst_32364__$1);

return statearr_32398;
})();
var statearr_32399_32415 = state_32387__$1;
(statearr_32399_32415[(2)] = null);

(statearr_32399_32415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32388 === (9))){
var state_32387__$1 = state_32387;
var statearr_32400_32416 = state_32387__$1;
(statearr_32400_32416[(2)] = null);

(statearr_32400_32416[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32388 === (5))){
var state_32387__$1 = state_32387;
var statearr_32401_32417 = state_32387__$1;
(statearr_32401_32417[(2)] = null);

(statearr_32401_32417[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32388 === (10))){
var inst_32379 = (state_32387[(2)]);
var state_32387__$1 = state_32387;
var statearr_32402_32418 = state_32387__$1;
(statearr_32402_32418[(2)] = inst_32379);

(statearr_32402_32418[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32388 === (8))){
var inst_32369 = (state_32387[(7)]);
var state_32387__$1 = state_32387;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32387__$1,(11),out,inst_32369);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___32408,out))
;
return ((function (switch__30862__auto__,c__30950__auto___32408,out){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_32403 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32403[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_32403[(1)] = (1));

return statearr_32403;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_32387){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_32387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e32404){if((e32404 instanceof Object)){
var ex__30866__auto__ = e32404;
var statearr_32405_32419 = state_32387;
(statearr_32405_32419[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32387);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32404;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32420 = state_32387;
state_32387 = G__32420;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_32387){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_32387);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___32408,out))
})();
var state__30952__auto__ = (function (){var statearr_32406 = f__30951__auto__.call(null);
(statearr_32406[(6)] = c__30950__auto___32408);

return statearr_32406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___32408,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32422 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32422 = (function (f,ch,meta32423){
this.f = f;
this.ch = ch;
this.meta32423 = meta32423;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32422.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32424,meta32423__$1){
var self__ = this;
var _32424__$1 = this;
return (new cljs.core.async.t_cljs$core$async32422(self__.f,self__.ch,meta32423__$1));
});

cljs.core.async.t_cljs$core$async32422.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32424){
var self__ = this;
var _32424__$1 = this;
return self__.meta32423;
});

cljs.core.async.t_cljs$core$async32422.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32422.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32422.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32422.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32422.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async32425 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32425 = (function (f,ch,meta32423,_,fn1,meta32426){
this.f = f;
this.ch = ch;
this.meta32423 = meta32423;
this._ = _;
this.fn1 = fn1;
this.meta32426 = meta32426;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32425.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32427,meta32426__$1){
var self__ = this;
var _32427__$1 = this;
return (new cljs.core.async.t_cljs$core$async32425(self__.f,self__.ch,self__.meta32423,self__._,self__.fn1,meta32426__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async32425.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32427){
var self__ = this;
var _32427__$1 = this;
return self__.meta32426;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32425.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32425.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32425.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32425.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32421_SHARP_){
return f1.call(null,(((p1__32421_SHARP_ == null))?null:self__.f.call(null,p1__32421_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async32425.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32423","meta32423",-1389116324,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32422","cljs.core.async/t_cljs$core$async32422",-102761274,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32426","meta32426",2099204659,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32425.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32425.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32425";

cljs.core.async.t_cljs$core$async32425.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async32425");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async32425 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32425(f__$1,ch__$1,meta32423__$1,___$2,fn1__$1,meta32426){
return (new cljs.core.async.t_cljs$core$async32425(f__$1,ch__$1,meta32423__$1,___$2,fn1__$1,meta32426));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async32425(self__.f,self__.ch,self__.meta32423,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28336__auto__ = ret;
if(cljs.core.truth_(and__28336__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28336__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32422.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32422.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32422.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32423","meta32423",-1389116324,null)], null);
});

cljs.core.async.t_cljs$core$async32422.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32422.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32422";

cljs.core.async.t_cljs$core$async32422.cljs$lang$ctorPrWriter = (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async32422");
});

cljs.core.async.__GT_t_cljs$core$async32422 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32422(f__$1,ch__$1,meta32423){
return (new cljs.core.async.t_cljs$core$async32422(f__$1,ch__$1,meta32423));
});

}

return (new cljs.core.async.t_cljs$core$async32422(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32428 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32428 = (function (f,ch,meta32429){
this.f = f;
this.ch = ch;
this.meta32429 = meta32429;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32428.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32430,meta32429__$1){
var self__ = this;
var _32430__$1 = this;
return (new cljs.core.async.t_cljs$core$async32428(self__.f,self__.ch,meta32429__$1));
});

cljs.core.async.t_cljs$core$async32428.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32430){
var self__ = this;
var _32430__$1 = this;
return self__.meta32429;
});

cljs.core.async.t_cljs$core$async32428.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32428.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32428.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32428.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32428.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32428.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async32428.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32429","meta32429",-404233766,null)], null);
});

cljs.core.async.t_cljs$core$async32428.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32428.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32428";

cljs.core.async.t_cljs$core$async32428.cljs$lang$ctorPrWriter = (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async32428");
});

cljs.core.async.__GT_t_cljs$core$async32428 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32428(f__$1,ch__$1,meta32429){
return (new cljs.core.async.t_cljs$core$async32428(f__$1,ch__$1,meta32429));
});

}

return (new cljs.core.async.t_cljs$core$async32428(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async32431 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32431 = (function (p,ch,meta32432){
this.p = p;
this.ch = ch;
this.meta32432 = meta32432;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32431.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32433,meta32432__$1){
var self__ = this;
var _32433__$1 = this;
return (new cljs.core.async.t_cljs$core$async32431(self__.p,self__.ch,meta32432__$1));
});

cljs.core.async.t_cljs$core$async32431.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32433){
var self__ = this;
var _32433__$1 = this;
return self__.meta32432;
});

cljs.core.async.t_cljs$core$async32431.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32431.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32431.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32431.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32431.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32431.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32431.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async32431.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32432","meta32432",74172676,null)], null);
});

cljs.core.async.t_cljs$core$async32431.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32431.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32431";

cljs.core.async.t_cljs$core$async32431.cljs$lang$ctorPrWriter = (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async32431");
});

cljs.core.async.__GT_t_cljs$core$async32431 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32431(p__$1,ch__$1,meta32432){
return (new cljs.core.async.t_cljs$core$async32431(p__$1,ch__$1,meta32432));
});

}

return (new cljs.core.async.t_cljs$core$async32431(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32435 = arguments.length;
switch (G__32435) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30950__auto___32475 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___32475,out){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___32475,out){
return (function (state_32456){
var state_val_32457 = (state_32456[(1)]);
if((state_val_32457 === (7))){
var inst_32452 = (state_32456[(2)]);
var state_32456__$1 = state_32456;
var statearr_32458_32476 = state_32456__$1;
(statearr_32458_32476[(2)] = inst_32452);

(statearr_32458_32476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (1))){
var state_32456__$1 = state_32456;
var statearr_32459_32477 = state_32456__$1;
(statearr_32459_32477[(2)] = null);

(statearr_32459_32477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (4))){
var inst_32438 = (state_32456[(7)]);
var inst_32438__$1 = (state_32456[(2)]);
var inst_32439 = (inst_32438__$1 == null);
var state_32456__$1 = (function (){var statearr_32460 = state_32456;
(statearr_32460[(7)] = inst_32438__$1);

return statearr_32460;
})();
if(cljs.core.truth_(inst_32439)){
var statearr_32461_32478 = state_32456__$1;
(statearr_32461_32478[(1)] = (5));

} else {
var statearr_32462_32479 = state_32456__$1;
(statearr_32462_32479[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (6))){
var inst_32438 = (state_32456[(7)]);
var inst_32443 = p.call(null,inst_32438);
var state_32456__$1 = state_32456;
if(cljs.core.truth_(inst_32443)){
var statearr_32463_32480 = state_32456__$1;
(statearr_32463_32480[(1)] = (8));

} else {
var statearr_32464_32481 = state_32456__$1;
(statearr_32464_32481[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (3))){
var inst_32454 = (state_32456[(2)]);
var state_32456__$1 = state_32456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32456__$1,inst_32454);
} else {
if((state_val_32457 === (2))){
var state_32456__$1 = state_32456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32456__$1,(4),ch);
} else {
if((state_val_32457 === (11))){
var inst_32446 = (state_32456[(2)]);
var state_32456__$1 = state_32456;
var statearr_32465_32482 = state_32456__$1;
(statearr_32465_32482[(2)] = inst_32446);

(statearr_32465_32482[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (9))){
var state_32456__$1 = state_32456;
var statearr_32466_32483 = state_32456__$1;
(statearr_32466_32483[(2)] = null);

(statearr_32466_32483[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (5))){
var inst_32441 = cljs.core.async.close_BANG_.call(null,out);
var state_32456__$1 = state_32456;
var statearr_32467_32484 = state_32456__$1;
(statearr_32467_32484[(2)] = inst_32441);

(statearr_32467_32484[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (10))){
var inst_32449 = (state_32456[(2)]);
var state_32456__$1 = (function (){var statearr_32468 = state_32456;
(statearr_32468[(8)] = inst_32449);

return statearr_32468;
})();
var statearr_32469_32485 = state_32456__$1;
(statearr_32469_32485[(2)] = null);

(statearr_32469_32485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32457 === (8))){
var inst_32438 = (state_32456[(7)]);
var state_32456__$1 = state_32456;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32456__$1,(11),out,inst_32438);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___32475,out))
;
return ((function (switch__30862__auto__,c__30950__auto___32475,out){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_32470 = [null,null,null,null,null,null,null,null,null];
(statearr_32470[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_32470[(1)] = (1));

return statearr_32470;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_32456){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_32456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e32471){if((e32471 instanceof Object)){
var ex__30866__auto__ = e32471;
var statearr_32472_32486 = state_32456;
(statearr_32472_32486[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32456);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32471;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32487 = state_32456;
state_32456 = G__32487;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_32456){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_32456);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___32475,out))
})();
var state__30952__auto__ = (function (){var statearr_32473 = f__30951__auto__.call(null);
(statearr_32473[(6)] = c__30950__auto___32475);

return statearr_32473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___32475,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32489 = arguments.length;
switch (G__32489) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__){
return (function (state_32552){
var state_val_32553 = (state_32552[(1)]);
if((state_val_32553 === (7))){
var inst_32548 = (state_32552[(2)]);
var state_32552__$1 = state_32552;
var statearr_32554_32592 = state_32552__$1;
(statearr_32554_32592[(2)] = inst_32548);

(statearr_32554_32592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (20))){
var inst_32518 = (state_32552[(7)]);
var inst_32529 = (state_32552[(2)]);
var inst_32530 = cljs.core.next.call(null,inst_32518);
var inst_32504 = inst_32530;
var inst_32505 = null;
var inst_32506 = (0);
var inst_32507 = (0);
var state_32552__$1 = (function (){var statearr_32555 = state_32552;
(statearr_32555[(8)] = inst_32504);

(statearr_32555[(9)] = inst_32506);

(statearr_32555[(10)] = inst_32507);

(statearr_32555[(11)] = inst_32505);

(statearr_32555[(12)] = inst_32529);

return statearr_32555;
})();
var statearr_32556_32593 = state_32552__$1;
(statearr_32556_32593[(2)] = null);

(statearr_32556_32593[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (1))){
var state_32552__$1 = state_32552;
var statearr_32557_32594 = state_32552__$1;
(statearr_32557_32594[(2)] = null);

(statearr_32557_32594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (4))){
var inst_32493 = (state_32552[(13)]);
var inst_32493__$1 = (state_32552[(2)]);
var inst_32494 = (inst_32493__$1 == null);
var state_32552__$1 = (function (){var statearr_32558 = state_32552;
(statearr_32558[(13)] = inst_32493__$1);

return statearr_32558;
})();
if(cljs.core.truth_(inst_32494)){
var statearr_32559_32595 = state_32552__$1;
(statearr_32559_32595[(1)] = (5));

} else {
var statearr_32560_32596 = state_32552__$1;
(statearr_32560_32596[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (15))){
var state_32552__$1 = state_32552;
var statearr_32564_32597 = state_32552__$1;
(statearr_32564_32597[(2)] = null);

(statearr_32564_32597[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (21))){
var state_32552__$1 = state_32552;
var statearr_32565_32598 = state_32552__$1;
(statearr_32565_32598[(2)] = null);

(statearr_32565_32598[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (13))){
var inst_32504 = (state_32552[(8)]);
var inst_32506 = (state_32552[(9)]);
var inst_32507 = (state_32552[(10)]);
var inst_32505 = (state_32552[(11)]);
var inst_32514 = (state_32552[(2)]);
var inst_32515 = (inst_32507 + (1));
var tmp32561 = inst_32504;
var tmp32562 = inst_32506;
var tmp32563 = inst_32505;
var inst_32504__$1 = tmp32561;
var inst_32505__$1 = tmp32563;
var inst_32506__$1 = tmp32562;
var inst_32507__$1 = inst_32515;
var state_32552__$1 = (function (){var statearr_32566 = state_32552;
(statearr_32566[(8)] = inst_32504__$1);

(statearr_32566[(14)] = inst_32514);

(statearr_32566[(9)] = inst_32506__$1);

(statearr_32566[(10)] = inst_32507__$1);

(statearr_32566[(11)] = inst_32505__$1);

return statearr_32566;
})();
var statearr_32567_32599 = state_32552__$1;
(statearr_32567_32599[(2)] = null);

(statearr_32567_32599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (22))){
var state_32552__$1 = state_32552;
var statearr_32568_32600 = state_32552__$1;
(statearr_32568_32600[(2)] = null);

(statearr_32568_32600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (6))){
var inst_32493 = (state_32552[(13)]);
var inst_32502 = f.call(null,inst_32493);
var inst_32503 = cljs.core.seq.call(null,inst_32502);
var inst_32504 = inst_32503;
var inst_32505 = null;
var inst_32506 = (0);
var inst_32507 = (0);
var state_32552__$1 = (function (){var statearr_32569 = state_32552;
(statearr_32569[(8)] = inst_32504);

(statearr_32569[(9)] = inst_32506);

(statearr_32569[(10)] = inst_32507);

(statearr_32569[(11)] = inst_32505);

return statearr_32569;
})();
var statearr_32570_32601 = state_32552__$1;
(statearr_32570_32601[(2)] = null);

(statearr_32570_32601[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (17))){
var inst_32518 = (state_32552[(7)]);
var inst_32522 = cljs.core.chunk_first.call(null,inst_32518);
var inst_32523 = cljs.core.chunk_rest.call(null,inst_32518);
var inst_32524 = cljs.core.count.call(null,inst_32522);
var inst_32504 = inst_32523;
var inst_32505 = inst_32522;
var inst_32506 = inst_32524;
var inst_32507 = (0);
var state_32552__$1 = (function (){var statearr_32571 = state_32552;
(statearr_32571[(8)] = inst_32504);

(statearr_32571[(9)] = inst_32506);

(statearr_32571[(10)] = inst_32507);

(statearr_32571[(11)] = inst_32505);

return statearr_32571;
})();
var statearr_32572_32602 = state_32552__$1;
(statearr_32572_32602[(2)] = null);

(statearr_32572_32602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (3))){
var inst_32550 = (state_32552[(2)]);
var state_32552__$1 = state_32552;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32552__$1,inst_32550);
} else {
if((state_val_32553 === (12))){
var inst_32538 = (state_32552[(2)]);
var state_32552__$1 = state_32552;
var statearr_32573_32603 = state_32552__$1;
(statearr_32573_32603[(2)] = inst_32538);

(statearr_32573_32603[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (2))){
var state_32552__$1 = state_32552;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32552__$1,(4),in$);
} else {
if((state_val_32553 === (23))){
var inst_32546 = (state_32552[(2)]);
var state_32552__$1 = state_32552;
var statearr_32574_32604 = state_32552__$1;
(statearr_32574_32604[(2)] = inst_32546);

(statearr_32574_32604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (19))){
var inst_32533 = (state_32552[(2)]);
var state_32552__$1 = state_32552;
var statearr_32575_32605 = state_32552__$1;
(statearr_32575_32605[(2)] = inst_32533);

(statearr_32575_32605[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (11))){
var inst_32518 = (state_32552[(7)]);
var inst_32504 = (state_32552[(8)]);
var inst_32518__$1 = cljs.core.seq.call(null,inst_32504);
var state_32552__$1 = (function (){var statearr_32576 = state_32552;
(statearr_32576[(7)] = inst_32518__$1);

return statearr_32576;
})();
if(inst_32518__$1){
var statearr_32577_32606 = state_32552__$1;
(statearr_32577_32606[(1)] = (14));

} else {
var statearr_32578_32607 = state_32552__$1;
(statearr_32578_32607[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (9))){
var inst_32540 = (state_32552[(2)]);
var inst_32541 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32552__$1 = (function (){var statearr_32579 = state_32552;
(statearr_32579[(15)] = inst_32540);

return statearr_32579;
})();
if(cljs.core.truth_(inst_32541)){
var statearr_32580_32608 = state_32552__$1;
(statearr_32580_32608[(1)] = (21));

} else {
var statearr_32581_32609 = state_32552__$1;
(statearr_32581_32609[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (5))){
var inst_32496 = cljs.core.async.close_BANG_.call(null,out);
var state_32552__$1 = state_32552;
var statearr_32582_32610 = state_32552__$1;
(statearr_32582_32610[(2)] = inst_32496);

(statearr_32582_32610[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (14))){
var inst_32518 = (state_32552[(7)]);
var inst_32520 = cljs.core.chunked_seq_QMARK_.call(null,inst_32518);
var state_32552__$1 = state_32552;
if(inst_32520){
var statearr_32583_32611 = state_32552__$1;
(statearr_32583_32611[(1)] = (17));

} else {
var statearr_32584_32612 = state_32552__$1;
(statearr_32584_32612[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (16))){
var inst_32536 = (state_32552[(2)]);
var state_32552__$1 = state_32552;
var statearr_32585_32613 = state_32552__$1;
(statearr_32585_32613[(2)] = inst_32536);

(statearr_32585_32613[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (10))){
var inst_32507 = (state_32552[(10)]);
var inst_32505 = (state_32552[(11)]);
var inst_32512 = cljs.core._nth.call(null,inst_32505,inst_32507);
var state_32552__$1 = state_32552;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32552__$1,(13),out,inst_32512);
} else {
if((state_val_32553 === (18))){
var inst_32518 = (state_32552[(7)]);
var inst_32527 = cljs.core.first.call(null,inst_32518);
var state_32552__$1 = state_32552;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32552__$1,(20),out,inst_32527);
} else {
if((state_val_32553 === (8))){
var inst_32506 = (state_32552[(9)]);
var inst_32507 = (state_32552[(10)]);
var inst_32509 = (inst_32507 < inst_32506);
var inst_32510 = inst_32509;
var state_32552__$1 = state_32552;
if(cljs.core.truth_(inst_32510)){
var statearr_32586_32614 = state_32552__$1;
(statearr_32586_32614[(1)] = (10));

} else {
var statearr_32587_32615 = state_32552__$1;
(statearr_32587_32615[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto__))
;
return ((function (switch__30862__auto__,c__30950__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30863__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30863__auto____0 = (function (){
var statearr_32588 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32588[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30863__auto__);

(statearr_32588[(1)] = (1));

return statearr_32588;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30863__auto____1 = (function (state_32552){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_32552);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e32589){if((e32589 instanceof Object)){
var ex__30866__auto__ = e32589;
var statearr_32590_32616 = state_32552;
(statearr_32590_32616[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32552);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32589;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32617 = state_32552;
state_32552 = G__32617;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30863__auto__ = function(state_32552){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30863__auto____1.call(this,state_32552);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30863__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30863__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__))
})();
var state__30952__auto__ = (function (){var statearr_32591 = f__30951__auto__.call(null);
(statearr_32591[(6)] = c__30950__auto__);

return statearr_32591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__))
);

return c__30950__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32619 = arguments.length;
switch (G__32619) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32622 = arguments.length;
switch (G__32622) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32625 = arguments.length;
switch (G__32625) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30950__auto___32672 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___32672,out){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___32672,out){
return (function (state_32649){
var state_val_32650 = (state_32649[(1)]);
if((state_val_32650 === (7))){
var inst_32644 = (state_32649[(2)]);
var state_32649__$1 = state_32649;
var statearr_32651_32673 = state_32649__$1;
(statearr_32651_32673[(2)] = inst_32644);

(statearr_32651_32673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32650 === (1))){
var inst_32626 = null;
var state_32649__$1 = (function (){var statearr_32652 = state_32649;
(statearr_32652[(7)] = inst_32626);

return statearr_32652;
})();
var statearr_32653_32674 = state_32649__$1;
(statearr_32653_32674[(2)] = null);

(statearr_32653_32674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32650 === (4))){
var inst_32629 = (state_32649[(8)]);
var inst_32629__$1 = (state_32649[(2)]);
var inst_32630 = (inst_32629__$1 == null);
var inst_32631 = cljs.core.not.call(null,inst_32630);
var state_32649__$1 = (function (){var statearr_32654 = state_32649;
(statearr_32654[(8)] = inst_32629__$1);

return statearr_32654;
})();
if(inst_32631){
var statearr_32655_32675 = state_32649__$1;
(statearr_32655_32675[(1)] = (5));

} else {
var statearr_32656_32676 = state_32649__$1;
(statearr_32656_32676[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32650 === (6))){
var state_32649__$1 = state_32649;
var statearr_32657_32677 = state_32649__$1;
(statearr_32657_32677[(2)] = null);

(statearr_32657_32677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32650 === (3))){
var inst_32646 = (state_32649[(2)]);
var inst_32647 = cljs.core.async.close_BANG_.call(null,out);
var state_32649__$1 = (function (){var statearr_32658 = state_32649;
(statearr_32658[(9)] = inst_32646);

return statearr_32658;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32649__$1,inst_32647);
} else {
if((state_val_32650 === (2))){
var state_32649__$1 = state_32649;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32649__$1,(4),ch);
} else {
if((state_val_32650 === (11))){
var inst_32629 = (state_32649[(8)]);
var inst_32638 = (state_32649[(2)]);
var inst_32626 = inst_32629;
var state_32649__$1 = (function (){var statearr_32659 = state_32649;
(statearr_32659[(7)] = inst_32626);

(statearr_32659[(10)] = inst_32638);

return statearr_32659;
})();
var statearr_32660_32678 = state_32649__$1;
(statearr_32660_32678[(2)] = null);

(statearr_32660_32678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32650 === (9))){
var inst_32629 = (state_32649[(8)]);
var state_32649__$1 = state_32649;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32649__$1,(11),out,inst_32629);
} else {
if((state_val_32650 === (5))){
var inst_32626 = (state_32649[(7)]);
var inst_32629 = (state_32649[(8)]);
var inst_32633 = cljs.core._EQ_.call(null,inst_32629,inst_32626);
var state_32649__$1 = state_32649;
if(inst_32633){
var statearr_32662_32679 = state_32649__$1;
(statearr_32662_32679[(1)] = (8));

} else {
var statearr_32663_32680 = state_32649__$1;
(statearr_32663_32680[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32650 === (10))){
var inst_32641 = (state_32649[(2)]);
var state_32649__$1 = state_32649;
var statearr_32664_32681 = state_32649__$1;
(statearr_32664_32681[(2)] = inst_32641);

(statearr_32664_32681[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32650 === (8))){
var inst_32626 = (state_32649[(7)]);
var tmp32661 = inst_32626;
var inst_32626__$1 = tmp32661;
var state_32649__$1 = (function (){var statearr_32665 = state_32649;
(statearr_32665[(7)] = inst_32626__$1);

return statearr_32665;
})();
var statearr_32666_32682 = state_32649__$1;
(statearr_32666_32682[(2)] = null);

(statearr_32666_32682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___32672,out))
;
return ((function (switch__30862__auto__,c__30950__auto___32672,out){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_32667 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32667[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_32667[(1)] = (1));

return statearr_32667;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_32649){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_32649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e32668){if((e32668 instanceof Object)){
var ex__30866__auto__ = e32668;
var statearr_32669_32683 = state_32649;
(statearr_32669_32683[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32649);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32668;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32684 = state_32649;
state_32649 = G__32684;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_32649){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_32649);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___32672,out))
})();
var state__30952__auto__ = (function (){var statearr_32670 = f__30951__auto__.call(null);
(statearr_32670[(6)] = c__30950__auto___32672);

return statearr_32670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___32672,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__32686 = arguments.length;
switch (G__32686) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30950__auto___32752 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___32752,out){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___32752,out){
return (function (state_32724){
var state_val_32725 = (state_32724[(1)]);
if((state_val_32725 === (7))){
var inst_32720 = (state_32724[(2)]);
var state_32724__$1 = state_32724;
var statearr_32726_32753 = state_32724__$1;
(statearr_32726_32753[(2)] = inst_32720);

(statearr_32726_32753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32725 === (1))){
var inst_32687 = (new Array(n));
var inst_32688 = inst_32687;
var inst_32689 = (0);
var state_32724__$1 = (function (){var statearr_32727 = state_32724;
(statearr_32727[(7)] = inst_32688);

(statearr_32727[(8)] = inst_32689);

return statearr_32727;
})();
var statearr_32728_32754 = state_32724__$1;
(statearr_32728_32754[(2)] = null);

(statearr_32728_32754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32725 === (4))){
var inst_32692 = (state_32724[(9)]);
var inst_32692__$1 = (state_32724[(2)]);
var inst_32693 = (inst_32692__$1 == null);
var inst_32694 = cljs.core.not.call(null,inst_32693);
var state_32724__$1 = (function (){var statearr_32729 = state_32724;
(statearr_32729[(9)] = inst_32692__$1);

return statearr_32729;
})();
if(inst_32694){
var statearr_32730_32755 = state_32724__$1;
(statearr_32730_32755[(1)] = (5));

} else {
var statearr_32731_32756 = state_32724__$1;
(statearr_32731_32756[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32725 === (15))){
var inst_32714 = (state_32724[(2)]);
var state_32724__$1 = state_32724;
var statearr_32732_32757 = state_32724__$1;
(statearr_32732_32757[(2)] = inst_32714);

(statearr_32732_32757[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32725 === (13))){
var state_32724__$1 = state_32724;
var statearr_32733_32758 = state_32724__$1;
(statearr_32733_32758[(2)] = null);

(statearr_32733_32758[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32725 === (6))){
var inst_32689 = (state_32724[(8)]);
var inst_32710 = (inst_32689 > (0));
var state_32724__$1 = state_32724;
if(cljs.core.truth_(inst_32710)){
var statearr_32734_32759 = state_32724__$1;
(statearr_32734_32759[(1)] = (12));

} else {
var statearr_32735_32760 = state_32724__$1;
(statearr_32735_32760[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32725 === (3))){
var inst_32722 = (state_32724[(2)]);
var state_32724__$1 = state_32724;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32724__$1,inst_32722);
} else {
if((state_val_32725 === (12))){
var inst_32688 = (state_32724[(7)]);
var inst_32712 = cljs.core.vec.call(null,inst_32688);
var state_32724__$1 = state_32724;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32724__$1,(15),out,inst_32712);
} else {
if((state_val_32725 === (2))){
var state_32724__$1 = state_32724;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32724__$1,(4),ch);
} else {
if((state_val_32725 === (11))){
var inst_32704 = (state_32724[(2)]);
var inst_32705 = (new Array(n));
var inst_32688 = inst_32705;
var inst_32689 = (0);
var state_32724__$1 = (function (){var statearr_32736 = state_32724;
(statearr_32736[(10)] = inst_32704);

(statearr_32736[(7)] = inst_32688);

(statearr_32736[(8)] = inst_32689);

return statearr_32736;
})();
var statearr_32737_32761 = state_32724__$1;
(statearr_32737_32761[(2)] = null);

(statearr_32737_32761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32725 === (9))){
var inst_32688 = (state_32724[(7)]);
var inst_32702 = cljs.core.vec.call(null,inst_32688);
var state_32724__$1 = state_32724;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32724__$1,(11),out,inst_32702);
} else {
if((state_val_32725 === (5))){
var inst_32692 = (state_32724[(9)]);
var inst_32688 = (state_32724[(7)]);
var inst_32689 = (state_32724[(8)]);
var inst_32697 = (state_32724[(11)]);
var inst_32696 = (inst_32688[inst_32689] = inst_32692);
var inst_32697__$1 = (inst_32689 + (1));
var inst_32698 = (inst_32697__$1 < n);
var state_32724__$1 = (function (){var statearr_32738 = state_32724;
(statearr_32738[(11)] = inst_32697__$1);

(statearr_32738[(12)] = inst_32696);

return statearr_32738;
})();
if(cljs.core.truth_(inst_32698)){
var statearr_32739_32762 = state_32724__$1;
(statearr_32739_32762[(1)] = (8));

} else {
var statearr_32740_32763 = state_32724__$1;
(statearr_32740_32763[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32725 === (14))){
var inst_32717 = (state_32724[(2)]);
var inst_32718 = cljs.core.async.close_BANG_.call(null,out);
var state_32724__$1 = (function (){var statearr_32742 = state_32724;
(statearr_32742[(13)] = inst_32717);

return statearr_32742;
})();
var statearr_32743_32764 = state_32724__$1;
(statearr_32743_32764[(2)] = inst_32718);

(statearr_32743_32764[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32725 === (10))){
var inst_32708 = (state_32724[(2)]);
var state_32724__$1 = state_32724;
var statearr_32744_32765 = state_32724__$1;
(statearr_32744_32765[(2)] = inst_32708);

(statearr_32744_32765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32725 === (8))){
var inst_32688 = (state_32724[(7)]);
var inst_32697 = (state_32724[(11)]);
var tmp32741 = inst_32688;
var inst_32688__$1 = tmp32741;
var inst_32689 = inst_32697;
var state_32724__$1 = (function (){var statearr_32745 = state_32724;
(statearr_32745[(7)] = inst_32688__$1);

(statearr_32745[(8)] = inst_32689);

return statearr_32745;
})();
var statearr_32746_32766 = state_32724__$1;
(statearr_32746_32766[(2)] = null);

(statearr_32746_32766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___32752,out))
;
return ((function (switch__30862__auto__,c__30950__auto___32752,out){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_32747 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32747[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_32747[(1)] = (1));

return statearr_32747;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_32724){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_32724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e32748){if((e32748 instanceof Object)){
var ex__30866__auto__ = e32748;
var statearr_32749_32767 = state_32724;
(statearr_32749_32767[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32724);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32748;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32768 = state_32724;
state_32724 = G__32768;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_32724){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_32724);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___32752,out))
})();
var state__30952__auto__ = (function (){var statearr_32750 = f__30951__auto__.call(null);
(statearr_32750[(6)] = c__30950__auto___32752);

return statearr_32750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___32752,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__32770 = arguments.length;
switch (G__32770) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30950__auto___32840 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___32840,out){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___32840,out){
return (function (state_32812){
var state_val_32813 = (state_32812[(1)]);
if((state_val_32813 === (7))){
var inst_32808 = (state_32812[(2)]);
var state_32812__$1 = state_32812;
var statearr_32814_32841 = state_32812__$1;
(statearr_32814_32841[(2)] = inst_32808);

(statearr_32814_32841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32813 === (1))){
var inst_32771 = [];
var inst_32772 = inst_32771;
var inst_32773 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32812__$1 = (function (){var statearr_32815 = state_32812;
(statearr_32815[(7)] = inst_32773);

(statearr_32815[(8)] = inst_32772);

return statearr_32815;
})();
var statearr_32816_32842 = state_32812__$1;
(statearr_32816_32842[(2)] = null);

(statearr_32816_32842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32813 === (4))){
var inst_32776 = (state_32812[(9)]);
var inst_32776__$1 = (state_32812[(2)]);
var inst_32777 = (inst_32776__$1 == null);
var inst_32778 = cljs.core.not.call(null,inst_32777);
var state_32812__$1 = (function (){var statearr_32817 = state_32812;
(statearr_32817[(9)] = inst_32776__$1);

return statearr_32817;
})();
if(inst_32778){
var statearr_32818_32843 = state_32812__$1;
(statearr_32818_32843[(1)] = (5));

} else {
var statearr_32819_32844 = state_32812__$1;
(statearr_32819_32844[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32813 === (15))){
var inst_32802 = (state_32812[(2)]);
var state_32812__$1 = state_32812;
var statearr_32820_32845 = state_32812__$1;
(statearr_32820_32845[(2)] = inst_32802);

(statearr_32820_32845[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32813 === (13))){
var state_32812__$1 = state_32812;
var statearr_32821_32846 = state_32812__$1;
(statearr_32821_32846[(2)] = null);

(statearr_32821_32846[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32813 === (6))){
var inst_32772 = (state_32812[(8)]);
var inst_32797 = inst_32772.length;
var inst_32798 = (inst_32797 > (0));
var state_32812__$1 = state_32812;
if(cljs.core.truth_(inst_32798)){
var statearr_32822_32847 = state_32812__$1;
(statearr_32822_32847[(1)] = (12));

} else {
var statearr_32823_32848 = state_32812__$1;
(statearr_32823_32848[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32813 === (3))){
var inst_32810 = (state_32812[(2)]);
var state_32812__$1 = state_32812;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32812__$1,inst_32810);
} else {
if((state_val_32813 === (12))){
var inst_32772 = (state_32812[(8)]);
var inst_32800 = cljs.core.vec.call(null,inst_32772);
var state_32812__$1 = state_32812;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32812__$1,(15),out,inst_32800);
} else {
if((state_val_32813 === (2))){
var state_32812__$1 = state_32812;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32812__$1,(4),ch);
} else {
if((state_val_32813 === (11))){
var inst_32780 = (state_32812[(10)]);
var inst_32776 = (state_32812[(9)]);
var inst_32790 = (state_32812[(2)]);
var inst_32791 = [];
var inst_32792 = inst_32791.push(inst_32776);
var inst_32772 = inst_32791;
var inst_32773 = inst_32780;
var state_32812__$1 = (function (){var statearr_32824 = state_32812;
(statearr_32824[(11)] = inst_32790);

(statearr_32824[(7)] = inst_32773);

(statearr_32824[(8)] = inst_32772);

(statearr_32824[(12)] = inst_32792);

return statearr_32824;
})();
var statearr_32825_32849 = state_32812__$1;
(statearr_32825_32849[(2)] = null);

(statearr_32825_32849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32813 === (9))){
var inst_32772 = (state_32812[(8)]);
var inst_32788 = cljs.core.vec.call(null,inst_32772);
var state_32812__$1 = state_32812;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32812__$1,(11),out,inst_32788);
} else {
if((state_val_32813 === (5))){
var inst_32780 = (state_32812[(10)]);
var inst_32776 = (state_32812[(9)]);
var inst_32773 = (state_32812[(7)]);
var inst_32780__$1 = f.call(null,inst_32776);
var inst_32781 = cljs.core._EQ_.call(null,inst_32780__$1,inst_32773);
var inst_32782 = cljs.core.keyword_identical_QMARK_.call(null,inst_32773,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32783 = (inst_32781) || (inst_32782);
var state_32812__$1 = (function (){var statearr_32826 = state_32812;
(statearr_32826[(10)] = inst_32780__$1);

return statearr_32826;
})();
if(cljs.core.truth_(inst_32783)){
var statearr_32827_32850 = state_32812__$1;
(statearr_32827_32850[(1)] = (8));

} else {
var statearr_32828_32851 = state_32812__$1;
(statearr_32828_32851[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32813 === (14))){
var inst_32805 = (state_32812[(2)]);
var inst_32806 = cljs.core.async.close_BANG_.call(null,out);
var state_32812__$1 = (function (){var statearr_32830 = state_32812;
(statearr_32830[(13)] = inst_32805);

return statearr_32830;
})();
var statearr_32831_32852 = state_32812__$1;
(statearr_32831_32852[(2)] = inst_32806);

(statearr_32831_32852[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32813 === (10))){
var inst_32795 = (state_32812[(2)]);
var state_32812__$1 = state_32812;
var statearr_32832_32853 = state_32812__$1;
(statearr_32832_32853[(2)] = inst_32795);

(statearr_32832_32853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32813 === (8))){
var inst_32780 = (state_32812[(10)]);
var inst_32776 = (state_32812[(9)]);
var inst_32772 = (state_32812[(8)]);
var inst_32785 = inst_32772.push(inst_32776);
var tmp32829 = inst_32772;
var inst_32772__$1 = tmp32829;
var inst_32773 = inst_32780;
var state_32812__$1 = (function (){var statearr_32833 = state_32812;
(statearr_32833[(14)] = inst_32785);

(statearr_32833[(7)] = inst_32773);

(statearr_32833[(8)] = inst_32772__$1);

return statearr_32833;
})();
var statearr_32834_32854 = state_32812__$1;
(statearr_32834_32854[(2)] = null);

(statearr_32834_32854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___32840,out))
;
return ((function (switch__30862__auto__,c__30950__auto___32840,out){
return (function() {
var cljs$core$async$state_machine__30863__auto__ = null;
var cljs$core$async$state_machine__30863__auto____0 = (function (){
var statearr_32835 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32835[(0)] = cljs$core$async$state_machine__30863__auto__);

(statearr_32835[(1)] = (1));

return statearr_32835;
});
var cljs$core$async$state_machine__30863__auto____1 = (function (state_32812){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_32812);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e32836){if((e32836 instanceof Object)){
var ex__30866__auto__ = e32836;
var statearr_32837_32855 = state_32812;
(statearr_32837_32855[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32812);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32836;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32856 = state_32812;
state_32812 = G__32856;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
cljs$core$async$state_machine__30863__auto__ = function(state_32812){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30863__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30863__auto____1.call(this,state_32812);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30863__auto____0;
cljs$core$async$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30863__auto____1;
return cljs$core$async$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___32840,out))
})();
var state__30952__auto__ = (function (){var statearr_32838 = f__30951__auto__.call(null);
(statearr_32838[(6)] = c__30950__auto___32840);

return statearr_32838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___32840,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1516617670389
